/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkDanielssonDistanceMapImageFilter_h
#define sitkDanielssonDistanceMapImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class DanielssonDistanceMapImageFilter
\brief This filter computes the distance map of the input image as an approximation with pixel accuracy to the Euclidean distance.

TInputImage

Input Image Type 



TOutputImage

Output Image Type 



TVoronoiImage

Voronoi Image Type. Note the default value is TInputImage.



The input is assumed to contain numeric codes defining objects. The filter will produce as output the following images:


\li A Voronoi partition using the same numeric codes as the input. 

\li A distance map with the approximation to the euclidean distance. from a particular pixel to the nearest object to this pixel in the input image. 

\li A vector map containing the component of the vector relating the current pixel with the closest point of the closest object to this pixel. Given that the components of the distance are computed in "pixels", the vector is represented by an itk::Offset . That is, physical coordinates are not used.


This filter is N-dimensional and known to be efficient in computational time. The algorithm is the N-dimensional version of the 4SED algorithm given for two dimensions in:

Danielsson, Per-Erik. Euclidean Distance Mapping. Computer Graphics and Image Processing 14, 227-248 (1980).
\sa itk::simple::DanielssonDistanceMap for the procedural interface
\sa itk::DanielssonDistanceMapImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT DanielssonDistanceMapImageFilter : public ImageFilter<1> {
    public:
      typedef DanielssonDistanceMapImageFilter Self;

      /** Destructor */
      virtual ~DanielssonDistanceMapImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      DanielssonDistanceMapImageFilter();

      /** Define the pixels types supported by this filter */
      typedef IntegerPixelIDTypeList  PixelIDTypeList;



      /**
       * Set if the input is binary. If this variable is set, each nonzero pixel in the input image will be given a unique numeric code to be used by the Voronoi partition. If the image is binary but you are not interested in the Voronoi regions of the different nonzero pixels, then you need not set this.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetInputIsBinary ( bool InputIsBinary ) { this->m_InputIsBinary = InputIsBinary; return *this; }

      /** Set the value of InputIsBinary to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER InputIsBinaryOn() { return this->SetInputIsBinary(true); }
      SITK_RETURN_SELF_TYPE_HEADER InputIsBinaryOff() { return this->SetInputIsBinary(false); }

      /**
       * Get if the input is binary. See SetInputIsBinary() .
       */
        bool GetInputIsBinary() const { return this->m_InputIsBinary; }

      /**
       * Set if the distance should be squared.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSquaredDistance ( bool SquaredDistance ) { this->m_SquaredDistance = SquaredDistance; return *this; }

      /** Set the value of SquaredDistance to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER SquaredDistanceOn() { return this->SetSquaredDistance(true); }
      SITK_RETURN_SELF_TYPE_HEADER SquaredDistanceOff() { return this->SetSquaredDistance(false); }

      /**
       * Get the distance squared.
       */
        bool GetSquaredDistance() const { return this->m_SquaredDistance; }

      /**
       * Set if image spacing should be used in computing distances.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseImageSpacing ( bool UseImageSpacing ) { this->m_UseImageSpacing = UseImageSpacing; return *this; }

      /** Set the value of UseImageSpacing to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOn() { return this->SetUseImageSpacing(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOff() { return this->SetUseImageSpacing(false); }

      /**
       * Get whether spacing is used.
       */
        bool GetUseImageSpacing() const { return this->m_UseImageSpacing; }
      /** Name of this class */
      std::string GetName() const { return std::string ("DanielssonDistanceMapImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, bool inputIsBinary, bool squaredDistance, bool useImageSpacing );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      bool  m_InputIsBinary;
      bool  m_SquaredDistance;
      bool  m_UseImageSpacing;
    };


    /**
     * \brief This filter computes the distance map of the input image as an approximation with pixel accuracy to the Euclidean distance.
     *
     * This function directly calls the execute method of DanielssonDistanceMapImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::DanielssonDistanceMapImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image DanielssonDistanceMap ( const Image& image1, bool inputIsBinary = false, bool squaredDistance = false, bool useImageSpacing = false );

  }
}
#endif
