/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkCurvatureFlowImageFilter_h
#define sitkCurvatureFlowImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class CurvatureFlowImageFilter
\brief Denoise an image using curvature driven flow.

CurvatureFlowImageFilter implements a curvature driven image denoising algorithm. Iso-brightness contours in the grayscale input image are viewed as a level set. The level set is then evolved using a curvature-based speed function:

 \f[ I_t = \kappa |\nabla I| \f] where \f$ \kappa \f$ is the curvature.

The advantage of this approach is that sharp boundaries are preserved with smoothing occurring only within a region. However, it should be noted that continuous application of this scheme will result in the eventual removal of all information as each contour shrinks to zero and disappear.

Note that unlike level set segmentation algorithms, the image to be denoised is already the level set and can be set directly as the input using the SetInput() method.

This filter has two parameters: the number of update iterations to be performed and the timestep between each update.

The timestep should be "small enough" to ensure numerical stability. Stability is guarantee when the timestep meets the CFL (Courant-Friedrichs-Levy) condition. Broadly speaking, this condition ensures that each contour does not move more than one grid position at each timestep. In the literature, the timestep is typically user specified and have to manually tuned to the application.

This filter make use of the multi-threaded finite difference solver hierarchy. Updates are computed using a CurvatureFlowFunction object. A zero flux Neumann boundary condition when computing derivatives near the data boundary.

This filter may be streamed. To support streaming this filter produces a padded output which takes into account edge effects. The size of the padding is m_NumberOfIterations on each edge. Users of this filter should only make use of the center valid central region.

\warning This filter assumes that the input and output types have the same dimensions. This filter also requires that the output image pixels are of a floating point type. This filter works for any dimensional images.

Reference: "Level Set Methods and Fast Marching Methods", J.A. Sethian, Cambridge Press, Chapter 16, Second edition, 1999.

\see DenseFiniteDifferenceImageFilter 

\see CurvatureFlowFunction 

\see MinMaxCurvatureFlowImageFilter 

\see BinaryMinMaxCurvatureFlowImageFilter
\sa itk::simple::CurvatureFlow for the procedural interface
\sa itk::CurvatureFlowImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT CurvatureFlowImageFilter : public ImageFilter<1> {
    public:
      typedef CurvatureFlowImageFilter Self;

      /** Destructor */
      virtual ~CurvatureFlowImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      CurvatureFlowImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Set the timestep parameter.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetTimeStep ( double TimeStep ) { this->m_TimeStep = TimeStep; return *this; }

      /**
       * Get the timestep parameter.
       */
        double GetTimeStep() const { return this->m_TimeStep; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNumberOfIterations ( uint32_t NumberOfIterations ) { this->m_NumberOfIterations = NumberOfIterations; return *this; }

      /**
       */
        uint32_t GetNumberOfIterations() const { return this->m_NumberOfIterations; }
      /** Name of this class */
      std::string GetName() const { return std::string ("CurvatureFlowImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double timeStep, uint32_t numberOfIterations );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /* Time step for curvature flow */
      double  m_TimeStep;
      /* Number of iterations to run */
      uint32_t  m_NumberOfIterations;
    };


    /**
     * \brief Denoise an image using curvature driven flow.
     *
     * This function directly calls the execute method of CurvatureFlowImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::CurvatureFlowImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image CurvatureFlow ( const Image& image1, double timeStep = 0.05, uint32_t numberOfIterations = 5u );

  }
}
#endif
