/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkConvolutionImageFilter_h
#define sitkConvolutionImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class ConvolutionImageFilter
\brief Convolve a given image with an arbitrary image kernel.

This filter operates by centering the flipped kernel at each pixel in the image and computing the inner product between pixel values in the image and pixel values in the kernel. The center of the kernel is defined as \f$ \lfloor (2*i+s-1)/2 \rfloor \f$ where \f$i\f$ is the index and \f$s\f$ is the size of the largest possible region of the kernel image. For kernels with odd sizes in all dimensions, this corresponds to the center pixel. If a dimension of the kernel image has an even size, then the center index of the kernel in that dimension will be the largest integral index that is less than the continuous index of the image center.

The kernel can optionally be normalized to sum to 1 using NormalizeOn() . Normalization is off by default.

\warning This filter ignores the spacing, origin, and orientation of the kernel image and treats them as identical to those in the input image.

This code was contributed in the Insight Journal paper:

"Image Kernel Convolution" by Tustison N., Gee J. https://hdl.handle.net/1926/1323 http://www.insight-journal.org/browse/publication/208 

\author Nicholas J. Tustison 

\author James C. Gee
\sa itk::simple::Convolution for the procedural interface
\sa itk::ConvolutionImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ConvolutionImageFilter : public ImageFilter<0> {
    public:
      typedef ConvolutionImageFilter Self;

      /** Destructor */
      virtual ~ConvolutionImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ConvolutionImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       * Normalize the output image by the sum of the kernel components

       */
      SITK_RETURN_SELF_TYPE_HEADER SetNormalize ( bool Normalize ) { this->m_Normalize = Normalize; return *this; }

      /** Set the value of Normalize to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER NormalizeOn() { return this->SetNormalize(true); }
      SITK_RETURN_SELF_TYPE_HEADER NormalizeOff() { return this->SetNormalize(false); }

      /**
       */
        bool GetNormalize() const { return this->m_Normalize; }

      typedef enum {ZERO_PAD,ZERO_FLUX_NEUMANN_PAD,PERIODIC_PAD} BoundaryConditionType;

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBoundaryCondition ( BoundaryConditionType BoundaryCondition ) { this->m_BoundaryCondition = BoundaryCondition; return *this; }

      /**
       */
        BoundaryConditionType GetBoundaryCondition() const { return this->m_BoundaryCondition; }

      typedef enum {SAME,VALID} OutputRegionModeType;

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputRegionMode ( OutputRegionModeType OutputRegionMode ) { this->m_OutputRegionMode = OutputRegionMode; return *this; }

      /**
       */
        OutputRegionModeType GetOutputRegionMode() const { return this->m_OutputRegionMode; }
      /** Name of this class */
      std::string GetName() const { return std::string ("ConvolutionImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image & image, const Image & kernelImage );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image & image, const Image & kernelImage, bool normalize, ConvolutionImageFilter::BoundaryConditionType boundaryCondition, ConvolutionImageFilter::OutputRegionModeType outputRegionMode );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image * image, const Image * kernelImage );
      template <class TImageType> Image ExecuteInternal ( const Image * image, const Image * kernelImage );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      bool  m_Normalize;
      BoundaryConditionType  m_BoundaryCondition;
      OutputRegionModeType  m_OutputRegionMode;
    };


    /**
     * \brief Convolve a given image with an arbitrary image kernel.
     *
     * This function directly calls the execute method of ConvolutionImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ConvolutionImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Convolution ( const Image & image, const Image & kernelImage, bool normalize = false, ConvolutionImageFilter::BoundaryConditionType boundaryCondition = itk::simple::ConvolutionImageFilter::ZERO_FLUX_NEUMANN_PAD, ConvolutionImageFilter::OutputRegionModeType outputRegionMode = itk::simple::ConvolutionImageFilter::SAME );

  }
}
#endif
