/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkConnectedComponentImageFilter_h
#define sitkConnectedComponentImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class ConnectedComponentImageFilter
\brief Label the objects in a binary image.

ConnectedComponentImageFilter labels the objects in a binary image (non-zero pixels are considered to be objects, zero-valued pixels are considered to be background). Each distinct object is assigned a unique label. The filter experiments with some improvements to the existing implementation, and is based on run length encoding along raster lines. The final object labels start with 1 and are consecutive. Objects that are reached earlier by a raster order scan have a lower label. This is different to the behaviour of the original connected component image filter which did not produce consecutive labels or impose any particular ordering.

After the filter is executed, ObjectCount holds the number of connected components.

\see ImageToImageFilter
\sa itk::simple::ConnectedComponent for the procedural interface
\sa itk::ConnectedComponentImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ConnectedComponentImageFilter : public ImageFilter<0> {
    public:
      typedef ConnectedComponentImageFilter Self;

      /** Destructor */
      virtual ~ConnectedComponentImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ConnectedComponentImageFilter();

      /** Define the pixels types supported by this filter */
      typedef IntegerPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/Get whether the connected components are defined strictly by face connectivity or by face+edge+vertex connectivity. Default is FullyConnectedOff. For objects that are 1 pixel wide, use FullyConnectedOn.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFullyConnected ( bool FullyConnected ) { this->m_FullyConnected = FullyConnected; return *this; }

      /** Set the value of FullyConnected to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOn() { return this->SetFullyConnected(true); }
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOff() { return this->SetFullyConnected(false); }

      /**
       * Set/Get whether the connected components are defined strictly by face connectivity or by face+edge+vertex connectivity. Default is FullyConnectedOff. For objects that are 1 pixel wide, use FullyConnectedOn.
       */
        bool GetFullyConnected() const { return this->m_FullyConnected; }
     /**
      *
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     uint32_t GetObjectCount() const { return this->m_ObjectCount; };

      /** Name of this class */
      std::string GetName() const { return std::string ("ConnectedComponentImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image & image, const Image & maskImage );
      Image Execute ( const Image & image );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image & image, const Image & maskImage, bool fullyConnected );
      Image Execute ( const Image & image, bool fullyConnected );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image * image, const Image * maskImage );
      template <class TImageType> Image ExecuteInternal ( const Image * image, const Image * maskImage );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      bool  m_FullyConnected;
      /*  */
      uint32_t m_ObjectCount;

    };


    /**
     * \brief Label the objects in a binary image.
     *
     * This function directly calls the execute method of ConnectedComponentImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ConnectedComponentImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image ConnectedComponent ( const Image & image, const Image & maskImage, bool fullyConnected = false );
     SITKBasicFilters_EXPORT Image ConnectedComponent ( const Image & image, bool fullyConnected = false );
  }
}
#endif
