/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkCoherenceEnhancingDiffusionImageFilter_h
#define sitkCoherenceEnhancingDiffusionImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class CoherenceEnhancingDiffusionImageFilter
\brief Coherence enhanging diffusion and edge enhancing diffusion.

Implementation of Coherence Enhancing Diffusion (CED), and Edge Enhancing Diffusion (EED), as described by Weickert.

CED heuristically smoothes everywhere except accross image contours, while EED smoothes nowhere but tangentially to image contours.

The non-linear diffusion tensor is defined in terms of the structure tensor.

Denote by \f$\mu_i\f$ the structure tensor eigenvalues, at a given point \f$x\f$ , with \f$0\leq i < d\f$ . Let also \f$\mu_{\rm min}\f$ and \f$\mu_{\rm max}\f$ , be the smallest and largest eigenvalues respectively. The diffusion tensor is defined by the same eigenvectors, but with modified with eigenvalues \f$\lambda_i\f$ .

Coherence Enhancing Diffusion:

\f$\lambda_i := g(\mu_i - \mu_{\rm min})\f$ , where \f$g(s) = 1 - (1-\alpha)*exp(-(\lambda/s)^m)\f$ 

Note the limit values \f$g(0) = 1\f$ , \f$g(\infty) = \alpha\f$ .

Edge enhancing diffusion:

\f$\lambda_i := g(\mu_{\rm max} - \mu_i)\f$ , where \f$g(s) = \alpha + (1-\alpha)*exp(-(\lambda/s)^m)\f$ 

Note the limit values \f$g(0) = \alpha\f$ , \f$g(\infty) = 1\f$ .
\sa itk::simple::CoherenceEnhancingDiffusion for the procedural interface
\sa itk::CoherenceEnhancingDiffusionImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT CoherenceEnhancingDiffusionImageFilter : public ImageFilter<1> {
    public:
      typedef CoherenceEnhancingDiffusionImageFilter Self;

      /** Destructor */
      virtual ~CoherenceEnhancingDiffusionImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      CoherenceEnhancingDiffusionImageFilter();

      /** Define the pixels types supported by this filter */
      typedef RealPixelIDTypeList  PixelIDTypeList;



      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetDiffusionTime ( double DiffusionTime ) { this->m_DiffusionTime = DiffusionTime; return *this; }

      /**
       */
        double GetDiffusionTime() const { return this->m_DiffusionTime; }

      /**
       * Exponent m involved in the function g defining eigenvalues.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetLambda ( double Lambda ) { this->m_Lambda = Lambda; return *this; }

      /**
       */
        double GetLambda() const { return this->m_Lambda; }

      typedef enum {CED,cCED,EED,cEED,Isotropic} EnhancementType;

      /**
       * \brief Switch between CED, EED, and variants.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetEnhancement ( EnhancementType Enhancement ) { this->m_Enhancement = Enhancement; return *this; }

      /**
       */
        EnhancementType GetEnhancement() const { return this->m_Enhancement; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNoiseScale ( double NoiseScale ) { this->m_NoiseScale = NoiseScale; return *this; }

      /**
       */
        double GetNoiseScale() const { return this->m_NoiseScale; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFeatureScale ( double FeatureScale ) { this->m_FeatureScale = FeatureScale; return *this; }

      /**
       */
        double GetFeatureScale() const { return this->m_FeatureScale; }

      /**
       * Exponent m involved in the function g defining eigenvalues.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetExponent ( double Exponent ) { this->m_Exponent = Exponent; return *this; }

      /**
       */
        double GetExponent() const { return this->m_Exponent; }

      /**
       * Exponent m involved in the function g defining eigenvalues.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetAlpha ( double Alpha ) { this->m_Alpha = Alpha; return *this; }

      /**
       */
        double GetAlpha() const { return this->m_Alpha; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetRatioToMaxStableTimeStep ( double RatioToMaxStableTimeStep ) { this->m_RatioToMaxStableTimeStep = RatioToMaxStableTimeStep; return *this; }

      /**
       */
        double GetRatioToMaxStableTimeStep() const { return this->m_RatioToMaxStableTimeStep; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMaxTimeStepsBetweenTensorUpdates ( uint8_t MaxTimeStepsBetweenTensorUpdates ) { this->m_MaxTimeStepsBetweenTensorUpdates = MaxTimeStepsBetweenTensorUpdates; return *this; }

      /**
       */
        uint8_t GetMaxTimeStepsBetweenTensorUpdates() const { return this->m_MaxTimeStepsBetweenTensorUpdates; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetAdimensionize ( bool Adimensionize ) { this->m_Adimensionize = Adimensionize; return *this; }

      /** Set the value of Adimensionize to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER AdimensionizeOn() { return this->SetAdimensionize(true); }
      SITK_RETURN_SELF_TYPE_HEADER AdimensionizeOff() { return this->SetAdimensionize(false); }

      /**
       */
        bool GetAdimensionize() const { return this->m_Adimensionize; }
      /** Name of this class */
      std::string GetName() const { return std::string ("CoherenceEnhancingDiffusionImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double diffusionTime, double lambda, CoherenceEnhancingDiffusionImageFilter::EnhancementType enhancement, double noiseScale, double featureScale, double exponent, double alpha, double ratioToMaxStableTimeStep, uint8_t maxTimeStepsBetweenTensorUpdates, bool adimensionize );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_DiffusionTime;
      double  m_Lambda;
      EnhancementType  m_Enhancement;
      double  m_NoiseScale;
      double  m_FeatureScale;
      double  m_Exponent;
      double  m_Alpha;
      double  m_RatioToMaxStableTimeStep;
      uint8_t  m_MaxTimeStepsBetweenTensorUpdates;
      bool  m_Adimensionize;
    };


    /**
     * \brief Coherence enhanging diffusion and edge enhancing diffusion.
     *
     * This function directly calls the execute method of CoherenceEnhancingDiffusionImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::CoherenceEnhancingDiffusionImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image CoherenceEnhancingDiffusion ( const Image& image1, double diffusionTime = 1, double lambda = 0.05, CoherenceEnhancingDiffusionImageFilter::EnhancementType enhancement = itk::simple::CoherenceEnhancingDiffusionImageFilter::CED, double noiseScale = 0.5, double featureScale = 2, double exponent = 2, double alpha = 0.01, double ratioToMaxStableTimeStep = 0.7, uint8_t maxTimeStepsBetweenTensorUpdates = 5, bool adimensionize = true );

  }
}
#endif
