/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkClosingByReconstructionImageFilter_h
#define sitkClosingByReconstructionImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkKernelImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkImageFilter.h"
#include "sitkBasicFilters.h"
#include "sitkKernel.h"

namespace itk {
  namespace simple {

    /**\class ClosingByReconstructionImageFilter
\brief Closing by reconstruction of an image.

This filter is similar to the morphological closing, but contrary to the mophological closing, the closing by reconstruction preserves the shape of the components. The closing by reconstruction of an image "f" is defined as:

ClosingByReconstruction(f) = ErosionByReconstruction(f, Dilation(f)).

Closing by reconstruction not only preserves structures preserved by the dilation, but also levels raises the contrast of the darkest regions. If PreserveIntensities is on, a subsequent reconstruction by dilation using a marker image that is the original image for all unaffected pixels.

Closing by reconstruction is described in Chapter 6.3.9 of Pierre Soille's book "Morphological Image Analysis: Principles and
Applications", Second Edition, Springer, 2003.

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.

\see GrayscaleMorphologicalClosingImageFilter
\sa itk::simple::ClosingByReconstruction for the procedural interface
\sa itk::ClosingByReconstructionImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ClosingByReconstructionImageFilter : public ImageFilter<1> {
    public:
      typedef ClosingByReconstructionImageFilter Self;

      /** Destructor */
      virtual ~ClosingByReconstructionImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ClosingByReconstructionImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;

    /** Kernel type enumeration */
    typedef enum{Annulus=sitkAnnulus, Ball=sitkBall, Box=sitkBox, Cross=sitkCross} KernelType;



      /**
       * Set/Get whether the connected components are defined strictly by face connectivity or by face+edge+vertex connectivity. Default is FullyConnectedOff. For objects that are 1 pixel wide, use FullyConnectedOn.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFullyConnected ( bool FullyConnected ) { this->m_FullyConnected = FullyConnected; return *this; }

      /** Set the value of FullyConnected to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOn() { return this->SetFullyConnected(true); }
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOff() { return this->SetFullyConnected(false); }

      /**
       * Set/Get whether the connected components are defined strictly by face connectivity or by face+edge+vertex connectivity. Default is FullyConnectedOff. For objects that are 1 pixel wide, use FullyConnectedOn.
       */
        bool GetFullyConnected() const { return this->m_FullyConnected; }

      /**
       * Set/Get whether the original intensities of the image retained for those pixels unaffected by the opening by reconstrcution. If Off, the output pixel contrast will be reduced.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetPreserveIntensities ( bool PreserveIntensities ) { this->m_PreserveIntensities = PreserveIntensities; return *this; }

      /** Set the value of PreserveIntensities to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER PreserveIntensitiesOn() { return this->SetPreserveIntensities(true); }
      SITK_RETURN_SELF_TYPE_HEADER PreserveIntensitiesOff() { return this->SetPreserveIntensities(false); }

      /**
       * Set/Get whether the original intensities of the image retained for those pixels unaffected by the opening by reconstrcution. If Off, the output pixel contrast will be reduced.
       */
        bool GetPreserveIntensities() const { return this->m_PreserveIntensities; }
      /** Kernel radius as a scale for isotropic structures */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius(uint32_t r);

      /** Set/Get the radius of the kernel structuring element as a
       * vector.
       *
       * If the dimension of the image is greater then the length of
       * r, then the radius will be padded. If it is less the r will
       * be truncated.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius(const std::vector<uint32_t>  &r );
      std::vector<uint32_t> GetKernelRadius() const;

      /** Set/Get the kernel or structuring elemenent used for the
       * morphology */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType(KernelEnum t);
#ifndef SWIG
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType(KernelType t);
#endif
      KernelEnum GetKernelType() const;

      /** Name of this class */
      std::string GetName() const { return std::string ("ClosingByReconstructionImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, bool fullyConnected, bool preserveIntensities );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      bool  m_FullyConnected;
      /*  */
      bool  m_PreserveIntensities;

      /* Kernel Radius as a vector */
      std::vector<uint32_t> m_KernelRadius;

      /** KernelType */
      KernelEnum m_KernelType;
    };


    /**
     * itk::simple::ClosingByReconstructionImageFilter Functional Interface
     *
     * This function directly calls the execute method of ClosingByReconstructionImageFilter
     * in order to support a fully functional API
     */
  Image SITKBasicFilters_EXPORT ClosingByReconstruction ( const Image&,
                                          uint32_t radius = 1, KernelEnum kernel = sitkBall
                                          , bool fullyConnected = false, bool preserveIntensities = false );


   /**
     * itk::simple::ClosingByReconstructionImageFilter Functional Interface
     *
     * This function directly calls the execute method of ClosingByReconstructionImageFilter
     * in order to support a fully functional API
     */
  Image SITKBasicFilters_EXPORT ClosingByReconstruction ( const Image&,
                                          const std::vector<uint32_t> vectorRadius, KernelEnum kernel = sitkBall
                                          , bool fullyConnected = false, bool preserveIntensities = false );
  }
}
#endif
