/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkChangeLabelLabelMapFilter_h
#define sitkChangeLabelLabelMapFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class ChangeLabelLabelMapFilter
\brief Replace the label Ids of selected LabelObjects with new label Ids.

This filter takes as input a label map and a list of pairs of Label Ids, to produce as output a new label map where the label Ids have been replaced according to the pairs in the list.

Labels that are relabeled to the same label Id are automatically merged and optimized into a single LabelObject . The background label can also be changed. Any object relabeled to the output background will automatically be removed.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176 

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.

\see ShapeLabelObject , RelabelComponentImageFilter , ChangeLabelImageFilter
\sa itk::simple::ChangeLabelLabelMapFilter for the procedural interface
\sa itk::ChangeLabelLabelMapFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT ChangeLabelLabelMapFilter : public ImageFilter<1> {
    public:
      typedef ChangeLabelLabelMapFilter Self;

      /** Destructor */
      virtual ~ChangeLabelLabelMapFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ChangeLabelLabelMapFilter();

      /** Define the pixels types supported by this filter */
      typedef LabelPixelIDTypeList  PixelIDTypeList;



      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetChangeMap ( std::map<double,double> ChangeMap ) { this->m_ChangeMap = ChangeMap; return *this; }

      /**
       */
        std::map<double,double> GetChangeMap() const { return this->m_ChangeMap; }
      /** Name of this class */
      std::string GetName() const { return std::string ("ChangeLabelLabelMapFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, std::map<double,double> changeMap );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::map<double,double>  m_ChangeMap;
    };


    /**
     * \brief Replace the label Ids of selected LabelObjects with new label Ids.
     *
     * This function directly calls the execute method of ChangeLabelLabelMapFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ChangeLabelLabelMapFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image ChangeLabelLabelMap ( const Image& image1, std::map<double,double> changeMap = std::map<double,double>() );

  }
}
#endif
