/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkBlackTopHatImageFilter_h
#define sitkBlackTopHatImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkKernelImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkImageFilter.h"
#include "sitkBasicFilters.h"
#include "sitkKernel.h"

namespace itk {
  namespace simple {

    /**\class BlackTopHatImageFilter
\brief Black top hat extracts local minima that are smaller than the structuring element.

Black top hat extracts local minima that are smaller than the structuring element. It subtracts the background from the input image. The output of the filter transforms the black valleys into white peaks.

Top-hats are described in Chapter 4.5 of Pierre Soille's book "Morphological Image Analysis: Principles and Applications", Second Edition, Springer, 2003.

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.
\sa itk::simple::BlackTopHat for the procedural interface
\sa itk::BlackTopHatImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT BlackTopHatImageFilter : public ImageFilter<1> {
    public:
      typedef BlackTopHatImageFilter Self;

      /** Destructor */
      virtual ~BlackTopHatImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      BlackTopHatImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;

    /** Kernel type enumeration */
    typedef enum{Annulus=sitkAnnulus, Ball=sitkBall, Box=sitkBox, Cross=sitkCross} KernelType;



      /**
       * A safe border is added to input image to avoid borders effects and remove it once the closing is done
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSafeBorder ( bool SafeBorder ) { this->m_SafeBorder = SafeBorder; return *this; }

      /** Set the value of SafeBorder to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER SafeBorderOn() { return this->SetSafeBorder(true); }
      SITK_RETURN_SELF_TYPE_HEADER SafeBorderOff() { return this->SetSafeBorder(false); }

      /**
       * A safe border is added to input image to avoid borders effects and remove it once the closing is done
       */
        bool GetSafeBorder() const { return this->m_SafeBorder; }
      /** Kernel radius as a scale for isotropic structures */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius(uint32_t r);

      /** Set/Get the radius of the kernel structuring element as a
       * vector.
       *
       * If the dimension of the image is greater then the length of
       * r, then the radius will be padded. If it is less the r will
       * be truncated.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius(const std::vector<uint32_t>  &r );
      std::vector<uint32_t> GetKernelRadius() const;

      /** Set/Get the kernel or structuring elemenent used for the
       * morphology */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType(KernelEnum t);
#ifndef SWIG
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType(KernelType t);
#endif
      KernelEnum GetKernelType() const;

      /** Name of this class */
      std::string GetName() const { return std::string ("BlackTopHatImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, bool safeBorder );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      bool  m_SafeBorder;

      /* Kernel Radius as a vector */
      std::vector<uint32_t> m_KernelRadius;

      /** KernelType */
      KernelEnum m_KernelType;
    };


    /**
     * itk::simple::BlackTopHatImageFilter Functional Interface
     *
     * This function directly calls the execute method of BlackTopHatImageFilter
     * in order to support a fully functional API
     */
  Image SITKBasicFilters_EXPORT BlackTopHat ( const Image&,
                                          uint32_t radius = 1, KernelEnum kernel = sitkBall
                                          , bool safeBorder = true );


   /**
     * itk::simple::BlackTopHatImageFilter Functional Interface
     *
     * This function directly calls the execute method of BlackTopHatImageFilter
     * in order to support a fully functional API
     */
  Image SITKBasicFilters_EXPORT BlackTopHat ( const Image&,
                                          const std::vector<uint32_t> vectorRadius, KernelEnum kernel = sitkBall
                                          , bool safeBorder = true );
  }
}
#endif
