/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkBitwiseNotImageFilter_h
#define sitkBitwiseNotImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class BitwiseNotImageFilter
\brief Implements pixel-wise generic operation on one image.

This class is parameterized over the type of the input image and the type of the output image. It is also parameterized by the operation to be applied, using a Functor style.

UnaryFunctorImageFilter allows the output dimension of the filter to be larger than the input dimension. Thus subclasses of the UnaryFunctorImageFilter (like the CastImageFilter ) can be used to promote a 2D image to a 3D image, etc.

\see BinaryFunctorImageFilter TernaryFunctorImageFilter
\sa itk::simple::BitwiseNot for the procedural interface
\sa itk::UnaryFunctorImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT BitwiseNotImageFilter : public ImageFilter<1> {
    public:
      typedef BitwiseNotImageFilter Self;

      /** Destructor */
      virtual ~BitwiseNotImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      BitwiseNotImageFilter();

      /** Define the pixels types supported by this filter */
      typedef IntegerPixelIDTypeList  PixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("BitwiseNotImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


    };


    /**
     * \brief Implements pixel-wise generic operation on one image.
     *
     * This function directly calls the execute method of BitwiseNotImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::BitwiseNotImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image BitwiseNot ( const Image& image1 );

  }
}
#endif
