/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkBinaryMorphologicalOpeningImageFilter_h
#define sitkBinaryMorphologicalOpeningImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkKernelImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkImageFilter.h"
#include "sitkBasicFilters.h"
#include "sitkKernel.h"

namespace itk {
  namespace simple {

    /**\class BinaryMorphologicalOpeningImageFilter
\brief binary morphological opening of an image.

This filter removes small (i.e., smaller than the structuring element) structures in the interior or at the boundaries of the image. The morphological opening of an image "f" is defined as: Opening(f) = Dilatation(Erosion(f)).

The structuring element is assumed to be composed of binary values (zero or one). Only elements of the structuring element having values > 0 are candidates for affecting the center pixel.

This code was contributed in the Insight Journal paper: "Binary morphological closing and opening image filters" by Lehmann G. https://hdl.handle.net/1926/141 http://www.insight-journal.org/browse/publication/58 

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.

\see MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleErodeImageFilter
\sa itk::simple::BinaryMorphologicalOpening for the procedural interface
\sa itk::BinaryMorphologicalOpeningImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT BinaryMorphologicalOpeningImageFilter : public ImageFilter<1> {
    public:
      typedef BinaryMorphologicalOpeningImageFilter Self;

      /** Destructor */
      virtual ~BinaryMorphologicalOpeningImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      BinaryMorphologicalOpeningImageFilter();

      /** Define the pixels types supported by this filter */
      typedef IntegerPixelIDTypeList  PixelIDTypeList;

    /** Kernel type enumeration */
    typedef enum{Annulus=sitkAnnulus, Ball=sitkBall, Box=sitkBox, Cross=sitkCross} KernelType;



      /**
       * Set the value in eroded part of the image. Defaults to zero
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBackgroundValue ( double BackgroundValue ) { this->m_BackgroundValue = BackgroundValue; return *this; }

      /**
       * Set the value in eroded part of the image. Defaults to zero
       */
        double GetBackgroundValue() const { return this->m_BackgroundValue; }

      /**
       * Set the value in the image to consider as "foreground". Defaults to maximum value of PixelType.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetForegroundValue ( double ForegroundValue ) { this->m_ForegroundValue = ForegroundValue; return *this; }

      /**
       * Get the value in the image considered as "foreground". Defaults to maximum value of PixelType.
       */
        double GetForegroundValue() const { return this->m_ForegroundValue; }
      /** Kernel radius as a scale for isotropic structures */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius(uint32_t r);

      /** Set/Get the radius of the kernel structuring element as a
       * vector.
       *
       * If the dimension of the image is greater then the length of
       * r, then the radius will be padded. If it is less the r will
       * be truncated.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius(const std::vector<uint32_t>  &r );
      std::vector<uint32_t> GetKernelRadius() const;

      /** Set/Get the kernel or structuring elemenent used for the
       * morphology */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType(KernelEnum t);
#ifndef SWIG
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType(KernelType t);
#endif
      KernelEnum GetKernelType() const;

      /** Name of this class */
      std::string GetName() const { return std::string ("BinaryMorphologicalOpeningImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double backgroundValue, double foregroundValue );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      double  m_BackgroundValue;
      double  m_ForegroundValue;

      /* Kernel Radius as a vector */
      std::vector<uint32_t> m_KernelRadius;

      /** KernelType */
      KernelEnum m_KernelType;
    };


    /**
     * itk::simple::BinaryMorphologicalOpeningImageFilter Functional Interface
     *
     * This function directly calls the execute method of BinaryMorphologicalOpeningImageFilter
     * in order to support a fully functional API
     */
  Image SITKBasicFilters_EXPORT BinaryMorphologicalOpening ( const Image&,
                                          uint32_t radius = 1, KernelEnum kernel = sitkBall
                                          , double backgroundValue = 0.0, double foregroundValue = 1.0 );


   /**
     * itk::simple::BinaryMorphologicalOpeningImageFilter Functional Interface
     *
     * This function directly calls the execute method of BinaryMorphologicalOpeningImageFilter
     * in order to support a fully functional API
     */
  Image SITKBasicFilters_EXPORT BinaryMorphologicalOpening ( const Image&,
                                          const std::vector<uint32_t> vectorRadius, KernelEnum kernel = sitkBall
                                          , double backgroundValue = 0.0, double foregroundValue = 1.0 );
  }
}
#endif
