/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkBinaryImageToLabelMapFilter_h
#define sitkBinaryImageToLabelMapFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class BinaryImageToLabelMapFilter
\brief Label the connected components in a binary image and produce a collection of label objects.

BinaryImageToLabelMapFilter labels the objects in a binary image. Each distinct object is assigned a unique label. The final object labels start with 1 and are consecutive. Objects that are reached earlier by a raster order scan have a lower label.

The GetOutput() function of this class returns an itk::LabelMap .

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176 

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.

\see ConnectedComponentImageFilter , LabelImageToLabelMapFilter , LabelMap , LabelObject
\sa itk::simple::BinaryImageToLabelMapFilter for the procedural interface
\sa itk::BinaryImageToLabelMapFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT BinaryImageToLabelMapFilter : public ImageFilter<1> {
    public:
      typedef BinaryImageToLabelMapFilter Self;

      /** Destructor */
      virtual ~BinaryImageToLabelMapFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      BinaryImageToLabelMapFilter();

      /** Define the pixels types supported by this filter */
      typedef IntegerPixelIDTypeList  PixelIDTypeList;



      /**
       * Set/Get whether the connected components are defined strictly by face connectivity or by face+edge+vertex connectivity. Default is FullyConnectedOff. For objects that are 1 pixel wide, use FullyConnectedOn.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetFullyConnected ( bool FullyConnected ) { this->m_FullyConnected = FullyConnected; return *this; }

      /** Set the value of FullyConnected to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOn() { return this->SetFullyConnected(true); }
      SITK_RETURN_SELF_TYPE_HEADER FullyConnectedOff() { return this->SetFullyConnected(false); }

      /**
       * Set/Get whether the connected components are defined strictly by face connectivity or by face+edge+vertex connectivity. Default is FullyConnectedOff. For objects that are 1 pixel wide, use FullyConnectedOn.
       */
        bool GetFullyConnected() const { return this->m_FullyConnected; }

      /**
       * Set/Get the value to be consider "foreground" in the input image. Defaults to NumericTraits<InputPixelType>::max() .
       */
      SITK_RETURN_SELF_TYPE_HEADER SetInputForegroundValue ( double InputForegroundValue ) { this->m_InputForegroundValue = InputForegroundValue; return *this; }

      /**
       * Set/Get the value to be consider "foreground" in the input image. Defaults to NumericTraits<InputPixelType>::max() .
       */
        double GetInputForegroundValue() const { return this->m_InputForegroundValue; }

      /**
       * Set/Get the value used as "background" in the output image. Defaults to NumericTraits<OutputPixelType>::NonpositiveMin() .
       */
      SITK_RETURN_SELF_TYPE_HEADER SetOutputBackgroundValue ( double OutputBackgroundValue ) { this->m_OutputBackgroundValue = OutputBackgroundValue; return *this; }

      /**
       * Set/Get the value used as "background" in the output image. Defaults to NumericTraits<OutputPixelType>::NonpositiveMin() .
       */
        double GetOutputBackgroundValue() const { return this->m_OutputBackgroundValue; }
     /**
      *
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     uint64_t GetNumberOfObjects() const { return this->m_NumberOfObjects; };

      /** Name of this class */
      std::string GetName() const { return std::string ("BinaryImageToLabelMapFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, bool fullyConnected, double inputForegroundValue, double outputBackgroundValue );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      bool  m_FullyConnected;
      double  m_InputForegroundValue;
      double  m_OutputBackgroundValue;
      /* Docs */
      uint64_t m_NumberOfObjects;

    };


    /**
     * \brief Label the connected components in a binary image and produce a collection of label objects.
     *
     * This function directly calls the execute method of BinaryImageToLabelMapFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::BinaryImageToLabelMapFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image BinaryImageToLabelMap ( const Image& image1, bool fullyConnected = false, double inputForegroundValue = 1.0, double outputBackgroundValue = 0.0 );

  }
}
#endif
