/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkBinaryErodeImageFilter_h
#define sitkBinaryErodeImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkKernelImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkImageFilter.h"
#include "sitkBasicFilters.h"
#include "sitkKernel.h"

namespace itk {
  namespace simple {

    /**\class BinaryErodeImageFilter
\brief Fast binary erosion.

BinaryErodeImageFilter is a binary erosion morphologic operation. This implementation is based on the papers:

L.Vincent "Morphological transformations of binary images with
arbitrary structuring elements", and

N.Nikopoulos et al. "An efficient algorithm for 3d binary morphological transformations with 3d structuring elements for arbitrary size and shape". IEEE Transactions on Image Processing. Vol. 9. No. 3. 2000. pp. 283-286.

Gray scale images can be processed as binary images by selecting a "ErodeValue". Pixel values matching the erode value are considered the "foreground" and all other pixels are "background". This is useful in processing segmented images where all pixels in segment #1 have value 1 and pixels in segment #2 have value 2, etc. A particular "segment number" can be processed. ErodeValue defaults to the maximum possible value of the PixelType. The eroded pixels will receive the BackgroundValue (defaults to 0).

The structuring element is assumed to be composed of binary values (zero or one). Only elements of the structuring element having values > 0 are candidates for affecting the center pixel. A reasonable choice of structuring element is itk::BinaryBallStructuringElement .

\see ImageToImageFilter BinaryDilateImageFilter BinaryMorphologyImageFilter
\sa itk::simple::BinaryErode for the procedural interface
\sa itk::BinaryErodeImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT BinaryErodeImageFilter : public ImageFilter<1> {
    public:
      typedef BinaryErodeImageFilter Self;

      /** Destructor */
      virtual ~BinaryErodeImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      BinaryErodeImageFilter();

      /** Define the pixels types supported by this filter */
      typedef IntegerPixelIDTypeList  PixelIDTypeList;

    /** Kernel type enumeration */
    typedef enum{Annulus=sitkAnnulus, Ball=sitkBall, Box=sitkBox, Cross=sitkCross} KernelType;



      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBackgroundValue ( double BackgroundValue ) { this->m_BackgroundValue = BackgroundValue; return *this; }

      /**
       */
        double GetBackgroundValue() const { return this->m_BackgroundValue; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetForegroundValue ( double ForegroundValue ) { this->m_ForegroundValue = ForegroundValue; return *this; }

      /**
       */
        double GetForegroundValue() const { return this->m_ForegroundValue; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBoundaryToForeground ( bool BoundaryToForeground ) { this->m_BoundaryToForeground = BoundaryToForeground; return *this; }

      /** Set the value of BoundaryToForeground to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER BoundaryToForegroundOn() { return this->SetBoundaryToForeground(true); }
      SITK_RETURN_SELF_TYPE_HEADER BoundaryToForegroundOff() { return this->SetBoundaryToForeground(false); }

      /**
       */
        bool GetBoundaryToForeground() const { return this->m_BoundaryToForeground; }
      /** Kernel radius as a scale for isotropic structures */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius(uint32_t r);

      /** Set/Get the radius of the kernel structuring element as a
       * vector.
       *
       * If the dimension of the image is greater then the length of
       * r, then the radius will be padded. If it is less the r will
       * be truncated.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius(const std::vector<uint32_t>  &r );
      std::vector<uint32_t> GetKernelRadius() const;

      /** Set/Get the kernel or structuring elemenent used for the
       * morphology */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType(KernelEnum t);
#ifndef SWIG
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType(KernelType t);
#endif
      KernelEnum GetKernelType() const;

      /** Name of this class */
      std::string GetName() const { return std::string ("BinaryErodeImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double backgroundValue, double foregroundValue, bool boundaryToForeground );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      double  m_BackgroundValue;
      /*  */
      double  m_ForegroundValue;
      /*  */
      bool  m_BoundaryToForeground;

      /* Kernel Radius as a vector */
      std::vector<uint32_t> m_KernelRadius;

      /** KernelType */
      KernelEnum m_KernelType;
    };


    /**
     * itk::simple::BinaryErodeImageFilter Functional Interface
     *
     * This function directly calls the execute method of BinaryErodeImageFilter
     * in order to support a fully functional API
     */
  Image SITKBasicFilters_EXPORT BinaryErode ( const Image&,
                                          uint32_t radius = 1, KernelEnum kernel = sitkBall
                                          , double backgroundValue = 0.0, double foregroundValue = 1.0, bool boundaryToForeground = true );


   /**
     * itk::simple::BinaryErodeImageFilter Functional Interface
     *
     * This function directly calls the execute method of BinaryErodeImageFilter
     * in order to support a fully functional API
     */
  Image SITKBasicFilters_EXPORT BinaryErode ( const Image&,
                                          const std::vector<uint32_t> vectorRadius, KernelEnum kernel = sitkBall
                                          , double backgroundValue = 0.0, double foregroundValue = 1.0, bool boundaryToForeground = true );
  }
}
#endif
