/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkBSplineDecompositionImageFilter_h
#define sitkBSplineDecompositionImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class BSplineDecompositionImageFilter
\brief Calculates the B-Spline coefficients of an image. Spline order may be from 0 to 5.

This class defines N-Dimension B-Spline transformation. It is based on: [1] M. Unser, "Splines: A Perfect Fit for Signal and Image Processing," IEEE Signal Processing Magazine, vol. 16, no. 6, pp. 22-38, November 1999. [2] M. Unser, A. Aldroubi and M. Eden, "B-Spline Signal Processing: Part I--Theory," IEEE Transactions on Signal Processing, vol. 41, no. 2, pp. 821-832, February 1993. [3] M. Unser, A. Aldroubi and M. Eden, "B-Spline Signal Processing: Part II--Efficient Design and Applications," IEEE Transactions on Signal Processing, vol. 41, no. 2, pp. 834-848, February 1993. And code obtained from bigwww.epfl.ch by Philippe Thevenaz

Limitations: Spline order must be between 0 and 5. Spline order must be set before setting the image. Uses mirror boundary conditions. Requires the same order of Spline for each dimension. Can only process LargestPossibleRegion

\see itkBSplineInterpolateImageFunction
\sa itk::simple::BSplineDecomposition for the procedural interface
\sa itk::BSplineDecompositionImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT BSplineDecompositionImageFilter : public ImageFilter<1> {
    public:
      typedef BSplineDecompositionImageFilter Self;

      /** Destructor */
      virtual ~BSplineDecompositionImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      BSplineDecompositionImageFilter();

      /** Define the pixels types supported by this filter */
      typedef RealPixelIDTypeList  PixelIDTypeList;



      /**
       * Get/Sets the Spline Order, supports 0th - 5th order splines. The default is a 3rd order spline.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSplineOrder ( uint32_t SplineOrder ) { this->m_SplineOrder = SplineOrder; return *this; }

      /**
       */
        uint32_t GetSplineOrder() const { return this->m_SplineOrder; }
     /**
      * Get the poles calculated for a given spline order.
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     std::vector<double> GetSplinePoles() const { return this->m_SplinePoles; };

      /** Name of this class */
      std::string GetName() const { return std::string ("BSplineDecompositionImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, uint32_t splineOrder );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      uint32_t  m_SplineOrder;
      /*  */
      std::vector<double> m_SplinePoles;

    };


    /**
     * \brief Calculates the B-Spline coefficients of an image. Spline order may be from 0 to 5.
     *
     * This function directly calls the execute method of BSplineDecompositionImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::BSplineDecompositionImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image BSplineDecomposition ( const Image& image1, uint32_t splineOrder = 3u );

  }
}
#endif
