/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkAtan2ImageFilter_h
#define sitkAtan2ImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkBinaryFunctorFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class Atan2ImageFilter
\brief Computes two argument inverse tangent.

The first argument to the atan function is provided by a pixel in the first input image (SetInput1() ) and the corresponding pixel in the second input image (SetInput2() ) is used as the second argument.

This class is templated over the types of the two input images and the type of the output image. Numeric conversions (castings) are done by the C++ defaults.

Both pixel input types are cast to double in order to be used as parameters of std::atan2() . The resulting double value is cast to the output pixel type.
\sa itk::simple::Atan2 for the procedural interface
\sa itk::Atan2ImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT Atan2ImageFilter : public ImageFilter<2> {
    public:
      typedef Atan2ImageFilter Self;

      /** Destructor */
      virtual ~Atan2ImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      Atan2ImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("Atan2ImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */
      Image Execute ( const Image& image1, const Image& image2 );


      /** Execute the filter with an image and a constant */
      Image Execute ( const Image& image1, double constant );
      Image Execute ( double constant, const Image& image2 );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;
      typedef Image (Self::*MemberFunction1Type)( double constant, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( double constant, const Image& image2 );
      friend struct detail::MemberFunctionAddressor<MemberFunction1Type>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunction1Type> > m_MemberFactory1;

      typedef Image (Self::*MemberFunction2Type)( const Image& image1, double constant );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, double constant );
      friend struct detail::MemberFunctionAddressor<MemberFunction2Type>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunction2Type> > m_MemberFactory2;


    };


    /**
     * \brief Computes two argument inverse tangent.
     *
     * This function directly calls the execute method of Atan2ImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::Atan2ImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Atan2 ( const Image& image1, const Image& image2 );

    SITKBasicFilters_EXPORT Image Atan2 ( const Image& image1, double constant );
    SITKBasicFilters_EXPORT Image Atan2 ( double constant, const Image& image2 );
  }
}
#endif
