/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkAntiAliasBinaryImageFilter_h
#define sitkAntiAliasBinaryImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class AntiAliasBinaryImageFilter
\brief A method for estimation of a surface from a binary volume.

\par 
This filter implements a surface-fitting method for estimation of a surface from a binary volume. This process can be used to reduce aliasing artifacts which result in visualization of binary partitioned surfaces.

\par 
The binary volume (filter input) is used as a set of constraints in an iterative relaxation process of an estimated ND surface. The surface is described implicitly as the zero level set of a volume \f$ \phi \f$ and allowed to deform under curvature flow. A set of constraints is imposed on this movement as follows:

\par 
 \f[ u_{i,j,k}^{n+1} = \left\{ \begin{array}{ll} \mbox{max} (u_{i,j,k}^{n} + \Delta t H_{i,j,k}^{n}, 0) & \mbox{\f$B_{i,j,k} = 1\f$} \\ \mbox{min} (u_{i,j,k}^{n} + \Delta t H_{i,j,k}^{n}, 0) & \mbox{\f$B_{i,j,k} = -1\f$} \end{array}\right. \f] 

\par 
where \f$ u_{i,j,k}^{n} \f$ is the value of \f$ \phi \f$ at discrete index \f$ (i,j,k) \f$ and iteration \f$ n \f$ , \f$ H \f$ is the gradient magnitude times mean curvature of \f$ \phi \f$ , and \f$ B \f$ is the binary input volume, with 1 denoting an inside pixel and -1 denoting an outside pixel.

\par NOTES
This implementation uses a sparse field level set solver instead of the narrow band implementation described in the reference below, which may introduce some differences in how fast and how accurately (in terms of RMS error) the solution converges.

\par REFERENCES
Whitaker, Ross. "Reducing Aliasing Artifacts In Iso-Surfaces of Binary
Volumes" IEEE Volume Visualization and Graphics Symposium, October 2000, pp.23-32.

\par PARAMETERS
The MaximumRMSChange parameter is used to determine when the solution has converged. A lower value will result in a tighter-fitting solution, but will require more computations. Too low a value could put the solver into an infinite loop. Values should always be less than 1.0. A value of 0.07 is a good starting estimate.

\par 
The MaximumIterations parameter can be used to halt the solution after a specified number of iterations.

\par INPUT
The input is an N-dimensional image of any type. It is assumed to be a binary image. The filter will use an isosurface value that is halfway between the min and max values in the image. A signed data type is not necessary for the input.

\par OUTPUT
The filter will output a level set image of real, signed values. The zero crossings of this (N-dimensional) image represent the position of the isosurface value of interest. Values outside the zero level set are negative and values inside the zero level set are positive values.

\par IMPORTANT!
The output image type you use to instantiate this filter should be a real valued scalar type. In other words: doubles or floats.

\par USING THIS FILTER
The filter is relatively straightforward to use. Tests and examples exist to illustrate. The important thing is to understand the input and output types so you can properly interperet your results.

\par 
In the common case, the only parameter that will need to be set is the MaximumRMSChange parameter, which determines when the solver halts.
\sa itk::simple::AntiAliasBinary for the procedural interface
\sa itk::AntiAliasBinaryImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT AntiAliasBinaryImageFilter : public ImageFilter<1> {
    public:
      typedef AntiAliasBinaryImageFilter Self;

      /** Destructor */
      virtual ~AntiAliasBinaryImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      AntiAliasBinaryImageFilter();

      /** Define the pixels types supported by this filter */
      typedef IntegerPixelIDTypeList  PixelIDTypeList;



      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetMaximumRMSError ( double MaximumRMSError ) { this->m_MaximumRMSError = MaximumRMSError; return *this; }

      /**
       */
        double GetMaximumRMSError() const { return this->m_MaximumRMSError; }

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNumberOfIterations ( uint32_t NumberOfIterations ) { this->m_NumberOfIterations = NumberOfIterations; return *this; }

      /**
       */
        uint32_t GetNumberOfIterations() const { return this->m_NumberOfIterations; }
     /** \brief Number of iterations run.
      *
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     uint32_t GetElapsedIterations() const { return this->m_ElapsedIterations; };

     /** \brief The Root Mean Square of the levelset upon termination.
      *
      *
      * This is a measurement. Its value is updated in the Execute
      * methods, so the value will only be valid after an execution.
      */
     double GetRMSChange() const { return this->m_RMSChange; };

      /** Name of this class */
      std::string GetName() const { return std::string ("AntiAliasBinaryImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, double maximumRMSError, uint32_t numberOfIterations );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /* Value of RMS change below which the filter should stop. This is a convergence criterion. */
      double  m_MaximumRMSError;
      /* Number of iterations to run */
      uint32_t  m_NumberOfIterations;

      uint32_t m_ElapsedIterations;

      double m_RMSChange;

    };


    /**
     * \brief A method for estimation of a surface from a binary volume.
     *
     * This function directly calls the execute method of AntiAliasBinaryImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::AntiAliasBinaryImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image AntiAliasBinary ( const Image& image1, double maximumRMSError = 0.07, uint32_t numberOfIterations = 1000u );

  }
}
#endif
