/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkAggregateLabelMapFilter_h
#define sitkAggregateLabelMapFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class AggregateLabelMapFilter
\brief Collapses all labels into the first label.

This filter takes a label map as input and visits the pixels of all labels and assigns them to the first label of the label map. At the end of the execution of this filter, the map will contain a single filter.

This implementation was taken from the Insight Journal paper: https://hdl.handle.net/1926/584 or http://www.insight-journal.org/browse/publication/176 

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.

\see ShapeLabelObject , RelabelComponentImageFilter
\sa itk::simple::AggregateLabelMapFilter for the procedural interface
\sa itk::AggregateLabelMapFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT AggregateLabelMapFilter : public ImageFilter<1> {
    public:
      typedef AggregateLabelMapFilter Self;

      /** Destructor */
      virtual ~AggregateLabelMapFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      AggregateLabelMapFilter();

      /** Define the pixels types supported by this filter */
      typedef LabelPixelIDTypeList  PixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("AggregateLabelMapFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


    };


    /**
     * \brief Collapses all labels into the first label.
     *
     * This function directly calls the execute method of AggregateLabelMapFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::AggregateLabelMapFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image AggregateLabelMap ( const Image& image1 );

  }
}
#endif
