/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkAddImageFilter_h
#define sitkAddImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkBinaryFunctorFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class AddImageFilter
\brief Pixel-wise addition of two images.

This class is templated over the types of the two input images and the type of the output image. Numeric conversions (castings) are done by the C++ defaults.

The pixel type of the input 1 image must have a valid definition of the operator+ with a pixel type of the image 2. This condition is required because internally this filter will perform the operation

\code
pixel_from_image_1 + pixel_from_image_2

\endcode

Additionally the type resulting from the sum, will be cast to the pixel type of the output image.

The total operation over one pixel will be \code
output_pixel = static_cast<OutputPixelType>( input1_pixel + input2_pixel )

\endcode

For example, this filter could be used directly for adding images whose pixels are vectors of the same dimension, and to store the resulting vector in an output image of vector pixels.

The images to be added are set using the methods: \code
SetInput1( image1 );

SetInput2( image2 );

\endcode

Additionally, this filter can be used to add a constant to every pixel of an image by using \code
SetInput1( image1 );

SetConstant2( constant );

\endcode

\warning No numeric overflow checking is performed in this filter.
\sa itk::simple::Add for the procedural interface
\sa itk::AddImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT AddImageFilter : public ImageFilter<2> {
    public:
      typedef AddImageFilter Self;

      /** Destructor */
      virtual ~AddImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      AddImageFilter();

      /** Define the pixels types supported by this filter */
      typedef NonLabelPixelIDTypeList  PixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("AddImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */
      Image Execute ( const Image& image1, const Image& image2 );


      /** Execute the filter with an image and a constant */
      Image Execute ( const Image& image1, double constant );
      Image Execute ( double constant, const Image& image2 );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;
      typedef Image (Self::*MemberFunction1Type)( double constant, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( double constant, const Image& image2 );
      friend struct detail::MemberFunctionAddressor<MemberFunction1Type>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunction1Type> > m_MemberFactory1;

      typedef Image (Self::*MemberFunction2Type)( const Image& image1, double constant );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, double constant );
      friend struct detail::MemberFunctionAddressor<MemberFunction2Type>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunction2Type> > m_MemberFactory2;


    };


    /**
     * \brief Pixel-wise addition of two images.
     *
     * This function directly calls the execute method of AddImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::AddImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image Add ( const Image& image1, const Image& image2 );

    SITKBasicFilters_EXPORT Image Add ( const Image& image1, double constant );
    SITKBasicFilters_EXPORT Image Add ( double constant, const Image& image2 );
  }
}
#endif
