/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkAdaptiveHistogramEqualizationImageFilter_h
#define sitkAdaptiveHistogramEqualizationImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class AdaptiveHistogramEqualizationImageFilter
\brief Power Law Adaptive Histogram Equalization.

Histogram equalization modifies the contrast in an image. The AdaptiveHistogramEqualizationImageFilter is a superset of many contrast enhancing filters. By modifying its parameters (alpha, beta, and window), the AdaptiveHistogramEqualizationImageFilter can produce an adaptively equalized histogram or a version of unsharp mask (local mean subtraction). Instead of applying a strict histogram equalization in a window about a pixel, this filter prescribes a mapping function (power law) controlled by the parameters alpha and beta.

The parameter alpha controls how much the filter acts like the classical histogram equalization method (alpha=0) to how much the filter acts like an unsharp mask (alpha=1).

The parameter beta controls how much the filter acts like an unsharp mask (beta=0) to much the filter acts like pass through (beta=1, with alpha=1).

The parameter window controls the size of the region over which local statistics are calculated.

By altering alpha, beta and window, a host of equalization and unsharp masking filters is available.

The boundary condition ignores the part of the neighborhood outside the image, and over-weights the valid part of the neighborhood.

For detail description, reference "Adaptive Image Contrast
Enhancement using Generalizations of Histogram Equalization." J.Alex Stark. IEEE Transactions on Image Processing, May 2000.
\sa itk::simple::AdaptiveHistogramEqualization for the procedural interface
\sa itk::AdaptiveHistogramEqualizationImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT AdaptiveHistogramEqualizationImageFilter : public ImageFilter<1> {
    public:
      typedef AdaptiveHistogramEqualizationImageFilter Self;

      /** Destructor */
      virtual ~AdaptiveHistogramEqualizationImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      AdaptiveHistogramEqualizationImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;



      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetRadius ( const std::vector<unsigned int> & Radius ) { this->m_Radius = Radius; return *this; }

      /** Set the values of the Radius vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetRadius( unsigned int value ) { this->m_Radius = std::vector<unsigned int>(3, value); return *this; }


      /**
       */
        std::vector<unsigned int> GetRadius() const { return this->m_Radius; }

      /**
       * Set/Get the value of alpha. Alpha = 0 produces the adaptive histogram equalization (provided beta=0). Alpha = 1 produces an unsharp mask. Default is 0.3.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetAlpha ( float Alpha ) { this->m_Alpha = Alpha; return *this; }

      /**
       * Set/Get the value of alpha. Alpha = 0 produces the adaptive histogram equalization (provided beta=0). Alpha = 1 produces an unsharp mask. Default is 0.3.
       */
        float GetAlpha() const { return this->m_Alpha; }

      /**
       * Set/Get the value of beta. If beta = 1 (and alpha = 1), then the output image matches the input image. As beta approaches 0, the filter behaves as an unsharp mask. Default is 0.3.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBeta ( float Beta ) { this->m_Beta = Beta; return *this; }

      /**
       * Set/Get the value of beta. If beta = 1 (and alpha = 1), then the output image matches the input image. As beta approaches 0, the filter behaves as an unsharp mask. Default is 0.3.
       */
        float GetBeta() const { return this->m_Beta; }
      /** Name of this class */
      std::string GetName() const { return std::string ("AdaptiveHistogramEqualizationImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */
      Image Execute ( const Image& image1 );


      /** Execute the filter on the input image with the given parameters */
      Image Execute ( const Image& image1, const std::vector<unsigned int> & radius, float alpha, float beta );

    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::vector<unsigned int>  m_Radius;
      float  m_Alpha;
      float  m_Beta;
    };


    /**
     * \brief Power Law Adaptive Histogram Equalization.
     *
     * This function directly calls the execute method of AdaptiveHistogramEqualizationImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::AdaptiveHistogramEqualizationImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image AdaptiveHistogramEqualization ( const Image& image1, const std::vector<unsigned int> & radius = std::vector<unsigned int>(3, 5), float alpha = 0.3f, float beta = 0.3f );

  }
}
#endif
