/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkAbsoluteValueDifferenceImageFilter_h
#define sitkAbsoluteValueDifferenceImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkBinaryFunctorFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk {
  namespace simple {

    /**\class AbsoluteValueDifferenceImageFilter
\brief Implements pixel-wise the computation of absolute value difference.

This filter is parametrized over the types of the two input images and the type of the output image.

Numeric conversions (castings) are done by the C++ defaults.

The filter will walk over all the pixels in the two input images, and for each one of them it will do the following:


\li Cast the input 1 pixel value to double . 

\li Cast the input 2 pixel value to double . 

\li Compute the difference of the two pixel values. 

\li Compute the absolute value of the difference. 

\li Cast the double value resulting from the absolute value to the pixel type of the output image. 

\li Store the casted value into the output image.


The filter expects all images to have the same dimension (e.g. all 2D, or all 3D, or all ND).
\sa itk::simple::AbsoluteValueDifference for the procedural interface
\sa itk::AbsoluteValueDifferenceImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT AbsoluteValueDifferenceImageFilter : public ImageFilter<2> {
    public:
      typedef AbsoluteValueDifferenceImageFilter Self;

      /** Destructor */
      virtual ~AbsoluteValueDifferenceImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      AbsoluteValueDifferenceImageFilter();

      /** Define the pixels types supported by this filter */
      typedef BasicPixelIDTypeList  PixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("AbsoluteValueDifferenceImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input images */
      Image Execute ( const Image& image1, const Image& image2 );


      /** Execute the filter with an image and a constant */
      Image Execute ( const Image& image1, double constant );
      Image Execute ( double constant, const Image& image2 );


    private:

      /** Setup for member function dispatching */

      typedef Image (Self::*MemberFunctionType)( const Image& image1, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, const Image& image2 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;
      typedef Image (Self::*MemberFunction1Type)( double constant, const Image& image2 );
      template <class TImageType> Image ExecuteInternal ( double constant, const Image& image2 );
      friend struct detail::MemberFunctionAddressor<MemberFunction1Type>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunction1Type> > m_MemberFactory1;

      typedef Image (Self::*MemberFunction2Type)( const Image& image1, double constant );
      template <class TImageType> Image ExecuteInternal ( const Image& image1, double constant );
      friend struct detail::MemberFunctionAddressor<MemberFunction2Type>;
      nsstd::auto_ptr<detail::MemberFunctionFactory<MemberFunction2Type> > m_MemberFactory2;


    };


    /**
     * \brief Implements pixel-wise the computation of absolute value difference.
     *
     * This function directly calls the execute method of AbsoluteValueDifferenceImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::AbsoluteValueDifferenceImageFilter for the object oriented interface
     */
     SITKBasicFilters_EXPORT Image AbsoluteValueDifference ( const Image& image1, const Image& image2 );

    SITKBasicFilters_EXPORT Image AbsoluteValueDifference ( const Image& image1, double constant );
    SITKBasicFilters_EXPORT Image AbsoluteValueDifference ( double constant, const Image& image2 );
  }
}
#endif
