############################################################################
# Copyright (c) 2016, Johan Mabille, Sylvain Corlay, Martin Renou          #
# Copyright (c) 2016, QuantStack                                           #
#                                                                          #
# Distributed under the terms of the BSD 3-Clause License.                 #
#                                                                          #
# The full license is in the file LICENSE, distributed with this software. #
############################################################################

# mamba cmake module
# This module sets the following variables in your project::
#
#   mamba_FOUND - true if mamba found on the system
#   mamba_INCLUDE_DIRS - the directory containing mamba headers
#   mamba_LIBRARY - the library for dynamic linking
#   mamba_STATIC_LIBRARY - the library for static linking


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was mambaConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR};${CMAKE_MODULE_PATH}")



include(CMakeFindDependencyMacro)
find_dependency(nlohmann_json)
find_dependency(pybind11)
find_dependency(Threads)

if(NOT TARGET mamba AND NOT TARGET mamba_lib)
    include("${CMAKE_CURRENT_LIST_DIR}/mambaTargets.cmake")

    if (TARGET mamba AND TARGET mamba_lib)
        get_target_property(mamba_INCLUDE_DIR mamba INTERFACE_INCLUDE_DIRECTORIES)
        get_target_property(mamba_LIBRARY mamba LOCATION)
        get_target_property(mamba_STATIC_LIBRARY mamba_lib LOCATION)
    elseif (TARGET mamba)
        get_target_property(mamba_INCLUDE_DIR mamba INTERFACE_INCLUDE_DIRECTORIES)
        get_target_property(mamba_LIBRARY mamba LOCATION)
    elseif (TARGET mamba_lib)
        get_target_property(mamba_INCLUDE_DIR mamba_lib INTERFACE_INCLUDE_DIRECTORIES)
        get_target_property(mamba_STATIC_LIBRARY mamba_lib LOCATION)
        set(mamba_LIBRARY ${mamba_STATIC_LIBRARY})
    endif ()
endif()
