if (IGNITION-TOOLS_CONFIG_INCLUDED)
  return()
endif()
set(IGNITION-TOOLS_CONFIG_INCLUDED TRUE)


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was ignition-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

list(APPEND IGNITION-TOOLS_BINARY_DIRS ${PACKAGE_PREFIX_DIR}/bin)

list(APPEND IGNITION-TOOLS_INCLUDE_DIRS ${PACKAGE_PREFIX_DIR}/include)

list(APPEND IGNITION-TOOLS_LIBRARY_DIRS ${PACKAGE_PREFIX_DIR}/lib)

list(APPEND IGNITION-TOOLS_CFLAGS -I${PACKAGE_PREFIX_DIR}/include)

list(APPEND IGNITION-TOOLS_CXX_FLAGS -std=c++11)
if ("${CMAKE_CXX_COMPILER_ID}" MATCHES "Clang")
  set(IGNITION-TOOLS_CXX_FLAGS "${IGNITION-TOOLS_CXX_FLAGS} -stdlib=libc++")
endif ()

foreach(dep )
  if(NOT ${dep}_FOUND)
    find_package(${dep} REQUIRED)
  endif()
  string(TOUPPER ${dep} dep_upper)
  list(APPEND IGNITION-TOOLS_INCLUDE_DIRS ${${dep_upper}_INCLUDE_DIRS})
  list(APPEND IGNITION-TOOLS_LIBRARIES ${${dep_upper}_LIBRARIES})
endforeach()

list(APPEND IGNITION-TOOLS_LDFLAGS -L${PACKAGE_PREFIX_DIR}/lib)
