# - Config to retrieve all components of the ignition-sensors5 package
#
# This should only be invoked by ignition-sensors5-config.cmake.
#
# To retrieve this meta-package, use:
# find_package(ignition-sensors5 COMPONENTS all)
#
# This creates the target ignition-sensors5::all which will link to all known
# components of ignition-sensors5, including the core library.
#
# This also creates the variable ignition-sensors5_ALL_LIBRARIES
#
################################################################################

cmake_minimum_required(VERSION 3.10.2 FATAL_ERROR)

if(ignition-sensors5_ALL_CONFIG_INCLUDED)
  return()
endif()
set(ignition-sensors5_ALL_CONFIG_INCLUDED TRUE)

if(NOT ignition-sensors5-all_FIND_QUIETLY)
  message(STATUS "Looking for all libraries of ignition-sensors5 -- found version 5.0.0")
endif()


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was ignition-all-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

# Get access to the find_dependency utility
include(CMakeFindDependencyMacro)

# Find the core library
find_dependency(ignition-sensors5 5.0.0 EXACT)

# Find the component libraries
find_dependency(ignition-sensors5-rendering 5.0.0 EXACT)
find_dependency(ignition-sensors5-camera 5.0.0 EXACT)
find_dependency(ignition-sensors5-depth_camera 5.0.0 EXACT)
find_dependency(ignition-sensors5-lidar 5.0.0 EXACT)
find_dependency(ignition-sensors5-gpu_lidar 5.0.0 EXACT)
find_dependency(ignition-sensors5-logical_camera 5.0.0 EXACT)
find_dependency(ignition-sensors5-magnetometer 5.0.0 EXACT)
find_dependency(ignition-sensors5-imu 5.0.0 EXACT)
find_dependency(ignition-sensors5-altimeter 5.0.0 EXACT)
find_dependency(ignition-sensors5-air_pressure 5.0.0 EXACT)
find_dependency(ignition-sensors5-rgbd_camera 5.0.0 EXACT)
find_dependency(ignition-sensors5-thermal_camera 5.0.0 EXACT)

if(NOT TARGET ignition-sensors5::ignition-sensors5-all)
  include("${CMAKE_CURRENT_LIST_DIR}/ignition-sensors5-all-targets.cmake")

  add_library(ignition-sensors5::all INTERFACE IMPORTED)
  set_target_properties(ignition-sensors5::all PROPERTIES
    INTERFACE_LINK_LIBRARIES "ignition-sensors5::ignition-sensors5-all")

endif()

# Create the "requested" target if it does not already exist
if(NOT TARGET ignition-sensors5::requested)
  add_library(ignition-sensors5::requested INTERFACE IMPORTED)
endif()

# Link the "all" target to the "requested" target
get_target_property(ign_requested_components ignition-sensors5::requested INTERFACE_LINK_LIBRARIES)
if(NOT ign_requested_components)
  set_target_properties(ignition-sensors5::requested PROPERTIES
    INTERFACE_LINK_LIBRARIES "ignition-sensors5::ignition-sensors5-all")
else()
  set_target_properties(ignition-sensors5::requested PROPERTIES
    INTERFACE_LINK_LIBRARIES "${ign_requested_components};ignition-sensors5::ignition-sensors5-all")
endif()

set(ignition-sensors5_ALL_LIBRARIES ignition-sensors5::ignition-sensors5-all)
