__all__ = ['chwirut_eval']
import numpy as np

NOBSERVATIONS = 214

y = np.zeros(214)
t = np.zeros(214)

y[0] =    92.9000;    t[0] =   0.5000;
y[1] =    78.7000;    t[1] =   0.6250;
y[2] =    64.2000;    t[2] =   0.7500;
y[3] =    64.9000;    t[3] =   0.8750;
y[4] =    57.1000;    t[4] =   1.0000;
y[5] =    43.3000;    t[5] =   1.2500;
y[6] =    31.1000;    t[6] =   1.7500;
y[7] =    23.6000;    t[7] =   2.2500;
y[8] =    31.0500;    t[8] =   1.7500;
y[9] =    23.7750;    t[9] =   2.2500;
y[10] =    17.7375;   t[10] =   2.7500;
y[11] =    13.8000;   t[11] =   3.2500;
y[12] =    11.5875;   t[12] =   3.7500;
y[13] =     9.4125;   t[13] =   4.2500;
y[14] =     7.7250;   t[14] =   4.7500;
y[15] =     7.3500;   t[15] =   5.2500;
y[16] =     8.0250;   t[16] =   5.7500;
y[17] =    90.6000;   t[17] =   0.5000;
y[18] =    76.9000;   t[18] =   0.6250;
y[19] =    71.6000;   t[19] =   0.7500;
y[20] =    63.6000;   t[20] =   0.8750;
y[21] =    54.0000;   t[21] =   1.0000;
y[22] =    39.2000;   t[22] =   1.2500;
y[23] =    29.3000;   t[23] =   1.7500;
y[24] =    21.4000;   t[24] =   2.2500;
y[25] =    29.1750;   t[25] =   1.7500;
y[26] =    22.1250;   t[26] =   2.2500;
y[27] =    17.5125;   t[27] =   2.7500;
y[28] =    14.2500;   t[28] =   3.2500;
y[29] =     9.4500;   t[29] =   3.7500;
y[30] =     9.1500;   t[30] =   4.2500;
y[31] =     7.9125;   t[31] =   4.7500;
y[32] =     8.4750;   t[32] =   5.2500;
y[33] =     6.1125;   t[33] =   5.7500;
y[34] =    80.0000;   t[34] =   0.5000;
y[35] =    79.0000;   t[35] =   0.6250;
y[36] =    63.8000;   t[36] =   0.7500;
y[37] =    57.2000;   t[37] =   0.8750;
y[38] =    53.2000;   t[38] =   1.0000;
y[39] =    42.5000;   t[39] =   1.2500;
y[40] =    26.8000;   t[40] =   1.7500;
y[41] =    20.4000;   t[41] =   2.2500;
y[42] =    26.8500;   t[42] =   1.7500;
y[43] =    21.0000;   t[43] =   2.2500;
y[44] =    16.4625;   t[44] =   2.7500;
y[45] =    12.5250;   t[45] =   3.2500;
y[46] =    10.5375;   t[46] =   3.7500;
y[47] =     8.5875;   t[47] =   4.2500;
y[48] =     7.1250;   t[48] =   4.7500;
y[49] =     6.1125;   t[49] =   5.2500;
y[50] =     5.9625;   t[50] =   5.7500;
y[51] =    74.1000;   t[51] =   0.5000;
y[52] =    67.3000;   t[52] =   0.6250;
y[53] =    60.8000;   t[53] =   0.7500;
y[54] =    55.5000;   t[54] =   0.8750;
y[55] =    50.3000;   t[55] =   1.0000;
y[56] =    41.0000;   t[56] =   1.2500;
y[57] =    29.4000;   t[57] =   1.7500;
y[58] =    20.4000;   t[58] =   2.2500;
y[59] =    29.3625;   t[59] =   1.7500;
y[60] =    21.1500;   t[60] =   2.2500;
y[61] =    16.7625;   t[61] =   2.7500;
y[62] =    13.2000;   t[62] =   3.2500;
y[63] =    10.8750;   t[63] =   3.7500;
y[64] =     8.1750;   t[64] =   4.2500;
y[65] =     7.3500;   t[65] =   4.7500;
y[66] =     5.9625;   t[66] =   5.2500;
y[67] =     5.6250;   t[67] =   5.7500;
y[68] =    81.5000;   t[68] =    .5000;
y[69] =    62.4000;   t[69] =    .7500;
y[70] =    32.5000;   t[70] =   1.5000;
y[71] =    12.4100;   t[71] =   3.0000;
y[72] =    13.1200;   t[72] =   3.0000;
y[73] =    15.5600;   t[73] =   3.0000;
y[74] =     5.6300;   t[74] =   6.0000;
y[75] =    78.0000;   t[75] =    .5000;
y[76] =    59.9000;   t[76] =    .7500;
y[77] =    33.2000;   t[77] =   1.5000;
y[78] =    13.8400;   t[78] =   3.0000;
y[79] =    12.7500;   t[79] =   3.0000;
y[80] =    14.6200;   t[80] =   3.0000;
y[81] =     3.9400;   t[81] =   6.0000;
y[82] =    76.8000;   t[82] =    .5000;
y[83] =    61.0000;   t[83] =    .7500;
y[84] =    32.9000;   t[84] =   1.5000;
y[85] =    13.8700;   t[85] =   3.0000;
y[86] =    11.8100;   t[86] =   3.0000;
y[87] =    13.3100;   t[87] =   3.0000;
y[88] =     5.4400;   t[88] =   6.0000;
y[89] =    78.0000;   t[89] =    .5000;
y[90] =    63.5000;   t[90] =    .7500;
y[91] =    33.8000;   t[91] =   1.5000;
y[92] =    12.5600;   t[92] =   3.0000;
y[93] =     5.6300;   t[93] =   6.0000;
y[94] =    12.7500;   t[94] =   3.0000;
y[95] =    13.1200;   t[95] =   3.0000;
y[96] =     5.4400;   t[96] =   6.0000;
y[97] =    76.8000;   t[97] =    .5000;
y[98] =    60.0000;   t[98] =    .7500;
y[99] =    47.8000;   t[99] =   1.0000;
y[100] =    32.0000;  t[100] =   1.5000;
y[101] =    22.2000;  t[101] =   2.0000;
y[102] =    22.5700;  t[102] =   2.0000;
y[103] =    18.8200;  t[103] =   2.5000;
y[104] =    13.9500;  t[104] =   3.0000;
y[105] =    11.2500;  t[105] =   4.0000;
y[106] =     9.0000;  t[106] =   5.0000;
y[107] =     6.6700;  t[107] =   6.0000;
y[108] =    75.8000;  t[108] =    .5000;
y[109] =    62.0000;  t[109] =    .7500;
y[110] =    48.8000;  t[110] =   1.0000;
y[111] =    35.2000;  t[111] =   1.5000;
y[112] =    20.0000;  t[112] =   2.0000;
y[113] =    20.3200;  t[113] =   2.0000;
y[114] =    19.3100;  t[114] =   2.5000;
y[115] =    12.7500;  t[115] =   3.0000;
y[116] =    10.4200;  t[116] =   4.0000;
y[117] =     7.3100;  t[117] =   5.0000;
y[118] =     7.4200;  t[118] =   6.0000;
y[119] =    70.5000;  t[119] =    .5000;
y[120] =    59.5000;  t[120] =    .7500;
y[121] =    48.5000;  t[121] =   1.0000;
y[122] =    35.8000;  t[122] =   1.5000;
y[123] =    21.0000;  t[123] =   2.0000;
y[124] =    21.6700;  t[124] =   2.0000;
y[125] =    21.0000;  t[125] =   2.5000;
y[126] =    15.6400;  t[126] =   3.0000;
y[127] =     8.1700;  t[127] =   4.0000;
y[128] =     8.5500;  t[128] =   5.0000;
y[129] =    10.1200;  t[129] =   6.0000;
y[130] =    78.0000;  t[130] =    .5000;
y[131] =    66.0000;  t[131] =    .6250;
y[132] =    62.0000;  t[132] =    .7500;
y[133] =    58.0000;  t[133] =    .8750;
y[134] =    47.7000;  t[134] =   1.0000;
y[135] =    37.8000;  t[135] =   1.2500;
y[136] =    20.2000;  t[136] =   2.2500;
y[137] =    21.0700;  t[137] =   2.2500;
y[138] =    13.8700;  t[138] =   2.7500;
y[139] =     9.6700;  t[139] =   3.2500;
y[140] =     7.7600;  t[140] =   3.7500;
y[141] =     5.4400;  t[141] =   4.2500;
y[142] =     4.8700;  t[142] =   4.7500;
y[143] =     4.0100;  t[143] =   5.2500;
y[144] =     3.7500;  t[144] =   5.7500;
y[145] =    24.1900;  t[145] =   3.0000;
y[146] =    25.7600;  t[146] =   3.0000;
y[147] =    18.0700;  t[147] =   3.0000;
y[148] =    11.8100;  t[148] =   3.0000;
y[149] =    12.0700;  t[149] =   3.0000;
y[150] =    16.1200;  t[150] =   3.0000;
y[151] =    70.8000;  t[151] =    .5000;
y[152] =    54.7000;  t[152] =    .7500;
y[153] =    48.0000;  t[153] =   1.0000;
y[154] =    39.8000;  t[154] =   1.5000;
y[155] =    29.8000;  t[155] =   2.0000;
y[156] =    23.7000;  t[156] =   2.5000;
y[157] =    29.6200;  t[157] =   2.0000;
y[158] =    23.8100;  t[158] =   2.5000;
y[159] =    17.7000;  t[159] =   3.0000;
y[160] =    11.5500;  t[160] =   4.0000;
y[161] =    12.0700;  t[161] =   5.0000;
y[162] =     8.7400;  t[162] =   6.0000;
y[163] =    80.7000;  t[163] =    .5000;
y[164] =    61.3000;  t[164] =    .7500;
y[165] =    47.5000;  t[165] =   1.0000;
y[166] =    29.0000;  t[166] =   1.5000;
y[167] =    24.0000;  t[167] =   2.0000;
y[168] =    17.7000;  t[168] =   2.5000;
y[169] =    24.5600;  t[169] =   2.0000;
y[170] =    18.6700;  t[170] =   2.5000;
y[171] =    16.2400;  t[171] =   3.0000;
y[172] =     8.7400;  t[172] =   4.0000;
y[173] =     7.8700;  t[173] =   5.0000;
y[174] =     8.5100;  t[174] =   6.0000;
y[175] =    66.7000;  t[175] =    .5000;
y[176] =    59.2000;  t[176] =    .7500;
y[177] =    40.8000;  t[177] =   1.0000;
y[178] =    30.7000;  t[178] =   1.5000;
y[179] =    25.7000;  t[179] =   2.0000;
y[180] =    16.3000;  t[180] =   2.5000;
y[181] =    25.9900;  t[181] =   2.0000;
y[182] =    16.9500;  t[182] =   2.5000;
y[183] =    13.3500;  t[183] =   3.0000;
y[184] =     8.6200;  t[184] =   4.0000;
y[185] =     7.2000;  t[185] =   5.0000;
y[186] =     6.6400;  t[186] =   6.0000;
y[187] =    13.6900;  t[187] =   3.0000;
y[188] =    81.0000;  t[188] =    .5000;
y[189] =    64.5000;  t[189] =    .7500;
y[190] =    35.5000;  t[190] =   1.5000;
y[191] =    13.3100;  t[191] =   3.0000;
y[192] =     4.8700;  t[192] =   6.0000;
y[193] =    12.9400;  t[193] =   3.0000;
y[194] =     5.0600;  t[194] =   6.0000;
y[195] =    15.1900;  t[195] =   3.0000;
y[196] =    14.6200;  t[196] =   3.0000;
y[197] =    15.6400;  t[197] =   3.0000;
y[198] =    25.5000;  t[198] =   1.7500;
y[199] =    25.9500;  t[199] =   1.7500;
y[200] =    81.7000;  t[200] =    .5000;
y[201] =    61.6000;  t[201] =    .7500;
y[202] =    29.8000;  t[202] =   1.7500;
y[203] =    29.8100;  t[203] =   1.7500;
y[204] =    17.1700;  t[204] =   2.7500;
y[205] =    10.3900;  t[205] =   3.7500;
y[206] =    28.4000;  t[206] =   1.7500;
y[207] =    28.6900;  t[207] =   1.7500;
y[208] =    81.3000;  t[208] =    .5000;
y[209] =    60.9000;  t[209] =    .7500;
y[210] =    16.6500;  t[210] =   2.7500;
y[211] =    10.0500;  t[211] =   3.7500;
y[212] =    28.9000;  t[212] =   1.7500;
y[213] =    28.9500;  t[213] =   1.7500;


def EvaluateFunction(x, component=np.nan):
    """
    Evaluates the chwirut function
    """
    if np.isnan(component):
        f = np.zeros(NOBSERVATIONS)
        for i in range(NOBSERVATIONS):
            f[i] = y[i] - np.exp(-x[0]*t[i])/(x[1] + x[2]*t[i])
    else:
        i = component
        f = y[i] - np.exp(-x[0]*t[i])/(x[1] + x[2]*t[i])

    return f


def EvaluateJacobian(x):
    """
    Evaluates the chwirut Jacobian
    """
    j = np.zeros((NOBSERVATIONS, 3))

    for i in range(NOBSERVATIONS):
        base = np.exp(-x[0]*t[i])/(x[1] + x[2]*t[i])

        j[i][0] = t[i]*base
        j[i][1] = base/(x[1] + x[2]*t[i])
        j[i][2] = base*t[i]/(x[1] + x[2]*t[i])

    return j


def chwirut_eval(H, persis_info, sim_specs, _):
    """
    Evaluates the chwirut objective function at a given set of points in
    ``H['x']``. If ``'obj_component'`` is a field in ``sim_specs['out']``, only that
    component of the objective will be evaluated. Otherwise, all 214 components
    are evaluated and returned in the ``'fvec'`` field.

    .. seealso::
        `test_chwirut_pounders.py <https://github.com/Libensemble/libensemble/blob/develop/libensemble/tests/regression_tests/test_chwirut_pounders.py>`_
        for an example where the entire fvec is computed each call.

    .. seealso::
        `test_chwirut_aposmm_one_residual_at_a_time.py <https://github.com/Libensemble/libensemble/blob/develop/libensemble/tests/regression_tests/test_chwirut_aposmm_one_residual_at_a_time.py>`_
        for an example where one component of fvec is computed per call
    """

    batch = len(H['x'])
    O = np.zeros(batch, dtype=sim_specs['out'])

    for i, x in enumerate(H['x']):
        if 'obj_component' in H.dtype.names:
            if 'user' in sim_specs and 'component_nan_frequency' in sim_specs['user'] and np.random.uniform(0, 1) < sim_specs['user']['component_nan_frequency']:
                O['f_i'][i] = np.nan
            else:
                O['f_i'][i] = EvaluateFunction(x, H['obj_component'][i])

        else:
            O['fvec'][i] = EvaluateFunction(x)
            O['f'][i] = sim_specs['user']['combine_component_func'](O['fvec'][i])

    return O, persis_info

# if __name__ == '__main__':
#     x = np.zeros(3)
#     x[0] = 0.15;
#     x[1] = 0.008;
#     x[2] = 0.010;

#     f = EvaluateFunction(x)
#     J = EvaluateJacobian(x)

#     print(f,J)
