#------------------------------------------------------------------------
# -*- mode: cmake -*-
#------------------------------------------------------------------------
# cx_target_abi_check( )
#
#------------------------------------------------------------------------
include( Autotools/cm_msg_error )
include( Autotools/ArchiveX/cx_msg_debug_variable )
include( CMakeParseArguments )

find_program( ABI_DUMPER_PROGRAM
  NAMES abi-dumper
  )
find_program( ABI_COMPLIANCE_CHECKER_PROGRAM
  NAMES abi-compliance-checker
  )

if ( NOT CMAKE_SCRIPT_MODE_FILE
    AND NOT TARGET abi-check )
  add_custom_target( abi-check )
endif( )

function(cx_target_abi_check)
  set(options
    )
  set(oneValueArgs
    HEADER_DIR
    LIBRARY
    LOCAL_INCLUDE_DIR
    MESSAGE
    )
  set(multiValueArgs
    HEADERS
    )
  cmake_parse_arguments(ARG "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN} )

  # set(library_name "$<TARGET_FILE_NAME:${ARG_LIBRARY}>")
  get_target_property(library_name ${ARG_LIBRARY} LIBRARY_OUTPUT_NAME)
  if( NOT library_name )
    set( library_name ${CMAKE_SHARED_LIBRARY_PREFIX}${ARG_LIBRARY}${CMAKE_SHARED_LIBRARY_SUFFIX})
  endif( )
  get_filename_component(library_name "${library_name}" NAME_WE)
  set(library_name "${library_name}${CMAKE_SHARED_LIBRARY_SUFFIX}")
  set(abi_full_library_name_old "${ABI_DIR}/${CMAKE_INSTALL_LIBDIR}/${library_name}")
  get_filename_component(abi_full_library_name_old "${abi_full_library_name_old}" REALPATH)
  set(abi_full_library_name_new "${CMAKE_CURRENT_BINARY_DIR}/${library_name}")
  get_filename_component(abi_full_library_name_new "${abi_full_library_name_new}" REALPATH)
  if ( ARG_MESSAGE )
    set(msg_begin_command COMMAND ${CMAKE_COMMAND} -E echo "STARTED: ${ARG_MESSAGE} ${library_name}" )
    set(msg_end_command COMMAND ${CMAKE_COMMAND} -E echo "FINISHED: ${ARG_MESSAGE} ${library_name}" )
  endif( )
  if ( NOT ABI_DIR )
    set( ABI_DIR ${CMAKE_INSTALL_PREFIX})
  endif( )
  if ( ABI_DUMPER_PROGRAM AND ABI_COMPLIANCE_CHECKER_PROGRAM )
    set(target_filename "${ARG_LIBRARY}")
    string( REGEX REPLACE "\\.[^.]*$" "" base_name "${target_filename}" )
    set(base_name_old "${base_name}_ABI_0" )
    set(base_name_new "${base_name}_ABI_1" )
    list( APPEND orig_options --debug )
    # list( APPEND orig_options --use-tu-dump )
    list( APPEND orig_options --sort --dir --all )
    list( APPEND new_options --debug )
    # list( APPEND new_options --use-tu-dump )
    list( APPEND new_options --sort --dir --all )
    if ( ARG_HEADERS )
      cx_msg_debug_variable( ARG_HEADERS )
      foreach( hdr ${ARG_HEADERS} )
        list( APPEND orig_headers "${ABI_DIR}/${CMAKE_INSTALL_INCLUDEDIR}/${ARG_HEADER_DIR}/${hdr}" )
        list( APPEND new_headers "${ARG_LOCAL_INCLUDE_DIR}/${hdr}" )
      endforeach( )
      cx_msg_debug_variable( orig_headers )
      cx_msg_debug_variable( new_headers )
      string( REPLACE ";" "\n" orig_headers "${orig_headers}" )
      string( REPLACE ";" "\n" new_headers "${new_headers}" )
      cx_msg_debug_variable( orig_headers )
      cx_msg_debug_variable( new_headers )
      file( WRITE "${CMAKE_CURRENT_BINARY_DIR}/${base_name_old}.hdrs" "${orig_headers}" )
      file( WRITE "${CMAKE_CURRENT_BINARY_DIR}/${base_name_new}.hdrs" "${new_headers}" )
      list( APPEND orig_options --public-headers "${base_name_old}.hdrs" )
      list( APPEND new_options --public-headers "${base_name_new}.hdrs" )
      # list( APPEND orig_options --public-headers "${ABI_DIR}/${CMAKE_INSTALL_INCLUDEDIR}/${ARG_HEADER_DIR}" )
      # list( APPEND new_options --public-headers "${ARG_LOCAL_INCLUDE_DIR}" )
    endif( )
    cx_msg_debug_variable( ABI_DIR )
    cx_msg_debug_variable( CMAKE_INSTALL_PREFIX )
    cx_msg_debug_variable( CMAKE_INSTALL_LIBDIR )
    if ( EXISTS "${ABI_DIR}/lib/debug/${ABI_DIR}/${CMAKE_INSTALL_LIBDIR}" )
      list( APPEND orig_options "--search-debuginfo=${ABI_DIR}/lib/debug/${ABI_DIR}/${CMAKE_INSTALL_LIBDIR}" )
    endif( )
    cx_msg_debug_variable( orig_options )
    add_custom_target( abi_check_${ARG_LIBRARY}
      COMMAND ${ABI_DUMPER_PROGRAM} ${abi_full_library_name_old} -o ${base_name_old}.dump --lver 0 ${orig_options}
      COMMAND ${ABI_DUMPER_PROGRAM} ${abi_full_library_name_new} -o ${base_name_new}.dump --lver 1 ${new_options}
      ${msg_begin_command}
      COMMAND ${CMAKE_COMMAND} -E echo "Comparing ${ABI_DIR}/${CMAKE_INSTALL_LIBDIR}/$<TARGET_FILE_NAME:${ARG_LIBRARY}>"
      "to $<TARGET_FILE:${ARG_LIBRARY}>"
      COMMAND ${ABI_COMPLIANCE_CHECKER_PROGRAM} -l ${ARG_LIBRARY} -old ${base_name_old}.dump -new ${base_name_new}.dump
      ${msg_end_command}
      COMMENT "Checking ABI/API compatability between ${abi_full_library_name_new} and ${abi_full_library_name_old}"
      )
  else( )
    add_custom_target( abi_check_${ARG_LIBRARY}
      COMMAND ${CMAKE_COMMAND} -E echo "Unable to check ABI/API compatibility for ${ARG_LIBRARY} (ABI_DUMPER_PROGRAM: ${ABI_DUMPER_PROGRAM} ABI_COMPLIANCE_CHECKER_PROGRAM: ${ABI_COMPLIANCE_CHECKER_PROGRAM})"
      )
  endif( )
  add_dependencies( abi-check abi_check_${ARG_LIBRARY} )
endfunction( )
