#========================================================================
# -*- mode: cmake -*-
#------------------------------------------------------------------------

#========================================================================
# Define some functions that everyone will use
#------------------------------------------------------------------------
function(cond_set_policy POLICY_ID STATE)
  if ( POLICY ${POLICY_ID} )
    cmake_policy( SET ${POLICY_ID} ${STATE} )
  endif ( POLICY ${POLICY_ID} )
endfunction(cond_set_policy)

set( LDAS_TOOLS_BUG_REPORT_URL "https://bugs.ligo.org/redmine/projects/ldas-tools"
  CACHE INTERNAL "URL of where to submit problems" )
set( LDAS_TOOLS_HOMEPAGE_URL "https://wiki.ligo.org/DASWG/LDASTools"
  CACHE INTERNAL "Homepage URL for LDASTools" )

#========================================================================
# Basic manipulation of the search path
#------------------------------------------------------------------------

if ( CMAKE_VERSION VERSION_LESS "3.0.3" )
  if ( EXISTS "${CMAKE_SOURCE_DIR}/ModulesPre3_0" )
    set( _PATH "${CMAKE_SOURCE_DIR}/ModulesPre3_0" )
  else ( EXISTS "${CMAKE_SOURCE_DIR}/ModulesPre3_0" )
    execute_process(
      COMMAND ${PKG_CONFIG_EXECUTABLE} --variable=LDASTOOLS_CMAKE_MODULE_DIR ldastoolscmake
      OUTPUT_VARIABLE _PATH
      OUTPUT_STRIP_TRAILING_WHITESPACE)
  endif ( EXISTS "${CMAKE_SOURCE_DIR}/ModulesPre3_0" )
  list( INSERT CMAKE_MODULE_PATH 0 ${_PATH} )
  message( STATUS "Search path now set to: ${CMAKE_MODULE_PATH}" )
endif ( CMAKE_VERSION VERSION_LESS "3.0.3" )

#========================================================================
# Preload common packages
#------------------------------------------------------------------------

include( CTest )
include( GNUInstallDirs )
include( LDASToolsInstallDirs )
include( Autotools/Autotools )
include( Autotools/Archive/Archive )
include( Autotools/ArchiveX/ArchiveX )

cx_reconfigure()

enable_testing()