#------------------------------------------------------------------------
# -*- mode: cmake -*-
#    MACPORTS_CATEGORY (default: science)
#    MACPORTS_NAME     (default: ${PROJECT_NAME})
#    MACPORTS_PORT_FILE_TEMPLATE
#                      ( default: ${CMAKE_SOURCE_DIR}/config/Portfile.in )
#------------------------------------------------------------------------
include( CMakeParseArguments )

include( Autotools/ArchiveX/cx_set_variable_default )

function(cx_packaging_macports)
  #----------------------------------------------------------------------
  # Establish defaults
  #----------------------------------------------------------------------
  set(options)
  set(oneValueArgs
    MACPORTS_CATEGORY
    MACPORTS_NAME
    MACPORTS_PORT_FILE_TEMPLATE
    )
  set(multiValueArgs)
  cmake_parse_arguments(ARG "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN} )

  cx_set_variable_default( ARG_MACPORTS_CATEGORY science )
  cx_set_variable_default( ARG_MACPORTS_NAME ${PROJECT_NAME} )
  cx_set_variable_default( ARG_MACPORTS_PORT_FILE_TEMPLATE
    "${CMAKE_SOURCE_DIR}/config/Portfile.in" )

  find_program(MACPORTSBUILD port)
  find_program(MACPORTSINDEX portindex)
  if (MACPORTSBUILD)
    set( PORT_PKG_DIR "/opt/local/var/macports/distfiles/${ARG_MACPORTS_NAME}" )
    set( PORT_CONFIG "/opt/local/etc/macports/sources.conf" )
    set( PORT_TOP_DIR ${CMAKE_CURRENT_BINARY_DIR}/test_port )
    set( PORT_TEST_DIR ${PORT_TOP_DIR}/${ARG_MACPORTS_CATEGORY}/${ARG_MACPORTS_NAME} )
    add_custom_command( OUTPUT ${CMAKE_CURRENT_BINARY_DIR}/rmd160.txt
      COMMAND /bin/sh -c "openssl rmd160 \"${CMAKE_BINARY_DIR}/${CPACK_SOURCE_PACKAGE_FILE_NAME_FULL}\" | sed -e 's/^.*= //' > ${CMAKE_CURRENT_BINARY_DIR}/rmd160.txt"
      COMMENT "Calculating rmd160 value"
      VERBATIM
      )
    add_custom_command( OUTPUT ${CMAKE_CURRENT_BINARY_DIR}/sha256.txt
      COMMAND /bin/sh -c "openssl sha256 \"${CMAKE_BINARY_DIR}/${CPACK_SOURCE_PACKAGE_FILE_NAME_FULL}\" | sed -e 's/^.*= //' > ${CMAKE_CURRENT_BINARY_DIR}/sha256.txt"
      COMMENT "Calculating sha256 value"
      VERBATIM
      )
    if( PROJECT_DESCRIPTION_LONG )
      list(LENGTH PROJECT_DESCRIPTION_LONG len)
      set(pos 0)
      foreach(line ${PROJECT_DESCRIPTION_LONG})
	set(PROJECT_DESCRIPTION_LONG_${pos} "${line}")
	math(EXPR pos "${pos}+1")
      endforeach( )
    endif()
    add_custom_target( macports_portfile
    		       DEPENDS
		         dist
			 ${CMAKE_CURRENT_BINARY_DIR}/rmd160.txt
			 ${CMAKE_CURRENT_BINARY_DIR}/sha256.txt
    		       COMMAND ${CMAKE_COMMAND} -E make_directory ${CMAKE_CURRENT_BINARY_DIR}/test_port/${ARG_MACPORTS_CATEGORY}/${ARG_MACPORTS_NAME}
    		       COMMAND sed
		         -e 's,[@]RMD160[@],'`cat ${CMAKE_CURRENT_BINARY_DIR}/rmd160.txt`',g'
			 -e 's,[@]SHA256[@],'`cat ${CMAKE_CURRENT_BINARY_DIR}/sha256.txt`',g'
			 -e 's,[@]PROJECT_NAME[@],${PROJECT_NAME},g'
			 -e 's,[@]PROJECT_VERSION[@],${PROJECT_VERSION},g'
			 -e 's,[@]PROJECT_DESCRIPTION[@],${PROJECT_DESCRIPTION},g'
			 -e 's,[@]PROJECT_DESCRIPTION_LONG_0[@],${PROJECT_DESCRIPTION_LONG_0},g'
			 -e 's,[@]PROJECT_DESCRIPTION_LONG_1[@],${PROJECT_DESCRIPTION_LONG_1},g'
			 -e 's,[@]PROJECT_DESCRIPTION_LONG_2[@],${PROJECT_DESCRIPTION_LONG_2},g'
			 -e 's,[@]CPACK_SOURCE_PACKAGE_FILE_NAME_FULL[@],${CPACK_SOURCE_PACKAGE_FILE_NAME_FULL},g'
			 -e 's,[@]CPACK_SOURCE_PACKAGE_FILE_EXTENSION[@],${CPACK_SOURCE_PACKAGE_FILE_EXTENSION},g'
			 < ${ARG_MACPORTS_PORT_FILE_TEMPLATE} > ${PORT_TEST_DIR}/Portfile
    )
    add_custom_target(macports_build
		      DEPENDS macports_portfile
		      WORKING_DIRECTORY ${PORT_TEST_DIR}
		      COMMAND ${CMAKE_COMMAND} -E make_directory ${PORT_PKG_DIR}
		      COMMAND ${CMAKE_COMMAND} -E copy "${CMAKE_BINARY_DIR}/${CPACK_SOURCE_PACKAGE_FILE_NAME_FULL}" ${PORT_PKG_DIR}
		      COMMAND ${MACPORTSBUILD} lint --nitpick
		      COMMAND ${MACPORTSBUILD} uninstall
		      COMMAND ${MACPORTSBUILD} clean
		      COMMAND ${MACPORTSBUILD} install
    )
    add_custom_target(macports_index
		      DEPENDS macports_build
		      WORKING_DIRECTORY ${PORT_TOP_DIR}
		      COMMAND ${MACPORTSINDEX}
    )
    add_custom_target(macports
		      DEPENDS macports_index
    )
  else(MACPORTSBUILD)
    add_custom_target(port
		      COMMAND ${CMAKE_COMMAND} -E echo "This platform does not support building of MacPorts packages")
  endif(MACPORTSBUILD)
endfunction(cx_packaging_macports)