#------------------------------------------------------------------------
# -*- mode: cmake -*-
#------------------------------------------------------------------------
include( CMakeParseArguments )
include( CheckLibraryExists )
include( Autotools/cm_define )

function(CM_CHECK_LIB _LIBRARY _FUNCTION)
  set(options)
  set(oneValueArgs)
  set(multiValueArgs)
  cmake_parse_arguments(ARG "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN} )

  string(TOUPPER ${_LIBRARY} _LIBRARY_UPPER)
  unset( _RESULT CACHE )
  check_library_exists( ${_LIBRARY} ${_FUNCTION} "" _RESULT)
  if ( _RESULT )
    unset( _LIB CACHE )
    find_library( _LIB ${_LIBRARY} )
    if ( _LIB )
      set( LIBS ${_LIB} ${LIBS} )
      set( HAVE_LIB${_LIBRARY_UPPER} 1
	CACHE INTERNAL "Intrnal" )
    else( _LIB )
      set( _RESULT 0 )
    endif( _LIB )
  endif ( _RESULT )
  cm_define(
    VARIABLE HAVE_LIB${_LIBRARY_UPPER}
    DESCRIPTION "Define to 1 if you have `${_LIBRARY}' library (-l${_LIBRARY})"  )

  if ( _RESULT )
    set( _RESULT "yes" )
  else ( _RESULT )
    set( _RESULT "no" )
  endif ( _RESULT )
  message( STATUS "Checking if library ${_LIBRARY} contains ${_FUNCTION} ... ${_RESULT}" )

endfunction(CM_CHECK_LIB)
