#------------------------------------------------------------------------
# -*- mode: cmake -*-
#------------------------------------------------------------------------
include( CMakeParseArguments )

include( Autotools/ArchiveX/cx_msg_debug_variable )

function(cx_test_python)
  set( options )
  set( oneValueArgs
    NAME
    )
  set( multiValueArgs
    COMMAND
    )

  cmake_parse_arguments(ARG "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN} )

  # list(GET ARGN 0 cmd )
  # list(REMOVE_AT ARGN 0)

  if( WIN32 )
    set(TPATH ${NDS_LIBRARY_DIR})
  else( WIN32 )
    set(TPATH "${CMAKE_CURRENT_BINARY_DIR}:$ENV{PATH}")
  endif( WIN32 )

  cx_msg_debug_variable( ARG_NAME )
  cx_msg_debug_variable( ARG_COMMAND )

  add_test( ${ARG_NAME} "${PYTHON_EXECUTABLE}" ${ARG_COMMAND} )
  set_tests_properties( ${ARG_NAME}
    PROPERTIES
      SKIP_RETURN_CODE 77
      ENVIRONMENT
        "PYTHONPATH=${TPATH}" )

endfunction(cx_test_python)

