#------------------------------------------------------------------------
# -*- mode: cmake -*-
#------------------------------------------------------------------------
include( CMakeParseArguments )
include( GNUInstallDirs )
include( GNUPkgInstallDirs )

#function( _cx_make_convenience_library )
#  add_library(${ARG_TARGET} OBJECT ${ARG_SOURCES} )
#  set_target_properties(
#    ${ARG_TARGET}
#    PROPERTIES
#      COMPILE_FLAGS "${SHARED_FLAGS}" )
#endfunction( _cx_make_convenience_library )

#function( _cx_make_library )
#  if (NOT RUNTIME_DESTINATION)
#    #--------------------------------------------------------------------
#    # Figure out where to install libraries
#    #--------------------------------------------------------------------
#    if ( WIN32 )
#      set( RUNTIME_DESTINATION ${CMAKE_INSTALL_BINDIR} )
#    else ( WIN32 )
#      set( RUNTIME_DESTINATION ${CMAKE_INSTALL_LIBDIR} )
#    endif( WIN32 )
#  endif (NOT RUNTIME_DESTINATION)
#  if (NOT LIBRARY_DESTINATION)
#    #--------------------------------------------------------------------
#    # Figure out where to install libraries
#    #--------------------------------------------------------------------
#    set(LIBRARY_DESTINATION ${RUNTIME_DESTINATION})
#  endif (NOT LIBRARY_DESTINATION)
#  if ( ARG_LIBRARIES )
#    foreach(lib_ ${ARG_LIBRARIES})
#      if ( ${lib_} MATCHES "^[$][<]TARGET_OBJECTS:.*[>]" )
#	list(APPEND CONVENIENCE_LIBS ${lib_})
#      endif(${lib_} MATCHES "^[$][<]TARGET_OBJECTS:.*[>]" )
#    endforeach(lib_)
#    if( CONVENIENCE_LIBS )
#      list( REMOVE_ITEM ARG_LIBRARIES ${CONVENIENCE_LIBS} )
#    endif( CONVENIENCE_LIBS )
#  endif ( ARG_LIBRARIES )
    

#  add_library(${ARG_TARGET} SHARED ${ARG_SOURCES} ${CONVENIENCE_LIBS})
#
#  if ( UNIX )
#    #--------------------------------------------------------------------
#    # Calculate the versioning based on what libtool would have done
#    #--------------------------------------------------------------------
#    string( TOUPPER ${ARG_TARGET} TARGET_UPPER )
#    cx_libtool_version_calculation(
#      ${TARGET_UPPER}
#      ${ARG_CURRENT}
#      ${ARG_REVISION}
#      ${ARG_AGE} )
#    set_target_properties(
#      ${ARG_TARGET}
#      PROPERTIES
#        VERSION ${${TARGET_UPPER}_VERSION}
#        SOVERSION ${${TARGET_UPPER}_SOVERSION} )
#    if ( ARG_LIBRARIES )
#      target_link_libraries(${ARG_TARGET} ${ARG_LIBRARIES})
#    endif ( ARG_LIBRARIES )
#  endif ( UNIX )


#  message(STATUS "RUNTIME_DESTINATION: ${RUNTIME_DESTINATION}")
#  message(STATUS "LIBRARY_DESTINATION: ${LIBRARY_DESTINATION}")
#  message(STATUS "LIB_INSTALL_DIR: ${LIB_INSTALL_DIR}")

#  if ( ARG_PKG_CONFIG_FILE )
#    #--------------------------------------------------------------------
#    # Handle pkg_config file intended for library
#    #--------------------------------------------------------------------
#    string(REGEX REPLACE "[.]in$" "" pkg_config_out ${ARG_PKG_CONFIG_FILE})
#    configure_file(
#      ${CMAKE_CURRENT_SOURCE_DIR}/${ARG_PKG_CONFIG_FILE}
#      ${CMAKE_CURRENT_BINARY_DIR}/${pkg_config_out}
#      @ONLY)
#    install(
#      FILES ${CMAKE_CURRENT_BINARY_DIR}/${pkg_config_out}
#      DESTINATION "${CMAKE_INSTALL_LIBDIR}/pkgconfig")
    
#  endif ( ARG_PKG_CONFIG_FILE )
#  install(
#    TARGETS ${ARG_TARGET}
#    RUNTIME
#      DESTINATION ${RUNTIME_DESTINATION}
#      COMPONENT ${ARG_RUNTIME_COMPONENT}
#    LIBRARY
#      DESTINATION ${LIBRARY_DESTINATION}
#      COMPONENT ${ARG_LIBRARY_COMPONENT}
#    ARCHIVE
#      DESTINATION ${LIB_INSTALL_DIR}
#      COMPONENT ${ARG_ARCHIVE_COMPONENT})
#endfunction( _cx_make_library )


function( cx_target_executable target )
  set(options
    NOINST
    )
  set(oneValueArgs
    INSTALL_DIR
    )
  set(multiValueArgs
    SOURCES
    LDADD
    )
  cmake_parse_arguments(ARG "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN} )

  add_executable( ${target} ${ARG_SOURCES} )
  if ( NOT "x${ARG_LDADD}" STREQUAL "x" )
    target_link_libraries( ${target} ${ARG_LDADD} )
  endif ( )
  if ( NOT ARG_NOINST )
    if ( "x${ARG_INSTALL_DIR}" STREQUAL "x" )
      set( ARG_INSTALL_DIR ${CMAKE_INSTALL_BINDIR} )
    endif( )
    install( TARGETS ${target}
      RUNTIME
        DESTINATION ${ARG_INSTALL_DIR} )
  endif( )

endfunction( )