# -*- conding: utf-8; cmake-tab-width: 4; indent-tabs-mode: nil; -*- vim:fenc=utf-8:ft=tcl:et:sw=4:ts=4:sts=4
include( CMakeParseArguments )

include( Autotools/ArchiveX/cx_msg_debug )

function( cx_ctest_add_python_test )
    set(options
        )
    set(oneValueArgs
        PYTHON_EXECUTABLE
        PYTHON_MODULE_DIR
        TARGET )
    set(multiValueArgs
        COMMAND
        DEPENDS
        PYTHON_PATH )
    cmake_parse_arguments(ARG "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN} )

    if ( NOT ARG_PYTHON_EXECUTABLE )
        set( ARG_PYTHON_EXECUTABLE ${PYTHON_EXECUTABLE} )
    endif( )
    if( WIN32 )
        if ( ARG_PYTHON_PATH )
            set( TPATH ${ARG_PYTHON_PATH} )
        endif( )
        if ( ARG_PYTHON_MODULE_DIR )
            set( TPATH "${ARG_PYTHON_MODULE_DIR};${TPATH}" )
        endif( )
    else( WIN32 )
        set( TPATH "$ENV{PATH}" )
        if ( ARG_PYTHON_PATH )
            string( REPLACE ";" ":" ARG_PYTHON_PATH "${ARG_PYTHON_PATH}" )
            set( TPATH "${ARG_PYTHON_PATH}:${TPATH}" )
        endif( )
        if ( ARG_PYTHON_MODULE_DIR )
            set( TPATH "${ARG_PYTHON_MODULE_DIR}:${TPATH}" )
        endif( )
    endif( WIN32 )

    add_test(
        ${ARG_TARGET} 
        "${ARG_PYTHON_EXECUTABLE}"
        ${ARG_COMMAND}
        )
    set_tests_properties( ${ARG_TARGET}
        PROPERTIES
        ENVIRONMENT "PYTHONPATH=${TPATH};PYTHON=${ARG_PYTHON_EXECUTABLE}"
        SKIP_RETURN_CODE 77 )
    message( STATUS "/usr/bin/env PYTHONPATH=${TPATH} PYTHON=${ARG_PYTHON_EXECUTABLE} ${ARG_PYTHON_EXECUTABLE} ${ARG_COMMAND}" )
    if ( ARG_DEPENDS )
        set_tests_properties( ${ARG_TARGET}
            PROPERTIES
                DEPENDS ${ARG_DEPENDS}
                )
    endif( )
endfunction( )
