# -*- mode: cmake -*-
# ---------------------------------------------------------------------
#  AX_CHECK_PTHREAD_READ_WRITE_LOCK
#     Check if C++ supports templates as parameters to templates
# ---------------------------------------------------------------------
include( Autotools/ArchiveX/cm_check_headers )
include( Autotools/ArchiveX/cm_try_compile )

function( cx_check_pthread_read_write_lock )
  cm_check_headers("pthread.h")
  set(inc "
#if HAVE_PTHREAD_H
#include <pthread.h>
#endif /* HAVE_PTHREAD_H */
")

  set(body "
   pthread_rwlock_t l;
   pthread_rwlock_init( &l, (pthread_rwlockattr_t*)NULL );
")

  cm_try_compile("${inc}" "${body}" HAVE_PTHREAD_RW_LOCK
    DEFINES -DHAVE_PTHREAD_H=${HAVE_PTHREAD_H})
  if(HAVE_PTHREAD_RW_LOCK)
    set(result_var "yes")
  else(HAVE_PTHREAD_RW_LOCK)
    set(result_var "no")
  endif(HAVE_PTHREAD_RW_LOCK)
  cm_define(
    VARIABLE HAVE_PTHREAD_RW_LOCK
    DESCRIPTION "Defined if pthread read/write locks supported" )
  message( STATUS "Checking if pthread library has read/write locks ... ${result_var}")
endfunction( cx_check_pthread_read_write_lock )
