# -*- mode: cmake -*-
#------------------------------------------------------------------------
# Simulate the CM_TRY_COMPILE macro
#------------------------------------------------------------------------
include( CMakeParseArguments )

function(cm_try_compile ARG_INCLUDE ARG_BODY ARG_VARIABLE )
  set(options)
  set(oneValueArgs)
  set(multiValueArgs DEFINES)
  cmake_parse_arguments(ARG "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN} )

  set(fn "${CMAKE_CURRENT_BINARY_DIR}/${ARG_VARIABLE}.cc")
  file(REMOVE ${fn})
  file(APPEND ${fn} "${ARG_INCLUDE}")
  file(APPEND ${fn} "int main() {\n")
  file(APPEND ${fn} "${ARG_BODY}")
  file(APPEND ${fn} "return 0;\n")
  file(APPEND ${fn} "}\n")
  try_compile(${ARG_VARIABLE} ${CMAKE_CURRENT_BINARY_DIR}
	      ${fn}
	      COMPILE_DEFINITIONS ${ARG_DEFINES})
  if(${ARG_VARIABLE})
    set(${ARG_VARIABLE} 1 PARENT_SCOPE)
  else(${ARG_VARIABLE})
    set(${ARG_VARIABLE} 0 PARENT_SCOPE)
  endif(${ARG_VARIABLE})
endfunction(cm_try_compile)
