
import sys
from ldaptor.protocols.ldap import ldapclient, ldif, ldapsyntax, ldapconnector
from ldaptor.protocols import pureber, pureldap
from ldaptor import usage, ldapfilter, config
from twisted.internet import protocol, reactor, defer

def printResults(o):
    sys.stdout.write(str(o))

def search(client, baseDN, filter_text, attributes):
    o=ldapsyntax.LDAPEntry(client=client, dn=baseDN)
    d=o.search(filterText=filter_text,
               attributes=attributes,
               callback=printResults)
    return d

exitStatus=0

def error(fail):
    print >>sys.stderr, 'fail:', fail.getErrorMessage()
    global exitStatus
    exitStatus=1

def main(cfg, filter_text, attributes):
    try:
        baseDN = cfg.getBaseDN()
    except config.MissingBaseDNError, e:
        print >>sys.stderr, "%s: %s." % (sys.argv[0], e)
        sys.exit(1)

    c = ldapconnector.LDAPClientCreator(reactor,
                                        ldapclient.LDAPClient)
    d = c.connectAnonymously(dn=baseDN,
                             overrides=cfg.getServiceLocationOverrides())
    d.addCallback(search, baseDN, filter_text, attributes)
    d.addErrback(error)
    d.addBoth(lambda x: reactor.stop())

    reactor.run()
    sys.exit(exitStatus)

class MyOptions(usage.Options, usage.Options_service_location, usage.Options_base_optional):
    """LDAPtor command line search utility"""

    def parseArgs(self, filter, *attributes):
        self.opts['filter'] = filter
        self.opts['attributes'] = attributes

if __name__ == "__main__":
    try:
        opts = MyOptions()
        opts.parseOptions()
    except usage.UsageError, ue:
        sys.stderr.write('%s: %s\n' % (sys.argv[0], ue))
        sys.exit(1)

    cfg = config.LDAPConfig(baseDN=opts['base'],
                            serviceLocationOverrides=opts['service-location'])
    main(cfg,
         opts['filter'],
         opts['attributes'])
