
import sys
from ldaptor.protocols.ldap import ldapclient, ldapsyntax, ldapconnector
from ldaptor import usage, numberalloc, config
from twisted.internet import reactor

exitStatus=0

def error(fail):
    print fail
    print >>sys.stderr, 'fail:', fail.getErrorMessage()
    global exitStatus
    exitStatus=1

def main(cfg):
    try:
        baseDN = cfg.getBaseDN()
    except config.MissingBaseDNError, e:
        print >>sys.stderr, "%s: %s." % (sys.argv[0], e)
        sys.exit(1)

    c = ldapconnector.LDAPClientCreator(reactor,
                                        ldapclient.LDAPClient)
    d= c.connectAnonymously(dn=baseDN,
                            overrides=cfg.getServiceLocationOverrides())
    def _cbBound(client, baseDN):
        o=ldapsyntax.LDAPEntry(client=client, dn=baseDN)
        return numberalloc.getFreeNumber(o,
                                         'uidNumber',
                                         min=1000)
    d.addCallback(_cbBound, baseDN)
    d.addCallback(lambda num: sys.stdout.write('%s\n' % repr(num)))
    d.addErrback(error)
    d.addBoth(lambda x: reactor.stop())

    reactor.run()
    sys.exit(exitStatus)

class MyOptions(usage.Options, usage.Options_service_location, usage.Options_base_optional):
    """LDAPtor command line search utility"""

if __name__ == "__main__":
    from twisted.python import log
    log.startLogging(sys.stderr, setStdout=0)

    try:
        opts = MyOptions()
        opts.parseOptions()
    except usage.UsageError, ue:
        sys.stderr.write('%s: %s\n' % (sys.argv[0], ue))
        sys.exit(1)

    cfg = config.LDAPConfig(
        baseDN=opts['base'],
        serviceLocationOverrides=opts['service-location'])
    main(cfg)
