def example(extract='m', estimate=False):
    import larch.numba as lx
    m = lx.example(17)

    shared = m.graph.new_node(parameter='mu_shared', children=[2,3], name='Shared')
    motorized = m.graph.new_node(parameter='mu_moto', children=[1,shared,4], name='Motorized')
    nonmotorized= m.graph.new_node(parameter='mu_nonmoto', children=[5,6], name='Nonmotorized')

    m.ordering = (
        ("CostbyInc","costbyincome",),
        ("TravelTime",".*time.*",".*dist.*", ),
        ("Household","hhinc.*","vehbywrk.*",),
        ("Zonal","wkcbd.*","wkempden.*",),
        ("ASCs","ASC.*",),
    )
    if not estimate:
        if isinstance(extract, str):
            return locals()[extract]
        else:
            _locals = locals()
            return [_locals.get(i) for i in extract]
    m.maximize_loglike()

    m.calculate_parameter_covariance()
    m.parameter_summary()
    if isinstance(extract, str):
        return locals()[extract]
    else:
        _locals = locals()
        return [_locals.get(i) for i in extract]
