def example(extract='m', estimate=False):
    import larch.numba as lx
    m = lx.example(17)

    motorized = m.graph.new_node(parameter='mu_motor', children=[1,2,3,4], name='Motorized')
    nonmotorized = m.graph.new_node(parameter='mu_nonmotor', children=[5,6], name='Nonmotorized')

    m.ordering = (
        ("CostbyInc","costbyincome",),
        ("TravelTime",".*time.*",".*dist.*", ),
        ("Household","hhinc.*","vehbywrk.*",),
        ("Zonal","wkcbd.*","wkempden.*",),
        ("ASCs","ASC.*",),
    )

    m.loglike()
    if not estimate:
        if isinstance(extract, str):
            return locals()[extract]
        else:
            _locals = locals()
            return [_locals.get(i) for i in extract]
    m.maximize_loglike()

    m.calculate_parameter_covariance()
    m.parameter_summary()
    if isinstance(extract, str):
        return locals()[extract]
    else:
        _locals = locals()
        return [_locals.get(i) for i in extract]
