def example(extract='m', estimate=False):
    import larch.numba as lx
    d = lx.examples.MTC(format='dataset')

    d1 = d.dc.query_cases("numveh <= 1")
    d2 = d.dc.query_cases("numveh > 1")
    m1 = lx.Model(d1, title="Cars<=1")
    m2 = lx.Model(d2, title="Cars>=2")

    from larch import P, X

    for m in (m1,m2):
        m.availability_var = 'avail'
        m.choice_ca_var = 'chose'
        m.utility_ca = (
            + X("totcost/hhinc") * P("costbyincome")
            + X("tottime * (altnum <= 4)") * P("motorized_time")
            + X("tottime * (altnum >= 5)") * P("nonmotorized_time")
            + X("ovtt/dist * (altnum <= 4)") * P("motorized_ovtbydist")
        )
        for a in [4,5,6]:
            m.utility_co[a] += X("hhinc") * P("hhinc#{}".format(a))
        for i in d['alt_names'][1:3]:
            name = str(i.values)
            a = int(i.altid)
            m.utility_co[a] += (
                + X("vehbywrk") * P("vehbywrk_SR")
                + X("wkccbd+wknccbd") * P("wkcbd_"+name)
                + X("wkempden") * P("wkempden_"+name)
                + P("ASC_"+name)
            )
        for i in d['alt_names'][3:]:
            name = str(i.values)
            a = int(i.altid)
            m.utility_co[a] += (
                + X("vehbywrk") * P("vehbywrk_"+name)
                + X("wkccbd+wknccbd") * P("wkcbd_"+name)
                + X("wkempden") * P("wkempden_"+name)
                + P("ASC_"+name)
            ) 
        m.ordering = (
            ('LOS', ".*cost.*", ".*time.*", ".*dist.*",),
            ('Zonal', "wkcbd.*", "wkempden.*",),
            ('Household', "hhinc.*", "vehbywrk.*",),
            ('ASCs', "ASC.*",),
        )
    if not estimate:
        if isinstance(extract, str):
            return locals()[extract]
        else:
            _locals = locals()
            return [_locals.get(i) for i in extract]
    r1 = m1.maximize_loglike()
    r2 = m2.maximize_loglike()

    for m in (m1,m2):
        m.calculate_parameter_covariance()
        m.loglike_null()

    from larch.util.summary import joint_parameter_summary
    joint_parameter_summary([m1,m2])

    m2.utility_ca = m2.utility_ca.reformat_param('{}_2Cars')

    for a in m2.utility_co:
        m2.utility_co[a] = m2.utility_co[a].reformat_param(
            pattern='(ASC)', repl='ASC_2Cars'
        )

    mg = lx.ModelGroup([m1,m2])

    mg.set_cap()
    rg = mg.maximize_loglike()
    mg.calculate_parameter_covariance()

    rg

    mg.ordering = (
        ('LOS', ".*cost.*", ".*time.*", ".*dist.*",),
        ('Zonal', "wkcbd.*", "wkempden.*",),
        ('Household', "hhinc.*", "vehbywrk.*",),
        ('ASCs', "ASC.*",),
    )
    mg.parameter_summary()

    mg.estimation_statistics()
    if isinstance(extract, str):
        return locals()[extract]
    else:
        _locals = locals()
        return [_locals.get(i) for i in extract]
