def example(extract='m', estimate=False):
    import larch.numba as lx
    from larch import P, X, PX

    d = lx.examples.MTC(format='dataset')
    m = lx.Model(d)
    m.title = "MTC Example 2, Motorized"

    m.utility_co[2] = P("ASC_SR2")  + P("hhinc#Moto") * X("hhinc") # ←
    m.utility_co[3] = P("ASC_SR3P") + P("hhinc#Moto") * X("hhinc") # ← Note same P("hhinc#Moto")
    m.utility_co[4] = P("ASC_TRAN") + P("hhinc#Moto") * X("hhinc") # ←
    m.utility_co[5] = P("ASC_BIKE") + P("hhinc#5") * X("hhinc")
    m.utility_co[6] = P("ASC_WALK") + P("hhinc#6") * X("hhinc")

    m.utility_ca = PX("tottime") + PX("totcost")

    m.availability_var = 'avail'
    m.choice_ca_var = 'chose'

    m.ordering = (
        ("LOS", "totcost", "tottime", ),
        ("Income", "hhinc.*", ),
        ("ASCs", "ASC.*", ),
    )
    if not estimate:
        if isinstance(extract, str):
            return locals()[extract]
        else:
            _locals = locals()
            return [_locals.get(i) for i in extract]
    m.maximize_loglike()

    m.calculate_parameter_covariance()

    m.parameter_summary()
    if isinstance(extract, str):
        return locals()[extract]
    else:
        _locals = locals()
        return [_locals.get(i) for i in extract]
