def example(extract='m', estimate=False):
    import os, gzip
    import numpy as np, pandas as pd, xarray as xr
    import larch.numba as lx

    df = pd.read_csv(lx.example_file("MTCwork.csv.gz"), index_col=['casenum','altnum'])

    df.head(15)

    ds = lx.Dataset.construct.from_idca(df)
    ds

    ds = ds.dc.set_altnames({
        1:'DA', 2:'SR2', 3:'SR3+', 4:'Transit', 5:'Bike', 6:'Walk',
    })
    ds
    if not estimate:
        if isinstance(extract, str):
            return locals()[extract]
        else:
            _locals = locals()
            return [_locals.get(i) for i in extract]

    if isinstance(extract, str):
        return locals()[extract]
    else:
        _locals = locals()
        return [_locals.get(i) for i in extract]
