def example(extract='m', estimate=False):
    import larch.numba as lx

    d = lx.Dataset.from_idce(
        pd.read_csv(lx.example_file("arc"), index_col=['id_case','id_alt']),
    )

    m = lx.Model(datatree=d)

    v = [
        "timeperiod==2",
        "timeperiod==3",
        "timeperiod==4",
        "timeperiod==5",
        "timeperiod==6",
        "timeperiod==7",
        "timeperiod==8",
        "timeperiod==9",
        "carrier==2",
        "carrier==3",
        "carrier==4",
        "carrier==5",
        "equipment==2",
        "fare_hy",    
        "fare_ly",    
        "elapsed_time",  
        "nb_cnxs",       
    ]


    from larch.roles import PX
    m.utility_ca = sum(PX(i) for i in v)
    m.choice_ca_var = 'choice'
    m.availability_var = 1
    if not estimate:
        if isinstance(extract, str):
            return locals()[extract]
        else:
            _locals = locals()
            return [_locals.get(i) for i in extract]
    m.maximize_loglike()
    if isinstance(extract, str):
        return locals()[extract]
    else:
        _locals = locals()
        return [_locals.get(i) for i in extract]
