def example(extract='m', estimate=False):
    import pandas as pd
    import larch.numba as lx

    raw_data = pd.read_csv(lx.example_file('swissmetro.csv.gz')).rename_axis(index='CASEID')
    data = lx.Dataset.from_idco(raw_data, alts={1:'Train', 2:'SM', 3:'Car'})
    data

    m = lx.Model(data.query_cases("PURPOSE in (1,3) and CHOICE != 0"))

    m.title = "swissmetro example 02 (weighted logit)"

    m.availability_co_vars = {
        1: "TRAIN_AV * (SP!=0)",
        2: "SM_AV",
        3: "CAR_AV * (SP!=0)",
    }
    m.choice_co_code = 'CHOICE'

    m.weight_co_var = "1.0*(GROUP==2)+1.2*(GROUP==3)"

    from larch.roles import P,X
    m.utility_co[1] = P("ASC_TRAIN")
    m.utility_co[2] = 0
    m.utility_co[3] = P("ASC_CAR")
    m.utility_co[1] += X("TRAIN_TT") * P("B_TIME")
    m.utility_co[2] += X("SM_TT") * P("B_TIME")
    m.utility_co[3] += X("CAR_TT") * P("B_TIME")
    m.utility_co[1] += X("TRAIN_CO*(GA==0)") * P("B_COST")
    m.utility_co[2] += X("SM_CO*(GA==0)") * P("B_COST")
    m.utility_co[3] += X("CAR_CO") * P("B_COST")

    m.ordering = [
        ("ASCs", 'ASC.*',),
        ("LOS", 'B_.*',),
    ]
    if not estimate:
        if isinstance(extract, str):
            return locals()[extract]
        else:
            _locals = locals()
            return [_locals.get(i) for i in extract]
    m.set_cap(15)
    m.maximize_loglike(method='SLSQP')

    m.calculate_parameter_covariance()
    m.parameter_summary()

    # TEST
    assert m.parameter_summary().data.to_markdown() == '''
    |                       |   Value |   Std Err |   t Stat | Signif   |   Null Value |
    |:----------------------|--------:|----------:|---------:|:---------|-------------:|
    | ('ASCs', 'ASC_CAR')   | -0.114  |  0.0407   |    -2.81 | **       |            0 |
    | ('ASCs', 'ASC_TRAIN') | -0.757  |  0.0528   |   -14.32 | ***      |            0 |
    | ('LOS', 'B_COST')     | -0.0112 |  0.00049  |   -22.83 | ***      |            0 |
    | ('LOS', 'B_TIME')     | -0.0132 |  0.000537 |   -24.62 | ***      |            0 |
    '''[1:-1]
    if isinstance(extract, str):
        return locals()[extract]
    else:
        _locals = locals()
        return [_locals.get(i) for i in extract]
