def example(extract='m', estimate=False):
    import larch.numba as lx

    m = lx.Model()

    m.title = "swissmetro example 01 (simple logit)"

    m.availability_co_vars = {
        1: "TRAIN_AV * (SP!=0)",
        2: "SM_AV",
        3: "CAR_AV * (SP!=0)",
    }

    m.choice_co_code = 'CHOICE'

    from larch.roles import P,X
    m.utility_co[1] = P("ASC_TRAIN")
    m.utility_co[2] = 0
    m.utility_co[3] = P("ASC_CAR")
    m.utility_co[1] += X("TRAIN_TT") * P("B_TIME")
    m.utility_co[2] += X("SM_TT") * P("B_TIME")
    m.utility_co[3] += X("CAR_TT") * P("B_TIME")
    m.utility_co[1] += X("TRAIN_CO*(GA==0)") * P("B_COST")
    m.utility_co[2] += X("SM_CO*(GA==0)") * P("B_COST")
    m.utility_co[3] += X("CAR_CO") * P("B_COST")

    m.ordering = [
        ("ASCs", 'ASC.*',),
        ("LOS", 'B_.*',),
    ]

    import pandas as pd
    raw_data = pd.read_csv(lx.example_file('swissmetro.csv.gz')).rename_axis(index='CASEID')
    raw_data.head()

    keep = raw_data.eval("PURPOSE in (1,3) and CHOICE != 0")
    selected_data = raw_data[keep]

    ds = lx.Dataset.from_idco(selected_data, alts={1:'Train', 2:'SM', 3:'Car'})

    ds

    m.datatree = ds
    if not estimate:
        if isinstance(extract, str):
            return locals()[extract]
        else:
            _locals = locals()
            return [_locals.get(i) for i in extract]
    m.set_cap(15)
    m.maximize_loglike(method='SLSQP')

    m.calculate_parameter_covariance()

    m.parameter_summary()

    # TEST
    assert m.parameter_summary().data.to_markdown() == """
    |                       |   Value |   Std Err |   t Stat | Signif   |   Null Value |
    |:----------------------|--------:|----------:|---------:|:---------|-------------:|
    | ('ASCs', 'ASC_CAR')   | -0.155  |  0.0432   |    -3.58 | ***      |            0 |
    | ('ASCs', 'ASC_TRAIN') | -0.701  |  0.0549   |   -12.78 | ***      |            0 |
    | ('LOS', 'B_COST')     | -0.0108 |  0.000518 |   -20.91 | ***      |            0 |
    | ('LOS', 'B_TIME')     | -0.0128 |  0.000569 |   -22.46 | ***      |            0 |
    """[1:-1]
    if isinstance(extract, str):
        return locals()[extract]
    else:
        _locals = locals()
        return [_locals.get(i) for i in extract]
