def example(extract='m', estimate=False):
    import larch.numba as lx
    d = lx.examples.MTC(format='dataset')
    m = lx.Model(d)

    m.availability_var = 'avail'
    m.choice_ca_var = 'chose'

    from larch.roles import P, X

    m.utility_ca = (
        + X("totcost/hhinc") * P("costbyincome")
        + X("tottime * (altnum <= 4)") * P("motorized_time")
        + X("tottime * (altnum >= 5)") * P("nonmotorized_time")
        + X("ovtt/dist * (altnum <= 4)") * P("motorized_ovtbydist")
    )

    for a in [4,5,6]:
        m.utility_co[a] += X("hhinc") * P("hhinc#{}".format(a))

    for i in d['alt_names'][1:3]:
        name = str(i.values)
        a = int(i.altid)
        m.utility_co[a] += (
            + X("vehbywrk") * P("vehbywrk_SR")
            + X("wkccbd+wknccbd") * P("wkcbd_"+name)
            + X("wkempden") * P("wkempden_"+name)
            + P("ASC_"+name)
        )

    for i in d['alt_names'][3:]:
        name = str(i.values)
        a = int(i.altid)
        m.utility_co[a] += (
            + X("vehbywrk") * P("vehbywrk_"+name)
            + X("wkccbd+wknccbd") * P("wkcbd_"+name)
            + X("wkempden") * P("wkempden_"+name)
            + P("ASC_"+name)
        )

    m.ordering = (
        ('LOS', ".*cost.*", ".*time.*", ".*dist.*",),
        ('Zonal', "wkcbd.*", "wkempden.*",),
        ('Household', "hhinc.*", "vehbywrk.*",),
        ('ASCs', "ASC.*",),
    )
    if not estimate:
        if isinstance(extract, str):
            return locals()[extract]
        else:
            _locals = locals()
            return [_locals.get(i) for i in extract]
    m.maximize_loglike()

    m.calculate_parameter_covariance()
    m.parameter_summary()
    if isinstance(extract, str):
        return locals()[extract]
    else:
        _locals = locals()
        return [_locals.get(i) for i in extract]
