def example(extract='m', estimate=False):
    import larch.numba as lx
    d = lx.examples.MTC(format='dataset')

    d1 = d.query_cases("numveh <= 1")
    d2 = d.query_cases("numveh > 1")
    m1 = lx.Model(d1, title="Cars<=1")
    m2 = lx.Model(d2, title="Cars>=2")

    from larch import P, X

    for m in (m1,m2):
        m.availability_var = 'avail'
        m.choice_ca_var = 'chose'
        m.utility_ca = (
            + X("totcost/hhinc") * P("costbyincome")
            + X("tottime * (altnum <= 4)") * P("motorized_time")
            + X("tottime * (altnum >= 5)") * P("nonmotorized_time")
            + X("ovtt/dist * (altnum <= 4)") * P("motorized_ovtbydist")
        )
        for a in [4,5,6]:
            m.utility_co[a] += X("hhinc") * P("hhinc#{}".format(a))
        for i in d['alt_names'][1:3]:
            name = str(i.values)
            a = int(i.altid)
            m.utility_co[a] += (
                + X("vehbywrk") * P("vehbywrk_SR")
                + X("wkccbd+wknccbd") * P("wkcbd_"+name)
                + X("wkempden") * P("wkempden_"+name)
                + P("ASC_"+name)
            )
        for i in d['alt_names'][3:]:
            name = str(i.values)
            a = int(i.altid)
            m.utility_co[a] += (
                + X("vehbywrk") * P("vehbywrk_"+name)
                + X("wkccbd+wknccbd") * P("wkcbd_"+name)
                + X("wkempden") * P("wkempden_"+name)
                + P("ASC_"+name)
            ) 
        m.ordering = (
            ('LOS', ".*cost.*", ".*time.*", ".*dist.*",),
            ('Zonal', "wkcbd.*", "wkempden.*",),
            ('Household', "hhinc.*", "vehbywrk.*",),
            ('ASCs', "ASC.*",),
        )
    if not estimate:
        if isinstance(extract, str):
            return locals()[extract]
        else:
            _locals = locals()
            return [_locals.get(i) for i in extract]
    r1 = m1.maximize_loglike()
    r2 = m2.maximize_loglike()

    for m in (m1,m2):
        m.calculate_parameter_covariance()
        m.loglike_null()

    from larch.util.summary import joint_parameter_summary
    joint_parameter_summary([m1,m2])

    m2.utility_ca = m2.utility_ca.reformat_param('{}_2Cars')

    for a in m2.utility_co:
        m2.utility_co[a] = m2.utility_co[a].reformat_param(
            pattern='(ASC)', repl='ASC_2Cars'
        )

    mg = lx.ModelGroup([m1,m2])

    # TEST
    assert mg.loglike('null') == approx(-7309.600971749634)

    mg.set_cap()
    rg = mg.maximize_loglike()
    mg.calculate_parameter_covariance()

    rg

    # TEST
    assert rg.loglike == approx(-3406.7232213364787)
    assert rg.n_cases == 5029

    mg.ordering = (
        ('LOS', ".*cost.*", ".*time.*", ".*dist.*",),
        ('Zonal', "wkcbd.*", "wkempden.*",),
        ('Household', "hhinc.*", "vehbywrk.*",),
        ('ASCs', "ASC.*",),
    )
    mg.parameter_summary()

    # TEST
    import re
    mash = lambda x: re.sub('\\s+', ' ', str(x)).strip()
    assert mash(mg.parameter_summary().data) == mash('''
                                            Value    Std Err  t Stat Signif  Null Value
    Category  Parameter                                                                
    LOS       costbyincome                -0.0174     0.0117   -1.49                0.0
              costbyincome_2Cars           -0.102     0.0154   -6.60    ***         0.0
              motorized_time              -0.0196    0.00567   -3.46    ***         0.0
              motorized_time_2Cars        -0.0195    0.00496   -3.94    ***         0.0
              nonmotorized_time           -0.0442    0.00776   -5.69    ***         0.0
              nonmotorized_time_2Cars     -0.0471    0.00868   -5.43    ***         0.0
              motorized_ovtbydist          -0.100     0.0237   -4.23    ***         0.0
              motorized_ovtbydist_2Cars    -0.187     0.0309   -6.05    ***         0.0
    Zonal     wkcbd_Bike                    0.460      0.364    1.27                0.0
              wkcbd_SR2                     0.233      0.124    1.88                0.0
              wkcbd_SR3+                     1.04      0.192    5.42    ***         0.0
              wkcbd_Transit                  1.27      0.168    7.53    ***         0.0
              wkcbd_Walk                    0.100      0.250    0.40                0.0
              wkempden_Bike               0.00137    0.00124    1.11                0.0
              wkempden_SR2                0.00132   0.000392    3.36    ***         0.0
              wkempden_SR3+               0.00184   0.000461    3.99    ***         0.0
              wkempden_Transit            0.00274   0.000358    7.64    ***         0.0
              wkempden_Walk               0.00248   0.000730    3.39    ***         0.0
    Household hhinc#4                    -0.00101    0.00208   -0.48                0.0
              hhinc#5                    -0.00366    0.00527   -0.70                0.0
              hhinc#6                    -0.00232    0.00331   -0.70                0.0
              vehbywrk_Bike                -0.255      0.290   -0.88                0.0
              vehbywrk_SR                  -0.314     0.0740   -4.24    ***         0.0
              vehbywrk_Transit             -0.638      0.132   -4.82    ***         0.0
              vehbywrk_Walk                -0.395      0.198   -1.99      *         0.0
    ASCs      ASC_2Cars_Bike                -2.94      0.629   -4.67    ***         0.0
              ASC_2Cars_SR2                 -1.91      0.127  -15.06    ***         0.0
              ASC_2Cars_SR3+                -3.53      0.173  -20.43    ***         0.0
              ASC_2Cars_Transit             -1.47      0.320   -4.60    ***         0.0
              ASC_2Cars_Walk                -1.00      0.517   -1.94                0.0
              ASC_Bike                      -1.39      0.439   -3.17     **         0.0
              ASC_SR2                       -1.58      0.126  -12.57    ***         0.0
              ASC_SR3+                      -3.26      0.206  -15.84    ***         0.0
              ASC_Transit                  -0.747      0.271   -2.76     **         0.0
              ASC_Walk                      0.314      0.416    0.75                0.0
    ''')

    mg.estimation_statistics()
    if isinstance(extract, str):
        return locals()[extract]
    else:
        _locals = locals()
        return [_locals.get(i) for i in extract]
