# NetworkSedimentTransporter: move sediment parcels in a river network.

The NetworkSedimentTransporter is a lagrangian model for sediment transport on a river network. This component is the subject of a forthcoming Journal of Open Source Software submission.

## Documentation and installation

Landlab documentation is hosted on this [ReadTheDocs page](https://landlab.readthedocs.io/en/release),
including instructions to install Landlab. NetworkSedimentTransporter is installed with
Landlab.

NetworkSedimentTransporter documentation is located [here](https://landlab.readthedocs.io/en/master/reference/components/network_sediment_transporter.html).

## NetworkSedimentTransporter tutorial

Three tutorials exist on NetworkSedimentTransporter. They are Jupyter notebooks accessible in the Landlab notebooks. The following are links to Binder instances of the notebooks. If instead you want to run the notebooks locally, you can clone the landlab repository and find them in the directory `landlab/notebooks/tutorials/network_sediment_transporter`.

- [Part  1: Introduction with a synthetic network](https://mybinder.org/v2/gh/landlab/landlab/release?filepath=notebooks/tutorials/network_sediment_transporter/network_sediment_transporter.ipynb)
- [Part  2: Using a shapefile-based river network](https://mybinder.org/v2/gh/landlab/landlab/release?filepath=notebooks/tutorials/network_sediment_transporter/network_sediment_transporter_shapefile_network.ipynb)
- [Part  3: Plotting options](https://mybinder.org/v2/gh/landlab/landlab/release?filepath=notebooks/tutorials/network_sediment_transporter/network_plotting_examples.ipynb)

The index of all Landlab tutorials on Binder can bee found [here](https://mybinder.org/v2/gh/landlab/landlab/release?filepath=notebooks/welcome.ipynb) using Binder.

## Get or give help

[Open an Issue here](https://github.com/landlab/landlab/issues) where we can
respond to your questions, comments, issues, ideas, or any identified bugs
related to Landlab including NetworkSedimentTransporter.
