# SpeciesEvolver: evolve life in simulated landscapes

[![status](https://joss.theoj.org/papers/446f3d17d642682b234ffed2b53198f6/status.svg)](https://joss.theoj.org/papers/446f3d17d642682b234ffed2b53198f6)

Life evolves alongside landscapes by biotic and abiotic processes under complex
dynamics at Earth's surface. Researchers who wish to explore these dynamics can
use this component as a tool for them to build landscape-life evolution models.
Landlab components, including SpeciesEvolver are designed to work with a shared
model grid. Researchers can build novel models using plug-and-play surface
process components to evolve the grid's landscape alongside the life tracked by
SpeciesEvolver. The simulated life evolves following customizable processes.

SpeciesEvolver is introduced [in this paper](https://doi.org/10.21105/joss.02066)
published February 2020 by the Journal of Open Source Software.

## Documentation and installation

Landlab documentation is hosted on this [ReadTheDocs page](https://landlab.readthedocs.io/en/release),
including instructions to install Landlab. SpeciesEvolver is installed with
Landlab.

SpeciesEvolver documentation is located [here](https://landlab.readthedocs.io/en/release/reference/components/species_evolution.html).

## SpeciesEvolver tutorial

A SpeciesEvolver tutorial exists in the form of a Jupyter Notebook accessible
through the following links:
- [Launch the tutorial](https://mybinder.org/v2/gh/landlab/landlab/release?filepath=notebooks/tutorials/species_evolution/Introduction_to_SpeciesEvolver.ipynb)
as interactive notebook in your browser, with no need to install software,
launched using Binder.
- [A static version of the same tutorial](https://nbviewer.jupyter.org/github/landlab/landlab/blob/master/notebooks/tutorials/species_evolution/Introduction_to_SpeciesEvolver.ipynb)
- All Landlab tutorials can be launched from [this directory](https://mybinder.org/v2/gh/landlab/landlab/release?filepath=notebooks/welcome.ipynb) using Binder.

## Get or give help

[Open an Issue here](https://github.com/landlab/landlab/issues) where we can
respond to your questions, comments, issues, ideas, or any identified bugs
related to Landlab including SpeciesEvolver.
