# Copyright 2011-2017 Kwant authors.
#
# This file is part of Kwant.  It is subject to the license terms in the file
# LICENSE.rst found in the top-level directory of this distribution and at
# http://kwant-project.org/license.  A list of Kwant authors can be found in
# the file AUTHORS.rst at the top-level directory of this distribution and at
# http://kwant-project.org/authors.

import numpy as np
from matplotlib.colors import ListedColormap


kr_data = [[ 0.98916316, 0.98474381, 0.99210697],
           [ 0.98723538, 0.98138853, 0.98740721],
           [ 0.98524761, 0.97805594, 0.98280815],
           [ 0.98323731, 0.97473672, 0.97825805],
           [ 0.98120432, 0.97143086, 0.97375773],
           [ 0.97914854, 0.96813832, 0.96930811],
           [ 0.97707118, 0.9648587 , 0.96490859],
           [ 0.97496489, 0.96159373, 0.96057068],
           [ 0.97282361, 0.95834495, 0.95630336],
           [ 0.9706266 , 0.95511878, 0.95212518],
           [ 0.96829617, 0.95194965, 0.94800577],
           [ 0.96603689, 0.94881665, 0.94335712],
           [ 0.9642474 , 0.94554816, 0.93828198],
           [ 0.96264371, 0.94222348, 0.93310824],
           [ 0.96112591, 0.93887825, 0.92787613],
           [ 0.9596737 , 0.93552033, 0.92258582],
           [ 0.95826857, 0.93215528, 0.91725354],
           [ 0.95691078, 0.92878338, 0.91187323],
           [ 0.95558706, 0.92540812, 0.90646129],
           [ 0.95429677, 0.92202971, 0.90101648],
           [ 0.95303987, 0.9186481 , 0.89553731],
           [ 0.95180895, 0.91526515, 0.89003356],
           [ 0.95060268, 0.91188113, 0.88450626],
           [ 0.94942096, 0.90849598, 0.87895478],
           [ 0.94826527, 0.9051092 , 0.87337621],
           [ 0.94713012, 0.90172214, 0.86777815],
           [ 0.9460154 , 0.89833471, 0.86216021],
           [ 0.94491934, 0.89494729, 0.85652453],
           [ 0.94384211, 0.89155971, 0.85087045],
           [ 0.94278282, 0.88817211, 0.84519885],
           [ 0.9417403 , 0.88478469, 0.83951108],
           [ 0.94071449, 0.88139736, 0.83380686],
           [ 0.93970482, 0.87801015, 0.8280867 ],
           [ 0.93869093, 0.87463154, 0.82235188],
           [ 0.93767439, 0.87126198, 0.81659016],
           [ 0.93665457, 0.86790165, 0.81080186],
           [ 0.93563073, 0.86455072, 0.80498748],
           [ 0.9346022 , 0.86120939, 0.79914753],
           [ 0.93356835, 0.85787779, 0.7932825 ],
           [ 0.93252858, 0.85455608, 0.78739289],
           [ 0.93148232, 0.8512444 , 0.78147919],
           [ 0.93042904, 0.84794286, 0.77554188],
           [ 0.92936825, 0.84465159, 0.76958144],
           [ 0.92829947, 0.84137068, 0.76359835],
           [ 0.92722226, 0.83810024, 0.75759308],
           [ 0.92613621, 0.83484035, 0.75156611],
           [ 0.92504093, 0.83159108, 0.74551788],
           [ 0.92393607, 0.8283525 , 0.73944885],
           [ 0.92282127, 0.82512468, 0.73335947],
           [ 0.92169623, 0.82190767, 0.72725019],
           [ 0.92056065, 0.81870151, 0.72112144],
           [ 0.91941428, 0.81550625, 0.71497363],
           [ 0.91825684, 0.8123219 , 0.70880719],
           [ 0.91708812, 0.80914851, 0.70262254],
           [ 0.91590788, 0.80598608, 0.69642011],
           [ 0.91471593, 0.80283464, 0.69020029],
           [ 0.91351208, 0.79969419, 0.6839635 ],
           [ 0.91229619, 0.79656474, 0.67771009],
           [ 0.9110681 , 0.79344626, 0.67144042],
           [ 0.9098277 , 0.79033876, 0.66515486],
           [ 0.90857484, 0.78724222, 0.65885379],
           [ 0.90730944, 0.78415662, 0.65253753],
           [ 0.90603137, 0.78108195, 0.64620649],
           [ 0.9047406 , 0.77801816, 0.63986091],
           [ 0.90343706, 0.77496521, 0.63350109],
           [ 0.90212043, 0.77192324, 0.62712707],
           [ 0.9007902 , 0.76889244, 0.62073872],
           [ 0.89944703, 0.76587239, 0.61433695],
           [ 0.8980909 , 0.76286305, 0.60792204],
           [ 0.8967218 , 0.75986435, 0.60149417],
           [ 0.89533975, 0.75687624, 0.59505355],
           [ 0.89394477, 0.75389866, 0.58860036],
           [ 0.89253687, 0.75093154, 0.58213482],
           [ 0.89111598, 0.74797484, 0.57565735],
           [ 0.88968224, 0.74502847, 0.56916787],
           [ 0.88823569, 0.74209235, 0.56266646],
           [ 0.88677639, 0.7391664 , 0.55615322],
           [ 0.88530439, 0.73625056, 0.5496283 ],
           [ 0.88381954, 0.73334485, 0.54309156],
           [ 0.88232071, 0.7304499 , 0.53654178],
           [ 0.88080928, 0.72756485, 0.52998058],
           [ 0.87928542, 0.72468959, 0.52340769],
           [ 0.87774918, 0.72182404, 0.51682313],
           [ 0.87620068, 0.71896812, 0.51022682],
           [ 0.87464002, 0.71612171, 0.50361862],
           [ 0.8730672 , 0.71328477, 0.49699875],
           [ 0.87148244, 0.71045715, 0.49036671],
           [ 0.86988582, 0.70763879, 0.48372234],
           [ 0.86827546, 0.70483075, 0.47706323],
           [ 0.8666533 , 0.70203183, 0.47039155],
           [ 0.86501961, 0.69924189, 0.46370656],
           [ 0.86337451, 0.69646083, 0.45700802],
           [ 0.86171805, 0.69368856, 0.45029569],
           [ 0.86005037, 0.69092498, 0.4435692 ],
           [ 0.8583717 , 0.68816997, 0.43682759],
           [ 0.85668069, 0.68542427, 0.43006904],
           [ 0.85497774, 0.68268759, 0.42329375],
           [ 0.85326416, 0.6799592 , 0.41650135],
           [ 0.85154001, 0.67723901, 0.40969136],
           [ 0.84980535, 0.67452693, 0.40286337],
           [ 0.84806043, 0.67182284, 0.39601592],
           [ 0.84630751, 0.66912636, 0.38913447],
           [ 0.84459103, 0.66641219, 0.38224671],
           [ 0.84291325, 0.66368084, 0.37532092],
           [ 0.84127642, 0.66093085, 0.36835537],
           [ 0.8396827 , 0.65816075, 0.36134959],
           [ 0.83813404, 0.65536906, 0.3543045 ],
           [ 0.83663304, 0.65255404, 0.34721892],
           [ 0.83518227, 0.64971389, 0.34009261],
           [ 0.83378463, 0.64684664, 0.33292467],
           [ 0.83244282, 0.64395026, 0.32571585],
           [ 0.83116067, 0.64102228, 0.31846359],
           [ 0.82994084, 0.63806051, 0.31117051],
           [ 0.82878668, 0.63506246, 0.30383759],
           [ 0.82770268, 0.63202504, 0.29646294],
           [ 0.82669177, 0.62894569, 0.28905098],
           [ 0.8257594 , 0.62581985, 0.28161649],
           [ 0.82491057, 0.62264328, 0.27417247],
           [ 0.82414639, 0.61941489, 0.26670947],
           [ 0.82346948, 0.6161318 , 0.25923681],
           [ 0.82288698, 0.61278636, 0.25181095],
           [ 0.8223949 , 0.6093803 , 0.24442135],
           [ 0.82199347, 0.60591095, 0.23710189],
           [ 0.8216812 , 0.6023757 , 0.22990946],
           [ 0.82144868, 0.59877883, 0.22284964],
           [ 0.82128972, 0.59511966, 0.21600609],
           [ 0.82118758, 0.591407  , 0.20938918],
           [ 0.82112964, 0.58764517, 0.20306727],
           [ 0.8210973 , 0.58384411, 0.19706615],
           [ 0.82107295, 0.58001337, 0.19141507],
           [ 0.82104144, 0.57616127, 0.18614637],
           [ 0.820987  , 0.57229831, 0.18125098],
           [ 0.82089884, 0.56843126, 0.17674506],
           [ 0.82076836, 0.56456672, 0.17261538],
           [ 0.82058591, 0.56071287, 0.16882561],
           [ 0.82035412, 0.55686763, 0.1654141 ],
           [ 0.82006554, 0.55303913, 0.162307  ],
           [ 0.81971999, 0.54922882, 0.15948908],
           [ 0.8193204 , 0.54543542, 0.15696633],
           [ 0.81886751, 0.54166009, 0.15471108],
           [ 0.81836021, 0.53790534, 0.15268999],
           [ 0.81780262, 0.53416961, 0.15088739],
           [ 0.81719522, 0.53045365, 0.14928762],
           [ 0.81654166, 0.52675603, 0.1478763 ],
           [ 0.8158438 , 0.52307639, 0.14663934],
           [ 0.81510297, 0.51941472, 0.14556293],
           [ 0.8143219 , 0.51576993, 0.14463469],
           [ 0.81350256, 0.5121414 , 0.14384267],
           [ 0.81264676, 0.50852856, 0.14317557],
           [ 0.81175539, 0.50493143, 0.14262199],
           [ 0.81083033, 0.50134931, 0.14217199],
           [ 0.80987366, 0.49778124, 0.14181673],
           [ 0.80888697, 0.49422657, 0.14154764],
           [ 0.80787088, 0.49068512, 0.14136263],
           [ 0.80682868, 0.48715438, 0.1412702 ],
           [ 0.80576011, 0.48363561, 0.14124257],
           [ 0.80466553, 0.48012899, 0.14127189],
           [ 0.80355703, 0.47662617, 0.14134325],
           [ 0.80244307, 0.47312268, 0.14140455],
           [ 0.80132288, 0.46961902, 0.14145468],
           [ 0.80019799, 0.46611382, 0.14149602],
           [ 0.7990684 , 0.46260695, 0.14152863],
           [ 0.79793402, 0.45909833, 0.14155245],
           [ 0.79679443, 0.45558816, 0.14156689],
           [ 0.79564905, 0.45207679, 0.14157115],
           [ 0.79449895, 0.44856316, 0.1415669 ],
           [ 0.79334425, 0.44504703, 0.1415543 ],
           [ 0.7921849 , 0.44152826, 0.14153333],
           [ 0.791021  , 0.43800659, 0.14150417],
           [ 0.7898508 , 0.43448337, 0.14146434],
           [ 0.78867629, 0.4309567 , 0.14141669],
           [ 0.78749716, 0.42742668, 0.14136083],
           [ 0.7863135 , 0.42389299, 0.14129692],
           [ 0.78512536, 0.42035543, 0.14122502],
           [ 0.7839324 , 0.41681408, 0.14114469],
           [ 0.78273406, 0.41326924, 0.14105512],
           [ 0.78153119, 0.40971994, 0.14095756],
           [ 0.78032382, 0.4061659 , 0.14085208],
           [ 0.77911231, 0.40260657, 0.14073912],
           [ 0.77789631, 0.399042  , 0.14061828],
           [ 0.77667586, 0.39547192, 0.1404896 ],
           [ 0.77545064, 0.39189639, 0.14035261],
           [ 0.77422054, 0.38831521, 0.14020724],
           [ 0.77298612, 0.38472759, 0.14005425],
           [ 0.77174749, 0.38113312, 0.13989379],
           [ 0.77050465, 0.37753149, 0.13972588],
           [ 0.76925755, 0.37392242, 0.13955047],
           [ 0.76800622, 0.37030556, 0.13936762],
           [ 0.76675073, 0.36668048, 0.13917742],
           [ 0.76549072, 0.36304722, 0.13897942],
           [ 0.76422604, 0.35940553, 0.13877348],
           [ 0.76295723, 0.35575449, 0.13856031],
           [ 0.7616843 , 0.35209368, 0.13833995],
           [ 0.76040723, 0.34842269, 0.13811243],
           [ 0.75912615, 0.34474093, 0.1378779 ],
           [ 0.75784098, 0.34104803, 0.13763632],
           [ 0.75655175, 0.33734346, 0.13738776],
           [ 0.75525845, 0.33362676, 0.13713223],
           [ 0.75396105, 0.32989738, 0.13686976],
           [ 0.75265958, 0.32615477, 0.13660042],
           [ 0.75135404, 0.32239833, 0.13632426],
           [ 0.75004443, 0.31862745, 0.13604133],
           [ 0.74873043, 0.31484189, 0.13575126],
           [ 0.7474124 , 0.31104052, 0.1354546 ],
           [ 0.74609036, 0.30722265, 0.1351514 ],
           [ 0.74476429, 0.30338754, 0.13484171],
           [ 0.7434342 , 0.2995344 , 0.13452559],
           [ 0.74210012, 0.29566234, 0.13420317],
           [ 0.740762  , 0.29177058, 0.13387443],
           [ 0.73941986, 0.28785816, 0.13353947],
           [ 0.73807366, 0.28392417, 0.13319832],
           [ 0.73672338, 0.27996758, 0.13285105],
           [ 0.73536902, 0.27598733, 0.13249773],
           [ 0.73401057, 0.27198225, 0.13213842],
           [ 0.73264812, 0.267951  , 0.13177331],
           [ 0.7312816 , 0.26389237, 0.13140239],
           [ 0.72991091, 0.25980509, 0.13102567],
           [ 0.72853607, 0.25568766, 0.13064324],
           [ 0.72715709, 0.25153846, 0.13025522],
           [ 0.72577404, 0.24735572, 0.12986175],
           [ 0.72438675, 0.24313784, 0.12946276],
           [ 0.72299506, 0.23888311, 0.12905819],
           [ 0.72159891, 0.23458955, 0.12864803],
           [ 0.72019841, 0.23025473, 0.12823254],
           [ 0.71879351, 0.22587627, 0.12781177],
           [ 0.71738445, 0.22145117, 0.12738605],
           [ 0.71597106, 0.2169768 , 0.12695531],
           [ 0.71455619, 0.21244509, 0.12652294],
           [ 0.71313673, 0.20785768, 0.12608696],
           [ 0.71171317, 0.20320993, 0.12564796],
           [ 0.71028524, 0.19849817, 0.12520579],
           [ 0.70885023, 0.19372288, 0.12475808],
           [ 0.70741049, 0.18887484, 0.12430712],
           [ 0.70596683, 0.18394695, 0.12385374],
           [ 0.70451965, 0.17893205, 0.12339841],
           [ 0.70306509, 0.17383098, 0.12293779],
           [ 0.70160541, 0.16863153, 0.12247404],
           [ 0.70014347, 0.16331865, 0.12200979],
           [ 0.69867317, 0.15789552, 0.12153977],
           [ 0.69719976, 0.15233907, 0.12106873],
           [ 0.69571992, 0.14664349, 0.12059389],
           [ 0.69423655, 0.14078634, 0.12011789],
           [ 0.69274566, 0.13475932, 0.11963739],
           [ 0.69125189, 0.12852876, 0.11915653],
           [ 0.68975221, 0.12207639, 0.1186728 ],
           [ 0.68824567, 0.11537334, 0.11818552],
           [ 0.6867347 , 0.10837306, 0.11769691],
           [ 0.68521904, 0.10102592, 0.11720685],
           [ 0.68369886, 0.09326599, 0.11671559],
           [ 0.68217313, 0.08501006, 0.11622239],
           [ 0.68064138, 0.07614058, 0.11572698],
           [ 0.67910607, 0.06647368, 0.11523153],
           [ 0.67756743, 0.05573816, 0.11473634],
           [ 0.67602649, 0.04347155, 0.11424238],
           [ 0.67448806, 0.02955075, 0.11375372],
           [ 0.67299504, 0.0153711 , 0.1133058 ]]

# Rescale colormap to start from white.
kr_data = np.array(kr_data)
kr_data = np.clip(kr_data / kr_data[0], 0, 1)

kwant_red = ListedColormap(kr_data, name="kwant red")
