this["jupyter"] =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var application_1 = __webpack_require__(1);
	/**
	 * A module loader instance.
	 */
	exports.loader = new application_1.ModuleLoader();
	/**
	 * Define a module that can be synchronously required.
	 *
	 * @param path - The version-mangled fully qualified path of the module.
	 *   For example, "foo@1.0.1/lib/bar/baz.js".
	 *
	 * @param callback - The callback function for invoking the module.
	 */
	function define(path, callback) {
	    exports.loader.define.call(exports.loader, path, callback);
	}
	exports.define = define;
	//# sourceMappingURL=loader.js.map

/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var services_1 = __webpack_require__(2);
	var application_1 = __webpack_require__(49);
	var shell_1 = __webpack_require__(60);
	var loader_1 = __webpack_require__(76);
	exports.ModuleLoader = loader_1.ModuleLoader;
	/**
	 * JupyterLab is the main application class. It is instantiated once and shared.
	 */
	var JupyterLab = (function (_super) {
	    __extends(JupyterLab, _super);
	    /**
	     * Construct a new JupyterLab object.
	     */
	    function JupyterLab(options) {
	        if (options === void 0) { options = {}; }
	        var _this = _super.call(this) || this;
	        _this._startedDelegate = new services_1.utils.PromiseDelegate();
	        _this._startedFlag = false;
	        _this._info = {
	            version: options.version || 'unknown',
	            gitDescription: options.gitDescription || 'unknown'
	        };
	        _this._loader = options.loader || null;
	        return _this;
	    }
	    Object.defineProperty(JupyterLab.prototype, "started", {
	        /**
	         * A promise that resolves when the JupyterLab application is started.
	         */
	        get: function () {
	            return this._startedDelegate.promise;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(JupyterLab.prototype, "info", {
	        /**
	         * The information about the application.
	         */
	        get: function () {
	            return this._info;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(JupyterLab.prototype, "loader", {
	        /**
	         * The module loader used by the application.
	         */
	        get: function () {
	            return this._loader;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Start the JupyterLab application.
	     */
	    JupyterLab.prototype.start = function (options) {
	        var _this = this;
	        if (options === void 0) { options = {}; }
	        if (this._startedFlag) {
	            return Promise.resolve(void 0);
	        }
	        this._startedFlag = true;
	        return _super.prototype.start.call(this, options).then(function () {
	            _this._startedDelegate.resolve(void 0);
	        });
	    };
	    /**
	     * Create the application shell for the JupyterLab application.
	     */
	    JupyterLab.prototype.createShell = function () {
	        return new shell_1.ApplicationShell();
	    };
	    return JupyterLab;
	}(application_1.Application));
	exports.JupyterLab = JupyterLab;
	//# sourceMappingURL=index.js.map

/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(3));
	__export(__webpack_require__(15));
	__export(__webpack_require__(23));
	__export(__webpack_require__(38));
	__export(__webpack_require__(48));
	__export(__webpack_require__(39));
	__export(__webpack_require__(44));
	var utils = __webpack_require__(4);
	exports.utils = utils;


/***/ },
/* 3 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var utils = __webpack_require__(4);
	/**
	 * The url for the config service.
	 */
	var SERVICE_CONFIG_URL = 'api/config';
	/**
	 * The namespace for ConfigSection statics.
	 */
	var ConfigSection;
	(function (ConfigSection) {
	    /**
	     * Create a config section.
	     *
	     * @returns A Promise that is fulfilled with the config section is loaded.
	     */
	    function create(options) {
	        var section = new DefaultConfigSection(options);
	        return section.load().then(function () {
	            return section;
	        });
	    }
	    ConfigSection.create = create;
	})(ConfigSection = exports.ConfigSection || (exports.ConfigSection = {}));
	/**
	 * Implementation of the Configurable data section.
	 */
	var DefaultConfigSection = (function () {
	    /**
	     * Construct a new config section.
	     */
	    function DefaultConfigSection(options) {
	        this._url = 'unknown';
	        this._data = null;
	        this._ajaxSettings = null;
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        this.ajaxSettings = utils.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	        this._url = utils.urlPathJoin(baseUrl, SERVICE_CONFIG_URL, encodeURIComponent(options.name));
	    }
	    Object.defineProperty(DefaultConfigSection.prototype, "ajaxSettings", {
	        /**
	         * Get a copy of the default ajax settings for the section.
	         */
	        get: function () {
	            return utils.copy(this._ajaxSettings);
	        },
	        /**
	         * Set the default ajax settings for the section.
	         */
	        set: function (value) {
	            this._ajaxSettings = utils.copy(value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultConfigSection.prototype, "data", {
	        /**
	         * Get the data for this section.
	         */
	        get: function () {
	            return this._data;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Load the initial data for this section.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/config).
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     */
	    DefaultConfigSection.prototype.load = function () {
	        var _this = this;
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(this._url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                return utils.makeAjaxError(success);
	            }
	            _this._data = success.data;
	        });
	    };
	    /**
	     * Modify the stored config values.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/config).
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     *
	     * Updates the local data immediately, sends the change to the server,
	     * and updates the local data with the response, and fulfils the promise
	     * with that data.
	     */
	    DefaultConfigSection.prototype.update = function (newdata) {
	        var _this = this;
	        this._data = utils.extend(this._data, newdata);
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'PATCH';
	        ajaxSettings.data = JSON.stringify(newdata);
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.contentType = 'application/json';
	        return utils.ajaxRequest(this._url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                return utils.makeAjaxError(success);
	            }
	            _this._data = success.data;
	            return _this._data;
	        });
	    };
	    return DefaultConfigSection;
	}());
	/**
	 * Configurable object with defaults.
	 */
	var ConfigWithDefaults = (function () {
	    /**
	     * Create a new config with defaults.
	     */
	    function ConfigWithDefaults(options) {
	        this._section = null;
	        this._defaults = null;
	        this._className = '';
	        this._section = options.section;
	        this._defaults = options.defaults || {};
	        this._className = options.className || '';
	    }
	    /**
	     * Get data from the config section or fall back to defaults.
	     */
	    ConfigWithDefaults.prototype.get = function (key) {
	        var data = this._classData();
	        return key in data ? data[key] : this._defaults[key];
	    };
	    /**
	     * Set a config value.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/config).
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     *
	     * Sends the update to the server, and changes our local copy of the data
	     * immediately.
	     */
	    ConfigWithDefaults.prototype.set = function (key, value) {
	        var d = {};
	        d[key] = value;
	        if (this._className) {
	            var d2 = {};
	            d2[this._className] = d;
	            return this._section.update(d2);
	        }
	        else {
	            return this._section.update(d);
	        }
	    };
	    /**
	     * Get data from the Section with our classname, if available.
	     *
	     * #### Notes
	     * If we have no classname, get all of the data in the Section
	     */
	    ConfigWithDefaults.prototype._classData = function () {
	        var data = this._section.data;
	        if (this._className && this._className in data) {
	            return data[this._className];
	        }
	        return data;
	    };
	    return ConfigWithDefaults;
	}());
	exports.ConfigWithDefaults = ConfigWithDefaults;


/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	'use strict';
	var minimist = __webpack_require__(6);
	var url = __webpack_require__(7);
	var urljoin = __webpack_require__(14);
	/**
	 * Copy the contents of one object to another, recursively.
	 *
	 * From [stackoverflow](http://stackoverflow.com/a/12317051).
	 */
	function extend(target, source) {
	    target = target || {};
	    for (var prop in source) {
	        if (typeof source[prop] === 'object') {
	            target[prop] = extend(target[prop], source[prop]);
	        }
	        else {
	            target[prop] = source[prop];
	        }
	    }
	    return target;
	}
	exports.extend = extend;
	/**
	 * Get a deep copy of a JSON object.
	 */
	function copy(object) {
	    return JSON.parse(JSON.stringify(object));
	}
	exports.copy = copy;
	/**
	 * Get a random 32 character hex string (not a formal UUID)
	 */
	function uuid() {
	    var s = [];
	    var hexDigits = '0123456789abcdef';
	    var nChars = hexDigits.length;
	    for (var i = 0; i < 32; i++) {
	        s[i] = hexDigits.charAt(Math.floor(Math.random() * nChars));
	    }
	    return s.join('');
	}
	exports.uuid = uuid;
	/**
	 * Parse a url into a URL object.
	 *
	 * @param urlString - The URL string to parse.
	 *
	 * @param parseQueryString - If `true`, the query property will always be set
	 *   to an object returned by the `querystring` module's `parse()` method.
	 *   If `false`, the `query` property on the returned URL object will be an
	 *   unparsed, undecoded string. Defaults to `false`.
	 *
	 * @param slashedDenoteHost - If `true`, the first token after the literal
	 *   string `//` and preceeding the next `/` will be interpreted as the `host`.
	 *   For instance, given `//foo/bar`, the result would be
	 *   `{host: 'foo', pathname: '/bar'}` rather than `{pathname: '//foo/bar'}`.
	 *   Defaults to `false`.
	 *
	 * @returns A URL object.
	 */
	function urlParse(urlStr, parseQueryString, slashesDenoteHost) {
	    return url.parse(urlStr, parseQueryString, slashesDenoteHost);
	}
	exports.urlParse = urlParse;
	/**
	 * Resolve a url.
	 *
	 * Take a base URL, and a href URL, and resolve them as a browser would for
	 * an anchor tag.
	 */
	function urlResolve(from, to) {
	    return url.resolve(from, to);
	}
	exports.urlResolve = urlResolve;
	/**
	 * Join a sequence of url components and normalizes as in node `path.join`.
	 */
	function urlPathJoin() {
	    var parts = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	        parts[_i - 0] = arguments[_i];
	    }
	    return urljoin.apply(void 0, parts);
	}
	exports.urlPathJoin = urlPathJoin;
	/**
	 * Encode the components of a multi-segment url.
	 *
	 * #### Notes
	 * Preserves the `'/'` separators.
	 * Should not include the base url, since all parts are escaped.
	 */
	function urlEncodeParts(uri) {
	    // Normalize and join, split, encode, then join.
	    uri = urljoin(uri);
	    var parts = uri.split('/').map(encodeURIComponent);
	    return urljoin.apply(void 0, parts);
	}
	exports.urlEncodeParts = urlEncodeParts;
	/**
	 * Return a serialized object string suitable for a query.
	 *
	 * From [stackoverflow](http://stackoverflow.com/a/30707423).
	 */
	function jsonToQueryString(json) {
	    return '?' + Object.keys(json).map(function (key) {
	        return encodeURIComponent(key) + '=' + encodeURIComponent(String(json[key]));
	    }).join('&');
	}
	exports.jsonToQueryString = jsonToQueryString;
	/**
	 * Asynchronous XMLHTTPRequest handler.
	 *
	 * @param url - The url to request.
	 *
	 * @param settings - The settings to apply to the request and response.
	 *
	 * #### Notes
	 * Based on this [example](http://www.html5rocks.com/en/tutorials/es6/promises/#toc-promisifying-xmlhttprequest).
	 */
	function ajaxRequest(url, ajaxSettings) {
	    var method = ajaxSettings.method || 'GET';
	    var user = ajaxSettings.user || '';
	    var password = ajaxSettings.password || '';
	    if (!ajaxSettings.cache) {
	        // https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest/Using_XMLHttpRequest#Bypassing_the_cache.
	        url += ((/\?/).test(url) ? '&' : '?') + (new Date()).getTime();
	    }
	    return new Promise(function (resolve, reject) {
	        var xhr = new XMLHttpRequest();
	        xhr.open(method, url, true, user, password);
	        if (ajaxSettings.contentType !== void 0) {
	            xhr.setRequestHeader('Content-Type', ajaxSettings.contentType);
	        }
	        if (ajaxSettings.timeout !== void 0) {
	            xhr.timeout = ajaxSettings.timeout;
	        }
	        if (!!ajaxSettings.withCredentials) {
	            xhr.withCredentials = true;
	        }
	        if (ajaxSettings.requestHeaders !== void 0) {
	            for (var prop in ajaxSettings.requestHeaders) {
	                xhr.setRequestHeader(prop, ajaxSettings.requestHeaders[prop]);
	            }
	        }
	        xhr.onload = function (event) {
	            if (xhr.status >= 300) {
	                reject({ event: event, xhr: xhr, ajaxSettings: ajaxSettings, throwError: xhr.statusText });
	            }
	            var data = xhr.responseText;
	            try {
	                data = JSON.parse(data);
	            }
	            catch (err) {
	            }
	            resolve({ xhr: xhr, ajaxSettings: ajaxSettings, data: data, event: event });
	        };
	        xhr.onabort = function (event) {
	            reject({ xhr: xhr, event: event, ajaxSettings: ajaxSettings });
	        };
	        xhr.onerror = function (event) {
	            reject({ xhr: xhr, event: event, ajaxSettings: ajaxSettings });
	        };
	        xhr.ontimeout = function (ev) {
	            reject({ xhr: xhr, event: event, ajaxSettings: ajaxSettings });
	        };
	        if (ajaxSettings.data) {
	            xhr.send(ajaxSettings.data);
	        }
	        else {
	            xhr.send();
	        }
	    });
	}
	exports.ajaxRequest = ajaxRequest;
	/**
	 * Create an ajax error from an ajax success.
	 *
	 * @param success - The original success object.
	 *
	 * @param throwError - The optional new error name.  If not given
	 *  we use "Invalid Status: <xhr.status>"
	 */
	function makeAjaxError(success, throwError) {
	    var xhr = success.xhr;
	    var ajaxSettings = success.ajaxSettings;
	    var event = success.event;
	    throwError = throwError || "Invalid Status: " + xhr.status;
	    return Promise.reject({ xhr: xhr, ajaxSettings: ajaxSettings, event: event, throwError: throwError });
	}
	exports.makeAjaxError = makeAjaxError;
	/**
	 * Try to load an object from a module or a registry.
	 *
	 * Try to load an object from a module asynchronously if a module
	 * is specified, otherwise tries to load an object from the global
	 * registry, if the global registry is provided.
	 */
	function loadObject(name, moduleName, registry) {
	    return new Promise(function (resolve, reject) {
	        // Try loading the view module using require.js
	        if (moduleName) {
	            if (typeof requirejs === 'undefined') {
	                throw new Error('requirejs not found');
	            }
	            requirejs([moduleName], function (mod) {
	                if (mod[name] === void 0) {
	                    var msg = "Object '" + name + "' not found in module '" + moduleName + "'";
	                    reject(new Error(msg));
	                }
	                else {
	                    resolve(mod[name]);
	                }
	            }, reject);
	        }
	        else {
	            if (registry && registry[name]) {
	                resolve(registry[name]);
	            }
	            else {
	                reject(new Error("Object '" + name + "' not found in registry"));
	            }
	        }
	    });
	}
	exports.loadObject = loadObject;
	;
	/**
	 * A Promise that can be resolved or rejected by another object.
	 */
	var PromiseDelegate = (function () {
	    /**
	     * Construct a new Promise delegate.
	     */
	    function PromiseDelegate() {
	        var _this = this;
	        this._promise = new Promise(function (resolve, reject) {
	            _this._resolve = resolve;
	            _this._reject = reject;
	        });
	    }
	    Object.defineProperty(PromiseDelegate.prototype, "promise", {
	        /**
	         * Get the underlying Promise.
	         */
	        get: function () {
	            return this._promise;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Resolve the underlying Promise with an optional value or another Promise.
	     */
	    PromiseDelegate.prototype.resolve = function (value) {
	        // Note: according to the Promise spec, and the `this` context for resolve
	        // and reject are ignored
	        this._resolve(value);
	    };
	    /**
	     * Reject the underlying Promise with an optional reason.
	     */
	    PromiseDelegate.prototype.reject = function (reason) {
	        // Note: according to the Promise spec, the `this` context for resolve
	        // and reject are ignored
	        this._reject(reason);
	    };
	    return PromiseDelegate;
	}());
	exports.PromiseDelegate = PromiseDelegate;
	/**
	 * Global config data for the Jupyter application.
	 */
	var configData = null;
	/**
	 *  Make an object fully immutable by freezing each object in it.
	 */
	function deepFreeze(obj) {
	    // Freeze properties before freezing self
	    Object.getOwnPropertyNames(obj).forEach(function (name) {
	        var prop = obj[name];
	        // Freeze prop if it is an object
	        if (typeof prop === 'object' && prop !== null && !Object.isFrozen(prop)) {
	            deepFreeze(prop);
	        }
	    });
	    // Freeze self
	    return Object.freeze(obj);
	}
	/**
	 * Get global configuration data for the Jupyter application.
	 *
	 * @param name - The name of the configuration option.
	 *
	 * @returns The config value or `undefined` if not found.
	 *
	 * #### Notes
	 * For browser based applications, it is assumed that the page HTML
	 * includes a script tag with the id `jupyter-config-data` containing the
	 * configuration as valid JSON.
	 */
	function getConfigOption(name) {
	    if (configData) {
	        return configData[name];
	    }
	    if (typeof document === 'undefined') {
	        configData = minimist(process.argv.slice(2));
	    }
	    else {
	        var el = document.getElementById('jupyter-config-data');
	        if (el) {
	            configData = JSON.parse(el.textContent);
	        }
	        else {
	            configData = {};
	        }
	    }
	    configData = deepFreeze(configData);
	    return configData[name];
	}
	exports.getConfigOption = getConfigOption;
	/**
	 * Get the base URL for a Jupyter application.
	 */
	function getBaseUrl() {
	    var baseUrl = getConfigOption('baseUrl');
	    if (!baseUrl || baseUrl === '/') {
	        baseUrl = (typeof location === 'undefined' ?
	            'http://localhost:8888/' : location.origin + '/');
	    }
	    return baseUrl;
	}
	exports.getBaseUrl = getBaseUrl;
	/**
	 * Get the base websocket URL for a Jupyter application.
	 */
	function getWsUrl(baseUrl) {
	    var wsUrl = getConfigOption('wsUrl');
	    if (!wsUrl) {
	        baseUrl = baseUrl || getBaseUrl();
	        if (baseUrl.indexOf('http') !== 0) {
	            if (typeof location !== 'undefined') {
	                baseUrl = urlPathJoin(location.origin, baseUrl);
	            }
	            else {
	                baseUrl = urlPathJoin('http://localhost:8888/', baseUrl);
	            }
	        }
	        wsUrl = 'ws' + baseUrl.slice(4);
	    }
	    return wsUrl;
	}
	exports.getWsUrl = getWsUrl;
	/**
	 * Add token to ajaxSettings.requestHeaders if defined.
	 * Always returns a copy of ajaxSettings, and a dict.
	 */
	function ajaxSettingsWithToken(ajaxSettings, token) {
	    if (!ajaxSettings) {
	        ajaxSettings = {};
	    }
	    else {
	        ajaxSettings = copy(ajaxSettings);
	    }
	    if (!token) {
	        token = getConfigOption('token');
	    }
	    if (!token || token == '') {
	        return ajaxSettings;
	    }
	    if (!ajaxSettings.requestHeaders) {
	        ajaxSettings.requestHeaders = {};
	    }
	    ajaxSettings.requestHeaders['Authorization'] = "token " + token;
	    return ajaxSettings;
	}
	exports.ajaxSettingsWithToken = ajaxSettingsWithToken;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(5)))

/***/ },
/* 5 */
/***/ function(module, exports) {

	// shim for using process in browser
	var process = module.exports = {};
	
	// cached from whatever global is present so that test runners that stub it
	// don't break things.  But we need to wrap it in a try catch in case it is
	// wrapped in strict mode code which doesn't define any globals.  It's inside a
	// function because try/catches deoptimize in certain engines.
	
	var cachedSetTimeout;
	var cachedClearTimeout;
	
	(function () {
	    try {
	        cachedSetTimeout = setTimeout;
	    } catch (e) {
	        cachedSetTimeout = function () {
	            throw new Error('setTimeout is not defined');
	        }
	    }
	    try {
	        cachedClearTimeout = clearTimeout;
	    } catch (e) {
	        cachedClearTimeout = function () {
	            throw new Error('clearTimeout is not defined');
	        }
	    }
	} ())
	function runTimeout(fun) {
	    if (cachedSetTimeout === setTimeout) {
	        //normal enviroments in sane situations
	        return setTimeout(fun, 0);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedSetTimeout(fun, 0);
	    } catch(e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
	            return cachedSetTimeout.call(null, fun, 0);
	        } catch(e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
	            return cachedSetTimeout.call(this, fun, 0);
	        }
	    }
	
	
	}
	function runClearTimeout(marker) {
	    if (cachedClearTimeout === clearTimeout) {
	        //normal enviroments in sane situations
	        return clearTimeout(marker);
	    }
	    try {
	        // when when somebody has screwed with setTimeout but no I.E. maddness
	        return cachedClearTimeout(marker);
	    } catch (e){
	        try {
	            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
	            return cachedClearTimeout.call(null, marker);
	        } catch (e){
	            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
	            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
	            return cachedClearTimeout.call(this, marker);
	        }
	    }
	
	
	
	}
	var queue = [];
	var draining = false;
	var currentQueue;
	var queueIndex = -1;
	
	function cleanUpNextTick() {
	    if (!draining || !currentQueue) {
	        return;
	    }
	    draining = false;
	    if (currentQueue.length) {
	        queue = currentQueue.concat(queue);
	    } else {
	        queueIndex = -1;
	    }
	    if (queue.length) {
	        drainQueue();
	    }
	}
	
	function drainQueue() {
	    if (draining) {
	        return;
	    }
	    var timeout = runTimeout(cleanUpNextTick);
	    draining = true;
	
	    var len = queue.length;
	    while(len) {
	        currentQueue = queue;
	        queue = [];
	        while (++queueIndex < len) {
	            if (currentQueue) {
	                currentQueue[queueIndex].run();
	            }
	        }
	        queueIndex = -1;
	        len = queue.length;
	    }
	    currentQueue = null;
	    draining = false;
	    runClearTimeout(timeout);
	}
	
	process.nextTick = function (fun) {
	    var args = new Array(arguments.length - 1);
	    if (arguments.length > 1) {
	        for (var i = 1; i < arguments.length; i++) {
	            args[i - 1] = arguments[i];
	        }
	    }
	    queue.push(new Item(fun, args));
	    if (queue.length === 1 && !draining) {
	        runTimeout(drainQueue);
	    }
	};
	
	// v8 likes predictible objects
	function Item(fun, array) {
	    this.fun = fun;
	    this.array = array;
	}
	Item.prototype.run = function () {
	    this.fun.apply(null, this.array);
	};
	process.title = 'browser';
	process.browser = true;
	process.env = {};
	process.argv = [];
	process.version = ''; // empty string to avoid regexp issues
	process.versions = {};
	
	function noop() {}
	
	process.on = noop;
	process.addListener = noop;
	process.once = noop;
	process.off = noop;
	process.removeListener = noop;
	process.removeAllListeners = noop;
	process.emit = noop;
	
	process.binding = function (name) {
	    throw new Error('process.binding is not supported');
	};
	
	process.cwd = function () { return '/' };
	process.chdir = function (dir) {
	    throw new Error('process.chdir is not supported');
	};
	process.umask = function() { return 0; };


/***/ },
/* 6 */
/***/ function(module, exports) {

	module.exports = function (args, opts) {
	    if (!opts) opts = {};
	    
	    var flags = { bools : {}, strings : {}, unknownFn: null };
	
	    if (typeof opts['unknown'] === 'function') {
	        flags.unknownFn = opts['unknown'];
	    }
	
	    if (typeof opts['boolean'] === 'boolean' && opts['boolean']) {
	      flags.allBools = true;
	    } else {
	      [].concat(opts['boolean']).filter(Boolean).forEach(function (key) {
	          flags.bools[key] = true;
	      });
	    }
	    
	    var aliases = {};
	    Object.keys(opts.alias || {}).forEach(function (key) {
	        aliases[key] = [].concat(opts.alias[key]);
	        aliases[key].forEach(function (x) {
	            aliases[x] = [key].concat(aliases[key].filter(function (y) {
	                return x !== y;
	            }));
	        });
	    });
	
	    [].concat(opts.string).filter(Boolean).forEach(function (key) {
	        flags.strings[key] = true;
	        if (aliases[key]) {
	            flags.strings[aliases[key]] = true;
	        }
	     });
	
	    var defaults = opts['default'] || {};
	    
	    var argv = { _ : [] };
	    Object.keys(flags.bools).forEach(function (key) {
	        setArg(key, defaults[key] === undefined ? false : defaults[key]);
	    });
	    
	    var notFlags = [];
	
	    if (args.indexOf('--') !== -1) {
	        notFlags = args.slice(args.indexOf('--')+1);
	        args = args.slice(0, args.indexOf('--'));
	    }
	
	    function argDefined(key, arg) {
	        return (flags.allBools && /^--[^=]+$/.test(arg)) ||
	            flags.strings[key] || flags.bools[key] || aliases[key];
	    }
	
	    function setArg (key, val, arg) {
	        if (arg && flags.unknownFn && !argDefined(key, arg)) {
	            if (flags.unknownFn(arg) === false) return;
	        }
	
	        var value = !flags.strings[key] && isNumber(val)
	            ? Number(val) : val
	        ;
	        setKey(argv, key.split('.'), value);
	        
	        (aliases[key] || []).forEach(function (x) {
	            setKey(argv, x.split('.'), value);
	        });
	    }
	
	    function setKey (obj, keys, value) {
	        var o = obj;
	        keys.slice(0,-1).forEach(function (key) {
	            if (o[key] === undefined) o[key] = {};
	            o = o[key];
	        });
	
	        var key = keys[keys.length - 1];
	        if (o[key] === undefined || flags.bools[key] || typeof o[key] === 'boolean') {
	            o[key] = value;
	        }
	        else if (Array.isArray(o[key])) {
	            o[key].push(value);
	        }
	        else {
	            o[key] = [ o[key], value ];
	        }
	    }
	    
	    function aliasIsBoolean(key) {
	      return aliases[key].some(function (x) {
	          return flags.bools[x];
	      });
	    }
	
	    for (var i = 0; i < args.length; i++) {
	        var arg = args[i];
	        
	        if (/^--.+=/.test(arg)) {
	            // Using [\s\S] instead of . because js doesn't support the
	            // 'dotall' regex modifier. See:
	            // http://stackoverflow.com/a/1068308/13216
	            var m = arg.match(/^--([^=]+)=([\s\S]*)$/);
	            var key = m[1];
	            var value = m[2];
	            if (flags.bools[key]) {
	                value = value !== 'false';
	            }
	            setArg(key, value, arg);
	        }
	        else if (/^--no-.+/.test(arg)) {
	            var key = arg.match(/^--no-(.+)/)[1];
	            setArg(key, false, arg);
	        }
	        else if (/^--.+/.test(arg)) {
	            var key = arg.match(/^--(.+)/)[1];
	            var next = args[i + 1];
	            if (next !== undefined && !/^-/.test(next)
	            && !flags.bools[key]
	            && !flags.allBools
	            && (aliases[key] ? !aliasIsBoolean(key) : true)) {
	                setArg(key, next, arg);
	                i++;
	            }
	            else if (/^(true|false)$/.test(next)) {
	                setArg(key, next === 'true', arg);
	                i++;
	            }
	            else {
	                setArg(key, flags.strings[key] ? '' : true, arg);
	            }
	        }
	        else if (/^-[^-]+/.test(arg)) {
	            var letters = arg.slice(1,-1).split('');
	            
	            var broken = false;
	            for (var j = 0; j < letters.length; j++) {
	                var next = arg.slice(j+2);
	                
	                if (next === '-') {
	                    setArg(letters[j], next, arg)
	                    continue;
	                }
	                
	                if (/[A-Za-z]/.test(letters[j]) && /=/.test(next)) {
	                    setArg(letters[j], next.split('=')[1], arg);
	                    broken = true;
	                    break;
	                }
	                
	                if (/[A-Za-z]/.test(letters[j])
	                && /-?\d+(\.\d*)?(e-?\d+)?$/.test(next)) {
	                    setArg(letters[j], next, arg);
	                    broken = true;
	                    break;
	                }
	                
	                if (letters[j+1] && letters[j+1].match(/\W/)) {
	                    setArg(letters[j], arg.slice(j+2), arg);
	                    broken = true;
	                    break;
	                }
	                else {
	                    setArg(letters[j], flags.strings[letters[j]] ? '' : true, arg);
	                }
	            }
	            
	            var key = arg.slice(-1)[0];
	            if (!broken && key !== '-') {
	                if (args[i+1] && !/^(-|--)[^-]/.test(args[i+1])
	                && !flags.bools[key]
	                && (aliases[key] ? !aliasIsBoolean(key) : true)) {
	                    setArg(key, args[i+1], arg);
	                    i++;
	                }
	                else if (args[i+1] && /true|false/.test(args[i+1])) {
	                    setArg(key, args[i+1] === 'true', arg);
	                    i++;
	                }
	                else {
	                    setArg(key, flags.strings[key] ? '' : true, arg);
	                }
	            }
	        }
	        else {
	            if (!flags.unknownFn || flags.unknownFn(arg) !== false) {
	                argv._.push(
	                    flags.strings['_'] || !isNumber(arg) ? arg : Number(arg)
	                );
	            }
	            if (opts.stopEarly) {
	                argv._.push.apply(argv._, args.slice(i + 1));
	                break;
	            }
	        }
	    }
	    
	    Object.keys(defaults).forEach(function (key) {
	        if (!hasKey(argv, key.split('.'))) {
	            setKey(argv, key.split('.'), defaults[key]);
	            
	            (aliases[key] || []).forEach(function (x) {
	                setKey(argv, x.split('.'), defaults[key]);
	            });
	        }
	    });
	    
	    if (opts['--']) {
	        argv['--'] = new Array();
	        notFlags.forEach(function(key) {
	            argv['--'].push(key);
	        });
	    }
	    else {
	        notFlags.forEach(function(key) {
	            argv._.push(key);
	        });
	    }
	
	    return argv;
	};
	
	function hasKey (obj, keys) {
	    var o = obj;
	    keys.slice(0,-1).forEach(function (key) {
	        o = (o[key] || {});
	    });
	
	    var key = keys[keys.length - 1];
	    return key in o;
	}
	
	function isNumber (x) {
	    if (typeof x === 'number') return true;
	    if (/^0x[0-9a-f]+$/i.test(x)) return true;
	    return /^[-+]?(?:\d+(?:\.\d*)?|\.\d+)(e[-+]?\d+)?$/.test(x);
	}
	


/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	'use strict';
	
	var punycode = __webpack_require__(8);
	var util = __webpack_require__(10);
	
	exports.parse = urlParse;
	exports.resolve = urlResolve;
	exports.resolveObject = urlResolveObject;
	exports.format = urlFormat;
	
	exports.Url = Url;
	
	function Url() {
	  this.protocol = null;
	  this.slashes = null;
	  this.auth = null;
	  this.host = null;
	  this.port = null;
	  this.hostname = null;
	  this.hash = null;
	  this.search = null;
	  this.query = null;
	  this.pathname = null;
	  this.path = null;
	  this.href = null;
	}
	
	// Reference: RFC 3986, RFC 1808, RFC 2396
	
	// define these here so at least they only have to be
	// compiled once on the first module load.
	var protocolPattern = /^([a-z0-9.+-]+:)/i,
	    portPattern = /:[0-9]*$/,
	
	    // Special case for a simple path URL
	    simplePathPattern = /^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/,
	
	    // RFC 2396: characters reserved for delimiting URLs.
	    // We actually just auto-escape these.
	    delims = ['<', '>', '"', '`', ' ', '\r', '\n', '\t'],
	
	    // RFC 2396: characters not allowed for various reasons.
	    unwise = ['{', '}', '|', '\\', '^', '`'].concat(delims),
	
	    // Allowed by RFCs, but cause of XSS attacks.  Always escape these.
	    autoEscape = ['\''].concat(unwise),
	    // Characters that are never ever allowed in a hostname.
	    // Note that any invalid chars are also handled, but these
	    // are the ones that are *expected* to be seen, so we fast-path
	    // them.
	    nonHostChars = ['%', '/', '?', ';', '#'].concat(autoEscape),
	    hostEndingChars = ['/', '?', '#'],
	    hostnameMaxLen = 255,
	    hostnamePartPattern = /^[+a-z0-9A-Z_-]{0,63}$/,
	    hostnamePartStart = /^([+a-z0-9A-Z_-]{0,63})(.*)$/,
	    // protocols that can allow "unsafe" and "unwise" chars.
	    unsafeProtocol = {
	      'javascript': true,
	      'javascript:': true
	    },
	    // protocols that never have a hostname.
	    hostlessProtocol = {
	      'javascript': true,
	      'javascript:': true
	    },
	    // protocols that always contain a // bit.
	    slashedProtocol = {
	      'http': true,
	      'https': true,
	      'ftp': true,
	      'gopher': true,
	      'file': true,
	      'http:': true,
	      'https:': true,
	      'ftp:': true,
	      'gopher:': true,
	      'file:': true
	    },
	    querystring = __webpack_require__(11);
	
	function urlParse(url, parseQueryString, slashesDenoteHost) {
	  if (url && util.isObject(url) && url instanceof Url) return url;
	
	  var u = new Url;
	  u.parse(url, parseQueryString, slashesDenoteHost);
	  return u;
	}
	
	Url.prototype.parse = function(url, parseQueryString, slashesDenoteHost) {
	  if (!util.isString(url)) {
	    throw new TypeError("Parameter 'url' must be a string, not " + typeof url);
	  }
	
	  // Copy chrome, IE, opera backslash-handling behavior.
	  // Back slashes before the query string get converted to forward slashes
	  // See: https://code.google.com/p/chromium/issues/detail?id=25916
	  var queryIndex = url.indexOf('?'),
	      splitter =
	          (queryIndex !== -1 && queryIndex < url.indexOf('#')) ? '?' : '#',
	      uSplit = url.split(splitter),
	      slashRegex = /\\/g;
	  uSplit[0] = uSplit[0].replace(slashRegex, '/');
	  url = uSplit.join(splitter);
	
	  var rest = url;
	
	  // trim before proceeding.
	  // This is to support parse stuff like "  http://foo.com  \n"
	  rest = rest.trim();
	
	  if (!slashesDenoteHost && url.split('#').length === 1) {
	    // Try fast path regexp
	    var simplePath = simplePathPattern.exec(rest);
	    if (simplePath) {
	      this.path = rest;
	      this.href = rest;
	      this.pathname = simplePath[1];
	      if (simplePath[2]) {
	        this.search = simplePath[2];
	        if (parseQueryString) {
	          this.query = querystring.parse(this.search.substr(1));
	        } else {
	          this.query = this.search.substr(1);
	        }
	      } else if (parseQueryString) {
	        this.search = '';
	        this.query = {};
	      }
	      return this;
	    }
	  }
	
	  var proto = protocolPattern.exec(rest);
	  if (proto) {
	    proto = proto[0];
	    var lowerProto = proto.toLowerCase();
	    this.protocol = lowerProto;
	    rest = rest.substr(proto.length);
	  }
	
	  // figure out if it's got a host
	  // user@server is *always* interpreted as a hostname, and url
	  // resolution will treat //foo/bar as host=foo,path=bar because that's
	  // how the browser resolves relative URLs.
	  if (slashesDenoteHost || proto || rest.match(/^\/\/[^@\/]+@[^@\/]+/)) {
	    var slashes = rest.substr(0, 2) === '//';
	    if (slashes && !(proto && hostlessProtocol[proto])) {
	      rest = rest.substr(2);
	      this.slashes = true;
	    }
	  }
	
	  if (!hostlessProtocol[proto] &&
	      (slashes || (proto && !slashedProtocol[proto]))) {
	
	    // there's a hostname.
	    // the first instance of /, ?, ;, or # ends the host.
	    //
	    // If there is an @ in the hostname, then non-host chars *are* allowed
	    // to the left of the last @ sign, unless some host-ending character
	    // comes *before* the @-sign.
	    // URLs are obnoxious.
	    //
	    // ex:
	    // http://a@b@c/ => user:a@b host:c
	    // http://a@b?@c => user:a host:c path:/?@c
	
	    // v0.12 TODO(isaacs): This is not quite how Chrome does things.
	    // Review our test case against browsers more comprehensively.
	
	    // find the first instance of any hostEndingChars
	    var hostEnd = -1;
	    for (var i = 0; i < hostEndingChars.length; i++) {
	      var hec = rest.indexOf(hostEndingChars[i]);
	      if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
	        hostEnd = hec;
	    }
	
	    // at this point, either we have an explicit point where the
	    // auth portion cannot go past, or the last @ char is the decider.
	    var auth, atSign;
	    if (hostEnd === -1) {
	      // atSign can be anywhere.
	      atSign = rest.lastIndexOf('@');
	    } else {
	      // atSign must be in auth portion.
	      // http://a@b/c@d => host:b auth:a path:/c@d
	      atSign = rest.lastIndexOf('@', hostEnd);
	    }
	
	    // Now we have a portion which is definitely the auth.
	    // Pull that off.
	    if (atSign !== -1) {
	      auth = rest.slice(0, atSign);
	      rest = rest.slice(atSign + 1);
	      this.auth = decodeURIComponent(auth);
	    }
	
	    // the host is the remaining to the left of the first non-host char
	    hostEnd = -1;
	    for (var i = 0; i < nonHostChars.length; i++) {
	      var hec = rest.indexOf(nonHostChars[i]);
	      if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
	        hostEnd = hec;
	    }
	    // if we still have not hit it, then the entire thing is a host.
	    if (hostEnd === -1)
	      hostEnd = rest.length;
	
	    this.host = rest.slice(0, hostEnd);
	    rest = rest.slice(hostEnd);
	
	    // pull out port.
	    this.parseHost();
	
	    // we've indicated that there is a hostname,
	    // so even if it's empty, it has to be present.
	    this.hostname = this.hostname || '';
	
	    // if hostname begins with [ and ends with ]
	    // assume that it's an IPv6 address.
	    var ipv6Hostname = this.hostname[0] === '[' &&
	        this.hostname[this.hostname.length - 1] === ']';
	
	    // validate a little.
	    if (!ipv6Hostname) {
	      var hostparts = this.hostname.split(/\./);
	      for (var i = 0, l = hostparts.length; i < l; i++) {
	        var part = hostparts[i];
	        if (!part) continue;
	        if (!part.match(hostnamePartPattern)) {
	          var newpart = '';
	          for (var j = 0, k = part.length; j < k; j++) {
	            if (part.charCodeAt(j) > 127) {
	              // we replace non-ASCII char with a temporary placeholder
	              // we need this to make sure size of hostname is not
	              // broken by replacing non-ASCII by nothing
	              newpart += 'x';
	            } else {
	              newpart += part[j];
	            }
	          }
	          // we test again with ASCII char only
	          if (!newpart.match(hostnamePartPattern)) {
	            var validParts = hostparts.slice(0, i);
	            var notHost = hostparts.slice(i + 1);
	            var bit = part.match(hostnamePartStart);
	            if (bit) {
	              validParts.push(bit[1]);
	              notHost.unshift(bit[2]);
	            }
	            if (notHost.length) {
	              rest = '/' + notHost.join('.') + rest;
	            }
	            this.hostname = validParts.join('.');
	            break;
	          }
	        }
	      }
	    }
	
	    if (this.hostname.length > hostnameMaxLen) {
	      this.hostname = '';
	    } else {
	      // hostnames are always lower case.
	      this.hostname = this.hostname.toLowerCase();
	    }
	
	    if (!ipv6Hostname) {
	      // IDNA Support: Returns a punycoded representation of "domain".
	      // It only converts parts of the domain name that
	      // have non-ASCII characters, i.e. it doesn't matter if
	      // you call it with a domain that already is ASCII-only.
	      this.hostname = punycode.toASCII(this.hostname);
	    }
	
	    var p = this.port ? ':' + this.port : '';
	    var h = this.hostname || '';
	    this.host = h + p;
	    this.href += this.host;
	
	    // strip [ and ] from the hostname
	    // the host field still retains them, though
	    if (ipv6Hostname) {
	      this.hostname = this.hostname.substr(1, this.hostname.length - 2);
	      if (rest[0] !== '/') {
	        rest = '/' + rest;
	      }
	    }
	  }
	
	  // now rest is set to the post-host stuff.
	  // chop off any delim chars.
	  if (!unsafeProtocol[lowerProto]) {
	
	    // First, make 100% sure that any "autoEscape" chars get
	    // escaped, even if encodeURIComponent doesn't think they
	    // need to be.
	    for (var i = 0, l = autoEscape.length; i < l; i++) {
	      var ae = autoEscape[i];
	      if (rest.indexOf(ae) === -1)
	        continue;
	      var esc = encodeURIComponent(ae);
	      if (esc === ae) {
	        esc = escape(ae);
	      }
	      rest = rest.split(ae).join(esc);
	    }
	  }
	
	
	  // chop off from the tail first.
	  var hash = rest.indexOf('#');
	  if (hash !== -1) {
	    // got a fragment string.
	    this.hash = rest.substr(hash);
	    rest = rest.slice(0, hash);
	  }
	  var qm = rest.indexOf('?');
	  if (qm !== -1) {
	    this.search = rest.substr(qm);
	    this.query = rest.substr(qm + 1);
	    if (parseQueryString) {
	      this.query = querystring.parse(this.query);
	    }
	    rest = rest.slice(0, qm);
	  } else if (parseQueryString) {
	    // no query string, but parseQueryString still requested
	    this.search = '';
	    this.query = {};
	  }
	  if (rest) this.pathname = rest;
	  if (slashedProtocol[lowerProto] &&
	      this.hostname && !this.pathname) {
	    this.pathname = '/';
	  }
	
	  //to support http.request
	  if (this.pathname || this.search) {
	    var p = this.pathname || '';
	    var s = this.search || '';
	    this.path = p + s;
	  }
	
	  // finally, reconstruct the href based on what has been validated.
	  this.href = this.format();
	  return this;
	};
	
	// format a parsed object into a url string
	function urlFormat(obj) {
	  // ensure it's an object, and not a string url.
	  // If it's an obj, this is a no-op.
	  // this way, you can call url_format() on strings
	  // to clean up potentially wonky urls.
	  if (util.isString(obj)) obj = urlParse(obj);
	  if (!(obj instanceof Url)) return Url.prototype.format.call(obj);
	  return obj.format();
	}
	
	Url.prototype.format = function() {
	  var auth = this.auth || '';
	  if (auth) {
	    auth = encodeURIComponent(auth);
	    auth = auth.replace(/%3A/i, ':');
	    auth += '@';
	  }
	
	  var protocol = this.protocol || '',
	      pathname = this.pathname || '',
	      hash = this.hash || '',
	      host = false,
	      query = '';
	
	  if (this.host) {
	    host = auth + this.host;
	  } else if (this.hostname) {
	    host = auth + (this.hostname.indexOf(':') === -1 ?
	        this.hostname :
	        '[' + this.hostname + ']');
	    if (this.port) {
	      host += ':' + this.port;
	    }
	  }
	
	  if (this.query &&
	      util.isObject(this.query) &&
	      Object.keys(this.query).length) {
	    query = querystring.stringify(this.query);
	  }
	
	  var search = this.search || (query && ('?' + query)) || '';
	
	  if (protocol && protocol.substr(-1) !== ':') protocol += ':';
	
	  // only the slashedProtocols get the //.  Not mailto:, xmpp:, etc.
	  // unless they had them to begin with.
	  if (this.slashes ||
	      (!protocol || slashedProtocol[protocol]) && host !== false) {
	    host = '//' + (host || '');
	    if (pathname && pathname.charAt(0) !== '/') pathname = '/' + pathname;
	  } else if (!host) {
	    host = '';
	  }
	
	  if (hash && hash.charAt(0) !== '#') hash = '#' + hash;
	  if (search && search.charAt(0) !== '?') search = '?' + search;
	
	  pathname = pathname.replace(/[?#]/g, function(match) {
	    return encodeURIComponent(match);
	  });
	  search = search.replace('#', '%23');
	
	  return protocol + host + pathname + search + hash;
	};
	
	function urlResolve(source, relative) {
	  return urlParse(source, false, true).resolve(relative);
	}
	
	Url.prototype.resolve = function(relative) {
	  return this.resolveObject(urlParse(relative, false, true)).format();
	};
	
	function urlResolveObject(source, relative) {
	  if (!source) return relative;
	  return urlParse(source, false, true).resolveObject(relative);
	}
	
	Url.prototype.resolveObject = function(relative) {
	  if (util.isString(relative)) {
	    var rel = new Url();
	    rel.parse(relative, false, true);
	    relative = rel;
	  }
	
	  var result = new Url();
	  var tkeys = Object.keys(this);
	  for (var tk = 0; tk < tkeys.length; tk++) {
	    var tkey = tkeys[tk];
	    result[tkey] = this[tkey];
	  }
	
	  // hash is always overridden, no matter what.
	  // even href="" will remove it.
	  result.hash = relative.hash;
	
	  // if the relative url is empty, then there's nothing left to do here.
	  if (relative.href === '') {
	    result.href = result.format();
	    return result;
	  }
	
	  // hrefs like //foo/bar always cut to the protocol.
	  if (relative.slashes && !relative.protocol) {
	    // take everything except the protocol from relative
	    var rkeys = Object.keys(relative);
	    for (var rk = 0; rk < rkeys.length; rk++) {
	      var rkey = rkeys[rk];
	      if (rkey !== 'protocol')
	        result[rkey] = relative[rkey];
	    }
	
	    //urlParse appends trailing / to urls like http://www.example.com
	    if (slashedProtocol[result.protocol] &&
	        result.hostname && !result.pathname) {
	      result.path = result.pathname = '/';
	    }
	
	    result.href = result.format();
	    return result;
	  }
	
	  if (relative.protocol && relative.protocol !== result.protocol) {
	    // if it's a known url protocol, then changing
	    // the protocol does weird things
	    // first, if it's not file:, then we MUST have a host,
	    // and if there was a path
	    // to begin with, then we MUST have a path.
	    // if it is file:, then the host is dropped,
	    // because that's known to be hostless.
	    // anything else is assumed to be absolute.
	    if (!slashedProtocol[relative.protocol]) {
	      var keys = Object.keys(relative);
	      for (var v = 0; v < keys.length; v++) {
	        var k = keys[v];
	        result[k] = relative[k];
	      }
	      result.href = result.format();
	      return result;
	    }
	
	    result.protocol = relative.protocol;
	    if (!relative.host && !hostlessProtocol[relative.protocol]) {
	      var relPath = (relative.pathname || '').split('/');
	      while (relPath.length && !(relative.host = relPath.shift()));
	      if (!relative.host) relative.host = '';
	      if (!relative.hostname) relative.hostname = '';
	      if (relPath[0] !== '') relPath.unshift('');
	      if (relPath.length < 2) relPath.unshift('');
	      result.pathname = relPath.join('/');
	    } else {
	      result.pathname = relative.pathname;
	    }
	    result.search = relative.search;
	    result.query = relative.query;
	    result.host = relative.host || '';
	    result.auth = relative.auth;
	    result.hostname = relative.hostname || relative.host;
	    result.port = relative.port;
	    // to support http.request
	    if (result.pathname || result.search) {
	      var p = result.pathname || '';
	      var s = result.search || '';
	      result.path = p + s;
	    }
	    result.slashes = result.slashes || relative.slashes;
	    result.href = result.format();
	    return result;
	  }
	
	  var isSourceAbs = (result.pathname && result.pathname.charAt(0) === '/'),
	      isRelAbs = (
	          relative.host ||
	          relative.pathname && relative.pathname.charAt(0) === '/'
	      ),
	      mustEndAbs = (isRelAbs || isSourceAbs ||
	                    (result.host && relative.pathname)),
	      removeAllDots = mustEndAbs,
	      srcPath = result.pathname && result.pathname.split('/') || [],
	      relPath = relative.pathname && relative.pathname.split('/') || [],
	      psychotic = result.protocol && !slashedProtocol[result.protocol];
	
	  // if the url is a non-slashed url, then relative
	  // links like ../.. should be able
	  // to crawl up to the hostname, as well.  This is strange.
	  // result.protocol has already been set by now.
	  // Later on, put the first path part into the host field.
	  if (psychotic) {
	    result.hostname = '';
	    result.port = null;
	    if (result.host) {
	      if (srcPath[0] === '') srcPath[0] = result.host;
	      else srcPath.unshift(result.host);
	    }
	    result.host = '';
	    if (relative.protocol) {
	      relative.hostname = null;
	      relative.port = null;
	      if (relative.host) {
	        if (relPath[0] === '') relPath[0] = relative.host;
	        else relPath.unshift(relative.host);
	      }
	      relative.host = null;
	    }
	    mustEndAbs = mustEndAbs && (relPath[0] === '' || srcPath[0] === '');
	  }
	
	  if (isRelAbs) {
	    // it's absolute.
	    result.host = (relative.host || relative.host === '') ?
	                  relative.host : result.host;
	    result.hostname = (relative.hostname || relative.hostname === '') ?
	                      relative.hostname : result.hostname;
	    result.search = relative.search;
	    result.query = relative.query;
	    srcPath = relPath;
	    // fall through to the dot-handling below.
	  } else if (relPath.length) {
	    // it's relative
	    // throw away the existing file, and take the new path instead.
	    if (!srcPath) srcPath = [];
	    srcPath.pop();
	    srcPath = srcPath.concat(relPath);
	    result.search = relative.search;
	    result.query = relative.query;
	  } else if (!util.isNullOrUndefined(relative.search)) {
	    // just pull out the search.
	    // like href='?foo'.
	    // Put this after the other two cases because it simplifies the booleans
	    if (psychotic) {
	      result.hostname = result.host = srcPath.shift();
	      //occationaly the auth can get stuck only in host
	      //this especially happens in cases like
	      //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
	      var authInHost = result.host && result.host.indexOf('@') > 0 ?
	                       result.host.split('@') : false;
	      if (authInHost) {
	        result.auth = authInHost.shift();
	        result.host = result.hostname = authInHost.shift();
	      }
	    }
	    result.search = relative.search;
	    result.query = relative.query;
	    //to support http.request
	    if (!util.isNull(result.pathname) || !util.isNull(result.search)) {
	      result.path = (result.pathname ? result.pathname : '') +
	                    (result.search ? result.search : '');
	    }
	    result.href = result.format();
	    return result;
	  }
	
	  if (!srcPath.length) {
	    // no path at all.  easy.
	    // we've already handled the other stuff above.
	    result.pathname = null;
	    //to support http.request
	    if (result.search) {
	      result.path = '/' + result.search;
	    } else {
	      result.path = null;
	    }
	    result.href = result.format();
	    return result;
	  }
	
	  // if a url ENDs in . or .., then it must get a trailing slash.
	  // however, if it ends in anything else non-slashy,
	  // then it must NOT get a trailing slash.
	  var last = srcPath.slice(-1)[0];
	  var hasTrailingSlash = (
	      (result.host || relative.host || srcPath.length > 1) &&
	      (last === '.' || last === '..') || last === '');
	
	  // strip single dots, resolve double dots to parent dir
	  // if the path tries to go above the root, `up` ends up > 0
	  var up = 0;
	  for (var i = srcPath.length; i >= 0; i--) {
	    last = srcPath[i];
	    if (last === '.') {
	      srcPath.splice(i, 1);
	    } else if (last === '..') {
	      srcPath.splice(i, 1);
	      up++;
	    } else if (up) {
	      srcPath.splice(i, 1);
	      up--;
	    }
	  }
	
	  // if the path is allowed to go above the root, restore leading ..s
	  if (!mustEndAbs && !removeAllDots) {
	    for (; up--; up) {
	      srcPath.unshift('..');
	    }
	  }
	
	  if (mustEndAbs && srcPath[0] !== '' &&
	      (!srcPath[0] || srcPath[0].charAt(0) !== '/')) {
	    srcPath.unshift('');
	  }
	
	  if (hasTrailingSlash && (srcPath.join('/').substr(-1) !== '/')) {
	    srcPath.push('');
	  }
	
	  var isAbsolute = srcPath[0] === '' ||
	      (srcPath[0] && srcPath[0].charAt(0) === '/');
	
	  // put the host back
	  if (psychotic) {
	    result.hostname = result.host = isAbsolute ? '' :
	                                    srcPath.length ? srcPath.shift() : '';
	    //occationaly the auth can get stuck only in host
	    //this especially happens in cases like
	    //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
	    var authInHost = result.host && result.host.indexOf('@') > 0 ?
	                     result.host.split('@') : false;
	    if (authInHost) {
	      result.auth = authInHost.shift();
	      result.host = result.hostname = authInHost.shift();
	    }
	  }
	
	  mustEndAbs = mustEndAbs || (result.host && srcPath.length);
	
	  if (mustEndAbs && !isAbsolute) {
	    srcPath.unshift('');
	  }
	
	  if (!srcPath.length) {
	    result.pathname = null;
	    result.path = null;
	  } else {
	    result.pathname = srcPath.join('/');
	  }
	
	  //to support request.http
	  if (!util.isNull(result.pathname) || !util.isNull(result.search)) {
	    result.path = (result.pathname ? result.pathname : '') +
	                  (result.search ? result.search : '');
	  }
	  result.auth = relative.auth || result.auth;
	  result.slashes = result.slashes || relative.slashes;
	  result.href = result.format();
	  return result;
	};
	
	Url.prototype.parseHost = function() {
	  var host = this.host;
	  var port = portPattern.exec(host);
	  if (port) {
	    port = port[0];
	    if (port !== ':') {
	      this.port = port.substr(1);
	    }
	    host = host.substr(0, host.length - port.length);
	  }
	  if (host) this.hostname = host;
	};


/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/* WEBPACK VAR INJECTION */(function(module, global) {/*! https://mths.be/punycode v1.3.2 by @mathias */
	;(function(root) {
	
		/** Detect free variables */
		var freeExports = typeof exports == 'object' && exports &&
			!exports.nodeType && exports;
		var freeModule = typeof module == 'object' && module &&
			!module.nodeType && module;
		var freeGlobal = typeof global == 'object' && global;
		if (
			freeGlobal.global === freeGlobal ||
			freeGlobal.window === freeGlobal ||
			freeGlobal.self === freeGlobal
		) {
			root = freeGlobal;
		}
	
		/**
		 * The `punycode` object.
		 * @name punycode
		 * @type Object
		 */
		var punycode,
	
		/** Highest positive signed 32-bit float value */
		maxInt = 2147483647, // aka. 0x7FFFFFFF or 2^31-1
	
		/** Bootstring parameters */
		base = 36,
		tMin = 1,
		tMax = 26,
		skew = 38,
		damp = 700,
		initialBias = 72,
		initialN = 128, // 0x80
		delimiter = '-', // '\x2D'
	
		/** Regular expressions */
		regexPunycode = /^xn--/,
		regexNonASCII = /[^\x20-\x7E]/, // unprintable ASCII chars + non-ASCII chars
		regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g, // RFC 3490 separators
	
		/** Error messages */
		errors = {
			'overflow': 'Overflow: input needs wider integers to process',
			'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
			'invalid-input': 'Invalid input'
		},
	
		/** Convenience shortcuts */
		baseMinusTMin = base - tMin,
		floor = Math.floor,
		stringFromCharCode = String.fromCharCode,
	
		/** Temporary variable */
		key;
	
		/*--------------------------------------------------------------------------*/
	
		/**
		 * A generic error utility function.
		 * @private
		 * @param {String} type The error type.
		 * @returns {Error} Throws a `RangeError` with the applicable error message.
		 */
		function error(type) {
			throw RangeError(errors[type]);
		}
	
		/**
		 * A generic `Array#map` utility function.
		 * @private
		 * @param {Array} array The array to iterate over.
		 * @param {Function} callback The function that gets called for every array
		 * item.
		 * @returns {Array} A new array of values returned by the callback function.
		 */
		function map(array, fn) {
			var length = array.length;
			var result = [];
			while (length--) {
				result[length] = fn(array[length]);
			}
			return result;
		}
	
		/**
		 * A simple `Array#map`-like wrapper to work with domain name strings or email
		 * addresses.
		 * @private
		 * @param {String} domain The domain name or email address.
		 * @param {Function} callback The function that gets called for every
		 * character.
		 * @returns {Array} A new string of characters returned by the callback
		 * function.
		 */
		function mapDomain(string, fn) {
			var parts = string.split('@');
			var result = '';
			if (parts.length > 1) {
				// In email addresses, only the domain name should be punycoded. Leave
				// the local part (i.e. everything up to `@`) intact.
				result = parts[0] + '@';
				string = parts[1];
			}
			// Avoid `split(regex)` for IE8 compatibility. See #17.
			string = string.replace(regexSeparators, '\x2E');
			var labels = string.split('.');
			var encoded = map(labels, fn).join('.');
			return result + encoded;
		}
	
		/**
		 * Creates an array containing the numeric code points of each Unicode
		 * character in the string. While JavaScript uses UCS-2 internally,
		 * this function will convert a pair of surrogate halves (each of which
		 * UCS-2 exposes as separate characters) into a single code point,
		 * matching UTF-16.
		 * @see `punycode.ucs2.encode`
		 * @see <https://mathiasbynens.be/notes/javascript-encoding>
		 * @memberOf punycode.ucs2
		 * @name decode
		 * @param {String} string The Unicode input string (UCS-2).
		 * @returns {Array} The new array of code points.
		 */
		function ucs2decode(string) {
			var output = [],
			    counter = 0,
			    length = string.length,
			    value,
			    extra;
			while (counter < length) {
				value = string.charCodeAt(counter++);
				if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
					// high surrogate, and there is a next character
					extra = string.charCodeAt(counter++);
					if ((extra & 0xFC00) == 0xDC00) { // low surrogate
						output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
					} else {
						// unmatched surrogate; only append this code unit, in case the next
						// code unit is the high surrogate of a surrogate pair
						output.push(value);
						counter--;
					}
				} else {
					output.push(value);
				}
			}
			return output;
		}
	
		/**
		 * Creates a string based on an array of numeric code points.
		 * @see `punycode.ucs2.decode`
		 * @memberOf punycode.ucs2
		 * @name encode
		 * @param {Array} codePoints The array of numeric code points.
		 * @returns {String} The new Unicode string (UCS-2).
		 */
		function ucs2encode(array) {
			return map(array, function(value) {
				var output = '';
				if (value > 0xFFFF) {
					value -= 0x10000;
					output += stringFromCharCode(value >>> 10 & 0x3FF | 0xD800);
					value = 0xDC00 | value & 0x3FF;
				}
				output += stringFromCharCode(value);
				return output;
			}).join('');
		}
	
		/**
		 * Converts a basic code point into a digit/integer.
		 * @see `digitToBasic()`
		 * @private
		 * @param {Number} codePoint The basic numeric code point value.
		 * @returns {Number} The numeric value of a basic code point (for use in
		 * representing integers) in the range `0` to `base - 1`, or `base` if
		 * the code point does not represent a value.
		 */
		function basicToDigit(codePoint) {
			if (codePoint - 48 < 10) {
				return codePoint - 22;
			}
			if (codePoint - 65 < 26) {
				return codePoint - 65;
			}
			if (codePoint - 97 < 26) {
				return codePoint - 97;
			}
			return base;
		}
	
		/**
		 * Converts a digit/integer into a basic code point.
		 * @see `basicToDigit()`
		 * @private
		 * @param {Number} digit The numeric value of a basic code point.
		 * @returns {Number} The basic code point whose value (when used for
		 * representing integers) is `digit`, which needs to be in the range
		 * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
		 * used; else, the lowercase form is used. The behavior is undefined
		 * if `flag` is non-zero and `digit` has no uppercase form.
		 */
		function digitToBasic(digit, flag) {
			//  0..25 map to ASCII a..z or A..Z
			// 26..35 map to ASCII 0..9
			return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
		}
	
		/**
		 * Bias adaptation function as per section 3.4 of RFC 3492.
		 * http://tools.ietf.org/html/rfc3492#section-3.4
		 * @private
		 */
		function adapt(delta, numPoints, firstTime) {
			var k = 0;
			delta = firstTime ? floor(delta / damp) : delta >> 1;
			delta += floor(delta / numPoints);
			for (/* no initialization */; delta > baseMinusTMin * tMax >> 1; k += base) {
				delta = floor(delta / baseMinusTMin);
			}
			return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
		}
	
		/**
		 * Converts a Punycode string of ASCII-only symbols to a string of Unicode
		 * symbols.
		 * @memberOf punycode
		 * @param {String} input The Punycode string of ASCII-only symbols.
		 * @returns {String} The resulting string of Unicode symbols.
		 */
		function decode(input) {
			// Don't use UCS-2
			var output = [],
			    inputLength = input.length,
			    out,
			    i = 0,
			    n = initialN,
			    bias = initialBias,
			    basic,
			    j,
			    index,
			    oldi,
			    w,
			    k,
			    digit,
			    t,
			    /** Cached calculation results */
			    baseMinusT;
	
			// Handle the basic code points: let `basic` be the number of input code
			// points before the last delimiter, or `0` if there is none, then copy
			// the first basic code points to the output.
	
			basic = input.lastIndexOf(delimiter);
			if (basic < 0) {
				basic = 0;
			}
	
			for (j = 0; j < basic; ++j) {
				// if it's not a basic code point
				if (input.charCodeAt(j) >= 0x80) {
					error('not-basic');
				}
				output.push(input.charCodeAt(j));
			}
	
			// Main decoding loop: start just after the last delimiter if any basic code
			// points were copied; start at the beginning otherwise.
	
			for (index = basic > 0 ? basic + 1 : 0; index < inputLength; /* no final expression */) {
	
				// `index` is the index of the next character to be consumed.
				// Decode a generalized variable-length integer into `delta`,
				// which gets added to `i`. The overflow checking is easier
				// if we increase `i` as we go, then subtract off its starting
				// value at the end to obtain `delta`.
				for (oldi = i, w = 1, k = base; /* no condition */; k += base) {
	
					if (index >= inputLength) {
						error('invalid-input');
					}
	
					digit = basicToDigit(input.charCodeAt(index++));
	
					if (digit >= base || digit > floor((maxInt - i) / w)) {
						error('overflow');
					}
	
					i += digit * w;
					t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
	
					if (digit < t) {
						break;
					}
	
					baseMinusT = base - t;
					if (w > floor(maxInt / baseMinusT)) {
						error('overflow');
					}
	
					w *= baseMinusT;
	
				}
	
				out = output.length + 1;
				bias = adapt(i - oldi, out, oldi == 0);
	
				// `i` was supposed to wrap around from `out` to `0`,
				// incrementing `n` each time, so we'll fix that now:
				if (floor(i / out) > maxInt - n) {
					error('overflow');
				}
	
				n += floor(i / out);
				i %= out;
	
				// Insert `n` at position `i` of the output
				output.splice(i++, 0, n);
	
			}
	
			return ucs2encode(output);
		}
	
		/**
		 * Converts a string of Unicode symbols (e.g. a domain name label) to a
		 * Punycode string of ASCII-only symbols.
		 * @memberOf punycode
		 * @param {String} input The string of Unicode symbols.
		 * @returns {String} The resulting Punycode string of ASCII-only symbols.
		 */
		function encode(input) {
			var n,
			    delta,
			    handledCPCount,
			    basicLength,
			    bias,
			    j,
			    m,
			    q,
			    k,
			    t,
			    currentValue,
			    output = [],
			    /** `inputLength` will hold the number of code points in `input`. */
			    inputLength,
			    /** Cached calculation results */
			    handledCPCountPlusOne,
			    baseMinusT,
			    qMinusT;
	
			// Convert the input in UCS-2 to Unicode
			input = ucs2decode(input);
	
			// Cache the length
			inputLength = input.length;
	
			// Initialize the state
			n = initialN;
			delta = 0;
			bias = initialBias;
	
			// Handle the basic code points
			for (j = 0; j < inputLength; ++j) {
				currentValue = input[j];
				if (currentValue < 0x80) {
					output.push(stringFromCharCode(currentValue));
				}
			}
	
			handledCPCount = basicLength = output.length;
	
			// `handledCPCount` is the number of code points that have been handled;
			// `basicLength` is the number of basic code points.
	
			// Finish the basic string - if it is not empty - with a delimiter
			if (basicLength) {
				output.push(delimiter);
			}
	
			// Main encoding loop:
			while (handledCPCount < inputLength) {
	
				// All non-basic code points < n have been handled already. Find the next
				// larger one:
				for (m = maxInt, j = 0; j < inputLength; ++j) {
					currentValue = input[j];
					if (currentValue >= n && currentValue < m) {
						m = currentValue;
					}
				}
	
				// Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
				// but guard against overflow
				handledCPCountPlusOne = handledCPCount + 1;
				if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
					error('overflow');
				}
	
				delta += (m - n) * handledCPCountPlusOne;
				n = m;
	
				for (j = 0; j < inputLength; ++j) {
					currentValue = input[j];
	
					if (currentValue < n && ++delta > maxInt) {
						error('overflow');
					}
	
					if (currentValue == n) {
						// Represent delta as a generalized variable-length integer
						for (q = delta, k = base; /* no condition */; k += base) {
							t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
							if (q < t) {
								break;
							}
							qMinusT = q - t;
							baseMinusT = base - t;
							output.push(
								stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
							);
							q = floor(qMinusT / baseMinusT);
						}
	
						output.push(stringFromCharCode(digitToBasic(q, 0)));
						bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
						delta = 0;
						++handledCPCount;
					}
				}
	
				++delta;
				++n;
	
			}
			return output.join('');
		}
	
		/**
		 * Converts a Punycode string representing a domain name or an email address
		 * to Unicode. Only the Punycoded parts of the input will be converted, i.e.
		 * it doesn't matter if you call it on a string that has already been
		 * converted to Unicode.
		 * @memberOf punycode
		 * @param {String} input The Punycoded domain name or email address to
		 * convert to Unicode.
		 * @returns {String} The Unicode representation of the given Punycode
		 * string.
		 */
		function toUnicode(input) {
			return mapDomain(input, function(string) {
				return regexPunycode.test(string)
					? decode(string.slice(4).toLowerCase())
					: string;
			});
		}
	
		/**
		 * Converts a Unicode string representing a domain name or an email address to
		 * Punycode. Only the non-ASCII parts of the domain name will be converted,
		 * i.e. it doesn't matter if you call it with a domain that's already in
		 * ASCII.
		 * @memberOf punycode
		 * @param {String} input The domain name or email address to convert, as a
		 * Unicode string.
		 * @returns {String} The Punycode representation of the given domain name or
		 * email address.
		 */
		function toASCII(input) {
			return mapDomain(input, function(string) {
				return regexNonASCII.test(string)
					? 'xn--' + encode(string)
					: string;
			});
		}
	
		/*--------------------------------------------------------------------------*/
	
		/** Define the public API */
		punycode = {
			/**
			 * A string representing the current Punycode.js version number.
			 * @memberOf punycode
			 * @type String
			 */
			'version': '1.3.2',
			/**
			 * An object of methods to convert from JavaScript's internal character
			 * representation (UCS-2) to Unicode code points, and back.
			 * @see <https://mathiasbynens.be/notes/javascript-encoding>
			 * @memberOf punycode
			 * @type Object
			 */
			'ucs2': {
				'decode': ucs2decode,
				'encode': ucs2encode
			},
			'decode': decode,
			'encode': encode,
			'toASCII': toASCII,
			'toUnicode': toUnicode
		};
	
		/** Expose `punycode` */
		// Some AMD build optimizers, like r.js, check for specific condition patterns
		// like the following:
		if (
			true
		) {
			!(__WEBPACK_AMD_DEFINE_RESULT__ = function() {
				return punycode;
			}.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
		} else if (freeExports && freeModule) {
			if (module.exports == freeExports) { // in Node.js or RingoJS v0.8.0+
				freeModule.exports = punycode;
			} else { // in Narwhal or RingoJS v0.7.0-
				for (key in punycode) {
					punycode.hasOwnProperty(key) && (freeExports[key] = punycode[key]);
				}
			}
		} else { // in Rhino or a web browser
			root.punycode = punycode;
		}
	
	}(this));
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(9)(module), (function() { return this; }())))

/***/ },
/* 9 */
/***/ function(module, exports) {

	module.exports = function(module) {
		if(!module.webpackPolyfill) {
			module.deprecate = function() {};
			module.paths = [];
			// module.parent = undefined by default
			module.children = [];
			module.webpackPolyfill = 1;
		}
		return module;
	}


/***/ },
/* 10 */
/***/ function(module, exports) {

	'use strict';
	
	module.exports = {
	  isString: function(arg) {
	    return typeof(arg) === 'string';
	  },
	  isObject: function(arg) {
	    return typeof(arg) === 'object' && arg !== null;
	  },
	  isNull: function(arg) {
	    return arg === null;
	  },
	  isNullOrUndefined: function(arg) {
	    return arg == null;
	  }
	};


/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';
	
	exports.decode = exports.parse = __webpack_require__(12);
	exports.encode = exports.stringify = __webpack_require__(13);


/***/ },
/* 12 */
/***/ function(module, exports) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	'use strict';
	
	// If obj.hasOwnProperty has been overridden, then calling
	// obj.hasOwnProperty(prop) will break.
	// See: https://github.com/joyent/node/issues/1707
	function hasOwnProperty(obj, prop) {
	  return Object.prototype.hasOwnProperty.call(obj, prop);
	}
	
	module.exports = function(qs, sep, eq, options) {
	  sep = sep || '&';
	  eq = eq || '=';
	  var obj = {};
	
	  if (typeof qs !== 'string' || qs.length === 0) {
	    return obj;
	  }
	
	  var regexp = /\+/g;
	  qs = qs.split(sep);
	
	  var maxKeys = 1000;
	  if (options && typeof options.maxKeys === 'number') {
	    maxKeys = options.maxKeys;
	  }
	
	  var len = qs.length;
	  // maxKeys <= 0 means that we should not limit keys count
	  if (maxKeys > 0 && len > maxKeys) {
	    len = maxKeys;
	  }
	
	  for (var i = 0; i < len; ++i) {
	    var x = qs[i].replace(regexp, '%20'),
	        idx = x.indexOf(eq),
	        kstr, vstr, k, v;
	
	    if (idx >= 0) {
	      kstr = x.substr(0, idx);
	      vstr = x.substr(idx + 1);
	    } else {
	      kstr = x;
	      vstr = '';
	    }
	
	    k = decodeURIComponent(kstr);
	    v = decodeURIComponent(vstr);
	
	    if (!hasOwnProperty(obj, k)) {
	      obj[k] = v;
	    } else if (Array.isArray(obj[k])) {
	      obj[k].push(v);
	    } else {
	      obj[k] = [obj[k], v];
	    }
	  }
	
	  return obj;
	};


/***/ },
/* 13 */
/***/ function(module, exports) {

	// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	'use strict';
	
	var stringifyPrimitive = function(v) {
	  switch (typeof v) {
	    case 'string':
	      return v;
	
	    case 'boolean':
	      return v ? 'true' : 'false';
	
	    case 'number':
	      return isFinite(v) ? v : '';
	
	    default:
	      return '';
	  }
	};
	
	module.exports = function(obj, sep, eq, name) {
	  sep = sep || '&';
	  eq = eq || '=';
	  if (obj === null) {
	    obj = undefined;
	  }
	
	  if (typeof obj === 'object') {
	    return Object.keys(obj).map(function(k) {
	      var ks = encodeURIComponent(stringifyPrimitive(k)) + eq;
	      if (Array.isArray(obj[k])) {
	        return obj[k].map(function(v) {
	          return ks + encodeURIComponent(stringifyPrimitive(v));
	        }).join(sep);
	      } else {
	        return ks + encodeURIComponent(stringifyPrimitive(obj[k]));
	      }
	    }).join(sep);
	
	  }
	
	  if (!name) return '';
	  return encodeURIComponent(stringifyPrimitive(name)) + eq +
	         encodeURIComponent(stringifyPrimitive(obj));
	};


/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (name, context, definition) {
	  if (typeof module !== 'undefined' && module.exports) module.exports = definition();
	  else if (true) !(__WEBPACK_AMD_DEFINE_FACTORY__ = (definition), __WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ? (__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) : __WEBPACK_AMD_DEFINE_FACTORY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	  else context[name] = definition();
	})('urljoin', this, function () {
	
	  function normalize (str, options) {
	
	    // make sure protocol is followed by two slashes
	    str = str.replace(/:\//g, '://');
	
	    // remove consecutive slashes
	    str = str.replace(/([^:\s])\/+/g, '$1/');
	
	    // remove trailing slash before parameters or hash
	    str = str.replace(/\/(\?|&|#[^!])/g, '$1');
	
	    // replace ? in parameters with &
	    str = str.replace(/(\?.+)\?/g, '$1&');
	
	    return str;
	  }
	
	  return function () {
	    var input = arguments;
	    var options = {};
	
	    if (typeof arguments[0] === 'object') {
	      // new syntax with array and options
	      input = arguments[0];
	      options = arguments[1] || {};
	    }
	
	    var joined = [].slice.call(input, 0).join('/');
	    return normalize(joined, options);
	  };
	
	});


/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var posix = __webpack_require__(16);
	var signaling_1 = __webpack_require__(20);
	var utils = __webpack_require__(4);
	var validate = __webpack_require__(22);
	/**
	 * The url for the contents service.
	 */
	var SERVICE_CONTENTS_URL = 'api/contents';
	/**
	 * The url for the file access.
	 */
	var FILES_URL = 'files';
	/**
	 * A contents manager that passes file operations to the server.
	 *
	 * This includes checkpointing with the normal file operations.
	 */
	var ContentsManager = (function () {
	    /**
	     * Construct a new contents manager object.
	     *
	     * @param options - The options used to initialize the object.
	     */
	    function ContentsManager(options) {
	        if (options === void 0) { options = {}; }
	        this._baseUrl = '';
	        this._isDisposed = false;
	        this._ajaxSettings = null;
	        this._baseUrl = options.baseUrl || utils.getBaseUrl();
	        this._ajaxSettings = utils.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	    }
	    Object.defineProperty(ContentsManager.prototype, "isDisposed", {
	        /**
	         * Test whether the manager has been disposed.
	         */
	        get: function () {
	            return this._isDisposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources held by the manager.
	     */
	    ContentsManager.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._isDisposed = true;
	        signaling_1.clearSignalData(this);
	    };
	    Object.defineProperty(ContentsManager.prototype, "baseUrl", {
	        /**
	         * Get the base url of the manager.
	         */
	        get: function () {
	            return this._baseUrl;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ContentsManager.prototype, "ajaxSettings", {
	        /**
	         * Get a copy of the default ajax settings for the contents manager.
	         */
	        get: function () {
	            return utils.copy(this._ajaxSettings);
	        },
	        /**
	         * Set the default ajax settings for the contents manager.
	         */
	        set: function (value) {
	            this._ajaxSettings = utils.copy(value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get a file or directory.
	     *
	     * @param path: The path to the file.
	     *
	     * @param options: The options used to fetch the file.
	     *
	     * @returns A promise which resolves with the file content.
	     *
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents) and validates the response model.
	     */
	    ContentsManager.prototype.get = function (path, options) {
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        var url = this._getUrl(path);
	        if (options) {
	            // The notebook type cannot take an format option.
	            if (options.type === 'notebook') {
	                delete options['format'];
	            }
	            var params = utils.copy(options);
	            params.content = options.content ? '1' : '0';
	            url += utils.jsonToQueryString(params);
	        }
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                return utils.makeAjaxError(success);
	            }
	            try {
	                validate.validateContentsModel(success.data);
	            }
	            catch (err) {
	                return utils.makeAjaxError(success, err.message);
	            }
	            return success.data;
	        });
	    };
	    /**
	     * Get an encoded download url given a file path.
	     *
	     * @param path - An absolute POSIX file path on the server.
	     *
	     * #### Notes
	     * It is expected that the path contains no relative paths,
	     * use [[ContentsManager.getAbsolutePath]] to get an absolute
	     * path if necessary.
	     */
	    ContentsManager.prototype.getDownloadUrl = function (path) {
	        return utils.urlPathJoin(this._baseUrl, FILES_URL, utils.urlEncodeParts(path));
	    };
	    /**
	     * Create a new untitled file or directory in the specified directory path.
	     *
	     * @param options: The options used to create the file.
	     *
	     * @returns A promise which resolves with the created file content when the
	     *    file is created.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents) and validates the response model.
	     */
	    ContentsManager.prototype.newUntitled = function (options) {
	        var _this = this;
	        if (options === void 0) { options = {}; }
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'POST';
	        ajaxSettings.dataType = 'json';
	        if (options) {
	            if (options.ext) {
	                options.ext = ContentsManager.normalizeExtension(options.ext);
	            }
	            ajaxSettings.data = JSON.stringify(options);
	            ajaxSettings.contentType = 'application/json';
	        }
	        var url = this._getUrl(options.path || '');
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 201) {
	                return utils.makeAjaxError(success);
	            }
	            var data = success.data;
	            try {
	                validate.validateContentsModel(data);
	            }
	            catch (err) {
	                return utils.makeAjaxError(success, err.message);
	            }
	            _this.fileChanged.emit({
	                type: 'new',
	                oldValue: null,
	                newValue: data
	            });
	            return data;
	        });
	    };
	    /**
	     * Delete a file.
	     *
	     * @param path - The path to the file.
	     *
	     * @returns A promise which resolves when the file is deleted.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents).
	     */
	    ContentsManager.prototype.delete = function (path) {
	        var _this = this;
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'DELETE';
	        ajaxSettings.dataType = 'json';
	        var url = this._getUrl(path);
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                return utils.makeAjaxError(success);
	            }
	            _this.fileChanged.emit({
	                type: 'delete',
	                oldValue: { path: path },
	                newValue: null
	            });
	        }, function (error) {
	            // Translate certain errors to more specific ones.
	            // TODO: update IPEP27 to specify errors more precisely, so
	            // that error types can be detected here with certainty.
	            if (error.xhr.status === 400) {
	                var err = JSON.parse(error.xhr.response);
	                if (err.message) {
	                    error.throwError = err.message;
	                }
	            }
	            return Promise.reject(error);
	        });
	    };
	    /**
	     * Rename a file or directory.
	     *
	     * @param path - The original file path.
	     *
	     * @param newPath - The new file path.
	     *
	     * @returns A promise which resolves with the new file contents model when
	     *   the file is renamed.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents) and validates the response model.
	     */
	    ContentsManager.prototype.rename = function (path, newPath) {
	        var _this = this;
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'PATCH';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.data = JSON.stringify({ path: newPath });
	        var url = this._getUrl(path);
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                return utils.makeAjaxError(success);
	            }
	            var data = success.data;
	            try {
	                validate.validateContentsModel(data);
	            }
	            catch (err) {
	                return utils.makeAjaxError(success, err.message);
	            }
	            _this.fileChanged.emit({
	                type: 'rename',
	                oldValue: { path: path },
	                newValue: data
	            });
	            return data;
	        });
	    };
	    /**
	     * Save a file.
	     *
	     * @param path - The desired file path.
	     *
	     * @param options - Optional overrides to the model.
	     *
	     * @returns A promise which resolves with the file content model when the
	     *   file is saved.
	     *
	     * #### Notes
	     * Ensure that `model.content` is populated for the file.
	     *
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents) and validates the response model.
	     */
	    ContentsManager.prototype.save = function (path, options) {
	        var _this = this;
	        if (options === void 0) { options = {}; }
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'PUT';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.data = JSON.stringify(options);
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.cache = false;
	        var url = this._getUrl(path);
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            // will return 200 for an existing file and 201 for a new file
	            if (success.xhr.status !== 200 && success.xhr.status !== 201) {
	                return utils.makeAjaxError(success);
	            }
	            var data = success.data;
	            try {
	                validate.validateContentsModel(data);
	            }
	            catch (err) {
	                return utils.makeAjaxError(success, err.message);
	            }
	            _this.fileChanged.emit({
	                type: 'save',
	                oldValue: null,
	                newValue: data
	            });
	            return data;
	        });
	    };
	    /**
	     * Copy a file into a given directory.
	     *
	     * @param path - The original file path.
	     *
	     * @param toDir - The destination directory path.
	     *
	     * @returns A promise which resolves with the new contents model when the
	     *  file is copied.
	     *
	     * #### Notes
	     * The server will select the name of the copied file.
	     *
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents) and validates the response model.
	     */
	    ContentsManager.prototype.copy = function (fromFile, toDir) {
	        var _this = this;
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'POST';
	        ajaxSettings.data = JSON.stringify({ copy_from: fromFile });
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.dataType = 'json';
	        var url = this._getUrl(toDir);
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 201) {
	                return utils.makeAjaxError(success);
	            }
	            var data = success.data;
	            try {
	                validate.validateContentsModel(data);
	            }
	            catch (err) {
	                return utils.makeAjaxError(success, err.message);
	            }
	            _this.fileChanged.emit({
	                type: 'new',
	                oldValue: null,
	                newValue: data
	            });
	            return data;
	        });
	    };
	    /**
	     * Create a checkpoint for a file.
	     *
	     * @param path - The path of the file.
	     *
	     * @returns A promise which resolves with the new checkpoint model when the
	     *   checkpoint is created.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents) and validates the response model.
	     */
	    ContentsManager.prototype.createCheckpoint = function (path) {
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'POST';
	        ajaxSettings.dataType = 'json';
	        var url = this._getUrl(path, 'checkpoints');
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 201) {
	                return utils.makeAjaxError(success);
	            }
	            try {
	                validate.validateCheckpointModel(success.data);
	            }
	            catch (err) {
	                return utils.makeAjaxError(success, err.message);
	            }
	            return success.data;
	        });
	    };
	    /**
	     * List available checkpoints for a file.
	     *
	     * @param path - The path of the file.
	     *
	     * @returns A promise which resolves with a list of checkpoint models for
	     *    the file.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents) and validates the response model.
	     */
	    ContentsManager.prototype.listCheckpoints = function (path) {
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        var url = this._getUrl(path, 'checkpoints');
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                return utils.makeAjaxError(success);
	            }
	            if (!Array.isArray(success.data)) {
	                return utils.makeAjaxError(success, 'Invalid Checkpoint list');
	            }
	            for (var i = 0; i < success.data.length; i++) {
	                try {
	                    validate.validateCheckpointModel(success.data[i]);
	                }
	                catch (err) {
	                    return utils.makeAjaxError(success, err.message);
	                }
	            }
	            return success.data;
	        });
	    };
	    /**
	     * Restore a file to a known checkpoint state.
	     *
	     * @param path - The path of the file.
	     *
	     * @param checkpointID - The id of the checkpoint to restore.
	     *
	     * @returns A promise which resolves when the checkpoint is restored.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents).
	     */
	    ContentsManager.prototype.restoreCheckpoint = function (path, checkpointID) {
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'POST';
	        ajaxSettings.dataType = 'json';
	        var url = this._getUrl(path, 'checkpoints', checkpointID);
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                return utils.makeAjaxError(success);
	            }
	        });
	    };
	    /**
	     * Delete a checkpoint for a file.
	     *
	     * @param path - The path of the file.
	     *
	     * @param checkpointID - The id of the checkpoint to delete.
	     *
	     * @returns A promise which resolves when the checkpoint is deleted.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents).
	     */
	    ContentsManager.prototype.deleteCheckpoint = function (path, checkpointID) {
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'DELETE';
	        ajaxSettings.dataType = 'json';
	        var url = this._getUrl(path, 'checkpoints', checkpointID);
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                return utils.makeAjaxError(success);
	            }
	        });
	    };
	    /**
	     * Get a REST url for a file given a path.
	     */
	    ContentsManager.prototype._getUrl = function () {
	        var args = [];
	        for (var _i = 0; _i < arguments.length; _i++) {
	            args[_i - 0] = arguments[_i];
	        }
	        var parts = args.map(function (path) { return utils.urlEncodeParts(path); });
	        return utils.urlPathJoin.apply(utils, [this._baseUrl, SERVICE_CONTENTS_URL].concat(parts));
	    };
	    return ContentsManager;
	}());
	exports.ContentsManager = ContentsManager;
	// Define the signals for the `ContentsManager` class.
	signaling_1.defineSignal(ContentsManager.prototype, 'fileChanged');
	/**
	 * A namespace for ContentsManager statics.
	 */
	var ContentsManager;
	(function (ContentsManager) {
	    /**
	     * Get the absolute POSIX path to a file on the server.
	     *
	     * @param relativePath - The relative POSIX path to the file.
	     *
	     * @param cwd - The optional POSIX current working directory.  The default is
	     *  an empty string.
	     *
	     * #### Notes
	     * Absolute path in this context is equivalent to a POSIX path without
	     * the initial `'/'` because IPEP 27 paths denote `''` as the root.
	     * If the resulting path is not contained within the server root,
	     * returns `null`, since it cannot be served.
	     */
	    function getAbsolutePath(relativePath, cwd) {
	        if (cwd === void 0) { cwd = ''; }
	        // Bail if it looks like a url.
	        var urlObj = utils.urlParse(relativePath);
	        if (urlObj.protocol) {
	            return relativePath;
	        }
	        var norm = posix.normalize(posix.join(cwd, relativePath));
	        if (norm.indexOf('../') === 0) {
	            return null;
	        }
	        return posix.resolve('/', cwd, relativePath).slice(1);
	    }
	    ContentsManager.getAbsolutePath = getAbsolutePath;
	    /**
	     * Get the last portion of a path, similar to the Unix basename command.
	     */
	    function basename(path, ext) {
	        return posix.basename(path, ext);
	    }
	    ContentsManager.basename = basename;
	    /**
	     * Get the directory name of a path, similar to the Unix dirname command.
	     */
	    function dirname(path) {
	        return posix.dirname(path);
	    }
	    ContentsManager.dirname = dirname;
	    /**
	     * Get the extension of the path.
	     *
	     * #### Notes
	     * The extension is the string from the last occurance of the `.`
	     * character to end of string in the last portion of the path.
	     * If there is no `.` in the last portion of the path, or if the first
	     * character of the basename of path [[basename]] is `.`, then an
	     * empty string is returned.
	     */
	    function extname(path) {
	        return posix.extname(path);
	    }
	    ContentsManager.extname = extname;
	    /**
	     * Normalize a file extension to be of the type `'.foo'`.
	     *
	     * Adds a leading dot if not present and converts to lower case.
	     */
	    function normalizeExtension(extension) {
	        if (extension.length > 0 && extension.indexOf('.') !== 0) {
	            extension = "." + extension;
	        }
	        return extension;
	    }
	    ContentsManager.normalizeExtension = normalizeExtension;
	})(ContentsManager = exports.ContentsManager || (exports.ContentsManager = {}));


/***/ },
/* 16 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	'use strict';
	var util = __webpack_require__(17);
	var isString = function (x) {
	  return typeof x === 'string';
	};
	
	
	// resolves . and .. elements in a path array with directory names there
	// must be no slashes or device names (c:\) in the array
	// (so also no leading and trailing slashes - it does not distinguish
	// relative and absolute paths)
	function normalizeArray(parts, allowAboveRoot) {
	  var res = [];
	  for (var i = 0; i < parts.length; i++) {
	    var p = parts[i];
	
	    // ignore empty parts
	    if (!p || p === '.')
	      continue;
	
	    if (p === '..') {
	      if (res.length && res[res.length - 1] !== '..') {
	        res.pop();
	      } else if (allowAboveRoot) {
	        res.push('..');
	      }
	    } else {
	      res.push(p);
	    }
	  }
	
	  return res;
	}
	
	// Split a filename into [root, dir, basename, ext], unix version
	// 'root' is just a slash, or nothing.
	var splitPathRe =
	    /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
	var posix = {};
	
	
	function posixSplitPath(filename) {
	  return splitPathRe.exec(filename).slice(1);
	}
	
	
	// path.resolve([from ...], to)
	// posix version
	posix.resolve = function() {
	  var resolvedPath = '',
	      resolvedAbsolute = false;
	
	  for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
	    var path = (i >= 0) ? arguments[i] : process.cwd();
	
	    // Skip empty and invalid entries
	    if (!isString(path)) {
	      throw new TypeError('Arguments to path.resolve must be strings');
	    } else if (!path) {
	      continue;
	    }
	
	    resolvedPath = path + '/' + resolvedPath;
	    resolvedAbsolute = path.charAt(0) === '/';
	  }
	
	  // At this point the path should be resolved to a full absolute path, but
	  // handle relative paths to be safe (might happen when process.cwd() fails)
	
	  // Normalize the path
	  resolvedPath = normalizeArray(resolvedPath.split('/'),
	                                !resolvedAbsolute).join('/');
	
	  return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
	};
	
	// path.normalize(path)
	// posix version
	posix.normalize = function(path) {
	  var isAbsolute = posix.isAbsolute(path),
	      trailingSlash = path.substr(-1) === '/';
	
	  // Normalize the path
	  path = normalizeArray(path.split('/'), !isAbsolute).join('/');
	
	  if (!path && !isAbsolute) {
	    path = '.';
	  }
	  if (path && trailingSlash) {
	    path += '/';
	  }
	
	  return (isAbsolute ? '/' : '') + path;
	};
	
	// posix version
	posix.isAbsolute = function(path) {
	  return path.charAt(0) === '/';
	};
	
	// posix version
	posix.join = function() {
	  var path = '';
	  for (var i = 0; i < arguments.length; i++) {
	    var segment = arguments[i];
	    if (!isString(segment)) {
	      throw new TypeError('Arguments to path.join must be strings');
	    }
	    if (segment) {
	      if (!path) {
	        path += segment;
	      } else {
	        path += '/' + segment;
	      }
	    }
	  }
	  return posix.normalize(path);
	};
	
	
	// path.relative(from, to)
	// posix version
	posix.relative = function(from, to) {
	  from = posix.resolve(from).substr(1);
	  to = posix.resolve(to).substr(1);
	
	  function trim(arr) {
	    var start = 0;
	    for (; start < arr.length; start++) {
	      if (arr[start] !== '') break;
	    }
	
	    var end = arr.length - 1;
	    for (; end >= 0; end--) {
	      if (arr[end] !== '') break;
	    }
	
	    if (start > end) return [];
	    return arr.slice(start, end + 1);
	  }
	
	  var fromParts = trim(from.split('/'));
	  var toParts = trim(to.split('/'));
	
	  var length = Math.min(fromParts.length, toParts.length);
	  var samePartsLength = length;
	  for (var i = 0; i < length; i++) {
	    if (fromParts[i] !== toParts[i]) {
	      samePartsLength = i;
	      break;
	    }
	  }
	
	  var outputParts = [];
	  for (var i = samePartsLength; i < fromParts.length; i++) {
	    outputParts.push('..');
	  }
	
	  outputParts = outputParts.concat(toParts.slice(samePartsLength));
	
	  return outputParts.join('/');
	};
	
	
	posix._makeLong = function(path) {
	  return path;
	};
	
	
	posix.dirname = function(path) {
	  var result = posixSplitPath(path),
	      root = result[0],
	      dir = result[1];
	
	  if (!root && !dir) {
	    // No dirname whatsoever
	    return '.';
	  }
	
	  if (dir) {
	    // It has a dirname, strip trailing slash
	    dir = dir.substr(0, dir.length - 1);
	  }
	
	  return root + dir;
	};
	
	
	posix.basename = function(path, ext) {
	  var f = posixSplitPath(path)[2];
	  // TODO: make this comparison case-insensitive on windows?
	  if (ext && f.substr(-1 * ext.length) === ext) {
	    f = f.substr(0, f.length - ext.length);
	  }
	  return f;
	};
	
	
	posix.extname = function(path) {
	  return posixSplitPath(path)[3];
	};
	
	
	posix.format = function(pathObject) {
	  if (!util.isObject(pathObject)) {
	    throw new TypeError(
	        "Parameter 'pathObject' must be an object, not " + typeof pathObject
	    );
	  }
	
	  var root = pathObject.root || '';
	
	  if (!isString(root)) {
	    throw new TypeError(
	        "'pathObject.root' must be a string or undefined, not " +
	        typeof pathObject.root
	    );
	  }
	
	  var dir = pathObject.dir ? pathObject.dir + posix.sep : '';
	  var base = pathObject.base || '';
	  return dir + base;
	};
	
	
	posix.parse = function(pathString) {
	  if (!isString(pathString)) {
	    throw new TypeError(
	        "Parameter 'pathString' must be a string, not " + typeof pathString
	    );
	  }
	  var allParts = posixSplitPath(pathString);
	  if (!allParts || allParts.length !== 4) {
	    throw new TypeError("Invalid path '" + pathString + "'");
	  }
	  allParts[1] = allParts[1] || '';
	  allParts[2] = allParts[2] || '';
	  allParts[3] = allParts[3] || '';
	
	  return {
	    root: allParts[0],
	    dir: allParts[0] + allParts[1].slice(0, allParts[1].length - 1),
	    base: allParts[2],
	    ext: allParts[3],
	    name: allParts[2].slice(0, allParts[2].length - allParts[3].length)
	  };
	};
	
	
	posix.sep = '/';
	posix.delimiter = ':';
	
	  module.exports = posix;
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(5)))

/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(global, process) {// Copyright Joyent, Inc. and other Node contributors.
	//
	// Permission is hereby granted, free of charge, to any person obtaining a
	// copy of this software and associated documentation files (the
	// "Software"), to deal in the Software without restriction, including
	// without limitation the rights to use, copy, modify, merge, publish,
	// distribute, sublicense, and/or sell copies of the Software, and to permit
	// persons to whom the Software is furnished to do so, subject to the
	// following conditions:
	//
	// The above copyright notice and this permission notice shall be included
	// in all copies or substantial portions of the Software.
	//
	// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
	// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
	// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
	// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
	// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
	// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
	// USE OR OTHER DEALINGS IN THE SOFTWARE.
	
	var formatRegExp = /%[sdj%]/g;
	exports.format = function(f) {
	  if (!isString(f)) {
	    var objects = [];
	    for (var i = 0; i < arguments.length; i++) {
	      objects.push(inspect(arguments[i]));
	    }
	    return objects.join(' ');
	  }
	
	  var i = 1;
	  var args = arguments;
	  var len = args.length;
	  var str = String(f).replace(formatRegExp, function(x) {
	    if (x === '%%') return '%';
	    if (i >= len) return x;
	    switch (x) {
	      case '%s': return String(args[i++]);
	      case '%d': return Number(args[i++]);
	      case '%j':
	        try {
	          return JSON.stringify(args[i++]);
	        } catch (_) {
	          return '[Circular]';
	        }
	      default:
	        return x;
	    }
	  });
	  for (var x = args[i]; i < len; x = args[++i]) {
	    if (isNull(x) || !isObject(x)) {
	      str += ' ' + x;
	    } else {
	      str += ' ' + inspect(x);
	    }
	  }
	  return str;
	};
	
	
	// Mark that a method should not be used.
	// Returns a modified function which warns once by default.
	// If --no-deprecation is set, then it is a no-op.
	exports.deprecate = function(fn, msg) {
	  // Allow for deprecating things in the process of starting up.
	  if (isUndefined(global.process)) {
	    return function() {
	      return exports.deprecate(fn, msg).apply(this, arguments);
	    };
	  }
	
	  if (process.noDeprecation === true) {
	    return fn;
	  }
	
	  var warned = false;
	  function deprecated() {
	    if (!warned) {
	      if (process.throwDeprecation) {
	        throw new Error(msg);
	      } else if (process.traceDeprecation) {
	        console.trace(msg);
	      } else {
	        console.error(msg);
	      }
	      warned = true;
	    }
	    return fn.apply(this, arguments);
	  }
	
	  return deprecated;
	};
	
	
	var debugs = {};
	var debugEnviron;
	exports.debuglog = function(set) {
	  if (isUndefined(debugEnviron))
	    debugEnviron = process.env.NODE_DEBUG || '';
	  set = set.toUpperCase();
	  if (!debugs[set]) {
	    if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
	      var pid = process.pid;
	      debugs[set] = function() {
	        var msg = exports.format.apply(exports, arguments);
	        console.error('%s %d: %s', set, pid, msg);
	      };
	    } else {
	      debugs[set] = function() {};
	    }
	  }
	  return debugs[set];
	};
	
	
	/**
	 * Echos the value of a value. Trys to print the value out
	 * in the best way possible given the different types.
	 *
	 * @param {Object} obj The object to print out.
	 * @param {Object} opts Optional options object that alters the output.
	 */
	/* legacy: obj, showHidden, depth, colors*/
	function inspect(obj, opts) {
	  // default options
	  var ctx = {
	    seen: [],
	    stylize: stylizeNoColor
	  };
	  // legacy...
	  if (arguments.length >= 3) ctx.depth = arguments[2];
	  if (arguments.length >= 4) ctx.colors = arguments[3];
	  if (isBoolean(opts)) {
	    // legacy...
	    ctx.showHidden = opts;
	  } else if (opts) {
	    // got an "options" object
	    exports._extend(ctx, opts);
	  }
	  // set default options
	  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
	  if (isUndefined(ctx.depth)) ctx.depth = 2;
	  if (isUndefined(ctx.colors)) ctx.colors = false;
	  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
	  if (ctx.colors) ctx.stylize = stylizeWithColor;
	  return formatValue(ctx, obj, ctx.depth);
	}
	exports.inspect = inspect;
	
	
	// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
	inspect.colors = {
	  'bold' : [1, 22],
	  'italic' : [3, 23],
	  'underline' : [4, 24],
	  'inverse' : [7, 27],
	  'white' : [37, 39],
	  'grey' : [90, 39],
	  'black' : [30, 39],
	  'blue' : [34, 39],
	  'cyan' : [36, 39],
	  'green' : [32, 39],
	  'magenta' : [35, 39],
	  'red' : [31, 39],
	  'yellow' : [33, 39]
	};
	
	// Don't use 'blue' not visible on cmd.exe
	inspect.styles = {
	  'special': 'cyan',
	  'number': 'yellow',
	  'boolean': 'yellow',
	  'undefined': 'grey',
	  'null': 'bold',
	  'string': 'green',
	  'date': 'magenta',
	  // "name": intentionally not styling
	  'regexp': 'red'
	};
	
	
	function stylizeWithColor(str, styleType) {
	  var style = inspect.styles[styleType];
	
	  if (style) {
	    return '\u001b[' + inspect.colors[style][0] + 'm' + str +
	           '\u001b[' + inspect.colors[style][1] + 'm';
	  } else {
	    return str;
	  }
	}
	
	
	function stylizeNoColor(str, styleType) {
	  return str;
	}
	
	
	function arrayToHash(array) {
	  var hash = {};
	
	  array.forEach(function(val, idx) {
	    hash[val] = true;
	  });
	
	  return hash;
	}
	
	
	function formatValue(ctx, value, recurseTimes) {
	  // Provide a hook for user-specified inspect functions.
	  // Check that value is an object with an inspect function on it
	  if (ctx.customInspect &&
	      value &&
	      isFunction(value.inspect) &&
	      // Filter out the util module, it's inspect function is special
	      value.inspect !== exports.inspect &&
	      // Also filter out any prototype objects using the circular check.
	      !(value.constructor && value.constructor.prototype === value)) {
	    var ret = value.inspect(recurseTimes, ctx);
	    if (!isString(ret)) {
	      ret = formatValue(ctx, ret, recurseTimes);
	    }
	    return ret;
	  }
	
	  // Primitive types cannot have properties
	  var primitive = formatPrimitive(ctx, value);
	  if (primitive) {
	    return primitive;
	  }
	
	  // Look up the keys of the object.
	  var keys = Object.keys(value);
	  var visibleKeys = arrayToHash(keys);
	
	  if (ctx.showHidden) {
	    keys = Object.getOwnPropertyNames(value);
	  }
	
	  // IE doesn't make error fields non-enumerable
	  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
	  if (isError(value)
	      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
	    return formatError(value);
	  }
	
	  // Some type of object without properties can be shortcutted.
	  if (keys.length === 0) {
	    if (isFunction(value)) {
	      var name = value.name ? ': ' + value.name : '';
	      return ctx.stylize('[Function' + name + ']', 'special');
	    }
	    if (isRegExp(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    }
	    if (isDate(value)) {
	      return ctx.stylize(Date.prototype.toString.call(value), 'date');
	    }
	    if (isError(value)) {
	      return formatError(value);
	    }
	  }
	
	  var base = '', array = false, braces = ['{', '}'];
	
	  // Make Array say that they are Array
	  if (isArray(value)) {
	    array = true;
	    braces = ['[', ']'];
	  }
	
	  // Make functions say that they are functions
	  if (isFunction(value)) {
	    var n = value.name ? ': ' + value.name : '';
	    base = ' [Function' + n + ']';
	  }
	
	  // Make RegExps say that they are RegExps
	  if (isRegExp(value)) {
	    base = ' ' + RegExp.prototype.toString.call(value);
	  }
	
	  // Make dates with properties first say the date
	  if (isDate(value)) {
	    base = ' ' + Date.prototype.toUTCString.call(value);
	  }
	
	  // Make error with message first say the error
	  if (isError(value)) {
	    base = ' ' + formatError(value);
	  }
	
	  if (keys.length === 0 && (!array || value.length == 0)) {
	    return braces[0] + base + braces[1];
	  }
	
	  if (recurseTimes < 0) {
	    if (isRegExp(value)) {
	      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
	    } else {
	      return ctx.stylize('[Object]', 'special');
	    }
	  }
	
	  ctx.seen.push(value);
	
	  var output;
	  if (array) {
	    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
	  } else {
	    output = keys.map(function(key) {
	      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
	    });
	  }
	
	  ctx.seen.pop();
	
	  return reduceToSingleString(output, base, braces);
	}
	
	
	function formatPrimitive(ctx, value) {
	  if (isUndefined(value))
	    return ctx.stylize('undefined', 'undefined');
	  if (isString(value)) {
	    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
	                                             .replace(/'/g, "\\'")
	                                             .replace(/\\"/g, '"') + '\'';
	    return ctx.stylize(simple, 'string');
	  }
	  if (isNumber(value))
	    return ctx.stylize('' + value, 'number');
	  if (isBoolean(value))
	    return ctx.stylize('' + value, 'boolean');
	  // For some reason typeof null is "object", so special case here.
	  if (isNull(value))
	    return ctx.stylize('null', 'null');
	}
	
	
	function formatError(value) {
	  return '[' + Error.prototype.toString.call(value) + ']';
	}
	
	
	function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
	  var output = [];
	  for (var i = 0, l = value.length; i < l; ++i) {
	    if (hasOwnProperty(value, String(i))) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          String(i), true));
	    } else {
	      output.push('');
	    }
	  }
	  keys.forEach(function(key) {
	    if (!key.match(/^\d+$/)) {
	      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
	          key, true));
	    }
	  });
	  return output;
	}
	
	
	function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
	  var name, str, desc;
	  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
	  if (desc.get) {
	    if (desc.set) {
	      str = ctx.stylize('[Getter/Setter]', 'special');
	    } else {
	      str = ctx.stylize('[Getter]', 'special');
	    }
	  } else {
	    if (desc.set) {
	      str = ctx.stylize('[Setter]', 'special');
	    }
	  }
	  if (!hasOwnProperty(visibleKeys, key)) {
	    name = '[' + key + ']';
	  }
	  if (!str) {
	    if (ctx.seen.indexOf(desc.value) < 0) {
	      if (isNull(recurseTimes)) {
	        str = formatValue(ctx, desc.value, null);
	      } else {
	        str = formatValue(ctx, desc.value, recurseTimes - 1);
	      }
	      if (str.indexOf('\n') > -1) {
	        if (array) {
	          str = str.split('\n').map(function(line) {
	            return '  ' + line;
	          }).join('\n').substr(2);
	        } else {
	          str = '\n' + str.split('\n').map(function(line) {
	            return '   ' + line;
	          }).join('\n');
	        }
	      }
	    } else {
	      str = ctx.stylize('[Circular]', 'special');
	    }
	  }
	  if (isUndefined(name)) {
	    if (array && key.match(/^\d+$/)) {
	      return str;
	    }
	    name = JSON.stringify('' + key);
	    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
	      name = name.substr(1, name.length - 2);
	      name = ctx.stylize(name, 'name');
	    } else {
	      name = name.replace(/'/g, "\\'")
	                 .replace(/\\"/g, '"')
	                 .replace(/(^"|"$)/g, "'");
	      name = ctx.stylize(name, 'string');
	    }
	  }
	
	  return name + ': ' + str;
	}
	
	
	function reduceToSingleString(output, base, braces) {
	  var numLinesEst = 0;
	  var length = output.reduce(function(prev, cur) {
	    numLinesEst++;
	    if (cur.indexOf('\n') >= 0) numLinesEst++;
	    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
	  }, 0);
	
	  if (length > 60) {
	    return braces[0] +
	           (base === '' ? '' : base + '\n ') +
	           ' ' +
	           output.join(',\n  ') +
	           ' ' +
	           braces[1];
	  }
	
	  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
	}
	
	
	// NOTE: These type checking functions intentionally don't use `instanceof`
	// because it is fragile and can be easily faked with `Object.create()`.
	function isArray(ar) {
	  return Array.isArray(ar);
	}
	exports.isArray = isArray;
	
	function isBoolean(arg) {
	  return typeof arg === 'boolean';
	}
	exports.isBoolean = isBoolean;
	
	function isNull(arg) {
	  return arg === null;
	}
	exports.isNull = isNull;
	
	function isNullOrUndefined(arg) {
	  return arg == null;
	}
	exports.isNullOrUndefined = isNullOrUndefined;
	
	function isNumber(arg) {
	  return typeof arg === 'number';
	}
	exports.isNumber = isNumber;
	
	function isString(arg) {
	  return typeof arg === 'string';
	}
	exports.isString = isString;
	
	function isSymbol(arg) {
	  return typeof arg === 'symbol';
	}
	exports.isSymbol = isSymbol;
	
	function isUndefined(arg) {
	  return arg === void 0;
	}
	exports.isUndefined = isUndefined;
	
	function isRegExp(re) {
	  return isObject(re) && objectToString(re) === '[object RegExp]';
	}
	exports.isRegExp = isRegExp;
	
	function isObject(arg) {
	  return typeof arg === 'object' && arg !== null;
	}
	exports.isObject = isObject;
	
	function isDate(d) {
	  return isObject(d) && objectToString(d) === '[object Date]';
	}
	exports.isDate = isDate;
	
	function isError(e) {
	  return isObject(e) &&
	      (objectToString(e) === '[object Error]' || e instanceof Error);
	}
	exports.isError = isError;
	
	function isFunction(arg) {
	  return typeof arg === 'function';
	}
	exports.isFunction = isFunction;
	
	function isPrimitive(arg) {
	  return arg === null ||
	         typeof arg === 'boolean' ||
	         typeof arg === 'number' ||
	         typeof arg === 'string' ||
	         typeof arg === 'symbol' ||  // ES6 symbol
	         typeof arg === 'undefined';
	}
	exports.isPrimitive = isPrimitive;
	
	exports.isBuffer = __webpack_require__(18);
	
	function objectToString(o) {
	  return Object.prototype.toString.call(o);
	}
	
	
	function pad(n) {
	  return n < 10 ? '0' + n.toString(10) : n.toString(10);
	}
	
	
	var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
	              'Oct', 'Nov', 'Dec'];
	
	// 26 Feb 16:19:34
	function timestamp() {
	  var d = new Date();
	  var time = [pad(d.getHours()),
	              pad(d.getMinutes()),
	              pad(d.getSeconds())].join(':');
	  return [d.getDate(), months[d.getMonth()], time].join(' ');
	}
	
	
	// log is just a thin wrapper to console.log that prepends a timestamp
	exports.log = function() {
	  console.log('%s - %s', timestamp(), exports.format.apply(exports, arguments));
	};
	
	
	/**
	 * Inherit the prototype methods from one constructor into another.
	 *
	 * The Function.prototype.inherits from lang.js rewritten as a standalone
	 * function (not on Function.prototype). NOTE: If this file is to be loaded
	 * during bootstrapping this function needs to be rewritten using some native
	 * functions as prototype setup using normal JavaScript does not work as
	 * expected during bootstrapping (see mirror.js in r114903).
	 *
	 * @param {function} ctor Constructor function which needs to inherit the
	 *     prototype.
	 * @param {function} superCtor Constructor function to inherit prototype from.
	 */
	exports.inherits = __webpack_require__(19);
	
	exports._extend = function(origin, add) {
	  // Don't do anything if add isn't an object
	  if (!add || !isObject(add)) return origin;
	
	  var keys = Object.keys(add);
	  var i = keys.length;
	  while (i--) {
	    origin[keys[i]] = add[keys[i]];
	  }
	  return origin;
	};
	
	function hasOwnProperty(obj, prop) {
	  return Object.prototype.hasOwnProperty.call(obj, prop);
	}
	
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }()), __webpack_require__(5)))

/***/ },
/* 18 */
/***/ function(module, exports) {

	module.exports = function isBuffer(arg) {
	  return arg && typeof arg === 'object'
	    && typeof arg.copy === 'function'
	    && typeof arg.fill === 'function'
	    && typeof arg.readUInt8 === 'function';
	}

/***/ },
/* 19 */
/***/ function(module, exports) {

	if (typeof Object.create === 'function') {
	  // implementation from standard node.js 'util' module
	  module.exports = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor
	    ctor.prototype = Object.create(superCtor.prototype, {
	      constructor: {
	        value: ctor,
	        enumerable: false,
	        writable: true,
	        configurable: true
	      }
	    });
	  };
	} else {
	  // old school shim for old browsers
	  module.exports = function inherits(ctor, superCtor) {
	    ctor.super_ = superCtor
	    var TempCtor = function () {}
	    TempCtor.prototype = superCtor.prototype
	    ctor.prototype = new TempCtor()
	    ctor.prototype.constructor = ctor
	  }
	}


/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(setImmediate) {/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * Define a signal property on a prototype object.
	 *
	 * @param target - The prototype for the class of interest.
	 *
	 * @param name - The name of the signal property.
	 *
	 * #### Notes
	 * The defined signal property is read-only.
	 *
	 * #### Example
	 * ```typescript
	 * class SomeClass {
	 *   valueChanged: ISignal<SomeClass, number>;
	 * }
	 *
	 * defineSignal(SomeClass.prototype, 'valueChanged');
	 */
	function defineSignal(target, name) {
	    var token = Object.freeze({});
	    Object.defineProperty(target, name, {
	        get: function () { return new Signal(this, token); }
	    });
	}
	exports.defineSignal = defineSignal;
	/**
	 * Remove all connections where the given object is the sender.
	 *
	 * @param sender - The sender object of interest.
	 *
	 * #### Example
	 * ```typescript
	 * disconnectSender(someObject);
	 * ```
	 */
	function disconnectSender(sender) {
	    // If there are no receivers, there is nothing to do.
	    var receiverList = senderData.get(sender);
	    if (receiverList === void 0) {
	        return;
	    }
	    // Clear the connections and schedule a cleanup of the
	    // receiver's corresponding list of sender connections.
	    for (var i = 0, n = receiverList.length; i < n; ++i) {
	        var conn = receiverList[i];
	        var senderList = receiverData.get(conn.thisArg || conn.slot);
	        scheduleCleanup(senderList);
	        conn.token = null;
	    }
	    // Schedule a cleanup of the receiver list.
	    scheduleCleanup(receiverList);
	}
	exports.disconnectSender = disconnectSender;
	/**
	 * Remove all connections where the given object is the receiver.
	 *
	 * @param receiver - The receiver object of interest.
	 *
	 * #### Notes
	 * If a `thisArg` is provided when connecting a signal, that object
	 * is considered the receiver. Otherwise, the `callback` is used as
	 * the receiver.
	 *
	 * #### Example
	 * ```typescript
	 * // disconnect a regular object receiver
	 * disconnectReceiver(myObject);
	 *
	 * // disconnect a plain callback receiver
	 * disconnectReceiver(myCallback);
	 * ```
	 */
	function disconnectReceiver(receiver) {
	    // If there are no senders, there is nothing to do.
	    var senderList = receiverData.get(receiver);
	    if (senderList === void 0) {
	        return;
	    }
	    // Clear the connections and schedule a cleanup of the
	    // senders's corresponding list of receiver connections.
	    for (var i = 0, n = senderList.length; i < n; ++i) {
	        var conn = senderList[i];
	        var receiverList = senderData.get(conn.sender);
	        scheduleCleanup(receiverList);
	        conn.token = null;
	    }
	    // Schedule a cleanup of the sender list.
	    scheduleCleanup(senderList);
	}
	exports.disconnectReceiver = disconnectReceiver;
	/**
	 * Clear all signal data associated with the given object.
	 *
	 * @param obj - The object for which the signal data should be cleared.
	 *
	 * #### Notes
	 * This removes all signal connections where the object is used as
	 * either the sender or the receiver.
	 *
	 * #### Example
	 * ```typescript
	 * clearSignalData(someObject);
	 * ```
	 */
	function clearSignalData(obj) {
	    disconnectSender(obj);
	    disconnectReceiver(obj);
	}
	exports.clearSignalData = clearSignalData;
	/**
	 * A concrete implementation of `ISignal`.
	 */
	var Signal = (function () {
	    /**
	     * Construct a new signal.
	     *
	     * @param sender - The object which owns the signal.
	     *
	     * @param token - The unique token identifying the signal.
	     */
	    function Signal(sender, token) {
	        this._sender = sender;
	        this._token = token;
	    }
	    /**
	     * Connect a slot to the signal.
	     *
	     * @param slot - The slot to invoke when the signal is emitted.
	     *
	     * @param thisArg - The `this` context for the slot. If provided,
	     *   this must be a non-primitive object.
	     *
	     * @returns `true` if the connection succeeds, `false` otherwise.
	     */
	    Signal.prototype.connect = function (slot, thisArg) {
	        return connect(this._sender, this._token, slot, thisArg);
	    };
	    /**
	     * Disconnect a slot from the signal.
	     *
	     * @param slot - The slot to disconnect from the signal.
	     *
	     * @param thisArg - The `this` context for the slot. If provided,
	     *   this must be a non-primitive object.
	     *
	     * @returns `true` if the connection is removed, `false` otherwise.
	     */
	    Signal.prototype.disconnect = function (slot, thisArg) {
	        return disconnect(this._sender, this._token, slot, thisArg);
	    };
	    /**
	     * Emit the signal and invoke the connected slots.
	     *
	     * @param args - The args to pass to the connected slots.
	     */
	    Signal.prototype.emit = function (args) {
	        emit(this._sender, this._token, args);
	    };
	    return Signal;
	}());
	/**
	 * A weak mapping of sender to list of receiver connections.
	 */
	var senderData = new WeakMap();
	/**
	 * A weak mapping of receiver to list of sender connections.
	 */
	var receiverData = new WeakMap();
	/**
	 * A set of connection lists which are pending cleanup.
	 */
	var dirtySet = new Set();
	/**
	 * A local reference to an event loop callback.
	 */
	var defer = (function () {
	    var ok = typeof requestAnimationFrame === 'function';
	    return ok ? requestAnimationFrame : setImmediate;
	})();
	/**
	 * Connect a slot to a signal.
	 *
	 * @param sender - The object emitting the signal.
	 *
	 * @param token - The unique token for the signal.
	 *
	 * @param slot - The slot to connect to the signal.
	 *
	 * @param thisArg - The `this` context for the slot.
	 *
	 * @returns `true` if the connection succeeds, `false` otherwise.
	 *
	 * #### Notes
	 * Signal connections are unique. If a connection already exists for
	 * the given `slot` and `thisArg`, this function returns `false`.
	 *
	 * A newly connected slot will not be invoked until the next time the
	 * signal is emitted, even if the slot is connected while the signal
	 * is dispatching.
	 */
	function connect(sender, token, slot, thisArg) {
	    // Coerce a `null` thisArg to `undefined`.
	    thisArg = thisArg || void 0;
	    // Ensure the sender's receiver list is created.
	    var receiverList = senderData.get(sender);
	    if (receiverList === void 0) {
	        receiverList = [];
	        senderData.set(sender, receiverList);
	    }
	    // Bail if a matching connection already exists.
	    if (findConnection(receiverList, token, slot, thisArg) !== null) {
	        return false;
	    }
	    // Ensure the receiver's sender list is created.
	    var receiver = thisArg || slot;
	    var senderList = receiverData.get(receiver);
	    if (senderList === void 0) {
	        senderList = [];
	        receiverData.set(receiver, senderList);
	    }
	    // Create a new connection and add it to the end of each list.
	    var connection = { sender: sender, token: token, slot: slot, thisArg: thisArg };
	    receiverList.push(connection);
	    senderList.push(connection);
	    // Indicate a successful connection.
	    return true;
	}
	/**
	 * Disconnect a slot from a signal.
	 *
	 * @param sender - The object emitting the signal.
	 *
	 * @param token - The unique token for the signal.
	 *
	 * @param slot - The slot to disconnect from the signal.
	 *
	 * @param thisArg - The `this` context for the slot.
	 *
	 * @returns `true` if the connection is removed, `false` otherwise.
	 *
	 * #### Notes
	 * If no connection exists for the given `slot` and `thisArg`, this
	 * function returns `false`.
	 *
	 * A disconnected slot will no longer be invoked, even if the slot
	 * is disconnected while the signal is dispatching.
	 */
	function disconnect(sender, token, slot, thisArg) {
	    // Coerce a `null` thisArg to `undefined`.
	    thisArg = thisArg || void 0;
	    // Lookup the list of receivers, and bail if none exist.
	    var receiverList = senderData.get(sender);
	    if (receiverList === void 0) {
	        return false;
	    }
	    // Bail if no matching connection exits.
	    var conn = findConnection(receiverList, token, slot, thisArg);
	    if (conn === null) {
	        return false;
	    }
	    // Lookup the list of senders, which is now known to exist.
	    var senderList = receiverData.get(thisArg || slot);
	    // Clear the connection and schedule list cleanup.
	    conn.token = null;
	    scheduleCleanup(receiverList);
	    scheduleCleanup(senderList);
	    // Indicate a successful disconnection.
	    return true;
	}
	/**
	 * Emit a signal and invoke the connected slots.
	 *
	 * @param sender - The object emitting the signal.
	 *
	 * @param token - The unique token for the signal.
	 *
	 * @param args - The args to pass to the connected slots.
	 *
	 * #### Notes
	 * Connected slots are invoked synchronously, in the order in which
	 * they are connected.
	 *
	 * Exceptions thrown by connected slots will be caught and logged.
	 */
	function emit(sender, token, args) {
	    // If there are no receivers, there is nothing to do.
	    var receiverList = senderData.get(sender);
	    if (receiverList === void 0) {
	        return;
	    }
	    // Invoke the connections which match the given token.
	    for (var i = 0, n = receiverList.length; i < n; ++i) {
	        var conn = receiverList[i];
	        if (conn.token === token) {
	            invokeSlot(conn, args);
	        }
	    }
	}
	/**
	 * Safely invoke a non-empty connection.
	 *
	 * @param conn - The connection of interest
	 *
	 * @param args - The arguments to pass to the slot.
	 *
	 * #### Notes
	 * Any exception thrown by the slot will be caught and logged.
	 */
	function invokeSlot(conn, args) {
	    try {
	        conn.slot.call(conn.thisArg, conn.sender, args);
	    }
	    catch (err) {
	        console.error(err);
	    }
	}
	/**
	 * Find a connection which matches the given parameters.
	 *
	 * @param list - The list of connections to search.
	 *
	 * @param token - The unique token for the signal.
	 *
	 * @param slot - The slot of interest.
	 *
	 * @param thisArg - The `this` context for the slot.
	 *
	 * @returns The first connection which matches the supplied parameters,
	 *   or null if no matching connection is found.
	 */
	function findConnection(list, token, slot, thisArg) {
	    for (var i = 0, n = list.length; i < n; ++i) {
	        var conn = list[i];
	        if (conn.token === token &&
	            conn.slot === slot &&
	            conn.thisArg === thisArg) {
	            return conn;
	        }
	    }
	    return null;
	}
	/**
	 * Schedule a cleanup of a connection list.
	 *
	 * @param list - The list of connections to cleanup.
	 *
	 * #### Notes
	 * This will add the list to the dirty set and schedule a deferred
	 * cleanup of the list contents. On cleanup, any connection with a
	 * null token will be removed from the array.
	 */
	function scheduleCleanup(list) {
	    if (dirtySet.size === 0) {
	        defer(cleanupDirtySet);
	    }
	    dirtySet.add(list);
	}
	/**
	 * Cleanup the connection lists in the dirty set.
	 *
	 * #### Notes
	 * This function should only be invoked asynchronously, when the stack
	 * frame is guaranteed to not be on the path of a signal dispatch.
	 */
	function cleanupDirtySet() {
	    dirtySet.forEach(cleanupList);
	    dirtySet.clear();
	}
	/**
	 * Cleanup the dirty connections in a connection list.
	 *
	 * @param list - The list of connection to cleanup.
	 *
	 * #### Notes
	 * This will remove any connection with a null token from the list,
	 * while retaining the relative order of the other connections.
	 *
	 * This function should only be invoked asynchronously, when the stack
	 * frame is guaranteed to not be on the path of a signal dispatch.
	 */
	function cleanupList(list) {
	    var count = 0;
	    for (var i = 0, n = list.length; i < n; ++i) {
	        var conn = list[i];
	        if (conn.token === null) {
	            count++;
	        }
	        else {
	            list[i - count] = conn;
	        }
	    }
	    list.length -= count;
	}
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(21).setImmediate))

/***/ },
/* 21 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(setImmediate, clearImmediate) {var nextTick = __webpack_require__(5).nextTick;
	var apply = Function.prototype.apply;
	var slice = Array.prototype.slice;
	var immediateIds = {};
	var nextImmediateId = 0;
	
	// DOM APIs, for completeness
	
	exports.setTimeout = function() {
	  return new Timeout(apply.call(setTimeout, window, arguments), clearTimeout);
	};
	exports.setInterval = function() {
	  return new Timeout(apply.call(setInterval, window, arguments), clearInterval);
	};
	exports.clearTimeout =
	exports.clearInterval = function(timeout) { timeout.close(); };
	
	function Timeout(id, clearFn) {
	  this._id = id;
	  this._clearFn = clearFn;
	}
	Timeout.prototype.unref = Timeout.prototype.ref = function() {};
	Timeout.prototype.close = function() {
	  this._clearFn.call(window, this._id);
	};
	
	// Does not start the time, just sets up the members needed.
	exports.enroll = function(item, msecs) {
	  clearTimeout(item._idleTimeoutId);
	  item._idleTimeout = msecs;
	};
	
	exports.unenroll = function(item) {
	  clearTimeout(item._idleTimeoutId);
	  item._idleTimeout = -1;
	};
	
	exports._unrefActive = exports.active = function(item) {
	  clearTimeout(item._idleTimeoutId);
	
	  var msecs = item._idleTimeout;
	  if (msecs >= 0) {
	    item._idleTimeoutId = setTimeout(function onTimeout() {
	      if (item._onTimeout)
	        item._onTimeout();
	    }, msecs);
	  }
	};
	
	// That's not how node.js implements it but the exposed api is the same.
	exports.setImmediate = typeof setImmediate === "function" ? setImmediate : function(fn) {
	  var id = nextImmediateId++;
	  var args = arguments.length < 2 ? false : slice.call(arguments, 1);
	
	  immediateIds[id] = true;
	
	  nextTick(function onNextTick() {
	    if (immediateIds[id]) {
	      // fn.call() is faster so we optimize for the common use-case
	      // @see http://jsperf.com/call-apply-segu
	      if (args) {
	        fn.apply(null, args);
	      } else {
	        fn.call(null);
	      }
	      // Prevent ids from leaking
	      exports.clearImmediate(id);
	    }
	  });
	
	  return id;
	};
	
	exports.clearImmediate = typeof clearImmediate === "function" ? clearImmediate : function(id) {
	  delete immediateIds[id];
	};
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(21).setImmediate, __webpack_require__(21).clearImmediate))

/***/ },
/* 22 */
/***/ function(module, exports) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	/**
	 * Validate a property as being on an object, and optionally
	 * of a given type.
	 */
	function validateProperty(object, name, typeName) {
	    if (!object.hasOwnProperty(name)) {
	        throw Error("Missing property '" + name + "'");
	    }
	    if (typeName !== void 0) {
	        var valid = true;
	        var value = object[name];
	        switch (typeName) {
	            case 'array':
	                valid = Array.isArray(value);
	                break;
	            case 'object':
	                valid = typeof value !== 'undefined';
	                break;
	            default:
	                valid = typeof value === typeName;
	        }
	        if (!valid) {
	            throw new Error("Property '" + name + "' is not of type '" + typeName);
	        }
	    }
	}
	/**
	 * Validate an `Contents.IModel` object.
	 */
	function validateContentsModel(model) {
	    validateProperty(model, 'name', 'string');
	    validateProperty(model, 'path', 'string');
	    validateProperty(model, 'type', 'string');
	    validateProperty(model, 'created', 'string');
	    validateProperty(model, 'last_modified', 'string');
	    validateProperty(model, 'mimetype', 'object');
	    validateProperty(model, 'content', 'object');
	    validateProperty(model, 'format', 'object');
	}
	exports.validateContentsModel = validateContentsModel;
	/**
	 * Validate an `Contents.ICheckpointModel` object.
	 */
	function validateCheckpointModel(model) {
	    validateProperty(model, 'id', 'string');
	    validateProperty(model, 'last_modified', 'string');
	}
	exports.validateCheckpointModel = validateCheckpointModel;


/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	'use strict';
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(24));
	__export(__webpack_require__(36));
	__export(__webpack_require__(32));


/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var default_1 = __webpack_require__(25);
	/**
	 * A namespace for kernel types, interfaces, and type checker functions.
	 */
	var Kernel;
	(function (Kernel) {
	    /**
	     * Find a kernel by id.
	     *
	     * #### Notes
	     * If the kernel was already started via `startNewKernel`, we return its
	     * `Kernel.IModel`.
	     *
	     * Otherwise, if `options` are given, we attempt to find to the existing
	     * kernel.
	     * The promise is fulfilled when the kernel is found,
	     * otherwise the promise is rejected.
	     */
	    function findById(id, options) {
	        return default_1.DefaultKernel.findById(id, options);
	    }
	    Kernel.findById = findById;
	    /**
	     * Fetch all of the kernel specs.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernelspecs).
	     */
	    function getSpecs(options) {
	        if (options === void 0) { options = {}; }
	        return default_1.DefaultKernel.getSpecs(options);
	    }
	    Kernel.getSpecs = getSpecs;
	    /**
	     * Fetch the running kernels.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernels) and validates the response model.
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     */
	    function listRunning(options) {
	        if (options === void 0) { options = {}; }
	        return default_1.DefaultKernel.listRunning(options);
	    }
	    Kernel.listRunning = listRunning;
	    /**
	     * Start a new kernel.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernels) and validates the response model.
	     *
	     * If no options are given or the kernel name is not given, the
	     * default kernel will by started by the server.
	     *
	     * Wraps the result in a Kernel object. The promise is fulfilled
	     * when the kernel is started by the server, otherwise the promise is rejected.
	     */
	    function startNew(options) {
	        options = options || {};
	        return default_1.DefaultKernel.startNew(options);
	    }
	    Kernel.startNew = startNew;
	    /**
	     * Connect to a running kernel.
	     *
	     * #### Notes
	     * If the kernel was already started via `startNewKernel`, the existing
	     * Kernel object info is used to create another instance.
	     *
	     * Otherwise, if `options` are given, we attempt to connect to the existing
	     * kernel found by calling `listRunningKernels`.
	     * The promise is fulfilled when the kernel is running on the server,
	     * otherwise the promise is rejected.
	     *
	     * If the kernel was not already started and no `options` are given,
	     * the promise is rejected.
	     */
	    function connectTo(id, options) {
	        return default_1.DefaultKernel.connectTo(id, options);
	    }
	    Kernel.connectTo = connectTo;
	    /**
	     * Shut down a kernel by id.
	     */
	    function shutdown(id, options) {
	        if (options === void 0) { options = {}; }
	        return default_1.DefaultKernel.shutdown(id, options);
	    }
	    Kernel.shutdown = shutdown;
	})(Kernel = exports.Kernel || (exports.Kernel = {}));


/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var iteration_1 = __webpack_require__(26);
	var searching_1 = __webpack_require__(27);
	var vector_1 = __webpack_require__(29);
	var disposable_1 = __webpack_require__(30);
	var signaling_1 = __webpack_require__(20);
	var comm_1 = __webpack_require__(31);
	var messages_1 = __webpack_require__(32);
	var future_1 = __webpack_require__(33);
	var serialize = __webpack_require__(34);
	var validate = __webpack_require__(35);
	var utils = __webpack_require__(4);
	/**
	 * The url for the kernel service.
	 */
	var KERNEL_SERVICE_URL = 'api/kernels';
	/**
	 * The url for the kernelspec service.
	 */
	var KERNELSPEC_SERVICE_URL = 'api/kernelspecs';
	/**
	 * Implementation of the Kernel object
	 */
	var DefaultKernel = (function () {
	    /**
	     * Construct a kernel object.
	     */
	    function DefaultKernel(options, id) {
	        this._id = '';
	        this._token = '';
	        this._name = '';
	        this._baseUrl = '';
	        this._wsUrl = '';
	        this._status = 'unknown';
	        this._clientId = '';
	        this._ws = null;
	        this._username = '';
	        this._ajaxSettings = '{}';
	        this._reconnectLimit = 7;
	        this._reconnectAttempt = 0;
	        this._isReady = false;
	        this._futures = null;
	        this._commPromises = null;
	        this._comms = null;
	        this._targetRegistry = Object.create(null);
	        this._info = null;
	        this._pendingMessages = [];
	        this._connectionPromise = null;
	        this._specPromise = null;
	        this._name = options.name;
	        this._id = id;
	        this._baseUrl = options.baseUrl || utils.getBaseUrl();
	        this._wsUrl = options.wsUrl || utils.getWsUrl(this._baseUrl);
	        this._ajaxSettings = JSON.stringify(utils.ajaxSettingsWithToken(options.ajaxSettings, options.token));
	        this._token = options.token || utils.getConfigOption('token');
	        this._clientId = options.clientId || utils.uuid();
	        this._username = options.username || '';
	        this._futures = new Map();
	        this._commPromises = new Map();
	        this._comms = new Map();
	        this._createSocket();
	        Private.runningKernels.pushBack(this);
	    }
	    Object.defineProperty(DefaultKernel.prototype, "id", {
	        /**
	         * The id of the server-side kernel.
	         */
	        get: function () {
	            return this._id;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultKernel.prototype, "name", {
	        /**
	         * The name of the server-side kernel.
	         */
	        get: function () {
	            return this._name;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultKernel.prototype, "model", {
	        /**
	         * Get the model associated with the kernel.
	         */
	        get: function () {
	            return { name: this.name, id: this.id };
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultKernel.prototype, "username", {
	        /**
	         * The client username.
	         */
	        get: function () {
	            return this._username;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultKernel.prototype, "clientId", {
	        /**
	         * The client unique id.
	         */
	        get: function () {
	            return this._clientId;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultKernel.prototype, "status", {
	        /**
	         * The current status of the kernel.
	         */
	        get: function () {
	            return this._status;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultKernel.prototype, "baseUrl", {
	        /**
	         * The base url of the kernel.
	         */
	        get: function () {
	            return this._baseUrl;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultKernel.prototype, "ajaxSettings", {
	        /**
	         * Get a copy of the default ajax settings for the kernel.
	         */
	        get: function () {
	            return JSON.parse(this._ajaxSettings);
	        },
	        /**
	         * Set the default ajax settings for the kernel.
	         */
	        set: function (value) {
	            this._ajaxSettings = JSON.stringify(value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultKernel.prototype, "isDisposed", {
	        /**
	         * Test whether the kernel has been disposed.
	         */
	        get: function () {
	            return this._futures === null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultKernel.prototype, "info", {
	        /**
	         * The cached kernel info.
	         *
	         * #### Notes
	         * This value will be null until the kernel is ready.
	         */
	        get: function () {
	            return this._info;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultKernel.prototype, "isReady", {
	        /**
	         * Test whether the kernel is ready.
	         */
	        get: function () {
	            return this._isReady;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultKernel.prototype, "ready", {
	        /**
	         * A promise that is fulfilled when the kernel is ready.
	         */
	        get: function () {
	            return this._connectionPromise.promise;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the kernel spec.
	     *
	     * @returns A promise that resolves with the kernel spec.
	     */
	    DefaultKernel.prototype.getSpec = function () {
	        var _this = this;
	        if (this._specPromise) {
	            return this._specPromise;
	        }
	        var options = {
	            baseUrl: this._baseUrl,
	            ajaxSettings: this.ajaxSettings
	        };
	        this._specPromise = Private.findSpecs(options).then(function (specs) {
	            return specs.kernelspecs[_this._name];
	        });
	        return this._specPromise;
	    };
	    /**
	     * Clone the current kernel with a new clientId.
	     */
	    DefaultKernel.prototype.clone = function () {
	        var options = {
	            baseUrl: this._baseUrl,
	            wsUrl: this._wsUrl,
	            name: this._name,
	            username: this._username,
	            token: this._token,
	            ajaxSettings: this.ajaxSettings
	        };
	        return new DefaultKernel(options, this._id);
	    };
	    /**
	     * Dispose of the resources held by the kernel.
	     */
	    DefaultKernel.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._status = 'dead';
	        if (this._ws !== null) {
	            this._ws.close();
	        }
	        this._ws = null;
	        this._futures.forEach(function (future, key) {
	            future.dispose();
	        });
	        this._comms.forEach(function (comm, key) {
	            comm.dispose();
	        });
	        this._futures = null;
	        this._commPromises = null;
	        this._comms = null;
	        this._targetRegistry = null;
	        Private.runningKernels.remove(this);
	        signaling_1.clearSignalData(this);
	    };
	    /**
	     * Send a shell message to the kernel.
	     *
	     * #### Notes
	     * Send a message to the kernel's shell channel, yielding a future object
	     * for accepting replies.
	     *
	     * If `expectReply` is given and `true`, the future is disposed when both a
	     * shell reply and an idle status message are received. If `expectReply`
	     * is not given or is `false`, the future is resolved when an idle status
	     * message is received.
	     * If `disposeOnDone` is not given or is `true`, the Future is disposed at this point.
	     * If `disposeOnDone` is given and `false`, it is up to the caller to dispose of the Future.
	     *
	     * All replies are validated as valid kernel messages.
	     *
	     * If the kernel status is `dead`, this will throw an error.
	     */
	    DefaultKernel.prototype.sendShellMessage = function (msg, expectReply, disposeOnDone) {
	        var _this = this;
	        if (expectReply === void 0) { expectReply = false; }
	        if (disposeOnDone === void 0) { disposeOnDone = true; }
	        if (this.status === 'dead') {
	            throw new Error('Kernel is dead');
	        }
	        if (!this._isReady) {
	            this._pendingMessages.push(msg);
	        }
	        else {
	            this._ws.send(serialize.serialize(msg));
	        }
	        var future = new future_1.KernelFutureHandler(function () {
	            _this._futures.delete(msg.header.msg_id);
	        }, msg, expectReply, disposeOnDone);
	        this._futures.set(msg.header.msg_id, future);
	        return future;
	    };
	    /**
	     * Interrupt a kernel.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernels).
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     *
	     * It is assumed that the API call does not mutate the kernel id or name.
	     *
	     * The promise will be rejected if the kernel status is `Dead` or if the
	     * request fails or the response is invalid.
	     */
	    DefaultKernel.prototype.interrupt = function () {
	        return Private.interruptKernel(this, this._baseUrl, this.ajaxSettings);
	    };
	    /**
	     * Restart a kernel.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernels) and validates the response model.
	     *
	     * Any existing Future or Comm objects are cleared.
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     *
	     * It is assumed that the API call does not mutate the kernel id or name.
	     *
	     * The promise will be rejected if the request fails or the response is
	     * invalid.
	     */
	    DefaultKernel.prototype.restart = function () {
	        this._clearState();
	        this._updateStatus('restarting');
	        return Private.restartKernel(this, this._baseUrl, this.ajaxSettings);
	    };
	    /**
	     * Reconnect to a disconnected kernel.
	     *
	     * #### Notes
	     * Used when the websocket connection to the kernel is lost.
	     */
	    DefaultKernel.prototype.reconnect = function () {
	        this._isReady = false;
	        if (this._ws !== null) {
	            // Clear the websocket event handlers and the socket itself.
	            this._ws.onopen = null;
	            this._ws.onclose = null;
	            this._ws.onerror = null;
	            this._ws.onmessage = null;
	            this._ws.close();
	            this._ws = null;
	        }
	        this._updateStatus('reconnecting');
	        this._createSocket();
	        return this._connectionPromise.promise;
	    };
	    /**
	     * Shutdown a kernel.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernels).
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     *
	     * On a valid response, closes the websocket and disposes of the kernel
	     * object, and fulfills the promise.
	     *
	     * The promise will be rejected if the kernel status is `Dead` or if the
	     * request fails or the response is invalid.
	     */
	    DefaultKernel.prototype.shutdown = function () {
	        if (this.status === 'dead') {
	            return Promise.reject(new Error('Kernel is dead'));
	        }
	        this._clearState();
	        return Private.shutdownKernel(this.id, this._baseUrl, this.ajaxSettings);
	    };
	    /**
	     * Send a `kernel_info_request` message.
	     *
	     * #### Notes
	     * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#kernel-info).
	     *
	     * Fulfills with the `kernel_info_response` content when the shell reply is
	     * received and validated.
	     */
	    DefaultKernel.prototype.requestKernelInfo = function () {
	        var _this = this;
	        var options = {
	            msgType: 'kernel_info_request',
	            channel: 'shell',
	            username: this._username,
	            session: this._clientId
	        };
	        var msg = messages_1.KernelMessage.createShellMessage(options);
	        return Private.handleShellMessage(this, msg).then(function (reply) {
	            _this._info = reply.content;
	            return reply;
	        });
	    };
	    /**
	     * Send a `complete_request` message.
	     *
	     * #### Notes
	     * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#completion).
	     *
	     * Fulfills with the `complete_reply` content when the shell reply is
	     * received and validated.
	     */
	    DefaultKernel.prototype.requestComplete = function (content) {
	        var options = {
	            msgType: 'complete_request',
	            channel: 'shell',
	            username: this._username,
	            session: this._clientId
	        };
	        var msg = messages_1.KernelMessage.createShellMessage(options, content);
	        return Private.handleShellMessage(this, msg);
	    };
	    /**
	     * Send an `inspect_request` message.
	     *
	     * #### Notes
	     * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#introspection).
	     *
	     * Fulfills with the `inspect_reply` content when the shell reply is
	     * received and validated.
	     */
	    DefaultKernel.prototype.requestInspect = function (content) {
	        var options = {
	            msgType: 'inspect_request',
	            channel: 'shell',
	            username: this._username,
	            session: this._clientId
	        };
	        var msg = messages_1.KernelMessage.createShellMessage(options, content);
	        return Private.handleShellMessage(this, msg);
	    };
	    /**
	     * Send a `history_request` message.
	     *
	     * #### Notes
	     * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#history).
	     *
	     * Fulfills with the `history_reply` content when the shell reply is
	     * received and validated.
	     */
	    DefaultKernel.prototype.requestHistory = function (content) {
	        var options = {
	            msgType: 'history_request',
	            channel: 'shell',
	            username: this._username,
	            session: this._clientId
	        };
	        var msg = messages_1.KernelMessage.createShellMessage(options, content);
	        return Private.handleShellMessage(this, msg);
	    };
	    /**
	     * Send an `execute_request` message.
	     *
	     * #### Notes
	     * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#execute).
	     *
	     * Future `onReply` is called with the `execute_reply` content when the
	     * shell reply is received and validated. The future will resolve when
	     * this message is received and the `idle` iopub status is received.
	     * The future will also be disposed at this point unless `disposeOnDone`
	     * is specified and `false`, in which case it is up to the caller to dispose
	     * of the future.
	     *
	     * **See also:** [[IExecuteReply]]
	     */
	    DefaultKernel.prototype.requestExecute = function (content, disposeOnDone) {
	        if (disposeOnDone === void 0) { disposeOnDone = true; }
	        var options = {
	            msgType: 'execute_request',
	            channel: 'shell',
	            username: this._username,
	            session: this._clientId
	        };
	        var defaults = {
	            silent: false,
	            store_history: true,
	            user_expressions: {},
	            allow_stdin: true,
	            stop_on_error: false
	        };
	        content = utils.extend(defaults, content);
	        var msg = messages_1.KernelMessage.createShellMessage(options, content);
	        return this.sendShellMessage(msg, true, disposeOnDone);
	    };
	    /**
	     * Send an `is_complete_request` message.
	     *
	     * #### Notes
	     * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#code-completeness).
	     *
	     * Fulfills with the `is_complete_response` content when the shell reply is
	     * received and validated.
	     */
	    DefaultKernel.prototype.requestIsComplete = function (content) {
	        var options = {
	            msgType: 'is_complete_request',
	            channel: 'shell',
	            username: this._username,
	            session: this._clientId
	        };
	        var msg = messages_1.KernelMessage.createShellMessage(options, content);
	        return Private.handleShellMessage(this, msg);
	    };
	    /**
	     * Send a `comm_info_request` message.
	     *
	     * #### Notes
	     * Fulfills with the `comm_info_reply` content when the shell reply is
	     * received and validated.
	     */
	    DefaultKernel.prototype.requestCommInfo = function (content) {
	        var options = {
	            msgType: 'comm_info_request',
	            channel: 'shell',
	            username: this._username,
	            session: this._clientId
	        };
	        var msg = messages_1.KernelMessage.createShellMessage(options, content);
	        return Private.handleShellMessage(this, msg);
	    };
	    /**
	     * Send an `input_reply` message.
	     *
	     * #### Notes
	     * See [Messaging in Jupyter](https://jupyter-client.readthedocs.io/en/latest/messaging.html#messages-on-the-stdin-router-dealer-sockets).
	     */
	    DefaultKernel.prototype.sendInputReply = function (content) {
	        if (this.status === 'dead') {
	            throw new Error('Kernel is dead');
	        }
	        var options = {
	            msgType: 'input_reply',
	            channel: 'stdin',
	            username: this._username,
	            session: this._clientId
	        };
	        var msg = messages_1.KernelMessage.createMessage(options, content);
	        if (!this._isReady) {
	            this._pendingMessages.push(msg);
	        }
	        else {
	            this._ws.send(serialize.serialize(msg));
	        }
	    };
	    /**
	     * Register an IOPub message hook.
	     *
	     * @param msg_id - The parent_header message id the hook will intercept.
	     *
	     * @param hook - The callback invoked for the message.
	     *
	     * @returns A disposable used to unregister the message hook.
	     *
	     * #### Notes
	     * The IOPub hook system allows you to preempt the handlers for IOPub messages with a
	     * given parent_header message id. The most recently registered hook is run first.
	     * If the hook returns false, any later hooks and the future's onIOPub handler will not run.
	     * If a hook throws an error, the error is logged to the console and the next hook is run.
	     * If a hook is registered during the hook processing, it won't run until the next message.
	     * If a hook is disposed during the hook processing, it will be deactivated immediately.
	     *
	     * See also [[IFuture.registerMessageHook]].
	     */
	    DefaultKernel.prototype.registerMessageHook = function (msgId, hook) {
	        var _this = this;
	        var future = this._futures && this._futures.get(msgId);
	        if (future) {
	            future.registerMessageHook(hook);
	        }
	        return new disposable_1.DisposableDelegate(function () {
	            future = _this._futures && _this._futures.get(msgId);
	            if (future) {
	                future.removeMessageHook(hook);
	            }
	        });
	    };
	    /**
	     * Register a comm target handler.
	     *
	     * @param targetName - The name of the comm target.
	     *
	     * @param callback - The callback invoked for a comm open message.
	     *
	     * @returns A disposable used to unregister the comm target.
	     *
	     * #### Notes
	     * Only one comm target can be registered at a time, an existing
	     * callback will be overidden.  A registered comm target handler will take
	     * precedence over a comm which specifies a `target_module`.
	     */
	    DefaultKernel.prototype.registerCommTarget = function (targetName, callback) {
	        var _this = this;
	        this._targetRegistry[targetName] = callback;
	        return new disposable_1.DisposableDelegate(function () {
	            if (!_this.isDisposed) {
	                delete _this._targetRegistry[targetName];
	            }
	        });
	    };
	    /**
	     * Connect to a comm, or create a new one.
	     *
	     * #### Notes
	     * If a client-side comm already exists, it is returned.
	     */
	    DefaultKernel.prototype.connectToComm = function (targetName, commId) {
	        var _this = this;
	        if (commId === void 0) {
	            commId = utils.uuid();
	        }
	        var comm = this._comms.get(commId);
	        if (!comm) {
	            comm = new comm_1.CommHandler(targetName, commId, this, function () { _this._unregisterComm(commId); });
	            this._comms.set(commId, comm);
	        }
	        return comm;
	    };
	    /**
	     * Create the kernel websocket connection and add socket status handlers.
	     */
	    DefaultKernel.prototype._createSocket = function () {
	        var _this = this;
	        var partialUrl = utils.urlPathJoin(this._wsUrl, KERNEL_SERVICE_URL, encodeURIComponent(this._id));
	        // Strip any authentication from the display string.
	        var parsed = utils.urlParse(partialUrl);
	        var display = partialUrl.replace(parsed.auth, '');
	        var url = utils.urlPathJoin(partialUrl, 'channels?session_id=' + encodeURIComponent(this._clientId));
	        // if token authentication is in use
	        if (this._token !== '') {
	            url = url + ("&token=" + encodeURIComponent(this._token));
	        }
	        console.log('Starting websocket', display);
	        this._connectionPromise = new utils.PromiseDelegate();
	        this._ws = new WebSocket(url);
	        // Ensure incoming binary messages are not Blobs
	        this._ws.binaryType = 'arraybuffer';
	        this._ws.onmessage = function (evt) { _this._onWSMessage(evt); };
	        this._ws.onopen = function (evt) { _this._onWSOpen(evt); };
	        this._ws.onclose = function (evt) { _this._onWSClose(evt); };
	        this._ws.onerror = function (evt) { _this._onWSClose(evt); };
	    };
	    /**
	     * Handle a websocket open event.
	     */
	    DefaultKernel.prototype._onWSOpen = function (evt) {
	        var _this = this;
	        this._reconnectAttempt = 0;
	        // Allow the message to get through.
	        this._isReady = true;
	        // Get the kernel info, signaling that the kernel is ready.
	        this.requestKernelInfo().then(function () {
	            _this._connectionPromise.resolve(void 0);
	        }).catch(function (err) {
	            _this._connectionPromise.reject(err);
	        });
	        this._isReady = false;
	    };
	    /**
	     * Handle a websocket message, validating and routing appropriately.
	     */
	    DefaultKernel.prototype._onWSMessage = function (evt) {
	        if (this.status === 'dead') {
	            // If the socket is being closed, ignore any messages
	            return;
	        }
	        var msg = serialize.deserialize(evt.data);
	        try {
	            validate.validateMessage(msg);
	        }
	        catch (error) {
	            console.error("Invalid message: " + error.message);
	            return;
	        }
	        if (msg.parent_header) {
	            var parentHeader = msg.parent_header;
	            var future = this._futures && this._futures.get(parentHeader.msg_id);
	            if (future) {
	                future.handleMsg(msg);
	            }
	            else {
	                // If the message was sent by us and was not iopub, it is orphaned.
	                var owned = parentHeader.session === this.clientId;
	                if (msg.channel !== 'iopub' && owned) {
	                    this.unhandledMessage.emit(msg);
	                }
	            }
	        }
	        if (msg.channel === 'iopub') {
	            switch (msg.header.msg_type) {
	                case 'status':
	                    this._updateStatus(msg.content.execution_state);
	                    break;
	                case 'comm_open':
	                    this._handleCommOpen(msg);
	                    break;
	                case 'comm_msg':
	                    this._handleCommMsg(msg);
	                    break;
	                case 'comm_close':
	                    this._handleCommClose(msg);
	                    break;
	            }
	            this.iopubMessage.emit(msg);
	        }
	    };
	    /**
	     * Handle a websocket close event.
	     */
	    DefaultKernel.prototype._onWSClose = function (evt) {
	        if (this.status === 'dead') {
	            return;
	        }
	        // Clear the websocket event handlers and the socket itself.
	        this._ws.onclose = null;
	        this._ws.onerror = null;
	        this._ws = null;
	        if (this._reconnectAttempt < this._reconnectLimit) {
	            this._updateStatus('reconnecting');
	            var timeout = Math.pow(2, this._reconnectAttempt);
	            console.error('Connection lost, reconnecting in ' + timeout + ' seconds.');
	            setTimeout(this._createSocket.bind(this), 1e3 * timeout);
	            this._reconnectAttempt += 1;
	        }
	        else {
	            this._updateStatus('dead');
	            this._connectionPromise.reject(new Error('Could not establish connection'));
	        }
	    };
	    /**
	     * Handle status iopub messages from the kernel.
	     */
	    DefaultKernel.prototype._updateStatus = function (status) {
	        switch (status) {
	            case 'starting':
	            case 'idle':
	            case 'busy':
	                this._isReady = true;
	                break;
	            case 'restarting':
	            case 'reconnecting':
	            case 'dead':
	                this._isReady = false;
	                break;
	            default:
	                console.error('invalid kernel status:', status);
	                return;
	        }
	        if (status !== this._status) {
	            this._status = status;
	            Private.logKernelStatus(this);
	            this.statusChanged.emit(status);
	            if (status === 'dead') {
	                this.dispose();
	            }
	        }
	        if (this._isReady) {
	            this._sendPending();
	        }
	    };
	    /**
	     * Send pending messages to the kernel.
	     */
	    DefaultKernel.prototype._sendPending = function () {
	        // We shift the message off the queue
	        // after the message is sent so that if there is an exception,
	        // the message is still pending.
	        while (this._pendingMessages.length > 0) {
	            var msg = serialize.serialize(this._pendingMessages[0]);
	            this._ws.send(msg);
	            this._pendingMessages.shift();
	        }
	    };
	    /**
	     * Clear the internal state.
	     */
	    DefaultKernel.prototype._clearState = function () {
	        this._isReady = false;
	        this._pendingMessages = [];
	        this._futures.forEach(function (future, key) {
	            future.dispose();
	        });
	        this._comms.forEach(function (comm, key) {
	            comm.dispose();
	        });
	        this._futures = new Map();
	        this._commPromises = new Map();
	        this._comms = new Map();
	    };
	    /**
	     * Handle a `comm_open` kernel message.
	     */
	    DefaultKernel.prototype._handleCommOpen = function (msg) {
	        var _this = this;
	        var content = msg.content;
	        var promise = utils.loadObject(content.target_name, content.target_module, this._targetRegistry).then(function (target) {
	            var comm = new comm_1.CommHandler(content.target_name, content.comm_id, _this, function () { _this._unregisterComm(content.comm_id); });
	            var response;
	            try {
	                response = target(comm, msg);
	            }
	            catch (e) {
	                comm.close();
	                console.error('Exception opening new comm');
	                throw (e);
	            }
	            return Promise.resolve(response).then(function () {
	                _this._commPromises.delete(comm.commId);
	                _this._comms.set(comm.commId, comm);
	                return comm;
	            });
	        });
	        this._commPromises.set(content.comm_id, promise);
	    };
	    /**
	     * Handle 'comm_close' kernel message.
	     */
	    DefaultKernel.prototype._handleCommClose = function (msg) {
	        var _this = this;
	        var content = msg.content;
	        var promise = this._commPromises.get(content.comm_id);
	        if (!promise) {
	            var comm = this._comms.get(content.comm_id);
	            if (!comm) {
	                console.error('Comm not found for comm id ' + content.comm_id);
	                return;
	            }
	            promise = Promise.resolve(comm);
	        }
	        promise.then(function (comm) {
	            _this._unregisterComm(comm.commId);
	            try {
	                var onClose = comm.onClose;
	                if (onClose) {
	                    onClose(msg);
	                }
	                comm.dispose();
	            }
	            catch (e) {
	                console.error('Exception closing comm: ', e, e.stack, msg);
	            }
	        });
	    };
	    /**
	     * Handle a 'comm_msg' kernel message.
	     */
	    DefaultKernel.prototype._handleCommMsg = function (msg) {
	        var content = msg.content;
	        var promise = this._commPromises.get(content.comm_id);
	        if (!promise) {
	            var comm = this._comms.get(content.comm_id);
	            if (!comm) {
	                // We do have a registered comm for this comm id, ignore.
	                return;
	            }
	            else {
	                var onMsg = comm.onMsg;
	                if (onMsg) {
	                    onMsg(msg);
	                }
	            }
	        }
	        else {
	            promise.then(function (comm) {
	                try {
	                    var onMsg = comm.onMsg;
	                    if (onMsg) {
	                        onMsg(msg);
	                    }
	                }
	                catch (e) {
	                    console.error('Exception handling comm msg: ', e, e.stack, msg);
	                }
	                return comm;
	            });
	        }
	    };
	    /**
	     * Unregister a comm instance.
	     */
	    DefaultKernel.prototype._unregisterComm = function (commId) {
	        this._comms.delete(commId);
	        this._commPromises.delete(commId);
	    };
	    return DefaultKernel;
	}());
	exports.DefaultKernel = DefaultKernel;
	// Define the signals for the `DefaultKernel` class.
	signaling_1.defineSignal(DefaultKernel.prototype, 'terminated');
	signaling_1.defineSignal(DefaultKernel.prototype, 'statusChanged');
	signaling_1.defineSignal(DefaultKernel.prototype, 'iopubMessage');
	signaling_1.defineSignal(DefaultKernel.prototype, 'unhandledMessage');
	/**
	 * The namespace for `DefaultKernel` statics.
	 */
	var DefaultKernel;
	(function (DefaultKernel) {
	    /**
	     * Find a kernel by id.
	     *
	     * #### Notes
	     * If the kernel was already started via `startNewKernel`, we return its
	     * `Kernel.IModel`.
	     *
	     * Otherwise, if `options` are given, we attempt to find the existing
	     * kernel.
	     * The promise is fulfilled when the kernel is found,
	     * otherwise the promise is rejected.
	     */
	    function findById(id, options) {
	        return Private.findById(id, options);
	    }
	    DefaultKernel.findById = findById;
	    /**
	     * Fetch all of the kernel specs.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernelspecs).
	     */
	    function getSpecs(options) {
	        if (options === void 0) { options = {}; }
	        return Private.getSpecs(options);
	    }
	    DefaultKernel.getSpecs = getSpecs;
	    /**
	     * Fetch the running kernels.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernels) and validates the response model.
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     */
	    function listRunning(options) {
	        if (options === void 0) { options = {}; }
	        return Private.listRunning(options);
	    }
	    DefaultKernel.listRunning = listRunning;
	    /**
	     * Start a new kernel.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernels) and validates the response model.
	     *
	     * If no options are given or the kernel name is not given, the
	     * default kernel will by started by the server.
	     *
	     * Wraps the result in a Kernel object. The promise is fulfilled
	     * when the kernel is started by the server, otherwise the promise is rejected.
	     */
	    function startNew(options) {
	        options = options || {};
	        return Private.startNew(options);
	    }
	    DefaultKernel.startNew = startNew;
	    /**
	     * Connect to a running kernel.
	     *
	     * #### Notes
	     * If the kernel was already started via `startNewKernel`, the existing
	     * Kernel object info is used to create another instance.
	     *
	     * Otherwise, if `options` are given, we attempt to connect to the existing
	     * kernel found by calling `listRunningKernels`.
	     * The promise is fulfilled when the kernel is running on the server,
	     * otherwise the promise is rejected.
	     *
	     * If the kernel was not already started and no `options` are given,
	     * the promise is rejected.
	     */
	    function connectTo(id, options) {
	        return Private.connectTo(id, options);
	    }
	    DefaultKernel.connectTo = connectTo;
	    /**
	     * Shut down a kernel by id.
	     */
	    function shutdown(id, options) {
	        if (options === void 0) { options = {}; }
	        return Private.shutdown(id, options);
	    }
	    DefaultKernel.shutdown = shutdown;
	})(DefaultKernel = exports.DefaultKernel || (exports.DefaultKernel = {}));
	/**
	 * A private namespace for the Kernel.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A module private store for running kernels.
	     */
	    Private.runningKernels = new vector_1.Vector();
	    /**
	     * A module private store of kernel specs by base url.
	     */
	    Private.specs = Object.create(null);
	    /**
	     * Find a kernel by id.
	     */
	    function findById(id, options) {
	        var kernel = searching_1.find(Private.runningKernels, function (value) {
	            return (value.id === id);
	        });
	        if (kernel) {
	            return Promise.resolve(kernel.model);
	        }
	        return getKernelModel(id, options).catch(function () {
	            throw new Error("No running kernel with id: " + id);
	        });
	    }
	    Private.findById = findById;
	    /**
	     * Get the cached kernel specs or fetch them.
	     */
	    function findSpecs(options) {
	        var promise = Private.specs[options.baseUrl];
	        if (promise) {
	            return promise;
	        }
	        return getSpecs(options);
	    }
	    Private.findSpecs = findSpecs;
	    /**
	     * Fetch all of the kernel specs.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernelspecs).
	     */
	    function getSpecs(options) {
	        if (options === void 0) { options = {}; }
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        var url = utils.urlPathJoin(baseUrl, KERNELSPEC_SERVICE_URL);
	        var ajaxSettings = utils.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        var promise = utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                return utils.makeAjaxError(success);
	            }
	            try {
	                return validate.validateSpecModels(success.data);
	            }
	            catch (err) {
	                return utils.makeAjaxError(success, err.message);
	            }
	        });
	        Private.specs[baseUrl] = promise;
	        return promise;
	    }
	    Private.getSpecs = getSpecs;
	    /**
	     * Fetch the running kernels.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernels) and validates the response model.
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     */
	    function listRunning(options) {
	        if (options === void 0) { options = {}; }
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        var url = utils.urlPathJoin(baseUrl, KERNEL_SERVICE_URL);
	        var ajaxSettings = utils.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                return utils.makeAjaxError(success);
	            }
	            if (!Array.isArray(success.data)) {
	                return utils.makeAjaxError(success, 'Invalid kernel list');
	            }
	            for (var i = 0; i < success.data.length; i++) {
	                try {
	                    validate.validateModel(success.data[i]);
	                }
	                catch (err) {
	                    return utils.makeAjaxError(success, err.message);
	                }
	            }
	            return updateRunningKernels(success.data);
	        }, onKernelError);
	    }
	    Private.listRunning = listRunning;
	    /**
	     * Update the running kernels based on new data from the server.
	     */
	    function updateRunningKernels(kernels) {
	        iteration_1.each(Private.runningKernels, function (kernel) {
	            var updated = searching_1.find(kernels, function (model) {
	                if (kernel.id === model.id) {
	                    return true;
	                }
	            });
	            // If kernel is no longer running on disk, emit dead signal.
	            if (!updated && kernel.status !== 'dead') {
	                kernel.terminated.emit(void 0);
	                kernel.dispose();
	            }
	        });
	        return kernels;
	    }
	    Private.updateRunningKernels = updateRunningKernels;
	    /**
	     * Start a new kernel.
	     */
	    function startNew(options) {
	        options = options || {};
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        var url = utils.urlPathJoin(baseUrl, KERNEL_SERVICE_URL);
	        var ajaxSettings = utils.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	        ajaxSettings.method = 'POST';
	        ajaxSettings.data = JSON.stringify({ name: options.name });
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 201) {
	                return utils.makeAjaxError(success);
	            }
	            validate.validateModel(success.data);
	            options = utils.copy(options);
	            options.name = success.data.name;
	            return new DefaultKernel(options, success.data.id);
	        }, onKernelError);
	    }
	    Private.startNew = startNew;
	    /**
	     * Connect to a running kernel.
	     *
	     * #### Notes
	     * If the kernel was already started via `startNewKernel`, the existing
	     * Kernel object info is used to create another instance.
	     *
	     * Otherwise, if `options` are given, we attempt to connect to the existing
	     * kernel found by calling `listRunningKernels`.
	     * The promise is fulfilled when the kernel is running on the server,
	     * otherwise the promise is rejected.
	     *
	     * If the kernel was not already started and no `options` are given,
	     * the promise is rejected.
	     */
	    function connectTo(id, options) {
	        var kernel = searching_1.find(Private.runningKernels, function (value) {
	            return value.id === id;
	        });
	        if (kernel) {
	            return Promise.resolve(kernel.clone());
	        }
	        return getKernelModel(id, options).then(function (model) {
	            options = utils.copy(options);
	            options.name = model.name;
	            return new DefaultKernel(options, id);
	        }).catch(function () {
	            throw new Error("No running kernel with id: " + id);
	        });
	    }
	    Private.connectTo = connectTo;
	    /**
	     * Shut down a kernel by id.
	     */
	    function shutdown(id, options) {
	        if (options === void 0) { options = {}; }
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        var ajaxSettings = utils.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	        return shutdownKernel(id, baseUrl, ajaxSettings);
	    }
	    Private.shutdown = shutdown;
	    /**
	     * Restart a kernel.
	     */
	    function restartKernel(kernel, baseUrl, ajaxSettings) {
	        if (kernel.status === 'dead') {
	            return Promise.reject(new Error('Kernel is dead'));
	        }
	        var url = utils.urlPathJoin(baseUrl, KERNEL_SERVICE_URL, encodeURIComponent(kernel.id), 'restart');
	        ajaxSettings = ajaxSettings || {};
	        ajaxSettings.method = 'POST';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                return utils.makeAjaxError(success);
	            }
	            try {
	                validate.validateModel(success.data);
	            }
	            catch (err) {
	                return utils.makeAjaxError(success, err.message);
	            }
	        }, onKernelError);
	    }
	    Private.restartKernel = restartKernel;
	    /**
	     * Interrupt a kernel.
	     */
	    function interruptKernel(kernel, baseUrl, ajaxSettings) {
	        if (kernel.status === 'dead') {
	            return Promise.reject(new Error('Kernel is dead'));
	        }
	        var url = utils.urlPathJoin(baseUrl, KERNEL_SERVICE_URL, encodeURIComponent(kernel.id), 'interrupt');
	        ajaxSettings = ajaxSettings || {};
	        ajaxSettings.method = 'POST';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                return utils.makeAjaxError(success);
	            }
	        }, onKernelError);
	    }
	    Private.interruptKernel = interruptKernel;
	    /**
	     * Delete a kernel.
	     */
	    function shutdownKernel(id, baseUrl, ajaxSettings) {
	        var url = utils.urlPathJoin(baseUrl, KERNEL_SERVICE_URL, encodeURIComponent(id));
	        ajaxSettings = ajaxSettings || {};
	        ajaxSettings.method = 'DELETE';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                return utils.makeAjaxError(success);
	            }
	            killKernels(id);
	        }, function (error) {
	            if (error.xhr.status === 404) {
	                var response = JSON.parse(error.xhr.responseText);
	                console.warn(response['message']);
	                killKernels(id);
	            }
	            else {
	                return onKernelError(error);
	            }
	        });
	    }
	    Private.shutdownKernel = shutdownKernel;
	    /**
	     * Kill the kernels by id.
	     */
	    function killKernels(id) {
	        iteration_1.each(iteration_1.toArray(Private.runningKernels), function (kernel) {
	            if (kernel.id === id) {
	                kernel.terminated.emit(void 0);
	                kernel.dispose();
	            }
	        });
	    }
	    /**
	     * Get a full kernel model from the server by kernel id string.
	     */
	    function getKernelModel(id, options) {
	        options = options || {};
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        var url = utils.urlPathJoin(baseUrl, KERNEL_SERVICE_URL, encodeURIComponent(id));
	        var ajaxSettings = utils.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                return utils.makeAjaxError(success);
	            }
	            var data = success.data;
	            try {
	                validate.validateModel(data);
	            }
	            catch (err) {
	                return utils.makeAjaxError(success, err.message);
	            }
	            return data;
	        }, Private.onKernelError);
	    }
	    Private.getKernelModel = getKernelModel;
	    /**
	     * Log the current kernel status.
	     */
	    function logKernelStatus(kernel) {
	        switch (kernel.status) {
	            case 'idle':
	            case 'busy':
	            case 'unknown':
	                return;
	            default:
	                console.log("Kernel: " + kernel.status + " (" + kernel.id + ")");
	                break;
	        }
	    }
	    Private.logKernelStatus = logKernelStatus;
	    /**
	     * Handle an error on a kernel Ajax call.
	     */
	    function onKernelError(error) {
	        var text = (error.throwError ||
	            error.xhr.statusText ||
	            error.xhr.responseText);
	        var msg = "API request failed: " + text;
	        console.error(msg);
	        return Promise.reject(error);
	    }
	    Private.onKernelError = onKernelError;
	    /**
	     * Send a kernel message to the kernel and resolve the reply message.
	     */
	    function handleShellMessage(kernel, msg) {
	        var future;
	        try {
	            future = kernel.sendShellMessage(msg, true);
	        }
	        catch (e) {
	            return Promise.reject(e);
	        }
	        return new Promise(function (resolve, reject) {
	            future.onReply = function (reply) {
	                resolve(reply);
	            };
	        });
	    }
	    Private.handleShellMessage = handleShellMessage;
	})(Private || (Private = {}));


/***/ },
/* 26 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * Create an iterator for an iterable or array-like object.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @returns A new iterator for the given object.
	 *
	 * #### Notes
	 * This function allows iteration algorithms to operate on user-defined
	 * iterable types and builtin array-like objects in a uniform fashion.
	 */
	function iter(object) {
	    var it;
	    if (typeof object.iter === 'function') {
	        it = object.iter();
	    }
	    else {
	        it = new ArrayIterator(object, 0);
	    }
	    return it;
	}
	exports.iter = iter;
	/**
	 * Create an array from an iterable of values.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @returns A new array of values from the given object.
	 */
	function toArray(object) {
	    var value;
	    var result = [];
	    var it = iter(object);
	    while ((value = it.next()) !== void 0) {
	        result[result.length] = value;
	    }
	    return result;
	}
	exports.toArray = toArray;
	/**
	 * Create an empty iterator.
	 *
	 * @returns A new iterator which yields nothing.
	 */
	function empty() {
	    return new EmptyIterator();
	}
	exports.empty = empty;
	/**
	 * An iterator which is always empty.
	 */
	var EmptyIterator = (function () {
	    /**
	     * Construct a new empty iterator.
	     */
	    function EmptyIterator() {
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    EmptyIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the current iterator.
	     *
	     * @returns A new independent clone of the current iterator.
	     */
	    EmptyIterator.prototype.clone = function () {
	        return new EmptyIterator();
	    };
	    /**
	     * Get the next value from the iterator.
	     *
	     * @returns Always `undefined`.
	     */
	    EmptyIterator.prototype.next = function () {
	        return void 0;
	    };
	    return EmptyIterator;
	}());
	exports.EmptyIterator = EmptyIterator;
	/**
	 * An iterator for an array-like object.
	 *
	 * #### Notes
	 * This iterator can be used for any builtin JS array-like object.
	 */
	var ArrayIterator = (function () {
	    /**
	     * Construct a new array iterator.
	     *
	     * @param source - The array-like object of interest.
	     *
	     * @param start - The starting index for iteration.
	     */
	    function ArrayIterator(source, start) {
	        this._source = source;
	        this._index = start;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    ArrayIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the current iterator.
	     *
	     * @returns A new independent clone of the current iterator.
	     *
	     * #### Notes
	     * The source array is shared among clones.
	     */
	    ArrayIterator.prototype.clone = function () {
	        return new ArrayIterator(this._source, this._index);
	    };
	    /**
	     * Get the next value from the source array.
	     *
	     * @returns The next value from the source array, or `undefined`
	     *   if the iterator is exhausted.
	     */
	    ArrayIterator.prototype.next = function () {
	        if (this._index >= this._source.length) {
	            return void 0;
	        }
	        return this._source[this._index++];
	    };
	    return ArrayIterator;
	}());
	exports.ArrayIterator = ArrayIterator;
	/**
	 * Invoke a function for each value in an iterable.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @param fn - The callback function to invoke for each value.
	 *
	 * #### Notes
	 * Iteration cannot be terminated early.
	 */
	function each(object, fn) {
	    var value;
	    var it = iter(object);
	    while ((value = it.next()) !== void 0) {
	        fn(value);
	    }
	}
	exports.each = each;
	/**
	 * Test whether all values in an iterable satisfy a predicate.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @param fn - The predicate function to invoke for each value.
	 *
	 * @returns `true` if all values pass the test, `false` otherwise.
	 *
	 * #### Notes
	 * Iteration terminates on the first `false` predicate result.
	 */
	function every(object, fn) {
	    var value;
	    var it = iter(object);
	    while ((value = it.next()) !== void 0) {
	        if (!fn(value)) {
	            return false;
	        }
	    }
	    return true;
	}
	exports.every = every;
	/**
	 * Test whether any value in an iterable satisfies a predicate.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @param fn - The predicate function to invoke for each value.
	 *
	 * @returns `true` if any value passes the test, `false` otherwise.
	 *
	 * #### Notes
	 * Iteration terminates on the first `true` predicate result.
	 */
	function some(object, fn) {
	    var value;
	    var it = iter(object);
	    while ((value = it.next()) !== void 0) {
	        if (fn(value)) {
	            return true;
	        }
	    }
	    return false;
	}
	exports.some = some;
	function reduce(object, fn, initial) {
	    // Setup the iterator and fetch the first value.
	    var it = iter(object);
	    var first = it.next();
	    // An empty iterator and no initial value is an error.
	    if (first === void 0 && initial === void 0) {
	        throw new TypeError('Reduce of empty iterable with no initial value.');
	    }
	    // If the iterator is empty, return the initial value.
	    if (first === void 0) {
	        return initial;
	    }
	    // If the iterator has a single item and no initial value, the
	    // reducer is not invoked and the first item is the return value.
	    var second = it.next();
	    if (second === void 0 && initial === void 0) {
	        return first;
	    }
	    // If iterator has a single item and an initial value is provided,
	    // the reducer is invoked and that result is the return value.
	    if (second === void 0) {
	        return fn(initial, first);
	    }
	    // Setup the initial accumulator value.
	    var accumulator;
	    if (initial === void 0) {
	        accumulator = fn(first, second);
	    }
	    else {
	        accumulator = fn(fn(initial, first), second);
	    }
	    // Iterate the rest of the values, updating the accumulator.
	    var next;
	    while ((next = it.next()) !== void 0) {
	        accumulator = fn(accumulator, next);
	    }
	    // Return the final accumulated value.
	    return accumulator;
	}
	exports.reduce = reduce;
	/**
	 * Filter an iterable for values which pass a test.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @param fn - The predicate function to invoke for each value.
	 *
	 * @returns An iterator which yields the values which pass the test.
	 */
	function filter(object, fn) {
	    return new FilterIterator(iter(object), fn);
	}
	exports.filter = filter;
	/**
	 * An iterator which yields values which pass a test.
	 */
	var FilterIterator = (function () {
	    /**
	     * Construct a new filter iterator.
	     *
	     * @param source - The iterator of values of interest.
	     *
	     * @param fn - The predicate function to invoke for each value in
	     *   the iterator. It returns whether the value passes the test.
	     */
	    function FilterIterator(source, fn) {
	        this._source = source;
	        this._fn = fn;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    FilterIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the current iterator.
	     *
	     * @returns A new independent clone of the current iterator.
	     *
	     * #### Notes
	     * The source iterator must be cloneable.
	     *
	     * The predicate function is shared among clones.
	     */
	    FilterIterator.prototype.clone = function () {
	        return new FilterIterator(this._source.clone(), this._fn);
	    };
	    /**
	     * Get the next value which passes the test.
	     *
	     * @returns The next value from the source iterator which passes
	     *   the predicate, or `undefined` if the iterator is exhausted.
	     */
	    FilterIterator.prototype.next = function () {
	        var value;
	        var fn = this._fn;
	        var it = this._source;
	        while ((value = it.next()) !== void 0) {
	            if (fn(value)) {
	                return value;
	            }
	        }
	        return void 0;
	    };
	    return FilterIterator;
	}());
	exports.FilterIterator = FilterIterator;
	/**
	 * Transform the values of an iterable with a mapping function.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @param fn - The mapping function to invoke for each value.
	 *
	 * @returns An iterator which yields the transformed values.
	 */
	function map(object, fn) {
	    return new MapIterator(iter(object), fn);
	}
	exports.map = map;
	/**
	 * An iterator which transforms values using a mapping function.
	 */
	var MapIterator = (function () {
	    /**
	     * Construct a new map iterator.
	     *
	     * @param source - The iterator of values of interest.
	     *
	     * @param fn - The mapping function to invoke for each value in the
	     *   iterator. It returns the transformed value.
	     */
	    function MapIterator(source, fn) {
	        this._source = source;
	        this._fn = fn;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    MapIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the current iterator.
	     *
	     * @returns A new independent clone of the current iterator.
	     *
	     * #### Notes
	     * The source iterator must be cloneable.
	     *
	     * The mapping function is shared among clones.
	     */
	    MapIterator.prototype.clone = function () {
	        return new MapIterator(this._source.clone(), this._fn);
	    };
	    /**
	     * Get the next mapped value from the source iterator.
	     *
	     * @returns The next value from the source iterator transformed
	     *   by the mapper, or `undefined` if the iterator is exhausted.
	     */
	    MapIterator.prototype.next = function () {
	        var value = this._source.next();
	        if (value === void 0) {
	            return void 0;
	        }
	        return this._fn.call(void 0, value);
	    };
	    return MapIterator;
	}());
	exports.MapIterator = MapIterator;
	/**
	 * Attach an incremental index to an iterable.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @param start - The initial value of the index. The default is zero.
	 *
	 * @returns An iterator which yields `[index, value]` tuples.
	 */
	function enumerate(object, start) {
	    if (start === void 0) { start = 0; }
	    return new EnumerateIterator(iter(object), start);
	}
	exports.enumerate = enumerate;
	/**
	 * An iterator which attaches an incremental index to a source.
	 */
	var EnumerateIterator = (function () {
	    /**
	     * Construct a new enumerate iterator.
	     *
	     * @param source - The iterator of values of interest.
	     *
	     * @param start - The initial value of the index.
	     */
	    function EnumerateIterator(source, start) {
	        this._source = source;
	        this._index = start;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    EnumerateIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the enumerate iterator.
	     *
	     * @returns A new iterator starting with the current value.
	     *
	     * #### Notes
	     * The source iterator must be cloneable.
	     */
	    EnumerateIterator.prototype.clone = function () {
	        return new EnumerateIterator(this._source.clone(), this._index);
	    };
	    /**
	     * Get the next value from the enumeration.
	     *
	     * @returns The next value from the enumeration, or `undefined` if
	     *   the iterator is exhausted.
	     */
	    EnumerateIterator.prototype.next = function () {
	        var value = this._source.next();
	        if (value === void 0) {
	            return void 0;
	        }
	        return [this._index++, value];
	    };
	    return EnumerateIterator;
	}());
	exports.EnumerateIterator = EnumerateIterator;
	/**
	 * Create an iterator which yields a value a single time.
	 *
	 * @param value - The value to wrap in an iterator.
	 *
	 * @returns A new iterator which yields the value a single time.
	 */
	function once(value) {
	    return new RepeatIterator(value, 1);
	}
	exports.once = once;
	/**
	 * Create an iterator which repeats a value a number of times.
	 *
	 * @param value - The value to repeat.
	 *
	 * @param count - The number of times to repeat the value.
	 *
	 * @returns A new iterator which repeats the specified value.
	 */
	function repeat(value, count) {
	    return new RepeatIterator(value, count);
	}
	exports.repeat = repeat;
	/**
	 * An iterator which repeats a value a specified number of times.
	 */
	var RepeatIterator = (function () {
	    /**
	     * Construct a new repeat iterator.
	     *
	     * @param value - The value to repeat.
	     *
	     * @param count - The number of times to repeat the value.
	     */
	    function RepeatIterator(value, count) {
	        this._value = value;
	        this._count = count;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    RepeatIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the repeat iterator.
	     *
	     * @returns A new iterator starting with the current value.
	     */
	    RepeatIterator.prototype.clone = function () {
	        return new RepeatIterator(this._value, this._count);
	    };
	    /**
	     * Get the next value from the iterator.
	     *
	     * @returns The next value from the iterator, or `undefined` if
	     *   the iterator is exhausted.
	     */
	    RepeatIterator.prototype.next = function () {
	        if (this._count <= 0) {
	            return void 0;
	        }
	        this._count--;
	        return this._value;
	    };
	    return RepeatIterator;
	}());
	exports.RepeatIterator = RepeatIterator;
	/**
	 * Chain together several iterables.
	 *
	 * @param objects - The iterables or array-like objects of interest.
	 *
	 * @returns An iterator which yields the values of the given iterables
	 *   in the order in which they are supplied.
	 */
	function chain() {
	    var objects = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	        objects[_i - 0] = arguments[_i];
	    }
	    return new ChainIterator(map(objects, iter));
	}
	exports.chain = chain;
	/**
	 * An iterator which chains together several iterators.
	 */
	var ChainIterator = (function () {
	    /**
	     * Construct a new chain iterator.
	     *
	     * @param source - The iterator of iterators of interest.
	     */
	    function ChainIterator(source) {
	        this._cloned = false;
	        this._source = source;
	        this._active = void 0;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    ChainIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the chain iterator.
	     *
	     * @returns A new iterator starting with the current value.
	     *
	     * #### Notes
	     * The source iterators must be cloneable.
	     */
	    ChainIterator.prototype.clone = function () {
	        var result = new ChainIterator(this._source.clone());
	        result._active = this._active && this._active.clone();
	        result._cloned = true;
	        this._cloned = true;
	        return result;
	    };
	    /**
	     * Get the next value from the iterator.
	     *
	     * @returns The next value from the iterator, or `undefined` when
	     *   all source iterators are exhausted.
	     */
	    ChainIterator.prototype.next = function () {
	        if (this._active === void 0) {
	            this._active = this._source.next();
	            if (this._active === void 0) {
	                return void 0;
	            }
	            if (this._cloned) {
	                this._active = this._active.clone();
	            }
	        }
	        var value = this._active.next();
	        if (value !== void 0) {
	            return value;
	        }
	        this._active = void 0;
	        return this.next();
	    };
	    return ChainIterator;
	}());
	exports.ChainIterator = ChainIterator;
	/**
	 * Iterate several iterables in lockstep.
	 *
	 * @param objects - The iterables or array-like objects of interest.
	 *
	 * @returns An iterator which yields successive tuples of values where
	 *   each value is taken in turn from the provided iterables. It will
	 *   be as long as the shortest provided iterable.
	 */
	function zip() {
	    var objects = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	        objects[_i - 0] = arguments[_i];
	    }
	    return new ZipIterator(objects.map(iter));
	}
	exports.zip = zip;
	/**
	 * An iterator which iterates several sources in lockstep.
	 */
	var ZipIterator = (function () {
	    /**
	     * Construct a new zip iterator.
	     *
	     * @param source - The iterators of interest.
	     */
	    function ZipIterator(source) {
	        this._source = source;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    ZipIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the zip iterator.
	     *
	     * @returns A new iterator starting with the current value.
	     *
	     * #### Notes
	     * The source iterators must be cloneable.
	     */
	    ZipIterator.prototype.clone = function () {
	        return new ZipIterator(this._source.map(function (it) { return it.clone(); }));
	    };
	    /**
	     * Get the next zipped value from the iterator.
	     *
	     * @returns The next zipped value from the iterator, or `undefined`
	     *   when the first source iterator is exhausted.
	     */
	    ZipIterator.prototype.next = function () {
	        var iters = this._source;
	        var result = new Array(iters.length);
	        for (var i = 0, n = iters.length; i < n; ++i) {
	            var value = iters[i].next();
	            if (value === void 0) {
	                return void 0;
	            }
	            result[i] = value;
	        }
	        return result;
	    };
	    return ZipIterator;
	}());
	exports.ZipIterator = ZipIterator;
	/**
	 * Iterate over an iterable using a stepped increment.
	 *
	 * @param object - The iterable or array-like object of interest.
	 *
	 * @param step - The distance to step on each iteration. A value
	 *   of less than `1` will behave the same as a value of `1`.
	 *
	 * @returns An iterator which traverses the iterable step-wise.
	 */
	function stride(object, step) {
	    return new StrideIterator(iter(object), step);
	}
	exports.stride = stride;
	/**
	 * An iterator which traverses a source iterator step-wise.
	 */
	var StrideIterator = (function () {
	    /**
	     * Construct a new stride iterator.
	     *
	     * @param source - The iterator of values of interest.
	     *
	     * @param step - The distance to step on each iteration. A value
	     *   of less than `1` will behave the same as a value of `1`.
	     */
	    function StrideIterator(source, step) {
	        this._source = source;
	        this._step = step;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    StrideIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the stride iterator.
	     *
	     * @returns A new iterator starting with the current value.
	     *
	     * #### Notes
	     * The source iterator must be cloneable.
	     */
	    StrideIterator.prototype.clone = function () {
	        return new StrideIterator(this._source.clone(), this._step);
	    };
	    /**
	     * Get the next stepped value from the iterator.
	     *
	     * @returns The next stepped value from the iterator, or `undefined`
	     *   when the source iterator is exhausted.
	     */
	    StrideIterator.prototype.next = function () {
	        var value = this._source.next();
	        if (value === void 0) {
	            return void 0;
	        }
	        var step = this._step;
	        while (--step > 0) {
	            this._source.next();
	        }
	        return value;
	    };
	    return StrideIterator;
	}());
	exports.StrideIterator = StrideIterator;


/***/ },
/* 27 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(26);
	var sequence_1 = __webpack_require__(28);
	/**
	 * Find the first value in an iterable which matches a predicate.
	 *
	 * @param object - The iterable or array-like object to search.
	 *
	 * @param fn - The predicate function to apply to the values.
	 *
	 * @returns The first matching value, or `undefined` if no matching
	 *   value is found.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Example
	 * ```typescript
	 * import { find } from 'phosphor/lib/algorithm/searching';
	 *
	 * interface IAnimal { species: string, name: string };
	 *
	 * function isCat(value: IAnimal): boolean {
	 *   return value.species === 'cat';
	 * }
	 *
	 * let data: IAnimal[] = [
	 *   { species: 'dog', name: 'spot' },
	 *   { species: 'cat', name: 'fluffy' },
	 *   { species: 'alligator', name: 'pocho' },
	 * ];
	 *
	 * find(data, isCat).name;  // 'fluffy'
	 * ```
	 */
	function find(object, fn) {
	    var value;
	    var it = iteration_1.iter(object);
	    while ((value = it.next()) !== void 0) {
	        if (fn(value)) {
	            return value;
	        }
	    }
	    return void 0;
	}
	exports.find = find;
	/**
	 * Test whether an iterable contains a specific value.
	 *
	 * @param object - The iterable or array-like object to search.
	 *
	 * @param value - The value to search for in the iterable. Values
	 *   are compared using strict `===` equality.
	 *
	 * @returns `true` if the value is found, `false` otherwise.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Example
	 * ```typescript
	 * import { contains } from 'phosphor/lib/algorithm/searching';
	 *
	 * let data: number[] = [5, 7, 0, -2, 9];
	 *
	 * contains(data, -2);  // true
	 * contains(data, 3);   // false
	 * ```
	 */
	function contains(object, value) {
	    var temp;
	    var it = iteration_1.iter(object);
	    while ((temp = it.next()) !== void 0) {
	        if (temp === value) {
	            return true;
	        }
	    }
	    return false;
	}
	exports.contains = contains;
	/**
	 * Find the minimum value in an iterable.
	 *
	 * @param object - The iterable or array-like object to search.
	 *
	 * @param fn - The 3-way comparison function to apply to the values.
	 *   It should return `< 0` if the first value is less than the second.
	 *   `0` if the values are equivalent, or `> 0` if the first value is
	 *   greater than the second.
	 *
	 * @returns The minimum value in the iterable. If multiple values are
	 *   equivalent to the minimum, the left-most value is returned. If
	 *   the iterable is empty, this returns `undefined`.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Example
	 * ```typescript
	 * import { min } from 'phosphor/lib/algorithm/searching';
	 *
	 * function numberCmp(a: number, b: number): number {
	 *   return a - b;
	 * }
	 *
	 * min([7, 4, 0, 3, 9, 4], numberCmp);  // 0
	 * ```
	 */
	function min(object, fn) {
	    var it = iteration_1.iter(object);
	    var result = it.next();
	    if (result === void 0) {
	        return void 0;
	    }
	    var value;
	    while ((value = it.next()) !== void 0) {
	        if (fn(value, result) < 0) {
	            result = value;
	        }
	    }
	    return result;
	}
	exports.min = min;
	/**
	 * Find the maximum value in an iterable.
	 *
	 * @param object - The iterable or array-like object to search.
	 *
	 * @param fn - The 3-way comparison function to apply to the values.
	 *   It should return `< 0` if the first value is less than the second.
	 *   `0` if the values are equivalent, or `> 0` if the first value is
	 *   greater than the second.
	 *
	 * @returns The maximum value in the iterable. If multiple values are
	 *   equivalent to the maximum, the left-most value is returned. If
	 *   the iterable is empty, this returns `undefined`.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Example
	 * ```typescript
	 * import { max } from 'phosphor/lib/algorithm/searching';
	 *
	 * function numberCmp(a: number, b: number): number {
	 *   return a - b;
	 * }
	 *
	 * max([7, 4, 0, 3, 9, 4], numberCmp);  // 9
	 * ```
	 */
	function max(object, fn) {
	    var it = iteration_1.iter(object);
	    var result = it.next();
	    if (result === void 0) {
	        return void 0;
	    }
	    var value;
	    while ((value = it.next()) !== void 0) {
	        if (fn(value, result) > 0) {
	            result = value;
	        }
	    }
	    return result;
	}
	exports.max = max;
	/**
	 * Find the index of the first occurrence of a value in a sequence.
	 *
	 * @param object - The sequence or array-like object to search.
	 *
	 * @param value - The value to locate in the sequence. Values are
	 *   compared using strict `===` equality.
	 *
	 * @param fromIndex - The starting index of the search. The default
	 *   value is `0`.
	 *
	 * @returns The index of the first occurrence of the value, or `-1`
	 *   if the value is not found.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Undefined Behavior
	 * A `fromIndex` which is non-integral or `< 0`.
	 *
	 * #### Example
	 * ```typescript
	 * import { indexOf } from 'phosphor/lib/algorithm/searching';
	 *
	 * let data = ['one', 'two', 'three', 'four', 'one'];
	 * indexOf(data, 'red');     // -1
	 * indexOf(data, 'one');     // 0
	 * indexOf(data, 'one', 1);  // 4
	 * indexOf(data, 'two', 2);  // -1
	 * ```
	 */
	function indexOf(object, value, fromIndex) {
	    var length = object.length;
	    if (length === 0) {
	        return -1;
	    }
	    var start;
	    if (fromIndex === void 0) {
	        start = 0;
	    }
	    else {
	        start = fromIndex;
	    }
	    var seq = sequence_1.asSequence(object);
	    for (var i = start; i < length; ++i) {
	        if (seq.at(i) === value) {
	            return i;
	        }
	    }
	    return -1;
	}
	exports.indexOf = indexOf;
	/**
	 * Find the index of the last occurrence of a value in a sequence.
	 *
	 * @param object - The sequence or array-like object to search.
	 *
	 * @param value - The value to locate in the sequence. Values are
	 *   compared using strict `===` equality.
	 *
	 * @param fromIndex - The starting index of the search. The default
	 *   value is `length - 1`.
	 *
	 * @returns The index of the last occurrence of the value, or `-1`
	 *   if the value is not found.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Undefined Behavior
	 * A `fromIndex` which is non-integral or `>= length`.
	 *
	 * #### Example
	 * ```typescript
	 * import { lastIndexOf } from 'phosphor/lib/algorithm/searching';
	 *
	 * let data = ['one', 'two', 'three', 'four', 'one'];
	 * lastIndexOf(data, 'red');     // -1
	 * lastIndexOf(data, 'one');     // 4
	 * lastIndexOf(data, 'one', 1);  // 0
	 * lastIndexOf(data, 'two', 2);  // 1
	 * ```
	 */
	function lastIndexOf(object, value, fromIndex) {
	    var length = object.length;
	    if (length === 0) {
	        return -1;
	    }
	    var start;
	    if (fromIndex === void 0) {
	        start = length - 1;
	    }
	    else {
	        start = fromIndex;
	    }
	    var seq = sequence_1.asSequence(object);
	    for (var i = start; i >= 0; --i) {
	        if (seq.at(i) === value) {
	            return i;
	        }
	    }
	    return -1;
	}
	exports.lastIndexOf = lastIndexOf;
	/**
	 * Find the index of the first value which matches a predicate.
	 *
	 * @param object - The sequence or array-like object to search.
	 *
	 * @param fn - The predicate function to apply to the values.
	 *
	 * @param fromIndex - The starting index of the search. The default
	 *   value is `0`.
	 *
	 * @returns The index of the first matching value, or `-1` if no
	 *   matching value is found.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Undefined Behavior
	 * A `fromIndex` which is non-integral or `< 0`.
	 *
	 * Modifying the length of the sequence while searching.
	 *
	 * #### Example
	 * ```typescript
	 * import { findIndex } from 'phosphor/lib/algorithm/searching';
	 *
	 * function isEven(value: number): boolean {
	 *   return value % 2 === 0;
	 * }
	 *
	 * let data = [1, 2, 3, 4, 3, 2, 1];
	 * findIndex(data, isEven);     // 1
	 * findIndex(data, isEven, 4);  // 5
	 * findIndex(data, isEven, 6);  // -1
	 * ```
	 */
	function findIndex(object, fn, fromIndex) {
	    var length = object.length;
	    if (length === 0) {
	        return -1;
	    }
	    var start;
	    if (fromIndex === void 0) {
	        start = 0;
	    }
	    else {
	        start = fromIndex;
	    }
	    var seq = sequence_1.asSequence(object);
	    for (var i = start; i < length; ++i) {
	        if (fn(seq.at(i), i)) {
	            return i;
	        }
	    }
	    return -1;
	}
	exports.findIndex = findIndex;
	/**
	 * Find the index of the last value which matches a predicate.
	 *
	 * @param object - The sequence or array-like object to search.
	 *
	 * @param fn - The predicate function to apply to the values.
	 *
	 * @param fromIndex - The starting index of the search. The default
	 *   value is `length - 1`.
	 *
	 * @returns The index of the last matching value, or `-1` if no
	 *   matching value is found.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Undefined Behavior
	 * A `fromIndex` which is non-integral or `>= length`.
	 *
	 * Modifying the length of the sequence while searching.
	 *
	 * #### Example
	 * ```typescript
	 * import { findLastIndex } from 'phosphor/lib/algorithm/searching';
	 *
	 * function isEven(value: number): boolean {
	 *   return value % 2 === 0;
	 * }
	 *
	 * let data = [1, 2, 3, 4, 3, 2, 1];
	 * findLastIndex(data, isEven);     // 5
	 * findLastIndex(data, isEven, 4);  // 3
	 * findLastIndex(data, isEven, 0);  // -1
	 * ```
	 */
	function findLastIndex(object, fn, fromIndex) {
	    var length = object.length;
	    if (length === 0) {
	        return -1;
	    }
	    var start;
	    if (fromIndex === void 0) {
	        start = length - 1;
	    }
	    else {
	        start = fromIndex;
	    }
	    var seq = sequence_1.asSequence(object);
	    for (var i = start; i >= 0; --i) {
	        if (fn(seq.at(i), i)) {
	            return i;
	        }
	    }
	    return -1;
	}
	exports.findLastIndex = findLastIndex;
	/**
	 * Find the index of the first element which compares `>=` to a value.
	 *
	 * @param sequence - The sequence or array-like object to search.
	 *   It must be sorted in ascending order.
	 *
	 * @param value - The value to locate in the sequence.
	 *
	 * @param fn - The 3-way comparison function to apply to the values.
	 *   It should return `< 0` if an element is less than a value, `0` if
	 *   an element is equal to a value, or `> 0` if an element is greater
	 *   than a value.
	 *
	 * @returns The index of the first element which compares `>=` to the
	 *   value, or `length` if there is no such element.
	 *
	 * #### Complexity
	 * Logarithmic.
	 *
	 * #### Undefined Behavior
	 * A sequence which is not sorted in ascending order.
	 *
	 * Modifying the length of the sequence while searching.
	 *
	 * #### Example
	 * ```typescript
	 * import { lowerBound } from 'phosphor/lib/algorithm/searching';
	 *
	 * function numberCmp(a: number, b: number): number {
	 *   return a - b;
	 * }
	 *
	 * let data = [0, 3, 4, 7, 7, 9];
	 * lowerBound(data, 0, numberCmp);   // 0
	 * lowerBound(data, 6, numberCmp);   // 3
	 * lowerBound(data, 7, numberCmp);   // 3
	 * lowerBound(data, -1, numberCmp);  // 0
	 * lowerBound(data, 10, numberCmp);  // 6
	 * ```
	 */
	function lowerBound(object, value, fn) {
	    var n = object.length;
	    if (n === 0) {
	        return 0;
	    }
	    var begin = 0;
	    var half;
	    var middle;
	    var seq = sequence_1.asSequence(object);
	    while (n > 0) {
	        half = n / 2 | 0;
	        middle = begin + half;
	        if (fn(seq.at(middle), value) < 0) {
	            begin = middle + 1;
	            n -= half + 1;
	        }
	        else {
	            n = half;
	        }
	    }
	    return begin;
	}
	exports.lowerBound = lowerBound;
	/**
	 * Find the index of the first element which compares `>` than a value.
	 *
	 * @param sequence - The sequence or array-like object to search.
	 *   It must be sorted in ascending order.
	 *
	 * @param value - The value to locate in the sequence.
	 *
	 * @param fn - The 3-way comparison function to apply to the values.
	 *   It should return `< 0` if an element is less than a value, `0` if
	 *   an element is equal to a value, or `> 0` if an element is greater
	 *   than a value.
	 *
	 * @returns The index of the first element which compares `>` than the
	 *   value, or `length` if there is no such element.
	 *
	 * #### Complexity
	 * Logarithmic.
	 *
	 * #### Undefined Behavior
	 * A sequence which is not sorted in ascending order.
	 *
	 * Modifying the length of the sequence while searching.
	 *
	 * #### Example
	 * ```typescript
	 * import { upperBound } from 'phosphor/lib/algorithm/searching';
	 *
	 * function numberCmp(a: number, b: number): number {
	 *   return a - b;
	 * }
	 *
	 * let data = [0, 3, 4, 7, 7, 9];
	 * upperBound(data, 0, numberCmp);   // 1
	 * upperBound(data, 6, numberCmp);   // 3
	 * upperBound(data, 7, numberCmp);   // 5
	 * upperBound(data, -1, numberCmp);  // 0
	 * upperBound(data, 10, numberCmp);  // 6
	 * ```
	 */
	function upperBound(object, value, fn) {
	    var n = object.length;
	    if (n === 0) {
	        return 0;
	    }
	    var begin = 0;
	    var half;
	    var middle;
	    var seq = sequence_1.asSequence(object);
	    while (n > 0) {
	        half = n / 2 | 0;
	        middle = begin + half;
	        if (fn(seq.at(middle), value) > 0) {
	            n = half;
	        }
	        else {
	            begin = middle + 1;
	            n -= half + 1;
	        }
	    }
	    return begin;
	}
	exports.upperBound = upperBound;
	/**
	 * A namespace which holds string searching functionality.
	 */
	var StringSearch;
	(function (StringSearch) {
	    /**
	     * Compute the sum-of-squares match for the given search text.
	     *
	     * @param sourceText - The text which should be searched.
	     *
	     * @param queryText - The query text to locate in the source text.
	     *
	     * @returns The match result object, or `null` if there is no match.
	     *
	     * #### Complexity
	     * Linear on `sourceText`.
	     *
	     * #### Notes
	     * This scoring algorithm uses a sum-of-squares approach to determine
	     * the score. In order for there to be a match, all of the characters
	     * in `queryText` **must** appear in `sourceText` in order. The index
	     * of each matching character is squared and added to the score. This
	     * means that early and consecutive character matches are preferred.
	     *
	     * The character match is performed with strict equality. It is case
	     * sensitive and does not ignore whitespace. If those behaviors are
	     * required, the text should be transformed before scoring.
	     */
	    function sumOfSquares(sourceText, queryText) {
	        var score = 0;
	        var indices = new Array(queryText.length);
	        for (var i = 0, j = 0, n = queryText.length; i < n; ++i, ++j) {
	            j = sourceText.indexOf(queryText[i], j);
	            if (j === -1) {
	                return null;
	            }
	            indices[i] = j;
	            score += j * j;
	        }
	        return { score: score, indices: indices };
	    }
	    StringSearch.sumOfSquares = sumOfSquares;
	    /**
	     * Highlight the matched characters of a source string.
	     *
	     * @param source - The text which should be highlighted.
	     *
	     * @param indices - The indices of the matched characters. They must
	     *   appear in increasing order and must be in bounds of the source.
	     *
	     * @returns A string with interpolated `<mark>` tags.
	     */
	    function highlight(sourceText, indices) {
	        var k = 0;
	        var last = 0;
	        var result = '';
	        var n = indices.length;
	        while (k < n) {
	            var i = indices[k];
	            var j = indices[k];
	            while (++k < n && indices[k] === j + 1) {
	                j++;
	            }
	            var head = sourceText.slice(last, i);
	            var chunk = sourceText.slice(i, j + 1);
	            result += head + "<mark>" + chunk + "</mark>";
	            last = j + 1;
	        }
	        return result + sourceText.slice(last);
	    }
	    StringSearch.highlight = highlight;
	})(StringSearch = exports.StringSearch || (exports.StringSearch = {}));


/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(26);
	/**
	 * Cast a sequence or array-like object to a sequence.
	 *
	 * @param object - The sequence or array-like object of interest.
	 *
	 * @returns A sequence for the given object.
	 *
	 * #### Notes
	 * This function allows sequence algorithms to operate on user-defined
	 * sequence types and builtin array-like objects in a uniform fashion.
	 */
	function asSequence(object) {
	    var seq;
	    if (typeof object.at === 'function') {
	        seq = object;
	    }
	    else {
	        seq = new ArraySequence(object);
	    }
	    return seq;
	}
	exports.asSequence = asSequence;
	/**
	 * Cast a mutable sequence or array-like object to a mutable sequence.
	 *
	 * @param object - The sequence or array-like object of interest.
	 *
	 * @returns A mutable sequence for the given object.
	 *
	 * #### Notes
	 * This function allows sequence algorithms to operate on user-defined
	 * sequence types and builtin array-like objects in a uniform fashion.
	 */
	function asMutableSequence(object) {
	    var seq;
	    if (typeof object.set === 'function') {
	        seq = object;
	    }
	    else {
	        seq = new MutableArraySequence(object);
	    }
	    return seq;
	}
	exports.asMutableSequence = asMutableSequence;
	/**
	 * A sequence for an array-like object.
	 *
	 * #### Notes
	 * This sequence can be used for any builtin JS array-like object.
	 */
	var ArraySequence = (function () {
	    /**
	     * Construct a new array sequence.
	     *
	     * @param source - The array-like object of interest.
	     */
	    function ArraySequence(source) {
	        this._source = source;
	    }
	    Object.defineProperty(ArraySequence.prototype, "length", {
	        /**
	         * The length of the sequence.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._source.length;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A new iterator which traverses the object's values.
	     */
	    ArraySequence.prototype.iter = function () {
	        return new iteration_1.ArrayIterator(this._source, 0);
	    };
	    /**
	     * Get the value at the specified index.
	     *
	     * @param index - The positive integer index of interest.
	     *
	     * @returns The value at the specified index.
	     *
	     * #### Undefined Behavior
	     * An `index` which is non-integral or out of range.
	     */
	    ArraySequence.prototype.at = function (index) {
	        return this._source[index];
	    };
	    return ArraySequence;
	}());
	exports.ArraySequence = ArraySequence;
	/**
	 * A sequence for a mutable array-like object.
	 *
	 * #### Notes
	 * This sequence can be used for any builtin JS array-like object.
	 */
	var MutableArraySequence = (function (_super) {
	    __extends(MutableArraySequence, _super);
	    function MutableArraySequence() {
	        _super.apply(this, arguments);
	    }
	    /**
	     * Set the value at the specified index.
	     *
	     * @param index - The positive integer index of interest.
	     *
	     * @param value - The value to set at the specified index.
	     *
	     * #### Undefined Behavior
	     * An `index` which is non-integral or out of range.
	     */
	    MutableArraySequence.prototype.set = function (index, value) {
	        this._source[index] = value;
	    };
	    return MutableArraySequence;
	}(ArraySequence));
	exports.MutableArraySequence = MutableArraySequence;


/***/ },
/* 29 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(26);
	/**
	 * A generic vector data structure.
	 */
	var Vector = (function () {
	    /**
	     * Construct a new vector.
	     *
	     * @param values - The initial values for the vector.
	     */
	    function Vector(values) {
	        var _this = this;
	        this._array = [];
	        if (values)
	            iteration_1.each(values, function (value) { _this.pushBack(value); });
	    }
	    Object.defineProperty(Vector.prototype, "isEmpty", {
	        /**
	         * Test whether the vector is empty.
	         *
	         * @returns `true` if the vector is empty, `false` otherwise.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._array.length === 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Vector.prototype, "length", {
	        /**
	         * Get the length of the vector.
	         *
	         * @return The number of values in the vector.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._array.length;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Vector.prototype, "front", {
	        /**
	         * Get the value at the front of the vector.
	         *
	         * @returns The value at the front of the vector, or `undefined` if
	         *   the vector is empty.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._array[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Vector.prototype, "back", {
	        /**
	         * Get the value at the back of the vector.
	         *
	         * @returns The value at the back of the vector, or `undefined` if
	         *   the vector is empty.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._array[this._array.length - 1];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Create an iterator over the values in the vector.
	     *
	     * @returns A new iterator starting at the front of the vector.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * No changes.
	     */
	    Vector.prototype.iter = function () {
	        return new iteration_1.ArrayIterator(this._array, 0);
	    };
	    /**
	     * Get the value at the specified index.
	     *
	     * @param index - The positive integer index of interest.
	     *
	     * @returns The value at the specified index.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * No changes.
	     *
	     * #### Undefined Behavior
	     * An `index` which is non-integral or out of range.
	     */
	    Vector.prototype.at = function (index) {
	        return this._array[index];
	    };
	    /**
	     * Set the value at the specified index.
	     *
	     * @param index - The positive integer index of interest.
	     *
	     * @param value - The value to set at the specified index.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * No changes.
	     *
	     * #### Undefined Behavior
	     * An `index` which is non-integral or out of range.
	     */
	    Vector.prototype.set = function (index, value) {
	        this._array[index] = value;
	    };
	    /**
	     * Add a value to the back of the vector.
	     *
	     * @param value - The value to add to the back of the vector.
	     *
	     * @returns The new length of the vector.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * No changes.
	     */
	    Vector.prototype.pushBack = function (value) {
	        return this._array.push(value);
	    };
	    /**
	     * Remove and return the value at the back of the vector.
	     *
	     * @returns The value at the back of the vector, or `undefined` if
	     *   the vector is empty.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * Iterators pointing at the removed value are invalidated.
	     */
	    Vector.prototype.popBack = function () {
	        return this._array.pop();
	    };
	    /**
	     * Insert a value into the vector at a specific index.
	     *
	     * @param index - The index at which to insert the value.
	     *
	     * @param value - The value to set at the specified index.
	     *
	     * @returns The new length of the vector.
	     *
	     * #### Complexity
	     * Linear.
	     *
	     * #### Iterator Validity
	     * No changes.
	     *
	     * #### Notes
	     * The `index` will be clamped to the bounds of the vector.
	     *
	     * #### Undefined Behavior
	     * An `index` which is non-integral.
	     */
	    Vector.prototype.insert = function (index, value) {
	        var array = this._array;
	        var n = array.length;
	        index = Math.max(0, Math.min(index, n));
	        for (var i = n; i > index; --i) {
	            array[i] = array[i - 1];
	        }
	        array[index] = value;
	        return n + 1;
	    };
	    /**
	     * Remove the first occurrence of a value from the vector.
	     *
	     * @param value - The value of interest.
	     *
	     * @returns The index of the removed value, or `-1` if the value
	     *   is not contained in the vector.
	     *
	     * #### Complexity
	     * Linear.
	     *
	     * #### Iterator Validity
	     * Iterators pointing at the removed value and beyond are invalidated.
	     *
	     * #### Notes
	     * Comparison is performed using strict `===` equality.
	     */
	    Vector.prototype.remove = function (value) {
	        var index = this._array.indexOf(value);
	        if (index !== -1)
	            this.removeAt(index);
	        return index;
	    };
	    /**
	     * Remove and return the value at a specific index.
	     *
	     * @param index - The index of the value of interest.
	     *
	     * @returns The value at the specified index, or `undefined` if the
	     *   index is out of range.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * Iterators pointing at the removed value and beyond are invalidated.
	     *
	     * #### Undefined Behavior
	     * An `index` which is non-integral.
	     */
	    Vector.prototype.removeAt = function (index) {
	        var array = this._array;
	        var n = array.length;
	        if (index < 0 || index >= n) {
	            return void 0;
	        }
	        var value = array[index];
	        for (var i = index + 1; i < n; ++i) {
	            array[i - 1] = array[i];
	        }
	        array.length = n - 1;
	        return value;
	    };
	    /**
	     * Remove all values from the vector.
	     *
	     * #### Complexity
	     * Linear.
	     *
	     * #### Iterator Validity
	     * All current iterators are invalidated.
	     */
	    Vector.prototype.clear = function () {
	        this._array.length = 0;
	    };
	    /**
	     * Swap the contents of the vector with the contents of another.
	     *
	     * @param other - The other vector holding the contents to swap.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * All current iterators remain valid, but will now point to the
	     * contents of the other vector involved in the swap.
	     */
	    Vector.prototype.swap = function (other) {
	        var array = other._array;
	        other._array = this._array;
	        this._array = array;
	    };
	    return Vector;
	}());
	exports.Vector = Vector;


/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(26);
	/**
	 * A disposable object which delegates to a callback function.
	 */
	var DisposableDelegate = (function () {
	    /**
	     * Construct a new disposable delegate.
	     *
	     * @param callback - The function to invoke on dispose.
	     */
	    function DisposableDelegate(callback) {
	        this._callback = callback || null;
	    }
	    Object.defineProperty(DisposableDelegate.prototype, "isDisposed", {
	        /**
	         * Test whether the delegate has been disposed.
	         *
	         * #### Notes
	         * This is a read-only property which is always safe to access.
	         */
	        get: function () {
	            return this._callback === null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the delegate and invoke the callback function.
	     *
	     * #### Notes
	     * All calls to this method after the first will be a no-op.
	     */
	    DisposableDelegate.prototype.dispose = function () {
	        if (this._callback === null) {
	            return;
	        }
	        var callback = this._callback;
	        this._callback = null;
	        callback();
	    };
	    return DisposableDelegate;
	}());
	exports.DisposableDelegate = DisposableDelegate;
	/**
	 * An object which manages a collection of disposable items.
	 */
	var DisposableSet = (function () {
	    /**
	     * Construct a new disposable set.
	     *
	     * @param items - The initial disposable items.
	     */
	    function DisposableSet(items) {
	        var _this = this;
	        this._set = new Set();
	        if (items)
	            iteration_1.each(items, function (item) { _this._set.add(item); });
	    }
	    Object.defineProperty(DisposableSet.prototype, "isDisposed", {
	        /**
	         * Test whether the set has been disposed.
	         *
	         * #### Notes
	         * This is a read-only property which is always safe to access.
	         */
	        get: function () {
	            return this._set === null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the set and the disposable items it contains.
	     *
	     * #### Notes
	     * Items are disposed in the order they are added to the set.
	     *
	     * It is unsafe to use the set after it has been disposed.
	     *
	     * All calls to this method after the first will be a no-op.
	     */
	    DisposableSet.prototype.dispose = function () {
	        if (this._set === null) {
	            return;
	        }
	        var set = this._set;
	        this._set = null;
	        set.forEach(function (item) { item.dispose(); });
	    };
	    /**
	     * Add a disposable item to the set.
	     *
	     * @param item - The disposable item to add to the set. If the item
	     *   is already contained in the set, this is a no-op.
	     *
	     * @throws An error if the set has been disposed.
	     */
	    DisposableSet.prototype.add = function (item) {
	        if (this._set === null) {
	            throw new Error('Object is disposed');
	        }
	        this._set.add(item);
	    };
	    /**
	     * Remove a disposable item from the set.
	     *
	     * @param item - The disposable item to remove from the set. If the
	     *   item does not exist in the set, this is a no-op.
	     *
	     * @throws An error if the set has been disposed.
	     */
	    DisposableSet.prototype.remove = function (item) {
	        if (this._set === null) {
	            throw new Error('Object is disposed');
	        }
	        this._set.delete(item);
	    };
	    /**
	     * Remove all disposable items from the set.
	     *
	     * @throws An error if the set has been disposed.
	     */
	    DisposableSet.prototype.clear = function () {
	        if (this._set === null) {
	            throw new Error('Object is disposed');
	        }
	        this._set.clear();
	    };
	    return DisposableSet;
	}());
	exports.DisposableSet = DisposableSet;


/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var disposable_1 = __webpack_require__(30);
	var messages_1 = __webpack_require__(32);
	/**
	 * Comm channel handler.
	 */
	var CommHandler = (function (_super) {
	    __extends(CommHandler, _super);
	    /**
	     * Construct a new comm channel.
	     */
	    function CommHandler(target, id, kernel, disposeCb) {
	        _super.call(this, disposeCb);
	        this._target = '';
	        this._id = '';
	        this._kernel = null;
	        this._onClose = null;
	        this._onMsg = null;
	        this._id = id;
	        this._target = target;
	        this._kernel = kernel;
	    }
	    Object.defineProperty(CommHandler.prototype, "commId", {
	        /**
	         * The unique id for the comm channel.
	         */
	        get: function () {
	            return this._id;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CommHandler.prototype, "targetName", {
	        /**
	         * The target name for the comm channel.
	         */
	        get: function () {
	            return this._target;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CommHandler.prototype, "onClose", {
	        /**
	         * Get the callback for a comm close event.
	         *
	         * #### Notes
	         * This is called when the comm is closed from either the server or
	         * client.
	         *
	         * **See also:** [[ICommClose]], [[close]]
	         */
	        get: function () {
	            return this._onClose;
	        },
	        /**
	         * Set the callback for a comm close event.
	         *
	         * #### Notes
	         * This is called when the comm is closed from either the server or
	         * client.
	         *
	         * **See also:** [[close]]
	         */
	        set: function (cb) {
	            this._onClose = cb;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CommHandler.prototype, "onMsg", {
	        /**
	         * Get the callback for a comm message received event.
	         */
	        get: function () {
	            return this._onMsg;
	        },
	        /**
	         * Set the callback for a comm message received event.
	         */
	        set: function (cb) {
	            this._onMsg = cb;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CommHandler.prototype, "isDisposed", {
	        /**
	         * Test whether the comm has been disposed.
	         */
	        get: function () {
	            return (this._kernel === null);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Open a comm with optional data and metadata.
	     *
	     * #### Notes
	     * This sends a `comm_open` message to the server.
	     *
	     * **See also:** [[ICommOpen]]
	     */
	    CommHandler.prototype.open = function (data, metadata) {
	        if (this.isDisposed || this._kernel.isDisposed) {
	            return;
	        }
	        var options = {
	            msgType: 'comm_open',
	            channel: 'shell',
	            username: this._kernel.username,
	            session: this._kernel.clientId
	        };
	        var content = {
	            comm_id: this._id,
	            target_name: this._target,
	            data: data || {}
	        };
	        var msg = messages_1.KernelMessage.createShellMessage(options, content, metadata);
	        return this._kernel.sendShellMessage(msg, false, true);
	    };
	    /**
	     * Send a `comm_msg` message to the kernel.
	     *
	     * #### Notes
	     * This is a no-op if the comm has been closed.
	     *
	     * **See also:** [[ICommMsg]]
	     */
	    CommHandler.prototype.send = function (data, metadata, buffers, disposeOnDone) {
	        if (buffers === void 0) { buffers = []; }
	        if (disposeOnDone === void 0) { disposeOnDone = true; }
	        if (this.isDisposed || this._kernel.isDisposed) {
	            return;
	        }
	        var options = {
	            msgType: 'comm_msg',
	            channel: 'shell',
	            username: this._kernel.username,
	            session: this._kernel.clientId
	        };
	        var content = {
	            comm_id: this._id,
	            data: data
	        };
	        var msg = messages_1.KernelMessage.createShellMessage(options, content, metadata, buffers);
	        return this._kernel.sendShellMessage(msg, false, true);
	    };
	    /**
	     * Close the comm.
	     *
	     * #### Notes
	     * This will send a `comm_close` message to the kernel, and call the
	     * `onClose` callback if set.
	     *
	     * This is a no-op if the comm is already closed.
	     *
	     * **See also:** [[ICommClose]], [[onClose]]
	     */
	    CommHandler.prototype.close = function (data, metadata) {
	        if (this.isDisposed || this._kernel.isDisposed) {
	            return;
	        }
	        var options = {
	            msgType: 'comm_msg',
	            channel: 'shell',
	            username: this._kernel.username,
	            session: this._kernel.clientId
	        };
	        var content = {
	            comm_id: this._id,
	            data: data || {}
	        };
	        var msg = messages_1.KernelMessage.createShellMessage(options, content, metadata);
	        var future = this._kernel.sendShellMessage(msg, false, true);
	        options.channel = 'iopub';
	        var ioMsg = messages_1.KernelMessage.createMessage(options, content, metadata);
	        var onClose = this._onClose;
	        if (onClose) {
	            onClose(ioMsg);
	        }
	        this.dispose();
	        return future;
	    };
	    /**
	     * Dispose of the resources held by the comm.
	     */
	    CommHandler.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._onClose = null;
	        this._onMsg = null;
	        this._kernel = null;
	        _super.prototype.dispose.call(this);
	    };
	    return CommHandler;
	}(disposable_1.DisposableDelegate));
	exports.CommHandler = CommHandler;


/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var utils = __webpack_require__(4);
	/**
	 * A namespace for kernel messages.
	 */
	var KernelMessage;
	(function (KernelMessage) {
	    /**
	     * Create a well-formed kernel message.
	     */
	    function createMessage(options, content, metadata, buffers) {
	        if (content === void 0) { content = {}; }
	        if (metadata === void 0) { metadata = {}; }
	        if (buffers === void 0) { buffers = []; }
	        return {
	            header: {
	                username: options.username || '',
	                version: '5.0',
	                session: options.session,
	                msg_id: options.msgId || utils.uuid(),
	                msg_type: options.msgType
	            },
	            parent_header: {},
	            channel: options.channel,
	            content: content,
	            metadata: metadata,
	            buffers: buffers
	        };
	    }
	    KernelMessage.createMessage = createMessage;
	    /**
	     * Create a well-formed kernel shell message.
	     */
	    function createShellMessage(options, content, metadata, buffers) {
	        if (content === void 0) { content = {}; }
	        if (metadata === void 0) { metadata = {}; }
	        if (buffers === void 0) { buffers = []; }
	        var msg = createMessage(options, content, metadata, buffers);
	        return msg;
	    }
	    KernelMessage.createShellMessage = createShellMessage;
	    /**
	     * Test whether a kernel message is a `'stream'` message.
	     */
	    function isStreamMsg(msg) {
	        return msg.header.msg_type === 'stream';
	    }
	    KernelMessage.isStreamMsg = isStreamMsg;
	    /**
	     * Test whether a kernel message is an `'display_data'` message.
	     */
	    function isDisplayDataMsg(msg) {
	        return msg.header.msg_type === 'display_data';
	    }
	    KernelMessage.isDisplayDataMsg = isDisplayDataMsg;
	    /**
	     * Test whether a kernel message is an `'execute_input'` message.
	     */
	    function isExecuteInputMsg(msg) {
	        return msg.header.msg_type === 'execute_input';
	    }
	    KernelMessage.isExecuteInputMsg = isExecuteInputMsg;
	    /**
	     * Test whether a kernel message is an `'execute_result'` message.
	     */
	    function isExecuteResultMsg(msg) {
	        return msg.header.msg_type === 'execute_result';
	    }
	    KernelMessage.isExecuteResultMsg = isExecuteResultMsg;
	    /**
	     * Test whether a kernel message is an `'error'` message.
	     */
	    function isErrorMsg(msg) {
	        return msg.header.msg_type === 'error';
	    }
	    KernelMessage.isErrorMsg = isErrorMsg;
	    /**
	     * Test whether a kernel message is a `'status'` message.
	     */
	    function isStatusMsg(msg) {
	        return msg.header.msg_type === 'status';
	    }
	    KernelMessage.isStatusMsg = isStatusMsg;
	    /**
	     * Test whether a kernel message is a `'clear_output'` message.
	     */
	    function isClearOutputMsg(msg) {
	        return msg.header.msg_type === 'clear_output';
	    }
	    KernelMessage.isClearOutputMsg = isClearOutputMsg;
	    /**
	     * Test whether a kernel message is a `'comm_open'` message.
	     */
	    function isCommOpenMsg(msg) {
	        return msg.header.msg_type === 'comm_open';
	    }
	    KernelMessage.isCommOpenMsg = isCommOpenMsg;
	    /**
	     * Test whether a kernel message is a `'comm_close'` message.
	     */
	    function isCommCloseMsg(msg) {
	        return msg.header.msg_type === 'comm_close';
	    }
	    KernelMessage.isCommCloseMsg = isCommCloseMsg;
	    /**
	     * Test whether a kernel message is a `'comm_msg'` message.
	     */
	    function isCommMsgMsg(msg) {
	        return msg.header.msg_type === 'comm_msg';
	    }
	    KernelMessage.isCommMsgMsg = isCommMsgMsg;
	    ;
	    /**
	     * Test whether a kernel message is an `'input_request'` message.
	     */
	    function isInputRequestMsg(msg) {
	        return msg.header.msg_type === 'input_request';
	    }
	    KernelMessage.isInputRequestMsg = isInputRequestMsg;
	})(KernelMessage = exports.KernelMessage || (exports.KernelMessage = {}));


/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(setImmediate) {// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var disposable_1 = __webpack_require__(30);
	var messages_1 = __webpack_require__(32);
	/**
	 * Implementation of a kernel future.
	 */
	var KernelFutureHandler = (function (_super) {
	    __extends(KernelFutureHandler, _super);
	    /**
	     * Construct a new KernelFutureHandler.
	     */
	    function KernelFutureHandler(cb, msg, expectShell, disposeOnDone) {
	        _super.call(this, cb);
	        this._msg = null;
	        this._status = 0;
	        this._stdin = null;
	        this._iopub = null;
	        this._reply = null;
	        this._done = null;
	        this._hooks = new Private.HookList();
	        this._disposeOnDone = true;
	        this._msg = msg;
	        if (!expectShell) {
	            this._setFlag(Private.KernelFutureFlag.GotReply);
	        }
	        this._disposeOnDone = disposeOnDone;
	    }
	    Object.defineProperty(KernelFutureHandler.prototype, "msg", {
	        /**
	         * Get the original outgoing message.
	         */
	        get: function () {
	            return this._msg;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelFutureHandler.prototype, "isDone", {
	        /**
	         * Check for message done state.
	         */
	        get: function () {
	            return this._testFlag(Private.KernelFutureFlag.IsDone);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelFutureHandler.prototype, "onReply", {
	        /**
	         * Get the reply handler.
	         */
	        get: function () {
	            return this._reply;
	        },
	        /**
	         * Set the reply handler.
	         */
	        set: function (cb) {
	            this._reply = cb;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelFutureHandler.prototype, "onIOPub", {
	        /**
	         * Get the iopub handler.
	         */
	        get: function () {
	            return this._iopub;
	        },
	        /**
	         * Set the iopub handler.
	         */
	        set: function (cb) {
	            this._iopub = cb;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelFutureHandler.prototype, "onDone", {
	        /**
	         * Get the done handler.
	         */
	        get: function () {
	            return this._done;
	        },
	        /**
	         * Set the done handler.
	         */
	        set: function (cb) {
	            this._done = cb;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelFutureHandler.prototype, "onStdin", {
	        /**
	         * Get the stdin handler.
	         */
	        get: function () {
	            return this._stdin;
	        },
	        /**
	         * Set the stdin handler.
	         */
	        set: function (cb) {
	            this._stdin = cb;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Register hook for IOPub messages.
	     *
	     * @param hook - The callback invoked for an IOPub message.
	     *
	     * #### Notes
	     * The IOPub hook system allows you to preempt the handlers for IOPub messages handled
	     * by the future. The most recently registered hook is run first.
	     * If the hook returns false, any later hooks and the future's onIOPub handler will not run.
	     * If a hook throws an error, the error is logged to the console and the next hook is run.
	     * If a hook is registered during the hook processing, it won't run until the next message.
	     * If a hook is removed during the hook processing, it will be deactivated immediately.
	     */
	    KernelFutureHandler.prototype.registerMessageHook = function (hook) {
	        this._hooks.add(hook);
	    };
	    /**
	     * Remove a hook for IOPub messages.
	     *
	     * @param hook - The hook to remove.
	     *
	     * #### Notes
	     * If a hook is removed during the hook processing, it will be deactivated immediately.
	     */
	    KernelFutureHandler.prototype.removeMessageHook = function (hook) {
	        if (this.isDisposed) {
	            return;
	        }
	        this._hooks.remove(hook);
	    };
	    /**
	     * Dispose and unregister the future.
	     */
	    KernelFutureHandler.prototype.dispose = function () {
	        this._stdin = null;
	        this._iopub = null;
	        this._reply = null;
	        this._done = null;
	        this._msg = null;
	        if (this._hooks) {
	            this._hooks.dispose();
	        }
	        this._hooks = null;
	        _super.prototype.dispose.call(this);
	    };
	    /**
	     * Handle an incoming kernel message.
	     */
	    KernelFutureHandler.prototype.handleMsg = function (msg) {
	        switch (msg.channel) {
	            case 'shell':
	                this._handleReply(msg);
	                break;
	            case 'stdin':
	                this._handleStdin(msg);
	                break;
	            case 'iopub':
	                this._handleIOPub(msg);
	                break;
	        }
	    };
	    KernelFutureHandler.prototype._handleReply = function (msg) {
	        var reply = this._reply;
	        if (reply) {
	            reply(msg);
	        }
	        this._setFlag(Private.KernelFutureFlag.GotReply);
	        if (this._testFlag(Private.KernelFutureFlag.GotIdle)) {
	            this._handleDone();
	        }
	    };
	    KernelFutureHandler.prototype._handleStdin = function (msg) {
	        var stdin = this._stdin;
	        if (stdin) {
	            stdin(msg);
	        }
	    };
	    KernelFutureHandler.prototype._handleIOPub = function (msg) {
	        var process = this._hooks.process(msg);
	        var iopub = this._iopub;
	        if (process && iopub) {
	            iopub(msg);
	        }
	        if (messages_1.KernelMessage.isStatusMsg(msg) &&
	            msg.content.execution_state === 'idle') {
	            this._setFlag(Private.KernelFutureFlag.GotIdle);
	            if (this._testFlag(Private.KernelFutureFlag.GotReply)) {
	                this._handleDone();
	            }
	        }
	    };
	    KernelFutureHandler.prototype._handleDone = function () {
	        if (this.isDone) {
	            return;
	        }
	        this._setFlag(Private.KernelFutureFlag.IsDone);
	        var done = this._done;
	        if (done)
	            done();
	        this._done = null;
	        if (this._disposeOnDone) {
	            this.dispose();
	        }
	    };
	    /**
	     * Test whether the given future flag is set.
	     */
	    KernelFutureHandler.prototype._testFlag = function (flag) {
	        return (this._status & flag) !== 0;
	    };
	    /**
	     * Set the given future flag.
	     */
	    KernelFutureHandler.prototype._setFlag = function (flag) {
	        this._status |= flag;
	    };
	    return KernelFutureHandler;
	}(disposable_1.DisposableDelegate));
	exports.KernelFutureHandler = KernelFutureHandler;
	var Private;
	(function (Private) {
	    /**
	     * A polyfill for a function to run code outside of the current execution context.
	     */
	    var defer = typeof requestAnimationFrame === "function" ? requestAnimationFrame : setImmediate;
	    var HookList = (function () {
	        function HookList() {
	            this._hooks = [];
	        }
	        /**
	         * Register a hook.
	         *
	         * @param hook - The callback to register.
	         */
	        HookList.prototype.add = function (hook) {
	            this.remove(hook);
	            this._hooks.push(hook);
	        };
	        /**
	         * Remove a hook.
	         *
	         * @param hook - The callback to remove.
	         */
	        HookList.prototype.remove = function (hook) {
	            if (this.isDisposed) {
	                return;
	            }
	            var index = this._hooks.indexOf(hook);
	            if (index >= 0) {
	                this._hooks[index] = null;
	                this._scheduleCompact();
	            }
	        };
	        /**
	         * Process a message through the hooks.
	         *
	         * #### Notes
	         * The most recently registered hook is run first.
	         * If the hook returns false, any later hooks will not run.
	         * If a hook throws an error, the error is logged to the console and the next hook is run.
	         * If a hook is registered during the hook processing, it won't run until the next message.
	         * If a hook is removed during the hook processing, it will be deactivated immediately.
	         */
	        HookList.prototype.process = function (msg) {
	            var continueHandling;
	            // most recently-added hook is called first
	            for (var i = this._hooks.length - 1; i >= 0; i--) {
	                var hook = this._hooks[i];
	                if (hook === null) {
	                    continue;
	                }
	                try {
	                    continueHandling = hook(msg);
	                }
	                catch (err) {
	                    continueHandling = true;
	                    console.error(err);
	                }
	                if (continueHandling === false) {
	                    return false;
	                }
	            }
	            return true;
	        };
	        Object.defineProperty(HookList.prototype, "isDisposed", {
	            /**
	             * Test whether the HookList has been disposed.
	             */
	            get: function () {
	                return (this._hooks === null);
	            },
	            enumerable: true,
	            configurable: true
	        });
	        /**
	         * Dispose the hook list.
	         */
	        HookList.prototype.dispose = function () {
	            this._hooks = null;
	        };
	        /**
	         * Schedule a cleanup of the list, removing any hooks that have been nulled out.
	         */
	        HookList.prototype._scheduleCompact = function () {
	            var _this = this;
	            if (!this._cleanupScheduled) {
	                this._cleanupScheduled = true;
	                defer(function () {
	                    _this._cleanupScheduled = false;
	                    _this._compact();
	                });
	            }
	        };
	        /**
	         * Compact the list, removing any nulls.
	         */
	        HookList.prototype._compact = function () {
	            if (this.isDisposed) {
	                return;
	            }
	            var numNulls = 0;
	            for (var i = 0, len = this._hooks.length; i < len; i++) {
	                var hook = this._hooks[i];
	                if (this._hooks[i] === null) {
	                    numNulls++;
	                }
	                else {
	                    this._hooks[i - numNulls] = hook;
	                }
	            }
	            this._hooks.length -= numNulls;
	        };
	        return HookList;
	    }());
	    Private.HookList = HookList;
	    /**
	     * Bit flags for the kernel future state.
	     */
	    (function (KernelFutureFlag) {
	        KernelFutureFlag[KernelFutureFlag["GotReply"] = 1] = "GotReply";
	        KernelFutureFlag[KernelFutureFlag["GotIdle"] = 2] = "GotIdle";
	        KernelFutureFlag[KernelFutureFlag["IsDone"] = 4] = "IsDone";
	        KernelFutureFlag[KernelFutureFlag["DisposeOnDone"] = 8] = "DisposeOnDone";
	    })(Private.KernelFutureFlag || (Private.KernelFutureFlag = {}));
	    var KernelFutureFlag = Private.KernelFutureFlag;
	})(Private || (Private = {}));
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(21).setImmediate))

/***/ },
/* 34 */
/***/ function(module, exports) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	/**
	 * Deserialize and return the unpacked message.
	 *
	 * #### Notes
	 * Handles JSON blob strings and binary messages.
	 */
	function deserialize(data) {
	    var value;
	    if (typeof data === 'string') {
	        value = JSON.parse(data);
	    }
	    else {
	        value = deserializeBinary(data);
	    }
	    return value;
	}
	exports.deserialize = deserialize;
	/**
	 * Serialize a kernel message for transport.
	 *
	 * #### Notes
	 * If there is binary content, an `ArrayBuffer` is returned,
	 * otherwise the message is converted to a JSON string.
	 */
	function serialize(msg) {
	    var value;
	    if (msg.buffers && msg.buffers.length) {
	        value = serializeBinary(msg);
	    }
	    else {
	        value = JSON.stringify(msg);
	    }
	    return value;
	}
	exports.serialize = serialize;
	/**
	 * Deserialize a binary message to a Kernel Message.
	 */
	function deserializeBinary(buf) {
	    var data = new DataView(buf);
	    // read the header: 1 + nbufs 32b integers
	    var nbufs = data.getUint32(0);
	    var offsets = [];
	    if (nbufs < 2) {
	        throw new Error('Invalid incoming Kernel Message');
	    }
	    for (var i = 1; i <= nbufs; i++) {
	        offsets.push(data.getUint32(i * 4));
	    }
	    var jsonBytes = new Uint8Array(buf.slice(offsets[0], offsets[1]));
	    var msg = JSON.parse((new TextDecoder('utf8')).decode(jsonBytes));
	    // the remaining chunks are stored as DataViews in msg.buffers
	    msg.buffers = [];
	    for (var i = 1; i < nbufs; i++) {
	        var start = offsets[i];
	        var stop = offsets[i + 1] || buf.byteLength;
	        msg.buffers.push(new DataView(buf.slice(start, stop)));
	    }
	    return msg;
	}
	/**
	 * Implement the binary serialization protocol.
	 *
	 * Serialize Kernel message to ArrayBuffer.
	 */
	function serializeBinary(msg) {
	    var offsets = [];
	    var buffers = [];
	    var encoder = new TextEncoder('utf8');
	    var jsonUtf8 = encoder.encode(JSON.stringify(msg, replaceBuffers));
	    buffers.push(jsonUtf8.buffer);
	    for (var i = 0; i < msg.buffers.length; i++) {
	        // msg.buffers elements could be either views or ArrayBuffers
	        // buffers elements are ArrayBuffers
	        var b = msg.buffers[i];
	        buffers.push(b instanceof ArrayBuffer ? b : b.buffer);
	    }
	    var nbufs = buffers.length;
	    offsets.push(4 * (nbufs + 1));
	    for (var i = 0; i + 1 < buffers.length; i++) {
	        offsets.push(offsets[offsets.length - 1] + buffers[i].byteLength);
	    }
	    var msgBuf = new Uint8Array(offsets[offsets.length - 1] + buffers[buffers.length - 1].byteLength);
	    // use DataView.setUint32 for network byte-order
	    var view = new DataView(msgBuf.buffer);
	    // write nbufs to first 4 bytes
	    view.setUint32(0, nbufs);
	    // write offsets to next 4 * nbufs bytes
	    for (var i = 0; i < offsets.length; i++) {
	        view.setUint32(4 * (i + 1), offsets[i]);
	    }
	    // write all the buffers at their respective offsets
	    for (var i = 0; i < buffers.length; i++) {
	        msgBuf.set(new Uint8Array(buffers[i]), offsets[i]);
	    }
	    return msgBuf.buffer;
	}
	/**
	 * Filter `"buffers"` key for `JSON.stringify`.
	 */
	function replaceBuffers(key, value) {
	    if (key === 'buffers') {
	        return undefined;
	    }
	    return value;
	}


/***/ },
/* 35 */
/***/ function(module, exports) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	/**
	 * Required fields for `IKernelHeader`.
	 */
	var HEADER_FIELDS = ['username', 'version', 'session', 'msg_id', 'msg_type'];
	/**
	 * Requred fields and types for contents of various types of `kernel.IMessage`
	 * messages on the iopub channel.
	 */
	var IOPUB_CONTENT_FIELDS = {
	    stream: { name: 'string', text: 'string' },
	    display_data: { data: 'object', metadata: 'object' },
	    execute_input: { code: 'string', execution_count: 'number' },
	    execute_result: { execution_count: 'number', data: 'object',
	        metadata: 'object' },
	    error: { ename: 'string', evalue: 'string', traceback: 'object' },
	    status: { execution_state: 'string' },
	    clear_output: { wait: 'boolean' },
	    comm_open: { comm_id: 'string', target_name: 'string', data: 'object' },
	    comm_msg: { comm_id: 'string', data: 'object' },
	    comm_close: { comm_id: 'string' },
	    shutdown_reply: { restart: 'boolean' } // Emitted by the IPython kernel.
	};
	/**
	 * Validate a property as being on an object, and optionally
	 * of a given type.
	 */
	function validateProperty(object, name, typeName) {
	    if (!object.hasOwnProperty(name)) {
	        throw Error("Missing property '" + name + "'");
	    }
	    if (typeName !== void 0) {
	        var valid = true;
	        var value = object[name];
	        switch (typeName) {
	            case 'array':
	                valid = Array.isArray(value);
	                break;
	            case 'object':
	                valid = typeof value !== 'undefined';
	                break;
	            default:
	                valid = typeof value === typeName;
	        }
	        if (!valid) {
	            throw new Error("Property '" + name + "' is not of type '" + typeName);
	        }
	    }
	}
	/**
	 * Validate the header of a kernel message.
	 */
	function validateHeader(header) {
	    for (var i = 0; i < HEADER_FIELDS.length; i++) {
	        validateProperty(header, HEADER_FIELDS[i], 'string');
	    }
	}
	/**
	 * Validate a kernel message object.
	 */
	function validateMessage(msg) {
	    validateProperty(msg, 'metadata', 'object');
	    validateProperty(msg, 'content', 'object');
	    validateProperty(msg, 'channel', 'string');
	    validateHeader(msg.header);
	    if (msg.channel === 'iopub') {
	        validateIOPubContent(msg);
	    }
	}
	exports.validateMessage = validateMessage;
	/**
	 * Validate content an kernel message on the iopub channel.
	 */
	function validateIOPubContent(msg) {
	    if (msg.channel === 'iopub') {
	        var fields = IOPUB_CONTENT_FIELDS[msg.header.msg_type];
	        if (fields === void 0) {
	            throw Error("Invalid Kernel message: iopub message type " + msg.header.msg_type + " not recognized");
	        }
	        var names = Object.keys(fields);
	        var content = msg.content;
	        for (var i = 0; i < names.length; i++) {
	            validateProperty(content, names[i], fields[names[i]]);
	        }
	    }
	}
	/**
	 * Validate a `Kernel.IModel` object.
	 */
	function validateModel(model) {
	    validateProperty(model, 'name', 'string');
	    validateProperty(model, 'id', 'string');
	}
	exports.validateModel = validateModel;
	/**
	 * Validate a server kernelspec model to a client side model.
	 */
	function validateSpecModel(data) {
	    var spec = data.spec;
	    if (!spec) {
	        throw new Error('Invalid kernel spec');
	    }
	    validateProperty(data, 'name', 'string');
	    validateProperty(data, 'resources', 'object');
	    validateProperty(spec, 'language', 'string');
	    validateProperty(spec, 'display_name', 'string');
	    validateProperty(spec, 'argv', 'array');
	    return {
	        name: data.name,
	        resources: data.resources,
	        language: spec.language,
	        display_name: spec.display_name,
	        argv: spec.argv
	    };
	}
	exports.validateSpecModel = validateSpecModel;
	/**
	 * Validate a `Kernel.ISpecModels` object.
	 */
	function validateSpecModels(data) {
	    if (!data.hasOwnProperty('kernelspecs')) {
	        throw new Error('No kernelspecs found');
	    }
	    var keys = Object.keys(data.kernelspecs);
	    var kernelspecs = Object.create(null);
	    var defaultSpec = data.default;
	    for (var i = 0; i < keys.length; i++) {
	        var ks = data.kernelspecs[keys[i]];
	        try {
	            kernelspecs[keys[i]] = validateSpecModel(ks);
	        }
	        catch (err) {
	            // Remove the errant kernel spec.
	            console.warn("Removing errant kernel spec: " + keys[i]);
	        }
	    }
	    keys = Object.keys(kernelspecs);
	    if (!keys.length) {
	        throw new Error('No valid kernelspecs found');
	    }
	    if (!defaultSpec || typeof defaultSpec !== 'string' ||
	        !(defaultSpec in kernelspecs)) {
	        defaultSpec = keys[0];
	        console.warn("Default kernel not found, using '" + keys[0] + "'");
	    }
	    return {
	        default: defaultSpec,
	        kernelspecs: kernelspecs,
	    };
	}
	exports.validateSpecModels = validateSpecModels;


/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var iteration_1 = __webpack_require__(26);
	var json_1 = __webpack_require__(37);
	var searching_1 = __webpack_require__(27);
	var signaling_1 = __webpack_require__(20);
	var utils = __webpack_require__(4);
	var kernel_1 = __webpack_require__(24);
	/**
	 * An implementation of a kernel manager.
	 */
	var KernelManager = (function () {
	    /**
	     * Construct a new kernel manager.
	     *
	     * @param options - The default options for kernel.
	     */
	    function KernelManager(options) {
	        var _this = this;
	        if (options === void 0) { options = {}; }
	        this._baseUrl = '';
	        this._wsUrl = '';
	        this._token = '';
	        this._ajaxSettings = '';
	        this._running = [];
	        this._specs = null;
	        this._isDisposed = false;
	        this._runningTimer = -1;
	        this._specsTimer = -1;
	        this._isReady = false;
	        this._baseUrl = options.baseUrl || utils.getBaseUrl();
	        this._wsUrl = options.wsUrl || utils.getWsUrl(this._baseUrl);
	        this._token = options.token || utils.getConfigOption('token');
	        this._ajaxSettings = JSON.stringify(utils.ajaxSettingsWithToken(options.ajaxSettings, options.token));
	        // Initialize internal data.
	        this._readyPromise = this._refreshSpecs().then(function () {
	            return _this._refreshRunning();
	        });
	        // Set up polling.
	        this._runningTimer = setInterval(function () {
	            _this._refreshRunning();
	        }, 10000);
	        this._specsTimer = setInterval(function () {
	            _this._refreshSpecs();
	        }, 61000);
	    }
	    Object.defineProperty(KernelManager.prototype, "isDisposed", {
	        /**
	         * Test whether the terminal manager is disposed.
	         */
	        get: function () {
	            return this._isDisposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources used by the manager.
	     */
	    KernelManager.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._isDisposed = true;
	        clearInterval(this._runningTimer);
	        clearInterval(this._specsTimer);
	        signaling_1.clearSignalData(this);
	        this._specs = null;
	        this._running = [];
	    };
	    Object.defineProperty(KernelManager.prototype, "baseUrl", {
	        /**
	         * Get the base url of the manager.
	         */
	        get: function () {
	            return this._baseUrl;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelManager.prototype, "wsUrl", {
	        /**
	         * Get the ws url of the manager.
	         */
	        get: function () {
	            return this._wsUrl;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelManager.prototype, "ajaxSettings", {
	        /**
	         * The default ajax settings for the manager.
	         */
	        get: function () {
	            return JSON.parse(this._ajaxSettings);
	        },
	        /**
	         * Set the default ajax settings for the manager.
	         */
	        set: function (value) {
	            this._ajaxSettings = JSON.stringify(value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelManager.prototype, "specs", {
	        /**
	         * Get the most recently fetched kernel specs.
	         */
	        get: function () {
	            return this._specs;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelManager.prototype, "isReady", {
	        /**
	         * Test whether the manager is ready.
	         */
	        get: function () {
	            return this._isReady;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelManager.prototype, "ready", {
	        /**
	         * A promise that fulfills when the manager is ready.
	         */
	        get: function () {
	            return this._readyPromise;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Create an iterator over the most recent running kernels.
	     *
	     * @returns A new iterator over the running kernels.
	     */
	    KernelManager.prototype.running = function () {
	        return iteration_1.iter(this._running);
	    };
	    /**
	     * Force a refresh of the specs from the server.
	     *
	     * @returns A promise that resolves when the specs are fetched.
	     *
	     * #### Notes
	     * This is intended to be called only in response to a user action,
	     * since the manager maintains its internal state.
	     */
	    KernelManager.prototype.refreshSpecs = function () {
	        return this._refreshSpecs();
	    };
	    /**
	     * Force a refresh of the running kernels.
	     *
	     * @returns A promise that with the list of running sessions.
	     *
	     * #### Notes
	     * This is not typically meant to be called by the user, since the
	     * manager maintains its own internal state.
	     */
	    KernelManager.prototype.refreshRunning = function () {
	        return this._refreshRunning();
	    };
	    /**
	     * Start a new kernel.  See also [[startNewKernel]].
	     *
	     * @param options - Overrides for the default options.
	     */
	    KernelManager.prototype.startNew = function (options) {
	        var _this = this;
	        return kernel_1.Kernel.startNew(this._getOptions(options)).then(function (kernel) {
	            _this._onStarted(kernel);
	            return kernel;
	        });
	    };
	    /**
	     * Find a kernel by id.
	     *
	     * @param options - Overrides for the default options.
	     */
	    KernelManager.prototype.findById = function (id, options) {
	        return kernel_1.Kernel.findById(id, this._getOptions(options));
	    };
	    /**
	     * Connect to a running kernel.  See also [[connectToKernel]].
	     *
	     * @param options - Overrides for the default options.
	     */
	    KernelManager.prototype.connectTo = function (id, options) {
	        var _this = this;
	        return kernel_1.Kernel.connectTo(id, this._getOptions(options)).then(function (kernel) {
	            _this._onStarted(kernel);
	            return kernel;
	        });
	    };
	    /**
	     * Shut down a kernel by id.
	     *
	     * @param options - Overrides for the default options.
	     *
	     * #### Notes
	     * This will emit [[runningChanged]] if the running kernels list
	     * changes.
	     */
	    KernelManager.prototype.shutdown = function (id, options) {
	        var _this = this;
	        return kernel_1.Kernel.shutdown(id, this._getOptions(options)).then(function () {
	            _this._onTerminated(id);
	        });
	    };
	    /**
	     * Handle a kernel terminating.
	     */
	    KernelManager.prototype._onTerminated = function (id) {
	        var index = searching_1.findIndex(this._running, function (value) { return value.id === id; });
	        if (index !== -1) {
	            this._running.splice(index, 1);
	            this.runningChanged.emit(this._running.slice());
	        }
	    };
	    /**
	     * Handle a kernel starting.
	     */
	    KernelManager.prototype._onStarted = function (kernel) {
	        var _this = this;
	        var id = kernel.id;
	        var index = searching_1.findIndex(this._running, function (value) { return value.id === id; });
	        if (index === -1) {
	            this._running.push(kernel.model);
	            this.runningChanged.emit(this._running.slice());
	        }
	        kernel.terminated.connect(function () {
	            _this._onTerminated(id);
	        });
	    };
	    /**
	     * Refresh the specs.
	     */
	    KernelManager.prototype._refreshSpecs = function () {
	        var _this = this;
	        var options = {
	            baseUrl: this._baseUrl,
	            token: this._token,
	            ajaxSettings: this.ajaxSettings
	        };
	        return kernel_1.Kernel.getSpecs(options).then(function (specs) {
	            if (!json_1.deepEqual(specs, _this._specs)) {
	                _this._specs = specs;
	                _this.specsChanged.emit(specs);
	            }
	        });
	    };
	    /**
	     * Refresh the running sessions.
	     */
	    KernelManager.prototype._refreshRunning = function () {
	        var _this = this;
	        return kernel_1.Kernel.listRunning(this._getOptions({})).then(function (running) {
	            _this._isReady = true;
	            if (!json_1.deepEqual(running, _this._running)) {
	                _this._running = running.slice();
	                _this.runningChanged.emit(running);
	            }
	        });
	    };
	    /**
	     * Get optionally overidden options.
	     */
	    KernelManager.prototype._getOptions = function (options) {
	        if (options === void 0) { options = {}; }
	        options.baseUrl = this._baseUrl;
	        options.wsUrl = this._wsUrl;
	        options.token = this._token;
	        options.ajaxSettings = options.ajaxSettings || this.ajaxSettings;
	        return options;
	    };
	    return KernelManager;
	}());
	exports.KernelManager = KernelManager;
	// Define the signal for the `KernelManager` class.
	signaling_1.defineSignal(KernelManager.prototype, 'specsChanged');
	signaling_1.defineSignal(KernelManager.prototype, 'runningChanged');


/***/ },
/* 37 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * Test whether a JSON value is a primitive.
	 *
	 * @param value - The JSON value of interest.
	 *
	 * @returns `true` if the value is a primitive or `null`,
	 *   `false` otherwise.
	 */
	function isPrimitive(value) {
	    return (value === null ||
	        typeof value === 'boolean' ||
	        typeof value === 'number' ||
	        typeof value === 'string');
	}
	exports.isPrimitive = isPrimitive;
	/**
	 * Test whether a JSON value is an array.
	 *
	 * @param value - The JSON value of interest.
	 *
	 * @returns `true` if the value is a an array, `false` otherwise.
	 */
	function isArray(value) {
	    return Array.isArray(value);
	}
	exports.isArray = isArray;
	/**
	 * Test whether a JSON value is an object.
	 *
	 * @param value - The JSON value of interest.
	 *
	 * @returns `true` if the value is a an object, `false` otherwise.
	 */
	function isObject(value) {
	    return !isPrimitive(value) && !isArray(value);
	}
	exports.isObject = isObject;
	/**
	 * Compare two JSON values for deep equality.
	 *
	 * @param first - The first JSON value of interest.
	 *
	 * @param second - The second JSON value of interest.
	 *
	 * @returns `true` if the values are equivalent, `false` otherwise.
	 */
	function deepEqual(first, second) {
	    // Check referential and primitive equality first.
	    if (first === second) {
	        return true;
	    }
	    // If one is a primitive, the `===` check ruled out the other.
	    if (isPrimitive(first) || isPrimitive(second)) {
	        return false;
	    }
	    // Bail if either is `undefined`.
	    if (!first || !second) {
	        return false;
	    }
	    // Test whether they are arrays.
	    var a1 = isArray(first);
	    var a2 = isArray(second);
	    // Bail if the types are different.
	    if (a1 !== a2) {
	        return false;
	    }
	    // If they are both arrays, compare them.
	    if (a1 && a2) {
	        return Private.arrayEqual(first, second);
	    }
	    // At this point, they must both be objects.
	    return Private.objectEqual(first, second);
	}
	exports.deepEqual = deepEqual;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Compare two JSON arrays for deep equality.
	     */
	    function arrayEqual(first, second) {
	        // Test the arrays for equal length.
	        if (first.length !== second.length) {
	            return false;
	        }
	        // Compare the values for equality.
	        for (var i = 0, n = first.length; i < n; ++i) {
	            if (!deepEqual(first[i], second[i])) {
	                return false;
	            }
	        }
	        // At this point, the arrays are equal.
	        return true;
	    }
	    Private.arrayEqual = arrayEqual;
	    /**
	     * Compare two JSON objects for deep equality.
	     */
	    function objectEqual(first, second) {
	        // Get the keys for each object.
	        var k1 = Object.keys(first);
	        var k2 = Object.keys(second);
	        // Test the keys for equal length.
	        if (k1.length !== k2.length) {
	            return false;
	        }
	        // Sort the keys for equivalent order.
	        k1.sort();
	        k2.sort();
	        // Compare the keys for equality.
	        for (var i = 0, n = k1.length; i < n; ++i) {
	            if (k1[i] !== k2[i]) {
	                return false;
	            }
	        }
	        // Compare the values for equality.
	        for (var i = 0, n = k1.length; i < n; ++i) {
	            if (!deepEqual(first[k1[i]], second[k1[i]])) {
	                return false;
	            }
	        }
	        // At this point, the objects are equal.
	        return true;
	    }
	    Private.objectEqual = objectEqual;
	})(Private || (Private = {}));


/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var signaling_1 = __webpack_require__(20);
	var contents_1 = __webpack_require__(15);
	var session_1 = __webpack_require__(39);
	var terminal_1 = __webpack_require__(44);
	var utils_1 = __webpack_require__(4);
	/**
	 * A Jupyter services manager.
	 */
	var ServiceManager = (function () {
	    /**
	     * Construct a new services provider.
	     */
	    function ServiceManager(options) {
	        var _this = this;
	        this._sessionManager = null;
	        this._contentsManager = null;
	        this._terminalManager = null;
	        this._isDisposed = false;
	        options = options || {};
	        options.wsUrl = options.wsUrl || utils_1.getWsUrl();
	        options.baseUrl = options.baseUrl || utils_1.getBaseUrl();
	        options.ajaxSettings = utils_1.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	        this._sessionManager = new session_1.SessionManager(options);
	        this._contentsManager = new contents_1.ContentsManager(options);
	        this._terminalManager = new terminal_1.TerminalManager(options);
	        this._sessionManager.specsChanged.connect(function (sender, specs) {
	            _this.specsChanged.emit(specs);
	        });
	        this._readyPromise = this._sessionManager.ready.then(function () {
	            if (_this._terminalManager.isAvailable()) {
	                return _this._terminalManager.ready;
	            }
	        });
	    }
	    Object.defineProperty(ServiceManager.prototype, "isDisposed", {
	        /**
	         * Test whether the terminal manager is disposed.
	         */
	        get: function () {
	            return this._isDisposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources used by the manager.
	     */
	    ServiceManager.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._isDisposed = true;
	        signaling_1.clearSignalData(this);
	        this._sessionManager.dispose();
	        this._contentsManager.dispose();
	        this._sessionManager.dispose();
	    };
	    Object.defineProperty(ServiceManager.prototype, "specs", {
	        /**
	         * The kernel spec models.
	         */
	        get: function () {
	            return this._sessionManager.specs;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ServiceManager.prototype, "baseUrl", {
	        /**
	         * Get the base url of the server.
	         */
	        get: function () {
	            return this._sessionManager.baseUrl;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ServiceManager.prototype, "sessions", {
	        /**
	         * Get the session manager instance.
	         */
	        get: function () {
	            return this._sessionManager;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ServiceManager.prototype, "contents", {
	        /**
	         * Get the contents manager instance.
	         */
	        get: function () {
	            return this._contentsManager;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ServiceManager.prototype, "terminals", {
	        /**
	         * Get the terminal manager instance.
	         */
	        get: function () {
	            return this._terminalManager;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ServiceManager.prototype, "isReady", {
	        /**
	         * Test whether the manager is ready.
	         */
	        get: function () {
	            return this._sessionManager.isReady || this._terminalManager.isReady;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ServiceManager.prototype, "ready", {
	        /**
	         * A promise that fulfills when the manager is ready.
	         */
	        get: function () {
	            return this._readyPromise;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return ServiceManager;
	}());
	exports.ServiceManager = ServiceManager;
	// Define the signals for the `ServiceManager` class.
	signaling_1.defineSignal(ServiceManager.prototype, 'specsChanged');


/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(40));
	__export(__webpack_require__(41));


/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var iteration_1 = __webpack_require__(26);
	var json_1 = __webpack_require__(37);
	var searching_1 = __webpack_require__(27);
	var signaling_1 = __webpack_require__(20);
	var kernel_1 = __webpack_require__(23);
	var utils = __webpack_require__(4);
	var session_1 = __webpack_require__(41);
	/**
	 * An implementation of a session manager.
	 */
	var SessionManager = (function () {
	    /**
	     * Construct a new session manager.
	     *
	     * @param options - The default options for each session.
	     */
	    function SessionManager(options) {
	        var _this = this;
	        if (options === void 0) { options = {}; }
	        this._baseUrl = '';
	        this._wsUrl = '';
	        this._ajaxSettings = '';
	        this._isDisposed = false;
	        this._running = [];
	        this._specs = null;
	        this._runningTimer = -1;
	        this._specsTimer = -1;
	        this._baseUrl = options.baseUrl || utils.getBaseUrl();
	        this._wsUrl = options.wsUrl || utils.getWsUrl(this._baseUrl);
	        this._ajaxSettings = JSON.stringify(options.ajaxSettings || {});
	        // Initialize internal data.
	        this._readyPromise = this._refreshSpecs().then(function () {
	            return _this._refreshRunning();
	        });
	        // Set up polling.
	        this._runningTimer = setInterval(function () {
	            _this._refreshRunning();
	        }, 10000);
	        this._specsTimer = setInterval(function () {
	            _this._refreshSpecs();
	        }, 61000);
	    }
	    Object.defineProperty(SessionManager.prototype, "isDisposed", {
	        /**
	         * Test whether the terminal manager is disposed.
	         */
	        get: function () {
	            return this._isDisposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources used by the manager.
	     */
	    SessionManager.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._isDisposed = true;
	        clearInterval(this._runningTimer);
	        clearInterval(this._specsTimer);
	        signaling_1.clearSignalData(this);
	        this._running = [];
	    };
	    Object.defineProperty(SessionManager.prototype, "baseUrl", {
	        /**
	         * The base url of the manager.
	         */
	        get: function () {
	            return this._baseUrl;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SessionManager.prototype, "wsUrl", {
	        /**
	         * The base ws url of the manager.
	         */
	        get: function () {
	            return this._wsUrl;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SessionManager.prototype, "ajaxSettings", {
	        /**
	         * The default ajax settings for the manager.
	         */
	        get: function () {
	            return JSON.parse(this._ajaxSettings);
	        },
	        /**
	         * Set the default ajax settings for the manager.
	         */
	        set: function (value) {
	            this._ajaxSettings = JSON.stringify(value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SessionManager.prototype, "specs", {
	        /**
	         * Get the most recently fetched kernel specs.
	         */
	        get: function () {
	            return this._specs;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SessionManager.prototype, "isReady", {
	        /**
	         * Test whether the manager is ready.
	         */
	        get: function () {
	            return this._specs !== null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SessionManager.prototype, "ready", {
	        /**
	         * A promise that fulfills when the manager is ready.
	         */
	        get: function () {
	            return this._readyPromise;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Create an iterator over the most recent running sessions.
	     *
	     * @returns A new iterator over the running sessions.
	     */
	    SessionManager.prototype.running = function () {
	        return iteration_1.iter(this._running);
	    };
	    /**
	     * Force a refresh of the specs from the server.
	     *
	     * @returns A promise that resolves when the specs are fetched.
	     *
	     * #### Notes
	     * This is intended to be called only in response to a user action,
	     * since the manager maintains its internal state.
	     */
	    SessionManager.prototype.refreshSpecs = function () {
	        return this._refreshSpecs();
	    };
	    /**
	     * Force a refresh of the running sessions.
	     *
	     * @returns A promise that with the list of running sessions.
	     *
	     * #### Notes
	     * This is not typically meant to be called by the user, since the
	     * manager maintains its own internal state.
	     */
	    SessionManager.prototype.refreshRunning = function () {
	        return this._refreshRunning();
	    };
	    /**
	     * Start a new session.  See also [[startNewSession]].
	     *
	     * @param options - Overrides for the default options, must include a
	     *   `'path'`.
	     */
	    SessionManager.prototype.startNew = function (options) {
	        var _this = this;
	        return session_1.Session.startNew(this._getOptions(options)).then(function (session) {
	            _this._onStarted(session);
	            return session;
	        });
	    };
	    /**
	     * Find a session by id.
	     */
	    SessionManager.prototype.findById = function (id, options) {
	        return session_1.Session.findById(id, this._getOptions(options));
	    };
	    /**
	     * Find a session by path.
	     */
	    SessionManager.prototype.findByPath = function (path, options) {
	        return session_1.Session.findByPath(path, this._getOptions(options));
	    };
	    /*
	     * Connect to a running session.  See also [[connectToSession]].
	     */
	    SessionManager.prototype.connectTo = function (id, options) {
	        var _this = this;
	        return session_1.Session.connectTo(id, this._getOptions(options)).then(function (session) {
	            _this._onStarted(session);
	            return session;
	        });
	    };
	    /**
	     * Shut down a session by id.
	     */
	    SessionManager.prototype.shutdown = function (id, options) {
	        var _this = this;
	        return session_1.Session.shutdown(id, this._getOptions(options)).then(function () {
	            _this._onTerminated(id);
	        });
	    };
	    /**
	     * Get optionally overidden options.
	     */
	    SessionManager.prototype._getOptions = function (options) {
	        if (options === void 0) { options = {}; }
	        options.baseUrl = this._baseUrl;
	        options.wsUrl = this._wsUrl;
	        options.ajaxSettings = options.ajaxSettings || this.ajaxSettings;
	        return options;
	    };
	    /**
	     * Handle a session terminating.
	     */
	    SessionManager.prototype._onTerminated = function (id) {
	        var index = searching_1.findIndex(this._running, function (value) { return value.id === id; });
	        if (index !== -1) {
	            this._running.splice(index, 1);
	            this.runningChanged.emit(this._running.slice());
	        }
	    };
	    /**
	     * Handle a session starting.
	     */
	    SessionManager.prototype._onStarted = function (session) {
	        var _this = this;
	        var id = session.id;
	        var index = searching_1.findIndex(this._running, function (value) { return value.id === id; });
	        if (index === -1) {
	            this._running.push(session.model);
	            this.runningChanged.emit(this._running.slice());
	        }
	        session.terminated.connect(function () {
	            _this._onTerminated(id);
	        });
	        session.pathChanged.connect(function () {
	            _this._onChanged(session.model);
	        });
	        session.kernelChanged.connect(function () {
	            _this._onChanged(session.model);
	        });
	    };
	    /**
	     * Handle a change to a session.
	     */
	    SessionManager.prototype._onChanged = function (model) {
	        var index = searching_1.findIndex(this._running, function (value) { return value.id === model.id; });
	        if (index !== -1) {
	            this._running[index] = model;
	            this.runningChanged.emit(this._running.slice());
	        }
	    };
	    /**
	     * Refresh the specs.
	     */
	    SessionManager.prototype._refreshSpecs = function () {
	        var _this = this;
	        var options = {
	            baseUrl: this._baseUrl,
	            ajaxSettings: this.ajaxSettings
	        };
	        return kernel_1.Kernel.getSpecs(options).then(function (specs) {
	            if (!json_1.deepEqual(specs, _this._specs)) {
	                _this._specs = specs;
	                _this.specsChanged.emit(specs);
	            }
	        });
	    };
	    /**
	     * Refresh the running sessions.
	     */
	    SessionManager.prototype._refreshRunning = function () {
	        var _this = this;
	        return session_1.Session.listRunning(this._getOptions({})).then(function (running) {
	            if (!json_1.deepEqual(running, _this._running)) {
	                _this._running = running.slice();
	                _this.runningChanged.emit(running);
	            }
	        });
	    };
	    return SessionManager;
	}());
	exports.SessionManager = SessionManager;
	// Define the signals for the `SessionManager` class.
	signaling_1.defineSignal(SessionManager.prototype, 'specsChanged');
	signaling_1.defineSignal(SessionManager.prototype, 'runningChanged');


/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var default_1 = __webpack_require__(42);
	/**
	 * A namespace for session interfaces and factory functions.
	 */
	var Session;
	(function (Session) {
	    /**
	     * List the running sessions.
	     *
	     * @param options - The options used for the request.
	     *
	     * @returns A promise that resolves with the list of session models.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/sessions), and validates the response.
	     *
	     * All client-side sessions are updated with current information.
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     */
	    function listRunning(options) {
	        return default_1.DefaultSession.listRunning(options);
	    }
	    Session.listRunning = listRunning;
	    /**
	     * Start a new session.
	     *
	     * @param options - The options used to start the session.
	     *
	     * @returns A promise that resolves with the session instance.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/sessions), and validates the response.
	     *
	     * A path must be provided.  If a kernel id is given, it will
	     * connect to an existing kernel.  If no kernel id or name is given,
	     * the server will start the default kernel type.
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     *
	     * Wrap the result in an Session object. The promise is fulfilled
	     * when the session is created on the server, otherwise the promise is
	     * rejected.
	     */
	    function startNew(options) {
	        return default_1.DefaultSession.startNew(options);
	    }
	    Session.startNew = startNew;
	    /**
	     * Find a session by id.
	     *
	     * @param id - The id of the target session.
	     *
	     * @param options - The options used to fetch the session.
	     *
	     * @returns A promise that resolves with the session model.
	     *
	     * #### Notes
	     * If the session was already started via `startNew`, the existing
	     * Session object's information is used in the fulfillment value.
	     *
	     * Otherwise, if `options` are given, we attempt to find to the existing
	     * session.
	     * The promise is fulfilled when the session is found,
	     * otherwise the promise is rejected.
	     */
	    function findById(id, options) {
	        return default_1.DefaultSession.findById(id, options);
	    }
	    Session.findById = findById;
	    /**
	     * Find a session by path.
	     *
	     * @param path - The path of the target session.
	     *
	     * @param options - The options used to fetch the session.
	     *
	     * @returns A promise that resolves with the session model.
	     *
	     * #### Notes
	     * If the session was already started via `startNewSession`, the existing
	     * Session object's info is used in the fulfillment value.
	     *
	     * Otherwise, if `options` are given, we attempt to find to the existing
	     * session using [listRunningSessions].
	     * The promise is fulfilled when the session is found,
	     * otherwise the promise is rejected.
	     *
	     * If the session was not already started and no `options` are given,
	     * the promise is rejected.
	     */
	    function findByPath(path, options) {
	        return default_1.DefaultSession.findByPath(path, options);
	    }
	    Session.findByPath = findByPath;
	    /**
	     * Connect to a running session.
	     *
	     * @param id - The id of the target session.
	     *
	     * @param options - The options used to fetch the session.
	     *
	     * @returns A promise that resolves with the session instance.
	     *
	     * #### Notes
	     * If the session was already started via `startNew`, the existing
	     * Session object is used as the fulfillment value.
	     *
	     * Otherwise, if `options` are given, we attempt to connect to the existing
	     * session.
	     * The promise is fulfilled when the session is ready on the server,
	     * otherwise the promise is rejected.
	     *
	     * If the session was not already started and no `options` are given,
	     * the promise is rejected.
	     */
	    function connectTo(id, options) {
	        return default_1.DefaultSession.connectTo(id, options);
	    }
	    Session.connectTo = connectTo;
	    /**
	     * Shut down a session by id.
	     *
	     * @param id - The id of the target session.
	     *
	     * @param options - The options used to fetch the session.
	     *
	     * @returns A promise that resolves when the session is shut down.
	     *
	     */
	    function shutdown(id, options) {
	        if (options === void 0) { options = {}; }
	        return default_1.DefaultSession.shutdown(id, options);
	    }
	    Session.shutdown = shutdown;
	})(Session = exports.Session || (exports.Session = {}));


/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var iteration_1 = __webpack_require__(26);
	var searching_1 = __webpack_require__(27);
	var vector_1 = __webpack_require__(29);
	var signaling_1 = __webpack_require__(20);
	var kernel_1 = __webpack_require__(23);
	var utils = __webpack_require__(4);
	var validate = __webpack_require__(43);
	/**
	 * The url for the session service.
	 */
	var SESSION_SERVICE_URL = 'api/sessions';
	/**
	 * Session object for accessing the session REST api. The session
	 * should be used to start kernels and then shut them down -- for
	 * all other operations, the kernel object should be used.
	 */
	var DefaultSession = (function () {
	    /**
	     * Construct a new session.
	     */
	    function DefaultSession(options, id, kernel) {
	        this._id = '';
	        this._path = '';
	        this._ajaxSettings = '';
	        this._token = '';
	        this._kernel = null;
	        this._uuid = '';
	        this._baseUrl = '';
	        this._options = null;
	        this._updating = false;
	        this._id = id;
	        this._path = options.path;
	        this._baseUrl = options.baseUrl || utils.getBaseUrl();
	        this._uuid = utils.uuid();
	        this._ajaxSettings = JSON.stringify(utils.ajaxSettingsWithToken(options.ajaxSettings || {}, options.token));
	        this._token = options.token || utils.getConfigOption('token');
	        Private.runningSessions.pushBack(this);
	        this.setupKernel(kernel);
	        this._options = utils.copy(options);
	    }
	    Object.defineProperty(DefaultSession.prototype, "id", {
	        /**
	         * Get the session id.
	         */
	        get: function () {
	            return this._id;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultSession.prototype, "kernel", {
	        /**
	         * Get the session kernel object.
	         *
	         * #### Notes
	         * This is a read-only property, and can be altered by [changeKernel].
	         * Use the [statusChanged] and [unhandledMessage] signals on the session
	         * instead of the ones on the kernel.
	         */
	        get: function () {
	            return this._kernel;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultSession.prototype, "path", {
	        /**
	         * Get the session path.
	         */
	        get: function () {
	            return this._path;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultSession.prototype, "model", {
	        /**
	         * Get the model associated with the session.
	         */
	        get: function () {
	            return {
	                id: this.id,
	                kernel: this.kernel.model,
	                notebook: {
	                    path: this.path
	                }
	            };
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultSession.prototype, "status", {
	        /**
	         * The current status of the session.
	         *
	         * #### Notes
	         * This is a delegate to the kernel status.
	         */
	        get: function () {
	            return this._kernel ? this._kernel.status : 'dead';
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultSession.prototype, "baseUrl", {
	        /**
	         * Get the base url of the session.
	         */
	        get: function () {
	            return this._baseUrl;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultSession.prototype, "ajaxSettings", {
	        /**
	         * Get a copy of the default ajax settings for the session.
	         */
	        get: function () {
	            return JSON.parse(this._ajaxSettings);
	        },
	        /**
	         * Set the default ajax settings for the session.
	         */
	        set: function (value) {
	            this._ajaxSettings = JSON.stringify(value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultSession.prototype, "isDisposed", {
	        /**
	         * Test whether the session has been disposed.
	         */
	        get: function () {
	            return this._options === null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Clone the current session with a new clientId.
	     */
	    DefaultSession.prototype.clone = function () {
	        var _this = this;
	        var options = this._getKernelOptions();
	        return kernel_1.Kernel.connectTo(this.kernel.id, options).then(function (kernel) {
	            options = utils.copy(_this._options);
	            options.ajaxSettings = _this.ajaxSettings;
	            return new DefaultSession(options, _this._id, kernel);
	        });
	    };
	    /**
	     * Update the session based on a session model from the server.
	     */
	    DefaultSession.prototype.update = function (model) {
	        var _this = this;
	        // Avoid a race condition if we are waiting for a REST call return.
	        if (this._updating) {
	            return Promise.resolve(void 0);
	        }
	        if (this._path !== model.notebook.path) {
	            this.pathChanged.emit(model.notebook.path);
	        }
	        this._path = model.notebook.path;
	        if (this._kernel.isDisposed || model.kernel.id !== this._kernel.id) {
	            var options = this._getKernelOptions();
	            options.name = model.kernel.name;
	            return kernel_1.Kernel.connectTo(model.kernel.id, options).then(function (kernel) {
	                _this.setupKernel(kernel);
	                _this.kernelChanged.emit(kernel);
	            });
	        }
	        return Promise.resolve(void 0);
	    };
	    /**
	     * Dispose of the resources held by the session.
	     */
	    DefaultSession.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._options = null;
	        if (this._kernel) {
	            this._kernel.dispose();
	        }
	        Private.runningSessions.remove(this);
	        this._kernel = null;
	        signaling_1.clearSignalData(this);
	    };
	    /**
	     * Change the session path.
	     *
	     * @param path - The new session path.
	     *
	     * #### Notes
	     * This uses the Jupyter REST API, and the response is validated.
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     */
	    DefaultSession.prototype.rename = function (path) {
	        if (this.isDisposed) {
	            return Promise.reject(new Error('Session is disposed'));
	        }
	        var data = JSON.stringify({
	            notebook: { path: path }
	        });
	        return this._patch(data).then(function () { return void 0; });
	    };
	    /**
	     * Change the kernel.
	     *
	     * @params options - The name or id of the new kernel.
	     *
	     * #### Notes
	     * This shuts down the existing kernel and creates a new kernel,
	     * keeping the existing session ID and session path.
	     */
	    DefaultSession.prototype.changeKernel = function (options) {
	        var _this = this;
	        if (this.isDisposed) {
	            return Promise.reject(new Error('Session is disposed'));
	        }
	        this._kernel.dispose();
	        var data = JSON.stringify({ kernel: options });
	        return this._patch(data).then(function () {
	            return _this.kernel;
	        });
	    };
	    /**
	     * Kill the kernel and shutdown the session.
	     *
	     * @returns - The promise fulfilled on a valid response from the server.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/sessions), and validates the response.
	     * Emits a [sessionDied] signal on success.
	     */
	    DefaultSession.prototype.shutdown = function () {
	        if (this.isDisposed) {
	            return Promise.reject(new Error('Session is disposed'));
	        }
	        return Private.shutdownSession(this.id, this._baseUrl, this.ajaxSettings);
	    };
	    /**
	     * Handle connections to a kernel.
	     */
	    DefaultSession.prototype.setupKernel = function (kernel) {
	        this._kernel = kernel;
	        kernel.statusChanged.connect(this.onKernelStatus, this);
	        kernel.unhandledMessage.connect(this.onUnhandledMessage, this);
	        kernel.iopubMessage.connect(this.onIOPubMessage, this);
	    };
	    /**
	     * Handle to changes in the Kernel status.
	     */
	    DefaultSession.prototype.onKernelStatus = function (sender, state) {
	        this.statusChanged.emit(state);
	    };
	    /**
	     * Handle iopub kernel messages.
	     */
	    DefaultSession.prototype.onIOPubMessage = function (sender, msg) {
	        this.iopubMessage.emit(msg);
	    };
	    /**
	     * Handle unhandled kernel messages.
	     */
	    DefaultSession.prototype.onUnhandledMessage = function (sender, msg) {
	        this.unhandledMessage.emit(msg);
	    };
	    /**
	     * Get the options used to create a new kernel.
	     */
	    DefaultSession.prototype._getKernelOptions = function () {
	        return {
	            baseUrl: this._options.baseUrl,
	            wsUrl: this._options.wsUrl,
	            username: this.kernel.username,
	            ajaxSettings: this.ajaxSettings
	        };
	    };
	    /**
	     * Send a PATCH to the server, updating the session path or the kernel.
	     */
	    DefaultSession.prototype._patch = function (data) {
	        var _this = this;
	        var url = Private.getSessionUrl(this._baseUrl, this._id);
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'PATCH';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.data = data;
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.cache = false;
	        this._updating = true;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            _this._updating = false;
	            if (success.xhr.status !== 200) {
	                return utils.makeAjaxError(success);
	            }
	            var value = success.data;
	            try {
	                validate.validateModel(value);
	            }
	            catch (err) {
	                return utils.makeAjaxError(success, err.message);
	            }
	            return Private.updateFromServer(value);
	        }, function (error) {
	            _this._updating = false;
	            return Private.onSessionError(error);
	        });
	    };
	    return DefaultSession;
	}());
	exports.DefaultSession = DefaultSession;
	// Define the signals for the `DefaultSession` class.
	signaling_1.defineSignal(DefaultSession.prototype, 'terminated');
	signaling_1.defineSignal(DefaultSession.prototype, 'kernelChanged');
	signaling_1.defineSignal(DefaultSession.prototype, 'statusChanged');
	signaling_1.defineSignal(DefaultSession.prototype, 'iopubMessage');
	signaling_1.defineSignal(DefaultSession.prototype, 'unhandledMessage');
	signaling_1.defineSignal(DefaultSession.prototype, 'pathChanged');
	/**
	 * The namespace for `DefaultSession` statics.
	 */
	var DefaultSession;
	(function (DefaultSession) {
	    /**
	     * List the running sessions.
	     */
	    function listRunning(options) {
	        return Private.listRunning(options);
	    }
	    DefaultSession.listRunning = listRunning;
	    /**
	     * Start a new session.
	     */
	    function startNew(options) {
	        return Private.startNew(options);
	    }
	    DefaultSession.startNew = startNew;
	    /**
	     * Find a session by id.
	     */
	    function findById(id, options) {
	        return Private.findById(id, options);
	    }
	    DefaultSession.findById = findById;
	    /**
	     * Find a session by path.
	     */
	    function findByPath(path, options) {
	        return Private.findByPath(path, options);
	    }
	    DefaultSession.findByPath = findByPath;
	    /**
	     * Connect to a running session.
	     */
	    function connectTo(id, options) {
	        return Private.connectTo(id, options);
	    }
	    DefaultSession.connectTo = connectTo;
	    /**
	     * Shut down a session by id.
	     */
	    function shutdown(id, options) {
	        if (options === void 0) { options = {}; }
	        return Private.shutdown(id, options);
	    }
	    DefaultSession.shutdown = shutdown;
	})(DefaultSession = exports.DefaultSession || (exports.DefaultSession = {}));
	/**
	 * A namespace for session private data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * The running sessions.
	     */
	    Private.runningSessions = new vector_1.Vector();
	    /**
	     * List the running sessions.
	     */
	    function listRunning(options) {
	        if (options === void 0) { options = {}; }
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        var url = utils.urlPathJoin(baseUrl, SESSION_SERVICE_URL);
	        var ajaxSettings = utils.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                return utils.makeAjaxError(success);
	            }
	            var data = success.data;
	            if (!Array.isArray(success.data)) {
	                return utils.makeAjaxError(success, 'Invalid Session list');
	            }
	            for (var i = 0; i < data.length; i++) {
	                try {
	                    validate.validateModel(data[i]);
	                }
	                catch (err) {
	                    return utils.makeAjaxError(success, err.message);
	                }
	            }
	            return updateRunningSessions(data);
	        }, Private.onSessionError);
	    }
	    Private.listRunning = listRunning;
	    /**
	     * Start a new session.
	     */
	    function startNew(options) {
	        if (options.path === void 0) {
	            return Promise.reject(new Error('Must specify a path'));
	        }
	        return startSession(options).then(function (model) {
	            return createSession(model, options);
	        });
	    }
	    Private.startNew = startNew;
	    /**
	     * Find a session by id.
	     */
	    function findById(id, options) {
	        if (options === void 0) { options = {}; }
	        var session = searching_1.find(Private.runningSessions, function (value) { return value.id === id; });
	        if (session) {
	            return Promise.resolve(session.model);
	        }
	        return getSessionModel(id, options).catch(function () {
	            var msg = "No running session for id: " + id;
	            return typedThrow(msg);
	        });
	    }
	    Private.findById = findById;
	    /**
	     * Find a session by path.
	     */
	    function findByPath(path, options) {
	        if (options === void 0) { options = {}; }
	        var session = searching_1.find(Private.runningSessions, function (value) { return value.path === path; });
	        if (session) {
	            return Promise.resolve(session.model);
	        }
	        return listRunning(options).then(function (models) {
	            var model = searching_1.find(models, function (value) {
	                return value.notebook.path === path;
	            });
	            if (model) {
	                return model;
	            }
	            var msg = "No running session for path: " + path;
	            return typedThrow(msg);
	        });
	    }
	    Private.findByPath = findByPath;
	    /**
	     * Connect to a running session.
	     */
	    function connectTo(id, options) {
	        if (options === void 0) { options = {}; }
	        var session = searching_1.find(Private.runningSessions, function (value) { return value.id === id; });
	        if (session) {
	            return Promise.resolve(session.clone());
	        }
	        return getSessionModel(id, options).then(function (model) {
	            return createSession(model, options);
	        }).catch(function () {
	            var msg = "No running session with id: " + id;
	            return typedThrow(msg);
	        });
	    }
	    Private.connectTo = connectTo;
	    /**
	     * Shut down a session by id.
	     */
	    function shutdown(id, options) {
	        if (options === void 0) { options = {}; }
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        var ajaxSettings = utils.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	        return shutdownSession(id, baseUrl, ajaxSettings);
	    }
	    Private.shutdown = shutdown;
	    /**
	     * Create a new session, or return an existing session if a session if
	     * the session path already exists
	     */
	    function startSession(options) {
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        var url = utils.urlPathJoin(baseUrl, SESSION_SERVICE_URL);
	        var model = {
	            kernel: { name: options.kernelName, id: options.kernelId },
	            notebook: { path: options.path }
	        };
	        var ajaxSettings = utils.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	        ajaxSettings.method = 'POST';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.data = JSON.stringify(model);
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 201) {
	                return utils.makeAjaxError(success);
	            }
	            try {
	                validate.validateModel(success.data);
	            }
	            catch (err) {
	                return utils.makeAjaxError(success, err.message);
	            }
	            var data = success.data;
	            return updateFromServer(data);
	        }, onSessionError);
	    }
	    Private.startSession = startSession;
	    /**
	     * Create a Promise for a kernel object given a session model and options.
	     */
	    function createKernel(options) {
	        var kernelOptions = {
	            name: options.kernelName,
	            baseUrl: options.baseUrl || utils.getBaseUrl(),
	            wsUrl: options.wsUrl,
	            username: options.username,
	            clientId: options.clientId,
	            token: options.token,
	            ajaxSettings: options.ajaxSettings
	        };
	        return kernel_1.Kernel.connectTo(options.kernelId, kernelOptions);
	    }
	    /**
	     * Create a Session object.
	     *
	     * @returns - A promise that resolves with a started session.
	     */
	    function createSession(model, options) {
	        options.kernelName = model.kernel.name;
	        options.kernelId = model.kernel.id;
	        options.path = model.notebook.path;
	        return createKernel(options).then(function (kernel) {
	            return new DefaultSession(options, model.id, kernel);
	        }).catch(function (error) {
	            return typedThrow('Session failed to start: ' + error.message);
	        });
	    }
	    Private.createSession = createSession;
	    /**
	     * Get a full session model from the server by session id string.
	     */
	    function getSessionModel(id, options) {
	        options = options || {};
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        var url = getSessionUrl(baseUrl, id);
	        var ajaxSettings = utils.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                return utils.makeAjaxError(success);
	            }
	            var data = success.data;
	            try {
	                validate.validateModel(data);
	            }
	            catch (err) {
	                return utils.makeAjaxError(success, err.message);
	            }
	            return updateFromServer(data);
	        }, Private.onSessionError);
	    }
	    Private.getSessionModel = getSessionModel;
	    /**
	     * Update the running sessions based on new data from the server.
	     */
	    function updateRunningSessions(sessions) {
	        var promises = [];
	        iteration_1.each(Private.runningSessions, function (session) {
	            var updated = searching_1.find(sessions, function (sId) {
	                if (session.id === sId.id) {
	                    promises.push(session.update(sId));
	                    return true;
	                }
	            });
	            // If session is no longer running on disk, emit dead signal.
	            if (!updated && session.status !== 'dead') {
	                session.terminated.emit(void 0);
	            }
	        });
	        return Promise.all(promises).then(function () { return sessions; });
	    }
	    Private.updateRunningSessions = updateRunningSessions;
	    /**
	     * Update the running sessions given an updated session Id.
	     */
	    function updateFromServer(model) {
	        var promises = [];
	        iteration_1.each(Private.runningSessions, function (session) {
	            if (session.id === model.id) {
	                promises.push(session.update(model));
	            }
	        });
	        return Promise.all(promises).then(function () { return model; });
	    }
	    Private.updateFromServer = updateFromServer;
	    /**
	     * Shut down a session by id.
	     */
	    function shutdownSession(id, baseUrl, ajaxSettings) {
	        if (ajaxSettings === void 0) { ajaxSettings = {}; }
	        var url = getSessionUrl(baseUrl, id);
	        ajaxSettings.method = 'DELETE';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                return utils.makeAjaxError(success);
	            }
	            killSessions(id);
	        }, function (err) {
	            if (err.xhr.status === 404) {
	                var response = JSON.parse(err.xhr.responseText);
	                console.warn(response['message']);
	                killSessions(id);
	                return;
	            }
	            if (err.xhr.status === 410) {
	                err.throwError = 'The kernel was deleted but the session was not';
	            }
	            return onSessionError(err);
	        });
	    }
	    Private.shutdownSession = shutdownSession;
	    /**
	     * Kill the sessions by id.
	     */
	    function killSessions(id) {
	        iteration_1.each(iteration_1.toArray(Private.runningSessions), function (session) {
	            if (session.id === id) {
	                session.terminated.emit(void 0);
	                session.dispose();
	            }
	        });
	    }
	    /**
	     * Get a session url.
	     */
	    function getSessionUrl(baseUrl, id) {
	        return utils.urlPathJoin(baseUrl, SESSION_SERVICE_URL, id);
	    }
	    Private.getSessionUrl = getSessionUrl;
	    /**
	     * Handle an error on a session Ajax call.
	     */
	    function onSessionError(error) {
	        var text = (error.throwError ||
	            error.xhr.statusText ||
	            error.xhr.responseText);
	        var msg = "API request failed: " + text;
	        console.error(msg);
	        return Promise.reject(error);
	    }
	    Private.onSessionError = onSessionError;
	    /**
	     * Throw a typed error.
	     */
	    function typedThrow(msg) {
	        throw new Error(msg);
	    }
	    Private.typedThrow = typedThrow;
	})(Private || (Private = {}));


/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var validate_1 = __webpack_require__(35);
	/**
	 * Validate a property as being on an object, and optionally
	 * of a given type.
	 */
	function validateProperty(object, name, typeName) {
	    if (!object.hasOwnProperty(name)) {
	        throw Error("Missing property '" + name + "'");
	    }
	    if (typeName !== void 0) {
	        var valid = true;
	        var value = object[name];
	        switch (typeName) {
	            case 'array':
	                valid = Array.isArray(value);
	                break;
	            case 'object':
	                valid = typeof value !== 'undefined';
	                break;
	            default:
	                valid = typeof value === typeName;
	        }
	        if (!valid) {
	            throw new Error("Property '" + name + "' is not of type '" + typeName);
	        }
	    }
	}
	/**
	 * Validate an `Session.IModel` object.
	 */
	function validateModel(model) {
	    validateProperty(model, 'id', 'string');
	    validateProperty(model, 'notebook', 'object');
	    validateProperty(model, 'kernel', 'object');
	    validate_1.validateModel(model.kernel);
	    validateProperty(model.notebook, 'path', 'string');
	}
	exports.validateModel = validateModel;


/***/ },
/* 44 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(45));
	__export(__webpack_require__(46));


/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var iteration_1 = __webpack_require__(26);
	var json_1 = __webpack_require__(37);
	var searching_1 = __webpack_require__(27);
	var signaling_1 = __webpack_require__(20);
	var utils = __webpack_require__(4);
	var terminal_1 = __webpack_require__(46);
	/**
	 * A terminal session manager.
	 */
	var TerminalManager = (function () {
	    /**
	     * Construct a new terminal manager.
	     */
	    function TerminalManager(options) {
	        var _this = this;
	        if (options === void 0) { options = {}; }
	        this._baseUrl = '';
	        this._wsUrl = '';
	        this._ajaxSettings = '';
	        this._running = [];
	        this._isDisposed = false;
	        this._isReady = false;
	        this._refreshTimer = -1;
	        this._baseUrl = options.baseUrl || utils.getBaseUrl();
	        this._wsUrl = options.wsUrl || utils.getWsUrl(this._baseUrl);
	        this._ajaxSettings = JSON.stringify(options.ajaxSettings || {});
	        // Set up state handling if terminals are available.
	        if (terminal_1.TerminalSession.isAvailable()) {
	            // Initialize internal data.
	            this._readyPromise = this._refreshRunning();
	            // Set up polling.
	            this._refreshTimer = setInterval(function () {
	                _this._refreshRunning();
	            }, 10000);
	        }
	    }
	    Object.defineProperty(TerminalManager.prototype, "isDisposed", {
	        /**
	         * Test whether the terminal manager is disposed.
	         */
	        get: function () {
	            return this._isDisposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TerminalManager.prototype, "baseUrl", {
	        /**
	         * The base url of the manager.
	         */
	        get: function () {
	            return this._baseUrl;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TerminalManager.prototype, "wsUrl", {
	        /**
	         * The base ws url of the manager.
	         */
	        get: function () {
	            return this._wsUrl;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TerminalManager.prototype, "ajaxSettings", {
	        /**
	         * The default ajax settings for the manager.
	         */
	        get: function () {
	            return JSON.parse(this._ajaxSettings);
	        },
	        /**
	         * Set the default ajax settings for the manager.
	         */
	        set: function (value) {
	            this._ajaxSettings = JSON.stringify(value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TerminalManager.prototype, "isReady", {
	        /**
	         * Test whether the manger is ready.
	         */
	        get: function () {
	            return this._isReady;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources used by the manager.
	     */
	    TerminalManager.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._isDisposed = true;
	        clearInterval(this._refreshTimer);
	        signaling_1.clearSignalData(this);
	        this._running = [];
	    };
	    Object.defineProperty(TerminalManager.prototype, "ready", {
	        /**
	         * A promise that fulfills when the manager is ready.
	         */
	        get: function () {
	            return this._readyPromise || Promise.reject('Terminals unavailable');
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Whether the terminal service is available.
	     */
	    TerminalManager.prototype.isAvailable = function () {
	        return terminal_1.TerminalSession.isAvailable();
	    };
	    /**
	     * Create an iterator over the most recent running terminals.
	     *
	     * @returns A new iterator over the running terminals.
	     */
	    TerminalManager.prototype.running = function () {
	        return iteration_1.iter(this._running);
	    };
	    /**
	     * Create a new terminal session.
	     *
	     * @param ajaxSettings - The ajaxSettings to use, overrides manager
	     *   settings.
	     *
	     * @returns A promise that resolves with the terminal instance.
	     *
	     * #### Notes
	     * The baseUrl and wsUrl of the options will be forced
	     * to the ones used by the manager. The ajaxSettings of the manager
	     * will be used unless overridden.
	     */
	    TerminalManager.prototype.startNew = function (options) {
	        var _this = this;
	        return terminal_1.TerminalSession.startNew(this._getOptions(options)).then(function (session) {
	            _this._onStarted(session);
	            return session;
	        });
	    };
	    /*
	     * Connect to a running session.
	     *
	     * @param name - The name of the target session.
	     *
	     * @param ajaxSettings - The ajaxSettings to use, overrides manager
	     *   settings.
	     *
	     * @returns A promise that resolves with the new session instance.
	     *
	     * #### Notes
	     * The baseUrl and wsUrl of the options will be forced
	     * to the ones used by the manager. The ajaxSettings of the manager
	     * will be used unless overridden.
	     */
	    TerminalManager.prototype.connectTo = function (name, options) {
	        var _this = this;
	        return terminal_1.TerminalSession.connectTo(name, this._getOptions(options)).then(function (session) {
	            _this._onStarted(session);
	            return session;
	        });
	    };
	    /**
	     * Shut down a terminal session by name.
	     */
	    TerminalManager.prototype.shutdown = function (name) {
	        var _this = this;
	        return terminal_1.TerminalSession.shutdown(name, this._getOptions()).then(function () {
	            _this._onTerminated(name);
	        });
	    };
	    /**
	     * Force a refresh of the running sessions.
	     *
	     * @returns A promise that with the list of running sessions.
	     *
	     * #### Notes
	     * This is not typically meant to be called by the user, since the
	     * manager maintains its own internal state.
	     */
	    TerminalManager.prototype.refreshRunning = function () {
	        return this._refreshRunning();
	    };
	    /**
	     * Handle a session terminating.
	     */
	    TerminalManager.prototype._onTerminated = function (name) {
	        var index = searching_1.findIndex(this._running, function (value) { return value.name === name; });
	        if (index !== -1) {
	            this._running.splice(index, 1);
	            this.runningChanged.emit(this._running.slice());
	        }
	    };
	    /**
	     * Handle a session starting.
	     */
	    TerminalManager.prototype._onStarted = function (session) {
	        var _this = this;
	        var name = session.name;
	        var index = searching_1.findIndex(this._running, function (value) { return value.name === name; });
	        if (index === -1) {
	            this._running.push(session.model);
	            this.runningChanged.emit(this._running.slice());
	        }
	        session.terminated.connect(function () {
	            _this._onTerminated(name);
	        });
	    };
	    /**
	     * Refresh the running sessions.
	     */
	    TerminalManager.prototype._refreshRunning = function () {
	        var _this = this;
	        return terminal_1.TerminalSession.listRunning(this._getOptions({})).then(function (running) {
	            _this._isReady = true;
	            if (!json_1.deepEqual(running, _this._running)) {
	                _this._running = running.slice();
	                _this.runningChanged.emit(running);
	            }
	        });
	    };
	    /**
	     * Get a set of options to pass.
	     */
	    TerminalManager.prototype._getOptions = function (options) {
	        if (options === void 0) { options = {}; }
	        options.baseUrl = this.baseUrl;
	        options.wsUrl = this.wsUrl;
	        options.ajaxSettings = options.ajaxSettings || this.ajaxSettings;
	        return options;
	    };
	    return TerminalManager;
	}());
	exports.TerminalManager = TerminalManager;
	// Define the signals for the `TerminalManager` class.
	signaling_1.defineSignal(TerminalManager.prototype, 'runningChanged');


/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var default_1 = __webpack_require__(47);
	/**
	 * The namespace for ISession statics.
	 */
	var TerminalSession;
	(function (TerminalSession) {
	    /**
	     * Test whether the terminal service is available.
	     */
	    function isAvailable() {
	        return default_1.DefaultTerminalSession.isAvailable();
	    }
	    TerminalSession.isAvailable = isAvailable;
	    /**
	     * Start a new terminal session.
	     *
	     * @options - The session options to use.
	     *
	     * @returns A promise that resolves with the session instance.
	     */
	    function startNew(options) {
	        return default_1.DefaultTerminalSession.startNew(options);
	    }
	    TerminalSession.startNew = startNew;
	    /*
	     * Connect to a running session.
	     *
	     * @param name - The name of the target session.
	     *
	     * @param options - The session options to use.
	     *
	     * @returns A promise that resolves with the new session instance.
	     *
	     * #### Notes
	     * If the session was already started via `startNew`, the existing
	     * session object is used as the fulfillment value.
	     *
	     * Otherwise, if `options` are given, we attempt to connect to the existing
	     * session.
	     * The promise is fulfilled when the session is ready on the server,
	     * otherwise the promise is rejected.
	     *
	     * If the session was not already started and no `options` are given,
	     * the promise is rejected.
	     */
	    function connectTo(name, options) {
	        return default_1.DefaultTerminalSession.connectTo(name, options);
	    }
	    TerminalSession.connectTo = connectTo;
	    /**
	     * List the running terminal sessions.
	     *
	     * @param options - The session options to use.
	     *
	     * @returns A promise that resolves with the list of running session models.
	     */
	    function listRunning(options) {
	        return default_1.DefaultTerminalSession.listRunning(options);
	    }
	    TerminalSession.listRunning = listRunning;
	    /**
	     * Shut down a terminal session by name.
	     *
	     * @param name - The name of the target session.
	     *
	     * @param options - The session options to use.
	     *
	     * @returns A promise that resolves when the session is shut down.
	     */
	    function shutdown(name, options) {
	        return default_1.DefaultTerminalSession.shutdown(name, options);
	    }
	    TerminalSession.shutdown = shutdown;
	})(TerminalSession = exports.TerminalSession || (exports.TerminalSession = {}));


/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var iteration_1 = __webpack_require__(26);
	var signaling_1 = __webpack_require__(20);
	var utils = __webpack_require__(4);
	var terminal_1 = __webpack_require__(46);
	/**
	 * The url for the terminal service.
	 */
	var TERMINAL_SERVICE_URL = 'api/terminals';
	/**
	 * An implementation of a terminal interface.
	 */
	var DefaultTerminalSession = (function () {
	    /**
	     * Construct a new terminal session.
	     */
	    function DefaultTerminalSession(name, options) {
	        if (options === void 0) { options = {}; }
	        this._token = '';
	        this._ajaxSettings = '';
	        this._ws = null;
	        this._isDisposed = false;
	        this._isReady = false;
	        this._name = name;
	        this._baseUrl = options.baseUrl || utils.getBaseUrl();
	        this._token = options.token || utils.getConfigOption('token');
	        this._ajaxSettings = JSON.stringify(utils.ajaxSettingsWithToken(options.ajaxSettings, this._token));
	        this._wsUrl = options.wsUrl || utils.getWsUrl(this._baseUrl);
	        this._readyPromise = this._initializeSocket();
	    }
	    Object.defineProperty(DefaultTerminalSession.prototype, "name", {
	        /**
	         * Get the name of the terminal session.
	         */
	        get: function () {
	            return this._name;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultTerminalSession.prototype, "model", {
	        /**
	         * Get the model for the terminal session.
	         */
	        get: function () {
	            return { name: this._name };
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultTerminalSession.prototype, "baseUrl", {
	        /**
	         * The base url of the terminal.
	         */
	        get: function () {
	            return this._baseUrl;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultTerminalSession.prototype, "ajaxSettings", {
	        /**
	         * Get a copy of the default ajax settings for the terminal.
	         */
	        get: function () {
	            return JSON.parse(this._ajaxSettings);
	        },
	        /**
	         * Set the default ajax settings for the terminal.
	         */
	        set: function (value) {
	            this._ajaxSettings = JSON.stringify(value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultTerminalSession.prototype, "isReady", {
	        /**
	         * Test whether the session is ready.
	         */
	        get: function () {
	            return this._isReady;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultTerminalSession.prototype, "ready", {
	        /**
	         * A promise that fulfills when the manager is ready.
	         */
	        get: function () {
	            return this._readyPromise;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DefaultTerminalSession.prototype, "isDisposed", {
	        /**
	         * Test whether the session is disposed.
	         */
	        get: function () {
	            return this._isDisposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources held by the session.
	     */
	    DefaultTerminalSession.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._isDisposed = true;
	        if (this._ws) {
	            this._ws.close();
	            this._ws = null;
	        }
	        delete Private.running[this._url];
	        this._readyPromise = null;
	        signaling_1.clearSignalData(this);
	    };
	    /**
	     * Send a message to the terminal session.
	     */
	    DefaultTerminalSession.prototype.send = function (message) {
	        var _this = this;
	        var msg = [message.type];
	        msg.push.apply(msg, message.content);
	        var value = JSON.stringify(msg);
	        if (this._isReady) {
	            this._ws.send(value);
	            return;
	        }
	        this.ready.then(function () {
	            _this._ws.send(value);
	        });
	    };
	    /**
	     * Shut down the terminal session.
	     */
	    DefaultTerminalSession.prototype.shutdown = function () {
	        var options = {
	            baseUrl: this._baseUrl,
	            ajaxSettings: this.ajaxSettings
	        };
	        return DefaultTerminalSession.shutdown(this.name, options);
	    };
	    /**
	     * Connect to the websocket.
	     */
	    DefaultTerminalSession.prototype._initializeSocket = function () {
	        var _this = this;
	        var name = this._name;
	        this._url = Private.getTermUrl(this._baseUrl, this._name);
	        Private.running[this._url] = this;
	        var wsUrl = utils.urlPathJoin(this._wsUrl, "terminals/websocket/" + name);
	        if (this._token) {
	            wsUrl = wsUrl + ("?token=" + this._token);
	        }
	        this._ws = new WebSocket(wsUrl);
	        this._ws.onmessage = function (event) {
	            var data = JSON.parse(event.data);
	            _this.messageReceived.emit({
	                type: data[0],
	                content: data.slice(1)
	            });
	        };
	        return new Promise(function (resolve, reject) {
	            _this._ws.onopen = function (event) {
	                _this._isReady = true;
	                resolve(void 0);
	            };
	            _this._ws.onerror = function (event) {
	                reject(event);
	            };
	        });
	    };
	    return DefaultTerminalSession;
	}());
	exports.DefaultTerminalSession = DefaultTerminalSession;
	/**
	 * The static namespace for `DefaultTerminalSession`.
	 */
	var DefaultTerminalSession;
	(function (DefaultTerminalSession) {
	    /**
	     * Whether the terminal service is available.
	     */
	    function isAvailable() {
	        return utils.getConfigOption('terminalsAvailable') === 'True';
	    }
	    DefaultTerminalSession.isAvailable = isAvailable;
	    /**
	     * Start a new terminal session.
	     *
	     * @options - The session options to use.
	     *
	     * @returns A promise that resolves with the session instance.
	     */
	    function startNew(options) {
	        if (options === void 0) { options = {}; }
	        if (!terminal_1.TerminalSession.isAvailable()) {
	            return Private.unavailable();
	        }
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        var url = Private.getBaseUrl(baseUrl);
	        var ajaxSettings = utils.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	        ajaxSettings.method = 'POST';
	        ajaxSettings.dataType = 'json';
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                return utils.makeAjaxError(success);
	            }
	            var name = success.data.name;
	            return new DefaultTerminalSession(name, options);
	        });
	    }
	    DefaultTerminalSession.startNew = startNew;
	    /*
	     * Connect to a running session.
	     *
	     * @param name - The name of the target session.
	     *
	     * @param options - The session options to use.
	     *
	     * @returns A promise that resolves with the new session instance.
	     *
	     * #### Notes
	     * If the session was already started via `startNew`, the existing
	     * session object is used as the fulfillment value.
	     *
	     * Otherwise, if `options` are given, we attempt to connect to the existing
	     * session.
	     * The promise is fulfilled when the session is ready on the server,
	     * otherwise the promise is rejected.
	     *
	     * If the session was not already started and no `options` are given,
	     * the promise is rejected.
	     */
	    function connectTo(name, options) {
	        if (options === void 0) { options = {}; }
	        if (!terminal_1.TerminalSession.isAvailable()) {
	            return Private.unavailable();
	        }
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        var url = Private.getTermUrl(baseUrl, name);
	        if (url in Private.running) {
	            return Promise.resolve(Private.running[url]);
	        }
	        var session = new DefaultTerminalSession(name, options);
	        return Promise.resolve(session);
	    }
	    DefaultTerminalSession.connectTo = connectTo;
	    /**
	     * List the running terminal sessions.
	     *
	     * @param options - The session options to use.
	     *
	     * @returns A promise that resolves with the list of running session models.
	     */
	    function listRunning(options) {
	        if (options === void 0) { options = {}; }
	        if (!terminal_1.TerminalSession.isAvailable()) {
	            return Private.unavailable();
	        }
	        var url = Private.getBaseUrl(options.baseUrl);
	        var ajaxSettings = utils.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                return utils.makeAjaxError(success);
	            }
	            var data = success.data;
	            if (!Array.isArray(data)) {
	                return utils.makeAjaxError(success, 'Invalid terminal data');
	            }
	            // Update the local data store.
	            var urls = iteration_1.toArray(iteration_1.map(data, function (item) {
	                return utils.urlPathJoin(url, item.name);
	            }));
	            iteration_1.each(Object.keys(Private.running), function (runningUrl) {
	                if (urls.indexOf(runningUrl) === -1) {
	                    var session = Private.running[runningUrl];
	                    session.terminated.emit(void 0);
	                    session.dispose();
	                }
	            });
	            return data;
	        });
	    }
	    DefaultTerminalSession.listRunning = listRunning;
	    /**
	     * Shut down a terminal session by name.
	     *
	     * @param name - The name of the target session.
	     *
	     * @param options - The session options to use.
	     *
	     * @returns A promise that resolves when the session is shut down.
	     */
	    function shutdown(name, options) {
	        if (options === void 0) { options = {}; }
	        if (!terminal_1.TerminalSession.isAvailable()) {
	            return Private.unavailable();
	        }
	        var url = Private.getTermUrl(options.baseUrl, name);
	        var ajaxSettings = utils.ajaxSettingsWithToken(options.ajaxSettings, options.token);
	        ajaxSettings.method = 'DELETE';
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                return utils.makeAjaxError(success);
	            }
	            Private.killTerminal(url);
	        }, function (err) {
	            if (err.xhr.status === 404) {
	                var response = JSON.parse(err.xhr.responseText);
	                console.warn(response['message']);
	                Private.killTerminal(url);
	                return;
	            }
	            return Promise.reject(err);
	        });
	    }
	    DefaultTerminalSession.shutdown = shutdown;
	})(DefaultTerminalSession = exports.DefaultTerminalSession || (exports.DefaultTerminalSession = {}));
	// Define the signals for the `DefaultTerminalSession` class.
	signaling_1.defineSignal(DefaultTerminalSession.prototype, 'terminated');
	signaling_1.defineSignal(DefaultTerminalSession.prototype, 'messageReceived');
	/**
	 * A namespace for private data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A mapping of running terminals by url.
	     */
	    Private.running = Object.create(null);
	    /**
	     * A promise returned for when terminals are unavailable.
	     */
	    function unavailable() {
	        return Promise.reject('Terminals Unavailable');
	    }
	    Private.unavailable = unavailable;
	    /**
	     * Get the url for a terminal.
	     */
	    function getTermUrl(baseUrl, name) {
	        return utils.urlPathJoin(baseUrl, TERMINAL_SERVICE_URL, name);
	    }
	    Private.getTermUrl = getTermUrl;
	    /**
	     * Get the base url.
	     */
	    function getBaseUrl(baseUrl) {
	        return utils.urlPathJoin(baseUrl, TERMINAL_SERVICE_URL);
	    }
	    Private.getBaseUrl = getBaseUrl;
	    /**
	     * Kill a terminal by url.
	     */
	    function killTerminal(url) {
	        // Update the local data store.
	        if (Private.running[url]) {
	            var session = Private.running[url];
	            session.terminated.emit(void 0);
	            session.dispose();
	        }
	    }
	    Private.killTerminal = killTerminal;
	})(Private || (Private = {}));


/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	// Notebook format interfaces
	// https://nbformat.readthedocs.io/en/latest/format_description.html
	// https://github.com/jupyter/nbformat/blob/master/nbformat/v4/nbformat.v4.schema.json
	var json_1 = __webpack_require__(37);
	/**
	 * A namespace for nbformat interfaces.
	 */
	var nbformat;
	(function (nbformat) {
	    /**
	     * The major version of the notebook format.
	     */
	    nbformat.MAJOR_VERSION = 4;
	    /**
	     * The minor version of the notebook format.
	     */
	    nbformat.MINOR_VERSION = 1;
	    /**
	     * Validate a mime type/value pair.
	     *
	     * @param type - The mimetype name.
	     *
	     * @param value - The value associated with the type.
	     *
	     * @returns Whether the type/value pair are valid.
	     */
	    function validateMimeValue(type, value) {
	        // Check if "application/json" or "application/foo+json"
	        var jsonTest = /^application\/(.*?)+\+json$/;
	        var isJSONType = type === 'application/json' || jsonTest.test(type);
	        var isString = function (x) {
	            return Object.prototype.toString.call(x) === '[object String]';
	        };
	        // If it is an array, make sure if is not a JSON type and it is an
	        // array of strings.
	        if (Array.isArray(value)) {
	            if (isJSONType) {
	                return false;
	            }
	            var valid_1 = true;
	            value.forEach(function (v) {
	                if (!isString(v)) {
	                    valid_1 = false;
	                }
	            });
	            return valid_1;
	        }
	        // If it is a string, make sure we are not a JSON type.
	        if (isString(value)) {
	            return !isJSONType;
	        }
	        // It is not a string, make sure it is a JSON type.
	        if (!isJSONType) {
	            return false;
	        }
	        // It is a JSON type, make sure it is a valid JSON object.
	        return json_1.isObject(value);
	    }
	    nbformat.validateMimeValue = validateMimeValue;
	})(nbformat = exports.nbformat || (exports.nbformat = {}));


/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var commandregistry_1 = __webpack_require__(50);
	var keymap_1 = __webpack_require__(51);
	var widget_1 = __webpack_require__(55);
	/**
	 * An abstract base class for creating pluggable applications.
	 *
	 * #### Notes
	 * The `Application` class is useful when creating large, complex
	 * UI applications with the ability to be safely extended by third
	 * party code via plugins.
	 *
	 * Use of this class is optional. Applications with low to moderate
	 * complexity will have no need for the features this class provides.
	 */
	var Application = (function () {
	    /**
	     * Construct a new application.
	     */
	    function Application() {
	        this._started = false;
	        this._shell = null;
	        this._promise = null;
	        this._pluginMap = Private.createPluginMap();
	        this._serviceMap = Private.createServiceMap();
	        this._commands = new commandregistry_1.CommandRegistry();
	        this._keymap = new keymap_1.Keymap({ commands: this._commands });
	    }
	    Object.defineProperty(Application.prototype, "shell", {
	        /**
	         * The application shell widget.
	         *
	         * #### Notes
	         * The shell widget is the root "container" widget for the entire
	         * application. It will typically expose an API which allows the
	         * application plugins to insert content in a variety of places.
	         *
	         * This is created by a subclass in the `createShell()` method.
	         *
	         * This will be `null` until the application is started.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._shell;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Application.prototype, "commands", {
	        /**
	         * The application command registry.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._commands;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Application.prototype, "keymap", {
	        /**
	         * The application keymap.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._keymap;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Test whether a plugin is registered with the application.
	     *
	     * @param id - The id of the plugin of interest.
	     *
	     * @returns `true` if the plugin is registered, `false` otherwise.
	     */
	    Application.prototype.hasPlugin = function (id) {
	        return id in this._pluginMap;
	    };
	    /**
	     * List the IDs of the plugins registered with the application.
	     *
	     * @returns A new array of the registered plugin IDs.
	     */
	    Application.prototype.listPlugins = function () {
	        return Object.keys(this._pluginMap);
	    };
	    /**
	     * Register a plugin with the application.
	     *
	     * @param plugin - The plugin to register.
	     *
	     * #### Notes
	     * An error will be thrown if a plugin with the same id is already
	     * registered, or if the plugin has a circular dependency.
	     *
	     * If the plugin provides a service which has already been provided
	     * by another plugin, the new service will override the old service.
	     */
	    Application.prototype.registerPlugin = function (plugin) {
	        // Throw an error if the plugin id is already registered.
	        if (plugin.id in this._pluginMap) {
	            throw new Error("Plugin '" + plugin.id + "' is already registered.");
	        }
	        // Create the normalized plugin data.
	        var data = Private.createPluginData(plugin);
	        // Ensure the plugin does not cause a cyclic dependency.
	        Private.ensureNoCycle(data, this._pluginMap, this._serviceMap);
	        // Add the service token to the registry.
	        if (data.provides)
	            this._serviceMap.set(data.provides, data.id);
	        // Add the plugin to the registry.
	        this._pluginMap[data.id] = data;
	    };
	    /**
	     * Register multiple plugins with the application.
	     *
	     * @param plugins - The plugins to register.
	     *
	     * #### Notes
	     * This calls `registerPlugin()` for each of the given plugins.
	     */
	    Application.prototype.registerPlugins = function (plugins) {
	        for (var _i = 0, plugins_1 = plugins; _i < plugins_1.length; _i++) {
	            var plugin = plugins_1[_i];
	            this.registerPlugin(plugin);
	        }
	    };
	    /**
	     * Activate the plugin with the given id.
	     *
	     * @param id - The ID of the plugin of interest.
	     *
	     * @returns A promise which resolves when the plugin is activated
	     *   or rejects with an error if it cannot be activated.
	     */
	    Application.prototype.activatePlugin = function (id) {
	        var _this = this;
	        // Reject the promise if the plugin is not registered.
	        var data = this._pluginMap[id];
	        if (!data) {
	            return Promise.reject(new Error("Plugin '" + id + "' is not registered."));
	        }
	        // Resolve immediately if the plugin is already activated.
	        if (data.activated) {
	            return Promise.resolve(void 0);
	        }
	        // Return the pending resolver promise if it exists.
	        if (data.promise) {
	            return data.promise;
	        }
	        // Resolve the services required by the plugin.
	        var promises = data.requires.map(function (req) { return _this.resolveService(req); });
	        // Setup the resolver promise for the plugin.
	        data.promise = Promise.all(promises).then(function (deps) {
	            return data.activate.apply(void 0, [_this].concat(deps));
	        }).then(function (service) {
	            data.service = service;
	            data.activated = true;
	            data.promise = null;
	        }).catch(function (error) {
	            data.promise = null;
	            throw error;
	        });
	        // Return the pending resolver promise.
	        return data.promise;
	    };
	    /**
	     * Resolve a service of a given type.
	     *
	     * @param token - The token for the service type of interest.
	     *
	     * @returns A promise which resolves to an instance of the requested
	     *   service, or rejects with an error if it cannot be resolved.
	     *
	     * #### Notes
	     * Services are singletons. The same instance will be returned each
	     * time a given service token is resolved.
	     *
	     * If the plugin which provides the service has not been activated,
	     * resolving the service will automatically activate the plugin.
	     *
	     * User code will not typically call this method directly. Instead,
	     * the required services for the user's plugins will be resolved
	     * automatically when the plugin is activated.
	     */
	    Application.prototype.resolveService = function (token) {
	        // Reject the promise if there is no provider for the type.
	        var id = this._serviceMap.get(token);
	        if (!id) {
	            return Promise.reject(new Error("No provider for: " + token.name + "."));
	        }
	        // Resolve immediately if the plugin is already activated.
	        var data = this._pluginMap[id];
	        if (data.activated) {
	            return Promise.resolve(data.service);
	        }
	        // Otherwise, activate the plugin and wait on the results.
	        return this.activatePlugin(id).then(function () { return data.service; });
	    };
	    /**
	     * Start the application.
	     *
	     * @param options - The options for starting the application.
	     *
	     * @returns A promise which resolves when all bootstrapping work
	     *   is complete and the shell is mounted to the DOM, or rejects
	     *   with an error if the bootstrapping process fails.
	     *
	     * #### Notes
	     * This should be called once by the application creator after all
	     * initial plugins have been registered.
	     *
	     * Bootstrapping the application consists of the following steps:
	     * 1. Create the shell widget
	     * 2. Activate the startup plugins
	     * 3. Wait for those plugins to activate
	     * 4. Attach the shell widget to the DOM
	     * 5. Add the application event listeners
	     */
	    Application.prototype.start = function (options) {
	        var _this = this;
	        if (options === void 0) { options = {}; }
	        // Resolve immediately if the application is already started.
	        if (this._started) {
	            return Promise.resolve(void 0);
	        }
	        // Return the pending promise if it exists.
	        if (this._promise) {
	            return this._promise;
	        }
	        // Create the shell widget.
	        this._shell = this.createShell();
	        // Parse the host id for attaching the shell.
	        var hostID = options.hostID || '';
	        // Collect the ids of the startup plugins.
	        var startups = Private.collectStartupPlugins(this._pluginMap, options);
	        // Generate the activation promises.
	        var promises = startups.map(function (id) { return _this.activatePlugin(id); });
	        // Wait for the plugins to activate, then finalize startup.
	        this._promise = Promise.all(promises).then(function () {
	            _this._started = true;
	            _this._promise = null;
	            _this.attachShell(hostID);
	            _this.addEventListeners();
	        }).catch(function (error) {
	            _this._promise = null;
	            throw error;
	        });
	        // Return the pending bootstrapping promise.
	        return this._promise;
	    };
	    /**
	     * Handle the DOM events for the application.
	     *
	     * @param event - The DOM event sent to the application.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events registered for the application. It
	     * should not be called directly by user code.
	     */
	    Application.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'resize':
	                this.evtResize(event);
	                break;
	            case 'keydown':
	                this.evtKeydown(event);
	                break;
	        }
	    };
	    /**
	     * Attach the application shell to the DOM.
	     *
	     * @param id - The id of the host node for the shell, or `''`.
	     *
	     * #### Notes
	     * If the id is not provided, the document body will be the host.
	     *
	     * A subclass may reimplement this method as needed.
	     */
	    Application.prototype.attachShell = function (id) {
	        widget_1.Widget.attach(this.shell, document.getElementById(id) || document.body);
	    };
	    /**
	     * Add the application event listeners.
	     *
	     * #### Notes
	     * The default implementation of this method adds listeners for
	     * `'keydown'` and `'resize'` events.
	     *
	     * A subclass may reimplement this method as needed.
	     */
	    Application.prototype.addEventListeners = function () {
	        document.addEventListener('keydown', this);
	        window.addEventListener('resize', this);
	    };
	    /**
	     * A method invoked on a document `'keydown'` event.
	     *
	     * #### Notes
	     * The default implementation of this method invokes the key down
	     * processing method of the application keymap.
	     *
	     * A subclass may reimplement this method as needed.
	     */
	    Application.prototype.evtKeydown = function (event) {
	        this.keymap.processKeydownEvent(event);
	    };
	    /**
	     * A method invoked on a window `'resize'` event.
	     *
	     * #### Notes
	     * The default implementation of this method updates the shell.
	     *
	     * A subclass may reimplement this method as needed.
	     */
	    Application.prototype.evtResize = function (event) {
	        this.shell.update();
	    };
	    return Application;
	}());
	exports.Application = Application;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create a new plugin map.
	     */
	    function createPluginMap() {
	        return Object.create(null);
	    }
	    Private.createPluginMap = createPluginMap;
	    /**
	     * Create a new service map.
	     */
	    function createServiceMap() {
	        return new Map();
	    }
	    Private.createServiceMap = createServiceMap;
	    /**
	     * Create a normalized plugin data object for the given plugin.
	     */
	    function createPluginData(plugin) {
	        return {
	            id: plugin.id,
	            service: null,
	            promise: null,
	            activated: false,
	            activate: plugin.activate,
	            provides: plugin.provides || null,
	            autoStart: plugin.autoStart || false,
	            requires: plugin.requires ? plugin.requires.slice() : [],
	        };
	    }
	    Private.createPluginData = createPluginData;
	    /**
	     * Ensure no cycle is present in the plugin resolution graph.
	     *
	     * If a cycle is detected, an error will be thrown.
	     */
	    function ensureNoCycle(data, pluginMap, serviceMap) {
	        // Bail early if there cannot be a cycle.
	        if (!data.provides || data.requires.length === 0) {
	            return;
	        }
	        // Setup a stack to trace service resolution.
	        var trace = [data.id];
	        // Throw an exception if a cycle is present.
	        if (data.requires.some(visit)) {
	            throw new Error("Cycle detected: " + trace.join(' -> ') + ".");
	        }
	        function visit(token) {
	            if (token === data.provides) {
	                return true;
	            }
	            var id = serviceMap.get(token);
	            if (!id) {
	                return false;
	            }
	            var other = pluginMap[id];
	            if (other.requires.length === 0) {
	                return false;
	            }
	            trace.push(id);
	            if (other.requires.some(visit)) {
	                return true;
	            }
	            trace.pop();
	            return false;
	        }
	    }
	    Private.ensureNoCycle = ensureNoCycle;
	    /**
	     * Collect the IDs of the plugins to activate on startup.
	     */
	    function collectStartupPlugins(pluginMap, options) {
	        // Create a map to hold the plugin IDs.
	        var resultMap = Object.create(null);
	        // Collect the auto-start plugins.
	        for (var id in pluginMap) {
	            if (pluginMap[id].autoStart) {
	                resultMap[id] = true;
	            }
	        }
	        // Add the startup plugins.
	        if (options.startPlugins) {
	            for (var _i = 0, _a = options.startPlugins; _i < _a.length; _i++) {
	                var id = _a[_i];
	                resultMap[id] = true;
	            }
	        }
	        // Remove the ignored plugins.
	        if (options.ignorePlugins) {
	            for (var _b = 0, _c = options.ignorePlugins; _b < _c.length; _b++) {
	                var id = _c[_b];
	                delete resultMap[id];
	            }
	        }
	        // Return the final startup plugins.
	        return Object.keys(resultMap);
	    }
	    Private.collectStartupPlugins = collectStartupPlugins;
	})(Private || (Private = {}));


/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var disposable_1 = __webpack_require__(30);
	var signaling_1 = __webpack_require__(20);
	/**
	 * A registry which holds user-defined commands.
	 */
	var CommandRegistry = (function () {
	    /**
	     * Construct a new command registry.
	     */
	    function CommandRegistry() {
	        this._commands = Object.create(null);
	    }
	    /**
	     * List the ids of the registered commands.
	     *
	     * @returns A new array of the registered command ids.
	     */
	    CommandRegistry.prototype.listCommands = function () {
	        return Object.keys(this._commands);
	    };
	    /**
	     * Test whether a specific command is registered.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @returns `true` if the command is registered, `false` otherwise.
	     */
	    CommandRegistry.prototype.hasCommand = function (id) {
	        return id in this._commands;
	    };
	    /**
	     * Add a command to the registry.
	     *
	     * @param id - The unique id of the command.
	     *
	     * @param options - The options for the command.
	     *
	     * @returns A disposable which will unregister the command.
	     *
	     * @throws An error if the given `id` is already registered.
	     */
	    CommandRegistry.prototype.addCommand = function (id, options) {
	        var _this = this;
	        // Throw an error if the id is already registered.
	        if (id in this._commands) {
	            throw new Error("Command '" + id + "' already registered.");
	        }
	        // Create the command and add it to the registry.
	        this._commands[id] = Private.createCommand(options);
	        // Emit the `commandChanged` signal.
	        this.commandChanged.emit({ id: id, type: 'added' });
	        // Return a disposable which will remove the command.
	        return new disposable_1.DisposableDelegate(function () {
	            // Remove the command from the registry.
	            delete _this._commands[id];
	            // Emit the `commandChanged` signal.
	            _this.commandChanged.emit({ id: id, type: 'removed' });
	        });
	    };
	    /**
	     * Notify listeners that the state of a command has changed.
	     *
	     * @param id - The id of the command which has changed.
	     *
	     * #### Notes
	     * This method should be called by the command author whenever the
	     * application state changes such that the results of the command
	     * metadata functions may have changed.
	     *
	     * This will cause the `commandChanged` signal to be emitted.
	     *
	     * If the command is not registered, this is a no-op.
	     */
	    CommandRegistry.prototype.notifyCommandChanged = function (id) {
	        if (id in this._commands) {
	            this.commandChanged.emit({ id: id, type: 'changed' });
	        }
	    };
	    /**
	     * Get the display label for a specific command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns The display label for the command.
	     *
	     * #### Notes
	     * Returns an empty string if the command is not registered.
	     */
	    CommandRegistry.prototype.label = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.label.call(void 0, args) : '';
	    };
	    /**
	     * Get the mnemonic index for a specific command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns The mnemonic index for the command.
	     *
	     * #### Notes
	     * Returns `-1` if the command is not registered.
	     */
	    CommandRegistry.prototype.mnemonic = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.mnemonic.call(void 0, args) : -1;
	    };
	    /**
	     * Get the icon class for a specific command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns The icon class for the command.
	     *
	     * #### Notes
	     * Returns an empty string if the command is not registered.
	     */
	    CommandRegistry.prototype.icon = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.icon.call(void 0, args) : '';
	    };
	    /**
	     * Get the short form caption for a specific command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns The caption for the command.
	     *
	     * #### Notes
	     * Returns an empty string if the command is not registered.
	     */
	    CommandRegistry.prototype.caption = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.caption.call(void 0, args) : '';
	    };
	    /**
	     * Get the usage help text for a specific command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns The usage text for the command.
	     *
	     * #### Notes
	     * Returns an empty string if the command is not registered.
	     */
	    CommandRegistry.prototype.usage = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.usage.call(void 0, args) : '';
	    };
	    /**
	     * Get the extra class name for a specific command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns The class name for the command.
	     *
	     * #### Notes
	     * Returns an empty string if the command is not registered.
	     */
	    CommandRegistry.prototype.className = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.className.call(void 0, args) : '';
	    };
	    /**
	     * Test whether a specific command is enabled.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns `true` if the command is enabled, `false` otherwise.
	     *
	     * #### Notes
	     * Returns `false` if the command is not registered.
	     */
	    CommandRegistry.prototype.isEnabled = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.isEnabled.call(void 0, args) : false;
	    };
	    /**
	     * Test whether a specific command is toggled.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns `true` if the command is toggled, `false` otherwise.
	     *
	     * #### Notes
	     * Returns `false` if the command is not registered.
	     */
	    CommandRegistry.prototype.isToggled = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.isToggled.call(void 0, args) : false;
	    };
	    /**
	     * Test whether a specific command is visible.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns `true` if the command is visible, `false` otherwise.
	     *
	     * #### Notes
	     * Returns `false` if the command is not registered.
	     */
	    CommandRegistry.prototype.isVisible = function (id, args) {
	        var cmd = this._commands[id];
	        return cmd ? cmd.isVisible.call(void 0, args) : false;
	    };
	    /**
	     * Execute a specific command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns A promise which resolves to the result of the command.
	     *
	     * #### Notes
	     * The promise will reject if the command is not registered.
	     */
	    CommandRegistry.prototype.execute = function (id, args) {
	        // Reject if the command is not registered.
	        var cmd = this._commands[id];
	        if (!cmd) {
	            return Promise.reject(new Error("Command '" + id + "' not registered."));
	        }
	        // Execute the command and reject if an exception is thrown.
	        var result;
	        try {
	            result = cmd.execute.call(void 0, args);
	        }
	        catch (err) {
	            result = Promise.reject(err);
	        }
	        // Create the return promise which resolves the result.
	        var promise = Promise.resolve(result);
	        // Emit the command executed signal.
	        this.commandExecuted.emit({ id: id, args: args });
	        // Return the result promise to the caller.
	        return promise;
	    };
	    return CommandRegistry;
	}());
	exports.CommandRegistry = CommandRegistry;
	// Define the signals for the `CommandRegistry` class.
	signaling_1.defineSignal(CommandRegistry.prototype, 'commandChanged');
	signaling_1.defineSignal(CommandRegistry.prototype, 'commandExecuted');
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create a normalized command object from options.
	     */
	    function createCommand(options) {
	        return {
	            execute: options.execute,
	            label: asStringFunc(options.label),
	            mnemonic: asNumberFunc(options.mnemonic),
	            icon: asStringFunc(options.icon),
	            caption: asStringFunc(options.caption),
	            usage: asStringFunc(options.usage),
	            className: asStringFunc(options.className),
	            isEnabled: options.isEnabled || trueFunc,
	            isToggled: options.isToggled || falseFunc,
	            isVisible: options.isVisible || trueFunc
	        };
	    }
	    Private.createCommand = createCommand;
	    /**
	     * A singleton empty string function.
	     */
	    var emptyStringFunc = function (args) { return ''; };
	    /**
	     * A singleton `-1` number function
	     */
	    var negativeOneFunc = function (args) { return -1; };
	    /**
	     * A singleton true boolean function.
	     */
	    var trueFunc = function (args) { return true; };
	    /**
	     * A singleton false boolean function.
	     */
	    var falseFunc = function (args) { return false; };
	    /**
	     * Coerce a value to a string function.
	     */
	    function asStringFunc(value) {
	        if (value === void 0) {
	            return emptyStringFunc;
	        }
	        if (typeof value === 'function') {
	            return value;
	        }
	        return function (args) { return value; };
	    }
	    /**
	     * Coerce a value to a number function.
	     */
	    function asNumberFunc(value) {
	        if (value === void 0) {
	            return negativeOneFunc;
	        }
	        if (typeof value === 'function') {
	            return value;
	        }
	        return function (args) { return value; };
	    }
	})(Private || (Private = {}));


/***/ },
/* 51 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var json_1 = __webpack_require__(37);
	var searching_1 = __webpack_require__(27);
	var vector_1 = __webpack_require__(29);
	var disposable_1 = __webpack_require__(30);
	var signaling_1 = __webpack_require__(20);
	var platform_1 = __webpack_require__(52);
	var selector_1 = __webpack_require__(53);
	var keyboard_1 = __webpack_require__(54);
	/**
	 * The timeout in ms for triggering a chord.
	 */
	var CHORD_TIMEOUT = 1000;
	/**
	 * A class which manages a collection of key bindings.
	 */
	var Keymap = (function () {
	    /**
	     * Construct a new keymap.
	     *
	     * @param options - The options for initializing the keymap.
	     */
	    function Keymap(options) {
	        this._timerID = 0;
	        this._replaying = false;
	        this._keys = [];
	        this._events = [];
	        this._exact = null;
	        this._bindings = new vector_1.Vector();
	        this._commands = options.commands;
	        this._layout = options.layout || keyboard_1.EN_US;
	    }
	    Object.defineProperty(Keymap.prototype, "commands", {
	        /**
	         * The command registry used by the keymap.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._commands;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Keymap.prototype, "layout", {
	        /**
	         * Get the keyboard layout used by the keymap.
	         *
	         * #### Notes
	         * The default is a US English layout.
	         */
	        get: function () {
	            return this._layout;
	        },
	        /**
	         * Set the keyboard layout used by the keymap.
	         *
	         * #### Notes
	         * A keymap requires a keyboard layout, so setting this value to
	         * `null` will revert the layout to the default US English layout.
	         */
	        set: function (value) {
	            var oldValue = this._layout;
	            var newValue = value || keyboard_1.EN_US;
	            if (oldValue === newValue) {
	                return;
	            }
	            this._layout = newValue;
	            this.layoutChanged.emit({ oldValue: oldValue, newValue: newValue });
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Keymap.prototype, "bindings", {
	        /**
	         * A read-only sequence of the key bindings in the keymap.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._bindings;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Find a key binding which matches the given command and args.
	     *
	     * @param command - The id of the command of interest.
	     *
	     * @param args - The arguments for the command.
	     *
	     * @returns The most recently added key binding which matches the
	     *   specified command and args, or `null` if no match is found.
	     *
	     * #### Notes
	     * This is a convenience method which searches through the public
	     * sequence of key `bindings`. If custom search behavior is needed,
	     * user code may search that sequence manually.
	     */
	    Keymap.prototype.findBinding = function (command, args) {
	        var i = searching_1.findLastIndex(this._bindings, function (kb) {
	            return kb.command === command && json_1.deepEqual(kb.args, args);
	        });
	        return i !== -1 ? this._bindings.at(i) : null;
	    };
	    /**
	     * Add a key binding to the keymap.
	     *
	     * @param options - The options for creating the key binding.
	     *
	     * @returns A disposable which removes the added key binding.
	     *
	     * #### Notes
	     * If multiple key bindings are registered for the same sequence, the
	     * binding with the highest selector specificity is executed first. A
	     * tie is broken by using the most recently added key binding.
	     *
	     * Ambiguous key bindings are resolved with a timeout. As an example,
	     * suppose two key bindings are registered: one with the key sequence
	     * `['Ctrl D']`, and another with `['Ctrl D', 'Ctrl W']`. If the user
	     * presses `Ctrl D`, the first binding cannot be immediately executed
	     * since the user may intend to complete the chord with `Ctrl W`. For
	     * such cases, a timer is used to allow the chord to be completed. If
	     * the chord is not completed before the timeout, the first binding
	     * is executed.
	     */
	    Keymap.prototype.addBinding = function (options) {
	        var _this = this;
	        // Create the binding for the given options.
	        var binding = Private.createBinding(options);
	        // Add the key binding to the internal vector.
	        this._bindings.pushBack(binding);
	        // Emit the `bindingChanged` signal.
	        this.bindingChanged.emit({ binding: binding, type: 'added' });
	        // Return a disposable which will remove the binding.
	        return new disposable_1.DisposableDelegate(function () {
	            // Remove the binding from the vector.
	            _this._bindings.remove(binding);
	            // Emit the `bindingChanged` signal.
	            _this.bindingChanged.emit({ binding: binding, type: 'removed' });
	        });
	    };
	    /**
	     * Process a `'keydown'` event and invoke a matching key binding.
	     *
	     * @param event - The event object for a `'keydown'` event.
	     *
	     * #### Notes
	     * This should be called in response to a `'keydown'` event in order
	     * to invoke the command for the best matching key binding.
	     *
	     * The keymap **does not** install its own key event listeners. This
	     * allows the application full control over the nodes for which the
	     * keymap processes `'keydown'` events.
	     */
	    Keymap.prototype.processKeydownEvent = function (event) {
	        // Bail immediately if playing back keystrokes.
	        if (this._replaying) {
	            return;
	        }
	        // Get the normalized keystroke for the event.
	        var keystroke = Keymap.keystrokeForKeydownEvent(event, this._layout);
	        // If the keystroke is not valid for the keyboard layout, replay
	        // any suppressed events and clear the pending state.
	        if (!keystroke) {
	            this._replayEvents();
	            this._clearPendingState();
	            return;
	        }
	        // Add the keystroke to the current key sequence.
	        this._keys.push(keystroke);
	        // Find the exact and partial matches for the key sequence.
	        var _a = Private.match(this._bindings, this._keys, event), exact = _a.exact, partial = _a.partial;
	        // If there is no exact match and no partial match, replay
	        // any suppressed events and clear the pending state.
	        if (!exact && !partial) {
	            this._replayEvents();
	            this._clearPendingState();
	            return;
	        }
	        // Stop propagation of the event. If there is only a partial match,
	        // the event will be replayed if a final exact match never occurs.
	        event.preventDefault();
	        event.stopPropagation();
	        // If there is an exact match but no partial match, the exact match
	        // can be dispatched immediately. The pending state is cleared so
	        // the next key press starts from the default state.
	        if (!partial) {
	            this._execute(exact);
	            this._clearPendingState();
	            return;
	        }
	        // If there is both an exact match and a partial match, the exact
	        // match is stored for future dispatch in case the timer expires
	        // before a more specific match is triggered.
	        if (exact)
	            this._exact = exact;
	        // Store the event for possible playback in the future.
	        this._events.push(event);
	        // (Re)start the timer to dispatch the most recent exact match
	        // in case the partial match fails to result in an exact match.
	        this._startTimer();
	    };
	    /**
	     * Start or restart the pending timeout.
	     */
	    Keymap.prototype._startTimer = function () {
	        var _this = this;
	        this._clearTimer();
	        this._timerID = setTimeout(function () {
	            _this._onPendingTimeout();
	        }, CHORD_TIMEOUT);
	    };
	    /**
	     * Clear the pending timeout.
	     */
	    Keymap.prototype._clearTimer = function () {
	        if (this._timerID !== 0) {
	            clearTimeout(this._timerID);
	            this._timerID = 0;
	        }
	    };
	    /**
	     * Clear the internal pending state.
	     */
	    Keymap.prototype._clearPendingState = function () {
	        this._clearTimer();
	        this._exact = null;
	        this._keys.length = 0;
	        this._events.length = 0;
	    };
	    /**
	     * Replay the events which were suppressed.
	     */
	    Keymap.prototype._replayEvents = function () {
	        if (this._events.length === 0) {
	            return;
	        }
	        this._replaying = true;
	        this._events.forEach(Private.replayEvent);
	        this._replaying = false;
	    };
	    /**
	     * Execute the command for the given key binding.
	     *
	     * If the command is disabled, a message will be logged.
	     */
	    Keymap.prototype._execute = function (binding) {
	        var command = binding.command, args = binding.args;
	        if (this._commands.isEnabled(command, args)) {
	            this._commands.execute(command, args);
	        }
	        else {
	            // TODO - right way to handle disabled command?
	            var formatted = binding.keys.map(Keymap.formatKeystroke).join(' ');
	            console.log("Command '" + command + "' is disabled (" + formatted + ").");
	        }
	    };
	    /**
	     * Handle the partial match timeout.
	     */
	    Keymap.prototype._onPendingTimeout = function () {
	        this._timerID = 0;
	        if (this._exact) {
	            this._execute(this._exact);
	        }
	        else {
	            this._replayEvents();
	        }
	        this._clearPendingState();
	    };
	    return Keymap;
	}());
	exports.Keymap = Keymap;
	// Define the signals for the `Keymap` class.
	signaling_1.defineSignal(Keymap.prototype, 'bindingChanged');
	signaling_1.defineSignal(Keymap.prototype, 'layoutChanged');
	/**
	 * The namespace for the `Keymap` class statics.
	 */
	var Keymap;
	(function (Keymap) {
	    /**
	     * Parse a keystroke into its constituent components.
	     *
	     * @param keystroke - The keystroke of interest.
	     *
	     * @returns The parsed components of the keystroke.
	     *
	     * #### Notes
	     * The keystroke should be of the form:
	     *   `[<modifier 1> [<modifier 2> [<modifier N> ]]]<primary key>`
	     *
	     * The supported modifiers are: `Accel`, `Alt`, `Cmd`, `Ctrl`, and
	     * `Shift`. The `Accel` modifier is translated to `Cmd` on Mac and
	     * `Ctrl` on all other platforms.
	     *
	     * The parsing is tolerant and will not throw exceptions. Notably:
	     *   - Duplicate modifiers are ignored.
	     *   - Extra primary keys are ignored.
	     *   - The order of modifiers and primary key is irrelevant.
	     *   - The keystroke parts should be separated by whitespace.
	     *   - The keystroke is case sensitive.
	     */
	    function parseKeystroke(keystroke) {
	        var key = '';
	        var alt = false;
	        var cmd = false;
	        var ctrl = false;
	        var shift = false;
	        for (var _i = 0, _a = keystroke.split(/\s+/); _i < _a.length; _i++) {
	            var token = _a[_i];
	            if (token === 'Accel') {
	                if (platform_1.IS_MAC) {
	                    cmd = true;
	                }
	                else {
	                    ctrl = true;
	                }
	            }
	            else if (token === 'Alt') {
	                alt = true;
	            }
	            else if (token === 'Cmd') {
	                cmd = true;
	            }
	            else if (token === 'Ctrl') {
	                ctrl = true;
	            }
	            else if (token === 'Shift') {
	                shift = true;
	            }
	            else if (token.length > 0) {
	                key = token;
	            }
	        }
	        return { cmd: cmd, ctrl: ctrl, alt: alt, shift: shift, key: key };
	    }
	    Keymap.parseKeystroke = parseKeystroke;
	    /**
	     * Normalize a keystroke into a canonical representation.
	     *
	     * @param keystroke - The keystroke of interest.
	     *
	     * @returns The normalized representation of the keystroke.
	     *
	     * #### Notes
	     * This normalizes the keystroke by removing duplicate modifiers and
	     * extra primary keys, and assembling the parts in a canonical order.
	     *
	     * The `Cmd` modifier is ignored on non-Mac platforms.
	     */
	    function normalizeKeystroke(keystroke) {
	        var mods = '';
	        var parts = parseKeystroke(keystroke);
	        if (parts.ctrl) {
	            mods += 'Ctrl ';
	        }
	        if (parts.alt) {
	            mods += 'Alt ';
	        }
	        if (parts.shift) {
	            mods += 'Shift ';
	        }
	        if (parts.cmd && platform_1.IS_MAC) {
	            mods += 'Cmd ';
	        }
	        return mods + parts.key;
	    }
	    Keymap.normalizeKeystroke = normalizeKeystroke;
	    /**
	     * Format a keystroke for display on the local system.
	     *
	     * @param keystroke - The keystroke of interest.
	     *
	     * @returns The keystroke formatted for display on the local system.
	     *
	     * #### Notes
	     * On Mac, this replaces the modifiers with the Mac-specific unicode
	     * characters. On other systems, this joins the modifiers with `+`.
	     */
	    function formatKeystroke(keystroke) {
	        var mods = '';
	        var parts = parseKeystroke(keystroke);
	        if (platform_1.IS_MAC) {
	            if (parts.ctrl) {
	                mods += '\u2303';
	            }
	            if (parts.alt) {
	                mods += '\u2325';
	            }
	            if (parts.shift) {
	                mods += '\u21E7';
	            }
	            if (parts.cmd) {
	                mods += '\u2318';
	            }
	        }
	        else {
	            if (parts.ctrl) {
	                mods += 'Ctrl+';
	            }
	            if (parts.alt) {
	                mods += 'Alt+';
	            }
	            if (parts.shift) {
	                mods += 'Shift+';
	            }
	        }
	        return mods + parts.key;
	    }
	    Keymap.formatKeystroke = formatKeystroke;
	    /**
	     * Create a normalized keystroke for a `'keydown'` event.
	     *
	     * @param event - The event object for a `'keydown'` event.
	     *
	     * @param layout - The keyboard layout for looking up the primary key.
	     *
	     * @returns A normalized keystroke, or an empty string if the event
	     *   does not represent a valid keystroke for the given layout.
	     */
	    function keystrokeForKeydownEvent(event, layout) {
	        var key = layout.keyForKeydownEvent(event);
	        if (!key) {
	            return '';
	        }
	        var mods = '';
	        if (event.ctrlKey) {
	            mods += 'Ctrl ';
	        }
	        if (event.altKey) {
	            mods += 'Alt ';
	        }
	        if (event.shiftKey) {
	            mods += 'Shift ';
	        }
	        if (event.metaKey && platform_1.IS_MAC) {
	            mods += 'Cmd ';
	        }
	        return mods + key;
	    }
	    Keymap.keystrokeForKeydownEvent = keystrokeForKeydownEvent;
	})(Keymap = exports.Keymap || (exports.Keymap = {}));
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create a binding object from binding options.
	     */
	    function createBinding(options) {
	        return new KeyBinding(options);
	    }
	    Private.createBinding = createBinding;
	    /**
	     * Find the bindings which match a key sequence.
	     *
	     * This returns a match result which contains the best exact matching
	     * binding, and a flag which indicates if there are partial matches.
	     */
	    function match(bindings, keys, event) {
	        // Whether a partial match has been found.
	        var partial = false;
	        // The current best exact match.
	        var exact = null;
	        // The match distance for the exact match.
	        var distance = Infinity;
	        // The specificity for the exact match.
	        var specificity = 0;
	        // Iterate over the bindings and search for the best match.
	        for (var i = 0, n = bindings.length; i < n; ++i) {
	            // Lookup the current binding.
	            var binding = bindings.at(i);
	            // Check whether the key binding sequence is a match.
	            var sqm = matchSequence(binding.keys, keys);
	            // If there is no match, the binding is ignored.
	            if (sqm === 0 /* None */) {
	                continue;
	            }
	            // If it is a partial match and no other partial match has been
	            // found, ensure the selector matches and set the partial flag.
	            if (sqm === 2 /* Partial */) {
	                if (!partial && targetDistance(binding.selector, event) !== -1) {
	                    partial = true;
	                }
	                continue;
	            }
	            // Ignore the match if the selector doesn't match, or if the
	            // matched node is farther away than the current best match.
	            var td = targetDistance(binding.selector, event);
	            if (td === -1 || td > distance) {
	                continue;
	            }
	            // Get the specificity for the selector.
	            var sp = selector_1.calculateSpecificity(binding.selector);
	            // Update the best match if this match is stronger.
	            if (exact === null || td < distance || sp >= specificity) {
	                exact = binding;
	                distance = td;
	                specificity = sp;
	            }
	        }
	        // Return the match result.
	        return { exact: exact, partial: partial };
	    }
	    Private.match = match;
	    /**
	     * Replay a keyboard event.
	     *
	     * This synthetically dispatches a clone of the keyboard event.
	     */
	    function replayEvent(event) {
	        event.target.dispatchEvent(cloneKeyboardEvent(event));
	    }
	    Private.replayEvent = replayEvent;
	    /**
	     * A concrete implementation of `Keymap.IBinding`.
	     */
	    var KeyBinding = (function () {
	        /**
	         * Construct a new binding.
	         */
	        function KeyBinding(options) {
	            this._keys = normalizeKeys(options);
	            this._selector = normalizeSelector(options);
	            this._command = options.command;
	            this._args = options.args || null;
	        }
	        Object.defineProperty(KeyBinding.prototype, "keys", {
	            /**
	             * The key sequence for the key binding.
	             */
	            get: function () {
	                return this._keys;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(KeyBinding.prototype, "selector", {
	            /**
	             * The CSS selector for the key binding.
	             */
	            get: function () {
	                return this._selector;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(KeyBinding.prototype, "command", {
	            /**
	             * The command to execute when the key binding is matched.
	             */
	            get: function () {
	                return this._command;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        Object.defineProperty(KeyBinding.prototype, "args", {
	            /**
	             * The arguments for the command.
	             */
	            get: function () {
	                return this._args;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        return KeyBinding;
	    }());
	    /**
	     * Get the platform-specific normalized keys for an options object.
	     *
	     * The normalized keys are frozen to prevent further modification.
	     */
	    function normalizeKeys(options) {
	        var keys;
	        if (platform_1.IS_WIN) {
	            keys = options.winKeys || options.keys;
	        }
	        else if (platform_1.IS_MAC) {
	            keys = options.macKeys || options.keys;
	        }
	        else {
	            keys = options.linuxKeys || options.keys;
	        }
	        return Object.freeze(keys.map(Keymap.normalizeKeystroke));
	    }
	    /**
	     * Normalize the selector for an options object.
	     *
	     * This returns the validated first clause of the selector.
	     */
	    function normalizeSelector(options) {
	        return selector_1.validateSelector(options.selector.split(',', 1)[0]);
	    }
	    ;
	    /**
	     * Test whether a binding sequence matches a key sequence.
	     *
	     * Returns a `SequenceMatch` value indicating the type of match.
	     */
	    function matchSequence(bindKeys, userKeys) {
	        if (bindKeys.length < userKeys.length) {
	            return 0 /* None */;
	        }
	        for (var i = 0, n = userKeys.length; i < n; ++i) {
	            if (bindKeys[i] !== userKeys[i]) {
	                return 0 /* None */;
	            }
	        }
	        if (bindKeys.length > userKeys.length) {
	            return 2 /* Partial */;
	        }
	        return 1 /* Exact */;
	    }
	    /**
	     * Find the distance from the target node to the first matching node.
	     *
	     * This traverses the event path from `target` to `currentTarget` and
	     * computes the distance from `target` to the first node which matches
	     * the CSS selector. If no match is found, `-1` is returned.
	     */
	    function targetDistance(selector, event) {
	        var distance = 0;
	        var target = event.target;
	        var current = event.currentTarget;
	        for (; target !== null; target = target.parentElement, ++distance) {
	            if (selector_1.matchesSelector(target, selector)) {
	                return distance;
	            }
	            if (target === current) {
	                return -1;
	            }
	        }
	        return -1;
	    }
	    /**
	     * Clone a keyboard event.
	     */
	    function cloneKeyboardEvent(event) {
	        // A custom event is required because Chrome nulls out the
	        // `keyCode` field in user-generated `KeyboardEvent` types.
	        var clone = document.createEvent('Event');
	        var bubbles = event.bubbles || true;
	        var cancelable = event.cancelable || true;
	        clone.initEvent(event.type || 'keydown', bubbles, cancelable);
	        clone.key = event.key || '';
	        clone.keyCode = event.keyCode || 0;
	        clone.which = event.keyCode || 0;
	        clone.ctrlKey = event.ctrlKey || false;
	        clone.altKey = event.altKey || false;
	        clone.shiftKey = event.shiftKey || false;
	        clone.metaKey = event.metaKey || false;
	        clone.view = event.view || window;
	        return clone;
	    }
	})(Private || (Private = {}));


/***/ },
/* 52 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * A boolean indicating whether the platform is Mac.
	 */
	exports.IS_MAC = !!navigator.platform.match(/Mac/i);
	/**
	 * A boolean indicating whether the platform is Windows.
	 */
	exports.IS_WIN = !!navigator.platform.match(/Win/i);
	/**
	 * A flag indicating whether the browser is IE.
	 */
	exports.IS_IE = /Trident/.test(navigator.userAgent);
	/**
	 * A flag indicating whether the browser is Edge.
	 */
	exports.IS_EDGE = /Edge/.test(navigator.userAgent);


/***/ },
/* 53 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * Calculate the specificity of a single CSS selector.
	 *
	 * @param selector - The CSS selector of interest.
	 *
	 * @returns The specificity of the selector.
	 *
	 * #### Undefined Behavior
	 * The selector is invalid.
	 *
	 * #### Notes
	 * This is based on https://www.w3.org/TR/css3-selectors/#specificity
	 *
	 * A larger number represents a more specific selector.
	 *
	 * The smallest possible specificity is `0`.
	 *
	 * The result is represented as a hex number `0x<aa><bb><cc>` where
	 * each component is the count of the respective selector clause.
	 *
	 * If the selector contains commas, only the first clause is used.
	 *
	 * The computed result is cached, so subsequent calculations for the
	 * same selector are extremely fast.
	 */
	function calculateSpecificity(selector) {
	    var result = Private.specificityCache[selector];
	    if (result === void 0) {
	        result = Private.calculateSingle(selector);
	        Private.specificityCache[selector] = result;
	    }
	    return result;
	}
	exports.calculateSpecificity = calculateSpecificity;
	/**
	 * Test whether a selector is a valid CSS selector.
	 *
	 * @param selector - The CSS selector of interest.
	 *
	 * @returns `true` if the selector is valid, `false` otherwise.
	 *
	 * #### Notes
	 * The computed result is cached, so subsequent tests for the same
	 * selector are extremely fast.
	 */
	function isValidSelector(selector) {
	    var result = Private.validityCache[selector];
	    if (result === void 0) {
	        try {
	            Private.testElem.querySelector(selector);
	            result = true;
	        }
	        catch (err) {
	            result = false;
	        }
	        Private.validityCache[selector] = result;
	    }
	    return result;
	}
	exports.isValidSelector = isValidSelector;
	/**
	 * Validate a CSS selector.
	 *
	 * @param selector - The CSS selector of interest.
	 *
	 * @returns The provided selector.
	 *
	 * @throws An error if the selector is invalid.
	 */
	function validateSelector(selector) {
	    if (!isValidSelector(selector)) {
	        throw new Error("Invalid selector: " + selector);
	    }
	    return selector;
	}
	exports.validateSelector = validateSelector;
	/**
	 * Test whether an element matches a CSS selector.
	 *
	 * @param elem - The element of interest.
	 *
	 * @param selector - The valid CSS selector of interest.
	 *
	 * @returns `true` if the element is a match, `false` otherwise.
	 *
	 * #### Notes
	 * This function uses the builtin browser capabilities when possible,
	 * falling back onto a document query otherwise.
	 */
	function matchesSelector(elem, selector) {
	    return Private.protoMatchFunc.call(elem, selector);
	}
	exports.matchesSelector = matchesSelector;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A regex which matches an ID selector at string start.
	     */
	    var ID_RE = /^#[^\s\+>~#\.\[:]+/;
	    /**
	     * A regex which matches a class selector at string start.
	     */
	    var CLASS_RE = /^\.[^\s\+>~#\.\[:]+/;
	    /**
	     * A regex which matches an attribute selector at string start.
	     */
	    var ATTR_RE = /^\[[^\]]+\]/;
	    /**
	     * A regex which matches a type selector at string start.
	     */
	    var TYPE_RE = /^[^\s\+>~#\.\[:]+/;
	    /**
	     * A regex which matches a pseudo-element selector at string start.
	     */
	    var PSEUDO_ELEM_RE = /^(::[^\s\+>~#\.\[:]+|:first-line|:first-letter|:before|:after)/;
	    /**
	     * A regex which matches a pseudo-class selector at string start.
	     */
	    var PSEUDO_CLASS_RE = /^:[^\s\+>~#\.\[:]+/;
	    /**
	     * A regex which matches ignored characters at string start.
	     */
	    var IGNORE_RE = /^[\s\+>~\*]+/;
	    /**
	     * A regex which matches the negation pseudo-class globally.
	     */
	    var NEGATION_RE = /:not\(([^\)]+)\)/g;
	    /**
	     * A cached of computed selector specificity values.
	     */
	    Private.specificityCache = Object.create(null);
	    /**
	     * A cached of computed selector validity.
	     */
	    Private.validityCache = Object.create(null);
	    /**
	     * An empty element for testing selector validity.
	     */
	    Private.testElem = document.createElement('div');
	    /**
	     * A cross-browser CSS selector matching prototype function.
	     */
	    Private.protoMatchFunc = (function () {
	        var proto = Element.prototype;
	        return (proto.matches ||
	            proto.matchesSelector ||
	            proto.mozMatchesSelector ||
	            proto.msMatchesSelector ||
	            proto.oMatchesSelector ||
	            proto.webkitMatchesSelector ||
	            (function (selector) {
	                var elem = this;
	                var matches = elem.ownerDocument.querySelectorAll(selector);
	                return Array.prototype.indexOf.call(matches, elem) !== -1;
	            }));
	    })();
	    /**
	     * Calculate the specificity of a single selector.
	     *
	     * The behavior is undefined if the selector is invalid.
	     */
	    function calculateSingle(selector) {
	        // Ignore anything after the first comma.
	        selector = selector.split(',', 1)[0];
	        // Setup the aggregate counters.
	        var a = 0;
	        var b = 0;
	        var c = 0;
	        // Apply a regex to the front selector. If the match succeeds, that
	        // portion of the selector is removed. Returns a success/fail flag.
	        function match(re) {
	            var match = selector.match(re);
	            if (match === null) {
	                return false;
	            }
	            selector = selector.slice(match[0].length);
	            return true;
	        }
	        // Replace the negation pseudo-class (which is ignored),
	        // but keep its inner content (which is not ignored).
	        selector = selector.replace(NEGATION_RE, ' $1 ');
	        // Continue matching until the selector is consumed.
	        while (selector.length > 0) {
	            // Match an ID selector.
	            if (match(ID_RE)) {
	                a++;
	                continue;
	            }
	            // Match a class selector.
	            if (match(CLASS_RE)) {
	                b++;
	                continue;
	            }
	            // Match an attribute selector.
	            if (match(ATTR_RE)) {
	                b++;
	                continue;
	            }
	            // Match a pseudo-element selector. This is done before matching
	            // a pseudo-class since this regex overlaps with the class regex.
	            if (match(PSEUDO_ELEM_RE)) {
	                c++;
	                continue;
	            }
	            // Match a pseudo-class selector.
	            if (match(PSEUDO_CLASS_RE)) {
	                b++;
	                continue;
	            }
	            // Match a plain type selector.
	            if (match(TYPE_RE)) {
	                c++;
	                continue;
	            }
	            // Finally, match any ignored characters.
	            if (match(IGNORE_RE)) {
	                continue;
	            }
	            // At this point, the selector is assumed to be invalid.
	            return 0;
	        }
	        // Clamp each component to a reasonable base.
	        a = Math.min(a, 0xFF);
	        b = Math.min(b, 0xFF);
	        c = Math.min(c, 0xFF);
	        // Combine the components into a single result.
	        return (a << 16) | (b << 8) | c;
	    }
	    Private.calculateSingle = calculateSingle;
	})(Private || (Private = {}));


/***/ },
/* 54 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * A concrete implementation of [[IKeyboardLayout]] based on keycodes.
	 *
	 * The `.keyCode` property of a `'keydown'` event is a browser and OS
	 * specific representation of the physical key (not character) which
	 * was pressed on a keyboard. While not the most convenient API, it
	 * is currently the only one which works reliably on all browsers.
	 *
	 * This class accepts a user-defined mapping of keycode to key, which
	 * allows for reliable shortcuts tailored to the user's system.
	 */
	var KeycodeLayout = (function () {
	    /**
	     * Construct a new keycode layout.
	     *
	     * @param name - The human readable name for the layout.
	     *
	     * @param codes - A mapping of keycode to key value.
	     */
	    function KeycodeLayout(name, codes) {
	        this._name = name;
	        this._codes = codes;
	        this._keys = KeycodeLayout.extractKeys(codes);
	    }
	    Object.defineProperty(KeycodeLayout.prototype, "name", {
	        /**
	         * The human readable name of the layout.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._name;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get an array of the key values supported by the layout.
	     *
	     * @returns A new array of the supported key values.
	     */
	    KeycodeLayout.prototype.keys = function () {
	        return Object.keys(this._keys);
	    };
	    /**
	     * Test whether the given key is a valid value for the layout.
	     *
	     * @param key - The user provided key to test for validity.
	     *
	     * @returns `true` if the key is valid, `false` otherwise.
	     */
	    KeycodeLayout.prototype.isValidKey = function (key) {
	        return key in this._keys;
	    };
	    /**
	     * Get the key for a `'keydown'` event.
	     *
	     * @param event - The event object for a `'keydown'` event.
	     *
	     * @returns The associated key value, or an empty string if
	     *   the event does not represent a valid primary key.
	     */
	    KeycodeLayout.prototype.keyForKeydownEvent = function (event) {
	        return this._codes[event.keyCode] || '';
	    };
	    return KeycodeLayout;
	}());
	exports.KeycodeLayout = KeycodeLayout;
	/**
	 * The namespace for the `KeycodeLayout` class statics.
	 */
	var KeycodeLayout;
	(function (KeycodeLayout) {
	    /**
	     * Extract the set of keys from a code map.
	     *
	     * @param code - The code map of interest.
	     *
	     * @returns A set of the keys in the code map.
	     */
	    function extractKeys(codes) {
	        var keys = Object.create(null);
	        for (var c in codes)
	            keys[codes[c]] = true;
	        return keys;
	    }
	    KeycodeLayout.extractKeys = extractKeys;
	})(KeycodeLayout = exports.KeycodeLayout || (exports.KeycodeLayout = {}));
	/**
	 * A keycode-based keyboard layout for US English keyboards.
	 *
	 * This layout is valid for the following OS/Browser combinations.
	 *
	 * - Windows
	 *   - Chrome
	 *   - Firefox
	 *   - IE
	 *
	 * - OSX
	 *   - Chrome
	 *   - Firefox
	 *   - Safari
	 *
	 * - Linux
	 *   - Chrome
	 *   - Firefox
	 *
	 * Other combinations may also work, but are untested.
	 */
	exports.EN_US = new KeycodeLayout('en-us', {
	    8: 'Backspace',
	    9: 'Tab',
	    13: 'Enter',
	    19: 'Pause',
	    27: 'Escape',
	    32: 'Space',
	    33: 'PageUp',
	    34: 'PageDown',
	    35: 'End',
	    36: 'Home',
	    37: 'ArrowLeft',
	    38: 'ArrowUp',
	    39: 'ArrowRight',
	    40: 'ArrowDown',
	    45: 'Insert',
	    46: 'Delete',
	    48: '0',
	    49: '1',
	    50: '2',
	    51: '3',
	    52: '4',
	    53: '5',
	    54: '6',
	    55: '7',
	    56: '8',
	    57: '9',
	    59: ';',
	    61: '=',
	    65: 'A',
	    66: 'B',
	    67: 'C',
	    68: 'D',
	    69: 'E',
	    70: 'F',
	    71: 'G',
	    72: 'H',
	    73: 'I',
	    74: 'J',
	    75: 'K',
	    76: 'L',
	    77: 'M',
	    78: 'N',
	    79: 'O',
	    80: 'P',
	    81: 'Q',
	    82: 'R',
	    83: 'S',
	    84: 'T',
	    85: 'U',
	    86: 'V',
	    87: 'W',
	    88: 'X',
	    89: 'Y',
	    90: 'Z',
	    93: 'ContextMenu',
	    96: '0',
	    97: '1',
	    98: '2',
	    99: '3',
	    100: '4',
	    101: '5',
	    102: '6',
	    103: '7',
	    104: '8',
	    105: '9',
	    106: '*',
	    107: '+',
	    109: '-',
	    110: '.',
	    111: '/',
	    112: 'F1',
	    113: 'F2',
	    114: 'F3',
	    115: 'F4',
	    116: 'F5',
	    117: 'F6',
	    118: 'F7',
	    119: 'F8',
	    120: 'F9',
	    121: 'F10',
	    122: 'F11',
	    123: 'F12',
	    173: '-',
	    186: ';',
	    187: '=',
	    188: ',',
	    189: '-',
	    190: '.',
	    191: '/',
	    192: '`',
	    219: '[',
	    220: '\\',
	    221: ']',
	    222: '\''
	});


/***/ },
/* 55 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(26);
	var messaging_1 = __webpack_require__(56);
	var properties_1 = __webpack_require__(58);
	var signaling_1 = __webpack_require__(20);
	var title_1 = __webpack_require__(59);
	/**
	 * The class name added to Widget instances.
	 */
	var WIDGET_CLASS = 'p-Widget';
	/**
	 * The class name added to hidden widgets.
	 */
	var HIDDEN_CLASS = 'p-mod-hidden';
	/**
	 * The base class of the Phosphor widget hierarchy.
	 *
	 * #### Notes
	 * This class will typically be subclassed in order to create a useful
	 * widget. However, it can be used directly to host externally created
	 * content.
	 */
	var Widget = (function () {
	    /**
	     * Construct a new widget.
	     *
	     * @param options - The options for initializing the widget.
	     */
	    function Widget(options) {
	        if (options === void 0) { options = {}; }
	        this._flags = 0;
	        this._layout = null;
	        this._parent = null;
	        this._node = Private.createNode(options);
	        this.addClass(WIDGET_CLASS);
	    }
	    /**
	     * Dispose of the widget and its descendant widgets.
	     *
	     * #### Notes
	     * It is unsafe to use the widget after it has been disposed.
	     *
	     * All calls made to this method after the first are a no-op.
	     */
	    Widget.prototype.dispose = function () {
	        // Do nothing if the widget is already disposed.
	        if (this.isDisposed) {
	            return;
	        }
	        // Set the disposed flag and emit the disposed signal.
	        this.setFlag(WidgetFlag.IsDisposed);
	        this.disposed.emit(void 0);
	        // Remove or detach the widget if necessary.
	        if (this.parent) {
	            this.parent = null;
	        }
	        else if (this.isAttached) {
	            Widget.detach(this);
	        }
	        // Dispose of the widget layout.
	        if (this._layout) {
	            this._layout.dispose();
	            this._layout = null;
	        }
	        // Clear the attached data associated with the widget.
	        signaling_1.clearSignalData(this);
	        messaging_1.clearMessageData(this);
	        properties_1.clearPropertyData(this);
	        // Clear the reference to the DOM node.
	        this._node = null;
	    };
	    Object.defineProperty(Widget.prototype, "isDisposed", {
	        /**
	         * Test whether the widget has been disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.testFlag(WidgetFlag.IsDisposed);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "isAttached", {
	        /**
	         * Test whether the widget's node is attached to the DOM.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.testFlag(WidgetFlag.IsAttached);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "isHidden", {
	        /**
	         * Test whether the widget is explicitly hidden.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.testFlag(WidgetFlag.IsHidden);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "isVisible", {
	        /**
	         * Test whether the widget is visible.
	         *
	         * #### Notes
	         * A widget is visible when it is attached to the DOM, is not
	         * explicitly hidden, and has no explicitly hidden ancestors.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.testFlag(WidgetFlag.IsVisible);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "node", {
	        /**
	         * Get the DOM node owned by the widget.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._node;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "id", {
	        /**
	         * Get the id of the widget's DOM node.
	         */
	        get: function () {
	            return this._node.id;
	        },
	        /**
	         * Set the id of the widget's DOM node.
	         */
	        set: function (value) {
	            this._node.id = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "title", {
	        /**
	         * Get the title object for the widget.
	         *
	         * #### Notes
	         * The title object is used by some container widgets when displaying
	         * the widget alongside some title, such as a tab panel or side bar.
	         *
	         * Since not all widgets will use the title, it is created on demand.
	         *
	         * The `owner` property of the title is set to this widget.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return Private.titleProperty.get(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "parent", {
	        /**
	         * Get the parent of the widget.
	         *
	         * #### Notes
	         * This will be `null` if the widget does not have a parent.
	         */
	        get: function () {
	            return this._parent;
	        },
	        /**
	         * Set the parent of the widget.
	         *
	         * #### Notes
	         * Children are typically added to a widget by using a layout, which
	         * means user code will not normally set the parent widget directly.
	         *
	         * The widget will be automatically removed from its old parent.
	         *
	         * This is a no-op if there is no effective parent change.
	         */
	        set: function (value) {
	            value = value || null;
	            if (this._parent === value) {
	                return;
	            }
	            if (value && this.contains(value)) {
	                throw new Error('Invalid parent widget.');
	            }
	            if (this._parent && !this._parent.isDisposed) {
	                messaging_1.sendMessage(this._parent, new ChildMessage('child-removed', this));
	            }
	            this._parent = value;
	            if (this._parent && !this._parent.isDisposed) {
	                messaging_1.sendMessage(this._parent, new ChildMessage('child-added', this));
	            }
	            messaging_1.sendMessage(this, WidgetMessage.ParentChanged);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "layout", {
	        /**
	         * Get the layout for the widget.
	         *
	         * #### Notes
	         * This will be `null` if the widget does not have a layout.
	         */
	        get: function () {
	            return this._layout;
	        },
	        /**
	         * Set the layout for the widget.
	         *
	         * #### Notes
	         * The layout is single-use only. It cannot be set to `null` and it
	         * cannot be changed after the first assignment.
	         *
	         * The layout is disposed automatically when the widget is disposed.
	         */
	        set: function (value) {
	            value = value || null;
	            if (this._layout === value) {
	                return;
	            }
	            if (this.testFlag(WidgetFlag.DisallowLayout)) {
	                throw new Error('Cannot set widget layout.');
	            }
	            if (this._layout) {
	                throw new Error('Cannot change widget layout.');
	            }
	            if (value.parent) {
	                throw new Error('Cannot change layout parent.');
	            }
	            this._layout = value;
	            value.parent = this;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Create an iterator over the widget's children.
	     *
	     * @returns A new iterator over the children of the widget.
	     *
	     * #### Notes
	     * The widget must have a populated layout in order to have children.
	     *
	     * If a layout is not installed, the returned iterator will be empty.
	     */
	    Widget.prototype.children = function () {
	        return this._layout ? this._layout.iter() : iteration_1.empty();
	    };
	    /**
	     * Test whether a widget is a descendant of this widget.
	     *
	     * @param widget - The descendant widget of interest.
	     *
	     * @returns `true` if the widget is a descendant, `false` otherwise.
	     */
	    Widget.prototype.contains = function (widget) {
	        for (; widget; widget = widget._parent) {
	            if (widget === this)
	                return true;
	        }
	        return false;
	    };
	    /**
	     * Test whether the widget's DOM node has the given class name.
	     *
	     * @param name - The class name of interest.
	     *
	     * @returns `true` if the node has the class, `false` otherwise.
	     */
	    Widget.prototype.hasClass = function (name) {
	        return this._node.classList.contains(name);
	    };
	    /**
	     * Add a class name to the widget's DOM node.
	     *
	     * @param name - The class name to add to the node.
	     *
	     * #### Notes
	     * If the class name is already added to the node, this is a no-op.
	     *
	     * The class name must not contain whitespace.
	     */
	    Widget.prototype.addClass = function (name) {
	        this._node.classList.add(name);
	    };
	    /**
	     * Remove a class name from the widget's DOM node.
	     *
	     * @param name - The class name to remove from the node.
	     *
	     * #### Notes
	     * If the class name is not yet added to the node, this is a no-op.
	     *
	     * The class name must not contain whitespace.
	     */
	    Widget.prototype.removeClass = function (name) {
	        this._node.classList.remove(name);
	    };
	    /**
	     * Toggle a class name on the widget's DOM node.
	     *
	     * @param name - The class name to toggle on the node.
	     *
	     * @param force - Whether to force add the class (`true`) or force
	     *   remove the class (`false`). If not provided, the presence of
	     *   the class will be toggled from its current state.
	     *
	     * @returns `true` if the class is now present, `false` otherwise.
	     *
	     * #### Notes
	     * The class name must not contain whitespace.
	     */
	    Widget.prototype.toggleClass = function (name, force) {
	        if (force === true) {
	            this._node.classList.add(name);
	            return true;
	        }
	        if (force === false) {
	            this._node.classList.remove(name);
	            return false;
	        }
	        return this._node.classList.toggle(name);
	    };
	    /**
	     * Post an `'update-request'` message to the widget.
	     *
	     * #### Notes
	     * This is a simple convenience method for posting the message.
	     */
	    Widget.prototype.update = function () {
	        messaging_1.postMessage(this, WidgetMessage.UpdateRequest);
	    };
	    /**
	     * Post a `'fit-request'` message to the widget.
	     *
	     * #### Notes
	     * This is a simple convenience method for posting the message.
	     */
	    Widget.prototype.fit = function () {
	        messaging_1.postMessage(this, WidgetMessage.FitRequest);
	    };
	    /**
	     * Post an `'activate-request'` message to the widget.
	     *
	     * #### Notes
	     * This is a simple convenience method for posting the message.
	     */
	    Widget.prototype.activate = function () {
	        messaging_1.postMessage(this, WidgetMessage.ActivateRequest);
	    };
	    /**
	     * Send a `'close-request'` message to the widget.
	     *
	     * #### Notes
	     * This is a simple convenience method for sending the message.
	     */
	    Widget.prototype.close = function () {
	        messaging_1.sendMessage(this, WidgetMessage.CloseRequest);
	    };
	    /**
	     * Show the widget and make it visible to its parent widget.
	     *
	     * #### Notes
	     * This causes the [[isHidden]] property to be `false`.
	     *
	     * If the widget is not explicitly hidden, this is a no-op.
	     */
	    Widget.prototype.show = function () {
	        if (!this.testFlag(WidgetFlag.IsHidden)) {
	            return;
	        }
	        this.clearFlag(WidgetFlag.IsHidden);
	        this.removeClass(HIDDEN_CLASS);
	        if (this.isAttached && (!this.parent || this.parent.isVisible)) {
	            messaging_1.sendMessage(this, WidgetMessage.AfterShow);
	        }
	        if (this.parent) {
	            messaging_1.sendMessage(this.parent, new ChildMessage('child-shown', this));
	        }
	    };
	    /**
	     * Hide the widget and make it hidden to its parent widget.
	     *
	     * #### Notes
	     * This causes the [[isHidden]] property to be `true`.
	     *
	     * If the widget is explicitly hidden, this is a no-op.
	     */
	    Widget.prototype.hide = function () {
	        if (this.testFlag(WidgetFlag.IsHidden)) {
	            return;
	        }
	        if (this.isAttached && (!this.parent || this.parent.isVisible)) {
	            messaging_1.sendMessage(this, WidgetMessage.BeforeHide);
	        }
	        this.setFlag(WidgetFlag.IsHidden);
	        this.addClass(HIDDEN_CLASS);
	        if (this.parent) {
	            messaging_1.sendMessage(this.parent, new ChildMessage('child-hidden', this));
	        }
	    };
	    /**
	     * Show or hide the widget according to a boolean value.
	     *
	     * @param hidden - `true` to hide the widget, or `false` to show it.
	     *
	     * #### Notes
	     * This is a convenience method for `hide()` and `show()`.
	     */
	    Widget.prototype.setHidden = function (hidden) {
	        if (hidden) {
	            this.hide();
	        }
	        else {
	            this.show();
	        }
	    };
	    /**
	     * Test whether the given widget flag is set.
	     *
	     * #### Notes
	     * This will not typically be called directly by user code.
	     */
	    Widget.prototype.testFlag = function (flag) {
	        return (this._flags & flag) !== 0;
	    };
	    /**
	     * Set the given widget flag.
	     *
	     * #### Notes
	     * This will not typically be called directly by user code.
	     */
	    Widget.prototype.setFlag = function (flag) {
	        this._flags |= flag;
	    };
	    /**
	     * Clear the given widget flag.
	     *
	     * #### Notes
	     * This will not typically be called directly by user code.
	     */
	    Widget.prototype.clearFlag = function (flag) {
	        this._flags &= ~flag;
	    };
	    /**
	     * Process a message sent to the widget.
	     *
	     * @param msg - The message sent to the widget.
	     *
	     * #### Notes
	     * Subclasses may reimplement this method as needed.
	     */
	    Widget.prototype.processMessage = function (msg) {
	        switch (msg.type) {
	            case 'resize':
	                this.notifyLayout(msg);
	                this.onResize(msg);
	                break;
	            case 'update-request':
	                this.notifyLayout(msg);
	                this.onUpdateRequest(msg);
	                break;
	            case 'after-show':
	                this.setFlag(WidgetFlag.IsVisible);
	                this.notifyLayout(msg);
	                this.onAfterShow(msg);
	                break;
	            case 'before-hide':
	                this.notifyLayout(msg);
	                this.onBeforeHide(msg);
	                this.clearFlag(WidgetFlag.IsVisible);
	                break;
	            case 'after-attach':
	                var visible = !this.isHidden && (!this.parent || this.parent.isVisible);
	                if (visible)
	                    this.setFlag(WidgetFlag.IsVisible);
	                this.setFlag(WidgetFlag.IsAttached);
	                this.notifyLayout(msg);
	                this.onAfterAttach(msg);
	                break;
	            case 'before-detach':
	                this.notifyLayout(msg);
	                this.onBeforeDetach(msg);
	                this.clearFlag(WidgetFlag.IsVisible);
	                this.clearFlag(WidgetFlag.IsAttached);
	                break;
	            case 'activate-request':
	                this.notifyLayout(msg);
	                this.onActivateRequest(msg);
	                break;
	            case 'close-request':
	                this.notifyLayout(msg);
	                this.onCloseRequest(msg);
	                break;
	            case 'child-added':
	                this.notifyLayout(msg);
	                this.onChildAdded(msg);
	                break;
	            case 'child-removed':
	                this.notifyLayout(msg);
	                this.onChildRemoved(msg);
	                break;
	            default:
	                this.notifyLayout(msg);
	                break;
	        }
	    };
	    /**
	     * Invoke the message processing routine of the widget's layout.
	     *
	     * @param msg - The message to dispatch to the layout.
	     *
	     * #### Notes
	     * This is a no-op if the widget does not have a layout.
	     *
	     * This will not typically be called directly by user code.
	     */
	    Widget.prototype.notifyLayout = function (msg) {
	        if (this._layout)
	            this._layout.processParentMessage(msg);
	    };
	    /**
	     * A message handler invoked on a `'close-request'` message.
	     *
	     * #### Notes
	     * The default implementation unparents or detaches the widget.
	     */
	    Widget.prototype.onCloseRequest = function (msg) {
	        if (this.parent) {
	            this.parent = null;
	        }
	        else if (this.isAttached) {
	            Widget.detach(this);
	        }
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onResize = function (msg) { };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onUpdateRequest = function (msg) { };
	    /**
	     * A message handler invoked on an `'activate-request'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onActivateRequest = function (msg) { };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onAfterShow = function (msg) { };
	    /**
	     * A message handler invoked on a `'before-hide'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onBeforeHide = function (msg) { };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onAfterAttach = function (msg) { };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onBeforeDetach = function (msg) { };
	    /**
	     * A message handler invoked on a `'child-added'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onChildAdded = function (msg) { };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Widget.prototype.onChildRemoved = function (msg) { };
	    return Widget;
	}());
	exports.Widget = Widget;
	// Define the signals for the `Widget` class.
	signaling_1.defineSignal(Widget.prototype, 'disposed');
	/**
	 * The namespace for the `Widget` class statics.
	 */
	var Widget;
	(function (Widget) {
	    // TODO - should this be an instance method?
	    /**
	     * Attach a widget to a host DOM node.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param host - The DOM node to use as the widget's host.
	     *
	     * #### Notes
	     * This will throw an error if the widget is not a root widget, if
	     * the widget is already attached, or if the host is not attached
	     * to the DOM.
	     */
	    function attach(widget, host) {
	        if (widget.parent) {
	            throw new Error('Cannot attach child widget.');
	        }
	        if (widget.isAttached || document.body.contains(widget.node)) {
	            throw new Error('Widget already attached.');
	        }
	        if (!document.body.contains(host)) {
	            throw new Error('Host not attached.');
	        }
	        host.appendChild(widget.node);
	        messaging_1.sendMessage(widget, WidgetMessage.AfterAttach);
	    }
	    Widget.attach = attach;
	    // TODO - should this be an instance method?
	    /**
	     * Detach the widget from its host DOM node.
	     *
	     * @param widget - The widget of interest.
	     *
	     * #### Notes
	     * This will throw an error if the widget is not a root widget, or
	     * if the widget is not attached to the DOM.
	     */
	    function detach(widget) {
	        if (widget.parent) {
	            throw new Error('Cannot detach child widget.');
	        }
	        if (!widget.isAttached || !document.body.contains(widget.node)) {
	            throw new Error('Widget not attached.');
	        }
	        messaging_1.sendMessage(widget, WidgetMessage.BeforeDetach);
	        widget.node.parentNode.removeChild(widget.node);
	    }
	    Widget.detach = detach;
	    /**
	     * Prepare a widget for absolute layout geometry.
	     *
	     * @param widget - The widget of interest.
	     *
	     * #### Notes
	     * This sets the inline style position of the widget to `absolute`.
	     */
	    function prepareGeometry(widget) {
	        widget.node.style.position = 'absolute';
	    }
	    Widget.prepareGeometry = prepareGeometry;
	    /**
	     * Reset the layout geometry of a widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * #### Notes
	     * This clears the inline style position and geometry of the widget.
	     */
	    function resetGeometry(widget) {
	        var style = widget.node.style;
	        var rect = Private.rectProperty.get(widget);
	        rect.top = NaN;
	        rect.left = NaN;
	        rect.width = NaN;
	        rect.height = NaN;
	        style.position = '';
	        style.top = '';
	        style.left = '';
	        style.width = '';
	        style.height = '';
	    }
	    Widget.resetGeometry = resetGeometry;
	    /**
	     * Set the absolute layout geometry of a widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param left - The desired offset left position of the widget.
	     *
	     * @param top - The desired offset top position of the widget.
	     *
	     * @param width - The desired offset width of the widget.
	     *
	     * @param height - The desired offset height of the widget.
	     *
	     * #### Notes
	     * All dimensions are assumed to be pixels with coordinates relative
	     * to the origin of the widget's offset parent.
	     *
	     * The widget's node is assumed to be position `absolute`.
	     *
	     * If the widget is resized from its previous size, a `ResizeMessage`
	     * will be automatically sent to the widget.
	     */
	    function setGeometry(widget, left, top, width, height) {
	        var resized = false;
	        var style = widget.node.style;
	        var rect = Private.rectProperty.get(widget);
	        if (rect.top !== top) {
	            rect.top = top;
	            style.top = top + "px";
	        }
	        if (rect.left !== left) {
	            rect.left = left;
	            style.left = left + "px";
	        }
	        if (rect.width !== width) {
	            resized = true;
	            rect.width = width;
	            style.width = width + "px";
	        }
	        if (rect.height !== height) {
	            resized = true;
	            rect.height = height;
	            style.height = height + "px";
	        }
	        if (resized) {
	            messaging_1.sendMessage(widget, new ResizeMessage(width, height));
	        }
	    }
	    Widget.setGeometry = setGeometry;
	})(Widget = exports.Widget || (exports.Widget = {}));
	/**
	 * An abstract base class for creating Phosphor layouts.
	 *
	 * #### Notes
	 * A layout is used to add widgets to a parent and to arrange those
	 * widgets within the parent's DOM node.
	 *
	 * This class implements the base functionality which is required of
	 * nearly all layouts. It must be subclassed in order to be useful.
	 *
	 * Notably, this class does not define a uniform interface for adding
	 * widgets to the layout. A subclass should define that API in a way
	 * which is meaningful for its intended use.
	 */
	var Layout = (function () {
	    function Layout() {
	        this._disposed = false;
	        this._parent = null;
	    }
	    /**
	     * Dispose of the resources held by the layout.
	     *
	     * #### Notes
	     * This should be reimplemented to clear and dispose of the widgets.
	     *
	     * All reimplementations should call the superclass method.
	     *
	     * This method is called automatically when the parent is disposed.
	     */
	    Layout.prototype.dispose = function () {
	        this._disposed = true;
	        this._parent = null;
	        signaling_1.clearSignalData(this);
	        properties_1.clearPropertyData(this);
	    };
	    Object.defineProperty(Layout.prototype, "isDisposed", {
	        /**
	         * Test whether the layout is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._disposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Layout.prototype, "parent", {
	        /**
	         * Get the parent widget of the layout.
	         */
	        get: function () {
	            return this._parent;
	        },
	        /**
	         * Set the parent widget of the layout.
	         *
	         * #### Notes
	         * This is set automatically when installing the layout on the parent
	         * widget. The parent widget should not be set directly by user code.
	         */
	        set: function (value) {
	            if (!value) {
	                throw new Error('Cannot set parent widget to null.');
	            }
	            if (this._parent === value) {
	                return;
	            }
	            if (this._parent) {
	                throw new Error('Cannot change parent widget.');
	            }
	            if (value.layout !== this) {
	                throw new Error('Invalid parent widget.');
	            }
	            this._parent = value;
	            this.init();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Process a message sent to the parent widget.
	     *
	     * @param msg - The message sent to the parent widget.
	     *
	     * #### Notes
	     * This method is called by the parent widget to process a message.
	     *
	     * Subclasses may reimplement this method as needed.
	     */
	    Layout.prototype.processParentMessage = function (msg) {
	        switch (msg.type) {
	            case 'resize':
	                this.onResize(msg);
	                break;
	            case 'update-request':
	                this.onUpdateRequest(msg);
	                break;
	            case 'fit-request':
	                this.onFitRequest(msg);
	                break;
	            case 'after-show':
	                this.onAfterShow(msg);
	                break;
	            case 'before-hide':
	                this.onBeforeHide(msg);
	                break;
	            case 'after-attach':
	                this.onAfterAttach(msg);
	                break;
	            case 'before-detach':
	                this.onBeforeDetach(msg);
	                break;
	            case 'child-removed':
	                this.onChildRemoved(msg);
	                break;
	            case 'child-shown':
	                this.onChildShown(msg);
	                break;
	            case 'child-hidden':
	                this.onChildHidden(msg);
	                break;
	        }
	    };
	    /**
	     * Perform layout initialization which requires the parent widget.
	     *
	     * #### Notes
	     * This method is invoked immediately after the layout is installed
	     * on the parent widget.
	     *
	     * The default implementation reparents all of the widgets to the
	     * layout parent widget.
	     *
	     * Subclasses should reimplement this method and attach the child
	     * widget nodes to the parent widget's node.
	     */
	    Layout.prototype.init = function () {
	        var _this = this;
	        iteration_1.each(this, function (widget) { widget.parent = _this.parent; });
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     *
	     * #### Notes
	     * The layout should ensure that its widgets are resized according
	     * to the specified layout space, and that they are sent a `'resize'`
	     * message if appropriate.
	     *
	     * The default implementation of this method sends an `UnknownSize`
	     * resize message to all widgets.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    Layout.prototype.onResize = function (msg) {
	        iteration_1.each(this, function (widget) { messaging_1.sendMessage(widget, ResizeMessage.UnknownSize); });
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     *
	     * #### Notes
	     * The layout should ensure that its widgets are resized according
	     * to the available layout space, and that they are sent a `'resize'`
	     * message if appropriate.
	     *
	     * The default implementation of this method sends an `UnknownSize`
	     * resize message to all widgets.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    Layout.prototype.onUpdateRequest = function (msg) {
	        iteration_1.each(this, function (widget) { messaging_1.sendMessage(widget, ResizeMessage.UnknownSize); });
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     *
	     * #### Notes
	     * The default implementation of this method forwards the message
	     * to all widgets. It assumes all widget nodes are attached to the
	     * parent widget node.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    Layout.prototype.onAfterAttach = function (msg) {
	        iteration_1.each(this, function (widget) { messaging_1.sendMessage(widget, msg); });
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     *
	     * #### Notes
	     * The default implementation of this method forwards the message
	     * to all widgets. It assumes all widget nodes are attached to the
	     * parent widget node.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    Layout.prototype.onBeforeDetach = function (msg) {
	        iteration_1.each(this, function (widget) { messaging_1.sendMessage(widget, msg); });
	    };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     *
	     * #### Notes
	     * The default implementation of this method forwards the message to
	     * all non-hidden widgets. It assumes all widget nodes are attached
	     * to the parent widget node.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    Layout.prototype.onAfterShow = function (msg) {
	        iteration_1.each(this, function (widget) { if (!widget.isHidden)
	            messaging_1.sendMessage(widget, msg); });
	    };
	    /**
	     * A message handler invoked on a `'before-hide'` message.
	     *
	     * #### Notes
	     * The default implementation of this method forwards the message to
	     * all non-hidden widgets. It assumes all widget nodes are attached
	     * to the parent widget node.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    Layout.prototype.onBeforeHide = function (msg) {
	        iteration_1.each(this, function (widget) { if (!widget.isHidden)
	            messaging_1.sendMessage(widget, msg); });
	    };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     *
	     * #### Notes
	     * This will remove the child widget from the layout.
	     *
	     * Subclasses should **not** typically reimplement this method.
	     */
	    Layout.prototype.onChildRemoved = function (msg) {
	        this.removeWidget(msg.child);
	    };
	    /**
	     * A message handler invoked on a `'fit-request'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Layout.prototype.onFitRequest = function (msg) { };
	    /**
	     * A message handler invoked on a `'child-shown'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Layout.prototype.onChildShown = function (msg) { };
	    /**
	     * A message handler invoked on a `'child-hidden'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler is a no-op.
	     */
	    Layout.prototype.onChildHidden = function (msg) { };
	    return Layout;
	}());
	exports.Layout = Layout;
	// TODO should this be in the Widget namespace?
	/**
	 * An enum of widget bit flags.
	 */
	(function (WidgetFlag) {
	    /**
	     * The widget has been disposed.
	     */
	    WidgetFlag[WidgetFlag["IsDisposed"] = 1] = "IsDisposed";
	    /**
	     * The widget is attached to the DOM.
	     */
	    WidgetFlag[WidgetFlag["IsAttached"] = 2] = "IsAttached";
	    /**
	     * The widget is hidden.
	     */
	    WidgetFlag[WidgetFlag["IsHidden"] = 4] = "IsHidden";
	    /**
	     * The widget is visible.
	     */
	    WidgetFlag[WidgetFlag["IsVisible"] = 8] = "IsVisible";
	    /**
	     * A layout cannot be set on the widget.
	     */
	    WidgetFlag[WidgetFlag["DisallowLayout"] = 16] = "DisallowLayout";
	})(exports.WidgetFlag || (exports.WidgetFlag = {}));
	var WidgetFlag = exports.WidgetFlag;
	// TODO should this be in the Widget namespace?
	/**
	 * A collection of stateless messages related to widgets.
	 */
	var WidgetMessage;
	(function (WidgetMessage) {
	    /**
	     * A singleton `'after-show'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget after it becomes visible.
	     *
	     * This message is **not** sent when the widget is being attached.
	     */
	    WidgetMessage.AfterShow = new messaging_1.Message('after-show');
	    /**
	     * A singleton `'before-hide'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget before it becomes not-visible.
	     *
	     * This message is **not** sent when the widget is being detached.
	     */
	    WidgetMessage.BeforeHide = new messaging_1.Message('before-hide');
	    /**
	     * A singleton `'after-attach'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget after it is attached.
	     */
	    WidgetMessage.AfterAttach = new messaging_1.Message('after-attach');
	    /**
	     * A singleton `'before-detach'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget before it is detached.
	     */
	    WidgetMessage.BeforeDetach = new messaging_1.Message('before-detach');
	    /**
	     * A singleton `'parent-changed'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget when its parent has changed.
	     */
	    WidgetMessage.ParentChanged = new messaging_1.Message('parent-changed');
	    /**
	     * A singleton conflatable `'update-request'` message.
	     *
	     * #### Notes
	     * This message can be dispatched to supporting widgets in order to
	     * update their content based on the current widget state. Not all
	     * widgets will respond to messages of this type.
	     *
	     * For widgets with a layout, this message will inform the layout to
	     * update the position and size of its child widgets.
	     */
	    WidgetMessage.UpdateRequest = new messaging_1.ConflatableMessage('update-request');
	    /**
	     * A singleton conflatable `'fit-request'` message.
	     *
	     * #### Notes
	     * For widgets with a layout, this message will inform the layout to
	     * recalculate its size constraints to fit the space requirements of
	     * its child widgets, and to update their position and size. Not all
	     * layouts will respond to messages of this type.
	     */
	    WidgetMessage.FitRequest = new messaging_1.ConflatableMessage('fit-request');
	    /**
	     * A singleton conflatable `'activate-request'` message.
	     *
	     * #### Notes
	     * This message should be dispatched to a widget when it should
	     * perform the actions necessary to activate the widget, which
	     * may include focusing its node or descendant node.
	     */
	    WidgetMessage.ActivateRequest = new messaging_1.ConflatableMessage('activate-request');
	    /**
	     * A singleton conflatable `'close-request'` message.
	     *
	     * #### Notes
	     * This message should be dispatched to a widget when it should close
	     * and remove itself from the widget hierarchy.
	     */
	    WidgetMessage.CloseRequest = new messaging_1.ConflatableMessage('close-request');
	})(WidgetMessage = exports.WidgetMessage || (exports.WidgetMessage = {}));
	// TODO should this be in the Widget namespace?
	/**
	 * A message class for child related messages.
	 */
	var ChildMessage = (function (_super) {
	    __extends(ChildMessage, _super);
	    /**
	     * Construct a new child message.
	     *
	     * @param type - The message type.
	     *
	     * @param child - The child widget for the message.
	     */
	    function ChildMessage(type, child) {
	        _super.call(this, type);
	        this._child = child;
	    }
	    Object.defineProperty(ChildMessage.prototype, "child", {
	        /**
	         * The child widget for the message.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._child;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return ChildMessage;
	}(messaging_1.Message));
	exports.ChildMessage = ChildMessage;
	// TODO should this be in the Widget namespace?
	/**
	 * A message class for `'resize'` messages.
	 */
	var ResizeMessage = (function (_super) {
	    __extends(ResizeMessage, _super);
	    /**
	     * Construct a new resize message.
	     *
	     * @param width - The **offset width** of the widget, or `-1` if
	     *   the width is not known.
	     *
	     * @param height - The **offset height** of the widget, or `-1` if
	     *   the height is not known.
	     */
	    function ResizeMessage(width, height) {
	        _super.call(this, 'resize');
	        this._width = width;
	        this._height = height;
	    }
	    Object.defineProperty(ResizeMessage.prototype, "width", {
	        /**
	         * The offset width of the widget.
	         *
	         * #### Notes
	         * This will be `-1` if the width is unknown.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._width;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ResizeMessage.prototype, "height", {
	        /**
	         * The offset height of the widget.
	         *
	         * #### Notes
	         * This will be `-1` if the height is unknown.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._height;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return ResizeMessage;
	}(messaging_1.Message));
	exports.ResizeMessage = ResizeMessage;
	/**
	 * The namespace for the `ResizeMessage` class statics.
	 */
	var ResizeMessage;
	(function (ResizeMessage) {
	    /**
	     * A singleton `'resize'` message with an unknown size.
	     */
	    ResizeMessage.UnknownSize = new ResizeMessage(-1, -1);
	})(ResizeMessage = exports.ResizeMessage || (exports.ResizeMessage = {}));
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A property descriptor for a widget absolute geometry rect.
	     */
	    Private.rectProperty = new properties_1.AttachedProperty({
	        name: 'rect',
	        create: function () { return ({ top: NaN, left: NaN, width: NaN, height: NaN }); },
	    });
	    /**
	     * An attached property for the widget title object.
	     */
	    Private.titleProperty = new properties_1.AttachedProperty({
	        name: 'title',
	        create: function (owner) { return new title_1.Title({ owner: owner }); },
	    });
	    /**
	     * Create a DOM node for the given widget options.
	     */
	    function createNode(options) {
	        return options.node || document.createElement('div');
	    }
	    Private.createNode = createNode;
	})(Private || (Private = {}));


/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(setImmediate) {"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(26);
	var queue_1 = __webpack_require__(57);
	/**
	 * A message which can be delivered to a message handler.
	 *
	 * #### Notes
	 * This class may be subclassed to create complex message types.
	 *
	 * **See also:** [[postMessage]] and [[sendMessage]].
	 */
	var Message = (function () {
	    /**
	     * Construct a new message.
	     *
	     * @param type - The type of the message.
	     */
	    function Message(type) {
	        this._type = type;
	    }
	    Object.defineProperty(Message.prototype, "type", {
	        /**
	         * The type of the message.
	         *
	         * #### Notes
	         * This value can be used to cast the message to a derived type.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._type;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Message.prototype, "isConflatable", {
	        /**
	         * Test whether the message is conflatable.
	         *
	         * #### Notes
	         * Message conflation is an advanced topic. Most message types will
	         * not make use of this feature.
	         *
	         * If a conflatable message is posted to the event queue when another
	         * conflatable message of the same type and handler has already been
	         * posted, the `conflate()` method of the existing message will be
	         * invoked. If that method returns `true`, the new message will not
	         * be enqueued. This allows messages to be compressed, so that only
	         * a single instance of the message type is processed per cycle, no
	         * matter how many times messages of that type are posted.
	         *
	         * Custom message types may reimplement this property. The default
	         * implementation is always `false`.
	         *
	         * This is a read-only property.
	         *
	         * **See also:** [[conflateMessage]]
	         */
	        get: function () {
	            return false;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Conflate this message with another message of the same `type`.
	     *
	     * @param other - A conflatable message of the same `type`.
	     *
	     * @returns `true` if the message was successfully conflated, or
	     *   `false` otherwise.
	     *
	     * #### Notes
	     * Message conflation is an advanced topic. Most message types will
	     * not make use of this feature.
	     *
	     * This method is called automatically by the message loop when the
	     * given message is posted to the handler paired with this message.
	     * This message will already be enqueued and conflatable, and the
	     * given message will have the same `type` and also be conflatable.
	     *
	     * This method should merge the state of the other message into this
	     * message as needed so that when this message is finally delivered
	     * to the handler, it receives the most up-to-date information.
	     *
	     * If this method returns `true`, it signals that the other message
	     * was successfully conflated and it will not be enqueued.
	     *
	     * If this method returns `false`, the other message will be enqueued
	     * for normal delivery.
	     *
	     * Custom message types may reimplement this method. The default
	     * implementation always returns `false`.
	     *
	     * **See also:** [[isConflatable]]
	     */
	    Message.prototype.conflate = function (other) {
	        return false;
	    };
	    return Message;
	}());
	exports.Message = Message;
	/**
	 * A convenience message class which conflates automatically.
	 *
	 * #### Notes
	 * Message conflation is an advanced topic. Most user code will not
	 * make use of this class.
	 *
	 * This message class is useful for creating message instances which
	 * should be conflated, but which have no state other than `type`.
	 *
	 * If conflation of stateful messages is required, a custom `Message`
	 * subclass should be created.
	 */
	var ConflatableMessage = (function (_super) {
	    __extends(ConflatableMessage, _super);
	    function ConflatableMessage() {
	        _super.apply(this, arguments);
	    }
	    Object.defineProperty(ConflatableMessage.prototype, "isConflatable", {
	        /**
	         * Test whether the message is conflatable.
	         *
	         * #### Notes
	         * This property is always `true`.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return true;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Conflate this message with another message of the same `type`.
	     *
	     * #### Notes
	     * This method always returns `true`.
	     */
	    ConflatableMessage.prototype.conflate = function (other) {
	        return true;
	    };
	    return ConflatableMessage;
	}(Message));
	exports.ConflatableMessage = ConflatableMessage;
	/**
	 * Send a message to a message handler to process immediately.
	 *
	 * @param handler - The handler which should process the message.
	 *
	 * @param msg - The message to deliver to the handler.
	 *
	 * #### Notes
	 * The message will first be sent through any installed message hooks
	 * for the handler. If the message passes all hooks, it will then be
	 * delivered to the `processMessage` method of the handler.
	 *
	 * The message will not be conflated with pending posted messages.
	 *
	 * Exceptions in hooks and handlers will be caught and logged.
	 */
	function sendMessage(handler, msg) {
	    MessageLoop.sendMessage(handler, msg);
	}
	exports.sendMessage = sendMessage;
	/**
	 * Post a message to the message handler to process in the future.
	 *
	 * @param handler - The handler which should process the message.
	 *
	 * @param msg - The message to post to the handler.
	 *
	 * #### Notes
	 * The message will be conflated with the pending posted messages for
	 * the handler, if possible. If the message is not conflated, it will
	 * be queued for normal delivery on the next cycle of the event loop.
	 *
	 * Exceptions in hooks and handlers will be caught and logged.
	 */
	function postMessage(handler, msg) {
	    MessageLoop.postMessage(handler, msg);
	}
	exports.postMessage = postMessage;
	/**
	 * Install a message hook for a message handler.
	 *
	 * @param handler - The message handler of interest.
	 *
	 * @param hook - The message hook to install.
	 *
	 * #### Notes
	 * A message hook is invoked before a message is delivered to the
	 * handler. If the hook returns `false`, no other hooks will be
	 * invoked and the message will not be delivered to the handler.
	 *
	 * The most recently installed message hook is executed first.
	 *
	 * If the hook is already installed, it will be moved to the front.
	 *
	 * **See also:** [[removeMessageHook]]
	 */
	function installMessageHook(handler, hook) {
	    MessageLoop.installMessageHook(handler, hook);
	}
	exports.installMessageHook = installMessageHook;
	/**
	 * Remove an installed message hook for a message handler.
	 *
	 * @param handler - The message handler of interest.
	 *
	 * @param hook - The message hook to remove.
	 *
	 * #### Notes
	 * If the hook is not installed, this is a no-op.
	 *
	 * It is safe to call this function while the hook is executing.
	 */
	function removeMessageHook(handler, hook) {
	    MessageLoop.removeMessageHook(handler, hook);
	}
	exports.removeMessageHook = removeMessageHook;
	/**
	 * Clear all message data associated with a message handler.
	 *
	 * @param handler - The message handler of interest.
	 *
	 * #### Notes
	 * This will clear all pending messages and hooks for the handler.
	 */
	function clearMessageData(handler) {
	    MessageLoop.clearMessageData(handler);
	}
	exports.clearMessageData = clearMessageData;
	/**
	 * The namespace for the global singleton message loop.
	 */
	var MessageLoop;
	(function (MessageLoop) {
	    /**
	     * Send a message to a handler for immediate processing.
	     *
	     * This will first call all message hooks for the handler. If any
	     * hook rejects the message, the message will not be delivered.
	     */
	    function sendMessage(handler, msg) {
	        // Handle the common case of no message hooks.
	        var node = hooks.get(handler);
	        if (node === void 0) {
	            invokeHandler(handler, msg);
	            return;
	        }
	        // Run the message hooks and bail early if any hook returns false.
	        // A null hook indicates the hook was removed during dispatch.
	        for (; node !== null; node = node.next) {
	            if (node.hook !== null && !invokeHook(node.hook, handler, msg)) {
	                return;
	            }
	        }
	        // All message hooks returned true, so invoke the handler.
	        invokeHandler(handler, msg);
	    }
	    MessageLoop.sendMessage = sendMessage;
	    /**
	     * Post a message to a handler for processing in the future.
	     *
	     * This will first conflate the message, if possible. If it cannot
	     * be conflated, it will be queued for delivery on the next cycle
	     * of the event loop.
	     */
	    function postMessage(handler, msg) {
	        // Handle the common case a non-conflatable message first.
	        if (!msg.isConflatable) {
	            enqueueMessage(handler, msg);
	            return;
	        }
	        // Conflate message if possible.
	        var conflated = iteration_1.some(queue, function (posted) {
	            if (posted.handler !== handler) {
	                return false;
	            }
	            if (posted.msg.type !== msg.type) {
	                return false;
	            }
	            if (!posted.msg.isConflatable) {
	                return false;
	            }
	            return posted.msg.conflate(msg);
	        });
	        // If the message was not conflated, enqueue the message.
	        if (!conflated)
	            enqueueMessage(handler, msg);
	    }
	    MessageLoop.postMessage = postMessage;
	    /**
	     * Install a message hook for a handler.
	     *
	     * This will first remove the hook if it exists, then install the
	     * hook in front of other hooks for the handler.
	     */
	    function installMessageHook(handler, hook) {
	        // Remove the message hook if it's already installed.
	        removeMessageHook(handler, hook);
	        // Install the hook at the front of the list.
	        var next = hooks.get(handler) || null;
	        hooks.set(handler, { next: next, hook: hook });
	    }
	    MessageLoop.installMessageHook = installMessageHook;
	    /**
	     * Remove a message hook for a handler, if it exists.
	     */
	    function removeMessageHook(handler, hook) {
	        // Traverse the list and find the matching hook. If found, clear
	        // the reference to the hook and remove the node from the list.
	        // The node's next reference is *not* cleared so that dispatch
	        // may continue when the hook is removed during dispatch.
	        var prev = null;
	        var node = hooks.get(handler) || null;
	        for (; node !== null; prev = node, node = node.next) {
	            if (node.hook === hook) {
	                if (prev === null && node.next === null) {
	                    hooks.delete(handler);
	                }
	                else if (prev === null) {
	                    hooks.set(handler, node.next);
	                }
	                else {
	                    prev.next = node.next;
	                }
	                node.hook = null;
	                return;
	            }
	        }
	    }
	    MessageLoop.removeMessageHook = removeMessageHook;
	    /**
	     * Clear all message data for a handler.
	     *
	     * This will remove all message hooks and clear pending messages.
	     */
	    function clearMessageData(handler) {
	        // Clear all message hooks.
	        var node = hooks.get(handler) || null;
	        for (; node !== null; node = node.next) {
	            node.hook = null;
	        }
	        // Remove the handler from the hooks map.
	        hooks.delete(handler);
	        // Clear all pending messages.
	        iteration_1.each(queue, function (posted) {
	            if (posted.handler === handler) {
	                posted.handler = null;
	            }
	        });
	    }
	    MessageLoop.clearMessageData = clearMessageData;
	    /**
	     * The queue of posted message pairs.
	     */
	    var queue = new queue_1.Queue();
	    /**
	     * A mapping of handler to list of installed message hooks.
	     */
	    var hooks = new WeakMap();
	    /**
	     * A local reference to an event loop callback.
	     */
	    var defer = (function () {
	        var ok = typeof requestAnimationFrame === 'function';
	        return ok ? requestAnimationFrame : setImmediate;
	    })();
	    /**
	     * Whether a message loop cycle is pending.
	     */
	    var cyclePending = false;
	    /**
	     * Invoke a message hook with the specified handler and message.
	     *
	     * Returns the result of the hook, or `true` if the hook throws.
	     *
	     * Exceptions in the hook will be caught and logged.
	     */
	    function invokeHook(hook, handler, msg) {
	        var result;
	        try {
	            result = hook(handler, msg);
	        }
	        catch (err) {
	            result = true;
	            console.error(err);
	        }
	        return result;
	    }
	    /**
	     * Invoke a message handler with the specified message.
	     *
	     * Exceptions in the handler will be caught and logged.
	     */
	    function invokeHandler(handler, msg) {
	        try {
	            handler.processMessage(msg);
	        }
	        catch (err) {
	            console.error(err);
	        }
	    }
	    /**
	     * Add a message to the end of the message queue.
	     *
	     * This will automatically schedule a cycle of the loop.
	     */
	    function enqueueMessage(handler, msg) {
	        queue.pushBack({ handler: handler, msg: msg });
	        scheduleMessageLoop();
	    }
	    /**
	     * Schedule a message loop cycle to process any pending messages.
	     *
	     * This is a no-op if a loop cycle is already pending.
	     */
	    function scheduleMessageLoop() {
	        if (!cyclePending) {
	            defer(runMessageLoop);
	            cyclePending = true;
	        }
	    }
	    /**
	     * Run an iteration of the message loop.
	     *
	     * This will process all pending messages in the queue. If a message
	     * is added to the queue while the message loop is running, it will
	     * be processed on the next cycle of the loop.
	     */
	    function runMessageLoop() {
	        // Clear the pending flag so the next loop can be scheduled.
	        cyclePending = false;
	        // If the queue is empty, there is nothing else to do.
	        if (queue.isEmpty) {
	            return;
	        }
	        // Add a sentinel value to the end of the queue. The queue will
	        // only be processed up to the sentinel. Messages posted during
	        // this cycle will execute on the next cycle.
	        var sentinel = { handler: null, msg: null };
	        queue.pushBack(sentinel);
	        // Enter the message loop.
	        while (!queue.isEmpty) {
	            // Remove the first posted message in the queue.
	            var posted = queue.popFront();
	            // If the value is the sentinel, exit the loop.
	            if (posted === sentinel) {
	                return;
	            }
	            // Dispatch the message if the handler has not been cleared.
	            if (posted.handler !== null) {
	                sendMessage(posted.handler, posted.msg);
	            }
	        }
	    }
	})(MessageLoop || (MessageLoop = {}));
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(21).setImmediate))

/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(26);
	/**
	 * A generic FIFO queue data structure.
	 */
	var Queue = (function () {
	    /**
	     * Construct a new queue.
	     *
	     * @param values - The initial values for the queue.
	     */
	    function Queue(values) {
	        var _this = this;
	        this._length = 0;
	        this._front = null;
	        this._back = null;
	        if (values)
	            iteration_1.each(values, function (value) { _this.pushBack(value); });
	    }
	    Object.defineProperty(Queue.prototype, "isEmpty", {
	        /**
	         * Test whether the queue is empty.
	         *
	         * @returns `true` if the queue is empty, `false` otherwise.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._length === 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Queue.prototype, "length", {
	        /**
	         * Get the length of the queue.
	         *
	         * @return The number of values in the queue.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._length;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Queue.prototype, "front", {
	        /**
	         * Get the value at the front of the queue.
	         *
	         * @returns The value at the front of the queue, or `undefined` if
	         *   the queue is empty.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._front ? this._front.value : void 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Queue.prototype, "back", {
	        /**
	         * Get the value at the back of the queue.
	         *
	         * @returns The value at the back of the queue, or `undefined` if
	         *   the queue is empty.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * #### Complexity
	         * Constant.
	         *
	         * #### Iterator Validity
	         * No changes.
	         */
	        get: function () {
	            return this._back ? this._back.value : void 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Create an iterator over the values in the queue.
	     *
	     * @returns A new iterator starting at the front of the queue.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * No changes.
	     */
	    Queue.prototype.iter = function () {
	        return new QueueIterator(this._front);
	    };
	    /**
	     * Add a value to the back of the queue.
	     *
	     * @param value - The value to add to the back of the queue.
	     *
	     * @returns The new length of the queue.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * No changes.
	     */
	    Queue.prototype.pushBack = function (value) {
	        var node = new QueueNode(value);
	        if (this._length === 0) {
	            this._front = node;
	            this._back = node;
	        }
	        else {
	            this._back.next = node;
	            this._back = node;
	        }
	        return ++this._length;
	    };
	    /**
	     * Remove and return the value at the front of the queue.
	     *
	     * @returns The value at the front of the queue, or `undefined` if
	     *   the queue is empty.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * Iterators pointing at the removed value are invalidated.
	     */
	    Queue.prototype.popFront = function () {
	        if (this._length === 0) {
	            return void 0;
	        }
	        var node = this._front;
	        if (this._length === 1) {
	            this._front = null;
	            this._back = null;
	        }
	        else {
	            this._front = node.next;
	            node.next = null;
	        }
	        this._length--;
	        return node.value;
	    };
	    /**
	     * Remove all values from the queue.
	     *
	     * #### Complexity
	     * Linear.
	     *
	     * #### Iterator Validity
	     * All current iterators are invalidated.
	     */
	    Queue.prototype.clear = function () {
	        var node = this._front;
	        while (node) {
	            var next = node.next;
	            node.next = null;
	            node = next;
	        }
	        this._length = 0;
	        this._front = null;
	        this._back = null;
	    };
	    /**
	     * Swap the contents of the queue with the contents of another.
	     *
	     * @param other - The other queue holding the contents to swap.
	     *
	     * #### Complexity
	     * Constant.
	     *
	     * #### Iterator Validity
	     * All current iterators remain valid, but will now point to the
	     * contents of the other queue involved in the swap.
	     */
	    Queue.prototype.swap = function (other) {
	        var length = other._length;
	        var front = other._front;
	        var back = other._back;
	        other._length = this._length;
	        other._front = this._front;
	        other._back = this._back;
	        this._length = length;
	        this._front = front;
	        this._back = back;
	    };
	    return Queue;
	}());
	exports.Queue = Queue;
	/**
	 * An iterator for a queue.
	 */
	var QueueIterator = (function () {
	    /**
	     * Construct a new queue iterator.
	     *
	     * @param node - The node at the front of range.
	     */
	    function QueueIterator(node) {
	        this._node = node;
	    }
	    /**
	     * Create an iterator over the object's values.
	     *
	     * @returns A reference to `this` iterator.
	     */
	    QueueIterator.prototype.iter = function () {
	        return this;
	    };
	    /**
	     * Create an independent clone of the queue iterator.
	     *
	     * @returns A new iterator starting with the current value.
	     */
	    QueueIterator.prototype.clone = function () {
	        return new QueueIterator(this._node);
	    };
	    /**
	     * Get the next value from the queue.
	     *
	     * @returns The next value from the queue, or `undefined` if the
	     *   iterator is exhausted.
	     */
	    QueueIterator.prototype.next = function () {
	        if (!this._node) {
	            return void 0;
	        }
	        var value = this._node.value;
	        this._node = this._node.next;
	        return value;
	    };
	    return QueueIterator;
	}());
	/**
	 * The node type for a queue.
	 */
	var QueueNode = (function () {
	    /**
	     * Construct a new queue node.
	     *
	     * @param value - The value for the node.
	     */
	    function QueueNode(value) {
	        /**
	         * The next node the queue.
	         */
	        this.next = null;
	        this.value = value;
	    }
	    return QueueNode;
	}());


/***/ },
/* 58 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * A class which attaches a value to an external object.
	 *
	 * #### Notes
	 * Attached properties are used to extend the state of an object with
	 * semantic data from an unrelated class. They also encapsulate value
	 * creation, coercion, and notification.
	 *
	 * Because attached property values are stored in a hash table, which
	 * in turn is stored in a WeakMap keyed on the owner object, there is
	 * non-trivial storage overhead involved in their use. The pattern is
	 * therefore best used for the storage of rare data.
	 */
	var AttachedProperty = (function () {
	    /**
	     * Construct a new attached property.
	     *
	     * @param options - The options for initializing the property.
	     */
	    function AttachedProperty(options) {
	        this._pid = nextPID();
	        this._name = options.name;
	        this._value = options.value;
	        this._create = options.create;
	        this._coerce = options.coerce;
	        this._compare = options.compare;
	        this._changed = options.changed;
	    }
	    Object.defineProperty(AttachedProperty.prototype, "name", {
	        /**
	         * Get the human readable name for the property.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._name;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the current value of the property for a given owner.
	     *
	     * @param owner - The property owner of interest.
	     *
	     * @returns The current value of the property.
	     *
	     * #### Notes
	     * If the value has not yet been set, the default value will be
	     * computed and assigned as the current value of the property.
	     */
	    AttachedProperty.prototype.get = function (owner) {
	        var value;
	        var map = ensureMap(owner);
	        if (this._pid in map) {
	            value = map[this._pid];
	        }
	        else {
	            value = map[this._pid] = this._createValue(owner);
	        }
	        return value;
	    };
	    /**
	     * Set the current value of the property for a given owner.
	     *
	     * @param owner - The property owner of interest.
	     *
	     * @param value - The value for the property.
	     *
	     * #### Notes
	     * If the value has not yet been set, the default value will be
	     * computed and used as the previous value for the comparison.
	     */
	    AttachedProperty.prototype.set = function (owner, value) {
	        var oldValue;
	        var map = ensureMap(owner);
	        if (this._pid in map) {
	            oldValue = map[this._pid];
	        }
	        else {
	            oldValue = map[this._pid] = this._createValue(owner);
	        }
	        var newValue = this._coerceValue(owner, value);
	        this._maybeNotify(owner, oldValue, map[this._pid] = newValue);
	    };
	    /**
	     * Explicitly coerce the current property value for a given owner.
	     *
	     * @param owner - The property owner of interest.
	     *
	     * #### Notes
	     * If the value has not yet been set, the default value will be
	     * computed and used as the previous value for the comparison.
	     */
	    AttachedProperty.prototype.coerce = function (owner) {
	        var oldValue;
	        var map = ensureMap(owner);
	        if (this._pid in map) {
	            oldValue = map[this._pid];
	        }
	        else {
	            oldValue = map[this._pid] = this._createValue(owner);
	        }
	        var newValue = this._coerceValue(owner, oldValue);
	        this._maybeNotify(owner, oldValue, map[this._pid] = newValue);
	    };
	    /**
	     * Get or create the default value for the given owner.
	     */
	    AttachedProperty.prototype._createValue = function (owner) {
	        var create = this._create;
	        return create ? create(owner) : this._value;
	    };
	    /**
	     * Coerce the value for the given owner.
	     */
	    AttachedProperty.prototype._coerceValue = function (owner, value) {
	        var coerce = this._coerce;
	        return coerce ? coerce(owner, value) : value;
	    };
	    /**
	     * Compare the old value and new value for equality.
	     */
	    AttachedProperty.prototype._compareValue = function (oldValue, newValue) {
	        var compare = this._compare;
	        return compare ? compare(oldValue, newValue) : oldValue === newValue;
	    };
	    /**
	     * Run the change notification if the given values are different.
	     */
	    AttachedProperty.prototype._maybeNotify = function (owner, oldValue, newValue) {
	        if (!this._changed || this._compareValue(oldValue, newValue)) {
	            return;
	        }
	        this._changed.call(void 0, owner, oldValue, newValue);
	    };
	    return AttachedProperty;
	}());
	exports.AttachedProperty = AttachedProperty;
	/**
	 * Clear the stored property data for the given property owner.
	 *
	 * @param owner - The property owner of interest.
	 *
	 * #### Notes
	 * This will clear all property values for the owner, but it will
	 * **not** run the change notification for any of the properties.
	 */
	function clearPropertyData(owner) {
	    ownerData.delete(owner);
	}
	exports.clearPropertyData = clearPropertyData;
	/**
	 * A weak mapping of property owner to property map.
	 */
	var ownerData = new WeakMap();
	/**
	 * A function which computes successive unique property ids.
	 */
	var nextPID = (function () {
	    var id = 0;
	    return function () {
	        var rand = Math.random();
	        var stem = ("" + rand).slice(2);
	        return "pid-" + stem + "-" + id++;
	    };
	})();
	/**
	 * Lookup the data map for the property owner.
	 *
	 * This will create the map if one does not already exist.
	 */
	function ensureMap(owner) {
	    var map = ownerData.get(owner);
	    if (map !== void 0)
	        return map;
	    map = Object.create(null);
	    ownerData.set(owner, map);
	    return map;
	}


/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var signaling_1 = __webpack_require__(20);
	/**
	 * An object which holds data related to a widget's title.
	 *
	 * #### Notes
	 * A title object is intended to hold the data necessary to display a
	 * header for a particular widget. A common example is the `TabPanel`,
	 * which uses the widget title to populate the tab for a child widget.
	 */
	var Title = (function () {
	    /**
	     * Construct a new title.
	     *
	     * @param options - The options for initializing the title.
	     */
	    function Title(options) {
	        if (options === void 0) { options = {}; }
	        this._label = '';
	        this._icon = '';
	        this._caption = '';
	        this._mnemonic = -1;
	        this._className = '';
	        this._closable = false;
	        this._owner = null;
	        if (options.owner !== void 0) {
	            this._owner = options.owner;
	        }
	        if (options.label !== void 0) {
	            this._label = options.label;
	        }
	        if (options.mnemonic !== void 0) {
	            this._mnemonic = options.mnemonic;
	        }
	        if (options.icon !== void 0) {
	            this._icon = options.icon;
	        }
	        if (options.caption !== void 0) {
	            this._caption = options.caption;
	        }
	        if (options.closable !== void 0) {
	            this._closable = options.closable;
	        }
	        if (options.className !== void 0) {
	            this._className = options.className;
	        }
	    }
	    Object.defineProperty(Title.prototype, "owner", {
	        /**
	         * Get the object which owns the title.
	         *
	         * #### Notes
	         * This will be `null` if the title has no owner.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._owner;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "label", {
	        /**
	         * Get the label for the title.
	         *
	         * #### Notes
	         * The default value is an empty string.
	         */
	        get: function () {
	            return this._label;
	        },
	        /**
	         * Set the label for the title.
	         */
	        set: function (value) {
	            if (this._label === value) {
	                return;
	            }
	            this._label = value;
	            this.changed.emit(void 0);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "mnemonic", {
	        /**
	         * Get the mnemonic index for the title.
	         *
	         * #### Notes
	         * The default value is `-1`.
	         */
	        get: function () {
	            return this._mnemonic;
	        },
	        /**
	         * Set the mnemonic index for the title.
	         */
	        set: function (value) {
	            if (this._mnemonic === value) {
	                return;
	            }
	            this._mnemonic = value;
	            this.changed.emit(void 0);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "icon", {
	        /**
	         * Get the icon class name for the title.
	         *
	         * #### Notes
	         * The default value is an empty string.
	         */
	        get: function () {
	            return this._icon;
	        },
	        /**
	         * Set the icon class name for the title.
	         *
	         * #### Notes
	         * Multiple class names can be separated with whitespace.
	         */
	        set: function (value) {
	            if (this._icon === value) {
	                return;
	            }
	            this._icon = value;
	            this.changed.emit(void 0);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "caption", {
	        /**
	         * Get the caption for the title.
	         *
	         * #### Notes
	         * The default value is an empty string.
	         */
	        get: function () {
	            return this._caption;
	        },
	        /**
	         * Set the caption for the title.
	         */
	        set: function (value) {
	            if (this._caption === value) {
	                return;
	            }
	            this._caption = value;
	            this.changed.emit(void 0);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "className", {
	        /**
	         * Get the extra class name for the title.
	         *
	         * #### Notes
	         * The default value is an empty string.
	         */
	        get: function () {
	            return this._className;
	        },
	        /**
	         * Set the extra class name for the title.
	         *
	         * #### Notes
	         * Multiple class names can be separated with whitespace.
	         */
	        set: function (value) {
	            if (this._className === value) {
	                return;
	            }
	            this._className = value;
	            this.changed.emit(void 0);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "closable", {
	        /**
	         * Get the closable state for the title.
	         *
	         * #### Notes
	         * The default value is `false`.
	         */
	        get: function () {
	            return this._closable;
	        },
	        /**
	         * Set the closable state for the title.
	         *
	         * #### Notes
	         * This controls the presence of a close icon when applicable.
	         */
	        set: function (value) {
	            if (this._closable === value) {
	                return;
	            }
	            this._closable = value;
	            this.changed.emit(void 0);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return Title;
	}());
	exports.Title = Title;
	// Define the signals for the `Title` class.
	signaling_1.defineSignal(Title.prototype, 'changed');


/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var iteration_1 = __webpack_require__(26);
	var searching_1 = __webpack_require__(27);
	var vector_1 = __webpack_require__(29);
	var signaling_1 = __webpack_require__(20);
	var boxpanel_1 = __webpack_require__(61);
	var dockpanel_1 = __webpack_require__(66);
	var panel_1 = __webpack_require__(65);
	var splitpanel_1 = __webpack_require__(74);
	var stackedpanel_1 = __webpack_require__(75);
	var tabbar_1 = __webpack_require__(72);
	var widget_1 = __webpack_require__(55);
	/**
	 * The class name added to AppShell instances.
	 */
	var APPLICATION_SHELL_CLASS = 'jp-ApplicationShell';
	/**
	 * The class name added to side bar instances.
	 */
	var SIDEBAR_CLASS = 'jp-SideBar';
	/**
	 * The class name added to the current widget's title.
	 */
	var CURRENT_CLASS = 'jp-mod-current';
	/**
	 * The application shell for JupyterLab.
	 */
	var ApplicationShell = (function (_super) {
	    __extends(ApplicationShell, _super);
	    /**
	     * Construct a new application shell.
	     */
	    function ApplicationShell() {
	        var _this = _super.call(this) || this;
	        _this.addClass(APPLICATION_SHELL_CLASS);
	        _this.id = 'main';
	        var topPanel = _this._topPanel = new panel_1.Panel();
	        var hboxPanel = _this._hboxPanel = new boxpanel_1.BoxPanel();
	        var dockPanel = _this._dockPanel = new dockpanel_1.DockPanel();
	        var hsplitPanel = _this._hsplitPanel = new splitpanel_1.SplitPanel();
	        var leftHandler = _this._leftHandler = new SideBarHandler('left');
	        var rightHandler = _this._rightHandler = new SideBarHandler('right');
	        var rootLayout = new boxpanel_1.BoxLayout();
	        topPanel.id = 'jp-top-panel';
	        hboxPanel.id = 'jp-main-content-panel';
	        dockPanel.id = 'jp-main-dock-panel';
	        hsplitPanel.id = 'jp-main-split-panel';
	        leftHandler.sideBar.addClass(SIDEBAR_CLASS);
	        leftHandler.sideBar.addClass('jp-mod-left');
	        leftHandler.stackedPanel.id = 'jp-left-stack';
	        rightHandler.sideBar.addClass(SIDEBAR_CLASS);
	        rightHandler.sideBar.addClass('jp-mod-right');
	        rightHandler.stackedPanel.id = 'jp-right-stack';
	        hboxPanel.spacing = 0;
	        dockPanel.spacing = 5;
	        hsplitPanel.spacing = 1;
	        hboxPanel.direction = 'left-to-right';
	        hsplitPanel.orientation = 'horizontal';
	        splitpanel_1.SplitPanel.setStretch(leftHandler.stackedPanel, 0);
	        splitpanel_1.SplitPanel.setStretch(dockPanel, 1);
	        splitpanel_1.SplitPanel.setStretch(rightHandler.stackedPanel, 0);
	        boxpanel_1.BoxPanel.setStretch(leftHandler.sideBar, 0);
	        boxpanel_1.BoxPanel.setStretch(hsplitPanel, 1);
	        boxpanel_1.BoxPanel.setStretch(rightHandler.sideBar, 0);
	        hsplitPanel.addWidget(leftHandler.stackedPanel);
	        hsplitPanel.addWidget(dockPanel);
	        hsplitPanel.addWidget(rightHandler.stackedPanel);
	        hboxPanel.addWidget(leftHandler.sideBar);
	        hboxPanel.addWidget(hsplitPanel);
	        hboxPanel.addWidget(rightHandler.sideBar);
	        rootLayout.direction = 'top-to-bottom';
	        rootLayout.spacing = 0; // TODO make this configurable?
	        boxpanel_1.BoxLayout.setStretch(topPanel, 0);
	        boxpanel_1.BoxLayout.setStretch(hboxPanel, 1);
	        rootLayout.addWidget(topPanel);
	        rootLayout.addWidget(hboxPanel);
	        _this.layout = rootLayout;
	        _this._dockPanel.currentChanged.connect(function (sender, args) {
	            if (args.newValue) {
	                args.newValue.title.className += " " + CURRENT_CLASS;
	            }
	            if (args.oldValue) {
	                var title = args.oldValue.title;
	                title.className = title.className.replace(CURRENT_CLASS, '');
	            }
	            _this.currentChanged.emit(args);
	        });
	        return _this;
	    }
	    Object.defineProperty(ApplicationShell.prototype, "currentWidget", {
	        /**
	         * The current widget in the shell's main area.
	         *
	         * #### Notes
	         * This property is read-only.
	         */
	        get: function () {
	            return this._dockPanel.currentWidget;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ApplicationShell.prototype, "mainAreaIsEmpty", {
	        /**
	         * True if main area is empty.
	         */
	        get: function () {
	            return this._dockPanel.isEmpty;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ApplicationShell.prototype, "topAreaIsEmpty", {
	        /**
	         * True if top area is empty.
	         */
	        get: function () {
	            return this._topPanel.widgets.length === 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ApplicationShell.prototype, "leftAreaIsEmpty", {
	        /**
	         * True if left area is empty.
	         */
	        get: function () {
	            return this._leftHandler.stackedPanel.widgets.length === 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ApplicationShell.prototype, "rightAreaIsEmpty", {
	        /**
	         * True if right area is empty.
	         */
	        get: function () {
	            return this._rightHandler.stackedPanel.widgets.length === 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Add a widget to the top content area.
	     *
	     * #### Notes
	     * Widgets must have a unique `id` property, which will be used as the DOM id.
	     */
	    ApplicationShell.prototype.addToTopArea = function (widget, options) {
	        if (options === void 0) { options = {}; }
	        if (!widget.id) {
	            console.error('widgets added to app shell must have unique id property');
	            return;
	        }
	        // Temporary: widgets are added to the panel in order of insertion.
	        this._topPanel.addWidget(widget);
	    };
	    /**
	     * Add a widget to the left content area.
	     *
	     * #### Notes
	     * Widgets must have a unique `id` property, which will be used as the DOM id.
	     */
	    ApplicationShell.prototype.addToLeftArea = function (widget, options) {
	        if (options === void 0) { options = {}; }
	        if (!widget.id) {
	            console.error('widgets added to app shell must have unique id property');
	            return;
	        }
	        var rank = 'rank' in options ? options.rank : 100;
	        this._leftHandler.addWidget(widget, rank);
	    };
	    /**
	     * Add a widget to the right content area.
	     *
	     * #### Notes
	     * Widgets must have a unique `id` property, which will be used as the DOM id.
	     */
	    ApplicationShell.prototype.addToRightArea = function (widget, options) {
	        if (options === void 0) { options = {}; }
	        if (!widget.id) {
	            console.error('widgets added to app shell must have unique id property');
	            return;
	        }
	        var rank = 'rank' in options ? options.rank : 100;
	        this._rightHandler.addWidget(widget, rank);
	    };
	    /**
	     * Add a widget to the main content area.
	     *
	     * #### Notes
	     * Widgets must have a unique `id` property, which will be used as the DOM id.
	     */
	    ApplicationShell.prototype.addToMainArea = function (widget) {
	        if (!widget.id) {
	            console.error('widgets added to app shell must have unique id property');
	            return;
	        }
	        this._dockPanel.addWidget(widget, { mode: 'tab-after' });
	    };
	    /**
	     * Activate a widget in the left area.
	     */
	    ApplicationShell.prototype.activateLeft = function (id) {
	        this._leftHandler.activate(id);
	    };
	    /**
	     * Activate a widget in the right area.
	     */
	    ApplicationShell.prototype.activateRight = function (id) {
	        this._rightHandler.activate(id);
	    };
	    /**
	     * Activate a widget in the main area.
	     */
	    ApplicationShell.prototype.activateMain = function (id) {
	        var dock = this._dockPanel;
	        var widget = searching_1.find(dock.widgets(), function (value) { return value.id === id; });
	        if (widget) {
	            dock.activateWidget(widget);
	        }
	    };
	    /**
	     * Collapse the left area.
	     */
	    ApplicationShell.prototype.collapseLeft = function () {
	        this._leftHandler.collapse();
	    };
	    /**
	     * Collapse the right area.
	     */
	    ApplicationShell.prototype.collapseRight = function () {
	        this._rightHandler.collapse();
	    };
	    /**
	     * Close all tracked widgets.
	     */
	    ApplicationShell.prototype.closeAll = function () {
	        iteration_1.each(iteration_1.toArray(this._dockPanel.widgets()), function (widget) { widget.close(); });
	    };
	    return ApplicationShell;
	}(widget_1.Widget));
	exports.ApplicationShell = ApplicationShell;
	// Define the signals for the `ApplicationShell` class.
	signaling_1.defineSignal(ApplicationShell.prototype, 'currentChanged');
	/**
	 * A class which manages a side bar and related stacked panel.
	 */
	var SideBarHandler = (function () {
	    /**
	     * Construct a new side bar handler.
	     */
	    function SideBarHandler(side) {
	        this._items = new vector_1.Vector();
	        this._side = side;
	        this._sideBar = new tabbar_1.TabBar({
	            insertBehavior: 'none',
	            removeBehavior: 'none',
	            allowDeselect: true
	        });
	        this._stackedPanel = new stackedpanel_1.StackedPanel();
	        this._sideBar.hide();
	        this._stackedPanel.hide();
	        this._sideBar.currentChanged.connect(this._onCurrentChanged, this);
	        this._stackedPanel.widgetRemoved.connect(this._onWidgetRemoved, this);
	    }
	    Object.defineProperty(SideBarHandler.prototype, "sideBar", {
	        /**
	         * Get the tab bar managed by the handler.
	         */
	        get: function () {
	            return this._sideBar;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SideBarHandler.prototype, "stackedPanel", {
	        /**
	         * Get the stacked panel managed by the handler
	         */
	        get: function () {
	            return this._stackedPanel;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Activate a widget residing in the side bar by ID.
	     *
	     * @param id - The widget's unique ID.
	     */
	    SideBarHandler.prototype.activate = function (id) {
	        var widget = this._findWidgetByID(id);
	        if (widget) {
	            this._sideBar.currentTitle = widget.title;
	            widget.activate();
	        }
	    };
	    /**
	     * Collapse the sidebar so no items are expanded.
	     */
	    SideBarHandler.prototype.collapse = function () {
	        this._sideBar.currentTitle = null;
	    };
	    /**
	     * Add a widget and its title to the stacked panel and side bar.
	     *
	     * If the widget is already added, it will be moved.
	     */
	    SideBarHandler.prototype.addWidget = function (widget, rank) {
	        widget.parent = null;
	        widget.hide();
	        var item = { widget: widget, rank: rank };
	        var index = this._findInsertIndex(item);
	        this._items.insert(index, item);
	        this._stackedPanel.insertWidget(index, widget);
	        this._sideBar.insertTab(index, widget.title);
	        this._refreshVisibility();
	    };
	    /**
	     * Find the insertion index for a rank item.
	     */
	    SideBarHandler.prototype._findInsertIndex = function (item) {
	        return searching_1.upperBound(this._items, item, Private.itemCmp);
	    };
	    /**
	     * Find the index of the item with the given widget, or `-1`.
	     */
	    SideBarHandler.prototype._findWidgetIndex = function (widget) {
	        return searching_1.findIndex(this._items, function (item) { return item.widget === widget; });
	    };
	    /**
	     * Find the widget which owns the given title, or `null`.
	     */
	    SideBarHandler.prototype._findWidgetByTitle = function (title) {
	        var item = searching_1.find(this._items, function (value) { return value.widget.title === title; });
	        return item ? item.widget : null;
	    };
	    /**
	     * Find the widget with the given id, or `null`.
	     */
	    SideBarHandler.prototype._findWidgetByID = function (id) {
	        var item = searching_1.find(this._items, function (value) { return value.widget.id === id; });
	        return item ? item.widget : null;
	    };
	    /**
	     * Refresh the visibility of the side bar and stacked panel.
	     */
	    SideBarHandler.prototype._refreshVisibility = function () {
	        this._sideBar.setHidden(this._sideBar.titles.length === 0);
	        this._stackedPanel.setHidden(this._sideBar.currentTitle === null);
	    };
	    /**
	     * Handle the `currentChanged` signal from the sidebar.
	     */
	    SideBarHandler.prototype._onCurrentChanged = function (sender, args) {
	        var oldWidget = this._findWidgetByTitle(args.previousTitle);
	        var newWidget = this._findWidgetByTitle(args.currentTitle);
	        if (oldWidget) {
	            oldWidget.hide();
	        }
	        if (newWidget) {
	            newWidget.show();
	        }
	        if (newWidget) {
	            document.body.setAttribute("data-" + this._side + "Area", newWidget.id);
	        }
	        else {
	            document.body.removeAttribute("data-" + this._side + "Area");
	        }
	        this._refreshVisibility();
	    };
	    /*
	     * Handle the `widgetRemoved` signal from the stacked panel.
	     */
	    SideBarHandler.prototype._onWidgetRemoved = function (sender, widget) {
	        this._items.removeAt(this._findWidgetIndex(widget));
	        this._sideBar.removeTab(widget.title);
	        this._refreshVisibility();
	    };
	    return SideBarHandler;
	}());
	var Private;
	(function (Private) {
	    /**
	     * A less-than comparison function for side bar rank items.
	     */
	    function itemCmp(first, second) {
	        return first.rank - second.rank;
	    }
	    Private.itemCmp = itemCmp;
	})(Private || (Private = {}));
	//# sourceMappingURL=shell.js.map

/***/ },
/* 61 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var mutation_1 = __webpack_require__(62);
	var vector_1 = __webpack_require__(29);
	var messaging_1 = __webpack_require__(56);
	var properties_1 = __webpack_require__(58);
	var platform_1 = __webpack_require__(52);
	var sizing_1 = __webpack_require__(63);
	var boxengine_1 = __webpack_require__(64);
	var panel_1 = __webpack_require__(65);
	var widget_1 = __webpack_require__(55);
	/**
	 * The class name added to BoxPanel instances.
	 */
	var BOX_PANEL_CLASS = 'p-BoxPanel';
	/**
	 * The class name added to a BoxPanel child.
	 */
	var CHILD_CLASS = 'p-BoxPanel-child';
	/**
	 * The class name added to left-to-right box layout parents.
	 */
	var LEFT_TO_RIGHT_CLASS = 'p-mod-left-to-right';
	/**
	 * The class name added to right-to-left box layout parents.
	 */
	var RIGHT_TO_LEFT_CLASS = 'p-mod-right-to-left';
	/**
	 * The class name added to top-to-bottom box layout parents.
	 */
	var TOP_TO_BOTTOM_CLASS = 'p-mod-top-to-bottom';
	/**
	 * The class name added to bottom-to-top box layout parents.
	 */
	var BOTTOM_TO_TOP_CLASS = 'p-mod-bottom-to-top';
	/**
	 * A panel which arranges its widgets in a single row or column.
	 *
	 * #### Notes
	 * This class provides a convenience wrapper around a [[BoxLayout]].
	 */
	var BoxPanel = (function (_super) {
	    __extends(BoxPanel, _super);
	    /**
	     * Construct a new box panel.
	     *
	     * @param options - The options for initializing the box panel.
	     */
	    function BoxPanel(options) {
	        if (options === void 0) { options = {}; }
	        _super.call(this, { layout: Private.createLayout(options) });
	        this.addClass(BOX_PANEL_CLASS);
	    }
	    Object.defineProperty(BoxPanel.prototype, "direction", {
	        /**
	         * Get the layout direction for the box panel.
	         */
	        get: function () {
	            return this.layout.direction;
	        },
	        /**
	         * Set the layout direction for the box panel.
	         */
	        set: function (value) {
	            this.layout.direction = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(BoxPanel.prototype, "spacing", {
	        /**
	         * Get the inter-element spacing for the box panel.
	         */
	        get: function () {
	            return this.layout.spacing;
	        },
	        /**
	         * Set the inter-element spacing for the box panel.
	         */
	        set: function (value) {
	            this.layout.spacing = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * A message handler invoked on a `'child-added'` message.
	     */
	    BoxPanel.prototype.onChildAdded = function (msg) {
	        msg.child.addClass(CHILD_CLASS);
	    };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     */
	    BoxPanel.prototype.onChildRemoved = function (msg) {
	        msg.child.removeClass(CHILD_CLASS);
	    };
	    return BoxPanel;
	}(panel_1.Panel));
	exports.BoxPanel = BoxPanel;
	/**
	 * The namespace for the `BoxPanel` class statics.
	 */
	var BoxPanel;
	(function (BoxPanel) {
	    /**
	     * Get the box panel stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The box panel stretch factor for the widget.
	     */
	    function getStretch(widget) {
	        return BoxLayout.getStretch(widget);
	    }
	    BoxPanel.getStretch = getStretch;
	    /**
	     * Set the box panel stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the stretch factor.
	     */
	    function setStretch(widget, value) {
	        BoxLayout.setStretch(widget, value);
	    }
	    BoxPanel.setStretch = setStretch;
	    /**
	     * Get the box panel size basis for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The box panel size basis for the widget.
	     */
	    function getSizeBasis(widget) {
	        return BoxLayout.getSizeBasis(widget);
	    }
	    BoxPanel.getSizeBasis = getSizeBasis;
	    /**
	     * Set the box panel size basis for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the size basis.
	     */
	    function setSizeBasis(widget, value) {
	        BoxLayout.setSizeBasis(widget, value);
	    }
	    BoxPanel.setSizeBasis = setSizeBasis;
	})(BoxPanel = exports.BoxPanel || (exports.BoxPanel = {}));
	/**
	 * A layout which arranges its widgets in a single row or column.
	 */
	var BoxLayout = (function (_super) {
	    __extends(BoxLayout, _super);
	    /**
	     * Construct a new box layout.
	     *
	     * @param options - The options for initializing the layout.
	     */
	    function BoxLayout(options) {
	        if (options === void 0) { options = {}; }
	        _super.call(this);
	        this._fixed = 0;
	        this._spacing = 4;
	        this._dirty = false;
	        this._box = null;
	        this._sizers = new vector_1.Vector();
	        this._direction = 'top-to-bottom';
	        if (options.direction !== void 0) {
	            this._direction = options.direction;
	        }
	        if (options.spacing !== void 0) {
	            this._spacing = Private.clampSpacing(options.spacing);
	        }
	    }
	    Object.defineProperty(BoxLayout.prototype, "direction", {
	        /**
	         * Get the layout direction for the box layout.
	         */
	        get: function () {
	            return this._direction;
	        },
	        /**
	         * Set the layout direction for the box layout.
	         */
	        set: function (value) {
	            if (this._direction === value) {
	                return;
	            }
	            this._direction = value;
	            if (!this.parent) {
	                return;
	            }
	            Private.toggleDirection(this.parent, value);
	            this.parent.fit();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(BoxLayout.prototype, "spacing", {
	        /**
	         * Get the inter-element spacing for the box layout.
	         */
	        get: function () {
	            return this._spacing;
	        },
	        /**
	         * Set the inter-element spacing for the box layout.
	         */
	        set: function (value) {
	            value = Private.clampSpacing(value);
	            if (this._spacing === value) {
	                return;
	            }
	            this._spacing = value;
	            if (!this.parent) {
	                return;
	            }
	            this.parent.fit();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Perform layout initialization which requires the parent widget.
	     */
	    BoxLayout.prototype.init = function () {
	        Private.toggleDirection(this.parent, this.direction);
	        _super.prototype.init.call(this);
	    };
	    /**
	     * Attach a widget to the parent's DOM node.
	     *
	     * @param index - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to attach to the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    BoxLayout.prototype.attachWidget = function (index, widget) {
	        // Create and add a new sizer for the widget.
	        this._sizers.insert(index, new boxengine_1.BoxSizer());
	        // Prepare the layout geometry for the widget.
	        widget_1.Widget.prepareGeometry(widget);
	        // Add the widget's node to the parent.
	        this.parent.node.appendChild(widget.node);
	        // Send an `'after-attach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.AfterAttach);
	        // Post a fit request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * Move a widget in the parent's DOM node.
	     *
	     * @param fromIndex - The previous index of the widget in the layout.
	     *
	     * @param toIndex - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to move in the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    BoxLayout.prototype.moveWidget = function (fromIndex, toIndex, widget) {
	        // Move the sizer for the widget.
	        mutation_1.move(this._sizers, fromIndex, toIndex);
	        // Post an update request for the parent widget.
	        this.parent.update();
	    };
	    /**
	     * Detach a widget from the parent's DOM node.
	     *
	     * @param index - The previous index of the widget in the layout.
	     *
	     * @param widget - The widget to detach from the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    BoxLayout.prototype.detachWidget = function (index, widget) {
	        // Remove the sizer for the widget.
	        this._sizers.removeAt(index);
	        // Send a `'before-detach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.BeforeDetach);
	        // Remove the widget's node from the parent.
	        this.parent.node.removeChild(widget.node);
	        // Reset the layout geometry for the widget.
	        widget_1.Widget.resetGeometry(widget);
	        // Post a fit request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     */
	    BoxLayout.prototype.onAfterShow = function (msg) {
	        _super.prototype.onAfterShow.call(this, msg);
	        this.parent.update();
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    BoxLayout.prototype.onAfterAttach = function (msg) {
	        _super.prototype.onAfterAttach.call(this, msg);
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on a `'child-shown'` message.
	     */
	    BoxLayout.prototype.onChildShown = function (msg) {
	        if (platform_1.IS_IE || platform_1.IS_EDGE) {
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'child-hidden'` message.
	     */
	    BoxLayout.prototype.onChildHidden = function (msg) {
	        if (platform_1.IS_IE || platform_1.IS_EDGE) {
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     */
	    BoxLayout.prototype.onResize = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(msg.width, msg.height);
	        }
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    BoxLayout.prototype.onUpdateRequest = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(-1, -1);
	        }
	    };
	    /**
	     * A message handler invoked on a `'fit-request'` message.
	     */
	    BoxLayout.prototype.onFitRequest = function (msg) {
	        if (this.parent.isAttached) {
	            this._fit();
	        }
	    };
	    /**
	     * Fit the layout to the total size required by the widgets.
	     */
	    BoxLayout.prototype._fit = function () {
	        // Compute the visible item count.
	        var nVisible = 0;
	        var widgets = this.widgets;
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            if (!widgets.at(i).isHidden)
	                nVisible++;
	        }
	        // Update the fixed space for the visible items.
	        this._fixed = this._spacing * Math.max(0, nVisible - 1);
	        // Setup the initial size limits.
	        var minW = 0;
	        var minH = 0;
	        var maxW = Infinity;
	        var maxH = Infinity;
	        var horz = Private.isHorizontal(this._direction);
	        if (horz) {
	            minW = this._fixed;
	            maxW = nVisible > 0 ? minW : maxW;
	        }
	        else {
	            minH = this._fixed;
	            maxH = nVisible > 0 ? minH : maxH;
	        }
	        // Update the sizers and computed size limits.
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            var widget = widgets.at(i);
	            var sizer = this._sizers.at(i);
	            if (widget.isHidden) {
	                sizer.minSize = 0;
	                sizer.maxSize = 0;
	                continue;
	            }
	            var limits = sizing_1.sizeLimits(widget.node);
	            sizer.sizeHint = BoxLayout.getSizeBasis(widget);
	            sizer.stretch = BoxLayout.getStretch(widget);
	            if (horz) {
	                sizer.minSize = limits.minWidth;
	                sizer.maxSize = limits.maxWidth;
	                minW += limits.minWidth;
	                maxW += limits.maxWidth;
	                minH = Math.max(minH, limits.minHeight);
	                maxH = Math.min(maxH, limits.maxHeight);
	            }
	            else {
	                sizer.minSize = limits.minHeight;
	                sizer.maxSize = limits.maxHeight;
	                minH += limits.minHeight;
	                maxH += limits.maxHeight;
	                minW = Math.max(minW, limits.minWidth);
	                maxW = Math.min(maxW, limits.maxWidth);
	            }
	        }
	        // Update the box sizing and add it to the size constraints.
	        var box = this._box = sizing_1.boxSizing(this.parent.node);
	        minW += box.horizontalSum;
	        minH += box.verticalSum;
	        maxW += box.horizontalSum;
	        maxH += box.verticalSum;
	        // Update the parent's size constraints.
	        var style = this.parent.node.style;
	        style.minWidth = minW + "px";
	        style.minHeight = minH + "px";
	        style.maxWidth = maxW === Infinity ? 'none' : maxW + "px";
	        style.maxHeight = maxH === Infinity ? 'none' : maxH + "px";
	        // Set the dirty flag to ensure only a single update occurs.
	        this._dirty = true;
	        // Notify the ancestor that it should fit immediately. This may
	        // cause a resize of the parent, fulfilling the required update.
	        var ancestor = this.parent.parent;
	        if (ancestor)
	            messaging_1.sendMessage(ancestor, widget_1.WidgetMessage.FitRequest);
	        // If the dirty flag is still set, the parent was not resized.
	        // Trigger the required update on the parent widget immediately.
	        if (this._dirty)
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.UpdateRequest);
	    };
	    /**
	     * Update the layout position and size of the widgets.
	     *
	     * The parent offset dimensions should be `-1` if unknown.
	     */
	    BoxLayout.prototype._update = function (offsetWidth, offsetHeight) {
	        // Clear the dirty flag to indicate the update occurred.
	        this._dirty = false;
	        // Bail early if there are no widgets to layout.
	        var widgets = this.widgets;
	        if (widgets.length === 0) {
	            return;
	        }
	        // Measure the parent if the offset dimensions are unknown.
	        if (offsetWidth < 0) {
	            offsetWidth = this.parent.node.offsetWidth;
	        }
	        if (offsetHeight < 0) {
	            offsetHeight = this.parent.node.offsetHeight;
	        }
	        // Ensure the parent box sizing data is computed.
	        var box = this._box || (this._box = sizing_1.boxSizing(this.parent.node));
	        // Compute the layout area adjusted for border and padding.
	        var top = box.paddingTop;
	        var left = box.paddingLeft;
	        var width = offsetWidth - box.horizontalSum;
	        var height = offsetHeight - box.verticalSum;
	        // Distribute the layout space and adjust the start position.
	        switch (this._direction) {
	            case 'left-to-right':
	                boxengine_1.boxCalc(this._sizers, Math.max(0, width - this._fixed));
	                break;
	            case 'top-to-bottom':
	                boxengine_1.boxCalc(this._sizers, Math.max(0, height - this._fixed));
	                break;
	            case 'right-to-left':
	                boxengine_1.boxCalc(this._sizers, Math.max(0, width - this._fixed));
	                left += width;
	                break;
	            case 'bottom-to-top':
	                boxengine_1.boxCalc(this._sizers, Math.max(0, height - this._fixed));
	                top += height;
	                break;
	        }
	        // Layout the widgets using the computed box sizes.
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            var widget = widgets.at(i);
	            if (widget.isHidden) {
	                continue;
	            }
	            var size = this._sizers.at(i).size;
	            switch (this._direction) {
	                case 'left-to-right':
	                    widget_1.Widget.setGeometry(widget, left, top, size, height);
	                    left += size + this._spacing;
	                    break;
	                case 'top-to-bottom':
	                    widget_1.Widget.setGeometry(widget, left, top, width, size);
	                    top += size + this._spacing;
	                    break;
	                case 'right-to-left':
	                    widget_1.Widget.setGeometry(widget, left - size, top, size, height);
	                    left -= size + this._spacing;
	                    break;
	                case 'bottom-to-top':
	                    widget_1.Widget.setGeometry(widget, left, top - size, width, size);
	                    top -= size + this._spacing;
	                    break;
	            }
	        }
	    };
	    return BoxLayout;
	}(panel_1.PanelLayout));
	exports.BoxLayout = BoxLayout;
	/**
	 * The namespace for the `BoxLayout` class statics.
	 */
	var BoxLayout;
	(function (BoxLayout) {
	    /**
	     * Get the box layout stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The box layout stretch factor for the widget.
	     */
	    function getStretch(widget) {
	        return Private.stretchProperty.get(widget);
	    }
	    BoxLayout.getStretch = getStretch;
	    /**
	     * Set the box layout stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the stretch factor.
	     */
	    function setStretch(widget, value) {
	        Private.stretchProperty.set(widget, value);
	    }
	    BoxLayout.setStretch = setStretch;
	    /**
	     * Get the box layout size basis for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The box layout size basis for the widget.
	     */
	    function getSizeBasis(widget) {
	        return Private.sizeBasisProperty.get(widget);
	    }
	    BoxLayout.getSizeBasis = getSizeBasis;
	    /**
	     * Set the box layout size basis for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the size basis.
	     */
	    function setSizeBasis(widget, value) {
	        Private.sizeBasisProperty.set(widget, value);
	    }
	    BoxLayout.setSizeBasis = setSizeBasis;
	})(BoxLayout = exports.BoxLayout || (exports.BoxLayout = {}));
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * The property descriptor for a widget stretch factor.
	     */
	    Private.stretchProperty = new properties_1.AttachedProperty({
	        name: 'stretch',
	        value: 0,
	        coerce: function (owner, value) { return Math.max(0, Math.floor(value)); },
	        changed: onChildPropertyChanged
	    });
	    /**
	     * The property descriptor for a widget size basis.
	     */
	    Private.sizeBasisProperty = new properties_1.AttachedProperty({
	        name: 'sizeBasis',
	        value: 0,
	        coerce: function (owner, value) { return Math.max(0, Math.floor(value)); },
	        changed: onChildPropertyChanged
	    });
	    /**
	     * Create a box layout for the given panel options.
	     */
	    function createLayout(options) {
	        return options.layout || new BoxLayout(options);
	    }
	    Private.createLayout = createLayout;
	    /**
	     * Test whether a direction has horizontal orientation.
	     */
	    function isHorizontal(dir) {
	        return dir === 'left-to-right' || dir === 'right-to-left';
	    }
	    Private.isHorizontal = isHorizontal;
	    /**
	     * Toggle the CSS direction class for the given widget.
	     */
	    function toggleDirection(widget, dir) {
	        widget.toggleClass(LEFT_TO_RIGHT_CLASS, dir === 'left-to-right');
	        widget.toggleClass(RIGHT_TO_LEFT_CLASS, dir === 'right-to-left');
	        widget.toggleClass(TOP_TO_BOTTOM_CLASS, dir === 'top-to-bottom');
	        widget.toggleClass(BOTTOM_TO_TOP_CLASS, dir === 'bottom-to-top');
	    }
	    Private.toggleDirection = toggleDirection;
	    /**
	     * Clamp a spacing value to an integer >= 0.
	     */
	    function clampSpacing(value) {
	        return Math.max(0, Math.floor(value));
	    }
	    Private.clampSpacing = clampSpacing;
	    /**
	     * The change handler for the attached child properties.
	     */
	    function onChildPropertyChanged(child) {
	        var parent = child.parent;
	        var layout = parent && parent.layout;
	        if (layout instanceof BoxLayout)
	            parent.fit();
	    }
	})(Private || (Private = {}));


/***/ },
/* 62 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var sequence_1 = __webpack_require__(28);
	/**
	 * Move an element in a sequence from one index to another.
	 *
	 * @param object - The sequence or array-like object to mutate.
	 *
	 * @param fromIndex - The index of the element to move.
	 *
	 * @param toIndex - The target index of the element.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Undefined Behavior
	 * A `fromIndex` which is non-integral or out of range.
	 *
	 * A `toIndex` which is non-integral or out of range.
	 *
	 * #### Example
	 * ```typescript
	 * import { move } from 'phosphor/lib/algorithm/mutation';
	 *
	 * let data = [0, 1, 2, 3, 4];
	 * move(data, 1, 2);  // [0, 2, 1, 3, 4]
	 * move(data, 4, 2);  // [0, 2, 4, 1, 3]
	 * ```
	 */
	function move(object, fromIndex, toIndex) {
	    if (object.length <= 1 || fromIndex === toIndex) {
	        return;
	    }
	    var d = fromIndex < toIndex ? 1 : -1;
	    var seq = sequence_1.asMutableSequence(object);
	    var value = seq.at(fromIndex);
	    for (var i = fromIndex; i !== toIndex; i += d) {
	        seq.set(i, seq.at(i + d));
	    }
	    seq.set(toIndex, value);
	}
	exports.move = move;
	/**
	 * Reverse a sequence in-place subject to an optional range.
	 *
	 * @param object - The sequence or array-like object to mutate.
	 *
	 * @param first - The index of the first element of the range. This
	 *   should be `<=` the `last` index. The default is `0`.
	 *
	 * @param last - The index of the last element of the range. This
	 *   should be `>=` the `first` index. The default is `length - 1`.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Undefined Behavior
	 * A `first` index which is non-integral or out of range.
	 *
	 * A `last` index which is non-integral or out of range.
	 *
	 * #### Example
	 * ```typescript
	 * import { reverse } from 'phosphor/lib/algorithm/mutation';
	 *
	 * let data = [0, 1, 2, 3, 4];
	 * reverse(data, 1, 3);  // [0, 3, 2, 1, 4]
	 * reverse(data, 3);     // [0, 3, 2, 4, 1]
	 * reverse(data);        // [1, 4, 2, 3, 0]
	 * ```
	 */
	function reverse(object, first, last) {
	    var length = object.length;
	    if (length <= 1) {
	        return;
	    }
	    if (first === void 0) {
	        first = 0;
	    }
	    if (last === void 0) {
	        last = length - 1;
	    }
	    if (first >= last) {
	        return;
	    }
	    var seq = sequence_1.asMutableSequence(object);
	    while (first < last) {
	        var front = seq.at(first);
	        var back = seq.at(last);
	        seq.set(first++, back);
	        seq.set(last--, front);
	    }
	}
	exports.reverse = reverse;
	/**
	 * Rotate the elements of a sequence by a positive or negative amount.
	 *
	 * @param object - The sequence or array-like object to mutate.
	 *
	 * @param delta - The amount of rotation to apply to the elements. A
	 *   positive value will rotate the elements to the left. A negative
	 *   value will rotate the elements to the right.
	 *
	 * #### Complexity
	 * Linear.
	 *
	 * #### Undefined Behavior
	 * A `delta` amount which is non-integral.
	 *
	 * #### Example
	 * ```typescript
	 * import { rotate } from 'phosphor/lib/algorithm/mutation';
	 *
	 * let data = [0, 1, 2, 3, 4];
	 * rotate(data, 2);   // [2, 3, 4, 0, 1]
	 * rotate(data, -2);  // [0, 1, 2, 3, 4]
	 * rotate(data, 10);  // [0, 1, 2, 3, 4]
	 * rotate(data, 9);   // [4, 0, 1, 2, 3]
	 * ```
	 */
	function rotate(object, delta) {
	    var length = object.length;
	    if (length <= 1) {
	        return;
	    }
	    if (delta > 0) {
	        delta = delta % length;
	    }
	    else if (delta < 0) {
	        delta = ((delta % length) + length) % length;
	    }
	    if (delta === 0) {
	        return;
	    }
	    var seq = sequence_1.asMutableSequence(object);
	    reverse(seq, 0, delta - 1);
	    reverse(seq, delta, length - 1);
	    reverse(seq, 0, length - 1);
	}
	exports.rotate = rotate;


/***/ },
/* 63 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * Compute the box sizing for a DOM node.
	 *
	 * @param node - The DOM node for which to compute the box sizing.
	 *
	 * @returns The box sizing data for the specified DOM node.
	 *
	 * #### Example
	 * ```typescript
	 * import { boxSizing } from 'phosphor/lib/dom/sizing';
	 *
	 * let div = document.createElement('div');
	 * div.style.borderTop = 'solid 10px black';
	 * document.body.appendChild(div);
	 *
	 * let sizing = boxSizing(div);
	 * sizing.borderTop;    // 10
	 * sizing.paddingLeft;  // 0
	 * // etc...
	 * ```
	 */
	function boxSizing(node) {
	    var cstyle = window.getComputedStyle(node);
	    var bt = parseInt(cstyle.borderTopWidth, 10) || 0;
	    var bl = parseInt(cstyle.borderLeftWidth, 10) || 0;
	    var br = parseInt(cstyle.borderRightWidth, 10) || 0;
	    var bb = parseInt(cstyle.borderBottomWidth, 10) || 0;
	    var pt = parseInt(cstyle.paddingTop, 10) || 0;
	    var pl = parseInt(cstyle.paddingLeft, 10) || 0;
	    var pr = parseInt(cstyle.paddingRight, 10) || 0;
	    var pb = parseInt(cstyle.paddingBottom, 10) || 0;
	    var hs = bl + pl + pr + br;
	    var vs = bt + pt + pb + bb;
	    return {
	        borderTop: bt,
	        borderLeft: bl,
	        borderRight: br,
	        borderBottom: bb,
	        paddingTop: pt,
	        paddingLeft: pl,
	        paddingRight: pr,
	        paddingBottom: pb,
	        horizontalSum: hs,
	        verticalSum: vs
	    };
	}
	exports.boxSizing = boxSizing;
	/**
	 * Compute the size limits for a DOM node.
	 *
	 * @param node - The node for which to compute the size limits.
	 *
	 * @returns The size limit data for the specified DOM node.
	 *
	 * #### Example
	 * ```typescript
	 * import { sizeLimits } from 'phosphor/lib/dom/sizing';
	 *
	 * let div = document.createElement('div');
	 * div.style.minWidth = '90px';
	 * document.body.appendChild(div);
	 *
	 * let limits = sizeLimits(div);
	 * limits.minWidth;   // 90
	 * limits.maxHeight;  // Infinity
	 * // etc...
	 * ```
	 */
	function sizeLimits(node) {
	    var cstyle = window.getComputedStyle(node);
	    return {
	        minWidth: parseInt(cstyle.minWidth, 10) || 0,
	        minHeight: parseInt(cstyle.minHeight, 10) || 0,
	        maxWidth: parseInt(cstyle.maxWidth, 10) || Infinity,
	        maxHeight: parseInt(cstyle.maxHeight, 10) || Infinity
	    };
	}
	exports.sizeLimits = sizeLimits;


/***/ },
/* 64 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var sequence_1 = __webpack_require__(28);
	/**
	 * A sizer object for use with the [[boxCalc]] function.
	 *
	 * #### Notes
	 * A box sizer holds the geometry information for an object along a
	 * layout orientation.
	 *
	 * For best performance, this class should be treated as a raw data
	 * struct. It should not typically be subclassed.
	 */
	var BoxSizer = (function () {
	    function BoxSizer() {
	        /**
	         * The preferred size for the sizer.
	         *
	         * #### Notes
	         * The sizer will be given this initial size subject to its size
	         * bounds. The sizer will not deviate from this size unless such
	         * deviation is required to fit into the available layout space.
	         *
	         * There is no limit to this value, but it will be clamped to the
	         * bounds defined by [[minSize]] and [[maxSize]].
	         *
	         * The default value is `0`.
	         */
	        this.sizeHint = 0;
	        /**
	         * The minimum size of the sizer.
	         *
	         * #### Notes
	         * The sizer will never be sized less than this value, even if
	         * it means the sizer will overflow the available layout space.
	         *
	         * It is assumed that this value lies in the range `[0, Infinity)`
	         * and that it is `<=` to [[maxSize]]. Failure to adhere to this
	         * constraint will yield undefined results.
	         *
	         * The default value is `0`.
	         */
	        this.minSize = 0;
	        /**
	         * The maximum size of the sizer.
	         *
	         * #### Notes
	         * The sizer will never be sized greater than this value, even if
	         * it means the sizer will underflow the available layout space.
	         *
	         * It is assumed that this value lies in the range `[0, Infinity]`
	         * and that it is `>=` to [[minSize]]. Failure to adhere to this
	         * constraint will yield undefined results.
	         *
	         * The default value is `Infinity`.
	         */
	        this.maxSize = Infinity;
	        /**
	         * The stretch factor for the sizer.
	         *
	         * #### Notes
	         * This controls how much the sizer stretches relative to its sibling
	         * sizers when layout space is distributed. A stretch factor of zero
	         * is special and will cause the sizer to only be resized after all
	         * other sizers with a stretch factor greater than zero have been
	         * resized to their limits.
	         *
	         * It is assumed that this value is an integer that lies in the range
	         * `[0, Infinity)`. Failure to adhere to this constraint will yield
	         * undefined results.
	         *
	         * The default value is `1`.
	         */
	        this.stretch = 1;
	        /**
	         * The computed size of the sizer.
	         *
	         * #### Notes
	         * This value is the output of a call to [[boxCalc]]. It represents
	         * the computed size for the object along the layout orientation,
	         * and will always lie in the range `[minSize, maxSize]`.
	         *
	         * This value is output only.
	         *
	         * Changing this value will have no effect.
	         */
	        this.size = 0;
	        /**
	         * An internal storage property for the layout algorithm.
	         *
	         * #### Notes
	         * This value is used as temporary storage by the layout algorithm.
	         *
	         * Changing this value will have no effect.
	         */
	        this.done = false;
	    }
	    return BoxSizer;
	}());
	exports.BoxSizer = BoxSizer;
	/**
	 * Compute the optimal layout sizes for a sequence of box sizers.
	 *
	 * This distributes the available layout space among the box sizers
	 * according to the following algorithm:
	 *
	 * 1. Initialize the sizers's size to its size hint and compute the
	 *    sums for each of size hint, min size, and max size.
	 *
	 * 2. If the total size hint equals the available space, return.
	 *
	 * 3. If the available space is less than the total min size, set all
	 *    sizers to their min size and return.
	 *
	 * 4. If the available space is greater than the total max size, set
	 *    all sizers to their max size and return.
	 *
	 * 5. If the layout space is less than the total size hint, distribute
	 *    the negative delta as follows:
	 *
	 *    a. Shrink each sizer with a stretch factor greater than zero by
	 *       an amount proportional to the negative space and the sum of
	 *       stretch factors. If the sizer reaches its min size, remove
	 *       it and its stretch factor from the computation.
	 *
	 *    b. If after adjusting all stretch sizers there remains negative
	 *       space, distribute the space equally among the sizers with a
	 *       stretch factor of zero. If a sizer reaches its min size,
	 *       remove it from the computation.
	 *
	 * 6. If the layout space is greater than the total size hint,
	 *    distribute the positive delta as follows:
	 *
	 *    a. Expand each sizer with a stretch factor greater than zero by
	 *       an amount proportional to the postive space and the sum of
	 *       stretch factors. If the sizer reaches its max size, remove
	 *       it and its stretch factor from the computation.
	 *
	 *    b. If after adjusting all stretch sizers there remains positive
	 *       space, distribute the space equally among the sizers with a
	 *       stretch factor of zero. If a sizer reaches its max size,
	 *       remove it from the computation.
	 *
	 * 7. return
	 *
	 * @param sizers - The sizers for a particular layout line.
	 *
	 * @param space - The available layout space for the sizers.
	 *
	 * #### Notes
	 * The [[size]] of each sizer is updated with the computed size.
	 *
	 * This function can be called at any time to recompute the layout for
	 * an existing sequence of sizers. The previously computed results will
	 * have no effect on the new output. It is therefore not necessary to
	 * create new sizer objects on each resize event.
	 */
	function boxCalc(object, space) {
	    // Bail early if there is nothing to do.
	    var count = object.length;
	    if (count === 0) {
	        return;
	    }
	    // Cast the object to a sequence of sizers.
	    var sizers = sequence_1.asSequence(object);
	    // Setup the size and stretch counters.
	    var totalMin = 0;
	    var totalMax = 0;
	    var totalSize = 0;
	    var totalStretch = 0;
	    var stretchCount = 0;
	    // Setup the sizers and compute the totals.
	    for (var i = 0; i < count; ++i) {
	        var sizer = sizers.at(i);
	        var min = sizer.minSize;
	        var max = sizer.maxSize;
	        var hint = sizer.sizeHint;
	        sizer.done = false;
	        sizer.size = Math.max(min, Math.min(hint, max));
	        totalSize += sizer.size;
	        totalMin += min;
	        totalMax += max;
	        if (sizer.stretch > 0) {
	            totalStretch += sizer.stretch;
	            stretchCount++;
	        }
	    }
	    // If the space is equal to the total size, return.
	    if (space === totalSize) {
	        return;
	    }
	    // If the space is less than the total min, minimize each sizer.
	    if (space <= totalMin) {
	        for (var i = 0; i < count; ++i) {
	            var sizer = sizers.at(i);
	            sizer.size = sizer.minSize;
	        }
	        return;
	    }
	    // If the space is greater than the total max, maximize each sizer.
	    if (space >= totalMax) {
	        for (var i = 0; i < count; ++i) {
	            var sizer = sizers.at(i);
	            sizer.size = sizer.maxSize;
	        }
	        return;
	    }
	    // The loops below perform sub-pixel precision sizing. A near zero
	    // value is used for compares instead of zero to ensure that the
	    // loop terminates when the subdivided space is reasonably small.
	    var nearZero = 0.01;
	    // A counter which is decremented each time a sizer is resized to
	    // its limit. This ensures the loops terminate even if there is
	    // space remaining to distribute.
	    var notDoneCount = count;
	    // Distribute negative delta space.
	    if (space < totalSize) {
	        // Shrink each stretchable sizer by an amount proportional to its
	        // stretch factor. If a sizer reaches its min size it's marked as
	        // done. The loop progresses in phases where each sizer is given
	        // a chance to consume its fair share for the pass, regardless of
	        // whether a sizer before it reached its limit. This continues
	        // until the stretchable sizers or the free space is exhausted.
	        var freeSpace = totalSize - space;
	        while (stretchCount > 0 && freeSpace > nearZero) {
	            var distSpace = freeSpace;
	            var distStretch = totalStretch;
	            for (var i = 0; i < count; ++i) {
	                var sizer = sizers.at(i);
	                if (sizer.done || sizer.stretch === 0) {
	                    continue;
	                }
	                var amt = sizer.stretch * distSpace / distStretch;
	                if (sizer.size - amt <= sizer.minSize) {
	                    freeSpace -= sizer.size - sizer.minSize;
	                    totalStretch -= sizer.stretch;
	                    sizer.size = sizer.minSize;
	                    sizer.done = true;
	                    notDoneCount--;
	                    stretchCount--;
	                }
	                else {
	                    freeSpace -= amt;
	                    sizer.size -= amt;
	                }
	            }
	        }
	        // Distribute any remaining space evenly among the non-stretchable
	        // sizers. This progresses in phases in the same manner as above.
	        while (notDoneCount > 0 && freeSpace > nearZero) {
	            var amt = freeSpace / notDoneCount;
	            for (var i = 0; i < count; ++i) {
	                var sizer = sizers.at(i);
	                if (sizer.done) {
	                    continue;
	                }
	                if (sizer.size - amt <= sizer.minSize) {
	                    freeSpace -= sizer.size - sizer.minSize;
	                    sizer.size = sizer.minSize;
	                    sizer.done = true;
	                    notDoneCount--;
	                }
	                else {
	                    freeSpace -= amt;
	                    sizer.size -= amt;
	                }
	            }
	        }
	    }
	    else {
	        // Expand each stretchable sizer by an amount proportional to its
	        // stretch factor. If a sizer reaches its max size it's marked as
	        // done. The loop progresses in phases where each sizer is given
	        // a chance to consume its fair share for the pass, regardless of
	        // whether a sizer before it reached its limit. This continues
	        // until the stretchable sizers or the free space is exhausted.
	        var freeSpace = space - totalSize;
	        while (stretchCount > 0 && freeSpace > nearZero) {
	            var distSpace = freeSpace;
	            var distStretch = totalStretch;
	            for (var i = 0; i < count; ++i) {
	                var sizer = sizers.at(i);
	                if (sizer.done || sizer.stretch === 0) {
	                    continue;
	                }
	                var amt = sizer.stretch * distSpace / distStretch;
	                if (sizer.size + amt >= sizer.maxSize) {
	                    freeSpace -= sizer.maxSize - sizer.size;
	                    totalStretch -= sizer.stretch;
	                    sizer.size = sizer.maxSize;
	                    sizer.done = true;
	                    notDoneCount--;
	                    stretchCount--;
	                }
	                else {
	                    freeSpace -= amt;
	                    sizer.size += amt;
	                }
	            }
	        }
	        // Distribute any remaining space evenly among the non-stretchable
	        // sizers. This progresses in phases in the same manner as above.
	        while (notDoneCount > 0 && freeSpace > nearZero) {
	            var amt = freeSpace / notDoneCount;
	            for (var i = 0; i < count; ++i) {
	                var sizer = sizers.at(i);
	                if (sizer.done) {
	                    continue;
	                }
	                if (sizer.size + amt >= sizer.maxSize) {
	                    freeSpace -= sizer.maxSize - sizer.size;
	                    sizer.size = sizer.maxSize;
	                    sizer.done = true;
	                    notDoneCount--;
	                }
	                else {
	                    freeSpace -= amt;
	                    sizer.size += amt;
	                }
	            }
	        }
	    }
	}
	exports.boxCalc = boxCalc;
	/**
	 * Adjust a sizer by a delta and adjust its neighbors accordingly.
	 *
	 * @param object - The sizers which should be adjusted.
	 *
	 * @param index - The index of the sizer to grow.
	 *
	 * @param delta - The amount to adjust the sizer, positive or negative.
	 *
	 * #### Notes
	 * This will adjust the indicated sizer by the specified amount, along
	 * with the sizes of the appropriate neighbors, subject to the limits
	 * specified by each of the sizers.
	 *
	 * This is useful when implementing box layouts where the boundaries
	 * between the sizers are interactively adjustable by the user.
	 */
	function adjustSizer(object, index, delta) {
	    // Bail early when there is nothing to do.
	    if (object.length === 0 || delta === 0) {
	        return;
	    }
	    // Dispatch to the proper implementation.
	    if (delta > 0) {
	        Private.growSizer(object, index, delta);
	    }
	    else {
	        Private.shrinkSizer(object, index, -delta);
	    }
	}
	exports.adjustSizer = adjustSizer;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Grow a sizer by a positive delta and adjust neighbors.
	     */
	    function growSizer(object, index, delta) {
	        // Cast the object to a sequence of sizers.
	        var sizers = sequence_1.asSequence(object);
	        // Compute how much the items to the left can expand.
	        var growLimit = 0;
	        for (var i = 0; i <= index; ++i) {
	            var sizer = sizers.at(i);
	            growLimit += sizer.maxSize - sizer.size;
	        }
	        // Compute how much the items to the right can shrink.
	        var shrinkLimit = 0;
	        for (var i = index + 1, n = sizers.length; i < n; ++i) {
	            var sizer = sizers.at(i);
	            shrinkLimit += sizer.size - sizer.minSize;
	        }
	        // Clamp the delta adjustment to the limits.
	        delta = Math.min(delta, growLimit, shrinkLimit);
	        // Grow the sizers to the left by the delta.
	        var grow = delta;
	        for (var i = index; i >= 0 && grow > 0; --i) {
	            var sizer = sizers.at(i);
	            var limit = sizer.maxSize - sizer.size;
	            if (limit >= grow) {
	                sizer.sizeHint = sizer.size + grow;
	                grow = 0;
	            }
	            else {
	                sizer.sizeHint = sizer.size + limit;
	                grow -= limit;
	            }
	        }
	        // Shrink the sizers to the right by the delta.
	        var shrink = delta;
	        for (var i = index + 1, n = sizers.length; i < n && shrink > 0; ++i) {
	            var sizer = sizers.at(i);
	            var limit = sizer.size - sizer.minSize;
	            if (limit >= shrink) {
	                sizer.sizeHint = sizer.size - shrink;
	                shrink = 0;
	            }
	            else {
	                sizer.sizeHint = sizer.size - limit;
	                shrink -= limit;
	            }
	        }
	    }
	    Private.growSizer = growSizer;
	    /**
	     * Shrink a sizer by a positive delta and adjust neighbors.
	     */
	    function shrinkSizer(object, index, delta) {
	        // Cast the object to a sequence of sizers.
	        var sizers = sequence_1.asSequence(object);
	        // Compute how much the items to the right can expand.
	        var growLimit = 0;
	        for (var i = index + 1, n = sizers.length; i < n; ++i) {
	            var sizer = sizers.at(i);
	            growLimit += sizer.maxSize - sizer.size;
	        }
	        // Compute how much the items to the left can shrink.
	        var shrinkLimit = 0;
	        for (var i = 0; i <= index; ++i) {
	            var sizer = sizers.at(i);
	            shrinkLimit += sizer.size - sizer.minSize;
	        }
	        // Clamp the delta adjustment to the limits.
	        delta = Math.min(delta, growLimit, shrinkLimit);
	        // Grow the sizers to the right by the delta.
	        var grow = delta;
	        for (var i = index + 1, n = sizers.length; i < n && grow > 0; ++i) {
	            var sizer = sizers.at(i);
	            var limit = sizer.maxSize - sizer.size;
	            if (limit >= grow) {
	                sizer.sizeHint = sizer.size + grow;
	                grow = 0;
	            }
	            else {
	                sizer.sizeHint = sizer.size + limit;
	                grow -= limit;
	            }
	        }
	        // Shrink the sizers to the left by the delta.
	        var shrink = delta;
	        for (var i = index; i >= 0 && shrink > 0; --i) {
	            var sizer = sizers.at(i);
	            var limit = sizer.size - sizer.minSize;
	            if (limit >= shrink) {
	                sizer.sizeHint = sizer.size - shrink;
	                shrink = 0;
	            }
	            else {
	                sizer.sizeHint = sizer.size - limit;
	                shrink -= limit;
	            }
	        }
	    }
	    Private.shrinkSizer = shrinkSizer;
	})(Private || (Private = {}));


/***/ },
/* 65 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(26);
	var mutation_1 = __webpack_require__(62);
	var searching_1 = __webpack_require__(27);
	var vector_1 = __webpack_require__(29);
	var messaging_1 = __webpack_require__(56);
	var widget_1 = __webpack_require__(55);
	/**
	 * The class name added to Panel instances.
	 */
	var PANEL_CLASS = 'p-Panel';
	/**
	 * A simple and convenient panel widget class.
	 *
	 * #### Notes
	 * This class is suitable as a base class for implementing a variety of
	 * convenience panel widgets, but can also be used directly with CSS to
	 * arrange a collection of widgets.
	 *
	 * This class provides a convenience wrapper around a [[PanelLayout]].
	 */
	var Panel = (function (_super) {
	    __extends(Panel, _super);
	    /**
	     * Construct a new panel.
	     *
	     * @param options - The options for initializing the panel.
	     */
	    function Panel(options) {
	        if (options === void 0) { options = {}; }
	        _super.call(this);
	        this.addClass(PANEL_CLASS);
	        this.layout = Private.createLayout(options);
	    }
	    Object.defineProperty(Panel.prototype, "widgets", {
	        /**
	         * A read-only sequence of the widgets in the panel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.layout.widgets;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Add a widget to the end of the panel.
	     *
	     * @param widget - The widget to add to the panel.
	     *
	     * #### Notes
	     * If the is already contained in the panel, it will be moved.
	     */
	    Panel.prototype.addWidget = function (widget) {
	        this.layout.addWidget(widget);
	    };
	    /**
	     * Insert a widget at the specified index.
	     *
	     * @param index - The index at which to insert the widget.
	     *
	     * @param widget - The widget to insert into to the panel.
	     *
	     * #### Notes
	     * If the widget is already contained in the panel, it will be moved.
	     */
	    Panel.prototype.insertWidget = function (index, widget) {
	        this.layout.insertWidget(index, widget);
	    };
	    return Panel;
	}(widget_1.Widget));
	exports.Panel = Panel;
	/**
	 * A concrete layout implementation suitable for many use cases.
	 *
	 * #### Notes
	 * This class is suitable as a base class for implementing a variety of
	 * layouts, but can also be used directly with standard CSS to layout a
	 * collection of widgets.
	 */
	var PanelLayout = (function (_super) {
	    __extends(PanelLayout, _super);
	    function PanelLayout() {
	        _super.apply(this, arguments);
	        this._widgets = new vector_1.Vector();
	    }
	    /**
	     * Dispose of the resources held by the layout.
	     *
	     * #### Notes
	     * This will clear and dispose all widgets in the layout.
	     *
	     * All reimplementations should call the superclass method.
	     *
	     * This method is called automatically when the parent is disposed.
	     */
	    PanelLayout.prototype.dispose = function () {
	        while (this._widgets.length > 0) {
	            this._widgets.popBack().dispose();
	        }
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(PanelLayout.prototype, "widgets", {
	        /**
	         * A read-only sequence of the widgets in the layout.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._widgets;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Create an iterator over the widgets in the layout.
	     *
	     * @returns A new iterator over the widgets in the layout.
	     */
	    PanelLayout.prototype.iter = function () {
	        return this._widgets.iter();
	    };
	    /**
	     * Add a widget to the end of the layout.
	     *
	     * @param widget - The widget to add to the layout.
	     *
	     * #### Notes
	     * If the widget is already contained in the layout, it will be moved.
	     */
	    PanelLayout.prototype.addWidget = function (widget) {
	        this.insertWidget(this._widgets.length, widget);
	    };
	    /**
	     * Insert a widget into the layout at the specified index.
	     *
	     * @param index - The index at which to insert the widget.
	     *
	     * @param widget - The widget to insert into the layout.
	     *
	     * #### Notes
	     * The index will be clamped to the bounds of the widgets.
	     *
	     * If the widget is already added to the layout, it will be moved.
	     */
	    PanelLayout.prototype.insertWidget = function (index, widget) {
	        // Remove the widget from its current parent. This is a no-op
	        // if the widget's parent is already the layout parent widget.
	        widget.parent = this.parent;
	        // Look up the current index of the widget.
	        var i = searching_1.indexOf(this._widgets, widget);
	        // Clamp the insert index to the vector bounds.
	        var j = Math.max(0, Math.min(Math.floor(index), this._widgets.length));
	        // If the widget is not in the vector, insert it.
	        if (i === -1) {
	            // Insert the widget into the vector.
	            this._widgets.insert(j, widget);
	            // If the layout is parented, attach the widget to the DOM.
	            if (this.parent)
	                this.attachWidget(j, widget);
	            // There is nothing more to do.
	            return;
	        }
	        // Otherwise, the widget exists in the vector and should be moved.
	        // Adjust the index if the location is at the end of the vector.
	        if (j === this._widgets.length)
	            j--;
	        // Bail if there is no effective move.
	        if (i === j)
	            return;
	        // Move the widget to the new location.
	        mutation_1.move(this._widgets, i, j);
	        // If the layout is parented, move the widget in the DOM.
	        if (this.parent)
	            this.moveWidget(i, j, widget);
	    };
	    /**
	     * Remove a widget from the layout.
	     *
	     * @param widget - The widget to remove from the layout.
	     *
	     * #### Notes
	     * A widget is automatically removed from the layout when its `parent`
	     * is set to `null`. This method should only be invoked directly when
	     * removing a widget from a layout which has yet to be installed on a
	     * parent widget.
	     *
	     * This method does *not* modify the widget's `parent`.
	     */
	    PanelLayout.prototype.removeWidget = function (widget) {
	        this.removeWidgetAt(searching_1.indexOf(this._widgets, widget));
	    };
	    /**
	     * Remove the widget at a given index from the layout.
	     *
	     * @param index - The index of the widget to remove.
	     *
	     * #### Notes
	     * A widget is automatically removed from the layout when its `parent`
	     * is set to `null`. This method should only be invoked directly when
	     * removing a widget from a layout which has yet to be installed on a
	     * parent widget.
	     *
	     * This method does *not* modify the widget's `parent`.
	     */
	    PanelLayout.prototype.removeWidgetAt = function (index) {
	        // Bail if the index is out of range.
	        var i = Math.floor(index);
	        if (i < 0 || i >= this._widgets.length) {
	            return;
	        }
	        // Remove the widget from the vector.
	        var widget = this._widgets.removeAt(i);
	        // If the layout is parented, detach the widget from the DOM.
	        if (this.parent)
	            this.detachWidget(i, widget);
	    };
	    /**
	     * Perform layout initialization which requires the parent widget.
	     */
	    PanelLayout.prototype.init = function () {
	        var _this = this;
	        _super.prototype.init.call(this);
	        var index = 0;
	        iteration_1.each(this, function (widget) { _this.attachWidget(index++, widget); });
	    };
	    /**
	     * Attach a widget to the parent's DOM node.
	     *
	     * @param index - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to attach to the parent.
	     *
	     * #### Notes
	     * This method is called automatically by the panel layout at the
	     * appropriate time. It should not be called directly by user code.
	     *
	     * The default implementation adds the widgets's node to the parent's
	     * node at the proper location, and sends an `'after-attach'` message
	     * to the widget if the parent is attached to the DOM.
	     *
	     * Subclasses may reimplement this method to control how the widget's
	     * node is added to the parent's node, but the reimplementation must
	     * send an `'after-attach'` message to the widget if the parent is
	     * attached to the DOM.
	     */
	    PanelLayout.prototype.attachWidget = function (index, widget) {
	        // Look up the next sibling reference node.
	        var ref = this.parent.node.children[index];
	        // Insert the widget's node before the sibling.
	        this.parent.node.insertBefore(widget.node, ref);
	        // Send an `'after-attach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.AfterAttach);
	    };
	    /**
	     * Move a widget in the parent's DOM node.
	     *
	     * @param fromIndex - The previous index of the widget in the layout.
	     *
	     * @param toIndex - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to move in the parent.
	     *
	     * #### Notes
	     * This method is called automatically by the panel layout at the
	     * appropriate time. It should not be called directly by user code.
	     *
	     * The default implementation moves the widget's node to the proper
	     * location in the parent's node and sends both a `'before-detach'`
	     * and an `'after-attach'` message to the widget if the parent is
	     * attached to the DOM.
	     *
	     * Subclasses may reimplement this method to control how the widget's
	     * node is moved in the parent's node, but the reimplementation must
	     * send both a `'before-detach'` and an `'after-attach'` message to
	     * the widget if the parent is attached to the DOM.
	     */
	    PanelLayout.prototype.moveWidget = function (fromIndex, toIndex, widget) {
	        // Send a `'before-detach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.BeforeDetach);
	        // Remove the widget's node from the parent.
	        this.parent.node.removeChild(widget.node);
	        // Look up the next sibling reference node.
	        var ref = this.parent.node.children[toIndex];
	        // Insert the widget's node before the sibling.
	        this.parent.node.insertBefore(widget.node, ref);
	        // Send an `'after-attach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.AfterAttach);
	    };
	    /**
	     * Detach a widget from the parent's DOM node.
	     *
	     * @param index - The previous index of the widget in the layout.
	     *
	     * @param widget - The widget to detach from the parent.
	     *
	     * #### Notes
	     * This method is called automatically by the panel layout at the
	     * appropriate time. It should not be called directly by user code.
	     *
	     * The default implementation removes the widget's node from the
	     * parent's node, and sends a `'before-detach'` message to the widget
	     * if the parent is attached to the DOM.
	     *
	     * Subclasses may reimplement this method to control how the widget's
	     * node is removed from the parent's node, but the reimplementation
	     * must send a `'before-detach'` message to the widget if the parent
	     * is attached to the DOM.
	     */
	    PanelLayout.prototype.detachWidget = function (index, widget) {
	        // Send a `'before-detach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.BeforeDetach);
	        // Remove the widget's node from the parent.
	        this.parent.node.removeChild(widget.node);
	    };
	    return PanelLayout;
	}(widget_1.Layout));
	exports.PanelLayout = PanelLayout;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create a panel layout for the given panel options.
	     */
	    function createLayout(options) {
	        return options.layout || new PanelLayout();
	    }
	    Private.createLayout = createLayout;
	})(Private || (Private = {}));


/***/ },
/* 66 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(26);
	var searching_1 = __webpack_require__(27);
	var vector_1 = __webpack_require__(29);
	var messaging_1 = __webpack_require__(56);
	var signaling_1 = __webpack_require__(20);
	var mimedata_1 = __webpack_require__(67);
	var cursor_1 = __webpack_require__(68);
	var dragdrop_1 = __webpack_require__(69);
	var platform_1 = __webpack_require__(52);
	var query_1 = __webpack_require__(70);
	var sizing_1 = __webpack_require__(63);
	var boxengine_1 = __webpack_require__(64);
	var focustracker_1 = __webpack_require__(71);
	var tabbar_1 = __webpack_require__(72);
	var widget_1 = __webpack_require__(55);
	/**
	 * The class name added to a DockPanel instance.
	 */
	var DOCK_PANEL_CLASS = 'p-DockPanel';
	/**
	 * The class name added to DockPanel widgets.
	 */
	var WIDGET_CLASS = 'p-DockPanel-widget';
	/**
	 * The class name added to a DockPanel tab bar.
	 */
	var TAB_BAR_CLASS = 'p-DockPanel-tabBar';
	/**
	 * The class name added to a DockPanel handle.
	 */
	var HANDLE_CLASS = 'p-DockPanel-handle';
	/**
	 * The class name added to a DockPanel overlay.
	 */
	var OVERLAY_CLASS = 'p-DockPanel-overlay';
	/**
	 * The class name added to hidden entities.
	 */
	var HIDDEN_CLASS = 'p-mod-hidden';
	/**
	 * The class name added to horizontal handles.
	 */
	var HORIZONTAL_CLASS = 'p-mod-horizontal';
	/**
	 * The class name added to vertical handles.
	 */
	var VERTICAL_CLASS = 'p-mod-vertical';
	/**
	 * The factory MIME type supported by the dock panel.
	 */
	var FACTORY_MIME = 'application/vnd.phosphor.widget-factory';
	/**
	 * A fraction used for sizing root panels; ~= `1 / golden_ratio`.
	 */
	var GOLDEN = 0.618;
	/**
	 * A widget which provides a flexible docking area for widgets.
	 */
	var DockPanel = (function (_super) {
	    __extends(DockPanel, _super);
	    /**
	     * Construct a new dock panel.
	     *
	     * @param options - The options for initializing the panel.
	     */
	    function DockPanel(options) {
	        var _this = this;
	        if (options === void 0) { options = {}; }
	        _super.call(this);
	        this._drag = null;
	        this._pressData = null;
	        this._tracker = new focustracker_1.FocusTracker();
	        this.addClass(DOCK_PANEL_CLASS);
	        // Extract the inter-panel spacing.
	        var spacing = options.spacing !== void 0 ? options.spacing : 4;
	        // Extract the content renderer for the panel.
	        this._renderer = options.renderer || DockPanel.defaultRenderer;
	        // Create the delegate renderer for the layout.
	        var renderer = {
	            createTabBar: function () { return _this._createTabBar(); },
	            createHandle: function () { return _this._createHandle(); }
	        };
	        // Setup the dock layout for the panel.
	        this.layout = new DockLayout({ renderer: renderer, spacing: spacing });
	        // Setup the overlay drop indicator.
	        this._overlay = options.overlay || new DockPanel.Overlay();
	        this._overlay.node.classList.add(OVERLAY_CLASS);
	        this.node.appendChild(this._overlay.node);
	        // Connect the focus tracker changed signal.
	        this._tracker.currentChanged.connect(this._onCurrentChanged, this);
	    }
	    /**
	     * Dispose of the resources held by the panel.
	     */
	    DockPanel.prototype.dispose = function () {
	        // Ensure the mouse is released.
	        this._releaseMouse();
	        // Hide the overlay.
	        this._overlay.hide(0);
	        // Cancel a drag if one is in progress.
	        if (this._drag) {
	            this._drag.dispose();
	        }
	        // Dispose of the focus tracker.
	        this._tracker.dispose();
	        // Dispose of the base class.
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(DockPanel.prototype, "currentWidget", {
	        /**
	         * The current widget in the dock panel.
	         *
	         * #### Notes
	         * The current widget is the widget among the added widgets which
	         * has the *descendant node* which has most recently been focused.
	         *
	         * This is the `currentWidget` of an internal `FocusTracker` which
	         * tracks all widgets in the dock panel.
	         *
	         * This will be `null` if there is no current widget.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._tracker.currentWidget;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DockPanel.prototype, "overlay", {
	        /**
	         * The overlay used by the dock panel.
	         */
	        get: function () {
	            return this._overlay;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DockPanel.prototype, "spacing", {
	        /**
	         * Get the spacing between the widgets.
	         */
	        get: function () {
	            return this.layout.spacing;
	        },
	        /**
	         * Set the spacing between the widgets.
	         */
	        set: function (value) {
	            this.layout.spacing = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DockPanel.prototype, "isEmpty", {
	        /**
	         * Whether the dock panel is empty.
	         */
	        get: function () {
	            return this.layout.isEmpty;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DockPanel.prototype, "renderer", {
	        /**
	         * The renderer used by the dock panel.
	         */
	        get: function () {
	            return this.layout.renderer;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Create an iterator over the user widgets in the panel.
	     *
	     * @returns A new iterator over the user widgets in the panel.
	     *
	     * #### Notes
	     * This iterator does not include the generated tab bars.
	     */
	    DockPanel.prototype.widgets = function () {
	        return this.layout.widgets();
	    };
	    /**
	     * Create an iterator over the tab bars in the panel.
	     *
	     * @returns A new iterator over the tab bars in the panel.
	     *
	     * #### Notes
	     * This iterator does not include the user widgets.
	     */
	    DockPanel.prototype.tabBars = function () {
	        return this.layout.tabBars();
	    };
	    /**
	     * Create an iterator over the handles in the panel.
	     *
	     * @returns A new iterator over the handles in the panel.
	     */
	    DockPanel.prototype.handles = function () {
	        return this.layout.handles();
	    };
	    /**
	     * Activate the specified widget in the dock panel.
	     *
	     * @param widget - The widget of interest.
	     *
	     * #### Notes
	     * This will make the widget the current widget in its tab area and
	     * post the widget an `activate-request` message.
	     */
	    DockPanel.prototype.activateWidget = function (widget) {
	        // Find the tab bar which contains the widget.
	        var title = widget.title;
	        var tabBar = searching_1.find(this.tabBars(), function (bar) { return searching_1.contains(bar.titles, title); });
	        // Throw an error if no tab bar is found.
	        if (!tabBar) {
	            throw new Error('Widget is not contained in the dock panel.');
	        }
	        // Update the current title and activate the widget.
	        tabBar.currentTitle = title;
	        widget.activate();
	    };
	    /**
	     * Add a widget to the dock panel.
	     *
	     * @param widget - The widget to add to the dock panel.
	     *
	     * @param options - The additional options for adding the widget.
	     */
	    DockPanel.prototype.addWidget = function (widget, options) {
	        if (options === void 0) { options = {}; }
	        // Add the widget to the layout.
	        this.layout.addWidget(widget, options);
	        // Add the widget to the focus tracker.
	        this._tracker.add(widget);
	    };
	    /**
	     * Handle the DOM events for the dock panel.
	     *
	     * @param event - The DOM event sent to the panel.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the panel's DOM node. It should
	     * not be called directly by user code.
	     */
	    DockPanel.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'p-dragenter':
	                this._evtDragEnter(event);
	                break;
	            case 'p-dragleave':
	                this._evtDragLeave(event);
	                break;
	            case 'p-dragover':
	                this._evtDragOver(event);
	                break;
	            case 'p-drop':
	                this._evtDrop(event);
	                break;
	            case 'mousedown':
	                this._evtMouseDown(event);
	                break;
	            case 'mousemove':
	                this._evtMouseMove(event);
	                break;
	            case 'mouseup':
	                this._evtMouseUp(event);
	                break;
	            case 'keydown':
	                this._evtKeyDown(event);
	                break;
	            case 'contextmenu':
	                event.preventDefault();
	                event.stopPropagation();
	                break;
	        }
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    DockPanel.prototype.onAfterAttach = function (msg) {
	        this.node.addEventListener('p-dragenter', this);
	        this.node.addEventListener('p-dragleave', this);
	        this.node.addEventListener('p-dragover', this);
	        this.node.addEventListener('p-drop', this);
	        this.node.addEventListener('mousedown', this);
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     */
	    DockPanel.prototype.onBeforeDetach = function (msg) {
	        this.node.removeEventListener('p-dragenter', this);
	        this.node.removeEventListener('p-dragleave', this);
	        this.node.removeEventListener('p-dragover', this);
	        this.node.removeEventListener('p-drop', this);
	        this.node.removeEventListener('mousedown', this);
	        this._releaseMouse();
	    };
	    /**
	     * A message handler invoked on a `'child-added'` message.
	     */
	    DockPanel.prototype.onChildAdded = function (msg) {
	        // Ignore the generated tab bars.
	        if (msg.child.hasClass(TAB_BAR_CLASS)) {
	            return;
	        }
	        // Add the widget class to the child.
	        msg.child.addClass(WIDGET_CLASS);
	    };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     */
	    DockPanel.prototype.onChildRemoved = function (msg) {
	        // Ignore the generated tab bars.
	        if (msg.child.hasClass(TAB_BAR_CLASS)) {
	            return;
	        }
	        // Remove the widget class from the child.
	        msg.child.removeClass(WIDGET_CLASS);
	        // Remove the widget from the focus tracker.
	        this._tracker.remove(msg.child);
	    };
	    /**
	     * Handle the `'p-dragenter'` event for the dock panel.
	     */
	    DockPanel.prototype._evtDragEnter = function (event) {
	        // If the factory mime type is present, mark the event as
	        // handled in order to get the rest of the drag events.
	        if (event.mimeData.hasData(FACTORY_MIME)) {
	            event.preventDefault();
	            event.stopPropagation();
	        }
	    };
	    /**
	     * Handle the `'p-dragleave'` event for the dock panel.
	     */
	    DockPanel.prototype._evtDragLeave = function (event) {
	        // Always mark the event as handled.
	        event.preventDefault();
	        event.stopPropagation();
	        // Get the node into which the drag is entering.
	        var related = event.relatedTarget;
	        // Hide the overlay if the drag is leaving the dock panel.
	        if (!related || !this.node.contains(related)) {
	            this._overlay.hide(0);
	        }
	    };
	    /**
	     * Handle the `'p-dragover'` event for the dock panel.
	     */
	    DockPanel.prototype._evtDragOver = function (event) {
	        // Always mark the event as handled.
	        event.preventDefault();
	        event.stopPropagation();
	        // Show the drop indicator overlay and update the drop
	        // action based on the drop target zone under the mouse.
	        var clientX = event.clientX, clientY = event.clientY, shiftKey = event.shiftKey;
	        if (this._showOverlay(clientX, clientY, shiftKey) === 'invalid') {
	            event.dropAction = 'none';
	        }
	        else {
	            event.dropAction = event.proposedAction;
	        }
	    };
	    /**
	     * Handle the `'p-drop'` event for the dock panel.
	     */
	    DockPanel.prototype._evtDrop = function (event) {
	        // Always mark the event as handled.
	        event.preventDefault();
	        event.stopPropagation();
	        // Hide the drop indicator overlay.
	        this._overlay.hide(0);
	        // Bail if the proposed action is to do nothing.
	        if (event.proposedAction === 'none') {
	            event.dropAction = 'none';
	            return;
	        }
	        // Find the drop target under the mouse.
	        var clientX = event.clientX, clientY = event.clientY, shiftKey = event.shiftKey;
	        var _a = this._findDropTarget(clientX, clientY, shiftKey), zone = _a.zone, target = _a.target;
	        // Bail if the drop zone is invalid.
	        if (zone === 'invalid') {
	            event.dropAction = 'none';
	            return;
	        }
	        // Bail if the factory mime type has invalid data.
	        var factory = event.mimeData.getData(FACTORY_MIME);
	        if (typeof factory !== 'function') {
	            event.dropAction = 'none';
	            return;
	        }
	        // Bail if the factory does not produce a widget.
	        var widget = factory();
	        if (!(widget instanceof widget_1.Widget)) {
	            event.dropAction = 'none';
	            return;
	        }
	        // Handle the drop using the generated widget.
	        switch (zone) {
	            case 'root':
	                this.addWidget(widget);
	                break;
	            case 'root-top':
	                this.addWidget(widget, { mode: 'split-top' });
	                break;
	            case 'root-left':
	                this.addWidget(widget, { mode: 'split-left' });
	                break;
	            case 'root-right':
	                this.addWidget(widget, { mode: 'split-right' });
	                break;
	            case 'root-bottom':
	                this.addWidget(widget, { mode: 'split-bottom' });
	                break;
	            case 'widget-top':
	                this.addWidget(widget, { mode: 'split-top', ref: target });
	                break;
	            case 'widget-left':
	                this.addWidget(widget, { mode: 'split-left', ref: target });
	                break;
	            case 'widget-right':
	                this.addWidget(widget, { mode: 'split-right', ref: target });
	                break;
	            case 'widget-bottom':
	                this.addWidget(widget, { mode: 'split-bottom', ref: target });
	                break;
	            case 'tab-bar':
	                var ref = Private.tabBarRef(target);
	                this.addWidget(widget, { mode: 'tab-after', ref: ref });
	                break;
	        }
	        // Accept the proposed drop action.
	        event.dropAction = event.proposedAction;
	        // Activate the dropped widget.
	        this.activateWidget(widget);
	    };
	    /**
	     * Handle the `'keydown'` event for the dock panel.
	     */
	    DockPanel.prototype._evtKeyDown = function (event) {
	        // Stop input events during drag.
	        event.preventDefault();
	        event.stopPropagation();
	        // Release the mouse if `Escape` is pressed.
	        if (event.keyCode === 27) {
	            this._releaseMouse();
	        }
	    };
	    /**
	     * Handle the `'mousedown'` event for the dock panel.
	     */
	    DockPanel.prototype._evtMouseDown = function (event) {
	        // Do nothing if the left mouse button is not pressed.
	        if (event.button !== 0) {
	            return;
	        }
	        // Find the handle which contains the mouse target, if any.
	        var layout = this.layout;
	        var target = event.target;
	        var handle = searching_1.find(layout.handles(), function (handle) { return handle.contains(target); });
	        if (!handle) {
	            return;
	        }
	        // Stop the event when a handle is pressed.
	        event.preventDefault();
	        event.stopPropagation();
	        // Add the extra document listeners.
	        document.addEventListener('keydown', this, true);
	        document.addEventListener('mouseup', this, true);
	        document.addEventListener('mousemove', this, true);
	        document.addEventListener('contextmenu', this, true);
	        // Compute the offset deltas for the handle press.
	        var rect = handle.getBoundingClientRect();
	        var deltaX = event.clientX - rect.left;
	        var deltaY = event.clientY - rect.top;
	        // Override the cursor and store the press data.
	        var style = window.getComputedStyle(handle);
	        var override = cursor_1.overrideCursor(style.cursor);
	        this._pressData = { handle: handle, deltaX: deltaX, deltaY: deltaY, override: override };
	    };
	    /**
	     * Handle the `'mousemove'` event for the dock panel.
	     */
	    DockPanel.prototype._evtMouseMove = function (event) {
	        // Stop the event when dragging a handle.
	        event.preventDefault();
	        event.stopPropagation();
	        // Compute the desired offset position for the handle.
	        var rect = this.node.getBoundingClientRect();
	        var xPos = event.clientX - rect.left - this._pressData.deltaX;
	        var yPos = event.clientY - rect.top - this._pressData.deltaY;
	        // Set the handle as close to the desired position as possible.
	        var layout = this.layout;
	        layout.moveHandle(this._pressData.handle, xPos, yPos);
	    };
	    /**
	     * Handle the `'mouseup'` event for the dock panel.
	     */
	    DockPanel.prototype._evtMouseUp = function (event) {
	        // Do nothing if the left mouse button is not released.
	        if (event.button !== 0) {
	            return;
	        }
	        // Stop the event when releasing a handle.
	        event.preventDefault();
	        event.stopPropagation();
	        // Finalize the mouse release.
	        this._releaseMouse();
	    };
	    /**
	     * Release the mouse grab for the dock panel.
	     */
	    DockPanel.prototype._releaseMouse = function () {
	        // Bail early if no drag is in progress.
	        if (!this._pressData) {
	            return;
	        }
	        // Clear the override cursor.
	        this._pressData.override.dispose();
	        this._pressData = null;
	        // Remove the extra document listeners.
	        document.removeEventListener('keydown', this, true);
	        document.removeEventListener('mouseup', this, true);
	        document.removeEventListener('mousemove', this, true);
	        document.removeEventListener('contextmenu', this, true);
	    };
	    /**
	     * Find the drop target for the given client position.
	     *
	     * @param clientX - The client X position of interest.
	     *
	     * @param clientY - The client Y position of interest.
	     *
	     * @param shift - Whether to search for shifted drop targets.
	     *
	     * @returns The dock target at the specified client position.
	     */
	    DockPanel.prototype._findDropTarget = function (clientX, clientY, shift) {
	        // Bail, if the mouse is not over the dock panel.
	        if (!query_1.hitTest(this.node, clientX, clientY)) {
	            return { zone: 'invalid', target: null };
	        }
	        // Lookup the layout for the panel.
	        var layout = this.layout;
	        // If the layout is empty, indicate a root drop zone.
	        if (layout.isEmpty) {
	            return { zone: 'root', target: null };
	        }
	        // Handle the shifted drop zones.
	        if (shift) {
	            var edge_1 = Private.calcEdge(this.node, clientX, clientY);
	            return { zone: ("root-" + edge_1), target: null };
	        }
	        // Find the widget at the given client position.
	        var widget = searching_1.find(layout, function (widget) {
	            return widget.isVisible && query_1.hitTest(widget.node, clientX, clientY);
	        });
	        // Bail if no widget is found.
	        if (!widget) {
	            return { zone: 'invalid', target: null };
	        }
	        // Handle the drop zone for a generated tab bar.
	        if (widget.hasClass(TAB_BAR_CLASS)) {
	            return { zone: 'tab-bar', target: widget };
	        }
	        // Handle the drop zone for a user widget.
	        var edge = Private.calcEdge(widget.node, clientX, clientY);
	        return { zone: ("widget-" + edge), target: widget };
	    };
	    /**
	     * Show the overlay indicator at the given client position.
	     *
	     * @param clientX - The client X position of interest.
	     *
	     * @param clientY - The client Y position of interest.
	     *
	     * @param shift - Whether to show the shifted drop targets.
	     *
	     * @returns The drop zone at the specified client position.
	     *
	     * #### Notes
	     * If the position is not over a valid zone, the overlay is hidden.
	     */
	    DockPanel.prototype._showOverlay = function (clientX, clientY, shift) {
	        // Find the dock target for the given client position.
	        var _a = this._findDropTarget(clientX, clientY, shift), zone = _a.zone, target = _a.target;
	        // If the drop zone is invalid, hide the overlay and bail.
	        if (zone === 'invalid') {
	            this._overlay.hide(100);
	            return zone;
	        }
	        // Setup the variables needed to compute the overlay geometry.
	        var top;
	        var left;
	        var right;
	        var bottom;
	        var tr;
	        var box = sizing_1.boxSizing(this.node); // TODO cache this?
	        var rect = this.node.getBoundingClientRect();
	        // Compute the overlay geometry based on the dock zone.
	        switch (zone) {
	            case 'root':
	                top = box.paddingTop;
	                left = box.paddingLeft;
	                right = box.paddingRight;
	                bottom = box.paddingBottom;
	                break;
	            case 'root-top':
	                top = box.paddingTop;
	                left = box.paddingLeft;
	                right = box.paddingRight;
	                bottom = rect.height * GOLDEN;
	                break;
	            case 'root-left':
	                top = box.paddingTop;
	                left = box.paddingLeft;
	                right = rect.width * GOLDEN;
	                bottom = box.paddingBottom;
	                break;
	            case 'root-right':
	                top = box.paddingTop;
	                left = rect.width * GOLDEN;
	                right = box.paddingRight;
	                bottom = box.paddingBottom;
	                break;
	            case 'root-bottom':
	                top = rect.height * GOLDEN;
	                left = box.paddingLeft;
	                right = box.paddingRight;
	                bottom = box.paddingBottom;
	                break;
	            case 'tab-bar':
	                tr = target.node.getBoundingClientRect();
	                top = tr.top - rect.top - box.borderTop;
	                left = tr.left - rect.left - box.borderLeft;
	                right = rect.right - tr.right - box.borderRight;
	                bottom = rect.bottom - tr.bottom - box.borderBottom;
	                break;
	            case 'widget-top':
	                tr = target.node.getBoundingClientRect();
	                top = tr.top - rect.top - box.borderTop;
	                left = tr.left - rect.left - box.borderLeft;
	                right = rect.right - tr.right - box.borderRight;
	                bottom = rect.bottom - tr.bottom + tr.height / 2 - box.borderBottom;
	                break;
	            case 'widget-left':
	                tr = target.node.getBoundingClientRect();
	                top = tr.top - rect.top - box.borderTop;
	                left = tr.left - rect.left - box.borderLeft;
	                right = rect.right - tr.right + tr.width / 2 - box.borderRight;
	                bottom = rect.bottom - tr.bottom - box.borderBottom;
	                break;
	            case 'widget-right':
	                tr = target.node.getBoundingClientRect();
	                top = tr.top - rect.top - box.borderTop;
	                left = tr.left - rect.left + tr.width / 2 - box.borderLeft;
	                right = rect.right - tr.right - box.borderRight;
	                bottom = rect.bottom - tr.bottom - box.borderBottom;
	                break;
	            case 'widget-bottom':
	                tr = target.node.getBoundingClientRect();
	                top = tr.top - rect.top + tr.height / 2 - box.borderTop;
	                left = tr.left - rect.left - box.borderLeft;
	                right = rect.right - tr.right - box.borderRight;
	                bottom = rect.bottom - tr.bottom - box.borderBottom;
	                break;
	        }
	        // Derive the width and height from the other dimensions.
	        var width = rect.width - right - left - box.borderLeft - box.borderRight;
	        var height = rect.height - bottom - top - box.borderTop - box.borderBottom;
	        // Show the overlay with the computed geometry.
	        this._overlay.show({
	            mouseX: clientX,
	            mouseY: clientY,
	            parentRect: rect,
	            top: top, left: left, right: right, bottom: bottom, width: width, height: height
	        });
	        // Finally, return the computed drop zone.
	        return zone;
	    };
	    /**
	     * Create a new tab bar for use by the panel.
	     */
	    DockPanel.prototype._createTabBar = function () {
	        // Create and initialize the tab bar.
	        var tabBar = this._renderer.createTabBar();
	        tabBar.addClass(TAB_BAR_CLASS);
	        // Setup the signal handlers for the tab bar.
	        tabBar.tabCloseRequested.connect(this._onTabCloseRequested, this);
	        tabBar.tabDetachRequested.connect(this._onTabDetachRequested, this);
	        tabBar.tabActivateRequested.connect(this._onTabActivateRequested, this);
	        // Return the initialized tab bar.
	        return tabBar;
	    };
	    /**
	     * Create a new handle for use by the panel.
	     */
	    DockPanel.prototype._createHandle = function () {
	        var handle = this._renderer.createHandle();
	        handle.classList.add(HANDLE_CLASS);
	        return handle;
	    };
	    /**
	     * Handle the `tabActivateRequested` signal from a tab bar.
	     */
	    DockPanel.prototype._onTabActivateRequested = function (sender, args) {
	        args.title.owner.activate();
	    };
	    /**
	     * Handle the `tabCloseRequested` signal from a tab bar.
	     */
	    DockPanel.prototype._onTabCloseRequested = function (sender, args) {
	        args.title.owner.close();
	    };
	    /**
	     * Handle the `tabDetachRequested` signal from a tab bar.
	     */
	    DockPanel.prototype._onTabDetachRequested = function (sender, args) {
	        var _this = this;
	        // Do nothing if a drag is already in progress.
	        if (this._drag) {
	            return;
	        }
	        // Release the tab bar's hold on the mouse.
	        sender.releaseMouse();
	        // Extract the data from the args.
	        var index = args.index, title = args.title, tab = args.tab, clientX = args.clientX, clientY = args.clientY;
	        // Setup the mime data for the drag operation.
	        var mimeData = new mimedata_1.MimeData();
	        var widget = title.owner;
	        mimeData.setData(FACTORY_MIME, function () { return widget; });
	        // Create the drag image for the drag operation.
	        var dragImage = tab.cloneNode(true);
	        // Create the drag object to manage the drag-drop operation.
	        this._drag = new dragdrop_1.Drag({
	            mimeData: mimeData, dragImage: dragImage,
	            proposedAction: 'move',
	            supportedActions: 'move',
	        });
	        // Hide the tab node in the original tab.
	        tab.classList.add(HIDDEN_CLASS);
	        // Create the cleanup callback.
	        var cleanup = (function () {
	            _this._drag = null;
	            tab.classList.remove(HIDDEN_CLASS);
	        });
	        // Start the drag operation and cleanup when done.
	        this._drag.start(clientX, clientY).then(cleanup);
	    };
	    /**
	     * Handle the `currentChanged` signal from the focus tracker.
	     */
	    DockPanel.prototype._onCurrentChanged = function (sender, args) {
	        this.currentChanged.emit(args);
	    };
	    return DockPanel;
	}(widget_1.Widget));
	exports.DockPanel = DockPanel;
	// Define the signals for the `DockPanel` class.
	signaling_1.defineSignal(DockPanel.prototype, 'currentChanged');
	/**
	 * The namespace for the `DockPanel` class statics.
	 */
	var DockPanel;
	(function (DockPanel) {
	    /**
	     * A concrete implementation of `IOverlay`.
	     *
	     * This is the default overlay implementation for a dock panel.
	     */
	    var Overlay = (function () {
	        /**
	         * Construct a new overlay.
	         */
	        function Overlay() {
	            this._timer = -1;
	            this._hidden = true;
	            this._node = document.createElement('div');
	            this._node.classList.add(HIDDEN_CLASS);
	            this._node.style.position = 'absolute';
	        }
	        Object.defineProperty(Overlay.prototype, "node", {
	            /**
	             * The DOM node for the overlay.
	             */
	            get: function () {
	                return this._node;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        /**
	         * Show the overlay using the given overlay geometry.
	         *
	         * @param geo - The desired geometry for the overlay.
	         */
	        Overlay.prototype.show = function (geo) {
	            // Update the position of the overlay.
	            var style = this._node.style;
	            style.top = geo.top + "px";
	            style.left = geo.left + "px";
	            style.right = geo.right + "px";
	            style.bottom = geo.bottom + "px";
	            // Clear any pending hide timer.
	            clearTimeout(this._timer);
	            this._timer = -1;
	            // If the overlay is already visible, we're done.
	            if (!this._hidden) {
	                return;
	            }
	            // Clear the hidden flag.
	            this._hidden = false;
	            // Finally, show the overlay.
	            this._node.classList.remove(HIDDEN_CLASS);
	        };
	        /**
	         * Hide the overlay node.
	         *
	         * @param delay - The delay (in ms) before hiding the overlay.
	         *   A delay value <= 0 will hide the overlay immediately.
	         */
	        Overlay.prototype.hide = function (delay) {
	            var _this = this;
	            // Do nothing if the overlay is already hidden.
	            if (this._hidden) {
	                return;
	            }
	            // Hide immediately if the delay is <= 0.
	            if (delay <= 0) {
	                clearTimeout(this._timer);
	                this._timer = -1;
	                this._hidden = true;
	                this._node.classList.add(HIDDEN_CLASS);
	                return;
	            }
	            // Do nothing if a hide is already pending.
	            if (this._timer !== -1) {
	                return;
	            }
	            // Otherwise setup the hide timer.
	            this._timer = setTimeout(function () {
	                _this._timer = -1;
	                _this._hidden = true;
	                _this._node.classList.add(HIDDEN_CLASS);
	            }, delay);
	        };
	        return Overlay;
	    }());
	    DockPanel.Overlay = Overlay;
	    /**
	     * The default implementation of `IRenderer`.
	     */
	    var Renderer = (function () {
	        function Renderer() {
	        }
	        /**
	         * Create a new tab bar for use with a dock panel.
	         *
	         * @returns A new tab bar for a dock panel.
	         */
	        Renderer.prototype.createTabBar = function () {
	            return new tabbar_1.TabBar();
	        };
	        /**
	         * Create a new handle node for use with a dock panel.
	         *
	         * @returns A new handle node for a dock panel.
	         */
	        Renderer.prototype.createHandle = function () {
	            return document.createElement('div');
	        };
	        return Renderer;
	    }());
	    DockPanel.Renderer = Renderer;
	    /**
	     * The default `Renderer` instance.
	     */
	    DockPanel.defaultRenderer = new Renderer();
	})(DockPanel = exports.DockPanel || (exports.DockPanel = {}));
	/**
	 * A layout which provides a flexible docking arrangement.
	 *
	 * #### Notes
	 * The layout handles the `currentChanged` signals of the tab bars and
	 * the corresponding visibility of the child widgets. The widget which
	 * consumes the layout is responsible for all other tab interactions
	 * as well as all mouse and drag events.
	 */
	var DockLayout = (function (_super) {
	    __extends(DockLayout, _super);
	    /**
	     * Construct a new dock layout.
	     *
	     * @param options - The options for initializing the layout.
	     */
	    function DockLayout(options) {
	        _super.call(this);
	        this._dirty = false;
	        this._box = null;
	        this._root = null;
	        this._renderer = options.renderer;
	        this._spacing = Private.clampSpacing(options.spacing);
	    }
	    /**
	     * Dispose of the resources held by the layout.
	     *
	     * #### Notes
	     * This will clear and dispose all widgets in the layout.
	     */
	    DockLayout.prototype.dispose = function () {
	        // Clear the reference to the renderer.
	        this._renderer = null;
	        // Get an iterator over the widgets in the layout.
	        var widgets = this.iter();
	        // Clear the layout before disposing the widgets.
	        this._root = null;
	        // Dispose of the widgets contained in the old layout root.
	        iteration_1.each(widgets, function (widget) { widget.dispose(); });
	        // Dispose of the base class.
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(DockLayout.prototype, "spacing", {
	        /**
	         * Get the inter-element spacing for the dock layout.
	         */
	        get: function () {
	            return this._spacing;
	        },
	        /**
	         * Set the inter-element spacing for the dock layout.
	         */
	        set: function (value) {
	            value = Private.clampSpacing(value);
	            if (this._spacing === value) {
	                return;
	            }
	            this._spacing = value;
	            if (!this.parent) {
	                return;
	            }
	            this.parent.fit();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DockLayout.prototype, "isEmpty", {
	        /**
	         * Whether the dock layout is empty.
	         */
	        get: function () {
	            return this._root === null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(DockLayout.prototype, "renderer", {
	        /**
	         * The renderer used by the dock layout.
	         */
	        get: function () {
	            return this._renderer;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Create an iterator over all widgets in the layout.
	     *
	     * @returns A new iterator over the widgets in the layout.
	     *
	     * #### Notes
	     * This iterator includes the generated tab bars.
	     */
	    DockLayout.prototype.iter = function () {
	        return this._root ? Private.iterAllWidgets(this._root) : iteration_1.empty();
	    };
	    /**
	     * Create an iterator over the user widgets in the layout.
	     *
	     * @returns A new iterator over the user widgets in the layout.
	     *
	     * #### Notes
	     * This iterator does not include the generated tab bars.
	     */
	    DockLayout.prototype.widgets = function () {
	        return this._root ? Private.iterUserWidgets(this._root) : iteration_1.empty();
	    };
	    /**
	     * Create an iterator over the tab bars in the layout.
	     *
	     * @returns A new iterator over the tab bars in the layout.
	     *
	     * #### Notes
	     * This iterator does not include the user widgets.
	     */
	    DockLayout.prototype.tabBars = function () {
	        return this._root ? Private.iterTabBars(this._root) : iteration_1.empty();
	    };
	    /**
	     * Create an iterator over the handles in the layout.
	     *
	     * @returns A new iterator over the handles in the layout.
	     */
	    DockLayout.prototype.handles = function () {
	        return this._root ? Private.iterHandles(this._root) : iteration_1.empty();
	    };
	    /**
	     * Move a handle to the given offset position.
	     *
	     * @param handle - The handle to move.
	     *
	     * @param offsetX - The desired offset X position of the handle.
	     *
	     * @param offsetY - The desired offset Y position of the handle.
	     *
	     * #### Notes
	     * If the given handle is not contained in the layout, this is no-op.
	     *
	     * The handle will be moved as close as possible to the desired
	     * position without violating any of the layout constraints.
	     *
	     * Only one of the coordinates is used depending on the orientation
	     * of the handle. This method accepts both coordinates to make it
	     * easy to invoke from a mouse move event without needing to know
	     * the handle orientation.
	     */
	    DockLayout.prototype.moveHandle = function (handle, offsetX, offsetY) {
	        // Bail early if there is no root or if the handle is hidden.
	        if (!this._root || handle.classList.contains(HIDDEN_CLASS)) {
	            return;
	        }
	        // Lookup the split node for the handle.
	        var data = Private.findSplitNode(this._root, handle);
	        if (!data) {
	            return;
	        }
	        // Compute the desired delta movement for the handle.
	        var delta;
	        if (data.node.orientation === 'horizontal') {
	            delta = offsetX - handle.offsetLeft;
	        }
	        else {
	            delta = offsetY - handle.offsetTop;
	        }
	        // Bail if there is no handle movement.
	        if (delta === 0) {
	            return;
	        }
	        // Prevent sibling resizing unless needed.
	        Private.holdSizes(data.node.sizers);
	        // Adjust the sizers to reflect the handle movement.
	        boxengine_1.adjustSizer(data.node.sizers, data.index, delta);
	        // Update the layout of the widgets.
	        if (this.parent) {
	            this.parent.update();
	        }
	    };
	    /**
	     * Add a widget to the dock layout.
	     *
	     * @param widget - The widget to add to the dock layout.
	     *
	     * @param options - The additional options for adding the widget.
	     *
	     * #### Notes
	     * The widget will be moved if it is already contained in the layout.
	     *
	     * A warning will be logged if the reference widget is invalid.
	     */
	    DockLayout.prototype.addWidget = function (widget, options) {
	        if (options === void 0) { options = {}; }
	        // Parse the options.
	        var ref = options.ref || null;
	        var mode = options.mode || 'tab-after';
	        // Find the tab node which holds the reference widget.
	        var refNode = null;
	        if (this._root && ref) {
	            refNode = Private.findTabNode(this._root, ref);
	        }
	        // Throw an error if the reference widget is invalid.
	        if (ref && !refNode) {
	            throw new Error('Reference widget is not in the layout.');
	        }
	        // Reparent the widget to the current layout parent.
	        widget.parent = this.parent;
	        // Insert the widget according to the insert mode.
	        switch (mode) {
	            case 'tab-after':
	                this._insertTab(widget, ref, refNode, true);
	                break;
	            case 'tab-before':
	                this._insertTab(widget, ref, refNode, false);
	                break;
	            case 'split-top':
	                this._insertSplit(widget, ref, refNode, 'vertical', false);
	                break;
	            case 'split-left':
	                this._insertSplit(widget, ref, refNode, 'horizontal', false);
	                break;
	            case 'split-right':
	                this._insertSplit(widget, ref, refNode, 'horizontal', true);
	                break;
	            case 'split-bottom':
	                this._insertSplit(widget, ref, refNode, 'vertical', true);
	                break;
	        }
	        // Do nothing else if there is no parent widget.
	        if (!this.parent) {
	            return;
	        }
	        // Ensure the widget is attached to the parent widget.
	        this.attachWidget(widget);
	        // Post a fit request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * Remove a widget from the layout.
	     *
	     * @param widget - The widget to remove from the layout.
	     *
	     * #### Notes
	     * A widget is automatically removed from the layout when its `parent`
	     * is set to `null`. This method should only be invoked directly when
	     * removing a widget from a layout which has yet to be installed on a
	     * parent widget.
	     *
	     * This method does *not* modify the widget's `parent`.
	     */
	    DockLayout.prototype.removeWidget = function (widget) {
	        // Remove the widget from its current layout location.
	        this._removeWidget(widget);
	        // Do nothing else if there is no parent widget.
	        if (!this.parent) {
	            return;
	        }
	        // Detach the widget from the parent widget.
	        this.detachWidget(widget);
	        // Post a fit request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * Perform layout initialization which requires the parent widget.
	     */
	    DockLayout.prototype.init = function () {
	        var _this = this;
	        // Perform superclass initialization.
	        _super.prototype.init.call(this);
	        // Attach each widget to the parent.
	        iteration_1.each(this, function (widget) { _this.attachWidget(widget); });
	        // Attach each handle to the parent.
	        iteration_1.each(this.handles(), function (handle) { _this.parent.node.appendChild(handle); });
	        // Post a fit request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * Attach the widget to the layout parent widget.
	     *
	     * @param widget - The widget to attach to the parent.
	     *
	     * #### Notes
	     * This is a no-op if the widget is already attached.
	     */
	    DockLayout.prototype.attachWidget = function (widget) {
	        // Do nothing if the widget is already attached.
	        if (this.parent.node === widget.node.parentNode) {
	            return;
	        }
	        // Prepare the layout geometry for the widget.
	        widget_1.Widget.prepareGeometry(widget);
	        // Add the widget's node to the parent.
	        this.parent.node.appendChild(widget.node);
	        // Send an `'after-attach'` message if the parent is attached.
	        if (this.parent.isAttached) {
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.AfterAttach);
	        }
	    };
	    /**
	     * Detach the widget from the layout parent widget.
	     *
	     * @param widget - The widget to detach from the parent.
	     *
	     * #### Notes
	     * This is a no-op if the widget is not attached.
	     */
	    DockLayout.prototype.detachWidget = function (widget) {
	        // Do nothing if the widget is not attached.
	        if (this.parent.node !== widget.node.parentNode) {
	            return;
	        }
	        // Send a `'before-detach'` message if the parent is attached.
	        if (this.parent.isAttached) {
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.BeforeDetach);
	        }
	        // Remove the widget's node from the parent.
	        this.parent.node.removeChild(widget.node);
	        // Reset the layout geometry for the widget.
	        widget_1.Widget.resetGeometry(widget);
	    };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     */
	    DockLayout.prototype.onAfterShow = function (msg) {
	        _super.prototype.onAfterShow.call(this, msg);
	        this.parent.update();
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    DockLayout.prototype.onAfterAttach = function (msg) {
	        _super.prototype.onAfterAttach.call(this, msg);
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on a `'child-shown'` message.
	     */
	    DockLayout.prototype.onChildShown = function (msg) {
	        if (platform_1.IS_IE || platform_1.IS_EDGE) {
	            // TODO not collapsing can cause lots of fitting
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'child-hidden'` message.
	     */
	    DockLayout.prototype.onChildHidden = function (msg) {
	        if (platform_1.IS_IE || platform_1.IS_EDGE) {
	            // TODO not collapsing can cause lots of fitting
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     */
	    DockLayout.prototype.onResize = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(msg.width, msg.height);
	        }
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    DockLayout.prototype.onUpdateRequest = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(-1, -1);
	        }
	    };
	    /**
	     * A message handler invoked on a `'fit-request'` message.
	     */
	    DockLayout.prototype.onFitRequest = function (msg) {
	        if (this.parent.isAttached) {
	            this._fit();
	        }
	    };
	    /**
	     * Remove the specified widget from the layout structure.
	     *
	     * @param widget - The widget to remove from the layout.
	     *
	     * #### Notes
	     * This is a no-op if the widget is not in the layout tree.
	     *
	     * This does not detach the widget from the parent node.
	     */
	    DockLayout.prototype._removeWidget = function (widget) {
	        // Bail early if there is no layout root.
	        if (!this._root) {
	            return;
	        }
	        // Find the tab node which contains the given widget.
	        var tabNode = Private.findTabNode(this._root, widget);
	        // Bail early if the tab node is not found.
	        if (!tabNode) {
	            return;
	        }
	        // If there are multiple tabs, just remove the widget's tab.
	        if (tabNode.tabBar.titles.length > 1) {
	            tabNode.tabBar.removeTab(widget.title);
	            return;
	        }
	        // Otherwise, the tab node needs to be removed...
	        // Dispose the tab bar.
	        tabNode.tabBar.dispose();
	        // Handle the case where the tab node is the root.
	        if (this._root === tabNode) {
	            this._root = null;
	            return;
	        }
	        // Otherwise, remove the tab node from its parent...
	        // Prevent widget resizing unless needed.
	        Private.holdLayoutSizes(this._root);
	        // Clear the parent reference on the tab node.
	        var splitNode = tabNode.parent;
	        tabNode.parent = null;
	        // Remove the tab node from its parent split node.
	        var i = splitNode.children.remove(tabNode);
	        var handle = splitNode.handles.removeAt(i);
	        splitNode.sizers.removeAt(i);
	        // Remove the handle from its parent DOM node.
	        if (handle.parentNode) {
	            handle.parentNode.removeChild(handle);
	        }
	        // If there are multiple children, just update the handles.
	        if (splitNode.children.length > 1) {
	            Private.syncHandles(splitNode);
	            return;
	        }
	        // Otherwise, the split node also needs to be removed...
	        // Clear the parent reference on the split node.
	        var parentNode = splitNode.parent;
	        splitNode.parent = null;
	        // Lookup the remaining child node and handle.
	        var childNode = splitNode.children.front;
	        var childHandle = splitNode.handles.front;
	        // Clear the split node data.
	        splitNode.children.clear();
	        splitNode.handles.clear();
	        splitNode.sizers.clear();
	        // Remove the child handle from its parent node.
	        if (childHandle.parentNode) {
	            childHandle.parentNode.removeChild(childHandle);
	        }
	        // Handle the case where the split node is the root.
	        if (this._root === splitNode) {
	            childNode.parent = null;
	            this._root = childNode;
	            return;
	        }
	        // Otherwise, move the child node to the parent node...
	        // Lookup the index of the split node.
	        var j = searching_1.indexOf(parentNode.children, splitNode);
	        // Handle the case where the child node is a tab node.
	        if (childNode instanceof Private.TabLayoutNode) {
	            childNode.parent = parentNode;
	            parentNode.children.set(j, childNode);
	            return;
	        }
	        // Remove the split data from the parent.
	        var splitHandle = parentNode.handles.removeAt(j);
	        parentNode.children.removeAt(j);
	        parentNode.sizers.removeAt(j);
	        // Remove the handle from its parent node.
	        if (splitHandle.parentNode) {
	            splitHandle.parentNode.removeChild(splitHandle);
	        }
	        // The child node and the split parent node will have the same
	        // orientation. Merge the grand-children with the parent node.
	        for (var i_1 = 0, n = childNode.children.length; i_1 < n; ++i_1) {
	            var gChild = childNode.children.at(i_1);
	            var gHandle = childNode.handles.at(i_1);
	            var gSizer = childNode.sizers.at(i_1);
	            parentNode.children.insert(j + i_1, gChild);
	            parentNode.handles.insert(j + i_1, gHandle);
	            parentNode.sizers.insert(j + i_1, gSizer);
	            gChild.parent = parentNode;
	        }
	        // Clear the child node.
	        childNode.children.clear();
	        childNode.handles.clear();
	        childNode.sizers.clear();
	        childNode.parent = null;
	        // Sync the handles on the parent node.
	        Private.syncHandles(parentNode);
	    };
	    /**
	     * Insert a widget next to an existing tab.
	     *
	     * @param widget - The widget to add to the layout.
	     *
	     * @param ref - The reference widget, or `null`.
	     *
	     * @param refNode - The layout node for the ref widget, or `null`.
	     *
	     * @param after - Whether to insert the widget after the ref.
	     *
	     * #### Notes
	     * This assumes the target widget is not in the layout tree.
	     *
	     * This does not attach the widget to the parent widget.
	     */
	    DockLayout.prototype._insertTab = function (widget, ref, refNode, after) {
	        // Do nothing if the tab is inserted next to itself.
	        if (widget === ref) {
	            return;
	        }
	        // Create the root if it does not exist.
	        if (!this._root) {
	            var tabNode = new Private.TabLayoutNode(this._createTabBar());
	            tabNode.tabBar.addTab(widget.title);
	            this._root = tabNode;
	            return;
	        }
	        // Use the first tab node as the ref node if needed.
	        if (!refNode) {
	            refNode = Private.firstTabNode(this._root);
	        }
	        // If the widget is not contained in the ref node, ensure it is
	        // removed from the layout and hidden before being added again.
	        if (!searching_1.contains(refNode.tabBar.titles, widget.title)) {
	            this._removeWidget(widget);
	            widget.hide();
	        }
	        // Lookup the target index for inserting the tab.
	        var index;
	        if (ref) {
	            index = searching_1.indexOf(refNode.tabBar.titles, ref.title);
	        }
	        else {
	            index = refNode.tabBar.currentIndex;
	        }
	        // Insert the widget's tab relative to the target index.
	        refNode.tabBar.insertTab(index + (after ? 1 : 0), widget.title);
	    };
	    /**
	     * Insert a widget as a new split area.
	     *
	     * @param widget - The widget to add to the layout.
	     *
	     * @param ref - The reference widget, or `null`.
	     *
	     * @param refNode - The layout node for the ref widget, or `null`.
	     *
	     * @param orientation - The orientation for the split.
	     *
	     * @param after - Whether to insert the widget after the ref.
	     *
	     * #### Notes
	     * This assumes the target widget is not in the layout tree.
	     *
	     * This does not attach the widget to the parent widget.
	     */
	    DockLayout.prototype._insertSplit = function (widget, ref, refNode, orientation, after) {
	        // Do nothing if there is no effective split.
	        if (widget === ref && refNode.tabBar.titles.length === 1) {
	            return;
	        }
	        // Ensure the widget is removed from the current layout.
	        this._removeWidget(widget);
	        // Create the tab layout node to hold the widget.
	        var tabNode = new Private.TabLayoutNode(this._createTabBar());
	        tabNode.tabBar.addTab(widget.title);
	        // Set the root if it does not exist.
	        if (!this._root) {
	            this._root = tabNode;
	            return;
	        }
	        // Lookup the split node for the ref widget.
	        var splitNode = refNode ? refNode.parent : null;
	        // If the split node is null, split the root.
	        if (!splitNode) {
	            // Ensure the root is split with the correct orientation.
	            var root = this._splitRoot(orientation);
	            // Determine the insert index for the new tab node.
	            var i_2 = after ? root.children.length : 0;
	            // Normalize the split node.
	            Private.normalizeSizes(root);
	            // Insert the tab node sized to the golden ratio.
	            root.children.insert(i_2, tabNode);
	            root.sizers.insert(i_2, Private.createSizer(GOLDEN));
	            root.handles.insert(i_2, this._createHandle());
	            tabNode.parent = root;
	            // Re-normalize the split node to maintain the ratios.
	            Private.normalizeSizes(root);
	            // Finally, synchronize the visibility of the handles.
	            Private.syncHandles(root);
	            return;
	        }
	        // If the split node already had the correct orientation,
	        // the widget can be inserted into the split node directly.
	        if (splitNode.orientation === orientation) {
	            // Find the index of the ref node.
	            var i_3 = searching_1.indexOf(splitNode.children, refNode);
	            // Normalize the split node.
	            Private.normalizeSizes(splitNode);
	            // Consume half the space for the insert location.
	            var s = splitNode.sizers.at(i_3).sizeHint /= 2;
	            // Insert the tab node sized to the other half.
	            var j_1 = i_3 + (after ? 1 : 0);
	            splitNode.children.insert(j_1, tabNode);
	            splitNode.sizers.insert(j_1, Private.createSizer(s));
	            splitNode.handles.insert(j_1, this._createHandle());
	            tabNode.parent = splitNode;
	            // Finally, synchronize the visibility of the handles.
	            Private.syncHandles(splitNode);
	            return;
	        }
	        // Remove the ref node from the split node.
	        var i = splitNode.children.remove(refNode);
	        // Create a new normalized split node for the children.
	        var childNode = new Private.SplitLayoutNode(orientation);
	        childNode.normalized = true;
	        // Add the ref node sized to half the space.
	        childNode.children.pushBack(refNode);
	        childNode.sizers.pushBack(Private.createSizer(0.5));
	        childNode.handles.pushBack(this._createHandle());
	        refNode.parent = childNode;
	        // Add the tab node sized to the other half.
	        var j = after ? 1 : 0;
	        childNode.children.insert(j, tabNode);
	        childNode.sizers.insert(j, Private.createSizer(0.5));
	        childNode.handles.insert(j, this._createHandle());
	        tabNode.parent = childNode;
	        // Synchronize the visibility of the handles.
	        Private.syncHandles(childNode);
	        // Finally, add the new child node to the original split node.
	        splitNode.children.insert(i, childNode);
	        childNode.parent = splitNode;
	    };
	    /**
	     * Ensure the root is a split node with the given orientation.
	     *
	     * @param orientation - The required orientation of the root.
	     *
	     * @returns The new root node (as a convenience).
	     */
	    DockLayout.prototype._splitRoot = function (orientation) {
	        // Bail early if the root already meets the requirements.
	        var root = this._root;
	        if (root instanceof Private.SplitLayoutNode) {
	            if (root.orientation === orientation) {
	                return root;
	            }
	        }
	        // Create a new root node with the specified orientation.
	        var result = this._root = new Private.SplitLayoutNode(orientation);
	        // Add the old root to the new root.
	        result.children.pushBack(root);
	        result.sizers.pushBack(Private.createSizer(0));
	        result.handles.pushBack(this._createHandle());
	        root.parent = result;
	        // Return the new root as a convenience.
	        return result;
	    };
	    /**
	     * Fit the layout to the total size required by the widgets.
	     */
	    DockLayout.prototype._fit = function () {
	        // Setup the size limits.
	        var minW = 0;
	        var minH = 0;
	        var maxW = Infinity;
	        var maxH = Infinity;
	        // Update the limits for the root layout node.
	        if (this._root) {
	            var limits = Private.fitLayoutNode(this._root, this._spacing);
	            minW = limits.minWidth;
	            minH = limits.minHeight;
	            maxW = limits.maxWidth;
	            maxH = limits.maxHeight;
	        }
	        // Update the box sizing and add it to the size limits.
	        var box = this._box = sizing_1.boxSizing(this.parent.node);
	        minW += box.horizontalSum;
	        minH += box.verticalSum;
	        maxW += box.horizontalSum;
	        maxH += box.verticalSum;
	        // Update the parent's size constraints.
	        var style = this.parent.node.style;
	        style.minWidth = minW + "px";
	        style.minHeight = minH + "px";
	        style.maxWidth = maxW === Infinity ? 'none' : maxW + "px";
	        style.maxHeight = maxH === Infinity ? 'none' : maxH + "px";
	        // Set the dirty flag to ensure only a single update occurs.
	        this._dirty = true;
	        // Notify the ancestor that it should fit immediately. This may
	        // cause a resize of the parent, fulfilling the required update.
	        if (this.parent.parent) {
	            messaging_1.sendMessage(this.parent.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        // If the dirty flag is still set, the parent was not resized.
	        // Trigger the required update on the parent widget immediately.
	        if (this._dirty) {
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.UpdateRequest);
	        }
	    };
	    /**
	     * Update the layout position and size of the widgets.
	     *
	     * The parent offset dimensions should be `-1` if unknown.
	     */
	    DockLayout.prototype._update = function (offsetWidth, offsetHeight) {
	        // Clear the dirty flag to indicate the update occurred.
	        this._dirty = false;
	        // Bail early if there is no root layout node.
	        if (!this._root) {
	            return;
	        }
	        // Measure the parent if the offset dimensions are unknown.
	        if (offsetWidth < 0) {
	            offsetWidth = this.parent.node.offsetWidth;
	        }
	        if (offsetHeight < 0) {
	            offsetHeight = this.parent.node.offsetHeight;
	        }
	        // Ensure the parent box sizing data is computed.
	        var box = this._box || (this._box = sizing_1.boxSizing(this.parent.node));
	        // Compute the actual layout bounds adjusted for border and padding.
	        var x = box.paddingTop;
	        var y = box.paddingLeft;
	        var width = offsetWidth - box.horizontalSum;
	        var height = offsetHeight - box.verticalSum;
	        // Update the geometry of the root layout node.
	        Private.updateLayoutNode(this._root, x, y, width, height, this._spacing);
	    };
	    /**
	     * Create a new tab bar for use by the dock layout.
	     *
	     * #### Notes
	     * The tab bar will be attached to the parent if it exists.
	     */
	    DockLayout.prototype._createTabBar = function () {
	        // Create the tab bar using the renderer.
	        var tabBar = this._renderer.createTabBar();
	        // Enforce necessary tab bar behavior.
	        // TODO do we really want to enforce *all* of these?
	        tabBar.tabsMovable = true;
	        tabBar.allowDeselect = false;
	        tabBar.orientation = 'horizontal';
	        tabBar.removeBehavior = 'select-previous-tab';
	        tabBar.insertBehavior = 'select-tab-if-needed';
	        // Setup the signal handlers for the tab bar.
	        tabBar.currentChanged.connect(this._onCurrentChanged, this);
	        // Reparent and attach the tab bar to the parent if possible.
	        if (this.parent) {
	            tabBar.parent = this.parent;
	            this.attachWidget(tabBar);
	        }
	        // Return the initialized tab bar.
	        return tabBar;
	    };
	    /**
	     * Create a new handle for the dock layout.
	     *
	     * #### Notes
	     * The handle will be attached to the parent if it exists.
	     */
	    DockLayout.prototype._createHandle = function () {
	        // Create the handle using the renderer.
	        var handle = this._renderer.createHandle();
	        // Initialize the handle layout behavior.
	        var style = handle.style;
	        style.position = 'absolute';
	        style.top = '0';
	        style.left = '0';
	        style.width = '0';
	        style.height = '0';
	        // Attach the handle to the parent if it exists.
	        if (this.parent) {
	            this.parent.node.appendChild(handle);
	        }
	        // Return the initialized handle.
	        return handle;
	    };
	    /**
	     * Handle the `currentChanged` signal from a tab bar in the layout.
	     */
	    DockLayout.prototype._onCurrentChanged = function (sender, args) {
	        // Extract the previous and current title from the args.
	        var previousTitle = args.previousTitle, currentTitle = args.currentTitle;
	        // Extract the widgets from the titles.
	        var previousWidget = previousTitle ? previousTitle.owner : null;
	        var currentWidget = currentTitle ? currentTitle.owner : null;
	        // Hide the previous widget.
	        if (previousWidget) {
	            previousWidget.hide();
	        }
	        // Show the current widget.
	        if (currentWidget) {
	            currentWidget.show();
	        }
	    };
	    return DockLayout;
	}(widget_1.Layout));
	exports.DockLayout = DockLayout;
	/**
	 * The namespace for the module private data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A layout node which holds the data for a tabbed area.
	     */
	    var TabLayoutNode = (function () {
	        /**
	         * Construct a new tab layout node.
	         *
	         * @param tabBar - The tab bar to use for the layout node.
	         */
	        function TabLayoutNode(tabBar) {
	            /**
	             * The parent of the layout node, or `null`.
	             */
	            this.parent = null;
	            /**
	             * The box sizers for the tab bar and current widget.
	             */
	            this.sizers = new vector_1.Vector();
	            var tabSizer = new boxengine_1.BoxSizer();
	            var widgetSizer = new boxengine_1.BoxSizer();
	            tabSizer.stretch = 0;
	            widgetSizer.stretch = 1;
	            this.sizers.pushBack(tabSizer);
	            this.sizers.pushBack(widgetSizer);
	            this.tabBar = tabBar;
	        }
	        return TabLayoutNode;
	    }());
	    Private.TabLayoutNode = TabLayoutNode;
	    /**
	     * A layout node which holds the data for a split area.
	     */
	    var SplitLayoutNode = (function () {
	        /**
	         * Construct a new split layout node.
	         *
	         * @param orientation - The orientation of the node.
	         */
	        function SplitLayoutNode(orientation) {
	            /**
	             * The parent of the layout node, or `null`.
	             */
	            this.parent = null;
	            /**
	             * Whether the sizers have been normalized.
	             */
	            this.normalized = false;
	            /**
	             * The child nodes for the split node.
	             */
	            this.children = new vector_1.Vector();
	            /**
	             * The box sizers for the layout children.
	             */
	            this.sizers = new vector_1.Vector();
	            /**
	             * The handles for the layout children.
	             */
	            this.handles = new vector_1.Vector();
	            this.orientation = orientation;
	        }
	        return SplitLayoutNode;
	    }());
	    Private.SplitLayoutNode = SplitLayoutNode;
	    /**
	     * Clamp a spacing value to an integer >= 0.
	     */
	    function clampSpacing(value) {
	        return Math.max(0, Math.floor(value));
	    }
	    Private.clampSpacing = clampSpacing;
	    /**
	     * Create an iterator for all widgets in the layout tree.
	     *
	     * @param node - The root layout node of interest.
	     *
	     * @returns An iterator which yields all widgets in the tree.
	     *
	     * #### Notes
	     * This includes the tab bars for the tab layout nodes.
	     */
	    function iterAllWidgets(node) {
	        var it;
	        if (node instanceof TabLayoutNode) {
	            it = iteration_1.chain(iteration_1.once(node.tabBar), iterUserWidgets(node));
	        }
	        else {
	            it = new iteration_1.ChainIterator(iteration_1.map(node.children, iterAllWidgets));
	        }
	        return it;
	    }
	    Private.iterAllWidgets = iterAllWidgets;
	    /**
	     * Create an iterator for the user widgets in the layout tree.
	     *
	     * @param node - The root layout node of interest.
	     *
	     * @returns An iterator which yields the user widgets in the tree.
	     *
	     * #### Notes
	     * This does not include the tab bars for the tab layout nodes.
	     */
	    function iterUserWidgets(node) {
	        var it;
	        if (node instanceof TabLayoutNode) {
	            it = iteration_1.map(node.tabBar.titles, function (title) { return title.owner; });
	        }
	        else {
	            it = new iteration_1.ChainIterator(iteration_1.map(node.children, iterUserWidgets));
	        }
	        return it;
	    }
	    Private.iterUserWidgets = iterUserWidgets;
	    /**
	     * Create an iterator for the tab bars in the tree.
	     *
	     * @param node - The root layout node of interest.
	     *
	     * @returns An iterator which yields the tab bars in the tree.
	     */
	    function iterTabBars(node) {
	        var it;
	        if (node instanceof TabLayoutNode) {
	            it = iteration_1.once(node.tabBar);
	        }
	        else {
	            it = new iteration_1.ChainIterator(iteration_1.map(node.children, iterTabBars));
	        }
	        return it;
	    }
	    Private.iterTabBars = iterTabBars;
	    /**
	     * Create an iterator for the handles in the tree.
	     *
	     * @param node - The root layout node of interest.
	     *
	     * @returns An iterator which yields the handles in the tree.
	     */
	    function iterHandles(node) {
	        var it;
	        if (node instanceof TabLayoutNode) {
	            it = iteration_1.empty();
	        }
	        else {
	            var others = iteration_1.map(node.children, iterHandles);
	            it = iteration_1.chain(node.handles, new iteration_1.ChainIterator(others));
	        }
	        return it;
	    }
	    Private.iterHandles = iterHandles;
	    /**
	     * Get the reference widget for a tab bar.
	     *
	     * @param tabBar - The tab bar of interest.
	     *
	     * @returns The target reference widget in the tab bar, or null.
	     */
	    function tabBarRef(tabBar) {
	        if (tabBar.currentTitle) {
	            return tabBar.currentTitle.owner;
	        }
	        if (tabBar.titles.length > 0) {
	            return tabBar.titles.at(tabBar.titles.length - 1).owner;
	        }
	        return null;
	    }
	    Private.tabBarRef = tabBarRef;
	    /**
	     * Find the first tab layout node in a layout tree.
	     *
	     * @param node - The root layout node of interest.
	     *
	     * @returns The first tab node in the tree, or `null`.
	     */
	    function firstTabNode(node) {
	        // Return the node if it's a tab layout node.
	        if (node instanceof TabLayoutNode) {
	            return node;
	        }
	        // Recursively search the children for a tab layout node.
	        for (var i = 0, n = node.children.length; i < n; ++i) {
	            var result = firstTabNode(node.children.at(i));
	            if (result !== null) {
	                return result;
	            }
	        }
	        // Otherwise, there is no tab layout node.
	        return null;
	    }
	    Private.firstTabNode = firstTabNode;
	    /**
	     * Find the tab layout node which contains the given widget.
	     *
	     * @param node - The root layout node of interest.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The tab node which holds the widget, or `null`.
	     */
	    function findTabNode(node, widget) {
	        // Return the tab node if it contains the widget.
	        if (node instanceof TabLayoutNode) {
	            return searching_1.contains(node.tabBar.titles, widget.title) ? node : null;
	        }
	        // Recursively search the children of a split layout node.
	        for (var i = 0, n = node.children.length; i < n; ++i) {
	            var result = findTabNode(node.children.at(i), widget);
	            if (result !== null) {
	                return result;
	            }
	        }
	        // Otherwise, the widget does not exist in the tree.
	        return null;
	    }
	    Private.findTabNode = findTabNode;
	    /**
	     * Find the split layout node which contains the given handle.
	     *
	     * @param node - The root layout node of interest.
	     *
	     * @param handle - The handle of interest.
	     *
	     * @returns An object which contains the split node and the index
	     *   of the handle, or `null` if the split node is not found.
	     */
	    function findSplitNode(node, handle) {
	        // Bail if the node is not a split node.
	        if (node instanceof TabLayoutNode) {
	            return null;
	        }
	        // Return the pair if the node contains the handle.
	        var index = searching_1.indexOf(node.handles, handle);
	        if (index !== -1) {
	            return { index: index, node: node };
	        }
	        // Recursively search the child split nodes.
	        for (var i = 0, n = node.children.length; i < n; ++i) {
	            var result = findSplitNode(node.children.at(i), handle);
	            if (result !== null) {
	                return result;
	            }
	        }
	        // Otherwise, the handle does not exist in the tree.
	        return null;
	    }
	    Private.findSplitNode = findSplitNode;
	    /**
	     * Recursively fit the given layout node.
	     *
	     * @param node - The layout node of interest.
	     *
	     * @param spacing - The spacing to use between tab areas.
	     *
	     * @returns The computed size limits for the layout node.
	     */
	    function fitLayoutNode(node, spacing) {
	        var limits;
	        if (node instanceof TabLayoutNode) {
	            limits = fitTabNode(node);
	        }
	        else {
	            limits = fitSplitNode(node, spacing);
	        }
	        return limits;
	    }
	    Private.fitLayoutNode = fitLayoutNode;
	    /**
	     * Recursively update the given layout node.
	     *
	     * @param node - The layout node of interest.
	     *
	     * @param x - The offset left position of the layout area.
	     *
	     * @param y - The offset top position of the layout area.
	     *
	     * @param width - The width of the layout area.
	     *
	     * @param height - The height of the layout area.
	     *
	     * @param spacing - The spacing to use between tab areas.
	     */
	    function updateLayoutNode(node, x, y, width, height, spacing) {
	        if (node instanceof TabLayoutNode) {
	            updateTabNode(node, x, y, width, height);
	        }
	        else {
	            updateSplitNode(node, x, y, width, height, spacing);
	        }
	    }
	    Private.updateLayoutNode = updateLayoutNode;
	    /**
	     * Sync the visibility and orientation of split node handles.
	     *
	     * @param splitNode - The split node of interest.
	     */
	    function syncHandles(splitNode) {
	        // Do nothing if there are no handles.
	        if (splitNode.handles.isEmpty) {
	            return;
	        }
	        // Compute the classes to add and remove.
	        var horizontal = splitNode.orientation === 'horizontal';
	        var remClass = horizontal ? VERTICAL_CLASS : HORIZONTAL_CLASS;
	        var addClass = horizontal ? HORIZONTAL_CLASS : VERTICAL_CLASS;
	        // Show all handles and update their orientation.
	        iteration_1.each(splitNode.handles, function (handle) {
	            handle.classList.remove(HIDDEN_CLASS);
	            handle.classList.remove(remClass);
	            handle.classList.add(addClass);
	        });
	        // Hide the last handle.
	        splitNode.handles.back.classList.add(HIDDEN_CLASS);
	    }
	    Private.syncHandles = syncHandles;
	    /**
	     * Determine the zone for the given node and client position.
	     *
	     * This assumes the position lies within the node's client rect.
	     */
	    function calcEdge(node, x, y) {
	        var rect = node.getBoundingClientRect();
	        var fracX = (x - rect.left) / rect.width;
	        var fracY = (y - rect.top) / rect.height;
	        var normX = fracX > 0.5 ? 1 - fracX : fracX;
	        var normY = fracY > 0.5 ? 1 - fracY : fracY;
	        var result;
	        if (normX < normY) {
	            result = fracX <= 0.5 ? 'left' : 'right';
	        }
	        else {
	            result = fracY <= 0.5 ? 'top' : 'bottom';
	        }
	        return result;
	    }
	    Private.calcEdge = calcEdge;
	    /**
	     * Hold the current sizes of a vector of box sizers.
	     *
	     * This sets the size hint of each sizer to its current size.
	     */
	    function holdSizes(sizers) {
	        iteration_1.each(sizers, function (sizer) { sizer.sizeHint = sizer.size; });
	    }
	    Private.holdSizes = holdSizes;
	    /**
	     * Recursively hold all the layout sizes in the tree.
	     *
	     * This ignores the sizers of tab layout nodes.
	     */
	    function holdLayoutSizes(node) {
	        if (node instanceof SplitLayoutNode) {
	            iteration_1.each(node.children, holdLayoutSizes);
	            holdSizes(node.sizers);
	        }
	    }
	    Private.holdLayoutSizes = holdLayoutSizes;
	    /**
	     * Create a box sizer with an initial size hint.
	     */
	    function createSizer(hint) {
	        var sizer = new boxengine_1.BoxSizer();
	        sizer.sizeHint = hint;
	        sizer.size = hint;
	        return sizer;
	    }
	    Private.createSizer = createSizer;
	    /**
	     * Normalize the sizes of a split layout node.
	     */
	    function normalizeSizes(splitNode) {
	        // Bail early if the sizers are empty.
	        var n = splitNode.sizers.length;
	        if (n === 0) {
	            return;
	        }
	        // Hold the current sizes of the sizers.
	        holdSizes(splitNode.sizers);
	        // Compute the sum of the sizes.
	        var sum = iteration_1.reduce(splitNode.sizers, function (v, sizer) { return v + sizer.sizeHint; }, 0);
	        // Normalize the sizes based on the sum.
	        if (sum === 0) {
	            iteration_1.each(splitNode.sizers, function (sizer) {
	                sizer.size = sizer.sizeHint = 1 / n;
	            });
	        }
	        else {
	            iteration_1.each(splitNode.sizers, function (sizer) {
	                sizer.size = sizer.sizeHint /= sum;
	            });
	        }
	        // Mark the split node as normalized.
	        splitNode.normalized = true;
	    }
	    Private.normalizeSizes = normalizeSizes;
	    /**
	     * Fit the given tab layout node.
	     *
	     * @param tabNode - The tab node of interest.
	     *
	     * @returns The computed size limits for the node.
	     */
	    function fitTabNode(tabNode) {
	        // Setup the limit variables.
	        var minWidth = 0;
	        var minHeight = 0;
	        var maxWidth = Infinity;
	        var maxHeight = Infinity;
	        // Lookup common variables.
	        var tabBar = tabNode.tabBar;
	        var tabSizer = tabNode.sizers.at(0);
	        var widgetSizer = tabNode.sizers.at(1);
	        var currentTitle = tabBar.currentTitle;
	        var widget = currentTitle ? currentTitle.owner : null;
	        // Adjust the starting max height if a widget is visible.
	        if (!tabBar.isHidden || (widget && !widget.isHidden)) {
	            maxHeight = 0;
	        }
	        // Update the results and sizer for the tab bar.
	        if (!tabBar.isHidden) {
	            var limits = sizing_1.sizeLimits(tabBar.node);
	            minWidth = Math.max(minWidth, limits.minWidth);
	            maxWidth = Math.min(maxWidth, limits.maxWidth);
	            minHeight += limits.minHeight;
	            maxHeight += limits.maxHeight;
	            tabSizer.minSize = limits.minHeight;
	            tabSizer.maxSize = limits.maxHeight;
	        }
	        else {
	            tabSizer.minSize = 0;
	            tabSizer.maxSize = 0;
	        }
	        // Update the results and sizer for the current widget.
	        if (widget && !widget.isHidden) {
	            var limits = sizing_1.sizeLimits(widget.node);
	            minWidth = Math.max(minWidth, limits.minWidth);
	            maxWidth = Math.min(maxWidth, limits.maxWidth);
	            minHeight += limits.minHeight;
	            maxHeight += limits.maxHeight;
	            widgetSizer.minSize = limits.minHeight;
	            widgetSizer.maxSize = limits.maxHeight;
	        }
	        else {
	            widgetSizer.minSize = 0;
	            widgetSizer.maxSize = 0;
	        }
	        // Return the computed size limits for the layout node.
	        return { minWidth: minWidth, minHeight: minHeight, maxWidth: maxWidth, maxHeight: maxHeight };
	    }
	    /**
	     * Recursively fit the given split layout node.
	     *
	     * @param splitNode - The split node of interest.
	     *
	     * @returns The computed size limits for the node.
	     */
	    function fitSplitNode(splitNode, spacing) {
	        // Setup the limit variables.
	        var minWidth = 0;
	        var minHeight = 0;
	        var maxWidth = Infinity;
	        var maxHeight = Infinity;
	        // Compute common values.
	        var horizontal = splitNode.orientation === 'horizontal';
	        var fixed = Math.max(0, splitNode.children.length - 1) * spacing;
	        // Adjust the starting limits for the orientation.
	        if (horizontal) {
	            minWidth = fixed;
	            maxWidth = fixed;
	        }
	        else {
	            minHeight = fixed;
	            maxHeight = fixed;
	        }
	        // Adjust the limits and sizer for each child area.
	        for (var i = 0, n = splitNode.children.length; i < n; ++i) {
	            var sizer = splitNode.sizers.at(i);
	            var child = splitNode.children.at(i);
	            var limits = fitLayoutNode(child, spacing);
	            if (horizontal) {
	                minHeight = Math.max(minHeight, limits.minHeight);
	                maxHeight = Math.min(maxHeight, limits.maxHeight);
	                minWidth += limits.minWidth;
	                maxWidth += limits.maxWidth;
	                sizer.minSize = limits.minWidth;
	                sizer.maxSize = limits.maxWidth;
	            }
	            else {
	                minWidth = Math.max(minWidth, limits.minWidth);
	                maxWidth = Math.min(maxWidth, limits.maxWidth);
	                minHeight += limits.minHeight;
	                maxHeight += limits.maxHeight;
	                sizer.minSize = limits.minHeight;
	                sizer.maxSize = limits.maxHeight;
	            }
	        }
	        // Return the computed size limits for the layout node.
	        return { minWidth: minWidth, minHeight: minHeight, maxWidth: maxWidth, maxHeight: maxHeight };
	    }
	    /**
	     * Update the given tab layout node.
	     *
	     * @param tabNode - The tab node of interest.
	     *
	     * @param x - The offset left position of the layout area.
	     *
	     * @param y - The offset top position of the layout area.
	     *
	     * @param width - The width of the layout area.
	     *
	     * @param height - The height of the layout area.
	     */
	    function updateTabNode(tabNode, x, y, width, height) {
	        // Lookup common variables.
	        var tabBar = tabNode.tabBar;
	        var tabSizer = tabNode.sizers.at(0);
	        var widgetSizer = tabNode.sizers.at(1);
	        var currentTitle = tabBar.currentTitle;
	        var widget = currentTitle ? currentTitle.owner : null;
	        // Distribute the layout space to the sizers.
	        boxengine_1.boxCalc(tabNode.sizers, height);
	        // Layout the tab bar using the computed size.
	        if (!tabBar.isHidden) {
	            widget_1.Widget.setGeometry(tabBar, x, y, width, tabSizer.size);
	            y += tabSizer.size;
	        }
	        // Layout the widget using the computed size.
	        if (widget && !widget.isHidden) {
	            widget_1.Widget.setGeometry(widget, x, y, width, widgetSizer.size);
	        }
	    }
	    /**
	     * Update the given split layout node.
	     *
	     * @param splitNode - The split node of interest.
	     *
	     * @param x - The offset left position of the layout area.
	     *
	     * @param y - The offset top position of the layout area.
	     *
	     * @param width - The width of the layout area.
	     *
	     * @param height - The height of the layout area.
	     *
	     * @param spacing - The spacing to use between tab areas.
	     */
	    function updateSplitNode(splitNode, x, y, width, height, spacing) {
	        // Compute the available layout space.
	        var horizontal = splitNode.orientation === 'horizontal';
	        var fixed = Math.max(0, splitNode.children.length - 1) * spacing;
	        var space = Math.max(0, (horizontal ? width : height) - fixed);
	        // De-normalize the split node if needed.
	        if (splitNode.normalized) {
	            iteration_1.each(splitNode.sizers, function (sizer) { sizer.sizeHint *= space; });
	            splitNode.normalized = false;
	        }
	        // Distribute the layout space to the sizers.
	        boxengine_1.boxCalc(splitNode.sizers, space);
	        // Update the geometry of the child areas and handles.
	        for (var i = 0, n = splitNode.children.length; i < n; ++i) {
	            var child = splitNode.children.at(i);
	            var size = splitNode.sizers.at(i).size;
	            var hStyle = splitNode.handles.at(i).style;
	            if (horizontal) {
	                updateLayoutNode(child, x, y, size, height, spacing);
	                x += size;
	                hStyle.top = y + "px";
	                hStyle.left = x + "px";
	                hStyle.width = spacing + "px";
	                hStyle.height = height + "px";
	                x += spacing;
	            }
	            else {
	                updateLayoutNode(child, x, y, width, size, spacing);
	                y += size;
	                hStyle.top = y + "px";
	                hStyle.left = x + "px";
	                hStyle.width = width + "px";
	                hStyle.height = spacing + "px";
	                y += spacing;
	            }
	        }
	    }
	})(Private || (Private = {}));


/***/ },
/* 67 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * An object which stores MIME data for general application use.
	 *
	 * #### Notes
	 * This class does not attempt to enforce "correctness" of MIME types
	 * and their associated data. Since this class is designed to transfer
	 * arbitrary data and objects within the same application, it assumes
	 * that the user provides correct and accurate data.
	 */
	var MimeData = (function () {
	    function MimeData() {
	        this._types = [];
	        this._values = [];
	    }
	    /**
	     * Get an array of the MIME types contained within the dataset.
	     *
	     * @returns A new array of the MIME types, in order of insertion.
	     */
	    MimeData.prototype.types = function () {
	        return this._types.slice();
	    };
	    /**
	     * Test whether the dataset has an entry for the given type.
	     *
	     * @param mime - The MIME type of interest.
	     *
	     * @returns `true` if the dataset contains a value for the given
	     *   MIME type, `false` otherwise.
	     */
	    MimeData.prototype.hasData = function (mime) {
	        return this._types.indexOf(mime) !== -1;
	    };
	    /**
	     * Get the data value for the given MIME type.
	     *
	     * @param mime - The MIME type of interest.
	     *
	     * @returns The value for the given MIME type, or `undefined` if
	     *   the dataset does not contain a value for the type.
	     */
	    MimeData.prototype.getData = function (mime) {
	        var i = this._types.indexOf(mime);
	        return i !== -1 ? this._values[i] : void 0;
	    };
	    /**
	     * Set the data value for the given MIME type.
	     *
	     * @param mime - The MIME type of interest.
	     *
	     * @param data - The data value for the given MIME type.
	     *
	     * #### Notes
	     * This will overwrite any previous entry for the MIME type.
	     */
	    MimeData.prototype.setData = function (mime, data) {
	        this.clearData(mime);
	        this._types.push(mime);
	        this._values.push(data);
	    };
	    /**
	     * Remove the data entry for the given MIME type.
	     *
	     * @param mime - The MIME type of interest.
	     *
	     * #### Notes
	     * This is a no-op if there is no entry for the given MIME type.
	     */
	    MimeData.prototype.clearData = function (mime) {
	        var i = this._types.indexOf(mime);
	        if (i === -1)
	            return;
	        this._types.splice(i, 1);
	        this._values.splice(i, 1);
	    };
	    /**
	     * Remove all data entries from the dataset.
	     */
	    MimeData.prototype.clear = function () {
	        this._types.length = 0;
	        this._values.length = 0;
	    };
	    return MimeData;
	}());
	exports.MimeData = MimeData;


/***/ },
/* 68 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var disposable_1 = __webpack_require__(30);
	/**
	 * The class name added to the document body during cursor override.
	 */
	var OVERRIDE_CURSOR_CLASS = 'p-mod-override-cursor';
	/**
	 * Override the cursor for the entire document.
	 *
	 * @param cursor - The string representing the cursor style.
	 *
	 * @returns A disposable which will clear the override when disposed.
	 *
	 * #### Notes
	 * The most recent call to `overrideCursor` takes precedence. Disposing
	 * an old override is a no-op and will not effect the current override.
	 *
	 * #### Example
	 * ```typescript
	 * import { overrideCursor } from 'phosphor/lib/dom/cursor';
	 *
	 * // force the cursor to be 'wait' for the entire document
	 * let override = overrideCursor('wait');
	 *
	 * // clear the override by disposing the return value
	 * override.dispose();
	 * ```
	 */
	function overrideCursor(cursor) {
	    var id = ++Private.cursorID;
	    var body = document.body;
	    body.style.cursor = cursor;
	    body.classList.add(OVERRIDE_CURSOR_CLASS);
	    return new disposable_1.DisposableDelegate(function () {
	        if (id === Private.cursorID) {
	            body.style.cursor = '';
	            body.classList.remove(OVERRIDE_CURSOR_CLASS);
	        }
	    });
	}
	exports.overrideCursor = overrideCursor;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * The id for the active cursor override.
	     */
	    Private.cursorID = 0;
	})(Private || (Private = {}));


/***/ },
/* 69 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var cursor_1 = __webpack_require__(68);
	/**
	 * The class name added to drag image nodes.
	 */
	var DRAG_IMAGE_CLASS = 'p-mod-drag-image';
	/**
	 * An object which manages a drag-drop operation.
	 *
	 * A drag object dispatches four different events to drop targets:
	 *
	 * - `'p-dragenter'` - Dispatched when the mouse enters the target
	 *   element. This event must be canceled in order to receive any
	 *   of the other events.
	 *
	 * - `'p-dragover'` - Dispatched when the mouse moves over the drop
	 *   target. It must cancel the event and set the `dropAction` to one
	 *   of the supported actions in order to receive drop events.
	 *
	 * - `'p-dragleave'` - Dispatched when the mouse leaves the target
	 *   element. This includes moving the mouse into child elements.
	 *
	 * - `'p-drop'`- Dispatched when the mouse is released over the target
	 *   element when the target indicates an appropriate drop action. If
	 *   the event is canceled, the indicated drop action is returned to
	 *   the initiator through the resolved promise.
	 *
	 * A drag operation can be canceled at any time by pressing `Escape`
	 * or by disposing the drag object.
	 *
	 * #### Notes
	 * This class is designed to be used when dragging and dropping custom
	 * data *within* a single application. It is *not* a replacement for
	 * the native drag-drop API. Instead, it provides an API which allows
	 * drag operations to be initiated programmatically and enables the
	 * transfer of arbitrary non-string objects; two features which are
	 * not possible with the native drag-drop APIs.
	 */
	var Drag = (function () {
	    /**
	     * Construct a new drag object.
	     *
	     * @param options - The options for initializing the drag.
	     */
	    function Drag(options) {
	        this._disposed = false;
	        this._source = null;
	        this._mimeData = null;
	        this._dragImage = null;
	        this._dropAction = 'none';
	        this._proposedAction = 'copy';
	        this._supportedActions = 'all';
	        this._override = null;
	        this._currentTarget = null;
	        this._currentElement = null;
	        this._promise = null;
	        this._resolve = null;
	        this._mimeData = options.mimeData;
	        if (options.dragImage !== void 0) {
	            this._dragImage = options.dragImage;
	        }
	        if (options.proposedAction !== void 0) {
	            this._proposedAction = options.proposedAction;
	        }
	        if (options.supportedActions !== void 0) {
	            this._supportedActions = options.supportedActions;
	        }
	        if (options.source !== void 0) {
	            this._source = options.source;
	        }
	    }
	    /**
	     * Dispose of the resources held by the drag object.
	     *
	     * #### Notes
	     * This will cancel the drag operation if it is active.
	     *
	     * All calls made after the first call to this method are a no-op.
	     */
	    Drag.prototype.dispose = function () {
	        // Do nothing if the drag object is already disposed.
	        if (this._disposed) {
	            return;
	        }
	        this._disposed = true;
	        // If there is a current target, dispatch a drag leave event.
	        if (this._currentTarget) {
	            var event_1 = Private.createMouseEvent('mouseup', -1, -1);
	            Private.dispatchDragLeave(this, this._currentTarget, null, event_1);
	        }
	        // Finalize the drag object with `'none'`.
	        this._finalize('none');
	    };
	    Object.defineProperty(Drag.prototype, "isDisposed", {
	        /**
	         * Test whether the drag object is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._disposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "mimeData", {
	        /**
	         * Get the mime data for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._mimeData;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "dragImage", {
	        /**
	         * Get the drag image element for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._dragImage;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "proposedAction", {
	        /**
	         * Get the proposed drop action for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._proposedAction;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "supportedActions", {
	        /**
	         * Get the supported drop actions for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._supportedActions;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "source", {
	        /**
	         * Get the drag source for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._source;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Start the drag operation at the specified client position.
	     *
	     * @param clientX - The client X position for the drag start.
	     *
	     * @param clientY - The client Y position for the drag start.
	     *
	     * @returns A promise which resolves to the result of the drag.
	     *
	     * #### Notes
	     * If the drag has already been started, the promise created by the
	     * first call to `start` is returned.
	     *
	     * If the drag operation has ended, or if the drag object has been
	     * disposed, the returned promise will resolve to `'none'`.
	     *
	     * The drag object will be automatically disposed when drag operation
	     * completes. This means `Drag` objects are for single-use only.
	     *
	     * This method assumes the left mouse button is already held down.
	     */
	    Drag.prototype.start = function (clientX, clientY) {
	        var _this = this;
	        // If the drag object is already disposed, resolve to `None`.
	        if (this._disposed) {
	            return Promise.resolve('none');
	        }
	        // If the drag has already been started, return the promise.
	        if (this._promise) {
	            return this._promise;
	        }
	        // Install the document listeners for the drag object.
	        this._addListeners();
	        // Attach the drag image at the specified client position.
	        this._attachDragImage(clientX, clientY);
	        // Create the promise which will be resolved on completion.
	        this._promise = new Promise(function (resolve, reject) {
	            _this._resolve = resolve;
	        });
	        // Trigger a fake move event to kick off the drag operation.
	        var event = Private.createMouseEvent('mousemove', clientX, clientY);
	        document.dispatchEvent(event);
	        // Return the pending promise for the drag operation.
	        return this._promise;
	    };
	    /**
	     * Handle the DOM events for the drag operation.
	     *
	     * @param event - The DOM event sent to the drag object.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the document. It should not be
	     * called directly by user code.
	     */
	    Drag.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'mousemove':
	                this._evtMouseMove(event);
	                break;
	            case 'mouseup':
	                this._evtMouseUp(event);
	                break;
	            case 'keydown':
	                this._evtKeyDown(event);
	                break;
	            default:
	                // Stop all other events during drag-drop.
	                event.preventDefault();
	                event.stopPropagation();
	                break;
	        }
	    };
	    /**
	     * Handle the `'mousemove'` event for the drag object.
	     */
	    Drag.prototype._evtMouseMove = function (event) {
	        // Stop all input events during drag-drop.
	        event.preventDefault();
	        event.stopPropagation();
	        // Update the current target node and dispatch enter/leave events.
	        this._updateCurrentTarget(event);
	        // Move the drag image to the specified client position. This is
	        // performed *after* dispatching to prevent unnecessary reflows.
	        this._moveDragImage(event.clientX, event.clientY);
	    };
	    /**
	     * Handle the `'mouseup'` event for the drag object.
	     */
	    Drag.prototype._evtMouseUp = function (event) {
	        // Stop all input events during drag-drop.
	        event.preventDefault();
	        event.stopPropagation();
	        // Do nothing if the left button is not released.
	        if (event.button !== 0) {
	            return;
	        }
	        // Update the current target node and dispatch enter/leave events.
	        // This prevents a subtle issue where the DOM mutates under the
	        // cursor after the last move event but before the drop event.
	        this._updateCurrentTarget(event);
	        // If there is no current target, finalize with `'none'`.
	        if (!this._currentTarget) {
	            this._finalize('none');
	            return;
	        }
	        // If the last drop action was `'none'`, dispatch a leave event
	        // to the current target and finalize the drag with `'none'`.
	        if (this._dropAction === 'none') {
	            Private.dispatchDragLeave(this, this._currentTarget, null, event);
	            this._finalize('none');
	            return;
	        }
	        // Dispatch the drop event at the current target and finalize
	        // with the resulting drop action.
	        var action = Private.dispatchDrop(this, this._currentTarget, event);
	        this._finalize(action);
	    };
	    /**
	     * Handle the `'keydown'` event for the drag object.
	     */
	    Drag.prototype._evtKeyDown = function (event) {
	        // Stop all input events during drag-drop.
	        event.preventDefault();
	        event.stopPropagation();
	        // Cancel the drag if `Escape` is pressed.
	        if (event.keyCode === 27)
	            this.dispose();
	    };
	    /**
	     * Add the document event listeners for the drag object.
	     */
	    Drag.prototype._addListeners = function () {
	        document.addEventListener('mousedown', this, true);
	        document.addEventListener('mousemove', this, true);
	        document.addEventListener('mouseup', this, true);
	        document.addEventListener('mouseenter', this, true);
	        document.addEventListener('mouseleave', this, true);
	        document.addEventListener('mouseover', this, true);
	        document.addEventListener('mouseout', this, true);
	        document.addEventListener('keydown', this, true);
	        document.addEventListener('keyup', this, true);
	        document.addEventListener('keypress', this, true);
	        document.addEventListener('contextmenu', this, true);
	    };
	    /**
	     * Remove the document event listeners for the drag object.
	     */
	    Drag.prototype._removeListeners = function () {
	        document.removeEventListener('mousedown', this, true);
	        document.removeEventListener('mousemove', this, true);
	        document.removeEventListener('mouseup', this, true);
	        document.removeEventListener('mouseenter', this, true);
	        document.removeEventListener('mouseleave', this, true);
	        document.removeEventListener('mouseover', this, true);
	        document.removeEventListener('mouseout', this, true);
	        document.removeEventListener('keydown', this, true);
	        document.removeEventListener('keyup', this, true);
	        document.removeEventListener('keypress', this, true);
	        document.removeEventListener('contextmenu', this, true);
	    };
	    /**
	     * Update the current target node using the given mouse event.
	     */
	    Drag.prototype._updateCurrentTarget = function (event) {
	        // Fetch common local state.
	        var prevTarget = this._currentTarget;
	        var currTarget = this._currentTarget;
	        var prevElem = this._currentElement;
	        // Find the current indicated element at the given position.
	        var currElem = document.elementFromPoint(event.clientX, event.clientY);
	        // Update the current element reference.
	        this._currentElement = currElem;
	        // Note: drag enter fires *before* drag leave according to spec.
	        // https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	        // If the indicated element changes from the previous iteration,
	        // and is different from the current target, dispatch the enter
	        // events and compute the new target element.
	        if (currElem !== prevElem && currElem !== currTarget) {
	            currTarget = Private.dispatchDragEnter(this, currElem, currTarget, event);
	        }
	        // If the current target element has changed, update the current
	        // target reference and dispatch the leave event to the old target.
	        if (currTarget !== prevTarget) {
	            this._currentTarget = currTarget;
	            Private.dispatchDragLeave(this, prevTarget, currTarget, event);
	        }
	        // Dispatch the drag over event and update the drop action.
	        var action = Private.dispatchDragOver(this, currTarget, event);
	        this._setDropAction(action);
	    };
	    /**
	     * Attach the drag image element at the specified location.
	     *
	     * This is a no-op if there is no drag image element.
	     */
	    Drag.prototype._attachDragImage = function (clientX, clientY) {
	        if (!this._dragImage) {
	            return;
	        }
	        this._dragImage.classList.add(DRAG_IMAGE_CLASS);
	        var style = this._dragImage.style;
	        style.pointerEvents = 'none';
	        style.position = 'absolute';
	        style.top = clientY + "px";
	        style.left = clientX + "px";
	        document.body.appendChild(this._dragImage);
	    };
	    /**
	     * Move the drag image element to the specified location.
	     *
	     * This is a no-op if there is no drag image element.
	     */
	    Drag.prototype._moveDragImage = function (clientX, clientY) {
	        if (!this._dragImage) {
	            return;
	        }
	        var style = this._dragImage.style;
	        style.top = clientY + "px";
	        style.left = clientX + "px";
	    };
	    /**
	     * Detach the drag image element from the DOM.
	     *
	     * This is a no-op if there is no drag image element.
	     */
	    Drag.prototype._detachDragImage = function () {
	        if (!this._dragImage) {
	            return;
	        }
	        var parent = this._dragImage.parentNode;
	        if (!parent) {
	            return;
	        }
	        parent.removeChild(this._dragImage);
	    };
	    /**
	     * Set the internal drop action state and update the drag cursor.
	     */
	    Drag.prototype._setDropAction = function (action) {
	        action = Private.validateAction(action, this._supportedActions);
	        if (this._override && this._dropAction === action) {
	            return;
	        }
	        switch (action) {
	            case 'none':
	                this._dropAction = action;
	                this._override = cursor_1.overrideCursor('no-drop');
	                break;
	            case 'copy':
	                this._dropAction = action;
	                this._override = cursor_1.overrideCursor('copy');
	                break;
	            case 'link':
	                this._dropAction = action;
	                this._override = cursor_1.overrideCursor('alias');
	                break;
	            case 'move':
	                this._dropAction = action;
	                this._override = cursor_1.overrideCursor('move');
	                break;
	        }
	    };
	    /**
	     * Finalize the drag operation and resolve the drag promise.
	     */
	    Drag.prototype._finalize = function (action) {
	        // Store the resolve function as a temp variable.
	        var resolve = this._resolve;
	        // Remove the document event listeners.
	        this._removeListeners();
	        // Detach the drag image.
	        this._detachDragImage();
	        // Dispose of the cursor override.
	        if (this._override)
	            this._override.dispose();
	        // Clear the mime data.
	        if (this._mimeData)
	            this._mimeData.clear();
	        // Clear the internal drag state.
	        this._disposed = true;
	        this._source = null;
	        this._mimeData = null;
	        this._dragImage = null;
	        this._dropAction = 'none';
	        this._proposedAction = 'none';
	        this._supportedActions = 'none';
	        this._override = null;
	        this._currentTarget = null;
	        this._currentElement = null;
	        this._promise = null;
	        this._resolve = null;
	        // Resolve the promise to the given drop action, if possible.
	        if (resolve)
	            resolve(action);
	    };
	    return Drag;
	}());
	exports.Drag = Drag;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Validate the given action is one of the supported actions.
	     *
	     * Returns the given action or `'none'` if the action is unsupported.
	     */
	    function validateAction(action, supported) {
	        var a = actionTable[action];
	        var b = supportedTable[supported];
	        return (a & b) ? action : 'none';
	    }
	    Private.validateAction = validateAction;
	    /**
	     * Create a left mouse event at the given position.
	     *
	     * @param type - The event type for the mouse event.
	     *
	     * @param clientX - The client X position.
	     *
	     * @param clientY - The client Y position.
	     *
	     * @returns A newly created and initialized mouse event.
	     */
	    function createMouseEvent(type, clientX, clientY) {
	        var event = document.createEvent('MouseEvent');
	        event.initMouseEvent(type, true, true, window, 0, 0, 0, clientX, clientY, false, false, false, false, 0, null);
	        return event;
	    }
	    Private.createMouseEvent = createMouseEvent;
	    /**
	     * Dispatch a drag enter event to the indicated element.
	     *
	     * @param drag - The drag object associated with the action.
	     *
	     * @param currElem - The currently indicated element, or `null`. This
	     *   is the "immediate user selection" from the whatwg spec.
	     *
	     * @param currTarget - The current drag target element, or `null`. This
	     *   is the "current target element" from the whatwg spec.
	     *
	     * @param event - The mouse event related to the action.
	     *
	     * @returns The element to use as the current drag target. This is the
	     *   "current target element" from the whatwg spec, and may be `null`.
	     *
	     * #### Notes
	     * This largely implements the drag enter portion of the whatwg spec:
	     * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	     */
	    function dispatchDragEnter(drag, currElem, currTarget, event) {
	        // If the current element is null, return null as the new target.
	        if (!currElem) {
	            return null;
	        }
	        // Dispatch a drag enter event to the current element.
	        var dragEvent = createDragEvent('p-dragenter', drag, event, currTarget);
	        var canceled = !currElem.dispatchEvent(dragEvent);
	        // If the event was canceled, use the current element as the new target.
	        if (canceled) {
	            return currElem;
	        }
	        // If the current element is the document body, keep the original target.
	        if (currElem === document.body) {
	            return currTarget;
	        }
	        // Dispatch a drag enter event on the document body.
	        dragEvent = createDragEvent('p-dragenter', drag, event, currTarget);
	        document.body.dispatchEvent(dragEvent);
	        // Ignore the event cancellation, and use the body as the new target.
	        return document.body;
	    }
	    Private.dispatchDragEnter = dispatchDragEnter;
	    /**
	     * Dispatch a drag leave event to the indicated element.
	     *
	     * @param drag - The drag object associated with the action.
	     *
	     * @param prevTarget - The previous target element, or `null`. This
	     *   is the previous "current target element" from the whatwg spec.
	     *
	     * @param currTarget - The current drag target element, or `null`. This
	     *   is the "current target element" from the whatwg spec.
	     *
	     * @param event - The mouse event related to the action.
	     *
	     * #### Notes
	     * This largely implements the drag leave portion of the whatwg spec:
	     * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	     */
	    function dispatchDragLeave(drag, prevTarget, currTarget, event) {
	        // If the previous target is null, do nothing.
	        if (!prevTarget) {
	            return;
	        }
	        // Dispatch the drag leave event to the previous target.
	        var dragEvent = createDragEvent('p-dragleave', drag, event, currTarget);
	        prevTarget.dispatchEvent(dragEvent);
	    }
	    Private.dispatchDragLeave = dispatchDragLeave;
	    /**
	     * Dispatch a drag over event to the indicated element.
	     *
	     * @param drag - The drag object associated with the action.
	     *
	     * @param currTarget - The current drag target element, or `null`. This
	     *   is the "current target element" from the whatwg spec.
	     *
	     * @param event - The mouse event related to the action.
	     *
	     * @returns The `DropAction` result of the drag over event.
	     *
	     * #### Notes
	     * This largely implements the drag over portion of the whatwg spec:
	     * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	     */
	    function dispatchDragOver(drag, currTarget, event) {
	        // If there is no current target, the drop action is none.
	        if (!currTarget) {
	            return 'none';
	        }
	        // Dispatch the drag over event to the current target.
	        var dragEvent = createDragEvent('p-dragover', drag, event, null);
	        var canceled = !currTarget.dispatchEvent(dragEvent);
	        // If the event was canceled, return the drop action result.
	        if (canceled) {
	            return dragEvent.dropAction;
	        }
	        // Otherwise, the effective drop action is none.
	        return 'none';
	    }
	    Private.dispatchDragOver = dispatchDragOver;
	    /**
	     * Dispatch a drop event to the indicated element.
	     *
	     * @param drag - The drag object associated with the action.
	     *
	     * @param currTarget - The current drag target element, or `null`. This
	     *   is the "current target element" from the whatwg spec.
	     *
	     * @param event - The mouse event related to the action.
	     *
	     * @returns The `DropAction` result of the drop event.
	     *
	     * #### Notes
	     * This largely implements the drag over portion of the whatwg spec:
	     * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	     */
	    function dispatchDrop(drag, currTarget, event) {
	        // If there is no current target, the drop action is none.
	        if (!currTarget) {
	            return 'none';
	        }
	        // Dispatch the drop event to the current target.
	        var dragEvent = createDragEvent('p-drop', drag, event, null);
	        var canceled = !currTarget.dispatchEvent(dragEvent);
	        // If the event was canceled, return the drop action result.
	        if (canceled) {
	            return dragEvent.dropAction;
	        }
	        // Otherwise, the effective drop action is none.
	        return 'none';
	    }
	    Private.dispatchDrop = dispatchDrop;
	    /**
	     * A lookup table from drop action to bit value.
	     */
	    var actionTable = {
	        'none': 0x0,
	        'copy': 0x1,
	        'link': 0x2,
	        'move': 0x4
	    };
	    /**
	     * A lookup table from supported action to drop action bit mask.
	     */
	    var supportedTable = {
	        'none': actionTable['none'],
	        'copy': actionTable['copy'],
	        'link': actionTable['link'],
	        'move': actionTable['move'],
	        'copy-link': actionTable['copy'] | actionTable['link'],
	        'copy-move': actionTable['copy'] | actionTable['move'],
	        'link-move': actionTable['link'] | actionTable['move'],
	        'all': actionTable['copy'] | actionTable['link'] | actionTable['move']
	    };
	    /**
	     * Create a new initialized `IDragEvent` from the given data.
	     *
	     * @param type - The event type for the drag event.
	     *
	     * @param drag - The drag object to use for seeding the drag data.
	     *
	     * @param event - The mouse event to use for seeding the mouse data.
	     *
	     * @param related - The related target for the event, or `null`.
	     *
	     * @returns A new object which implements `IDragEvent`.
	     */
	    function createDragEvent(type, drag, event, related) {
	        // Create a new mouse event and cast to a custom drag event.
	        var dragEvent = document.createEvent('MouseEvent');
	        // Initialize the mouse event data.
	        dragEvent.initMouseEvent(type, true, true, window, 0, event.screenX, event.screenY, event.clientX, event.clientY, event.ctrlKey, event.altKey, event.shiftKey, event.metaKey, event.button, related);
	        // Add the custom drag event data.
	        dragEvent.dropAction = 'none';
	        dragEvent.mimeData = drag.mimeData;
	        dragEvent.proposedAction = drag.proposedAction;
	        dragEvent.supportedActions = drag.supportedActions;
	        dragEvent.source = drag.source;
	        // Return the fully initialized drag event.
	        return dragEvent;
	    }
	})(Private || (Private = {}));


/***/ },
/* 70 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * Test whether a client position lies within a node.
	 *
	 * @param node - The DOM node of interest.
	 *
	 * @param clientX - The client X coordinate of interest.
	 *
	 * @param clientY - The client Y coordinate of interest.
	 *
	 * @returns `true` if the node covers the position, `false` otherwise.
	 *
	 * #### Example
	 * ```typescript
	 * import { hitTest } from 'phosphor/lib/dom/query';
	 *
	 * let div = document.createElement('div');
	 * div.style.position = 'absolute';
	 * div.style.left = '0px';
	 * div.style.top = '0px';
	 * div.style.width = '100px';
	 * div.style.height = '100px';
	 * document.body.appendChild(div);
	 *
	 * hitTest(div, 50, 50);   // true
	 * hitTest(div, 150, 150); // false
	 * ```
	 */
	function hitTest(node, clientX, clientY) {
	    var rect = node.getBoundingClientRect();
	    return (clientX >= rect.left &&
	        clientX < rect.right &&
	        clientY >= rect.top &&
	        clientY < rect.bottom);
	}
	exports.hitTest = hitTest;
	/**
	 * Vertically scroll an element into view if needed.
	 *
	 * @param area - The scroll area element.
	 *
	 * @param elem - The element of interest.
	 *
	 * #### Notes
	 * This follows the "nearest" behavior of the native `scrollIntoView`
	 * method, which is not supported by all browsers.
	 * https://drafts.csswg.org/cssom-view/#element-scrolling-members
	 *
	 * If the element fully covers the visible area or is fully contained
	 * within the visible area, no scrolling will take place. Otherwise,
	 * the nearest edges of the area and element are aligned.
	 *
	 * #### Example
	 * ```typescript
	 * import { scrollIntoViewIfNeeded } from 'phosphor/lib/dom/query';
	 *
	 * let area = document.createElement('div');
	 * let elem = document.createElement('div');
	 *
	 * // Style the scrollable area with a small height and a black border.
	 * area.style.height = '100px';
	 * area.style.overflow = 'auto';
	 * area.style.border = '1px solid black';
	 *
	 * // Style the element of interest with a red border and some content.
	 * elem.style.border = '1px solid red';
	 * elem.textContent = 'visible content';
	 *
	 * // Add enough whitespace to to guarantee scrolling.
	 * for (let i = 0; i < 50; i++) {
	 *   area.appendChild(document.createElement('br'));
	 * }
	 *
	 * // Attach the nodes to the DOM.
	 * area.appendChild(elem);
	 * document.body.appendChild(area);
	 *
	 * // Scroll to the element of interest.
	 * scrollIntoViewIfNeeded(area, elem);
	 * ```
	 */
	function scrollIntoViewIfNeeded(area, elem) {
	    var ar = area.getBoundingClientRect();
	    var er = elem.getBoundingClientRect();
	    if (er.top <= ar.top && er.bottom >= ar.bottom) {
	        return;
	    }
	    if (er.top < ar.top && er.height <= ar.height) {
	        area.scrollTop -= ar.top - er.top;
	        return;
	    }
	    if (er.bottom > ar.bottom && er.height >= ar.height) {
	        area.scrollTop -= ar.top - er.top;
	        return;
	    }
	    if (er.top < ar.top && er.height > ar.height) {
	        area.scrollTop -= ar.bottom - er.bottom;
	        return;
	    }
	    if (er.bottom > ar.bottom && er.height < ar.height) {
	        area.scrollTop -= ar.bottom - er.bottom;
	        return;
	    }
	}
	exports.scrollIntoViewIfNeeded = scrollIntoViewIfNeeded;


/***/ },
/* 71 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(26);
	var searching_1 = __webpack_require__(27);
	var vector_1 = __webpack_require__(29);
	var signaling_1 = __webpack_require__(20);
	/**
	 * A class which tracks focus among a set of widgets.
	 *
	 * This class is useful when code needs to keep track of the most
	 * recently focused widget(s) among a set of related widgets.
	 */
	var FocusTracker = (function () {
	    /**
	     * Construct a new focus tracker.
	     */
	    function FocusTracker() {
	        this._counter = 0;
	        this._currentWidget = null;
	        this._widgets = new vector_1.Vector();
	        this._numbers = new Map();
	        this._nodes = new Map();
	    }
	    /**
	     * Dispose of the resources held by the tracker.
	     */
	    FocusTracker.prototype.dispose = function () {
	        var _this = this;
	        // Do nothing if the tracker is already disposed.
	        if (this._counter < 0) {
	            return;
	        }
	        // Mark the tracker as disposed.
	        this._counter = -1;
	        // Clear the connections for the tracker.
	        signaling_1.clearSignalData(this);
	        // Remove all event listeners.
	        iteration_1.each(this._widgets, function (widget) {
	            widget.node.removeEventListener('focus', _this, true);
	        });
	        // Clear the internal data structures.
	        this._currentWidget = null;
	        this._nodes.clear();
	        this._numbers.clear();
	        this._widgets.clear();
	    };
	    Object.defineProperty(FocusTracker.prototype, "isDisposed", {
	        /**
	         * A flag indicated whether the tracker is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._counter < 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(FocusTracker.prototype, "currentWidget", {
	        /**
	         * The current widget in the tracker.
	         *
	         * #### Notes
	         * The current widget is the widget among the tracked widgets which
	         * has the *descendant node* which has most recently been focused.
	         *
	         * The current widget will not be updated if the node loses focus. It
	         * will only be updated when a different tracked widget gains focus.
	         *
	         * If the current widget is removed from the tracker, the previous
	         * current widget will be restored.
	         *
	         * This behavior is intended to follow a user's conceptual model of
	         * a semantically "active" widget, where the "last thing of type X"
	         * to be interacted with is the "active instance of X", regardless
	         * of whether that instance still has focus.
	         *
	         * This will be `null` if there is no current widget.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._currentWidget;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(FocusTracker.prototype, "widgets", {
	        /**
	         * A read only sequence of the widgets being tracked.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._widgets;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the focus number for a particular widget in the tracker.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The focus number for the given widget, or `-1` if the
	     *   widget has not had focus since being added to the tracker.
	     *
	     * #### Notes
	     * The focus number indicates the relative order in which the widgets
	     * have gained focus. A widget with a larger number has gained focus
	     * more recently than a widget with a smaller number.
	     *
	     * The `currentWidget` will always have the largest focus number.
	     *
	     * All widgets start with a focus number of `-1`, which indicates that
	     * the widget has not been focused since being added to the tracker.
	     *
	     * #### Undefined Behavior
	     * A `widget` which is not contained in the tracker.
	     */
	    FocusTracker.prototype.focusNumber = function (widget) {
	        return this._numbers.get(widget);
	    };
	    /**
	     * Test whether the focus tracker contains a given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns `true` if the widget is tracked, `false` otherwise.
	     */
	    FocusTracker.prototype.has = function (widget) {
	        return this._numbers.has(widget);
	    };
	    /**
	     * Add a widget to the focus tracker.
	     *
	     * @param widget - The widget of interest.
	     *
	     * #### Notes
	     * If the widget is currently focused, it will automatically become
	     * the new `currentWidget`.
	     *
	     * A widget will be automatically removed from the tracker if it
	     * is disposed after being added.
	     *
	     * If the widget is already tracked, this is a no-op.
	     */
	    FocusTracker.prototype.add = function (widget) {
	        // Do nothing if the widget is already tracked.
	        if (this._numbers.has(widget)) {
	            return;
	        }
	        // Test whether this widget has focus.
	        var focused = widget.node.contains(document.activeElement);
	        // Setup the initial focus number.
	        var n = focused ? this._counter++ : -1;
	        // Add the widget to the internal data structures.
	        this._numbers.set(widget, n);
	        this._widgets.pushBack(widget);
	        this._nodes.set(widget.node, widget);
	        // Setup the focus event listener. The capturing phase must
	        // be used since the 'focus' event doesn't bubble and since
	        // firefox doesn't support the 'focusin' event.
	        widget.node.addEventListener('focus', this, true);
	        // Connect the disposed signal handler.
	        widget.disposed.connect(this._onWidgetDisposed, this);
	        // Update the current widget if the new widget has focus.
	        if (focused)
	            this._setCurrentWidget(widget);
	    };
	    /**
	     * Remove a widget from the focus tracker.
	     *
	     * #### Notes
	     * If the widget is the `currentWidget`, the previous current widget
	     * will become the new `currentWidget`.
	     *
	     * A widget will be automatically removed from the tracker if it
	     * is disposed after being added.
	     *
	     * If the widget is not tracked, this is a no-op.
	     */
	    FocusTracker.prototype.remove = function (widget) {
	        var _this = this;
	        // Do nothing if the widget is not tracked.
	        if (!this._numbers.has(widget)) {
	            return;
	        }
	        // Disconnect the disposed signal handler.
	        widget.disposed.disconnect(this._onWidgetDisposed, this);
	        // Remove the focus event listener.
	        widget.node.removeEventListener('focus', this, true);
	        // Remove the widget from the internal data structures.
	        this._widgets.remove(widget);
	        this._nodes.delete(widget.node);
	        this._numbers.delete(widget);
	        // If the widget is not the current widget, we're done.
	        if (this._currentWidget !== widget) {
	            return;
	        }
	        // Otherwise, filter the widgets for those which have had focus.
	        var valid = iteration_1.filter(this._widgets, function (w) { return _this._numbers.get(w) !== -1; });
	        // Get the valid widget with the max focus number.
	        var previous = searching_1.max(valid, function (first, second) {
	            var a = _this._numbers.get(first);
	            var b = _this._numbers.get(second);
	            return a - b;
	        }) || null;
	        // Finally, update the current widget.
	        this._setCurrentWidget(previous);
	    };
	    /**
	     * Handle the DOM events for the focus tracker.
	     *
	     * @param event - The DOM event sent to the panel.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the tracked nodes. It should
	     * not be called directly by user code.
	     */
	    FocusTracker.prototype.handleEvent = function (event) {
	        if (event.type === 'focus') {
	            this._evtFocus(event);
	        }
	    };
	    /**
	     * Set the current widget for the tracker.
	     */
	    FocusTracker.prototype._setCurrentWidget = function (widget) {
	        // Do nothing if there is no change.
	        if (this._currentWidget === widget) {
	            return;
	        }
	        // Swap the current widget.
	        var old = this._currentWidget;
	        this._currentWidget = widget;
	        // Emit the changed signal.
	        this.currentChanged.emit({ oldValue: old, newValue: widget });
	    };
	    /**
	     * Handle the `'focus'` event for a tracked widget.
	     */
	    FocusTracker.prototype._evtFocus = function (event) {
	        // Find the widget which gained focus.
	        var widget = this._nodes.get(event.currentTarget);
	        // Update the focus number for the widget.
	        this._numbers.set(widget, this._counter++);
	        // Update the current widget.
	        this._setCurrentWidget(widget);
	    };
	    /**
	     * Handle the `disposed` signal for a tracked widget.
	     */
	    FocusTracker.prototype._onWidgetDisposed = function (sender) {
	        this.remove(sender);
	    };
	    return FocusTracker;
	}());
	exports.FocusTracker = FocusTracker;
	// Define the signals for the `FocusTracker` class.
	signaling_1.defineSignal(FocusTracker.prototype, 'currentChanged');


/***/ },
/* 72 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(26);
	var mutation_1 = __webpack_require__(62);
	var searching_1 = __webpack_require__(27);
	var vector_1 = __webpack_require__(29);
	var messaging_1 = __webpack_require__(56);
	var signaling_1 = __webpack_require__(20);
	var cursor_1 = __webpack_require__(68);
	var query_1 = __webpack_require__(70);
	var title_1 = __webpack_require__(59);
	var vdom_1 = __webpack_require__(73);
	var widget_1 = __webpack_require__(55);
	/**
	 * The class name added to TabBar instances.
	 */
	var TAB_BAR_CLASS = 'p-TabBar';
	/**
	 * The class name added to a tab bar content node.
	 */
	var CONTENT_CLASS = 'p-TabBar-content';
	/**
	 * The class name added to a tab bar tab.
	 */
	var TAB_CLASS = 'p-TabBar-tab';
	/**
	 * The class name added to a tab label node.
	 */
	var LABEL_CLASS = 'p-TabBar-tabLabel';
	/**
	 * The class name added to a tab icon node.
	 */
	var ICON_CLASS = 'p-TabBar-tabIcon';
	/**
	 * The class name added to a tab close icon node.
	 */
	var CLOSE_ICON_CLASS = 'p-TabBar-tabCloseIcon';
	/**
	 * The class name added to a tab bar and tab when dragging.
	 */
	var DRAGGING_CLASS = 'p-mod-dragging';
	/**
	 * The class name added to the current tab.
	 */
	var CURRENT_CLASS = 'p-mod-current';
	/**
	 * The class name added to a closable tab.
	 */
	var CLOSABLE_CLASS = 'p-mod-closable';
	/**
	 * The start drag distance threshold.
	 */
	var DRAG_THRESHOLD = 5;
	/**
	 * The detach distance threshold.
	 */
	var DETACH_THRESHOLD = 20;
	/**
	 * The DOM structure for a TabBar.
	 */
	var TAB_BAR_NODE = (vdom_1.h.div(vdom_1.h.ul({ className: CONTENT_CLASS })));
	/**
	 * A widget which displays titles as a single row or column of tabs.
	 *
	 * #### Notes
	 * If CSS transforms are used to rotate nodes for vertically oriented
	 * text, then tab dragging will not work correctly. The `tabsMovable`
	 * property should be set to `false` when rotating nodes from CSS.
	 */
	var TabBar = (function (_super) {
	    __extends(TabBar, _super);
	    /**
	     * Construct a new tab bar.
	     *
	     * @param options - The options for initializing the tab bar.
	     */
	    function TabBar(options) {
	        if (options === void 0) { options = {}; }
	        _super.call(this, { node: vdom_1.realize(TAB_BAR_NODE) });
	        this._currentIndex = -1;
	        this._previousTitle = null;
	        this._titles = new vector_1.Vector();
	        this._dragData = null;
	        this.addClass(TAB_BAR_CLASS);
	        this.setFlag(widget_1.WidgetFlag.DisallowLayout);
	        this._tabsMovable = options.tabsMovable || false;
	        this._allowDeselect = options.allowDeselect || false;
	        this._orientation = options.orientation || 'horizontal';
	        this._renderer = options.renderer || TabBar.defaultRenderer;
	        this._insertBehavior = options.insertBehavior || 'select-tab-if-needed';
	        this._removeBehavior = options.removeBehavior || 'select-tab-after';
	        this.addClass("p-mod-" + this._orientation);
	    }
	    /**
	     * Dispose of the resources held by the widget.
	     */
	    TabBar.prototype.dispose = function () {
	        this._releaseMouse();
	        this._titles.clear();
	        this._renderer = null;
	        this._previousTitle = null;
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(TabBar.prototype, "contentNode", {
	        /**
	         * Get the tab bar content node.
	         *
	         * #### Notes
	         * This is the node which holds the tab nodes.
	         *
	         * Modifying this node directly can lead to undefined behavior.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.node.getElementsByClassName(CONTENT_CLASS)[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "titles", {
	        /**
	         * A read-only sequence of the titles in the tab bar.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._titles;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "currentTitle", {
	        /**
	         * Get the currently selected title.
	         *
	         * #### Notes
	         * This will be `null` if no tab is selected.
	         */
	        get: function () {
	            var i = this._currentIndex;
	            return i !== -1 ? this._titles.at(i) : null;
	        },
	        /**
	         * Set the currently selected title.
	         *
	         * #### Notes
	         * If the title does not exist, the title will be set to `null`.
	         */
	        set: function (value) {
	            this.currentIndex = searching_1.indexOf(this._titles, value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "currentIndex", {
	        /**
	         * Get the index of the currently selected tab.
	         *
	         * #### Notes
	         * This will be `-1` if no tab is selected.
	         */
	        get: function () {
	            return this._currentIndex;
	        },
	        /**
	         * Set the index of the currently selected tab.
	         *
	         * #### Notes
	         * If the value is out of range, the index will be set to `-1`.
	         */
	        set: function (value) {
	            // Coerce the value to an index.
	            var i = Math.floor(value);
	            if (i < 0 || i >= this._titles.length) {
	                i = -1;
	            }
	            // Bail early if the index will not change.
	            if (this._currentIndex === i) {
	                return;
	            }
	            // Look up the previous index and title.
	            var pi = this._currentIndex;
	            var pt = pi === -1 ? null : this._titles.at(pi);
	            // Look up the current index and title.
	            var ci = i;
	            var ct = ci === -1 ? null : this._titles.at(ci);
	            // Update the current index and previous title.
	            this._currentIndex = ci;
	            this._previousTitle = pt;
	            // Emit the current changed signal.
	            this.currentChanged.emit({
	                previousIndex: pi, previousTitle: pt,
	                currentIndex: ci, currentTitle: ct
	            });
	            // Schedule an update of the tabs.
	            this.update();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "orientation", {
	        /**
	         * Get the orientation of the tab bar.
	         *
	         * #### Notes
	         * This controls whether the tabs are arranged in a row or column.
	         */
	        get: function () {
	            return this._orientation;
	        },
	        /**
	         * Set the orientation of the tab bar.
	         *
	         * #### Notes
	         * This controls whether the tabs are arranged in a row or column.
	         */
	        set: function (value) {
	            // Do nothing if the orientation does not change.
	            if (this._orientation === value) {
	                return;
	            }
	            // Release the mouse before making any changes.
	            this._releaseMouse();
	            // Swap the orientation values.
	            var old = this._orientation;
	            this._orientation = value;
	            // Toggle the orientation classes.
	            this.removeClass("p-mod-" + old);
	            this.addClass("p-mod-" + value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "tabsMovable", {
	        /**
	         * Get whether the tabs are movable by the user.
	         *
	         * #### Notes
	         * Tabs can always be moved programmatically.
	         */
	        get: function () {
	            return this._tabsMovable;
	        },
	        /**
	         * Set whether the tabs are movable by the user.
	         *
	         * #### Notes
	         * Tabs can always be moved programmatically.
	         */
	        set: function (value) {
	            this._tabsMovable = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "allowDeselect", {
	        /**
	         * Get whether a tab can be deselected by the user.
	         *
	         * #### Notes
	         * Tabs can be always be deselected programmatically.
	         */
	        get: function () {
	            return this._allowDeselect;
	        },
	        /**
	         * Set whether a tab can be deselected by the user.
	         *
	         * #### Notes
	         * Tabs can be always be deselected programmatically.
	         */
	        set: function (value) {
	            this._allowDeselect = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "insertBehavior", {
	        /**
	         * Get the selection behavior when inserting a tab.
	         */
	        get: function () {
	            return this._insertBehavior;
	        },
	        /**
	         * Set the selection behavior when inserting a tab.
	         */
	        set: function (value) {
	            this._insertBehavior = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "removeBehavior", {
	        /**
	         * Get the selection behavior when removing a tab.
	         */
	        get: function () {
	            return this._removeBehavior;
	        },
	        /**
	         * Set the selection behavior when removing a tab.
	         */
	        set: function (value) {
	            this._removeBehavior = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "renderer", {
	        /**
	         * The renderer used by the tab bar.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._renderer;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Add a tab to the end of the tab bar.
	     *
	     * @param value - The title which holds the data for the tab,
	     *   or an options object to convert to a title.
	     *
	     * @returns The title object added to the tab bar.
	     *
	     * #### Notes
	     * If the title is already added to the tab bar, it will be moved.
	     */
	    TabBar.prototype.addTab = function (value) {
	        return this.insertTab(this._titles.length, value);
	    };
	    /**
	     * Insert a tab into the tab bar at the specified index.
	     *
	     * @param index - The index at which to insert the tab.
	     *
	     * @param value - The title which holds the data for the tab,
	     *   or an options object to convert to a title.
	     *
	     * @returns The title object added to the tab bar.
	     *
	     * #### Notes
	     * The index will be clamped to the bounds of the tabs.
	     *
	     * If the title is already added to the tab bar, it will be moved.
	     */
	    TabBar.prototype.insertTab = function (index, value) {
	        // Release the mouse before making any changes.
	        this._releaseMouse();
	        // Coerce the value to a title.
	        var title = Private.asTitle(value);
	        // Look up the index of the title.
	        var i = searching_1.indexOf(this._titles, title);
	        // Clamp the insert index to the vector bounds.
	        var j = Math.max(0, Math.min(Math.floor(index), this._titles.length));
	        // If the title is not in the vector, insert it.
	        if (i === -1) {
	            // Insert the title into the vector.
	            this._titles.insert(j, title);
	            // Connect to the title changed signal.
	            title.changed.connect(this._onTitleChanged, this);
	            // Adjust the current index for the insert.
	            this._adjustCurrentForInsert(j, title);
	            // Schedule an update of the tabs.
	            this.update();
	            // Return the title added to the tab bar.
	            return title;
	        }
	        // Otherwise, the title exists in the vector and should be moved.
	        // Adjust the index if the location is at the end of the vector.
	        if (j === this._titles.length)
	            j--;
	        // Bail if there is no effective move.
	        if (i === j)
	            return title;
	        // Move the title to the new location.
	        mutation_1.move(this._titles, i, j);
	        // Adjust the current index for the move.
	        this._adjustCurrentForMove(i, j);
	        // Schedule an update of the tabs.
	        this.update();
	        // Return the title added to the tab bar.
	        return title;
	    };
	    /**
	     * Remove a tab from the tab bar.
	     *
	     * @param title - The title for the tab to remove.
	     *
	     * @returns The index occupied by the tab, or `-1` if the tab
	     *   was not contained in the tab bar.
	     */
	    TabBar.prototype.removeTab = function (title) {
	        var index = searching_1.indexOf(this._titles, title);
	        if (index !== -1)
	            this.removeTabAt(index);
	        return index;
	    };
	    /**
	     * Remove the tab at a given index from the tab bar.
	     *
	     * @param index - The index of the tab to remove.
	     *
	     * @returns The title occupying the index, or `null` if the index
	     *   is out of range.
	     */
	    TabBar.prototype.removeTabAt = function (index) {
	        // Bail if the index is out of range.
	        var i = Math.floor(index);
	        if (i < 0 || i >= this._titles.length) {
	            return null;
	        }
	        // Release the mouse before making any changes.
	        this._releaseMouse();
	        // Remove the title from the vector.
	        var title = this._titles.removeAt(i);
	        // Disconnect from the title changed signal.
	        title.changed.disconnect(this._onTitleChanged, this);
	        // Clear the previous title if it's being removed.
	        if (title === this._previousTitle) {
	            this._previousTitle = null;
	        }
	        // Adjust the current index for the remove.
	        this._adjustCurrentForRemove(i, title);
	        // Schedule an update of the tabs.
	        this.update();
	        // Return the removed title.
	        return title;
	    };
	    /**
	     * Remove all tabs from the tab bar.
	     */
	    TabBar.prototype.clearTabs = function () {
	        var _this = this;
	        // Bail if there is nothing to remove.
	        if (this._titles.length === 0) {
	            return;
	        }
	        // Release the mouse before making any changes.
	        this._releaseMouse();
	        // Disconnect from the title changed signals.
	        iteration_1.each(this._titles, function (title) {
	            title.changed.disconnect(_this._onTitleChanged, _this);
	        });
	        // Get the current index and title.
	        var pi = this.currentIndex;
	        var pt = this.currentTitle;
	        // Reset the current index and previous title.
	        this._currentIndex = -1;
	        this._previousTitle = null;
	        // Clear the title vector.
	        this._titles.clear();
	        // Schedule an update of the tabs.
	        this.update();
	        // If no tab was selected, there's nothing else to do.
	        if (pi === -1) {
	            return;
	        }
	        // Emit the current changed signal.
	        this.currentChanged.emit({
	            previousIndex: pi, previousTitle: pt,
	            currentIndex: -1, currentTitle: null
	        });
	    };
	    /**
	     * Release the mouse and restore the non-dragged tab positions.
	     *
	     * #### Notes
	     * This will cause the tab bar to stop handling mouse events and to
	     * restore the tabs to their non-dragged positions.
	     */
	    TabBar.prototype.releaseMouse = function () {
	        this._releaseMouse();
	    };
	    /**
	     * Handle the DOM events for the tab bar.
	     *
	     * @param event - The DOM event sent to the tab bar.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the tab bar's DOM node.
	     *
	     * This should not be called directly by user code.
	     */
	    TabBar.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'click':
	                this._evtClick(event);
	                break;
	            case 'mousedown':
	                this._evtMouseDown(event);
	                break;
	            case 'mousemove':
	                this._evtMouseMove(event);
	                break;
	            case 'mouseup':
	                this._evtMouseUp(event);
	                break;
	            case 'keydown':
	                this._evtKeyDown(event);
	                break;
	            case 'contextmenu':
	                event.preventDefault();
	                event.stopPropagation();
	                break;
	        }
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    TabBar.prototype.onAfterAttach = function (msg) {
	        this.node.addEventListener('click', this);
	        this.node.addEventListener('mousedown', this);
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     */
	    TabBar.prototype.onBeforeDetach = function (msg) {
	        this.node.removeEventListener('click', this);
	        this.node.removeEventListener('mousedown', this);
	        this._releaseMouse();
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    TabBar.prototype.onUpdateRequest = function (msg) {
	        var content = [];
	        var titles = this._titles;
	        var renderer = this._renderer;
	        var currentTitle = this.currentTitle;
	        for (var i = 0, n = titles.length; i < n; ++i) {
	            var title = titles.at(i);
	            var current = title === currentTitle;
	            var zIndex = current ? n : n - i - 1;
	            content.push(renderer.renderTab({ title: title, current: current, zIndex: zIndex }));
	        }
	        vdom_1.render(content, this.contentNode);
	    };
	    /**
	     * Handle the `'keydown'` event for the tab bar.
	     */
	    TabBar.prototype._evtKeyDown = function (event) {
	        // Stop all input events during drag.
	        event.preventDefault();
	        event.stopPropagation();
	        // Release the mouse if `Escape` is pressed.
	        if (event.keyCode === 27)
	            this._releaseMouse();
	    };
	    /**
	     * Handle the `'click'` event for the tab bar.
	     */
	    TabBar.prototype._evtClick = function (event) {
	        // Do nothing if it's not a left click.
	        if (event.button !== 0) {
	            return;
	        }
	        // Do nothing if a drag is in progress.
	        if (this._dragData) {
	            return;
	        }
	        // Lookup the tab nodes.
	        var tabs = this.contentNode.children;
	        // Do nothing if the click is not on a tab.
	        var x = event.clientX;
	        var y = event.clientY;
	        var i = searching_1.findIndex(tabs, function (tab) { return query_1.hitTest(tab, x, y); });
	        if (i < 0) {
	            return;
	        }
	        // Clicking on a tab stops the event propagation.
	        event.preventDefault();
	        event.stopPropagation();
	        // Ignore the click if the title is not closable.
	        var title = this._titles.at(i);
	        if (!title.closable) {
	            return;
	        }
	        // Ignore the click if it was not on a close icon.
	        var icon = tabs[i].querySelector(this._renderer.closeIconSelector);
	        if (!icon || !icon.contains(event.target)) {
	            return;
	        }
	        // Emit the tab close requested signal.
	        this.tabCloseRequested.emit({ index: i, title: title });
	    };
	    /**
	     * Handle the `'mousedown'` event for the tab bar.
	     */
	    TabBar.prototype._evtMouseDown = function (event) {
	        // Do nothing if it's not a left mouse press.
	        if (event.button !== 0) {
	            return;
	        }
	        // Do nothing if a drag is in progress.
	        if (this._dragData) {
	            return;
	        }
	        // Lookup the tab nodes.
	        var tabs = this.contentNode.children;
	        // Do nothing if the press is not on a tab.
	        var x = event.clientX;
	        var y = event.clientY;
	        var i = searching_1.findIndex(tabs, function (tab) { return query_1.hitTest(tab, x, y); });
	        if (i < 0) {
	            return;
	        }
	        // Pressing on a tab stops the event propagation.
	        event.preventDefault();
	        event.stopPropagation();
	        // Ignore the press if it was on a close icon.
	        var icon = tabs[i].querySelector(this._renderer.closeIconSelector);
	        if (icon && icon.contains(event.target)) {
	            return;
	        }
	        // Setup the drag data if the tabs are movable.
	        if (this._tabsMovable) {
	            this._dragData = new Private.DragData();
	            this._dragData.index = i;
	            this._dragData.tab = tabs[i];
	            this._dragData.pressX = event.clientX;
	            this._dragData.pressY = event.clientY;
	            document.addEventListener('mousemove', this, true);
	            document.addEventListener('mouseup', this, true);
	            document.addEventListener('keydown', this, true);
	            document.addEventListener('contextmenu', this, true);
	        }
	        // Update the current index as appropriate.
	        if (this._allowDeselect && this._currentIndex === i) {
	            this.currentIndex = -1;
	        }
	        else {
	            this.currentIndex = i;
	        }
	        // Do nothing else if there is no current tab.
	        if (this._currentIndex === -1) {
	            return;
	        }
	        // Emit the tab activate request signal.
	        this.tabActivateRequested.emit({
	            index: this.currentIndex,
	            title: this.currentTitle
	        });
	    };
	    /**
	     * Handle the `'mousemove'` event for the tab bar.
	     */
	    TabBar.prototype._evtMouseMove = function (event) {
	        // Do nothing if no drag is in progress.
	        if (!this._dragData) {
	            return;
	        }
	        // Suppress the event during a drag.
	        event.preventDefault();
	        event.stopPropagation();
	        // Lookup the tab nodes.
	        var tabs = this.contentNode.children;
	        // Check the threshold if the drag is not active.
	        var data = this._dragData;
	        if (!data.dragActive) {
	            // Bail if the drag threshold is not exceeded.
	            var dx = Math.abs(event.clientX - data.pressX);
	            var dy = Math.abs(event.clientY - data.pressY);
	            if (dx < DRAG_THRESHOLD && dy < DRAG_THRESHOLD) {
	                return;
	            }
	            // Fill in the rest of the drag data measurements.
	            var tabRect = data.tab.getBoundingClientRect();
	            if (this._orientation === 'horizontal') {
	                data.tabPos = data.tab.offsetLeft;
	                data.tabSize = tabRect.width;
	                data.tabPressPos = data.pressX - tabRect.left;
	            }
	            else {
	                data.tabPos = data.tab.offsetTop;
	                data.tabSize = tabRect.height;
	                data.tabPressPos = data.pressY - tabRect.top;
	            }
	            data.tabLayout = Private.snapTabLayout(tabs, this._orientation);
	            data.contentRect = this.contentNode.getBoundingClientRect();
	            data.override = cursor_1.overrideCursor('default');
	            // Add the dragging style classes.
	            data.tab.classList.add(DRAGGING_CLASS);
	            this.addClass(DRAGGING_CLASS);
	            // Mark the drag as active.
	            data.dragActive = true;
	        }
	        // Emit the detach requested signal if the threshold is exceeded.
	        if (!data.detachRequested && Private.detachExceeded(data, event)) {
	            // Only emit the signal once per drag cycle.
	            data.detachRequested = true;
	            // Setup the arguments for the signal.
	            var index = data.index;
	            var clientX = event.clientX;
	            var clientY = event.clientY;
	            var tab = tabs[index];
	            var title = this._titles.at(index);
	            // Emit the tab detach requested signal.
	            this.tabDetachRequested.emit({ index: index, title: title, tab: tab, clientX: clientX, clientY: clientY });
	            // Bail if the signal handler aborted the drag.
	            if (data.dragAborted) {
	                return;
	            }
	        }
	        // Update the positions of the tabs.
	        Private.layoutTabs(tabs, data, event, this._orientation);
	    };
	    /**
	     * Handle the `'mouseup'` event for the tab bar.
	     */
	    TabBar.prototype._evtMouseUp = function (event) {
	        var _this = this;
	        // Do nothing if it's not a left mouse release.
	        if (event.button !== 0) {
	            return;
	        }
	        // Do nothing if no drag is in progress.
	        if (!this._dragData) {
	            return;
	        }
	        // Suppress the event during a drag operation.
	        event.preventDefault();
	        event.stopPropagation();
	        // Remove the extra mouse event listeners.
	        document.removeEventListener('mousemove', this, true);
	        document.removeEventListener('mouseup', this, true);
	        document.removeEventListener('keydown', this, true);
	        document.removeEventListener('contextmenu', this, true);
	        // Bail early if the drag is not active.
	        var data = this._dragData;
	        if (!data.dragActive) {
	            this._dragData = null;
	            return;
	        }
	        // Position the tab at its final resting position.
	        Private.finalizeTabPosition(data, this._orientation);
	        // Remove the dragging class from the tab so it can be transitioned.
	        data.tab.classList.remove(DRAGGING_CLASS);
	        // Parse the transition duration for releasing the tab.
	        var duration = Private.parseTransitionDuration(data.tab);
	        // Complete the release on a timer to allow the tab to transition.
	        setTimeout(function () {
	            // Do nothing if the drag has been aborted.
	            if (data.dragAborted) {
	                return;
	            }
	            // Clear the drag data reference.
	            _this._dragData = null;
	            // Reset the positions of the tabs.
	            Private.resetTabPositions(_this.contentNode.children, _this._orientation);
	            // Clear the cursor grab.
	            data.override.dispose();
	            // Remove the remaining dragging style.
	            _this.removeClass(DRAGGING_CLASS);
	            // If the tab was not moved, there is nothing else to do.
	            var i = data.index;
	            var j = data.targetIndex;
	            if (j === -1 || i === j) {
	                return;
	            }
	            // Move the title to the new locations.
	            mutation_1.move(_this._titles, i, j);
	            // Adjust the current index for the move.
	            _this._adjustCurrentForMove(i, j);
	            // Emit the tab moved signal.
	            _this.tabMoved.emit({
	                fromIndex: i, toIndex: j, title: _this._titles.at(j)
	            });
	            // Update the tabs immediately to prevent flicker.
	            messaging_1.sendMessage(_this, widget_1.WidgetMessage.UpdateRequest);
	        }, duration);
	    };
	    /**
	     * Release the mouse and restore the non-dragged tab positions.
	     */
	    TabBar.prototype._releaseMouse = function () {
	        // Do nothing if no drag is in progress.
	        if (!this._dragData) {
	            return;
	        }
	        // Remove the extra mouse listeners.
	        document.removeEventListener('mousemove', this, true);
	        document.removeEventListener('mouseup', this, true);
	        document.removeEventListener('keydown', this, true);
	        document.removeEventListener('contextmenu', this, true);
	        // Clear the drag data reference.
	        var data = this._dragData;
	        this._dragData = null;
	        // Indicate the drag has been aborted. This allows the mouse
	        // event handlers to return early when the drag is canceled.
	        data.dragAborted = true;
	        // If the drag is not active, there's nothing more to do.
	        if (!data.dragActive) {
	            return;
	        }
	        // Reset the tabs to their non-dragged positions.
	        Private.resetTabPositions(this.contentNode.children, this._orientation);
	        // Clear the cursor override.
	        data.override.dispose();
	        // Clear the dragging style classes.
	        data.tab.classList.remove(DRAGGING_CLASS);
	        this.removeClass(DRAGGING_CLASS);
	    };
	    /**
	     * Adjust the current index for a tab insert operation.
	     *
	     * This method accounts for the tab bar's insertion behavior when
	     * adjusting the current index and emitting the changed signal.
	     */
	    TabBar.prototype._adjustCurrentForInsert = function (i, title) {
	        // Lookup commonly used variables.
	        var ct = this.currentTitle;
	        var ci = this._currentIndex;
	        var bh = this._insertBehavior;
	        // Handle the behavior where the new tab is always selected,
	        // or the behavior where the new tab is selected if needed.
	        if (bh === 'select-tab' || (bh === 'select-tab-if-needed' && ci === -1)) {
	            this._currentIndex = i;
	            this._previousTitle = ct;
	            this.currentChanged.emit({
	                previousIndex: ci, previousTitle: ct,
	                currentIndex: i, currentTitle: title
	            });
	            return;
	        }
	        // Otherwise, silently adjust the current index if needed.
	        if (ci >= i)
	            this._currentIndex++;
	    };
	    /**
	     * Adjust the current index for a tab move operation.
	     *
	     * This method will not cause the actual current tab to change.
	     * It silently adjusts the index to account for the given move.
	     */
	    TabBar.prototype._adjustCurrentForMove = function (i, j) {
	        if (this._currentIndex === i) {
	            this._currentIndex = j;
	        }
	        else if (this._currentIndex < i && this._currentIndex >= j) {
	            this._currentIndex++;
	        }
	        else if (this._currentIndex > i && this._currentIndex <= j) {
	            this._currentIndex--;
	        }
	    };
	    /**
	     * Adjust the current index for a tab remove operation.
	     *
	     * This method accounts for the tab bar's remove behavior when
	     * adjusting the current index and emitting the changed signal.
	     */
	    TabBar.prototype._adjustCurrentForRemove = function (i, title) {
	        // Lookup commonly used variables.
	        var ci = this._currentIndex;
	        var bh = this._removeBehavior;
	        // Silently adjust the index if the current tab is not removed.
	        if (ci !== i) {
	            if (ci > i)
	                this._currentIndex--;
	            return;
	        }
	        // No tab gets selected if the tab bar is empty.
	        if (this._titles.length === 0) {
	            this._currentIndex = -1;
	            this.currentChanged.emit({
	                previousIndex: i, previousTitle: title,
	                currentIndex: -1, currentTitle: null
	            });
	            return;
	        }
	        // Handle behavior where the next sibling tab is selected.
	        if (bh === 'select-tab-after') {
	            this._currentIndex = Math.min(i, this._titles.length - 1);
	            this.currentChanged.emit({
	                previousIndex: i, previousTitle: title,
	                currentIndex: this._currentIndex, currentTitle: this.currentTitle
	            });
	            return;
	        }
	        // Handle behavior where the previous sibling tab is selected.
	        if (bh === 'select-tab-before') {
	            this._currentIndex = Math.max(0, i - 1);
	            this.currentChanged.emit({
	                previousIndex: i, previousTitle: title,
	                currentIndex: this._currentIndex, currentTitle: this.currentTitle
	            });
	            return;
	        }
	        // Handle behavior where the previous history tab is selected.
	        if (bh === 'select-previous-tab') {
	            if (this._previousTitle) {
	                this._currentIndex = searching_1.indexOf(this._titles, this._previousTitle);
	                this._previousTitle = null;
	            }
	            else {
	                this._currentIndex = Math.min(i, this._titles.length - 1);
	            }
	            this.currentChanged.emit({
	                previousIndex: i, previousTitle: title,
	                currentIndex: this._currentIndex, currentTitle: this.currentTitle
	            });
	            return;
	        }
	        // Otherwise, no tab gets selected.
	        this._currentIndex = -1;
	        this.currentChanged.emit({
	            previousIndex: i, previousTitle: title,
	            currentIndex: -1, currentTitle: null
	        });
	    };
	    /**
	     * Handle the `changed` signal of a title object.
	     */
	    TabBar.prototype._onTitleChanged = function (sender) {
	        this.update();
	    };
	    return TabBar;
	}(widget_1.Widget));
	exports.TabBar = TabBar;
	// Define the signals for the `TabBar` class.
	signaling_1.defineSignal(TabBar.prototype, 'currentChanged');
	signaling_1.defineSignal(TabBar.prototype, 'tabMoved');
	signaling_1.defineSignal(TabBar.prototype, 'tabActivateRequested');
	signaling_1.defineSignal(TabBar.prototype, 'tabCloseRequested');
	signaling_1.defineSignal(TabBar.prototype, 'tabDetachRequested');
	/**
	 * The namespace for the `TabBar` class statics.
	 */
	var TabBar;
	(function (TabBar) {
	    /**
	     * The default implementation of `IRenderer`.
	     */
	    var Renderer = (function () {
	        /**
	         * Construct a new renderer.
	         *
	         * @param options - The options for initializing the renderer.
	         */
	        function Renderer(options) {
	            if (options === void 0) { options = {}; }
	            this._tabID = 0;
	            this._tabKeys = new WeakMap();
	            this._extraTabClass = options.extraTabClass || '';
	        }
	        Object.defineProperty(Renderer.prototype, "closeIconSelector", {
	            /**
	             * A selector which matches the close icon node in a tab.
	             *
	             * #### Notes
	             * This is a read-only property.
	             */
	            get: function () {
	                return "." + CLOSE_ICON_CLASS;
	            },
	            enumerable: true,
	            configurable: true
	        });
	        /**
	         * Render the node for the a tab.
	         *
	         * @param data - The data to use for rendering the tab.
	         *
	         * @returns A virtual DOM node representing the tab.
	         */
	        Renderer.prototype.renderTab = function (data) {
	            var _a = data.title, label = _a.label, caption = _a.caption;
	            var key = this.createTabKey(data);
	            var style = this.createTabStyle(data);
	            var tabClass = this.createTabClass(data);
	            var iconClass = this.createIconClass(data);
	            return (vdom_1.h.li({ key: key, className: tabClass, title: caption, style: style }, vdom_1.h.div({ className: iconClass }), vdom_1.h.div({ className: LABEL_CLASS }, label), vdom_1.h.div({ className: CLOSE_ICON_CLASS })));
	        };
	        /**
	         * Create a unique render key for the tab.
	         *
	         * @param data - The data to use for the tab.
	         *
	         * @returns The unique render key for the tab.
	         *
	         * #### Notes
	         * This method caches the key against the tab title the first time
	         * the key is generated. This enables efficient rendering of moved
	         * tabs and avoids subtle hover style artifacts.
	         */
	        Renderer.prototype.createTabKey = function (data) {
	            var key = this._tabKeys.get(data.title);
	            if (key === void 0) {
	                key = "tab-key-" + this._tabID++;
	                this._tabKeys.set(data.title, key);
	            }
	            return key;
	        };
	        /**
	         * Create the inline style object for a tab.
	         *
	         * @param data - The data to use for the tab.
	         *
	         * @returns The inline style data for the tab.
	         */
	        Renderer.prototype.createTabStyle = function (data) {
	            return { zIndex: "" + data.zIndex };
	        };
	        /**
	         * Create the class name for the tab.
	         *
	         * @param data - The data to use for the tab.
	         *
	         * @returns The full class name for the tab.
	         */
	        Renderer.prototype.createTabClass = function (data) {
	            var title = data.title, current = data.current;
	            var name = TAB_CLASS;
	            if (title.className) {
	                name += " " + title.className;
	            }
	            if (title.closable) {
	                name += " " + CLOSABLE_CLASS;
	            }
	            if (current) {
	                name += " " + CURRENT_CLASS;
	            }
	            if (this._extraTabClass) {
	                name += " " + this._extraTabClass;
	            }
	            return name;
	        };
	        /**
	         * Create the class name for the tab icon.
	         *
	         * @param data - The data to use for the tab.
	         *
	         * @returns The full class name for the tab icon.
	         */
	        Renderer.prototype.createIconClass = function (data) {
	            var title = data.title;
	            var name = ICON_CLASS;
	            if (title.icon) {
	                name += " " + title.icon;
	            }
	            return name;
	        };
	        return Renderer;
	    }());
	    TabBar.Renderer = Renderer;
	    /**
	     * The default `Renderer` instance.
	     */
	    TabBar.defaultRenderer = new Renderer();
	})(TabBar = exports.TabBar || (exports.TabBar = {}));
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A struct which holds the drag data for a tab bar.
	     */
	    var DragData = (function () {
	        function DragData() {
	            /**
	             * The tab node being dragged.
	             */
	            this.tab = null;
	            /**
	             * The index of the tab being dragged.
	             */
	            this.index = -1;
	            /**
	             * The offset left/top of the tab being dragged.
	             */
	            this.tabPos = -1;
	            /**
	             * The offset width/height of the tab being dragged.
	             */
	            this.tabSize = -1;
	            /**
	             * The original mouse X/Y position in tab coordinates.
	             */
	            this.tabPressPos = -1;
	            /**
	             * The tab target index upon mouse release.
	             */
	            this.targetIndex = -1;
	            /**
	             * The array of tab layout objects snapped at drag start.
	             */
	            this.tabLayout = null;
	            /**
	             * The mouse press client X position.
	             */
	            this.pressX = -1;
	            /**
	             * The mouse press client Y position.
	             */
	            this.pressY = -1;
	            /**
	             * The bounding client rect of the tab bar content node.
	             */
	            this.contentRect = null;
	            /**
	             * The disposable to clean up the cursor override.
	             */
	            this.override = null;
	            /**
	             * Whether the drag is currently active.
	             */
	            this.dragActive = false;
	            /**
	             * Whether the drag has been aborted.
	             */
	            this.dragAborted = false;
	            /**
	             * Whether a detach request as been made.
	             */
	            this.detachRequested = false;
	        }
	        return DragData;
	    }());
	    Private.DragData = DragData;
	    /**
	     * Coerce a title or options into a real title.
	     */
	    function asTitle(value) {
	        return value instanceof title_1.Title ? value : new title_1.Title(value);
	    }
	    Private.asTitle = asTitle;
	    /**
	     * Parse the transition duration for a tab node.
	     */
	    function parseTransitionDuration(tab) {
	        var style = window.getComputedStyle(tab);
	        return 1000 * (parseFloat(style.transitionDuration) || 0);
	    }
	    Private.parseTransitionDuration = parseTransitionDuration;
	    /**
	     * Get a snapshot of the current tab layout values.
	     */
	    function snapTabLayout(tabs, orientation) {
	        var layout = new Array(tabs.length);
	        if (orientation === 'horizontal') {
	            for (var i = 0, n = tabs.length; i < n; ++i) {
	                var node = tabs[i];
	                var pos = node.offsetLeft;
	                var size = node.offsetWidth;
	                var cstyle = window.getComputedStyle(node);
	                var margin = parseInt(cstyle.marginLeft, 10) || 0;
	                layout[i] = { margin: margin, pos: pos, size: size };
	            }
	        }
	        else {
	            for (var i = 0, n = tabs.length; i < n; ++i) {
	                var node = tabs[i];
	                var pos = node.offsetTop;
	                var size = node.offsetHeight;
	                var cstyle = window.getComputedStyle(node);
	                var margin = parseInt(cstyle.marginTop, 10) || 0;
	                layout[i] = { margin: margin, pos: pos, size: size };
	            }
	        }
	        return layout;
	    }
	    Private.snapTabLayout = snapTabLayout;
	    /**
	     * Test if the event exceeds the drag detach threshold.
	     */
	    function detachExceeded(data, event) {
	        var rect = data.contentRect;
	        return ((event.clientX < rect.left - DETACH_THRESHOLD) ||
	            (event.clientX >= rect.right + DETACH_THRESHOLD) ||
	            (event.clientY < rect.top - DETACH_THRESHOLD) ||
	            (event.clientY >= rect.bottom + DETACH_THRESHOLD));
	    }
	    Private.detachExceeded = detachExceeded;
	    /**
	     * Update the relative tab positions and computed target index.
	     */
	    function layoutTabs(tabs, data, event, orientation) {
	        // Compute the orientation-sensitive values.
	        var pressPos;
	        var localPos;
	        var clientPos;
	        var clientSize;
	        if (orientation === 'horizontal') {
	            pressPos = data.pressX;
	            localPos = event.clientX - data.contentRect.left;
	            clientPos = event.clientX;
	            clientSize = data.contentRect.width;
	        }
	        else {
	            pressPos = data.pressY;
	            localPos = event.clientY - data.contentRect.top;
	            clientPos = event.clientY;
	            clientSize = data.contentRect.height;
	        }
	        // Compute the target data.
	        var targetIndex = data.index;
	        var targetPos = localPos - data.tabPressPos;
	        var targetEnd = targetPos + data.tabSize;
	        // Update the relative tab positions.
	        for (var i = 0, n = tabs.length; i < n; ++i) {
	            var pxPos = void 0;
	            var layout = data.tabLayout[i];
	            var threshold = layout.pos + (layout.size >> 1);
	            if (i < data.index && targetPos < threshold) {
	                pxPos = (data.tabSize + data.tabLayout[i + 1].margin) + "px";
	                targetIndex = Math.min(targetIndex, i);
	            }
	            else if (i > data.index && targetEnd > threshold) {
	                pxPos = (-data.tabSize - layout.margin) + "px";
	                targetIndex = Math.max(targetIndex, i);
	            }
	            else if (i === data.index) {
	                var ideal = clientPos - pressPos;
	                var limit = clientSize - (data.tabPos + data.tabSize);
	                pxPos = Math.max(-data.tabPos, Math.min(ideal, limit)) + "px";
	            }
	            else {
	                pxPos = '';
	            }
	            if (orientation === 'horizontal') {
	                tabs[i].style.left = pxPos;
	            }
	            else {
	                tabs[i].style.top = pxPos;
	            }
	        }
	        // Update the computed target index.
	        data.targetIndex = targetIndex;
	    }
	    Private.layoutTabs = layoutTabs;
	    /**
	     * Position the drag tab at its final resting relative position.
	     */
	    function finalizeTabPosition(data, orientation) {
	        // Compute the orientation-sensitive client size.
	        var clientSize;
	        if (orientation === 'horizontal') {
	            clientSize = data.contentRect.width;
	        }
	        else {
	            clientSize = data.contentRect.height;
	        }
	        // Compute the ideal final tab position.
	        var ideal;
	        if (data.targetIndex === data.index) {
	            ideal = 0;
	        }
	        else if (data.targetIndex > data.index) {
	            var tgt = data.tabLayout[data.targetIndex];
	            ideal = tgt.pos + tgt.size - data.tabSize - data.tabPos;
	        }
	        else {
	            var tgt = data.tabLayout[data.targetIndex];
	            ideal = tgt.pos - data.tabPos;
	        }
	        // Compute the tab position limit.
	        var limit = clientSize - (data.tabPos + data.tabSize);
	        var final = Math.max(-data.tabPos, Math.min(ideal, limit));
	        // Set the final orientation-sensitive position.
	        if (orientation === 'horizontal') {
	            data.tab.style.left = final + "px";
	        }
	        else {
	            data.tab.style.top = final + "px";
	        }
	    }
	    Private.finalizeTabPosition = finalizeTabPosition;
	    /**
	     * Reset the relative positions of the given tabs.
	     */
	    function resetTabPositions(tabs, orientation) {
	        if (orientation === 'horizontal') {
	            iteration_1.each(tabs, function (tab) { tab.style.left = ''; });
	        }
	        else {
	            iteration_1.each(tabs, function (tab) { tab.style.top = ''; });
	        }
	    }
	    Private.resetTabPositions = resetTabPositions;
	})(Private || (Private = {}));


/***/ },
/* 73 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * A node in a virtual DOM hierarchy.
	 *
	 * #### Notes
	 * User code will not usually instantiate an node directly. Rather, the
	 * `h()` function will be called to create a node in a type-safe manner.
	 *
	 * A node *must* be treated as immutable. Mutating the state of a node
	 * **will** result in undefined rendering behavior.
	 */
	var VNode = (function () {
	    /**
	     * Construct a new virtual DOM node.
	     *
	     * @param type - The type of the node.
	     *
	     * @param tag - The node tag.
	     *
	     * @param attrs - The node attributes.
	     *
	     * @param children - The node children.
	     */
	    function VNode(type, tag, attrs, children) {
	        this.type = type;
	        this.tag = tag;
	        this.attrs = attrs;
	        this.children = children;
	    }
	    return VNode;
	}());
	exports.VNode = VNode;
	function h(tag, first) {
	    // Setup the variables to hold the parsed data.
	    var attrs;
	    var children;
	    // Parse the first variadic argument.
	    if (first) {
	        if (typeof first === 'string') {
	            children = [first];
	        }
	        else if (first instanceof VNode) {
	            children = [first];
	        }
	        else if (first instanceof Array) {
	            children = first.slice();
	        }
	        else {
	            attrs = first;
	        }
	    }
	    // Parse the rest of the variadic arguments.
	    if (arguments.length > 2) {
	        children = children || [];
	        for (var i = 2, n = arguments.length; i < n; ++i) {
	            var child = arguments[i];
	            if (child instanceof Array) {
	                for (var j = 0, k = child.length; j < k; ++j) {
	                    if (child[j])
	                        children.push(child[j]);
	                }
	            }
	            else if (child) {
	                children.push(child);
	            }
	        }
	    }
	    // Convert string literal children into text nodes.
	    if (children) {
	        for (var i = 0, n = children.length; i < n; ++i) {
	            var child = children[i];
	            if (typeof child === 'string') {
	                children[i] = Private.createTextVNode(child);
	            }
	        }
	    }
	    // Return a new virtual DOM node.
	    return Private.createElementVNode(tag, attrs, children);
	}
	exports.h = h;
	/**
	 * The namespace for the `h()` function statics.
	 */
	var h;
	(function (h) {
	    h.a = h.bind(void 0, 'a');
	    h.abbr = h.bind(void 0, 'abbr');
	    h.address = h.bind(void 0, 'address');
	    h.area = h.bind(void 0, 'area');
	    h.article = h.bind(void 0, 'article');
	    h.aside = h.bind(void 0, 'aside');
	    h.audio = h.bind(void 0, 'audio');
	    h.b = h.bind(void 0, 'b');
	    h.bdi = h.bind(void 0, 'bdi');
	    h.bdo = h.bind(void 0, 'bdo');
	    h.blockquote = h.bind(void 0, 'blockquote');
	    h.br = h.bind(void 0, 'br');
	    h.button = h.bind(void 0, 'button');
	    h.canvas = h.bind(void 0, 'canvas');
	    h.caption = h.bind(void 0, 'caption');
	    h.cite = h.bind(void 0, 'cite');
	    h.code = h.bind(void 0, 'code');
	    h.col = h.bind(void 0, 'col');
	    h.colgroup = h.bind(void 0, 'colgroup');
	    h.data = h.bind(void 0, 'data');
	    h.datalist = h.bind(void 0, 'datalist');
	    h.dd = h.bind(void 0, 'dd');
	    h.del = h.bind(void 0, 'del');
	    h.dfn = h.bind(void 0, 'dfn');
	    h.div = h.bind(void 0, 'div');
	    h.dl = h.bind(void 0, 'dl');
	    h.dt = h.bind(void 0, 'dt');
	    h.em = h.bind(void 0, 'em');
	    h.embed = h.bind(void 0, 'embed');
	    h.fieldset = h.bind(void 0, 'fieldset');
	    h.figcaption = h.bind(void 0, 'figcaption');
	    h.figure = h.bind(void 0, 'figure');
	    h.footer = h.bind(void 0, 'footer');
	    h.form = h.bind(void 0, 'form');
	    h.h1 = h.bind(void 0, 'h1');
	    h.h2 = h.bind(void 0, 'h2');
	    h.h3 = h.bind(void 0, 'h3');
	    h.h4 = h.bind(void 0, 'h4');
	    h.h5 = h.bind(void 0, 'h5');
	    h.h6 = h.bind(void 0, 'h6');
	    h.header = h.bind(void 0, 'header');
	    h.hr = h.bind(void 0, 'hr');
	    h.i = h.bind(void 0, 'i');
	    h.iframe = h.bind(void 0, 'iframe');
	    h.img = h.bind(void 0, 'img');
	    h.input = h.bind(void 0, 'input');
	    h.ins = h.bind(void 0, 'ins');
	    h.kbd = h.bind(void 0, 'kbd');
	    h.label = h.bind(void 0, 'label');
	    h.legend = h.bind(void 0, 'legend');
	    h.li = h.bind(void 0, 'li');
	    h.main = h.bind(void 0, 'main');
	    h.map = h.bind(void 0, 'map');
	    h.mark = h.bind(void 0, 'mark');
	    h.meter = h.bind(void 0, 'meter');
	    h.nav = h.bind(void 0, 'nav');
	    h.noscript = h.bind(void 0, 'noscript');
	    h.object = h.bind(void 0, 'object');
	    h.ol = h.bind(void 0, 'ol');
	    h.optgroup = h.bind(void 0, 'optgroup');
	    h.option = h.bind(void 0, 'option');
	    h.output = h.bind(void 0, 'output');
	    h.p = h.bind(void 0, 'p');
	    h.param = h.bind(void 0, 'param');
	    h.pre = h.bind(void 0, 'pre');
	    h.progress = h.bind(void 0, 'progress');
	    h.q = h.bind(void 0, 'q');
	    h.rp = h.bind(void 0, 'rp');
	    h.rt = h.bind(void 0, 'rt');
	    h.ruby = h.bind(void 0, 'ruby');
	    h.s = h.bind(void 0, 's');
	    h.samp = h.bind(void 0, 'samp');
	    h.section = h.bind(void 0, 'section');
	    h.select = h.bind(void 0, 'select');
	    h.small = h.bind(void 0, 'small');
	    h.source = h.bind(void 0, 'source');
	    h.span = h.bind(void 0, 'span');
	    h.strong = h.bind(void 0, 'strong');
	    h.sub = h.bind(void 0, 'sub');
	    h.summary = h.bind(void 0, 'summary');
	    h.sup = h.bind(void 0, 'sup');
	    h.table = h.bind(void 0, 'table');
	    h.tbody = h.bind(void 0, 'tbody');
	    h.td = h.bind(void 0, 'td');
	    h.textarea = h.bind(void 0, 'textarea');
	    h.tfoot = h.bind(void 0, 'tfoot');
	    h.th = h.bind(void 0, 'th');
	    h.thead = h.bind(void 0, 'thead');
	    h.time = h.bind(void 0, 'time');
	    h.title = h.bind(void 0, 'title');
	    h.tr = h.bind(void 0, 'tr');
	    h.track = h.bind(void 0, 'track');
	    h.u = h.bind(void 0, 'u');
	    h.ul = h.bind(void 0, 'ul');
	    h.var_ = h.bind(void 0, 'var');
	    h.video = h.bind(void 0, 'video');
	    h.wbr = h.bind(void 0, 'wbr');
	})(h = exports.h || (exports.h = {}));
	/**
	 * Create a real DOM node from a virtual DOM node.
	 *
	 * @param content - The virtual DOM content to realize.
	 *
	 * @returns A new DOM node for the given virtual DOM tree.
	 *
	 * #### Notes
	 * The content node is assumed to be of the `'element'` type.
	 *
	 * This creates a brand new *real* DOM node with a structure which
	 * matches the given virtual DOM node.
	 *
	 * If virtual diffing is desired, use the `render` function instead.
	 */
	function realize(content) {
	    return Private.realizeImpl(content);
	}
	exports.realize = realize;
	/**
	 * Render virtual DOM content into a host element.
	 *
	 * @param content - The virtual DOM content to render.
	 *
	 * @param host - The host element for the rendered content.
	 *
	 * #### Notes
	 * This renders the delta from the previous rendering. It assumes that
	 * the content of the host element is not manipulated by external code.
	 *
	 * Providing `null` content will clear the rendering.
	 *
	 * Externally modifying the provided content or the host element will
	 * result in undefined rendering behavior.
	 */
	function render(content, host) {
	    Private.renderImpl(content, host);
	}
	exports.render = render;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create a virtual text node for the given string.
	     */
	    function createTextVNode(text) {
	        return new VNode('text', text, emptyObject, emptyArray);
	    }
	    Private.createTextVNode = createTextVNode;
	    /**
	     * Create a virtual element node for the given parameters.
	     */
	    function createElementVNode(tag, attrs, children) {
	        attrs = attrs || emptyObject;
	        children = children || emptyArray;
	        return new VNode('element', tag, attrs, children);
	    }
	    Private.createElementVNode = createElementVNode;
	    /**
	     * The internal `realize` entry point.
	     */
	    function realizeImpl(content) {
	        return createDOMNode(content);
	    }
	    Private.realizeImpl = realizeImpl;
	    /**
	     * The internal `render` entry point.
	     */
	    function renderImpl(content, host) {
	        var oldContent = hostMap.get(host) || emptyArray;
	        var newContent = asVNodeArray(content);
	        hostMap.set(host, newContent);
	        updateContent(host, oldContent, newContent);
	    }
	    Private.renderImpl = renderImpl;
	    /**
	     * A shared frozen empty array.
	     */
	    var emptyArray = Object.freeze([]);
	    /**
	     * A shared frozen empty object.
	     */
	    var emptyObject = Object.freeze({});
	    /**
	     * A weak mapping of host element to virtual DOM content.
	     */
	    var hostMap = new WeakMap();
	    /**
	     * Coerce content into a virtual node array.
	     *
	     * Null content will be coerced to an empty array.
	     */
	    function asVNodeArray(content) {
	        if (content instanceof Array) {
	            return content;
	        }
	        if (content) {
	            return [content];
	        }
	        return emptyArray;
	    }
	    /**
	     * Update a host element with the delta of the virtual content.
	     *
	     * This is the core "diff" algorithm. There is no explicit "patch"
	     * phase. The host is patched at each step as the diff progresses.
	     */
	    function updateContent(host, oldContent, newContent) {
	        // Bail early if the content is identical. This can occur when an
	        // node has no children or if the user is rendering cached content.
	        if (oldContent === newContent) {
	            return;
	        }
	        // Collect the old keyed elems into a mapping.
	        var oldKeyed = collectKeys(host, oldContent);
	        // Create a copy of the old content which can be modified in-place.
	        var oldCopy = oldContent.slice();
	        // Update the host with the new content. The diff always proceeds
	        // forward and never modifies a previously visited index. The old
	        // copy array is modified in-place to reflect the changes made to
	        // the host children. This causes the stale nodes to be pushed to
	        // the end of the host node and removed at the end of the loop.
	        var currNode = host.firstChild;
	        var newCount = newContent.length;
	        for (var i = 0; i < newCount; ++i) {
	            // If the old elems are exhausted, create a new node.
	            if (i >= oldCopy.length) {
	                host.appendChild(createDOMNode(newContent[i]));
	                continue;
	            }
	            // Cache a reference to the old and new elems.
	            var oldVNode = oldCopy[i];
	            var newVNode = newContent[i];
	            // If the new elem is keyed, move an old keyed elem to the proper
	            // location before proceeding with the diff. The search can start
	            // at the current index, since the unmatched old keyed elems are
	            // pushed forward in the old copy array.
	            var newKey = newVNode.attrs.key;
	            if (newKey && newKey in oldKeyed) {
	                var pair = oldKeyed[newKey];
	                if (pair.vNode !== oldVNode) {
	                    arrayMove(oldCopy, oldCopy.indexOf(pair.vNode), i);
	                    host.insertBefore(pair.element, currNode);
	                    oldVNode = pair.vNode;
	                    currNode = pair.element;
	                }
	            }
	            // If both elements are identical, there is nothing to do.
	            // This can occur when the user renders cached content.
	            if (oldVNode === newVNode) {
	                currNode = currNode.nextSibling;
	                continue;
	            }
	            // If the old elem is keyed and does not match the new elem key,
	            // create a new node. This is necessary since the old keyed elem
	            // may be matched at a later point in the diff.
	            var oldKey = oldVNode.attrs.key;
	            if (oldKey && oldKey !== newKey) {
	                arrayInsert(oldCopy, i, newVNode);
	                host.insertBefore(createDOMNode(newVNode), currNode);
	                continue;
	            }
	            // If the elements have different types, create a new node.
	            if (oldVNode.type !== newVNode.type) {
	                arrayInsert(oldCopy, i, newVNode);
	                host.insertBefore(createDOMNode(newVNode), currNode);
	                continue;
	            }
	            // If the element is a text node, update its text content.
	            if (newVNode.type === 'text') {
	                currNode.textContent = newVNode.tag;
	                currNode = currNode.nextSibling;
	                continue;
	            }
	            // At this point, the node is an 'element' type. If the tags
	            // are different, create a new node.
	            if (oldVNode.tag !== newVNode.tag) {
	                arrayInsert(oldCopy, i, newVNode);
	                host.insertBefore(createDOMNode(newVNode), currNode);
	                continue;
	            }
	            // The element tags match, update the element in place.
	            updateAttrs(currNode, oldVNode.attrs, newVNode.attrs);
	            updateContent(currNode, oldVNode.children, newVNode.children);
	            currNode = currNode.nextSibling;
	        }
	        // Dispose of the old nodes pushed to the end of the host.
	        for (var i = oldCopy.length - 1; i >= newCount; --i) {
	            host.removeChild(host.lastChild);
	        }
	    }
	    /**
	     * Add attributes to a newly created DOM node.
	     */
	    function addAttrs(node, attrs) {
	        // Set the known attributes defined in the attr table.
	        for (var name_1 in attrs) {
	            var mode = attrModeTable[name_1];
	            if (mode === 0 /* Property */ || mode === 2 /* Event */) {
	                node[name_1] = attrs[name_1];
	            }
	            else if (mode === 1 /* Attribute */) {
	                node.setAttribute(name_1.toLowerCase(), attrs[name_1]);
	            }
	        }
	        // Handle the dataset values.
	        var dataset = attrs.dataset;
	        if (dataset) {
	            for (var name_2 in dataset) {
	                node.setAttribute("data-" + name_2, dataset[name_2]);
	            }
	        }
	        // Handle the inline styles.
	        var styles = attrs.style;
	        if (styles) {
	            var nodeStyle = node.style;
	            for (var name_3 in styles) {
	                nodeStyle[name_3] = styles[name_3];
	            }
	        }
	    }
	    /**
	     * Update the node attributes with the delta of attribute objects.
	     */
	    function updateAttrs(node, oldAttrs, newAttrs) {
	        // Do nothing if the attrs are the same object.
	        if (oldAttrs === newAttrs) {
	            return;
	        }
	        // Remove attributes which no longer exist.
	        for (var name_4 in oldAttrs) {
	            if (!(name_4 in newAttrs)) {
	                var mode = attrModeTable[name_4];
	                if (mode === 0 /* Property */) {
	                    node.removeAttribute(name_4);
	                }
	                else if (mode === 1 /* Attribute */) {
	                    node.removeAttribute(name_4.toLowerCase());
	                }
	                else if (mode === 2 /* Event */) {
	                    node[name_4] = null;
	                }
	            }
	        }
	        // Add new attributes an update existing ones.
	        for (var name_5 in newAttrs) {
	            var value = newAttrs[name_5];
	            if (oldAttrs[name_5] !== value) {
	                var mode = attrModeTable[name_5];
	                if (mode === 0 /* Property */ || mode === 2 /* Event */) {
	                    node[name_5] = value;
	                }
	                else if (mode === 1 /* Attribute */) {
	                    node.setAttribute(name_5.toLowerCase(), value);
	                }
	            }
	        }
	        // Handle the dataset values.
	        var oldDataset = oldAttrs.dataset || emptyObject;
	        var newDataset = newAttrs.dataset || emptyObject;
	        if (oldDataset !== newDataset) {
	            for (var name_6 in oldDataset) {
	                if (!(name_6 in newDataset)) {
	                    node.removeAttribute('data-' + name_6);
	                }
	            }
	            for (var name_7 in newDataset) {
	                var value = newDataset[name_7];
	                if (oldDataset[name_7] !== value) {
	                    node.setAttribute('data-' + name_7, value);
	                }
	            }
	        }
	        // Handle the inline styles.
	        var oldStyle = oldAttrs.style || emptyObject;
	        var newStyle = newAttrs.style || emptyObject;
	        if (oldStyle !== newStyle) {
	            var nodeStyle = node.style;
	            for (var name_8 in oldStyle) {
	                if (!(name_8 in newStyle)) {
	                    nodeStyle[name_8] = '';
	                }
	            }
	            for (var name_9 in newStyle) {
	                var value = newStyle[name_9];
	                if (oldStyle[name_9] !== value) {
	                    nodeStyle[name_9] = value;
	                }
	            }
	        }
	    }
	    /**
	     * Collect a mapping of keyed elements for the host content.
	     */
	    function collectKeys(host, content) {
	        var node = host.firstChild;
	        var keyed = Object.create(null);
	        for (var i = 0, n = content.length; i < n; ++i) {
	            var vNode = content[i];
	            if (vNode.type === 'element') {
	                var key = vNode.attrs.key;
	                if (key)
	                    keyed[key] = { vNode: vNode, element: node };
	            }
	            node = node.nextSibling;
	        }
	        return keyed;
	    }
	    /**
	     * Create and return a new DOM node for a virtual element.
	     */
	    function createDOMNode(elem) {
	        var node;
	        if (elem.type === 'text') {
	            node = document.createTextNode(elem.tag);
	        }
	        else {
	            node = document.createElement(elem.tag);
	            addAttrs(node, elem.attrs);
	            addContent(node, elem.children);
	        }
	        return node;
	    }
	    /**
	     * Create and add child content to a newly created DOM node.
	     */
	    function addContent(node, content) {
	        for (var i = 0, n = content.length; i < n; ++i) {
	            node.appendChild(createDOMNode(content[i]));
	        }
	    }
	    /**
	     * A mapping of attribute name to attribute mode.
	     */
	    var attrModeTable = {
	        accept: 0 /* Property */,
	        acceptCharset: 0 /* Property */,
	        accessKey: 0 /* Property */,
	        action: 0 /* Property */,
	        allowFullscreen: 1 /* Attribute */,
	        alt: 0 /* Property */,
	        autocomplete: 0 /* Property */,
	        autofocus: 0 /* Property */,
	        autoplay: 0 /* Property */,
	        checked: 0 /* Property */,
	        cite: 0 /* Property */,
	        className: 0 /* Property */,
	        colSpan: 0 /* Property */,
	        cols: 0 /* Property */,
	        contentEditable: 0 /* Property */,
	        controls: 0 /* Property */,
	        coords: 0 /* Property */,
	        crossOrigin: 0 /* Property */,
	        data: 0 /* Property */,
	        dateTime: 0 /* Property */,
	        default: 0 /* Property */,
	        dir: 0 /* Property */,
	        dirName: 0 /* Property */,
	        disabled: 0 /* Property */,
	        download: 0 /* Property */,
	        draggable: 0 /* Property */,
	        enctype: 0 /* Property */,
	        form: 1 /* Attribute */,
	        formAction: 0 /* Property */,
	        formEnctype: 0 /* Property */,
	        formMethod: 0 /* Property */,
	        formNoValidate: 0 /* Property */,
	        formTarget: 0 /* Property */,
	        headers: 0 /* Property */,
	        height: 0 /* Property */,
	        hidden: 0 /* Property */,
	        high: 0 /* Property */,
	        href: 0 /* Property */,
	        hreflang: 0 /* Property */,
	        htmlFor: 0 /* Property */,
	        id: 0 /* Property */,
	        inputMode: 0 /* Property */,
	        isMap: 0 /* Property */,
	        kind: 0 /* Property */,
	        label: 0 /* Property */,
	        lang: 0 /* Property */,
	        list: 1 /* Attribute */,
	        loop: 0 /* Property */,
	        low: 0 /* Property */,
	        max: 0 /* Property */,
	        maxLength: 0 /* Property */,
	        media: 1 /* Attribute */,
	        mediaGroup: 0 /* Property */,
	        method: 0 /* Property */,
	        min: 0 /* Property */,
	        minLength: 0 /* Property */,
	        multiple: 0 /* Property */,
	        muted: 0 /* Property */,
	        name: 0 /* Property */,
	        noValidate: 0 /* Property */,
	        optimum: 0 /* Property */,
	        pattern: 0 /* Property */,
	        placeholder: 0 /* Property */,
	        poster: 0 /* Property */,
	        preload: 0 /* Property */,
	        readOnly: 0 /* Property */,
	        rel: 0 /* Property */,
	        required: 0 /* Property */,
	        reversed: 0 /* Property */,
	        rowSpan: 0 /* Property */,
	        rows: 0 /* Property */,
	        sandbox: 0 /* Property */,
	        scope: 0 /* Property */,
	        seamless: 1 /* Attribute */,
	        selected: 0 /* Property */,
	        shape: 0 /* Property */,
	        size: 0 /* Property */,
	        sizes: 1 /* Attribute */,
	        sorted: 0 /* Property */,
	        span: 0 /* Property */,
	        spellcheck: 0 /* Property */,
	        src: 0 /* Property */,
	        srcdoc: 0 /* Property */,
	        srclang: 0 /* Property */,
	        srcset: 1 /* Attribute */,
	        start: 0 /* Property */,
	        step: 0 /* Property */,
	        tabIndex: 0 /* Property */,
	        target: 0 /* Property */,
	        title: 0 /* Property */,
	        type: 0 /* Property */,
	        typeMustMatch: 0 /* Property */,
	        useMap: 0 /* Property */,
	        value: 0 /* Property */,
	        volume: 0 /* Property */,
	        width: 0 /* Property */,
	        wrap: 0 /* Property */,
	        onabort: 2 /* Event */,
	        onbeforecopy: 2 /* Event */,
	        onbeforecut: 2 /* Event */,
	        onbeforepaste: 2 /* Event */,
	        onblur: 2 /* Event */,
	        oncanplay: 2 /* Event */,
	        oncanplaythrough: 2 /* Event */,
	        onchange: 2 /* Event */,
	        onclick: 2 /* Event */,
	        oncontextmenu: 2 /* Event */,
	        oncopy: 2 /* Event */,
	        oncuechange: 2 /* Event */,
	        oncut: 2 /* Event */,
	        ondblclick: 2 /* Event */,
	        ondrag: 2 /* Event */,
	        ondragend: 2 /* Event */,
	        ondragenter: 2 /* Event */,
	        ondragleave: 2 /* Event */,
	        ondragover: 2 /* Event */,
	        ondragstart: 2 /* Event */,
	        ondrop: 2 /* Event */,
	        ondurationchange: 2 /* Event */,
	        onended: 2 /* Event */,
	        onemptied: 2 /* Event */,
	        onerror: 2 /* Event */,
	        onfocus: 2 /* Event */,
	        onhelp: 2 /* Event */,
	        oninput: 2 /* Event */,
	        onkeydown: 2 /* Event */,
	        onkeypress: 2 /* Event */,
	        onkeyup: 2 /* Event */,
	        onload: 2 /* Event */,
	        onloadeddata: 2 /* Event */,
	        onloadedmetadata: 2 /* Event */,
	        onloadstart: 2 /* Event */,
	        onmousedown: 2 /* Event */,
	        onmouseenter: 2 /* Event */,
	        onmouseleave: 2 /* Event */,
	        onmousemove: 2 /* Event */,
	        onmouseout: 2 /* Event */,
	        onmouseover: 2 /* Event */,
	        onmouseup: 2 /* Event */,
	        onmousewheel: 2 /* Event */,
	        onpaste: 2 /* Event */,
	        onpause: 2 /* Event */,
	        onplay: 2 /* Event */,
	        onplaying: 2 /* Event */,
	        onprogress: 2 /* Event */,
	        onratechange: 2 /* Event */,
	        onreadystatechange: 2 /* Event */,
	        onreset: 2 /* Event */,
	        onscroll: 2 /* Event */,
	        onseeked: 2 /* Event */,
	        onseeking: 2 /* Event */,
	        onselect: 2 /* Event */,
	        onselectstart: 2 /* Event */,
	        onstalled: 2 /* Event */,
	        onsubmit: 2 /* Event */,
	        onsuspend: 2 /* Event */,
	        ontimeupdate: 2 /* Event */,
	        onvolumechange: 2 /* Event */,
	        onwaiting: 2 /* Event */
	    };
	    /**
	     * Insert an element into an array at a specified index.
	     */
	    function arrayInsert(array, i, value) {
	        for (var k = array.length; k > i; --k) {
	            array[k] = array[k - 1];
	        }
	        array[i] = value;
	    }
	    /**
	     * Move an element in an array from one index to another.
	     */
	    function arrayMove(array, i, j) {
	        if (i === j) {
	            return;
	        }
	        var value = array[i];
	        var d = i < j ? 1 : -1;
	        for (var k = i; k !== j; k += d) {
	            array[k] = array[k + d];
	        }
	        array[j] = value;
	    }
	})(Private || (Private = {}));


/***/ },
/* 74 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var iteration_1 = __webpack_require__(26);
	var mutation_1 = __webpack_require__(62);
	var searching_1 = __webpack_require__(27);
	var vector_1 = __webpack_require__(29);
	var messaging_1 = __webpack_require__(56);
	var properties_1 = __webpack_require__(58);
	var cursor_1 = __webpack_require__(68);
	var platform_1 = __webpack_require__(52);
	var sizing_1 = __webpack_require__(63);
	var boxengine_1 = __webpack_require__(64);
	var panel_1 = __webpack_require__(65);
	var widget_1 = __webpack_require__(55);
	/**
	 * The class name added to SplitPanel instances.
	 */
	var SPLIT_PANEL_CLASS = 'p-SplitPanel';
	/**
	 * The class name added to split panel children.
	 */
	var CHILD_CLASS = 'p-SplitPanel-child';
	/**
	 * The class name added to split panel handles.
	 */
	var HANDLE_CLASS = 'p-SplitPanel-handle';
	/**
	 * The class name added to hidden split handles.
	 */
	var HIDDEN_CLASS = 'p-mod-hidden';
	/**
	 * The class name added to horizontal split panels.
	 */
	var HORIZONTAL_CLASS = 'p-mod-horizontal';
	/**
	 * The class name added to vertical split panels.
	 */
	var VERTICAL_CLASS = 'p-mod-vertical';
	/**
	 * A panel which arranges its widgets into resizable sections.
	 *
	 * #### Notes
	 * This class provides a convenience wrapper around a [[SplitLayout]].
	 */
	var SplitPanel = (function (_super) {
	    __extends(SplitPanel, _super);
	    /**
	     * Construct a new split panel.
	     *
	     * @param options - The options for initializing the split panel.
	     */
	    function SplitPanel(options) {
	        if (options === void 0) { options = {}; }
	        _super.call(this, { layout: Private.createLayout(options) });
	        this._pressData = null;
	        this.addClass(SPLIT_PANEL_CLASS);
	    }
	    /**
	     * Dispose of the resources held by the panel.
	     */
	    SplitPanel.prototype.dispose = function () {
	        this._releaseMouse();
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(SplitPanel.prototype, "orientation", {
	        /**
	         * Get the layout orientation for the split panel.
	         */
	        get: function () {
	            return this.layout.orientation;
	        },
	        /**
	         * Set the layout orientation for the split panel.
	         */
	        set: function (value) {
	            this.layout.orientation = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SplitPanel.prototype, "spacing", {
	        /**
	         * Get the inter-element spacing for the split panel.
	         */
	        get: function () {
	            return this.layout.spacing;
	        },
	        /**
	         * Set the inter-element spacing for the split panel.
	         */
	        set: function (value) {
	            this.layout.spacing = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SplitPanel.prototype, "renderer", {
	        /**
	         * The renderer used by the split panel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.layout.renderer;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SplitPanel.prototype, "handles", {
	        /**
	         * A read-only sequence of the split handles in the panel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.layout.handles;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the relative sizes of the widgets in the panel.
	     *
	     * @returns A new array of the relative sizes of the widgets.
	     *
	     * #### Notes
	     * The returned sizes reflect the sizes of the widgets normalized
	     * relative to their siblings.
	     *
	     * This method **does not** measure the DOM nodes.
	     */
	    SplitPanel.prototype.relativeSizes = function () {
	        return this.layout.relativeSizes();
	    };
	    /**
	     * Set the relative sizes for the widgets in the panel.
	     *
	     * @param sizes - The relative sizes for the widgets in the panel.
	     *
	     * #### Notes
	     * Extra values are ignored, too few will yield an undefined layout.
	     *
	     * The actual geometry of the DOM nodes is updated asynchronously.
	     */
	    SplitPanel.prototype.setRelativeSizes = function (sizes) {
	        this.layout.setRelativeSizes(sizes);
	    };
	    /**
	     * Handle the DOM events for the split panel.
	     *
	     * @param event - The DOM event sent to the panel.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the panel's DOM node. It should
	     * not be called directly by user code.
	     */
	    SplitPanel.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'mousedown':
	                this._evtMouseDown(event);
	                break;
	            case 'mousemove':
	                this._evtMouseMove(event);
	                break;
	            case 'mouseup':
	                this._evtMouseUp(event);
	                break;
	            case 'keydown':
	                this._evtKeyDown(event);
	                break;
	            case 'contextmenu':
	                event.preventDefault();
	                event.stopPropagation();
	                break;
	        }
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    SplitPanel.prototype.onAfterAttach = function (msg) {
	        this.node.addEventListener('mousedown', this);
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     */
	    SplitPanel.prototype.onBeforeDetach = function (msg) {
	        this.node.removeEventListener('mousedown', this);
	        this._releaseMouse();
	    };
	    /**
	     * A message handler invoked on a `'child-added'` message.
	     */
	    SplitPanel.prototype.onChildAdded = function (msg) {
	        msg.child.addClass(CHILD_CLASS);
	        this._releaseMouse();
	    };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     */
	    SplitPanel.prototype.onChildRemoved = function (msg) {
	        msg.child.removeClass(CHILD_CLASS);
	        this._releaseMouse();
	    };
	    /**
	     * Handle the `'keydown'` event for the split panel.
	     */
	    SplitPanel.prototype._evtKeyDown = function (event) {
	        // Stop input events during drag.
	        event.preventDefault();
	        event.stopPropagation();
	        // Release the mouse if `Escape` is pressed.
	        if (event.keyCode === 27)
	            this._releaseMouse();
	    };
	    /**
	     * Handle the `'mousedown'` event for the split panel.
	     */
	    SplitPanel.prototype._evtMouseDown = function (event) {
	        // Do nothing if the left mouse button is not pressed.
	        if (event.button !== 0) {
	            return;
	        }
	        // Find the handle which contains the mouse target, if any.
	        var layout = this.layout;
	        var target = event.target;
	        var index = searching_1.findIndex(layout.handles, function (handle) { return handle.contains(target); });
	        if (index === -1) {
	            return;
	        }
	        // Stop the event when a split handle is pressed.
	        event.preventDefault();
	        event.stopPropagation();
	        // Add the extra document listeners.
	        document.addEventListener('mouseup', this, true);
	        document.addEventListener('mousemove', this, true);
	        document.addEventListener('keydown', this, true);
	        document.addEventListener('contextmenu', this, true);
	        // Compute the offset delta for the handle press.
	        var delta;
	        var handle = layout.handles.at(index);
	        var rect = handle.getBoundingClientRect();
	        if (layout.orientation === 'horizontal') {
	            delta = event.clientX - rect.left;
	        }
	        else {
	            delta = event.clientY - rect.top;
	        }
	        // Override the cursor and store the press data.
	        var style = window.getComputedStyle(handle);
	        var override = cursor_1.overrideCursor(style.cursor);
	        this._pressData = { index: index, delta: delta, override: override };
	    };
	    /**
	     * Handle the `'mousemove'` event for the split panel.
	     */
	    SplitPanel.prototype._evtMouseMove = function (event) {
	        // Stop the event when dragging a split handle.
	        event.preventDefault();
	        event.stopPropagation();
	        // Compute the desired offset position for the handle.
	        var pos;
	        var layout = this.layout;
	        var rect = this.node.getBoundingClientRect();
	        if (layout.orientation === 'horizontal') {
	            pos = event.clientX - rect.left - this._pressData.delta;
	        }
	        else {
	            pos = event.clientY - rect.top - this._pressData.delta;
	        }
	        // Set the handle as close to the desired position as possible.
	        layout.setHandlePosition(this._pressData.index, pos);
	    };
	    /**
	     * Handle the `'mouseup'` event for the split panel.
	     */
	    SplitPanel.prototype._evtMouseUp = function (event) {
	        // Do nothing if the left mouse button is not released.
	        if (event.button !== 0) {
	            return;
	        }
	        // Stop the event when releasing a handle.
	        event.preventDefault();
	        event.stopPropagation();
	        // Finalize the mouse release.
	        this._releaseMouse();
	    };
	    /**
	     * Release the mouse grab for the split panel.
	     */
	    SplitPanel.prototype._releaseMouse = function () {
	        // Bail early if no drag is in progress.
	        if (!this._pressData) {
	            return;
	        }
	        // Clear the override cursor.
	        this._pressData.override.dispose();
	        this._pressData = null;
	        // Remove the extra document listeners.
	        document.removeEventListener('mouseup', this, true);
	        document.removeEventListener('mousemove', this, true);
	        document.removeEventListener('keydown', this, true);
	        document.removeEventListener('contextmenu', this, true);
	    };
	    return SplitPanel;
	}(panel_1.Panel));
	exports.SplitPanel = SplitPanel;
	/**
	 * The namespace for the `SplitPanel` class statics.
	 */
	var SplitPanel;
	(function (SplitPanel) {
	    /**
	     * The default implementation of `IRenderer`.
	     */
	    var Renderer = (function () {
	        function Renderer() {
	        }
	        /**
	         * Create a new handle node for use with a split panel.
	         *
	         * @returns A new handle node for a split panel.
	         */
	        Renderer.prototype.createHandleNode = function () {
	            var node = document.createElement('div');
	            node.className = HANDLE_CLASS;
	            return node;
	        };
	        return Renderer;
	    }());
	    SplitPanel.Renderer = Renderer;
	    /**
	     * The default `Renderer` instance.
	     */
	    SplitPanel.defaultRenderer = new Renderer();
	    /**
	     * Get the split panel stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The split panel stretch factor for the widget.
	     */
	    function getStretch(widget) {
	        return SplitLayout.getStretch(widget);
	    }
	    SplitPanel.getStretch = getStretch;
	    /**
	     * Set the split panel stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the stretch factor.
	     */
	    function setStretch(widget, value) {
	        SplitLayout.setStretch(widget, value);
	    }
	    SplitPanel.setStretch = setStretch;
	})(SplitPanel = exports.SplitPanel || (exports.SplitPanel = {}));
	/**
	 * A layout which arranges its widgets into resizable sections.
	 */
	var SplitLayout = (function (_super) {
	    __extends(SplitLayout, _super);
	    /**
	     * Construct a new split layout.
	     *
	     * @param options - The options for initializing the layout.
	     */
	    function SplitLayout(options) {
	        _super.call(this);
	        this._fixed = 0;
	        this._spacing = 4;
	        this._dirty = false;
	        this._hasNormedSizes = false;
	        this._box = null;
	        this._sizers = new vector_1.Vector();
	        this._handles = new vector_1.Vector();
	        this._orientation = 'horizontal';
	        this._renderer = options.renderer;
	        if (options.orientation !== void 0) {
	            this._orientation = options.orientation;
	        }
	        if (options.spacing !== void 0) {
	            this._spacing = Private.clampSpacing(options.spacing);
	        }
	    }
	    Object.defineProperty(SplitLayout.prototype, "orientation", {
	        /**
	         * Get the layout orientation for the split layout.
	         */
	        get: function () {
	            return this._orientation;
	        },
	        /**
	         * Set the layout orientation for the split layout.
	         */
	        set: function (value) {
	            if (this._orientation === value) {
	                return;
	            }
	            this._orientation = value;
	            if (!this.parent) {
	                return;
	            }
	            Private.toggleOrientation(this.parent, value);
	            this.parent.fit();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SplitLayout.prototype, "spacing", {
	        /**
	         * Get the inter-element spacing for the split layout.
	         */
	        get: function () {
	            return this._spacing;
	        },
	        /**
	         * Set the inter-element spacing for the split layout.
	         */
	        set: function (value) {
	            value = Private.clampSpacing(value);
	            if (this._spacing === value) {
	                return;
	            }
	            this._spacing = value;
	            if (!this.parent) {
	                return;
	            }
	            this.parent.fit();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SplitLayout.prototype, "renderer", {
	        /**
	         * The renderer used by the split layout.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._renderer;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SplitLayout.prototype, "handles", {
	        /**
	         * A read-only sequence of the split handles in the layout.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._handles;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the relative sizes of the widgets in the layout.
	     *
	     * @returns A new array of the relative sizes of the widgets.
	     *
	     * #### Notes
	     * The returned sizes reflect the sizes of the widgets normalized
	     * relative to their siblings.
	     *
	     * This method **does not** measure the DOM nodes.
	     */
	    SplitLayout.prototype.relativeSizes = function () {
	        return Private.normalize(iteration_1.toArray(iteration_1.map(this._sizers, function (sizer) { return sizer.size; })));
	    };
	    /**
	     * Set the relative sizes for the widgets in the layout.
	     *
	     * @param sizes - The relative sizes for the widgets in the panel.
	     *
	     * #### Notes
	     * Extra values are ignored, too few will yield an undefined layout.
	     *
	     * The actual geometry of the DOM nodes is updated asynchronously.
	     */
	    SplitLayout.prototype.setRelativeSizes = function (sizes) {
	        // Copy the sizes and pad with zeros as needed.
	        var n = this._sizers.length;
	        var temp = sizes.slice(0, n);
	        while (temp.length < n)
	            temp.push(0);
	        // Normalize the padded sizes.
	        var normed = Private.normalize(temp);
	        // Apply the normalized sizes to the sizers.
	        for (var i = 0; i < n; ++i) {
	            var sizer = this._sizers.at(i);
	            sizer.sizeHint = sizer.size = normed[i];
	        }
	        // Set the flag indicating the sizes are normalized.
	        this._hasNormedSizes = true;
	        // Trigger an update of the parent widget.
	        if (this.parent)
	            this.parent.update();
	    };
	    // TODO rename this to `moveHandle`
	    /**
	     * Set the offset position of a split handle.
	     *
	     * @param index - The index of the handle of the interest.
	     *
	     * @param position - The desired offset position of the handle.
	     *
	     * #### Notes
	     * The position is relative to the offset parent.
	     *
	     * This will move the handle as close as possible to the desired
	     * position. The sibling widgets will be adjusted as necessary.
	     *
	     * #### Undefined Behavior
	     * An `index` which is non-integral or out of range.
	     */
	    SplitLayout.prototype.setHandlePosition = function (index, position) {
	        // Bail if the index is invalid or the handle is hidden.
	        var handle = this._handles.at(index);
	        if (!handle || handle.classList.contains(HIDDEN_CLASS)) {
	            return;
	        }
	        // Compute the desired delta movement for the handle.
	        var delta;
	        if (this._orientation === 'horizontal') {
	            delta = position - handle.offsetLeft;
	        }
	        else {
	            delta = position - handle.offsetTop;
	        }
	        // Bail if there is no handle movement.
	        if (delta === 0) {
	            return;
	        }
	        // Prevent widget resizing unless needed.
	        iteration_1.each(this._sizers, function (sizer) {
	            // TODO is this check actually necessary?
	            if (sizer.size > 0)
	                sizer.sizeHint = sizer.size;
	        });
	        // Adjust the sizers to reflect the handle movement.
	        boxengine_1.adjustSizer(this._sizers, index, delta);
	        // Update the layout of the widgets.
	        if (this.parent)
	            this.parent.update();
	    };
	    /**
	     * Perform layout initialization which requires the parent widget.
	     */
	    SplitLayout.prototype.init = function () {
	        Private.toggleOrientation(this.parent, this.orientation);
	        _super.prototype.init.call(this);
	    };
	    /**
	     * Attach a widget to the parent's DOM node.
	     *
	     * @param index - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to attach to the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    SplitLayout.prototype.attachWidget = function (index, widget) {
	        // Create and add the handle and sizer for the new widget.
	        var handle = Private.createHandle(this._renderer);
	        var average = Private.averageSize(this._sizers);
	        var sizer = Private.createSizer(average);
	        this._sizers.insert(index, sizer);
	        this._handles.insert(index, handle);
	        // Prepare the layout geometry for the widget.
	        widget_1.Widget.prepareGeometry(widget);
	        // Add the widget and handle nodes to the parent.
	        this.parent.node.appendChild(widget.node);
	        this.parent.node.appendChild(handle);
	        // Send an `'after-attach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.AfterAttach);
	        // Post a fit request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * Move a widget in the parent's DOM node.
	     *
	     * @param fromIndex - The previous index of the widget in the layout.
	     *
	     * @param toIndex - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to move in the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    SplitLayout.prototype.moveWidget = function (fromIndex, toIndex, widget) {
	        // Move the sizer and handle for the widget.
	        mutation_1.move(this._sizers, fromIndex, toIndex);
	        mutation_1.move(this._handles, fromIndex, toIndex);
	        // Post a fit request to the parent to show/hide last handle.
	        this.parent.fit();
	    };
	    /**
	     * Detach a widget from the parent's DOM node.
	     *
	     * @param index - The previous index of the widget in the layout.
	     *
	     * @param widget - The widget to detach from the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    SplitLayout.prototype.detachWidget = function (index, widget) {
	        // Remove the handle for the widget.
	        var handle = this._handles.removeAt(index);
	        // Remove the sizer for the widget.
	        this._sizers.removeAt(index);
	        // Send a `'before-detach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.BeforeDetach);
	        // Remove the widget and handle nodes from the parent.
	        this.parent.node.removeChild(widget.node);
	        this.parent.node.removeChild(handle);
	        // Reset the layout geometry for the widget.
	        widget_1.Widget.resetGeometry(widget);
	        // Post a fit request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     */
	    SplitLayout.prototype.onAfterShow = function (msg) {
	        _super.prototype.onAfterShow.call(this, msg);
	        this.parent.update();
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    SplitLayout.prototype.onAfterAttach = function (msg) {
	        _super.prototype.onAfterAttach.call(this, msg);
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on a `'child-shown'` message.
	     */
	    SplitLayout.prototype.onChildShown = function (msg) {
	        if (platform_1.IS_IE || platform_1.IS_EDGE) {
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'child-hidden'` message.
	     */
	    SplitLayout.prototype.onChildHidden = function (msg) {
	        if (platform_1.IS_IE || platform_1.IS_EDGE) {
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     */
	    SplitLayout.prototype.onResize = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(msg.width, msg.height);
	        }
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    SplitLayout.prototype.onUpdateRequest = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(-1, -1);
	        }
	    };
	    /**
	     * A message handler invoked on a `'fit-request'` message.
	     */
	    SplitLayout.prototype.onFitRequest = function (msg) {
	        if (this.parent.isAttached) {
	            this._fit();
	        }
	    };
	    /**
	     * Fit the layout to the total size required by the widgets.
	     */
	    SplitLayout.prototype._fit = function () {
	        // Update the handles and track the visible widget count.
	        var nVisible = 0;
	        var widgets = this.widgets;
	        var lastHandle = null;
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            var handle = this._handles.at(i);
	            if (widgets.at(i).isHidden) {
	                handle.classList.add(HIDDEN_CLASS);
	            }
	            else {
	                handle.classList.remove(HIDDEN_CLASS);
	                lastHandle = handle;
	                nVisible++;
	            }
	        }
	        // Hide the handle for the last visible widget.
	        if (lastHandle)
	            lastHandle.classList.add(HIDDEN_CLASS);
	        // Update the fixed space for the visible items.
	        this._fixed = this._spacing * Math.max(0, nVisible - 1);
	        // Setup the initial size limits.
	        var minW = 0;
	        var minH = 0;
	        var maxW = Infinity;
	        var maxH = Infinity;
	        var horz = this._orientation === 'horizontal';
	        if (horz) {
	            minW = this._fixed;
	            maxW = nVisible > 0 ? minW : maxW;
	        }
	        else {
	            minH = this._fixed;
	            maxH = nVisible > 0 ? minH : maxH;
	        }
	        // Update the sizers and computed size limits.
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            var widget = widgets.at(i);
	            var sizer = this._sizers.at(i);
	            if (sizer.size > 0) {
	                sizer.sizeHint = sizer.size;
	            }
	            if (widget.isHidden) {
	                sizer.minSize = 0;
	                sizer.maxSize = 0;
	                continue;
	            }
	            var limits = sizing_1.sizeLimits(widget.node);
	            sizer.stretch = SplitLayout.getStretch(widget);
	            if (horz) {
	                sizer.minSize = limits.minWidth;
	                sizer.maxSize = limits.maxWidth;
	                minW += limits.minWidth;
	                maxW += limits.maxWidth;
	                minH = Math.max(minH, limits.minHeight);
	                maxH = Math.min(maxH, limits.maxHeight);
	            }
	            else {
	                sizer.minSize = limits.minHeight;
	                sizer.maxSize = limits.maxHeight;
	                minH += limits.minHeight;
	                maxH += limits.maxHeight;
	                minW = Math.max(minW, limits.minWidth);
	                maxW = Math.min(maxW, limits.maxWidth);
	            }
	        }
	        // Update the box sizing and add it to the size constraints.
	        var box = this._box = sizing_1.boxSizing(this.parent.node);
	        minW += box.horizontalSum;
	        minH += box.verticalSum;
	        maxW += box.horizontalSum;
	        maxH += box.verticalSum;
	        // Update the parent's size constraints.
	        var style = this.parent.node.style;
	        style.minWidth = minW + "px";
	        style.minHeight = minH + "px";
	        style.maxWidth = maxW === Infinity ? 'none' : maxW + "px";
	        style.maxHeight = maxH === Infinity ? 'none' : maxH + "px";
	        // Set the dirty flag to ensure only a single update occurs.
	        this._dirty = true;
	        // Notify the ancestor that it should fit immediately. This may
	        // cause a resize of the parent, fulfilling the required update.
	        var ancestor = this.parent.parent;
	        if (ancestor)
	            messaging_1.sendMessage(ancestor, widget_1.WidgetMessage.FitRequest);
	        // If the dirty flag is still set, the parent was not resized.
	        // Trigger the required update on the parent widget immediately.
	        if (this._dirty)
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.UpdateRequest);
	    };
	    /**
	     * Update the layout position and size of the widgets.
	     *
	     * The parent offset dimensions should be `-1` if unknown.
	     */
	    SplitLayout.prototype._update = function (offsetWidth, offsetHeight) {
	        // Clear the dirty flag to indicate the update occurred.
	        this._dirty = false;
	        // Bail early if there are no widgets to layout.
	        var widgets = this.widgets;
	        if (widgets.length === 0) {
	            return;
	        }
	        // Measure the parent if the offset dimensions are unknown.
	        if (offsetWidth < 0) {
	            offsetWidth = this.parent.node.offsetWidth;
	        }
	        if (offsetHeight < 0) {
	            offsetHeight = this.parent.node.offsetHeight;
	        }
	        // Ensure the parent box sizing data is computed.
	        var box = this._box || (this._box = sizing_1.boxSizing(this.parent.node));
	        // Compute the actual layout bounds adjusted for border and padding.
	        var top = box.paddingTop;
	        var left = box.paddingLeft;
	        var width = offsetWidth - box.horizontalSum;
	        var height = offsetHeight - box.verticalSum;
	        // Compute the adjusted layout space.
	        var space;
	        var horz = this._orientation === 'horizontal';
	        if (horz) {
	            space = Math.max(0, width - this._fixed);
	        }
	        else {
	            space = Math.max(0, height - this._fixed);
	        }
	        // Scale the size hints if they are normalized.
	        if (this._hasNormedSizes) {
	            iteration_1.each(this._sizers, function (sizer) { sizer.sizeHint *= space; });
	            this._hasNormedSizes = false;
	        }
	        // Distribute the layout space to the box sizers.
	        boxengine_1.boxCalc(this._sizers, space);
	        // Layout the widgets using the computed box sizes.
	        var spacing = this._spacing;
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            var widget = widgets.at(i);
	            if (widget.isHidden) {
	                continue;
	            }
	            var size = this._sizers.at(i).size;
	            var hstyle = this._handles.at(i).style;
	            if (horz) {
	                widget_1.Widget.setGeometry(widget, left, top, size, height);
	                left += size;
	                hstyle.top = top + "px";
	                hstyle.left = left + "px";
	                hstyle.width = spacing + "px";
	                hstyle.height = height + "px";
	                left += spacing;
	            }
	            else {
	                widget_1.Widget.setGeometry(widget, left, top, width, size);
	                top += size;
	                hstyle.top = top + "px";
	                hstyle.left = left + "px";
	                hstyle.width = width + "px";
	                hstyle.height = spacing + "px";
	                top += spacing;
	            }
	        }
	    };
	    return SplitLayout;
	}(panel_1.PanelLayout));
	exports.SplitLayout = SplitLayout;
	/**
	 * The namespace for the `SplitLayout` class statics.
	 */
	var SplitLayout;
	(function (SplitLayout) {
	    /**
	     * Get the split layout stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The split layout stretch factor for the widget.
	     */
	    function getStretch(widget) {
	        return Private.stretchProperty.get(widget);
	    }
	    SplitLayout.getStretch = getStretch;
	    /**
	     * Set the split layout stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the stretch factor.
	     */
	    function setStretch(widget, value) {
	        Private.stretchProperty.set(widget, value);
	    }
	    SplitLayout.setStretch = setStretch;
	})(SplitLayout = exports.SplitLayout || (exports.SplitLayout = {}));
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * The property descriptor for a widget stretch factor.
	     */
	    Private.stretchProperty = new properties_1.AttachedProperty({
	        name: 'stretch',
	        value: 0,
	        coerce: function (owner, value) { return Math.max(0, Math.floor(value)); },
	        changed: onChildPropertyChanged
	    });
	    /**
	     * Create a split layout for the given panel options.
	     */
	    function createLayout(options) {
	        return options.layout || new SplitLayout({
	            renderer: options.renderer || SplitPanel.defaultRenderer,
	            orientation: options.orientation,
	            spacing: options.spacing
	        });
	    }
	    Private.createLayout = createLayout;
	    /**
	     * Create a new box sizer with the given size hint.
	     */
	    function createSizer(size) {
	        var sizer = new boxengine_1.BoxSizer();
	        sizer.sizeHint = Math.floor(size);
	        return sizer;
	    }
	    Private.createSizer = createSizer;
	    /**
	     * Create a new split handle node using the given renderer.
	     */
	    function createHandle(renderer) {
	        var node = renderer.createHandleNode();
	        node.style.position = 'absolute';
	        return node;
	    }
	    Private.createHandle = createHandle;
	    /**
	     * Toggle the CSS orientation class for the given widget.
	     */
	    function toggleOrientation(widget, orient) {
	        widget.toggleClass(HORIZONTAL_CLASS, orient === 'horizontal');
	        widget.toggleClass(VERTICAL_CLASS, orient === 'vertical');
	    }
	    Private.toggleOrientation = toggleOrientation;
	    /**
	     * Clamp a spacing value to an integer >= 0.
	     */
	    function clampSpacing(value) {
	        return Math.max(0, Math.floor(value));
	    }
	    Private.clampSpacing = clampSpacing;
	    /**
	     * Compute the average size of a vector of box sizers.
	     */
	    function averageSize(sizers) {
	        return iteration_1.reduce(sizers, function (v, s) { return v + s.size; }, 0) / sizers.length || 0;
	    }
	    Private.averageSize = averageSize;
	    /**
	     * Normalize an array of values.
	     */
	    function normalize(values) {
	        var n = values.length;
	        if (n === 0)
	            return [];
	        var sum = values.reduce(function (a, b) { return a + Math.abs(b); }, 0);
	        return sum === 0 ? values.map(function (v) { return 1 / n; }) : values.map(function (v) { return v / sum; });
	    }
	    Private.normalize = normalize;
	    /**
	     * The change handler for the attached child properties.
	     */
	    function onChildPropertyChanged(child) {
	        var parent = child.parent;
	        var layout = parent && parent.layout;
	        if (layout instanceof SplitLayout)
	            parent.fit();
	    }
	})(Private || (Private = {}));


/***/ },
/* 75 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var messaging_1 = __webpack_require__(56);
	var signaling_1 = __webpack_require__(20);
	var platform_1 = __webpack_require__(52);
	var sizing_1 = __webpack_require__(63);
	var panel_1 = __webpack_require__(65);
	var widget_1 = __webpack_require__(55);
	/**
	 * The class name added to StackedPanel instances.
	 */
	var STACKED_PANEL_CLASS = 'p-StackedPanel';
	/**
	 * The class name added to a StackedPanel child.
	 */
	var CHILD_CLASS = 'p-StackedPanel-child';
	/**
	 * A panel where visible widgets are stacked atop one another.
	 *
	 * #### Notes
	 * This class provides a convenience wrapper around a [[StackedLayout]].
	 */
	var StackedPanel = (function (_super) {
	    __extends(StackedPanel, _super);
	    /**
	     * Construct a new stacked panel.
	     *
	     * @param options - The options for initializing the panel.
	     */
	    function StackedPanel(options) {
	        if (options === void 0) { options = {}; }
	        _super.call(this, { layout: Private.createLayout(options) });
	        this.addClass(STACKED_PANEL_CLASS);
	    }
	    /**
	     * A message handler invoked on a `'child-added'` message.
	     */
	    StackedPanel.prototype.onChildAdded = function (msg) {
	        msg.child.addClass(CHILD_CLASS);
	    };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     */
	    StackedPanel.prototype.onChildRemoved = function (msg) {
	        msg.child.removeClass(CHILD_CLASS);
	        this.widgetRemoved.emit(msg.child);
	    };
	    return StackedPanel;
	}(panel_1.Panel));
	exports.StackedPanel = StackedPanel;
	// Define the signals for the `StackedPanel` class.
	signaling_1.defineSignal(StackedPanel.prototype, 'widgetRemoved');
	/**
	 * A layout where visible widgets are stacked atop one another.
	 *
	 * #### Notes
	 * The Z-order of the visible widgets follows their layout order.
	 */
	var StackedLayout = (function (_super) {
	    __extends(StackedLayout, _super);
	    function StackedLayout() {
	        _super.apply(this, arguments);
	        this._dirty = false;
	        this._box = null;
	    }
	    /**
	     * Attach a widget to the parent's DOM node.
	     *
	     * @param index - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to attach to the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    StackedLayout.prototype.attachWidget = function (index, widget) {
	        // Prepare the layout geometry for the widget.
	        widget_1.Widget.prepareGeometry(widget);
	        // Add the widget's node to the parent.
	        this.parent.node.appendChild(widget.node);
	        // Send an `'after-attach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.AfterAttach);
	        // Post a fit request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * Move a widget in the parent's DOM node.
	     *
	     * @param fromIndex - The previous index of the widget in the layout.
	     *
	     * @param toIndex - The current index of the widget in the layout.
	     *
	     * @param widget - The widget to move in the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    StackedLayout.prototype.moveWidget = function (fromIndex, toIndex, widget) {
	        // Post an update request for the parent widget.
	        this.parent.update();
	    };
	    /**
	     * Detach a widget from the parent's DOM node.
	     *
	     * @param index - The previous index of the widget in the layout.
	     *
	     * @param widget - The widget to detach from the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    StackedLayout.prototype.detachWidget = function (index, widget) {
	        // Send a `'before-detach'` message if the parent is attached.
	        if (this.parent.isAttached)
	            messaging_1.sendMessage(widget, widget_1.WidgetMessage.BeforeDetach);
	        // Remove the widget's node from the parent.
	        this.parent.node.removeChild(widget.node);
	        // Reset the layout geometry for the widget.
	        widget_1.Widget.resetGeometry(widget);
	        // Reset the z-index for the widget.
	        widget.node.style.zIndex = '';
	        // Post a fit request for the parent widget.
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     */
	    StackedLayout.prototype.onAfterShow = function (msg) {
	        _super.prototype.onAfterShow.call(this, msg);
	        this.parent.update();
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    StackedLayout.prototype.onAfterAttach = function (msg) {
	        _super.prototype.onAfterAttach.call(this, msg);
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on a `'child-shown'` message.
	     */
	    StackedLayout.prototype.onChildShown = function (msg) {
	        if (platform_1.IS_IE || platform_1.IS_EDGE) {
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'child-hidden'` message.
	     */
	    StackedLayout.prototype.onChildHidden = function (msg) {
	        if (platform_1.IS_IE || platform_1.IS_EDGE) {
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.FitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     */
	    StackedLayout.prototype.onResize = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(msg.width, msg.height);
	        }
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    StackedLayout.prototype.onUpdateRequest = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(-1, -1);
	        }
	    };
	    /**
	     * A message handler invoked on a `'fit-request'` message.
	     */
	    StackedLayout.prototype.onFitRequest = function (msg) {
	        if (this.parent.isAttached) {
	            this._fit();
	        }
	    };
	    /**
	     * Fit the layout to the total size required by the widgets.
	     */
	    StackedLayout.prototype._fit = function () {
	        // Setup the initial size limits.
	        var minW = 0;
	        var minH = 0;
	        var maxW = Infinity;
	        var maxH = Infinity;
	        // Update the computed size limits.
	        var widgets = this.widgets;
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            var widget = widgets.at(i);
	            if (widget.isHidden) {
	                continue;
	            }
	            var limits = sizing_1.sizeLimits(widget.node);
	            minW = Math.max(minW, limits.minWidth);
	            minH = Math.max(minH, limits.minHeight);
	            maxW = Math.min(maxW, limits.maxWidth);
	            maxH = Math.min(maxH, limits.maxHeight);
	        }
	        // Ensure max limits >= min limits.
	        maxW = Math.max(minW, maxW);
	        maxH = Math.max(minH, maxH);
	        // Update the box sizing and add it to the size constraints.
	        var box = this._box = sizing_1.boxSizing(this.parent.node);
	        minW += box.horizontalSum;
	        minH += box.verticalSum;
	        maxW += box.horizontalSum;
	        maxH += box.verticalSum;
	        // Update the parent's size constraints.
	        var style = this.parent.node.style;
	        style.minWidth = minW + "px";
	        style.minHeight = minH + "px";
	        style.maxWidth = maxW === Infinity ? 'none' : maxW + "px";
	        style.maxHeight = maxH === Infinity ? 'none' : maxH + "px";
	        // Set the dirty flag to ensure only a single update occurs.
	        this._dirty = true;
	        // Notify the ancestor that it should fit immediately. This may
	        // cause a resize of the parent, fulfilling the required update.
	        var ancestor = this.parent.parent;
	        if (ancestor)
	            messaging_1.sendMessage(ancestor, widget_1.WidgetMessage.FitRequest);
	        // If the dirty flag is still set, the parent was not resized.
	        // Trigger the required update on the parent widget immediately.
	        if (this._dirty)
	            messaging_1.sendMessage(this.parent, widget_1.WidgetMessage.UpdateRequest);
	    };
	    /**
	     * Update the layout position and size of the widgets.
	     *
	     * The parent offset dimensions should be `-1` if unknown.
	     */
	    StackedLayout.prototype._update = function (offsetWidth, offsetHeight) {
	        // Clear the dirty flag to indicate the update occurred.
	        this._dirty = false;
	        // Bail early if there are no widgets to layout.
	        var widgets = this.widgets;
	        if (widgets.length === 0) {
	            return;
	        }
	        // Measure the parent if the offset dimensions are unknown.
	        if (offsetWidth < 0) {
	            offsetWidth = this.parent.node.offsetWidth;
	        }
	        if (offsetHeight < 0) {
	            offsetHeight = this.parent.node.offsetHeight;
	        }
	        // Ensure the parent box sizing data is computed.
	        var box = this._box || (this._box = sizing_1.boxSizing(this.parent.node));
	        // Compute the actual layout bounds adjusted for border and padding.
	        var top = box.paddingTop;
	        var left = box.paddingLeft;
	        var width = offsetWidth - box.horizontalSum;
	        var height = offsetHeight - box.verticalSum;
	        // Update the widget stacking order and layout geometry.
	        for (var i = 0, n = widgets.length; i < n; ++i) {
	            var widget = widgets.at(i);
	            if (widget.isHidden) {
	                continue;
	            }
	            widget.node.style.zIndex = "" + i;
	            widget_1.Widget.setGeometry(widget, left, top, width, height);
	        }
	    };
	    return StackedLayout;
	}(panel_1.PanelLayout));
	exports.StackedLayout = StackedLayout;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create a stacked layout for the given panel options.
	     */
	    function createLayout(options) {
	        return options.layout || new StackedLayout();
	    }
	    Private.createLayout = createLayout;
	})(Private || (Private = {}));


/***/ },
/* 76 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var semver_1 = __webpack_require__(77);
	/**
	 * A module loader using semver for dynamic resolution of requires.
	 *
	 * It is meant to be used in conjunction with the JuptyerLabPlugin
	 * for WebPack.
	 */
	var ModuleLoader = (function () {
	    /**
	     * Construct a new module loader.
	     */
	    function ModuleLoader() {
	        this._registered = Object.create(null);
	        this._parsed = Object.create(null);
	        this._modules = Object.create(null);
	        this._bundles = Object.create(null);
	        this._matches = Object.create(null);
	        // Provide the `require.ensure` function used for code
	        // splitting in the WebPack bundles.
	        // https://webpack.github.io/docs/code-splitting.html
	        this.require.ensure = this.ensureBundle.bind(this);
	        this._boundRequire = this.require.bind(this);
	        this._boundRequire.ensure = this.ensureBundle.bind(this);
	    }
	    /**
	     * Define a module that can be synchronously required.
	     *
	     * @param path - The version-mangled fully qualified path of the module.
	     *   For example, "foo@1.0.1/lib/bar/baz.js".
	     *
	     * @param callback - The callback function for invoking the module.
	     *
	     * #### Notes
	     * The callback is called with the module,
	     */
	    ModuleLoader.prototype.define = function (path, callback) {
	        if (!(path in this._registered)) {
	            this._registered[path] = callback;
	        }
	    };
	    /**
	     * Synchronously require a module that has already been loaded.
	     *
	     * @param path - The semver-mangled fully qualified path of the module.
	     *   For example, "foo@^1.1.0/lib/bar/baz.js".
	     *
	     * @returns The exports of the requested module, if registered.  The module
	     *   selected is the registered module that maximally satisfies the semver
	     *   range of the request.
	     */
	    ModuleLoader.prototype.require = function (path) {
	        // Check if module is in cache.
	        var id = this._findMatch(path);
	        var installed = this._modules;
	        if (installed[id]) {
	            return installed[id].exports;
	        }
	        // Create a new module (and put it into the cache).
	        var mod = installed[id] = {
	            exports: {},
	            id: id,
	            loaded: false
	        };
	        // Execute the module function.
	        var callback = this._registered[id];
	        callback.call(mod.exports, mod, mod.exports, this._boundRequire);
	        // Flag the module as loaded.
	        mod.loaded = true;
	        // Return the exports of the module.
	        return mod.exports;
	    };
	    /**
	     * Ensure a bundle is loaded on a page.
	     *
	     * @param path - The public path of the bundle (e.g. "lab/jupyter.bundle.js").
	     *
	     * @param callback - The callback invoked when the bundle has loaded.
	     */
	    ModuleLoader.prototype.ensureBundle = function (path, callback) {
	        var bundle = this._getBundle(path);
	        if (bundle.loaded) {
	            if (callback) {
	                callback.call(null, this.require);
	            }
	            return Promise.resolve(void 0);
	        }
	        if (callback) {
	            bundle.callbacks.push(callback);
	        }
	        return bundle.promise;
	    };
	    /**
	     * Extract the entry point plugins of an extension.
	     *
	     * @param data - The loaded entry point module.
	     *
	     * @returns An array of validated plugins.
	     *
	     * #### Notes
	     * The plugin(s) are extracted and validated before being returned.
	     */
	    ModuleLoader.prototype.extractPlugins = function (data) {
	        // We use the default export from es6 modules.
	        if (data.__esModule) {
	            data = data.default;
	        }
	        if (!Array.isArray(data)) {
	            data = [data];
	        }
	        if (!data.length) {
	            throw new Error("No plugins found");
	        }
	        for (var i = 0; i < data.length; i++) {
	            var plugin = data[i];
	            if (!plugin.hasOwnProperty('id')) {
	                throw new Error("Missing id for plugin " + i);
	            }
	            if (typeof (plugin['activate']) !== 'function') {
	                var id = plugin.id;
	                throw Error("Missing activate function in '" + id + "'");
	            }
	        }
	        return data;
	    };
	    /**
	     * Find a module path matching a given module request.
	     *
	     * @param path - The semver-mangled fully qualified path to the module.
	     *   For example, "foo@^1.1.0/lib/bar/baz.js".
	     *
	     * @returns The matching defined module path, if registered.  A match is
	     *   the registered path that maximally satisfies the semver range of the
	     *   request.
	     *
	     * #### Notes
	     * If the path has loaders, and thus multiple packages and modules delimited
	     * by '!', then the versions are matched in reverse order.
	     */
	    ModuleLoader.prototype._findMatch = function (path) {
	        var _this = this;
	        // Use the cached match if available.
	        var cache = this._matches;
	        if (cache[path]) {
	            return cache[path];
	        }
	        var modules = Object.keys(this._registered);
	        var sources = path.split('!').map(function (value) { return _this._parsePath(value); });
	        if (sources.some(function (elem) { return !elem; })) {
	            // check to see if any element of sources is falsey
	            throw Error('Invalid module path ' + path);
	        }
	        var matches = [];
	        var versions = [];
	        var _loop_1 = function (mod) {
	            var targets = mod.split('!').map(function (value) { return _this._parsePath(value); });
	            if (targets.some(function (e) { return !e; })) {
	                return "continue";
	            }
	            if (sources.length === targets.length && sources.every(function (source, i) {
	                return (source.package === targets[i].package
	                    && source.module === targets[i].module);
	            })) {
	                matches.push(mod);
	                versions.push(targets.map(function (t) { return t.version; }));
	            }
	        };
	        for (var _i = 0, modules_1 = modules; _i < modules_1.length; _i++) {
	            var mod = modules_1[_i];
	            _loop_1(mod);
	        }
	        if (!matches.length) {
	            throw Error("No module found matching: " + path);
	        }
	        var _loop_2 = function (part) {
	            var best = semver_1.maxSatisfying(versions.map(function (v) { return v[part]; }), sources[part].version);
	            if (!best) {
	                throw new Error("No module found satisfying " + path);
	            }
	            matches = matches.filter(function (mod, index) { return versions[index][part] === best; });
	            versions = versions.filter(function (v) { return v[part] === best; });
	        };
	        // If we have a chain of loaders, we want
	        // to filter for best versions in reverse order.
	        for (var part = versions[0].length - 1; matches.length > 1 && part >= 0; part--) {
	            _loop_2(part);
	        }
	        cache[path] = matches[0];
	        return matches[0];
	    };
	    /**
	     * Get or create a bundle record for a path.
	     */
	    ModuleLoader.prototype._getBundle = function (path) {
	        var _this = this;
	        var bundle = this._bundles[path];
	        if (bundle) {
	            return bundle;
	        }
	        // Start bundle loading.
	        var head = document.getElementsByTagName('head')[0];
	        var script = document.createElement('script');
	        script.type = 'text/javascript';
	        script.charset = 'utf-8';
	        script.async = true;
	        var promise = new Promise(function (resolve, reject) {
	            script.onload = function () {
	                while (bundle.callbacks.length) {
	                    bundle.callbacks.shift().call(null, _this.require.bind(_this));
	                }
	                bundle.loaded = true;
	                resolve(void 0);
	            };
	            script.onerror = function (err) {
	                reject(err);
	            };
	        });
	        head.appendChild(script);
	        script.src = path;
	        bundle = this._bundles[path] = {
	            loaded: false,
	            callbacks: [],
	            promise: promise
	        };
	        return bundle;
	    };
	    /**
	     * Parse a version-mangled module path.
	     *
	     * @param path - The module path (e.g. "foo@^1.1.0/lib/bar/baz.js").
	     *
	     * @returns A parsed object describing the module path.
	     */
	    ModuleLoader.prototype._parsePath = function (path) {
	        var cache = this._parsed;
	        if (cache[path]) {
	            return cache[path];
	        }
	        var match = path.match(/(^(?:@[^/]+\/)??[^/@]+?)@([^/]+?)(\/.*)?$/);
	        if (!match) {
	            cache[path] = null;
	        }
	        else {
	            cache[path] = {
	                package: match[1],
	                version: match[2],
	                module: match[3]
	            };
	        }
	        return cache[path];
	    };
	    return ModuleLoader;
	}());
	exports.ModuleLoader = ModuleLoader;
	//# sourceMappingURL=loader.js.map

/***/ },
/* 77 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {exports = module.exports = SemVer;
	
	// The debug function is excluded entirely from the minified version.
	/* nomin */ var debug;
	/* nomin */ if (typeof process === 'object' &&
	    /* nomin */ process.env &&
	    /* nomin */ process.env.NODE_DEBUG &&
	    /* nomin */ /\bsemver\b/i.test(process.env.NODE_DEBUG))
	  /* nomin */ debug = function() {
	    /* nomin */ var args = Array.prototype.slice.call(arguments, 0);
	    /* nomin */ args.unshift('SEMVER');
	    /* nomin */ console.log.apply(console, args);
	    /* nomin */ };
	/* nomin */ else
	  /* nomin */ debug = function() {};
	
	// Note: this is the semver.org version of the spec that it implements
	// Not necessarily the package version of this code.
	exports.SEMVER_SPEC_VERSION = '2.0.0';
	
	var MAX_LENGTH = 256;
	var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;
	
	// The actual regexps go on exports.re
	var re = exports.re = [];
	var src = exports.src = [];
	var R = 0;
	
	// The following Regular Expressions can be used for tokenizing,
	// validating, and parsing SemVer version strings.
	
	// ## Numeric Identifier
	// A single `0`, or a non-zero digit followed by zero or more digits.
	
	var NUMERICIDENTIFIER = R++;
	src[NUMERICIDENTIFIER] = '0|[1-9]\\d*';
	var NUMERICIDENTIFIERLOOSE = R++;
	src[NUMERICIDENTIFIERLOOSE] = '[0-9]+';
	
	
	// ## Non-numeric Identifier
	// Zero or more digits, followed by a letter or hyphen, and then zero or
	// more letters, digits, or hyphens.
	
	var NONNUMERICIDENTIFIER = R++;
	src[NONNUMERICIDENTIFIER] = '\\d*[a-zA-Z-][a-zA-Z0-9-]*';
	
	
	// ## Main Version
	// Three dot-separated numeric identifiers.
	
	var MAINVERSION = R++;
	src[MAINVERSION] = '(' + src[NUMERICIDENTIFIER] + ')\\.' +
	                   '(' + src[NUMERICIDENTIFIER] + ')\\.' +
	                   '(' + src[NUMERICIDENTIFIER] + ')';
	
	var MAINVERSIONLOOSE = R++;
	src[MAINVERSIONLOOSE] = '(' + src[NUMERICIDENTIFIERLOOSE] + ')\\.' +
	                        '(' + src[NUMERICIDENTIFIERLOOSE] + ')\\.' +
	                        '(' + src[NUMERICIDENTIFIERLOOSE] + ')';
	
	// ## Pre-release Version Identifier
	// A numeric identifier, or a non-numeric identifier.
	
	var PRERELEASEIDENTIFIER = R++;
	src[PRERELEASEIDENTIFIER] = '(?:' + src[NUMERICIDENTIFIER] +
	                            '|' + src[NONNUMERICIDENTIFIER] + ')';
	
	var PRERELEASEIDENTIFIERLOOSE = R++;
	src[PRERELEASEIDENTIFIERLOOSE] = '(?:' + src[NUMERICIDENTIFIERLOOSE] +
	                                 '|' + src[NONNUMERICIDENTIFIER] + ')';
	
	
	// ## Pre-release Version
	// Hyphen, followed by one or more dot-separated pre-release version
	// identifiers.
	
	var PRERELEASE = R++;
	src[PRERELEASE] = '(?:-(' + src[PRERELEASEIDENTIFIER] +
	                  '(?:\\.' + src[PRERELEASEIDENTIFIER] + ')*))';
	
	var PRERELEASELOOSE = R++;
	src[PRERELEASELOOSE] = '(?:-?(' + src[PRERELEASEIDENTIFIERLOOSE] +
	                       '(?:\\.' + src[PRERELEASEIDENTIFIERLOOSE] + ')*))';
	
	// ## Build Metadata Identifier
	// Any combination of digits, letters, or hyphens.
	
	var BUILDIDENTIFIER = R++;
	src[BUILDIDENTIFIER] = '[0-9A-Za-z-]+';
	
	// ## Build Metadata
	// Plus sign, followed by one or more period-separated build metadata
	// identifiers.
	
	var BUILD = R++;
	src[BUILD] = '(?:\\+(' + src[BUILDIDENTIFIER] +
	             '(?:\\.' + src[BUILDIDENTIFIER] + ')*))';
	
	
	// ## Full Version String
	// A main version, followed optionally by a pre-release version and
	// build metadata.
	
	// Note that the only major, minor, patch, and pre-release sections of
	// the version string are capturing groups.  The build metadata is not a
	// capturing group, because it should not ever be used in version
	// comparison.
	
	var FULL = R++;
	var FULLPLAIN = 'v?' + src[MAINVERSION] +
	                src[PRERELEASE] + '?' +
	                src[BUILD] + '?';
	
	src[FULL] = '^' + FULLPLAIN + '$';
	
	// like full, but allows v1.2.3 and =1.2.3, which people do sometimes.
	// also, 1.0.0alpha1 (prerelease without the hyphen) which is pretty
	// common in the npm registry.
	var LOOSEPLAIN = '[v=\\s]*' + src[MAINVERSIONLOOSE] +
	                 src[PRERELEASELOOSE] + '?' +
	                 src[BUILD] + '?';
	
	var LOOSE = R++;
	src[LOOSE] = '^' + LOOSEPLAIN + '$';
	
	var GTLT = R++;
	src[GTLT] = '((?:<|>)?=?)';
	
	// Something like "2.*" or "1.2.x".
	// Note that "x.x" is a valid xRange identifer, meaning "any version"
	// Only the first item is strictly required.
	var XRANGEIDENTIFIERLOOSE = R++;
	src[XRANGEIDENTIFIERLOOSE] = src[NUMERICIDENTIFIERLOOSE] + '|x|X|\\*';
	var XRANGEIDENTIFIER = R++;
	src[XRANGEIDENTIFIER] = src[NUMERICIDENTIFIER] + '|x|X|\\*';
	
	var XRANGEPLAIN = R++;
	src[XRANGEPLAIN] = '[v=\\s]*(' + src[XRANGEIDENTIFIER] + ')' +
	                   '(?:\\.(' + src[XRANGEIDENTIFIER] + ')' +
	                   '(?:\\.(' + src[XRANGEIDENTIFIER] + ')' +
	                   '(?:' + src[PRERELEASE] + ')?' +
	                   src[BUILD] + '?' +
	                   ')?)?';
	
	var XRANGEPLAINLOOSE = R++;
	src[XRANGEPLAINLOOSE] = '[v=\\s]*(' + src[XRANGEIDENTIFIERLOOSE] + ')' +
	                        '(?:\\.(' + src[XRANGEIDENTIFIERLOOSE] + ')' +
	                        '(?:\\.(' + src[XRANGEIDENTIFIERLOOSE] + ')' +
	                        '(?:' + src[PRERELEASELOOSE] + ')?' +
	                        src[BUILD] + '?' +
	                        ')?)?';
	
	var XRANGE = R++;
	src[XRANGE] = '^' + src[GTLT] + '\\s*' + src[XRANGEPLAIN] + '$';
	var XRANGELOOSE = R++;
	src[XRANGELOOSE] = '^' + src[GTLT] + '\\s*' + src[XRANGEPLAINLOOSE] + '$';
	
	// Tilde ranges.
	// Meaning is "reasonably at or greater than"
	var LONETILDE = R++;
	src[LONETILDE] = '(?:~>?)';
	
	var TILDETRIM = R++;
	src[TILDETRIM] = '(\\s*)' + src[LONETILDE] + '\\s+';
	re[TILDETRIM] = new RegExp(src[TILDETRIM], 'g');
	var tildeTrimReplace = '$1~';
	
	var TILDE = R++;
	src[TILDE] = '^' + src[LONETILDE] + src[XRANGEPLAIN] + '$';
	var TILDELOOSE = R++;
	src[TILDELOOSE] = '^' + src[LONETILDE] + src[XRANGEPLAINLOOSE] + '$';
	
	// Caret ranges.
	// Meaning is "at least and backwards compatible with"
	var LONECARET = R++;
	src[LONECARET] = '(?:\\^)';
	
	var CARETTRIM = R++;
	src[CARETTRIM] = '(\\s*)' + src[LONECARET] + '\\s+';
	re[CARETTRIM] = new RegExp(src[CARETTRIM], 'g');
	var caretTrimReplace = '$1^';
	
	var CARET = R++;
	src[CARET] = '^' + src[LONECARET] + src[XRANGEPLAIN] + '$';
	var CARETLOOSE = R++;
	src[CARETLOOSE] = '^' + src[LONECARET] + src[XRANGEPLAINLOOSE] + '$';
	
	// A simple gt/lt/eq thing, or just "" to indicate "any version"
	var COMPARATORLOOSE = R++;
	src[COMPARATORLOOSE] = '^' + src[GTLT] + '\\s*(' + LOOSEPLAIN + ')$|^$';
	var COMPARATOR = R++;
	src[COMPARATOR] = '^' + src[GTLT] + '\\s*(' + FULLPLAIN + ')$|^$';
	
	
	// An expression to strip any whitespace between the gtlt and the thing
	// it modifies, so that `> 1.2.3` ==> `>1.2.3`
	var COMPARATORTRIM = R++;
	src[COMPARATORTRIM] = '(\\s*)' + src[GTLT] +
	                      '\\s*(' + LOOSEPLAIN + '|' + src[XRANGEPLAIN] + ')';
	
	// this one has to use the /g flag
	re[COMPARATORTRIM] = new RegExp(src[COMPARATORTRIM], 'g');
	var comparatorTrimReplace = '$1$2$3';
	
	
	// Something like `1.2.3 - 1.2.4`
	// Note that these all use the loose form, because they'll be
	// checked against either the strict or loose comparator form
	// later.
	var HYPHENRANGE = R++;
	src[HYPHENRANGE] = '^\\s*(' + src[XRANGEPLAIN] + ')' +
	                   '\\s+-\\s+' +
	                   '(' + src[XRANGEPLAIN] + ')' +
	                   '\\s*$';
	
	var HYPHENRANGELOOSE = R++;
	src[HYPHENRANGELOOSE] = '^\\s*(' + src[XRANGEPLAINLOOSE] + ')' +
	                        '\\s+-\\s+' +
	                        '(' + src[XRANGEPLAINLOOSE] + ')' +
	                        '\\s*$';
	
	// Star ranges basically just allow anything at all.
	var STAR = R++;
	src[STAR] = '(<|>)?=?\\s*\\*';
	
	// Compile to actual regexp objects.
	// All are flag-free, unless they were created above with a flag.
	for (var i = 0; i < R; i++) {
	  debug(i, src[i]);
	  if (!re[i])
	    re[i] = new RegExp(src[i]);
	}
	
	exports.parse = parse;
	function parse(version, loose) {
	  if (version instanceof SemVer)
	    return version;
	
	  if (typeof version !== 'string')
	    return null;
	
	  if (version.length > MAX_LENGTH)
	    return null;
	
	  var r = loose ? re[LOOSE] : re[FULL];
	  if (!r.test(version))
	    return null;
	
	  try {
	    return new SemVer(version, loose);
	  } catch (er) {
	    return null;
	  }
	}
	
	exports.valid = valid;
	function valid(version, loose) {
	  var v = parse(version, loose);
	  return v ? v.version : null;
	}
	
	
	exports.clean = clean;
	function clean(version, loose) {
	  var s = parse(version.trim().replace(/^[=v]+/, ''), loose);
	  return s ? s.version : null;
	}
	
	exports.SemVer = SemVer;
	
	function SemVer(version, loose) {
	  if (version instanceof SemVer) {
	    if (version.loose === loose)
	      return version;
	    else
	      version = version.version;
	  } else if (typeof version !== 'string') {
	    throw new TypeError('Invalid Version: ' + version);
	  }
	
	  if (version.length > MAX_LENGTH)
	    throw new TypeError('version is longer than ' + MAX_LENGTH + ' characters')
	
	  if (!(this instanceof SemVer))
	    return new SemVer(version, loose);
	
	  debug('SemVer', version, loose);
	  this.loose = loose;
	  var m = version.trim().match(loose ? re[LOOSE] : re[FULL]);
	
	  if (!m)
	    throw new TypeError('Invalid Version: ' + version);
	
	  this.raw = version;
	
	  // these are actually numbers
	  this.major = +m[1];
	  this.minor = +m[2];
	  this.patch = +m[3];
	
	  if (this.major > MAX_SAFE_INTEGER || this.major < 0)
	    throw new TypeError('Invalid major version')
	
	  if (this.minor > MAX_SAFE_INTEGER || this.minor < 0)
	    throw new TypeError('Invalid minor version')
	
	  if (this.patch > MAX_SAFE_INTEGER || this.patch < 0)
	    throw new TypeError('Invalid patch version')
	
	  // numberify any prerelease numeric ids
	  if (!m[4])
	    this.prerelease = [];
	  else
	    this.prerelease = m[4].split('.').map(function(id) {
	      if (/^[0-9]+$/.test(id)) {
	        var num = +id;
	        if (num >= 0 && num < MAX_SAFE_INTEGER)
	          return num;
	      }
	      return id;
	    });
	
	  this.build = m[5] ? m[5].split('.') : [];
	  this.format();
	}
	
	SemVer.prototype.format = function() {
	  this.version = this.major + '.' + this.minor + '.' + this.patch;
	  if (this.prerelease.length)
	    this.version += '-' + this.prerelease.join('.');
	  return this.version;
	};
	
	SemVer.prototype.toString = function() {
	  return this.version;
	};
	
	SemVer.prototype.compare = function(other) {
	  debug('SemVer.compare', this.version, this.loose, other);
	  if (!(other instanceof SemVer))
	    other = new SemVer(other, this.loose);
	
	  return this.compareMain(other) || this.comparePre(other);
	};
	
	SemVer.prototype.compareMain = function(other) {
	  if (!(other instanceof SemVer))
	    other = new SemVer(other, this.loose);
	
	  return compareIdentifiers(this.major, other.major) ||
	         compareIdentifiers(this.minor, other.minor) ||
	         compareIdentifiers(this.patch, other.patch);
	};
	
	SemVer.prototype.comparePre = function(other) {
	  if (!(other instanceof SemVer))
	    other = new SemVer(other, this.loose);
	
	  // NOT having a prerelease is > having one
	  if (this.prerelease.length && !other.prerelease.length)
	    return -1;
	  else if (!this.prerelease.length && other.prerelease.length)
	    return 1;
	  else if (!this.prerelease.length && !other.prerelease.length)
	    return 0;
	
	  var i = 0;
	  do {
	    var a = this.prerelease[i];
	    var b = other.prerelease[i];
	    debug('prerelease compare', i, a, b);
	    if (a === undefined && b === undefined)
	      return 0;
	    else if (b === undefined)
	      return 1;
	    else if (a === undefined)
	      return -1;
	    else if (a === b)
	      continue;
	    else
	      return compareIdentifiers(a, b);
	  } while (++i);
	};
	
	// preminor will bump the version up to the next minor release, and immediately
	// down to pre-release. premajor and prepatch work the same way.
	SemVer.prototype.inc = function(release, identifier) {
	  switch (release) {
	    case 'premajor':
	      this.prerelease.length = 0;
	      this.patch = 0;
	      this.minor = 0;
	      this.major++;
	      this.inc('pre', identifier);
	      break;
	    case 'preminor':
	      this.prerelease.length = 0;
	      this.patch = 0;
	      this.minor++;
	      this.inc('pre', identifier);
	      break;
	    case 'prepatch':
	      // If this is already a prerelease, it will bump to the next version
	      // drop any prereleases that might already exist, since they are not
	      // relevant at this point.
	      this.prerelease.length = 0;
	      this.inc('patch', identifier);
	      this.inc('pre', identifier);
	      break;
	    // If the input is a non-prerelease version, this acts the same as
	    // prepatch.
	    case 'prerelease':
	      if (this.prerelease.length === 0)
	        this.inc('patch', identifier);
	      this.inc('pre', identifier);
	      break;
	
	    case 'major':
	      // If this is a pre-major version, bump up to the same major version.
	      // Otherwise increment major.
	      // 1.0.0-5 bumps to 1.0.0
	      // 1.1.0 bumps to 2.0.0
	      if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0)
	        this.major++;
	      this.minor = 0;
	      this.patch = 0;
	      this.prerelease = [];
	      break;
	    case 'minor':
	      // If this is a pre-minor version, bump up to the same minor version.
	      // Otherwise increment minor.
	      // 1.2.0-5 bumps to 1.2.0
	      // 1.2.1 bumps to 1.3.0
	      if (this.patch !== 0 || this.prerelease.length === 0)
	        this.minor++;
	      this.patch = 0;
	      this.prerelease = [];
	      break;
	    case 'patch':
	      // If this is not a pre-release version, it will increment the patch.
	      // If it is a pre-release it will bump up to the same patch version.
	      // 1.2.0-5 patches to 1.2.0
	      // 1.2.0 patches to 1.2.1
	      if (this.prerelease.length === 0)
	        this.patch++;
	      this.prerelease = [];
	      break;
	    // This probably shouldn't be used publicly.
	    // 1.0.0 "pre" would become 1.0.0-0 which is the wrong direction.
	    case 'pre':
	      if (this.prerelease.length === 0)
	        this.prerelease = [0];
	      else {
	        var i = this.prerelease.length;
	        while (--i >= 0) {
	          if (typeof this.prerelease[i] === 'number') {
	            this.prerelease[i]++;
	            i = -2;
	          }
	        }
	        if (i === -1) // didn't increment anything
	          this.prerelease.push(0);
	      }
	      if (identifier) {
	        // 1.2.0-beta.1 bumps to 1.2.0-beta.2,
	        // 1.2.0-beta.fooblz or 1.2.0-beta bumps to 1.2.0-beta.0
	        if (this.prerelease[0] === identifier) {
	          if (isNaN(this.prerelease[1]))
	            this.prerelease = [identifier, 0];
	        } else
	          this.prerelease = [identifier, 0];
	      }
	      break;
	
	    default:
	      throw new Error('invalid increment argument: ' + release);
	  }
	  this.format();
	  this.raw = this.version;
	  return this;
	};
	
	exports.inc = inc;
	function inc(version, release, loose, identifier) {
	  if (typeof(loose) === 'string') {
	    identifier = loose;
	    loose = undefined;
	  }
	
	  try {
	    return new SemVer(version, loose).inc(release, identifier).version;
	  } catch (er) {
	    return null;
	  }
	}
	
	exports.diff = diff;
	function diff(version1, version2) {
	  if (eq(version1, version2)) {
	    return null;
	  } else {
	    var v1 = parse(version1);
	    var v2 = parse(version2);
	    if (v1.prerelease.length || v2.prerelease.length) {
	      for (var key in v1) {
	        if (key === 'major' || key === 'minor' || key === 'patch') {
	          if (v1[key] !== v2[key]) {
	            return 'pre'+key;
	          }
	        }
	      }
	      return 'prerelease';
	    }
	    for (var key in v1) {
	      if (key === 'major' || key === 'minor' || key === 'patch') {
	        if (v1[key] !== v2[key]) {
	          return key;
	        }
	      }
	    }
	  }
	}
	
	exports.compareIdentifiers = compareIdentifiers;
	
	var numeric = /^[0-9]+$/;
	function compareIdentifiers(a, b) {
	  var anum = numeric.test(a);
	  var bnum = numeric.test(b);
	
	  if (anum && bnum) {
	    a = +a;
	    b = +b;
	  }
	
	  return (anum && !bnum) ? -1 :
	         (bnum && !anum) ? 1 :
	         a < b ? -1 :
	         a > b ? 1 :
	         0;
	}
	
	exports.rcompareIdentifiers = rcompareIdentifiers;
	function rcompareIdentifiers(a, b) {
	  return compareIdentifiers(b, a);
	}
	
	exports.major = major;
	function major(a, loose) {
	  return new SemVer(a, loose).major;
	}
	
	exports.minor = minor;
	function minor(a, loose) {
	  return new SemVer(a, loose).minor;
	}
	
	exports.patch = patch;
	function patch(a, loose) {
	  return new SemVer(a, loose).patch;
	}
	
	exports.compare = compare;
	function compare(a, b, loose) {
	  return new SemVer(a, loose).compare(b);
	}
	
	exports.compareLoose = compareLoose;
	function compareLoose(a, b) {
	  return compare(a, b, true);
	}
	
	exports.rcompare = rcompare;
	function rcompare(a, b, loose) {
	  return compare(b, a, loose);
	}
	
	exports.sort = sort;
	function sort(list, loose) {
	  return list.sort(function(a, b) {
	    return exports.compare(a, b, loose);
	  });
	}
	
	exports.rsort = rsort;
	function rsort(list, loose) {
	  return list.sort(function(a, b) {
	    return exports.rcompare(a, b, loose);
	  });
	}
	
	exports.gt = gt;
	function gt(a, b, loose) {
	  return compare(a, b, loose) > 0;
	}
	
	exports.lt = lt;
	function lt(a, b, loose) {
	  return compare(a, b, loose) < 0;
	}
	
	exports.eq = eq;
	function eq(a, b, loose) {
	  return compare(a, b, loose) === 0;
	}
	
	exports.neq = neq;
	function neq(a, b, loose) {
	  return compare(a, b, loose) !== 0;
	}
	
	exports.gte = gte;
	function gte(a, b, loose) {
	  return compare(a, b, loose) >= 0;
	}
	
	exports.lte = lte;
	function lte(a, b, loose) {
	  return compare(a, b, loose) <= 0;
	}
	
	exports.cmp = cmp;
	function cmp(a, op, b, loose) {
	  var ret;
	  switch (op) {
	    case '===':
	      if (typeof a === 'object') a = a.version;
	      if (typeof b === 'object') b = b.version;
	      ret = a === b;
	      break;
	    case '!==':
	      if (typeof a === 'object') a = a.version;
	      if (typeof b === 'object') b = b.version;
	      ret = a !== b;
	      break;
	    case '': case '=': case '==': ret = eq(a, b, loose); break;
	    case '!=': ret = neq(a, b, loose); break;
	    case '>': ret = gt(a, b, loose); break;
	    case '>=': ret = gte(a, b, loose); break;
	    case '<': ret = lt(a, b, loose); break;
	    case '<=': ret = lte(a, b, loose); break;
	    default: throw new TypeError('Invalid operator: ' + op);
	  }
	  return ret;
	}
	
	exports.Comparator = Comparator;
	function Comparator(comp, loose) {
	  if (comp instanceof Comparator) {
	    if (comp.loose === loose)
	      return comp;
	    else
	      comp = comp.value;
	  }
	
	  if (!(this instanceof Comparator))
	    return new Comparator(comp, loose);
	
	  debug('comparator', comp, loose);
	  this.loose = loose;
	  this.parse(comp);
	
	  if (this.semver === ANY)
	    this.value = '';
	  else
	    this.value = this.operator + this.semver.version;
	
	  debug('comp', this);
	}
	
	var ANY = {};
	Comparator.prototype.parse = function(comp) {
	  var r = this.loose ? re[COMPARATORLOOSE] : re[COMPARATOR];
	  var m = comp.match(r);
	
	  if (!m)
	    throw new TypeError('Invalid comparator: ' + comp);
	
	  this.operator = m[1];
	  if (this.operator === '=')
	    this.operator = '';
	
	  // if it literally is just '>' or '' then allow anything.
	  if (!m[2])
	    this.semver = ANY;
	  else
	    this.semver = new SemVer(m[2], this.loose);
	};
	
	Comparator.prototype.toString = function() {
	  return this.value;
	};
	
	Comparator.prototype.test = function(version) {
	  debug('Comparator.test', version, this.loose);
	
	  if (this.semver === ANY)
	    return true;
	
	  if (typeof version === 'string')
	    version = new SemVer(version, this.loose);
	
	  return cmp(version, this.operator, this.semver, this.loose);
	};
	
	
	exports.Range = Range;
	function Range(range, loose) {
	  if ((range instanceof Range) && range.loose === loose)
	    return range;
	
	  if (!(this instanceof Range))
	    return new Range(range, loose);
	
	  this.loose = loose;
	
	  // First, split based on boolean or ||
	  this.raw = range;
	  this.set = range.split(/\s*\|\|\s*/).map(function(range) {
	    return this.parseRange(range.trim());
	  }, this).filter(function(c) {
	    // throw out any that are not relevant for whatever reason
	    return c.length;
	  });
	
	  if (!this.set.length) {
	    throw new TypeError('Invalid SemVer Range: ' + range);
	  }
	
	  this.format();
	}
	
	Range.prototype.format = function() {
	  this.range = this.set.map(function(comps) {
	    return comps.join(' ').trim();
	  }).join('||').trim();
	  return this.range;
	};
	
	Range.prototype.toString = function() {
	  return this.range;
	};
	
	Range.prototype.parseRange = function(range) {
	  var loose = this.loose;
	  range = range.trim();
	  debug('range', range, loose);
	  // `1.2.3 - 1.2.4` => `>=1.2.3 <=1.2.4`
	  var hr = loose ? re[HYPHENRANGELOOSE] : re[HYPHENRANGE];
	  range = range.replace(hr, hyphenReplace);
	  debug('hyphen replace', range);
	  // `> 1.2.3 < 1.2.5` => `>1.2.3 <1.2.5`
	  range = range.replace(re[COMPARATORTRIM], comparatorTrimReplace);
	  debug('comparator trim', range, re[COMPARATORTRIM]);
	
	  // `~ 1.2.3` => `~1.2.3`
	  range = range.replace(re[TILDETRIM], tildeTrimReplace);
	
	  // `^ 1.2.3` => `^1.2.3`
	  range = range.replace(re[CARETTRIM], caretTrimReplace);
	
	  // normalize spaces
	  range = range.split(/\s+/).join(' ');
	
	  // At this point, the range is completely trimmed and
	  // ready to be split into comparators.
	
	  var compRe = loose ? re[COMPARATORLOOSE] : re[COMPARATOR];
	  var set = range.split(' ').map(function(comp) {
	    return parseComparator(comp, loose);
	  }).join(' ').split(/\s+/);
	  if (this.loose) {
	    // in loose mode, throw out any that are not valid comparators
	    set = set.filter(function(comp) {
	      return !!comp.match(compRe);
	    });
	  }
	  set = set.map(function(comp) {
	    return new Comparator(comp, loose);
	  });
	
	  return set;
	};
	
	// Mostly just for testing and legacy API reasons
	exports.toComparators = toComparators;
	function toComparators(range, loose) {
	  return new Range(range, loose).set.map(function(comp) {
	    return comp.map(function(c) {
	      return c.value;
	    }).join(' ').trim().split(' ');
	  });
	}
	
	// comprised of xranges, tildes, stars, and gtlt's at this point.
	// already replaced the hyphen ranges
	// turn into a set of JUST comparators.
	function parseComparator(comp, loose) {
	  debug('comp', comp);
	  comp = replaceCarets(comp, loose);
	  debug('caret', comp);
	  comp = replaceTildes(comp, loose);
	  debug('tildes', comp);
	  comp = replaceXRanges(comp, loose);
	  debug('xrange', comp);
	  comp = replaceStars(comp, loose);
	  debug('stars', comp);
	  return comp;
	}
	
	function isX(id) {
	  return !id || id.toLowerCase() === 'x' || id === '*';
	}
	
	// ~, ~> --> * (any, kinda silly)
	// ~2, ~2.x, ~2.x.x, ~>2, ~>2.x ~>2.x.x --> >=2.0.0 <3.0.0
	// ~2.0, ~2.0.x, ~>2.0, ~>2.0.x --> >=2.0.0 <2.1.0
	// ~1.2, ~1.2.x, ~>1.2, ~>1.2.x --> >=1.2.0 <1.3.0
	// ~1.2.3, ~>1.2.3 --> >=1.2.3 <1.3.0
	// ~1.2.0, ~>1.2.0 --> >=1.2.0 <1.3.0
	function replaceTildes(comp, loose) {
	  return comp.trim().split(/\s+/).map(function(comp) {
	    return replaceTilde(comp, loose);
	  }).join(' ');
	}
	
	function replaceTilde(comp, loose) {
	  var r = loose ? re[TILDELOOSE] : re[TILDE];
	  return comp.replace(r, function(_, M, m, p, pr) {
	    debug('tilde', comp, _, M, m, p, pr);
	    var ret;
	
	    if (isX(M))
	      ret = '';
	    else if (isX(m))
	      ret = '>=' + M + '.0.0 <' + (+M + 1) + '.0.0';
	    else if (isX(p))
	      // ~1.2 == >=1.2.0 <1.3.0
	      ret = '>=' + M + '.' + m + '.0 <' + M + '.' + (+m + 1) + '.0';
	    else if (pr) {
	      debug('replaceTilde pr', pr);
	      if (pr.charAt(0) !== '-')
	        pr = '-' + pr;
	      ret = '>=' + M + '.' + m + '.' + p + pr +
	            ' <' + M + '.' + (+m + 1) + '.0';
	    } else
	      // ~1.2.3 == >=1.2.3 <1.3.0
	      ret = '>=' + M + '.' + m + '.' + p +
	            ' <' + M + '.' + (+m + 1) + '.0';
	
	    debug('tilde return', ret);
	    return ret;
	  });
	}
	
	// ^ --> * (any, kinda silly)
	// ^2, ^2.x, ^2.x.x --> >=2.0.0 <3.0.0
	// ^2.0, ^2.0.x --> >=2.0.0 <3.0.0
	// ^1.2, ^1.2.x --> >=1.2.0 <2.0.0
	// ^1.2.3 --> >=1.2.3 <2.0.0
	// ^1.2.0 --> >=1.2.0 <2.0.0
	function replaceCarets(comp, loose) {
	  return comp.trim().split(/\s+/).map(function(comp) {
	    return replaceCaret(comp, loose);
	  }).join(' ');
	}
	
	function replaceCaret(comp, loose) {
	  debug('caret', comp, loose);
	  var r = loose ? re[CARETLOOSE] : re[CARET];
	  return comp.replace(r, function(_, M, m, p, pr) {
	    debug('caret', comp, _, M, m, p, pr);
	    var ret;
	
	    if (isX(M))
	      ret = '';
	    else if (isX(m))
	      ret = '>=' + M + '.0.0 <' + (+M + 1) + '.0.0';
	    else if (isX(p)) {
	      if (M === '0')
	        ret = '>=' + M + '.' + m + '.0 <' + M + '.' + (+m + 1) + '.0';
	      else
	        ret = '>=' + M + '.' + m + '.0 <' + (+M + 1) + '.0.0';
	    } else if (pr) {
	      debug('replaceCaret pr', pr);
	      if (pr.charAt(0) !== '-')
	        pr = '-' + pr;
	      if (M === '0') {
	        if (m === '0')
	          ret = '>=' + M + '.' + m + '.' + p + pr +
	                ' <' + M + '.' + m + '.' + (+p + 1);
	        else
	          ret = '>=' + M + '.' + m + '.' + p + pr +
	                ' <' + M + '.' + (+m + 1) + '.0';
	      } else
	        ret = '>=' + M + '.' + m + '.' + p + pr +
	              ' <' + (+M + 1) + '.0.0';
	    } else {
	      debug('no pr');
	      if (M === '0') {
	        if (m === '0')
	          ret = '>=' + M + '.' + m + '.' + p +
	                ' <' + M + '.' + m + '.' + (+p + 1);
	        else
	          ret = '>=' + M + '.' + m + '.' + p +
	                ' <' + M + '.' + (+m + 1) + '.0';
	      } else
	        ret = '>=' + M + '.' + m + '.' + p +
	              ' <' + (+M + 1) + '.0.0';
	    }
	
	    debug('caret return', ret);
	    return ret;
	  });
	}
	
	function replaceXRanges(comp, loose) {
	  debug('replaceXRanges', comp, loose);
	  return comp.split(/\s+/).map(function(comp) {
	    return replaceXRange(comp, loose);
	  }).join(' ');
	}
	
	function replaceXRange(comp, loose) {
	  comp = comp.trim();
	  var r = loose ? re[XRANGELOOSE] : re[XRANGE];
	  return comp.replace(r, function(ret, gtlt, M, m, p, pr) {
	    debug('xRange', comp, ret, gtlt, M, m, p, pr);
	    var xM = isX(M);
	    var xm = xM || isX(m);
	    var xp = xm || isX(p);
	    var anyX = xp;
	
	    if (gtlt === '=' && anyX)
	      gtlt = '';
	
	    if (xM) {
	      if (gtlt === '>' || gtlt === '<') {
	        // nothing is allowed
	        ret = '<0.0.0';
	      } else {
	        // nothing is forbidden
	        ret = '*';
	      }
	    } else if (gtlt && anyX) {
	      // replace X with 0
	      if (xm)
	        m = 0;
	      if (xp)
	        p = 0;
	
	      if (gtlt === '>') {
	        // >1 => >=2.0.0
	        // >1.2 => >=1.3.0
	        // >1.2.3 => >= 1.2.4
	        gtlt = '>=';
	        if (xm) {
	          M = +M + 1;
	          m = 0;
	          p = 0;
	        } else if (xp) {
	          m = +m + 1;
	          p = 0;
	        }
	      } else if (gtlt === '<=') {
	        // <=0.7.x is actually <0.8.0, since any 0.7.x should
	        // pass.  Similarly, <=7.x is actually <8.0.0, etc.
	        gtlt = '<';
	        if (xm)
	          M = +M + 1;
	        else
	          m = +m + 1;
	      }
	
	      ret = gtlt + M + '.' + m + '.' + p;
	    } else if (xm) {
	      ret = '>=' + M + '.0.0 <' + (+M + 1) + '.0.0';
	    } else if (xp) {
	      ret = '>=' + M + '.' + m + '.0 <' + M + '.' + (+m + 1) + '.0';
	    }
	
	    debug('xRange return', ret);
	
	    return ret;
	  });
	}
	
	// Because * is AND-ed with everything else in the comparator,
	// and '' means "any version", just remove the *s entirely.
	function replaceStars(comp, loose) {
	  debug('replaceStars', comp, loose);
	  // Looseness is ignored here.  star is always as loose as it gets!
	  return comp.trim().replace(re[STAR], '');
	}
	
	// This function is passed to string.replace(re[HYPHENRANGE])
	// M, m, patch, prerelease, build
	// 1.2 - 3.4.5 => >=1.2.0 <=3.4.5
	// 1.2.3 - 3.4 => >=1.2.0 <3.5.0 Any 3.4.x will do
	// 1.2 - 3.4 => >=1.2.0 <3.5.0
	function hyphenReplace($0,
	                       from, fM, fm, fp, fpr, fb,
	                       to, tM, tm, tp, tpr, tb) {
	
	  if (isX(fM))
	    from = '';
	  else if (isX(fm))
	    from = '>=' + fM + '.0.0';
	  else if (isX(fp))
	    from = '>=' + fM + '.' + fm + '.0';
	  else
	    from = '>=' + from;
	
	  if (isX(tM))
	    to = '';
	  else if (isX(tm))
	    to = '<' + (+tM + 1) + '.0.0';
	  else if (isX(tp))
	    to = '<' + tM + '.' + (+tm + 1) + '.0';
	  else if (tpr)
	    to = '<=' + tM + '.' + tm + '.' + tp + '-' + tpr;
	  else
	    to = '<=' + to;
	
	  return (from + ' ' + to).trim();
	}
	
	
	// if ANY of the sets match ALL of its comparators, then pass
	Range.prototype.test = function(version) {
	  if (!version)
	    return false;
	
	  if (typeof version === 'string')
	    version = new SemVer(version, this.loose);
	
	  for (var i = 0; i < this.set.length; i++) {
	    if (testSet(this.set[i], version))
	      return true;
	  }
	  return false;
	};
	
	function testSet(set, version) {
	  for (var i = 0; i < set.length; i++) {
	    if (!set[i].test(version))
	      return false;
	  }
	
	  if (version.prerelease.length) {
	    // Find the set of versions that are allowed to have prereleases
	    // For example, ^1.2.3-pr.1 desugars to >=1.2.3-pr.1 <2.0.0
	    // That should allow `1.2.3-pr.2` to pass.
	    // However, `1.2.4-alpha.notready` should NOT be allowed,
	    // even though it's within the range set by the comparators.
	    for (var i = 0; i < set.length; i++) {
	      debug(set[i].semver);
	      if (set[i].semver === ANY)
	        continue;
	
	      if (set[i].semver.prerelease.length > 0) {
	        var allowed = set[i].semver;
	        if (allowed.major === version.major &&
	            allowed.minor === version.minor &&
	            allowed.patch === version.patch)
	          return true;
	      }
	    }
	
	    // Version has a -pre, but it's not one of the ones we like.
	    return false;
	  }
	
	  return true;
	}
	
	exports.satisfies = satisfies;
	function satisfies(version, range, loose) {
	  try {
	    range = new Range(range, loose);
	  } catch (er) {
	    return false;
	  }
	  return range.test(version);
	}
	
	exports.maxSatisfying = maxSatisfying;
	function maxSatisfying(versions, range, loose) {
	  return versions.filter(function(version) {
	    return satisfies(version, range, loose);
	  }).sort(function(a, b) {
	    return rcompare(a, b, loose);
	  })[0] || null;
	}
	
	exports.minSatisfying = minSatisfying;
	function minSatisfying(versions, range, loose) {
	  return versions.filter(function(version) {
	    return satisfies(version, range, loose);
	  }).sort(function(a, b) {
	    return compare(a, b, loose);
	  })[0] || null;
	}
	
	exports.validRange = validRange;
	function validRange(range, loose) {
	  try {
	    // Return '*' instead of '' so that truthiness works.
	    // This will throw if it's invalid anyway
	    return new Range(range, loose).range || '*';
	  } catch (er) {
	    return null;
	  }
	}
	
	// Determine if version is less than all the versions possible in the range
	exports.ltr = ltr;
	function ltr(version, range, loose) {
	  return outside(version, range, '<', loose);
	}
	
	// Determine if version is greater than all the versions possible in the range.
	exports.gtr = gtr;
	function gtr(version, range, loose) {
	  return outside(version, range, '>', loose);
	}
	
	exports.outside = outside;
	function outside(version, range, hilo, loose) {
	  version = new SemVer(version, loose);
	  range = new Range(range, loose);
	
	  var gtfn, ltefn, ltfn, comp, ecomp;
	  switch (hilo) {
	    case '>':
	      gtfn = gt;
	      ltefn = lte;
	      ltfn = lt;
	      comp = '>';
	      ecomp = '>=';
	      break;
	    case '<':
	      gtfn = lt;
	      ltefn = gte;
	      ltfn = gt;
	      comp = '<';
	      ecomp = '<=';
	      break;
	    default:
	      throw new TypeError('Must provide a hilo val of "<" or ">"');
	  }
	
	  // If it satisifes the range it is not outside
	  if (satisfies(version, range, loose)) {
	    return false;
	  }
	
	  // From now on, variable terms are as if we're in "gtr" mode.
	  // but note that everything is flipped for the "ltr" function.
	
	  for (var i = 0; i < range.set.length; ++i) {
	    var comparators = range.set[i];
	
	    var high = null;
	    var low = null;
	
	    comparators.forEach(function(comparator) {
	      if (comparator.semver === ANY) {
	        comparator = new Comparator('>=0.0.0')
	      }
	      high = high || comparator;
	      low = low || comparator;
	      if (gtfn(comparator.semver, high.semver, loose)) {
	        high = comparator;
	      } else if (ltfn(comparator.semver, low.semver, loose)) {
	        low = comparator;
	      }
	    });
	
	    // If the edge version comparator has a operator then our version
	    // isn't outside it
	    if (high.operator === comp || high.operator === ecomp) {
	      return false;
	    }
	
	    // If the lowest version comparator has an operator and our version
	    // is less than it then it isn't higher than the range
	    if ((!low.operator || low.operator === comp) &&
	        ltefn(version, low.semver)) {
	      return false;
	    } else if (low.operator === ecomp && ltfn(version, low.semver)) {
	      return false;
	    }
	  }
	  return true;
	}
	
	exports.prerelease = prerelease;
	function prerelease(version, loose) {
	  var parsed = parse(version, loose);
	  return (parsed && parsed.prerelease.length) ? parsed.prerelease : null;
	}
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(5)))

/***/ }
/******/ ]);
//# sourceMappingURL=loader.bundle.js.map