/******/ (function(modules) { // webpackBootstrap
/******/ 	// install a JSONP callback for chunk loading
/******/ 	var parentJsonpFunction = window["webpackJsonp"];
/******/ 	window["webpackJsonp"] = function webpackJsonpCallback(chunkIds, moreModules) {
/******/ 		// add "moreModules" to the modules object,
/******/ 		// then flag all "chunkIds" as loaded and fire callback
/******/ 		var moduleId, chunkId, i = 0, callbacks = [];
/******/ 		for(;i < chunkIds.length; i++) {
/******/ 			chunkId = chunkIds[i];
/******/ 			if(installedChunks[chunkId])
/******/ 				callbacks.push.apply(callbacks, installedChunks[chunkId]);
/******/ 			installedChunks[chunkId] = 0;
/******/ 		}
/******/ 		for(moduleId in moreModules) {
/******/ 			modules[moduleId] = moreModules[moduleId];
/******/ 		}
/******/ 		if(parentJsonpFunction) parentJsonpFunction(chunkIds, moreModules);
/******/ 		while(callbacks.length)
/******/ 			callbacks.shift().call(null, __webpack_require__);
/******/
/******/ 	};
/******/
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// object to store loaded and loading chunks
/******/ 	// "0" means "already loaded"
/******/ 	// Array means "loading", array contains callbacks
/******/ 	var installedChunks = {
/******/ 		0:0
/******/ 	};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/ 	// This file contains only the entry chunk.
/******/ 	// The chunk loading function for additional chunks
/******/ 	__webpack_require__.e = function requireEnsure(chunkId, callback) {
/******/ 		// "0" is the signal for "already loaded"
/******/ 		if(installedChunks[chunkId] === 0)
/******/ 			return callback.call(null, __webpack_require__);
/******/
/******/ 		// an array means "currently loading".
/******/ 		if(installedChunks[chunkId] !== undefined) {
/******/ 			installedChunks[chunkId].push(callback);
/******/ 		} else {
/******/ 			// start chunk loading
/******/ 			installedChunks[chunkId] = [callback];
/******/ 			var head = document.getElementsByTagName('head')[0];
/******/ 			var script = document.createElement('script');
/******/ 			script.type = 'text/javascript';
/******/ 			script.charset = 'utf-8';
/******/ 			script.async = true;
/******/
/******/ 			script.src = __webpack_require__.p + "" + chunkId + ".bundle.js";
/******/ 			head.appendChild(script);
/******/ 		}
/******/ 	};
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "lab/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	
	var phosphide = __webpack_require__(1);
	
	// ES6 Promise polyfill
	__webpack_require__(66).polyfill();
	
	__webpack_require__(70);
	__webpack_require__(78);
	__webpack_require__(84);
	
	var app = new phosphide.Application({
	  extensions: [
	    __webpack_require__(122).aboutExtension,
	    __webpack_require__(123).faqExtension,
	    __webpack_require__(126).consoleExtension,
	    __webpack_require__(367).editorHandlerExtension,
	    __webpack_require__(399).fileBrowserExtension,
	    __webpack_require__(514).helpHandlerExtension,
	    __webpack_require__(516).imageHandlerExtension,
	    __webpack_require__(518).csvHandlerExtension,
	    __webpack_require__(521).mapHandlerExtension,
	    __webpack_require__(528).landingExtension,
	    __webpack_require__(529).mainExtension,
	    __webpack_require__(359).mainMenuExtension,
	    __webpack_require__(530).markdownHandlerExtension,
	    __webpack_require__(536).notebookHandlerExtension,
	    __webpack_require__(549).runningSessionsExtension,
	    __webpack_require__(551).shortcutsExtension,
	    __webpack_require__(552).terminalExtension,
	    __webpack_require__(555).widgetManagerExtension,
	    __webpack_require__(632).commandPaletteExtension,
	  ],
	  providers: [
	    __webpack_require__(633).clipboardProvider,
	    __webpack_require__(634).docRegistryProvider,
	    __webpack_require__(399).fileBrowserProvider,
	    __webpack_require__(536).notebookTrackerProvider,
	    __webpack_require__(359).mainMenuProvider,
	    __webpack_require__(635).renderMimeProvider,
	    __webpack_require__(636).servicesProvider,
	  ]
	});
	
	window.onload = function() {
	    app.run();
	}


/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var applicationshell_1 = __webpack_require__(2);
	var extensionregistry_1 = __webpack_require__(50);
	var serviceregistry_1 = __webpack_require__(51);
	var commandregistry_1 = __webpack_require__(52);
	var paletteregistry_1 = __webpack_require__(53);
	var shortcutregistry_1 = __webpack_require__(61);
	/**
	 * A class which provides the main Phosphide application logic.
	 *
	 * A phosphide application manages the registration of services and
	 * extensions, and provides the top-level application shell widget.
	 */
	var Application = (function () {
	    /**
	     * Construct a new application.
	     *
	     * @param options - The options for initializing the application.
	     */
	    function Application(options) {
	        this._started = false;
	        this._promise = null;
	        this._shell = null;
	        this._commands = null;
	        this._palette = null;
	        this._shortcuts = null;
	        this._services = new serviceregistry_1.ServiceRegistry();
	        this._extensions = new extensionregistry_1.ExtensionRegistry();
	        if (options)
	            Private.initFrom(this, options);
	    }
	    Object.defineProperty(Application.prototype, "shell", {
	        /**
	         * Get the application shell widget.
	         *
	         * #### Notes
	         * The shell widget is not a service, and can only be accessed as a
	         * property of the application. Since the application object is not
	         * passed to service providers, services do not have access to the
	         * shell. This is by design. The intent is to encourage authors to
	         * maintain a distinct separation between generic services and the
	         * application extensions which manipulates the UI.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._shell;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Application.prototype, "commands", {
	        /**
	         * Get the application command registry.
	         *
	         * #### Notes
	         * The command registry is a service, and is provided as a property
	         * for the convenience of application extension authors. A service
	         * provider may require the command registry as needed.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._commands;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Application.prototype, "palette", {
	        /**
	         * Get the application palette registry.
	         *
	         * #### Notes
	         * The palette registry is a service, and is provided as a property
	         * for the convenience of application extension authors. A service
	         * provider may require the palette registry as needed.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._palette;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Application.prototype, "shortcuts", {
	        /**
	         * Get the application shortcut registry.
	         *
	         * #### Notes
	         * The shortcut registry is a service, and is provided as a property
	         * for the convenience of application extension authors. A service
	         * provider may require the shortcut registry as needed.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._shortcuts;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Register a service provider with the application.
	     *
	     * @param provider - The service provider to register.
	     *
	     * #### Notes
	     * An error will be thrown if a provider with the same id is already
	     * registered, if a provider which provides the identical service is
	     * already registered, or if the provider has a circular dependency.
	     */
	    Application.prototype.registerProvider = function (provider) {
	        this._services.registerProvider(provider);
	    };
	    /**
	     * List the IDs of all service providers in the application.
	     *
	     * @returns A new array of all provider IDs in the application.
	     */
	    Application.prototype.listProviders = function () {
	        return this._services.listProviders();
	    };
	    /**
	     * Test whether the application has a registered service provider.
	     *
	     * @param id - The id of the provider of interest.
	     *
	     * @returns `true` if a service provider with the specified id is
	     *   registered, `false` otherwise.
	     */
	    Application.prototype.hasProvider = function (id) {
	        return this._services.hasProvider(id);
	    };
	    /**
	     * Test whether the application has a provider for a service type.
	     *
	     * @param kind - The type of the service of interest.
	     *
	     * @returns `true` if a service provider is registered for the
	     *   given service type, `false` otherwise.
	     */
	    Application.prototype.hasProviderFor = function (kind) {
	        return this._services.hasProviderFor(kind);
	    };
	    /**
	     * Resolve a service implementation for the given type.
	     *
	     * @param kind - The type of service object to resolve.
	     *
	     * @returns A promise which resolves the specified service type,
	     *   or rejects with an error if it cannot be satisfied.
	     *
	     * #### Notes
	     * Services are singletons. The same service instance will be
	     * returned each time a given service type is resolved.
	     *
	     * User code will not normally call this method directly. Instead
	     * the required services for the user's providers and extensions
	     * will be resolved automatically as needed.
	     */
	    Application.prototype.resolveService = function (kind) {
	        return this._services.resolveService(kind);
	    };
	    /**
	     * Register an extension with the application.
	     *
	     * @param extension - The application extension to register.
	     *
	     * #### Notes
	     * An error will be thrown if the extension id is already registered.
	     */
	    Application.prototype.registerExtension = function (extension) {
	        this._extensions.registerExtension(extension);
	    };
	    /**
	     * List the IDs of all extensions in the application.
	     *
	     * @returns A new array of all extension IDs in the application.
	     */
	    Application.prototype.listExtensions = function () {
	        return this._extensions.listExtensions();
	    };
	    /**
	     * Test whether the application has a registered extension.
	     *
	     * @param id - The id of the extension of interest.
	     *
	     * @returns `true` if an application extension with the specified
	     *   id is registered, `false` otherwise.
	     */
	    Application.prototype.hasExtension = function (id) {
	        return this._extensions.hasExtension(id);
	    };
	    /**
	     * Activate the application extension with the given id.
	     *
	     * @param id - The ID of the extension of interest.
	     *
	     * @returns A promise which resolves when the extension is fully
	     *   activated or rejects with an error if it cannot be activated.
	     */
	    Application.prototype.activateExtension = function (id) {
	        return this._extensions.activateExtension(id, this, this._services);
	    };
	    /**
	     * Run the bootstrapping process for the application.
	     *
	     * @param options - The options for bootstrapping the application.
	     *
	     * @returns A promise which resolves when all bootstrapping work
	     *   is complete and the shell is mounted to the DOM, or rejects
	     *   with an error if the bootstrapping process fails.
	     *
	     * #### Notes
	     * This should be called once by the application creator after all
	     * initial providers and extensions have been registered.
	     *
	     * Bootstrapping the application consists of the following steps:
	     * 1. Create the application shell
	     * 2. Register the default providers
	     * 3. Register the default extensions
	     * 4. Resolve the application services
	     * 5. Activate the initial extensions
	     * 6. Attach the shell widget to the DOM
	     * 7. Add the application event listeners
	     */
	    Application.prototype.run = function (options) {
	        var _this = this;
	        if (options === void 0) { options = {}; }
	        // Resolve immediately if the application is already started.
	        if (this._started) {
	            return Promise.resolve();
	        }
	        // Return the pending bootstrapping promise if it exists.
	        if (this._promise) {
	            return this._promise;
	        }
	        // Create the application shell.
	        this._shell = this.createApplicationShell();
	        // Register the default providers.
	        this.registerDefaultProviders();
	        // Register the default extensions.
	        this.registerDefaultExtensions();
	        // Resolve the application services.
	        var promises = [
	            this.resolveService(commandregistry_1.ABCCommandRegistry),
	            this.resolveService(paletteregistry_1.ABCPaletteRegistry),
	            this.resolveService(shortcutregistry_1.ABCShortcutRegistry)
	        ];
	        // Setup the promise for the rest of the bootstrapping.
	        this._promise = Promise.all(promises).then(function (results) {
	            // Store the resolved default services.
	            _this._commands = results[0];
	            _this._palette = results[1];
	            _this._shortcuts = results[2];
	            // Compute the extension ids to activate.
	            var extIDs;
	            var optVal = options.activateExtensions;
	            if (optVal === true) {
	                extIDs = _this.listExtensions();
	            }
	            else if (optVal === false) {
	                extIDs = [];
	            }
	            else if (optVal) {
	                extIDs = optVal;
	            }
	            else {
	                extIDs = _this.listExtensions();
	            }
	            // Activate the initial extensions.
	            return Promise.all(extIDs.map(function (id) { return _this.activateExtension(id); }));
	        }).then(function () {
	            // Mark the application as started and clear the stored promise.
	            _this._promise = null;
	            _this._started = true;
	            // Compute the id of the shell host node.
	            var shellHostID = options.shellHostID || '';
	            // Attach the application shell to the host node.
	            _this.attachApplicationShell(shellHostID);
	            // Add the application event listeners.
	            _this.addEventsListeners();
	        }).catch(function (error) {
	            // Clear the stored promise.
	            _this._promise = null;
	            // Rethrow the error to reject the promise.
	            throw error;
	        });
	        // Return the pending bootstrapping promise.
	        return this._promise;
	    };
	    /**
	     * Handle the DOM events for the application.
	     *
	     * @param event - The DOM event sent to the application.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events registered for the application. It
	     * should not be called directly by user code.
	     */
	    Application.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'resize':
	                this.evtResize(event);
	                break;
	            case 'keydown':
	                this.evtKeydown(event);
	                break;
	        }
	    };
	    /**
	     * Create the shell widget for the application.
	     *
	     * @returns An instance of an application shell.
	     *
	     * #### Notes
	     * A subclass may reimplement this this method for a custom shell.
	     */
	    Application.prototype.createApplicationShell = function () {
	        return new applicationshell_1.ApplicationShell();
	    };
	    /**
	     * Register the default service providers for the application.
	     *
	     * #### Notes
	     * The default implementation of this method registers default
	     * providers for the `ABCCommandRegistry`, `ABCPaletteRegistry`,
	     * and `ABCShortcutRegistry` services, unless providers for these
	     * services have already been registered.
	     *
	     * A subclass may reimplement this this method to register custom
	     * default providers, but it should ensure that providers for the
	     * default services are also registered.
	     */
	    Application.prototype.registerDefaultProviders = function () {
	        if (!this.hasProviderFor(commandregistry_1.ABCCommandRegistry)) {
	            this.registerProvider(commandregistry_1.commandRegistryProvider);
	        }
	        if (!this.hasProviderFor(shortcutregistry_1.ABCShortcutRegistry)) {
	            this.registerProvider(shortcutregistry_1.shortcutRegistryProvider);
	        }
	        if (!this.hasProviderFor(paletteregistry_1.ABCPaletteRegistry)) {
	            this.registerProvider(paletteregistry_1.paletteRegistryProvider);
	        }
	    };
	    /**
	     * Register the default extensions for the application.
	     *
	     * #### Notes
	     * The default implementation of this method is a no-op.
	     *
	     * A subclass may reimplement this method as needed.
	     */
	    Application.prototype.registerDefaultExtensions = function () { };
	    /**
	     * Attach the application shell to the DOM.
	     *
	     * @param id - The id of the host node for shell, or `''`.
	     *
	     * #### Notes
	     * If the id is not provided, the document body will be the host.
	     *
	     * A subclass may reimplement this method for custom attachment.
	     */
	    Application.prototype.attachApplicationShell = function (id) {
	        this._shell.attach(id ? document.getElementById(id) : document.body);
	    };
	    /**
	     * Add the application event listeners.
	     *
	     * #### Notes
	     * The default implementation of this method listens for `'resize'`
	     * and `'keydown'` events.
	     *
	     * A subclass may reimplement this method as needed.
	     */
	    Application.prototype.addEventsListeners = function () {
	        document.addEventListener('keydown', this);
	        window.addEventListener('resize', this);
	    };
	    /**
	     * A method invoked on a document `'resize'` event.
	     *
	     * #### Notes
	     * The default implementation of this method updates the shell.
	     *
	     * A subclass may reimplement this method as needed.
	     */
	    Application.prototype.evtResize = function (event) {
	        this._shell.update();
	    };
	    /**
	     * A method invoked on a document `'keydown'` event.
	     *
	     * #### Notes
	     * The default implementation of this method invokes the key-down
	     * processing method of the shortcut manager.
	     *
	     * A subclass may reimplement this method as needed.
	     */
	    Application.prototype.evtKeydown = function (event) {
	        this._shortcuts.processKeydownEvent(event);
	    };
	    return Application;
	}());
	exports.Application = Application;
	/**
	 * The namespace for the application private data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Initialize an application with the given options object.
	     */
	    function initFrom(app, options) {
	        var providers = options.providers || [];
	        var extensions = options.extensions || [];
	        providers.forEach(function (p) { app.registerProvider(p); });
	        extensions.forEach(function (e) { app.registerExtension(e); });
	    }
	    Private.initFrom = initFrom;
	})(Private || (Private = {}));


/***/ },
/* 2 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var arrays = __webpack_require__(3);
	var phosphor_boxpanel_1 = __webpack_require__(4);
	var phosphor_dockpanel_1 = __webpack_require__(30);
	var phosphor_panel_1 = __webpack_require__(18);
	var phosphor_splitpanel_1 = __webpack_require__(32);
	var phosphor_stackedpanel_1 = __webpack_require__(37);
	var phosphor_widget_1 = __webpack_require__(20);
	var sidebar_1 = __webpack_require__(47);
	/**
	 * The class name added to AppShell instances.
	 */
	var APPLICATION_SHELL_CLASS = 'p-ApplicationShell';
	/**
	 *
	 */
	var ApplicationShell = (function (_super) {
	    __extends(ApplicationShell, _super);
	    /**
	     * Construct a new application shell.
	     */
	    function ApplicationShell() {
	        _super.call(this);
	        this.addClass(APPLICATION_SHELL_CLASS);
	        var topPanel = new phosphor_panel_1.Panel();
	        var hboxPanel = new phosphor_boxpanel_1.BoxPanel();
	        var dockPanel = new phosphor_dockpanel_1.DockPanel();
	        var hsplitPanel = new phosphor_splitpanel_1.SplitPanel();
	        var leftHandler = new SideBarHandler('left');
	        var rightHandler = new SideBarHandler('right');
	        var rootLayout = new phosphor_boxpanel_1.BoxLayout();
	        this._topPanel = topPanel;
	        this._hboxPanel = hboxPanel;
	        this._dockPanel = dockPanel;
	        this._hsplitPanel = hsplitPanel;
	        this._leftHandler = leftHandler;
	        this._rightHandler = rightHandler;
	        // TODO fix these
	        topPanel.id = 'p-top-panel';
	        hsplitPanel.id = 'p-main-split-panel';
	        leftHandler.sideBar.addClass('p-mod-left');
	        rightHandler.sideBar.addClass('p-mod-right');
	        leftHandler.stackedPanel.id = 'p-left-stack';
	        rightHandler.stackedPanel.id = 'p-right-stack';
	        dockPanel.id = 'p-main-dock-panel';
	        dockPanel.spacing = 8; // TODO make this configurable?
	        hsplitPanel.orientation = phosphor_splitpanel_1.SplitPanel.Horizontal;
	        hsplitPanel.spacing = 1; // TODO make this configurable?
	        phosphor_splitpanel_1.SplitPanel.setStretch(leftHandler.stackedPanel, 0);
	        phosphor_splitpanel_1.SplitPanel.setStretch(dockPanel, 1);
	        phosphor_splitpanel_1.SplitPanel.setStretch(rightHandler.stackedPanel, 0);
	        hsplitPanel.addChild(leftHandler.stackedPanel);
	        hsplitPanel.addChild(dockPanel);
	        hsplitPanel.addChild(rightHandler.stackedPanel);
	        hboxPanel.direction = phosphor_boxpanel_1.BoxPanel.LeftToRight;
	        hboxPanel.spacing = 0; // TODO make this configurable?
	        phosphor_boxpanel_1.BoxPanel.setStretch(leftHandler.sideBar, 0);
	        phosphor_boxpanel_1.BoxPanel.setStretch(hsplitPanel, 1);
	        phosphor_boxpanel_1.BoxPanel.setStretch(rightHandler.sideBar, 0);
	        hboxPanel.addChild(leftHandler.sideBar);
	        hboxPanel.addChild(hsplitPanel);
	        hboxPanel.addChild(rightHandler.sideBar);
	        rootLayout.direction = phosphor_boxpanel_1.BoxLayout.TopToBottom;
	        rootLayout.spacing = 0; // TODO make this configurable?
	        phosphor_boxpanel_1.BoxLayout.setStretch(topPanel, 0);
	        phosphor_boxpanel_1.BoxLayout.setStretch(hboxPanel, 1);
	        rootLayout.addChild(topPanel);
	        rootLayout.addChild(hboxPanel);
	        this.layout = rootLayout;
	    }
	    /**
	     * Add a widget to the top content area.
	     */
	    ApplicationShell.prototype.addToTopArea = function (widget, options) {
	        if (options === void 0) { options = {}; }
	        if (!widget.id) {
	            console.error('widgets added to app shell must have unique id property');
	            return;
	        }
	        // Temporary: widgets are added to the panel in order of insertion.
	        this._topPanel.addChild(widget);
	    };
	    /**
	     * Add a widget to the left content area.
	     */
	    ApplicationShell.prototype.addToLeftArea = function (widget, options) {
	        if (options === void 0) { options = {}; }
	        if (!widget.id) {
	            console.error('widgets added to app shell must have unique id property');
	            return;
	        }
	        var rank = 'rank' in options ? options.rank : 100;
	        this._leftHandler.addWidget(widget, rank);
	    };
	    /**
	     * Add a widget to the right content area.
	     */
	    ApplicationShell.prototype.addToRightArea = function (widget, options) {
	        if (options === void 0) { options = {}; }
	        if (!widget.id) {
	            console.error('widgets added to app shell must have unique id property');
	            return;
	        }
	        var rank = 'rank' in options ? options.rank : 100;
	        this._rightHandler.addWidget(widget, rank);
	    };
	    /**
	     * Add a widget to the main content area.
	     */
	    ApplicationShell.prototype.addToMainArea = function (widget, options) {
	        if (options === void 0) { options = {}; }
	        // TODO
	        if (!widget.id) {
	            console.error('widgets added to app shell must have unique id property');
	            return;
	        }
	        this._dockPanel.insertTabAfter(widget);
	    };
	    /**
	     *
	     */
	    ApplicationShell.prototype.activateLeft = function (id) {
	        this._leftHandler.activate(id);
	    };
	    /**
	     *
	     */
	    ApplicationShell.prototype.activateRight = function (id) {
	        this._rightHandler.activate(id);
	    };
	    /**
	     *
	     */
	    ApplicationShell.prototype.activateMain = function (id) {
	        // TODO
	    };
	    /**
	     *
	     */
	    ApplicationShell.prototype.collapseLeft = function () {
	        this._leftHandler.collapse();
	    };
	    /**
	     *
	     */
	    ApplicationShell.prototype.collapseRight = function () {
	        this._rightHandler.collapse();
	    };
	    return ApplicationShell;
	}(phosphor_widget_1.Widget));
	exports.ApplicationShell = ApplicationShell;
	/**
	 * A class which manages a side bar and related stacked panel.
	 */
	var SideBarHandler = (function () {
	    /**
	     * Construct a new side bar handler.
	     */
	    function SideBarHandler(side) {
	        this._items = [];
	        this._side = side;
	        this._sideBar = new sidebar_1.SideBar();
	        this._stackedPanel = new phosphor_stackedpanel_1.StackedPanel();
	        this._sideBar.hide();
	        this._stackedPanel.hide();
	        this._sideBar.currentChanged.connect(this._onCurrentChanged, this);
	        this._stackedPanel.widgetRemoved.connect(this._onWidgetRemoved, this);
	    }
	    /**
	     * A less-than comparison function for side bar rank items.
	     */
	    SideBarHandler.itemCmp = function (first, second) {
	        return first.rank < second.rank;
	    };
	    Object.defineProperty(SideBarHandler.prototype, "sideBar", {
	        /**
	         * Get the side bar managed by the handler.
	         */
	        get: function () {
	            return this._sideBar;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SideBarHandler.prototype, "stackedPanel", {
	        /**
	         * Get the stacked panel managed by the handler
	         */
	        get: function () {
	            return this._stackedPanel;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Activate a widget residing in the side bar by ID.
	     *
	     * @param id - The widget's unique ID.
	     */
	    SideBarHandler.prototype.activate = function (id) {
	        var widget = this._findWidgetByID(id);
	        if (widget)
	            this._sideBar.currentTitle = widget.title;
	    };
	    /**
	     * Collapse the sidebar so no items are expanded.
	     */
	    SideBarHandler.prototype.collapse = function () {
	        this._sideBar.currentTitle = null;
	    };
	    /**
	     * Add a widget and its title to the stacked panel and side bar.
	     *
	     * If the widget is already added, it will be moved.
	     */
	    SideBarHandler.prototype.addWidget = function (widget, rank) {
	        widget.parent = null;
	        widget.hide();
	        var item = { widget: widget, rank: rank };
	        var index = this._findInsertIndex(item);
	        arrays.insert(this._items, index, item);
	        this._stackedPanel.insertChild(index, widget);
	        this._sideBar.insertTitle(index, widget.title);
	        this._refreshVisibility();
	    };
	    /**
	     * Find the insertion index for a rank item.
	     */
	    SideBarHandler.prototype._findInsertIndex = function (item) {
	        return arrays.upperBound(this._items, item, SideBarHandler.itemCmp);
	    };
	    /**
	     * Find the index of the item with the given widget, or `-1`.
	     */
	    SideBarHandler.prototype._findWidgetIndex = function (widget) {
	        return arrays.findIndex(this._items, function (item) { return item.widget === widget; });
	    };
	    /**
	     * Find the widget which owns the given title, or `null`.
	     */
	    SideBarHandler.prototype._findWidgetByTitle = function (title) {
	        var item = arrays.find(this._items, function (item) { return item.widget.title === title; });
	        return item ? item.widget : null;
	    };
	    /**
	     * Find the widget with the given id, or `null`.
	     */
	    SideBarHandler.prototype._findWidgetByID = function (id) {
	        var item = arrays.find(this._items, function (item) { return item.widget.id === id; });
	        return item ? item.widget : null;
	    };
	    /**
	     * Refresh the visibility of the side bar and stacked panel.
	     */
	    SideBarHandler.prototype._refreshVisibility = function () {
	        this._sideBar.setHidden(this._sideBar.titleCount() === 0);
	        this._stackedPanel.setHidden(this._sideBar.currentTitle === null);
	    };
	    /**
	     * Handle the `currentChanged` signal from the sidebar.
	     */
	    SideBarHandler.prototype._onCurrentChanged = function (sender, args) {
	        var oldWidget = this._findWidgetByTitle(args.oldValue);
	        var newWidget = this._findWidgetByTitle(args.newValue);
	        if (oldWidget)
	            oldWidget.hide();
	        if (newWidget)
	            newWidget.show();
	        if (newWidget) {
	            document.body.dataset[(this._side + "Area")] = newWidget.id;
	        }
	        else {
	            delete document.body.dataset[(this._side + "Area")];
	        }
	        this._refreshVisibility();
	    };
	    /*
	     * Handle the `widgetRemoved` signal from the stacked panel.
	     */
	    SideBarHandler.prototype._onWidgetRemoved = function (sender, widget) {
	        arrays.removeAt(this._items, this._findWidgetIndex(widget));
	        this._sideBar.removeTitle(widget.title);
	        this._refreshVisibility();
	    };
	    return SideBarHandler;
	}());


/***/ },
/* 3 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	/**
	 * Execute a callback for each element in an array.
	 *
	 * @param array - The array of values to iterate.
	 *
	 * @param callback - The callback to invoke for the array elements.
	 *
	 * @param fromIndex - The starting index for iteration.
	 *
	 * @param wrap - Whether iteration wraps around at the end of the array.
	 *
	 * @returns The first value returned by `callback` which is not
	 *   equal to `undefined`, or `undefined` if the callback does
	 *   not return a value or if the start index is out of range.
	 *
	 * #### Notes
	 * It is not safe to modify the size of the array while iterating.
	 *
	 * #### Example
	 * ```typescript
	 * import * as arrays from 'phosphor-arrays';
	 *
	 * function logger(value: number): void {
	 *   console.log(value);
	 * }
	 *
	 * let data = [1, 2, 3, 4];
	 * arrays.forEach(data, logger);           // logs 1, 2, 3, 4
	 * arrays.forEach(data, logger, 2);        // logs 3, 4
	 * arrays.forEach(data, logger, 2, true);  // logs 3, 4, 1, 2
	 * arrays.forEach(data, (v, i) => {        // 2
	 *   if (v === 3) return i;
	 * });
	 * ```
	 *
	 * **See also** [[rforEach]]
	 */
	function forEach(array, callback, fromIndex, wrap) {
	    if (fromIndex === void 0) { fromIndex = 0; }
	    if (wrap === void 0) { wrap = false; }
	    var start = fromIndex | 0;
	    if (start < 0 || start >= array.length) {
	        return void 0;
	    }
	    if (wrap) {
	        for (var i = 0, n = array.length; i < n; ++i) {
	            var j = (start + i) % n;
	            var result = callback(array[j], j);
	            if (result !== void 0)
	                return result;
	        }
	    }
	    else {
	        for (var i = start, n = array.length; i < n; ++i) {
	            var result = callback(array[i], i);
	            if (result !== void 0)
	                return result;
	        }
	    }
	    return void 0;
	}
	exports.forEach = forEach;
	/**
	 * Execute a callback for each element in an array, in reverse.
	 *
	 * @param array - The array of values to iterate.
	 *
	 * @param callback - The callback to invoke for the array elements.
	 *
	 * @param fromIndex - The starting index for iteration.
	 *
	 * @param wrap - Whether iteration wraps around at the end of the array.
	 *
	 * @returns The first value returned by `callback` which is not
	 *   equal to `undefined`, or `undefined` if the callback does
	 *   not return a value or if the start index is out of range.
	 *
	 * #### Notes
	 * It is not safe to modify the size of the array while iterating.
	 *
	 * #### Example
	 * ```typescript
	 * import * as arrays from 'phosphor-arrays';
	 *
	 * function logger(value: number): void {
	 *   console.log(value);
	 * }
	 *
	 * let data = [1, 2, 3, 4];
	 * arrays.rforEach(data, logger);           // logs 4, 3, 2, 1
	 * arrays.rforEach(data, logger, 2);        // logs 3, 2, 1
	 * arrays.rforEach(data, logger, 2, true);  // logs 3, 2, 1, 4
	 * arrays.rforEach(data, (v, i) => {        // 2
	 *   if (v === 3) return i;
	 * });
	 * ```
	 * **See also** [[forEach]]
	 */
	function rforEach(array, callback, fromIndex, wrap) {
	    if (fromIndex === void 0) { fromIndex = array.length - 1; }
	    if (wrap === void 0) { wrap = false; }
	    var start = fromIndex | 0;
	    if (start < 0 || start >= array.length) {
	        return void 0;
	    }
	    if (wrap) {
	        for (var i = 0, n = array.length; i < n; ++i) {
	            var j = (start - i + n) % n;
	            var result = callback(array[j], j);
	            if (result !== void 0)
	                return result;
	        }
	    }
	    else {
	        for (var i = start; i >= 0; --i) {
	            var result = callback(array[i], i);
	            if (result !== void 0)
	                return result;
	        }
	    }
	    return void 0;
	}
	exports.rforEach = rforEach;
	/**
	 * Find the index of the first value which matches a predicate.
	 *
	 * @param array - The array of values to be searched.
	 *
	 * @param pred - The predicate function to apply to the values.
	 *
	 * @param fromIndex - The starting index of the search.
	 *
	 * @param wrap - Whether the search wraps around at the end of the array.
	 *
	 * @returns The index of the first matching value, or `-1` if no value
	 *   matches the predicate or if the start index is out of range.
	 *
	 * #### Notes
	 * It is not safe to modify the size of the array while iterating.
	 *
	 * #### Example
	 * ```typescript
	 * import * as arrays from 'phosphor-arrays';
	 *
	 * function isEven(value: number): boolean {
	 *   return value % 2 === 0;
	 * }
	 *
	 * let data = [1, 2, 3, 4, 3, 2, 1];
	 * arrays.findIndex(data, isEven);           // 1
	 * arrays.findIndex(data, isEven, 4);        // 5
	 * arrays.findIndex(data, isEven, 6);        // -1
	 * arrays.findIndex(data, isEven, 6, true);  // 1
	 * ```
	 *
	 * **See also** [[rfindIndex]].
	 */
	function findIndex(array, pred, fromIndex, wrap) {
	    if (fromIndex === void 0) { fromIndex = 0; }
	    if (wrap === void 0) { wrap = false; }
	    var start = fromIndex | 0;
	    if (start < 0 || start >= array.length) {
	        return -1;
	    }
	    if (wrap) {
	        for (var i = 0, n = array.length; i < n; ++i) {
	            var j = (start + i) % n;
	            if (pred(array[j], j))
	                return j;
	        }
	    }
	    else {
	        for (var i = start, n = array.length; i < n; ++i) {
	            if (pred(array[i], i))
	                return i;
	        }
	    }
	    return -1;
	}
	exports.findIndex = findIndex;
	/**
	 * Find the index of the last value which matches a predicate.
	 *
	 * @param array - The array of values to be searched.
	 *
	 * @param pred - The predicate function to apply to the values.
	 *
	 * @param fromIndex - The starting index of the search.
	 *
	 * @param wrap - Whether the search wraps around at the front of the array.
	 *
	 * @returns The index of the last matching value, or `-1` if no value
	 *   matches the predicate or if the start index is out of range.
	 *
	 * #### Notes
	 * It is not safe to modify the size of the array while iterating.
	 *
	 * #### Example
	 * ```typescript
	 * import * as arrays from 'phosphor-arrays';
	 *
	 * function isEven(value: number): boolean {
	 *   return value % 2 === 0;
	 * }
	 *
	 * let data = [1, 2, 3, 4, 3, 2, 1];
	 * arrays.rfindIndex(data, isEven);           // 5
	 * arrays.rfindIndex(data, isEven, 4);        // 3
	 * arrays.rfindIndex(data, isEven, 0);        // -1
	 * arrays.rfindIndex(data, isEven, 0, true);  // 5
	 * ```
	 *
	 * **See also** [[findIndex]].
	 */
	function rfindIndex(array, pred, fromIndex, wrap) {
	    if (fromIndex === void 0) { fromIndex = array.length - 1; }
	    if (wrap === void 0) { wrap = false; }
	    var start = fromIndex | 0;
	    if (start < 0 || start >= array.length) {
	        return -1;
	    }
	    if (wrap) {
	        for (var i = 0, n = array.length; i < n; ++i) {
	            var j = (start - i + n) % n;
	            if (pred(array[j], j))
	                return j;
	        }
	    }
	    else {
	        for (var i = start; i >= 0; --i) {
	            if (pred(array[i], i))
	                return i;
	        }
	    }
	    return -1;
	}
	exports.rfindIndex = rfindIndex;
	/**
	 * Find the first value which matches a predicate.
	 *
	 * @param array - The array of values to be searched.
	 *
	 * @param pred - The predicate function to apply to the values.
	 *
	 * @param fromIndex - The starting index of the search.
	 *
	 * @param wrap - Whether the search wraps around at the end of the array.
	 *
	 * @returns The first matching value, or `undefined` if no value matches
	 *   the predicate or if the start index is out of range.
	 *
	 * #### Notes
	 * It is not safe to modify the size of the array while iterating.
	 *
	 * #### Example
	 * ```typescript
	 * import * as arrays from 'phosphor-arrays';
	 *
	 * function isEven(value: number): boolean {
	 *   return value % 2 === 0;
	 * }
	 *
	 * let data = [1, 2, 3, 4, 3, 2, 1];
	 * arrays.find(data, isEven);           // 2
	 * arrays.find(data, isEven, 4);        // 2
	 * arrays.find(data, isEven, 6);        // undefined
	 * arrays.find(data, isEven, 6, true);  // 2
	 * ```
	 *
	 * **See also** [[rfind]].
	 */
	function find(array, pred, fromIndex, wrap) {
	    var i = findIndex(array, pred, fromIndex, wrap);
	    return i !== -1 ? array[i] : void 0;
	}
	exports.find = find;
	/**
	 * Find the last value which matches a predicate.
	 *
	 * @param array - The array of values to be searched.
	 *
	 * @param pred - The predicate function to apply to the values.
	 *
	 * @param fromIndex - The starting index of the search.
	 *
	 * @param wrap - Whether the search wraps around at the front of the array.
	 *
	 * @returns The last matching value, or `undefined` if no value matches
	 *   the predicate or if the start index is out of range.
	 *
	 * #### Notes
	 * The range of visited indices is set before the first invocation of
	 * `pred`. It is not safe for `pred` to change the length of `array`.
	 *
	 * #### Example
	 * ```typescript
	 * import * as arrays from 'phosphor-arrays';
	 *
	 * function isEven(value: number): boolean {
	 *   return value % 2 === 0;
	 * }
	 *
	 * let data = [1, 2, 3, 4, 3, 2, 1];
	 * arrays.rfind(data, isEven);           // 2
	 * arrays.rfind(data, isEven, 4);        // 4
	 * arrays.rfind(data, isEven, 0);        // undefined
	 * arrays.rfind(data, isEven, 0, true);  // 2
	 * ```
	 *
	 * **See also** [[find]].
	 */
	function rfind(array, pred, fromIndex, wrap) {
	    var i = rfindIndex(array, pred, fromIndex, wrap);
	    return i !== -1 ? array[i] : void 0;
	}
	exports.rfind = rfind;
	/**
	 * Insert an element into an array at a specified index.
	 *
	 * @param array - The array of values to modify.
	 *
	 * @param index - The index at which to insert the value. This value
	 *   is clamped to the bounds of the array.
	 *
	 * @param value - The value to insert into the array.
	 *
	 * @returns The index at which the value was inserted.
	 *
	 * #### Example
	 * ```typescript
	 * import * as arrays from 'phosphor-arrays';
	 *
	 * let data = [0, 1, 2, 3, 4];
	 * arrays.insert(data, 0, 12);  // 0
	 * arrays.insert(data, 3, 42);  // 3
	 * arrays.insert(data, -9, 9);  // 0
	 * arrays.insert(data, 12, 8);  // 8
	 * console.log(data);           // [9, 12, 0, 1, 42, 2, 3, 4, 8]
	 * ```
	 *
	 * **See also** [[removeAt]] and [[remove]]
	 */
	function insert(array, index, value) {
	    var j = Math.max(0, Math.min(index | 0, array.length));
	    for (var i = array.length; i > j; --i) {
	        array[i] = array[i - 1];
	    }
	    array[j] = value;
	    return j;
	}
	exports.insert = insert;
	/**
	 * Move an element in an array from one index to another.
	 *
	 * @param array - The array of values to modify.
	 *
	 * @param fromIndex - The index of the element to move.
	 *
	 * @param toIndex - The target index of the element.
	 *
	 * @returns `true` if the element was moved, or `false` if either
	 *   index is out of range.
	 *
	 * #### Example
	 * ```typescript
	 * import * as arrays from 'phosphor-arrays';
	 *
	 * let data = [0, 1, 2, 3, 4];
	 * arrays.move(data, 1, 2);   // true
	 * arrays.move(data, -1, 0);  // false
	 * arrays.move(data, 4, 2);   // true
	 * arrays.move(data, 10, 0);  // false
	 * console.log(data);         // [0, 2, 4, 1, 3]
	 * ```
	 */
	function move(array, fromIndex, toIndex) {
	    var j = fromIndex | 0;
	    if (j < 0 || j >= array.length) {
	        return false;
	    }
	    var k = toIndex | 0;
	    if (k < 0 || k >= array.length) {
	        return false;
	    }
	    var value = array[j];
	    if (j > k) {
	        for (var i = j; i > k; --i) {
	            array[i] = array[i - 1];
	        }
	    }
	    else if (j < k) {
	        for (var i = j; i < k; ++i) {
	            array[i] = array[i + 1];
	        }
	    }
	    array[k] = value;
	    return true;
	}
	exports.move = move;
	/**
	 * Remove an element from an array at a specified index.
	 *
	 * @param array - The array of values to modify.
	 *
	 * @param index - The index of the element to remove.
	 *
	 * @returns The removed value, or `undefined` if the index is out
	 *   of range.
	 *
	 * #### Example
	 * ```typescript
	 * import * as arrays from 'phosphor-arrays';
	 *
	 * let data = [0, 1, 2, 3, 4];
	 * arrays.removeAt(data, 1);   // 1
	 * arrays.removeAt(data, 3);   // 4
	 * arrays.removeAt(data, 10);  // undefined
	 * console.log(data);          // [0, 2, 3]
	 * ```
	 *
	 * **See also** [[remove]] and [[insert]]
	 */
	function removeAt(array, index) {
	    var j = index | 0;
	    if (j < 0 || j >= array.length) {
	        return void 0;
	    }
	    var value = array[j];
	    for (var i = j + 1, n = array.length; i < n; ++i) {
	        array[i - 1] = array[i];
	    }
	    array.length -= 1;
	    return value;
	}
	exports.removeAt = removeAt;
	/**
	 * Remove the first occurrence of a value from an array.
	 *
	 * @param array - The array of values to modify.
	 *
	 * @param value - The value to remove from the array.
	 *
	 * @returns The index where the value was located, or `-1` if the
	 *   value is not the array.
	 *
	 * #### Example
	 * ```typescript
	 * import * as arrays from 'phosphor-arrays';
	 *
	 * let data = [0, 1, 2, 3, 4];
	 * arrays.remove(data, 1);  // 1
	 * arrays.remove(data, 3);  // 2
	 * arrays.remove(data, 7);  // -1
	 * console.log(data);       // [0, 2, 4]
	 * ```
	 *
	 * **See also** [[removeAt]] and [[insert]]
	 */
	function remove(array, value) {
	    var j = -1;
	    for (var i = 0, n = array.length; i < n; ++i) {
	        if (array[i] === value) {
	            j = i;
	            break;
	        }
	    }
	    if (j === -1) {
	        return -1;
	    }
	    for (var i = j + 1, n = array.length; i < n; ++i) {
	        array[i - 1] = array[i];
	    }
	    array.length -= 1;
	    return j;
	}
	exports.remove = remove;
	/**
	 * Reverse an array in-place subject to an optional range.
	 *
	 * @param array - The array to reverse.
	 *
	 * @param fromIndex - The index of the first element of the range.
	 *   This value will be clamped to the array bounds.
	 *
	 * @param toIndex - The index of the last element of the range.
	 *   This value will be clamped to the array bounds.
	 *
	 * @returns A reference to the original array.
	 *
	 * #### Example
	 * ```typescript
	 * import * as arrays from 'phosphor-arrays';
	 *
	 * let data = [0, 1, 2, 3, 4];
	 * arrays.reverse(data, 1, 3);    // [0, 3, 2, 1, 4]
	 * arrays.reverse(data, 3);       // [0, 3, 2, 4, 1]
	 * arrays.reverse(data);          // [1, 4, 2, 3, 0]
	 * ```
	 *
	 * **See also** [[rotate]]
	 */
	function reverse(array, fromIndex, toIndex) {
	    if (fromIndex === void 0) { fromIndex = 0; }
	    if (toIndex === void 0) { toIndex = array.length; }
	    var i = Math.max(0, Math.min(fromIndex | 0, array.length - 1));
	    var j = Math.max(0, Math.min(toIndex | 0, array.length - 1));
	    if (j < i)
	        i = j + (j = i, 0);
	    while (i < j) {
	        var tmpval = array[i];
	        array[i++] = array[j];
	        array[j--] = tmpval;
	    }
	    return array;
	}
	exports.reverse = reverse;
	/**
	 * Rotate the elements of an array by a positive or negative delta.
	 *
	 * @param array - The array to rotate.
	 *
	 * @param delta - The amount of rotation to apply to the elements. A
	 *   positive delta will shift the elements to the left. A negative
	 *   delta will shift the elements to the right.
	 *
	 * @returns A reference to the original array.
	 *
	 * #### Notes
	 * This executes in `O(n)` time and `O(1)` space.
	 *
	 * #### Example
	 * ```typescript
	 * import * as arrays from 'phosphor-arrays';
	 *
	 * let data = [0, 1, 2, 3, 4];
	 * arrays.rotate(data, 2);    // [2, 3, 4, 0, 1]
	 * arrays.rotate(data, -2);   // [0, 1, 2, 3, 4]
	 * arrays.rotate(data, 10);   // [0, 1, 2, 3, 4]
	 * arrays.rotate(data, 9);    // [4, 0, 1, 2, 3]
	 * ```
	 *
	 * **See also** [[reverse]]
	 */
	function rotate(array, delta) {
	    var n = array.length;
	    if (n <= 1) {
	        return array;
	    }
	    var d = delta | 0;
	    if (d > 0) {
	        d = d % n;
	    }
	    else if (d < 0) {
	        d = ((d % n) + n) % n;
	    }
	    if (d === 0) {
	        return array;
	    }
	    reverse(array, 0, d - 1);
	    reverse(array, d, n - 1);
	    reverse(array, 0, n - 1);
	    return array;
	}
	exports.rotate = rotate;
	/**
	 * Using a binary search, find the index of the first element in an
	 * array which compares `>=` to a value.
	 *
	 * @param array - The array of values to be searched. It must be sorted
	 *   in ascending order.
	 *
	 * @param value - The value to locate in the array.
	 *
	 * @param cmp - The comparison function which returns `true` if an
	 *   array element is less than the given value.
	 *
	 * @returns The index of the first element in `array` which compares
	 *   `>=` to `value`, or `array.length` if there is no such element.
	 *
	 * #### Notes
	 * It is not safe for the comparison function to modify the array.
	 *
	 * #### Example
	 * ```typescript
	 * import * as arrays from 'phosphor-arrays';
	 *
	 * function numberCmp(a: number, b: number): boolean {
	 *   return a < b;
	 * }
	 *
	 * let data = [0, 3, 4, 7, 7, 9];
	 * arrays.lowerBound(data, 0, numberCmp);   // 0
	 * arrays.lowerBound(data, 6, numberCmp);   // 3
	 * arrays.lowerBound(data, 7, numberCmp);   // 3
	 * arrays.lowerBound(data, -1, numberCmp);  // 0
	 * arrays.lowerBound(data, 10, numberCmp);  // 6
	 * ```
	 *
	 * **See also** [[upperBound]]
	 */
	function lowerBound(array, value, cmp) {
	    var begin = 0;
	    var half;
	    var middle;
	    var n = array.length;
	    while (n > 0) {
	        half = n >> 1;
	        middle = begin + half;
	        if (cmp(array[middle], value)) {
	            begin = middle + 1;
	            n -= half + 1;
	        }
	        else {
	            n = half;
	        }
	    }
	    return begin;
	}
	exports.lowerBound = lowerBound;
	/**
	 * Using a binary search, find the index of the first element in an
	 * array which compares `>` than a value.
	 *
	 * @param array - The array of values to be searched. It must be sorted
	 *   in ascending order.
	 *
	 * @param value - The value to locate in the array.
	 *
	 * @param cmp - The comparison function which returns `true` if the
	 *   the given value is less than an array element.
	 *
	 * @returns The index of the first element in `array` which compares
	 *   `>` than `value`, or `array.length` if there is no such element.
	 *
	 * #### Notes
	 * It is not safe for the comparison function to modify the array.
	 *
	 * #### Example
	 * ```typescript
	 * import * as arrays from 'phosphor-arrays';
	 *
	 * function numberCmp(a: number, b: number): number {
	 *   return a < b;
	 * }
	 *
	 * let data = [0, 3, 4, 7, 7, 9];
	 * arrays.upperBound(data, 0, numberCmp);   // 1
	 * arrays.upperBound(data, 6, numberCmp);   // 3
	 * arrays.upperBound(data, 7, numberCmp);   // 5
	 * arrays.upperBound(data, -1, numberCmp);  // 0
	 * arrays.upperBound(data, 10, numberCmp);  // 6
	 * ```
	 *
	 * **See also** [[lowerBound]]
	 */
	function upperBound(array, value, cmp) {
	    var begin = 0;
	    var half;
	    var middle;
	    var n = array.length;
	    while (n > 0) {
	        half = n >> 1;
	        middle = begin + half;
	        if (cmp(value, array[middle])) {
	            n = half;
	        }
	        else {
	            begin = middle + 1;
	            n -= half + 1;
	        }
	    }
	    return begin;
	}
	exports.upperBound = upperBound;
	//# sourceMappingURL=index.js.map

/***/ },
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(5));
	__export(__webpack_require__(29));


/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var arrays = __webpack_require__(3);
	var phosphor_boxengine_1 = __webpack_require__(6);
	var phosphor_domutil_1 = __webpack_require__(7);
	var phosphor_messaging_1 = __webpack_require__(13);
	var phosphor_properties_1 = __webpack_require__(17);
	var phosphor_panel_1 = __webpack_require__(18);
	var phosphor_widget_1 = __webpack_require__(20);
	/**
	 * The class name added to left-to-right box layout parents.
	 */
	var LEFT_TO_RIGHT_CLASS = 'p-mod-left-to-right';
	/**
	 * The class name added to right-to-left box layout parents.
	 */
	var RIGHT_TO_LEFT_CLASS = 'p-mod-right-to-left';
	/**
	 * The class name added to top-to-bottom box layout parents.
	 */
	var TOP_TO_BOTTOM_CLASS = 'p-mod-top-to-bottom';
	/**
	 * The class name added to bottom-to-top box layout parents.
	 */
	var BOTTOM_TO_TOP_CLASS = 'p-mod-bottom-to-top';
	/**
	 * The layout direction of a box layout.
	 */
	(function (Direction) {
	    /**
	     * Left to right direction.
	     */
	    Direction[Direction["LeftToRight"] = 0] = "LeftToRight";
	    /**
	     * Right to left direction.
	     */
	    Direction[Direction["RightToLeft"] = 1] = "RightToLeft";
	    /**
	     * Top to bottom direction.
	     */
	    Direction[Direction["TopToBottom"] = 2] = "TopToBottom";
	    /**
	     * Bottom to top direction.
	     */
	    Direction[Direction["BottomToTop"] = 3] = "BottomToTop";
	})(exports.Direction || (exports.Direction = {}));
	var Direction = exports.Direction;
	/**
	 * A layout which arranges its children in a single row or column.
	 */
	var BoxLayout = (function (_super) {
	    __extends(BoxLayout, _super);
	    function BoxLayout() {
	        _super.apply(this, arguments);
	        this._fixed = 0;
	        this._spacing = 8;
	        this._box = null;
	        this._sizers = [];
	        this._direction = Direction.TopToBottom;
	    }
	    Object.defineProperty(BoxLayout.prototype, "direction", {
	        /**
	         * Get the layout direction for the box layout.
	         */
	        get: function () {
	            return this._direction;
	        },
	        /**
	         * Set the layout direction for the box layout.
	         */
	        set: function (value) {
	            if (this._direction === value) {
	                return;
	            }
	            this._direction = value;
	            if (!this.parent) {
	                return;
	            }
	            BoxLayoutPrivate.toggleDirection(this.parent, value);
	            this.parent.fit();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(BoxLayout.prototype, "spacing", {
	        /**
	         * Get the inter-element spacing for the box layout.
	         */
	        get: function () {
	            return this._spacing;
	        },
	        /**
	         * Set the inter-element spacing for the box layout.
	         */
	        set: function (value) {
	            value = Math.max(0, value | 0);
	            if (this._spacing === value) {
	                return;
	            }
	            this._spacing = value;
	            if (!this.parent) {
	                return;
	            }
	            this.parent.fit();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Initialize the children of the layout.
	     *
	     * #### Notes
	     * This method is called automatically when the layout is installed
	     * on its parent widget.
	     */
	    BoxLayout.prototype.initialize = function () {
	        BoxLayoutPrivate.toggleDirection(this.parent, this.direction);
	        _super.prototype.initialize.call(this);
	    };
	    /**
	     * Attach a child widget to the parent's DOM node.
	     *
	     * @param index - The current index of the child in the layout.
	     *
	     * @param child - The child widget to attach to the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    BoxLayout.prototype.attachChild = function (index, child) {
	        arrays.insert(this._sizers, index, new phosphor_boxengine_1.BoxSizer());
	        BoxLayoutPrivate.prepareGeometry(child);
	        this.parent.node.appendChild(child.node);
	        if (this.parent.isAttached)
	            phosphor_messaging_1.sendMessage(child, phosphor_widget_1.Widget.MsgAfterAttach);
	        this.parent.fit();
	    };
	    /**
	     * Move a child widget in the parent's DOM node.
	     *
	     * @param fromIndex - The previous index of the child in the layout.
	     *
	     * @param toIndex - The current index of the child in the layout.
	     *
	     * @param child - The child widget to move in the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    BoxLayout.prototype.moveChild = function (fromIndex, toIndex, child) {
	        arrays.move(this._sizers, fromIndex, toIndex);
	        this.parent.update();
	    };
	    /**
	     * Detach a child widget from the parent's DOM node.
	     *
	     * @param index - The previous index of the child in the layout.
	     *
	     * @param child - The child widget to detach from the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    BoxLayout.prototype.detachChild = function (index, child) {
	        arrays.removeAt(this._sizers, index);
	        if (this.parent.isAttached)
	            phosphor_messaging_1.sendMessage(child, phosphor_widget_1.Widget.MsgBeforeDetach);
	        this.parent.node.removeChild(child.node);
	        BoxLayoutPrivate.resetGeometry(child);
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     */
	    BoxLayout.prototype.onAfterShow = function (msg) {
	        _super.prototype.onAfterShow.call(this, msg);
	        this.parent.update();
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    BoxLayout.prototype.onAfterAttach = function (msg) {
	        _super.prototype.onAfterAttach.call(this, msg);
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on a `'child-shown'` message.
	     */
	    BoxLayout.prototype.onChildShown = function (msg) {
	        if (BoxLayoutPrivate.IsIE) {
	            phosphor_messaging_1.sendMessage(this.parent, phosphor_widget_1.Widget.MsgFitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'child-hidden'` message.
	     */
	    BoxLayout.prototype.onChildHidden = function (msg) {
	        if (BoxLayoutPrivate.IsIE) {
	            phosphor_messaging_1.sendMessage(this.parent, phosphor_widget_1.Widget.MsgFitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     */
	    BoxLayout.prototype.onResize = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(msg.width, msg.height);
	        }
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    BoxLayout.prototype.onUpdateRequest = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(-1, -1);
	        }
	    };
	    /**
	     * A message handler invoked on a `'fit-request'` message.
	     */
	    BoxLayout.prototype.onFitRequest = function (msg) {
	        if (this.parent.isAttached) {
	            this._fit();
	        }
	    };
	    /**
	     * Fit the layout to the total size required by the child widgets.
	     */
	    BoxLayout.prototype._fit = function () {
	        // Compute the visible item count.
	        var nVisible = 0;
	        for (var i = 0, n = this.childCount(); i < n; ++i) {
	            if (!this.childAt(i).isHidden)
	                nVisible++;
	        }
	        // Update the fixed space for the visible items.
	        this._fixed = this._spacing * Math.max(0, nVisible - 1);
	        // Setup the initial size limits.
	        var minW = 0;
	        var minH = 0;
	        var maxW = Infinity;
	        var maxH = Infinity;
	        var horz = BoxLayoutPrivate.isHorizontal(this._direction);
	        if (horz) {
	            minW = this._fixed;
	            maxW = nVisible > 0 ? minW : maxW;
	        }
	        else {
	            minH = this._fixed;
	            maxH = nVisible > 0 ? minH : maxH;
	        }
	        // Update the sizers and computed size limits.
	        for (var i = 0, n = this.childCount(); i < n; ++i) {
	            var child = this.childAt(i);
	            var sizer = this._sizers[i];
	            if (child.isHidden) {
	                sizer.minSize = 0;
	                sizer.maxSize = 0;
	                continue;
	            }
	            var limits = phosphor_domutil_1.sizeLimits(child.node);
	            sizer.sizeHint = BoxLayout.getSizeBasis(child);
	            sizer.stretch = BoxLayout.getStretch(child);
	            if (horz) {
	                sizer.minSize = limits.minWidth;
	                sizer.maxSize = limits.maxWidth;
	                minW += limits.minWidth;
	                maxW += limits.maxWidth;
	                minH = Math.max(minH, limits.minHeight);
	                maxH = Math.min(maxH, limits.maxHeight);
	            }
	            else {
	                sizer.minSize = limits.minHeight;
	                sizer.maxSize = limits.maxHeight;
	                minH += limits.minHeight;
	                maxH += limits.maxHeight;
	                minW = Math.max(minW, limits.minWidth);
	                maxW = Math.min(maxW, limits.maxWidth);
	            }
	        }
	        // Update the box sizing and add it to the size constraints.
	        var box = this._box = phosphor_domutil_1.boxSizing(this.parent.node);
	        minW += box.horizontalSum;
	        minH += box.verticalSum;
	        maxW += box.horizontalSum;
	        maxH += box.verticalSum;
	        // Update the parent's size constraints.
	        var style = this.parent.node.style;
	        style.minWidth = minW + "px";
	        style.minHeight = minH + "px";
	        style.maxWidth = maxW === Infinity ? 'none' : maxW + "px";
	        style.maxHeight = maxH === Infinity ? 'none' : maxH + "px";
	        // Notify the ancestor that it should fit immediately.
	        var ancestor = this.parent.parent;
	        if (ancestor)
	            phosphor_messaging_1.sendMessage(ancestor, phosphor_widget_1.Widget.MsgFitRequest);
	        // Notify the parent that it should update immediately.
	        phosphor_messaging_1.sendMessage(this.parent, phosphor_widget_1.Widget.MsgUpdateRequest);
	    };
	    /**
	     * Update the layout position and size of the child widgets.
	     *
	     * The parent offset dimensions should be `-1` if unknown.
	     */
	    BoxLayout.prototype._update = function (offsetWidth, offsetHeight) {
	        // Bail early if there are no children to layout.
	        if (this.childCount() === 0) {
	            return;
	        }
	        // Measure the parent if the offset dimensions are unknown.
	        if (offsetWidth < 0) {
	            offsetWidth = this.parent.node.offsetWidth;
	        }
	        if (offsetHeight < 0) {
	            offsetHeight = this.parent.node.offsetHeight;
	        }
	        // Ensure the parent box sizing data is computed.
	        var box = this._box || (this._box = phosphor_domutil_1.boxSizing(this.parent.node));
	        // Compute the layout area adjusted for border and padding.
	        var top = box.paddingTop;
	        var left = box.paddingLeft;
	        var width = offsetWidth - box.horizontalSum;
	        var height = offsetHeight - box.verticalSum;
	        // Distribute the layout space and adjust the start position.
	        switch (this._direction) {
	            case Direction.LeftToRight:
	                phosphor_boxengine_1.boxCalc(this._sizers, Math.max(0, width - this._fixed));
	                break;
	            case Direction.TopToBottom:
	                phosphor_boxengine_1.boxCalc(this._sizers, Math.max(0, height - this._fixed));
	                break;
	            case Direction.RightToLeft:
	                phosphor_boxengine_1.boxCalc(this._sizers, Math.max(0, width - this._fixed));
	                left += width;
	                break;
	            case Direction.BottomToTop:
	                phosphor_boxengine_1.boxCalc(this._sizers, Math.max(0, height - this._fixed));
	                top += height;
	                break;
	        }
	        // Layout the children using the computed box sizes.
	        for (var i = 0, n = this.childCount(); i < n; ++i) {
	            var child = this.childAt(i);
	            if (child.isHidden) {
	                continue;
	            }
	            var size = this._sizers[i].size;
	            switch (this._direction) {
	                case Direction.LeftToRight:
	                    BoxLayoutPrivate.setGeometry(child, left, top, size, height);
	                    left += size + this._spacing;
	                    break;
	                case Direction.TopToBottom:
	                    BoxLayoutPrivate.setGeometry(child, left, top, width, size);
	                    top += size + this._spacing;
	                    break;
	                case Direction.RightToLeft:
	                    BoxLayoutPrivate.setGeometry(child, left - size, top, size, height);
	                    left -= size + this._spacing;
	                    break;
	                case Direction.BottomToTop:
	                    BoxLayoutPrivate.setGeometry(child, left, top - size, width, size);
	                    top -= size + this._spacing;
	                    break;
	            }
	        }
	    };
	    return BoxLayout;
	})(phosphor_panel_1.PanelLayout);
	exports.BoxLayout = BoxLayout;
	/**
	 * The namespace for the `BoxLayout` class statics.
	 */
	var BoxLayout;
	(function (BoxLayout) {
	    /**
	     * A convenience alias of the `LeftToRight` [[Direction]].
	     */
	    BoxLayout.LeftToRight = Direction.LeftToRight;
	    /**
	     * A convenience alias of the `RightToLeft` [[Direction]].
	     */
	    BoxLayout.RightToLeft = Direction.RightToLeft;
	    /**
	     * A convenience alias of the `TopToBottom` [[Direction]].
	     */
	    BoxLayout.TopToBottom = Direction.TopToBottom;
	    /**
	     * A convenience alias of the `BottomToTop` [[Direction]].
	     */
	    BoxLayout.BottomToTop = Direction.BottomToTop;
	    /**
	     * Get the box layout stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The box layout stretch factor for the widget.
	     */
	    function getStretch(widget) {
	        return BoxLayoutPrivate.stretchProperty.get(widget);
	    }
	    BoxLayout.getStretch = getStretch;
	    /**
	     * Set the box layout stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the stretch factor.
	     */
	    function setStretch(widget, value) {
	        BoxLayoutPrivate.stretchProperty.set(widget, value);
	    }
	    BoxLayout.setStretch = setStretch;
	    /**
	     * Get the box layout size basis for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The box layout size basis for the widget.
	     */
	    function getSizeBasis(widget) {
	        return BoxLayoutPrivate.sizeBasisProperty.get(widget);
	    }
	    BoxLayout.getSizeBasis = getSizeBasis;
	    /**
	     * Set the box layout size basis for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the size basis.
	     */
	    function setSizeBasis(widget, value) {
	        BoxLayoutPrivate.sizeBasisProperty.set(widget, value);
	    }
	    BoxLayout.setSizeBasis = setSizeBasis;
	})(BoxLayout = exports.BoxLayout || (exports.BoxLayout = {}));
	/**
	 * The namespace for the `BoxLayout` class private data.
	 */
	var BoxLayoutPrivate;
	(function (BoxLayoutPrivate) {
	    /**
	     * A flag indicating whether the browser is IE.
	     */
	    BoxLayoutPrivate.IsIE = /Trident/.test(navigator.userAgent);
	    /**
	     * The property descriptor for a widget stretch factor.
	     */
	    BoxLayoutPrivate.stretchProperty = new phosphor_properties_1.Property({
	        name: 'stretch',
	        value: 0,
	        coerce: function (owner, value) { return Math.max(0, value | 0); },
	        changed: onChildPropertyChanged,
	    });
	    /**
	     * The property descriptor for a widget size basis.
	     */
	    BoxLayoutPrivate.sizeBasisProperty = new phosphor_properties_1.Property({
	        name: 'sizeBasis',
	        value: 0,
	        coerce: function (owner, value) { return Math.max(0, value | 0); },
	        changed: onChildPropertyChanged,
	    });
	    /**
	     * Test whether a direction has horizontal orientation.
	     */
	    function isHorizontal(dir) {
	        return dir === Direction.LeftToRight || dir === Direction.RightToLeft;
	    }
	    BoxLayoutPrivate.isHorizontal = isHorizontal;
	    /**
	     * Toggle the CSS direction class for the given widget.
	     */
	    function toggleDirection(widget, dir) {
	        widget.toggleClass(LEFT_TO_RIGHT_CLASS, dir === Direction.LeftToRight);
	        widget.toggleClass(RIGHT_TO_LEFT_CLASS, dir === Direction.RightToLeft);
	        widget.toggleClass(TOP_TO_BOTTOM_CLASS, dir === Direction.TopToBottom);
	        widget.toggleClass(BOTTOM_TO_TOP_CLASS, dir === Direction.BottomToTop);
	    }
	    BoxLayoutPrivate.toggleDirection = toggleDirection;
	    /**
	     * Prepare a child widget for absolute layout geometry.
	     */
	    function prepareGeometry(widget) {
	        widget.node.style.position = 'absolute';
	    }
	    BoxLayoutPrivate.prepareGeometry = prepareGeometry;
	    /**
	     * Reset the layout geometry of a child widget.
	     */
	    function resetGeometry(widget) {
	        var rect = rectProperty.get(widget);
	        var style = widget.node.style;
	        rect.top = NaN;
	        rect.left = NaN;
	        rect.width = NaN;
	        rect.height = NaN;
	        style.position = '';
	        style.top = '';
	        style.left = '';
	        style.width = '';
	        style.height = '';
	    }
	    BoxLayoutPrivate.resetGeometry = resetGeometry;
	    /**
	     * Set the layout geometry of a child widget.
	     */
	    function setGeometry(widget, left, top, width, height) {
	        var resized = false;
	        var style = widget.node.style;
	        var rect = rectProperty.get(widget);
	        if (rect.top !== top) {
	            rect.top = top;
	            style.top = top + "px";
	        }
	        if (rect.left !== left) {
	            rect.left = left;
	            style.left = left + "px";
	        }
	        if (rect.width !== width) {
	            resized = true;
	            rect.width = width;
	            style.width = width + "px";
	        }
	        if (rect.height !== height) {
	            resized = true;
	            rect.height = height;
	            style.height = height + "px";
	        }
	        if (resized) {
	            phosphor_messaging_1.sendMessage(widget, new phosphor_widget_1.ResizeMessage(width, height));
	        }
	    }
	    BoxLayoutPrivate.setGeometry = setGeometry;
	    /**
	     * A property descriptor for a widget offset rect.
	     */
	    var rectProperty = new phosphor_properties_1.Property({
	        name: 'rect',
	        create: function () { return ({ top: NaN, left: NaN, width: NaN, height: NaN }); },
	    });
	    /**
	     * The change handler for the attached child properties.
	     */
	    function onChildPropertyChanged(child) {
	        var parent = child.parent;
	        var layout = parent && parent.layout;
	        if (layout instanceof BoxLayout)
	            parent.fit();
	    }
	})(BoxLayoutPrivate || (BoxLayoutPrivate = {}));


/***/ },
/* 6 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	/**
	 * The sizer object for the [[boxCalc]] function.
	 *
	 * A box sizer holds the geometry information for an object along the
	 * layout orientation. An array of box sizers representing a line of
	 * objects is passed to [[boxCalc]] along with the amount of space
	 * available for layout. The algorithm will update the [[size]] of
	 * each box sizer with its computed size.
	 *
	 * #### Notes
	 * For best performance, this class should be treated as a raw data
	 * struct. It should not typically be subclassed.
	 */
	var BoxSizer = (function () {
	    function BoxSizer() {
	        /**
	         * The preferred size for the sizer.
	         *
	         * The sizer will be given this initial size subject to its size
	         * bounds. The sizer will not deviate from this size unless such
	         * deviation is required to fit into the available layout space.
	         *
	         * #### Notes
	         * There is no limit to this value, but it will be clamped to the
	         * bounds defined by [[minSize]] and [[maxSize]].
	         *
	         * The default value is `0`.
	         */
	        this.sizeHint = 0;
	        /**
	         * The minimum size of the sizer.
	         *
	         * The sizer will never be sized less than this value, even if
	         * it means the sizer will overflow the available layout space.
	         *
	         * #### Notes
	         * It is assumed that this value lies in the range `[0, Infinity)`
	         * and that it is `<=` to [[maxSize]]. Failure to adhere to this
	         * constraint will yield undefined results.
	         *
	         * The default value is `0`.
	         */
	        this.minSize = 0;
	        /**
	         * The maximum size of the sizer.
	         *
	         * The sizer will never be sized greater than this value, even if
	         * it means the sizer will underflow the available layout space.
	         *
	         * #### Notes
	         * It is assumed that this value lies in the range `[0, Infinity]`
	         * and that it is `>=` to [[minSize]]. Failure to adhere to this
	         * constraint will yield undefined results.
	         *
	         * The default value is `Infinity`.
	         */
	        this.maxSize = Infinity;
	        /**
	         * The stretch factor for the sizer.
	         *
	         * This controls how much the sizer stretches relative to its sibling
	         * sizers when layout space is distributed. A stretch factor of zero
	         * is special and will cause the sizer to only be resized after all
	         * other sizers with a stretch factor greater than zero have been
	         * resized to their limits.
	         *
	         * #### Notes
	         * It is assumed that this value is an integer that lies in the range
	         * `[0, Infinity)`. Failure to adhere to this constraint will yield
	         * undefined results.
	         *
	         * The default value is `1`.
	         */
	        this.stretch = 1;
	        /**
	         * The computed size of the sizer.
	         *
	         * This value is the output of a call to [[boxCalc]]. It represents
	         * the computed size for the object along the layout orientation,
	         * and will always lie in the range `[minSize, maxSize]`.
	         *
	         * #### Notes
	         * This value is output only. Changing the value will have no effect.
	         */
	        this.size = 0;
	        /**
	         * An internal storage property for the layout algorithm.
	         *
	         * #### Notes
	         * This value is used as temporary storage by the layout algorithm.
	         * Changing the value will have no effect.
	         */
	        this.done = false;
	    }
	    return BoxSizer;
	})();
	exports.BoxSizer = BoxSizer;
	/**
	 * Compute the optimal layout sizes for an array of box sizers.
	 *
	 * This distributes the available layout space among the box sizers
	 * according to the following algorithm:
	 *
	 * 1. Initialize the sizers's size to its size hint and compute the
	 *    sums for each of size hint, min size, and max size.
	 *
	 * 2. If the total size hint equals the available space, return.
	 *
	 * 3. If the available space is less than the total min size, set all
	 *    sizers to their min size and return.
	 *
	 * 4. If the available space is greater than the total max size, set
	 *    all sizers to their max size and return.
	 *
	 * 5. If the layout space is less than the total size hint, distribute
	 *    the negative delta as follows:
	 *
	 *    a. Shrink each sizer with a stretch factor greater than zero by
	 *       an amount proportional to the negative space and the sum of
	 *       stretch factors. If the sizer reaches its min size, remove
	 *       it and its stretch factor from the computation.
	 *
	 *    b. If after adjusting all stretch sizers there remains negative
	 *       space, distribute the space equally among the sizers with a
	 *       stretch factor of zero. If a sizer reaches its min size,
	 *       remove it from the computation.
	 *
	 * 6. If the layout space is greater than the total size hint,
	 *    distribute the positive delta as follows:
	 *
	 *    a. Expand each sizer with a stretch factor greater than zero by
	 *       an amount proportional to the postive space and the sum of
	 *       stretch factors. If the sizer reaches its max size, remove
	 *       it and its stretch factor from the computation.
	 *
	 *    b. If after adjusting all stretch sizers there remains positive
	 *       space, distribute the space equally among the sizers with a
	 *       stretch factor of zero. If a sizer reaches its max size,
	 *       remove it from the computation.
	 *
	 * 7. return
	 *
	 * @param sizers - The sizers for a particular layout line.
	 *
	 * @param space - The available layout space for the sizers.
	 *
	 * #### Notes
	 * This function can be called at any time to recompute the layout
	 * sizing for an existing array of sizers. The previously computed
	 * results will have no effect on the new output. It is therefore
	 * not necessary to create new sizers on each resize event.
	 */
	function boxCalc(sizers, space) {
	    // Bail early if there is nothing to do.
	    var count = sizers.length;
	    if (count === 0) {
	        return;
	    }
	    // Setup the size and stretch counters.
	    var totalMin = 0;
	    var totalMax = 0;
	    var totalSize = 0;
	    var totalStretch = 0;
	    var stretchCount = 0;
	    // Setup the sizers and compute the totals.
	    for (var i = 0; i < count; ++i) {
	        var sizer = sizers[i];
	        initSizer(sizer);
	        totalSize += sizer.size;
	        totalMin += sizer.minSize;
	        totalMax += sizer.maxSize;
	        if (sizer.stretch > 0) {
	            totalStretch += sizer.stretch;
	            stretchCount++;
	        }
	    }
	    // If the space is equal to the total size, return.
	    if (space === totalSize) {
	        return;
	    }
	    // If the space is less than the total min, minimize each sizer.
	    if (space <= totalMin) {
	        for (var i = 0; i < count; ++i) {
	            var sizer = sizers[i];
	            sizer.size = sizer.minSize;
	        }
	        return;
	    }
	    // If the space is greater than the total max, maximize each sizer.
	    if (space >= totalMax) {
	        for (var i = 0; i < count; ++i) {
	            var sizer = sizers[i];
	            sizer.size = sizer.maxSize;
	        }
	        return;
	    }
	    // The loops below perform sub-pixel precision sizing. A near zero
	    // value is used for compares instead of zero to ensure that the
	    // loop terminates when the subdivided space is reasonably small.
	    var nearZero = 0.01;
	    // A counter which is decremented each time a sizer is resized to
	    // its limit. This ensures the loops terminate even if there is
	    // space remaining to distribute.
	    var notDoneCount = count;
	    // Distribute negative delta space.
	    if (space < totalSize) {
	        // Shrink each stretchable sizer by an amount proportional to its
	        // stretch factor. If a sizer reaches its min size it's marked as
	        // done. The loop progresses in phases where each sizer is given
	        // a chance to consume its fair share for the pass, regardless of
	        // whether a sizer before it reached its limit. This continues
	        // until the stretchable sizers or the free space is exhausted.
	        var freeSpace = totalSize - space;
	        while (stretchCount > 0 && freeSpace > nearZero) {
	            var distSpace = freeSpace;
	            var distStretch = totalStretch;
	            for (var i = 0; i < count; ++i) {
	                var sizer = sizers[i];
	                if (sizer.done || sizer.stretch === 0) {
	                    continue;
	                }
	                var amt = sizer.stretch * distSpace / distStretch;
	                if (sizer.size - amt <= sizer.minSize) {
	                    freeSpace -= sizer.size - sizer.minSize;
	                    totalStretch -= sizer.stretch;
	                    sizer.size = sizer.minSize;
	                    sizer.done = true;
	                    notDoneCount--;
	                    stretchCount--;
	                }
	                else {
	                    freeSpace -= amt;
	                    sizer.size -= amt;
	                }
	            }
	        }
	        // Distribute any remaining space evenly among the non-stretchable
	        // sizers. This progresses in phases in the same manner as above.
	        while (notDoneCount > 0 && freeSpace > nearZero) {
	            var amt = freeSpace / notDoneCount;
	            for (var i = 0; i < count; ++i) {
	                var sizer = sizers[i];
	                if (sizer.done) {
	                    continue;
	                }
	                if (sizer.size - amt <= sizer.minSize) {
	                    freeSpace -= sizer.size - sizer.minSize;
	                    sizer.size = sizer.minSize;
	                    sizer.done = true;
	                    notDoneCount--;
	                }
	                else {
	                    freeSpace -= amt;
	                    sizer.size -= amt;
	                }
	            }
	        }
	    }
	    else {
	        // Expand each stretchable sizer by an amount proportional to its
	        // stretch factor. If a sizer reaches its max size it's marked as
	        // done. The loop progresses in phases where each sizer is given
	        // a chance to consume its fair share for the pass, regardless of
	        // whether a sizer before it reached its limit. This continues
	        // until the stretchable sizers or the free space is exhausted.
	        var freeSpace = space - totalSize;
	        while (stretchCount > 0 && freeSpace > nearZero) {
	            var distSpace = freeSpace;
	            var distStretch = totalStretch;
	            for (var i = 0; i < count; ++i) {
	                var sizer = sizers[i];
	                if (sizer.done || sizer.stretch === 0) {
	                    continue;
	                }
	                var amt = sizer.stretch * distSpace / distStretch;
	                if (sizer.size + amt >= sizer.maxSize) {
	                    freeSpace -= sizer.maxSize - sizer.size;
	                    totalStretch -= sizer.stretch;
	                    sizer.size = sizer.maxSize;
	                    sizer.done = true;
	                    notDoneCount--;
	                    stretchCount--;
	                }
	                else {
	                    freeSpace -= amt;
	                    sizer.size += amt;
	                }
	            }
	        }
	        // Distribute any remaining space evenly among the non-stretchable
	        // sizers. This progresses in phases in the same manner as above.
	        while (notDoneCount > 0 && freeSpace > nearZero) {
	            var amt = freeSpace / notDoneCount;
	            for (var i = 0; i < count; ++i) {
	                var sizer = sizers[i];
	                if (sizer.done) {
	                    continue;
	                }
	                if (sizer.size + amt >= sizer.maxSize) {
	                    freeSpace -= sizer.maxSize - sizer.size;
	                    sizer.size = sizer.maxSize;
	                    sizer.done = true;
	                    notDoneCount--;
	                }
	                else {
	                    freeSpace -= amt;
	                    sizer.size += amt;
	                }
	            }
	        }
	    }
	}
	exports.boxCalc = boxCalc;
	/**
	 * (Re)initialize a box sizer's data for a layout pass.
	 */
	function initSizer(sizer) {
	    sizer.size = Math.max(sizer.minSize, Math.min(sizer.sizeHint, sizer.maxSize));
	    sizer.done = false;
	}
	//# sourceMappingURL=index.js.map

/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var phosphor_disposable_1 = __webpack_require__(8);
	__webpack_require__(9);
	/**
	 * The class name added to the document body during cursor override.
	 */
	var OVERRIDE_CURSOR_CLASS = 'p-mod-override-cursor';
	/**
	 * The id for the active cursor override.
	 */
	var overrideID = 0;
	/**
	 * Override the cursor for the entire document.
	 *
	 * @param cursor - The string representing the cursor style.
	 *
	 * @returns A disposable which will clear the override when disposed.
	 *
	 * #### Notes
	 * The most recent call to `overrideCursor` takes precedence. Disposing
	 * an old override is a no-op and will not effect the current override.
	 *
	 * #### Example
	 * ```typescript
	 * import { overrideCursor } from 'phosphor-domutil';
	 *
	 * // force the cursor to be 'wait' for the entire document
	 * let override = overrideCursor('wait');
	 *
	 * // clear the override by disposing the return value
	 * override.dispose();
	 * ```
	 */
	function overrideCursor(cursor) {
	    var id = ++overrideID;
	    var body = document.body;
	    body.style.cursor = cursor;
	    body.classList.add(OVERRIDE_CURSOR_CLASS);
	    return new phosphor_disposable_1.DisposableDelegate(function () {
	        if (id === overrideID) {
	            body.style.cursor = '';
	            body.classList.remove(OVERRIDE_CURSOR_CLASS);
	        }
	    });
	}
	exports.overrideCursor = overrideCursor;
	/**
	 * Test whether a client position lies within a node.
	 *
	 * @param node - The DOM node of interest.
	 *
	 * @param clientX - The client X coordinate of interest.
	 *
	 * @param clientY - The client Y coordinate of interest.
	 *
	 * @returns `true` if the node covers the position, `false` otherwise.
	 *
	 * #### Example
	 * ```typescript
	 * import { hitTest } from 'phosphor-domutil';
	 *
	 * let div = document.createElement('div');
	 * div.style.position = 'absolute';
	 * div.style.left = '0px';
	 * div.style.top = '0px';
	 * div.style.width = '100px';
	 * div.style.height = '100px';
	 * document.body.appendChild(div);
	 *
	 * hitTest(div, 50, 50);   // true
	 * hitTest(div, 150, 150); // false
	 * ```
	 */
	function hitTest(node, clientX, clientY) {
	    var rect = node.getBoundingClientRect();
	    return (clientX >= rect.left &&
	        clientX < rect.right &&
	        clientY >= rect.top &&
	        clientY < rect.bottom);
	}
	exports.hitTest = hitTest;
	/**
	 * Compute the box sizing for a DOM node.
	 *
	 * @param node - The DOM node for which to compute the box sizing.
	 *
	 * @returns The box sizing data for the specified DOM node.
	 *
	 * #### Example
	 * ```typescript
	 * import { boxSizing } from 'phosphor-domutil';
	 *
	 * let div = document.createElement('div');
	 * div.style.borderTop = 'solid 10px black';
	 * document.body.appendChild(div);
	 *
	 * let sizing = boxSizing(div);
	 * sizing.borderTop;    // 10
	 * sizing.paddingLeft;  // 0
	 * // etc...
	 * ```
	 */
	function boxSizing(node) {
	    var cstyle = window.getComputedStyle(node);
	    var bt = parseInt(cstyle.borderTopWidth, 10) || 0;
	    var bl = parseInt(cstyle.borderLeftWidth, 10) || 0;
	    var br = parseInt(cstyle.borderRightWidth, 10) || 0;
	    var bb = parseInt(cstyle.borderBottomWidth, 10) || 0;
	    var pt = parseInt(cstyle.paddingTop, 10) || 0;
	    var pl = parseInt(cstyle.paddingLeft, 10) || 0;
	    var pr = parseInt(cstyle.paddingRight, 10) || 0;
	    var pb = parseInt(cstyle.paddingBottom, 10) || 0;
	    var hs = bl + pl + pr + br;
	    var vs = bt + pt + pb + bb;
	    return {
	        borderTop: bt,
	        borderLeft: bl,
	        borderRight: br,
	        borderBottom: bb,
	        paddingTop: pt,
	        paddingLeft: pl,
	        paddingRight: pr,
	        paddingBottom: pb,
	        horizontalSum: hs,
	        verticalSum: vs,
	    };
	}
	exports.boxSizing = boxSizing;
	/**
	 * Compute the size limits for a DOM node.
	 *
	 * @param node - The node for which to compute the size limits.
	 *
	 * @returns The size limit data for the specified DOM node.
	 *
	 * #### Example
	 * ```typescript
	 * import { sizeLimits } from 'phosphor-domutil';
	 *
	 * let div = document.createElement('div');
	 * div.style.minWidth = '90px';
	 * document.body.appendChild(div);
	 *
	 * let limits = sizeLimits(div);
	 * limits.minWidth;   // 90
	 * limits.maxHeight;  // Infinity
	 * // etc...
	 * ```
	 */
	function sizeLimits(node) {
	    var cstyle = window.getComputedStyle(node);
	    return {
	        minWidth: parseInt(cstyle.minWidth, 10) || 0,
	        minHeight: parseInt(cstyle.minHeight, 10) || 0,
	        maxWidth: parseInt(cstyle.maxWidth, 10) || Infinity,
	        maxHeight: parseInt(cstyle.maxHeight, 10) || Infinity,
	    };
	}
	exports.sizeLimits = sizeLimits;
	//# sourceMappingURL=index.js.map

/***/ },
/* 8 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	/**
	 * A disposable object which delegates to a callback.
	 */
	var DisposableDelegate = (function () {
	    /**
	     * Construct a new disposable delegate.
	     *
	     * @param callback - The function to invoke when the delegate is
	     *   disposed.
	     */
	    function DisposableDelegate(callback) {
	        this._callback = callback || null;
	    }
	    Object.defineProperty(DisposableDelegate.prototype, "isDisposed", {
	        /**
	         * Test whether the delegate has been disposed.
	         *
	         * #### Notes
	         * This is a read-only property which is always safe to access.
	         */
	        get: function () {
	            return this._callback === null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the delegate and invoke its callback.
	     *
	     * #### Notes
	     * If this method is called more than once, all calls made after the
	     * first will be a no-op.
	     */
	    DisposableDelegate.prototype.dispose = function () {
	        if (this._callback === null) {
	            return;
	        }
	        var callback = this._callback;
	        this._callback = null;
	        callback();
	    };
	    return DisposableDelegate;
	})();
	exports.DisposableDelegate = DisposableDelegate;
	/**
	 * An object which manages a collection of disposable items.
	 */
	var DisposableSet = (function () {
	    /**
	     * Construct a new disposable set.
	     *
	     * @param items - The initial disposable items for the set.
	     */
	    function DisposableSet(items) {
	        var _this = this;
	        this._set = new Set();
	        if (items)
	            items.forEach(function (item) { _this._set.add(item); });
	    }
	    Object.defineProperty(DisposableSet.prototype, "isDisposed", {
	        /**
	         * Test whether the set has been disposed.
	         *
	         * #### Notes
	         * This is a read-only property which is always safe to access.
	         */
	        get: function () {
	            return this._set === null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the set and dispose the items it contains.
	     *
	     * #### Notes
	     * Items are disposed in the order they are added to the set.
	     *
	     * It is unsafe to use the set after it has been disposed.
	     *
	     * If this method is called more than once, all calls made after the
	     * first will be a no-op.
	     */
	    DisposableSet.prototype.dispose = function () {
	        if (this._set === null) {
	            return;
	        }
	        var set = this._set;
	        this._set = null;
	        set.forEach(function (item) { item.dispose(); });
	    };
	    /**
	     * Add a disposable item to the set.
	     *
	     * @param item - The disposable item to add to the set. If the item
	     *   is already contained in the set, this is a no-op.
	     *
	     * @throws Will throw an error if the set has been disposed.
	     */
	    DisposableSet.prototype.add = function (item) {
	        if (this._set === null) {
	            throw new Error('object is disposed');
	        }
	        this._set.add(item);
	    };
	    /**
	     * Remove a disposable item from the set.
	     *
	     * @param item - The disposable item to remove from the set. If the
	     *   item does not exist in the set, this is a no-op.
	     *
	     * @throws Will throw an error if the set has been disposed.
	     */
	    DisposableSet.prototype.remove = function (item) {
	        if (this._set === null) {
	            throw new Error('object is disposed');
	        }
	        this._set.delete(item);
	    };
	    /**
	     * Clear all disposable items from the set.
	     *
	     * @throws Will throw an error if the set has been disposed.
	     */
	    DisposableSet.prototype.clear = function () {
	        if (this._set === null) {
	            throw new Error('object is disposed');
	        }
	        this._set.clear();
	    };
	    return DisposableSet;
	})();
	exports.DisposableSet = DisposableSet;
	//# sourceMappingURL=index.js.map

/***/ },
/* 9 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(10);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(12)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../css-loader/index.js!./index.css", function() {
				var newContent = require("!!./../../css-loader/index.js!./index.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\r\n| Copyright (c) 2014-2015, PhosphorJS Contributors\r\n|\r\n| Distributed under the terms of the BSD 3-Clause License.\r\n|\r\n| The full license is in the file LICENSE, distributed with this software.\r\n|----------------------------------------------------------------------------*/\r\nbody.p-mod-override-cursor * {\r\n  cursor: inherit !important;\r\n}\r\n", ""]);
	
	// exports


/***/ },
/* 11 */
/***/ function(module, exports) {

	/*
		MIT License http://www.opensource.org/licenses/mit-license.php
		Author Tobias Koppers @sokra
	*/
	// css base code, injected by the css-loader
	module.exports = function() {
		var list = [];
	
		// return the list of modules as css string
		list.toString = function toString() {
			var result = [];
			for(var i = 0; i < this.length; i++) {
				var item = this[i];
				if(item[2]) {
					result.push("@media " + item[2] + "{" + item[1] + "}");
				} else {
					result.push(item[1]);
				}
			}
			return result.join("");
		};
	
		// import a list of modules into the list
		list.i = function(modules, mediaQuery) {
			if(typeof modules === "string")
				modules = [[null, modules, ""]];
			var alreadyImportedModules = {};
			for(var i = 0; i < this.length; i++) {
				var id = this[i][0];
				if(typeof id === "number")
					alreadyImportedModules[id] = true;
			}
			for(i = 0; i < modules.length; i++) {
				var item = modules[i];
				// skip already imported module
				// this implementation is not 100% perfect for weird media query combinations
				//  when a module is imported multiple times with different media queries.
				//  I hope this will never occur (Hey this way we have smaller bundles)
				if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
					if(mediaQuery && !item[2]) {
						item[2] = mediaQuery;
					} else if(mediaQuery) {
						item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
					}
					list.push(item);
				}
			}
		};
		return list;
	};


/***/ },
/* 12 */
/***/ function(module, exports, __webpack_require__) {

	/*
		MIT License http://www.opensource.org/licenses/mit-license.php
		Author Tobias Koppers @sokra
	*/
	var stylesInDom = {},
		memoize = function(fn) {
			var memo;
			return function () {
				if (typeof memo === "undefined") memo = fn.apply(this, arguments);
				return memo;
			};
		},
		isOldIE = memoize(function() {
			return /msie [6-9]\b/.test(window.navigator.userAgent.toLowerCase());
		}),
		getHeadElement = memoize(function () {
			return document.head || document.getElementsByTagName("head")[0];
		}),
		singletonElement = null,
		singletonCounter = 0,
		styleElementsInsertedAtTop = [];
	
	module.exports = function(list, options) {
		if(true) {
			if(typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
		}
	
		options = options || {};
		// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
		// tags it will allow on a page
		if (typeof options.singleton === "undefined") options.singleton = isOldIE();
	
		// By default, add <style> tags to the bottom of <head>.
		if (typeof options.insertAt === "undefined") options.insertAt = "bottom";
	
		var styles = listToStyles(list);
		addStylesToDom(styles, options);
	
		return function update(newList) {
			var mayRemove = [];
			for(var i = 0; i < styles.length; i++) {
				var item = styles[i];
				var domStyle = stylesInDom[item.id];
				domStyle.refs--;
				mayRemove.push(domStyle);
			}
			if(newList) {
				var newStyles = listToStyles(newList);
				addStylesToDom(newStyles, options);
			}
			for(var i = 0; i < mayRemove.length; i++) {
				var domStyle = mayRemove[i];
				if(domStyle.refs === 0) {
					for(var j = 0; j < domStyle.parts.length; j++)
						domStyle.parts[j]();
					delete stylesInDom[domStyle.id];
				}
			}
		};
	}
	
	function addStylesToDom(styles, options) {
		for(var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];
			if(domStyle) {
				domStyle.refs++;
				for(var j = 0; j < domStyle.parts.length; j++) {
					domStyle.parts[j](item.parts[j]);
				}
				for(; j < item.parts.length; j++) {
					domStyle.parts.push(addStyle(item.parts[j], options));
				}
			} else {
				var parts = [];
				for(var j = 0; j < item.parts.length; j++) {
					parts.push(addStyle(item.parts[j], options));
				}
				stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
			}
		}
	}
	
	function listToStyles(list) {
		var styles = [];
		var newStyles = {};
		for(var i = 0; i < list.length; i++) {
			var item = list[i];
			var id = item[0];
			var css = item[1];
			var media = item[2];
			var sourceMap = item[3];
			var part = {css: css, media: media, sourceMap: sourceMap};
			if(!newStyles[id])
				styles.push(newStyles[id] = {id: id, parts: [part]});
			else
				newStyles[id].parts.push(part);
		}
		return styles;
	}
	
	function insertStyleElement(options, styleElement) {
		var head = getHeadElement();
		var lastStyleElementInsertedAtTop = styleElementsInsertedAtTop[styleElementsInsertedAtTop.length - 1];
		if (options.insertAt === "top") {
			if(!lastStyleElementInsertedAtTop) {
				head.insertBefore(styleElement, head.firstChild);
			} else if(lastStyleElementInsertedAtTop.nextSibling) {
				head.insertBefore(styleElement, lastStyleElementInsertedAtTop.nextSibling);
			} else {
				head.appendChild(styleElement);
			}
			styleElementsInsertedAtTop.push(styleElement);
		} else if (options.insertAt === "bottom") {
			head.appendChild(styleElement);
		} else {
			throw new Error("Invalid value for parameter 'insertAt'. Must be 'top' or 'bottom'.");
		}
	}
	
	function removeStyleElement(styleElement) {
		styleElement.parentNode.removeChild(styleElement);
		var idx = styleElementsInsertedAtTop.indexOf(styleElement);
		if(idx >= 0) {
			styleElementsInsertedAtTop.splice(idx, 1);
		}
	}
	
	function createStyleElement(options) {
		var styleElement = document.createElement("style");
		styleElement.type = "text/css";
		insertStyleElement(options, styleElement);
		return styleElement;
	}
	
	function createLinkElement(options) {
		var linkElement = document.createElement("link");
		linkElement.rel = "stylesheet";
		insertStyleElement(options, linkElement);
		return linkElement;
	}
	
	function addStyle(obj, options) {
		var styleElement, update, remove;
	
		if (options.singleton) {
			var styleIndex = singletonCounter++;
			styleElement = singletonElement || (singletonElement = createStyleElement(options));
			update = applyToSingletonTag.bind(null, styleElement, styleIndex, false);
			remove = applyToSingletonTag.bind(null, styleElement, styleIndex, true);
		} else if(obj.sourceMap &&
			typeof URL === "function" &&
			typeof URL.createObjectURL === "function" &&
			typeof URL.revokeObjectURL === "function" &&
			typeof Blob === "function" &&
			typeof btoa === "function") {
			styleElement = createLinkElement(options);
			update = updateLink.bind(null, styleElement);
			remove = function() {
				removeStyleElement(styleElement);
				if(styleElement.href)
					URL.revokeObjectURL(styleElement.href);
			};
		} else {
			styleElement = createStyleElement(options);
			update = applyToTag.bind(null, styleElement);
			remove = function() {
				removeStyleElement(styleElement);
			};
		}
	
		update(obj);
	
		return function updateStyle(newObj) {
			if(newObj) {
				if(newObj.css === obj.css && newObj.media === obj.media && newObj.sourceMap === obj.sourceMap)
					return;
				update(obj = newObj);
			} else {
				remove();
			}
		};
	}
	
	var replaceText = (function () {
		var textStore = [];
	
		return function (index, replacement) {
			textStore[index] = replacement;
			return textStore.filter(Boolean).join('\n');
		};
	})();
	
	function applyToSingletonTag(styleElement, index, remove, obj) {
		var css = remove ? "" : obj.css;
	
		if (styleElement.styleSheet) {
			styleElement.styleSheet.cssText = replaceText(index, css);
		} else {
			var cssNode = document.createTextNode(css);
			var childNodes = styleElement.childNodes;
			if (childNodes[index]) styleElement.removeChild(childNodes[index]);
			if (childNodes.length) {
				styleElement.insertBefore(cssNode, childNodes[index]);
			} else {
				styleElement.appendChild(cssNode);
			}
		}
	}
	
	function applyToTag(styleElement, obj) {
		var css = obj.css;
		var media = obj.media;
	
		if(media) {
			styleElement.setAttribute("media", media)
		}
	
		if(styleElement.styleSheet) {
			styleElement.styleSheet.cssText = css;
		} else {
			while(styleElement.firstChild) {
				styleElement.removeChild(styleElement.firstChild);
			}
			styleElement.appendChild(document.createTextNode(css));
		}
	}
	
	function updateLink(linkElement, obj) {
		var css = obj.css;
		var sourceMap = obj.sourceMap;
	
		if(sourceMap) {
			// http://stackoverflow.com/a/26603875
			css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
		}
	
		var blob = new Blob([css], { type: "text/css" });
	
		var oldSrc = linkElement.href;
	
		linkElement.href = URL.createObjectURL(blob);
	
		if(oldSrc)
			URL.revokeObjectURL(oldSrc);
	}


/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(setImmediate) {/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var phosphor_queue_1 = __webpack_require__(16);
	/**
	 * A message which can be sent or posted to a message handler.
	 *
	 * #### Notes
	 * This class may be subclassed to create complex message types.
	 *
	 * **See Also** [[postMessage]] and [[sendMessage]].
	 */
	var Message = (function () {
	    /**
	     * Construct a new message.
	     *
	     * @param type - The type of the message. Consumers of a message will
	     *   use this value to cast the message to the appropriately derived
	     *   message type.
	     */
	    function Message(type) {
	        this._type = type;
	    }
	    Object.defineProperty(Message.prototype, "type", {
	        /**
	         * Get the type of the message.
	         */
	        get: function () {
	            return this._type;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return Message;
	})();
	exports.Message = Message;
	/**
	 * Send a message to the message handler to process immediately.
	 *
	 * @param handler - The handler which should process the message.
	 *
	 * @param msg - The message to send to the handler.
	 *
	 * #### Notes
	 * Unlike [[postMessage]], [[sendMessage]] delivers the message to
	 * the handler immediately. The handler will not have the opportunity
	 * to compress the message, however the message will still be sent
	 * through any installed message filters.
	 *
	 * **See Also** [[postMessage]].
	 */
	function sendMessage(handler, msg) {
	    getDispatcher(handler).sendMessage(handler, msg);
	}
	exports.sendMessage = sendMessage;
	/**
	 * Post a message to the message handler to process in the future.
	 *
	 * @param handler - The handler which should process the message.
	 *
	 * @param msg - The message to post to the handler.
	 *
	 * #### Notes
	 * Unlike [[sendMessage]], [[postMessage]] will schedule the deliver of
	 * the message for the next cycle of the event loop. The handler will
	 * have the opportunity to compress the message in order to optimize
	 * its handling of similar messages. The message will be sent through
	 * any installed message filters before being delivered to the handler.
	 *
	 * **See Also** [[sendMessage]].
	 */
	function postMessage(handler, msg) {
	    getDispatcher(handler).postMessage(handler, msg);
	}
	exports.postMessage = postMessage;
	/**
	 * Test whether a message handler has posted messages pending delivery.
	 *
	 * @param handler - The message handler of interest.
	 *
	 * @returns `true` if the handler has pending posted messages, `false`
	 *   otherwise.
	 *
	 * **See Also** [[sendPendingMessage]].
	 */
	function hasPendingMessages(handler) {
	    return getDispatcher(handler).hasPendingMessages();
	}
	exports.hasPendingMessages = hasPendingMessages;
	/**
	 * Send the first pending posted message to the message handler.
	 *
	 * @param handler - The message handler of interest.
	 *
	 * #### Notes
	 * If the handler has no pending messages, this is a no-op.
	 *
	 * **See Also** [[hasPendingMessages]].
	 */
	function sendPendingMessage(handler) {
	    getDispatcher(handler).sendPendingMessage(handler);
	}
	exports.sendPendingMessage = sendPendingMessage;
	/**
	 * Install a message filter for a message handler.
	 *
	 * A message filter is invoked before the message handler processes a
	 * message. If the filter returns `true` from its [[filterMessage]] method,
	 * no other filters will be invoked, and the message will not be delivered.
	 *
	 * The most recently installed message filter is executed first.
	 *
	 * @param handler - The handler whose messages should be filtered.
	 *
	 * @param filter - The filter to install for the handler.
	 *
	 * #### Notes
	 * It is possible to install the same filter multiple times. If the
	 * filter should be unique, call [[removeMessageFilter]] first.
	 *
	 * **See Also** [[removeMessageFilter]].
	 */
	function installMessageFilter(handler, filter) {
	    getDispatcher(handler).installMessageFilter(filter);
	}
	exports.installMessageFilter = installMessageFilter;
	/**
	 * Remove a previously installed message filter for a message handler.
	 *
	 * @param handler - The handler for which the filter is installed.
	 *
	 * @param filter - The filter to remove.
	 *
	 * #### Notes
	 * This will remove **all** occurrences of the filter. If the filter is
	 * not installed, this is a no-op.
	 *
	 * It is safe to call this function while the filter is executing.
	 *
	 * **See Also** [[installMessageFilter]].
	 */
	function removeMessageFilter(handler, filter) {
	    getDispatcher(handler).removeMessageFilter(filter);
	}
	exports.removeMessageFilter = removeMessageFilter;
	/**
	 * Clear all message data associated with the message handler.
	 *
	 * @param handler - The message handler for which to clear the data.
	 *
	 * #### Notes
	 * This will remove all pending messages and filters for the handler.
	 */
	function clearMessageData(handler) {
	    var dispatcher = dispatcherMap.get(handler);
	    if (dispatcher)
	        dispatcher.clear();
	    dispatchQueue.removeAll(handler);
	}
	exports.clearMessageData = clearMessageData;
	/**
	 * The internal mapping of message handler to message dispatcher
	 */
	var dispatcherMap = new WeakMap();
	/**
	 * The internal queue of pending message handlers.
	 */
	var dispatchQueue = new phosphor_queue_1.Queue();
	/**
	 * The internal animation frame id for the message loop wake up call.
	 */
	var frameId = void 0;
	/**
	 * A local reference to an event loop hook.
	 */
	var raf;
	if (typeof requestAnimationFrame === 'function') {
	    raf = requestAnimationFrame;
	}
	else {
	    raf = setImmediate;
	}
	/**
	 * Get or create the message dispatcher for a message handler.
	 */
	function getDispatcher(handler) {
	    var dispatcher = dispatcherMap.get(handler);
	    if (dispatcher)
	        return dispatcher;
	    dispatcher = new MessageDispatcher();
	    dispatcherMap.set(handler, dispatcher);
	    return dispatcher;
	}
	/**
	 * Wake up the message loop to process any pending dispatchers.
	 *
	 * This is a no-op if a wake up is not needed or is already pending.
	 */
	function wakeUpMessageLoop() {
	    if (frameId === void 0 && !dispatchQueue.empty) {
	        frameId = raf(runMessageLoop);
	    }
	}
	/**
	 * Run an iteration of the message loop.
	 *
	 * This will process all pending dispatchers in the queue. Dispatchers
	 * which are added to the queue while the message loop is running will
	 * be processed on the next message loop cycle.
	 */
	function runMessageLoop() {
	    // Clear the frame id so the next wake up call can be scheduled.
	    frameId = void 0;
	    // If the queue is empty, there is nothing else to do.
	    if (dispatchQueue.empty) {
	        return;
	    }
	    // Add a null sentinel value to the end of the queue. The queue
	    // will only be processed up to the first null value. This means
	    // that messages posted during this cycle will execute on the next
	    // cycle of the loop.
	    dispatchQueue.push(null);
	    // The message dispatch loop. If the dispatcher is the null sentinel,
	    // the processing of the current block of messages is complete and
	    // another loop is scheduled. Otherwise, the pending message is
	    // dispatched to the message handler.
	    while (!dispatchQueue.empty) {
	        var handler = dispatchQueue.pop();
	        if (handler === null) {
	            wakeUpMessageLoop();
	            return;
	        }
	        getDispatcher(handler).sendPendingMessage(handler);
	    }
	}
	/**
	 * Safely process a message for a message handler.
	 *
	 * If the handler throws an exception, it will be caught and logged.
	 */
	function safeProcess(handler, msg) {
	    try {
	        handler.processMessage(msg);
	    }
	    catch (err) {
	        console.error(err);
	    }
	}
	/**
	 * Safely compress a message for a message handler.
	 *
	 * If the handler throws an exception, it will be caught and logged.
	 */
	function safeCompress(handler, msg, queue) {
	    var result = false;
	    try {
	        result = handler.compressMessage(msg, queue);
	    }
	    catch (err) {
	        console.error(err);
	    }
	    return result;
	}
	/**
	 * Safely filter a message for a message handler.
	 *
	 * If the filter throws an exception, it will be caught and logged.
	 */
	function safeFilter(filter, handler, msg) {
	    var result = false;
	    try {
	        result = filter.filterMessage(handler, msg);
	    }
	    catch (err) {
	        console.error(err);
	    }
	    return result;
	}
	/**
	 * An internal class which manages message dispatching for a handler.
	 */
	var MessageDispatcher = (function () {
	    function MessageDispatcher() {
	        this._filters = null;
	        this._messages = null;
	    }
	    /**
	     * Send a message to the handler immediately.
	     *
	     * The message will first be sent through installed filters.
	     */
	    MessageDispatcher.prototype.sendMessage = function (handler, msg) {
	        if (!this._filterMessage(handler, msg)) {
	            safeProcess(handler, msg);
	        }
	    };
	    /**
	     * Post a message for delivery in the future.
	     *
	     * The message will first be compressed if possible.
	     */
	    MessageDispatcher.prototype.postMessage = function (handler, msg) {
	        if (!this._compressMessage(handler, msg)) {
	            this._enqueueMessage(handler, msg);
	        }
	    };
	    /**
	     * Test whether the dispatcher has messages pending delivery.
	     */
	    MessageDispatcher.prototype.hasPendingMessages = function () {
	        return !!(this._messages && !this._messages.empty);
	    };
	    /**
	     * Send the first pending message to the message handler.
	     */
	    MessageDispatcher.prototype.sendPendingMessage = function (handler) {
	        if (this._messages && !this._messages.empty) {
	            this.sendMessage(handler, this._messages.pop());
	        }
	    };
	    /**
	     * Install a message filter for the dispatcher.
	     */
	    MessageDispatcher.prototype.installMessageFilter = function (filter) {
	        this._filters = { next: this._filters, filter: filter };
	    };
	    /**
	     * Remove all occurrences of a message filter from the dispatcher.
	     */
	    MessageDispatcher.prototype.removeMessageFilter = function (filter) {
	        var link = this._filters;
	        var prev = null;
	        while (link !== null) {
	            if (link.filter === filter) {
	                link.filter = null;
	            }
	            else if (prev === null) {
	                this._filters = link;
	                prev = link;
	            }
	            else {
	                prev.next = link;
	                prev = link;
	            }
	            link = link.next;
	        }
	        if (!prev) {
	            this._filters = null;
	        }
	        else {
	            prev.next = null;
	        }
	    };
	    /**
	     * Clear all messages and filters from the dispatcher.
	     */
	    MessageDispatcher.prototype.clear = function () {
	        if (this._messages) {
	            this._messages.clear();
	        }
	        for (var link = this._filters; link !== null; link = link.next) {
	            link.filter = null;
	        }
	        this._filters = null;
	    };
	    /**
	     * Run the installed message filters for the handler.
	     *
	     * Returns `true` if the message was filtered, `false` otherwise.
	     */
	    MessageDispatcher.prototype._filterMessage = function (handler, msg) {
	        for (var link = this._filters; link !== null; link = link.next) {
	            if (link.filter && safeFilter(link.filter, handler, msg)) {
	                return true;
	            }
	        }
	        return false;
	    };
	    /**
	     * Compress the mssage for the given handler.
	     *
	     * Returns `true` if the message was compressed, `false` otherwise.
	     */
	    MessageDispatcher.prototype._compressMessage = function (handler, msg) {
	        if (!handler.compressMessage) {
	            return false;
	        }
	        if (!this._messages || this._messages.empty) {
	            return false;
	        }
	        return safeCompress(handler, msg, this._messages);
	    };
	    /**
	     * Enqueue the message for future delivery to the handler.
	     */
	    MessageDispatcher.prototype._enqueueMessage = function (handler, msg) {
	        this._ensureMessages().push(msg);
	        dispatchQueue.push(handler);
	        wakeUpMessageLoop();
	    };
	    /**
	     * Get the internal message queue, creating it if needed.
	     */
	    MessageDispatcher.prototype._ensureMessages = function () {
	        return this._messages || (this._messages = new phosphor_queue_1.Queue());
	    };
	    return MessageDispatcher;
	})();
	//# sourceMappingURL=index.js.map
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(14).setImmediate))

/***/ },
/* 14 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(setImmediate, clearImmediate) {var nextTick = __webpack_require__(15).nextTick;
	var apply = Function.prototype.apply;
	var slice = Array.prototype.slice;
	var immediateIds = {};
	var nextImmediateId = 0;
	
	// DOM APIs, for completeness
	
	exports.setTimeout = function() {
	  return new Timeout(apply.call(setTimeout, window, arguments), clearTimeout);
	};
	exports.setInterval = function() {
	  return new Timeout(apply.call(setInterval, window, arguments), clearInterval);
	};
	exports.clearTimeout =
	exports.clearInterval = function(timeout) { timeout.close(); };
	
	function Timeout(id, clearFn) {
	  this._id = id;
	  this._clearFn = clearFn;
	}
	Timeout.prototype.unref = Timeout.prototype.ref = function() {};
	Timeout.prototype.close = function() {
	  this._clearFn.call(window, this._id);
	};
	
	// Does not start the time, just sets up the members needed.
	exports.enroll = function(item, msecs) {
	  clearTimeout(item._idleTimeoutId);
	  item._idleTimeout = msecs;
	};
	
	exports.unenroll = function(item) {
	  clearTimeout(item._idleTimeoutId);
	  item._idleTimeout = -1;
	};
	
	exports._unrefActive = exports.active = function(item) {
	  clearTimeout(item._idleTimeoutId);
	
	  var msecs = item._idleTimeout;
	  if (msecs >= 0) {
	    item._idleTimeoutId = setTimeout(function onTimeout() {
	      if (item._onTimeout)
	        item._onTimeout();
	    }, msecs);
	  }
	};
	
	// That's not how node.js implements it but the exposed api is the same.
	exports.setImmediate = typeof setImmediate === "function" ? setImmediate : function(fn) {
	  var id = nextImmediateId++;
	  var args = arguments.length < 2 ? false : slice.call(arguments, 1);
	
	  immediateIds[id] = true;
	
	  nextTick(function onNextTick() {
	    if (immediateIds[id]) {
	      // fn.call() is faster so we optimize for the common use-case
	      // @see http://jsperf.com/call-apply-segu
	      if (args) {
	        fn.apply(null, args);
	      } else {
	        fn.call(null);
	      }
	      // Prevent ids from leaking
	      exports.clearImmediate(id);
	    }
	  });
	
	  return id;
	};
	
	exports.clearImmediate = typeof clearImmediate === "function" ? clearImmediate : function(id) {
	  delete immediateIds[id];
	};
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(14).setImmediate, __webpack_require__(14).clearImmediate))

/***/ },
/* 15 */
/***/ function(module, exports) {

	// shim for using process in browser
	
	var process = module.exports = {};
	
	// cached from whatever global is present so that test runners that stub it
	// don't break things.  But we need to wrap it in a try catch in case it is
	// wrapped in strict mode code which doesn't define any globals.  It's inside a
	// function because try/catches deoptimize in certain engines.
	
	var cachedSetTimeout;
	var cachedClearTimeout;
	
	(function () {
	  try {
	    cachedSetTimeout = setTimeout;
	  } catch (e) {
	    cachedSetTimeout = function () {
	      throw new Error('setTimeout is not defined');
	    }
	  }
	  try {
	    cachedClearTimeout = clearTimeout;
	  } catch (e) {
	    cachedClearTimeout = function () {
	      throw new Error('clearTimeout is not defined');
	    }
	  }
	} ())
	var queue = [];
	var draining = false;
	var currentQueue;
	var queueIndex = -1;
	
	function cleanUpNextTick() {
	    if (!draining || !currentQueue) {
	        return;
	    }
	    draining = false;
	    if (currentQueue.length) {
	        queue = currentQueue.concat(queue);
	    } else {
	        queueIndex = -1;
	    }
	    if (queue.length) {
	        drainQueue();
	    }
	}
	
	function drainQueue() {
	    if (draining) {
	        return;
	    }
	    var timeout = cachedSetTimeout(cleanUpNextTick);
	    draining = true;
	
	    var len = queue.length;
	    while(len) {
	        currentQueue = queue;
	        queue = [];
	        while (++queueIndex < len) {
	            if (currentQueue) {
	                currentQueue[queueIndex].run();
	            }
	        }
	        queueIndex = -1;
	        len = queue.length;
	    }
	    currentQueue = null;
	    draining = false;
	    cachedClearTimeout(timeout);
	}
	
	process.nextTick = function (fun) {
	    var args = new Array(arguments.length - 1);
	    if (arguments.length > 1) {
	        for (var i = 1; i < arguments.length; i++) {
	            args[i - 1] = arguments[i];
	        }
	    }
	    queue.push(new Item(fun, args));
	    if (queue.length === 1 && !draining) {
	        cachedSetTimeout(drainQueue, 0);
	    }
	};
	
	// v8 likes predictible objects
	function Item(fun, array) {
	    this.fun = fun;
	    this.array = array;
	}
	Item.prototype.run = function () {
	    this.fun.apply(null, this.array);
	};
	process.title = 'browser';
	process.browser = true;
	process.env = {};
	process.argv = [];
	process.version = ''; // empty string to avoid regexp issues
	process.versions = {};
	
	function noop() {}
	
	process.on = noop;
	process.addListener = noop;
	process.once = noop;
	process.off = noop;
	process.removeListener = noop;
	process.removeAllListeners = noop;
	process.emit = noop;
	
	process.binding = function (name) {
	    throw new Error('process.binding is not supported');
	};
	
	process.cwd = function () { return '/' };
	process.chdir = function (dir) {
	    throw new Error('process.chdir is not supported');
	};
	process.umask = function() { return 0; };


/***/ },
/* 16 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	/**
	 * A generic FIFO queue data structure.
	 *
	 * #### Notes
	 * This queue is implemented internally using a singly linked list and
	 * can grow to arbitrary size.
	 *
	 * #### Example
	 * ```typescript
	 * let q = new Queue<number>([0, 1, 2]);
	 * q.size;      // 3
	 * q.empty;     // false
	 * q.pop();     // 0
	 * q.pop();     // 1
	 * q.push(42);  // undefined
	 * q.size;      // 2
	 * q.pop();     // 2
	 * q.pop();     // 42
	 * q.pop();     // undefined
	 * q.size;      // 0
	 * q.empty;     // true
	 * ```
	 */
	var Queue = (function () {
	    /**
	     * Construct a new queue.
	     *
	     * @param items - The initial items for the queue.
	     */
	    function Queue(items) {
	        var _this = this;
	        this._size = 0;
	        this._front = null;
	        this._back = null;
	        if (items)
	            items.forEach(function (item) { return _this.push(item); });
	    }
	    Object.defineProperty(Queue.prototype, "size", {
	        /**
	         * Get the number of elements in the queue.
	         *
	         * #### Notes
	         * This has `O(1)` complexity.
	         */
	        get: function () {
	            return this._size;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Queue.prototype, "empty", {
	        /**
	         * Test whether the queue is empty.
	         *
	         * #### Notes
	         * This has `O(1)` complexity.
	         */
	        get: function () {
	            return this._size === 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Queue.prototype, "front", {
	        /**
	         * Get the value at the front of the queue.
	         *
	         * #### Notes
	         * This has `O(1)` complexity.
	         *
	         * If the queue is empty, this value will be `undefined`.
	         */
	        get: function () {
	            return this._front !== null ? this._front.value : void 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Queue.prototype, "back", {
	        /**
	         * Get the value at the back of the queue.
	         *
	         * #### Notes
	         * This has `O(1)` complexity.
	         *
	         * If the queue is empty, this value will be `undefined`.
	         */
	        get: function () {
	            return this._back !== null ? this._back.value : void 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Push a value onto the back of the queue.
	     *
	     * @param value - The value to add to the queue.
	     *
	     * #### Notes
	     * This has `O(1)` complexity.
	     */
	    Queue.prototype.push = function (value) {
	        var link = { next: null, value: value };
	        if (this._back === null) {
	            this._front = link;
	            this._back = link;
	        }
	        else {
	            this._back.next = link;
	            this._back = link;
	        }
	        this._size++;
	    };
	    /**
	     * Pop and return the value at the front of the queue.
	     *
	     * @returns The value at the front of the queue.
	     *
	     * #### Notes
	     * This has `O(1)` complexity.
	     *
	     * If the queue is empty, the return value will be `undefined`.
	     */
	    Queue.prototype.pop = function () {
	        var link = this._front;
	        if (link === null) {
	            return void 0;
	        }
	        if (link.next === null) {
	            this._front = null;
	            this._back = null;
	        }
	        else {
	            this._front = link.next;
	        }
	        this._size--;
	        return link.value;
	    };
	    /**
	     * Remove the first occurrence of a value from the queue.
	     *
	     * @param value - The value to remove from the queue.
	     *
	     * @returns `true` on success, `false` otherwise.
	     *
	     * #### Notes
	     * This has `O(N)` complexity.
	     */
	    Queue.prototype.remove = function (value) {
	        var link = this._front;
	        var prev = null;
	        while (link !== null) {
	            if (link.value === value) {
	                if (prev === null) {
	                    this._front = link.next;
	                }
	                else {
	                    prev.next = link.next;
	                }
	                if (link.next === null) {
	                    this._back = prev;
	                }
	                this._size--;
	                return true;
	            }
	            prev = link;
	            link = link.next;
	        }
	        return false;
	    };
	    /**
	     * Remove all occurrences of a value from the queue.
	     *
	     * @param value - The value to remove from the queue.
	     *
	     * @returns The number of occurrences removed.
	     *
	     * #### Notes
	     * This has `O(N)` complexity.
	     */
	    Queue.prototype.removeAll = function (value) {
	        var count = 0;
	        var link = this._front;
	        var prev = null;
	        while (link !== null) {
	            if (link.value === value) {
	                count++;
	                this._size--;
	            }
	            else if (prev === null) {
	                this._front = link;
	                prev = link;
	            }
	            else {
	                prev.next = link;
	                prev = link;
	            }
	            link = link.next;
	        }
	        if (!prev) {
	            this._front = null;
	            this._back = null;
	        }
	        else {
	            prev.next = null;
	            this._back = prev;
	        }
	        return count;
	    };
	    /**
	     * Remove all values from the queue.
	     *
	     * #### Notes
	     * This has `O(1)` complexity.
	     */
	    Queue.prototype.clear = function () {
	        this._size = 0;
	        this._front = null;
	        this._back = null;
	    };
	    /**
	     * Create an array from the values in the queue.
	     *
	     * @returns An array of all values in the queue.
	     *
	     * #### Notes
	     * This has `O(N)` complexity.
	     */
	    Queue.prototype.toArray = function () {
	        var result = new Array(this._size);
	        for (var i = 0, link = this._front; link !== null; link = link.next, ++i) {
	            result[i] = link.value;
	        }
	        return result;
	    };
	    /**
	     * Test whether any value in the queue passes a predicate function.
	     *
	     * @param pred - The predicate to apply to the values.
	     *
	     * @returns `true` if any value in the queue passes the predicate,
	     *   or `false` otherwise.
	     *
	     * #### Notes
	     * This has `O(N)` complexity.
	     *
	     * It is **not** safe for the predicate to modify the queue while
	     * iterating.
	     */
	    Queue.prototype.some = function (pred) {
	        for (var i = 0, link = this._front; link !== null; link = link.next, ++i) {
	            if (pred(link.value, i))
	                return true;
	        }
	        return false;
	    };
	    /**
	     * Test whether all values in the queue pass a predicate function.
	     *
	     * @param pred - The predicate to apply to the values.
	     *
	     * @returns `true` if all values in the queue pass the predicate,
	     *   or `false` otherwise.
	     *
	     * #### Notes
	     * This has `O(N)` complexity.
	     *
	     * It is **not** safe for the predicate to modify the queue while
	     * iterating.
	     */
	    Queue.prototype.every = function (pred) {
	        for (var i = 0, link = this._front; link !== null; link = link.next, ++i) {
	            if (!pred(link.value, i))
	                return false;
	        }
	        return true;
	    };
	    /**
	     * Create an array of the values which pass a predicate function.
	     *
	     * @param pred - The predicate to apply to the values.
	     *
	     * @returns The array of values which pass the predicate.
	     *
	     * #### Notes
	     * This has `O(N)` complexity.
	     *
	     * It is **not** safe for the predicate to modify the queue while
	     * iterating.
	     */
	    Queue.prototype.filter = function (pred) {
	        var result = [];
	        for (var i = 0, link = this._front; link !== null; link = link.next, ++i) {
	            if (pred(link.value, i))
	                result.push(link.value);
	        }
	        return result;
	    };
	    /**
	     * Create an array of mapped values for the values in the queue.
	     *
	     * @param callback - The map function to apply to the values.
	     *
	     * @returns The array of values returned by the map function.
	     *
	     * #### Notes
	     * This has `O(N)` complexity.
	     *
	     * It is **not** safe for the callback to modify the queue while
	     * iterating.
	     */
	    Queue.prototype.map = function (callback) {
	        var result = new Array(this._size);
	        for (var i = 0, link = this._front; link !== null; link = link.next, ++i) {
	            result[i] = callback(link.value, i);
	        }
	        return result;
	    };
	    /**
	     * Execute a callback for each value in the queue.
	     *
	     * @param callback - The function to apply to the values.
	     *
	     * @returns The first value returned by the callback which is not
	     *   `undefined`.
	     *
	     * #### Notes
	     * This has `O(N)` complexity.
	     *
	     * Iteration will terminate immediately if the callback returns any
	     * value other than `undefined`.
	     *
	     * It is **not** safe for the callback to modify the queue while
	     * iterating.
	     */
	    Queue.prototype.forEach = function (callback) {
	        for (var i = 0, link = this._front; link !== null; link = link.next, ++i) {
	            var result = callback(link.value, i);
	            if (result !== void 0)
	                return result;
	        }
	        return void 0;
	    };
	    return Queue;
	})();
	exports.Queue = Queue;
	//# sourceMappingURL=index.js.map

/***/ },
/* 17 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	/**
	 * A property descriptor for a datum belonging to an object.
	 *
	 * Property descriptors can be used to expose a rich interface for an
	 * object which encapsulates value creation, coercion, and notification.
	 * They can also be used to extend the state of an object with semantic
	 * data from an unrelated class.
	 */
	var Property = (function () {
	    /**
	     * Construct a new property descriptor.
	     *
	     * @param options - The options for initializing the property.
	     */
	    function Property(options) {
	        this._pid = nextPID();
	        this._name = options.name;
	        this._value = options.value;
	        this._create = options.create;
	        this._coerce = options.coerce;
	        this._compare = options.compare;
	        this._changed = options.changed;
	        this._notify = options.notify;
	    }
	    Object.defineProperty(Property.prototype, "name", {
	        /**
	         * Get the human readable name for the property.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._name;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Property.prototype, "notify", {
	        /**
	         * Get the notify signal for the property.
	         *
	         * #### Notes
	         * This will be `undefined` if no notify signal was provided.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._notify;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the current value of the property for a given owner.
	     *
	     * @param owner - The property owner of interest.
	     *
	     * @returns The current value of the property.
	     *
	     * #### Notes
	     * If the value has not yet been set, the default value will be
	     * computed and assigned as the current value of the property.
	     */
	    Property.prototype.get = function (owner) {
	        var value;
	        var hash = lookupHash(owner);
	        if (this._pid in hash) {
	            value = hash[this._pid];
	        }
	        else {
	            value = hash[this._pid] = this._createValue(owner);
	        }
	        return value;
	    };
	    /**
	     * Set the current value of the property for a given owner.
	     *
	     * @param owner - The property owner of interest.
	     *
	     * @param value - The value for the property.
	     *
	     * #### Notes
	     * If the value has not yet been set, the default value will be
	     * computed and used as the previous value for the comparison.
	     */
	    Property.prototype.set = function (owner, value) {
	        var oldValue;
	        var hash = lookupHash(owner);
	        if (this._pid in hash) {
	            oldValue = hash[this._pid];
	        }
	        else {
	            oldValue = hash[this._pid] = this._createValue(owner);
	        }
	        var newValue = this._coerceValue(owner, value);
	        this._maybeNotify(owner, oldValue, hash[this._pid] = newValue);
	    };
	    /**
	     * Explicitly coerce the current property value for a given owner.
	     *
	     * @param owner - The property owner of interest.
	     *
	     * #### Notes
	     * If the value has not yet been set, the default value will be
	     * computed and used as the previous value for the comparison.
	     */
	    Property.prototype.coerce = function (owner) {
	        var oldValue;
	        var hash = lookupHash(owner);
	        if (this._pid in hash) {
	            oldValue = hash[this._pid];
	        }
	        else {
	            oldValue = hash[this._pid] = this._createValue(owner);
	        }
	        var newValue = this._coerceValue(owner, oldValue);
	        this._maybeNotify(owner, oldValue, hash[this._pid] = newValue);
	    };
	    /**
	     * Get or create the default value for the given owner.
	     */
	    Property.prototype._createValue = function (owner) {
	        var create = this._create;
	        return create ? create(owner) : this._value;
	    };
	    /**
	     * Coerce the value for the given owner.
	     */
	    Property.prototype._coerceValue = function (owner, value) {
	        var coerce = this._coerce;
	        return coerce ? coerce(owner, value) : value;
	    };
	    /**
	     * Compare the old value and new value for equality.
	     */
	    Property.prototype._compareValue = function (oldValue, newValue) {
	        var compare = this._compare;
	        return compare ? compare(oldValue, newValue) : oldValue === newValue;
	    };
	    /**
	     * Run the change notification if the given values are different.
	     */
	    Property.prototype._maybeNotify = function (owner, oldValue, newValue) {
	        var changed = this._changed;
	        var notify = this._notify;
	        if (!changed && !notify) {
	            return;
	        }
	        if (this._compareValue(oldValue, newValue)) {
	            return;
	        }
	        if (changed) {
	            changed(owner, oldValue, newValue);
	        }
	        if (notify) {
	            notify.bind(owner).emit({ name: this._name, oldValue: oldValue, newValue: newValue });
	        }
	    };
	    return Property;
	})();
	exports.Property = Property;
	/**
	 * Clear the stored property data for the given property owner.
	 *
	 * @param owner - The property owner of interest.
	 *
	 * #### Notes
	 * This will clear all property values for the owner, but it will
	 * **not** run the change notification for any of the properties.
	 */
	function clearPropertyData(owner) {
	    ownerData.delete(owner);
	}
	exports.clearPropertyData = clearPropertyData;
	/**
	 * A weak mapping of property owner to property hash.
	 */
	var ownerData = new WeakMap();
	/**
	 * A function which computes successive unique property ids.
	 */
	var nextPID = (function () { var id = 0; return function () { return 'pid-' + id++; }; })();
	/**
	 * Lookup the data hash for the property owner.
	 *
	 * This will create the hash if one does not already exist.
	 */
	function lookupHash(owner) {
	    var hash = ownerData.get(owner);
	    if (hash !== void 0)
	        return hash;
	    hash = Object.create(null);
	    ownerData.set(owner, hash);
	    return hash;
	}
	//# sourceMappingURL=index.js.map

/***/ },
/* 18 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(19));
	__export(__webpack_require__(28));


/***/ },
/* 19 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var arrays = __webpack_require__(3);
	var phosphor_messaging_1 = __webpack_require__(13);
	var phosphor_widget_1 = __webpack_require__(20);
	/**
	 * A concrete layout implementation suitable for many use cases.
	 *
	 * #### Notes
	 * This class is suitable as a base class for implementing a variety of
	 * layouts, but can also be used directly with standard CSS to layout a
	 * collection of widgets.
	 */
	var PanelLayout = (function (_super) {
	    __extends(PanelLayout, _super);
	    function PanelLayout() {
	        _super.apply(this, arguments);
	        this._children = [];
	    }
	    /**
	     * Dispose of the resources held by the layout.
	     *
	     * #### Notes
	     * This will dispose all current child widgets of the layout.
	     */
	    PanelLayout.prototype.dispose = function () {
	        while (this._children.length > 0) {
	            this._children.pop().dispose();
	        }
	        _super.prototype.dispose.call(this);
	    };
	    /**
	     * Get the number of child widgets in the layout.
	     *
	     * @returns The number of child widgets in the layout.
	     */
	    PanelLayout.prototype.childCount = function () {
	        return this._children.length;
	    };
	    /**
	     * Get the child widget at the specified index.
	     *
	     * @param index - The index of the child widget of interest.
	     *
	     * @returns The child at the specified index, or `undefined`.
	     */
	    PanelLayout.prototype.childAt = function (index) {
	        return this._children[index];
	    };
	    /**
	     * Add a child widget to the end of the layout.
	     *
	     * @param child - The child widget to add to the layout.
	     *
	     * #### Notes
	     * If the child is already contained in the layout, it will be moved.
	     */
	    PanelLayout.prototype.addChild = function (child) {
	        this.insertChild(this.childCount(), child);
	    };
	    /**
	     * Insert a child widget into the layout at the specified index.
	     *
	     * @param index - The index at which to insert the child widget.
	     *
	     * @param child - The child widget to insert into the layout.
	     *
	     * #### Notes
	     * If the child is already contained in the layout, it will be moved.
	     */
	    PanelLayout.prototype.insertChild = function (index, child) {
	        child.parent = this.parent;
	        var n = this._children.length;
	        var i = this._children.indexOf(child);
	        var j = Math.max(0, Math.min(index | 0, n));
	        if (i !== -1) {
	            if (j === n)
	                j--;
	            if (i === j)
	                return;
	            arrays.move(this._children, i, j);
	            if (this.parent)
	                this.moveChild(i, j, child);
	        }
	        else {
	            arrays.insert(this._children, j, child);
	            if (this.parent)
	                this.attachChild(j, child);
	        }
	    };
	    /**
	     * Remove a child widget from the layout.
	     *
	     * @param child - The child widget to remove from the layout.
	     *
	     * #### Notes
	     * A child widget will be removed from the layout automatically when
	     * its `parent` is set to `null`. This method should only be invoked
	     * directly when removing a widget from a layout which has yet to be
	     * installed on a parent widget.
	     *
	     * This method does *not* modify the widget's `parent`.
	     *
	     * If the child is not contained in the layout, this is a no-op.
	     */
	    PanelLayout.prototype.removeChild = function (child) {
	        var i = arrays.remove(this._children, child);
	        if (i !== -1 && this.parent)
	            this.detachChild(i, child);
	    };
	    /**
	     * Initialize the children of the layout.
	     *
	     * #### Notes
	     * This method is called automatically when the layout is installed
	     * on its parent widget.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    PanelLayout.prototype.initialize = function () {
	        for (var i = 0; i < this.childCount(); ++i) {
	            var child = this.childAt(i);
	            child.parent = this.parent;
	            this.attachChild(i, child);
	        }
	    };
	    /**
	     * Attach a child widget to the parent's DOM node.
	     *
	     * @param index - The current index of the child in the layout.
	     *
	     * @param child - The child widget to attach to the parent.
	     *
	     * #### Notes
	     * This method is called automatically by the panel layout at the
	     * appropriate time. It should not be called directly by user code.
	     *
	     * The default implementation adds the child's node to the parent's
	     * node at the proper location, and sends an `'after-attach'` message
	     * to the child if the parent is attached to the DOM.
	     *
	     * Subclasses may reimplement this method to control how the child's
	     * node is added to the parent's node, but the reimplementation must
	     * send an `'after-attach'` message to the child if the parent is
	     * attached to the DOM.
	     */
	    PanelLayout.prototype.attachChild = function (index, child) {
	        var ref = this.parent.node.children[index];
	        this.parent.node.insertBefore(child.node, ref);
	        if (this.parent.isAttached)
	            phosphor_messaging_1.sendMessage(child, phosphor_widget_1.Widget.MsgAfterAttach);
	    };
	    /**
	     * Move a child widget in the parent's DOM node.
	     *
	     * @param fromIndex - The previous index of the child in the layout.
	     *
	     * @param toIndex - The current index of the child in the layout.
	     *
	     * @param child - The child widget to move in the parent.
	     *
	     * #### Notes
	     * This method is called automatically by the panel layout at the
	     * appropriate time. It should not be called directly by user code.
	     *
	     * The default implementation moves the child's node to the proper
	     * location in the parent's node and sends both a `'before-detach'`
	     * and an `'after-attach'` message to the child if the parent is
	     * attached to the DOM.
	     *
	     * Subclasses may reimplement this method to control how the child's
	     * node is moved in the parent's node, but the reimplementation must
	     * send both a `'before-detach'` and an `'after-attach'` message to
	     * the child if the parent is attached to the DOM.
	     */
	    PanelLayout.prototype.moveChild = function (fromIndex, toIndex, child) {
	        if (this.parent.isAttached)
	            phosphor_messaging_1.sendMessage(child, phosphor_widget_1.Widget.MsgBeforeDetach);
	        this.parent.node.removeChild(child.node);
	        var ref = this.parent.node.children[toIndex];
	        this.parent.node.insertBefore(child.node, ref);
	        if (this.parent.isAttached)
	            phosphor_messaging_1.sendMessage(child, phosphor_widget_1.Widget.MsgAfterAttach);
	    };
	    /**
	     * Detach a child widget from the parent's DOM node.
	     *
	     * @param index - The previous index of the child in the layout.
	     *
	     * @param child - The child widget to detach from the parent.
	     *
	     * #### Notes
	     * This method is called automatically by the panel layout at the
	     * appropriate time. It should not be called directly by user code.
	     *
	     * The default implementation removes the child's node from the
	     * parent's node, and sends a `'before-detach'` message to the child
	     * if the parent is attached to the DOM.
	     *
	     * Subclasses may reimplement this method to control how the child's
	     * node is removed from the parent's node, but the reimplementation
	     * must send a `'before-detach'` message to the child if the parent
	     * is attached to the DOM.
	     */
	    PanelLayout.prototype.detachChild = function (index, child) {
	        if (this.parent.isAttached)
	            phosphor_messaging_1.sendMessage(child, phosphor_widget_1.Widget.MsgBeforeDetach);
	        this.parent.node.removeChild(child.node);
	    };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     *
	     * #### Notes
	     * This will remove the child from the layout.
	     *
	     * Subclasses should **not** typically reimplement this method.
	     */
	    PanelLayout.prototype.onChildRemoved = function (msg) {
	        this.removeChild(msg.child);
	    };
	    return PanelLayout;
	})(phosphor_widget_1.AbstractLayout);
	exports.PanelLayout = PanelLayout;


/***/ },
/* 20 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(21));
	__export(__webpack_require__(25));
	__export(__webpack_require__(23));
	__webpack_require__(26);


/***/ },
/* 21 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var phosphor_messaging_1 = __webpack_require__(13);
	var phosphor_properties_1 = __webpack_require__(17);
	var phosphor_signaling_1 = __webpack_require__(22);
	var widget_1 = __webpack_require__(23);
	/**
	 * The abstract base class of all Phosphor layouts.
	 *
	 * #### Notes
	 * A layout is used to add child widgets to a parent and to arrange
	 * those children within the parent's node.
	 *
	 * This class must be subclassed to make a fully functioning layout.
	 */
	var Layout = (function () {
	    function Layout() {
	        this._disposed = false;
	        this._parent = null;
	    }
	    /**
	     * Dispose of the resources held by the layout.
	     *
	     * #### Notes
	     * This method should be reimplemented by subclasses to dispose their
	     * children. All reimplementations should call the superclass method.
	     */
	    Layout.prototype.dispose = function () {
	        this._disposed = true;
	        this._parent = null;
	        phosphor_signaling_1.clearSignalData(this);
	        phosphor_properties_1.clearPropertyData(this);
	    };
	    Object.defineProperty(Layout.prototype, "isDisposed", {
	        /**
	         * Test whether the layout is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._disposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Layout.prototype, "parent", {
	        /**
	         * Get the parent widget of the layout.
	         */
	        get: function () {
	            return this._parent;
	        },
	        /**
	         * Set the parent widget of the layout.
	         *
	         * #### Notes
	         * This is set automatically when installing the layout on the parent
	         * widget. The layout parent should not be set directly by user code.
	         */
	        set: function (value) {
	            if (!value) {
	                throw new Error('Cannot set layout parent to null.');
	            }
	            if (this._parent === value) {
	                return;
	            }
	            if (this._parent) {
	                throw new Error('Cannot change layout parent.');
	            }
	            if (value.layout !== this) {
	                throw new Error('Invalid layout parent.');
	            }
	            this._parent = value;
	            this.initialize();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Process a message sent to the parent widget.
	     *
	     * @param msg - The message sent to the parent widget.
	     *
	     * #### Notes
	     * This method is called by the parent to process a message.
	     *
	     * Subclasses may reimplement this method as needed.
	     */
	    Layout.prototype.processParentMessage = function (msg) {
	        switch (msg.type) {
	            case 'resize':
	                this.onResize(msg);
	                break;
	            case 'update-request':
	                this.onUpdateRequest(msg);
	                break;
	            case 'fit-request':
	                this.onFitRequest(msg);
	                break;
	            case 'after-attach':
	                this.onAfterAttach(msg);
	                break;
	            case 'before-detach':
	                this.onBeforeDetach(msg);
	                break;
	            case 'after-show':
	                this.onAfterShow(msg);
	                break;
	            case 'before-hide':
	                this.onBeforeHide(msg);
	                break;
	            case 'child-removed':
	                this.onChildRemoved(msg);
	                break;
	            case 'child-shown':
	                this.onChildShown(msg);
	                break;
	            case 'child-hidden':
	                this.onChildHidden(msg);
	                break;
	        }
	    };
	    /**
	     * A message handler invoked on a `'fit-request'` message.
	     *
	     * The default implementation of this handler is a no-op.
	     */
	    Layout.prototype.onFitRequest = function (msg) { };
	    /**
	     * A message handler invoked on a `'child-shown'` message.
	     *
	     * The default implementation of this handler is a no-op.
	     */
	    Layout.prototype.onChildShown = function (msg) { };
	    /**
	     * A message handler invoked on a `'child-hidden'` message.
	     *
	     * The default implementation of this handler is a no-op.
	     */
	    Layout.prototype.onChildHidden = function (msg) { };
	    return Layout;
	})();
	exports.Layout = Layout;
	/**
	 * An abstract base class for creating index-based layouts.
	 *
	 * #### Notes
	 * This class implements core functionality which is required by nearly
	 * all layouts. It is a good starting point for creating custom layouts
	 * which control the types of children that may be added to the layout.
	 *
	 * This class must be subclassed to make a fully functioning layout.
	 */
	var AbstractLayout = (function (_super) {
	    __extends(AbstractLayout, _super);
	    function AbstractLayout() {
	        _super.apply(this, arguments);
	    }
	    /**
	     * Get the index of the specified child widget.
	     *
	     * @param child - The child widget of interest.
	     *
	     * @returns The index of the specified child, or `-1`.
	     */
	    AbstractLayout.prototype.childIndex = function (child) {
	        for (var i = 0; i < this.childCount(); ++i) {
	            if (this.childAt(i) === child)
	                return i;
	        }
	        return -1;
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     *
	     * #### Notes
	     * The default implementation of this method sends an `UnknownSize`
	     * resize message to all children.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    AbstractLayout.prototype.onResize = function (msg) {
	        for (var i = 0; i < this.childCount(); ++i) {
	            phosphor_messaging_1.sendMessage(this.childAt(i), widget_1.ResizeMessage.UnknownSize);
	        }
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     *
	     * #### Notes
	     * The default implementation of this method sends an `UnknownSize`
	     * resize message to all children.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    AbstractLayout.prototype.onUpdateRequest = function (msg) {
	        for (var i = 0; i < this.childCount(); ++i) {
	            phosphor_messaging_1.sendMessage(this.childAt(i), widget_1.ResizeMessage.UnknownSize);
	        }
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     *
	     * #### Notes
	     * The default implementation of this method forwards the message
	     * to all children.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    AbstractLayout.prototype.onAfterAttach = function (msg) {
	        for (var i = 0; i < this.childCount(); ++i) {
	            phosphor_messaging_1.sendMessage(this.childAt(i), msg);
	        }
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     *
	     * #### Notes
	     * The default implementation of this method forwards the message
	     * to all children.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    AbstractLayout.prototype.onBeforeDetach = function (msg) {
	        for (var i = 0; i < this.childCount(); ++i) {
	            phosphor_messaging_1.sendMessage(this.childAt(i), msg);
	        }
	    };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     *
	     * #### Notes
	     * The default implementation of this method forwards the message
	     * to all non-hidden children.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    AbstractLayout.prototype.onAfterShow = function (msg) {
	        for (var i = 0; i < this.childCount(); ++i) {
	            var child = this.childAt(i);
	            if (!child.isHidden)
	                phosphor_messaging_1.sendMessage(child, msg);
	        }
	    };
	    /**
	     * A message handler invoked on a `'before-hide'` message.
	     *
	     * #### Notes
	     * The default implementation of this method forwards the message
	     * to all non-hidden children.
	     *
	     * This may be reimplemented by subclasses as needed.
	     */
	    AbstractLayout.prototype.onBeforeHide = function (msg) {
	        for (var i = 0; i < this.childCount(); ++i) {
	            var child = this.childAt(i);
	            if (!child.isHidden)
	                phosphor_messaging_1.sendMessage(child, msg);
	        }
	    };
	    return AbstractLayout;
	})(Layout);
	exports.AbstractLayout = AbstractLayout;


/***/ },
/* 22 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	/**
	 * An object used for type-safe inter-object communication.
	 *
	 * #### Notes
	 * Signals provide a type-safe implementation of the publish-subscribe
	 * pattern. An object (publisher) declares which signals it will emit,
	 * and consumers connect callbacks (subscribers) to those signals. The
	 * subscribers are invoked whenever the publisher emits the signal.
	 *
	 * A `Signal` object must be bound to a sender in order to be useful.
	 * A common pattern is to declare a `Signal` object as a static class
	 * member, along with a convenience getter which binds the signal to
	 * the `this` instance on-demand.
	 *
	 * #### Example
	 * ```typescript
	 * import { ISignal, Signal } from 'phosphor-signaling';
	 *
	 * class MyClass {
	 *
	 *   static valueChangedSignal = new Signal<MyClass, number>();
	 *
	 *   constructor(name: string) {
	 *     this._name = name;
	 *   }
	 *
	 *   get valueChanged(): ISignal<MyClass, number> {
	 *     return MyClass.valueChangedSignal.bind(this);
	 *   }
	 *
	 *   get name(): string {
	 *     return this._name;
	 *   }
	 *
	 *   get value(): number {
	 *     return this._value;
	 *   }
	 *
	 *   set value(value: number) {
	 *     if (value !== this._value) {
	 *       this._value = value;
	 *       this.valueChanged.emit(value);
	 *     }
	 *   }
	 *
	 *   private _name: string;
	 *   private _value = 0;
	 * }
	 *
	 * function logger(sender: MyClass, value: number): void {
	 *   console.log(sender.name, value);
	 * }
	 *
	 * let m1 = new MyClass('foo');
	 * let m2 = new MyClass('bar');
	 *
	 * m1.valueChanged.connect(logger);
	 * m2.valueChanged.connect(logger);
	 *
	 * m1.value = 42;  // logs: foo 42
	 * m2.value = 17;  // logs: bar 17
	 * ```
	 */
	var Signal = (function () {
	    function Signal() {
	    }
	    /**
	     * Bind the signal to a specific sender.
	     *
	     * @param sender - The sender object to bind to the signal.
	     *
	     * @returns The bound signal object which can be used for connecting,
	     *   disconnecting, and emitting the signal.
	     */
	    Signal.prototype.bind = function (sender) {
	        return new BoundSignal(this, sender);
	    };
	    return Signal;
	})();
	exports.Signal = Signal;
	/**
	 * Remove all connections where the given object is the sender.
	 *
	 * @param sender - The sender object of interest.
	 *
	 * #### Example
	 * ```typescript
	 * disconnectSender(someObject);
	 * ```
	 */
	function disconnectSender(sender) {
	    var list = senderMap.get(sender);
	    if (!list) {
	        return;
	    }
	    var conn = list.first;
	    while (conn !== null) {
	        removeFromSendersList(conn);
	        conn.callback = null;
	        conn.thisArg = null;
	        conn = conn.nextReceiver;
	    }
	    senderMap.delete(sender);
	}
	exports.disconnectSender = disconnectSender;
	/**
	 * Remove all connections where the given object is the receiver.
	 *
	 * @param receiver - The receiver object of interest.
	 *
	 * #### Notes
	 * If a `thisArg` is provided when connecting a signal, that object
	 * is considered the receiver. Otherwise, the `callback` is used as
	 * the receiver.
	 *
	 * #### Example
	 * ```typescript
	 * // disconnect a regular object receiver
	 * disconnectReceiver(myObject);
	 *
	 * // disconnect a plain callback receiver
	 * disconnectReceiver(myCallback);
	 * ```
	 */
	function disconnectReceiver(receiver) {
	    var conn = receiverMap.get(receiver);
	    if (!conn) {
	        return;
	    }
	    while (conn !== null) {
	        var next = conn.nextSender;
	        conn.callback = null;
	        conn.thisArg = null;
	        conn.prevSender = null;
	        conn.nextSender = null;
	        conn = next;
	    }
	    receiverMap.delete(receiver);
	}
	exports.disconnectReceiver = disconnectReceiver;
	/**
	 * Clear all signal data associated with the given object.
	 *
	 * @param obj - The object for which the signal data should be cleared.
	 *
	 * #### Notes
	 * This removes all signal connections where the object is used as
	 * either the sender or the receiver.
	 *
	 * #### Example
	 * ```typescript
	 * clearSignalData(someObject);
	 * ```
	 */
	function clearSignalData(obj) {
	    disconnectSender(obj);
	    disconnectReceiver(obj);
	}
	exports.clearSignalData = clearSignalData;
	/**
	 * A concrete implementation of ISignal.
	 */
	var BoundSignal = (function () {
	    /**
	     * Construct a new bound signal.
	     */
	    function BoundSignal(signal, sender) {
	        this._signal = signal;
	        this._sender = sender;
	    }
	    /**
	     * Connect a callback to the signal.
	     */
	    BoundSignal.prototype.connect = function (callback, thisArg) {
	        return connect(this._sender, this._signal, callback, thisArg);
	    };
	    /**
	     * Disconnect a callback from the signal.
	     */
	    BoundSignal.prototype.disconnect = function (callback, thisArg) {
	        return disconnect(this._sender, this._signal, callback, thisArg);
	    };
	    /**
	     * Emit the signal and invoke the connected callbacks.
	     */
	    BoundSignal.prototype.emit = function (args) {
	        emit(this._sender, this._signal, args);
	    };
	    return BoundSignal;
	})();
	/**
	 * A struct which holds connection data.
	 */
	var Connection = (function () {
	    function Connection() {
	        /**
	         * The signal for the connection.
	         */
	        this.signal = null;
	        /**
	         * The callback connected to the signal.
	         */
	        this.callback = null;
	        /**
	         * The `this` context for the callback.
	         */
	        this.thisArg = null;
	        /**
	         * The next connection in the singly linked receivers list.
	         */
	        this.nextReceiver = null;
	        /**
	         * The next connection in the doubly linked senders list.
	         */
	        this.nextSender = null;
	        /**
	         * The previous connection in the doubly linked senders list.
	         */
	        this.prevSender = null;
	    }
	    return Connection;
	})();
	/**
	 * The list of receiver connections for a specific sender.
	 */
	var ConnectionList = (function () {
	    function ConnectionList() {
	        /**
	         * The ref count for the list.
	         */
	        this.refs = 0;
	        /**
	         * The first connection in the list.
	         */
	        this.first = null;
	        /**
	         * The last connection in the list.
	         */
	        this.last = null;
	    }
	    return ConnectionList;
	})();
	/**
	 * A mapping of sender object to its receiver connection list.
	 */
	var senderMap = new WeakMap();
	/**
	 * A mapping of receiver object to its sender connection list.
	 */
	var receiverMap = new WeakMap();
	/**
	 * Create a connection between a sender, signal, and callback.
	 */
	function connect(sender, signal, callback, thisArg) {
	    // Coerce a `null` thisArg to `undefined`.
	    thisArg = thisArg || void 0;
	    // Search for an equivalent connection and bail if one exists.
	    var list = senderMap.get(sender);
	    if (list && findConnection(list, signal, callback, thisArg)) {
	        return false;
	    }
	    // Create a new connection.
	    var conn = new Connection();
	    conn.signal = signal;
	    conn.callback = callback;
	    conn.thisArg = thisArg;
	    // Add the connection to the receivers list.
	    if (!list) {
	        list = new ConnectionList();
	        list.first = conn;
	        list.last = conn;
	        senderMap.set(sender, list);
	    }
	    else if (list.last === null) {
	        list.first = conn;
	        list.last = conn;
	    }
	    else {
	        list.last.nextReceiver = conn;
	        list.last = conn;
	    }
	    // Add the connection to the senders list.
	    var receiver = thisArg || callback;
	    var head = receiverMap.get(receiver);
	    if (head) {
	        head.prevSender = conn;
	        conn.nextSender = head;
	    }
	    receiverMap.set(receiver, conn);
	    return true;
	}
	/**
	 * Break the connection between a sender, signal, and callback.
	 */
	function disconnect(sender, signal, callback, thisArg) {
	    // Coerce a `null` thisArg to `undefined`.
	    thisArg = thisArg || void 0;
	    // Search for an equivalent connection and bail if none exists.
	    var list = senderMap.get(sender);
	    if (!list) {
	        return false;
	    }
	    var conn = findConnection(list, signal, callback, thisArg);
	    if (!conn) {
	        return false;
	    }
	    // Remove the connection from the senders list. It will be removed
	    // from the receivers list the next time the signal is emitted.
	    removeFromSendersList(conn);
	    // Clear the connection data so it becomes a dead connection.
	    conn.callback = null;
	    conn.thisArg = null;
	    return true;
	}
	/**
	 * Emit a signal and invoke the connected callbacks.
	 */
	function emit(sender, signal, args) {
	    // If there is no connection list, there is nothing to do.
	    var list = senderMap.get(sender);
	    if (!list) {
	        return;
	    }
	    // Prepare to dispatch the callbacks. Increment the reference count
	    // on the list so that the list is cleaned only when the emit stack
	    // is fully unwound.
	    list.refs++;
	    var dirty = false;
	    var last = list.last;
	    var conn = list.first;
	    // Dispatch the callbacks. If a connection has a null callback, it
	    // indicates the list is dirty. Connections which match the signal
	    // are safely dispatched where all exceptions are logged. Dispatch
	    // is stopped at the last connection for the current stack frame.
	    while (conn !== null) {
	        if (!conn.callback) {
	            dirty = true;
	        }
	        else if (conn.signal === signal) {
	            safeInvoke(conn, sender, args);
	        }
	        if (conn === last) {
	            break;
	        }
	        conn = conn.nextReceiver;
	    }
	    // Decrement the reference count on the list.
	    list.refs--;
	    // Clean the list if it's dirty and the emit stack is fully unwound.
	    if (dirty && list.refs === 0) {
	        cleanList(list);
	    }
	}
	/**
	 * Safely invoke the callback for the given connection.
	 *
	 * Exceptions thrown by the callback will be caught and logged.
	 */
	function safeInvoke(conn, sender, args) {
	    try {
	        conn.callback.call(conn.thisArg, sender, args);
	    }
	    catch (err) {
	        console.error('Exception in signal handler:', err);
	    }
	}
	/**
	 * Find a matching connection in the given connection list.
	 *
	 * Returns `null` if no matching connection is found.
	 */
	function findConnection(list, signal, callback, thisArg) {
	    var conn = list.first;
	    while (conn !== null) {
	        if (conn.signal === signal &&
	            conn.callback === callback &&
	            conn.thisArg === thisArg) {
	            return conn;
	        }
	        conn = conn.nextReceiver;
	    }
	    return null;
	}
	/**
	 * Remove the dead connections from the given connection list.
	 */
	function cleanList(list) {
	    var prev;
	    var conn = list.first;
	    while (conn !== null) {
	        var next = conn.nextReceiver;
	        if (!conn.callback) {
	            conn.nextReceiver = null;
	        }
	        else if (!prev) {
	            list.first = conn;
	            prev = conn;
	        }
	        else {
	            prev.nextReceiver = conn;
	            prev = conn;
	        }
	        conn = next;
	    }
	    if (!prev) {
	        list.first = null;
	        list.last = null;
	    }
	    else {
	        prev.nextReceiver = null;
	        list.last = prev;
	    }
	}
	/**
	 * Remove a connection from the doubly linked list of senders.
	 */
	function removeFromSendersList(conn) {
	    var receiver = conn.thisArg || conn.callback;
	    if (!receiver) {
	        return;
	    }
	    var prev = conn.prevSender;
	    var next = conn.nextSender;
	    if (prev === null && next === null) {
	        receiverMap.delete(receiver);
	    }
	    else if (prev === null) {
	        receiverMap.set(receiver, next);
	        next.prevSender = null;
	    }
	    else if (next === null) {
	        prev.nextSender = null;
	    }
	    else {
	        prev.nextSender = next;
	        next.prevSender = prev;
	    }
	    conn.prevSender = null;
	    conn.nextSender = null;
	}
	//# sourceMappingURL=index.js.map

/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var phosphor_messaging_1 = __webpack_require__(13);
	var phosphor_nodewrapper_1 = __webpack_require__(24);
	var phosphor_properties_1 = __webpack_require__(17);
	var phosphor_signaling_1 = __webpack_require__(22);
	var title_1 = __webpack_require__(25);
	/**
	 * The class name added to Widget instances.
	 */
	var WIDGET_CLASS = 'p-Widget';
	/**
	 * The class name added to hidden widgets.
	 */
	var HIDDEN_CLASS = 'p-mod-hidden';
	/**
	 * The base class of the Phosphor widget hierarchy.
	 *
	 * #### Notes
	 * This class will typically be subclassed in order to create a useful
	 * widget. However, it can be used directly to host externally created
	 * content. Simply instantiate an empty widget and add the DOM content
	 * directly to the widget's `.node`.
	 */
	var Widget = (function (_super) {
	    __extends(Widget, _super);
	    /**
	     * Construct a new widget.
	     */
	    function Widget() {
	        _super.call(this);
	        this._flags = 0;
	        this._layout = null;
	        this._parent = null;
	        this.addClass(WIDGET_CLASS);
	    }
	    /**
	     * Dispose of the widget and its descendants.
	     *
	     * #### Notes
	     * It is generally unsafe to use the widget after it is disposed.
	     *
	     * All calls made to this method after the first are a no-op.
	     */
	    Widget.prototype.dispose = function () {
	        // Do nothing if the widget is already disposed.
	        if (this.isDisposed) {
	            return;
	        }
	        // Set the disposed flag and emit the disposed signal.
	        this.setFlag(WidgetFlag.IsDisposed);
	        this.disposed.emit(void 0);
	        // Remove or detach the widget if necessary.
	        if (this.parent) {
	            this.parent = null;
	        }
	        else if (this.isAttached) {
	            this.detach();
	        }
	        // Dispose of the widget layout.
	        if (this._layout) {
	            this._layout.dispose();
	            this._layout = null;
	        }
	        // Clear the attached data associated with the widget.
	        phosphor_signaling_1.clearSignalData(this);
	        phosphor_messaging_1.clearMessageData(this);
	        phosphor_properties_1.clearPropertyData(this);
	    };
	    Object.defineProperty(Widget.prototype, "disposed", {
	        /**
	         * A signal emitted when the widget is disposed.
	         *
	         * **See also:** [[dispose]], [[disposed]]
	         */
	        get: function () {
	            return WidgetPrivate.disposedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "isDisposed", {
	        /**
	         * Test whether the widget has been disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * **See also:** [[dispose]], [[disposed]]
	         */
	        get: function () {
	            return this.testFlag(WidgetFlag.IsDisposed);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "isAttached", {
	        /**
	         * Test whether the widget's node is attached to the DOM.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * **See also:** [[attach]], [[detach]]
	         */
	        get: function () {
	            return this.testFlag(WidgetFlag.IsAttached);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "isHidden", {
	        /**
	         * Test whether the widget is explicitly hidden.
	         *
	         * #### Notes
	         * This is a read-only property.
	         *
	         * **See also:** [[isVisible]], [[hide]], [[show]]
	         */
	        get: function () {
	            return this.testFlag(WidgetFlag.IsHidden);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "isVisible", {
	        /**
	         * Test whether the widget is visible.
	         *
	         * #### Notes
	         * A widget is visible when it is attached to the DOM, is not
	         * explicitly hidden, and has no explicitly hidden ancestors.
	         *
	         * This is a read-only property.
	         *
	         * **See also:** [[isHidden]], [[hide]], [[show]]
	         */
	        get: function () {
	            return this.testFlag(WidgetFlag.IsVisible);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "title", {
	        /**
	         * Get the title data object for the widget.
	         *
	         * #### Notes
	         * The title data is used by some container widgets when displaying
	         * the widget along with a title, such as a tab panel or dock panel.
	         *
	         * Not all widgets will make use of the title data, so it is created
	         * on-demand the first time it is accessed.
	         */
	        get: function () {
	            return WidgetPrivate.titleProperty.get(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "parent", {
	        /**
	         * Get the parent of the widget.
	         *
	         * #### Notes
	         * This will be `null` if the widget does not have a parent.
	         */
	        get: function () {
	            return this._parent;
	        },
	        /**
	         * Set the parent of the widget.
	         *
	         * #### Notes
	         * The widget will be automatically removed from its current parent.
	         *
	         * This is a no-op if there is no effective parent change.
	         */
	        set: function (value) {
	            value = value || null;
	            if (this._parent === value) {
	                return;
	            }
	            if (value && this.contains(value)) {
	                throw new Error('Invalid parent widget.');
	            }
	            if (this._parent && !this._parent.isDisposed) {
	                phosphor_messaging_1.sendMessage(this._parent, new ChildMessage('child-removed', this));
	            }
	            this._parent = value;
	            if (this._parent && !this._parent.isDisposed) {
	                phosphor_messaging_1.sendMessage(this._parent, new ChildMessage('child-added', this));
	            }
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Widget.prototype, "layout", {
	        /**
	         * Get the layout for the widget.
	         *
	         * #### Notes
	         * This will be `null` if the widget does not have a layout.
	         */
	        get: function () {
	            return this._layout;
	        },
	        /**
	         * Set the layout for the widget.
	         *
	         * #### Notes
	         * The layout is single-use only. It cannot be set to `null` and it
	         * cannot be changed after the first assignment.
	         *
	         * The layout is disposed automatically when the widget is disposed.
	         */
	        set: function (value) {
	            if (!value) {
	                throw new Error('Cannot set widget layout to null.');
	            }
	            if (this._layout === value) {
	                return;
	            }
	            if (this._layout) {
	                throw new Error('Cannot change widget layout.');
	            }
	            if (value.parent) {
	                throw new Error('Cannot change layout parent.');
	            }
	            this._layout = value;
	            value.parent = this;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Test whether a widget is a descendant of this widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns `true` if the widget is a descendant, `false` otherwise.
	     */
	    Widget.prototype.contains = function (widget) {
	        while (widget) {
	            if (widget === this) {
	                return true;
	            }
	            widget = widget._parent;
	        }
	        return false;
	    };
	    /**
	     * Post an `'update-request'` message to the widget.
	     *
	     * **See also:** [[MsgUpdateRequest]]
	     */
	    Widget.prototype.update = function () {
	        phosphor_messaging_1.postMessage(this, Widget.MsgUpdateRequest);
	    };
	    /**
	     * Post a `'fit-request'` message to the widget.
	     *
	     * **See also:** [[MsgFitRequest]]
	     */
	    Widget.prototype.fit = function () {
	        phosphor_messaging_1.postMessage(this, Widget.MsgFitRequest);
	    };
	    /**
	     * Send a `'close-request'` message to the widget.
	     *
	     * **See also:** [[MsgCloseRequest]]
	     */
	    Widget.prototype.close = function () {
	        phosphor_messaging_1.sendMessage(this, Widget.MsgCloseRequest);
	    };
	    /**
	     * Show the widget and make it visible to its parent widget.
	     *
	     * #### Notes
	     * This causes the [[isHidden]] property to be `false`.
	     */
	    Widget.prototype.show = function () {
	        if (!this.testFlag(WidgetFlag.IsHidden)) {
	            return;
	        }
	        this.clearFlag(WidgetFlag.IsHidden);
	        this.removeClass(HIDDEN_CLASS);
	        if (this.isAttached && (!this.parent || this.parent.isVisible)) {
	            phosphor_messaging_1.sendMessage(this, Widget.MsgAfterShow);
	        }
	        if (this.parent) {
	            phosphor_messaging_1.sendMessage(this.parent, new ChildMessage('child-shown', this));
	        }
	    };
	    /**
	     * Hide the widget and make it hidden to its parent widget.
	     *
	     * #### Notes
	     * This causes the [[isHidden]] property to be `true`.
	     */
	    Widget.prototype.hide = function () {
	        if (this.testFlag(WidgetFlag.IsHidden)) {
	            return;
	        }
	        this.setFlag(WidgetFlag.IsHidden);
	        if (this.isAttached && (!this.parent || this.parent.isVisible)) {
	            phosphor_messaging_1.sendMessage(this, Widget.MsgBeforeHide);
	        }
	        this.addClass(HIDDEN_CLASS);
	        if (this.parent) {
	            phosphor_messaging_1.sendMessage(this.parent, new ChildMessage('child-hidden', this));
	        }
	    };
	    /**
	     * Set whether the widget is hidden.
	     *
	     * @param hidden - `true` to hide the widget, or `false` to show it.
	     *
	     * #### Notes
	     * `widget.setHidden(true)` is equivalent to `widget.hide()`, and
	     * `widget.setHidden(false)` is equivalent to `widget.show()`.
	     */
	    Widget.prototype.setHidden = function (hidden) {
	        if (hidden) {
	            this.hide();
	        }
	        else {
	            this.show();
	        }
	    };
	    /**
	     * Attach the widget to a host DOM node.
	     *
	     * @param host - The DOM node to use as the widget's host.
	     *
	     * @throws An error if the widget is not a root widget, if the widget
	     *   is already attached, or if the host is not attached to the DOM.
	     */
	    Widget.prototype.attach = function (host) {
	        if (this.parent) {
	            throw new Error('Cannot attach child widget.');
	        }
	        if (this.isAttached || document.body.contains(this.node)) {
	            throw new Error('Widget already attached.');
	        }
	        if (!document.body.contains(host)) {
	            throw new Error('Host not attached.');
	        }
	        host.appendChild(this.node);
	        phosphor_messaging_1.sendMessage(this, Widget.MsgAfterAttach);
	    };
	    /**
	     * Detach the widget from its host DOM node.
	     *
	     * @throws An error if the widget is not a root widget, or if the
	     *   widget is not attached.
	     */
	    Widget.prototype.detach = function () {
	        if (this.parent) {
	            throw new Error('Cannot detach child widget.');
	        }
	        if (!this.isAttached || !document.body.contains(this.node)) {
	            throw new Error('Widget not attached.');
	        }
	        phosphor_messaging_1.sendMessage(this, Widget.MsgBeforeDetach);
	        this.node.parentNode.removeChild(this.node);
	    };
	    /**
	     * Test whether the given widget flag is set.
	     *
	     * #### Notes
	     * This will not typically be consumed directly by user code.
	     */
	    Widget.prototype.testFlag = function (flag) {
	        return (this._flags & flag) !== 0;
	    };
	    /**
	     * Set the given widget flag.
	     *
	     * #### Notes
	     * This will not typically be consumed directly by user code.
	     */
	    Widget.prototype.setFlag = function (flag) {
	        this._flags |= flag;
	    };
	    /**
	     * Clear the given widget flag.
	     *
	     * #### Notes
	     * This will not typically be consumed directly by user code.
	     */
	    Widget.prototype.clearFlag = function (flag) {
	        this._flags &= ~flag;
	    };
	    /**
	     * Compress a message posted to the widget.
	     *
	     * @param msg - The message posted to the widget.
	     *
	     * @param pending - The queue of pending messages for the widget.
	     *
	     * @returns `true` if the message should be ignored, or `false` if
	     *   the message should be enqueued for delivery as normal.
	     *
	     * #### Notes
	     * Subclasses may reimplement this method as needed.
	     */
	    Widget.prototype.compressMessage = function (msg, pending) {
	        if (msg.type === 'update-request') {
	            return pending.some(function (other) { return other.type === 'update-request'; });
	        }
	        if (msg.type === 'fit-request') {
	            return pending.some(function (other) { return other.type === 'fit-request'; });
	        }
	        return false;
	    };
	    /**
	     * Process a message sent to the widget.
	     *
	     * @param msg - The message sent to the widget.
	     *
	     * #### Notes
	     * Subclasses may reimplement this method as needed.
	     */
	    Widget.prototype.processMessage = function (msg) {
	        switch (msg.type) {
	            case 'resize':
	                this.notifyLayout(msg);
	                this.onResize(msg);
	                break;
	            case 'update-request':
	                this.notifyLayout(msg);
	                this.onUpdateRequest(msg);
	                break;
	            case 'after-show':
	                this.setFlag(WidgetFlag.IsVisible);
	                this.notifyLayout(msg);
	                this.onAfterShow(msg);
	                break;
	            case 'before-hide':
	                this.notifyLayout(msg);
	                this.onBeforeHide(msg);
	                this.clearFlag(WidgetFlag.IsVisible);
	                break;
	            case 'after-attach':
	                var visible = !this.isHidden && (!this.parent || this.parent.isVisible);
	                if (visible)
	                    this.setFlag(WidgetFlag.IsVisible);
	                this.setFlag(WidgetFlag.IsAttached);
	                this.notifyLayout(msg);
	                this.onAfterAttach(msg);
	                break;
	            case 'before-detach':
	                this.notifyLayout(msg);
	                this.onBeforeDetach(msg);
	                this.clearFlag(WidgetFlag.IsVisible);
	                this.clearFlag(WidgetFlag.IsAttached);
	                break;
	            case 'close-request':
	                this.notifyLayout(msg);
	                this.onCloseRequest(msg);
	                break;
	            case 'child-added':
	                this.notifyLayout(msg);
	                this.onChildAdded(msg);
	                break;
	            case 'child-removed':
	                this.notifyLayout(msg);
	                this.onChildRemoved(msg);
	                break;
	            default:
	                this.notifyLayout(msg);
	                break;
	        }
	    };
	    /**
	     * Invoke the message processing routine of the widget's layout.
	     *
	     * @param msg - The message to dispatch to the layout.
	     *
	     * #### Notes
	     * This is a no-op if the widget does not have a layout.
	     */
	    Widget.prototype.notifyLayout = function (msg) {
	        if (this.layout)
	            this.layout.processParentMessage(msg);
	    };
	    /**
	     * A message handler invoked on a `'close-request'` message.
	     *
	     * #### Notes
	     * The default implementation of this handler detaches the widget.
	     *
	     * **See also:** [[close]], [[MsgCloseRequest]]
	     */
	    Widget.prototype.onCloseRequest = function (msg) {
	        if (this.parent) {
	            this.parent = null;
	        }
	        else if (this.isAttached) {
	            this.detach();
	        }
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     *
	     * The default implementation of this handler is a no-op.
	     *
	     * **See also:** [[ResizeMessage]]
	     */
	    Widget.prototype.onResize = function (msg) { };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     *
	     * The default implementation of this handler is a no-op.
	     *
	     * **See also:** [[update]], [[MsgUpdateRequest]]
	     */
	    Widget.prototype.onUpdateRequest = function (msg) { };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     *
	     * The default implementation of this handler is a no-op.
	     *
	     * **See also:** [[MsgAfterShow]]
	     */
	    Widget.prototype.onAfterShow = function (msg) { };
	    /**
	     * A message handler invoked on a `'before-hide'` message.
	     *
	     * The default implementation of this handler is a no-op.
	     *
	     * **See also:** [[MsgBeforeHide]]
	     */
	    Widget.prototype.onBeforeHide = function (msg) { };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     *
	     * The default implementation of this handler is a no-op.
	     *
	     * **See also:** [[MsgAfterAttach]]
	     */
	    Widget.prototype.onAfterAttach = function (msg) { };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     *
	     * The default implementation of this handler is a no-op.
	     *
	     * **See also:** [[MsgBeforeDetach]]
	     */
	    Widget.prototype.onBeforeDetach = function (msg) { };
	    /**
	     * A message handler invoked on a `'child-added'` message.
	     *
	     * The default implementation of this handler is a no-op.
	     *
	     * **See also:** [[ChildMessage]]
	     */
	    Widget.prototype.onChildAdded = function (msg) { };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     *
	     * The default implementation of this handler is a no-op.
	     *
	     * **See also:** [[ChildMessage]]
	     */
	    Widget.prototype.onChildRemoved = function (msg) { };
	    return Widget;
	})(phosphor_nodewrapper_1.NodeWrapper);
	exports.Widget = Widget;
	/**
	 * The namespace for the `Widget` class statics.
	 */
	var Widget;
	(function (Widget) {
	    /**
	     * A singleton `'update-request'` message.
	     *
	     * #### Notes
	     * This message can be dispatched to supporting widgets in order to
	     * update their content based on the current widget state. Not all
	     * widgets will respond to messages of this type.
	     *
	     * For widgets with a layout, this message will inform the layout to
	     * update the position and size of its child widgets.
	     *
	     * Messages of this type are compressed by default.
	     *
	     * **See also:** [[update]], [[onUpdateRequest]]
	     */
	    Widget.MsgUpdateRequest = new phosphor_messaging_1.Message('update-request');
	    /**
	     * A singleton `'fit-request'` message.
	     *
	     * #### Notes
	     * For widgets with a layout, this message will inform the layout to
	     * recalculate its size constraints to fit the space requirements of
	     * its child widgets, and to update their position and size. Not all
	     * layouts will respond to messages of this type.
	     *
	     * Messages of this type are compressed by default.
	     *
	     * **See also:** [[fit]]
	     */
	    Widget.MsgFitRequest = new phosphor_messaging_1.Message('fit-request');
	    /**
	     * A singleton `'close-request'` message.
	     *
	     * #### Notes
	     * This message should be dispatched to a widget when it should close
	     * and remove itself from the widget hierarchy.
	     *
	     * Messages of this type are compressed by default.
	     *
	     * **See also:** [[close]], [[onCloseRequest]]
	     */
	    Widget.MsgCloseRequest = new phosphor_messaging_1.Message('close-request');
	    /**
	     * A singleton `'after-show'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget after it becomes visible.
	     *
	     * This message is **not** sent when the widget is being attached.
	     *
	     * **See also:** [[isVisible]], [[onAfterShow]]
	     */
	    Widget.MsgAfterShow = new phosphor_messaging_1.Message('after-show');
	    /**
	     * A singleton `'before-hide'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget before it becomes not-visible.
	     *
	     * This message is **not** sent when the widget is being detached.
	     *
	     * **See also:** [[isVisible]], [[onBeforeHide]]
	     */
	    Widget.MsgBeforeHide = new phosphor_messaging_1.Message('before-hide');
	    /**
	     * A singleton `'after-attach'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget after it is attached.
	     *
	     * **See also:** [[isAttached]], [[onAfterAttach]]
	     */
	    Widget.MsgAfterAttach = new phosphor_messaging_1.Message('after-attach');
	    /**
	     * A singleton `'before-detach'` message.
	     *
	     * #### Notes
	     * This message is sent to a widget before it is detached.
	     *
	     * **See also:** [[isAttached]], [[onBeforeDetach]]
	     */
	    Widget.MsgBeforeDetach = new phosphor_messaging_1.Message('before-detach');
	})(Widget = exports.Widget || (exports.Widget = {}));
	/**
	 * An enum of widget bit flags.
	 */
	(function (WidgetFlag) {
	    /**
	     * The widget has been disposed.
	     */
	    WidgetFlag[WidgetFlag["IsDisposed"] = 1] = "IsDisposed";
	    /**
	     * The widget is attached to the DOM.
	     */
	    WidgetFlag[WidgetFlag["IsAttached"] = 2] = "IsAttached";
	    /**
	     * The widget is hidden.
	     */
	    WidgetFlag[WidgetFlag["IsHidden"] = 4] = "IsHidden";
	    /**
	     * The widget is visible.
	     */
	    WidgetFlag[WidgetFlag["IsVisible"] = 8] = "IsVisible";
	})(exports.WidgetFlag || (exports.WidgetFlag = {}));
	var WidgetFlag = exports.WidgetFlag;
	/**
	 * A message class for child related messages.
	 */
	var ChildMessage = (function (_super) {
	    __extends(ChildMessage, _super);
	    /**
	     * Construct a new child message.
	     *
	     * @param type - The message type.
	     *
	     * @param child - The child widget for the message.
	     */
	    function ChildMessage(type, child) {
	        _super.call(this, type);
	        this._child = child;
	    }
	    Object.defineProperty(ChildMessage.prototype, "child", {
	        /**
	         * The child widget for the message.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._child;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return ChildMessage;
	})(phosphor_messaging_1.Message);
	exports.ChildMessage = ChildMessage;
	/**
	 * A message class for `'resize'` messages.
	 */
	var ResizeMessage = (function (_super) {
	    __extends(ResizeMessage, _super);
	    /**
	     * Construct a new resize message.
	     *
	     * @param width - The **offset width** of the widget, or `-1` if
	     *   the width is not known.
	     *
	     * @param height - The **offset height** of the widget, or `-1` if
	     *   the height is not known.
	     */
	    function ResizeMessage(width, height) {
	        _super.call(this, 'resize');
	        this._width = width;
	        this._height = height;
	    }
	    Object.defineProperty(ResizeMessage.prototype, "width", {
	        /**
	         * The offset width of the widget.
	         *
	         * #### Notes
	         * This will be `-1` if the width is unknown.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._width;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ResizeMessage.prototype, "height", {
	        /**
	         * The offset height of the widget.
	         *
	         * #### Notes
	         * This will be `-1` if the height is unknown.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._height;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return ResizeMessage;
	})(phosphor_messaging_1.Message);
	exports.ResizeMessage = ResizeMessage;
	/**
	 * The namespace for the `ResizeMessage` class statics.
	 */
	var ResizeMessage;
	(function (ResizeMessage) {
	    /**
	     * A singleton `'resize'` message with an unknown size.
	     */
	    ResizeMessage.UnknownSize = new ResizeMessage(-1, -1);
	})(ResizeMessage = exports.ResizeMessage || (exports.ResizeMessage = {}));
	/**
	 * The namespace for the widget private data.
	 */
	var WidgetPrivate;
	(function (WidgetPrivate) {
	    /**
	     * A signal emitted when the widget is disposed.
	     */
	    WidgetPrivate.disposedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A property for the title data for a widget.
	     */
	    WidgetPrivate.titleProperty = new phosphor_properties_1.Property({
	        name: 'title',
	        create: function () { return new title_1.Title(); },
	    });
	})(WidgetPrivate || (WidgetPrivate = {}));


/***/ },
/* 24 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	/**
	 * A base class for creating objects which wrap a DOM node.
	 */
	var NodeWrapper = (function () {
	    /**
	     * Construct a new node wrapper.
	     */
	    function NodeWrapper() {
	        this._node = this.constructor.createNode();
	    }
	    /**
	     * Create the DOM node for a new node wrapper instance.
	     *
	     * @returns The DOM node to use with the node wrapper instance.
	     *
	     * #### Notes
	     * The default implementation creates an empty `<div>`.
	     *
	     * This may be reimplemented by a subclass to create a custom node.
	     */
	    NodeWrapper.createNode = function () {
	        return document.createElement('div');
	    };
	    Object.defineProperty(NodeWrapper.prototype, "node", {
	        /**
	         * Get the DOM node managed by the wrapper.
	         *
	         * #### Notes
	         * This property is read-only.
	         */
	        get: function () {
	            return this._node;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(NodeWrapper.prototype, "id", {
	        /**
	         * Get the id of the wrapper's DOM node.
	         */
	        get: function () {
	            return this._node.id;
	        },
	        /**
	         * Set the id of the wrapper's DOM node.
	         */
	        set: function (value) {
	            this._node.id = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Test whether the wrapper's DOM node has the given class name.
	     *
	     * @param name - The class name of interest.
	     *
	     * @returns `true` if the node has the class, `false` otherwise.
	     */
	    NodeWrapper.prototype.hasClass = function (name) {
	        return this._node.classList.contains(name);
	    };
	    /**
	     * Add a class name to the wrapper's DOM node.
	     *
	     * @param name - The class name to add to the node.
	     *
	     * #### Notes
	     * If the class name is already added to the node, this is a no-op.
	     */
	    NodeWrapper.prototype.addClass = function (name) {
	        this._node.classList.add(name);
	    };
	    /**
	     * Remove a class name from the wrapper's DOM node.
	     *
	     * @param name - The class name to remove from the node.
	     *
	     * #### Notes
	     * If the class name is not yet added to the node, this is a no-op.
	     */
	    NodeWrapper.prototype.removeClass = function (name) {
	        this._node.classList.remove(name);
	    };
	    /**
	     * Toggle a class name on the wrapper's DOM node.
	     *
	     * @param name - The class name to toggle on the node.
	     *
	     * @param force - Whether to force add the class (`true`) or force
	     *   remove the class (`false`). If not provided, the presence of
	     *   the class will be toggled from its current state.
	     *
	     * @returns `true` if the class is now present, `false` otherwise.
	     */
	    NodeWrapper.prototype.toggleClass = function (name, force) {
	        var present;
	        if (force === true) {
	            this.addClass(name);
	            present = true;
	        }
	        else if (force === false) {
	            this.removeClass(name);
	            present = false;
	        }
	        else if (this.hasClass(name)) {
	            this.removeClass(name);
	            present = false;
	        }
	        else {
	            this.addClass(name);
	            present = true;
	        }
	        return present;
	    };
	    return NodeWrapper;
	})();
	exports.NodeWrapper = NodeWrapper;


/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var phosphor_properties_1 = __webpack_require__(17);
	var phosphor_signaling_1 = __webpack_require__(22);
	/**
	 * An object which holds data related to a widget title.
	 *
	 * #### Notes
	 * A title object is intended to hold the data necessary to display a
	 * header for a particular widget. A common example is the `TabPanel`,
	 * which uses the widget title to populate the tab for a child widget.
	 */
	var Title = (function () {
	    /**
	     * Construct a new title.
	     *
	     * @param options - The options for initializing a title.
	     */
	    function Title(options) {
	        if (options)
	            TitlePrivate.initFrom(this, options);
	    }
	    Object.defineProperty(Title.prototype, "changed", {
	        /**
	         * A signal emitted when the title state changes.
	         */
	        get: function () {
	            return TitlePrivate.changedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "text", {
	        /**
	         * Get the text for the title.
	         *
	         * #### Notes
	         * The default value is an empty string.
	         */
	        get: function () {
	            return TitlePrivate.textProperty.get(this);
	        },
	        /**
	         * Set the text for the title.
	         */
	        set: function (value) {
	            TitlePrivate.textProperty.set(this, value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "icon", {
	        /**
	         * Get the icon class name for the title.
	         *
	         * #### Notes
	         * The default value is an empty string.
	         */
	        get: function () {
	            return TitlePrivate.iconProperty.get(this);
	        },
	        /**
	         * Set the icon class name for the title.
	         *
	         * #### Notes
	         * Multiple class names can be separated with whitespace.
	         */
	        set: function (value) {
	            TitlePrivate.iconProperty.set(this, value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "closable", {
	        /**
	         * Get the closable state for the title.
	         *
	         * #### Notes
	         * The default value is `false`.
	         */
	        get: function () {
	            return TitlePrivate.closableProperty.get(this);
	        },
	        /**
	         * Set the closable state for the title.
	         *
	         * #### Notes
	         * This controls the presence of a close icon when applicable.
	         */
	        set: function (value) {
	            TitlePrivate.closableProperty.set(this, value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Title.prototype, "className", {
	        /**
	         * Get the extra class name for the title.
	         *
	         * #### Notes
	         * The default value is an empty string.
	         */
	        get: function () {
	            return TitlePrivate.classNameProperty.get(this);
	        },
	        /**
	         * Set the extra class name for the title.
	         *
	         * #### Notes
	         * Multiple class names can be separated with whitespace.
	         */
	        set: function (value) {
	            TitlePrivate.classNameProperty.set(this, value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return Title;
	})();
	exports.Title = Title;
	/**
	 * The namespace for the title private data.
	 */
	var TitlePrivate;
	(function (TitlePrivate) {
	    /**
	     * A signal emitted when the title state changes.
	     */
	    TitlePrivate.changedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * The property descriptor for the title text.
	     */
	    TitlePrivate.textProperty = new phosphor_properties_1.Property({
	        name: 'text',
	        value: '',
	        notify: TitlePrivate.changedSignal,
	    });
	    /**
	     * The property descriptor for the title icon class.
	     */
	    TitlePrivate.iconProperty = new phosphor_properties_1.Property({
	        name: 'icon',
	        value: '',
	        notify: TitlePrivate.changedSignal,
	    });
	    /**
	     * The property descriptor for the title closable state.
	     */
	    TitlePrivate.closableProperty = new phosphor_properties_1.Property({
	        name: 'closable',
	        value: false,
	        notify: TitlePrivate.changedSignal,
	    });
	    /**
	     * The property descriptor for the title extra class name.
	     */
	    TitlePrivate.classNameProperty = new phosphor_properties_1.Property({
	        name: 'className',
	        value: '',
	        notify: TitlePrivate.changedSignal,
	    });
	    /**
	     * Initialize a title from an options object.
	     */
	    function initFrom(title, options) {
	        if (options.text !== void 0) {
	            title.text = options.text;
	        }
	        if (options.icon !== void 0) {
	            title.icon = options.icon;
	        }
	        if (options.closable !== void 0) {
	            title.closable = options.closable;
	        }
	        if (options.className !== void 0) {
	            title.className = options.className;
	        }
	    }
	    TitlePrivate.initFrom = initFrom;
	})(TitlePrivate || (TitlePrivate = {}));


/***/ },
/* 26 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(27);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(12)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../css-loader/index.js!./index.css", function() {
				var newContent = require("!!./../../css-loader/index.js!./index.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 27 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\r\n| Copyright (c) 2014-2015, PhosphorJS Contributors\r\n|\r\n| Distributed under the terms of the BSD 3-Clause License.\r\n|\r\n| The full license is in the file LICENSE, distributed with this software.\r\n|----------------------------------------------------------------------------*/\r\n.p-Widget {\r\n  box-sizing: border-box;\r\n  position: relative;\r\n  overflow: hidden;\r\n  cursor: default;\r\n  -webkit-user-select: none;\r\n  -moz-user-select: none;\r\n  -ms-user-select: none;\r\n  user-select: none;\r\n}\r\n\r\n\r\n.p-Widget.p-mod-hidden {\r\n  display: none;\r\n}\r\n", ""]);
	
	// exports


/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var phosphor_widget_1 = __webpack_require__(20);
	var layout_1 = __webpack_require__(19);
	/**
	 * The class name added to Panel instances.
	 */
	var PANEL_CLASS = 'p-Panel';
	/**
	 * A simple and convenient panel widget class.
	 *
	 * #### Notes
	 * This class is suitable as a base class for implementing a variety of
	 * convenience panels, but can also be used directly along with CSS to
	 * arrange a collection of widgets.
	 *
	 * This class provides a convenience wrapper around a [[PanelLayout]].
	 */
	var Panel = (function (_super) {
	    __extends(Panel, _super);
	    /**
	     * Construct a new panel.
	     */
	    function Panel() {
	        _super.call(this);
	        this.addClass(PANEL_CLASS);
	        this.layout = this.constructor.createLayout();
	    }
	    /**
	     * Create a panel layout to use with a panel.
	     *
	     * @returns A new panel layout to use with a panel.
	     *
	     * #### Notes
	     * This may be reimplemented by a subclass to create custom layouts.
	     */
	    Panel.createLayout = function () {
	        return new layout_1.PanelLayout();
	    };
	    /**
	     * Get the number of child widgets in the panel.
	     *
	     * @returns The number of child widgets in the panel.
	     */
	    Panel.prototype.childCount = function () {
	        return this.layout.childCount();
	    };
	    /**
	     * Get the child widget at the specified index.
	     *
	     * @param index - The index of the child widget of interest.
	     *
	     * @returns The child at the specified index, or `undefined`.
	     */
	    Panel.prototype.childAt = function (index) {
	        return this.layout.childAt(index);
	    };
	    /**
	     * Get the index of the specified child widget.
	     *
	     * @param child - The child widget of interest.
	     *
	     * @returns The index of the specified child, or `-1`.
	     */
	    Panel.prototype.childIndex = function (child) {
	        return this.layout.childIndex(child);
	    };
	    /**
	     * Add a child widget to the end of the panel.
	     *
	     * @param child - The child widget to add to the panel.
	     *
	     * #### Notes
	     * If the child is already contained in the panel, it will be moved.
	     */
	    Panel.prototype.addChild = function (child) {
	        this.layout.addChild(child);
	    };
	    /**
	     * Insert a child widget at the specified index.
	     *
	     * @param index - The index at which to insert the child.
	     *
	     * @param child - The child widget to insert into to the panel.
	     *
	     * #### Notes
	     * If the child is already contained in the panel, it will be moved.
	     */
	    Panel.prototype.insertChild = function (index, child) {
	        this.layout.insertChild(index, child);
	    };
	    return Panel;
	})(phosphor_widget_1.Widget);
	exports.Panel = Panel;


/***/ },
/* 29 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var phosphor_panel_1 = __webpack_require__(18);
	var layout_1 = __webpack_require__(5);
	/**
	 * The class name added to BoxPanel instances.
	 */
	var BOX_PANEL_CLASS = 'p-BoxPanel';
	/**
	 * The class name added to a BoxPanel child.
	 */
	var CHILD_CLASS = 'p-BoxPanel-child';
	/**
	 * A panel which arranges its children in a single row or column.
	 *
	 * #### Notes
	 * This class provides a convenience wrapper around a [[BoxLayout]].
	 */
	var BoxPanel = (function (_super) {
	    __extends(BoxPanel, _super);
	    /**
	     * Construct a new box panel.
	     */
	    function BoxPanel() {
	        _super.call(this);
	        this.addClass(BOX_PANEL_CLASS);
	    }
	    /**
	     * Create a box layout for a box panel.
	     */
	    BoxPanel.createLayout = function () {
	        return new layout_1.BoxLayout();
	    };
	    Object.defineProperty(BoxPanel.prototype, "direction", {
	        /**
	         * Get the layout direction for the box panel.
	         */
	        get: function () {
	            return this.layout.direction;
	        },
	        /**
	         * Set the layout direction for the box panel.
	         */
	        set: function (value) {
	            this.layout.direction = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(BoxPanel.prototype, "spacing", {
	        /**
	         * Get the inter-element spacing for the box panel.
	         */
	        get: function () {
	            return this.layout.spacing;
	        },
	        /**
	         * Set the inter-element spacing for the box panel.
	         */
	        set: function (value) {
	            this.layout.spacing = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * A message handler invoked on a `'child-added'` message.
	     */
	    BoxPanel.prototype.onChildAdded = function (msg) {
	        msg.child.addClass(CHILD_CLASS);
	    };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     */
	    BoxPanel.prototype.onChildRemoved = function (msg) {
	        msg.child.removeClass(CHILD_CLASS);
	    };
	    return BoxPanel;
	})(phosphor_panel_1.Panel);
	exports.BoxPanel = BoxPanel;
	/**
	 * The namespace for the `BoxPanel` class statics.
	 */
	var BoxPanel;
	(function (BoxPanel) {
	    /**
	     * A convenience alias of the `LeftToRight` [[Direction]].
	     */
	    BoxPanel.LeftToRight = layout_1.Direction.LeftToRight;
	    /**
	     * A convenience alias of the `RightToLeft` [[Direction]].
	     */
	    BoxPanel.RightToLeft = layout_1.Direction.RightToLeft;
	    /**
	     * A convenience alias of the `TopToBottom` [[Direction]].
	     */
	    BoxPanel.TopToBottom = layout_1.Direction.TopToBottom;
	    /**
	     * A convenience alias of the `BottomToTop` [[Direction]].
	     */
	    BoxPanel.BottomToTop = layout_1.Direction.BottomToTop;
	    /**
	     * Get the box panel stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The box panel stretch factor for the widget.
	     */
	    function getStretch(widget) {
	        return layout_1.BoxLayout.getStretch(widget);
	    }
	    BoxPanel.getStretch = getStretch;
	    /**
	     * Set the box panel stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the stretch factor.
	     */
	    function setStretch(widget, value) {
	        layout_1.BoxLayout.setStretch(widget, value);
	    }
	    BoxPanel.setStretch = setStretch;
	    /**
	     * Get the box panel size basis for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The box panel size basis for the widget.
	     */
	    function getSizeBasis(widget) {
	        return layout_1.BoxLayout.getSizeBasis(widget);
	    }
	    BoxPanel.getSizeBasis = getSizeBasis;
	    /**
	     * Set the box panel size basis for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the size basis.
	     */
	    function setSizeBasis(widget, value) {
	        layout_1.BoxLayout.setSizeBasis(widget, value);
	    }
	    BoxPanel.setSizeBasis = setSizeBasis;
	})(BoxPanel = exports.BoxPanel || (exports.BoxPanel = {}));


/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var arrays = __webpack_require__(3);
	var phosphor_domutil_1 = __webpack_require__(7);
	var phosphor_dragdrop_1 = __webpack_require__(31);
	var phosphor_nodewrapper_1 = __webpack_require__(24);
	var phosphor_properties_1 = __webpack_require__(17);
	var phosphor_splitpanel_1 = __webpack_require__(32);
	var phosphor_stackedpanel_1 = __webpack_require__(37);
	var phosphor_tabs_1 = __webpack_require__(40);
	var phosphor_widget_1 = __webpack_require__(20);
	__webpack_require__(45);
	// TODO - need better solution for storing these class names
	/**
	 * The class name added to DockPanel instances.
	 */
	var DOCK_PANEL_CLASS = 'p-DockPanel';
	/**
	 * The class name added to dock tab panels.
	 */
	var TAB_PANEL_CLASS = 'p-DockTabPanel';
	/**
	 * The class name added to dock split panels.
	 */
	var SPLIT_PANEL_CLASS = 'p-DockSplitPanel';
	/**
	 * The class name added to dock panel overlays.
	 */
	var OVERLAY_CLASS = 'p-DockPanel-overlay';
	/**
	 * The class name added to hidden overlays and tabs.
	 */
	var HIDDEN_CLASS = 'p-mod-hidden';
	/**
	 * The class name added to top root dock overlays.
	 */
	var ROOT_TOP_CLASS = 'p-mod-root-top';
	/**
	 * The class name added to left root dock overlays.
	 */
	var ROOT_LEFT_CLASS = 'p-mod-root-left';
	/**
	 * The class name added to right root dock overlays.
	 */
	var ROOT_RIGHT_CLASS = 'p-mod-root-right';
	/**
	 * The class name added to bottom root dock overlays.
	 */
	var ROOT_BOTTOM_CLASS = 'p-mod-root-bottom';
	/**
	 * The class name added to center root dock overlays.
	 */
	var ROOT_CENTER_CLASS = 'p-mod-root-center';
	/**
	 * The class name added to top panel dock overlays.
	 */
	var PANEL_TOP_CLASS = 'p-mod-panel-top';
	/**
	 * The class name added to left panel dock overlays.
	 */
	var PANEL_LEFT_CLASS = 'p-mod-panel-left';
	/**
	 * The class name added to right panel dock overlays.
	 */
	var PANEL_RIGHT_CLASS = 'p-mod-panel-right';
	/**
	 * The class name added to bottom panel dock overlays.
	 */
	var PANEL_BOTTOM_CLASS = 'p-mod-panel-bottom';
	/**
	 * The class named added to center panel dock overlays.
	 */
	var PANEL_CENTER_CLASS = 'p-mod-panel-center';
	/**
	 * The factory MIME type supported by the dock panel.
	 */
	var FACTORY_MIME = 'application/x-phosphor-widget-factory';
	/**
	 * The size of the edge dock zone for the root panel.
	 */
	var EDGE_SIZE = 30;
	/**
	 * A widget which provides a flexible docking area for content widgets.
	 */
	var DockPanel = (function (_super) {
	    __extends(DockPanel, _super);
	    /**
	     * Construct a new dock panel.
	     */
	    function DockPanel() {
	        _super.call(this);
	        this.addClass(DOCK_PANEL_CLASS);
	        this.layout = new phosphor_stackedpanel_1.StackedLayout();
	    }
	    Object.defineProperty(DockPanel.prototype, "spacing", {
	        /**
	         * Get the spacing between the tab panels.
	         */
	        get: function () {
	            return DockPanelPrivate.spacingProperty.get(this);
	        },
	        /**
	         * Set the spacing between the tab panels.
	         */
	        set: function (value) {
	            DockPanelPrivate.spacingProperty.set(this, value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Insert a widget as a new panel above a reference widget.
	     *
	     * @param widget - The widget to insert into the dock panel.
	     *
	     * @param ref - The reference widget. If this is not provided, the
	     *   widget will be inserted at the top edge of the dock panel.
	     *
	     * @throws An error if either `widget` or `ref` is invalid.
	     */
	    DockPanel.prototype.insertTop = function (widget, ref) {
	        DockPanelPrivate.insertSplit(this, widget, ref, phosphor_splitpanel_1.Orientation.Vertical, false);
	    };
	    /**
	     * Insert a widget as a new panel to the left of a reference widget.
	     *
	     * @param widget - The widget to insert into the dock panel.
	     *
	     * @param ref - The reference widget. If this is not provided, the
	     *   widget will be inserted at the left edge of the dock panel.
	     *
	     * @throws An error if either `widget` or `ref` is invalid.
	     */
	    DockPanel.prototype.insertLeft = function (widget, ref) {
	        DockPanelPrivate.insertSplit(this, widget, ref, phosphor_splitpanel_1.Orientation.Horizontal, false);
	    };
	    /**
	     * Insert a widget as a new panel to the right of a reference widget.
	     *
	     * @param widget - The widget to insert into the dock panel.
	     *
	     * @param ref - The reference widget. If this is not provided, the
	     *   widget will be inserted at the right edge of the dock panel.
	     *
	     * @throws An error if either `widget` or `ref` is invalid.
	     */
	    DockPanel.prototype.insertRight = function (widget, ref) {
	        DockPanelPrivate.insertSplit(this, widget, ref, phosphor_splitpanel_1.Orientation.Horizontal, true);
	    };
	    /**
	     * Insert a widget as a new panel below a reference widget.
	     *
	     * @param widget - The widget to insert into the dock panel.
	     *
	     * @param ref - The reference widget. If this is not provided, the
	     *   widget will be inserted at the bottom edge of the dock panel.
	     *
	     * @throws An error if either `widget` or `ref` is invalid.
	     */
	    DockPanel.prototype.insertBottom = function (widget, ref) {
	        DockPanelPrivate.insertSplit(this, widget, ref, phosphor_splitpanel_1.Orientation.Vertical, true);
	    };
	    /**
	     * Insert a widget as a sibling tab before a reference widget.
	     *
	     * @param widget - The widget to insert into the dock panel.
	     *
	     * @param ref - The reference widget. If this is not provided, the
	     *   widget will be inserted as the first tab in the top-left panel.
	     *
	     * @throws An error if either `widget` or `ref` is invalid.
	     */
	    DockPanel.prototype.insertTabBefore = function (widget, ref) {
	        DockPanelPrivate.insertTab(this, widget, ref, false);
	    };
	    /**
	     * Insert a widget as a sibling tab after a reference widget.
	     *
	     * @param widget - The widget to insert into the dock panel.
	     *
	     * @param ref - The reference widget. If this is not provided, the
	     *   widget will be inserted as the last tab in the top-left panel.
	     *
	     * @throws An error if either `widget` or `ref` is invalid.
	     */
	    DockPanel.prototype.insertTabAfter = function (widget, ref) {
	        DockPanelPrivate.insertTab(this, widget, ref, true);
	    };
	    /**
	     * Ensure the tab for the specified content widget is selected.
	     *
	     * @param widget - The content widget of interest.
	     *
	     * #### Notes
	     * If the widget is not contained in the dock panel, or is already
	     * the selected tab in its respective tab panel, this is a no-op.
	     */
	    DockPanel.prototype.selectWidget = function (widget) {
	        DockPanelPrivate.selectWidget(this, widget);
	    };
	    /**
	     * Handle the DOM events for the dock panel.
	     *
	     * @param event - The DOM event sent to the dock panel.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the dock panel's node. It should
	     * not be called directly by user code.
	     */
	    DockPanel.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'p-dragenter':
	                this._evtDragEnter(event);
	                break;
	            case 'p-dragleave':
	                this._evtDragLeave(event);
	                break;
	            case 'p-dragover':
	                this._evtDragOver(event);
	                break;
	            case 'p-drop':
	                this._evtDrop(event);
	                break;
	        }
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    DockPanel.prototype.onAfterAttach = function (msg) {
	        var node = this.node;
	        node.addEventListener('p-dragenter', this);
	        node.addEventListener('p-dragleave', this);
	        node.addEventListener('p-dragover', this);
	        node.addEventListener('p-drop', this);
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     */
	    DockPanel.prototype.onBeforeDetach = function (msg) {
	        var node = this.node;
	        node.removeEventListener('p-dragenter', this);
	        node.removeEventListener('p-dragleave', this);
	        node.removeEventListener('p-dragover', this);
	        node.removeEventListener('p-drop', this);
	    };
	    /**
	     * Handle the `'p-dragenter'` event for the dock panel.
	     */
	    DockPanel.prototype._evtDragEnter = function (event) {
	        if (event.mimeData.hasData(FACTORY_MIME)) {
	            event.preventDefault();
	            event.stopPropagation();
	        }
	    };
	    /**
	     * Handle the `'p-dragleave'` event for the dock panel.
	     */
	    DockPanel.prototype._evtDragLeave = function (event) {
	        event.preventDefault();
	        event.stopPropagation();
	        var related = event.relatedTarget;
	        if (!related || !this.node.contains(related)) {
	            DockPanelPrivate.hideOverlay(this);
	        }
	    };
	    /**
	     * Handle the `'p-dragover'` event for the dock panel.
	     */
	    DockPanel.prototype._evtDragOver = function (event) {
	        event.preventDefault();
	        event.stopPropagation();
	        var x = event.clientX;
	        var y = event.clientY;
	        var zone = DockPanelPrivate.showOverlay(this, x, y);
	        if (zone === 10 /* Invalid */) {
	            event.dropAction = phosphor_dragdrop_1.DropAction.None;
	        }
	        else {
	            event.dropAction = event.proposedAction;
	        }
	    };
	    /**
	     * Handle the `'p-drop'` event for the dock panel.
	     */
	    DockPanel.prototype._evtDrop = function (event) {
	        event.preventDefault();
	        event.stopPropagation();
	        DockPanelPrivate.hideOverlay(this);
	        if (event.proposedAction === phosphor_dragdrop_1.DropAction.None) {
	            event.dropAction = phosphor_dragdrop_1.DropAction.None;
	            return;
	        }
	        var x = event.clientX;
	        var y = event.clientY;
	        var target = DockPanelPrivate.findDockTarget(this, x, y);
	        if (target.zone === 10 /* Invalid */) {
	            event.dropAction = phosphor_dragdrop_1.DropAction.None;
	            return;
	        }
	        var factory = event.mimeData.getData(FACTORY_MIME);
	        if (typeof factory !== 'function') {
	            event.dropAction = phosphor_dragdrop_1.DropAction.None;
	            return;
	        }
	        var widget = factory();
	        if (!(widget instanceof phosphor_widget_1.Widget)) {
	            event.dropAction = phosphor_dragdrop_1.DropAction.None;
	            return;
	        }
	        DockPanelPrivate.handleDrop(this, widget, target);
	        event.dropAction = event.proposedAction;
	    };
	    return DockPanel;
	})(phosphor_widget_1.Widget);
	exports.DockPanel = DockPanel;
	/**
	 * A custom tab panel used by a DockPanel.
	 */
	var DockTabPanel = (function (_super) {
	    __extends(DockTabPanel, _super);
	    /**
	     * Construct a new dock tab panel.
	     */
	    function DockTabPanel() {
	        _super.call(this);
	        this.addClass(TAB_PANEL_CLASS);
	        this.tabBar.tabsMovable = true;
	    }
	    return DockTabPanel;
	})(phosphor_tabs_1.TabPanel);
	/**
	 * A custom split panel used by a DockPanel.
	 */
	var DockSplitPanel = (function (_super) {
	    __extends(DockSplitPanel, _super);
	    /**
	     * Construct a new dock split panel.
	     */
	    function DockSplitPanel(orientation, spacing) {
	        _super.call(this);
	        this.addClass(SPLIT_PANEL_CLASS);
	        this.orientation = orientation;
	        this.spacing = spacing;
	    }
	    return DockSplitPanel;
	})(phosphor_splitpanel_1.SplitPanel);
	/**
	 * A node wrapper used as an overlay dock indicator for a dock panel.
	 */
	var DockPanelOverlay = (function (_super) {
	    __extends(DockPanelOverlay, _super);
	    /**
	     * Construct a new dock panel overlay.
	     */
	    function DockPanelOverlay() {
	        _super.call(this);
	        this._zone = 10 /* Invalid */;
	        this.addClass(OVERLAY_CLASS);
	        this.addClass(HIDDEN_CLASS);
	    }
	    /**
	     * Show the overlay with the given zone and geometry
	     */
	    DockPanelOverlay.prototype.show = function (zone, left, top, width, height) {
	        var style = this.node.style;
	        style.top = top + 'px';
	        style.left = left + 'px';
	        style.width = width + 'px';
	        style.height = height + 'px';
	        this.removeClass(HIDDEN_CLASS);
	        this._setZone(zone);
	    };
	    /**
	     * Hide the overlay and reset its zone.
	     */
	    DockPanelOverlay.prototype.hide = function () {
	        this.addClass(HIDDEN_CLASS);
	        this._setZone(10 /* Invalid */);
	    };
	    /**
	     * Set the dock zone for the overlay.
	     */
	    DockPanelOverlay.prototype._setZone = function (zone) {
	        if (zone === this._zone) {
	            return;
	        }
	        var oldClass = DockPanelOverlay.zoneMap[this._zone];
	        var newClass = DockPanelOverlay.zoneMap[zone];
	        if (oldClass)
	            this.removeClass(oldClass);
	        if (newClass)
	            this.addClass(newClass);
	        this._zone = zone;
	    };
	    /**
	     * A mapping of dock zone enum value to modifier class.
	     */
	    DockPanelOverlay.zoneMap = [
	        ROOT_TOP_CLASS,
	        ROOT_LEFT_CLASS,
	        ROOT_RIGHT_CLASS,
	        ROOT_BOTTOM_CLASS,
	        ROOT_CENTER_CLASS,
	        PANEL_TOP_CLASS,
	        PANEL_LEFT_CLASS,
	        PANEL_RIGHT_CLASS,
	        PANEL_BOTTOM_CLASS,
	        PANEL_CENTER_CLASS
	    ];
	    return DockPanelOverlay;
	})(phosphor_nodewrapper_1.NodeWrapper);
	/**
	 * The namespace for the `DockPanel` class private data.
	 */
	var DockPanelPrivate;
	(function (DockPanelPrivate) {
	    /**
	     * The property descriptor for the spacing between panels.
	     */
	    DockPanelPrivate.spacingProperty = new phosphor_properties_1.Property({
	        name: 'spacing',
	        value: 3,
	        coerce: function (owner, value) { return Math.max(0, value | 0); },
	        changed: onSpacingChanged,
	    });
	    /**
	     * Insert a widget as a new split panel in a dock panel.
	     */
	    function insertSplit(owner, widget, ref, orientation, after) {
	        // Ensure the insert args are valid.
	        validateInsertArgs(owner, widget, ref);
	        // If the widget is the same as the ref, there's nothing to do.
	        if (widget === ref) {
	            return;
	        }
	        // Unparent the widget before performing the insert. This ensures
	        // that structural changes to the dock panel occur before searching
	        // for the insert location.
	        widget.parent = null;
	        // Setup the new tab panel to host the widget.
	        var tabPanel = createTabPanel();
	        tabPanel.addChild(widget);
	        // If there is no root, add the new tab panel as the root.
	        if (!getRoot(owner)) {
	            setRoot(owner, tabPanel);
	            return;
	        }
	        // If the ref widget is null, split the root panel.
	        if (!ref) {
	            var root = ensureSplitRoot(owner, orientation);
	            var sizes_1 = root.sizes();
	            var count = sizes_1.length;
	            arrays.insert(sizes_1, after ? count : 0, 0.5);
	            root.insertChild(after ? count : 0, tabPanel);
	            root.setSizes(sizes_1);
	            return;
	        }
	        // Lookup the tab panel for the ref widget.
	        var refTabPanel = findTabPanel(ref);
	        // If the ref tab panel parent is the dock panel, split the root.
	        if (refTabPanel.parent === owner) {
	            var root = ensureSplitRoot(owner, orientation);
	            root.insertChild(after ? 1 : 0, tabPanel);
	            root.setSizes([1, 1]);
	            return;
	        }
	        // Assert the parent of the ref tab panel is a dock split panel.
	        if (!(refTabPanel.parent instanceof DockSplitPanel)) {
	            internalError();
	        }
	        // Cast the ref tab panel parent to a dock split panel.
	        var splitPanel = refTabPanel.parent;
	        // If the split panel is the correct orientation, the widget
	        // can be inserted directly and sized to 1/2 the ref space.
	        if (splitPanel.orientation === orientation) {
	            var i_1 = splitPanel.childIndex(refTabPanel);
	            var sizes_2 = splitPanel.sizes();
	            var size = sizes_2[i_1] = sizes_2[i_1] / 2;
	            arrays.insert(sizes_2, after ? i_1 + 1 : i_1, size);
	            splitPanel.insertChild(after ? i_1 + 1 : i_1, tabPanel);
	            splitPanel.setSizes(sizes_2);
	            return;
	        }
	        // If the split panel only has a single child, its orientation
	        // can be changed directly and its sizes set to a 1:1 ratio.
	        if (splitPanel.childCount() === 1) {
	            splitPanel.orientation = orientation;
	            splitPanel.insertChild(after ? 1 : 0, tabPanel);
	            splitPanel.setSizes([1, 1]);
	            return;
	        }
	        // Assert the split panel has more than one child.
	        if (splitPanel.childCount() === 0) {
	            internalError();
	        }
	        // Otherwise, a new split panel with the correct orientation needs
	        // to be created to hold the ref panel and tab panel, and inserted
	        // in the previous location of the ref panel.
	        var sizes = splitPanel.sizes();
	        var i = splitPanel.childIndex(refTabPanel);
	        var childSplit = new DockSplitPanel(orientation, owner.spacing);
	        childSplit.addChild(refTabPanel);
	        childSplit.insertChild(after ? 1 : 0, tabPanel);
	        splitPanel.insertChild(i, childSplit);
	        splitPanel.setSizes(sizes);
	        childSplit.setSizes([1, 1]);
	    }
	    DockPanelPrivate.insertSplit = insertSplit;
	    /**
	     * Insert a widget as a sibling tab in a dock panel.
	     */
	    function insertTab(owner, widget, ref, after) {
	        // Ensure the insert args are valid.
	        validateInsertArgs(owner, widget, ref);
	        // If the widget is the same as the ref, there's nothing to do.
	        if (widget === ref) {
	            return;
	        }
	        // Unparent the widget before performing the insert. This ensures
	        // that structural changes to the dock panel occur before searching
	        // for the insert location.
	        widget.parent = null;
	        // Find the index and tab panel for the insert operation.
	        var index;
	        var tabPanel;
	        if (ref) {
	            tabPanel = findTabPanel(ref);
	            index = tabPanel.childIndex(ref) + (after ? 1 : 0);
	        }
	        else {
	            tabPanel = ensureFirstTabPanel(owner);
	            index = after ? tabPanel.childCount() : 0;
	        }
	        // Insert the widget into the tab panel at the proper location.
	        tabPanel.insertChild(index, widget);
	    }
	    DockPanelPrivate.insertTab = insertTab;
	    /**
	     * Ensure the given widget is the current widget in its tab panel.
	     *
	     * This is a no-op if the widget is not contained in the dock panel.
	     */
	    function selectWidget(owner, widget) {
	        if (!dockPanelContains(owner, widget))
	            return;
	        widget.parent.parent.currentWidget = widget;
	    }
	    DockPanelPrivate.selectWidget = selectWidget;
	    /**
	     * Hide the dock panel overlay for the given dock panel.
	     */
	    function hideOverlay(owner) {
	        getOverlay(owner).hide();
	    }
	    DockPanelPrivate.hideOverlay = hideOverlay;
	    /**
	     * Show the dock panel overlay indicator at the given client position.
	     *
	     * If the position is not over a dock zone, the overlay is hidden.
	     *
	     * This returns the dock zone used to display the overlay.
	     */
	    function showOverlay(owner, clientX, clientY) {
	        // Find the dock target for the given client position.
	        var target = findDockTarget(owner, clientX, clientY);
	        // If the dock zone is invalid, hide the overlay and bail.
	        if (target.zone === 10 /* Invalid */) {
	            hideOverlay(owner);
	            return target.zone;
	        }
	        // Setup the variables needed to compute the overlay geometry.
	        var top;
	        var left;
	        var width;
	        var height;
	        var pcr;
	        var box = phosphor_domutil_1.boxSizing(owner.node); // TODO cache this?
	        var rect = owner.node.getBoundingClientRect();
	        // Compute the overlay geometry based on the dock zone.
	        switch (target.zone) {
	            case 0 /* RootTop */:
	                top = box.paddingTop;
	                left = box.paddingLeft;
	                width = rect.width - box.horizontalSum;
	                height = (rect.height - box.verticalSum) / 3;
	                break;
	            case 1 /* RootLeft */:
	                top = box.paddingTop;
	                left = box.paddingLeft;
	                width = (rect.width - box.horizontalSum) / 3;
	                height = rect.height - box.verticalSum;
	                break;
	            case 2 /* RootRight */:
	                top = box.paddingTop;
	                width = (rect.width - box.horizontalSum) / 3;
	                left = box.paddingLeft + 2 * width;
	                height = rect.height - box.verticalSum;
	                break;
	            case 3 /* RootBottom */:
	                height = (rect.height - box.verticalSum) / 3;
	                top = box.paddingTop + 2 * height;
	                left = box.paddingLeft;
	                width = rect.width - box.horizontalSum;
	                break;
	            case 4 /* RootCenter */:
	                top = box.paddingTop;
	                left = box.paddingLeft;
	                width = rect.width - box.horizontalSum;
	                height = rect.height - box.verticalSum;
	                break;
	            case 5 /* PanelTop */:
	                pcr = target.panel.node.getBoundingClientRect();
	                top = pcr.top - rect.top - box.borderTop;
	                left = pcr.left - rect.left - box.borderLeft;
	                width = pcr.width;
	                height = pcr.height / 2;
	                break;
	            case 6 /* PanelLeft */:
	                pcr = target.panel.node.getBoundingClientRect();
	                top = pcr.top - rect.top - box.borderTop;
	                left = pcr.left - rect.left - box.borderLeft;
	                width = pcr.width / 2;
	                height = pcr.height;
	                break;
	            case 7 /* PanelRight */:
	                pcr = target.panel.node.getBoundingClientRect();
	                top = pcr.top - rect.top - box.borderTop;
	                left = pcr.left - rect.left - box.borderLeft + pcr.width / 2;
	                width = pcr.width / 2;
	                height = pcr.height;
	                break;
	            case 8 /* PanelBottom */:
	                pcr = target.panel.node.getBoundingClientRect();
	                top = pcr.top - rect.top - box.borderTop + pcr.height / 2;
	                left = pcr.left - rect.left - box.borderLeft;
	                width = pcr.width;
	                height = pcr.height / 2;
	                break;
	            case 9 /* PanelCenter */:
	                pcr = target.panel.node.getBoundingClientRect();
	                top = pcr.top - rect.top - box.borderTop;
	                left = pcr.left - rect.left - box.borderLeft;
	                width = pcr.width;
	                height = pcr.height;
	                break;
	        }
	        // Show the overlay and return the dock zone.
	        getOverlay(owner).show(target.zone, left, top, width, height);
	        return target.zone;
	    }
	    DockPanelPrivate.showOverlay = showOverlay;
	    /**
	     * Find the dock target for the given client position.
	     */
	    function findDockTarget(owner, clientX, clientY) {
	        var root = getRoot(owner);
	        if (!root) {
	            return { zone: 4 /* RootCenter */, panel: null };
	        }
	        if (!phosphor_domutil_1.hitTest(root.node, clientX, clientY)) {
	            return { zone: 10 /* Invalid */, panel: null };
	        }
	        var edgeZone = getEdgeZone(root.node, clientX, clientY);
	        if (edgeZone !== 10 /* Invalid */) {
	            return { zone: edgeZone, panel: null };
	        }
	        var hitPanel = iterTabPanels(root, function (tabs) {
	            return phosphor_domutil_1.hitTest(tabs.node, clientX, clientY) ? tabs : void 0;
	        });
	        if (!hitPanel) {
	            return { zone: 10 /* Invalid */, panel: null };
	        }
	        var panelZone = getPanelZone(hitPanel.node, clientX, clientY);
	        return { zone: panelZone, panel: hitPanel };
	    }
	    DockPanelPrivate.findDockTarget = findDockTarget;
	    /**
	     * Drop a widget onto a dock panel using the given dock target.
	     */
	    function handleDrop(owner, widget, target) {
	        // Do nothing if the dock zone is invalid.
	        if (target.zone === 10 /* Invalid */) {
	            return;
	        }
	        // Handle the simple case of root drops first.
	        switch (target.zone) {
	            case 0 /* RootTop */:
	                owner.insertTop(widget);
	                return;
	            case 1 /* RootLeft */:
	                owner.insertLeft(widget);
	                return;
	            case 2 /* RootRight */:
	                owner.insertRight(widget);
	                return;
	            case 3 /* RootBottom */:
	                owner.insertBottom(widget);
	                return;
	            case 4 /* RootCenter */:
	                owner.insertLeft(widget);
	                return;
	        }
	        // Otherwise, it's a panel drop, and that requires more checks.
	        // Do nothing if the widget is dropped as a tab on its own panel.
	        if (target.zone === 9 /* PanelCenter */) {
	            if (target.panel.childIndex(widget) !== -1) {
	                return;
	            }
	        }
	        // Do nothing if the panel only contains the drop widget.
	        if (target.panel.childCount() === 1) {
	            if (target.panel.childAt(0) === widget) {
	                return;
	            }
	        }
	        // Find a suitable reference widget for the drop.
	        var n = target.panel.childCount();
	        var ref = target.panel.childAt(n - 1);
	        if (ref === widget) {
	            ref = target.panel.childAt(n - 2);
	        }
	        // Insert the widget based on the panel zone.
	        switch (target.zone) {
	            case 5 /* PanelTop */:
	                owner.insertTop(widget, ref);
	                return;
	            case 6 /* PanelLeft */:
	                owner.insertLeft(widget, ref);
	                return;
	            case 7 /* PanelRight */:
	                owner.insertRight(widget, ref);
	                return;
	            case 8 /* PanelBottom */:
	                owner.insertBottom(widget, ref);
	                return;
	            case 9 /* PanelCenter */:
	                owner.insertTabAfter(widget, ref);
	                selectWidget(owner, widget);
	                return;
	        }
	    }
	    DockPanelPrivate.handleDrop = handleDrop;
	    /**
	     * A private attached property for the dock panel root.
	     */
	    var rootProperty = new phosphor_properties_1.Property({
	        name: 'root',
	        value: null,
	        changed: onRootChanged,
	    });
	    /**
	     * A private attached property for the dock panel overlay.
	     */
	    var overlayProperty = new phosphor_properties_1.Property({
	        name: 'overlay',
	        create: createOverlay,
	    });
	    /**
	     * Get the root panel for a dock panel.
	     */
	    function getRoot(owner) {
	        return rootProperty.get(owner);
	    }
	    /**
	     * Set the root panel for a dock panel.
	     */
	    function setRoot(owner, root) {
	        rootProperty.set(owner, root);
	    }
	    /**
	     * Get the overlay for a dock panel.
	     */
	    function getOverlay(owner) {
	        return overlayProperty.get(owner);
	    }
	    /**
	     * The change handler for the dock panel `rootProperty`.
	     *
	     * This will re-parent the new root and set it as the current widget.
	     *
	     * The old root is not modified.
	     */
	    function onRootChanged(owner, old, root) {
	        if (!root)
	            return;
	        var layout = owner.layout;
	        layout.addChild(root);
	        root.show();
	    }
	    /**
	     * The creation handler for the dock panel `overlayProperty`.
	     *
	     * This will create and install the overlay for the panel.
	     */
	    function createOverlay(owner) {
	        var overlay = new DockPanelOverlay();
	        owner.node.appendChild(overlay.node);
	        return overlay;
	    }
	    /**
	     * The change handler for the `spacing` property of a dock panel.
	     */
	    function onSpacingChanged(owner, old, spacing) {
	        var root = getRoot(owner);
	        if (root instanceof DockSplitPanel) {
	            updateSpacing(root, spacing);
	        }
	    }
	    /**
	     * Recursively update the spacing of a dock split panel.
	     */
	    function updateSpacing(panel, spacing) {
	        for (var i = 0, n = panel.childCount(); i < n; ++i) {
	            var child = panel.childAt(i);
	            if (child instanceof DockSplitPanel) {
	                updateSpacing(child, spacing);
	            }
	        }
	        panel.spacing = spacing;
	    }
	    /**
	     * Throw an internal dock panel error.
	     */
	    function internalError() {
	        throw new Error('Internal DockPanel Error.');
	    }
	    /**
	     * Test whether a dock panel contains the given widget.
	     *
	     * For this condition to be `true`, the widget must be a logical child
	     * of a `DockTabPanel`, which itself must be a proper descendant of the
	     * given dock panel.
	     */
	    function dockPanelContains(owner, widget) {
	        var stack = widget.parent;
	        if (!stack) {
	            return false;
	        }
	        var tabs = stack.parent;
	        if (!(tabs instanceof DockTabPanel)) {
	            return false;
	        }
	        var parent = tabs.parent;
	        while (parent) {
	            if (parent === owner) {
	                return true;
	            }
	            if (!(parent instanceof DockSplitPanel)) {
	                return false;
	            }
	            parent = parent.parent;
	        }
	        return false;
	    }
	    /**
	     * Find the ancestor dock tab panel for the given widget.
	     *
	     * This assumes the widget already belongs to a dock panel, and will
	     * throw an error if that assumption does not hold.
	     */
	    function findTabPanel(widget) {
	        var stack = widget.parent;
	        if (!stack) {
	            internalError();
	        }
	        var tabs = stack.parent;
	        if (!(tabs instanceof DockTabPanel)) {
	            internalError();
	        }
	        return tabs;
	    }
	    /**
	     * Find the first dock tab panel for the given dock panel.
	     *
	     * This returns `null` if the dock panel has no content. It will throw
	     * an error if the structure of the dock panel is found to be invalid.
	     */
	    function findFirstTabPanel(owner) {
	        var root = getRoot(owner);
	        while (root) {
	            if (root instanceof DockTabPanel) {
	                return root;
	            }
	            if (!(root instanceof DockSplitPanel) || root.childCount() === 0) {
	                internalError();
	            }
	            root = root.childAt(0);
	        }
	        return null;
	    }
	    /**
	     * Get or create the first dock tab panel for the given dock panel.
	     *
	     * If dock panel has no root, a new tab panel will be created and
	     * added as the root. An error will be thrown if the structure of
	     * the dock panel is found to be invalid.
	     */
	    function ensureFirstTabPanel(owner) {
	        var tabs = findFirstTabPanel(owner);
	        if (!tabs) {
	            tabs = createTabPanel();
	            setRoot(owner, tabs);
	        }
	        return tabs;
	    }
	    /**
	     * Ensure the root panel is a splitter with the given orientation.
	     *
	     * This will throw an error if the panel does not have a current root,
	     * since that would violate the invariants of the dock panel structure.
	     */
	    function ensureSplitRoot(owner, orientation) {
	        var oldRoot = getRoot(owner);
	        if (!oldRoot) {
	            internalError();
	        }
	        if (oldRoot instanceof DockSplitPanel) {
	            if (oldRoot.orientation === orientation) {
	                return oldRoot;
	            }
	            if (oldRoot.childCount() <= 1) {
	                oldRoot.orientation = orientation;
	                return oldRoot;
	            }
	        }
	        var newRoot = new DockSplitPanel(orientation, owner.spacing);
	        newRoot.addChild(oldRoot);
	        setRoot(owner, newRoot);
	        return newRoot;
	    }
	    /**
	     * Validate the insert arguments for a dock panel.
	     *
	     * This will throw an error if the target widget is null, or if the
	     * reference widget is not null and not contained by the dock panel.
	     */
	    function validateInsertArgs(owner, widget, ref) {
	        if (!widget) {
	            throw new Error('Target widget is null.');
	        }
	        if (ref && !dockPanelContains(owner, ref)) {
	            throw new Error('Reference widget not contained by the dock panel.');
	        }
	    }
	    /**
	     * Recursively iterate over the dock tab panels of a root panel.
	     *
	     * Iteration stops if the callback returns anything but `undefined`.
	     */
	    function iterTabPanels(root, callback) {
	        if (root instanceof DockTabPanel) {
	            return callback(root);
	        }
	        if (!(root instanceof DockSplitPanel)) {
	            internalError();
	        }
	        for (var i = 0; i < root.childCount(); ++i) {
	            var child = root.childAt(i);
	            var result = iterTabPanels(child, callback);
	            if (result !== void 0)
	                return result;
	        }
	        return void 0;
	    }
	    /**
	     * Get the root edge zone for the given node and client position.
	     *
	     * This assumes the position lies within the node's client rect.
	     *
	     * Returns the `Invalid` zone if the position is not within an edge.
	     */
	    function getEdgeZone(node, x, y) {
	        var zone;
	        var rect = node.getBoundingClientRect();
	        if (x < rect.left + EDGE_SIZE) {
	            if (y - rect.top < x - rect.left) {
	                zone = 0 /* RootTop */;
	            }
	            else if (rect.bottom - y < x - rect.left) {
	                zone = 3 /* RootBottom */;
	            }
	            else {
	                zone = 1 /* RootLeft */;
	            }
	        }
	        else if (x >= rect.right - EDGE_SIZE) {
	            if (y - rect.top < rect.right - x) {
	                zone = 0 /* RootTop */;
	            }
	            else if (rect.bottom - y < rect.right - x) {
	                zone = 3 /* RootBottom */;
	            }
	            else {
	                zone = 2 /* RootRight */;
	            }
	        }
	        else if (y < rect.top + EDGE_SIZE) {
	            zone = 0 /* RootTop */;
	        }
	        else if (y >= rect.bottom - EDGE_SIZE) {
	            zone = 3 /* RootBottom */;
	        }
	        else {
	            zone = 10 /* Invalid */;
	        }
	        return zone;
	    }
	    /**
	     * Get the panel zone for the given node and position.
	     *
	     * This assumes the position lies within the node's client rect.
	     *
	     * This always returns a valid zone.
	     */
	    function getPanelZone(node, x, y) {
	        var zone;
	        var rect = node.getBoundingClientRect();
	        var fracX = (x - rect.left) / rect.width;
	        var fracY = (y - rect.top) / rect.height;
	        if (fracX < 1 / 3) {
	            if (fracY < fracX) {
	                zone = 5 /* PanelTop */;
	            }
	            else if (1 - fracY < fracX) {
	                zone = 8 /* PanelBottom */;
	            }
	            else {
	                zone = 6 /* PanelLeft */;
	            }
	        }
	        else if (fracX < 2 / 3) {
	            if (fracY < 1 / 3) {
	                zone = 5 /* PanelTop */;
	            }
	            else if (fracY < 2 / 3) {
	                zone = 9 /* PanelCenter */;
	            }
	            else {
	                zone = 8 /* PanelBottom */;
	            }
	        }
	        else {
	            if (fracY < 1 - fracX) {
	                zone = 5 /* PanelTop */;
	            }
	            else if (fracY > fracX) {
	                zone = 8 /* PanelBottom */;
	            }
	            else {
	                zone = 7 /* PanelRight */;
	            }
	        }
	        return zone;
	    }
	    /**
	     * The current tab drag object.
	     */
	    var currentDrag = null;
	    /**
	     * Create a new tab panel for a dock panel.
	     */
	    function createTabPanel() {
	        var panel = new DockTabPanel();
	        panel.tabBar.tabDetachRequested.connect(onTabDetachRequested);
	        panel.stackedPanel.widgetRemoved.connect(onWidgetRemoved);
	        return panel;
	    }
	    /**
	     * Remove an empty dock tab panel from the hierarchy.
	     *
	     * This ensures that the hierarchy is kept consistent by merging an
	     * ancestor split panel when it contains only a single child widget.
	     */
	    function removeTabPanel(tabPanel) {
	        // Assert the tab panel is empty.
	        if (tabPanel.childCount() !== 0) {
	            internalError();
	        }
	        // If the parent of the tab panel is a dock panel, just remove it.
	        if (tabPanel.parent instanceof DockPanel) {
	            setRoot(tabPanel.parent, null);
	            tabPanel.dispose();
	            return;
	        }
	        // Assert the tab panel parent is a dock split panel.
	        if (!(tabPanel.parent instanceof DockSplitPanel)) {
	            internalError();
	        }
	        // Cast the tab panel parent to a dock split panel.
	        var splitPanel = tabPanel.parent;
	        // Assert the split panel has at least two children.
	        if (splitPanel.childCount() < 2) {
	            internalError();
	        }
	        // Dispose the tab panel to ensure its resources are released.
	        tabPanel.dispose();
	        // If the split panel still has multiple children, there is
	        // nothing more to do.
	        if (splitPanel.childCount() > 1) {
	            return;
	        }
	        // Extract the remaining child from the split panel.
	        var child = splitPanel.childAt(0);
	        // Assert the remaining child is a proper panel type.
	        if (!(child instanceof DockTabPanel) && !(child instanceof DockSplitPanel)) {
	            internalError();
	        }
	        // If the parent of the split panel is a dock panel, replace it.
	        if (splitPanel.parent instanceof DockPanel) {
	            setRoot(splitPanel.parent, child);
	            splitPanel.dispose();
	            return;
	        }
	        // Assert the split panel parent is a dock split panel.
	        if (!(splitPanel.parent instanceof DockSplitPanel)) {
	            internalError();
	        }
	        // Cast the split panel parent to a dock split panel.
	        var grandPanel = splitPanel.parent;
	        // If the child is a dock tab panel, replace the split panel.
	        if (child instanceof DockTabPanel) {
	            var sizes = grandPanel.sizes();
	            var index_1 = grandPanel.childIndex(splitPanel);
	            splitPanel.parent = null;
	            grandPanel.insertChild(index_1, child);
	            grandPanel.setSizes(sizes);
	            splitPanel.dispose();
	            return;
	        }
	        // Cast the child to a dock split panel.
	        var childSplit = child;
	        // Child splitters have an orthogonal orientation to their parent.
	        // Assert the orientation of the child matches the grand parent.
	        if (childSplit.orientation !== grandPanel.orientation) {
	            internalError();
	        }
	        // The grand children can now be merged with their grand parent.
	        // Start by fetching the relevant current sizes and insert index.
	        var index = grandPanel.childIndex(splitPanel);
	        var childSizes = childSplit.sizes();
	        var grandSizes = grandPanel.sizes();
	        // Remove the split panel and store its share of the size.
	        splitPanel.parent = null;
	        var sizeShare = arrays.removeAt(grandSizes, index);
	        // Merge the grand children and maintain their relative size.
	        for (var i = 0; childSplit.childCount() !== 0; ++i) {
	            grandPanel.insertChild(index + i, childSplit.childAt(0));
	            arrays.insert(grandSizes, index + i, sizeShare * childSizes[i]);
	        }
	        // Update the grand parent sizes and dispose the removed panel.
	        grandPanel.setSizes(grandSizes);
	        splitPanel.dispose();
	    }
	    /**
	     * Handle the `tabDetachRequested` signal from a dock tab bar.
	     */
	    function onTabDetachRequested(sender, args) {
	        // Do nothing if a drag is already in progress.
	        if (currentDrag) {
	            return;
	        }
	        // Release the tab bar's hold on the mouse.
	        sender.releaseMouse();
	        // Setup the mime data for the drag operation.
	        var mimeData = new phosphor_dragdrop_1.MimeData();
	        var widget = args.item;
	        mimeData.setData(FACTORY_MIME, function () { return widget; });
	        // Create the drag image for the drag operation.
	        var tab = sender.tabAt(args.index);
	        var dragImage = tab.cloneNode(true);
	        // Create the drag object to manage the drag-drop operation.
	        currentDrag = new phosphor_dragdrop_1.Drag({
	            mimeData: mimeData,
	            dragImage: dragImage,
	            proposedAction: phosphor_dragdrop_1.DropAction.Move,
	            supportedActions: phosphor_dragdrop_1.DropActions.Move,
	        });
	        // Start the drag operation and cleanup when done.
	        tab.classList.add(HIDDEN_CLASS);
	        currentDrag.start(args.clientX, args.clientY).then(function () {
	            currentDrag = null;
	            tab.classList.remove(HIDDEN_CLASS);
	        });
	    }
	    /**
	     * Handle the `widgetRemvoed` signal for a dock stacked panel.
	     */
	    function onWidgetRemoved(sender, widget) {
	        if (sender.childCount() === 0) {
	            removeTabPanel(sender.parent);
	        }
	    }
	})(DockPanelPrivate || (DockPanelPrivate = {}));


/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var phosphor_domutil_1 = __webpack_require__(7);
	/**
	 * The class name added to drag image nodes.
	 */
	var DRAG_IMAGE_CLASS = 'p-mod-drag-image';
	/**
	 * An enum which defines the possible independent drop actions.
	 */
	(function (DropAction) {
	    /**
	     * No item may be dropped.
	     */
	    DropAction[DropAction["None"] = 0] = "None";
	    /**
	     * The item is copied into its new location.
	     */
	    DropAction[DropAction["Copy"] = 1] = "Copy";
	    /**
	     * The item is linked to its new location.
	     */
	    DropAction[DropAction["Link"] = 2] = "Link";
	    /**
	     * The item is moved to its new location.
	     */
	    DropAction[DropAction["Move"] = 4] = "Move";
	})(exports.DropAction || (exports.DropAction = {}));
	var DropAction = exports.DropAction;
	/**
	 * An enum which defines the combinations of possible drop actions.
	 */
	(function (DropActions) {
	    /**
	     * No drop action is supported.
	     */
	    DropActions[DropActions["None"] = 0] = "None";
	    /**
	     * The item may be copied to its new location.
	     */
	    DropActions[DropActions["Copy"] = 1] = "Copy";
	    /**
	     * The item may be linked to its new location.
	     */
	    DropActions[DropActions["Link"] = 2] = "Link";
	    /**
	     * The item may be moved to its new location.
	     */
	    DropActions[DropActions["Move"] = 4] = "Move";
	    /**
	     * The item may be copied or linked to its new location.
	     */
	    DropActions[DropActions["CopyLink"] = 3] = "CopyLink";
	    /**
	     * The item may be copied or moved to its new location.
	     */
	    DropActions[DropActions["CopyMove"] = 5] = "CopyMove";
	    /**
	     * The item may be linked or moved to its new location.
	     */
	    DropActions[DropActions["LinkMove"] = 6] = "LinkMove";
	    /**
	     * The item may be copied, linked, or moved to its new location.
	     */
	    DropActions[DropActions["All"] = 7] = "All";
	})(exports.DropActions || (exports.DropActions = {}));
	var DropActions = exports.DropActions;
	/**
	 * An object which stores MIME data for drag-drop operations.
	 *
	 * #### Notes
	 * This class does not attempt to enforce "correctness" of MIME types
	 * and their associated data. Since this drag-drop system is designed
	 * to transfer arbitrary data and objects within the same application,
	 * it assumes that the user provides correct and accurate data.
	 */
	var MimeData = (function () {
	    function MimeData() {
	        this._types = [];
	        this._values = [];
	    }
	    /**
	     * Get an array of the MIME types contains within the dataset.
	     *
	     * @returns A new array of the MIME types, in order of insertion.
	     */
	    MimeData.prototype.types = function () {
	        return this._types.slice();
	    };
	    /**
	     * Test whether the dataset has an entry for the given type.
	     *
	     * @param mime - The MIME type of interest.
	     *
	     * @returns `true` if the dataset contains a value for the given
	     *   MIME type, `false` otherwise.
	     */
	    MimeData.prototype.hasData = function (mime) {
	        return this._types.indexOf(mime) !== -1;
	    };
	    /**
	     * Get the data value for the given MIME type.
	     *
	     * @param mime - The MIME type of interest.
	     *
	     * @returns The value for the given MIME type, or `undefined` if
	     *   the dataset does not contain a value for the type.
	     */
	    MimeData.prototype.getData = function (mime) {
	        var i = this._types.indexOf(mime);
	        return i !== -1 ? this._values[i] : void 0;
	    };
	    /**
	     * Set the data value for the given MIME type.
	     *
	     * @param mime - The MIME type of interest.
	     *
	     * @param data - The data value for the given MIME type.
	     *
	     * #### Notes
	     * This will overwrite any previous entry for the MIME type.
	     */
	    MimeData.prototype.setData = function (mime, data) {
	        this.clearData(mime);
	        this._types.push(mime);
	        this._values.push(data);
	    };
	    /**
	     * Remove the data entry for the given MIME type.
	     *
	     * @param mime - The MIME type of interest.
	     *
	     * #### Notes
	     * This is a no-op if there is no entry for the given MIME type.
	     */
	    MimeData.prototype.clearData = function (mime) {
	        var i = this._types.indexOf(mime);
	        if (i === -1)
	            return;
	        this._types.splice(i, 1);
	        this._values.splice(i, 1);
	    };
	    /**
	     * Remove all data entries from the dataset.
	     */
	    MimeData.prototype.clear = function () {
	        this._types.length = 0;
	        this._values.length = 0;
	    };
	    return MimeData;
	}());
	exports.MimeData = MimeData;
	/**
	 * An object which manages a drag-drop operation.
	 *
	 * A drag object dispatches four different events to drop targets:
	 *
	 * - `'p-dragenter'` - Dispatched when the mouse enters the target
	 *   element. This event must be canceled in order to receive any
	 *   of the other events.
	 *
	 * - `'p-dragover'` - Dispatched when the mouse moves over the drop
	 *   target. It must cancel the event and set the `dropAction` to one
	 *   of the supported actions in order to receive drop events.
	 *
	 * - `'p-dragleave'` - Dispatched when the mouse leaves the target
	 *   element. This includes moving the mouse into child elements.
	 *
	 * - `'p-drop'`- Dispatched when the mouse is released over the target
	 *   element when the target indicates an appropriate drop action. If
	 *   the event is canceled, the indicated drop action is returned to
	 *   the initiator through the resolved promise.
	 *
	 * A drag operation can be canceled at any time by pressing `Escape`
	 * or by disposing the drag object.
	 *
	 * #### Notes
	 * This class is designed to be used when dragging and dropping custom
	 * data *within* a single application. It is *not* a replacement for
	 * the native drag-drop API. Instead, it provides an API which allows
	 * drag operations to be initiated programmatically and enables the
	 * transfer of arbitrary non-string objects; two features which are
	 * not possible with the native drag-drop APIs.
	 */
	var Drag = (function () {
	    /**
	     * Construct a new drag object.
	     *
	     * @param options - The options for initializing the drag.
	     */
	    function Drag(options) {
	        this._disposed = false;
	        this._source = null;
	        this._mimeData = null;
	        this._dragImage = null;
	        this._dropAction = DropAction.None;
	        this._proposedAction = DropAction.Copy;
	        this._supportedActions = DropActions.Copy;
	        this._override = null;
	        this._currentTarget = null;
	        this._currentElement = null;
	        this._promise = null;
	        this._resolve = null;
	        this._mimeData = options.mimeData;
	        if (options.dragImage !== void 0) {
	            this._dragImage = options.dragImage;
	        }
	        if (options.proposedAction !== void 0) {
	            this._proposedAction = options.proposedAction;
	        }
	        if (options.supportedActions !== void 0) {
	            this._supportedActions = options.supportedActions;
	        }
	        if (options.source !== void 0) {
	            this._source = options.source;
	        }
	    }
	    /**
	     * Dispose of the resources held by the drag object.
	     *
	     * #### Notes
	     * This will cancel the drag operation if it is active.
	     *
	     * All calls made after the first call to this method are a no-op.
	     */
	    Drag.prototype.dispose = function () {
	        // Do nothing if the drag object is already disposed.
	        if (this._disposed) {
	            return;
	        }
	        this._disposed = true;
	        // If there is a current target, dispatch a drag leave event.
	        if (this._currentTarget) {
	            var event_1 = createMouseEvent('mouseup', -1, -1);
	            dispatchDragLeave(this, this._currentTarget, null, event_1);
	        }
	        // Finalize the drag object with `None`.
	        this._finalize(DropAction.None);
	    };
	    Object.defineProperty(Drag.prototype, "isDisposed", {
	        /**
	         * Test whether the drag object is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._disposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "mimeData", {
	        /**
	         * Get the mime data for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._mimeData;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "dragImage", {
	        /**
	         * Get the drag image element for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._dragImage;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "proposedAction", {
	        /**
	         * Get the proposed drop action for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._proposedAction;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "supportedActions", {
	        /**
	         * Get the supported drop actions for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._supportedActions;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Drag.prototype, "source", {
	        /**
	         * Get the drag source for the drag object.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._source;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Start the drag operation at the specified client position.
	     *
	     * @param clientX - The client X position for the drag start.
	     *
	     * @param clientY - The client Y position for the drag start.
	     *
	     * @returns A promise which resolves to the result of the drag.
	     *
	     * #### Notes
	     * If the drag has already been started, the promise created by the
	     * first call to `start` is returned.
	     *
	     * If the drag operation has ended, or if the drag object has been
	     * disposed, the returned promise will resolve to `DropAction.None`.
	     *
	     * The drag object will be automatically disposed when drag operation
	     * completes. This makes `Drag` objects suitable for single use only.
	     *
	     * This method assumes the left mouse button is already held down.
	     */
	    Drag.prototype.start = function (clientX, clientY) {
	        var _this = this;
	        // If the drag object is already disposed, resolve to `None`.
	        if (this._disposed) {
	            return Promise.resolve(DropAction.None);
	        }
	        // If the drag has already been started, return the promise.
	        if (this._promise) {
	            return this._promise;
	        }
	        // Install the document listeners for the drag object.
	        this._addListeners();
	        // Attach the drag image at the specified client position.
	        this._attachDragImage(clientX, clientY);
	        // Create the promise which will be resolved on completion.
	        this._promise = new Promise(function (resolve, reject) {
	            _this._resolve = resolve;
	        });
	        // Trigger a fake move event to kick off the drag operation.
	        var event = createMouseEvent('mousemove', clientX, clientY);
	        document.dispatchEvent(event);
	        // Return the pending promise for the drag operation.
	        return this._promise;
	    };
	    /**
	     * Handle the DOM events for the drag operation.
	     *
	     * @param event - The DOM event sent to the drag object.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the document. It should not be
	     * called directly by user code.
	     */
	    Drag.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'mousemove':
	                this._evtMouseMove(event);
	                break;
	            case 'mouseup':
	                this._evtMouseUp(event);
	                break;
	            case 'keydown':
	                this._evtKeyDown(event);
	                break;
	            default:
	                // Stop all other events during drag-drop.
	                event.preventDefault();
	                event.stopPropagation();
	                break;
	        }
	    };
	    /**
	     * Handle the `'mousemove'` event for the drag object.
	     */
	    Drag.prototype._evtMouseMove = function (event) {
	        // Stop all input events during drag-drop.
	        event.preventDefault();
	        event.stopPropagation();
	        // Update the current target node and dispatch enter/leave events.
	        this._updateCurrentTarget(event);
	        // Move the drag image to the specified client position. This is
	        // performed *after* dispatching to prevent unnecessary reflows.
	        this._moveDragImage(event.clientX, event.clientY);
	    };
	    /**
	     * Handle the `'mouseup'` event for the drag object.
	     */
	    Drag.prototype._evtMouseUp = function (event) {
	        // Stop all input events during drag-drop.
	        event.preventDefault();
	        event.stopPropagation();
	        // Do nothing if the left button is not released.
	        if (event.button !== 0) {
	            return;
	        }
	        // Update the current target node and dispatch enter/leave events.
	        // This prevents a subtle issue where the DOM mutates under the
	        // cursor after the last move event but before the drop event.
	        this._updateCurrentTarget(event);
	        // If there is no current target, finalize with `None`.
	        if (!this._currentTarget) {
	            this._finalize(DropAction.None);
	            return;
	        }
	        // If the last drop action was `None`, dispatch a leave event
	        // to the current target and finalize the drag with `None`.
	        if (this._dropAction === DropAction.None) {
	            dispatchDragLeave(this, this._currentTarget, null, event);
	            this._finalize(DropAction.None);
	            return;
	        }
	        // Dispatch the drop event at the current target and finalize
	        // with the resulting drop action.
	        var action = dispatchDrop(this, this._currentTarget, event);
	        this._finalize(action);
	    };
	    /**
	     * Handle the `'keydown'` event for the drag object.
	     */
	    Drag.prototype._evtKeyDown = function (event) {
	        // Stop all input events during drag-drop.
	        event.preventDefault();
	        event.stopPropagation();
	        // Cancel the drag if `Escape` is pressed.
	        if (event.keyCode === 27)
	            this.dispose();
	    };
	    /**
	     * Add the document event listeners for the drag object.
	     */
	    Drag.prototype._addListeners = function () {
	        document.addEventListener('mousedown', this, true);
	        document.addEventListener('mousemove', this, true);
	        document.addEventListener('mouseup', this, true);
	        document.addEventListener('mouseenter', this, true);
	        document.addEventListener('mouseleave', this, true);
	        document.addEventListener('mouseover', this, true);
	        document.addEventListener('mouseout', this, true);
	        document.addEventListener('keydown', this, true);
	        document.addEventListener('keyup', this, true);
	        document.addEventListener('keypress', this, true);
	        document.addEventListener('contextmenu', this, true);
	    };
	    /**
	     * Remove the document event listeners for the drag object.
	     */
	    Drag.prototype._removeListeners = function () {
	        document.removeEventListener('mousedown', this, true);
	        document.removeEventListener('mousemove', this, true);
	        document.removeEventListener('mouseup', this, true);
	        document.removeEventListener('mouseenter', this, true);
	        document.removeEventListener('mouseleave', this, true);
	        document.removeEventListener('mouseover', this, true);
	        document.removeEventListener('mouseout', this, true);
	        document.removeEventListener('keydown', this, true);
	        document.removeEventListener('keyup', this, true);
	        document.removeEventListener('keypress', this, true);
	        document.removeEventListener('contextmenu', this, true);
	    };
	    /**
	     * Update the current target node using the given mouse event.
	     */
	    Drag.prototype._updateCurrentTarget = function (event) {
	        // Fetch common local state.
	        var prevTarget = this._currentTarget;
	        var currTarget = this._currentTarget;
	        var prevElem = this._currentElement;
	        // Find the current indicated element at the given position.
	        var currElem = document.elementFromPoint(event.clientX, event.clientY);
	        // Update the current element reference.
	        this._currentElement = currElem;
	        // Note: drag enter fires *before* drag leave according to spec.
	        // https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	        // If the indicated element changes from the previous iteration,
	        // and is different from the current target, dispatch the enter
	        // events and compute the new target element.
	        if (currElem !== prevElem && currElem !== currTarget) {
	            currTarget = dispatchDragEnter(this, currElem, currTarget, event);
	        }
	        // If the current target element has changed, update the current
	        // target reference and dispatch the leave event to the old target.
	        if (currTarget !== prevTarget) {
	            this._currentTarget = currTarget;
	            dispatchDragLeave(this, prevTarget, currTarget, event);
	        }
	        // Dispatch the drag over event and update the drop action.
	        var action = dispatchDragOver(this, currTarget, event);
	        this._setDropAction(action);
	    };
	    /**
	     * Attach the drag image element at the specified location.
	     *
	     * This is a no-op if there is no drag image element.
	     */
	    Drag.prototype._attachDragImage = function (clientX, clientY) {
	        if (!this._dragImage) {
	            return;
	        }
	        this._dragImage.classList.add(DRAG_IMAGE_CLASS);
	        var style = this._dragImage.style;
	        style.pointerEvents = 'none';
	        style.position = 'absolute';
	        style.top = clientY + "px";
	        style.left = clientX + "px";
	        document.body.appendChild(this._dragImage);
	    };
	    /**
	     * Move the drag image element to the specified location.
	     *
	     * This is a no-op if there is no drag image element.
	     */
	    Drag.prototype._moveDragImage = function (clientX, clientY) {
	        if (!this._dragImage) {
	            return;
	        }
	        var style = this._dragImage.style;
	        style.top = clientY + "px";
	        style.left = clientX + "px";
	    };
	    /**
	     * Detach the drag image element from the DOM.
	     *
	     * This is a no-op if there is no drag image element.
	     */
	    Drag.prototype._detachDragImage = function () {
	        if (!this._dragImage) {
	            return;
	        }
	        var parent = this._dragImage.parentNode;
	        if (!parent) {
	            return;
	        }
	        parent.removeChild(this._dragImage);
	    };
	    /**
	     * Set the internal drop action state and update the drag cursor.
	     */
	    Drag.prototype._setDropAction = function (action) {
	        if ((action & this._supportedActions) === 0) {
	            action = DropAction.None;
	        }
	        if (this._override && this._dropAction === action) {
	            return;
	        }
	        switch (action) {
	            case DropAction.None:
	                this._dropAction = action;
	                this._override = phosphor_domutil_1.overrideCursor('no-drop');
	                break;
	            case DropAction.Copy:
	                this._dropAction = action;
	                this._override = phosphor_domutil_1.overrideCursor('copy');
	                break;
	            case DropAction.Link:
	                this._dropAction = action;
	                this._override = phosphor_domutil_1.overrideCursor('alias');
	                break;
	            case DropAction.Move:
	                this._dropAction = action;
	                this._override = phosphor_domutil_1.overrideCursor('move');
	                break;
	        }
	    };
	    /**
	     * Finalize the drag operation and resolve the drag promise.
	     */
	    Drag.prototype._finalize = function (action) {
	        // Store the resolve function as a temp variable.
	        var resolve = this._resolve;
	        // Remove the document event listeners.
	        this._removeListeners();
	        // Detach the drag image.
	        this._detachDragImage();
	        // Dispose of the cursor override.
	        if (this._override)
	            this._override.dispose();
	        // Clear the mime data.
	        if (this._mimeData)
	            this._mimeData.clear();
	        // Clear the internal drag state.
	        this._disposed = true;
	        this._source = null;
	        this._mimeData = null;
	        this._dragImage = null;
	        this._dropAction = DropAction.None;
	        this._proposedAction = DropAction.None;
	        this._supportedActions = DropActions.None;
	        this._override = null;
	        this._currentTarget = null;
	        this._currentElement = null;
	        this._promise = null;
	        this._resolve = null;
	        // Resolve the promise to the given drop action, if possible.
	        if (resolve)
	            resolve(action);
	    };
	    return Drag;
	}());
	exports.Drag = Drag;
	/**
	 * Create a left mouse event at the given position.
	 *
	 * @param type - The event type for the mouse event.
	 *
	 * @param clientX - The client X position.
	 *
	 * @param clientY - The client Y position.
	 *
	 * @returns A newly created and initialized mouse event.
	 */
	function createMouseEvent(type, clientX, clientY) {
	    var event = document.createEvent('MouseEvent');
	    event.initMouseEvent(type, true, true, window, 0, 0, 0, clientX, clientY, false, false, false, false, 0, null);
	    return event;
	}
	/**
	 * Create a new initialized `IDragEvent` from the given data.
	 *
	 * @param type - The event type for the drag event.
	 *
	 * @param drag - The drag object to use for seeding the drag data.
	 *
	 * @param event - The mouse event to use for seeding the mouse data.
	 *
	 * @param related - The related target for the event, or `null`.
	 *
	 * @returns A new object which implements `IDragEvent`.
	 */
	function createDragEvent(type, drag, event, related) {
	    // Create a new mouse event and cast to a custom drag event.
	    var dragEvent = document.createEvent('MouseEvent');
	    // Initialize the mouse event data.
	    dragEvent.initMouseEvent(type, true, true, window, 0, event.screenX, event.screenY, event.clientX, event.clientY, event.ctrlKey, event.altKey, event.shiftKey, event.metaKey, event.button, related);
	    // Add the custom drag event data.
	    dragEvent.mimeData = drag.mimeData;
	    dragEvent.dropAction = DropAction.None;
	    dragEvent.proposedAction = drag.proposedAction;
	    dragEvent.supportedActions = drag.supportedActions;
	    dragEvent.source = drag.source;
	    // Return the fully initialized drag event.
	    return dragEvent;
	}
	/**
	 * Dispatch a drag enter event to the indicated element.
	 *
	 * @param drag - The drag object associated with the action.
	 *
	 * @param currElem - The currently indicated element, or `null`. This
	 *   is the "immediate user selection" from the whatwg spec.
	 *
	 * @param currTarget - The current drag target element, or `null`. This
	 *   is the "current target element" from the whatwg spec.
	 *
	 * @param event - The mouse event related to the action.
	 *
	 * @returns The element to use as the current drag target. This is the
	 *   "current target element" from the whatwg spec, and may be `null`.
	 *
	 * #### Notes
	 * This largely implements the drag enter portion of the whatwg spec:
	 * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	 */
	function dispatchDragEnter(drag, currElem, currTarget, event) {
	    // If the current element is null, return null as the new target.
	    if (!currElem) {
	        return null;
	    }
	    // Dispatch a drag enter event to the current element.
	    var dragEvent = createDragEvent('p-dragenter', drag, event, currTarget);
	    var canceled = !currElem.dispatchEvent(dragEvent);
	    // If the event was canceled, use the current element as the new target.
	    if (canceled) {
	        return currElem;
	    }
	    // If the current element is the document body, keep the original target.
	    if (currElem === document.body) {
	        return currTarget;
	    }
	    // Dispatch a drag enter event on the document body.
	    dragEvent = createDragEvent('p-dragenter', drag, event, currTarget);
	    document.body.dispatchEvent(dragEvent);
	    // Ignore the event cancellation, and use the body as the new target.
	    return document.body;
	}
	/**
	 * Dispatch a drag leave event to the indicated element.
	 *
	 * @param drag - The drag object associated with the action.
	 *
	 * @param prevTarget - The previous target element, or `null`. This
	 *   is the previous "current target element" from the whatwg spec.
	 *
	 * @param currTarget - The current drag target element, or `null`. This
	 *   is the "current target element" from the whatwg spec.
	 *
	 * @param event - The mouse event related to the action.
	 *
	 * #### Notes
	 * This largely implements the drag leave portion of the whatwg spec:
	 * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	 */
	function dispatchDragLeave(drag, prevTarget, currTarget, event) {
	    // If the previous target is null, do nothing.
	    if (!prevTarget) {
	        return;
	    }
	    // Dispatch the drag leave event to the previous target.
	    var dragEvent = createDragEvent('p-dragleave', drag, event, currTarget);
	    prevTarget.dispatchEvent(dragEvent);
	}
	/**
	 * Dispatch a drag over event to the indicated element.
	 *
	 * @param drag - The drag object associated with the action.
	 *
	 * @param currTarget - The current drag target element, or `null`. This
	 *   is the "current target element" from the whatwg spec.
	 *
	 * @param event - The mouse event related to the action.
	 *
	 * @returns The `DropAction` result of the drag over event.
	 *
	 * #### Notes
	 * This largely implements the drag over portion of the whatwg spec:
	 * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	 */
	function dispatchDragOver(drag, currTarget, event) {
	    // If there is no current target, the drop action is none.
	    if (!currTarget) {
	        return DropAction.None;
	    }
	    // Dispatch the drag over event to the current target.
	    var dragEvent = createDragEvent('p-dragover', drag, event, null);
	    var canceled = !currTarget.dispatchEvent(dragEvent);
	    // If the event was canceled, return the drop action result.
	    if (canceled) {
	        return dragEvent.dropAction;
	    }
	    // Otherwise, the effective drop action is none.
	    return DropAction.None;
	}
	/**
	 * Dispatch a drop event to the indicated element.
	 *
	 * @param drag - The drag object associated with the action.
	 *
	 * @param currTarget - The current drag target element, or `null`. This
	 *   is the "current target element" from the whatwg spec.
	 *
	 * @param event - The mouse event related to the action.
	 *
	 * @returns The `DropAction` result of the drop event.
	 *
	 * #### Notes
	 * This largely implements the drag over portion of the whatwg spec:
	 * https://html.spec.whatwg.org/multipage/interaction.html#drag-and-drop-processing-model
	 */
	function dispatchDrop(drag, currTarget, event) {
	    // If there is no current target, the drop action is none.
	    if (!currTarget) {
	        return DropAction.None;
	    }
	    // Dispatch the drop event to the current target.
	    var dragEvent = createDragEvent('p-drop', drag, event, null);
	    var canceled = !currTarget.dispatchEvent(dragEvent);
	    // If the event was canceled, return the drop action result.
	    if (canceled) {
	        return dragEvent.dropAction;
	    }
	    // Otherwise, the effective drop action is none.
	    return DropAction.None;
	}


/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(33));
	__export(__webpack_require__(34));
	__webpack_require__(35);


/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var arrays = __webpack_require__(3);
	var phosphor_boxengine_1 = __webpack_require__(6);
	var phosphor_domutil_1 = __webpack_require__(7);
	var phosphor_messaging_1 = __webpack_require__(13);
	var phosphor_panel_1 = __webpack_require__(18);
	var phosphor_properties_1 = __webpack_require__(17);
	var phosphor_widget_1 = __webpack_require__(20);
	/**
	 * The class name added to hidden split handles.
	 */
	var HIDDEN_CLASS = 'p-mod-hidden';
	/**
	 * The class name added to horizontal split panels.
	 */
	var HORIZONTAL_CLASS = 'p-mod-horizontal';
	/**
	 * The class name added to vertical split panels.
	 */
	var VERTICAL_CLASS = 'p-mod-vertical';
	/**
	 * The orientation of a split layout.
	 */
	(function (Orientation) {
	    /**
	     * Left-to-right horizontal orientation.
	     */
	    Orientation[Orientation["Horizontal"] = 0] = "Horizontal";
	    /**
	     * Top-to-bottom vertical orientation.
	     */
	    Orientation[Orientation["Vertical"] = 1] = "Vertical";
	})(exports.Orientation || (exports.Orientation = {}));
	var Orientation = exports.Orientation;
	/**
	 * A layout which arranges its children into resizable sections.
	 */
	var SplitLayout = (function (_super) {
	    __extends(SplitLayout, _super);
	    /**
	     * Construct a new split layout.
	     *
	     * @param factory - The handle factory for creating split handles.
	     */
	    function SplitLayout(factory) {
	        _super.call(this);
	        this._fixed = 0;
	        this._spacing = 3;
	        this._normed = false;
	        this._box = null;
	        this._sizers = [];
	        this._handles = [];
	        this._orientation = Orientation.Horizontal;
	        this._factory = factory;
	    }
	    Object.defineProperty(SplitLayout.prototype, "orientation", {
	        /**
	         * Get the layout orientation for the split layout.
	         */
	        get: function () {
	            return this._orientation;
	        },
	        /**
	         * Set the layout orientation for the split layout.
	         */
	        set: function (value) {
	            if (this._orientation === value) {
	                return;
	            }
	            this._orientation = value;
	            if (!this.parent) {
	                return;
	            }
	            SplitLayoutPrivate.toggleOrientation(this.parent, value);
	            this.parent.fit();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SplitLayout.prototype, "spacing", {
	        /**
	         * Get the inter-element spacing for the split layout.
	         */
	        get: function () {
	            return this._spacing;
	        },
	        /**
	         * Set the inter-element spacing for the split layout.
	         */
	        set: function (value) {
	            value = Math.max(0, value | 0);
	            if (this._spacing === value) {
	                return;
	            }
	            this._spacing = value;
	            if (!this.parent) {
	                return;
	            }
	            this.parent.fit();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the normalized sizes of the widgets in the layout.
	     *
	     * @returns The normalized sizes of the widgets in the layout.
	     */
	    SplitLayout.prototype.sizes = function () {
	        return SplitLayoutPrivate.normalize(this._sizers.map(function (s) { return s.size; }));
	    };
	    /**
	     * Set the relative sizes for the child widgets in the layout.
	     *
	     * @param sizes - The relative sizes for the children in the layout.
	     *   These values will be normalized to the available layout space.
	     *
	     * #### Notes
	     * Extra values are ignored, too few will yield an undefined layout.
	     */
	    SplitLayout.prototype.setSizes = function (sizes) {
	        var normed = SplitLayoutPrivate.normalize(sizes);
	        for (var i = 0, n = this._sizers.length; i < n; ++i) {
	            var hint = Math.max(0, normed[i] || 0);
	            var sizer = this._sizers[i];
	            sizer.sizeHint = hint;
	            sizer.size = hint;
	        }
	        this._normed = true;
	        if (this.parent)
	            this.parent.update();
	    };
	    /**
	     * Get the handle for the widget at the given index.
	     *
	     * @param index - The index of the handle of interest.
	     *
	     * @returns The handle for the given index, or `undefined`.
	     */
	    SplitLayout.prototype.handleAt = function (index) {
	        return this._handles[index];
	    };
	    /**
	     * Move a split handle to the specified offset position.
	     *
	     * @param index - The index of the handle of the interest.
	     *
	     * @param position - The desired offset position of the handle. This
	     *   is the absolute position relative to the origin of the parent.
	     *
	     * #### Notes
	     * This will move the handle as close as possible to the desired
	     * position. The sibling children will be adjusted as necessary.
	     */
	    SplitLayout.prototype.moveHandle = function (index, position) {
	        // Bail if the index is invalid or the handle is hidden.
	        var handle = this._handles[index];
	        if (!handle || handle.classList.contains(HIDDEN_CLASS)) {
	            return;
	        }
	        // Compute the delta movement for the handle.
	        var delta;
	        if (this._orientation === Orientation.Horizontal) {
	            delta = position - handle.offsetLeft;
	        }
	        else {
	            delta = position - handle.offsetTop;
	        }
	        // Bail if there is no handle movement.
	        if (delta === 0) {
	            return;
	        }
	        // Prevent item resizing unless needed.
	        for (var _i = 0, _a = this._sizers; _i < _a.length; _i++) {
	            var sizer = _a[_i];
	            if (sizer.size > 0)
	                sizer.sizeHint = sizer.size;
	        }
	        // Adjust the sizers to reflect the movement.
	        if (delta > 0) {
	            SplitLayoutPrivate.growSizer(this._sizers, index, delta);
	        }
	        else {
	            SplitLayoutPrivate.shrinkSizer(this._sizers, index, -delta);
	        }
	        // Update the layout of the child widgets.
	        if (this.parent)
	            this.parent.update();
	    };
	    /**
	     * Initialize the children of the layout.
	     *
	     * #### Notes
	     * This method is called automatically when the layout is installed
	     * on its parent widget.
	     */
	    SplitLayout.prototype.initialize = function () {
	        SplitLayoutPrivate.toggleOrientation(this.parent, this.orientation);
	        _super.prototype.initialize.call(this);
	    };
	    /**
	     * Attach a child widget to the parent's DOM node.
	     *
	     * @param index - The current index of the child in the layout.
	     *
	     * @param child - The child widget to attach to the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    SplitLayout.prototype.attachChild = function (index, child) {
	        var handle = SplitLayoutPrivate.createHandle(this._factory);
	        var average = SplitLayoutPrivate.averageSize(this._sizers);
	        var sizer = SplitLayoutPrivate.createSizer(average);
	        arrays.insert(this._sizers, index, sizer);
	        arrays.insert(this._handles, index, handle);
	        SplitLayoutPrivate.prepareGeometry(child);
	        this.parent.node.appendChild(child.node);
	        this.parent.node.appendChild(handle);
	        if (this.parent.isAttached)
	            phosphor_messaging_1.sendMessage(child, phosphor_widget_1.Widget.MsgAfterAttach);
	        this.parent.fit();
	    };
	    /**
	     * Move a child widget in the parent's DOM node.
	     *
	     * @param fromIndex - The previous index of the child in the layout.
	     *
	     * @param toIndex - The current index of the child in the layout.
	     *
	     * @param child - The child widget to move in the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    SplitLayout.prototype.moveChild = function (fromIndex, toIndex, child) {
	        arrays.move(this._sizers, fromIndex, toIndex);
	        arrays.move(this._handles, fromIndex, toIndex);
	        this.parent.fit(); // fit instead of update to show/hide handles
	    };
	    /**
	     * Detach a child widget from the parent's DOM node.
	     *
	     * @param index - The previous index of the child in the layout.
	     *
	     * @param child - The child widget to detach from the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    SplitLayout.prototype.detachChild = function (index, child) {
	        var sizer = arrays.removeAt(this._sizers, index);
	        var handle = arrays.removeAt(this._handles, index);
	        if (this.parent.isAttached)
	            phosphor_messaging_1.sendMessage(child, phosphor_widget_1.Widget.MsgBeforeDetach);
	        this.parent.node.removeChild(child.node);
	        this.parent.node.removeChild(handle);
	        SplitLayoutPrivate.resetGeometry(child);
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     */
	    SplitLayout.prototype.onAfterShow = function (msg) {
	        _super.prototype.onAfterShow.call(this, msg);
	        this.parent.update();
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    SplitLayout.prototype.onAfterAttach = function (msg) {
	        _super.prototype.onAfterAttach.call(this, msg);
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on a `'child-shown'` message.
	     */
	    SplitLayout.prototype.onChildShown = function (msg) {
	        if (SplitLayoutPrivate.IsIE) {
	            phosphor_messaging_1.sendMessage(this.parent, phosphor_widget_1.Widget.MsgFitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'child-hidden'` message.
	     */
	    SplitLayout.prototype.onChildHidden = function (msg) {
	        if (SplitLayoutPrivate.IsIE) {
	            phosphor_messaging_1.sendMessage(this.parent, phosphor_widget_1.Widget.MsgFitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     */
	    SplitLayout.prototype.onResize = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(msg.width, msg.height);
	        }
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    SplitLayout.prototype.onUpdateRequest = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(-1, -1);
	        }
	    };
	    /**
	     * A message handler invoked on a `'fit-request'` message.
	     */
	    SplitLayout.prototype.onFitRequest = function (msg) {
	        if (this.parent.isAttached) {
	            this._fit();
	        }
	    };
	    /**
	     * Fit the layout to the total size required by the child widgets.
	     */
	    SplitLayout.prototype._fit = function () {
	        // Update the handles and track the visible widget count.
	        var nVisible = 0;
	        var lastHandle = null;
	        for (var i = 0, n = this.childCount(); i < n; ++i) {
	            var handle = this._handles[i];
	            if (this.childAt(i).isHidden) {
	                handle.classList.add(HIDDEN_CLASS);
	            }
	            else {
	                handle.classList.remove(HIDDEN_CLASS);
	                lastHandle = handle;
	                nVisible++;
	            }
	        }
	        // Hide the handle for the last visible child.
	        if (lastHandle)
	            lastHandle.classList.add(HIDDEN_CLASS);
	        // Update the fixed space for the visible items.
	        this._fixed = this._spacing * Math.max(0, nVisible - 1);
	        // Setup the initial size limits.
	        var minW = 0;
	        var minH = 0;
	        var maxW = Infinity;
	        var maxH = Infinity;
	        var horz = this._orientation === Orientation.Horizontal;
	        if (horz) {
	            minW = this._fixed;
	            maxW = nVisible > 0 ? minW : maxW;
	        }
	        else {
	            minH = this._fixed;
	            maxH = nVisible > 0 ? minH : maxH;
	        }
	        // Update the sizers and computed size limits.
	        for (var i = 0, n = this.childCount(); i < n; ++i) {
	            var child = this.childAt(i);
	            var sizer = this._sizers[i];
	            if (sizer.size > 0) {
	                sizer.sizeHint = sizer.size;
	            }
	            if (child.isHidden) {
	                sizer.minSize = 0;
	                sizer.maxSize = 0;
	                continue;
	            }
	            var limits = phosphor_domutil_1.sizeLimits(child.node);
	            sizer.stretch = SplitLayout.getStretch(child);
	            if (horz) {
	                sizer.minSize = limits.minWidth;
	                sizer.maxSize = limits.maxWidth;
	                minW += limits.minWidth;
	                maxW += limits.maxWidth;
	                minH = Math.max(minH, limits.minHeight);
	                maxH = Math.min(maxH, limits.maxHeight);
	            }
	            else {
	                sizer.minSize = limits.minHeight;
	                sizer.maxSize = limits.maxHeight;
	                minH += limits.minHeight;
	                maxH += limits.maxHeight;
	                minW = Math.max(minW, limits.minWidth);
	                maxW = Math.min(maxW, limits.maxWidth);
	            }
	        }
	        // Update the box sizing and add it to the size constraints.
	        var box = this._box = phosphor_domutil_1.boxSizing(this.parent.node);
	        minW += box.horizontalSum;
	        minH += box.verticalSum;
	        maxW += box.horizontalSum;
	        maxH += box.verticalSum;
	        // Update the parent's size constraints.
	        var style = this.parent.node.style;
	        style.minWidth = minW + "px";
	        style.minHeight = minH + "px";
	        style.maxWidth = maxW === Infinity ? 'none' : maxW + "px";
	        style.maxHeight = maxH === Infinity ? 'none' : maxH + "px";
	        // Notify the ancestor that it should fit immediately.
	        var ancestor = this.parent.parent;
	        if (ancestor)
	            phosphor_messaging_1.sendMessage(ancestor, phosphor_widget_1.Widget.MsgFitRequest);
	        // Notify the parent that it should update immediately.
	        phosphor_messaging_1.sendMessage(this.parent, phosphor_widget_1.Widget.MsgUpdateRequest);
	    };
	    /**
	     * Update the layout position and size of the child widgets.
	     *
	     * The parent offset dimensions should be `-1` if unknown.
	     */
	    SplitLayout.prototype._update = function (offsetWidth, offsetHeight) {
	        // Bail early if there are no children to layout.
	        if (this.childCount() === 0) {
	            return;
	        }
	        // Measure the parent if the offset dimensions are unknown.
	        if (offsetWidth < 0) {
	            offsetWidth = this.parent.node.offsetWidth;
	        }
	        if (offsetHeight < 0) {
	            offsetHeight = this.parent.node.offsetHeight;
	        }
	        // Ensure the parent box sizing data is computed.
	        var box = this._box || (this._box = phosphor_domutil_1.boxSizing(this.parent.node));
	        // Compute the actual layout bounds adjusted for border and padding.
	        var top = box.paddingTop;
	        var left = box.paddingLeft;
	        var width = offsetWidth - box.horizontalSum;
	        var height = offsetHeight - box.verticalSum;
	        // Compute the adjusted layout space.
	        var space;
	        var horz = this._orientation === Orientation.Horizontal;
	        if (horz) {
	            space = Math.max(0, width - this._fixed);
	        }
	        else {
	            space = Math.max(0, height - this._fixed);
	        }
	        // Scale the size hints if they are normalized.
	        if (this._normed) {
	            for (var _i = 0, _a = this._sizers; _i < _a.length; _i++) {
	                var sizer = _a[_i];
	                sizer.sizeHint *= space;
	            }
	            this._normed = false;
	        }
	        // Distribute the layout space to the box sizers.
	        phosphor_boxengine_1.boxCalc(this._sizers, space);
	        // Layout the children using the computed box sizes.
	        var spacing = this._spacing;
	        for (var i = 0, n = this.childCount(); i < n; ++i) {
	            var child = this.childAt(i);
	            if (child.isHidden) {
	                continue;
	            }
	            var handle = this._handles[i];
	            var size = this._sizers[i].size;
	            if (horz) {
	                SplitLayoutPrivate.setGeometry(child, left, top, size, height);
	                left += size;
	                SplitLayoutPrivate.setHandleGeo(handle, left, top, spacing, height);
	                left += spacing;
	            }
	            else {
	                SplitLayoutPrivate.setGeometry(child, left, top, width, size);
	                top += size;
	                SplitLayoutPrivate.setHandleGeo(handle, left, top, width, spacing);
	                top += spacing;
	            }
	        }
	    };
	    return SplitLayout;
	})(phosphor_panel_1.PanelLayout);
	exports.SplitLayout = SplitLayout;
	/**
	 * The namespace for the `SplitLayout` class statics.
	 */
	var SplitLayout;
	(function (SplitLayout) {
	    /**
	     * A convenience alias of the `Horizontal` [[Orientation]].
	     */
	    SplitLayout.Horizontal = Orientation.Horizontal;
	    /**
	     * A convenience alias of the `Vertical` [[Orientation]].
	     */
	    SplitLayout.Vertical = Orientation.Vertical;
	    /**
	     * Get the split layout stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The split layout stretch factor for the widget.
	     */
	    function getStretch(widget) {
	        return SplitLayoutPrivate.stretchProperty.get(widget);
	    }
	    SplitLayout.getStretch = getStretch;
	    /**
	     * Set the split layout stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the stretch factor.
	     */
	    function setStretch(widget, value) {
	        SplitLayoutPrivate.stretchProperty.set(widget, value);
	    }
	    SplitLayout.setStretch = setStretch;
	})(SplitLayout = exports.SplitLayout || (exports.SplitLayout = {}));
	/**
	 * The namespace for the `SplitLayout` class private data.
	 */
	var SplitLayoutPrivate;
	(function (SplitLayoutPrivate) {
	    /**
	     * A flag indicating whether the browser is IE.
	     */
	    SplitLayoutPrivate.IsIE = /Trident/.test(navigator.userAgent);
	    /**
	     * The property descriptor for a widget stretch factor.
	     */
	    SplitLayoutPrivate.stretchProperty = new phosphor_properties_1.Property({
	        name: 'stretch',
	        value: 0,
	        coerce: function (owner, value) { return Math.max(0, value | 0); },
	        changed: onChildPropertyChanged,
	    });
	    /**
	     * Create a new box sizer with the given size hint.
	     */
	    function createSizer(size) {
	        var sizer = new phosphor_boxengine_1.BoxSizer();
	        sizer.sizeHint = size | 0;
	        return sizer;
	    }
	    SplitLayoutPrivate.createSizer = createSizer;
	    /**
	     * Create a new split handle using the given factory.
	     */
	    function createHandle(factory) {
	        var handle = factory.createHandle();
	        handle.style.position = 'absolute';
	        return handle;
	    }
	    SplitLayoutPrivate.createHandle = createHandle;
	    /**
	     * Toggle the CSS orientation class for the given widget.
	     */
	    function toggleOrientation(widget, orient) {
	        widget.toggleClass(HORIZONTAL_CLASS, orient === Orientation.Horizontal);
	        widget.toggleClass(VERTICAL_CLASS, orient === Orientation.Vertical);
	    }
	    SplitLayoutPrivate.toggleOrientation = toggleOrientation;
	    /**
	     * Prepare the layout geometry for the given child widget.
	     */
	    function prepareGeometry(widget) {
	        widget.node.style.position = 'absolute';
	    }
	    SplitLayoutPrivate.prepareGeometry = prepareGeometry;
	    /**
	     * Reset the layout geometry for the given child widget.
	     */
	    function resetGeometry(widget) {
	        var rect = rectProperty.get(widget);
	        var style = widget.node.style;
	        rect.top = NaN;
	        rect.left = NaN;
	        rect.width = NaN;
	        rect.height = NaN;
	        style.position = '';
	        style.top = '';
	        style.left = '';
	        style.width = '';
	        style.height = '';
	    }
	    SplitLayoutPrivate.resetGeometry = resetGeometry;
	    /**
	     * Set the layout geometry of a child widget.
	     */
	    function setGeometry(widget, left, top, width, height) {
	        var resized = false;
	        var style = widget.node.style;
	        var rect = rectProperty.get(widget);
	        if (rect.top !== top) {
	            rect.top = top;
	            style.top = top + "px";
	        }
	        if (rect.left !== left) {
	            rect.left = left;
	            style.left = left + "px";
	        }
	        if (rect.width !== width) {
	            resized = true;
	            rect.width = width;
	            style.width = width + "px";
	        }
	        if (rect.height !== height) {
	            resized = true;
	            rect.height = height;
	            style.height = height + "px";
	        }
	        if (resized) {
	            phosphor_messaging_1.sendMessage(widget, new phosphor_widget_1.ResizeMessage(width, height));
	        }
	    }
	    SplitLayoutPrivate.setGeometry = setGeometry;
	    /**
	     * Set the layout geometry of a split handle.
	     */
	    function setHandleGeo(handle, left, top, width, height) {
	        var style = handle.style;
	        style.top = top + "px";
	        style.left = left + "px";
	        style.width = width + "px";
	        style.height = height + "px";
	    }
	    SplitLayoutPrivate.setHandleGeo = setHandleGeo;
	    /**
	     * Compute the average size of the given box sizers.
	     */
	    function averageSize(sizers) {
	        if (sizers.length === 0)
	            return 0;
	        return sizers.reduce(function (v, s) { return v + s.size; }, 0) / sizers.length;
	    }
	    SplitLayoutPrivate.averageSize = averageSize;
	    /**
	     * Normalize an array of positive values.
	     */
	    function normalize(values) {
	        var n = values.length;
	        if (n === 0) {
	            return [];
	        }
	        var sum = 0;
	        for (var i = 0; i < n; ++i) {
	            sum += values[i];
	        }
	        var result = new Array(n);
	        if (sum === 0) {
	            for (var i = 0; i < n; ++i) {
	                result[i] = 1 / n;
	            }
	        }
	        else {
	            for (var i = 0; i < n; ++i) {
	                result[i] = values[i] / sum;
	            }
	        }
	        return result;
	    }
	    SplitLayoutPrivate.normalize = normalize;
	    /**
	     * Grow a sizer to the right by a positive delta and adjust neighbors.
	     */
	    function growSizer(sizers, index, delta) {
	        var growLimit = 0;
	        for (var i = 0; i <= index; ++i) {
	            var sizer = sizers[i];
	            growLimit += sizer.maxSize - sizer.size;
	        }
	        var shrinkLimit = 0;
	        for (var i = index + 1, n = sizers.length; i < n; ++i) {
	            var sizer = sizers[i];
	            shrinkLimit += sizer.size - sizer.minSize;
	        }
	        delta = Math.min(delta, growLimit, shrinkLimit);
	        var grow = delta;
	        for (var i = index; i >= 0 && grow > 0; --i) {
	            var sizer = sizers[i];
	            var limit = sizer.maxSize - sizer.size;
	            if (limit >= grow) {
	                sizer.sizeHint = sizer.size + grow;
	                grow = 0;
	            }
	            else {
	                sizer.sizeHint = sizer.size + limit;
	                grow -= limit;
	            }
	        }
	        var shrink = delta;
	        for (var i = index + 1, n = sizers.length; i < n && shrink > 0; ++i) {
	            var sizer = sizers[i];
	            var limit = sizer.size - sizer.minSize;
	            if (limit >= shrink) {
	                sizer.sizeHint = sizer.size - shrink;
	                shrink = 0;
	            }
	            else {
	                sizer.sizeHint = sizer.size - limit;
	                shrink -= limit;
	            }
	        }
	    }
	    SplitLayoutPrivate.growSizer = growSizer;
	    /**
	     * Shrink a sizer to the left by a positive delta and adjust neighbors.
	     */
	    function shrinkSizer(sizers, index, delta) {
	        var growLimit = 0;
	        for (var i = index + 1, n = sizers.length; i < n; ++i) {
	            var sizer = sizers[i];
	            growLimit += sizer.maxSize - sizer.size;
	        }
	        var shrinkLimit = 0;
	        for (var i = 0; i <= index; ++i) {
	            var sizer = sizers[i];
	            shrinkLimit += sizer.size - sizer.minSize;
	        }
	        delta = Math.min(delta, growLimit, shrinkLimit);
	        var grow = delta;
	        for (var i = index + 1, n = sizers.length; i < n && grow > 0; ++i) {
	            var sizer = sizers[i];
	            var limit = sizer.maxSize - sizer.size;
	            if (limit >= grow) {
	                sizer.sizeHint = sizer.size + grow;
	                grow = 0;
	            }
	            else {
	                sizer.sizeHint = sizer.size + limit;
	                grow -= limit;
	            }
	        }
	        var shrink = delta;
	        for (var i = index; i >= 0 && shrink > 0; --i) {
	            var sizer = sizers[i];
	            var limit = sizer.size - sizer.minSize;
	            if (limit >= shrink) {
	                sizer.sizeHint = sizer.size - shrink;
	                shrink = 0;
	            }
	            else {
	                sizer.sizeHint = sizer.size - limit;
	                shrink -= limit;
	            }
	        }
	    }
	    SplitLayoutPrivate.shrinkSizer = shrinkSizer;
	    /**
	     * A property descriptor for a widget offset rect.
	     */
	    var rectProperty = new phosphor_properties_1.Property({
	        name: 'rect',
	        create: function () { return ({ top: NaN, left: NaN, width: NaN, height: NaN }); },
	    });
	    /**
	     * The change handler for the attached child properties.
	     */
	    function onChildPropertyChanged(child) {
	        var parent = child.parent;
	        var layout = parent && parent.layout;
	        if (layout instanceof SplitLayout)
	            parent.fit();
	    }
	})(SplitLayoutPrivate || (SplitLayoutPrivate = {}));


/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var phosphor_domutil_1 = __webpack_require__(7);
	var phosphor_panel_1 = __webpack_require__(18);
	var layout_1 = __webpack_require__(33);
	/**
	 * The class name added to SplitPanel instances.
	 */
	var SPLIT_PANEL_CLASS = 'p-SplitPanel';
	/**
	 * The class name added to split panel children.
	 */
	var CHILD_CLASS = 'p-SplitPanel-child';
	/**
	 * The class name added to split panel handles.
	 */
	var HANDLE_CLASS = 'p-SplitPanel-handle';
	/**
	 * A panel which arranges its children into resizable sections.
	 *
	 * #### Notes
	 * This class provides a convenience wrapper around a [[SplitLayout]].
	 */
	var SplitPanel = (function (_super) {
	    __extends(SplitPanel, _super);
	    /**
	     * Construct a new split panel.
	     */
	    function SplitPanel() {
	        _super.call(this);
	        this._pressData = null;
	        this.addClass(SPLIT_PANEL_CLASS);
	    }
	    /**
	     * Create a split layout for a split panel.
	     */
	    SplitPanel.createLayout = function () {
	        return new layout_1.SplitLayout(this);
	    };
	    /**
	     * Create a split handle for use in a split panel.
	     *
	     * #### Notes
	     * This may be reimplemented to create custom split handles.
	     */
	    SplitPanel.createHandle = function () {
	        var handle = document.createElement('div');
	        handle.className = HANDLE_CLASS;
	        return handle;
	    };
	    /**
	     * Dispose of the resources held by the panel.
	     */
	    SplitPanel.prototype.dispose = function () {
	        this._releaseMouse();
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(SplitPanel.prototype, "orientation", {
	        /**
	         * Get the layout orientation for the split panel.
	         */
	        get: function () {
	            return this.layout.orientation;
	        },
	        /**
	         * Set the layout orientation for the split panel.
	         */
	        set: function (value) {
	            this.layout.orientation = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SplitPanel.prototype, "spacing", {
	        /**
	         * Get the inter-element spacing for the split panel.
	         */
	        get: function () {
	            return this.layout.spacing;
	        },
	        /**
	         * Set the inter-element spacing for the split panel.
	         */
	        set: function (value) {
	            this.layout.spacing = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the normalized sizes of the widgets in the panel.
	     *
	     * @returns The normalized sizes of the widgets in the panel.
	     */
	    SplitPanel.prototype.sizes = function () {
	        return this.layout.sizes();
	    };
	    /**
	     * Set the relative sizes for the child widgets in the panel.
	     *
	     * @param sizes - The relative sizes for the children in the panel.
	     *   These values will be normalized to the available layout space.
	     *
	     * #### Notes
	     * Extra values are ignored, too few will yield an undefined layout.
	     */
	    SplitPanel.prototype.setSizes = function (sizes) {
	        this.layout.setSizes(sizes);
	    };
	    /**
	     * Get the split handle for the widget at the given index.
	     *
	     * @param index - The index of the widget of interest.
	     *
	     * @returns The split handle for the widget, or `undefined`.
	     */
	    SplitPanel.prototype.handleAt = function (index) {
	        return this.layout.handleAt(index);
	    };
	    /**
	     * Handle the DOM events for the split panel.
	     *
	     * @param event - The DOM event sent to the panel.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the panel's DOM node. It should
	     * not be called directly by user code.
	     */
	    SplitPanel.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'mousedown':
	                this._evtMouseDown(event);
	                break;
	            case 'mousemove':
	                this._evtMouseMove(event);
	                break;
	            case 'mouseup':
	                this._evtMouseUp(event);
	                break;
	            case 'keydown':
	                this._evtKeyDown(event);
	                break;
	            case 'keyup':
	            case 'keypress':
	            case 'contextmenu':
	                // Stop all input events during drag.
	                event.preventDefault();
	                event.stopPropagation();
	                break;
	        }
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    SplitPanel.prototype.onAfterAttach = function (msg) {
	        this.node.addEventListener('mousedown', this);
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     */
	    SplitPanel.prototype.onBeforeDetach = function (msg) {
	        this.node.removeEventListener('mousedown', this);
	        this._releaseMouse();
	    };
	    /**
	     * A message handler invoked on a `'child-added'` message.
	     */
	    SplitPanel.prototype.onChildAdded = function (msg) {
	        msg.child.addClass(CHILD_CLASS);
	        this._releaseMouse();
	    };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     */
	    SplitPanel.prototype.onChildRemoved = function (msg) {
	        msg.child.removeClass(CHILD_CLASS);
	        this._releaseMouse();
	    };
	    /**
	     * Handle the `'keydown'` event for the split panel.
	     */
	    SplitPanel.prototype._evtKeyDown = function (event) {
	        // Stop all input events during drag.
	        event.preventDefault();
	        event.stopPropagation();
	        // Release the mouse if `Escape` is pressed.
	        if (event.keyCode === 27)
	            this._releaseMouse();
	    };
	    /**
	     * Handle the `'mousedown'` event for the split panel.
	     */
	    SplitPanel.prototype._evtMouseDown = function (event) {
	        // Do nothing if the left mouse button is not pressed.
	        if (event.button !== 0) {
	            return;
	        }
	        // Find the handle which contains the target, if any.
	        var layout = this.layout;
	        var target = event.target;
	        var _a = SplitPanelPrivate.findHandle(layout, target), index = _a.index, handle = _a.handle;
	        if (index === -1) {
	            return;
	        }
	        // Stop the event when a split handle is pressed.
	        event.preventDefault();
	        event.stopPropagation();
	        // Add the extra document listeners.
	        document.addEventListener('mouseup', this, true);
	        document.addEventListener('mousemove', this, true);
	        document.addEventListener('keydown', this, true);
	        document.addEventListener('keyup', this, true);
	        document.addEventListener('keypress', this, true);
	        document.addEventListener('contextmenu', this, true);
	        // Compute the offset delta for the handle press.
	        var delta;
	        var rect = handle.getBoundingClientRect();
	        if (layout.orientation === layout_1.Orientation.Horizontal) {
	            delta = event.clientX - rect.left;
	        }
	        else {
	            delta = event.clientY - rect.top;
	        }
	        // Override the cursor and store the press data.
	        var style = window.getComputedStyle(handle);
	        var override = phosphor_domutil_1.overrideCursor(style.cursor);
	        this._pressData = { index: index, delta: delta, override: override };
	    };
	    /**
	     * Handle the `'mousemove'` event for the split panel.
	     */
	    SplitPanel.prototype._evtMouseMove = function (event) {
	        // Stop the event when dragging a split handle.
	        event.preventDefault();
	        event.stopPropagation();
	        // Compute the desired offset position for the handle.
	        var pos;
	        var layout = this.layout;
	        var rect = this.node.getBoundingClientRect();
	        if (layout.orientation === layout_1.Orientation.Horizontal) {
	            pos = event.clientX - rect.left - this._pressData.delta;
	        }
	        else {
	            pos = event.clientY - rect.top - this._pressData.delta;
	        }
	        // Move the handle as close to the desired position as possible.
	        layout.moveHandle(this._pressData.index, pos);
	    };
	    /**
	     * Handle the `'mouseup'` event for the split panel.
	     */
	    SplitPanel.prototype._evtMouseUp = function (event) {
	        // Do nothing if the left mouse button is not released.
	        if (event.button !== 0) {
	            return;
	        }
	        // Stop the event when releasing a handle.
	        event.preventDefault();
	        event.stopPropagation();
	        // Finalize the mouse release.
	        this._releaseMouse();
	    };
	    /**
	     * Release the mouse grab for the split panel.
	     */
	    SplitPanel.prototype._releaseMouse = function () {
	        // Bail early if no drag is in progress.
	        if (!this._pressData) {
	            return;
	        }
	        // Clear the override cursor.
	        this._pressData.override.dispose();
	        this._pressData = null;
	        // Remove the extra document listeners.
	        document.removeEventListener('mouseup', this, true);
	        document.removeEventListener('mousemove', this, true);
	        document.removeEventListener('keydown', this, true);
	        document.removeEventListener('keyup', this, true);
	        document.removeEventListener('keypress', this, true);
	        document.removeEventListener('contextmenu', this, true);
	    };
	    return SplitPanel;
	})(phosphor_panel_1.Panel);
	exports.SplitPanel = SplitPanel;
	/**
	 * The namespace for the `SplitPanel` class statics.
	 */
	var SplitPanel;
	(function (SplitPanel) {
	    /**
	     * A convenience alias of the `Horizontal` [[Orientation]].
	     */
	    SplitPanel.Horizontal = layout_1.Orientation.Horizontal;
	    /**
	     * A convenience alias of the `Vertical` [[Orientation]].
	     */
	    SplitPanel.Vertical = layout_1.Orientation.Vertical;
	    /**
	     * Get the split panel stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @returns The split panel stretch factor for the widget.
	     */
	    function getStretch(widget) {
	        return layout_1.SplitLayout.getStretch(widget);
	    }
	    SplitPanel.getStretch = getStretch;
	    /**
	     * Set the split panel stretch factor for the given widget.
	     *
	     * @param widget - The widget of interest.
	     *
	     * @param value - The value for the stretch factor.
	     */
	    function setStretch(widget, value) {
	        layout_1.SplitLayout.setStretch(widget, value);
	    }
	    SplitPanel.setStretch = setStretch;
	})(SplitPanel = exports.SplitPanel || (exports.SplitPanel = {}));
	/**
	 * The namespace for the `SplitPanel` class private data.
	 */
	var SplitPanelPrivate;
	(function (SplitPanelPrivate) {
	    /**
	     * Find the split handle which contains the given target element.
	     */
	    function findHandle(layout, target) {
	        for (var i = 0, n = layout.childCount(); i < n; ++i) {
	            var handle = layout.handleAt(i);
	            if (handle.contains(target)) {
	                return { index: i, handle: handle };
	            }
	        }
	        return { index: -1, handle: null };
	    }
	    SplitPanelPrivate.findHandle = findHandle;
	})(SplitPanelPrivate || (SplitPanelPrivate = {}));


/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(36);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(12)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../css-loader/index.js!./index.css", function() {
				var newContent = require("!!./../../css-loader/index.js!./index.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2015, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n.p-SplitPanel {\n  z-index: 0;\n}\n\n\n.p-SplitPanel-child {\n  z-index: 0;\n}\n\n\n.p-SplitPanel-handle {\n  z-index: 1;\n}\n\n\n.p-SplitPanel-handle.p-mod-hidden {\n  display: none;\n}\n\n\n.p-SplitPanel-handle:after {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  content: '';\n}\n\n\n.p-SplitPanel.p-mod-horizontal > .p-SplitPanel-handle {\n  cursor: ew-resize;\n}\n\n\n.p-SplitPanel.p-mod-vertical > .p-SplitPanel-handle {\n  cursor: ns-resize;\n}\n\n\n.p-SplitPanel.p-mod-horizontal > .p-SplitPanel-handle:after {\n  left: 50%;\n  min-width: 7px;\n  transform: translateX(-50%);\n}\n\n\n.p-SplitPanel.p-mod-vertical > .p-SplitPanel-handle:after {\n  top: 50%;\n  min-height: 7px;\n  transform: translateY(-50%);\n}\n", ""]);
	
	// exports


/***/ },
/* 37 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(38));
	__export(__webpack_require__(39));


/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var phosphor_domutil_1 = __webpack_require__(7);
	var phosphor_messaging_1 = __webpack_require__(13);
	var phosphor_panel_1 = __webpack_require__(18);
	var phosphor_properties_1 = __webpack_require__(17);
	var phosphor_widget_1 = __webpack_require__(20);
	/**
	 * A layout where visible children are stacked atop one another.
	 *
	 * #### Notes
	 * The Z-order of the visible children follows their layout order.
	 */
	var StackedLayout = (function (_super) {
	    __extends(StackedLayout, _super);
	    function StackedLayout() {
	        _super.apply(this, arguments);
	        this._box = null;
	    }
	    /**
	     * Attach a child widget to the parent's DOM node.
	     *
	     * @param index - The current index of the child in the layout.
	     *
	     * @param child - The child widget to attach to the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    StackedLayout.prototype.attachChild = function (index, child) {
	        StackedLayoutPrivate.prepareGeometry(child);
	        this.parent.node.appendChild(child.node);
	        if (this.parent.isAttached)
	            phosphor_messaging_1.sendMessage(child, phosphor_widget_1.Widget.MsgAfterAttach);
	        this.parent.fit();
	    };
	    /**
	     * Move a child widget in the parent's DOM node.
	     *
	     * @param fromIndex - The previous index of the child in the layout.
	     *
	     * @param toIndex - The current index of the child in the layout.
	     *
	     * @param child - The child widget to move in the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    StackedLayout.prototype.moveChild = function (fromIndex, toIndex, child) {
	        this.parent.update();
	    };
	    /**
	     * Detach a child widget from the parent's DOM node.
	     *
	     * @param index - The previous index of the child in the layout.
	     *
	     * @param child - The child widget to detach from the parent.
	     *
	     * #### Notes
	     * This is a reimplementation of the superclass method.
	     */
	    StackedLayout.prototype.detachChild = function (index, child) {
	        if (this.parent.isAttached)
	            phosphor_messaging_1.sendMessage(child, phosphor_widget_1.Widget.MsgBeforeDetach);
	        this.parent.node.removeChild(child.node);
	        StackedLayoutPrivate.resetGeometry(child);
	        child.node.style.zIndex = '';
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on an `'after-show'` message.
	     */
	    StackedLayout.prototype.onAfterShow = function (msg) {
	        _super.prototype.onAfterShow.call(this, msg);
	        this.parent.update();
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    StackedLayout.prototype.onAfterAttach = function (msg) {
	        _super.prototype.onAfterAttach.call(this, msg);
	        this.parent.fit();
	    };
	    /**
	     * A message handler invoked on a `'child-shown'` message.
	     */
	    StackedLayout.prototype.onChildShown = function (msg) {
	        if (StackedLayoutPrivate.IsIE) {
	            phosphor_messaging_1.sendMessage(this.parent, phosphor_widget_1.Widget.MsgFitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'child-hidden'` message.
	     */
	    StackedLayout.prototype.onChildHidden = function (msg) {
	        if (StackedLayoutPrivate.IsIE) {
	            phosphor_messaging_1.sendMessage(this.parent, phosphor_widget_1.Widget.MsgFitRequest);
	        }
	        else {
	            this.parent.fit();
	        }
	    };
	    /**
	     * A message handler invoked on a `'resize'` message.
	     */
	    StackedLayout.prototype.onResize = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(msg.width, msg.height);
	        }
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    StackedLayout.prototype.onUpdateRequest = function (msg) {
	        if (this.parent.isVisible) {
	            this._update(-1, -1);
	        }
	    };
	    /**
	     * A message handler invoked on a `'fit-request'` message.
	     */
	    StackedLayout.prototype.onFitRequest = function (msg) {
	        if (this.parent.isAttached) {
	            this._fit();
	        }
	    };
	    /**
	     * Fit the layout to the total size required by the child widgets.
	     */
	    StackedLayout.prototype._fit = function () {
	        // Setup the initial size limits.
	        var minW = 0;
	        var minH = 0;
	        var maxW = Infinity;
	        var maxH = Infinity;
	        // Update the computed size limits.
	        for (var i = 0, n = this.childCount(); i < n; ++i) {
	            var child = this.childAt(i);
	            if (child.isHidden) {
	                continue;
	            }
	            var limits = phosphor_domutil_1.sizeLimits(child.node);
	            minW = Math.max(minW, limits.minWidth);
	            minH = Math.max(minH, limits.minHeight);
	            maxW = Math.min(maxW, limits.maxWidth);
	            maxH = Math.min(maxH, limits.maxHeight);
	        }
	        // Ensure max limits >= min limits.
	        maxW = Math.max(minW, maxW);
	        maxH = Math.max(minH, maxH);
	        // Update the box sizing and add it to the size constraints.
	        var box = this._box = phosphor_domutil_1.boxSizing(this.parent.node);
	        minW += box.horizontalSum;
	        minH += box.verticalSum;
	        maxW += box.horizontalSum;
	        maxH += box.verticalSum;
	        // Update the parent's size constraints.
	        var style = this.parent.node.style;
	        style.minWidth = minW + "px";
	        style.minHeight = minH + "px";
	        style.maxWidth = maxW === Infinity ? 'none' : maxW + "px";
	        style.maxHeight = maxH === Infinity ? 'none' : maxH + "px";
	        // Notify the ancestor that it should fit immediately.
	        var ancestor = this.parent.parent;
	        if (ancestor)
	            phosphor_messaging_1.sendMessage(ancestor, phosphor_widget_1.Widget.MsgFitRequest);
	        // Notify the parent that it should update immediately.
	        phosphor_messaging_1.sendMessage(this.parent, phosphor_widget_1.Widget.MsgUpdateRequest);
	    };
	    /**
	     * Update the layout position and size of the child widgets.
	     *
	     * The parent offset dimensions should be `-1` if unknown.
	     */
	    StackedLayout.prototype._update = function (offsetWidth, offsetHeight) {
	        // Bail early if there are no children to layout.
	        if (this.childCount() === 0) {
	            return;
	        }
	        // Measure the parent if the offset dimensions are unknown.
	        if (offsetWidth < 0) {
	            offsetWidth = this.parent.node.offsetWidth;
	        }
	        if (offsetHeight < 0) {
	            offsetHeight = this.parent.node.offsetHeight;
	        }
	        // Ensure the parent box sizing data is computed.
	        var box = this._box || (this._box = phosphor_domutil_1.boxSizing(this.parent.node));
	        // Compute the actual layout bounds adjusted for border and padding.
	        var top = box.paddingTop;
	        var left = box.paddingLeft;
	        var width = offsetWidth - box.horizontalSum;
	        var height = offsetHeight - box.verticalSum;
	        // Update the child stacking order and layout geometry.
	        for (var i = 0, n = this.childCount(); i < n; ++i) {
	            var child = this.childAt(i);
	            if (child.isHidden) {
	                continue;
	            }
	            child.node.style.zIndex = "" + i;
	            StackedLayoutPrivate.setGeometry(child, left, top, width, height);
	        }
	    };
	    return StackedLayout;
	})(phosphor_panel_1.PanelLayout);
	exports.StackedLayout = StackedLayout;
	/**
	 * The namespace for the `StackedLayout` class private data.
	 */
	var StackedLayoutPrivate;
	(function (StackedLayoutPrivate) {
	    /**
	     * A flag indicating whether the browser is IE.
	     */
	    StackedLayoutPrivate.IsIE = /Trident/.test(navigator.userAgent);
	    /**
	     * Prepare a child widget for absolute layout geometry.
	     */
	    function prepareGeometry(widget) {
	        widget.node.style.position = 'absolute';
	    }
	    StackedLayoutPrivate.prepareGeometry = prepareGeometry;
	    /**
	     * Reset the layout geometry for the given child widget.
	     */
	    function resetGeometry(widget) {
	        var rect = rectProperty.get(widget);
	        var style = widget.node.style;
	        rect.top = NaN;
	        rect.left = NaN;
	        rect.width = NaN;
	        rect.height = NaN;
	        style.position = '';
	        style.top = '';
	        style.left = '';
	        style.width = '';
	        style.height = '';
	    }
	    StackedLayoutPrivate.resetGeometry = resetGeometry;
	    /**
	     * Set the layout geometry for the given child widget.
	     */
	    function setGeometry(widget, left, top, width, height) {
	        var resized = false;
	        var style = widget.node.style;
	        var rect = rectProperty.get(widget);
	        if (rect.top !== top) {
	            rect.top = top;
	            style.top = top + "px";
	        }
	        if (rect.left !== left) {
	            rect.left = left;
	            style.left = left + "px";
	        }
	        if (rect.width !== width) {
	            resized = true;
	            rect.width = width;
	            style.width = width + "px";
	        }
	        if (rect.height !== height) {
	            resized = true;
	            rect.height = height;
	            style.height = height + "px";
	        }
	        if (resized) {
	            phosphor_messaging_1.sendMessage(widget, new phosphor_widget_1.ResizeMessage(width, height));
	        }
	    }
	    StackedLayoutPrivate.setGeometry = setGeometry;
	    /**
	     * A property descriptor for a widget offset rect.
	     */
	    var rectProperty = new phosphor_properties_1.Property({
	        name: 'rect',
	        create: function () { return ({ top: NaN, left: NaN, width: NaN, height: NaN }); },
	    });
	})(StackedLayoutPrivate || (StackedLayoutPrivate = {}));


/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var phosphor_panel_1 = __webpack_require__(18);
	var phosphor_signaling_1 = __webpack_require__(22);
	var layout_1 = __webpack_require__(38);
	/**
	 * The class name added to StackedPanel instances.
	 */
	var STACKED_PANEL_CLASS = 'p-StackedPanel';
	/**
	 * The class name added to a StackedPanel child.
	 */
	var CHILD_CLASS = 'p-StackedPanel-child';
	/**
	 * A panel where visible children are stacked atop one another.
	 *
	 * #### Notes
	 * This class provides a convenience wrapper around a [[StackedLayout]].
	 */
	var StackedPanel = (function (_super) {
	    __extends(StackedPanel, _super);
	    /**
	     * Construct a new stacked panel.
	     */
	    function StackedPanel() {
	        _super.call(this);
	        this.addClass(STACKED_PANEL_CLASS);
	    }
	    /**
	     * Create a stacked layout for a stacked panel.
	     */
	    StackedPanel.createLayout = function () {
	        return new layout_1.StackedLayout();
	    };
	    Object.defineProperty(StackedPanel.prototype, "widgetRemoved", {
	        /**
	         * A signal emitted when a widget is removed from the panel.
	         */
	        get: function () {
	            return StackedPanelPrivate.widgetRemovedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * A message handler invoked on a `'child-added'` message.
	     */
	    StackedPanel.prototype.onChildAdded = function (msg) {
	        msg.child.addClass(CHILD_CLASS);
	    };
	    /**
	     * A message handler invoked on a `'child-removed'` message.
	     */
	    StackedPanel.prototype.onChildRemoved = function (msg) {
	        msg.child.removeClass(CHILD_CLASS);
	        this.widgetRemoved.emit(msg.child);
	    };
	    return StackedPanel;
	})(phosphor_panel_1.Panel);
	exports.StackedPanel = StackedPanel;
	/**
	 * The namespace for the `StackedPanel` class private data.
	 */
	var StackedPanelPrivate;
	(function (StackedPanelPrivate) {
	    /**
	     * A signal emitted when a widget is removed from the panel.
	     */
	    StackedPanelPrivate.widgetRemovedSignal = new phosphor_signaling_1.Signal();
	})(StackedPanelPrivate || (StackedPanelPrivate = {}));


/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(41));
	__export(__webpack_require__(42));
	__webpack_require__(43);


/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var arrays = __webpack_require__(3);
	var phosphor_domutil_1 = __webpack_require__(7);
	var phosphor_signaling_1 = __webpack_require__(22);
	var phosphor_widget_1 = __webpack_require__(20);
	/**
	 * The class name added to TabBar instances.
	 */
	var TAB_BAR_CLASS = 'p-TabBar';
	/**
	 * The class name added to a tab bar body node.
	 */
	var BODY_CLASS = 'p-TabBar-body';
	/**
	 * The class name added to a tab bar header node.
	 */
	var HEADER_CLASS = 'p-TabBar-header';
	/**
	 * The class name added to a tab bar content node.
	 */
	var CONTENT_CLASS = 'p-TabBar-content';
	/**
	 * The class name added to a tab bar footer node.
	 */
	var FOOTER_CLASS = 'p-TabBar-footer';
	/**
	 * The class name added to a tab bar tab.
	 */
	var TAB_CLASS = 'p-TabBar-tab';
	/**
	 * The class name added to a tab text node.
	 */
	var TEXT_CLASS = 'p-TabBar-tabText';
	/**
	 * The class name added to a tab icon node.
	 */
	var ICON_CLASS = 'p-TabBar-tabIcon';
	/**
	 * The class name added to a tab close icon node.
	 */
	var CLOSE_CLASS = 'p-TabBar-tabCloseIcon';
	/**
	 * The class name added to a tab bar and tab when dragging.
	 */
	var DRAGGING_CLASS = 'p-mod-dragging';
	/**
	 * The class name added to the current tab.
	 */
	var CURRENT_CLASS = 'p-mod-current';
	/**
	 * The class name added to a closable tab.
	 */
	var CLOSABLE_CLASS = 'p-mod-closable';
	/**
	 * The start drag distance threshold.
	 */
	var DRAG_THRESHOLD = 5;
	/**
	 * The detach distance threshold.
	 */
	var DETACH_THRESHOLD = 20;
	/**
	 * The tab transition duration.
	 */
	var TRANSITION_DURATION = 150; // Keep in sync with CSS.
	/**
	 * A widget which displays tab items as a row of tabs.
	 */
	var TabBar = (function (_super) {
	    __extends(TabBar, _super);
	    /**
	     * Construct a new tab bar.
	     */
	    function TabBar() {
	        _super.call(this);
	        this._tabsMovable = false;
	        this._items = [];
	        this._tabs = [];
	        this._dirtySet = new Set();
	        this._currentItem = null;
	        this._dragData = null;
	        this.addClass(TAB_BAR_CLASS);
	    }
	    /**
	     * Create the DOM node for a tab bar.
	     */
	    TabBar.createNode = function () {
	        var node = document.createElement('div');
	        var header = document.createElement('div');
	        var body = document.createElement('div');
	        var footer = document.createElement('div');
	        var content = document.createElement('ul');
	        header.className = HEADER_CLASS;
	        body.className = BODY_CLASS;
	        footer.className = FOOTER_CLASS;
	        content.className = CONTENT_CLASS;
	        body.appendChild(content);
	        node.appendChild(header);
	        node.appendChild(body);
	        node.appendChild(footer);
	        return node;
	    };
	    /**
	     * Create and initialize a tab node for a tab bar.
	     *
	     * @param title - The title to use for the initial tab state.
	     *
	     * @returns A new DOM node to use as a tab in a tab bar.
	     *
	     * #### Notes
	     * It is not necessary to subscribe to the `changed` signal of the
	     * title. The tab bar subscribes to that signal and will call the
	     * [[updateTab]] static method automatically as needed.
	     *
	     * This method may be reimplemented to create custom tabs.
	     */
	    TabBar.createTab = function (title) {
	        var node = document.createElement('li');
	        var icon = document.createElement('span');
	        var text = document.createElement('span');
	        var close = document.createElement('span');
	        node.className = TAB_CLASS;
	        icon.className = ICON_CLASS;
	        text.className = TEXT_CLASS;
	        close.className = CLOSE_CLASS;
	        node.appendChild(icon);
	        node.appendChild(text);
	        node.appendChild(close);
	        this.updateTab(node, title);
	        return node;
	    };
	    /**
	     * Update a tab node to reflect the current state of a title.
	     *
	     * @param tab - A tab node created by a call to [[createTab]].
	     *
	     * @param title - The title object to use for the tab state.
	     *
	     * #### Notes
	     * This is called automatically when the title state changes.
	     *
	     * If the [[createTab]] method is reimplemented, this method should
	     * also be reimplemented so that the tab state is properly updated.
	     */
	    TabBar.updateTab = function (tab, title) {
	        var tabInfix = title.className ? ' ' + title.className : '';
	        var tabSuffix = title.closable ? ' ' + CLOSABLE_CLASS : '';
	        var iconSuffix = title.icon ? ' ' + title.icon : '';
	        var icon = tab.firstChild;
	        var text = icon.nextSibling;
	        tab.className = TAB_CLASS + tabInfix + tabSuffix;
	        icon.className = ICON_CLASS + iconSuffix;
	        text.textContent = title.text;
	    };
	    /**
	     * Get the close icon node for a given tab node.
	     *
	     * @param tab - A tab node created by a call to [[createTab]].
	     *
	     * @returns The close icon node for the tab node.
	     *
	     * #### Notes
	     * The close icon node is used to correctly process click events.
	     *
	     * If the [[createTab]] method is reimplemented, this method should
	     * also be reimplemented so that the correct icon node is returned.
	     */
	    TabBar.tabCloseIcon = function (tab) {
	        return tab.lastChild;
	    };
	    /**
	     * Dispose of the resources held by the widget.
	     */
	    TabBar.prototype.dispose = function () {
	        this._releaseMouse();
	        this._tabs.length = 0;
	        this._items.length = 0;
	        this._dirtySet.clear();
	        this._currentItem = null;
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(TabBar.prototype, "currentChanged", {
	        /**
	         * A signal emitted when the current tab is changed.
	         */
	        get: function () {
	            return TabBarPrivate.currentChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "tabMoved", {
	        /**
	         * A signal emitted when a tab is moved by the user.
	         */
	        get: function () {
	            return TabBarPrivate.tabMovedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "tabCloseRequested", {
	        /**
	         * A signal emitted when the user clicks a tab's close icon.
	         */
	        get: function () {
	            return TabBarPrivate.tabCloseRequestedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "tabDetachRequested", {
	        /**
	         * A signal emitted when a tab is dragged beyond the detach threshold.
	         */
	        get: function () {
	            return TabBarPrivate.tabDetachRequestedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "currentItem", {
	        /**
	         * Get the currently selected tab item.
	         */
	        get: function () {
	            return this._currentItem;
	        },
	        /**
	         * Set the currently selected tab item.
	         */
	        set: function (value) {
	            var item = value || null;
	            if (this._currentItem === item) {
	                return;
	            }
	            var index = item ? this._items.indexOf(item) : -1;
	            if (item && index === -1) {
	                console.warn('Tab item not contained in tab bar.');
	                return;
	            }
	            this._currentItem = item;
	            this.currentChanged.emit({ index: index, item: item });
	            this.update();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "tabsMovable", {
	        /**
	         * Get whether the tabs are movable by the user.
	         */
	        get: function () {
	            return this._tabsMovable;
	        },
	        /**
	         * Set whether the tabs are movable by the user.
	         */
	        set: function (value) {
	            this._tabsMovable = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "headerNode", {
	        /**
	         * Get the tab bar header node.
	         *
	         * #### Notes
	         * This node can be used to add extra content to the tab bar header.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.node.getElementsByClassName(HEADER_CLASS)[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "bodyNode", {
	        /**
	         * Get the tab bar body node.
	         *
	         * #### Notes
	         * This node can be used to add extra content to the tab bar.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.node.getElementsByClassName(BODY_CLASS)[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "footerNode", {
	        /**
	         * Get the tab bar footer node.
	         *
	         * #### Notes
	         * This node can be used to add extra content to the tab bar footer.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.node.getElementsByClassName(FOOTER_CLASS)[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabBar.prototype, "contentNode", {
	        /**
	         * Get the tab bar content node.
	         *
	         * #### Notes
	         * This is the node which holds the tab nodes.
	         *
	         * Modifying this node directly can lead to undefined behavior.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.node.getElementsByClassName(CONTENT_CLASS)[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the number of tab items in the tab bar.
	     *
	     * @returns The number of tab items in the tab bar.
	     */
	    TabBar.prototype.itemCount = function () {
	        return this._items.length;
	    };
	    /**
	     * Get the tab item at the specified index.
	     *
	     * @param index - The index of the tab item of interest.
	     *
	     * @returns The tab item at the specified index, or `undefined`.
	     */
	    TabBar.prototype.itemAt = function (index) {
	        return this._items[index];
	    };
	    /**
	     * Get the index of the specified tab item.
	     *
	     * @param item - The tab item of interest.
	     *
	     * @returns The index of the specified item, or `-1`.
	     */
	    TabBar.prototype.itemIndex = function (item) {
	        return this._items.indexOf(item);
	    };
	    /**
	     * Add a tab item to the end of the tab bar.
	     *
	     * @param item - The tab item to add to the tab bar.
	     *
	     * #### Notes
	     * If the item is already added to the tab bar, it will be moved.
	     */
	    TabBar.prototype.addItem = function (item) {
	        this.insertItem(this.itemCount(), item);
	    };
	    /**
	     * Insert a tab item at the specified index.
	     *
	     * @param index - The index at which to insert the item.
	     *
	     * @param item - The tab item to insert into the tab bar.
	     *
	     * #### Notes
	     * If the item is already added to the tab bar, it will be moved.
	     */
	    TabBar.prototype.insertItem = function (index, item) {
	        this._releaseMouse();
	        var n = this._items.length;
	        var i = this._items.indexOf(item);
	        var j = Math.max(0, Math.min(index | 0, n));
	        if (i !== -1) {
	            if (j === n)
	                j--;
	            if (i === j)
	                return;
	            arrays.move(this._tabs, i, j);
	            arrays.move(this._items, i, j);
	            this.contentNode.insertBefore(this._tabs[j], this._tabs[j + 1]);
	        }
	        else {
	            var tab = this.constructor.createTab(item.title);
	            arrays.insert(this._tabs, j, tab);
	            arrays.insert(this._items, j, item);
	            this.contentNode.insertBefore(tab, this._tabs[j + 1]);
	            item.title.changed.connect(this._onTitleChanged, this);
	            if (!this.currentItem)
	                this.currentItem = item;
	        }
	        this.update();
	    };
	    /**
	     * Remove a tab item from the tab bar.
	     *
	     * @param item - The tab item to remove from the tab bar.
	     *
	     * #### Notes
	     * If the item is not in the tab bar, this is a no-op.
	     */
	    TabBar.prototype.removeItem = function (item) {
	        this._releaseMouse();
	        var i = arrays.remove(this._items, item);
	        if (i === -1) {
	            return;
	        }
	        this._dirtySet.delete(item.title);
	        item.title.changed.disconnect(this._onTitleChanged, this);
	        this.contentNode.removeChild(arrays.removeAt(this._tabs, i));
	        if (this.currentItem === item) {
	            var next = this._items[i];
	            var prev = this._items[i - 1];
	            this.currentItem = next || prev;
	        }
	        this.update();
	    };
	    /**
	     * Get the tab node for the item at the given index.
	     *
	     * @param index - The index of the tab item of interest.
	     *
	     * @returns The tab node for the item, or `undefined`.
	     */
	    TabBar.prototype.tabAt = function (index) {
	        return this._tabs[index];
	    };
	    /**
	     * Release the mouse and restore the non-dragged tab positions.
	     *
	     * #### Notes
	     * This will cause the tab bar to stop handling mouse events and to
	     * restore the tabs to their non-dragged positions.
	     */
	    TabBar.prototype.releaseMouse = function () {
	        this._releaseMouse();
	    };
	    /**
	     * Handle the DOM events for the tab bar.
	     *
	     * @param event - The DOM event sent to the tab bar.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the tab bar's DOM node. It should
	     * not be called directly by user code.
	     */
	    TabBar.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'click':
	                this._evtClick(event);
	                break;
	            case 'mousedown':
	                this._evtMouseDown(event);
	                break;
	            case 'mousemove':
	                this._evtMouseMove(event);
	                break;
	            case 'mouseup':
	                this._evtMouseUp(event);
	                break;
	            case 'keydown':
	                this._evtKeyDown(event);
	                break;
	            case 'contextmenu':
	                event.preventDefault();
	                event.stopPropagation();
	                break;
	        }
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    TabBar.prototype.onAfterAttach = function (msg) {
	        this.node.addEventListener('click', this);
	        this.node.addEventListener('mousedown', this);
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     */
	    TabBar.prototype.onBeforeDetach = function (msg) {
	        this.node.removeEventListener('click', this);
	        this.node.removeEventListener('mousedown', this);
	        this._releaseMouse();
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    TabBar.prototype.onUpdateRequest = function (msg) {
	        var tabs = this._tabs;
	        var items = this._items;
	        var dirty = this._dirtySet;
	        var current = this._currentItem;
	        var constructor = this.constructor;
	        for (var i = 0, n = tabs.length; i < n; ++i) {
	            var tab = tabs[i];
	            var item = items[i];
	            if (dirty.has(item.title)) {
	                constructor.updateTab(tab, item.title);
	            }
	            if (item === current) {
	                tab.classList.add(CURRENT_CLASS);
	                tab.style.zIndex = "" + n;
	            }
	            else {
	                tab.classList.remove(CURRENT_CLASS);
	                tab.style.zIndex = "" + (n - i - 1);
	            }
	        }
	        dirty.clear();
	    };
	    /**
	     * Handle the `'keydown'` event for the tab bar.
	     */
	    TabBar.prototype._evtKeyDown = function (event) {
	        // Stop all input events during drag.
	        event.preventDefault();
	        event.stopPropagation();
	        // Release the mouse if `Escape` is pressed.
	        if (event.keyCode === 27)
	            this._releaseMouse();
	    };
	    /**
	     * Handle the `'click'` event for the tab bar.
	     */
	    TabBar.prototype._evtClick = function (event) {
	        // Do nothing if it's not a left click.
	        if (event.button !== 0) {
	            return;
	        }
	        // Do nothing if a drag is in progress.
	        if (this._dragData) {
	            return;
	        }
	        // Do nothing if the click is not on a tab.
	        var x = event.clientX;
	        var y = event.clientY;
	        var i = arrays.findIndex(this._tabs, function (tab) { return phosphor_domutil_1.hitTest(tab, x, y); });
	        if (i < 0) {
	            return;
	        }
	        // Clicking on a tab stops the event propagation.
	        event.preventDefault();
	        event.stopPropagation();
	        // Ignore the click if the title is not closable.
	        var item = this._items[i];
	        if (!item.title.closable) {
	            return;
	        }
	        // Ignore the click if it was not on a close icon.
	        var constructor = this.constructor;
	        var icon = constructor.tabCloseIcon(this._tabs[i]);
	        if (!icon.contains(event.target)) {
	            return;
	        }
	        // Emit the tab close requested signal.
	        this.tabCloseRequested.emit({ index: i, item: item });
	    };
	    /**
	     * Handle the `'mousedown'` event for the tab bar.
	     */
	    TabBar.prototype._evtMouseDown = function (event) {
	        // Do nothing if it's not a left mouse press.
	        if (event.button !== 0) {
	            return;
	        }
	        // Do nothing if a drag is in progress.
	        if (this._dragData) {
	            return;
	        }
	        // Do nothing if the press is not on a tab.
	        var x = event.clientX;
	        var y = event.clientY;
	        var i = arrays.findIndex(this._tabs, function (tab) { return phosphor_domutil_1.hitTest(tab, x, y); });
	        if (i < 0) {
	            return;
	        }
	        // Pressing on a tab stops the event propagation.
	        event.preventDefault();
	        event.stopPropagation();
	        // Ignore the press if it was on a close icon.
	        var constructor = this.constructor;
	        var icon = constructor.tabCloseIcon(this._tabs[i]);
	        if (icon.contains(event.target)) {
	            return;
	        }
	        // Setup the drag data if the tabs are movable.
	        if (this._tabsMovable) {
	            this._dragData = new TabBarPrivate.DragData();
	            this._dragData.index = i;
	            this._dragData.tab = this._tabs[i];
	            this._dragData.pressX = event.clientX;
	            this._dragData.pressY = event.clientY;
	            document.addEventListener('mousemove', this, true);
	            document.addEventListener('mouseup', this, true);
	            document.addEventListener('keydown', this, true);
	            document.addEventListener('contextmenu', this, true);
	        }
	        // Update the current item to the pressed item.
	        this.currentItem = this._items[i];
	    };
	    /**
	     * Handle the `'mousemove'` event for the tab bar.
	     */
	    TabBar.prototype._evtMouseMove = function (event) {
	        // Do nothing if no drag is in progress.
	        if (!this._dragData) {
	            return;
	        }
	        // Suppress the event during a drag.
	        event.preventDefault();
	        event.stopPropagation();
	        // Ensure the drag threshold is exceeded before moving the tab.
	        var data = this._dragData;
	        if (!data.dragActive) {
	            var dx = Math.abs(event.clientX - data.pressX);
	            var dy = Math.abs(event.clientY - data.pressY);
	            if (dx < DRAG_THRESHOLD && dy < DRAG_THRESHOLD) {
	                return;
	            }
	            // Fill in the rest of the drag data measurements.
	            var tabRect = data.tab.getBoundingClientRect();
	            data.tabLeft = data.tab.offsetLeft;
	            data.tabWidth = tabRect.width;
	            data.tabPressX = data.pressX - tabRect.left;
	            data.tabLayout = TabBarPrivate.snapTabLayout(this._tabs);
	            data.contentRect = this.contentNode.getBoundingClientRect();
	            data.override = phosphor_domutil_1.overrideCursor('default');
	            // Add the dragging classes and mark the drag as active.
	            data.tab.classList.add(DRAGGING_CLASS);
	            this.addClass(DRAGGING_CLASS);
	            data.dragActive = true;
	        }
	        // Emit the detach request signal if the threshold is exceeded.
	        if (!data.detachRequested && TabBarPrivate.detachExceeded(data, event)) {
	            data.detachRequested = true;
	            var index = data.index;
	            var item = this._items[index];
	            var clientX = event.clientX;
	            var clientY = event.clientY;
	            this.tabDetachRequested.emit({ index: index, item: item, clientX: clientX, clientY: clientY });
	            if (data.dragAborted) {
	                return;
	            }
	        }
	        // Update the tab layout and computed target index.
	        TabBarPrivate.layoutTabs(this._tabs, data, event);
	    };
	    /**
	     * Handle the `'mouseup'` event for the tab bar.
	     */
	    TabBar.prototype._evtMouseUp = function (event) {
	        var _this = this;
	        // Do nothing if it's not a left mouse release.
	        if (event.button !== 0) {
	            return;
	        }
	        // Do nothing if no drag is in progress.
	        if (!this._dragData) {
	            return;
	        }
	        // Suppress the event during a drag operation.
	        event.preventDefault();
	        event.stopPropagation();
	        // Remove the extra mouse event listeners.
	        document.removeEventListener('mousemove', this, true);
	        document.removeEventListener('mouseup', this, true);
	        document.removeEventListener('keydown', this, true);
	        document.removeEventListener('contextmenu', this, true);
	        // Bail early if the drag is not active.
	        var data = this._dragData;
	        if (!data.dragActive) {
	            this._dragData = null;
	            return;
	        }
	        // Position the tab at its final resting position.
	        TabBarPrivate.finalizeTabPosition(data);
	        // Remove the dragging class from the tab so it can be transitioned.
	        data.tab.classList.remove(DRAGGING_CLASS);
	        // Complete the release on a timer to allow the tab to transition.
	        setTimeout(function () {
	            // Do nothing if the drag has been aborted.
	            if (data.dragAborted) {
	                return;
	            }
	            // Clear the drag data reference.
	            _this._dragData = null;
	            // Reset the positions of the tabs.
	            TabBarPrivate.resetTabPositions(_this._tabs);
	            // Clear the cursor grab and drag styles.
	            data.override.dispose();
	            _this.removeClass(DRAGGING_CLASS);
	            // If the tab was not moved, there is nothing else to do.
	            var i = data.index;
	            var j = data.targetIndex;
	            if (j === -1 || i === j) {
	                return;
	            }
	            // Move the tab and related tab item to the new location.
	            arrays.move(_this._tabs, i, j);
	            arrays.move(_this._items, i, j);
	            _this.contentNode.insertBefore(_this._tabs[j], _this._tabs[j + 1]);
	            // Emit the tab moved signal and schedule a render update.
	            _this.tabMoved.emit({ fromIndex: i, toIndex: j, item: _this._items[j] });
	            _this.update();
	        }, TRANSITION_DURATION);
	    };
	    /**
	     * Release the mouse and restore the non-dragged tab positions.
	     */
	    TabBar.prototype._releaseMouse = function () {
	        // Do nothing if no drag is in progress.
	        if (!this._dragData) {
	            return;
	        }
	        // Remove the extra mouse listeners.
	        document.removeEventListener('mousemove', this, true);
	        document.removeEventListener('mouseup', this, true);
	        document.removeEventListener('keydown', this, true);
	        document.removeEventListener('contextmenu', this, true);
	        // Clear the drag data reference.
	        var data = this._dragData;
	        this._dragData = null;
	        // Indicate the drag has been aborted. This allows the mouse
	        // event handlers to return early when the drag is canceled.
	        data.dragAborted = true;
	        // If the drag is not active, there's nothing more to do.
	        if (!data.dragActive) {
	            return;
	        }
	        // Reset the tabs to their non-dragged positions.
	        TabBarPrivate.resetTabPositions(this._tabs);
	        // Clear the cursor override and extra styling classes.
	        data.override.dispose();
	        data.tab.classList.remove(DRAGGING_CLASS);
	        this.removeClass(DRAGGING_CLASS);
	    };
	    /**
	     * Handle the `changed` signal of a title object.
	     */
	    TabBar.prototype._onTitleChanged = function (sender) {
	        this._dirtySet.add(sender);
	        this.update();
	    };
	    return TabBar;
	})(phosphor_widget_1.Widget);
	exports.TabBar = TabBar;
	/**
	 * The namespace for the `TabBar` class private data.
	 */
	var TabBarPrivate;
	(function (TabBarPrivate) {
	    /**
	     * A signal emitted when the current tab item is changed.
	     */
	    TabBarPrivate.currentChangedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted when a tab is moved by the user.
	     */
	    TabBarPrivate.tabMovedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted when the user clicks a tab's close icon.
	     */
	    TabBarPrivate.tabCloseRequestedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted when a tab is dragged beyond the detach threshold.
	     */
	    TabBarPrivate.tabDetachRequestedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A struct which holds the drag data for a tab bar.
	     */
	    var DragData = (function () {
	        function DragData() {
	            /**
	             * The tab node being dragged.
	             */
	            this.tab = null;
	            /**
	             * The index of the tab being dragged.
	             */
	            this.index = -1;
	            /**
	             * The offset left of the tab being dragged.
	             */
	            this.tabLeft = -1;
	            /**
	             * The offset width of the tab being dragged.
	             */
	            this.tabWidth = -1;
	            /**
	             * The original mouse X position in tab coordinates.
	             */
	            this.tabPressX = -1;
	            /**
	             * The tab target index upon mouse release.
	             */
	            this.targetIndex = -1;
	            /**
	             * The array of tab layout objects snapped at drag start.
	             */
	            this.tabLayout = null;
	            /**
	             * The mouse press client X position.
	             */
	            this.pressX = -1;
	            /**
	             * The mouse press client Y position.
	             */
	            this.pressY = -1;
	            /**
	             * The bounding client rect of the tab bar content node.
	             */
	            this.contentRect = null;
	            /**
	             * The disposable to clean up the cursor override.
	             */
	            this.override = null;
	            /**
	             * Whether the drag is currently active.
	             */
	            this.dragActive = false;
	            /**
	             * Whether the drag has been aborted.
	             */
	            this.dragAborted = false;
	            /**
	             * Whether a detach request as been made.
	             */
	            this.detachRequested = false;
	        }
	        return DragData;
	    })();
	    TabBarPrivate.DragData = DragData;
	    /**
	     * Get a snapshot of the current tab layout values.
	     */
	    function snapTabLayout(tabs) {
	        var layout = new Array(tabs.length);
	        for (var i = 0, n = tabs.length; i < n; ++i) {
	            var node = tabs[i];
	            var left = node.offsetLeft;
	            var width = node.offsetWidth;
	            var cstyle = window.getComputedStyle(node);
	            var margin = parseInt(cstyle.marginLeft, 10) || 0;
	            layout[i] = { margin: margin, left: left, width: width };
	        }
	        return layout;
	    }
	    TabBarPrivate.snapTabLayout = snapTabLayout;
	    /**
	     * Test if the event exceeds the drag detach threshold.
	     */
	    function detachExceeded(data, event) {
	        var rect = data.contentRect;
	        return ((event.clientX < rect.left - DETACH_THRESHOLD) ||
	            (event.clientX >= rect.right + DETACH_THRESHOLD) ||
	            (event.clientY < rect.top - DETACH_THRESHOLD) ||
	            (event.clientY >= rect.bottom + DETACH_THRESHOLD));
	    }
	    TabBarPrivate.detachExceeded = detachExceeded;
	    /**
	     * Update the relative tab positions and computed target index.
	     */
	    function layoutTabs(tabs, data, event) {
	        var targetIndex = data.index;
	        var targetLeft = event.clientX - data.contentRect.left - data.tabPressX;
	        var targetRight = targetLeft + data.tabWidth;
	        for (var i = 0, n = tabs.length; i < n; ++i) {
	            var style = tabs[i].style;
	            var layout = data.tabLayout[i];
	            var threshold = layout.left + (layout.width >> 1);
	            if (i < data.index && targetLeft < threshold) {
	                style.left = data.tabWidth + data.tabLayout[i + 1].margin + 'px';
	                targetIndex = Math.min(targetIndex, i);
	            }
	            else if (i > data.index && targetRight > threshold) {
	                style.left = -data.tabWidth - layout.margin + 'px';
	                targetIndex = Math.max(targetIndex, i);
	            }
	            else if (i === data.index) {
	                var ideal = event.clientX - data.pressX;
	                var limit = data.contentRect.width - (data.tabLeft + data.tabWidth);
	                style.left = Math.max(-data.tabLeft, Math.min(ideal, limit)) + 'px';
	            }
	            else {
	                style.left = '';
	            }
	        }
	        data.targetIndex = targetIndex;
	    }
	    TabBarPrivate.layoutTabs = layoutTabs;
	    /**
	     * Position the drag tab at its final resting relative position.
	     */
	    function finalizeTabPosition(data) {
	        var ideal;
	        if (data.targetIndex === data.index) {
	            ideal = 0;
	        }
	        else if (data.targetIndex > data.index) {
	            var tgt = data.tabLayout[data.targetIndex];
	            ideal = tgt.left + tgt.width - data.tabWidth - data.tabLeft;
	        }
	        else {
	            var tgt = data.tabLayout[data.targetIndex];
	            ideal = tgt.left - data.tabLeft;
	        }
	        var style = data.tab.style;
	        var limit = data.contentRect.width - (data.tabLeft + data.tabWidth);
	        style.left = Math.max(-data.tabLeft, Math.min(ideal, limit)) + 'px';
	    }
	    TabBarPrivate.finalizeTabPosition = finalizeTabPosition;
	    /**
	     * Reset the relative positions of the given tabs.
	     */
	    function resetTabPositions(tabs) {
	        for (var i = 0, n = tabs.length; i < n; ++i) {
	            tabs[i].style.left = '';
	        }
	    }
	    TabBarPrivate.resetTabPositions = resetTabPositions;
	})(TabBarPrivate || (TabBarPrivate = {}));


/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var phosphor_boxpanel_1 = __webpack_require__(4);
	var phosphor_stackedpanel_1 = __webpack_require__(37);
	var phosphor_widget_1 = __webpack_require__(20);
	var tabbar_1 = __webpack_require__(41);
	/**
	 * The class name added to TabPanel instances.
	 */
	var TAB_PANEL_CLASS = 'p-TabPanel';
	/**
	 * The class name added to a TabPanel's tab bar.
	 */
	var TAB_BAR_CLASS = 'p-TabPanel-tabBar';
	/**
	 * The class name added to a TabPanel's stacked panel.
	 */
	var STACKED_PANEL_CLASS = 'p-TabPanel-stackedPanel';
	/**
	 * A widget which combines a `TabBar` and a `StackedPanel`.
	 *
	 * #### Notes
	 * This is a simple panel which handles the common case of a tab bar
	 * placed above a content area. The selected tab controls the widget
	 * which is shown in the content area.
	 *
	 * For use cases which require more control than is provided by this
	 * panel, the `TabBar` widget may be used independently.
	 */
	var TabPanel = (function (_super) {
	    __extends(TabPanel, _super);
	    /**
	     * Construct a new tab panel.
	     */
	    function TabPanel() {
	        _super.call(this);
	        this._currentWidget = null;
	        this.addClass(TAB_PANEL_CLASS);
	        var constructor = this.constructor;
	        this._tabBar = constructor.createTabBar();
	        this._stackedPanel = constructor.createStackedPanel();
	        this._tabBar.tabMoved.connect(this._onTabMoved, this);
	        this._tabBar.currentChanged.connect(this._onCurrentChanged, this);
	        this._tabBar.tabCloseRequested.connect(this._onTabCloseRequested, this);
	        this._stackedPanel.widgetRemoved.connect(this._onWidgetRemoved, this);
	        var layout = new phosphor_boxpanel_1.BoxLayout();
	        layout.direction = phosphor_boxpanel_1.BoxLayout.TopToBottom;
	        layout.spacing = 0;
	        phosphor_boxpanel_1.BoxLayout.setStretch(this._tabBar, 0);
	        phosphor_boxpanel_1.BoxLayout.setStretch(this._stackedPanel, 1);
	        layout.addChild(this._tabBar);
	        layout.addChild(this._stackedPanel);
	        this.layout = layout;
	    }
	    /**
	     * Create a `TabBar` for a tab panel.
	     *
	     * @returns A new tab bar to use with a tab panel.
	     *
	     * #### Notes
	     * This may be reimplemented by subclasses for custom tab bars.
	     */
	    TabPanel.createTabBar = function () {
	        var tabBar = new tabbar_1.TabBar();
	        tabBar.addClass(TAB_BAR_CLASS);
	        return tabBar;
	    };
	    /**
	     * Create a `StackedPanel` for a tab panel.
	     *
	     * @returns A new stacked panel to use with a tab panel.
	     *
	     * #### Notes
	     * This may be reimplemented by subclasses for custom stacks.
	     */
	    TabPanel.createStackedPanel = function () {
	        var stackedPanel = new phosphor_stackedpanel_1.StackedPanel();
	        stackedPanel.addClass(STACKED_PANEL_CLASS);
	        return stackedPanel;
	    };
	    /**
	     * Dispose of the resources held by the widget.
	     */
	    TabPanel.prototype.dispose = function () {
	        this._tabBar = null;
	        this._stackedPanel = null;
	        this._currentWidget = null;
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(TabPanel.prototype, "currentWidget", {
	        /**
	         * Get the currently selected widget.
	         */
	        get: function () {
	            return this._tabBar.currentItem;
	        },
	        /**
	         * Set the currently selected widget.
	         */
	        set: function (value) {
	            this._tabBar.currentItem = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabPanel.prototype, "tabsMovable", {
	        /**
	         * Get whether the tabs are movable by the user.
	         */
	        get: function () {
	            return this._tabBar.tabsMovable;
	        },
	        /**
	         * Set whether the tabs are movable by the user.
	         */
	        set: function (value) {
	            this._tabBar.tabsMovable = value;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabPanel.prototype, "tabBar", {
	        /**
	         * Get the tab bar associated with the tab panel.
	         *
	         * #### Notes
	         * Modifying the tab bar directly can lead to undefined behavior.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._tabBar;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TabPanel.prototype, "stackedPanel", {
	        /**
	         * Get the stacked panel associated with the tab panel.
	         *
	         * #### Notes
	         * Modifying the stack directly can lead to undefined behavior.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._stackedPanel;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the number of child widgets in the tab panel.
	     *
	     * @returns The number of child widgets in the tab panel.
	     *
	     * #### Notes
	     * This delegates to the `childCount` method of the stacked panel.
	     */
	    TabPanel.prototype.childCount = function () {
	        return this._stackedPanel.childCount();
	    };
	    /**
	     * Get the child widget at the specified index.
	     *
	     * @param index - The index of the child widget of interest.
	     *
	     * @returns The child at the specified index, or `undefined`.
	     *
	     * #### Notes
	     * This delegates to the `childAt` method of the stacked panel.
	     */
	    TabPanel.prototype.childAt = function (index) {
	        return this._stackedPanel.childAt(index);
	    };
	    /**
	     * Get the index of the specified child widget.
	     *
	     * @param child - The child widget of interest.
	     *
	     * @returns The index of the specified child, or `-1`.
	     *
	     * #### Notes
	     * This delegates to the `childIndex` method of the stacked panel.
	     */
	    TabPanel.prototype.childIndex = function (child) {
	        return this._stackedPanel.childIndex(child);
	    };
	    /**
	     * Add a child widget to the end of the tab panel.
	     *
	     * @param child - The child widget to add to the tab panel.
	     *
	     * #### Notes
	     * If the child is already contained in the panel, it will be moved.
	     */
	    TabPanel.prototype.addChild = function (child) {
	        this.insertChild(this.childCount(), child);
	    };
	    /**
	     * Insert a child widget at the specified index.
	     *
	     * @param index - The index at which to insert the child.
	     *
	     * @param child - The child widget to insert into to the tab panel.
	     *
	     * #### Notes
	     * If the child is already contained in the panel, it will be moved.
	     */
	    TabPanel.prototype.insertChild = function (index, child) {
	        if (child !== this._currentWidget)
	            child.hide();
	        this._stackedPanel.insertChild(index, child);
	        this._tabBar.insertItem(index, child);
	    };
	    /**
	     * Handle the `currentChanged` signal from the tab bar.
	     */
	    TabPanel.prototype._onCurrentChanged = function (sender, args) {
	        var oldWidget = this._currentWidget;
	        var newWidget = args.item;
	        if (oldWidget === newWidget)
	            return;
	        this._currentWidget = newWidget;
	        if (oldWidget)
	            oldWidget.hide();
	        if (newWidget)
	            newWidget.show();
	    };
	    /**
	     * Handle the `tabCloseRequested` signal from the tab bar.
	     */
	    TabPanel.prototype._onTabCloseRequested = function (sender, args) {
	        args.item.close();
	    };
	    /**
	     * Handle the `tabMoved` signal from the tab bar.
	     */
	    TabPanel.prototype._onTabMoved = function (sender, args) {
	        this._stackedPanel.insertChild(args.toIndex, args.item);
	    };
	    /**
	     * Handle the `widgetRemoved` signal from the stacked panel.
	     */
	    TabPanel.prototype._onWidgetRemoved = function (sender, widget) {
	        if (this._currentWidget === widget)
	            this._currentWidget = null;
	        this._tabBar.removeItem(widget);
	    };
	    return TabPanel;
	})(phosphor_widget_1.Widget);
	exports.TabPanel = TabPanel;


/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(44);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(12)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../css-loader/index.js!./index.css", function() {
				var newContent = require("!!./../../css-loader/index.js!./index.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 44 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\r\n| Copyright (c) 2014-2015, PhosphorJS Contributors\r\n|\r\n| Distributed under the terms of the BSD 3-Clause License.\r\n|\r\n| The full license is in the file LICENSE, distributed with this software.\r\n|----------------------------------------------------------------------------*/\r\n.p-TabBar {\r\n  display: flex;\r\n  flex-direction: column;\r\n}\r\n\r\n\r\n.p-TabBar-header,\r\n.p-TabBar-footer {\r\n  flex: 0 0 auto;\r\n}\r\n\r\n\r\n.p-TabBar-body {\r\n  display: flex;\r\n  flex-direction: row;\r\n  flex: 1 1 auto;\r\n}\r\n\r\n\r\n.p-TabBar-content {\r\n  display: flex;\r\n  flex-direction: row;\r\n  flex: 1 1 auto;\r\n  margin: 0;\r\n  padding: 0;\r\n  list-style-type: none;\r\n}\r\n\r\n\r\n.p-TabBar-tab {\r\n  display: flex;\r\n  flex-direction: row;\r\n  box-sizing: border-box;\r\n  overflow: hidden;\r\n}\r\n\r\n\r\n.p-TabBar-tabIcon,\r\n.p-TabBar-tabCloseIcon {\r\n  flex: 0 0 auto;\r\n}\r\n\r\n\r\n.p-TabBar-tabText {\r\n  flex: 1 1 auto;\r\n  overflow: hidden;\r\n  white-space: nowrap;\r\n}\r\n\r\n\r\n.p-TabBar.p-mod-dragging .p-TabBar-tab {\r\n  position: relative;\r\n  left: 0;\r\n  transition: left 150ms ease; /* keep in sync with JS */\r\n}\r\n\r\n\r\n.p-TabBar.p-mod-dragging .p-TabBar-tab.p-mod-dragging {\r\n  transition: none;\r\n}\r\n\r\n\r\n.p-TabPanel-tabBar {\r\n  z-index: 1;\r\n}\r\n\r\n\r\n.p-TabPanel-stackedPanel {\r\n  z-index: 0;\r\n}\r\n", ""]);
	
	// exports


/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(46);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(12)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../css-loader/index.js!./index.css", function() {
				var newContent = require("!!./../../css-loader/index.js!./index.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\r\n| Copyright (c) 2014-2015, PhosphorJS Contributors\r\n|\r\n| Distributed under the terms of the BSD 3-Clause License.\r\n|\r\n| The full license is in the file LICENSE, distributed with this software.\r\n|----------------------------------------------------------------------------*/\r\n.p-DockPanel {\r\n  position: relative;\r\n  z-index: 0;\r\n}\r\n\r\n\r\n.p-DockPanel > .p-Widget {\r\n  position: absolute;\r\n  z-index: 0;\r\n}\r\n\r\n\r\n.p-DockPanel-overlay {\r\n  box-sizing: border-box;\r\n  position: absolute;\r\n  top: 0;\r\n  left: 0;\r\n  width: 0;\r\n  height: 0;\r\n  z-index: 1;\r\n  pointer-events: none;\r\n}\r\n\r\n\r\n.p-TabBar-tab.p-mod-hidden,\r\n.p-DockPanel-overlay.p-mod-hidden {\r\n  display: none;\r\n}\r\n", ""]);
	
	// exports


/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var arrays = __webpack_require__(3);
	var phosphor_domutil_1 = __webpack_require__(7);
	var phosphor_properties_1 = __webpack_require__(17);
	var phosphor_signaling_1 = __webpack_require__(22);
	var phosphor_widget_1 = __webpack_require__(20);
	__webpack_require__(48);
	/**
	 * The class name added to SideBar instances.
	 */
	var SIDE_BAR_CLASS = 'p-SideBar';
	/**
	 * The class name added to the side bar content node.
	 */
	var CONTENT_CLASS = 'p-SideBar-content';
	/**
	 * The class name added to side bar button nodes.
	 */
	var BUTTON_CLASS = 'p-SideBar-button';
	/**
	 * The class name added to a side bar button text node.
	 */
	var TEXT_CLASS = 'p-SideBar-button-text';
	/**
	 * The class name added to a side bar button icon node.
	 */
	var ICON_CLASS = 'p-SideBar-button-icon';
	/**
	 * The class name added to the current side bar button.
	 */
	var CURRENT_CLASS = 'p-mod-current';
	/**
	 * A widget which displays titles as a row of exclusive buttons.
	 */
	var SideBar = (function (_super) {
	    __extends(SideBar, _super);
	    /**
	     * Construct a new side bar.
	     */
	    function SideBar() {
	        _super.call(this);
	        this._dirty = false;
	        this._titles = [];
	        this.addClass(SIDE_BAR_CLASS);
	    }
	    /**
	     * Create the DOM node for a side bar.
	     */
	    SideBar.createNode = function () {
	        var node = document.createElement('div');
	        var content = document.createElement('ul');
	        content.className = CONTENT_CLASS;
	        node.appendChild(content);
	        return node;
	    };
	    /**
	     * Dispose of the resources held by the widget.
	     */
	    SideBar.prototype.dispose = function () {
	        this._titles.length = 0;
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(SideBar.prototype, "currentChanged", {
	        /**
	         * A signal emitted when the current side bar title is changed.
	         */
	        get: function () {
	            return SideBarPrivate.currentChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SideBar.prototype, "currentTitle", {
	        /**
	         * Get the currently selected side bar title.
	         */
	        get: function () {
	            return SideBarPrivate.currentTitleProperty.get(this);
	        },
	        /**
	         * Set the currently selected side bar title.
	         */
	        set: function (value) {
	            SideBarPrivate.currentTitleProperty.set(this, value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SideBar.prototype, "contentNode", {
	        /**
	         * Get the content node which holds the side bar buttons.
	         *
	         * #### Notes
	         * Modifying this node can lead to undefined behavior.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.node.getElementsByClassName(CONTENT_CLASS)[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the number of title objects in the side bar.
	     *
	     * @returns The number of title objects in the side bar.
	     */
	    SideBar.prototype.titleCount = function () {
	        return this._titles.length;
	    };
	    /**
	     * Get the title object at the specified index.
	     *
	     * @param index - The index of the title object of interest.
	     *
	     * @returns The title at the specified index, or `undefined`.
	     */
	    SideBar.prototype.titleAt = function (index) {
	        return this._titles[index];
	    };
	    /**
	     * Get the index of the specified title object.
	     *
	     * @param title - The title object of interest.
	     *
	     * @returns The index of the specified title, or `-1`.
	     */
	    SideBar.prototype.titleIndex = function (title) {
	        return this._titles.indexOf(title);
	    };
	    /**
	     * Add a title object to the end of the side bar.
	     *
	     * @param title - The title object to add to the side bar.
	     *
	     * #### Notes
	     * If the title is already added to the side bar, it will be moved.
	     */
	    SideBar.prototype.addTitle = function (title) {
	        this.insertTitle(this.titleCount(), title);
	    };
	    /**
	     * Insert a title object at the specified index.
	     *
	     * @param index - The index at which to insert the title.
	     *
	     * @param title - The title object to insert into to the side bar.
	     *
	     * #### Notes
	     * If the title is already added to the side bar, it will be moved.
	     */
	    SideBar.prototype.insertTitle = function (index, title) {
	        var n = this.titleCount();
	        var i = this.titleIndex(title);
	        var j = Math.max(0, Math.min(index | 0, n));
	        if (i !== -1) {
	            if (j === n)
	                j--;
	            if (i === j)
	                return;
	            arrays.move(this._titles, i, j);
	        }
	        else {
	            arrays.insert(this._titles, j, title);
	            title.changed.connect(this._onTitleChanged, this);
	        }
	        this._dirty = true;
	        this.update();
	    };
	    /**
	     * Remove a title object from the side bar.
	     *
	     * @param title - The title object to remove from the side bar.
	     *
	     * #### Notes
	     * If the title is not in the side bar, this is a no-op.
	     */
	    SideBar.prototype.removeTitle = function (title) {
	        var i = arrays.remove(this._titles, title);
	        if (i === -1) {
	            return;
	        }
	        title.changed.disconnect(this._onTitleChanged, this);
	        if (this.currentTitle === title)
	            this.currentTitle = null;
	        this._dirty = true;
	        this.update();
	    };
	    /**
	     * Handle the DOM events for the side bar.
	     *
	     * @param event - The DOM event sent to the side bar.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the side bar's DOM node. It should
	     * not be called directly by user code.
	     */
	    SideBar.prototype.handleEvent = function (event) {
	        if (event.type === 'mousedown') {
	            this._evtMouseDown(event);
	        }
	    };
	    /**
	     * A message handler invoked on an `'after-attach'` message.
	     */
	    SideBar.prototype.onAfterAttach = function (msg) {
	        this.node.addEventListener('mousedown', this);
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     */
	    SideBar.prototype.onBeforeDetach = function (msg) {
	        this.node.removeEventListener('mousedown', this);
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    SideBar.prototype.onUpdateRequest = function (msg) {
	        if (this._dirty) {
	            this._dirty = false;
	            SideBarPrivate.updateButtons(this);
	        }
	        else {
	            SideBarPrivate.updateCurrent(this);
	        }
	    };
	    /**
	     * Handle the `'mousedown'` event for the side bar.
	     */
	    SideBar.prototype._evtMouseDown = function (event) {
	        // Do nothing if it's not a left mouse press.
	        if (event.button !== 0) {
	            return;
	        }
	        // Do nothing if the press is not on a button.
	        var i = SideBarPrivate.hitTestButtons(this, event.clientX, event.clientY);
	        if (i < 0) {
	            return;
	        }
	        // Pressing on a button stops the event propagation.
	        event.preventDefault();
	        event.stopPropagation();
	        // Update the current title.
	        var title = this._titles[i];
	        if (title !== this.currentTitle) {
	            this.currentTitle = title;
	        }
	        else {
	            this.currentTitle = null;
	        }
	    };
	    /**
	     * Handle the `changed` signal of a title object.
	     */
	    SideBar.prototype._onTitleChanged = function () {
	        this._dirty = true;
	        this.update();
	    };
	    return SideBar;
	}(phosphor_widget_1.Widget));
	exports.SideBar = SideBar;
	/**
	 * The namespace for the `SideBar` class private data.
	 */
	var SideBarPrivate;
	(function (SideBarPrivate) {
	    /**
	     * A signal emitted when the current title is changed.
	     */
	    SideBarPrivate.currentChangedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * The property descriptor for the current side bar title.
	     */
	    SideBarPrivate.currentTitleProperty = new phosphor_properties_1.Property({
	        name: 'currentTitle',
	        value: null,
	        coerce: coerceCurrentTitle,
	        changed: onCurrentTitleChanged,
	        notify: SideBarPrivate.currentChangedSignal,
	    });
	    /**
	     * Update the side bar buttons to match the current titles.
	     *
	     * This is a full update which also updates the currrent state.
	     */
	    function updateButtons(owner) {
	        var count = owner.titleCount();
	        var content = owner.contentNode;
	        var children = content.children;
	        while (children.length > count) {
	            content.removeChild(content.lastChild);
	        }
	        while (children.length < count) {
	            content.appendChild(createButtonNode());
	        }
	        for (var i = 0; i < count; ++i) {
	            var node = children[i];
	            updateButtonNode(node, owner.titleAt(i));
	        }
	        updateCurrent(owner);
	    }
	    SideBarPrivate.updateButtons = updateButtons;
	    /**
	     * Update the current state of the buttons to match the side bar.
	     *
	     * This is a partial update which only updates the current button
	     * class. It assumes the button count is the same as the title count.
	     */
	    function updateCurrent(owner) {
	        var count = owner.titleCount();
	        var content = owner.contentNode;
	        var children = content.children;
	        var current = owner.currentTitle;
	        for (var i = 0; i < count; ++i) {
	            var node = children[i];
	            if (owner.titleAt(i) === current) {
	                node.classList.add(CURRENT_CLASS);
	            }
	            else {
	                node.classList.remove(CURRENT_CLASS);
	            }
	        }
	    }
	    SideBarPrivate.updateCurrent = updateCurrent;
	    /**
	     * Get the index of the button node at a client position, or `-1`.
	     */
	    function hitTestButtons(owner, x, y) {
	        var nodes = owner.contentNode.children;
	        for (var i = 0, n = nodes.length; i < n; ++i) {
	            if (phosphor_domutil_1.hitTest(nodes[i], x, y))
	                return i;
	        }
	        return -1;
	    }
	    SideBarPrivate.hitTestButtons = hitTestButtons;
	    /**
	     * The coerce handler for the `currentTitle` property.
	     */
	    function coerceCurrentTitle(owner, value) {
	        return (value && owner.titleIndex(value) !== -1) ? value : null;
	    }
	    /**
	     * The change handler for the `currentTitle` property.
	     */
	    function onCurrentTitleChanged(owner) {
	        owner.update();
	    }
	    /**
	     * Create an uninitialized DOM node for a side bar button.
	     */
	    function createButtonNode() {
	        var node = document.createElement('li');
	        var icon = document.createElement('span');
	        var text = document.createElement('span');
	        text.className = TEXT_CLASS;
	        node.appendChild(icon);
	        node.appendChild(text);
	        return node;
	    }
	    /**
	     * Update a button node to reflect the state of a title.
	     */
	    function updateButtonNode(node, title) {
	        var icon = node.firstChild;
	        var text = node.lastChild;
	        if (title.className) {
	            node.className = BUTTON_CLASS + ' ' + title.className;
	        }
	        else {
	            node.className = BUTTON_CLASS;
	        }
	        if (title.icon) {
	            icon.className = ICON_CLASS + ' ' + title.icon;
	        }
	        else {
	            icon.className = ICON_CLASS;
	        }
	        text.textContent = title.text;
	    }
	})(SideBarPrivate || (SideBarPrivate = {}));


/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(49);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(12)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../../css-loader/index.js!./sidebar.css", function() {
				var newContent = require("!!./../../../css-loader/index.js!./sidebar.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n.p-SideBar-content {\n  margin: 0;\n  padding: 0;\n  display: flex;\n  align-items: stretch;\n  list-style-type: none;\n}\n", ""]);
	
	// exports


/***/ },
/* 50 */
/***/ function(module, exports) {

	"use strict";
	/**
	 * A class which manages a registry of extensions.
	 *
	 * #### Notes
	 * A service registry is used by populating it with extension objects,
	 * then calling the `activate` method to activate a specific extension.
	 *
	 * This class is used internally by the `Application` class. It will
	 * not typically be used directly by user code.
	 */
	var ExtensionRegistry = (function () {
	    /**
	     * Construct a new extension registry.
	     */
	    function ExtensionRegistry() {
	        this._extensionsByID = Private.createExtensionIDMap();
	    }
	    /**
	     * Register an extension with the registry.
	     *
	     * @param extension - The extension to add to the registry.
	     *
	     * #### Notes
	     * An error will be thrown if the extension id is already registered.
	     */
	    ExtensionRegistry.prototype.registerExtension = function (extension) {
	        // Throw an error if the extension id is already registered.
	        if (extension.id in this._extensionsByID) {
	            throw new Error("extension '" + extension.id + "' already registered");
	        }
	        // Create the extended extension and add it to the registry.
	        var ext = Private.createExtensionEx(extension);
	        this._extensionsByID[ext.id] = ext;
	    };
	    /**
	     * List the IDs of all extensions in the registry.
	     *
	     * @returns A new array of all extension IDs in the registry.
	     */
	    ExtensionRegistry.prototype.listExtensions = function () {
	        return Object.keys(this._extensionsByID);
	    };
	    /**
	     * Test whether the registry has an extension with the given id.
	     *
	     * @param id - The id of the extension of interest.
	     *
	     * @returns `true` if an extension with the specified id is
	     *   registered, `false` otherwise.
	     */
	    ExtensionRegistry.prototype.hasExtension = function (id) {
	        return id in this._extensionsByID;
	    };
	    /**
	     * Activate the extension with the given id.
	     *
	     * @param id - The ID of the extension of interest.
	     *
	     * @param context - The context object to pass as the first argument
	     *   to the extension's `activate` function.
	     *
	     * @param services - The service registry for resolving the services
	     *   required by the extension.
	     *
	     * @returns A promise which resolves when the extension is fully
	     *   activated or rejects with an error if it cannot be activated.
	     */
	    ExtensionRegistry.prototype.activateExtension = function (id, context, services) {
	        // Reject the promise if the extension is not registered.
	        var ext = this._extensionsByID[id];
	        if (!ext) {
	            return Promise.reject(new Error("extension '" + id + "' not registered"));
	        }
	        // Resolve immediately if the extension is already activated.
	        if (ext.activated) {
	            return Promise.resolve();
	        }
	        // Return the pending resolver promise if it exists.
	        if (ext.promise) {
	            return ext.promise;
	        }
	        // Resolve the services required by the extension.
	        var promises = ext.requires.map(function (req) { return services.resolveService(req); });
	        // Setup the resolver promise for the extension.
	        ext.promise = Promise.all(promises).then(function (deps) {
	            deps.unshift(context);
	            return ext.activate.apply(void 0, deps);
	        }).then(function () {
	            ext.promise = null;
	            ext.activated = true;
	        }).catch(function (error) {
	            ext.promise = null;
	            throw error;
	        });
	        // Return the pending resolver promise.
	        return ext.promise;
	    };
	    return ExtensionRegistry;
	}());
	exports.ExtensionRegistry = ExtensionRegistry;
	/**
	 * The namespace for the private extension registry functionality.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create new extension id map.
	     */
	    function createExtensionIDMap() {
	        return Object.create(null);
	    }
	    Private.createExtensionIDMap = createExtensionIDMap;
	    /**
	     * Create a new extended extension.
	     *
	     * @param extension - The extension source object.
	     *
	     * @returns A new extended extension initialized with the data
	     *   from the given extension.
	     *
	     * #### Notes
	     * The `requires` property of the extended extension will always be
	     * specified. If the original extension does not have dependencies,
	     * the `requires` array will be empty.
	     */
	    function createExtensionEx(extension) {
	        var id = extension.id, requires = extension.requires, activate = extension.activate;
	        requires = requires ? requires.slice() : [];
	        return { id: id, requires: requires, activate: activate, activated: false, promise: null };
	    }
	    Private.createExtensionEx = createExtensionEx;
	})(Private || (Private = {}));


/***/ },
/* 51 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	"use strict";
	/**
	 * A class which manages a registry of service providers.
	 *
	 * #### Notes
	 * A service registry is used by populating it with service providers,
	 * then calling the `resolve` method to get the singleton instance of
	 * a specified service type.
	 *
	 * This class is used internally by the `Application` class. It will
	 * not typically be used directly by user code.
	 */
	var ServiceRegistry = (function () {
	    /**
	     * Construct a new service registry.
	     */
	    function ServiceRegistry() {
	        this._providersByID = Private.createProviderIDMap();
	        this._providersByType = Private.createProviderTypeMap();
	    }
	    /**
	     * Register a service provider with the registry.
	     *
	     * @param provider - The service provider to add to the registry.
	     *
	     * #### Notes
	     * An error will be thrown if a provider with the same id is already
	     * registered, if a provider which provides the identical service is
	     * already registered, or if the provider has a circular dependency.
	     */
	    ServiceRegistry.prototype.registerProvider = function (provider) {
	        // Throw an error if the provider id is already registered.
	        var pid = provider.id;
	        if (pid in this._providersByID) {
	            throw new Error("provider '" + pid + "' already registered");
	        }
	        // Throw an error if the service type is already registered.
	        var other = this._providersByType.get(provider.provides);
	        if (other) {
	            throw new Error("'" + pid + "' service already provided by '" + other.id + "'");
	        }
	        // Throw an error if the provider has a circular dependency.
	        var cycle = Private.findCycle(provider, this._providersByType);
	        if (cycle) {
	            throw new Error("provider cycle detected: " + cycle.join(' -> '));
	        }
	        // Create the extended provider and add it to the registry.
	        var pex = Private.createProviderEx(provider);
	        this._providersByType.set(pex.provides, pex);
	        this._providersByID[pex.id] = pex;
	    };
	    /**
	     * List the IDs of all service providers in the registry.
	     *
	     * @returns A new array of all provider IDs in the registry.
	     */
	    ServiceRegistry.prototype.listProviders = function () {
	        return Object.keys(this._providersByID);
	    };
	    /**
	     * Test whether the registry has a provider with the given id.
	     *
	     * @param id - The id of the provider of interest.
	     *
	     * @returns `true` if a service provider with the specified id is
	     *   registered, `false` otherwise.
	     */
	    ServiceRegistry.prototype.hasProvider = function (id) {
	        return id in this._providersByID;
	    };
	    /**
	     * Test whether the registry has a provider for the given service.
	     *
	     * @param kind - The type of the service of interest.
	     *
	     * @returns `true` if a service provider is registered for the
	     *   specified service type, `false` otherwise.
	     */
	    ServiceRegistry.prototype.hasProviderFor = function (kind) {
	        return this._providersByType.has(kind);
	    };
	    /**
	     * Resolve a service implementation for the given type.
	     *
	     * @param kind - The type of service object to resolve.
	     *
	     * @returns A promise which resolves the specified service type,
	     *   or rejects with an error if it cannot be satisfied.
	     *
	     * #### Notes
	     * Services are singletons. The same service instance will be
	     * returned each time a given service type is resolved.
	     */
	    ServiceRegistry.prototype.resolveService = function (kind) {
	        return Private.resolveService(kind, this._providersByType, []);
	    };
	    return ServiceRegistry;
	}());
	exports.ServiceRegistry = ServiceRegistry;
	/**
	 * The namespace for the private service registry functionality.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Create new provider id map.
	     */
	    function createProviderIDMap() {
	        return Object.create(null);
	    }
	    Private.createProviderIDMap = createProviderIDMap;
	    /**
	     * Create a new provider type map.
	     */
	    function createProviderTypeMap() {
	        return new Map();
	    }
	    Private.createProviderTypeMap = createProviderTypeMap;
	    /**
	     * Create a new extended provider.
	     *
	     * @param provider - The service provider source object.
	     *
	     * @returns A new extended provider initialized with the data
	     *   from the given service provider.
	     *
	     * #### Notes
	     * The `requires` property of the extended provider will always be
	     * specified. If the original provider does not have dependencies,
	     * the `requires` array will be empty.
	     */
	    function createProviderEx(provider) {
	        var id = provider.id, provides = provider.provides, requires = provider.requires, resolve = provider.resolve;
	        requires = requires ? requires.slice() : [];
	        return { id: id, provides: provides, requires: requires, resolve: resolve, value: null, resolved: false, promise: null };
	    }
	    Private.createProviderEx = createProviderEx;
	    /**
	     * Find a cycle with the given service provider, if one exists.
	     *
	     * @param provider - The service provider to test for a cycle.
	     *
	     * @param map - The mapping of type to extended provider.
	     *
	     * @returns The ordered IDs of the cyclic providers, or null if
	     *   no cycle is present.
	     */
	    function findCycle(provider, map) {
	        if (!provider.requires)
	            return null;
	        var trace = [provider.id];
	        var root = provider.provides;
	        return provider.requires.some(visit) ? trace : null;
	        function visit(kind) {
	            if (kind === root) {
	                return true;
	            }
	            var pex = map.get(kind);
	            if (!pex) {
	                return false;
	            }
	            trace.push(pex.id);
	            if (pex.requires.some(visit)) {
	                return true;
	            }
	            trace.pop();
	            return false;
	        }
	    }
	    Private.findCycle = findCycle;
	    /**
	     * Resolve the instance of the specified service type.
	     *
	     * @param kind - The service type to resolve.
	     *
	     * @param map - The mapping of type to extended provider.
	     *
	     * @param path - An array of provider ids representing the current
	     *   path of the resolver graph. This should be an empty array for
	     *   the first call to this function.
	     *
	     * @returns A promise which resolves to an instance of the requested
	     *   type, or rejects if the instance cannot be created.
	     */
	    function resolveService(kind, map, path) {
	        // Reject the promise if there is no provider for the type.
	        var pex = map.get(kind);
	        if (!pex) {
	            return Promise.reject(missingProviderError(kind, path));
	        }
	        // Resolve immediately if the provider is already resolved.
	        if (pex.resolved) {
	            return Promise.resolve(pex.value);
	        }
	        // Return the pending resolver promise if it exists.
	        if (pex.promise) {
	            return pex.promise;
	        }
	        // Setup the resolver promise for the provider.
	        pex.promise = resolveImpl(pex, map, path).then(function (value) {
	            pex.value = value;
	            pex.promise = null;
	            pex.resolved = true;
	            return value;
	        }, function (error) {
	            pex.promise = null;
	            throw error;
	        });
	        // Return the pending resolver promise.
	        return pex.promise;
	    }
	    Private.resolveService = resolveService;
	    /**
	     * Resolve the service instance for the given provider.
	     */
	    function resolveImpl(pex, map, path) {
	        // Push the current provider id onto the path stack.
	        path.push(pex.id);
	        // Generate the resolver promises from the provider dependencies.
	        var reqs = pex.requires.map(function (kind) { return resolveService(kind, map, path); });
	        // Pop the provider id from the path stack.
	        path.pop();
	        // Return the promise which resolves the type for the provider.
	        return Promise.all(reqs).then(function (deps) { return pex.resolve.apply(void 0, deps); });
	    }
	    /**
	     * Create a formatted error for a missing provider.
	     *
	     * @param kind - The service type which cannot be fulfilled.
	     *
	     * @param path - The resolver path at the point of failure.
	     *
	     * @returns An error with a formatted message.
	     */
	    function missingProviderError(kind, path) {
	        // The `any` cast is needed due to no `Function.name` on IE.
	        var name = kind.name || '';
	        var head = "No registered provider for type: " + name + ".";
	        var tail = "Provider resolution path: " + path.join(' -> ') + ".";
	        return new Error(head + " " + tail);
	    }
	})(Private || (Private = {}));


/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var phosphor_disposable_1 = __webpack_require__(8);
	var phosphor_signaling_1 = __webpack_require__(22);
	/**
	 * An abstract base class which defines a command registry.
	 */
	var ABCCommandRegistry = (function () {
	    function ABCCommandRegistry() {
	    }
	    Object.defineProperty(ABCCommandRegistry.prototype, "commandsAdded", {
	        /**
	         * A signal emitted when commands are added to the registry.
	         */
	        get: function () {
	            return Private.commandsAddedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ABCCommandRegistry.prototype, "commandsRemoved", {
	        /**
	         * A signal emitted when commands are removed from the registry.
	         */
	        get: function () {
	            return Private.commandsRemovedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ABCCommandRegistry.prototype, "commandExecuted", {
	        /**
	         * A signal emitted when a command is executed.
	         */
	        get: function () {
	            return Private.commandExecutedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return ABCCommandRegistry;
	}());
	exports.ABCCommandRegistry = ABCCommandRegistry;
	/**
	 * A concrete implementation of ABCCommandRegistry.
	 */
	var CommandRegistry = (function (_super) {
	    __extends(CommandRegistry, _super);
	    function CommandRegistry() {
	        _super.apply(this, arguments);
	        this._commands = Private.createCommandMap();
	    }
	    /**
	     * List the ids of the currently registered commands.
	     *
	     * @returns A new array of the registered command ids.
	     */
	    CommandRegistry.prototype.list = function () {
	        return Object.keys(this._commands);
	    };
	    /**
	     * Test whether the registry contains a command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @returns `true` if the command is registered, `false` otherwise.
	     */
	    CommandRegistry.prototype.has = function (id) {
	        return id in this._commands;
	    };
	    /**
	     * Add commands to the registry.
	     *
	     * @param items - The command items to add to the registry.
	     *
	     * @returns A disposable which will remove the added commands.
	     *
	     * #### Notes
	     * If the `id` for a command is already registered, a warning will be
	     * logged to the console and that specific command will be ignored.
	     */
	    CommandRegistry.prototype.add = function (items) {
	        var _this = this;
	        // Setup the array for the new unique ids.
	        var added = [];
	        // Add the new commands to the map and warn for duplicates.
	        for (var _i = 0, items_1 = items; _i < items_1.length; _i++) {
	            var _a = items_1[_i], id = _a.id, handler = _a.handler;
	            if (id in this._commands) {
	                console.warn("Command '" + id + "' is already registered.");
	            }
	            else {
	                this._commands[id] = handler;
	                added.push(id);
	            }
	        }
	        // If no items are added, return an empty delegate.
	        if (added.length === 0) {
	            return new phosphor_disposable_1.DisposableDelegate(null);
	        }
	        // Notify for the added commands using a safe shallow copy.
	        this.commandsAdded.emit(added.slice());
	        // Return a delegate which will remove the added commands.
	        return new phosphor_disposable_1.DisposableDelegate(function () {
	            for (var _i = 0, added_1 = added; _i < added_1.length; _i++) {
	                var id = added_1[_i];
	                delete _this._commands[id];
	            }
	            _this.commandsRemoved.emit(added.slice());
	        });
	    };
	    /**
	     * Execute a registered command.
	     *
	     * @param id - The id of the command to execute.
	     *
	     * #### Notes
	     * If the command id is not registered, a warning will be logged.
	     *
	     * If the handler throws an exception, it will be caught and logged.
	     */
	    CommandRegistry.prototype.execute = function (id) {
	        var handler = this._commands[id];
	        if (!handler) {
	            console.warn("command '" + id + "' not registered");
	            return;
	        }
	        try {
	            handler();
	        }
	        catch (err) {
	            console.error("error in command '" + id + "'", err);
	        }
	        this.commandExecuted.emit(id);
	    };
	    return CommandRegistry;
	}(ABCCommandRegistry));
	exports.CommandRegistry = CommandRegistry;
	/**
	 * The default command registry service provider.
	 */
	exports.commandRegistryProvider = {
	    id: 'phosphide.services.commandRegistry',
	    provides: ABCCommandRegistry,
	    resolve: function () { return new CommandRegistry(); },
	};
	/**
	 * The namespace for the private command registry functionality.
	 */
	var Private;
	(function (Private) {
	    /**
	     *
	     */
	    Private.commandsAddedSignal = new phosphor_signaling_1.Signal();
	    /**
	     *
	     */
	    Private.commandsRemovedSignal = new phosphor_signaling_1.Signal();
	    /**
	     *
	     */
	    Private.commandExecutedSignal = new phosphor_signaling_1.Signal();
	    /**
	     *
	     */
	    function createCommandMap() {
	        return Object.create(null);
	    }
	    Private.createCommandMap = createCommandMap;
	})(Private || (Private = {}));


/***/ },
/* 53 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var phosphor_commandpalette_1 = __webpack_require__(54);
	var phosphor_disposable_1 = __webpack_require__(8);
	var phosphor_signaling_1 = __webpack_require__(22);
	var commandregistry_1 = __webpack_require__(52);
	var shortcutregistry_1 = __webpack_require__(61);
	/**
	 *
	 */
	var ABCPaletteRegistry = (function () {
	    function ABCPaletteRegistry() {
	    }
	    Object.defineProperty(ABCPaletteRegistry.prototype, "commandTriggered", {
	        /**
	         * A signal emitted when a command is triggered by the palette.
	         */
	        get: function () {
	            return Private.commandTriggeredSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ABCPaletteRegistry.prototype, "model", {
	        /**
	         *
	         */
	        get: function () {
	            return this.getModel();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return ABCPaletteRegistry;
	}());
	exports.ABCPaletteRegistry = ABCPaletteRegistry;
	/**
	 *
	 */
	var PaletteRegistry = (function (_super) {
	    __extends(PaletteRegistry, _super);
	    /**
	     *
	     */
	    function PaletteRegistry(commands, shortcuts) {
	        var _this = this;
	        _super.call(this);
	        /**
	         * The private command handler function.
	         */
	        this._executeCommand = function (id) {
	            _this.commandTriggered.emit(id);
	            _this._commands.execute(id);
	        };
	        this._model = new phosphor_commandpalette_1.StandardPaletteModel();
	        this._boxes = [];
	        this._commands = commands;
	        this._shortcuts = shortcuts;
	        this._shortcuts.shortcutsAdded.connect(this._onShortcutsChanged, this);
	        this._shortcuts.shortcutsRemoved.connect(this._onShortcutsChanged, this);
	    }
	    /**
	     * Add command palette items to the palette registry.
	     *
	     * @param items - The array of items to add to the registry.
	     *
	     * @returns A disposable which will remove the added items.
	     */
	    PaletteRegistry.prototype.add = function (items) {
	        var _this = this;
	        var optionsArray = items.map(function (item) {
	            // let commandExists = this._commandRegistry.has(item.id);
	            // if (!commandExists) return null;
	            var seq = _this._shortcuts.sequenceFor(item.command);
	            var shortcut = seq ? Private.formatSequence(seq) : '';
	            var options = {
	                handler: _this._executeCommand,
	                args: item.command,
	                text: item.text,
	                shortcut: shortcut,
	                icon: item.icon || '',
	                caption: item.caption || '',
	                category: item.category || ''
	            };
	            return options;
	        });
	        if (optionsArray.length === 0) {
	            return new phosphor_disposable_1.DisposableDelegate(null);
	        }
	        var boxes = this._model.addItems(optionsArray).map(function (item) { return ({ item: item }); });
	        Array.prototype.push.apply(this._boxes, boxes);
	        return new phosphor_disposable_1.DisposableDelegate(function () {
	            _this._model.removeItems(boxes.map(function (box) { return box.item; }));
	            _this._boxes = _this._boxes.filter(function (box) { return boxes.indexOf(box) === -1; });
	        });
	    };
	    /**
	     *
	     */
	    PaletteRegistry.prototype.getModel = function () {
	        return this._model;
	    };
	    /**
	     * Update the shortcut for the given item pair.
	     */
	    PaletteRegistry.prototype._updateShortcut = function (box) {
	        var seq = this._shortcuts.sequenceFor(box.item.args);
	        var shortcut = seq ? Private.formatSequence(seq) : '';
	        var options = {
	            handler: this._executeCommand,
	            args: box.item.args,
	            text: box.item.text,
	            shortcut: shortcut,
	            icon: box.item.icon,
	            caption: box.item.caption,
	            category: box.item.category
	        };
	        this._model.removeItem(box.item);
	        box.item = this._model.addItem(options);
	    };
	    /**
	     * A handler for shortcut registry signals.
	     */
	    PaletteRegistry.prototype._onShortcutsChanged = function (sender, commands) {
	        var changed = Object.create(null);
	        commands.forEach(function (id) { changed[id] = true; });
	        for (var _i = 0, _a = this._boxes; _i < _a.length; _i++) {
	            var box = _a[_i];
	            var relevant = box.item.args in changed;
	            if (relevant)
	                this._updateShortcut(box);
	        }
	    };
	    return PaletteRegistry;
	}(ABCPaletteRegistry));
	exports.PaletteRegistry = PaletteRegistry;
	/**
	 * The default palette registry service provider.
	 */
	exports.paletteRegistryProvider = {
	    id: 'phosphide.services.paletteRegistry',
	    provides: ABCPaletteRegistry,
	    requires: [commandregistry_1.ABCCommandRegistry, shortcutregistry_1.ABCShortcutRegistry],
	    resolve: function (commands, shortcuts) {
	        return new PaletteRegistry(commands, shortcuts);
	    },
	};
	/**
	 *
	 */
	var Private;
	(function (Private) {
	    /**
	     * A signal emitted when a command is triggered by the palette.
	     */
	    Private.commandTriggeredSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A flag indicating whether the platform is Mac.
	     */
	    var IS_MAC = !!navigator.platform.match(/Mac/i);
	    /**
	     * How to format Accel (Cmd on Mac, Ctrl elsewhere)
	     */
	    var ACCEL = IS_MAC ? 'Cmd' : 'Ctrl';
	    /**
	     *
	     */
	    function formatSequence(seq) {
	        return seq.map(function (s) { return s.trim().replace(/\s+/g, '-').replace('Accel', ACCEL); }).join(' ');
	    }
	    Private.formatSequence = formatSequence;
	})(Private || (Private = {}));


/***/ },
/* 54 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(55));
	__export(__webpack_require__(56));
	__export(__webpack_require__(57));
	__export(__webpack_require__(58));
	__webpack_require__(59);


/***/ },
/* 55 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var phosphor_signaling_1 = __webpack_require__(22);
	/**
	 * An enum of the support search result types.
	 */
	(function (SearchResultType) {
	    /**
	     * The search result represents a section header.
	     */
	    SearchResultType[SearchResultType["Header"] = 0] = "Header";
	    /**
	     * The search result represents a command.
	     */
	    SearchResultType[SearchResultType["Command"] = 1] = "Command";
	})(exports.SearchResultType || (exports.SearchResultType = {}));
	var SearchResultType = exports.SearchResultType;
	/**
	 * An abstract base class for creating command palette models.
	 */
	var AbstractPaletteModel = (function () {
	    function AbstractPaletteModel() {
	    }
	    Object.defineProperty(AbstractPaletteModel.prototype, "changed", {
	        /**
	         * A signal emitted when the potential search results change.
	         *
	         * #### Notes
	         * A subclass should emit this signal when its contents change in
	         * a way which may invalidate previously computed search results.
	         */
	        get: function () {
	            return AbstractPaletteModelPrivate.changedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return AbstractPaletteModel;
	})();
	exports.AbstractPaletteModel = AbstractPaletteModel;
	/**
	 * The namespace for the `AbstractPaletteModel` private data.
	 */
	var AbstractPaletteModelPrivate;
	(function (AbstractPaletteModelPrivate) {
	    /**
	     * A signal emitted when a palette model's search results change.
	     */
	    AbstractPaletteModelPrivate.changedSignal = new phosphor_signaling_1.Signal();
	})(AbstractPaletteModelPrivate || (AbstractPaletteModelPrivate = {}));


/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var arrays = __webpack_require__(3);
	var phosphor_widget_1 = __webpack_require__(20);
	var abstractmodel_1 = __webpack_require__(55);
	/**
	 * The class name added to `CommandPalette` instances.
	 */
	var PALETTE_CLASS = 'p-CommandPalette';
	/**
	 * The class name added to the search section of the palette.
	 */
	var SEARCH_CLASS = 'p-CommandPalette-search';
	/**
	 * The class name added to the input wrapper in the search section.
	 */
	var WRAPPER_CLASS = 'p-CommandPalette-inputWrapper';
	/**
	 * The class name added to the input node in the search section.
	 */
	var INPUT_CLASS = 'p-CommandPalette-input';
	/**
	 * The class name added to the content section of the palette.
	 */
	var CONTENT_CLASS = 'p-CommandPalette-content';
	/**
	 * The class name added to a palette section header.
	 */
	var HEADER_CLASS = 'p-CommandPalette-header';
	/**
	 * The class name added to a palette command.
	 */
	var COMMAND_CLASS = 'p-CommandPalette-command';
	/**
	 * The class name added to the command content node.
	 */
	var COMMAND_CONTENT_CLASS = 'p-CommandPalette-commandContent';
	/**
	 * The class name added to a command icon node.
	 */
	var COMMAND_ICON_CLASS = 'p-CommandPalette-commandIcon';
	/**
	 * The class name added to a command text node.
	 */
	var COMMAND_TEXT_CLASS = 'p-CommandPalette-commandText';
	/**
	 * The class name added to a command shortcut node.
	 */
	var COMMAND_SHORTCUT_CLASS = 'p-CommandPalette-commandShortcut';
	/**
	 * The class name added to a command caption node.
	 */
	var COMMAND_CAPTION_CLASS = 'p-CommandPalette-commandCaption';
	/**
	 * The class name added to the active palette header or command.
	 */
	var ACTIVE_CLASS = 'p-mod-active';
	/**
	 * An enum of command palette activation targets.
	 */
	(function (ActivationTarget) {
	    /**
	     * The activation target is a header item.
	     */
	    ActivationTarget[ActivationTarget["Header"] = 0] = "Header";
	    /**
	     * The activation target is a command item.
	     */
	    ActivationTarget[ActivationTarget["Command"] = 1] = "Command";
	    /**
	     * The activate target is any item.
	     */
	    ActivationTarget[ActivationTarget["Any"] = 2] = "Any";
	})(exports.ActivationTarget || (exports.ActivationTarget = {}));
	var ActivationTarget = exports.ActivationTarget;
	/**
	 * A widget which displays commands from a command source.
	 */
	var CommandPalette = (function (_super) {
	    __extends(CommandPalette, _super);
	    /**
	     * Construct a new command palette.
	     */
	    function CommandPalette() {
	        _super.call(this);
	        this._activeIndex = -1;
	        this._results = [];
	        this._headerPool = [];
	        this._commandPool = [];
	        this._model = null;
	        this.addClass(PALETTE_CLASS);
	    }
	    /**
	     * Create the DOM node for a command palette.
	     */
	    CommandPalette.createNode = function () {
	        var node = document.createElement('div');
	        var search = document.createElement('div');
	        var wrapper = document.createElement('div');
	        var input = document.createElement('input');
	        var content = document.createElement('ul');
	        search.className = SEARCH_CLASS;
	        wrapper.className = WRAPPER_CLASS;
	        input.className = INPUT_CLASS;
	        content.className = CONTENT_CLASS;
	        input.spellcheck = false;
	        wrapper.appendChild(input);
	        search.appendChild(wrapper);
	        node.appendChild(search);
	        node.appendChild(content);
	        return node;
	    };
	    /**
	     * Create a new header node for a command palette.
	     *
	     * @returns A new DOM node for a palette section header.
	     *
	     * #### Notes
	     * This method may be reimplemented to create custom headers.
	     */
	    CommandPalette.createHeaderNode = function () {
	        var node = document.createElement('li');
	        node.className = HEADER_CLASS;
	        return node;
	    };
	    /**
	     * Create a new command node for a command palette.
	     *
	     * @returns A new DOM node for a palette section command.
	     *
	     * #### Notes
	     * This method may be reimplemented to create custom items.
	     */
	    CommandPalette.createCommandNode = function () {
	        var node = document.createElement('li');
	        var content = document.createElement('div');
	        var icon = document.createElement('span');
	        var text = document.createElement('span');
	        var caption = document.createElement('span');
	        var shortcut = document.createElement('span');
	        node.className = COMMAND_CLASS;
	        content.className = COMMAND_CONTENT_CLASS;
	        icon.className = COMMAND_ICON_CLASS;
	        text.className = COMMAND_TEXT_CLASS;
	        caption.className = COMMAND_CAPTION_CLASS;
	        shortcut.className = COMMAND_SHORTCUT_CLASS;
	        content.appendChild(shortcut);
	        content.appendChild(text);
	        content.appendChild(caption);
	        node.appendChild(icon);
	        node.appendChild(content);
	        return node;
	    };
	    /**
	     * Update a header node to reflect the given data.
	     *
	     * @param node - The header node which should be updated.
	     *
	     * @param data - The data object to use for the node state.
	     *
	     * #### Notes
	     * This is called automatically when the node should be updated.
	     *
	     * If the [[createHeaderNode]] method is reimplemented, this method
	     * should also be reimplemented so that the node state is properly
	     * updated.
	     */
	    CommandPalette.updateHeaderNode = function (node, data) {
	        node.className = HEADER_CLASS;
	        node.innerHTML = data.text;
	    };
	    /**
	     * Update a command node to reflect the given data.
	     *
	     * @param node - The command node which should be updated.
	     *
	     * @param data - The data object to use for the node state.
	     *
	     * #### Notes
	     * This is called automatically when the node should be updated.
	     *
	     * If the [[createHeaderNode]] method is reimplemented, this method
	     * should also be reimplemented so that the node state is properly
	     * updated.
	     */
	    CommandPalette.updateCommandNode = function (node, data) {
	        var icon = node.firstChild;
	        var content = icon.nextSibling;
	        var shortcut = content.firstChild;
	        var text = shortcut.nextSibling;
	        var caption = text.nextSibling;
	        var itemClass = COMMAND_CLASS;
	        if (data.className)
	            itemClass += ' ' + data.className;
	        node.className = itemClass;
	        var iconClass = COMMAND_ICON_CLASS;
	        if (data.icon)
	            iconClass += ' ' + data.icon;
	        icon.className = iconClass;
	        text.innerHTML = data.text;
	        caption.innerHTML = data.caption;
	        shortcut.innerHTML = data.shortcut;
	    };
	    /**
	     * Dispose of the resources held by the command palette.
	     */
	    CommandPalette.prototype.dispose = function () {
	        this._model = null;
	        this._results.length = 0;
	        this._headerPool.length = 0;
	        this._commandPool.length = 0;
	        _super.prototype.dispose.call(this);
	    };
	    Object.defineProperty(CommandPalette.prototype, "model", {
	        /**
	         * Get the model for the command palette.
	         */
	        get: function () {
	            return this._model;
	        },
	        /**
	         * Set the model for the command palette.
	         */
	        set: function (value) {
	            value = value || null;
	            if (this._model === value) {
	                return;
	            }
	            if (this._model) {
	                this._model.changed.disconnect(this._onModelChanged, this);
	            }
	            if (value) {
	                value.changed.connect(this._onModelChanged, this);
	            }
	            this._model = value;
	            this._results.length = 0;
	            this.update();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CommandPalette.prototype, "contentNode", {
	        /**
	         * Get the command palette content node.
	         *
	         * #### Notes
	         * This is the node which holds the command palette item nodes.
	         *
	         * Modifying this node directly can lead to undefined behavior.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.node.getElementsByClassName(CONTENT_CLASS)[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CommandPalette.prototype, "inputNode", {
	        /**
	         * Get the command palette input node.
	         *
	         * #### Notes
	         * This node can be used to trigger manual updates of the command
	         * palette. Simply set the input node `value` to the desired text
	         * and call `palette.update()`.
	         *
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.node.getElementsByTagName('input')[0];
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Activate the first matching target item in the palette.
	     *
	     * @param target - The activation target. The default is `Any`.
	     *
	     * #### Notes
	     * This automatically scrolls the item into view.
	     *
	     * If no matching item is found, no item is activated.
	     */
	    CommandPalette.prototype.activateFirst = function (target) {
	        if (target === void 0) { target = ActivationTarget.Any; }
	        var i;
	        if (target === ActivationTarget.Header) {
	            var type = abstractmodel_1.SearchResultType.Header;
	            i = arrays.findIndex(this._results, function (r) { return r.type === type; });
	        }
	        else if (target === ActivationTarget.Command) {
	            var type = abstractmodel_1.SearchResultType.Command;
	            i = arrays.findIndex(this._results, function (r) { return r.type === type; });
	        }
	        else {
	            i = 0;
	        }
	        this._activate(i);
	    };
	    /**
	     * Activate the last matching target item in the palette.
	     *
	     * @param target - The activation target. The default is `Any`.
	     *
	     * #### Notes
	     * This automatically scrolls the item into view.
	     *
	     * If no matching item is found, no item is activated.
	     */
	    CommandPalette.prototype.activateLast = function (target) {
	        if (target === void 0) { target = ActivationTarget.Any; }
	        var i;
	        if (target === ActivationTarget.Header) {
	            var type = abstractmodel_1.SearchResultType.Header;
	            i = arrays.rfindIndex(this._results, function (r) { return r.type === type; });
	        }
	        else if (target === ActivationTarget.Command) {
	            var type = abstractmodel_1.SearchResultType.Command;
	            i = arrays.rfindIndex(this._results, function (r) { return r.type === type; });
	        }
	        else {
	            i = this._results.length - 1;
	        }
	        this._activate(i);
	    };
	    /**
	     * Activate the next matching target item in the palette.
	     *
	     * @param target - The activation target. The default is `Any`.
	     *
	     * #### Notes
	     * This automatically scrolls the item into view.
	     *
	     * The search will wrap around at the end of the palette.
	     *
	     * If no matching item is found, no item is activated.
	     */
	    CommandPalette.prototype.activateNext = function (target) {
	        if (target === void 0) { target = ActivationTarget.Any; }
	        var i;
	        var k = this._activeIndex + 1;
	        var j = k >= this._results.length ? 0 : k;
	        if (target === ActivationTarget.Header) {
	            var type = abstractmodel_1.SearchResultType.Header;
	            i = arrays.findIndex(this._results, function (r) { return r.type === type; }, j, true);
	        }
	        else if (target === ActivationTarget.Command) {
	            var type = abstractmodel_1.SearchResultType.Command;
	            i = arrays.findIndex(this._results, function (r) { return r.type === type; }, j, true);
	        }
	        else {
	            i = j;
	        }
	        this._activate(i);
	    };
	    /**
	     * Activate the previous matching target item in the palette.
	     *
	     * @param target - The activation target. The default is `Any`.
	     *
	     * #### Notes
	     * This automatically scrolls the item into view.
	     *
	     * The search will wrap around at the end of the palette.
	     *
	     * If no matching item is found, no item is activated.
	     */
	    CommandPalette.prototype.activatePrevious = function (target) {
	        if (target === void 0) { target = ActivationTarget.Any; }
	        var i;
	        var k = this._activeIndex;
	        var j = k <= 0 ? this._results.length - 1 : k - 1;
	        if (target === ActivationTarget.Header) {
	            var type = abstractmodel_1.SearchResultType.Header;
	            i = arrays.rfindIndex(this._results, function (r) { return r.type === type; }, j, true);
	        }
	        else if (target === ActivationTarget.Command) {
	            var type = abstractmodel_1.SearchResultType.Command;
	            i = arrays.rfindIndex(this._results, function (r) { return r.type === type; }, j, true);
	        }
	        else {
	            i = j;
	        }
	        this._activate(i);
	    };
	    /**
	     * Trigger the currently active item in the palette.
	     *
	     * #### Notes
	     * If the active item is a header, the search results are refined
	     * using the category of the header. If the current category is
	     * the same as the header category, the category will be removed.
	     *
	     * If the active item is a command, the command handler will be
	     * invoked and the current query text will be selected.
	     *
	     * If there is no active item, this is a no-op.
	     */
	    CommandPalette.prototype.triggerActive = function () {
	        var result = this._results[this._activeIndex];
	        if (!result) {
	            return;
	        }
	        if (result.type === abstractmodel_1.SearchResultType.Header) {
	            var input = this.inputNode;
	            var _a = CommandPalette.splitQuery(input.value), category = _a.category, text = _a.text;
	            var desired = result.value.category.trim();
	            var computed = desired === category ? '' : desired;
	            var query = CommandPalette.joinQuery(computed, text);
	            input.value = query;
	            input.focus();
	            this.update();
	        }
	        else if (result.type === abstractmodel_1.SearchResultType.Command) {
	            var _b = result.value, handler = _b.handler, args = _b.args;
	            this.inputNode.select();
	            handler(args);
	        }
	    };
	    /**
	     * Handle the DOM events for the command palette.
	     *
	     * @param event - The DOM event sent to the command palette.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the command palette's DOM node.
	     * It should not be called directly by user code.
	     */
	    CommandPalette.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'click':
	                this._evtClick(event);
	                break;
	            case 'keydown':
	                this._evtKeyDown(event);
	                break;
	            case 'input':
	                this.update();
	                break;
	        }
	    };
	    /**
	     * A message handler invoked on a `'after-attach'` message.
	     */
	    CommandPalette.prototype.onAfterAttach = function (msg) {
	        this.node.addEventListener('click', this);
	        this.node.addEventListener('keydown', this);
	        this.node.addEventListener('input', this);
	    };
	    /**
	     * A message handler invoked on a `'before-detach'` message.
	     */
	    CommandPalette.prototype.onBeforeDetach = function (msg) {
	        this.node.removeEventListener('click', this);
	        this.node.removeEventListener('keydown', this);
	        this.node.removeEventListener('input', this);
	    };
	    /**
	     * A message handler invoked on an `'update-request'` message.
	     */
	    CommandPalette.prototype.onUpdateRequest = function (msg) {
	        // Clear the current content.
	        var content = this.contentNode;
	        content.textContent = '';
	        // Reset the active index.
	        this._activeIndex = -1;
	        // Bail early if there is no model.
	        if (!this._model) {
	            return;
	        }
	        // Split the query text into its category and text parts.
	        var _a = CommandPalette.splitQuery(this.inputNode.value), category = _a.category, text = _a.text;
	        // Search for query matches and store the results for later use.
	        var results = this._results = this._model.search(category, text);
	        // If the results are empty, there is nothing left to do.
	        if (results.length === 0) {
	            return;
	        }
	        // Grab the derived class type for access to the render methods.
	        var ctor = this.constructor;
	        // Setup the header node render function.
	        var headerPoolIndex = 0;
	        var headerPool = this._headerPool;
	        var renderHeader = function (data) {
	            var node = headerPool[headerPoolIndex++];
	            if (!node) {
	                node = ctor.createHeaderNode();
	                headerPool.push(node);
	            }
	            ctor.updateHeaderNode(node, data);
	            return node;
	        };
	        // Setup the command node render function.
	        var commandPoolIndex = 0;
	        var commandPool = this._commandPool;
	        var renderCommand = function (data) {
	            var node = commandPool[commandPoolIndex++];
	            if (!node) {
	                node = ctor.createCommandNode();
	                commandPool.push(node);
	            }
	            ctor.updateCommandNode(node, data);
	            return node;
	        };
	        // Loop over the search results and render the nodes.
	        var fragment = document.createDocumentFragment();
	        for (var _i = 0; _i < results.length; _i++) {
	            var _b = results[_i], type = _b.type, value = _b.value;
	            if (type === abstractmodel_1.SearchResultType.Header) {
	                fragment.appendChild(renderHeader(value));
	            }
	            else if (type === abstractmodel_1.SearchResultType.Command) {
	                fragment.appendChild(renderCommand(value));
	            }
	            else {
	                throw new Error('invalid search result type');
	            }
	        }
	        // Update the content node with the rendered search results.
	        content.appendChild(fragment);
	        // If there is query text, highlight the first command item.
	        // Otherwise, reset the content scroll position to the top.
	        if (category || text) {
	            this.activateFirst(ActivationTarget.Command);
	        }
	        else {
	            requestAnimationFrame(function () { content.scrollTop = 0; });
	        }
	    };
	    /**
	     * Activate the node at the given index.
	     *
	     * If the node is scrolled out of view, it will be scrolled into
	     * view and aligned according to the `alignTop` parameter.
	     */
	    CommandPalette.prototype._activate = function (index) {
	        var content = this.contentNode;
	        var children = content.children;
	        if (index < 0 || index >= children.length) {
	            index = -1;
	        }
	        if (this._activeIndex === index) {
	            return;
	        }
	        var oldNode = children[this._activeIndex];
	        var newNode = children[index];
	        this._activeIndex = index;
	        if (oldNode)
	            oldNode.classList.remove(ACTIVE_CLASS);
	        if (newNode)
	            newNode.classList.add(ACTIVE_CLASS);
	        if (newNode)
	            requestAnimationFrame(function () {
	                Private.scrollIfNeeded(content, newNode);
	            });
	    };
	    /**
	     * Handle the `'click'` event for the command palette.
	     */
	    CommandPalette.prototype._evtClick = function (event) {
	        if (event.button !== 0) {
	            return;
	        }
	        event.preventDefault();
	        event.stopPropagation();
	        var root = this.node;
	        var content = this.contentNode;
	        var target = event.target;
	        while (true) {
	            if (target === root)
	                return;
	            var parent_1 = target.parentNode;
	            if (parent_1 === content)
	                break;
	            target = parent_1;
	        }
	        var index = Array.prototype.indexOf.call(content.children, target);
	        this._activate(index);
	        this.triggerActive();
	    };
	    /**
	     * Handle the `'keydown'` event for the command palette.
	     */
	    CommandPalette.prototype._evtKeyDown = function (event) {
	        if (event.altKey || event.ctrlKey || event.metaKey || event.shiftKey) {
	            return;
	        }
	        switch (event.keyCode) {
	            case 13:
	                event.preventDefault();
	                event.stopPropagation();
	                this.triggerActive();
	                break;
	            case 38:
	                event.preventDefault();
	                event.stopPropagation();
	                this.activatePrevious();
	                break;
	            case 40:
	                event.preventDefault();
	                event.stopPropagation();
	                this.activateNext();
	                break;
	        }
	    };
	    /**
	     * Handle the `changed` signal for the palette model.
	     */
	    CommandPalette.prototype._onModelChanged = function () {
	        this.update();
	    };
	    return CommandPalette;
	})(phosphor_widget_1.Widget);
	exports.CommandPalette = CommandPalette;
	/**
	 * The namespace for the `CommandPalette` class statics.
	 */
	var CommandPalette;
	(function (CommandPalette) {
	    /**
	     * Split a query string into its category and text components.
	     *
	     * @param query - A query string of the form `(:<category>:)?<text>`.
	     *
	     * @returns The `category` and `text` components of the query with
	     *   leading and trailing whitespace removed.
	     */
	    function splitQuery(query) {
	        query = query.trim();
	        if (query[0] !== ':') {
	            return { category: '', text: query };
	        }
	        var i = query.indexOf(':', 1);
	        if (i === -1) {
	            return { category: query.slice(1).trim(), text: '' };
	        }
	        var category = query.slice(1, i).trim();
	        var text = query.slice(i + 1).trim();
	        return { category: category, text: text };
	    }
	    CommandPalette.splitQuery = splitQuery;
	    /**
	     * Join category and text components into a query string.
	     *
	     * @param category - The category for the query or an empty string.
	     *
	     * @param text - The text for the query or an empty string.
	     *
	     * @returns The joined query string for the components.
	     */
	    function joinQuery(category, text) {
	        var query;
	        if (category && text) {
	            query = ":" + category.trim() + ": " + text.trim();
	        }
	        else if (category) {
	            query = ":" + category.trim() + ": ";
	        }
	        else if (text) {
	            query = text.trim();
	        }
	        else {
	            query = '';
	        }
	        return query;
	    }
	    CommandPalette.joinQuery = joinQuery;
	})(CommandPalette = exports.CommandPalette || (exports.CommandPalette = {}));
	/**
	 * The namespace for the `CommandPalette` private data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Scroll an element into view if needed.
	     *
	     * @param area - The scroll area element.
	     *
	     * @param elem - The element of interest.
	     */
	    function scrollIfNeeded(area, elem) {
	        var ar = area.getBoundingClientRect();
	        var er = elem.getBoundingClientRect();
	        if (er.top < ar.top) {
	            area.scrollTop -= ar.top - er.top;
	        }
	        else if (er.bottom > ar.bottom) {
	            area.scrollTop += er.bottom - ar.bottom;
	        }
	    }
	    Private.scrollIfNeeded = scrollIfNeeded;
	})(Private || (Private = {}));


/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var arrays = __webpack_require__(3);
	var abstractmodel_1 = __webpack_require__(55);
	var stringsearch_1 = __webpack_require__(58);
	/**
	 * An object for use with a standard palette model.
	 *
	 * #### Notes
	 * Instances of this class will not typically be created directly by
	 * the user. A palette model will create and return instances of the
	 * class from its adder methods.
	 */
	var StandardPaletteItem = (function () {
	    /**
	     * Construct a new standard palette item.
	     *
	     * @param options - The options for initializing the item.
	     */
	    function StandardPaletteItem(options) {
	        this._text = options.text;
	        this._args = options.args;
	        this._handler = options.handler;
	        this._icon = options.icon || '';
	        this._caption = options.caption || '';
	        this._shortcut = options.shortcut || '';
	        this._className = options.className || '';
	        this._category = Private.normalizeCategory(options.category || '');
	    }
	    Object.defineProperty(StandardPaletteItem.prototype, "text", {
	        /**
	         * Get the primary text for the item.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._text;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(StandardPaletteItem.prototype, "icon", {
	        /**
	         * Get the icon class name(s) for the item.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._icon;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(StandardPaletteItem.prototype, "caption", {
	        /**
	         * Get the descriptive caption for the item.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._caption;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(StandardPaletteItem.prototype, "shortcut", {
	        /**
	         * Get the keyboard shortcut for the item.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._shortcut;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(StandardPaletteItem.prototype, "category", {
	        /**
	         * Get the category name for the item.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._category;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(StandardPaletteItem.prototype, "className", {
	        /**
	         * Get the extra class name(s) for the item.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._className;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(StandardPaletteItem.prototype, "handler", {
	        /**
	         * Get the handler function for the item.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._handler;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(StandardPaletteItem.prototype, "args", {
	        /**
	         * Get the arguments for the handler.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._args;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return StandardPaletteItem;
	})();
	exports.StandardPaletteItem = StandardPaletteItem;
	/**
	 * A concrete palette model which holds a collection of palette items.
	 *
	 * #### Notes
	 * This class is a reasonable option for populating command palettes
	 * when the number of items is reasonable, and when the items can be
	 * created ahead of time. If lazy searching of a large data set is
	 * required, then a custom palette model should be used instead.
	 */
	var StandardPaletteModel = (function (_super) {
	    __extends(StandardPaletteModel, _super);
	    function StandardPaletteModel() {
	        _super.apply(this, arguments);
	        this._items = [];
	    }
	    /**
	     * Get the items contained in the palette model.
	     *
	     * @returns A new array of the current items in the model.
	     */
	    StandardPaletteModel.prototype.items = function () {
	        return this._items.slice();
	    };
	    /**
	     * Add a new palette item to the model.
	     *
	     * @param options - The options for initializing the item.
	     *
	     * @returns The palette item which was added to the model.
	     */
	    StandardPaletteModel.prototype.addItem = function (options) {
	        var item = new StandardPaletteItem(options);
	        this._items.push(item);
	        this.changed.emit(void 0);
	        return item;
	    };
	    /**
	     * Add several new palette items to the model.
	     *
	     * @param options - The options for initializing the items.
	     *
	     * @returns The new palette items where were added to the model.
	     */
	    StandardPaletteModel.prototype.addItems = function (options) {
	        var items = options.map(function (opts) { return new StandardPaletteItem(opts); });
	        Array.prototype.push.apply(this._items, items);
	        this.changed.emit(void 0);
	        return items;
	    };
	    /**
	     * Remove a palette item from the model.
	     *
	     * @param item - The item to remove from the model.
	     *
	     * #### Notes
	     * If the item is not contained in the model, this is a no-op.
	     */
	    StandardPaletteModel.prototype.removeItem = function (item) {
	        var i = arrays.remove(this._items, item);
	        if (i !== -1)
	            this.changed.emit(void 0);
	    };
	    /**
	     * Remove several items from the model.
	     *
	     * @param items - The items to remove from the model.
	     *
	     * #### Notes
	     * Items which are no contained in the model are ignored.
	     */
	    StandardPaletteModel.prototype.removeItems = function (items) {
	        var rest = this._items.filter(function (other) { return items.indexOf(other) === -1; });
	        if (rest.length === this._items.length) {
	            return;
	        }
	        this._items = rest;
	        this.changed.emit(void 0);
	    };
	    /**
	     * Remove all items from the model.
	     */
	    StandardPaletteModel.prototype.clearItems = function () {
	        if (this._items.length === 0) {
	            return;
	        }
	        this._items.length = 0;
	        this.changed.emit(void 0);
	    };
	    /**
	     * Search the palette model for matching commands.
	     *
	     * @param category - The category match against the model items. If
	     *   this is an empty string, all item categories will be matched.
	     *
	     * @param text - The text to match against the model items. If this
	     *   is an empty string, all items will be matched.
	     *
	     * @returns An array of new search results for the query.
	     */
	    StandardPaletteModel.prototype.search = function (category, text) {
	        // Collect a mapping of the matching categories. The mapping will
	        // only contain categories which match the provided query text.
	        // If the category is an empty string, all categories will be
	        // matched with a score of `0` and a `null` indices array.
	        var catmap = Private.matchCategory(this._items, category);
	        // Filter the items for matching text. Only items which have a
	        // category in the given map are considered. The category score
	        // is added to the text score to create the final item score.
	        // If the text is an empty string, all items will be matched
	        // will a text score of `0` and `null` indices array.
	        var scores = Private.matchText(this._items, text, catmap);
	        // Sort the items based on their total item score. Ties are
	        // broken by locale ordering the category followed by the text.
	        scores.sort(Private.scoreCmp);
	        // Group the item scores by category. The categories are added
	        // to the map in the order they appear in the scores array.
	        var groups = Private.groupScores(scores);
	        // Return the results for the search. The headers are created in
	        // the order of key iteration of the map. On major browsers, this
	        // is insertion order. This means that headers are created in the
	        // order of first appearance in the sorted scores array.
	        return Private.createSearchResults(groups, catmap);
	    };
	    return StandardPaletteModel;
	})(abstractmodel_1.AbstractPaletteModel);
	exports.StandardPaletteModel = StandardPaletteModel;
	/**
	 * The namespace for the `StandardPaletteModel` private data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Normalize a category for a palette item.
	     *
	     * @param category - The item category to normalize.
	     *
	     * @returns The normalized category text.
	     *
	     * #### Notes
	     * This converts the category to lower case and removes any
	     * extraneous whitespace.
	     */
	    function normalizeCategory(category) {
	        return category.trim().replace(/\s+/g, ' ').toLowerCase();
	    }
	    Private.normalizeCategory = normalizeCategory;
	    /**
	     * Collect a mapping of the categories which match the given query.
	     *
	     * @param items - The palette items to search.
	     *
	     * @param query - The category portion of the palette model query.
	     *
	     * @returns A mapping of matched category to match score.
	     *
	     * #### Notes
	     * The query string will be normalized by lower casing and removing
	     * all whitespace. If the normalized query is an empty string, all
	     * categories will be matched with a `0` score and `null` indices.
	     */
	    function matchCategory(items, query) {
	        // Normalize the query text to lower case with no whitespace.
	        query = normalizeQueryText(query);
	        // Create the maps needed to track the match state.
	        var seen = Object.create(null);
	        var matched = Object.create(null);
	        // Iterate over the items and match the categories.
	        for (var _i = 0; _i < items.length; _i++) {
	            var category = items[_i].category;
	            // If a category has already been seen, no more work is needed.
	            if (category in seen) {
	                continue;
	            }
	            // Mark the category as seen so it is only processed once.
	            seen[category] = true;
	            // If the query is empty, all categories match by default.
	            if (!query) {
	                matched[category] = { score: 0, indices: null };
	                continue;
	            }
	            // Run the matcher for the query and skip if no match.
	            var match = stringsearch_1.StringSearch.sumOfSquares(category, query);
	            if (!match) {
	                continue;
	            }
	            // Store the match score in the results.
	            matched[category] = match;
	        }
	        // Return the final mapping of matched categories.
	        return matched;
	    }
	    Private.matchCategory = matchCategory;
	    /**
	     * Filter palette items for those with matching text and category.
	     *
	     * @param items - The palette items to search.
	     *
	     * @param query - The text portion of the palette model query.
	     *
	     * @param categories - A mapping of the valid item categories.
	     *
	     * @returns An array of item scores for the matching items.
	     *
	     * #### Notes
	     * The query string will be normalized by lower casing and removing
	     * all whitespace. If the normalized query is an empty string, all
	     * items will be matched with a `0` text score and `null` indices.
	     *
	     * Items which have a category which is not present in the category
	     * map will be ignored.
	     *
	     * The final item score is the sum of the item text score and the
	     * relevant category score.
	     *
	     * This function does not sort the results.
	     */
	    function matchText(items, query, categories) {
	        // Normalize the query text to lower case with no whitespace.
	        query = normalizeQueryText(query);
	        // Create the array to hold the resulting scores.
	        var scores = [];
	        // Iterate over the items and match the text with the query.
	        for (var _i = 0; _i < items.length; _i++) {
	            var item = items[_i];
	            // Lookup the category score for the item category.
	            var cs = categories[item.category];
	            // If the category was not matched, the item is skipped.
	            if (!cs) {
	                continue;
	            }
	            // If the query is empty, all items are matched by default.
	            if (!query) {
	                scores.push({ score: cs.score, indices: null, item: item });
	                continue;
	            }
	            // Run the matcher for the query and skip if no match.
	            var match = stringsearch_1.StringSearch.sumOfSquares(item.text.toLowerCase(), query);
	            if (!match) {
	                continue;
	            }
	            // Create the match score for the item.
	            var score = cs.score + match.score;
	            scores.push({ score: score, indices: match.indices, item: item });
	        }
	        // Return the final array of matched item scores.
	        return scores;
	    }
	    Private.matchText = matchText;
	    /**
	     * A sort comparison function for a palette item match score.
	     *
	     * #### Notes
	     * This orders the items first based on score (lower is better), then
	     * by locale order of the item category followed by the item text.
	     */
	    function scoreCmp(a, b) {
	        var d1 = a.score - b.score;
	        if (d1 !== 0) {
	            return d1;
	        }
	        var d2 = a.item.category.localeCompare(b.item.category);
	        if (d2 !== 0) {
	            return d2;
	        }
	        return a.item.text.localeCompare(b.item.text);
	    }
	    Private.scoreCmp = scoreCmp;
	    /**
	     * Group item scores by item category.
	     *
	     * @param scores - The items to group by category.
	     *
	     * @returns A mapping of category name to group of items.
	     *
	     * #### Notes
	     * The categories are added to the map in the order of first
	     * appearance in the `scores` array.
	     */
	    function groupScores(scores) {
	        var result = Object.create(null);
	        for (var _i = 0; _i < scores.length; _i++) {
	            var score = scores[_i];
	            var cat = score.item.category;
	            (result[cat] || (result[cat] = [])).push(score);
	        }
	        return result;
	    }
	    Private.groupScores = groupScores;
	    /**
	     * Create the search results for a collection of item scores.
	     *
	     * @param groups - The item scores, grouped by category.
	     *
	     * @param categories - A mapping of category scores.
	     *
	     * @returns A flat array of search results for the groups.
	     *
	     * #### Notes
	     * This function renders the groups in iteration order, which on all
	     * major browsers is order of insertion (a de facto standard).
	     */
	    function createSearchResults(groups, categories) {
	        var results = [];
	        for (var cat in groups) {
	            results.push(createHeaderResult(cat, categories[cat]));
	            for (var _i = 0, _a = groups[cat]; _i < _a.length; _i++) {
	                var score = _a[_i];
	                results.push(createCommandResult(score));
	            }
	        }
	        return results;
	    }
	    Private.createSearchResults = createSearchResults;
	    /**
	     * Normalize the query text for a palette item.
	     *
	     * @param text - The category or text portion of a palette query.
	     *
	     * @returns The normalized query text.
	     *
	     * #### Notes
	     * The text is normalized by converting to lower case and removing
	     * all whitespace.
	     */
	    function normalizeQueryText(text) {
	        return text.replace(/\s+/g, '').toLowerCase();
	    }
	    /**
	     * Create a header search result for the given data.
	     *
	     * @param category - The category name for the header.
	     *
	     * @param score - The score for the category match.
	     *
	     * @returns A header search result for the given data.
	     */
	    function createHeaderResult(category, score) {
	        var text = highlightText(category, score.indices);
	        return { type: abstractmodel_1.SearchResultType.Header, value: { text: text, category: category } };
	    }
	    /**
	     * Create a command search result for the given data.
	     *
	     * @param score - The score for the item match.
	     *
	     * @returns A command search result for the given data.
	     */
	    function createCommandResult(score) {
	        var text = highlightText(score.item.text, score.indices);
	        var _a = score.item, icon = _a.icon, caption = _a.caption, shortcut = _a.shortcut, className = _a.className, handler = _a.handler, args = _a.args;
	        var value = { text: text, icon: icon, caption: caption, shortcut: shortcut, className: className, handler: handler, args: args };
	        return { type: abstractmodel_1.SearchResultType.Command, value: value };
	    }
	    /**
	     * Highlight the matching character of the given text.
	     *
	     * @param text - The text to highlight.
	     *
	     * @param indices - The character indices to highlight, or `null`.
	     *
	     * @returns The text interpolated with `<mark>` tags as needed.
	     */
	    function highlightText(text, indices) {
	        return indices ? stringsearch_1.StringSearch.highlight(text, indices) : text;
	    }
	})(Private || (Private = {}));


/***/ },
/* 58 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	/**
	 * A namespace which holds string searching functionality.
	 */
	var StringSearch;
	(function (StringSearch) {
	    /**
	     * Compute the sum-of-squares match for the given search text.
	     *
	     * @param sourceText - The text which should be searched.
	     *
	     * @param queryText - The query text to locate in the source text.
	     *
	     * @returns The match result object, or `null` if there is no match.
	     *
	     * #### Notes
	     * This scoring algorithm uses a sum-of-squares approach to determine
	     * the score. In order for there to be a match, all of the characters
	     * in `queryText` **must** appear in `sourceText` in order. The index
	     * of each matching character is squared and added to the score. This
	     * means that early and consecutive character matches are preferred.
	     *
	     * The character match is performed with strict equality. It is case
	     * sensitive and does not ignore whitespace. If those behaviors are
	     * required, the text should be transformed before scoring.
	     *
	     * This has a runtime complexity of `O(n)` on `sourceText`.
	     */
	    function sumOfSquares(sourceText, queryText) {
	        var score = 0;
	        var indices = new Array(queryText.length);
	        for (var i = 0, j = 0, n = queryText.length; i < n; ++i, ++j) {
	            j = sourceText.indexOf(queryText[i], j);
	            if (j === -1)
	                return null;
	            indices[i] = j;
	            score += j * j;
	        }
	        return { score: score, indices: indices };
	    }
	    StringSearch.sumOfSquares = sumOfSquares;
	    /**
	     * Highlight the matched characters of a source string.
	     *
	     * @param source - The text which should be highlighted.
	     *
	     * @param indices - The indices of the matched characters. They must
	     *   appear in increasing order and must be in bounds of the source.
	     *
	     * @returns A string with interpolated `<mark>` tags.
	     */
	    function highlight(sourceText, indices) {
	        var k = 0;
	        var last = 0;
	        var result = '';
	        var n = indices.length;
	        while (k < n) {
	            var i = indices[k];
	            var j = indices[k];
	            while (++k < n && indices[k] === j + 1)
	                j++;
	            var head = sourceText.slice(last, i);
	            var chunk = sourceText.slice(i, j + 1);
	            result += head + "<mark>" + chunk + "</mark>";
	            last = j + 1;
	        }
	        return result + sourceText.slice(last);
	    }
	    StringSearch.highlight = highlight;
	})(StringSearch = exports.StringSearch || (exports.StringSearch = {}));


/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(60);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(12)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../css-loader/index.js!./index.css", function() {
				var newContent = require("!!./../../css-loader/index.js!./index.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\r\n| Copyright (c) 2014-2016, PhosphorJS Contributors\r\n|\r\n| Distributed under the terms of the BSD 3-Clause License.\r\n|\r\n| The full license is in the file LICENSE, distributed with this software.\r\n|----------------------------------------------------------------------------*/\r\n.p-CommandPalette {\r\n  display: flex;\r\n  flex-direction: column;\r\n}\r\n\r\n\r\n.p-CommandPalette-search {\r\n  flex: 0 0 auto;\r\n}\r\n\r\n\r\n.p-CommandPalette-content {\r\n  flex: 1 1 auto;\r\n  margin: 0;\r\n  padding: 0;\r\n  min-height: 0;\r\n  overflow: auto;\r\n  list-style-type: none;\r\n}\r\n\r\n\r\n.p-CommandPalette-header {\r\n  overflow: hidden;\r\n  white-space: nowrap;\r\n  text-overflow: ellipsis;\r\n}\r\n\r\n\r\n.p-CommandPalette-command {\r\n  display: flex;\r\n  flex-direction: row;\r\n}\r\n\r\n\r\n.p-CommandPalette-commandIcon {\r\n  flex: 0 0 auto;\r\n}\r\n\r\n\r\n.p-CommandPalette-commandContent {\r\n  flex: 1 1 auto;\r\n}\r\n\r\n\r\n.p-CommandPalette-commandShortcut {\r\n  float: right;\r\n}\r\n\r\n\r\n.p-CommandPalette-commandText {\r\n  display: block;\r\n  overflow: hidden;\r\n  white-space: nowrap;\r\n  text-overflow: ellipsis;\r\n}\r\n\r\n\r\n.p-CommandPalette-commandCaption {\r\n  display: block;\r\n}\r\n", ""]);
	
	// exports


/***/ },
/* 61 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2016, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	var phosphor_disposable_1 = __webpack_require__(8);
	var phosphor_keymap_1 = __webpack_require__(62);
	var phosphor_signaling_1 = __webpack_require__(22);
	var commandregistry_1 = __webpack_require__(52);
	/**
	 * An abstract base class which defines a shortcut registry.
	 *
	 * TODO - allow multiple shortcuts for a single command?
	 */
	var ABCShortcutRegistry = (function () {
	    function ABCShortcutRegistry() {
	    }
	    Object.defineProperty(ABCShortcutRegistry.prototype, "shortcutsAdded", {
	        /**
	         * A signal emitted when shortcuts are added to the manager.
	         */
	        get: function () {
	            return Private.shortcutsAddedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ABCShortcutRegistry.prototype, "shortcutsRemoved", {
	        /**
	         * A signal emitted when shortcuts are removed from the manager.
	         */
	        get: function () {
	            return Private.shortcutsRemovedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return ABCShortcutRegistry;
	}());
	exports.ABCShortcutRegistry = ABCShortcutRegistry;
	/**
	 * A concrete implementation of ABCShortcutRegistry.
	 *
	 * TODO - Support configurable keyboard layout.
	 */
	var ShortcutRegistry = (function (_super) {
	    __extends(ShortcutRegistry, _super);
	    /**
	     * Construct a shortcut manager.
	     *
	     * @param commands - The command registry for executing commands.
	     */
	    function ShortcutRegistry(commands) {
	        var _this = this;
	        _super.call(this);
	        /**
	         * The private key binding handler function.
	         */
	        this._executeCommand = function (id) {
	            _this._commands.execute(id);
	            return true;
	        };
	        this._keymap = new phosphor_keymap_1.KeymapManager();
	        this._commands = null;
	        this._sequences = Private.createSequenceMap();
	        this._commands = commands;
	    }
	    /**
	     * List the currently registered command ids.
	     *
	     * @returns A new array of the registered command ids.
	     */
	    ShortcutRegistry.prototype.list = function () {
	        return Object.keys(this._sequences);
	    };
	    /**
	     * Test whether the registry contains a sequence for a command.
	     *
	     * @param id - The id of the command of interest.
	     *
	     * @returns `true` if a sequence is registered, `false` otherwise.
	     */
	    ShortcutRegistry.prototype.has = function (command) {
	        return command in this._sequences;
	    };
	    /**
	     * Get the key sequence for the given command id.
	     *
	     * @param command - The id of the command of interest.
	     *
	     * @returns The key sequence for the specified command, or null.
	     */
	    ShortcutRegistry.prototype.sequenceFor = function (command) {
	        var sequence = this._sequences[command];
	        return sequence ? sequence.slice() : null;
	    };
	    /**
	     * Add key bindings to the shortcut manager.
	     *
	     * @param bindings - The key bindings to add to the manager.
	     *
	     * @returns A disposable which removes the added key bindings.
	     *
	     * #### Notes
	     * If a shortcut for a specific command is already registered,
	     * a warning will be logged and that specific shortcut will be
	     * ignored.
	     */
	    ShortcutRegistry.prototype.add = function (items) {
	        var _this = this;
	        // Setup the added ids and keybinding arrays.
	        var added = [];
	        var bindings = [];
	        // Convert the shortcut items into key bindings.
	        for (var _i = 0, items_1 = items; _i < items_1.length; _i++) {
	            var _a = items_1[_i], sequence = _a.sequence, selector = _a.selector, command = _a.command;
	            // Log a warning if the command already has a shortcut.
	            if (command in this._sequences) {
	                console.warn("shortcut already registered for '" + command + "'");
	                continue;
	            }
	            // Register a safe shallow copy of the sequence.
	            sequence = sequence.slice();
	            this._sequences[command] = sequence;
	            // Add the command to the tracking array.
	            added.push(command);
	            // Add a keybinding to the tracking array.
	            var handler = this._executeCommand;
	            bindings.push({ sequence: sequence, selector: selector, handler: handler, args: command });
	        }
	        // If no items are added, return an empty delegate.
	        if (added.length === 0) {
	            return new phosphor_disposable_1.DisposableDelegate(null);
	        }
	        // Add the keybindings to the keymap manager.
	        // TODO - if any keybinding is invalid, we'll be out-of-sync.
	        var addedResult = this._keymap.add(bindings);
	        // Notify for the added shortcuts using a safe shallow copy.
	        this.shortcutsAdded.emit(added.slice());
	        // Return a delegate which will remove the added shortcuts.
	        return new phosphor_disposable_1.DisposableDelegate(function () {
	            addedResult.dispose();
	            for (var _i = 0, added_1 = added; _i < added_1.length; _i++) {
	                var id = added_1[_i];
	                delete _this._sequences[id];
	            }
	            _this.shortcutsRemoved.emit(added.slice());
	        });
	    };
	    /**
	     * Process a `'keydown'` event dispatching a matching shortcut.
	     *
	     * @param event - The event object for the `'keydown'` event.
	     *
	     * #### Notes
	     * This will typically be called automatically by the application.
	     */
	    ShortcutRegistry.prototype.processKeydownEvent = function (event) {
	        this._keymap.processKeydownEvent(event);
	    };
	    return ShortcutRegistry;
	}(ABCShortcutRegistry));
	exports.ShortcutRegistry = ShortcutRegistry;
	/**
	 * The default shortcut registry service provider.
	 */
	exports.shortcutRegistryProvider = {
	    id: 'phosphide.services.shortcutRegistry',
	    provides: ABCShortcutRegistry,
	    requires: [commandregistry_1.ABCCommandRegistry],
	    resolve: function (commands) { return new ShortcutRegistry(commands); },
	};
	/**
	 * The namespace for the private shortcut registry functionality.
	 */
	var Private;
	(function (Private) {
	    /**
	     *
	     */
	    Private.shortcutsAddedSignal = new phosphor_signaling_1.Signal();
	    /**
	     *
	     */
	    Private.shortcutsRemovedSignal = new phosphor_signaling_1.Signal();
	    /**
	     *
	     */
	    function createSequenceMap() {
	        return Object.create(null);
	    }
	    Private.createSequenceMap = createSequenceMap;
	})(Private || (Private = {}));


/***/ },
/* 62 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(63));
	__export(__webpack_require__(64));


/***/ },
/* 63 */
/***/ function(module, exports) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	/**
	 * Create a normalized keystroke for a `'keydown'` event.
	 *
	 * @param event - The event object for a `'keydown'` event.
	 *
	 * @param layout - The keyboard layout for computing the keycap.
	 *
	 * @returns A normalized keystroke, or an empty string if the event
	 *   does not represent a valid shortcut keystroke.
	 */
	function keystrokeForKeydownEvent(event, layout) {
	    var keycap = layout.keycapForKeydownEvent(event);
	    if (!keycap) {
	        return '';
	    }
	    var mods = '';
	    if (event.metaKey && IS_MAC) {
	        mods += 'Cmd ';
	    }
	    if (event.ctrlKey) {
	        mods += 'Ctrl ';
	    }
	    if (event.altKey) {
	        mods += 'Alt ';
	    }
	    if (event.shiftKey) {
	        mods += 'Shift ';
	    }
	    return mods + keycap;
	}
	exports.keystrokeForKeydownEvent = keystrokeForKeydownEvent;
	/**
	 * Normalize and validate a keystroke.
	 *
	 * @param keystroke - The keystroke to normalize.
	 *
	 * @param layout - The keyboard layout for validating the keycap.
	 *
	 * @returns The normalized keystroke.
	 *
	 * @throws An error if the keystroke is invalid.
	 *
	 * #### Notes
	 * The keystroke must adhere to the format:
	 *
	 *   `[<modifier 1> [<modifier 2> [<modifier N]]] <primary key>`
	 *
	 * The supported modifiers are: `Accel`, `Alt`, `Cmd`, `Ctrl`, and
	 * `Shift`. The `Accel` modifier is translated to `Cmd` on Mac and
	 * `Ctrl` on all other platforms.
	 *
	 * The keystroke must conform to the following:
	 *   - Modifiers and the primary key are case senstive.
	 *   - The primary key must be a valid key for the layout.
	 *   - Whitespace is used to separate modifiers and primary key.
	 *   - Modifiers may appear in any order before the primary key.
	 *   - Modifiers cannot appear in duplicate.
	 *   - The `Cmd` modifier is only valid on Mac.
	 *
	 * If a keystroke is nonconforming, an error will be thrown.
	 */
	function normalizeKeystroke(keystroke, layout) {
	    var keycap = '';
	    var alt = false;
	    var cmd = false;
	    var ctrl = false;
	    var shift = false;
	    for (var _i = 0, _a = keystroke.trim().split(/\s+/); _i < _a.length; _i++) {
	        var token = _a[_i];
	        if (token === 'Accel') {
	            token = IS_MAC ? 'Cmd' : 'Ctrl';
	        }
	        if (token === 'Alt') {
	            if (alt) {
	                throwKeystrokeError(keystroke, '`Alt` appears in duplicate');
	            }
	            if (keycap) {
	                throwKeystrokeError(keystroke, '`Alt` follows primary key');
	            }
	            alt = true;
	        }
	        else if (token === 'Cmd') {
	            if (cmd) {
	                throwKeystrokeError(keystroke, '`Cmd` appears in duplicate');
	            }
	            if (keycap) {
	                throwKeystrokeError(keystroke, '`Cmd` follows primary key');
	            }
	            if (!IS_MAC) {
	                throwKeystrokeError(keystroke, '`Cmd` used on non-Mac platform');
	            }
	            cmd = true;
	        }
	        else if (token === 'Ctrl') {
	            if (ctrl) {
	                throwKeystrokeError(keystroke, '`Ctrl` appears in duplicate');
	            }
	            if (keycap) {
	                throwKeystrokeError(keystroke, '`Ctrl` follows primary key');
	            }
	            ctrl = true;
	        }
	        else if (token === 'Shift') {
	            if (shift) {
	                throwKeystrokeError(keystroke, '`Shift` appears in duplicate');
	            }
	            if (keycap) {
	                throwKeystrokeError(keystroke, '`Shift` follows primary key');
	            }
	            shift = true;
	        }
	        else {
	            if (keycap) {
	                throwKeystrokeError(keystroke, 'primary key appears in duplicate');
	            }
	            if (!layout.isValidKeycap(token)) {
	                throwKeystrokeError(keystroke, 'primary key invalid for layout');
	            }
	            keycap = token;
	        }
	    }
	    if (!keycap) {
	        throwKeystrokeError(keystroke, 'primary key not specified');
	    }
	    var mods = '';
	    if (cmd) {
	        mods += 'Cmd ';
	    }
	    if (ctrl) {
	        mods += 'Ctrl ';
	    }
	    if (alt) {
	        mods += 'Alt ';
	    }
	    if (shift) {
	        mods += 'Shift ';
	    }
	    return mods + keycap;
	}
	exports.normalizeKeystroke = normalizeKeystroke;
	/**
	 * A concrete implementation of [[IKeyboardLayout]] based on keycodes.
	 *
	 * The `.keyCode` property of a `'keydown'` event is a browser and OS
	 * specific representation of the physical key (not character) which
	 * was pressed on a keyboard. While not the most convenient API, it
	 * is currently the only one which works reliably on all browsers.
	 *
	 * This class accepts a user-defined mapping of keycodes to keycaps
	 * (the letter(s) printed on a physical keyboard key) which allows
	 * for reliable keyboard shortcuts tailored to the user's system.
	 */
	var KeycodeLayout = (function () {
	    /**
	     * Construct a new keycode layout.
	     *
	     * @param name - The human readable name for the layout.
	     *
	     * @param codes - A mapping of keycode to keycap value.
	     */
	    function KeycodeLayout(name, codes) {
	        this._name = name;
	        this._codes = codes;
	        this._keys = extractKeys(codes);
	    }
	    Object.defineProperty(KeycodeLayout.prototype, "name", {
	        /**
	         * The human readable read-only name of the layout.
	         */
	        get: function () {
	            return this._name;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get an array of all keycap values supported by the layout.
	     *
	     * @returns A new array of the supported keycap values.
	     */
	    KeycodeLayout.prototype.keycaps = function () {
	        return Object.keys(this._keys);
	    };
	    /**
	     * Test whether the given keycap is a valid value for the layout.
	     *
	     * @param keycap - The user provided keycap to test for validity.
	     *
	     * @returns `true` if the keycap is valid, `false` otherwise.
	     */
	    KeycodeLayout.prototype.isValidKeycap = function (keycap) {
	        return keycap in this._keys;
	    };
	    /**
	     * Get the keycap for a `'keydown'` event.
	     *
	     * @param event - The event object for a `'keydown'` event.
	     *
	     * @returns The associated keycap value, or an empty string if
	     *   the event does not represent a valid primary shortcut key.
	     */
	    KeycodeLayout.prototype.keycapForKeydownEvent = function (event) {
	        return this._codes[event.keyCode] || '';
	    };
	    return KeycodeLayout;
	})();
	exports.KeycodeLayout = KeycodeLayout;
	/**
	 * A keycode-based keyboard layout for US English keyboards.
	 *
	 * This layout is valid for the following OS/Browser combinations.
	 *
	 * - Windows
	 *   - Chrome
	 *   - Firefox
	 *   - IE
	 *
	 * - OSX
	 *   - Chrome
	 *   - Firefox
	 *   - Safari
	 *
	 * - Linux
	 *   - Chrome
	 *   - Firefox
	 *
	 * Other combinations may also work, but are untested.
	 */
	exports.EN_US = new KeycodeLayout('en-us', {
	    8: 'Backspace',
	    9: 'Tab',
	    13: 'Enter',
	    19: 'Pause',
	    27: 'Escape',
	    32: 'Space',
	    33: 'PageUp',
	    34: 'PageDown',
	    35: 'End',
	    36: 'Home',
	    37: 'ArrowLeft',
	    38: 'ArrowUp',
	    39: 'ArrowRight',
	    40: 'ArrowDown',
	    45: 'Insert',
	    46: 'Delete',
	    48: '0',
	    49: '1',
	    50: '2',
	    51: '3',
	    52: '4',
	    53: '5',
	    54: '6',
	    55: '7',
	    56: '8',
	    57: '9',
	    59: ';',
	    61: '=',
	    65: 'A',
	    66: 'B',
	    67: 'C',
	    68: 'D',
	    69: 'E',
	    70: 'F',
	    71: 'G',
	    72: 'H',
	    73: 'I',
	    74: 'J',
	    75: 'K',
	    76: 'L',
	    77: 'M',
	    78: 'N',
	    79: 'O',
	    80: 'P',
	    81: 'Q',
	    82: 'R',
	    83: 'S',
	    84: 'T',
	    85: 'U',
	    86: 'V',
	    87: 'W',
	    88: 'X',
	    89: 'Y',
	    90: 'Z',
	    93: 'ContextMenu',
	    96: '0',
	    97: '1',
	    98: '2',
	    99: '3',
	    100: '4',
	    101: '5',
	    102: '6',
	    103: '7',
	    104: '8',
	    105: '9',
	    106: '*',
	    107: '+',
	    109: '-',
	    110: '.',
	    111: '/',
	    112: 'F1',
	    113: 'F2',
	    114: 'F3',
	    115: 'F4',
	    116: 'F5',
	    117: 'F6',
	    118: 'F7',
	    119: 'F8',
	    120: 'F9',
	    121: 'F10',
	    122: 'F11',
	    123: 'F12',
	    173: '-',
	    186: ';',
	    187: '=',
	    188: ',',
	    189: '-',
	    190: '.',
	    191: '/',
	    192: '`',
	    219: '[',
	    220: '\\',
	    221: ']',
	    222: '\'',
	});
	/**
	 * A flag indicating whether the platform is Mac.
	 */
	var IS_MAC = !!navigator.platform.match(/Mac/i);
	/**
	 * Throw an error with the give invalid keystroke.
	 */
	function throwKeystrokeError(keystroke, message) {
	    throw new Error("invalid keystroke: " + keystroke + " (" + message + ")");
	}
	/**
	 * Extract the key set from a code map.
	 */
	function extractKeys(codes) {
	    var keys = Object.create(null);
	    for (var c in codes) {
	        keys[codes[c]] = true;
	    }
	    return keys;
	}


/***/ },
/* 64 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var clear_cut_1 = __webpack_require__(65);
	var phosphor_disposable_1 = __webpack_require__(8);
	var keyboard_1 = __webpack_require__(63);
	/**
	 * A class which manages a collection of key bindings.
	 */
	var KeymapManager = (function () {
	    /**
	     * Construct a new key map manager.
	     *
	     * @param layout - The keyboard layout to use with the manager.
	     *   The default layout is US English.
	     */
	    function KeymapManager(layout) {
	        if (layout === void 0) { layout = keyboard_1.EN_US; }
	        this._timer = 0;
	        this._replaying = false;
	        this._sequence = [];
	        this._exact = null;
	        this._bindings = [];
	        this._events = [];
	        this._layout = layout;
	    }
	    Object.defineProperty(KeymapManager.prototype, "layout", {
	        /**
	         * Get the keyboard layout used by the manager.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._layout;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Add key bindings to the key map manager.
	     *
	     * @param bindings - The key bindings to add to the manager.
	     *
	     * @returns A disposable which removes the added key bindings.
	     *
	     * #### Notes
	     * If a key binding is invalid, a warning will be logged to the
	     * console and the offending key binding will be ignored.
	     *
	     * If multiple key bindings are registered for the same sequence,
	     * the binding with the highest CSS specificity is executed first.
	     *
	     * Ambiguous key bindings are resolved with a timeout.
	     */
	    KeymapManager.prototype.add = function (bindings) {
	        var _this = this;
	        var exbArray = [];
	        for (var _i = 0; _i < bindings.length; _i++) {
	            var kb = bindings[_i];
	            var exb = createExBinding(kb, this._layout);
	            if (exb !== null)
	                exbArray.push(exb);
	        }
	        Array.prototype.push.apply(this._bindings, exbArray);
	        return new phosphor_disposable_1.DisposableDelegate(function () { return _this._removeBindings(exbArray); });
	    };
	    /**
	     * Process a `'keydown'` event and invoke a matching key binding.
	     *
	     * @param event - The event object for a `'keydown'` event.
	     *
	     * #### Notes
	     * This should be called in response to a `'keydown'` event in order
	     * to invoke the handler function of the best matching key binding.
	     *
	     * The manager **does not** install its own key event listeners. This
	     * allows user code full control over the nodes for which the manager
	     * processes `'keydown'` events.
	     */
	    KeymapManager.prototype.processKeydownEvent = function (event) {
	        // Bail immediately if playing back keystrokes.
	        if (this._replaying) {
	            return;
	        }
	        // Get the canonical keystroke for the event. An empty string
	        // indicates a keystroke which cannot be a valid key shortcut.
	        var keystroke = keyboard_1.keystrokeForKeydownEvent(event, this._layout);
	        if (!keystroke) {
	            return;
	        }
	        // Add the keystroke to the current key sequence.
	        this._sequence.push(keystroke);
	        // Find the exact and partial matches for the key sequence.
	        var _a = findMatch(this._bindings, this._sequence, event), exact = _a.exact, partial = _a.partial;
	        // If there is no exact or partial match, replay any suppressed
	        // events and clear the pending state so that the next key press
	        // starts from a fresh default state.
	        if (!exact && !partial) {
	            this._replayEvents();
	            this._clearPendingState();
	            return;
	        }
	        // Stop propagation of the event. If there is only a partial match,
	        // the event will be replayed if a final match is never triggered.
	        event.preventDefault();
	        event.stopPropagation();
	        // If there is an exact match but no partial, the exact match can
	        // be dispatched immediately. The pending state is cleared so the
	        // next key press starts from a fresh default state.
	        if (!partial) {
	            safeInvoke(exact);
	            this._clearPendingState();
	            return;
	        }
	        // If there is both an exact match and a partial, the exact match
	        // is stored for future dispatch in case the timer expires before
	        // a more specific match is triggered.
	        if (exact)
	            this._exact = exact;
	        // Store the event for possible playback in the future.
	        this._events.push(event);
	        // (Re)start the timer to dispatch the most recent exact match
	        // in case the partial match fails to result in an exact match.
	        this._startTimer();
	    };
	    /**
	     * Remove an array of extended bindings from the key map.
	     */
	    KeymapManager.prototype._removeBindings = function (exbArray) {
	        var count = 0;
	        for (var i = 0, n = this._bindings.length; i < n; ++i) {
	            var exb = this._bindings[i];
	            if (exbArray.indexOf(exb) !== -1) {
	                count++;
	            }
	            else {
	                this._bindings[i - count] = exb;
	            }
	        }
	        this._bindings.length -= count;
	    };
	    /**
	     * Start or restart the pending timer for the key map.
	     */
	    KeymapManager.prototype._startTimer = function () {
	        var _this = this;
	        this._clearTimer();
	        this._timer = setTimeout(function () {
	            _this._onPendingTimeout();
	        }, 1000);
	    };
	    /**
	     * Clear the pending timer for the key map.
	     */
	    KeymapManager.prototype._clearTimer = function () {
	        if (this._timer !== 0) {
	            clearTimeout(this._timer);
	            this._timer = 0;
	        }
	    };
	    /**
	     * Replay the events which were suppressed.
	     */
	    KeymapManager.prototype._replayEvents = function () {
	        if (this._events.length === 0) {
	            return;
	        }
	        this._replaying = true;
	        for (var _i = 0, _a = this._events; _i < _a.length; _i++) {
	            var evt = _a[_i];
	            var clone = cloneKeyboardEvent(evt);
	            evt.target.dispatchEvent(clone);
	        }
	        this._replaying = false;
	    };
	    /**
	     * Clear the pending state for the keymap.
	     */
	    KeymapManager.prototype._clearPendingState = function () {
	        this._clearTimer();
	        this._exact = null;
	        this._events.length = 0;
	        this._sequence.length = 0;
	    };
	    /**
	     * Handle the partial match timeout.
	     */
	    KeymapManager.prototype._onPendingTimeout = function () {
	        this._timer = 0;
	        if (this._exact) {
	            safeInvoke(this._exact);
	        }
	        else {
	            this._replayEvents();
	        }
	        this._clearPendingState();
	    };
	    return KeymapManager;
	})();
	exports.KeymapManager = KeymapManager;
	/**
	 * Create an extended key binding from a user key binding.
	 *
	 * Warns and returns `null` if the key binding is invalid.
	 */
	function createExBinding(binding, layout) {
	    if (!clear_cut_1.isSelectorValid(binding.selector)) {
	        console.warn("invalid key binding selector: " + binding.selector);
	        return null;
	    }
	    if (binding.sequence.length === 0) {
	        console.warn('empty key sequence for key binding');
	        return null;
	    }
	    try {
	        var sequence = binding.sequence.map(function (ks) { return keyboard_1.normalizeKeystroke(ks, layout); });
	    }
	    catch (e) {
	        console.warn(e.message);
	        return null;
	    }
	    return {
	        sequence: sequence,
	        args: binding.args,
	        handler: binding.handler,
	        selector: binding.selector,
	        specificity: clear_cut_1.calculateSpecificity(binding.selector),
	    };
	}
	;
	/**
	 * Test whether a binding sequence matches a key sequence.
	 *
	 * Returns a `SequenceMatch` value indicating the type of match.
	 */
	function matchSequence(exbSeq, keySeq) {
	    if (exbSeq.length < keySeq.length) {
	        return 0 /* None */;
	    }
	    for (var i = 0, n = keySeq.length; i < n; ++i) {
	        if (exbSeq[i] !== keySeq[i]) {
	            return 0 /* None */;
	        }
	    }
	    if (exbSeq.length > keySeq.length) {
	        return 2 /* Partial */;
	    }
	    return 1 /* Exact */;
	}
	/**
	 * Find the distance from the target node to the first matching node.
	 *
	 * This traverses the event path from `target` to `currentTarget` and
	 * computes the distance from `target` to the first node which matches
	 * the CSS selector. If no match is found, `-1` is returned.
	 */
	function targetDistance(selector, event) {
	    var distance = 0;
	    var target = event.target;
	    var current = event.currentTarget;
	    for (; target !== null; target = target.parentElement, ++distance) {
	        if (matchesSelector(target, selector)) {
	            return distance;
	        }
	        if (target === current) {
	            return -1;
	        }
	    }
	    return -1;
	}
	/**
	 * Find the bindings which match a key sequence.
	 *
	 * This returns a match result which contains the best exact matching
	 * binding, and a flag which indicates if there are partial matches.
	 */
	function findMatch(bindings, sequence, event) {
	    // Whether a partial match has been found.
	    var partial = false;
	    // The current best exact match.
	    var exact = null;
	    // The match distance for the exact match.
	    var distance = Infinity;
	    // Iterate the bindings and search for the best match.
	    for (var i = 0, n = bindings.length; i < n; ++i) {
	        // Lookup the current binding.
	        var exb = bindings[i];
	        // Check whether the binding sequence is a match.
	        var match = matchSequence(exb.sequence, sequence);
	        // If there is no match, the binding is ignored.
	        if (match === 0 /* None */) {
	            continue;
	        }
	        // If it is a partial match and no other partial match has been
	        // found, ensure the selector matches and mark the partial flag.
	        if (match === 2 /* Partial */) {
	            if (!partial && targetDistance(exb.selector, event) !== -1) {
	                partial = true;
	            }
	            continue;
	        }
	        // Otherwise, it's an exact match. Update the best match if the
	        // binding is a stronger match than the current best exact match.
	        var td = targetDistance(exb.selector, event);
	        if (td !== -1 && td <= distance) {
	            if (exact === null || exb.specificity > exact.specificity) {
	                exact = exb;
	                distance = td;
	            }
	        }
	    }
	    // Return the match result.
	    return { exact: exact, partial: partial };
	}
	/**
	 * Safely invoke the handler for the key binding.
	 *
	 * Exceptions in the handler will be caught and logged.
	 */
	function safeInvoke(binding) {
	    try {
	        binding.handler.call(void 0, binding.args);
	    }
	    catch (err) {
	        console.error(err);
	    }
	}
	/**
	 * A cross-browser CSS selector matching prototype function.
	 *
	 * This function must be called with an element as `this` context.
	 */
	var protoMatchFunc = (function () {
	    var proto = Element.prototype;
	    return (proto.matches ||
	        proto.matchesSelector ||
	        proto.mozMatchesSelector ||
	        proto.msMatchesSelector ||
	        proto.oMatchesSelector ||
	        proto.webkitMatchesSelector ||
	        (function (selector) {
	            var elem = this;
	            var matches = elem.ownerDocument.querySelectorAll(selector);
	            return Array.prototype.indexOf.call(matches, elem) !== -1;
	        }));
	})();
	/**
	 * Test whether an element matches a CSS selector.
	 */
	function matchesSelector(elem, selector) {
	    return protoMatchFunc.call(elem, selector);
	}
	/**
	 * Clone a keyboard event.
	 *
	 * #### Notes
	 * A custom event is required because Chrome nulls out the `keyCode`
	 * field in user-generated `KeyboardEvent` types.
	 */
	function cloneKeyboardEvent(event) {
	    var clone = document.createEvent('Event');
	    var bubbles = event.bubbles || true;
	    var cancelable = event.cancelable || true;
	    clone.initEvent(event.type || 'keydown', bubbles, cancelable);
	    clone.key = event.key || '';
	    clone.keyCode = event.keyCode || 0;
	    clone.which = event.keyCode || 0;
	    clone.ctrlKey = event.ctrlKey || false;
	    clone.altKey = event.altKey || false;
	    clone.shiftKey = event.shiftKey || false;
	    clone.metaKey = event.metaKey || false;
	    clone.view = event.view || window;
	    return clone;
	}


/***/ },
/* 65 */
/***/ function(module, exports) {

	/* WEBPACK VAR INJECTION */(function(global) {/**
	 * Originally ported from https://github.com/keeganstreet/specificity/blob/866bf7ab4e7f62a7179c15b13a95af4e1c7b1afa/specificity.js
	 *
	 * Calculates the specificity of CSS selectors
	 * http://www.w3.org/TR/css3-selectors/#specificity
	 *
	 * Returns a selector integer value
	 */
	
	// The following regular expressions assume that selectors matching the preceding regular expressions have been removed
	var attributeRegex = /(\[[^\]]+\])/g;
	var idRegex = /(#[^\s\+>~\.\[:]+)/g;
	var classRegex = /(\.[^\s\+>~\.\[:]+)/g;
	var pseudoElementRegex = /(::[^\s\+>~\.\[:]+|:first-line|:first-letter|:before|:after)/g;
	var pseudoClassRegex = /(:[^\s\+>~\.\[:]+)/g;
	var elementRegex = /([^\s\+>~\.\[:]+)/g;
	var notRegex = /:not\(([^\)]*)\)/g;
	var ruleRegex = /\{[^]*/gm;
	var separatorRegex = /[\*\s\+>~]/g;
	var straysRegex = /[#\.]/g;
	
	// Find matches for a regular expression in a string and push their details to parts
	// Type is "a" for IDs, "b" for classes, attributes and pseudo-classes and "c" for elements and pseudo-elements
	var findMatch = function(regex, type, types, selector) {
	  var matches = selector.match(regex);
	  if (matches) {
	    for (var i = 0; i < matches.length; i++) {
	      types[type]++;
	      // Replace this simple selector with whitespace so it won't be counted in further simple selectors
	      selector = selector.replace(matches[i], ' ');
	    }
	  }
	
	  return selector;
	}
	
	// Calculate the specificity for a selector by dividing it into simple selectors and counting them
	var calculate = function(selector) {
	  var commaIndex = selector.indexOf(',');
	  if (commaIndex !== -1) {
	    selector = selector.substring(0, commaIndex);
	  }
	
	  var  types = {
	    a: 0,
	    b: 0,
	    c: 0
	  };
	
	  // Remove the negation psuedo-class (:not) but leave its argument because specificity is calculated on its argument
	  selector = selector.replace(notRegex, ' $1 ');
	
	  // Remove anything after a left brace in case a user has pasted in a rule, not just a selector
	  selector = selector.replace(ruleRegex, ' ');
	
	  // Add attribute selectors to parts collection (type b)
	  selector = findMatch(attributeRegex, 'b', types, selector);
	
	  // Add ID selectors to parts collection (type a)
	  selector = findMatch(idRegex, 'a', types, selector);
	
	  // Add class selectors to parts collection (type b)
	  selector = findMatch(classRegex, 'b', types, selector);
	
	  // Add pseudo-element selectors to parts collection (type c)
	  selector = findMatch(pseudoElementRegex, 'c', types, selector);
	
	  // Add pseudo-class selectors to parts collection (type b)
	  selector = findMatch(pseudoClassRegex, 'b', types, selector);
	
	  // Remove universal selector and separator characters
	  selector = selector.replace(separatorRegex, ' ');
	
	  // Remove any stray dots or hashes which aren't attached to words
	  // These may be present if the user is live-editing this selector
	  selector = selector.replace(straysRegex, ' ');
	
	  // The only things left should be element selectors (type c)
	  findMatch(elementRegex, 'c', types, selector);
	
	  return (types.a * 100) + (types.b * 10) + (types.c * 1);
	}
	
	var specificityCache = {};
	
	exports.calculateSpecificity = function(selector) {
	  var specificity = specificityCache[selector];
	  if (specificity === undefined) {
	    specificity = calculate(selector);
	    specificityCache[selector] = specificity;
	  }
	  return specificity;
	}
	
	if (global.document) {
	  var validSelectorCache = {};
	  var testSelectorElement = global.document.createElement('div');
	
	  exports.isSelectorValid = function(selector) {
	    var valid = validSelectorCache[selector];
	    if (valid === undefined) {
	      try {
	        testSelectorElement.querySelector(selector);
	        valid = true;
	      } catch (error) {
	        valid = false;
	      }
	      validSelectorCache[selector] = valid;
	    }
	    return valid;
	  }
	
	  exports.validateSelector = function(selector) {
	    if (!exports.isSelectorValid(selector)) {
	      var error = new SyntaxError(selector + ' is not a valid selector');
	      error.code = 'EBADSELECTOR';
	      throw error;
	    }
	  }
	}
	
	/* WEBPACK VAR INJECTION */}.call(exports, (function() { return this; }())))

/***/ },
/* 66 */
/***/ function(module, exports, __webpack_require__) {

	var require;var __WEBPACK_AMD_DEFINE_RESULT__;/* WEBPACK VAR INJECTION */(function(process, global, module) {/*!
	 * @overview es6-promise - a tiny implementation of Promises/A+.
	 * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
	 * @license   Licensed under MIT license
	 *            See https://raw.githubusercontent.com/jakearchibald/es6-promise/master/LICENSE
	 * @version   3.2.1
	 */
	
	(function() {
	    "use strict";
	    function lib$es6$promise$utils$$objectOrFunction(x) {
	      return typeof x === 'function' || (typeof x === 'object' && x !== null);
	    }
	
	    function lib$es6$promise$utils$$isFunction(x) {
	      return typeof x === 'function';
	    }
	
	    function lib$es6$promise$utils$$isMaybeThenable(x) {
	      return typeof x === 'object' && x !== null;
	    }
	
	    var lib$es6$promise$utils$$_isArray;
	    if (!Array.isArray) {
	      lib$es6$promise$utils$$_isArray = function (x) {
	        return Object.prototype.toString.call(x) === '[object Array]';
	      };
	    } else {
	      lib$es6$promise$utils$$_isArray = Array.isArray;
	    }
	
	    var lib$es6$promise$utils$$isArray = lib$es6$promise$utils$$_isArray;
	    var lib$es6$promise$asap$$len = 0;
	    var lib$es6$promise$asap$$vertxNext;
	    var lib$es6$promise$asap$$customSchedulerFn;
	
	    var lib$es6$promise$asap$$asap = function asap(callback, arg) {
	      lib$es6$promise$asap$$queue[lib$es6$promise$asap$$len] = callback;
	      lib$es6$promise$asap$$queue[lib$es6$promise$asap$$len + 1] = arg;
	      lib$es6$promise$asap$$len += 2;
	      if (lib$es6$promise$asap$$len === 2) {
	        // If len is 2, that means that we need to schedule an async flush.
	        // If additional callbacks are queued before the queue is flushed, they
	        // will be processed by this flush that we are scheduling.
	        if (lib$es6$promise$asap$$customSchedulerFn) {
	          lib$es6$promise$asap$$customSchedulerFn(lib$es6$promise$asap$$flush);
	        } else {
	          lib$es6$promise$asap$$scheduleFlush();
	        }
	      }
	    }
	
	    function lib$es6$promise$asap$$setScheduler(scheduleFn) {
	      lib$es6$promise$asap$$customSchedulerFn = scheduleFn;
	    }
	
	    function lib$es6$promise$asap$$setAsap(asapFn) {
	      lib$es6$promise$asap$$asap = asapFn;
	    }
	
	    var lib$es6$promise$asap$$browserWindow = (typeof window !== 'undefined') ? window : undefined;
	    var lib$es6$promise$asap$$browserGlobal = lib$es6$promise$asap$$browserWindow || {};
	    var lib$es6$promise$asap$$BrowserMutationObserver = lib$es6$promise$asap$$browserGlobal.MutationObserver || lib$es6$promise$asap$$browserGlobal.WebKitMutationObserver;
	    var lib$es6$promise$asap$$isNode = typeof self === 'undefined' && typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';
	
	    // test for web worker but not in IE10
	    var lib$es6$promise$asap$$isWorker = typeof Uint8ClampedArray !== 'undefined' &&
	      typeof importScripts !== 'undefined' &&
	      typeof MessageChannel !== 'undefined';
	
	    // node
	    function lib$es6$promise$asap$$useNextTick() {
	      // node version 0.10.x displays a deprecation warning when nextTick is used recursively
	      // see https://github.com/cujojs/when/issues/410 for details
	      return function() {
	        process.nextTick(lib$es6$promise$asap$$flush);
	      };
	    }
	
	    // vertx
	    function lib$es6$promise$asap$$useVertxTimer() {
	      return function() {
	        lib$es6$promise$asap$$vertxNext(lib$es6$promise$asap$$flush);
	      };
	    }
	
	    function lib$es6$promise$asap$$useMutationObserver() {
	      var iterations = 0;
	      var observer = new lib$es6$promise$asap$$BrowserMutationObserver(lib$es6$promise$asap$$flush);
	      var node = document.createTextNode('');
	      observer.observe(node, { characterData: true });
	
	      return function() {
	        node.data = (iterations = ++iterations % 2);
	      };
	    }
	
	    // web worker
	    function lib$es6$promise$asap$$useMessageChannel() {
	      var channel = new MessageChannel();
	      channel.port1.onmessage = lib$es6$promise$asap$$flush;
	      return function () {
	        channel.port2.postMessage(0);
	      };
	    }
	
	    function lib$es6$promise$asap$$useSetTimeout() {
	      return function() {
	        setTimeout(lib$es6$promise$asap$$flush, 1);
	      };
	    }
	
	    var lib$es6$promise$asap$$queue = new Array(1000);
	    function lib$es6$promise$asap$$flush() {
	      for (var i = 0; i < lib$es6$promise$asap$$len; i+=2) {
	        var callback = lib$es6$promise$asap$$queue[i];
	        var arg = lib$es6$promise$asap$$queue[i+1];
	
	        callback(arg);
	
	        lib$es6$promise$asap$$queue[i] = undefined;
	        lib$es6$promise$asap$$queue[i+1] = undefined;
	      }
	
	      lib$es6$promise$asap$$len = 0;
	    }
	
	    function lib$es6$promise$asap$$attemptVertx() {
	      try {
	        var r = require;
	        var vertx = __webpack_require__(68);
	        lib$es6$promise$asap$$vertxNext = vertx.runOnLoop || vertx.runOnContext;
	        return lib$es6$promise$asap$$useVertxTimer();
	      } catch(e) {
	        return lib$es6$promise$asap$$useSetTimeout();
	      }
	    }
	
	    var lib$es6$promise$asap$$scheduleFlush;
	    // Decide what async method to use to triggering processing of queued callbacks:
	    if (lib$es6$promise$asap$$isNode) {
	      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$useNextTick();
	    } else if (lib$es6$promise$asap$$BrowserMutationObserver) {
	      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$useMutationObserver();
	    } else if (lib$es6$promise$asap$$isWorker) {
	      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$useMessageChannel();
	    } else if (lib$es6$promise$asap$$browserWindow === undefined && "function" === 'function') {
	      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$attemptVertx();
	    } else {
	      lib$es6$promise$asap$$scheduleFlush = lib$es6$promise$asap$$useSetTimeout();
	    }
	    function lib$es6$promise$then$$then(onFulfillment, onRejection) {
	      var parent = this;
	
	      var child = new this.constructor(lib$es6$promise$$internal$$noop);
	
	      if (child[lib$es6$promise$$internal$$PROMISE_ID] === undefined) {
	        lib$es6$promise$$internal$$makePromise(child);
	      }
	
	      var state = parent._state;
	
	      if (state) {
	        var callback = arguments[state - 1];
	        lib$es6$promise$asap$$asap(function(){
	          lib$es6$promise$$internal$$invokeCallback(state, child, callback, parent._result);
	        });
	      } else {
	        lib$es6$promise$$internal$$subscribe(parent, child, onFulfillment, onRejection);
	      }
	
	      return child;
	    }
	    var lib$es6$promise$then$$default = lib$es6$promise$then$$then;
	    function lib$es6$promise$promise$resolve$$resolve(object) {
	      /*jshint validthis:true */
	      var Constructor = this;
	
	      if (object && typeof object === 'object' && object.constructor === Constructor) {
	        return object;
	      }
	
	      var promise = new Constructor(lib$es6$promise$$internal$$noop);
	      lib$es6$promise$$internal$$resolve(promise, object);
	      return promise;
	    }
	    var lib$es6$promise$promise$resolve$$default = lib$es6$promise$promise$resolve$$resolve;
	    var lib$es6$promise$$internal$$PROMISE_ID = Math.random().toString(36).substring(16);
	
	    function lib$es6$promise$$internal$$noop() {}
	
	    var lib$es6$promise$$internal$$PENDING   = void 0;
	    var lib$es6$promise$$internal$$FULFILLED = 1;
	    var lib$es6$promise$$internal$$REJECTED  = 2;
	
	    var lib$es6$promise$$internal$$GET_THEN_ERROR = new lib$es6$promise$$internal$$ErrorObject();
	
	    function lib$es6$promise$$internal$$selfFulfillment() {
	      return new TypeError("You cannot resolve a promise with itself");
	    }
	
	    function lib$es6$promise$$internal$$cannotReturnOwn() {
	      return new TypeError('A promises callback cannot return that same promise.');
	    }
	
	    function lib$es6$promise$$internal$$getThen(promise) {
	      try {
	        return promise.then;
	      } catch(error) {
	        lib$es6$promise$$internal$$GET_THEN_ERROR.error = error;
	        return lib$es6$promise$$internal$$GET_THEN_ERROR;
	      }
	    }
	
	    function lib$es6$promise$$internal$$tryThen(then, value, fulfillmentHandler, rejectionHandler) {
	      try {
	        then.call(value, fulfillmentHandler, rejectionHandler);
	      } catch(e) {
	        return e;
	      }
	    }
	
	    function lib$es6$promise$$internal$$handleForeignThenable(promise, thenable, then) {
	       lib$es6$promise$asap$$asap(function(promise) {
	        var sealed = false;
	        var error = lib$es6$promise$$internal$$tryThen(then, thenable, function(value) {
	          if (sealed) { return; }
	          sealed = true;
	          if (thenable !== value) {
	            lib$es6$promise$$internal$$resolve(promise, value);
	          } else {
	            lib$es6$promise$$internal$$fulfill(promise, value);
	          }
	        }, function(reason) {
	          if (sealed) { return; }
	          sealed = true;
	
	          lib$es6$promise$$internal$$reject(promise, reason);
	        }, 'Settle: ' + (promise._label || ' unknown promise'));
	
	        if (!sealed && error) {
	          sealed = true;
	          lib$es6$promise$$internal$$reject(promise, error);
	        }
	      }, promise);
	    }
	
	    function lib$es6$promise$$internal$$handleOwnThenable(promise, thenable) {
	      if (thenable._state === lib$es6$promise$$internal$$FULFILLED) {
	        lib$es6$promise$$internal$$fulfill(promise, thenable._result);
	      } else if (thenable._state === lib$es6$promise$$internal$$REJECTED) {
	        lib$es6$promise$$internal$$reject(promise, thenable._result);
	      } else {
	        lib$es6$promise$$internal$$subscribe(thenable, undefined, function(value) {
	          lib$es6$promise$$internal$$resolve(promise, value);
	        }, function(reason) {
	          lib$es6$promise$$internal$$reject(promise, reason);
	        });
	      }
	    }
	
	    function lib$es6$promise$$internal$$handleMaybeThenable(promise, maybeThenable, then) {
	      if (maybeThenable.constructor === promise.constructor &&
	          then === lib$es6$promise$then$$default &&
	          constructor.resolve === lib$es6$promise$promise$resolve$$default) {
	        lib$es6$promise$$internal$$handleOwnThenable(promise, maybeThenable);
	      } else {
	        if (then === lib$es6$promise$$internal$$GET_THEN_ERROR) {
	          lib$es6$promise$$internal$$reject(promise, lib$es6$promise$$internal$$GET_THEN_ERROR.error);
	        } else if (then === undefined) {
	          lib$es6$promise$$internal$$fulfill(promise, maybeThenable);
	        } else if (lib$es6$promise$utils$$isFunction(then)) {
	          lib$es6$promise$$internal$$handleForeignThenable(promise, maybeThenable, then);
	        } else {
	          lib$es6$promise$$internal$$fulfill(promise, maybeThenable);
	        }
	      }
	    }
	
	    function lib$es6$promise$$internal$$resolve(promise, value) {
	      if (promise === value) {
	        lib$es6$promise$$internal$$reject(promise, lib$es6$promise$$internal$$selfFulfillment());
	      } else if (lib$es6$promise$utils$$objectOrFunction(value)) {
	        lib$es6$promise$$internal$$handleMaybeThenable(promise, value, lib$es6$promise$$internal$$getThen(value));
	      } else {
	        lib$es6$promise$$internal$$fulfill(promise, value);
	      }
	    }
	
	    function lib$es6$promise$$internal$$publishRejection(promise) {
	      if (promise._onerror) {
	        promise._onerror(promise._result);
	      }
	
	      lib$es6$promise$$internal$$publish(promise);
	    }
	
	    function lib$es6$promise$$internal$$fulfill(promise, value) {
	      if (promise._state !== lib$es6$promise$$internal$$PENDING) { return; }
	
	      promise._result = value;
	      promise._state = lib$es6$promise$$internal$$FULFILLED;
	
	      if (promise._subscribers.length !== 0) {
	        lib$es6$promise$asap$$asap(lib$es6$promise$$internal$$publish, promise);
	      }
	    }
	
	    function lib$es6$promise$$internal$$reject(promise, reason) {
	      if (promise._state !== lib$es6$promise$$internal$$PENDING) { return; }
	      promise._state = lib$es6$promise$$internal$$REJECTED;
	      promise._result = reason;
	
	      lib$es6$promise$asap$$asap(lib$es6$promise$$internal$$publishRejection, promise);
	    }
	
	    function lib$es6$promise$$internal$$subscribe(parent, child, onFulfillment, onRejection) {
	      var subscribers = parent._subscribers;
	      var length = subscribers.length;
	
	      parent._onerror = null;
	
	      subscribers[length] = child;
	      subscribers[length + lib$es6$promise$$internal$$FULFILLED] = onFulfillment;
	      subscribers[length + lib$es6$promise$$internal$$REJECTED]  = onRejection;
	
	      if (length === 0 && parent._state) {
	        lib$es6$promise$asap$$asap(lib$es6$promise$$internal$$publish, parent);
	      }
	    }
	
	    function lib$es6$promise$$internal$$publish(promise) {
	      var subscribers = promise._subscribers;
	      var settled = promise._state;
	
	      if (subscribers.length === 0) { return; }
	
	      var child, callback, detail = promise._result;
	
	      for (var i = 0; i < subscribers.length; i += 3) {
	        child = subscribers[i];
	        callback = subscribers[i + settled];
	
	        if (child) {
	          lib$es6$promise$$internal$$invokeCallback(settled, child, callback, detail);
	        } else {
	          callback(detail);
	        }
	      }
	
	      promise._subscribers.length = 0;
	    }
	
	    function lib$es6$promise$$internal$$ErrorObject() {
	      this.error = null;
	    }
	
	    var lib$es6$promise$$internal$$TRY_CATCH_ERROR = new lib$es6$promise$$internal$$ErrorObject();
	
	    function lib$es6$promise$$internal$$tryCatch(callback, detail) {
	      try {
	        return callback(detail);
	      } catch(e) {
	        lib$es6$promise$$internal$$TRY_CATCH_ERROR.error = e;
	        return lib$es6$promise$$internal$$TRY_CATCH_ERROR;
	      }
	    }
	
	    function lib$es6$promise$$internal$$invokeCallback(settled, promise, callback, detail) {
	      var hasCallback = lib$es6$promise$utils$$isFunction(callback),
	          value, error, succeeded, failed;
	
	      if (hasCallback) {
	        value = lib$es6$promise$$internal$$tryCatch(callback, detail);
	
	        if (value === lib$es6$promise$$internal$$TRY_CATCH_ERROR) {
	          failed = true;
	          error = value.error;
	          value = null;
	        } else {
	          succeeded = true;
	        }
	
	        if (promise === value) {
	          lib$es6$promise$$internal$$reject(promise, lib$es6$promise$$internal$$cannotReturnOwn());
	          return;
	        }
	
	      } else {
	        value = detail;
	        succeeded = true;
	      }
	
	      if (promise._state !== lib$es6$promise$$internal$$PENDING) {
	        // noop
	      } else if (hasCallback && succeeded) {
	        lib$es6$promise$$internal$$resolve(promise, value);
	      } else if (failed) {
	        lib$es6$promise$$internal$$reject(promise, error);
	      } else if (settled === lib$es6$promise$$internal$$FULFILLED) {
	        lib$es6$promise$$internal$$fulfill(promise, value);
	      } else if (settled === lib$es6$promise$$internal$$REJECTED) {
	        lib$es6$promise$$internal$$reject(promise, value);
	      }
	    }
	
	    function lib$es6$promise$$internal$$initializePromise(promise, resolver) {
	      try {
	        resolver(function resolvePromise(value){
	          lib$es6$promise$$internal$$resolve(promise, value);
	        }, function rejectPromise(reason) {
	          lib$es6$promise$$internal$$reject(promise, reason);
	        });
	      } catch(e) {
	        lib$es6$promise$$internal$$reject(promise, e);
	      }
	    }
	
	    var lib$es6$promise$$internal$$id = 0;
	    function lib$es6$promise$$internal$$nextId() {
	      return lib$es6$promise$$internal$$id++;
	    }
	
	    function lib$es6$promise$$internal$$makePromise(promise) {
	      promise[lib$es6$promise$$internal$$PROMISE_ID] = lib$es6$promise$$internal$$id++;
	      promise._state = undefined;
	      promise._result = undefined;
	      promise._subscribers = [];
	    }
	
	    function lib$es6$promise$promise$all$$all(entries) {
	      return new lib$es6$promise$enumerator$$default(this, entries).promise;
	    }
	    var lib$es6$promise$promise$all$$default = lib$es6$promise$promise$all$$all;
	    function lib$es6$promise$promise$race$$race(entries) {
	      /*jshint validthis:true */
	      var Constructor = this;
	
	      if (!lib$es6$promise$utils$$isArray(entries)) {
	        return new Constructor(function(resolve, reject) {
	          reject(new TypeError('You must pass an array to race.'));
	        });
	      } else {
	        return new Constructor(function(resolve, reject) {
	          var length = entries.length;
	          for (var i = 0; i < length; i++) {
	            Constructor.resolve(entries[i]).then(resolve, reject);
	          }
	        });
	      }
	    }
	    var lib$es6$promise$promise$race$$default = lib$es6$promise$promise$race$$race;
	    function lib$es6$promise$promise$reject$$reject(reason) {
	      /*jshint validthis:true */
	      var Constructor = this;
	      var promise = new Constructor(lib$es6$promise$$internal$$noop);
	      lib$es6$promise$$internal$$reject(promise, reason);
	      return promise;
	    }
	    var lib$es6$promise$promise$reject$$default = lib$es6$promise$promise$reject$$reject;
	
	
	    function lib$es6$promise$promise$$needsResolver() {
	      throw new TypeError('You must pass a resolver function as the first argument to the promise constructor');
	    }
	
	    function lib$es6$promise$promise$$needsNew() {
	      throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");
	    }
	
	    var lib$es6$promise$promise$$default = lib$es6$promise$promise$$Promise;
	    /**
	      Promise objects represent the eventual result of an asynchronous operation. The
	      primary way of interacting with a promise is through its `then` method, which
	      registers callbacks to receive either a promise's eventual value or the reason
	      why the promise cannot be fulfilled.
	
	      Terminology
	      -----------
	
	      - `promise` is an object or function with a `then` method whose behavior conforms to this specification.
	      - `thenable` is an object or function that defines a `then` method.
	      - `value` is any legal JavaScript value (including undefined, a thenable, or a promise).
	      - `exception` is a value that is thrown using the throw statement.
	      - `reason` is a value that indicates why a promise was rejected.
	      - `settled` the final resting state of a promise, fulfilled or rejected.
	
	      A promise can be in one of three states: pending, fulfilled, or rejected.
	
	      Promises that are fulfilled have a fulfillment value and are in the fulfilled
	      state.  Promises that are rejected have a rejection reason and are in the
	      rejected state.  A fulfillment value is never a thenable.
	
	      Promises can also be said to *resolve* a value.  If this value is also a
	      promise, then the original promise's settled state will match the value's
	      settled state.  So a promise that *resolves* a promise that rejects will
	      itself reject, and a promise that *resolves* a promise that fulfills will
	      itself fulfill.
	
	
	      Basic Usage:
	      ------------
	
	      ```js
	      var promise = new Promise(function(resolve, reject) {
	        // on success
	        resolve(value);
	
	        // on failure
	        reject(reason);
	      });
	
	      promise.then(function(value) {
	        // on fulfillment
	      }, function(reason) {
	        // on rejection
	      });
	      ```
	
	      Advanced Usage:
	      ---------------
	
	      Promises shine when abstracting away asynchronous interactions such as
	      `XMLHttpRequest`s.
	
	      ```js
	      function getJSON(url) {
	        return new Promise(function(resolve, reject){
	          var xhr = new XMLHttpRequest();
	
	          xhr.open('GET', url);
	          xhr.onreadystatechange = handler;
	          xhr.responseType = 'json';
	          xhr.setRequestHeader('Accept', 'application/json');
	          xhr.send();
	
	          function handler() {
	            if (this.readyState === this.DONE) {
	              if (this.status === 200) {
	                resolve(this.response);
	              } else {
	                reject(new Error('getJSON: `' + url + '` failed with status: [' + this.status + ']'));
	              }
	            }
	          };
	        });
	      }
	
	      getJSON('/posts.json').then(function(json) {
	        // on fulfillment
	      }, function(reason) {
	        // on rejection
	      });
	      ```
	
	      Unlike callbacks, promises are great composable primitives.
	
	      ```js
	      Promise.all([
	        getJSON('/posts'),
	        getJSON('/comments')
	      ]).then(function(values){
	        values[0] // => postsJSON
	        values[1] // => commentsJSON
	
	        return values;
	      });
	      ```
	
	      @class Promise
	      @param {function} resolver
	      Useful for tooling.
	      @constructor
	    */
	    function lib$es6$promise$promise$$Promise(resolver) {
	      this[lib$es6$promise$$internal$$PROMISE_ID] = lib$es6$promise$$internal$$nextId();
	      this._result = this._state = undefined;
	      this._subscribers = [];
	
	      if (lib$es6$promise$$internal$$noop !== resolver) {
	        typeof resolver !== 'function' && lib$es6$promise$promise$$needsResolver();
	        this instanceof lib$es6$promise$promise$$Promise ? lib$es6$promise$$internal$$initializePromise(this, resolver) : lib$es6$promise$promise$$needsNew();
	      }
	    }
	
	    lib$es6$promise$promise$$Promise.all = lib$es6$promise$promise$all$$default;
	    lib$es6$promise$promise$$Promise.race = lib$es6$promise$promise$race$$default;
	    lib$es6$promise$promise$$Promise.resolve = lib$es6$promise$promise$resolve$$default;
	    lib$es6$promise$promise$$Promise.reject = lib$es6$promise$promise$reject$$default;
	    lib$es6$promise$promise$$Promise._setScheduler = lib$es6$promise$asap$$setScheduler;
	    lib$es6$promise$promise$$Promise._setAsap = lib$es6$promise$asap$$setAsap;
	    lib$es6$promise$promise$$Promise._asap = lib$es6$promise$asap$$asap;
	
	    lib$es6$promise$promise$$Promise.prototype = {
	      constructor: lib$es6$promise$promise$$Promise,
	
	    /**
	      The primary way of interacting with a promise is through its `then` method,
	      which registers callbacks to receive either a promise's eventual value or the
	      reason why the promise cannot be fulfilled.
	
	      ```js
	      findUser().then(function(user){
	        // user is available
	      }, function(reason){
	        // user is unavailable, and you are given the reason why
	      });
	      ```
	
	      Chaining
	      --------
	
	      The return value of `then` is itself a promise.  This second, 'downstream'
	      promise is resolved with the return value of the first promise's fulfillment
	      or rejection handler, or rejected if the handler throws an exception.
	
	      ```js
	      findUser().then(function (user) {
	        return user.name;
	      }, function (reason) {
	        return 'default name';
	      }).then(function (userName) {
	        // If `findUser` fulfilled, `userName` will be the user's name, otherwise it
	        // will be `'default name'`
	      });
	
	      findUser().then(function (user) {
	        throw new Error('Found user, but still unhappy');
	      }, function (reason) {
	        throw new Error('`findUser` rejected and we're unhappy');
	      }).then(function (value) {
	        // never reached
	      }, function (reason) {
	        // if `findUser` fulfilled, `reason` will be 'Found user, but still unhappy'.
	        // If `findUser` rejected, `reason` will be '`findUser` rejected and we're unhappy'.
	      });
	      ```
	      If the downstream promise does not specify a rejection handler, rejection reasons will be propagated further downstream.
	
	      ```js
	      findUser().then(function (user) {
	        throw new PedagogicalException('Upstream error');
	      }).then(function (value) {
	        // never reached
	      }).then(function (value) {
	        // never reached
	      }, function (reason) {
	        // The `PedgagocialException` is propagated all the way down to here
	      });
	      ```
	
	      Assimilation
	      ------------
	
	      Sometimes the value you want to propagate to a downstream promise can only be
	      retrieved asynchronously. This can be achieved by returning a promise in the
	      fulfillment or rejection handler. The downstream promise will then be pending
	      until the returned promise is settled. This is called *assimilation*.
	
	      ```js
	      findUser().then(function (user) {
	        return findCommentsByAuthor(user);
	      }).then(function (comments) {
	        // The user's comments are now available
	      });
	      ```
	
	      If the assimliated promise rejects, then the downstream promise will also reject.
	
	      ```js
	      findUser().then(function (user) {
	        return findCommentsByAuthor(user);
	      }).then(function (comments) {
	        // If `findCommentsByAuthor` fulfills, we'll have the value here
	      }, function (reason) {
	        // If `findCommentsByAuthor` rejects, we'll have the reason here
	      });
	      ```
	
	      Simple Example
	      --------------
	
	      Synchronous Example
	
	      ```javascript
	      var result;
	
	      try {
	        result = findResult();
	        // success
	      } catch(reason) {
	        // failure
	      }
	      ```
	
	      Errback Example
	
	      ```js
	      findResult(function(result, err){
	        if (err) {
	          // failure
	        } else {
	          // success
	        }
	      });
	      ```
	
	      Promise Example;
	
	      ```javascript
	      findResult().then(function(result){
	        // success
	      }, function(reason){
	        // failure
	      });
	      ```
	
	      Advanced Example
	      --------------
	
	      Synchronous Example
	
	      ```javascript
	      var author, books;
	
	      try {
	        author = findAuthor();
	        books  = findBooksByAuthor(author);
	        // success
	      } catch(reason) {
	        // failure
	      }
	      ```
	
	      Errback Example
	
	      ```js
	
	      function foundBooks(books) {
	
	      }
	
	      function failure(reason) {
	
	      }
	
	      findAuthor(function(author, err){
	        if (err) {
	          failure(err);
	          // failure
	        } else {
	          try {
	            findBoooksByAuthor(author, function(books, err) {
	              if (err) {
	                failure(err);
	              } else {
	                try {
	                  foundBooks(books);
	                } catch(reason) {
	                  failure(reason);
	                }
	              }
	            });
	          } catch(error) {
	            failure(err);
	          }
	          // success
	        }
	      });
	      ```
	
	      Promise Example;
	
	      ```javascript
	      findAuthor().
	        then(findBooksByAuthor).
	        then(function(books){
	          // found books
	      }).catch(function(reason){
	        // something went wrong
	      });
	      ```
	
	      @method then
	      @param {Function} onFulfilled
	      @param {Function} onRejected
	      Useful for tooling.
	      @return {Promise}
	    */
	      then: lib$es6$promise$then$$default,
	
	    /**
	      `catch` is simply sugar for `then(undefined, onRejection)` which makes it the same
	      as the catch block of a try/catch statement.
	
	      ```js
	      function findAuthor(){
	        throw new Error('couldn't find that author');
	      }
	
	      // synchronous
	      try {
	        findAuthor();
	      } catch(reason) {
	        // something went wrong
	      }
	
	      // async with promises
	      findAuthor().catch(function(reason){
	        // something went wrong
	      });
	      ```
	
	      @method catch
	      @param {Function} onRejection
	      Useful for tooling.
	      @return {Promise}
	    */
	      'catch': function(onRejection) {
	        return this.then(null, onRejection);
	      }
	    };
	    var lib$es6$promise$enumerator$$default = lib$es6$promise$enumerator$$Enumerator;
	    function lib$es6$promise$enumerator$$Enumerator(Constructor, input) {
	      this._instanceConstructor = Constructor;
	      this.promise = new Constructor(lib$es6$promise$$internal$$noop);
	
	      if (!this.promise[lib$es6$promise$$internal$$PROMISE_ID]) {
	        lib$es6$promise$$internal$$makePromise(this.promise);
	      }
	
	      if (lib$es6$promise$utils$$isArray(input)) {
	        this._input     = input;
	        this.length     = input.length;
	        this._remaining = input.length;
	
	        this._result = new Array(this.length);
	
	        if (this.length === 0) {
	          lib$es6$promise$$internal$$fulfill(this.promise, this._result);
	        } else {
	          this.length = this.length || 0;
	          this._enumerate();
	          if (this._remaining === 0) {
	            lib$es6$promise$$internal$$fulfill(this.promise, this._result);
	          }
	        }
	      } else {
	        lib$es6$promise$$internal$$reject(this.promise, lib$es6$promise$enumerator$$validationError());
	      }
	    }
	
	    function lib$es6$promise$enumerator$$validationError() {
	      return new Error('Array Methods must be provided an Array');
	    }
	
	    lib$es6$promise$enumerator$$Enumerator.prototype._enumerate = function() {
	      var length  = this.length;
	      var input   = this._input;
	
	      for (var i = 0; this._state === lib$es6$promise$$internal$$PENDING && i < length; i++) {
	        this._eachEntry(input[i], i);
	      }
	    };
	
	    lib$es6$promise$enumerator$$Enumerator.prototype._eachEntry = function(entry, i) {
	      var c = this._instanceConstructor;
	      var resolve = c.resolve;
	
	      if (resolve === lib$es6$promise$promise$resolve$$default) {
	        var then = lib$es6$promise$$internal$$getThen(entry);
	
	        if (then === lib$es6$promise$then$$default &&
	            entry._state !== lib$es6$promise$$internal$$PENDING) {
	          this._settledAt(entry._state, i, entry._result);
	        } else if (typeof then !== 'function') {
	          this._remaining--;
	          this._result[i] = entry;
	        } else if (c === lib$es6$promise$promise$$default) {
	          var promise = new c(lib$es6$promise$$internal$$noop);
	          lib$es6$promise$$internal$$handleMaybeThenable(promise, entry, then);
	          this._willSettleAt(promise, i);
	        } else {
	          this._willSettleAt(new c(function(resolve) { resolve(entry); }), i);
	        }
	      } else {
	        this._willSettleAt(resolve(entry), i);
	      }
	    };
	
	    lib$es6$promise$enumerator$$Enumerator.prototype._settledAt = function(state, i, value) {
	      var promise = this.promise;
	
	      if (promise._state === lib$es6$promise$$internal$$PENDING) {
	        this._remaining--;
	
	        if (state === lib$es6$promise$$internal$$REJECTED) {
	          lib$es6$promise$$internal$$reject(promise, value);
	        } else {
	          this._result[i] = value;
	        }
	      }
	
	      if (this._remaining === 0) {
	        lib$es6$promise$$internal$$fulfill(promise, this._result);
	      }
	    };
	
	    lib$es6$promise$enumerator$$Enumerator.prototype._willSettleAt = function(promise, i) {
	      var enumerator = this;
	
	      lib$es6$promise$$internal$$subscribe(promise, undefined, function(value) {
	        enumerator._settledAt(lib$es6$promise$$internal$$FULFILLED, i, value);
	      }, function(reason) {
	        enumerator._settledAt(lib$es6$promise$$internal$$REJECTED, i, reason);
	      });
	    };
	    function lib$es6$promise$polyfill$$polyfill() {
	      var local;
	
	      if (typeof global !== 'undefined') {
	          local = global;
	      } else if (typeof self !== 'undefined') {
	          local = self;
	      } else {
	          try {
	              local = Function('return this')();
	          } catch (e) {
	              throw new Error('polyfill failed because global object is unavailable in this environment');
	          }
	      }
	
	      var P = local.Promise;
	
	      if (P && Object.prototype.toString.call(P.resolve()) === '[object Promise]' && !P.cast) {
	        return;
	      }
	
	      local.Promise = lib$es6$promise$promise$$default;
	    }
	    var lib$es6$promise$polyfill$$default = lib$es6$promise$polyfill$$polyfill;
	
	    var lib$es6$promise$umd$$ES6Promise = {
	      'Promise': lib$es6$promise$promise$$default,
	      'polyfill': lib$es6$promise$polyfill$$default
	    };
	
	    /* global define:true module:true window: true */
	    if ("function" === 'function' && __webpack_require__(69)['amd']) {
	      !(__WEBPACK_AMD_DEFINE_RESULT__ = function() { return lib$es6$promise$umd$$ES6Promise; }.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	    } else if (typeof module !== 'undefined' && module['exports']) {
	      module['exports'] = lib$es6$promise$umd$$ES6Promise;
	    } else if (typeof this !== 'undefined') {
	      this['ES6Promise'] = lib$es6$promise$umd$$ES6Promise;
	    }
	
	    lib$es6$promise$polyfill$$default();
	}).call(this);
	
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(15), (function() { return this; }()), __webpack_require__(67)(module)))

/***/ },
/* 67 */
/***/ function(module, exports) {

	module.exports = function(module) {
		if(!module.webpackPolyfill) {
			module.deprecate = function() {};
			module.paths = [];
			// module.parent = undefined by default
			module.children = [];
			module.webpackPolyfill = 1;
		}
		return module;
	}


/***/ },
/* 68 */
/***/ function(module, exports) {

	/* (ignored) */

/***/ },
/* 69 */
/***/ function(module, exports) {

	module.exports = function() { throw new Error("define cannot be used indirect"); };


/***/ },
/* 70 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(71);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(12)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../css-loader/index.js!./font-awesome.min.css", function() {
				var newContent = require("!!./../../css-loader/index.js!./font-awesome.min.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 71 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*!\n *  Font Awesome 4.6.3 by @davegandy - http://fontawesome.io - @fontawesome\n *  License - http://fontawesome.io/license (Font: SIL OFL 1.1, CSS: MIT License)\n */@font-face{font-family:'FontAwesome';src:url(" + __webpack_require__(72) + ");src:url(" + __webpack_require__(73) + "?#iefix&v=4.6.3) format('embedded-opentype'),url(" + __webpack_require__(74) + ") format('woff2'),url(" + __webpack_require__(75) + ") format('woff'),url(" + __webpack_require__(76) + ") format('truetype'),url(" + __webpack_require__(77) + "#fontawesomeregular) format('svg');font-weight:normal;font-style:normal}.fa{display:inline-block;font:normal normal normal 14px/1 FontAwesome;font-size:inherit;text-rendering:auto;-webkit-font-smoothing:antialiased;-moz-osx-font-smoothing:grayscale}.fa-lg{font-size:1.33333333em;line-height:.75em;vertical-align:-15%}.fa-2x{font-size:2em}.fa-3x{font-size:3em}.fa-4x{font-size:4em}.fa-5x{font-size:5em}.fa-fw{width:1.28571429em;text-align:center}.fa-ul{padding-left:0;margin-left:2.14285714em;list-style-type:none}.fa-ul>li{position:relative}.fa-li{position:absolute;left:-2.14285714em;width:2.14285714em;top:.14285714em;text-align:center}.fa-li.fa-lg{left:-1.85714286em}.fa-border{padding:.2em .25em .15em;border:solid .08em #eee;border-radius:.1em}.fa-pull-left{float:left}.fa-pull-right{float:right}.fa.fa-pull-left{margin-right:.3em}.fa.fa-pull-right{margin-left:.3em}.pull-right{float:right}.pull-left{float:left}.fa.pull-left{margin-right:.3em}.fa.pull-right{margin-left:.3em}.fa-spin{-webkit-animation:fa-spin 2s infinite linear;animation:fa-spin 2s infinite linear}.fa-pulse{-webkit-animation:fa-spin 1s infinite steps(8);animation:fa-spin 1s infinite steps(8)}@-webkit-keyframes fa-spin{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}100%{-webkit-transform:rotate(359deg);transform:rotate(359deg)}}@keyframes fa-spin{0%{-webkit-transform:rotate(0deg);transform:rotate(0deg)}100%{-webkit-transform:rotate(359deg);transform:rotate(359deg)}}.fa-rotate-90{-ms-filter:\"progid:DXImageTransform.Microsoft.BasicImage(rotation=1)\";-webkit-transform:rotate(90deg);-ms-transform:rotate(90deg);transform:rotate(90deg)}.fa-rotate-180{-ms-filter:\"progid:DXImageTransform.Microsoft.BasicImage(rotation=2)\";-webkit-transform:rotate(180deg);-ms-transform:rotate(180deg);transform:rotate(180deg)}.fa-rotate-270{-ms-filter:\"progid:DXImageTransform.Microsoft.BasicImage(rotation=3)\";-webkit-transform:rotate(270deg);-ms-transform:rotate(270deg);transform:rotate(270deg)}.fa-flip-horizontal{-ms-filter:\"progid:DXImageTransform.Microsoft.BasicImage(rotation=0, mirror=1)\";-webkit-transform:scale(-1, 1);-ms-transform:scale(-1, 1);transform:scale(-1, 1)}.fa-flip-vertical{-ms-filter:\"progid:DXImageTransform.Microsoft.BasicImage(rotation=2, mirror=1)\";-webkit-transform:scale(1, -1);-ms-transform:scale(1, -1);transform:scale(1, -1)}:root .fa-rotate-90,:root .fa-rotate-180,:root .fa-rotate-270,:root .fa-flip-horizontal,:root .fa-flip-vertical{filter:none}.fa-stack{position:relative;display:inline-block;width:2em;height:2em;line-height:2em;vertical-align:middle}.fa-stack-1x,.fa-stack-2x{position:absolute;left:0;width:100%;text-align:center}.fa-stack-1x{line-height:inherit}.fa-stack-2x{font-size:2em}.fa-inverse{color:#fff}.fa-glass:before{content:\"\\F000\"}.fa-music:before{content:\"\\F001\"}.fa-search:before{content:\"\\F002\"}.fa-envelope-o:before{content:\"\\F003\"}.fa-heart:before{content:\"\\F004\"}.fa-star:before{content:\"\\F005\"}.fa-star-o:before{content:\"\\F006\"}.fa-user:before{content:\"\\F007\"}.fa-film:before{content:\"\\F008\"}.fa-th-large:before{content:\"\\F009\"}.fa-th:before{content:\"\\F00A\"}.fa-th-list:before{content:\"\\F00B\"}.fa-check:before{content:\"\\F00C\"}.fa-remove:before,.fa-close:before,.fa-times:before{content:\"\\F00D\"}.fa-search-plus:before{content:\"\\F00E\"}.fa-search-minus:before{content:\"\\F010\"}.fa-power-off:before{content:\"\\F011\"}.fa-signal:before{content:\"\\F012\"}.fa-gear:before,.fa-cog:before{content:\"\\F013\"}.fa-trash-o:before{content:\"\\F014\"}.fa-home:before{content:\"\\F015\"}.fa-file-o:before{content:\"\\F016\"}.fa-clock-o:before{content:\"\\F017\"}.fa-road:before{content:\"\\F018\"}.fa-download:before{content:\"\\F019\"}.fa-arrow-circle-o-down:before{content:\"\\F01A\"}.fa-arrow-circle-o-up:before{content:\"\\F01B\"}.fa-inbox:before{content:\"\\F01C\"}.fa-play-circle-o:before{content:\"\\F01D\"}.fa-rotate-right:before,.fa-repeat:before{content:\"\\F01E\"}.fa-refresh:before{content:\"\\F021\"}.fa-list-alt:before{content:\"\\F022\"}.fa-lock:before{content:\"\\F023\"}.fa-flag:before{content:\"\\F024\"}.fa-headphones:before{content:\"\\F025\"}.fa-volume-off:before{content:\"\\F026\"}.fa-volume-down:before{content:\"\\F027\"}.fa-volume-up:before{content:\"\\F028\"}.fa-qrcode:before{content:\"\\F029\"}.fa-barcode:before{content:\"\\F02A\"}.fa-tag:before{content:\"\\F02B\"}.fa-tags:before{content:\"\\F02C\"}.fa-book:before{content:\"\\F02D\"}.fa-bookmark:before{content:\"\\F02E\"}.fa-print:before{content:\"\\F02F\"}.fa-camera:before{content:\"\\F030\"}.fa-font:before{content:\"\\F031\"}.fa-bold:before{content:\"\\F032\"}.fa-italic:before{content:\"\\F033\"}.fa-text-height:before{content:\"\\F034\"}.fa-text-width:before{content:\"\\F035\"}.fa-align-left:before{content:\"\\F036\"}.fa-align-center:before{content:\"\\F037\"}.fa-align-right:before{content:\"\\F038\"}.fa-align-justify:before{content:\"\\F039\"}.fa-list:before{content:\"\\F03A\"}.fa-dedent:before,.fa-outdent:before{content:\"\\F03B\"}.fa-indent:before{content:\"\\F03C\"}.fa-video-camera:before{content:\"\\F03D\"}.fa-photo:before,.fa-image:before,.fa-picture-o:before{content:\"\\F03E\"}.fa-pencil:before{content:\"\\F040\"}.fa-map-marker:before{content:\"\\F041\"}.fa-adjust:before{content:\"\\F042\"}.fa-tint:before{content:\"\\F043\"}.fa-edit:before,.fa-pencil-square-o:before{content:\"\\F044\"}.fa-share-square-o:before{content:\"\\F045\"}.fa-check-square-o:before{content:\"\\F046\"}.fa-arrows:before{content:\"\\F047\"}.fa-step-backward:before{content:\"\\F048\"}.fa-fast-backward:before{content:\"\\F049\"}.fa-backward:before{content:\"\\F04A\"}.fa-play:before{content:\"\\F04B\"}.fa-pause:before{content:\"\\F04C\"}.fa-stop:before{content:\"\\F04D\"}.fa-forward:before{content:\"\\F04E\"}.fa-fast-forward:before{content:\"\\F050\"}.fa-step-forward:before{content:\"\\F051\"}.fa-eject:before{content:\"\\F052\"}.fa-chevron-left:before{content:\"\\F053\"}.fa-chevron-right:before{content:\"\\F054\"}.fa-plus-circle:before{content:\"\\F055\"}.fa-minus-circle:before{content:\"\\F056\"}.fa-times-circle:before{content:\"\\F057\"}.fa-check-circle:before{content:\"\\F058\"}.fa-question-circle:before{content:\"\\F059\"}.fa-info-circle:before{content:\"\\F05A\"}.fa-crosshairs:before{content:\"\\F05B\"}.fa-times-circle-o:before{content:\"\\F05C\"}.fa-check-circle-o:before{content:\"\\F05D\"}.fa-ban:before{content:\"\\F05E\"}.fa-arrow-left:before{content:\"\\F060\"}.fa-arrow-right:before{content:\"\\F061\"}.fa-arrow-up:before{content:\"\\F062\"}.fa-arrow-down:before{content:\"\\F063\"}.fa-mail-forward:before,.fa-share:before{content:\"\\F064\"}.fa-expand:before{content:\"\\F065\"}.fa-compress:before{content:\"\\F066\"}.fa-plus:before{content:\"\\F067\"}.fa-minus:before{content:\"\\F068\"}.fa-asterisk:before{content:\"\\F069\"}.fa-exclamation-circle:before{content:\"\\F06A\"}.fa-gift:before{content:\"\\F06B\"}.fa-leaf:before{content:\"\\F06C\"}.fa-fire:before{content:\"\\F06D\"}.fa-eye:before{content:\"\\F06E\"}.fa-eye-slash:before{content:\"\\F070\"}.fa-warning:before,.fa-exclamation-triangle:before{content:\"\\F071\"}.fa-plane:before{content:\"\\F072\"}.fa-calendar:before{content:\"\\F073\"}.fa-random:before{content:\"\\F074\"}.fa-comment:before{content:\"\\F075\"}.fa-magnet:before{content:\"\\F076\"}.fa-chevron-up:before{content:\"\\F077\"}.fa-chevron-down:before{content:\"\\F078\"}.fa-retweet:before{content:\"\\F079\"}.fa-shopping-cart:before{content:\"\\F07A\"}.fa-folder:before{content:\"\\F07B\"}.fa-folder-open:before{content:\"\\F07C\"}.fa-arrows-v:before{content:\"\\F07D\"}.fa-arrows-h:before{content:\"\\F07E\"}.fa-bar-chart-o:before,.fa-bar-chart:before{content:\"\\F080\"}.fa-twitter-square:before{content:\"\\F081\"}.fa-facebook-square:before{content:\"\\F082\"}.fa-camera-retro:before{content:\"\\F083\"}.fa-key:before{content:\"\\F084\"}.fa-gears:before,.fa-cogs:before{content:\"\\F085\"}.fa-comments:before{content:\"\\F086\"}.fa-thumbs-o-up:before{content:\"\\F087\"}.fa-thumbs-o-down:before{content:\"\\F088\"}.fa-star-half:before{content:\"\\F089\"}.fa-heart-o:before{content:\"\\F08A\"}.fa-sign-out:before{content:\"\\F08B\"}.fa-linkedin-square:before{content:\"\\F08C\"}.fa-thumb-tack:before{content:\"\\F08D\"}.fa-external-link:before{content:\"\\F08E\"}.fa-sign-in:before{content:\"\\F090\"}.fa-trophy:before{content:\"\\F091\"}.fa-github-square:before{content:\"\\F092\"}.fa-upload:before{content:\"\\F093\"}.fa-lemon-o:before{content:\"\\F094\"}.fa-phone:before{content:\"\\F095\"}.fa-square-o:before{content:\"\\F096\"}.fa-bookmark-o:before{content:\"\\F097\"}.fa-phone-square:before{content:\"\\F098\"}.fa-twitter:before{content:\"\\F099\"}.fa-facebook-f:before,.fa-facebook:before{content:\"\\F09A\"}.fa-github:before{content:\"\\F09B\"}.fa-unlock:before{content:\"\\F09C\"}.fa-credit-card:before{content:\"\\F09D\"}.fa-feed:before,.fa-rss:before{content:\"\\F09E\"}.fa-hdd-o:before{content:\"\\F0A0\"}.fa-bullhorn:before{content:\"\\F0A1\"}.fa-bell:before{content:\"\\F0F3\"}.fa-certificate:before{content:\"\\F0A3\"}.fa-hand-o-right:before{content:\"\\F0A4\"}.fa-hand-o-left:before{content:\"\\F0A5\"}.fa-hand-o-up:before{content:\"\\F0A6\"}.fa-hand-o-down:before{content:\"\\F0A7\"}.fa-arrow-circle-left:before{content:\"\\F0A8\"}.fa-arrow-circle-right:before{content:\"\\F0A9\"}.fa-arrow-circle-up:before{content:\"\\F0AA\"}.fa-arrow-circle-down:before{content:\"\\F0AB\"}.fa-globe:before{content:\"\\F0AC\"}.fa-wrench:before{content:\"\\F0AD\"}.fa-tasks:before{content:\"\\F0AE\"}.fa-filter:before{content:\"\\F0B0\"}.fa-briefcase:before{content:\"\\F0B1\"}.fa-arrows-alt:before{content:\"\\F0B2\"}.fa-group:before,.fa-users:before{content:\"\\F0C0\"}.fa-chain:before,.fa-link:before{content:\"\\F0C1\"}.fa-cloud:before{content:\"\\F0C2\"}.fa-flask:before{content:\"\\F0C3\"}.fa-cut:before,.fa-scissors:before{content:\"\\F0C4\"}.fa-copy:before,.fa-files-o:before{content:\"\\F0C5\"}.fa-paperclip:before{content:\"\\F0C6\"}.fa-save:before,.fa-floppy-o:before{content:\"\\F0C7\"}.fa-square:before{content:\"\\F0C8\"}.fa-navicon:before,.fa-reorder:before,.fa-bars:before{content:\"\\F0C9\"}.fa-list-ul:before{content:\"\\F0CA\"}.fa-list-ol:before{content:\"\\F0CB\"}.fa-strikethrough:before{content:\"\\F0CC\"}.fa-underline:before{content:\"\\F0CD\"}.fa-table:before{content:\"\\F0CE\"}.fa-magic:before{content:\"\\F0D0\"}.fa-truck:before{content:\"\\F0D1\"}.fa-pinterest:before{content:\"\\F0D2\"}.fa-pinterest-square:before{content:\"\\F0D3\"}.fa-google-plus-square:before{content:\"\\F0D4\"}.fa-google-plus:before{content:\"\\F0D5\"}.fa-money:before{content:\"\\F0D6\"}.fa-caret-down:before{content:\"\\F0D7\"}.fa-caret-up:before{content:\"\\F0D8\"}.fa-caret-left:before{content:\"\\F0D9\"}.fa-caret-right:before{content:\"\\F0DA\"}.fa-columns:before{content:\"\\F0DB\"}.fa-unsorted:before,.fa-sort:before{content:\"\\F0DC\"}.fa-sort-down:before,.fa-sort-desc:before{content:\"\\F0DD\"}.fa-sort-up:before,.fa-sort-asc:before{content:\"\\F0DE\"}.fa-envelope:before{content:\"\\F0E0\"}.fa-linkedin:before{content:\"\\F0E1\"}.fa-rotate-left:before,.fa-undo:before{content:\"\\F0E2\"}.fa-legal:before,.fa-gavel:before{content:\"\\F0E3\"}.fa-dashboard:before,.fa-tachometer:before{content:\"\\F0E4\"}.fa-comment-o:before{content:\"\\F0E5\"}.fa-comments-o:before{content:\"\\F0E6\"}.fa-flash:before,.fa-bolt:before{content:\"\\F0E7\"}.fa-sitemap:before{content:\"\\F0E8\"}.fa-umbrella:before{content:\"\\F0E9\"}.fa-paste:before,.fa-clipboard:before{content:\"\\F0EA\"}.fa-lightbulb-o:before{content:\"\\F0EB\"}.fa-exchange:before{content:\"\\F0EC\"}.fa-cloud-download:before{content:\"\\F0ED\"}.fa-cloud-upload:before{content:\"\\F0EE\"}.fa-user-md:before{content:\"\\F0F0\"}.fa-stethoscope:before{content:\"\\F0F1\"}.fa-suitcase:before{content:\"\\F0F2\"}.fa-bell-o:before{content:\"\\F0A2\"}.fa-coffee:before{content:\"\\F0F4\"}.fa-cutlery:before{content:\"\\F0F5\"}.fa-file-text-o:before{content:\"\\F0F6\"}.fa-building-o:before{content:\"\\F0F7\"}.fa-hospital-o:before{content:\"\\F0F8\"}.fa-ambulance:before{content:\"\\F0F9\"}.fa-medkit:before{content:\"\\F0FA\"}.fa-fighter-jet:before{content:\"\\F0FB\"}.fa-beer:before{content:\"\\F0FC\"}.fa-h-square:before{content:\"\\F0FD\"}.fa-plus-square:before{content:\"\\F0FE\"}.fa-angle-double-left:before{content:\"\\F100\"}.fa-angle-double-right:before{content:\"\\F101\"}.fa-angle-double-up:before{content:\"\\F102\"}.fa-angle-double-down:before{content:\"\\F103\"}.fa-angle-left:before{content:\"\\F104\"}.fa-angle-right:before{content:\"\\F105\"}.fa-angle-up:before{content:\"\\F106\"}.fa-angle-down:before{content:\"\\F107\"}.fa-desktop:before{content:\"\\F108\"}.fa-laptop:before{content:\"\\F109\"}.fa-tablet:before{content:\"\\F10A\"}.fa-mobile-phone:before,.fa-mobile:before{content:\"\\F10B\"}.fa-circle-o:before{content:\"\\F10C\"}.fa-quote-left:before{content:\"\\F10D\"}.fa-quote-right:before{content:\"\\F10E\"}.fa-spinner:before{content:\"\\F110\"}.fa-circle:before{content:\"\\F111\"}.fa-mail-reply:before,.fa-reply:before{content:\"\\F112\"}.fa-github-alt:before{content:\"\\F113\"}.fa-folder-o:before{content:\"\\F114\"}.fa-folder-open-o:before{content:\"\\F115\"}.fa-smile-o:before{content:\"\\F118\"}.fa-frown-o:before{content:\"\\F119\"}.fa-meh-o:before{content:\"\\F11A\"}.fa-gamepad:before{content:\"\\F11B\"}.fa-keyboard-o:before{content:\"\\F11C\"}.fa-flag-o:before{content:\"\\F11D\"}.fa-flag-checkered:before{content:\"\\F11E\"}.fa-terminal:before{content:\"\\F120\"}.fa-code:before{content:\"\\F121\"}.fa-mail-reply-all:before,.fa-reply-all:before{content:\"\\F122\"}.fa-star-half-empty:before,.fa-star-half-full:before,.fa-star-half-o:before{content:\"\\F123\"}.fa-location-arrow:before{content:\"\\F124\"}.fa-crop:before{content:\"\\F125\"}.fa-code-fork:before{content:\"\\F126\"}.fa-unlink:before,.fa-chain-broken:before{content:\"\\F127\"}.fa-question:before{content:\"\\F128\"}.fa-info:before{content:\"\\F129\"}.fa-exclamation:before{content:\"\\F12A\"}.fa-superscript:before{content:\"\\F12B\"}.fa-subscript:before{content:\"\\F12C\"}.fa-eraser:before{content:\"\\F12D\"}.fa-puzzle-piece:before{content:\"\\F12E\"}.fa-microphone:before{content:\"\\F130\"}.fa-microphone-slash:before{content:\"\\F131\"}.fa-shield:before{content:\"\\F132\"}.fa-calendar-o:before{content:\"\\F133\"}.fa-fire-extinguisher:before{content:\"\\F134\"}.fa-rocket:before{content:\"\\F135\"}.fa-maxcdn:before{content:\"\\F136\"}.fa-chevron-circle-left:before{content:\"\\F137\"}.fa-chevron-circle-right:before{content:\"\\F138\"}.fa-chevron-circle-up:before{content:\"\\F139\"}.fa-chevron-circle-down:before{content:\"\\F13A\"}.fa-html5:before{content:\"\\F13B\"}.fa-css3:before{content:\"\\F13C\"}.fa-anchor:before{content:\"\\F13D\"}.fa-unlock-alt:before{content:\"\\F13E\"}.fa-bullseye:before{content:\"\\F140\"}.fa-ellipsis-h:before{content:\"\\F141\"}.fa-ellipsis-v:before{content:\"\\F142\"}.fa-rss-square:before{content:\"\\F143\"}.fa-play-circle:before{content:\"\\F144\"}.fa-ticket:before{content:\"\\F145\"}.fa-minus-square:before{content:\"\\F146\"}.fa-minus-square-o:before{content:\"\\F147\"}.fa-level-up:before{content:\"\\F148\"}.fa-level-down:before{content:\"\\F149\"}.fa-check-square:before{content:\"\\F14A\"}.fa-pencil-square:before{content:\"\\F14B\"}.fa-external-link-square:before{content:\"\\F14C\"}.fa-share-square:before{content:\"\\F14D\"}.fa-compass:before{content:\"\\F14E\"}.fa-toggle-down:before,.fa-caret-square-o-down:before{content:\"\\F150\"}.fa-toggle-up:before,.fa-caret-square-o-up:before{content:\"\\F151\"}.fa-toggle-right:before,.fa-caret-square-o-right:before{content:\"\\F152\"}.fa-euro:before,.fa-eur:before{content:\"\\F153\"}.fa-gbp:before{content:\"\\F154\"}.fa-dollar:before,.fa-usd:before{content:\"\\F155\"}.fa-rupee:before,.fa-inr:before{content:\"\\F156\"}.fa-cny:before,.fa-rmb:before,.fa-yen:before,.fa-jpy:before{content:\"\\F157\"}.fa-ruble:before,.fa-rouble:before,.fa-rub:before{content:\"\\F158\"}.fa-won:before,.fa-krw:before{content:\"\\F159\"}.fa-bitcoin:before,.fa-btc:before{content:\"\\F15A\"}.fa-file:before{content:\"\\F15B\"}.fa-file-text:before{content:\"\\F15C\"}.fa-sort-alpha-asc:before{content:\"\\F15D\"}.fa-sort-alpha-desc:before{content:\"\\F15E\"}.fa-sort-amount-asc:before{content:\"\\F160\"}.fa-sort-amount-desc:before{content:\"\\F161\"}.fa-sort-numeric-asc:before{content:\"\\F162\"}.fa-sort-numeric-desc:before{content:\"\\F163\"}.fa-thumbs-up:before{content:\"\\F164\"}.fa-thumbs-down:before{content:\"\\F165\"}.fa-youtube-square:before{content:\"\\F166\"}.fa-youtube:before{content:\"\\F167\"}.fa-xing:before{content:\"\\F168\"}.fa-xing-square:before{content:\"\\F169\"}.fa-youtube-play:before{content:\"\\F16A\"}.fa-dropbox:before{content:\"\\F16B\"}.fa-stack-overflow:before{content:\"\\F16C\"}.fa-instagram:before{content:\"\\F16D\"}.fa-flickr:before{content:\"\\F16E\"}.fa-adn:before{content:\"\\F170\"}.fa-bitbucket:before{content:\"\\F171\"}.fa-bitbucket-square:before{content:\"\\F172\"}.fa-tumblr:before{content:\"\\F173\"}.fa-tumblr-square:before{content:\"\\F174\"}.fa-long-arrow-down:before{content:\"\\F175\"}.fa-long-arrow-up:before{content:\"\\F176\"}.fa-long-arrow-left:before{content:\"\\F177\"}.fa-long-arrow-right:before{content:\"\\F178\"}.fa-apple:before{content:\"\\F179\"}.fa-windows:before{content:\"\\F17A\"}.fa-android:before{content:\"\\F17B\"}.fa-linux:before{content:\"\\F17C\"}.fa-dribbble:before{content:\"\\F17D\"}.fa-skype:before{content:\"\\F17E\"}.fa-foursquare:before{content:\"\\F180\"}.fa-trello:before{content:\"\\F181\"}.fa-female:before{content:\"\\F182\"}.fa-male:before{content:\"\\F183\"}.fa-gittip:before,.fa-gratipay:before{content:\"\\F184\"}.fa-sun-o:before{content:\"\\F185\"}.fa-moon-o:before{content:\"\\F186\"}.fa-archive:before{content:\"\\F187\"}.fa-bug:before{content:\"\\F188\"}.fa-vk:before{content:\"\\F189\"}.fa-weibo:before{content:\"\\F18A\"}.fa-renren:before{content:\"\\F18B\"}.fa-pagelines:before{content:\"\\F18C\"}.fa-stack-exchange:before{content:\"\\F18D\"}.fa-arrow-circle-o-right:before{content:\"\\F18E\"}.fa-arrow-circle-o-left:before{content:\"\\F190\"}.fa-toggle-left:before,.fa-caret-square-o-left:before{content:\"\\F191\"}.fa-dot-circle-o:before{content:\"\\F192\"}.fa-wheelchair:before{content:\"\\F193\"}.fa-vimeo-square:before{content:\"\\F194\"}.fa-turkish-lira:before,.fa-try:before{content:\"\\F195\"}.fa-plus-square-o:before{content:\"\\F196\"}.fa-space-shuttle:before{content:\"\\F197\"}.fa-slack:before{content:\"\\F198\"}.fa-envelope-square:before{content:\"\\F199\"}.fa-wordpress:before{content:\"\\F19A\"}.fa-openid:before{content:\"\\F19B\"}.fa-institution:before,.fa-bank:before,.fa-university:before{content:\"\\F19C\"}.fa-mortar-board:before,.fa-graduation-cap:before{content:\"\\F19D\"}.fa-yahoo:before{content:\"\\F19E\"}.fa-google:before{content:\"\\F1A0\"}.fa-reddit:before{content:\"\\F1A1\"}.fa-reddit-square:before{content:\"\\F1A2\"}.fa-stumbleupon-circle:before{content:\"\\F1A3\"}.fa-stumbleupon:before{content:\"\\F1A4\"}.fa-delicious:before{content:\"\\F1A5\"}.fa-digg:before{content:\"\\F1A6\"}.fa-pied-piper-pp:before{content:\"\\F1A7\"}.fa-pied-piper-alt:before{content:\"\\F1A8\"}.fa-drupal:before{content:\"\\F1A9\"}.fa-joomla:before{content:\"\\F1AA\"}.fa-language:before{content:\"\\F1AB\"}.fa-fax:before{content:\"\\F1AC\"}.fa-building:before{content:\"\\F1AD\"}.fa-child:before{content:\"\\F1AE\"}.fa-paw:before{content:\"\\F1B0\"}.fa-spoon:before{content:\"\\F1B1\"}.fa-cube:before{content:\"\\F1B2\"}.fa-cubes:before{content:\"\\F1B3\"}.fa-behance:before{content:\"\\F1B4\"}.fa-behance-square:before{content:\"\\F1B5\"}.fa-steam:before{content:\"\\F1B6\"}.fa-steam-square:before{content:\"\\F1B7\"}.fa-recycle:before{content:\"\\F1B8\"}.fa-automobile:before,.fa-car:before{content:\"\\F1B9\"}.fa-cab:before,.fa-taxi:before{content:\"\\F1BA\"}.fa-tree:before{content:\"\\F1BB\"}.fa-spotify:before{content:\"\\F1BC\"}.fa-deviantart:before{content:\"\\F1BD\"}.fa-soundcloud:before{content:\"\\F1BE\"}.fa-database:before{content:\"\\F1C0\"}.fa-file-pdf-o:before{content:\"\\F1C1\"}.fa-file-word-o:before{content:\"\\F1C2\"}.fa-file-excel-o:before{content:\"\\F1C3\"}.fa-file-powerpoint-o:before{content:\"\\F1C4\"}.fa-file-photo-o:before,.fa-file-picture-o:before,.fa-file-image-o:before{content:\"\\F1C5\"}.fa-file-zip-o:before,.fa-file-archive-o:before{content:\"\\F1C6\"}.fa-file-sound-o:before,.fa-file-audio-o:before{content:\"\\F1C7\"}.fa-file-movie-o:before,.fa-file-video-o:before{content:\"\\F1C8\"}.fa-file-code-o:before{content:\"\\F1C9\"}.fa-vine:before{content:\"\\F1CA\"}.fa-codepen:before{content:\"\\F1CB\"}.fa-jsfiddle:before{content:\"\\F1CC\"}.fa-life-bouy:before,.fa-life-buoy:before,.fa-life-saver:before,.fa-support:before,.fa-life-ring:before{content:\"\\F1CD\"}.fa-circle-o-notch:before{content:\"\\F1CE\"}.fa-ra:before,.fa-resistance:before,.fa-rebel:before{content:\"\\F1D0\"}.fa-ge:before,.fa-empire:before{content:\"\\F1D1\"}.fa-git-square:before{content:\"\\F1D2\"}.fa-git:before{content:\"\\F1D3\"}.fa-y-combinator-square:before,.fa-yc-square:before,.fa-hacker-news:before{content:\"\\F1D4\"}.fa-tencent-weibo:before{content:\"\\F1D5\"}.fa-qq:before{content:\"\\F1D6\"}.fa-wechat:before,.fa-weixin:before{content:\"\\F1D7\"}.fa-send:before,.fa-paper-plane:before{content:\"\\F1D8\"}.fa-send-o:before,.fa-paper-plane-o:before{content:\"\\F1D9\"}.fa-history:before{content:\"\\F1DA\"}.fa-circle-thin:before{content:\"\\F1DB\"}.fa-header:before{content:\"\\F1DC\"}.fa-paragraph:before{content:\"\\F1DD\"}.fa-sliders:before{content:\"\\F1DE\"}.fa-share-alt:before{content:\"\\F1E0\"}.fa-share-alt-square:before{content:\"\\F1E1\"}.fa-bomb:before{content:\"\\F1E2\"}.fa-soccer-ball-o:before,.fa-futbol-o:before{content:\"\\F1E3\"}.fa-tty:before{content:\"\\F1E4\"}.fa-binoculars:before{content:\"\\F1E5\"}.fa-plug:before{content:\"\\F1E6\"}.fa-slideshare:before{content:\"\\F1E7\"}.fa-twitch:before{content:\"\\F1E8\"}.fa-yelp:before{content:\"\\F1E9\"}.fa-newspaper-o:before{content:\"\\F1EA\"}.fa-wifi:before{content:\"\\F1EB\"}.fa-calculator:before{content:\"\\F1EC\"}.fa-paypal:before{content:\"\\F1ED\"}.fa-google-wallet:before{content:\"\\F1EE\"}.fa-cc-visa:before{content:\"\\F1F0\"}.fa-cc-mastercard:before{content:\"\\F1F1\"}.fa-cc-discover:before{content:\"\\F1F2\"}.fa-cc-amex:before{content:\"\\F1F3\"}.fa-cc-paypal:before{content:\"\\F1F4\"}.fa-cc-stripe:before{content:\"\\F1F5\"}.fa-bell-slash:before{content:\"\\F1F6\"}.fa-bell-slash-o:before{content:\"\\F1F7\"}.fa-trash:before{content:\"\\F1F8\"}.fa-copyright:before{content:\"\\F1F9\"}.fa-at:before{content:\"\\F1FA\"}.fa-eyedropper:before{content:\"\\F1FB\"}.fa-paint-brush:before{content:\"\\F1FC\"}.fa-birthday-cake:before{content:\"\\F1FD\"}.fa-area-chart:before{content:\"\\F1FE\"}.fa-pie-chart:before{content:\"\\F200\"}.fa-line-chart:before{content:\"\\F201\"}.fa-lastfm:before{content:\"\\F202\"}.fa-lastfm-square:before{content:\"\\F203\"}.fa-toggle-off:before{content:\"\\F204\"}.fa-toggle-on:before{content:\"\\F205\"}.fa-bicycle:before{content:\"\\F206\"}.fa-bus:before{content:\"\\F207\"}.fa-ioxhost:before{content:\"\\F208\"}.fa-angellist:before{content:\"\\F209\"}.fa-cc:before{content:\"\\F20A\"}.fa-shekel:before,.fa-sheqel:before,.fa-ils:before{content:\"\\F20B\"}.fa-meanpath:before{content:\"\\F20C\"}.fa-buysellads:before{content:\"\\F20D\"}.fa-connectdevelop:before{content:\"\\F20E\"}.fa-dashcube:before{content:\"\\F210\"}.fa-forumbee:before{content:\"\\F211\"}.fa-leanpub:before{content:\"\\F212\"}.fa-sellsy:before{content:\"\\F213\"}.fa-shirtsinbulk:before{content:\"\\F214\"}.fa-simplybuilt:before{content:\"\\F215\"}.fa-skyatlas:before{content:\"\\F216\"}.fa-cart-plus:before{content:\"\\F217\"}.fa-cart-arrow-down:before{content:\"\\F218\"}.fa-diamond:before{content:\"\\F219\"}.fa-ship:before{content:\"\\F21A\"}.fa-user-secret:before{content:\"\\F21B\"}.fa-motorcycle:before{content:\"\\F21C\"}.fa-street-view:before{content:\"\\F21D\"}.fa-heartbeat:before{content:\"\\F21E\"}.fa-venus:before{content:\"\\F221\"}.fa-mars:before{content:\"\\F222\"}.fa-mercury:before{content:\"\\F223\"}.fa-intersex:before,.fa-transgender:before{content:\"\\F224\"}.fa-transgender-alt:before{content:\"\\F225\"}.fa-venus-double:before{content:\"\\F226\"}.fa-mars-double:before{content:\"\\F227\"}.fa-venus-mars:before{content:\"\\F228\"}.fa-mars-stroke:before{content:\"\\F229\"}.fa-mars-stroke-v:before{content:\"\\F22A\"}.fa-mars-stroke-h:before{content:\"\\F22B\"}.fa-neuter:before{content:\"\\F22C\"}.fa-genderless:before{content:\"\\F22D\"}.fa-facebook-official:before{content:\"\\F230\"}.fa-pinterest-p:before{content:\"\\F231\"}.fa-whatsapp:before{content:\"\\F232\"}.fa-server:before{content:\"\\F233\"}.fa-user-plus:before{content:\"\\F234\"}.fa-user-times:before{content:\"\\F235\"}.fa-hotel:before,.fa-bed:before{content:\"\\F236\"}.fa-viacoin:before{content:\"\\F237\"}.fa-train:before{content:\"\\F238\"}.fa-subway:before{content:\"\\F239\"}.fa-medium:before{content:\"\\F23A\"}.fa-yc:before,.fa-y-combinator:before{content:\"\\F23B\"}.fa-optin-monster:before{content:\"\\F23C\"}.fa-opencart:before{content:\"\\F23D\"}.fa-expeditedssl:before{content:\"\\F23E\"}.fa-battery-4:before,.fa-battery-full:before{content:\"\\F240\"}.fa-battery-3:before,.fa-battery-three-quarters:before{content:\"\\F241\"}.fa-battery-2:before,.fa-battery-half:before{content:\"\\F242\"}.fa-battery-1:before,.fa-battery-quarter:before{content:\"\\F243\"}.fa-battery-0:before,.fa-battery-empty:before{content:\"\\F244\"}.fa-mouse-pointer:before{content:\"\\F245\"}.fa-i-cursor:before{content:\"\\F246\"}.fa-object-group:before{content:\"\\F247\"}.fa-object-ungroup:before{content:\"\\F248\"}.fa-sticky-note:before{content:\"\\F249\"}.fa-sticky-note-o:before{content:\"\\F24A\"}.fa-cc-jcb:before{content:\"\\F24B\"}.fa-cc-diners-club:before{content:\"\\F24C\"}.fa-clone:before{content:\"\\F24D\"}.fa-balance-scale:before{content:\"\\F24E\"}.fa-hourglass-o:before{content:\"\\F250\"}.fa-hourglass-1:before,.fa-hourglass-start:before{content:\"\\F251\"}.fa-hourglass-2:before,.fa-hourglass-half:before{content:\"\\F252\"}.fa-hourglass-3:before,.fa-hourglass-end:before{content:\"\\F253\"}.fa-hourglass:before{content:\"\\F254\"}.fa-hand-grab-o:before,.fa-hand-rock-o:before{content:\"\\F255\"}.fa-hand-stop-o:before,.fa-hand-paper-o:before{content:\"\\F256\"}.fa-hand-scissors-o:before{content:\"\\F257\"}.fa-hand-lizard-o:before{content:\"\\F258\"}.fa-hand-spock-o:before{content:\"\\F259\"}.fa-hand-pointer-o:before{content:\"\\F25A\"}.fa-hand-peace-o:before{content:\"\\F25B\"}.fa-trademark:before{content:\"\\F25C\"}.fa-registered:before{content:\"\\F25D\"}.fa-creative-commons:before{content:\"\\F25E\"}.fa-gg:before{content:\"\\F260\"}.fa-gg-circle:before{content:\"\\F261\"}.fa-tripadvisor:before{content:\"\\F262\"}.fa-odnoklassniki:before{content:\"\\F263\"}.fa-odnoklassniki-square:before{content:\"\\F264\"}.fa-get-pocket:before{content:\"\\F265\"}.fa-wikipedia-w:before{content:\"\\F266\"}.fa-safari:before{content:\"\\F267\"}.fa-chrome:before{content:\"\\F268\"}.fa-firefox:before{content:\"\\F269\"}.fa-opera:before{content:\"\\F26A\"}.fa-internet-explorer:before{content:\"\\F26B\"}.fa-tv:before,.fa-television:before{content:\"\\F26C\"}.fa-contao:before{content:\"\\F26D\"}.fa-500px:before{content:\"\\F26E\"}.fa-amazon:before{content:\"\\F270\"}.fa-calendar-plus-o:before{content:\"\\F271\"}.fa-calendar-minus-o:before{content:\"\\F272\"}.fa-calendar-times-o:before{content:\"\\F273\"}.fa-calendar-check-o:before{content:\"\\F274\"}.fa-industry:before{content:\"\\F275\"}.fa-map-pin:before{content:\"\\F276\"}.fa-map-signs:before{content:\"\\F277\"}.fa-map-o:before{content:\"\\F278\"}.fa-map:before{content:\"\\F279\"}.fa-commenting:before{content:\"\\F27A\"}.fa-commenting-o:before{content:\"\\F27B\"}.fa-houzz:before{content:\"\\F27C\"}.fa-vimeo:before{content:\"\\F27D\"}.fa-black-tie:before{content:\"\\F27E\"}.fa-fonticons:before{content:\"\\F280\"}.fa-reddit-alien:before{content:\"\\F281\"}.fa-edge:before{content:\"\\F282\"}.fa-credit-card-alt:before{content:\"\\F283\"}.fa-codiepie:before{content:\"\\F284\"}.fa-modx:before{content:\"\\F285\"}.fa-fort-awesome:before{content:\"\\F286\"}.fa-usb:before{content:\"\\F287\"}.fa-product-hunt:before{content:\"\\F288\"}.fa-mixcloud:before{content:\"\\F289\"}.fa-scribd:before{content:\"\\F28A\"}.fa-pause-circle:before{content:\"\\F28B\"}.fa-pause-circle-o:before{content:\"\\F28C\"}.fa-stop-circle:before{content:\"\\F28D\"}.fa-stop-circle-o:before{content:\"\\F28E\"}.fa-shopping-bag:before{content:\"\\F290\"}.fa-shopping-basket:before{content:\"\\F291\"}.fa-hashtag:before{content:\"\\F292\"}.fa-bluetooth:before{content:\"\\F293\"}.fa-bluetooth-b:before{content:\"\\F294\"}.fa-percent:before{content:\"\\F295\"}.fa-gitlab:before{content:\"\\F296\"}.fa-wpbeginner:before{content:\"\\F297\"}.fa-wpforms:before{content:\"\\F298\"}.fa-envira:before{content:\"\\F299\"}.fa-universal-access:before{content:\"\\F29A\"}.fa-wheelchair-alt:before{content:\"\\F29B\"}.fa-question-circle-o:before{content:\"\\F29C\"}.fa-blind:before{content:\"\\F29D\"}.fa-audio-description:before{content:\"\\F29E\"}.fa-volume-control-phone:before{content:\"\\F2A0\"}.fa-braille:before{content:\"\\F2A1\"}.fa-assistive-listening-systems:before{content:\"\\F2A2\"}.fa-asl-interpreting:before,.fa-american-sign-language-interpreting:before{content:\"\\F2A3\"}.fa-deafness:before,.fa-hard-of-hearing:before,.fa-deaf:before{content:\"\\F2A4\"}.fa-glide:before{content:\"\\F2A5\"}.fa-glide-g:before{content:\"\\F2A6\"}.fa-signing:before,.fa-sign-language:before{content:\"\\F2A7\"}.fa-low-vision:before{content:\"\\F2A8\"}.fa-viadeo:before{content:\"\\F2A9\"}.fa-viadeo-square:before{content:\"\\F2AA\"}.fa-snapchat:before{content:\"\\F2AB\"}.fa-snapchat-ghost:before{content:\"\\F2AC\"}.fa-snapchat-square:before{content:\"\\F2AD\"}.fa-pied-piper:before{content:\"\\F2AE\"}.fa-first-order:before{content:\"\\F2B0\"}.fa-yoast:before{content:\"\\F2B1\"}.fa-themeisle:before{content:\"\\F2B2\"}.fa-google-plus-circle:before,.fa-google-plus-official:before{content:\"\\F2B3\"}.fa-fa:before,.fa-font-awesome:before{content:\"\\F2B4\"}.sr-only{position:absolute;width:1px;height:1px;padding:0;margin:-1px;overflow:hidden;clip:rect(0, 0, 0, 0);border:0}.sr-only-focusable:active,.sr-only-focusable:focus{position:static;width:auto;height:auto;margin:0;overflow:visible;clip:auto}\n", ""]);
	
	// exports


/***/ },
/* 72 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "25a32416abee198dd821b0b17a198a8f.eot";

/***/ },
/* 73 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "25a32416abee198dd821b0b17a198a8f.eot";

/***/ },
/* 74 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "e6cf7c6ec7c2d6f670ae9d762604cb0b.woff2";

/***/ },
/* 75 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "c8ddf1e5e5bf3682bc7bebf30f394148.woff";

/***/ },
/* 76 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "1dc35d25e61d819a9c357074014867ab.ttf";

/***/ },
/* 77 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "d7c639084f684d66a1bc66855d193ed8.svg";

/***/ },
/* 78 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(79);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(12)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../css-loader/index.js!./material-icons.css", function() {
				var newContent = require("!!./../../css-loader/index.js!./material-icons.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 79 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "@font-face {\n  font-family: 'Material Icons';\n  font-style: normal;\n  font-weight: 400;\n  src: url(" + __webpack_require__(80) + "); /* For IE6-8 */\n  src: local('Material Icons'),\n       local('MaterialIcons-Regular'),\n       url(" + __webpack_require__(81) + ") format('woff2'),\n       url(" + __webpack_require__(82) + ") format('woff'),\n       url(" + __webpack_require__(83) + ") format('truetype');\n}\n\n.material-icons {\n  font-family: 'Material Icons';\n  font-weight: normal;\n  font-style: normal;\n  font-size: 24px;  /* Preferred icon size */\n  display: inline-block;\n  width: 1em;\n  height: 1em;\n  line-height: 1;\n  text-transform: none;\n  letter-spacing: normal;\n  word-wrap: normal;\n  white-space: nowrap;\n  direction: ltr;\n\n  /* Support for all WebKit browsers. */\n  -webkit-font-smoothing: antialiased;\n  /* Support for Safari and Chrome. */\n  text-rendering: optimizeLegibility;\n\n  /* Support for Firefox. */\n  -moz-osx-font-smoothing: grayscale;\n\n  /* Support for IE. */\n  font-feature-settings: 'liga';\n}\n", ""]);
	
	// exports


/***/ },
/* 80 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "e79bfd88537def476913f3ed52f4f4b3.eot";

/***/ },
/* 81 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "570eb83859dc23dd0eec423a49e147fe.woff2";

/***/ },
/* 82 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "012cf6a10129e2275d79d6adac7f3b02.woff";

/***/ },
/* 83 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "a37b0c01c0baf1888ca812cc0508f6e2.ttf";

/***/ },
/* 84 */
/***/ function(module, exports, __webpack_require__) {

	// style-loader: Adds some css to the DOM by adding a <style> tag
	
	// load the styles
	var content = __webpack_require__(85);
	if(typeof content === 'string') content = [[module.id, content, '']];
	// add the styles to the DOM
	var update = __webpack_require__(12)(content, {});
	if(content.locals) module.exports = content.locals;
	// Hot Module Replacement
	if(false) {
		// When the styles change, update the <style> tags
		if(!content.locals) {
			module.hot.accept("!!./../../../css-loader/index.js!./index.css", function() {
				var newContent = require("!!./../../../css-loader/index.js!./index.css");
				if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
				update(newContent);
			});
		}
		// When the module is disposed, remove the <style> tags
		module.hot.dispose(function() { update(); });
	}

/***/ },
/* 85 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	exports.i(__webpack_require__(86), "");
	exports.i(__webpack_require__(87), "");
	exports.i(__webpack_require__(88), "");
	exports.i(__webpack_require__(89), "");
	exports.i(__webpack_require__(96), "");
	exports.i(__webpack_require__(106), "");
	exports.i(__webpack_require__(107), "");
	exports.i(__webpack_require__(108), "");
	exports.i(__webpack_require__(109), "");
	exports.i(__webpack_require__(110), "");
	exports.i(__webpack_require__(111), "");
	exports.i(__webpack_require__(112), "");
	exports.i(__webpack_require__(113), "");
	exports.i(__webpack_require__(120), "");
	exports.i(__webpack_require__(121), "");
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n\nbody {\n  margin: 0;\n  padding: 0;\n  background: #E0E0E0;\n  overflow: hidden;\n  font-family: sans-serif;\n}\n\n\n.p-ApplicationShell.p-Widget {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  font-size: 14px;\n}\n\n\n#p-top-panel {\n  display: flex;\n  min-height: 24px;\n}\n\n\n.jp-Document {\n  min-width: 120px;\n  min-height: 120px;\n  outline: none;\n}\n\n\n.jp-NotebookContainer-widget {\n  flex: 0 0 auto;\n}\n\n\n.jp-Notebook {\n  flex: 1 1 auto;\n}\n\n\n\n.jp-FileBrowser {\n  min-width: 300px;\n}\n\n\n#p-right-stack {\n  border-left: 1px solid #BDBDBD;\n}\n\n#p-left-stack {\n  border-right: 1px solid #BDBDBD;\n}\n\n.p-SideBar {\n  min-width: 36px;\n  max-width: 36px;\n  font-size: 14px;\n  color: #777777;\n  background: white;\n}\n\n\n.p-SideBar.p-Widget {\n  overflow: visible;\n}\n\n\n.p-SideBar.p-mod-left {\n  border-right: 1px solid #BDBDBD;\n}\n\n\n.p-SideBar.p-mod-right {\n  border-left: 1px solid #BDBDBD;\n}\n\n\n.p-SideBar-content {\n  height: 35px;\n  transform-origin: 0 0 0;\n}\n\n\n.p-SideBar.p-mod-left > .p-SideBar-content {\n  flex-direction: row-reverse;\n  transform: rotate(-90deg) translateX(-100%);\n}\n\n\n.p-SideBar.p-mod-right > .p-SideBar-content {\n  flex-direction: row;\n  transform: rotate(90deg) translateY(-100%);\n}\n\n\n.p-SideBar-button {\n  padding: 0 18px;\n  line-height: 35px;\n}\n\n\n.p-SideBar-button:hover:not(.p-mod-current) {\n  background: #FAFAFA;\n}\n\n\n.p-SideBar-button.p-mod-current {\n  color: #2196F3;\n  background: #FAFAFA;\n}\n\n\n.p-SideBar.p-mod-left .p-SideBar-button {\n  border-left: 1px solid #BDBDBD;\n}\n\n\n.p-SideBar.p-mod-right .p-SideBar-button {\n  border-right: 1px solid #BDBDBD;\n}\n\n\n#p-main-dock-panel {\n  padding: 8px;\n}\n\n\n.p-DockTabPanel {\n  border-top: none;\n}\n\n\n.p-DockTabPanel > .p-StackedPanel {\n  background: white;\n  border-left: 1px solid #BDBDBD;\n  border-right: 1px solid #BDBDBD;\n  border-bottom: 1px solid #BDBDBD;\n}\n\n\n.p-DockPanel-overlay {\n  background: rgba(33, 150, 243, 0.1);\n  border: 1px dashed #2196F3;\n}\n\n\n.p-DockPanel-overlay.p-mod-root-top,\n.p-DockPanel-overlay.p-mod-root-left,\n.p-DockPanel-overlay.p-mod-root-right,\n.p-DockPanel-overlay.p-mod-root-bottom,\n.p-DockPanel-overlay.p-mod-root-center {\n  border-width: 2px;\n}\n\n\n.p-TabBar {\n  min-height: 24px;\n  max-height: 24px;\n  color: #777777;\n  font-size: 13px;\n}\n\n\n/* increase specificity to override default */\n.p-TabBar > .p-TabBar-header {\n  flex: 0 0 1px;\n}\n\n\n.p-TabBar-content {\n  min-width: 0;\n  /* max-height: 27px; */\n  padding-right: 1px;\n}\n\n\n/* increase specificity to override default */\n.p-TabBar > .p-TabBar-footer {\n  flex: 0 0 1px;\n  background: #BDBDBD;\n}\n\n\n.p-TabBar-tab {\n  flex-basis: 144px;\n  min-height: 23px;\n  max-height: 23px;\n  min-width: 35px;\n  padding: 0px 7px;\n  background: #EEEEEE;\n  border: 1px solid #BDBDBD;\n  transform: translateY(-1px);\n  border-bottom: none;\n  margin-right: -1px;\n}\n\n\n.p-TabBar-tab.p-mod-current {\n  min-height: 24px;\n  max-height: 24px;\n  background: #FFFFFF;\n  border-top: 1px solid #2196F3;\n}\n\n\n.p-TabBar-tab:hover:not(.p-mod-current) {\n  background: #FAFAFA;\n}\n\n\n.p-TabBar-tabIcon,\n.p-TabBar-tabText,\n.p-TabBar-tabCloseIcon {\n  line-height: 24px;\n}\n\n\n.p-TabBar-tab.p-mod-closable > .p-TabBar-tabCloseIcon {\n  margin-left: 4px;\n}\n\n\n.p-TabBar-tab.p-mod-closable > .p-TabBar-tabCloseIcon:before {\n  font-family: FontAwesome;\n  content: '\\F00D'; /* close */\n}\n\n\n.p-TabBar-tab.p-mod-closable.jp-mod-dirty > .p-TabBar-tabCloseIcon:before {\n  font-family: FontAwesome;\n  content: '\\F111'; /* circle */\n  font-size: 10px;\n}\n\n\n.p-TabBar-tab.p-mod-drag-image {\n  min-height: 24px;\n  min-width: 124px;\n  color: #777777;\n  background: white;\n  border: 1px solid #BDBDBD;\n  border-top: 1px solid #2196F3;\n  font-size: 14px;\n  box-shadow: 1px 1px 2px rgba(0, 0, 1, 0.1);\n  transform: translateX(-40%) translateY(-58%);\n}\n\n\n.p-MenuBar {\n  padding-left: 5px;\n  background: #FAFAFA;\n  color: rgba(0, 0, 0, 0.87);\n  font-size: 14px;\n}\n\n\n.p-MenuBar-menu {\n  transform: translateY(-1px);\n}\n\n\n.p-MenuBar-item {\n  padding: 4px 8px;\n  border-left: 1px solid transparent;\n  border-right: 1px solid transparent;\n}\n\n\n.p-MenuBar-item.p-mod-active {\n  background: #E5E5E5;\n}\n\n\n.p-MenuBar-item.p-mod-disabled {\n  color: rgba(0, 0, 0, 0.26);\n}\n\n\n.p-MenuBar-item.p-type-separator {\n  margin: 2px;\n  padding: 0;\n  border: none;\n  border-left: 1px solid #DDDDDD;\n}\n\n\n.p-MenuBar.p-mod-active .p-MenuBar-item.p-mod-active {\n  z-index: 10001;\n  background: white;\n  border-left: 1px solid #C0C0C0;\n  border-right: 1px solid #C0C0C0;\n  box-shadow: 0px 0px 6px rgba(0, 0, 0, 0.2);\n}\n\n\n.p-Menu {\n  z-index: 10000;\n  padding: 3px 0px;\n  background: white;\n  color: rgba(0, 0, 0, 0.87);\n  border: 1px solid #C0C0C0;\n  font-size: 14px;\n  box-shadow: 0px 1px 6px rgba(0, 0, 0, 0.2);\n}\n\n\n.p-Menu-item.p-mod-active {\n  background: #E5E5E5;\n}\n\n\n.p-Menu-item.p-mod-disabled {\n  color: rgba(0, 0, 0, 0.26);\n}\n\n\n.p-Menu-itemIcon {\n  width: 21px;\n  padding: 4px 2px;\n}\n\n\n.p-Menu-itemText {\n  padding: 4px 35px 4px 2px;\n}\n\n\n.p-Menu-itemShortcut {\n  padding: 4px 0px;\n}\n\n\n.p-Menu-itemSubmenuIcon {\n  width: 16px;\n  padding: 4px 0px;\n}\n\n\n.p-Menu-item.p-type-separator > span {\n  padding: 0;\n  height: 9px;\n}\n\n\n.p-Menu-item.p-type-separator > span::after {\n  content: '';\n  display: block;\n  position: relative;\n  top: 4px;\n  border-top: 1px solid #DDDDDD;\n}\n\n\n.p-Menu-itemIcon::before,\n.p-Menu-itemSubmenuIcon::before {\n  font-family: FontAwesome;\n}\n\n\n.p-Menu-item.p-type-check.p-mod-checked > .p-Menu-itemIcon::before {\n  content: '\\F00C';\n}\n\n\n.p-Menu-item.p-type-submenu > .p-Menu-itemSubmenuIcon::before {\n  content: '\\F0DA';\n}\n\n\n.p-Widget.jp-Cell.jp-CodeCell.jp-mod-collapsed.jp-mod-readOnly {\n  padding-left: 5px;\n  padding-right: 5px;\n  border-width: 1px;\n  border-style: solid;\n  border-color: transparent;\n  outline: none;\n  background: transparent;\n  border-color: transparent;\n}\n\n\n.jp-MainAreaLandscapeIcon {\n  background-repeat: no-repeat;\n  margin-right: 2px;\n  width: 22px;\n}\n\n\n.jp-MainAreaPortraitIcon {\n  background-position: 0 1px;\n  background-repeat: no-repeat;\n  margin-right: 0;\n  width: 20px;\n}\n", ""]);
	
	// exports


/***/ },
/* 86 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Console-panel {\n  display: flex;\n  flex: 1 1 auto;\n  flex-direction: column;\n}\n\n\n.p-Widget.jp-Console {\n  overflow: auto;\n}", ""]);
	
	// exports


/***/ },
/* 87 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Notebook-panel {\n  display: flex;\n  flex-direction: column;\n}\n\n\n.p-Widget.jp-NBToolbar {\n  flex: 0 0 auto;\n}\n\n\n.p-Widget.jp-Notebook-container {\n  flex: 1 1 auto;\n}\n\n\n.jp-InputArea {\n  display: flex;\n  flex-direction: row;\n}\n\n\n.jp-InputArea-prompt {\n  flex-grow: 0;\n  flex-shrink: 0;\n  padding-top: 8px !important;\n}\n\n\n.jp-InputArea-editor {\n  flex-grow: 1;\n  flex-shrink: 1;\n}\n\n\n.jp-MarkdownCell-content.p-Widget {\n  padding: 7px;\n  user-select: text;\n  -moz-user-select: text;\n  -webkit-user-select: text;\n  -ms-user-select: text;\n}\n\n\n.jp-MarkdownCell-content.p-Widget h1 {\n  font-size: 26px;\n  line-height: 1.0;\n  margin: 14px 0 0 0;\n}\n\n\n.jp-MarkdownCell-content.p-Widget h2 {\n  font-size: 22px;\n  line-height: 1.0;\n  margin: 14px 0 0 0;\n}\n\n\n.jp-MarkdownCell-content.p-Widget h3 {\n  font-size: 18px;\n  line-height: 1.0;\n  margin: 14px 0 0 0;\n}\n\n\n.jp-MarkdownCell-content.p-Widget h4 {\n  font-size: 14px;\n  line-height: 1.0;\n  margin: 14px 0 0 0;\n}\n\n\n.jp-MarkdownCell-content.p-Widget h5 {\n  font-size: 14px;\n  font-style: italic;\n  line-height: 1.0;\n  margin: 14px 0 0 0;\n}\n\n\n.jp-MarkdownCell-content.p-Widget h6 {\n  font-size: 14px;\n  font-style: italic;\n  line-height: 1.0;\n  margin: 14px 0 0 0;\n}\n\n\n.jp-MarkdownCell-content.p-Widget p {\n  font-size: 14px;\n  line-height: 20px;\n  margin: 0 0 0 0;\n}\n\n\n.jp-MarkdownCell-content.p-Widget li {\n  line-height: 20px;\n  margin: 14px 0 0 0;\n}\n\n\n.jp-OutputArea-result.p-Widget {\n  user-select: text;\n  -moz-user-select: text;\n  -webkit-user-select: text;\n  -ms-user-select: text;\n}\n", ""]);
	
	// exports


/***/ },
/* 88 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n/* Increased specificity in case phosphor css is loaded later. */\n.p-Widget.jp-Notebook {\n  margin-top: 20px;\n  min-width: 50px;\n  min-height: 50px;\n  outline: none;\n}\n\n\n.p-Widget.jp-Notebook-panel {\n  height: 100%;\n}\n\n\n.p-Widget.jp-Notebook-container {\n  overflow: auto;\n  padding-left: 10px;\n  padding-right: 10px;\n  padding-bottom: 20px;\n}\n\n\n.jp-InputArea-prompt {\n  flex-basis: 90px;\n  color: #303F9F;\n  font-family: monospace;\n  padding: 0.4em;\n  text-align: right;\n  line-height: 20px;\n  font-size: 14px;\n}\n\n\n.jp-InputArea-editor {\n  height: auto;\n  min-height: 2em;\n}\n\n\n.jp-CellEditor {\n  border: 1px solid #cfcfcf;\n  border-radius: 2px;\n  background: #f7f7f7;\n  line-height: 1.2em;\n  padding: 4px;\n}\n\n\n.jp-MarkdownCell {\n  outline: 0;\n}\n\n\n.jp-MarkdownCell.jp-mod-rendered {\n  padding-left: 100px;\n}\n\n\n.jp-MarkdownCell-renderer {\n  padding-left: 4px;\n}\n\n\n.jp-OutputArea {\n  background: none;\n}\n\n\n.jp-Output {\n  display: flex;\n  flex-direction: row;\n}\n\n\n.jp-Output-executeResult {\n  margin-left: 0px;\n  flex: 1 1 auto;\n}\n\n\n.jp-Output-prompt {\n  color: #D84315;\n  font-family: monospace;\n  text-align: right;\n  vertical-align: middle;\n  padding: 0.4em;\n  font-size: 14px;\n  flex: 0 0 90px;\n  box-sizing: border-box;\n}\n\n\n.jp-Output-result {\n  padding: 0.4em;\n}\n\n\n.jp-Notebook .jp-Output pre {\n  border: none;\n  margin: 1px 0 0 5px;\n  overflow-x: auto;\n  overflow-y: auto;\n  word-break: break-all;\n  word-wrap: break-word;\n  white-space: pre-wrap;\n}\n\n\n.jp-Output-stderr {\n  background: #fdd;\n}\n\n\n.jp-Notebook.jp-mod-commandMode .jp-Notebook-cell.jp-mod-active.jp-mod-selected {\n  border-color: #ABABAB;\n  border-left-width: 1px;\n  background: linear-gradient(to right, #42A5F5 -40px, #42A5F5 5px, transparent 5px, transparent 100%);\n}\n\n\n.jp-Notebook.jp-mod-commandMode .jp-Notebook-cell.jp-mod-multiSelected.jp-mod-active {\n  background: linear-gradient(to right, #42A5F5 -40px, #42A5F5 7px, #E3F2FD 7px, #E3F2FD 100%);\n}\n\n\n.jp-Notebook.jp-mod-commandMode .jp-Notebook-cell.jp-mod-selected {\n  background: #E3F2FD;\n}\n\n\n.jp-Notebook.jp-mod-editMode .jp-Notebook-cell.jp-mod-active {\n  border-color: #66BB6A;\n  border-left-width: 1px;\n  background: linear-gradient(to right, #66BB6A -40px, #66BB6A 5px, transparent 5px, transparent 100%);\n}\n\n\n.jp-Cell {\n  padding-top: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n  padding-right: 5px;\n  border-width: 1px;\n  border-style: solid;\n  border-color: transparent;\n  outline: none;\n}\n\n.jp-NBToolbar {\n    display: flex;\n    flex-direction: row;\n    border-bottom: 1px solid #E0E0E0;\n    height: 24px;\n}\n\n\n.jp-NBToolbar > .jp-NBToolbar-item {\n    flex: 0 0 auto;\n    padding-left: 8px;\n    padding-right: 8px;\n    vertical-align: middle;\n    font-size: 14px;\n    color: #616161;\n    line-height: 23px;\n}\n\n\n.jp-NBToolbar-item.jp-NBToolbar-button,\n.jp-NBToolbar-item.jp-NBToolbar-kernelIndicator {\n    font-family: FontAwesome;\n    text-align: center;\n    display: inline-block;\n}\n\n\n.jp-NBToolbar-item.jp-NBToolbar-cellType select {\n    background: #FFFFFF;\n}\n\n.jp-NBToolbar-cellType .jp-NBToolbar-cellTypeDropdown {\n    border: 1px solid #BDBDBD;\n    border-radius: 0;\n    outline: none;\n    width: 100%;\n    font-size: 14px;\n    line-height: 23px;\n    color: #616161;\n}\n\n\n.jp-NBToolbar-item.jp-NBToolbar-kernelName {\n    text-align: right;\n    flex-grow: 1;\n    flex-shrink: 1;\n}\n\n\n.jp-NBToolbar-item.jp-NBToolbar-kernelIndicator {\n    border-right: none;\n}\n\n\n.jp-NBToolbar-button.jp-mod-pressed {\n    background-color: #E0E0E0;\n    box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.5);\n}\n\n\n.jp-NBToolbar-button:hover {\n    background-color: #EEEEEE;\n    box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.5);\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-save::before {\n   content: \"\\F0C7\";  /* Save */\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-insert::before {\n   content: \"\\F067\";  /* Plus */\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-cut::before {\n   content: \"\\F0C4\";  /* Cut */\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-copy::before {\n   content: \"\\F0C5\";  /* Copy */\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-paste::before {\n   content: \"\\F0EA\";  /* Paste */\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-run::before {\n   content: \"\\F051\";  /* Step-forward */\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-interrupt::before {\n   content: \"\\F04D\";  /* Stop */\n}\n\n\n.jp-NBToolbar-button.jp-NBToolbar-restart::before {\n   content: \"\\F01E\";  /* Rotate-right */\n}\n\n\n.jp-NBToolbar-item.jp-NBToolbar-kernelIndicator::before {\n    content: \"\\F10C\";  /* Circle-o */\n}\n\n\n.jp-NBToolbar-item.jp-NBToolbar-kernelIndicator.jp-mod-busy::before {\n    content: \"\\F111\";  /* Circle */\n}\n\n\n.jp-CellEditor > .CodeMirror {\n  line-height: 1.21429em;\n  /* Changed from 1em to our global default */\n  font-size: 14px;\n  height: auto;\n  /* Changed to auto to autogrow */\n  background: none;\n  /* Changed from white to allow our bg to show through */\n}\n\n\n.jp-CellEditor > .CodeMirror-scroll {\n  /*  The CodeMirror docs are a bit fuzzy on if overflow-y should be hidden or visible.*/\n  /*  We have found that if it is visible, vertical scrollbars appear with font size changes.*/\n  overflow-y: hidden;\n  overflow-x: auto;\n}\n\n\n.jp-CellEditor > .CodeMirror-lines {\n  /* In CM2, this used to be 0.4em, but in CM3 it went to 4px. We need the em value because */\n  /* we have set a different line-height and want this to scale with that. */\n  padding: 0.4em;\n}\n\n\n.jp-CellEditor > .CodeMirror-linenumber {\n  padding: 0 8px 0 4px;\n}\n\n\n.jp-CellEditor > .CodeMirror-gutters {\n  border-bottom-left-radius: 2px;\n  border-top-left-radius: 2px;\n}\n\n\n.jp-CellEditor > .CodeMirror pre {\n  /* In CM3 this went to 4px from 0 in CM2. We need the 0 value because of how we size */\n  /* .CodeMirror-lines */\n  padding: 0;\n  border: 0;\n  border-radius: 0;\n}", ""]);
	
	// exports


/***/ },
/* 89 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	exports.i(__webpack_require__(90), "");
	exports.i(__webpack_require__(91), "");
	exports.i(__webpack_require__(92), "");
	exports.i(__webpack_require__(93), "");
	exports.i(__webpack_require__(94), "");
	exports.i(__webpack_require__(95), "");
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n", ""]);
	
	// exports


/***/ },
/* 90 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Dialog {\n  position: absolute;\n  z-index: 10000;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  top: 0px;\n  left: 0px;\n  margin: 0;\n  padding: 0;\n  width: 100%;\n  height: 100%;\n}\n\n\n.jp-Dialog-content {\n  margin-left: auto;\n  margin-right: auto;\n}\n\n\n.jp-Dialog-header {\n\n}\n\n\n.jp-Dialog-footer {\n\n}\n\n\n.jp-Dialog-title {\n  overflow: hidden;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n}\n", ""]);
	
	// exports


/***/ },
/* 91 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-FileBrowser {\n  display: flex;\n  flex-direction: column;\n}\n\n\n.jp-BreadCrumbs {\n  flex: 0 0 auto;\n}\n\n\n.jp-FileButtons {\n  flex: 0 0 auto;\n  display: flex;\n  flex-direction: row;\n}\n\n\n.jp-FileButtons-buttonContent {\n  display: flex;\n  flex-direction: row;\n  align-items: baseline;\n}\n\n\n.jp-FileButtons-buttonIcon {\n  margin-left: auto;\n  margin-right: auto;\n}\n\n\n.jp-DirListing {\n  flex: 1 1 auto;\n  display: flex;\n  flex-direction: column;\n}\n\n\n.jp-DirListing-header {\n  flex: 0 0 auto;\n  display: flex;\n  flex-direction: row;\n  overflow: hidden;\n}\n\n\n.jp-DirListing-content {\n  flex: 1 1 auto;\n  margin: 0;\n  padding: 0;\n  list-style-type: none;\n  overflow: auto;\n}\n\n\n.jp-DirListing-item {\n  display: flex;\n  flex-direction: row;\n}\n", ""]);
	
	// exports


/***/ },
/* 92 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n/*\nWhen drag events occur, `p-mod-override-cursor` is added to the body.\nBecause iframes steal all cursor events, the following two rules are necessary\nto suppress pointer events while resize drags are occuring. There may be a\nbetter solution to this problem.\n*/\nbody.p-mod-override-cursor .jp-IFrame {\n  position: relative;\n}\n\n\nbody.p-mod-override-cursor .jp-IFrame:before {\n  content: '';\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  background: transparent;\n}\n", ""]);
	
	// exports


/***/ },
/* 93 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Completion.jp-mod-outofview {\n  display: none;\n}\n", ""]);
	
	// exports


/***/ },
/* 94 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-TerminalWidget {\n  background: red;\n  padding: 0;\n  margin: 0;\n}\n\n\n.jp-TerminalWidget-body {\n  font-family: \"DejaVu Sans Mono\", \"Liberation Mono\", monospace;\n}\n", ""]);
	
	// exports


/***/ },
/* 95 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n#jp-MainMenu.p-Widget.p-MenuBar {\n   background: white;\n}\n\n#p-top-panel.p-Widget.p-Panel {\n   border-bottom: 1px solid #BDBDBD;\n   background: white;\n   top: 0px;\n   left: 0px;\n   min-height: 28px;\n   max-height: 28px;\n   position: absolute;\n}\n\n.p-MenuBar .p-MenuBar-item {\n  padding: 6px 8px;\n}\n\n.p-MenuBar-itemText {\n  font-size: 13px;\n  color: #777777;\n}\n\n.p-MenuBar-item.p-mod-active > .p-MenuBar-itemText {\n  color: #2196F3;\n}\n", ""]);
	
	// exports


/***/ },
/* 96 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	exports.i(__webpack_require__(97), "");
	exports.i(__webpack_require__(98), "");
	exports.i(__webpack_require__(99), "");
	exports.i(__webpack_require__(100), "");
	exports.i(__webpack_require__(101), "");
	exports.i(__webpack_require__(103), "");
	exports.i(__webpack_require__(104), "");
	exports.i(__webpack_require__(105), "");
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n", ""]);
	
	// exports


/***/ },
/* 97 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-CSVWidget {\n  padding: 1em;\n  overflow: auto;\n}\n\n\n.jp-CSVWidget th,\n.jp-CSVWidget td {\n  border: 1px solid black;\n  padding: 0.2em 0.5em;\n}\n\n.jp-CSVWidget table {\n  border: 1px solid black;\n  border-collapse: collapse;\n}\n", ""]);
	
	// exports


/***/ },
/* 98 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-CodeMirrorWidget {\n  height: 100%;\n}\n\n\n.jp-CodeMirrorWidget > .CodeMirror {\n  line-height: 1.21429em;\n  /* Changed from 1em to our global default */\n  font-size: 14px;\n  height: 100%;\n  /* Changed to auto to autogrow */\n  background: none;\n  /* Changed from white to allow our bg to show through */\n}\n\n\n.jp-CodeMirrorWidget .CodeMirror-scroll {\n  /*  The CodeMirror docs are a bit fuzzy on if overflow-y should be hidden or visible.*/\n  /*  We have found that if it is visible, vertical scrollbars appear with font size changes.*/\n  overflow-y: hidden;\n  overflow-x: auto;\n}\n\n\n.jp-CodeMirrorWidget .CodeMirror-lines {\n  /* In CM2, this used to be 0.4em, but in CM3 it went to 4px. We need the em value because */\n  /* we have set a different line-height and want this to scale with that. */\n  padding: 0.4em;\n}\n\n\n.jp-CodeMirrorWidget .CodeMirror-linenumber {\n  padding: 0 8px 0 4px;\n}\n\n\n.jp-CodeMirrorWidget .CodeMirror-gutters {\n  border-bottom-left-radius: 2px;\n  border-top-left-radius: 2px;\n}\n\n\n.jp-CodeMirrorWidget > .CodeMirror pre {\n  /* In CM3 this went to 4px from 0 in CM2. We need the 0 value because of how we size */\n  /* .CodeMirror-lines */\n  padding: 0;\n  border: 0;\n  border-radius: 0;\n}\n\n\n", ""]);
	
	// exports


/***/ },
/* 99 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2016, Jupyter Development Team.\n|\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Dialog {\n  background: rgba(0,0,0,0.25);\n  color: #757575;\n}\n\n\n.jp-Dialog-content {\n  background: #FAFAFA;\n  padding: 24px;\n  width: 300px;\n  box-sizing: border-box;\n  box-shadow: 0px 2px 2px 0px rgba(0,0,0,0.5);\n  word-wrap: break-word;\n}\n\n\n.jp-Dialog-header {\n  padding-bottom: 12px;\n  font-size: 18px;\n  color: #616161;\n}\n\n\n.jp-Dialog-body {\n  font-size: 15px;\n  background: #FAFAFA;\n}\n\n\n.jp-Dialog-bodyContent {\n  font-size: 15px;\n  outline: none;\n  margin-bottom: 12px;\n}\n\n\n.jp-Dialog-footer {\n  margin-top: 24px;\n}\n\n\n.jp-Dialog-button {\n  font-size: 15px;\n  border: none;\n  min-width: 120px;\n  max-width: 120px;\n  text-transform: uppercase;\n  line-height: 38px;\n  border-radius: 2px;\n  outline: none;\n  padding: 0px;\n}\n\n\n.jp-Dialog-okButton {\n  background: #2196F3;\n  color: white;\n}\n\n\n.jp-Dialog-cancelButton {\n  background: #9E9E9E;\n  margin-right: 12px;\n  color: white;\n}\n\n\n.jp-Dialog-inputWrapper {\n  padding: 7px;\n  background: white;\n  width: 252px;\n  box-sizing: border-box;\n  border: 1px solid #BDBDBD;\n  border-radius: 2px;\n  margin-bottom: 12px;\n}\n\n\n.jp-Dialog-input {\n  font-size: 15px;\n  color: #676767;\n  width: 100%;\n  outline: none;\n  border: none;\n}\n\n\n.jp-Dialog-selectWrapper {\n  padding-top: 6px;\n  padding-bottom: 6px;\n  background: white;\n  width: 252px;\n  box-sizing: border-box;\n  border: 1px solid #BDBDBD;\n  border-radius: 2px;\n  margin-bottom: 12px;\n}\n\n\n.jp-Dialog-select {\n  font-size: 15px;\n  background: white;\n  color: #676767;\n  width: 100%;\n  outline: none;\n  border: none;\n}\n", ""]);
	
	// exports


/***/ },
/* 100 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-FileBrowser {\n  min-width: 300px;\n  color: #757575;\n  background: #FAFAFA;\n  font-size: 13px;\n}\n\n\n.jp-BreadCrumbs {\n  margin: 4px 12px;\n}\n\n\n.jp-BreadCrumbs-item {\n  margin: 0px 4px;\n  cursor: pointer;\n}\n\n\n.jp-BreadCrumbs-item:first-child {\n  margin-left: 0px;\n}\n\n\n.jp-BreadCrumbs-item.jp-mod-dropTarget {\n  background: #FEDBC4;\n}\n\n\n.jp-FileButtons {\n  border-bottom: 1px solid #E0E0E0;\n}\n\n\n.jp-FileButtons-button {\n  flex: 1 1 auto;\n  max-width: 100px;\n  padding: 4px 6px;\n  color: #757575;\n  background: #FAFAFA;\n  border: none;\n  font-size: 14px;\n  outline: 0;\n  padding-top: 8px;\n  padding-bottom: 8px;\n}\n\n\n.jp-FileButtons-button::-moz-focus-inner {\n  border: 0;\n}\n\n\n.jp-FileButtons-button:hover {\n  background: #F5F5F5;\n  border-color: #D0D0D0;\n  z-index: 1; /* raise overlapping border */\n}\n\n\n.jp-FileButtons-button:active,\n.jp-FileButtons-button.jp-id-create.jp-mod-active {\n  background: #EEEEEE;\n  border-color: #BDBDBD;\n  z-index: 1; /* raise overlapping border */\n}\n\n\n.jp-FileButtons-button.jp-id-upload {\n  margin-left: -1px; /* overlap borders */\n}\n\n\n.jp-DirListing {\n  outline: 0;\n}\n\n\n.jp-DirListing-header {\n  margin-bottom: 4px;\n  border-top: 1px solid #E0E0E0;\n  border-bottom: 1px solid #E0E0E0;\n}\n\n\n.jp-DirListing-headerItem {\n  padding: 4px 12px;\n  font-weight: 500;\n}\n\n\n.jp-DirListing-headerItem:hover {\n  background: #EEEEEE;\n}\n\n\n.jp-DirListing-headerItem.jp-id-name {\n  flex: 1 0 84px;\n}\n\n\n.jp-DirListing-headerItem.jp-id-modified {\n  flex: 0 0 112px;\n  border-left: 1px solid #E0E0E0;\n  text-align: right;\n}\n\n\n.jp-DirListing-headerItem.jp-mod-selected {\n  font-weight: 600;\n}\n\n\n.jp-DirListing-headerItem.jp-mod-selected .jp-DirListing-headerItemIcon:before {\n  font-family: FontAwesome;\n  content: \"\\F0D8\";\n}\n\n\n.jp-DirListing-headerItem.jp-mod-selected.jp-mod-descending .jp-DirListing-headerItemIcon:before {\n  font-family: FontAwesome;\n  content: \"\\F0D7\";\n}\n\n\n.jp-DirListing-headerItem.jp-mod-selected.jp-id-name .jp-DirListing-headerItemIcon:before {\n  float: right;\n}\n\n\n.jp-DirListing-headerItem.jp-mod-selected.jp-id-modified .jp-DirListing-headerItemIcon:before {\n  float: left;\n}\n\n/* increase specificity to override bundled default */\n/*.jp-DirListing > .jp-DirListing-content {\n  padding: 0px;\n}*/\n\n\n.jp-DirListing-item {\n  padding: 4px 12px;\n}\n\n\n.jp-DirListing-item.jp-mod-selected {\n  color: white;\n  background: #2196F3;\n}\n\n\n.jp-DirListing-item.jp-mod-dropTarget {\n  background: #FEDBC4;\n}\n\n\n.jp-DirListing-item:hover:not(.jp-mod-selected) {\n  background: #EEEEEE;\n}\n\n\n.jp-DirListing-itemIcon {\n  flex: 0 0 20px;\n  font-family: FontAwesome;\n  font-size: 14px;\n}\n\n\n.jp-DirListing-itemText {\n  flex: 1 0 64px;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n\n.jp-DirListing-itemModified {\n  flex: 0 0 108px;\n  text-align: right;\n}\n\n\n.jp-DirListing-editor {\n  flex: 1 0 64px;\n}\n\n\n.jp-type-folder.jp-DirListing-itemIcon:before {\n  content: \"\\F114\";\n}\n\n\n.jp-type-file.jp-DirListing-itemIcon:before {\n  content: \"\\F016\";\n}\n\n\n.jp-type-notebook.jp-DirListing-itemIcon:before {\n  content: \"\\F02D\";\n}\n\n\n.jp-DirListing-item.jp-mod-running .jp-DirListing-itemIcon {\n  color: #27AE60;\n}\n\n.jp-DirListing-item.p-mod-drag-image,\n.jp-DirListing-item.jp-mod-selected.p-mod-drag-image {\n  background-color: #FFFFFF;\n  box-shadow: 5px 5px 10px rgba(46,46,46,0.5);\n  border-radius: 3px;\n  color: #757575;\n  transform: translateX(-40%) translateY(-58%);\n}\n", ""]);
	
	// exports


/***/ },
/* 101 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	exports.i(__webpack_require__(102), "");
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-TerminalWidget {\n  min-width: 200px;\n  min-height: 200px;\n  padding: 8px;\n}\n\n\n.jp-TerminalWidget-body {\n  outline: none;\n  user-select: text;\n  -webkit-user-select: text;\n}\n\n.terminal {\n  font-family: monospace;\n}\n", ""]);
	
	// exports


/***/ },
/* 102 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/**\n * xterm.js: xterm, in the browser\n * Copyright (c) 2014, sourceLair Limited (www.sourcelair.com (MIT License)\n * Copyright (c) 2012-2013, Christopher Jeffrey (MIT License)\n * https://github.com/chjj/term.js\n *\n * Permission is hereby granted, free of charge, to any person obtaining a copy\n * of this software and associated documentation files (the \"Software\"), to deal\n * in the Software without restriction, including without limitation the rights\n * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\n * copies of the Software, and to permit persons to whom the Software is\n * furnished to do so, subject to the following conditions:\n *\n * The above copyright notice and this permission notice shall be included in\n * all copies or substantial portions of the Software.\n *\n * THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\n * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\n * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\n * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\n * THE SOFTWARE.\n *\n * Originally forked from (with the author's permission):\n *   Fabrice Bellard's javascript vt100 for jslinux:\n *   http://bellard.org/jslinux/\n *   Copyright (c) 2011 Fabrice Bellard\n *   The original design remains. The terminal itself\n *   has been extended to include xterm CSI codes, among\n *   other features.\n */\n\n/*\n *  Default style for xterm.js\n */\n\n.terminal {\n    background-color: #000;\n    color: #fff;\n    font-family: courier-new, courier, monospace;\n    position: relative;\n}\n\n.terminal:focus {\n    outline: none;\n}\n\n.terminal .terminal-cursor {\n    background-color: #fff;\n    color: #000;\n}\n\n.terminal .xterm-helpers {\n    position: absolute;\n    top: 0;\n}\n\n.terminal .xterm-helper-textarea {\n    /*\n     * HACK: to fix IE's blinking cursor\n     * Move textarea out of the screen to the far left, so that the cursor is not visible.\n     */\n    text-indent: -9999em;\n    opacity: 0;\n    width: 0;\n    height: 0;\n    z-index: -10;\n}\n\n/*\n *  Determine default colors for xterm.js\n */\n.terminal .xterm-bold {\n    font-weight: bold;\n}\n\n.terminal .xterm-underline {\n    text-decoration: underline;\n}\n\n.terminal .xterm-blink {\n    text-decoration: blink;\n}\n\n.terminal .xterm-hidden {\n    visibility: hidden;\n}\n\n.terminal .xterm-color-0 {\n    color: #2e3436;\n}\n\n.terminal .xterm-bg-color-0 {\n    background-color: #2e3436;\n}\n\n.terminal .xterm-color-1 {\n    color: #cc0000;\n}\n\n.terminal .xterm-bg-color-1 {\n    background-color: #cc0000;\n}\n\n.terminal .xterm-color-2 {\n    color: #4e9a06;\n}\n\n.terminal .xterm-bg-color-2 {\n    background-color: #4e9a06;\n}\n\n.terminal .xterm-color-3 {\n    color: #c4a000;\n}\n\n.terminal .xterm-bg-color-3 {\n    background-color: #c4a000;\n}\n\n.terminal .xterm-color-4 {\n    color: #3465a4;\n}\n\n.terminal .xterm-bg-color-4 {\n    background-color: #3465a4;\n}\n\n.terminal .xterm-color-5 {\n    color: #75507b;\n}\n\n.terminal .xterm-bg-color-5 {\n    background-color: #75507b;\n}\n\n.terminal .xterm-color-6 {\n    color: #06989a;\n}\n\n.terminal .xterm-bg-color-6 {\n    background-color: #06989a;\n}\n\n.terminal .xterm-color-7 {\n    color: #d3d7cf;\n}\n\n.terminal .xterm-bg-color-7 {\n    background-color: #d3d7cf;\n}\n\n.terminal .xterm-color-8 {\n    color: #555753;\n}\n\n.terminal .xterm-bg-color-8 {\n    background-color: #555753;\n}\n\n.terminal .xterm-color-9 {\n    color: #ef2929;\n}\n\n.terminal .xterm-bg-color-9 {\n    background-color: #ef2929;\n}\n\n.terminal .xterm-color-10 {\n    color: #8ae234;\n}\n\n.terminal .xterm-bg-color-10 {\n    background-color: #8ae234;\n}\n\n.terminal .xterm-color-11 {\n    color: #fce94f;\n}\n\n.terminal .xterm-bg-color-11 {\n    background-color: #fce94f;\n}\n\n.terminal .xterm-color-12 {\n    color: #729fcf;\n}\n\n.terminal .xterm-bg-color-12 {\n    background-color: #729fcf;\n}\n\n.terminal .xterm-color-13 {\n    color: #ad7fa8;\n}\n\n.terminal .xterm-bg-color-13 {\n    background-color: #ad7fa8;\n}\n\n.terminal .xterm-color-14 {\n    color: #34e2e2;\n}\n\n.terminal .xterm-bg-color-14 {\n    background-color: #34e2e2;\n}\n\n.terminal .xterm-color-15 {\n    color: #eeeeec;\n}\n\n.terminal .xterm-bg-color-15 {\n    background-color: #eeeeec;\n}\n\n.terminal .xterm-color-16 {\n    color: #000000;\n}\n\n.terminal .xterm-bg-color-16 {\n    background-color: #000000;\n}\n\n.terminal .xterm-color-17 {\n    color: #00005f;\n}\n\n.terminal .xterm-bg-color-17 {\n    background-color: #00005f;\n}\n\n.terminal .xterm-color-18 {\n    color: #000087;\n}\n\n.terminal .xterm-bg-color-18 {\n    background-color: #000087;\n}\n\n.terminal .xterm-color-19 {\n    color: #0000af;\n}\n\n.terminal .xterm-bg-color-19 {\n    background-color: #0000af;\n}\n\n.terminal .xterm-color-20 {\n    color: #0000d7;\n}\n\n.terminal .xterm-bg-color-20 {\n    background-color: #0000d7;\n}\n\n.terminal .xterm-color-21 {\n    color: #0000ff;\n}\n\n.terminal .xterm-bg-color-21 {\n    background-color: #0000ff;\n}\n\n.terminal .xterm-color-22 {\n    color: #005f00;\n}\n\n.terminal .xterm-bg-color-22 {\n    background-color: #005f00;\n}\n\n.terminal .xterm-color-23 {\n    color: #005f5f;\n}\n\n.terminal .xterm-bg-color-23 {\n    background-color: #005f5f;\n}\n\n.terminal .xterm-color-24 {\n    color: #005f87;\n}\n\n.terminal .xterm-bg-color-24 {\n    background-color: #005f87;\n}\n\n.terminal .xterm-color-25 {\n    color: #005faf;\n}\n\n.terminal .xterm-bg-color-25 {\n    background-color: #005faf;\n}\n\n.terminal .xterm-color-26 {\n    color: #005fd7;\n}\n\n.terminal .xterm-bg-color-26 {\n    background-color: #005fd7;\n}\n\n.terminal .xterm-color-27 {\n    color: #005fff;\n}\n\n.terminal .xterm-bg-color-27 {\n    background-color: #005fff;\n}\n\n.terminal .xterm-color-28 {\n    color: #008700;\n}\n\n.terminal .xterm-bg-color-28 {\n    background-color: #008700;\n}\n\n.terminal .xterm-color-29 {\n    color: #00875f;\n}\n\n.terminal .xterm-bg-color-29 {\n    background-color: #00875f;\n}\n\n.terminal .xterm-color-30 {\n    color: #008787;\n}\n\n.terminal .xterm-bg-color-30 {\n    background-color: #008787;\n}\n\n.terminal .xterm-color-31 {\n    color: #0087af;\n}\n\n.terminal .xterm-bg-color-31 {\n    background-color: #0087af;\n}\n\n.terminal .xterm-color-32 {\n    color: #0087d7;\n}\n\n.terminal .xterm-bg-color-32 {\n    background-color: #0087d7;\n}\n\n.terminal .xterm-color-33 {\n    color: #0087ff;\n}\n\n.terminal .xterm-bg-color-33 {\n    background-color: #0087ff;\n}\n\n.terminal .xterm-color-34 {\n    color: #00af00;\n}\n\n.terminal .xterm-bg-color-34 {\n    background-color: #00af00;\n}\n\n.terminal .xterm-color-35 {\n    color: #00af5f;\n}\n\n.terminal .xterm-bg-color-35 {\n    background-color: #00af5f;\n}\n\n.terminal .xterm-color-36 {\n    color: #00af87;\n}\n\n.terminal .xterm-bg-color-36 {\n    background-color: #00af87;\n}\n\n.terminal .xterm-color-37 {\n    color: #00afaf;\n}\n\n.terminal .xterm-bg-color-37 {\n    background-color: #00afaf;\n}\n\n.terminal .xterm-color-38 {\n    color: #00afd7;\n}\n\n.terminal .xterm-bg-color-38 {\n    background-color: #00afd7;\n}\n\n.terminal .xterm-color-39 {\n    color: #00afff;\n}\n\n.terminal .xterm-bg-color-39 {\n    background-color: #00afff;\n}\n\n.terminal .xterm-color-40 {\n    color: #00d700;\n}\n\n.terminal .xterm-bg-color-40 {\n    background-color: #00d700;\n}\n\n.terminal .xterm-color-41 {\n    color: #00d75f;\n}\n\n.terminal .xterm-bg-color-41 {\n    background-color: #00d75f;\n}\n\n.terminal .xterm-color-42 {\n    color: #00d787;\n}\n\n.terminal .xterm-bg-color-42 {\n    background-color: #00d787;\n}\n\n.terminal .xterm-color-43 {\n    color: #00d7af;\n}\n\n.terminal .xterm-bg-color-43 {\n    background-color: #00d7af;\n}\n\n.terminal .xterm-color-44 {\n    color: #00d7d7;\n}\n\n.terminal .xterm-bg-color-44 {\n    background-color: #00d7d7;\n}\n\n.terminal .xterm-color-45 {\n    color: #00d7ff;\n}\n\n.terminal .xterm-bg-color-45 {\n    background-color: #00d7ff;\n}\n\n.terminal .xterm-color-46 {\n    color: #00ff00;\n}\n\n.terminal .xterm-bg-color-46 {\n    background-color: #00ff00;\n}\n\n.terminal .xterm-color-47 {\n    color: #00ff5f;\n}\n\n.terminal .xterm-bg-color-47 {\n    background-color: #00ff5f;\n}\n\n.terminal .xterm-color-48 {\n    color: #00ff87;\n}\n\n.terminal .xterm-bg-color-48 {\n    background-color: #00ff87;\n}\n\n.terminal .xterm-color-49 {\n    color: #00ffaf;\n}\n\n.terminal .xterm-bg-color-49 {\n    background-color: #00ffaf;\n}\n\n.terminal .xterm-color-50 {\n    color: #00ffd7;\n}\n\n.terminal .xterm-bg-color-50 {\n    background-color: #00ffd7;\n}\n\n.terminal .xterm-color-51 {\n    color: #00ffff;\n}\n\n.terminal .xterm-bg-color-51 {\n    background-color: #00ffff;\n}\n\n.terminal .xterm-color-52 {\n    color: #5f0000;\n}\n\n.terminal .xterm-bg-color-52 {\n    background-color: #5f0000;\n}\n\n.terminal .xterm-color-53 {\n    color: #5f005f;\n}\n\n.terminal .xterm-bg-color-53 {\n    background-color: #5f005f;\n}\n\n.terminal .xterm-color-54 {\n    color: #5f0087;\n}\n\n.terminal .xterm-bg-color-54 {\n    background-color: #5f0087;\n}\n\n.terminal .xterm-color-55 {\n    color: #5f00af;\n}\n\n.terminal .xterm-bg-color-55 {\n    background-color: #5f00af;\n}\n\n.terminal .xterm-color-56 {\n    color: #5f00d7;\n}\n\n.terminal .xterm-bg-color-56 {\n    background-color: #5f00d7;\n}\n\n.terminal .xterm-color-57 {\n    color: #5f00ff;\n}\n\n.terminal .xterm-bg-color-57 {\n    background-color: #5f00ff;\n}\n\n.terminal .xterm-color-58 {\n    color: #5f5f00;\n}\n\n.terminal .xterm-bg-color-58 {\n    background-color: #5f5f00;\n}\n\n.terminal .xterm-color-59 {\n    color: #5f5f5f;\n}\n\n.terminal .xterm-bg-color-59 {\n    background-color: #5f5f5f;\n}\n\n.terminal .xterm-color-60 {\n    color: #5f5f87;\n}\n\n.terminal .xterm-bg-color-60 {\n    background-color: #5f5f87;\n}\n\n.terminal .xterm-color-61 {\n    color: #5f5faf;\n}\n\n.terminal .xterm-bg-color-61 {\n    background-color: #5f5faf;\n}\n\n.terminal .xterm-color-62 {\n    color: #5f5fd7;\n}\n\n.terminal .xterm-bg-color-62 {\n    background-color: #5f5fd7;\n}\n\n.terminal .xterm-color-63 {\n    color: #5f5fff;\n}\n\n.terminal .xterm-bg-color-63 {\n    background-color: #5f5fff;\n}\n\n.terminal .xterm-color-64 {\n    color: #5f8700;\n}\n\n.terminal .xterm-bg-color-64 {\n    background-color: #5f8700;\n}\n\n.terminal .xterm-color-65 {\n    color: #5f875f;\n}\n\n.terminal .xterm-bg-color-65 {\n    background-color: #5f875f;\n}\n\n.terminal .xterm-color-66 {\n    color: #5f8787;\n}\n\n.terminal .xterm-bg-color-66 {\n    background-color: #5f8787;\n}\n\n.terminal .xterm-color-67 {\n    color: #5f87af;\n}\n\n.terminal .xterm-bg-color-67 {\n    background-color: #5f87af;\n}\n\n.terminal .xterm-color-68 {\n    color: #5f87d7;\n}\n\n.terminal .xterm-bg-color-68 {\n    background-color: #5f87d7;\n}\n\n.terminal .xterm-color-69 {\n    color: #5f87ff;\n}\n\n.terminal .xterm-bg-color-69 {\n    background-color: #5f87ff;\n}\n\n.terminal .xterm-color-70 {\n    color: #5faf00;\n}\n\n.terminal .xterm-bg-color-70 {\n    background-color: #5faf00;\n}\n\n.terminal .xterm-color-71 {\n    color: #5faf5f;\n}\n\n.terminal .xterm-bg-color-71 {\n    background-color: #5faf5f;\n}\n\n.terminal .xterm-color-72 {\n    color: #5faf87;\n}\n\n.terminal .xterm-bg-color-72 {\n    background-color: #5faf87;\n}\n\n.terminal .xterm-color-73 {\n    color: #5fafaf;\n}\n\n.terminal .xterm-bg-color-73 {\n    background-color: #5fafaf;\n}\n\n.terminal .xterm-color-74 {\n    color: #5fafd7;\n}\n\n.terminal .xterm-bg-color-74 {\n    background-color: #5fafd7;\n}\n\n.terminal .xterm-color-75 {\n    color: #5fafff;\n}\n\n.terminal .xterm-bg-color-75 {\n    background-color: #5fafff;\n}\n\n.terminal .xterm-color-76 {\n    color: #5fd700;\n}\n\n.terminal .xterm-bg-color-76 {\n    background-color: #5fd700;\n}\n\n.terminal .xterm-color-77 {\n    color: #5fd75f;\n}\n\n.terminal .xterm-bg-color-77 {\n    background-color: #5fd75f;\n}\n\n.terminal .xterm-color-78 {\n    color: #5fd787;\n}\n\n.terminal .xterm-bg-color-78 {\n    background-color: #5fd787;\n}\n\n.terminal .xterm-color-79 {\n    color: #5fd7af;\n}\n\n.terminal .xterm-bg-color-79 {\n    background-color: #5fd7af;\n}\n\n.terminal .xterm-color-80 {\n    color: #5fd7d7;\n}\n\n.terminal .xterm-bg-color-80 {\n    background-color: #5fd7d7;\n}\n\n.terminal .xterm-color-81 {\n    color: #5fd7ff;\n}\n\n.terminal .xterm-bg-color-81 {\n    background-color: #5fd7ff;\n}\n\n.terminal .xterm-color-82 {\n    color: #5fff00;\n}\n\n.terminal .xterm-bg-color-82 {\n    background-color: #5fff00;\n}\n\n.terminal .xterm-color-83 {\n    color: #5fff5f;\n}\n\n.terminal .xterm-bg-color-83 {\n    background-color: #5fff5f;\n}\n\n.terminal .xterm-color-84 {\n    color: #5fff87;\n}\n\n.terminal .xterm-bg-color-84 {\n    background-color: #5fff87;\n}\n\n.terminal .xterm-color-85 {\n    color: #5fffaf;\n}\n\n.terminal .xterm-bg-color-85 {\n    background-color: #5fffaf;\n}\n\n.terminal .xterm-color-86 {\n    color: #5fffd7;\n}\n\n.terminal .xterm-bg-color-86 {\n    background-color: #5fffd7;\n}\n\n.terminal .xterm-color-87 {\n    color: #5fffff;\n}\n\n.terminal .xterm-bg-color-87 {\n    background-color: #5fffff;\n}\n\n.terminal .xterm-color-88 {\n    color: #870000;\n}\n\n.terminal .xterm-bg-color-88 {\n    background-color: #870000;\n}\n\n.terminal .xterm-color-89 {\n    color: #87005f;\n}\n\n.terminal .xterm-bg-color-89 {\n    background-color: #87005f;\n}\n\n.terminal .xterm-color-90 {\n    color: #870087;\n}\n\n.terminal .xterm-bg-color-90 {\n    background-color: #870087;\n}\n\n.terminal .xterm-color-91 {\n    color: #8700af;\n}\n\n.terminal .xterm-bg-color-91 {\n    background-color: #8700af;\n}\n\n.terminal .xterm-color-92 {\n    color: #8700d7;\n}\n\n.terminal .xterm-bg-color-92 {\n    background-color: #8700d7;\n}\n\n.terminal .xterm-color-93 {\n    color: #8700ff;\n}\n\n.terminal .xterm-bg-color-93 {\n    background-color: #8700ff;\n}\n\n.terminal .xterm-color-94 {\n    color: #875f00;\n}\n\n.terminal .xterm-bg-color-94 {\n    background-color: #875f00;\n}\n\n.terminal .xterm-color-95 {\n    color: #875f5f;\n}\n\n.terminal .xterm-bg-color-95 {\n    background-color: #875f5f;\n}\n\n.terminal .xterm-color-96 {\n    color: #875f87;\n}\n\n.terminal .xterm-bg-color-96 {\n    background-color: #875f87;\n}\n\n.terminal .xterm-color-97 {\n    color: #875faf;\n}\n\n.terminal .xterm-bg-color-97 {\n    background-color: #875faf;\n}\n\n.terminal .xterm-color-98 {\n    color: #875fd7;\n}\n\n.terminal .xterm-bg-color-98 {\n    background-color: #875fd7;\n}\n\n.terminal .xterm-color-99 {\n    color: #875fff;\n}\n\n.terminal .xterm-bg-color-99 {\n    background-color: #875fff;\n}\n\n.terminal .xterm-color-100 {\n    color: #878700;\n}\n\n.terminal .xterm-bg-color-100 {\n    background-color: #878700;\n}\n\n.terminal .xterm-color-101 {\n    color: #87875f;\n}\n\n.terminal .xterm-bg-color-101 {\n    background-color: #87875f;\n}\n\n.terminal .xterm-color-102 {\n    color: #878787;\n}\n\n.terminal .xterm-bg-color-102 {\n    background-color: #878787;\n}\n\n.terminal .xterm-color-103 {\n    color: #8787af;\n}\n\n.terminal .xterm-bg-color-103 {\n    background-color: #8787af;\n}\n\n.terminal .xterm-color-104 {\n    color: #8787d7;\n}\n\n.terminal .xterm-bg-color-104 {\n    background-color: #8787d7;\n}\n\n.terminal .xterm-color-105 {\n    color: #8787ff;\n}\n\n.terminal .xterm-bg-color-105 {\n    background-color: #8787ff;\n}\n\n.terminal .xterm-color-106 {\n    color: #87af00;\n}\n\n.terminal .xterm-bg-color-106 {\n    background-color: #87af00;\n}\n\n.terminal .xterm-color-107 {\n    color: #87af5f;\n}\n\n.terminal .xterm-bg-color-107 {\n    background-color: #87af5f;\n}\n\n.terminal .xterm-color-108 {\n    color: #87af87;\n}\n\n.terminal .xterm-bg-color-108 {\n    background-color: #87af87;\n}\n\n.terminal .xterm-color-109 {\n    color: #87afaf;\n}\n\n.terminal .xterm-bg-color-109 {\n    background-color: #87afaf;\n}\n\n.terminal .xterm-color-110 {\n    color: #87afd7;\n}\n\n.terminal .xterm-bg-color-110 {\n    background-color: #87afd7;\n}\n\n.terminal .xterm-color-111 {\n    color: #87afff;\n}\n\n.terminal .xterm-bg-color-111 {\n    background-color: #87afff;\n}\n\n.terminal .xterm-color-112 {\n    color: #87d700;\n}\n\n.terminal .xterm-bg-color-112 {\n    background-color: #87d700;\n}\n\n.terminal .xterm-color-113 {\n    color: #87d75f;\n}\n\n.terminal .xterm-bg-color-113 {\n    background-color: #87d75f;\n}\n\n.terminal .xterm-color-114 {\n    color: #87d787;\n}\n\n.terminal .xterm-bg-color-114 {\n    background-color: #87d787;\n}\n\n.terminal .xterm-color-115 {\n    color: #87d7af;\n}\n\n.terminal .xterm-bg-color-115 {\n    background-color: #87d7af;\n}\n\n.terminal .xterm-color-116 {\n    color: #87d7d7;\n}\n\n.terminal .xterm-bg-color-116 {\n    background-color: #87d7d7;\n}\n\n.terminal .xterm-color-117 {\n    color: #87d7ff;\n}\n\n.terminal .xterm-bg-color-117 {\n    background-color: #87d7ff;\n}\n\n.terminal .xterm-color-118 {\n    color: #87ff00;\n}\n\n.terminal .xterm-bg-color-118 {\n    background-color: #87ff00;\n}\n\n.terminal .xterm-color-119 {\n    color: #87ff5f;\n}\n\n.terminal .xterm-bg-color-119 {\n    background-color: #87ff5f;\n}\n\n.terminal .xterm-color-120 {\n    color: #87ff87;\n}\n\n.terminal .xterm-bg-color-120 {\n    background-color: #87ff87;\n}\n\n.terminal .xterm-color-121 {\n    color: #87ffaf;\n}\n\n.terminal .xterm-bg-color-121 {\n    background-color: #87ffaf;\n}\n\n.terminal .xterm-color-122 {\n    color: #87ffd7;\n}\n\n.terminal .xterm-bg-color-122 {\n    background-color: #87ffd7;\n}\n\n.terminal .xterm-color-123 {\n    color: #87ffff;\n}\n\n.terminal .xterm-bg-color-123 {\n    background-color: #87ffff;\n}\n\n.terminal .xterm-color-124 {\n    color: #af0000;\n}\n\n.terminal .xterm-bg-color-124 {\n    background-color: #af0000;\n}\n\n.terminal .xterm-color-125 {\n    color: #af005f;\n}\n\n.terminal .xterm-bg-color-125 {\n    background-color: #af005f;\n}\n\n.terminal .xterm-color-126 {\n    color: #af0087;\n}\n\n.terminal .xterm-bg-color-126 {\n    background-color: #af0087;\n}\n\n.terminal .xterm-color-127 {\n    color: #af00af;\n}\n\n.terminal .xterm-bg-color-127 {\n    background-color: #af00af;\n}\n\n.terminal .xterm-color-128 {\n    color: #af00d7;\n}\n\n.terminal .xterm-bg-color-128 {\n    background-color: #af00d7;\n}\n\n.terminal .xterm-color-129 {\n    color: #af00ff;\n}\n\n.terminal .xterm-bg-color-129 {\n    background-color: #af00ff;\n}\n\n.terminal .xterm-color-130 {\n    color: #af5f00;\n}\n\n.terminal .xterm-bg-color-130 {\n    background-color: #af5f00;\n}\n\n.terminal .xterm-color-131 {\n    color: #af5f5f;\n}\n\n.terminal .xterm-bg-color-131 {\n    background-color: #af5f5f;\n}\n\n.terminal .xterm-color-132 {\n    color: #af5f87;\n}\n\n.terminal .xterm-bg-color-132 {\n    background-color: #af5f87;\n}\n\n.terminal .xterm-color-133 {\n    color: #af5faf;\n}\n\n.terminal .xterm-bg-color-133 {\n    background-color: #af5faf;\n}\n\n.terminal .xterm-color-134 {\n    color: #af5fd7;\n}\n\n.terminal .xterm-bg-color-134 {\n    background-color: #af5fd7;\n}\n\n.terminal .xterm-color-135 {\n    color: #af5fff;\n}\n\n.terminal .xterm-bg-color-135 {\n    background-color: #af5fff;\n}\n\n.terminal .xterm-color-136 {\n    color: #af8700;\n}\n\n.terminal .xterm-bg-color-136 {\n    background-color: #af8700;\n}\n\n.terminal .xterm-color-137 {\n    color: #af875f;\n}\n\n.terminal .xterm-bg-color-137 {\n    background-color: #af875f;\n}\n\n.terminal .xterm-color-138 {\n    color: #af8787;\n}\n\n.terminal .xterm-bg-color-138 {\n    background-color: #af8787;\n}\n\n.terminal .xterm-color-139 {\n    color: #af87af;\n}\n\n.terminal .xterm-bg-color-139 {\n    background-color: #af87af;\n}\n\n.terminal .xterm-color-140 {\n    color: #af87d7;\n}\n\n.terminal .xterm-bg-color-140 {\n    background-color: #af87d7;\n}\n\n.terminal .xterm-color-141 {\n    color: #af87ff;\n}\n\n.terminal .xterm-bg-color-141 {\n    background-color: #af87ff;\n}\n\n.terminal .xterm-color-142 {\n    color: #afaf00;\n}\n\n.terminal .xterm-bg-color-142 {\n    background-color: #afaf00;\n}\n\n.terminal .xterm-color-143 {\n    color: #afaf5f;\n}\n\n.terminal .xterm-bg-color-143 {\n    background-color: #afaf5f;\n}\n\n.terminal .xterm-color-144 {\n    color: #afaf87;\n}\n\n.terminal .xterm-bg-color-144 {\n    background-color: #afaf87;\n}\n\n.terminal .xterm-color-145 {\n    color: #afafaf;\n}\n\n.terminal .xterm-bg-color-145 {\n    background-color: #afafaf;\n}\n\n.terminal .xterm-color-146 {\n    color: #afafd7;\n}\n\n.terminal .xterm-bg-color-146 {\n    background-color: #afafd7;\n}\n\n.terminal .xterm-color-147 {\n    color: #afafff;\n}\n\n.terminal .xterm-bg-color-147 {\n    background-color: #afafff;\n}\n\n.terminal .xterm-color-148 {\n    color: #afd700;\n}\n\n.terminal .xterm-bg-color-148 {\n    background-color: #afd700;\n}\n\n.terminal .xterm-color-149 {\n    color: #afd75f;\n}\n\n.terminal .xterm-bg-color-149 {\n    background-color: #afd75f;\n}\n\n.terminal .xterm-color-150 {\n    color: #afd787;\n}\n\n.terminal .xterm-bg-color-150 {\n    background-color: #afd787;\n}\n\n.terminal .xterm-color-151 {\n    color: #afd7af;\n}\n\n.terminal .xterm-bg-color-151 {\n    background-color: #afd7af;\n}\n\n.terminal .xterm-color-152 {\n    color: #afd7d7;\n}\n\n.terminal .xterm-bg-color-152 {\n    background-color: #afd7d7;\n}\n\n.terminal .xterm-color-153 {\n    color: #afd7ff;\n}\n\n.terminal .xterm-bg-color-153 {\n    background-color: #afd7ff;\n}\n\n.terminal .xterm-color-154 {\n    color: #afff00;\n}\n\n.terminal .xterm-bg-color-154 {\n    background-color: #afff00;\n}\n\n.terminal .xterm-color-155 {\n    color: #afff5f;\n}\n\n.terminal .xterm-bg-color-155 {\n    background-color: #afff5f;\n}\n\n.terminal .xterm-color-156 {\n    color: #afff87;\n}\n\n.terminal .xterm-bg-color-156 {\n    background-color: #afff87;\n}\n\n.terminal .xterm-color-157 {\n    color: #afffaf;\n}\n\n.terminal .xterm-bg-color-157 {\n    background-color: #afffaf;\n}\n\n.terminal .xterm-color-158 {\n    color: #afffd7;\n}\n\n.terminal .xterm-bg-color-158 {\n    background-color: #afffd7;\n}\n\n.terminal .xterm-color-159 {\n    color: #afffff;\n}\n\n.terminal .xterm-bg-color-159 {\n    background-color: #afffff;\n}\n\n.terminal .xterm-color-160 {\n    color: #d70000;\n}\n\n.terminal .xterm-bg-color-160 {\n    background-color: #d70000;\n}\n\n.terminal .xterm-color-161 {\n    color: #d7005f;\n}\n\n.terminal .xterm-bg-color-161 {\n    background-color: #d7005f;\n}\n\n.terminal .xterm-color-162 {\n    color: #d70087;\n}\n\n.terminal .xterm-bg-color-162 {\n    background-color: #d70087;\n}\n\n.terminal .xterm-color-163 {\n    color: #d700af;\n}\n\n.terminal .xterm-bg-color-163 {\n    background-color: #d700af;\n}\n\n.terminal .xterm-color-164 {\n    color: #d700d7;\n}\n\n.terminal .xterm-bg-color-164 {\n    background-color: #d700d7;\n}\n\n.terminal .xterm-color-165 {\n    color: #d700ff;\n}\n\n.terminal .xterm-bg-color-165 {\n    background-color: #d700ff;\n}\n\n.terminal .xterm-color-166 {\n    color: #d75f00;\n}\n\n.terminal .xterm-bg-color-166 {\n    background-color: #d75f00;\n}\n\n.terminal .xterm-color-167 {\n    color: #d75f5f;\n}\n\n.terminal .xterm-bg-color-167 {\n    background-color: #d75f5f;\n}\n\n.terminal .xterm-color-168 {\n    color: #d75f87;\n}\n\n.terminal .xterm-bg-color-168 {\n    background-color: #d75f87;\n}\n\n.terminal .xterm-color-169 {\n    color: #d75faf;\n}\n\n.terminal .xterm-bg-color-169 {\n    background-color: #d75faf;\n}\n\n.terminal .xterm-color-170 {\n    color: #d75fd7;\n}\n\n.terminal .xterm-bg-color-170 {\n    background-color: #d75fd7;\n}\n\n.terminal .xterm-color-171 {\n    color: #d75fff;\n}\n\n.terminal .xterm-bg-color-171 {\n    background-color: #d75fff;\n}\n\n.terminal .xterm-color-172 {\n    color: #d78700;\n}\n\n.terminal .xterm-bg-color-172 {\n    background-color: #d78700;\n}\n\n.terminal .xterm-color-173 {\n    color: #d7875f;\n}\n\n.terminal .xterm-bg-color-173 {\n    background-color: #d7875f;\n}\n\n.terminal .xterm-color-174 {\n    color: #d78787;\n}\n\n.terminal .xterm-bg-color-174 {\n    background-color: #d78787;\n}\n\n.terminal .xterm-color-175 {\n    color: #d787af;\n}\n\n.terminal .xterm-bg-color-175 {\n    background-color: #d787af;\n}\n\n.terminal .xterm-color-176 {\n    color: #d787d7;\n}\n\n.terminal .xterm-bg-color-176 {\n    background-color: #d787d7;\n}\n\n.terminal .xterm-color-177 {\n    color: #d787ff;\n}\n\n.terminal .xterm-bg-color-177 {\n    background-color: #d787ff;\n}\n\n.terminal .xterm-color-178 {\n    color: #d7af00;\n}\n\n.terminal .xterm-bg-color-178 {\n    background-color: #d7af00;\n}\n\n.terminal .xterm-color-179 {\n    color: #d7af5f;\n}\n\n.terminal .xterm-bg-color-179 {\n    background-color: #d7af5f;\n}\n\n.terminal .xterm-color-180 {\n    color: #d7af87;\n}\n\n.terminal .xterm-bg-color-180 {\n    background-color: #d7af87;\n}\n\n.terminal .xterm-color-181 {\n    color: #d7afaf;\n}\n\n.terminal .xterm-bg-color-181 {\n    background-color: #d7afaf;\n}\n\n.terminal .xterm-color-182 {\n    color: #d7afd7;\n}\n\n.terminal .xterm-bg-color-182 {\n    background-color: #d7afd7;\n}\n\n.terminal .xterm-color-183 {\n    color: #d7afff;\n}\n\n.terminal .xterm-bg-color-183 {\n    background-color: #d7afff;\n}\n\n.terminal .xterm-color-184 {\n    color: #d7d700;\n}\n\n.terminal .xterm-bg-color-184 {\n    background-color: #d7d700;\n}\n\n.terminal .xterm-color-185 {\n    color: #d7d75f;\n}\n\n.terminal .xterm-bg-color-185 {\n    background-color: #d7d75f;\n}\n\n.terminal .xterm-color-186 {\n    color: #d7d787;\n}\n\n.terminal .xterm-bg-color-186 {\n    background-color: #d7d787;\n}\n\n.terminal .xterm-color-187 {\n    color: #d7d7af;\n}\n\n.terminal .xterm-bg-color-187 {\n    background-color: #d7d7af;\n}\n\n.terminal .xterm-color-188 {\n    color: #d7d7d7;\n}\n\n.terminal .xterm-bg-color-188 {\n    background-color: #d7d7d7;\n}\n\n.terminal .xterm-color-189 {\n    color: #d7d7ff;\n}\n\n.terminal .xterm-bg-color-189 {\n    background-color: #d7d7ff;\n}\n\n.terminal .xterm-color-190 {\n    color: #d7ff00;\n}\n\n.terminal .xterm-bg-color-190 {\n    background-color: #d7ff00;\n}\n\n.terminal .xterm-color-191 {\n    color: #d7ff5f;\n}\n\n.terminal .xterm-bg-color-191 {\n    background-color: #d7ff5f;\n}\n\n.terminal .xterm-color-192 {\n    color: #d7ff87;\n}\n\n.terminal .xterm-bg-color-192 {\n    background-color: #d7ff87;\n}\n\n.terminal .xterm-color-193 {\n    color: #d7ffaf;\n}\n\n.terminal .xterm-bg-color-193 {\n    background-color: #d7ffaf;\n}\n\n.terminal .xterm-color-194 {\n    color: #d7ffd7;\n}\n\n.terminal .xterm-bg-color-194 {\n    background-color: #d7ffd7;\n}\n\n.terminal .xterm-color-195 {\n    color: #d7ffff;\n}\n\n.terminal .xterm-bg-color-195 {\n    background-color: #d7ffff;\n}\n\n.terminal .xterm-color-196 {\n    color: #ff0000;\n}\n\n.terminal .xterm-bg-color-196 {\n    background-color: #ff0000;\n}\n\n.terminal .xterm-color-197 {\n    color: #ff005f;\n}\n\n.terminal .xterm-bg-color-197 {\n    background-color: #ff005f;\n}\n\n.terminal .xterm-color-198 {\n    color: #ff0087;\n}\n\n.terminal .xterm-bg-color-198 {\n    background-color: #ff0087;\n}\n\n.terminal .xterm-color-199 {\n    color: #ff00af;\n}\n\n.terminal .xterm-bg-color-199 {\n    background-color: #ff00af;\n}\n\n.terminal .xterm-color-200 {\n    color: #ff00d7;\n}\n\n.terminal .xterm-bg-color-200 {\n    background-color: #ff00d7;\n}\n\n.terminal .xterm-color-201 {\n    color: #ff00ff;\n}\n\n.terminal .xterm-bg-color-201 {\n    background-color: #ff00ff;\n}\n\n.terminal .xterm-color-202 {\n    color: #ff5f00;\n}\n\n.terminal .xterm-bg-color-202 {\n    background-color: #ff5f00;\n}\n\n.terminal .xterm-color-203 {\n    color: #ff5f5f;\n}\n\n.terminal .xterm-bg-color-203 {\n    background-color: #ff5f5f;\n}\n\n.terminal .xterm-color-204 {\n    color: #ff5f87;\n}\n\n.terminal .xterm-bg-color-204 {\n    background-color: #ff5f87;\n}\n\n.terminal .xterm-color-205 {\n    color: #ff5faf;\n}\n\n.terminal .xterm-bg-color-205 {\n    background-color: #ff5faf;\n}\n\n.terminal .xterm-color-206 {\n    color: #ff5fd7;\n}\n\n.terminal .xterm-bg-color-206 {\n    background-color: #ff5fd7;\n}\n\n.terminal .xterm-color-207 {\n    color: #ff5fff;\n}\n\n.terminal .xterm-bg-color-207 {\n    background-color: #ff5fff;\n}\n\n.terminal .xterm-color-208 {\n    color: #ff8700;\n}\n\n.terminal .xterm-bg-color-208 {\n    background-color: #ff8700;\n}\n\n.terminal .xterm-color-209 {\n    color: #ff875f;\n}\n\n.terminal .xterm-bg-color-209 {\n    background-color: #ff875f;\n}\n\n.terminal .xterm-color-210 {\n    color: #ff8787;\n}\n\n.terminal .xterm-bg-color-210 {\n    background-color: #ff8787;\n}\n\n.terminal .xterm-color-211 {\n    color: #ff87af;\n}\n\n.terminal .xterm-bg-color-211 {\n    background-color: #ff87af;\n}\n\n.terminal .xterm-color-212 {\n    color: #ff87d7;\n}\n\n.terminal .xterm-bg-color-212 {\n    background-color: #ff87d7;\n}\n\n.terminal .xterm-color-213 {\n    color: #ff87ff;\n}\n\n.terminal .xterm-bg-color-213 {\n    background-color: #ff87ff;\n}\n\n.terminal .xterm-color-214 {\n    color: #ffaf00;\n}\n\n.terminal .xterm-bg-color-214 {\n    background-color: #ffaf00;\n}\n\n.terminal .xterm-color-215 {\n    color: #ffaf5f;\n}\n\n.terminal .xterm-bg-color-215 {\n    background-color: #ffaf5f;\n}\n\n.terminal .xterm-color-216 {\n    color: #ffaf87;\n}\n\n.terminal .xterm-bg-color-216 {\n    background-color: #ffaf87;\n}\n\n.terminal .xterm-color-217 {\n    color: #ffafaf;\n}\n\n.terminal .xterm-bg-color-217 {\n    background-color: #ffafaf;\n}\n\n.terminal .xterm-color-218 {\n    color: #ffafd7;\n}\n\n.terminal .xterm-bg-color-218 {\n    background-color: #ffafd7;\n}\n\n.terminal .xterm-color-219 {\n    color: #ffafff;\n}\n\n.terminal .xterm-bg-color-219 {\n    background-color: #ffafff;\n}\n\n.terminal .xterm-color-220 {\n    color: #ffd700;\n}\n\n.terminal .xterm-bg-color-220 {\n    background-color: #ffd700;\n}\n\n.terminal .xterm-color-221 {\n    color: #ffd75f;\n}\n\n.terminal .xterm-bg-color-221 {\n    background-color: #ffd75f;\n}\n\n.terminal .xterm-color-222 {\n    color: #ffd787;\n}\n\n.terminal .xterm-bg-color-222 {\n    background-color: #ffd787;\n}\n\n.terminal .xterm-color-223 {\n    color: #ffd7af;\n}\n\n.terminal .xterm-bg-color-223 {\n    background-color: #ffd7af;\n}\n\n.terminal .xterm-color-224 {\n    color: #ffd7d7;\n}\n\n.terminal .xterm-bg-color-224 {\n    background-color: #ffd7d7;\n}\n\n.terminal .xterm-color-225 {\n    color: #ffd7ff;\n}\n\n.terminal .xterm-bg-color-225 {\n    background-color: #ffd7ff;\n}\n\n.terminal .xterm-color-226 {\n    color: #ffff00;\n}\n\n.terminal .xterm-bg-color-226 {\n    background-color: #ffff00;\n}\n\n.terminal .xterm-color-227 {\n    color: #ffff5f;\n}\n\n.terminal .xterm-bg-color-227 {\n    background-color: #ffff5f;\n}\n\n.terminal .xterm-color-228 {\n    color: #ffff87;\n}\n\n.terminal .xterm-bg-color-228 {\n    background-color: #ffff87;\n}\n\n.terminal .xterm-color-229 {\n    color: #ffffaf;\n}\n\n.terminal .xterm-bg-color-229 {\n    background-color: #ffffaf;\n}\n\n.terminal .xterm-color-230 {\n    color: #ffffd7;\n}\n\n.terminal .xterm-bg-color-230 {\n    background-color: #ffffd7;\n}\n\n.terminal .xterm-color-231 {\n    color: #ffffff;\n}\n\n.terminal .xterm-bg-color-231 {\n    background-color: #ffffff;\n}\n\n.terminal .xterm-color-232 {\n    color: #080808;\n}\n\n.terminal .xterm-bg-color-232 {\n    background-color: #080808;\n}\n\n.terminal .xterm-color-233 {\n    color: #121212;\n}\n\n.terminal .xterm-bg-color-233 {\n    background-color: #121212;\n}\n\n.terminal .xterm-color-234 {\n    color: #1c1c1c;\n}\n\n.terminal .xterm-bg-color-234 {\n    background-color: #1c1c1c;\n}\n\n.terminal .xterm-color-235 {\n    color: #262626;\n}\n\n.terminal .xterm-bg-color-235 {\n    background-color: #262626;\n}\n\n.terminal .xterm-color-236 {\n    color: #303030;\n}\n\n.terminal .xterm-bg-color-236 {\n    background-color: #303030;\n}\n\n.terminal .xterm-color-237 {\n    color: #3a3a3a;\n}\n\n.terminal .xterm-bg-color-237 {\n    background-color: #3a3a3a;\n}\n\n.terminal .xterm-color-238 {\n    color: #444444;\n}\n\n.terminal .xterm-bg-color-238 {\n    background-color: #444444;\n}\n\n.terminal .xterm-color-239 {\n    color: #4e4e4e;\n}\n\n.terminal .xterm-bg-color-239 {\n    background-color: #4e4e4e;\n}\n\n.terminal .xterm-color-240 {\n    color: #585858;\n}\n\n.terminal .xterm-bg-color-240 {\n    background-color: #585858;\n}\n\n.terminal .xterm-color-241 {\n    color: #626262;\n}\n\n.terminal .xterm-bg-color-241 {\n    background-color: #626262;\n}\n\n.terminal .xterm-color-242 {\n    color: #6c6c6c;\n}\n\n.terminal .xterm-bg-color-242 {\n    background-color: #6c6c6c;\n}\n\n.terminal .xterm-color-243 {\n    color: #767676;\n}\n\n.terminal .xterm-bg-color-243 {\n    background-color: #767676;\n}\n\n.terminal .xterm-color-244 {\n    color: #808080;\n}\n\n.terminal .xterm-bg-color-244 {\n    background-color: #808080;\n}\n\n.terminal .xterm-color-245 {\n    color: #8a8a8a;\n}\n\n.terminal .xterm-bg-color-245 {\n    background-color: #8a8a8a;\n}\n\n.terminal .xterm-color-246 {\n    color: #949494;\n}\n\n.terminal .xterm-bg-color-246 {\n    background-color: #949494;\n}\n\n.terminal .xterm-color-247 {\n    color: #9e9e9e;\n}\n\n.terminal .xterm-bg-color-247 {\n    background-color: #9e9e9e;\n}\n\n.terminal .xterm-color-248 {\n    color: #a8a8a8;\n}\n\n.terminal .xterm-bg-color-248 {\n    background-color: #a8a8a8;\n}\n\n.terminal .xterm-color-249 {\n    color: #b2b2b2;\n}\n\n.terminal .xterm-bg-color-249 {\n    background-color: #b2b2b2;\n}\n\n.terminal .xterm-color-250 {\n    color: #bcbcbc;\n}\n\n.terminal .xterm-bg-color-250 {\n    background-color: #bcbcbc;\n}\n\n.terminal .xterm-color-251 {\n    color: #c6c6c6;\n}\n\n.terminal .xterm-bg-color-251 {\n    background-color: #c6c6c6;\n}\n\n.terminal .xterm-color-252 {\n    color: #d0d0d0;\n}\n\n.terminal .xterm-bg-color-252 {\n    background-color: #d0d0d0;\n}\n\n.terminal .xterm-color-253 {\n    color: #dadada;\n}\n\n.terminal .xterm-bg-color-253 {\n    background-color: #dadada;\n}\n\n.terminal .xterm-color-254 {\n    color: #e4e4e4;\n}\n\n.terminal .xterm-bg-color-254 {\n    background-color: #e4e4e4;\n}\n\n.terminal .xterm-color-255 {\n    color: #eeeeee;\n}\n\n.terminal .xterm-bg-color-255 {\n    background-color: #eeeeee;\n}\n", ""]);
	
	// exports


/***/ },
/* 103 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-EditorWidget {\n    border-top: 1px solid #E0E0E0;\n    margin-top: 4px;\n}\n", ""]);
	
	// exports


/***/ },
/* 104 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-ImageWidget {\n  overflow: auto;\n  padding: 0 4px 4px 4px;\n}\n\n.jp-ImageWidget img {\n  max-width: 100%;\n  max-height: 100%;\n  margin: auto;\n}\n", ""]);
	
	// exports


/***/ },
/* 105 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, ".faqsvg {\n    float: left;\n}\n.faqbody {\n  font-family: 'Helvetica Neue', 'Helvetica', 'Arial', sans-serif;\n}\n.faqh1 {\n  font-size: 26px;\n  font-weight: 300;\n  color: #313940;\n  margin: 5px 0 0 20px;\n}\n#faqheader {\n  width: 412px;\n  display: flex;\n  margin: 65px auto 0 auto;\n  text-align: center;\n}\n.faqh2 {\n  font-size: 14px;\n  font-weight: 300;\n  color: #9E9E9E;\n  margin: 52px 0 0 0;\n}\n.faqul {\n  margin: 0 0 0 0;\n}\nli.faqquestion {\n  cursor: pointer;\n  font-size: 20px;\n  color: #616161;\n  font-weight: 400;\n  line-height: 150%;\n  list-style-type: none;\n  margin: 28px 0 0 0;\n}\nli.faqanswer{\n  font-size: 15px;\n  font-weight: 200;\n  color: #9E9E9E;\n  line-height: 160%;\n  border-left: 2px solid #9E9E9E;\n  padding-left: 25px;\n  list-style-type: none;\n  margin: 28px 0 0 0;\n}\nli.faqquestion:hover {\n  color: #42A5F5;\n  h1 {\n    color: brown;\n  }\n}\nli.faqquestion:focus{\n  color: #42A5F5;\n}\n.hide {\n  display:none;\n}\n\nli>faqanswer {\n  color: #4A90E2;\n  text-decoration: none;\n}\n#faqcontent {\n  margin: 0 auto 0 auto;\n  display: block;\n  width: 94%;\n  max-width: 675px;\n\n}\nh1 span.short-faq {\n  display: none;\n}\n\nh1 span.long-faq {\n  color: #616161;\n  display: block;\n}\n.faqa {\n    text-decoration: none;\n    color: #2196F3;\n}\n", ""]);
	
	// exports


/***/ },
/* 106 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-RunningSessions {\n  display: flex;\n  flex-direction: column;\n}\n\n\n.jp-RunningSessions-header {\n  flex: 0 0 auto;\n  display: flex;\n  flex-direction: row;\n}\n\n\n.jp-RunningSessions-headerTitle {\n  flex: 1 1 auto;\n}\n\n\n.jp-RunningSessions-headerRefresh {\n  flex: 0 0 auto;\n}\n\n\n.jp-RunningSessions-section {\n  display: flex;\n  flex: 0 1 auto;\n  flex-direction: column;\n}\n\n\n.jp-RunningSessions-sectionHeader {\n  flex: 0 0 auto;\n}\n\n\n.jp-RunningSessions-sectionContainer {\n  flex: 1 1 auto;\n  margin: 0;\n  padding: 0;\n  overflow: auto;\n}\n\n\n.jp-RunningSessions-sectionList {\n  margin: 0;\n  padding: 0;\n  list-style-type: none;\n}\n\n\n.jp-RunningSessions-item {\n  display: flex;\n  flex-direction: row;\n}\n\n\n.jp-RunningSessions-itemIcon {\n  flex: 0 0 auto;\n}\n\n\n.jp-RunningSessions-itemLabel {\n  flex: 1 1 auto;\n}\n\n\n.jp-RunningSessions-itemKernelName {\n  flex: 0 0 auto;\n}\n\n\n.jp-RunningSessions-itemShutdown {\n  flex: 0 0 auto;\n}\n", ""]);
	
	// exports


/***/ },
/* 107 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n\n.jp-RunningSessions {\n  min-width: 300px;\n  color: #757575;\n  background: #FAFAFA;\n  font-size: 13px;\n}\n\n\n.jp-RunningSessions-header {\n  border-bottom: 1px solid #E0E0E0;\n}\n\n\n.jp-RunningSessions-headerTitle {\n  padding: 6px;\n  font-size: 12px;\n  vertical-align: middle;\n}\n\n\n.jp-RunningSessions-headerRefresh {\n  flex: 1 1 auto;\n  max-width: 100px;\n  padding: 4px 6px;\n  background: #FAFAFA;\n  color: #757575;\n  border: none;\n  font-size: 14px;\n  outline: 0;\n  padding-top: 8px;\n  padding-bottom: 8px;\n}\n\n\n.jp-RunningSessions-headerRefresh:before {\n  font-family: FontAwesome;\n  content: '\\F021'; /* refresh */\n  font-size: 12px;\n}\n\n\n.jp-RunningSessions-headerRefresh:hover {\n  background: #F5F5F5;\n  border-color: #D0D0D0;\n  z-index: 1; /* raise overlapping border */\n}\n\n\n.jp-RunningSessions-sectionHeader {\n  margin: 4px 0px;\n  padding: 4px 12px;\n  font-size: 11px;\n  font-weight: 600;\n  text-transform: uppercase;\n  border-bottom: 1px solid #E0E0E0;\n  letter-spacing: 2px;\n}\n\n\n.jp-RunningSessions-item {\n  padding: 3px 12px;\n  font-size: 13px;\n  font-weight: 500;\n  color: #757575;\n}\n\n\n.jp-RunningSessions-item:hover {\n    background: #F5F5F5;\n}\n\n\n.jp-RunningSessions-itemIcon {\n  padding: 1px 4px;\n  font-size: 14px;\n  font-family: FontAwesome;\n  color: #5e5e5e;\n  margin-right: 7px;\n  margin-left: 7px;\n  vertical-align: baseline;\n}\n\n.jp-RunningSessions-itemIcon.jp-mod-notebook:before {\n  content: '\\F02D';\n}\n\n\n.jp-RunningSessions-itemIcon.jp-mod-file:before {\n  content: '\\F016';\n}\n\n\n.jp-RunningSessions-itemIcon.jp-mod-terminal:before {\n  content: '\\F120';\n}\n\n.jp-RunningSessions-itemLabel {\n  padding: 1px;\n}\n\n.jp-RunningSessions-itemKernelName {\n  padding: 1px;\n  margin-right: 7px;\n}\n\n\n.jp-RunningSessions-itemShutdown {\n  padding: 1px 4px;\n  color: #ffffff;\n  background: #f0ad4e;\n  border-radius: 1px;\n  cursor: pointer;\n}\n", ""]);
	
	// exports


/***/ },
/* 108 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n#about-jupyterlab {\n    padding: 2em;\n}\n", ""]);
	
	// exports


/***/ },
/* 109 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.p-CommandPalette {\n  min-width: 300px;\n  padding-bottom: 0px;\n  color: #757575;\n  background: #FAFAFA;\n}\n\n\n.p-CommandPalette-search {\n  margin-bottom: 4px;\n}\n\n\n.p-CommandPalette-inputWrapper {\n  padding: 4px 6px;\n  margin: 4px;\n  background: white;\n  border: 1px solid #E0E0E0;\n  border-radius: 1px;\n}\n\n\n.p-CommandPalette-input {\n  width: 100%;\n  outline: none;\n  border: none;\n  font-size: 13px;\n}\n\n\n.p-CommandPalette-header {\n  margin: 4px 0px;\n  padding: 4px 12px;\n  font-size: 11px;\n  font-weight: 600;\n  text-transform: uppercase;\n  border-bottom: 1px solid #E0E0E0;\n  letter-spacing: 2px;\n}\n\n\n.p-CommandPalette-command {\n  padding: 4px 12px;\n  font-size: 13px;\n  font-weight: 500;\n  color: #757575;\n}\n\n\n.p-CommandPalette-commandCaption {\n  display: none;\n}\n\n\n.p-CommandPalette-header:hover:not(.p-mod-active),\n.p-CommandPalette-command:hover:not(.p-mod-active) {\n  background: #EEEEEE;\n}\n\n\n.p-CommandPalette-header mark {\n  color: #424242;\n  background: inherit;\n}\n\n\n.p-CommandPalette-command.p-mod-active {\n  color: rgba(255,255,255,0.7);\n  background: #2196F3;\n}\n\n\n.p-CommandPalette-command.p-mod-active .p-CommandPalette-commandCaption {\n  color: inherit;\n}\n\n\n.p-CommandPalette-command.p-mod-active mark {\n    background: inherit;\n    color: white;\n}\n\n\n.p-CommandPalette-command mark {\n    background: inherit;\n    color: #757575;\n}\n", ""]);
	
	// exports


/***/ },
/* 110 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Completion-item {\n  margin: 0;\n  min-width: 150px;\n  padding: 0 2px;\n}\n\n\n.jp-Completion-item:nth-child(odd) {\n  background: #FFFFFF;\n}\n\n\n.jp-Completion-item.jp-mod-active {\n  background: #BFBFBF;\n}\n\n\n.jp-Completion-item code {\n  font-size: 14px;\n  line-height: 25px;\n}\n\n\n.jp-Completion-item mark {\n  font-weight: bold;\n  text-decoration: underline;\n  background: inherit;\n  color: inherit;\n}\n", ""]);
	
	// exports


/***/ },
/* 111 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Console {\n  height: 100%;\n  padding: 0 10px 20px 10px;\n}\n\n\n.jp-Console .jp-Cell {\n  padding-top: 0;\n  padding-bottom: 0;\n}\n\n\n.jp-Console .jp-InputArea-editor.jp-CellEditor {\n  background: transparent;\n  border-color: transparent;\n}\n\n\n.jp-Console-prompt {\n  border-color: #66BB6A;\n  border-left-width: 1px;\n  background: linear-gradient(to right, #66BB6A -40px, #66BB6A 5px, transparent 5px, transparent 100%);\n}\n\n\n.jp-Console .jp-InputArea-prompt {\n  flex-basis: auto;\n  text-align: left;\n}\n\n\n.jp-Console .jp-Output-prompt {\n  flex-basis: auto;\n  text-align: left;\n}\n\n\n.jp-Console .jp-Output pre {\n  border: none;\n  margin: 1px 0 0 5px;\n  overflow-x: auto;\n  overflow-y: auto;\n  word-break: break-all;\n  word-wrap: break-word;\n  white-space: pre-wrap;\n}\n\n\n.jp-Console .jp-Console-banner .jp-InputArea-prompt {\n  display: none;\n}\n\n\n.jp-ConsoleTooltip {\n  position: absolute;\n  background: #FFFFCA;\n  border: 1px solid #000000;\n  z-index: 10001;\n}\n\n.jp-ConsoleTooltip pre {\n  margin: 0;\n  padding: 2px;\n}\n\n\n/* ansi_up creates classed spans for console foregrounds and backgrounds. */\n.jp-ConsoleTooltip pre .ansi-black-fg { color: #3A3A3A; }\n\n\n.jp-ConsoleTooltip pre .ansi-red-fg { color: #DD948E; }\n\n\n.jp-ConsoleTooltip pre .ansi-green-fg { color: #B6D1AA; }\n\n\n.jp-ConsoleTooltip pre .ansi-yellow-fg { color: #F3D57C; }\n\n\n.jp-ConsoleTooltip pre .ansi-blue-fg { color: #8AA9D5; }\n\n\n.jp-ConsoleTooltip pre .ansi-magenta-fg { color: #CBAFD5; }\n\n\n.jp-ConsoleTooltip pre .ansi-cyan-fg { color: #9AD1D4; }\n\n\n.jp-ConsoleTooltip pre .ansi-white-fg { color: #EFEFEF; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-black-fg { color: #5E5D5E; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-red-fg { color: #E69B94; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-green-fg { color: #D1F0C3; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-yellow-fg { color: #F4D799; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-blue-fg { color: #A6CBFE; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-magenta-fg { color: #E8C8F3; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-cyan-fg { color: #B1F1F6; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-white-fg { color: #FFFFFF; }\n\n\n.jp-ConsoleTooltip pre .ansi-black-bg { background-color: #3B3B3B; }\n\n\n.jp-ConsoleTooltip pre .ansi-red-bg { background-color: #DE958F; }\n\n\n.jp-ConsoleTooltip pre .ansi-green-bg { background-color: #B7D2AB; }\n\n\n.jp-ConsoleTooltip pre .ansi-yellow-bg { background-color: #F4D67D; }\n\n\n.jp-ConsoleTooltip pre .ansi-blue-bg { background-color: #8BAAD6; }\n\n\n.jp-ConsoleTooltip pre .ansi-magenta-bg { background-color: #CCB0D6; }\n\n\n.jp-ConsoleTooltip pre .ansi-cyan-bg { background-color: #9BD2D5; }\n\n\n.jp-ConsoleTooltip pre .ansi-white-bg { background-color: #F0F0F0; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-black-bg { background-color: #5F5E5F; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-red-bg { background-color: #E79C95; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-green-bg { background-color: #D2F1C4; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-yellow-bg { background-color: #F5D89A; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-blue-bg { background-color: #A7CCFF; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-magenta-bg { background-color: #E8C8F3; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-cyan-bg { background-color: #B1F1F6; }\n\n\n.jp-ConsoleTooltip pre .ansi-bright-white-bg { background-color: #FFFFFF; }\n\n\n.jp-Completion {\n  background: #EEEEEE;\n  border: 1px solid #000000;\n  list-style-type: none;\n  margin: 0;\n  overflow: auto;\n  padding: 0;\n  position: absolute;\n  z-index: 10001;\n}", ""]);
	
	// exports


/***/ },
/* 112 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Help {\n  min-width: 480px;\n  background: white;\n}\n\n\n.jp-Help > iframe {\n  border: none;\n}\n", ""]);
	
	// exports


/***/ },
/* 113 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-ImageConsole {\n  background-image: url(" + __webpack_require__(114) + ");\n}\n\n\n.jp-ImageJupyterLab {\n  background-image: url(" + __webpack_require__(115) + ");\n}\n\n\n.jp-ImageNotebook {\n  background-image: url(" + __webpack_require__(116) + ");\n}\n\n\n.jp-ImageTerminal {\n  background-image: url(" + __webpack_require__(117) + ");\n}\n\n\n.jp-ImageTextEditor {\n  background-image: url(" + __webpack_require__(118) + ");\n}\n\n\n.jp-JupyterIcon {\n  background-image: url(" + __webpack_require__(119) + ");\n  background-size: 16px;\n  margin: 2px;\n  margin-left: 10px;\n  margin-right: 0px;\n  padding-right: 0px;\n}\n", ""]);
	
	// exports


/***/ },
/* 114 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "a5f896d73c05dd2cec16fd54f7b6d38b.svg";

/***/ },
/* 115 */
/***/ function(module, exports) {

	module.exports = "data:image/svg+xml;base64,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"

/***/ },
/* 116 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "67210cba51efc06308353fa274b6d389.svg";

/***/ },
/* 117 */
/***/ function(module, exports) {

	module.exports = "data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjwhLS0gR2VuZXJhdG9yOiBBZG9iZSBJbGx1c3RyYXRvciAxOS4xLjAsIFNWRyBFeHBvcnQgUGx1Zy1JbiAuIFNWRyBWZXJzaW9uOiA2LjAwIEJ1aWxkIDApICAtLT4NCjxzdmcgdmVyc2lvbj0iMS4xIiBpZD0iTGF5ZXJfMSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeD0iMHB4IiB5PSIwcHgiDQoJIHZpZXdCb3g9IjAgMCAxOTIgMTkyIiBzdHlsZT0iZW5hYmxlLWJhY2tncm91bmQ6bmV3IDAgMCAxOTIgMTkyOyIgeG1sOnNwYWNlPSJwcmVzZXJ2ZSI+DQo8c3R5bGUgdHlwZT0idGV4dC9jc3MiPg0KCS5zdDB7ZmlsbDojQUFBQUFBO3N0cm9rZTojNzY3NDc0O3N0cm9rZS13aWR0aDoyO3N0cm9rZS1taXRlcmxpbWl0OjEwO30NCgkuc3Qxe2ZpbGw6IzIxMjEyMTtzdHJva2U6Izc2NzQ3NDtzdHJva2Utd2lkdGg6MjtzdHJva2UtbWl0ZXJsaW1pdDoxMDt9DQoJLnN0MntmaWxsOiNGRkZGRkY7fQ0KCS5zdDN7ZmlsbDojRTQ2RTJFO30NCjwvc3R5bGU+DQo8ZyBpZD0iTGF5ZXJfMV8xXyI+DQoJPHJlY3QgeD0iOCIgeT0iMzIiIGNsYXNzPSJzdDAiIHdpZHRoPSIxNzYiIGhlaWdodD0iMTI4Ii8+DQoJPHJlY3QgeD0iMTYiIHk9IjQwIiBjbGFzcz0ic3QxIiB3aWR0aD0iMTYwIiBoZWlnaHQ9IjExMiIvPg0KCTxnPg0KCQk8cGF0aCBjbGFzcz0ic3QyIiBkPSJNNTMuMSw4OS4xYy0xLjEtMC44LTIuMi0xLjQtMy4yLTEuOHMtMi4yLTAuNi0zLjUtMC42Yy0yLjIsMC0zLjMsMC43LTMuMywyLjJjMCwwLjYsMC4zLDEuMSwxLDEuNA0KCQkJYzAuNywwLjQsMS42LDAuOCwyLjYsMS4yYzEsMC40LDIuMiwwLjgsMy40LDEuMmMxLjIsMC40LDIuMywxLDMuNCwxLjdjMSwwLjcsMS45LDEuNSwyLjYsMi41YzAuNywxLDEsMi4yLDEsMy42DQoJCQljMCwyLTAuNywzLjgtMi4xLDUuM2MtMS40LDEuNS0zLjQsMi41LTYuMSwyLjl2Ny4yaC00Ljd2LTdjLTEuNi0wLjItMy4yLTAuNi00LjgtMS4yYy0xLjctMC43LTMuMS0xLjUtNC4zLTIuNmwzLjEtNC44DQoJCQljMS41LDAuOSwzLDEuNyw0LjMsMi4yYzEuNCwwLjUsMi44LDAuOCw0LjMsMC44YzEuMiwwLDItMC4yLDIuNi0wLjZzMC45LTAuOSwwLjktMS42cy0wLjMtMS4yLTEtMS43Yy0wLjctMC40LTEuNi0wLjktMi42LTEuMw0KCQkJcy0yLjItMC44LTMuNC0xLjNjLTEuMi0wLjQtMi4zLTEtMy40LTEuN2MtMS0wLjctMS45LTEuNS0yLjYtMi41Yy0wLjctMS0xLTIuMi0xLTMuN2MwLTIuMSwwLjctMy44LDIuMS01LjINCgkJCWMxLjQtMS40LDMuMy0yLjMsNS44LTIuNnYtNi4zaDQuN1Y4MWMxLjcsMC4yLDMuMSwwLjcsNC4zLDEuNGMxLjIsMC43LDIuMywxLjUsMy4zLDIuNkw1My4xLDg5LjF6Ii8+DQoJCTxwYXRoIGNsYXNzPSJzdDMiIGQ9Ik04Ni43LDExMy4ydjUuM2gtMjN2LTUuM0g4Ni43eiIvPg0KCTwvZz4NCjwvZz4NCjwvc3ZnPg0K"

/***/ },
/* 118 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__.p + "2b609d364e2e1d67ba33a81c58d9eb8a.svg";

/***/ },
/* 119 */
/***/ function(module, exports) {

	module.exports = "data:image/svg+xml;base64,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"

/***/ },
/* 120 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-MarkdownWidget {\n  border-top: 1px solid #E0E0E0;\n  padding: 14px;\n}\n", ""]);
	
	// exports


/***/ },
/* 121 */
/***/ function(module, exports, __webpack_require__) {

	exports = module.exports = __webpack_require__(11)();
	// imports
	
	
	// module
	exports.push([module.id, "/*-----------------------------------------------------------------------------\n| Copyright (c) Jupyter Development Team.\n| Distributed under the terms of the Modified BSD License.\n|----------------------------------------------------------------------------*/\n.jp-Landing {\n  color: #757575;\n  position: absolute;\n  z-index: 10000;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  top: 0px;\n  left: 0px;\n  margin: 0;\n  padding: 0;\n  width: 100%;\n  height: 100%;\n}\n\n\n.jp-Landing-dialog {\n  padding-bottom: 20px;\n  font-size: 16px;\n  color: #757575;\n  background: #FAFAFA;\n  margin-left: auto;\n  margin-right: auto;\n  text-align: center;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  flex-direction: column;\n  border: 1px solid #BDBDBD;\n  border-radius: 2px;\n  box-shadow: 0px 2px 2px 0px rgba(0,0,0,0.5);\n}\n\n\n.jp-Landing-logo {\n  flex: 0 0 40px;\n  margin-left: auto;\n  margin-right: auto;\n  width: 100%;\n  background-color: white;\n  background-size: 193px 40px;\n  background-repeat: no-repeat;\n  background-position: center top;\n  padding-bottom: 20px;\n  border-bottom: 1px solid #BDBDBD;\n}\n\n\n.jp-Landing-title {\n  padding-top: 20px;\n  background: white;\n  width: 100%;\n}\n\n\n.jp-Landing-header {\n\n  padding-top: 20px;\n  padding-bottom: 8px;\n}\n\n\n.jp-Landing-body {\n  display: flex;\n  flex-direction: row;\n  padding-left: 20px;\n  padding-right: 20px;\n}\n\n\n.jp-Landing-column {\n  padding-left: 20px;\n  padding-right: 20px;\n  display: flex;\n  flex-direction: column;\n}\n\n\n.jp-Landing-image {\n  flex: 0 0 auto;\n  min-height: 72px;\n  max-height: 72px;\n  min-width: 56px;\n  max-width: 56px;\n  background-size: 56px 72px;\n  background-repeat: no-repeat;\n\n}\n\n\n.jp-Landing-image:hover {\n  cursor: pointer;\n}\n\n\n.jp-Landing-text {\n  flex: 0 0 auto;\n  font-size: 12px;\n  padding-top: 8px;\n}\n\n.jp-Landing-tour {\n    color: #f37a3c;\n    margin-top: 20px;\n    cursor: pointer;\n}\n", ""]);
	
	// exports


/***/ },
/* 122 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var phosphor_widget_1 = __webpack_require__(20);
	var phosphor_tabs_1 = __webpack_require__(40);
	/**
	 * The about page extension.
	 */
	exports.aboutExtension = {
	    id: 'jupyter.extensions.about',
	    activate: activateAbout
	};
	function activateAbout(app) {
	    var widget = new phosphor_widget_1.Widget();
	    var commandId = 'about-jupyterlab:show';
	    widget.id = 'about-jupyterlab';
	    widget.title.text = 'About';
	    widget.title.closable = true;
	    widget.node.innerHTML = "\n<h1>Welcome to the JupyterLab pre-alpha preview</h1>\n\n<p>This demo gives an pre-alpha-level developer preview of the JupyterLab environment. <b>It is not ready for general usage yet.</b> We are developing JupyterLab at <a href=\"https://github.com/jupyter/jupyterlab\">https://github.com/jupyter/jupyterlab</a>. Pull requests are welcome!</p>\n\n<p>Click on the JupyterLab tab for the initial JupyterLab screen.</p>\n\n<p>Here is a brief description of some of the things you'll find in this demo.</p>\n\n<h2>File Browser</h2>\n\n<p>Clicking the \"Files\" tab, located on the left, will toggle the file browser. Navigate into directories by double-clicking, and use the breadcrumbs at the top to navigate out. Create a new file/directory by clicking the plus icon at the top. Click the middle icon to upload files, and click the last icon to reload the file listing. Drag and drop files to move them to subdirectories. Click on a selected file to rename it. Sort the list by clicking on a column header. Open a file by double-clicking it or dragging it into the main area. Opening an image displays the image. Opening a code file opens a code editor. Opening a notebook opens a very preliminary notebook component.</p>\n\n<h2>Command Palette</h2>\n\n<p>Clicking the \"Commands\" tab, located on the left, will toggle the command palette. Execute a command by clicking, or navigating with your arrow keys and pressing Enter. Filter commands by typing in the text box at the top of the palette. The palette is organized into categories, and you can filter on a single category by clicking on the category header or by typing the header surrounded by colons in the search input (e.g., <code>:file:</code>).</p>\n\n<p>You can try these things out from the command palette:</p>\n\n<ul>\n<li>Open a new terminal (requires OS X or Linux)</li>\n<li>Open a ipython console</li>\n<li>Open a new file</li>\n<li>Save a file</li>\n<li>Open up a help panel on the right</li>\n</ul>\n\n<h2>Main area</h2>\n\n<p>The main area is divided into panels of tabs. Drag a tab around the area to split the main area in different ways. Drag a tab to the center of a panel to move a tab without splitting the panel (in this case, the whole panel will highlight instead of just a portion). Resize panels by dragging their borders (be aware that panels and sidebars also have a minimum width). A file that contains changes to be saved has a star for a close icon.</p>\n\n<h2>Notebook</h2>\n\n<p>Opening a notebook will open a minimally-featured notebook. Code execution, Markdown rendering, and basic cell toolbar actions are supported.  Future versions will add more features from the existing Jupyter notebook.</p>\n";
	    widget.node.style.overflowY = 'auto';
	    app.commands.add([{
	            id: commandId,
	            handler: function () {
	                if (!widget.isAttached)
	                    app.shell.addToMainArea(widget);
	                var stack = widget.parent;
	                if (!stack) {
	                    return;
	                }
	                var tabs = stack.parent;
	                if (tabs instanceof phosphor_tabs_1.TabPanel) {
	                    tabs.currentWidget = widget;
	                }
	            }
	        }]);
	    app.palette.add([{
	            command: commandId,
	            text: 'About JupyterLab',
	            category: 'Help'
	        }]);
	}


/***/ },
/* 123 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var phosphor_widget_1 = __webpack_require__(20);
	var widgettracker_1 = __webpack_require__(124);
	var phosphor_tabs_1 = __webpack_require__(40);
	var $ = __webpack_require__(125);
	/**
	 * The faq page extension.
	 */
	exports.faqExtension = {
	    id: 'jupyter.extensions.FAQ',
	    activate: activateFAQ
	};
	var hasBeenAttatched = false;
	var FAQWidget = (function (_super) {
	    __extends(FAQWidget, _super);
	    function FAQWidget() {
	        _super.apply(this, arguments);
	    }
	    FAQWidget.prototype.onAfterAttach = function (msg) {
	        if (!hasBeenAttatched) {
	            $(document).ready(function () {
	                $('li.faqanswer').addClass('hide');
	                $('li.faqquestion').click(function () {
	                    $(this).data('clicked', false).next().slideToggle(200).siblings('li.faqanswer').slideUp(200);
	                });
	            });
	            hasBeenAttatched = true;
	        }
	    };
	    return FAQWidget;
	}(phosphor_widget_1.Widget));
	function activateFAQ(app) {
	    var widget = new FAQWidget();
	    var commandId = 'faq-jupyterlab:show';
	    widget.id = 'faq-jupyterlab';
	    widget.title.text = 'FAQ';
	    widget.title.closable = true;
	    widget.node.innerHTML = "\n  <body>\n    <section id=\"faqheader\">\n      <svg width=\"49px\" height=\"49px\" viewBox=\"0 0 49 49\" version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n          <!-- Generator: Sketch 3.8.3 (29802) - http://www.bohemiancoding.com/sketch -->\n          <title>Group 2</title>\n          <desc>Created with Sketch.</desc>\n          <defs>\n              <linearGradient x1=\"50%\" y1=\"0%\" x2=\"50%\" y2=\"100%\" id=\"linearGradient-1\">\n                  <stop stop-color=\"#90CAF9\" offset=\"0%\"></stop>\n                  <stop stop-color=\"#2196F3\" offset=\"100%\"></stop>\n              </linearGradient>\n          </defs>\n          <g id=\"Page-1\" stroke=\"none\" stroke-width=\"1\" fill=\"none\" fill-rule=\"evenodd\">\n              <g id=\"JupyterLab---Main\" transform=\"translate(-638.000000, -156.000000)\">\n                  <g id=\"FAQ-Window\" transform=\"translate(321.000000, 4.000000)\">\n                      <g id=\"FAQ-Text-Normal\" transform=\"translate(0.000000, 24.000000)\">\n                          <g id=\"Group-9\" transform=\"translate(317.000000, 128.000000)\">\n                              <g id=\"Group-2\">\n                                  <path d=\"M24.5,49 C38.0309764,49 49,38.0309764 49,24.5 C49,10.9690236 38.0309764,0 24.5,0 C10.9690236,0 0,10.9690236 0,24.5 C0,38.0309764 10.9690236,49 24.5,49 Z\" id=\"Oval-1\" fill=\"url(#linearGradient-1)\"></path>\n                                  <path d=\"M26.2142159,38.4121298 C26.2142159,37.1812999 25.221611,36.188695 23.9510769,36.188695 C22.7202469,36.188695 21.7276421,37.1812999 21.7276421,38.4121298 C21.7276421,39.682664 22.7202469,40.6752688 23.9510769,40.6752688 C25.221611,40.6752688 26.2142159,39.682664 26.2142159,38.4121298 L26.2142159,38.4121298 Z M25.9759907,33.6476267 C25.9362865,32.0991632 26.2142159,30.5904039 26.8097788,29.2801655 C27.5244542,27.6919978 28.517059,26.7788014 29.5890722,25.865605 C30.8596064,24.7141834 32.3286615,23.4436492 32.9639286,21.0216935 C33.3609705,19.6320467 33.4006747,18.5203293 33.1624496,17.0909784 C32.844816,15.5028107 32.1698448,14.0337556 31.1772399,12.882334 C30.1846351,11.7309124 28.9538052,10.8971243 27.5244542,10.3809698 C26.4127368,9.98392791 25.420132,9.86481533 24.7848649,9.82511114 C24.4275272,9.78540694 23.2761056,9.74570275 21.8070505,10.1030405 C19.861545,10.619195 18.193969,11.651504 16.9234348,13.0808549 C15.6529006,14.5896143 14.8588168,16.4954155 14.7,18.4806251 L18.7895318,18.8776671 C18.8689402,18.1629916 19.1071654,16.7336407 20.060066,15.5028107 C21.7673463,13.3190801 24.387823,13.4778969 24.5069356,13.4778969 C25.1819069,13.5176011 26.8891871,13.7955304 28.0406087,15.2645855 C28.5567632,15.9395568 28.914101,16.813049 29.0729177,17.7659497 C29.2317345,18.6791461 29.2317345,19.2350048 28.9935094,20.108497 C28.6758758,21.4584396 27.9214961,22.173115 26.8494829,23.2451282 C25.618653,24.436254 24.1495978,25.1509295 23.0378805,27.5728852 C22.2040924,29.4389823 21.8070505,31.4638961 21.8467547,33.6476267 L25.9759907,33.6476267 Z\" id=\"?\" fill=\"#FFFFFF\"></path>\n                              </g>\n                          </g>\n                      </g>\n                  </g>\n              </g>\n          </g>\n      </svg>\n        <h1 class=\"faqh1\">\n          <span class=\"short-faq\">FAQ</span><span class=\"long-faq\">Frequently Asked Questions</span>\n        </h1>\n    </section>\n    <p>\n      <section id=\"faqcontent\" >\n        <h2 class=\"faqh2\">\n          THE BASICS\n        </h2>\n        <ul class=\"faqul\">\n          <li class=\"faqquestion\"> What is JupyterLab? </li>\n          <li class=\"faqanswer\"> JupyterLab allows users to arrange multiple jupyter notebooks, text editors, terminals, output areas, etc. on a single page with multiple panels and tabs into one application. The codebase and UI of JupyterLab is based on a flexible plugin system that makes it easy to extend with new components.</li>\n          <li class=\"faqquestion\"> What is a Jupyter Notebook? </li>\n          <li class=\"faqanswer\"> Central to the project is the Jupyter Notebook, a web-based platform that allows users to combine live code, equations, narrative text, visualizations, interactive dashboards and other media. Together these building blocks make science and data reproducible across over 40 programming languages and combine to form what we call a computational narrative.</li>\n          <li class=\"faqquestion\"> How stable is JupyterLab? </li>\n          <li class=\"faqanswer\"> JupyterLab is currently in a alpha release and not ready for public use as new features and bug fixes are being added very frequently. We strongly recommend to backup your work before using JupyterLab. However, testing, development, and user feedback are greatly appreciated. </li>\n          <li class=\"faqquestion\"> I\u2019m confused with the interface. How do I navigate around JupyterLab? </li>\n          <li class=\"faqanswer\"> Checkout the Jupyter Lab tour (look in the help section). </li>\n        </ul>\n        <h2 class=\"faqh2\">\n          FEATURES\n        </h2>\n        <ul class=\"faqul\">\n          <li class=\"faqquestion\"> How do I add more kernels/languages to JupyterLab? </li>\n          <li class=\"faqanswer\"> To add more languages to the JupyterLab you must install a new kernel. Installing a kernel is usually fairly simple and can be done with a couple terminal commands. However the instructions for installing kernels is different for each language. For further instructions, click this <a class=\"faqa\" target=\"_blank\" href=\"http://jupyter.readthedocs.io/en/latest/install-kernel.html\">link</a>. </li>\n          <li class=\"faqquestion\"> How can I share my notebooks? </li>\n          <li class=\"faqanswer\"> You can either publish your notebooks on GitHub or use a free service such as <a class=\"faqa\" target=\"_blank\" href=\"https://nbviewer.jupyter.org/\">nbviewer.org</a> to render your notebooks online. </li>\n        </ul>\n        <h2 class=\"faqh2\">\n        DEVELOPER\n        </h2>\n        <ul class=\"faqul\">\n        <li class=\"faqquestion\"> How do I report a bug? </li>\n        <li class=\"faqanswer\"> You can open an issue on our <a class=\"faqa\" target=\"_blank\" href=\"https://github.com/jupyter/jupyterlab/issues\">github repository</a>. Please check already opened issues before posting. </li>\n        <li class=\"faqquestion\"> I have security concerns about JupyterLab.</li>\n        <li class=\"faqanswer\"> If you have any inquiries, concerns, or thought you found a security vulnerability, please write to us at <a class=\"faqa\" href=\"mailto:security@jupyter.org\">security@jupyter.org</a>. We will do our best to respond to you promptly.  </li>\n        <li class=\"faqquestion\"> How can I contribute? </li>\n        <li class=\"faqanswer\"> There are many ways to contribute to JupyterLab. Whether you are an experienced python programmer or a newcomer, any interested developers are welcome. You can learn about the JupyterLab codebase by watching [Brian Granger\u2019s Keynote] and [talk] at scipy 2016, as well as our tutorial walkthrough and documentation. Also, feel free to ask questions on our <a class=\"faqa\" target=\"_blank\" href=\"https://github.com/jupyter/jupyterlab\">github</a> or through any of our <a class=\"faqa\" target=\"_blank\" href=\"http://jupyter.org/community.html\">community resources</a>. </li>\n        </ul>\n    </section>\n    </p>\n  </body>\n  ";
	    widget.node.style.overflowY = 'auto';
	    var tracker = new widgettracker_1.WidgetTracker();
	    var activeFAQ;
	    tracker.activeWidgetChanged.connect(function (sender, widget) {
	        activeFAQ = widget;
	    });
	    app.commands.add([{
	            id: commandId,
	            handler: function () {
	                if (!widget.isAttached)
	                    app.shell.addToMainArea(widget);
	                var stack = widget.parent;
	                if (!stack) {
	                    return;
	                }
	                var tabs = stack.parent;
	                if (tabs instanceof phosphor_tabs_1.TabPanel) {
	                    tabs.currentWidget = widget;
	                }
	            }
	        }]);
	    app.palette.add([{
	            command: commandId,
	            text: 'FAQ',
	            category: 'Help',
	            caption: 'Frequently Asked Questions'
	        }]);
	}


/***/ },
/* 124 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var phosphor_disposable_1 = __webpack_require__(8);
	var phosphor_signaling_1 = __webpack_require__(22);
	var phosphor_tabs_1 = __webpack_require__(40);
	/**
	 * The class name added to the currently active widget's title.
	 */
	var SEMANTIC_FOCUS_CLASS = 'jp-mod-semanticFocus';
	/**
	 * An object that tracks the active widget in an application.
	 */
	var WidgetTracker = (function () {
	    /**
	     * Construct a new widget tracker.
	     */
	    function WidgetTracker() {
	        this._widgets = [];
	        this._activeWidget = null;
	        // TODO: Replace this with message filters on semantic-focus
	        // events when available.
	        document.body.addEventListener('focus', this, true);
	    }
	    Object.defineProperty(WidgetTracker.prototype, "activeWidgetChanged", {
	        /**
	         * A signal emitted when the active widget changes.
	         */
	        get: function () {
	            return activeWidgetChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(WidgetTracker.prototype, "isDisposed", {
	        /**
	         * Test whether the widget tracker has been disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._widgets === null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(WidgetTracker.prototype, "widgets", {
	        /**
	         * The read-only list of tracked widgets.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._widgets.slice();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(WidgetTracker.prototype, "activeWidget", {
	        /**
	         * The currently active widget.
	         *
	         * #### Notes
	         * This is set automatically due to user events but can
	         * also be set programatically.
	         * The widget must be one of the current widgets.
	         * The widget will be activated in the application shell.
	         * The [[activeWidgetChanged]] signal will be emitted.
	         */
	        get: function () {
	            return this._activeWidget;
	        },
	        set: function (widget) {
	            if (this._activeWidget === widget) {
	                return;
	            }
	            if (this._widgets.indexOf(widget) === -1) {
	                return;
	            }
	            // Toggle the active class in the widget titles.
	            if (this._activeWidget) {
	                var className = this._activeWidget.title.className;
	                className = className.replace(SEMANTIC_FOCUS_CLASS, '');
	                this._activeWidget.title.className = className;
	            }
	            this._activeWidget = widget;
	            if (widget) {
	                widget.title.className += " " + SEMANTIC_FOCUS_CLASS;
	            }
	            this.activeWidgetChanged.emit(widget);
	            // Activate the widget in the dock panel.
	            // TODO: Use an API for this for this when available.
	            var stack = widget.parent;
	            if (!stack) {
	                return;
	            }
	            var tabs = stack.parent;
	            if (tabs instanceof phosphor_tabs_1.TabPanel) {
	                tabs.currentWidget = widget;
	            }
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources used by the tracker.
	     */
	    WidgetTracker.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._widgets = null;
	        this._activeWidget = null;
	        document.body.removeEventListener('focus', this, true);
	    };
	    /**
	     * Add a widget to the widget tracker.
	     *
	     * @param widget - The widget to add to the tracker.
	     *
	     * @returns A disposable that can be used to remove the widget from
	     *   the tracker.
	     *
	     * #### Notes
	     * The new widget will be set as the active widget.
	     */
	    WidgetTracker.prototype.addWidget = function (widget) {
	        var _this = this;
	        this._widgets.push(widget);
	        this.activeWidget = widget;
	        var disposal = function () {
	            var index = _this._widgets.indexOf(widget);
	            _this._widgets.splice(index, 1);
	        };
	        widget.disposed.connect(function () { disposal(); });
	        return new phosphor_disposable_1.DisposableDelegate(function () { disposal(); });
	    };
	    /**
	     * Handle the DOM events for the widget tracker.
	     *
	     * @param event - The DOM event sent to the widget.
	     */
	    WidgetTracker.prototype.handleEvent = function (event) {
	        if (event.type === 'focus') {
	            for (var _i = 0, _a = this._widgets; _i < _a.length; _i++) {
	                var widget = _a[_i];
	                var target = event.target;
	                if (widget.isAttached && widget.isVisible) {
	                    if (widget.node.contains(target)) {
	                        this.activeWidget = widget;
	                        return;
	                    }
	                }
	            }
	        }
	    };
	    return WidgetTracker;
	}());
	exports.WidgetTracker = WidgetTracker;
	/**
	 * A signal emitted when the active widget changes.
	 */
	var activeWidgetChangedSignal = new phosphor_signaling_1.Signal();


/***/ },
/* 125 */
/***/ function(module, exports) {

	module.exports = $;

/***/ },
/* 126 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var jupyter_js_services_1 = __webpack_require__(127);
	var widget_1 = __webpack_require__(141);
	var rendermime_1 = __webpack_require__(353);
	var docregistry_1 = __webpack_require__(354);
	var widgettracker_1 = __webpack_require__(124);
	var plugin_1 = __webpack_require__(359);
	var phosphor_menus_1 = __webpack_require__(360);
	/**
	 * The console extension.
	 */
	exports.consoleExtension = {
	    id: 'jupyter.extensions.console',
	    requires: [jupyter_js_services_1.ServiceManager, rendermime_1.RenderMime, plugin_1.MainMenu],
	    activate: activateConsole
	};
	/**
	 * The class name for all main area landscape tab icons.
	 */
	var LANDSCAPE_ICON_CLASS = 'jp-MainAreaLandscapeIcon';
	/**
	 * The class name for the console icon from the default theme.
	 */
	var CONSOLE_ICON_CLASS = 'jp-ImageConsole';
	/**
	 * Activate the console extension.
	 */
	function activateConsole(app, services, rendermime, mainMenu) {
	    var tracker = new widgettracker_1.WidgetTracker();
	    var manager = services.sessions;
	    var newSubmenuItems = [];
	    // Add the ability to create new consoles for each kernel.
	    var specs = services.kernelspecs;
	    var displayNameMap = Object.create(null);
	    for (var kernelName in specs.kernelspecs) {
	        var displayName = specs.kernelspecs[kernelName].spec.display_name;
	        displayNameMap[displayName] = kernelName;
	    }
	    var displayNames = Object.keys(displayNameMap).sort(function (a, b) {
	        return a.localeCompare(b);
	    });
	    var count = 0;
	    var _loop_1 = function(displayName) {
	        var id = "console:create-" + displayNameMap[displayName];
	        app.commands.add([{
	                id: id,
	                handler: function () {
	                    manager.startNew({
	                        path: "Console-" + count++,
	                        kernelName: "" + displayNameMap[displayName]
	                    }).then(function (session) {
	                        var panel = new widget_1.ConsolePanel({
	                            session: session, rendermime: rendermime.clone()
	                        });
	                        panel.id = "console-" + count;
	                        panel.title.text = displayName + " (" + count + ")";
	                        panel.title.icon = LANDSCAPE_ICON_CLASS + " " + CONSOLE_ICON_CLASS;
	                        panel.title.closable = true;
	                        app.shell.addToMainArea(panel);
	                        tracker.addWidget(panel);
	                    });
	                }
	            }]);
	        app.palette.add([{
	                command: id,
	                category: 'Console',
	                text: "New " + displayName + " console"
	            }]);
	        newSubmenuItems.push(new phosphor_menus_1.MenuItem({
	            text: displayName + " console",
	            handler: function () {
	                app.commands.execute(id);
	            }
	        }));
	    };
	    for (var _i = 0, displayNames_1 = displayNames; _i < displayNames_1.length; _i++) {
	        var displayName = displayNames_1[_i];
	        _loop_1(displayName);
	    }
	    app.commands.add([
	        {
	            id: 'console:clear',
	            handler: function () {
	                if (tracker.activeWidget) {
	                    tracker.activeWidget.content.clear();
	                }
	            }
	        },
	        {
	            id: 'console:dismiss-overlays',
	            handler: function () {
	                if (tracker.activeWidget) {
	                    tracker.activeWidget.content.dismissOverlays();
	                }
	            }
	        },
	        {
	            id: 'console:execute',
	            handler: function () {
	                if (tracker.activeWidget) {
	                    tracker.activeWidget.content.execute();
	                }
	            }
	        },
	        {
	            id: 'console:interrupt-kernel',
	            handler: function () {
	                if (tracker.activeWidget) {
	                    var kernel = tracker.activeWidget.content.session.kernel;
	                    if (kernel) {
	                        kernel.interrupt();
	                    }
	                }
	            }
	        },
	        {
	            id: 'console:switch-kernel',
	            handler: function () {
	                if (tracker.activeWidget) {
	                    var widget_2 = tracker.activeWidget.content;
	                    var session_1 = widget_2.session;
	                    var lang_1 = '';
	                    if (session_1.kernel) {
	                        lang_1 = specs.kernelspecs[session_1.kernel.name].spec.language;
	                    }
	                    manager.listRunning().then(function (sessions) {
	                        var options = {
	                            name: widget_2.parent.title.text,
	                            specs: specs,
	                            sessions: sessions,
	                            preferredLanguage: lang_1,
	                            kernel: session_1.kernel.model,
	                            host: widget_2.parent.node
	                        };
	                        return docregistry_1.selectKernel(options);
	                    }).then(function (kernelId) {
	                        if (kernelId) {
	                            session_1.changeKernel(kernelId);
	                        }
	                        else {
	                            session_1.kernel.shutdown();
	                        }
	                    });
	                }
	            }
	        }
	    ]);
	    app.palette.add([
	        {
	            command: 'console:clear',
	            category: 'Console',
	            text: 'Clear Cells'
	        },
	        {
	            command: 'console:execute',
	            category: 'Console',
	            text: 'Execute Cell'
	        },
	        {
	            command: 'console:interrupt-kernel',
	            category: 'Console',
	            text: 'Interrupt Kernel'
	        },
	        {
	            command: 'console:switch-kernel',
	            category: 'Console',
	            text: 'Switch Kernel'
	        }]);
	    var newSubmenu = new phosphor_menus_1.Menu(newSubmenuItems);
	    var menu = new phosphor_menus_1.Menu([
	        new phosphor_menus_1.MenuItem({
	            text: 'New',
	            submenu: newSubmenu
	        }),
	        new phosphor_menus_1.MenuItem({
	            text: 'Clear Cells',
	            handler: function () {
	                app.commands.execute('console:clear');
	            }
	        }),
	        new phosphor_menus_1.MenuItem({
	            text: 'Execute Cell',
	            handler: function () {
	                app.commands.execute('console:execute');
	            }
	        }),
	        new phosphor_menus_1.MenuItem({
	            text: 'Interrupt Kernel',
	            handler: function () {
	                app.commands.execute('console:interrupt-kernel');
	            }
	        }),
	        new phosphor_menus_1.MenuItem({
	            text: 'Switch Kernel',
	            handler: function () {
	                app.commands.execute('console:switch-kernel');
	            }
	        })
	    ]);
	    var consoleMenu = new phosphor_menus_1.MenuItem({
	        text: 'Console',
	        submenu: menu
	    });
	    mainMenu.addItem(consoleMenu, { rank: 50 });
	    return Promise.resolve(void 0);
	}


/***/ },
/* 127 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	'use strict';
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(128));
	__export(__webpack_require__(131));
	__export(__webpack_require__(133));
	__export(__webpack_require__(134));
	__export(__webpack_require__(138));
	__export(__webpack_require__(139));
	__export(__webpack_require__(140));


/***/ },
/* 128 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var utils = __webpack_require__(129);
	/**
	 * The url for the config service.
	 */
	var SERVICE_CONFIG_URL = 'api/config';
	/**
	 * Create a config section.
	 *
	 * @returns A Promise that is fulfilled with the config section is loaded.
	 */
	function getConfigSection(options) {
	    var section = new ConfigSection(options);
	    return section.load().then(function () {
	        return section;
	    });
	}
	exports.getConfigSection = getConfigSection;
	/**
	 * Implementation of the Configurable data section.
	 */
	var ConfigSection = (function () {
	    /**
	     * Construct a new config section.
	     */
	    function ConfigSection(options) {
	        this._url = 'unknown';
	        this._data = null;
	        this._ajaxSettings = null;
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        this.ajaxSettings = options.ajaxSettings || {};
	        this._url = utils.urlPathJoin(baseUrl, SERVICE_CONFIG_URL, utils.urlJoinEncode(options.name));
	    }
	    Object.defineProperty(ConfigSection.prototype, "ajaxSettings", {
	        /**
	         * Get a copy of the default ajax settings for the section.
	         */
	        get: function () {
	            return utils.copy(this._ajaxSettings);
	        },
	        /**
	         * Set the default ajax settings for the section.
	         */
	        set: function (value) {
	            this._ajaxSettings = utils.copy(value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ConfigSection.prototype, "data", {
	        /**
	         * Get the data for this section.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._data;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Load the initial data for this section.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/config).
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     */
	    ConfigSection.prototype.load = function () {
	        var _this = this;
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(this._url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	            _this._data = success.data;
	        });
	    };
	    /**
	     * Modify the stored config values.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/config).
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     *
	     * Updates the local data immediately, sends the change to the server,
	     * and updates the local data with the response, and fulfils the promise
	     * with that data.
	     */
	    ConfigSection.prototype.update = function (newdata) {
	        var _this = this;
	        this._data = utils.extend(this._data, newdata);
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'PATCH';
	        ajaxSettings.data = JSON.stringify(newdata);
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.contentType = 'application/json';
	        return utils.ajaxRequest(this._url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	            _this._data = success.data;
	            return _this._data;
	        });
	    };
	    return ConfigSection;
	}());
	/**
	 * Configurable object with defaults.
	 */
	var ConfigWithDefaults = (function () {
	    /**
	     * Create a new config with defaults.
	     */
	    function ConfigWithDefaults(options) {
	        this._section = null;
	        this._defaults = null;
	        this._className = '';
	        this._section = options.section;
	        this._defaults = options.defaults || {};
	        this._className = options.className || '';
	    }
	    /**
	     * Get data from the config section or fall back to defaults.
	     */
	    ConfigWithDefaults.prototype.get = function (key) {
	        return this._classData()[key] || this._defaults[key];
	    };
	    /**
	     * Set a config value.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/config).
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     *
	     * Sends the update to the server, and changes our local copy of the data
	     * immediately.
	     */
	    ConfigWithDefaults.prototype.set = function (key, value) {
	        var d = {};
	        d[key] = value;
	        if (this._className) {
	            var d2 = {};
	            d2[this._className] = d;
	            return this._section.update(d2);
	        }
	        else {
	            return this._section.update(d);
	        }
	    };
	    /**
	     * Get data from the Section with our classname, if available.
	     *
	     * #### Notes
	     * If we have no classname, get all of the data in the Section
	     */
	    ConfigWithDefaults.prototype._classData = function () {
	        if (this._className) {
	            return this._section.data[this._className] || {};
	        }
	        else {
	            return this._section.data;
	        }
	    };
	    return ConfigWithDefaults;
	}());
	exports.ConfigWithDefaults = ConfigWithDefaults;


/***/ },
/* 129 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(process) {// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	'use strict';
	var minimist = __webpack_require__(130);
	/**
	 * Copy the contents of one object to another, recursively.
	 *
	 * From [stackoverflow](http://stackoverflow.com/a/12317051).
	 */
	function extend(target, source) {
	    target = target || {};
	    for (var prop in source) {
	        if (typeof source[prop] === 'object') {
	            target[prop] = extend(target[prop], source[prop]);
	        }
	        else {
	            target[prop] = source[prop];
	        }
	    }
	    return target;
	}
	exports.extend = extend;
	/**
	 * Get a copy of an object, or null.
	 */
	function copy(object) {
	    if (object !== null && typeof object === 'object') {
	        return JSON.parse(JSON.stringify(object));
	    }
	    return null;
	}
	exports.copy = copy;
	/**
	 * Check for shallow equality of two objects.
	 */
	function shallowEquals(o1, o2) {
	    for (var p in o1) {
	        if (o1.hasOwnProperty(p)) {
	            if (o1[p] !== o2[p]) {
	                return false;
	            }
	        }
	    }
	    for (var p in o2) {
	        if (o2.hasOwnProperty(p) && !o1.hasOwnProperty(p)) {
	            return false;
	        }
	    }
	    return true;
	}
	exports.shallowEquals = shallowEquals;
	;
	/**
	 * Get a random 32 character hex string (not a formal UUID)
	 */
	function uuid() {
	    var s = [];
	    var hexDigits = "0123456789abcdef";
	    var nChars = hexDigits.length;
	    for (var i = 0; i < 32; i++) {
	        s[i] = hexDigits.charAt(Math.floor(Math.random() * nChars));
	    }
	    return s.join("");
	}
	exports.uuid = uuid;
	/**
	 * Join a sequence of url components with `'/'`.
	 */
	function urlPathJoin() {
	    var paths = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	        paths[_i - 0] = arguments[_i];
	    }
	    var url = '';
	    for (var i = 0; i < paths.length; i++) {
	        var path = paths[i];
	        if (path === '') {
	            continue;
	        }
	        if (i > 0) {
	            path = path.replace(/\/\/+/, '/');
	        }
	        if (url.length > 0 && url.charAt(url.length - 1) != '/' && path[0] != '/') {
	            url = url + '/' + path;
	        }
	        else {
	            url = url + path;
	        }
	    }
	    return url;
	}
	exports.urlPathJoin = urlPathJoin;
	/**
	 * Encode just the components of a multi-segment uri.
	 *
	 * Preserves the `'/'` separators.
	 */
	function encodeURIComponents(uri) {
	    return uri.split('/').map(encodeURIComponent).join('/');
	}
	exports.encodeURIComponents = encodeURIComponents;
	/**
	 * Encode and join a sequence of url components with `'/'`.
	 */
	function urlJoinEncode() {
	    var args = [];
	    for (var _i = 0; _i < arguments.length; _i++) {
	        args[_i - 0] = arguments[_i];
	    }
	    return encodeURIComponents(urlPathJoin.apply(null, args));
	}
	exports.urlJoinEncode = urlJoinEncode;
	/**
	 * Return a serialized object string suitable for a query.
	 *
	 * From [stackoverflow](http://stackoverflow.com/a/30707423).
	 */
	function jsonToQueryString(json) {
	    return '?' + Object.keys(json).map(function (key) {
	        return encodeURIComponent(key) + '=' + encodeURIComponent(json[key]);
	    }).join('&');
	}
	exports.jsonToQueryString = jsonToQueryString;
	/**
	 * Asynchronous XMLHTTPRequest handler.
	 *
	 * @param url - The url to request.
	 *
	 * @param settings - The settings to apply to the request and response.
	 *
	 * #### Notes
	 * Based on this [example](http://www.html5rocks.com/en/tutorials/es6/promises/#toc-promisifying-xmlhttprequest).
	 */
	function ajaxRequest(url, settings) {
	    var method = settings.method || 'GET';
	    var user = settings.user || '';
	    var password = settings.password || '';
	    if (!settings.cache) {
	        // https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest/Using_XMLHttpRequest#Bypassing_the_cache.
	        url += ((/\?/).test(url) ? "&" : "?") + (new Date()).getTime();
	    }
	    return new Promise(function (resolve, reject) {
	        var req = new XMLHttpRequest();
	        req.open(method, url, true, user, password);
	        if (settings.contentType !== void 0) {
	            req.setRequestHeader('Content-Type', settings.contentType);
	        }
	        if (settings.timeout !== void 0)
	            req.timeout = settings.timeout;
	        if (!!settings.withCredentials) {
	            req.withCredentials = true;
	        }
	        if (settings.requestHeaders !== void 0) {
	            for (var prop in settings.requestHeaders) {
	                req.setRequestHeader(prop, settings.requestHeaders[prop]);
	            }
	        }
	        req.onload = function () {
	            if (req.status >= 400) {
	                var error = new Error(req.statusText);
	                reject({ xhr: req, statusText: req.statusText, error: error });
	                return;
	            }
	            var response = req.responseText;
	            if (settings.dataType === 'json' && response) {
	                response = JSON.parse(response);
	            }
	            resolve({ data: response, statusText: req.statusText, xhr: req });
	        };
	        req.onerror = function (err) {
	            reject({ xhr: req, statusText: req.statusText, error: err });
	        };
	        req.ontimeout = function () {
	            reject({ xhr: req, statusText: req.statusText,
	                error: new Error('Operation Timed Out') });
	        };
	        if (settings.data) {
	            req.send(settings.data);
	        }
	        else {
	            req.send();
	        }
	    });
	}
	exports.ajaxRequest = ajaxRequest;
	/**
	 * Try to load an object from a module or a registry.
	 *
	 * Try to load an object from a module asynchronously if a module
	 * is specified, otherwise tries to load an object from the global
	 * registry, if the global registry is provided.
	 */
	function loadObject(name, moduleName, registry) {
	    return new Promise(function (resolve, reject) {
	        // Try loading the view module using require.js
	        if (moduleName) {
	            if (typeof requirejs === 'undefined') {
	                throw new Error('requirejs not found.');
	            }
	            requirejs([moduleName], function (mod) {
	                if (mod[name] === void 0) {
	                    var msg = "Object '" + name + "' not found in module '" + moduleName + "'";
	                    reject(new Error(msg));
	                }
	                else {
	                    resolve(mod[name]);
	                }
	            }, reject);
	        }
	        else {
	            if (registry && registry[name]) {
	                resolve(registry[name]);
	            }
	            else {
	                reject(new Error("Object '" + name + "' not found in registry"));
	            }
	        }
	    });
	}
	exports.loadObject = loadObject;
	;
	/**
	 * A Promise that can be resolved or rejected by another object.
	 */
	var PromiseDelegate = (function () {
	    /**
	     * Construct a new Promise delegate.
	     */
	    function PromiseDelegate() {
	        var _this = this;
	        this._promise = new Promise(function (resolve, reject) {
	            _this._resolve = resolve;
	            _this._reject = reject;
	        });
	    }
	    Object.defineProperty(PromiseDelegate.prototype, "promise", {
	        /**
	         * Get the underlying Promise.
	         */
	        get: function () {
	            return this._promise;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Resolve the underlying Promise with an optional value or another Promise.
	     */
	    PromiseDelegate.prototype.resolve = function (value) {
	        // Note: according to the Promise spec, and the `this` context for resolve
	        // and reject are ignored
	        this._resolve(value);
	    };
	    /**
	     * Reject the underlying Promise with an optional reason.
	     */
	    PromiseDelegate.prototype.reject = function (reason) {
	        // Note: according to the Promise spec, the `this` context for resolve
	        // and reject are ignored
	        this._reject(reason);
	    };
	    return PromiseDelegate;
	})();
	exports.PromiseDelegate = PromiseDelegate;
	/**
	 * Global config data for the Jupyter application.
	 */
	var configData = null;
	/**
	 *  Make an object fully immutable by freezing each object in it.
	 */
	function deepFreeze(obj) {
	    // Freeze properties before freezing self
	    Object.getOwnPropertyNames(obj).forEach(function (name) {
	        var prop = obj[name];
	        // Freeze prop if it is an object
	        if (typeof prop == 'object' && prop !== null && !Object.isFrozen(prop))
	            deepFreeze(prop);
	    });
	    // Freeze self
	    return Object.freeze(obj);
	}
	function getConfigOption(name) {
	    if (configData) {
	        return configData[name];
	    }
	    if (typeof document === 'undefined') {
	        configData = minimist(process.argv.slice(2));
	    }
	    else {
	        var el = document.getElementById('jupyter-config-data');
	        if (el) {
	            configData = JSON.parse(el.textContent);
	        }
	        else {
	            configData = {};
	        }
	    }
	    configData = deepFreeze(configData);
	    return configData[name];
	}
	exports.getConfigOption = getConfigOption;
	/**
	 * Get the base URL for a Jupyter application.
	 */
	function getBaseUrl() {
	    var baseUrl = getConfigOption('baseUrl');
	    if (!baseUrl || baseUrl === '/') {
	        baseUrl = (typeof location === 'undefined' ?
	            'http://localhost:8888/' : location.origin + '/');
	    }
	    return baseUrl;
	}
	exports.getBaseUrl = getBaseUrl;
	/**
	 * Get the base websocket URL for a Jupyter application.
	 */
	function getWsUrl(baseUrl) {
	    var wsUrl = getConfigOption('wsUrl');
	    if (!wsUrl) {
	        baseUrl = baseUrl || getBaseUrl();
	        if (baseUrl.indexOf('http') !== 0) {
	            if (typeof location !== 'undefined') {
	                baseUrl = urlPathJoin(location.origin, baseUrl);
	            }
	            else {
	                baseUrl = urlPathJoin('http://localhost:8888/', baseUrl);
	            }
	        }
	        wsUrl = 'ws' + baseUrl.slice(4);
	    }
	    return wsUrl;
	}
	exports.getWsUrl = getWsUrl;
	//# sourceMappingURL=index.js.map
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(15)))

/***/ },
/* 130 */
/***/ function(module, exports) {

	module.exports = function (args, opts) {
	    if (!opts) opts = {};
	    
	    var flags = { bools : {}, strings : {}, unknownFn: null };
	
	    if (typeof opts['unknown'] === 'function') {
	        flags.unknownFn = opts['unknown'];
	    }
	
	    if (typeof opts['boolean'] === 'boolean' && opts['boolean']) {
	      flags.allBools = true;
	    } else {
	      [].concat(opts['boolean']).filter(Boolean).forEach(function (key) {
	          flags.bools[key] = true;
	      });
	    }
	    
	    var aliases = {};
	    Object.keys(opts.alias || {}).forEach(function (key) {
	        aliases[key] = [].concat(opts.alias[key]);
	        aliases[key].forEach(function (x) {
	            aliases[x] = [key].concat(aliases[key].filter(function (y) {
	                return x !== y;
	            }));
	        });
	    });
	
	    [].concat(opts.string).filter(Boolean).forEach(function (key) {
	        flags.strings[key] = true;
	        if (aliases[key]) {
	            flags.strings[aliases[key]] = true;
	        }
	     });
	
	    var defaults = opts['default'] || {};
	    
	    var argv = { _ : [] };
	    Object.keys(flags.bools).forEach(function (key) {
	        setArg(key, defaults[key] === undefined ? false : defaults[key]);
	    });
	    
	    var notFlags = [];
	
	    if (args.indexOf('--') !== -1) {
	        notFlags = args.slice(args.indexOf('--')+1);
	        args = args.slice(0, args.indexOf('--'));
	    }
	
	    function argDefined(key, arg) {
	        return (flags.allBools && /^--[^=]+$/.test(arg)) ||
	            flags.strings[key] || flags.bools[key] || aliases[key];
	    }
	
	    function setArg (key, val, arg) {
	        if (arg && flags.unknownFn && !argDefined(key, arg)) {
	            if (flags.unknownFn(arg) === false) return;
	        }
	
	        var value = !flags.strings[key] && isNumber(val)
	            ? Number(val) : val
	        ;
	        setKey(argv, key.split('.'), value);
	        
	        (aliases[key] || []).forEach(function (x) {
	            setKey(argv, x.split('.'), value);
	        });
	    }
	
	    function setKey (obj, keys, value) {
	        var o = obj;
	        keys.slice(0,-1).forEach(function (key) {
	            if (o[key] === undefined) o[key] = {};
	            o = o[key];
	        });
	
	        var key = keys[keys.length - 1];
	        if (o[key] === undefined || flags.bools[key] || typeof o[key] === 'boolean') {
	            o[key] = value;
	        }
	        else if (Array.isArray(o[key])) {
	            o[key].push(value);
	        }
	        else {
	            o[key] = [ o[key], value ];
	        }
	    }
	    
	    function aliasIsBoolean(key) {
	      return aliases[key].some(function (x) {
	          return flags.bools[x];
	      });
	    }
	
	    for (var i = 0; i < args.length; i++) {
	        var arg = args[i];
	        
	        if (/^--.+=/.test(arg)) {
	            // Using [\s\S] instead of . because js doesn't support the
	            // 'dotall' regex modifier. See:
	            // http://stackoverflow.com/a/1068308/13216
	            var m = arg.match(/^--([^=]+)=([\s\S]*)$/);
	            var key = m[1];
	            var value = m[2];
	            if (flags.bools[key]) {
	                value = value !== 'false';
	            }
	            setArg(key, value, arg);
	        }
	        else if (/^--no-.+/.test(arg)) {
	            var key = arg.match(/^--no-(.+)/)[1];
	            setArg(key, false, arg);
	        }
	        else if (/^--.+/.test(arg)) {
	            var key = arg.match(/^--(.+)/)[1];
	            var next = args[i + 1];
	            if (next !== undefined && !/^-/.test(next)
	            && !flags.bools[key]
	            && !flags.allBools
	            && (aliases[key] ? !aliasIsBoolean(key) : true)) {
	                setArg(key, next, arg);
	                i++;
	            }
	            else if (/^(true|false)$/.test(next)) {
	                setArg(key, next === 'true', arg);
	                i++;
	            }
	            else {
	                setArg(key, flags.strings[key] ? '' : true, arg);
	            }
	        }
	        else if (/^-[^-]+/.test(arg)) {
	            var letters = arg.slice(1,-1).split('');
	            
	            var broken = false;
	            for (var j = 0; j < letters.length; j++) {
	                var next = arg.slice(j+2);
	                
	                if (next === '-') {
	                    setArg(letters[j], next, arg)
	                    continue;
	                }
	                
	                if (/[A-Za-z]/.test(letters[j]) && /=/.test(next)) {
	                    setArg(letters[j], next.split('=')[1], arg);
	                    broken = true;
	                    break;
	                }
	                
	                if (/[A-Za-z]/.test(letters[j])
	                && /-?\d+(\.\d*)?(e-?\d+)?$/.test(next)) {
	                    setArg(letters[j], next, arg);
	                    broken = true;
	                    break;
	                }
	                
	                if (letters[j+1] && letters[j+1].match(/\W/)) {
	                    setArg(letters[j], arg.slice(j+2), arg);
	                    broken = true;
	                    break;
	                }
	                else {
	                    setArg(letters[j], flags.strings[letters[j]] ? '' : true, arg);
	                }
	            }
	            
	            var key = arg.slice(-1)[0];
	            if (!broken && key !== '-') {
	                if (args[i+1] && !/^(-|--)[^-]/.test(args[i+1])
	                && !flags.bools[key]
	                && (aliases[key] ? !aliasIsBoolean(key) : true)) {
	                    setArg(key, args[i+1], arg);
	                    i++;
	                }
	                else if (args[i+1] && /true|false/.test(args[i+1])) {
	                    setArg(key, args[i+1] === 'true', arg);
	                    i++;
	                }
	                else {
	                    setArg(key, flags.strings[key] ? '' : true, arg);
	                }
	            }
	        }
	        else {
	            if (!flags.unknownFn || flags.unknownFn(arg) !== false) {
	                argv._.push(
	                    flags.strings['_'] || !isNumber(arg) ? arg : Number(arg)
	                );
	            }
	            if (opts.stopEarly) {
	                argv._.push.apply(argv._, args.slice(i + 1));
	                break;
	            }
	        }
	    }
	    
	    Object.keys(defaults).forEach(function (key) {
	        if (!hasKey(argv, key.split('.'))) {
	            setKey(argv, key.split('.'), defaults[key]);
	            
	            (aliases[key] || []).forEach(function (x) {
	                setKey(argv, x.split('.'), defaults[key]);
	            });
	        }
	    });
	    
	    if (opts['--']) {
	        argv['--'] = new Array();
	        notFlags.forEach(function(key) {
	            argv['--'].push(key);
	        });
	    }
	    else {
	        notFlags.forEach(function(key) {
	            argv._.push(key);
	        });
	    }
	
	    return argv;
	};
	
	function hasKey (obj, keys) {
	    var o = obj;
	    keys.slice(0,-1).forEach(function (key) {
	        o = (o[key] || {});
	    });
	
	    var key = keys[keys.length - 1];
	    return key in o;
	}
	
	function isNumber (x) {
	    if (typeof x === 'number') return true;
	    if (/^0x[0-9a-f]+$/i.test(x)) return true;
	    return /^[-+]?(?:\d+(?:\.\d*)?|\.\d+)(e[-+]?\d+)?$/.test(x);
	}
	


/***/ },
/* 131 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	var utils = __webpack_require__(129);
	var validate = __webpack_require__(132);
	/**
	 * The url for the contents service.
	 */
	var SERVICE_CONTENTS_URL = 'api/contents';
	/**
	 * A contents manager that passes file operations to the server.
	 *
	 * This includes checkpointing with the normal file operations.
	 */
	var ContentsManager = (function () {
	    /**
	     * Construct a new contents manager object.
	     *
	     * @param options - The options used to initialize the object.
	     */
	    function ContentsManager(options) {
	        if (options === void 0) { options = {}; }
	        this._apiUrl = 'unknown';
	        this._ajaxSettings = null;
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        options.ajaxSettings = options.ajaxSettings || {};
	        this._ajaxSettings = utils.copy(options.ajaxSettings);
	        this._apiUrl = utils.urlPathJoin(baseUrl, SERVICE_CONTENTS_URL);
	    }
	    Object.defineProperty(ContentsManager.prototype, "ajaxSettings", {
	        /**
	         * Get a copy of the default ajax settings for the contents manager.
	         */
	        get: function () {
	            return utils.copy(this._ajaxSettings);
	        },
	        /**
	         * Set the default ajax settings for the contents manager.
	         */
	        set: function (value) {
	            this._ajaxSettings = utils.copy(value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get a file or directory.
	     *
	     * @param path: The path to the file.
	     *
	     * @param options: The options used to fetch the file.
	     *
	     * @returns A promise which resolves with the file content.
	     *
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents) and validates the response model.
	     */
	    ContentsManager.prototype.get = function (path, options) {
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        var url = this._getUrl(path);
	        if (options) {
	            // The notebook type cannot take an format option.
	            if (options.type === 'notebook') {
	                delete options['format'];
	            }
	            var params = utils.copy(options);
	            params.content = options.content ? '1' : '0';
	            url += utils.jsonToQueryString(params);
	        }
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	            validate.validateContentsModel(success.data);
	            return success.data;
	        });
	    };
	    /**
	     * Create a new untitled file or directory in the specified directory path.
	     *
	     * @param options: The options used to create the file.
	     *
	     * @returns A promise which resolves with the created file content when the
	     *    file is created.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents) and validates the response model.
	     */
	    ContentsManager.prototype.newUntitled = function (options) {
	        if (options === void 0) { options = {}; }
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'POST';
	        ajaxSettings.dataType = 'json';
	        if (options) {
	            ajaxSettings.data = JSON.stringify(options);
	            ajaxSettings.contentType = 'application/json';
	        }
	        var url = this._getUrl(options.path || '');
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 201) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	            validate.validateContentsModel(success.data);
	            return success.data;
	        });
	    };
	    /**
	     * Delete a file.
	     *
	     * @param path - The path to the file.
	     *
	     * @returns A promise which resolves when the file is deleted.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents).
	     */
	    ContentsManager.prototype.delete = function (path) {
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'DELETE';
	        ajaxSettings.dataType = 'json';
	        var url = this._getUrl(path);
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	        }, function (error) {
	            // Translate certain errors to more specific ones.
	            // TODO: update IPEP27 to specify errors more precisely, so
	            // that error types can be detected here with certainty.
	            if (error.xhr.status === 400) {
	                var err = JSON.parse(error.xhr.response);
	                if (err.message) {
	                    throw new Error(err.message);
	                }
	            }
	            throw new Error(error.xhr.statusText);
	        });
	    };
	    /**
	     * Rename a file or directory.
	     *
	     * @param path - The original file path.
	     *
	     * @param newPath - The new file path.
	     *
	     * @returns A promise which resolves with the new file contents model when
	     *   the file is renamed.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents) and validates the response model.
	     */
	    ContentsManager.prototype.rename = function (path, newPath) {
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'PATCH';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.data = JSON.stringify({ path: newPath });
	        var url = this._getUrl(path);
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	            validate.validateContentsModel(success.data);
	            return success.data;
	        });
	    };
	    /**
	     * Save a file.
	     *
	     * @param path - The desired file path.
	     *
	     * @param options - Optional overrrides to the model.
	     *
	     * @returns A promise which resolves with the file content model when the
	     *   file is saved.
	     *
	     * #### Notes
	     * Ensure that `model.content` is populated for the file.
	     *
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents) and validates the response model.
	     */
	    ContentsManager.prototype.save = function (path, options) {
	        if (options === void 0) { options = {}; }
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'PUT';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.data = JSON.stringify(options);
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.cache = false;
	        var url = this._getUrl(path);
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            // will return 200 for an existing file and 201 for a new file
	            if (success.xhr.status !== 200 && success.xhr.status !== 201) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	            validate.validateContentsModel(success.data);
	            return success.data;
	        });
	    };
	    /**
	     * Copy a file into a given directory.
	     *
	     * @param path - The original file path.
	     *
	     * @param toDir - The destination directory path.
	     *
	     * @returns A promise which resolves with the new contents model when the
	     *  file is copied.
	     *
	     * #### Notes
	     * The server will select the name of the copied file.
	     *
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents) and validates the response model.
	     */
	    ContentsManager.prototype.copy = function (fromFile, toDir) {
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'POST';
	        ajaxSettings.data = JSON.stringify({ copy_from: fromFile });
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.dataType = 'json';
	        var url = this._getUrl(toDir);
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 201) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	            validate.validateContentsModel(success.data);
	            return success.data;
	        });
	    };
	    /**
	     * Create a checkpoint for a file.
	     *
	     * @param path - The path of the file.
	     *
	     * @returns A promise which resolves with the new checkpoint model when the
	     *   checkpoint is created.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents) and validates the response model.
	     */
	    ContentsManager.prototype.createCheckpoint = function (path) {
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'POST';
	        ajaxSettings.dataType = 'json';
	        var url = this._getUrl(path, 'checkpoints');
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 201) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	            validate.validateCheckpointModel(success.data);
	            return success.data;
	        });
	    };
	    /**
	     * List available checkpoints for a file.
	     *
	     * @param path - The path of the file.
	     *
	     * @returns A promise which resolves with a list of checkpoint models for
	     *    the file.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents) and validates the response model.
	     */
	    ContentsManager.prototype.listCheckpoints = function (path) {
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        var url = this._getUrl(path, 'checkpoints');
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	            if (!Array.isArray(success.data)) {
	                throw Error('Invalid Checkpoint list');
	            }
	            for (var i = 0; i < success.data.length; i++) {
	                validate.validateCheckpointModel(success.data[i]);
	            }
	            return success.data;
	        });
	    };
	    /**
	     * Restore a file to a known checkpoint state.
	     *
	     * @param path - The path of the file.
	     *
	     * @param checkpointID - The id of the checkpoint to restore.
	     *
	     * @returns A promise which resolves when the checkpoint is restored.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents).
	     */
	    ContentsManager.prototype.restoreCheckpoint = function (path, checkpointID) {
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'POST';
	        ajaxSettings.dataType = 'json';
	        var url = this._getUrl(path, 'checkpoints', checkpointID);
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	        });
	    };
	    /**
	     * Delete a checkpoint for a file.
	     *
	     * @param path - The path of the file.
	     *
	     * @param checkpointID - The id of the checkpoint to delete.
	     *
	     * @returns A promise which resolves when the checkpoint is deleted.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/contents).
	     */
	    ContentsManager.prototype.deleteCheckpoint = function (path, checkpointID) {
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'DELETE';
	        ajaxSettings.dataType = 'json';
	        var url = this._getUrl(path, 'checkpoints', checkpointID);
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	        });
	    };
	    /**
	     * Get a REST url for a file given a path.
	     */
	    ContentsManager.prototype._getUrl = function () {
	        var args = [];
	        for (var _i = 0; _i < arguments.length; _i++) {
	            args[_i - 0] = arguments[_i];
	        }
	        var urlParts = [].concat(Array.prototype.slice.apply(args));
	        return utils.urlPathJoin(this._apiUrl, utils.urlJoinEncode.apply(null, urlParts));
	    };
	    return ContentsManager;
	}());
	exports.ContentsManager = ContentsManager;


/***/ },
/* 132 */
/***/ function(module, exports) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	'use strict';
	/**
	 * Required fields for `IKernelHeader`.
	 */
	var HEADER_FIELDS = ['username', 'version', 'session', 'msg_id', 'msg_type'];
	/**
	 * Requred fields and types for contents of various types of `kernel.IMessage`
	 * messages on the iopub channel.
	 */
	var IOPUB_CONTENT_FIELDS = {
	    stream: { name: 'string', text: 'string' },
	    display_data: { data: 'object', metadata: 'object' },
	    execute_input: { code: 'string', execution_count: 'number' },
	    execute_result: { execution_count: 'number', data: 'object',
	        metadata: 'object' },
	    error: { ename: 'string', evalue: 'string', traceback: 'object' },
	    status: { execution_state: 'string' },
	    clear_output: { wait: 'boolean' },
	    comm_open: { comm_id: 'string', target_name: 'string', data: 'object' },
	    comm_msg: { comm_id: 'string', data: 'object' },
	    comm_close: { comm_id: 'string' },
	    shutdown_reply: { restart: 'boolean' } // Emitted by the IPython kernel.
	};
	/**
	 * Validate a property as being on an object, and optionally
	 * of a given type.
	 */
	function validateProperty(object, name, typeName) {
	    if (!object.hasOwnProperty(name)) {
	        throw Error("Missing property '" + name + "'");
	    }
	    if (typeName !== void 0) {
	        var valid = true;
	        var value = object[name];
	        switch (typeName) {
	            case 'array':
	                valid = Array.isArray(value);
	                break;
	            case 'object':
	                valid = typeof value !== 'undefined';
	                break;
	            default:
	                valid = typeof value === typeName;
	        }
	        if (!valid) {
	            throw new Error("Property '" + name + "' is not of type '" + typeName);
	        }
	    }
	}
	/**
	 * Validate the header of a kernel message.
	 */
	function validateKernelHeader(header) {
	    for (var i = 0; i < HEADER_FIELDS.length; i++) {
	        validateProperty(header, HEADER_FIELDS[i], 'string');
	    }
	}
	/**
	 * Validate a kernel message object.
	 */
	function validateKernelMessage(msg) {
	    validateProperty(msg, 'metadata', 'object');
	    validateProperty(msg, 'content', 'object');
	    validateProperty(msg, 'channel', 'string');
	    validateProperty(msg, 'buffers', 'array');
	    validateKernelHeader(msg.header);
	    if (Object.keys(msg.parent_header).length > 0) {
	        validateKernelHeader(msg.parent_header);
	    }
	    if (msg.channel === 'iopub') {
	        validateIOPubContent(msg);
	    }
	}
	exports.validateKernelMessage = validateKernelMessage;
	/**
	 * Validate content an kernel message on the iopub channel.
	 */
	function validateIOPubContent(msg) {
	    if (msg.channel === 'iopub') {
	        var fields = IOPUB_CONTENT_FIELDS[msg.header.msg_type];
	        if (fields === void 0) {
	            throw Error("Invalid Kernel message: iopub message type " + msg.header.msg_type + " not recognized");
	        }
	        var names = Object.keys(fields);
	        var content = msg.content;
	        for (var i = 0; i < names.length; i++) {
	            validateProperty(content, names[i], fields[names[i]]);
	        }
	    }
	}
	/**
	 * Validate an `IKernel.IModel` object.
	 */
	function validateKernelModel(model) {
	    validateProperty(model, 'name', 'string');
	    validateProperty(model, 'id', 'string');
	}
	exports.validateKernelModel = validateKernelModel;
	/**
	 * Validate an `ISession.IModel` object.
	 */
	function validateSessionModel(model) {
	    validateProperty(model, 'id', 'string');
	    validateProperty(model, 'notebook', 'object');
	    validateProperty(model, 'kernel', 'object');
	    validateKernelModel(model.kernel);
	    validateProperty(model.notebook, 'path', 'string');
	}
	exports.validateSessionModel = validateSessionModel;
	/**
	 * Validate an `IKernel.ISpecModel` object.
	 */
	function validateKernelSpecModel(info) {
	    validateProperty(info, 'name', 'string');
	    validateProperty(info, 'spec', 'object');
	    validateProperty(info, 'resources', 'object');
	    var spec = info.spec;
	    validateProperty(spec, 'language', 'string');
	    validateProperty(spec, 'display_name', 'string');
	    validateProperty(spec, 'argv', 'array');
	}
	exports.validateKernelSpecModel = validateKernelSpecModel;
	/**
	 * Validate an `IContents.IModel` object.
	 */
	function validateContentsModel(model) {
	    validateProperty(model, 'name', 'string');
	    validateProperty(model, 'path', 'string');
	    validateProperty(model, 'type', 'string');
	    validateProperty(model, 'created', 'string');
	    validateProperty(model, 'last_modified', 'string');
	    validateProperty(model, 'mimetype', 'object');
	    validateProperty(model, 'content', 'object');
	    validateProperty(model, 'format', 'object');
	}
	exports.validateContentsModel = validateContentsModel;
	/**
	 * Validate an `IContents.ICheckpointModel` object.
	 */
	function validateCheckpointModel(model) {
	    validateProperty(model, 'id', 'string');
	    validateProperty(model, 'last_modified', 'string');
	}
	exports.validateCheckpointModel = validateCheckpointModel;


/***/ },
/* 133 */
/***/ function(module, exports) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	'use strict';
	/**
	 * A namespace for kernel messages.
	 */
	var KernelMessage;
	(function (KernelMessage) {
	    /**
	     * Test whether a kernel message is a `'stream'` message.
	     */
	    function isStreamMsg(msg) {
	        return msg.header.msg_type === 'stream';
	    }
	    KernelMessage.isStreamMsg = isStreamMsg;
	    /**
	     * Test whether a kernel message is an `'display_data'` message.
	     */
	    function isDisplayDataMsg(msg) {
	        return msg.header.msg_type === 'display_data';
	    }
	    KernelMessage.isDisplayDataMsg = isDisplayDataMsg;
	    /**
	     * Test whether a kernel message is an `'execute_input'` message.
	     */
	    function isExecuteInputMsg(msg) {
	        return msg.header.msg_type === 'execute_input';
	    }
	    KernelMessage.isExecuteInputMsg = isExecuteInputMsg;
	    /**
	     * Test whether a kernel message is an `'execute_result'` message.
	     */
	    function isExecuteResultMsg(msg) {
	        return msg.header.msg_type === 'execute_result';
	    }
	    KernelMessage.isExecuteResultMsg = isExecuteResultMsg;
	    /**
	     * Test whether a kernel message is an `'error'` message.
	     */
	    function isErrorMsg(msg) {
	        return msg.header.msg_type === 'error';
	    }
	    KernelMessage.isErrorMsg = isErrorMsg;
	    /**
	     * Test whether a kernel message is a `'status'` message.
	     */
	    function isStatusMsg(msg) {
	        return msg.header.msg_type === 'status';
	    }
	    KernelMessage.isStatusMsg = isStatusMsg;
	    /**
	     * Test whether a kernel message is a `'clear_output'` message.
	     */
	    function isClearOutputMsg(msg) {
	        return msg.header.msg_type === 'clear_output';
	    }
	    KernelMessage.isClearOutputMsg = isClearOutputMsg;
	    /**
	     * Test whether a kernel message is a `'comm_open'` message.
	     */
	    function isCommOpenMsg(msg) {
	        return msg.header.msg_type === 'comm_open';
	    }
	    KernelMessage.isCommOpenMsg = isCommOpenMsg;
	    /**
	     * Test whether a kernel message is a `'comm_close'` message.
	     */
	    function isCommCloseMsg(msg) {
	        return msg.header.msg_type === 'comm_close';
	    }
	    KernelMessage.isCommCloseMsg = isCommCloseMsg;
	    /**
	     * Test whether a kernel message is a `'comm_msg'` message.
	     */
	    function isCommMsgMsg(msg) {
	        return msg.header.msg_type === 'comm_msg';
	    }
	    KernelMessage.isCommMsgMsg = isCommMsgMsg;
	})(KernelMessage = exports.KernelMessage || (exports.KernelMessage = {}));


/***/ },
/* 134 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var utils = __webpack_require__(129);
	var phosphor_disposable_1 = __webpack_require__(8);
	var phosphor_signaling_1 = __webpack_require__(22);
	var json_1 = __webpack_require__(135);
	var kernelfuture_1 = __webpack_require__(136);
	var serialize = __webpack_require__(137);
	var validate = __webpack_require__(132);
	/**
	 * The url for the kernel service.
	 */
	var KERNEL_SERVICE_URL = 'api/kernels';
	/**
	 * The url for the kernelspec service.
	 */
	var KERNELSPEC_SERVICE_URL = 'api/kernelspecs';
	/**
	 * An implementation of a kernel manager.
	 */
	var KernelManager = (function () {
	    /**
	     * Construct a new kernel manager.
	     *
	     * @param options - The default options for kernel.
	     */
	    function KernelManager(options) {
	        this._options = null;
	        this._running = [];
	        this._specs = null;
	        this._isDisposed = false;
	        this._options = utils.copy(options || {});
	    }
	    Object.defineProperty(KernelManager.prototype, "specsChanged", {
	        /**
	         * A signal emitted when the specs change.
	         */
	        get: function () {
	            return Private.specsChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelManager.prototype, "runningChanged", {
	        /**
	         * A signal emitted when the running kernels change.
	         */
	        get: function () {
	            return Private.runningChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelManager.prototype, "isDisposed", {
	        /**
	         * Test whether the terminal manager is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._isDisposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources used by the manager.
	     */
	    KernelManager.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._isDisposed = true;
	        phosphor_signaling_1.clearSignalData(this);
	        this._specs = null;
	        this._running = [];
	    };
	    /**
	     * Get the kernel specs.  See also [[getKernelSpecs]].
	     *
	     * @param options - Overrides for the default options.
	     */
	    KernelManager.prototype.getSpecs = function (options) {
	        var _this = this;
	        return getKernelSpecs(this._getOptions(options)).then(function (specs) {
	            if (!json_1.deepEqual(specs, _this._specs)) {
	                _this._specs = specs;
	                _this.specsChanged.emit(specs);
	            }
	            return specs;
	        });
	    };
	    /**
	     * List the running kernels.  See also [[listRunningKernels]].
	     *
	     * @param options - Overrides for the default options.
	     */
	    KernelManager.prototype.listRunning = function (options) {
	        var _this = this;
	        return listRunningKernels(this._getOptions(options)).then(function (running) {
	            if (!json_1.deepEqual(running, _this._running)) {
	                _this._running = running.slice();
	                _this.runningChanged.emit(running);
	            }
	            return running;
	        });
	    };
	    /**
	     * Start a new kernel.  See also [[startNewKernel]].
	     *
	     * @param options - Overrides for the default options.
	     *
	     * #### Notes
	     * This will emit [[runningChanged]] if the running kernels list
	     * changes.
	     */
	    KernelManager.prototype.startNew = function (options) {
	        return startNewKernel(this._getOptions(options));
	    };
	    /**
	     * Find a kernel by id.
	     *
	     * @param options - Overrides for the default options.
	     */
	    KernelManager.prototype.findById = function (id, options) {
	        return findKernelById(id, this._getOptions(options));
	    };
	    /**
	     * Connect to a running kernel.  See also [[connectToKernel]].
	     *
	     * @param options - Overrides for the default options.
	     */
	    KernelManager.prototype.connectTo = function (id, options) {
	        return connectToKernel(id, this._getOptions(options));
	    };
	    /**
	     * Shut down a kernel by id.
	     *
	     * @param options - Overrides for the default options.
	     *
	     * #### Notes
	     * This will emit [[runningChanged]] if the running kernels list
	     * changes.
	     */
	    KernelManager.prototype.shutdown = function (id, options) {
	        return shutdownKernel(id, this._getOptions(options));
	    };
	    /**
	     * Get optionally overidden options.
	     */
	    KernelManager.prototype._getOptions = function (options) {
	        if (options) {
	            options = utils.extend(utils.copy(this._options), options);
	        }
	        else {
	            options = this._options;
	        }
	        return options;
	    };
	    return KernelManager;
	}());
	exports.KernelManager = KernelManager;
	/**
	 * Find a kernel by id.
	 *
	 * #### Notes
	 * If the kernel was already started via `startNewKernel`, we return its
	 * `IKernel.IModel`.
	 *
	 * Otherwise, if `options` are given, we attempt to find to the existing
	 * kernel.
	 * The promise is fulfilled when the kernel is found,
	 * otherwise the promise is rejected.
	 */
	function findKernelById(id, options) {
	    var kernels = Private.runningKernels;
	    for (var clientId in kernels) {
	        var kernel = kernels[clientId];
	        if (kernel.id === id) {
	            var result = { id: kernel.id, name: kernel.name };
	            return Promise.resolve(result);
	        }
	    }
	    return Private.getKernelModel(id, options).catch(function () {
	        return Private.typedThrow("No running kernel with id: " + id);
	    });
	}
	exports.findKernelById = findKernelById;
	/**
	 * Fetch the kernel specs.
	 *
	 * #### Notes
	 * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernelspecs).
	 */
	function getKernelSpecs(options) {
	    options = options || {};
	    var baseUrl = options.baseUrl || utils.getBaseUrl();
	    var url = utils.urlPathJoin(baseUrl, KERNELSPEC_SERVICE_URL);
	    var ajaxSettings = utils.copy(options.ajaxSettings) || {};
	    ajaxSettings.method = 'GET';
	    ajaxSettings.dataType = 'json';
	    return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	        var err = new Error('Invalid KernelSpecs Model');
	        if (success.xhr.status !== 200) {
	            throw new Error('Invalid Response: ' + success.xhr.status);
	        }
	        var data = success.data;
	        if (!data.hasOwnProperty('default') ||
	            typeof data.default !== 'string') {
	            throw err;
	        }
	        if (!data.hasOwnProperty('kernelspecs')) {
	            throw err;
	        }
	        if (!data.kernelspecs.hasOwnProperty(data.default)) {
	            throw err;
	        }
	        var keys = Object.keys(data.kernelspecs);
	        for (var i = 0; i < keys.length; i++) {
	            var ks = data.kernelspecs[keys[i]];
	            validate.validateKernelSpecModel(ks);
	        }
	        return data;
	    });
	}
	exports.getKernelSpecs = getKernelSpecs;
	/**
	 * Fetch the running kernels.
	 *
	 * #### Notes
	 * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernels) and validates the response model.
	 *
	 * The promise is fulfilled on a valid response and rejected otherwise.
	 */
	function listRunningKernels(options) {
	    options = options || {};
	    var baseUrl = options.baseUrl || utils.getBaseUrl();
	    var url = utils.urlPathJoin(baseUrl, KERNEL_SERVICE_URL);
	    var ajaxSettings = utils.copy(options.ajaxSettings) || {};
	    ajaxSettings.method = 'GET';
	    ajaxSettings.dataType = 'json';
	    ajaxSettings.cache = false;
	    return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	        if (success.xhr.status !== 200) {
	            throw Error('Invalid Status: ' + success.xhr.status);
	        }
	        if (!Array.isArray(success.data)) {
	            throw Error('Invalid kernel list');
	        }
	        for (var i = 0; i < success.data.length; i++) {
	            validate.validateKernelModel(success.data[i]);
	        }
	        return success.data;
	    }, Private.onKernelError);
	}
	exports.listRunningKernels = listRunningKernels;
	/**
	 * Start a new kernel.
	 *
	 * #### Notes
	 * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernels) and validates the response model.
	 *
	 * If no options are given or the kernel name is not given, the
	 * default kernel will by started by the server.
	 *
	 * Wraps the result in a Kernel object. The promise is fulfilled
	 * when the kernel is started by the server, otherwise the promise is rejected.
	 */
	function startNewKernel(options) {
	    options = options || {};
	    var baseUrl = options.baseUrl || utils.getBaseUrl();
	    var url = utils.urlPathJoin(baseUrl, KERNEL_SERVICE_URL);
	    var ajaxSettings = utils.copy(options.ajaxSettings) || {};
	    ajaxSettings.method = 'POST';
	    ajaxSettings.data = JSON.stringify({ name: options.name });
	    ajaxSettings.dataType = 'json';
	    ajaxSettings.contentType = 'application/json';
	    ajaxSettings.cache = false;
	    return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	        if (success.xhr.status !== 201) {
	            throw Error('Invalid Status: ' + success.xhr.status);
	        }
	        validate.validateKernelModel(success.data);
	        return new Kernel(options, success.data.id);
	    }, Private.onKernelError);
	}
	exports.startNewKernel = startNewKernel;
	/**
	 * Connect to a running kernel.
	 *
	 * #### Notes
	 * If the kernel was already started via `startNewKernel`, the existing
	 * Kernel object info is used to create another instance.
	 *
	 * Otherwise, if `options` are given, we attempt to connect to the existing
	 * kernel found by calling `listRunningKernels`.
	 * The promise is fulfilled when the kernel is running on the server,
	 * otherwise the promise is rejected.
	 *
	 * If the kernel was not already started and no `options` are given,
	 * the promise is rejected.
	 */
	function connectToKernel(id, options) {
	    for (var clientId in Private.runningKernels) {
	        var kernel = Private.runningKernels[clientId];
	        if (kernel.id === id) {
	            return Promise.resolve(kernel.clone());
	        }
	    }
	    return Private.getKernelModel(utils.urlJoinEncode(id), options).then(function (model) {
	        return new Kernel(options, id);
	    }).catch(function () {
	        return Private.typedThrow("No running kernel with id: " + id);
	    });
	}
	exports.connectToKernel = connectToKernel;
	/**
	 * Shut down a kernel by id.
	 */
	function shutdownKernel(id, options) {
	    if (options === void 0) { options = {}; }
	    var baseUrl = options.baseUrl || utils.getBaseUrl();
	    var ajaxSettings = options.ajaxSettings || {};
	    return Private.shutdownKernel(id, baseUrl, ajaxSettings);
	}
	exports.shutdownKernel = shutdownKernel;
	/**
	 * Create a well-formed kernel message.
	 */
	function createKernelMessage(options, content, metadata, buffers) {
	    if (content === void 0) { content = {}; }
	    if (metadata === void 0) { metadata = {}; }
	    if (buffers === void 0) { buffers = []; }
	    return {
	        header: {
	            username: options.username || '',
	            version: '5.0',
	            session: options.session,
	            msg_id: options.msgId || utils.uuid(),
	            msg_type: options.msgType
	        },
	        parent_header: {},
	        channel: options.channel,
	        content: content,
	        metadata: metadata,
	        buffers: buffers
	    };
	}
	exports.createKernelMessage = createKernelMessage;
	/**
	 * Create a well-formed kernel shell message.
	 */
	function createShellMessage(options, content, metadata, buffers) {
	    if (content === void 0) { content = {}; }
	    if (metadata === void 0) { metadata = {}; }
	    if (buffers === void 0) { buffers = []; }
	    var msg = createKernelMessage(options, content, metadata, buffers);
	    return msg;
	}
	exports.createShellMessage = createShellMessage;
	/**
	 * Implementation of the Kernel object
	 */
	var Kernel = (function () {
	    /**
	     * Construct a kernel object.
	     */
	    function Kernel(options, id) {
	        this._id = '';
	        this._name = '';
	        this._baseUrl = '';
	        this._wsUrl = '';
	        this._status = 'unknown';
	        this._clientId = '';
	        this._ws = null;
	        this._username = '';
	        this._ajaxSettings = '{}';
	        this._reconnectLimit = 7;
	        this._reconnectAttempt = 0;
	        this._isReady = false;
	        this._futures = null;
	        this._commPromises = null;
	        this._comms = null;
	        this._targetRegistry = Object.create(null);
	        this._spec = null;
	        this._pendingMessages = [];
	        this._connectionPromise = null;
	        this.ajaxSettings = options.ajaxSettings || {};
	        this._name = options.name;
	        this._id = id;
	        this._baseUrl = options.baseUrl || utils.getBaseUrl();
	        this._wsUrl = options.wsUrl || utils.getWsUrl(this._baseUrl);
	        this._clientId = options.clientId || utils.uuid();
	        this._username = options.username || '';
	        this._futures = new Map();
	        this._commPromises = new Map();
	        this._comms = new Map();
	        this._createSocket();
	        Private.runningKernels[this._clientId] = this;
	    }
	    Object.defineProperty(Kernel.prototype, "statusChanged", {
	        /**
	         * A signal emitted when the kernel status changes.
	         */
	        get: function () {
	            return Private.statusChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Kernel.prototype, "iopubMessage", {
	        /**
	         * A signal emitted for iopub kernel messages.
	         */
	        get: function () {
	            return Private.iopubMessageSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Kernel.prototype, "unhandledMessage", {
	        /**
	         * A signal emitted for unhandled kernel message.
	         */
	        get: function () {
	            return Private.unhandledMessageSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Kernel.prototype, "id", {
	        /**
	         * The id of the server-side kernel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._id;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Kernel.prototype, "name", {
	        /**
	         * The name of the server-side kernel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._name;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Kernel.prototype, "model", {
	        /**
	         * Get the model associated with the kernel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return { name: this.name, id: this.id };
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Kernel.prototype, "username", {
	        /**
	         * The client username.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._username;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Kernel.prototype, "clientId", {
	        /**
	         * The client unique id.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._clientId;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Kernel.prototype, "status", {
	        /**
	         * The current status of the kernel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._status;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Kernel.prototype, "ajaxSettings", {
	        /**
	         * Get a copy of the default ajax settings for the kernel.
	         */
	        get: function () {
	            return JSON.parse(this._ajaxSettings);
	        },
	        /**
	         * Set the default ajax settings for the kernel.
	         */
	        set: function (value) {
	            this._ajaxSettings = JSON.stringify(value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Kernel.prototype, "isDisposed", {
	        /**
	         * Test whether the kernel has been disposed.
	         *
	         * #### Notes
	         * This is a read-only property which is always safe to access.
	         */
	        get: function () {
	            return this._futures === null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Clone the current kernel with a new clientId.
	     */
	    Kernel.prototype.clone = function () {
	        var options = {
	            baseUrl: this._baseUrl,
	            wsUrl: this._wsUrl,
	            name: this._name,
	            username: this._username,
	            ajaxSettings: this.ajaxSettings
	        };
	        return new Kernel(options, this._id);
	    };
	    /**
	     * Dispose of the resources held by the kernel.
	     */
	    Kernel.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._status = 'dead';
	        if (this._ws !== null) {
	            this._ws.close();
	        }
	        this._ws = null;
	        this._futures.forEach(function (future, key) {
	            future.dispose();
	        });
	        this._comms.forEach(function (comm, key) {
	            comm.dispose();
	        });
	        this._futures = null;
	        this._commPromises = null;
	        this._comms = null;
	        this._status = 'dead';
	        this._targetRegistry = null;
	        phosphor_signaling_1.clearSignalData(this);
	        delete Private.runningKernels[this._clientId];
	    };
	    /**
	     * Send a shell message to the kernel.
	     *
	     * #### Notes
	     * Send a message to the kernel's shell channel, yielding a future object
	     * for accepting replies.
	     *
	     * If `expectReply` is given and `true`, the future is disposed when both a
	     * shell reply and an idle status message are received. If `expectReply`
	     * is not given or is `false`, the future is resolved when an idle status
	     * message is received.
	     * If `disposeOnDone` is not given or is `true`, the Future is disposed at this point.
	     * If `disposeOnDone` is given and `false`, it is up to the caller to dispose of the Future.
	     *
	     * All replies are validated as valid kernel messages.
	     *
	     * If the kernel status is `Dead`, this will throw an error.
	     */
	    Kernel.prototype.sendShellMessage = function (msg, expectReply, disposeOnDone) {
	        var _this = this;
	        if (expectReply === void 0) { expectReply = false; }
	        if (disposeOnDone === void 0) { disposeOnDone = true; }
	        if (this.status === 'dead') {
	            throw new Error('Kernel is dead');
	        }
	        if (!this._isReady) {
	            this._pendingMessages.push(msg);
	        }
	        else {
	            this._ws.send(serialize.serialize(msg));
	        }
	        var future = new kernelfuture_1.KernelFutureHandler(function () {
	            _this._futures.delete(msg.header.msg_id);
	        }, msg, expectReply, disposeOnDone);
	        this._futures.set(msg.header.msg_id, future);
	        return future;
	    };
	    /**
	     * Interrupt a kernel.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernels).
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     *
	     * It is assumed that the API call does not mutate the kernel id or name.
	     *
	     * The promise will be rejected if the kernel status is `Dead` or if the
	     * request fails or the response is invalid.
	     */
	    Kernel.prototype.interrupt = function () {
	        return Private.interruptKernel(this, this._baseUrl, this.ajaxSettings);
	    };
	    /**
	     * Restart a kernel.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernels) and validates the response model.
	     *
	     * Any existing Future or Comm objects are cleared.
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     *
	     * It is assumed that the API call does not mutate the kernel id or name.
	     *
	     * The promise will be rejected if the request fails or the response is
	     * invalid.
	     */
	    Kernel.prototype.restart = function () {
	        this._clearState();
	        this._updateStatus('restarting');
	        return Private.restartKernel(this, this._baseUrl, this.ajaxSettings);
	    };
	    /**
	     * Reconnect to a disconnected kernel.
	     *
	     * #### Notes
	     * Used when the websocket connection to the kernel is lost.
	     */
	    Kernel.prototype.reconnect = function () {
	        if (this._ws !== null) {
	            // Clear the websocket event handlers and the socket itself.
	            this._ws.onclose = null;
	            this._ws.onerror = null;
	            this._ws.close();
	            this._ws = null;
	        }
	        this._isReady = false;
	        this._updateStatus('reconnecting');
	        this._createSocket();
	        return this._connectionPromise.promise;
	    };
	    /**
	     * Shutdown a kernel.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/kernels).
	     *
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     *
	     * On a valid response, closes the websocket and disposes of the kernel
	     * object, and fulfills the promise.
	     *
	     * The promise will be rejected if the kernel status is `Dead` or if the
	     * request fails or the response is invalid.
	     */
	    Kernel.prototype.shutdown = function () {
	        var _this = this;
	        if (this.status === 'dead') {
	            return Promise.reject(new Error('Kernel is dead'));
	        }
	        this._clearState();
	        return Private.shutdownKernel(this.id, this._baseUrl, this.ajaxSettings)
	            .then(function () {
	            _this.dispose();
	        });
	    };
	    /**
	     * Send a `kernel_info_request` message.
	     *
	     * #### Notes
	     * See [Messaging in Jupyter](http://jupyter-client.readthedocs.org/en/latest/messaging.html#kernel-info).
	     *
	     * Fulfills with the `kernel_info_response` content when the shell reply is
	     * received and validated.
	     */
	    Kernel.prototype.kernelInfo = function () {
	        var options = {
	            msgType: 'kernel_info_request',
	            channel: 'shell',
	            username: this._username,
	            session: this._clientId
	        };
	        var msg = createShellMessage(options);
	        return Private.handleShellMessage(this, msg);
	    };
	    /**
	     * Send a `complete_request` message.
	     *
	     * #### Notes
	     * See [Messaging in Jupyter](http://jupyter-client.readthedocs.org/en/latest/messaging.html#completion).
	     *
	     * Fulfills with the `complete_reply` content when the shell reply is
	     * received and validated.
	     */
	    Kernel.prototype.complete = function (content) {
	        var options = {
	            msgType: 'complete_request',
	            channel: 'shell',
	            username: this._username,
	            session: this._clientId
	        };
	        var msg = createShellMessage(options, content);
	        return Private.handleShellMessage(this, msg);
	    };
	    /**
	     * Send an `inspect_request` message.
	     *
	     * #### Notes
	     * See [Messaging in Jupyter](http://jupyter-client.readthedocs.org/en/latest/messaging.html#introspection).
	     *
	     * Fulfills with the `inspect_reply` content when the shell reply is
	     * received and validated.
	     */
	    Kernel.prototype.inspect = function (content) {
	        var options = {
	            msgType: 'inspect_request',
	            channel: 'shell',
	            username: this._username,
	            session: this._clientId
	        };
	        var msg = createShellMessage(options, content);
	        return Private.handleShellMessage(this, msg);
	    };
	    /**
	     * Send a `history_request` message.
	     *
	     * #### Notes
	     * See [Messaging in Jupyter](http://jupyter-client.readthedocs.org/en/latest/messaging.html#history).
	     *
	     * Fulfills with the `history_reply` content when the shell reply is
	     * received and validated.
	     */
	    Kernel.prototype.history = function (content) {
	        var options = {
	            msgType: 'history_request',
	            channel: 'shell',
	            username: this._username,
	            session: this._clientId
	        };
	        var msg = createShellMessage(options, content);
	        return Private.handleShellMessage(this, msg);
	    };
	    /**
	     * Send an `execute_request` message.
	     *
	     * #### Notes
	     * See [Messaging in Jupyter](http://jupyter-client.readthedocs.org/en/latest/messaging.html#execute).
	     *
	     * Future `onReply` is called with the `execute_reply` content when the
	     * shell reply is received and validated. The future will resolve when
	     * this message is received and the `idle` iopub status is received.
	     * The future will also be disposed at this point unless `disposeOnDone`
	     * is specified and `false`, in which case it is up to the caller to dispose
	     * of the future.
	     *
	     * **See also:** [[IExecuteReply]]
	     */
	    Kernel.prototype.execute = function (content, disposeOnDone) {
	        if (disposeOnDone === void 0) { disposeOnDone = true; }
	        var options = {
	            msgType: 'execute_request',
	            channel: 'shell',
	            username: this._username,
	            session: this._clientId
	        };
	        var defaults = {
	            silent: false,
	            store_history: true,
	            user_expressions: {},
	            allow_stdin: true,
	            stop_on_error: false
	        };
	        content = utils.extend(defaults, content);
	        var msg = createShellMessage(options, content);
	        return this.sendShellMessage(msg, true, disposeOnDone);
	    };
	    /**
	     * Send an `is_complete_request` message.
	     *
	     * #### Notes
	     * See [Messaging in Jupyter](http://jupyter-client.readthedocs.org/en/latest/messaging.html#code-completeness).
	     *
	     * Fulfills with the `is_complete_response` content when the shell reply is
	     * received and validated.
	     */
	    Kernel.prototype.isComplete = function (content) {
	        var options = {
	            msgType: 'is_complete_request',
	            channel: 'shell',
	            username: this._username,
	            session: this._clientId
	        };
	        var msg = createShellMessage(options, content);
	        return Private.handleShellMessage(this, msg);
	    };
	    /**
	     * Send a `comm_info_request` message.
	     *
	     * #### Notes
	     * Fulfills with the `comm_info_reply` content when the shell reply is
	     * received and validated.
	     */
	    Kernel.prototype.commInfo = function (content) {
	        var options = {
	            msgType: 'comm_info_request',
	            channel: 'shell',
	            username: this._username,
	            session: this._clientId
	        };
	        var msg = createShellMessage(options, content);
	        return Private.handleShellMessage(this, msg);
	    };
	    /**
	     * Send an `input_reply` message.
	     *
	     * #### Notes
	     * See [Messaging in Jupyter](http://jupyter-client.readthedocs.org/en/latest/messaging.html#messages-on-the-stdin-router-dealer-sockets).
	     */
	    Kernel.prototype.sendInputReply = function (content) {
	        if (this.status === 'dead') {
	            throw new Error('Kernel is dead');
	        }
	        var options = {
	            msgType: 'input_reply',
	            channel: 'stdin',
	            username: this._username,
	            session: this._clientId
	        };
	        var msg = createKernelMessage(options, content);
	        if (!this._isReady) {
	            this._pendingMessages.push(msg);
	        }
	        else {
	            this._ws.send(serialize.serialize(msg));
	        }
	    };
	    /**
	     * Register an IOPub message hook.
	     *
	     * @param msg_id - The parent_header message id the hook will intercept.
	     *
	     * @param hook - The callback invoked for the message.
	     *
	     * @returns A disposable used to unregister the message hook.
	     *
	     * #### Notes
	     * The IOPub hook system allows you to preempt the handlers for IOPub messages with a
	     * given parent_header message id. The most recently registered hook is run first.
	     * If the hook returns false, any later hooks and the future's onIOPub handler will not run.
	     * If a hook throws an error, the error is logged to the console and the next hook is run.
	     * If a hook is registered during the hook processing, it won't run until the next message.
	     * If a hook is disposed during the hook processing, it will be deactivated immediately.
	     *
	     * See also [[IFuture.registerMessageHook]].
	     */
	    Kernel.prototype.registerMessageHook = function (msg_id, hook) {
	        var _this = this;
	        var future = this._futures && this._futures.get(msg_id);
	        if (future) {
	            future.registerMessageHook(hook);
	        }
	        return new phosphor_disposable_1.DisposableDelegate(function () {
	            var future = _this._futures && _this._futures.get(msg_id);
	            if (future) {
	                future.removeMessageHook(hook);
	            }
	        });
	    };
	    /**
	     * Register a comm target handler.
	     *
	     * @param targetName - The name of the comm target.
	     *
	     * @param callback - The callback invoked for a comm open message.
	     *
	     * @returns A disposable used to unregister the comm target.
	     *
	     * #### Notes
	     * Only one comm target can be registered at a time, an existing
	     * callback will be overidden.  A registered comm target handler will take
	     * precedence over a comm which specifies a `target_module`.
	     */
	    Kernel.prototype.registerCommTarget = function (targetName, callback) {
	        var _this = this;
	        this._targetRegistry[targetName] = callback;
	        return new phosphor_disposable_1.DisposableDelegate(function () {
	            if (!_this.isDisposed) {
	                delete _this._targetRegistry[targetName];
	            }
	        });
	    };
	    /**
	     * Connect to a comm, or create a new one.
	     *
	     * #### Notes
	     * If a client-side comm already exists, it is returned.
	     */
	    Kernel.prototype.connectToComm = function (targetName, commId) {
	        var _this = this;
	        if (commId === void 0) {
	            commId = utils.uuid();
	        }
	        var comm = this._comms.get(commId);
	        if (!comm) {
	            comm = new Comm(targetName, commId, this, function () { _this._unregisterComm(commId); });
	            this._comms.set(commId, comm);
	        }
	        return comm;
	    };
	    /**
	     * Get the kernel spec associated with the kernel.
	     *
	     * #### Notes
	     * This value is cached and only fetched the first time it is requested.
	     */
	    Kernel.prototype.getKernelSpec = function () {
	        var _this = this;
	        if (this._spec) {
	            return Promise.resolve(this._spec);
	        }
	        var name = this.name;
	        var options = { baseUrl: this._baseUrl, ajaxSettings: this._ajaxSettings };
	        return getKernelSpecs(options).then(function (ids) {
	            var id = ids.kernelspecs[name];
	            if (!id) {
	                throw new Error("Could not find kernel spec for " + name);
	            }
	            _this._spec = id.spec;
	            return _this._spec;
	        });
	    };
	    /**
	     * Create the kernel websocket connection and add socket status handlers.
	     */
	    Kernel.prototype._createSocket = function () {
	        var _this = this;
	        var partialUrl = utils.urlPathJoin(this._wsUrl, KERNEL_SERVICE_URL, utils.urlJoinEncode(this._id));
	        // Strip any authentication from the display string.
	        var display = partialUrl.replace(/^((?:\w+:)?\/\/)(?:[^@\/]+@)/, '$1');
	        console.log('Starting WebSocket:', display);
	        var url = (utils.urlPathJoin(partialUrl, 'channels') +
	            '?session_id=' + this._clientId);
	        this._connectionPromise = new utils.PromiseDelegate();
	        this._ws = new WebSocket(url);
	        // Ensure incoming binary messages are not Blobs
	        this._ws.binaryType = 'arraybuffer';
	        this._ws.onmessage = function (evt) { _this._onWSMessage(evt); };
	        this._ws.onopen = function (evt) { _this._onWSOpen(evt); };
	        this._ws.onclose = function (evt) { _this._onWSClose(evt); };
	        this._ws.onerror = function (evt) { _this._onWSClose(evt); };
	    };
	    /**
	     * Handle a websocket open event.
	     */
	    Kernel.prototype._onWSOpen = function (evt) {
	        var _this = this;
	        this._reconnectAttempt = 0;
	        // Allow the message to get through.
	        this._isReady = true;
	        // Get the kernel info, signaling that the kernel is ready.
	        this.kernelInfo().then(function () {
	            _this._connectionPromise.resolve(void 0);
	        });
	        this._isReady = false;
	    };
	    /**
	     * Handle a websocket message, validating and routing appropriately.
	     */
	    Kernel.prototype._onWSMessage = function (evt) {
	        if (this.status === 'dead') {
	            // If the socket is being closed, ignore any messages
	            return;
	        }
	        var msg = serialize.deserialize(evt.data);
	        try {
	            validate.validateKernelMessage(msg);
	        }
	        catch (error) {
	            console.error(error.message);
	            return;
	        }
	        if (msg.parent_header) {
	            var parentHeader = msg.parent_header;
	            var future = this._futures && this._futures.get(parentHeader.msg_id);
	            if (future) {
	                future.handleMsg(msg);
	            }
	            else {
	                // If the message was sent by us and was not iopub, it is orphaned.
	                var owned = parentHeader.session === this.clientId;
	                if (msg.channel !== 'iopub' && owned) {
	                    this.unhandledMessage.emit(msg);
	                }
	            }
	        }
	        if (msg.channel === 'iopub') {
	            switch (msg.header.msg_type) {
	                case 'status':
	                    this._updateStatus(msg.content.execution_state);
	                    break;
	                case 'comm_open':
	                    this._handleCommOpen(msg);
	                    break;
	                case 'comm_msg':
	                    this._handleCommMsg(msg);
	                    break;
	                case 'comm_close':
	                    this._handleCommClose(msg);
	                    break;
	            }
	            this.iopubMessage.emit(msg);
	        }
	    };
	    /**
	     * Handle a websocket close event.
	     */
	    Kernel.prototype._onWSClose = function (evt) {
	        if (this.status === 'dead') {
	            return;
	        }
	        // Clear the websocket event handlers and the socket itself.
	        this._ws.onclose = null;
	        this._ws.onerror = null;
	        this._ws = null;
	        if (this._reconnectAttempt < this._reconnectLimit) {
	            this._updateStatus('reconnecting');
	            var timeout = Math.pow(2, this._reconnectAttempt);
	            console.error('Connection lost, reconnecting in ' + timeout + ' seconds.');
	            setTimeout(this._createSocket.bind(this), 1e3 * timeout);
	            this._reconnectAttempt += 1;
	        }
	        else {
	            this._updateStatus('dead');
	        }
	    };
	    /**
	     * Handle status iopub messages from the kernel.
	     */
	    Kernel.prototype._updateStatus = function (status) {
	        switch (status) {
	            case 'starting':
	            case 'idle':
	            case 'busy':
	                this._isReady = true;
	                break;
	            case 'restarting':
	            case 'reconnecting':
	            case 'dead':
	                this._isReady = false;
	                break;
	            default:
	                console.error('invalid kernel status:', status);
	                return;
	        }
	        if (status !== this._status) {
	            this._status = status;
	            Private.logKernelStatus(this);
	            this.statusChanged.emit(status);
	            if (status === 'dead') {
	                this.dispose();
	            }
	        }
	        if (this._isReady) {
	            this._sendPending();
	        }
	    };
	    /**
	     * Send pending messages to the kernel.
	     */
	    Kernel.prototype._sendPending = function () {
	        // We shift the message off the queue
	        // after the message is sent so that if there is an exception,
	        // the message is still pending.
	        while (this._pendingMessages.length > 0) {
	            var msg = serialize.serialize(this._pendingMessages[0]);
	            this._ws.send(msg);
	            this._pendingMessages.shift();
	        }
	    };
	    /**
	     * Clear the internal state.
	     */
	    Kernel.prototype._clearState = function () {
	        this._isReady = false;
	        this._pendingMessages = [];
	        this._futures.forEach(function (future, key) {
	            future.dispose();
	        });
	        this._comms.forEach(function (comm, key) {
	            comm.dispose();
	        });
	        this._futures = new Map();
	        this._commPromises = new Map();
	        this._comms = new Map();
	    };
	    /**
	     * Handle a `comm_open` kernel message.
	     */
	    Kernel.prototype._handleCommOpen = function (msg) {
	        var _this = this;
	        var content = msg.content;
	        var promise = utils.loadObject(content.target_name, content.target_module, this._targetRegistry).then(function (target) {
	            var comm = new Comm(content.target_name, content.comm_id, _this, function () { _this._unregisterComm(content.comm_id); });
	            var response;
	            try {
	                response = target(comm, msg);
	            }
	            catch (e) {
	                comm.close();
	                console.error('Exception opening new comm');
	                throw (e);
	            }
	            return Promise.resolve(response).then(function () {
	                _this._commPromises.delete(comm.commId);
	                _this._comms.set(comm.commId, comm);
	                return comm;
	            });
	        });
	        this._commPromises.set(content.comm_id, promise);
	    };
	    /**
	     * Handle 'comm_close' kernel message.
	     */
	    Kernel.prototype._handleCommClose = function (msg) {
	        var _this = this;
	        var content = msg.content;
	        var promise = this._commPromises.get(content.comm_id);
	        if (!promise) {
	            var comm = this._comms.get(content.comm_id);
	            if (!comm) {
	                console.error('Comm not found for comm id ' + content.comm_id);
	                return;
	            }
	            promise = Promise.resolve(comm);
	        }
	        promise.then(function (comm) {
	            _this._unregisterComm(comm.commId);
	            try {
	                var onClose = comm.onClose;
	                if (onClose) {
	                    onClose(msg);
	                }
	                comm.dispose();
	            }
	            catch (e) {
	                console.error('Exception closing comm: ', e, e.stack, msg);
	            }
	        });
	    };
	    /**
	     * Handle a 'comm_msg' kernel message.
	     */
	    Kernel.prototype._handleCommMsg = function (msg) {
	        var content = msg.content;
	        var promise = this._commPromises.get(content.comm_id);
	        if (!promise) {
	            var comm = this._comms.get(content.comm_id);
	            if (!comm) {
	                console.error('Comm not found for comm id ' + content.comm_id);
	                return;
	            }
	            else {
	                var onMsg = comm.onMsg;
	                if (onMsg) {
	                    onMsg(msg);
	                }
	            }
	        }
	        else {
	            promise.then(function (comm) {
	                try {
	                    var onMsg = comm.onMsg;
	                    if (onMsg) {
	                        onMsg(msg);
	                    }
	                }
	                catch (e) {
	                    console.error('Exception handling comm msg: ', e, e.stack, msg);
	                }
	                return comm;
	            });
	        }
	    };
	    /**
	     * Unregister a comm instance.
	     */
	    Kernel.prototype._unregisterComm = function (commId) {
	        this._comms.delete(commId);
	        this._commPromises.delete(commId);
	    };
	    return Kernel;
	}());
	/**
	 * Comm channel handler.
	 */
	var Comm = (function (_super) {
	    __extends(Comm, _super);
	    /**
	     * Construct a new comm channel.
	     */
	    function Comm(target, id, kernel, disposeCb) {
	        _super.call(this, disposeCb);
	        this._target = '';
	        this._id = '';
	        this._kernel = null;
	        this._onClose = null;
	        this._onMsg = null;
	        this._id = id;
	        this._target = target;
	        this._kernel = kernel;
	    }
	    Object.defineProperty(Comm.prototype, "commId", {
	        /**
	         * The unique id for the comm channel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._id;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Comm.prototype, "targetName", {
	        /**
	         * The target name for the comm channel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._target;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Comm.prototype, "onClose", {
	        /**
	         * Get the callback for a comm close event.
	         *
	         * #### Notes
	         * This is called when the comm is closed from either the server or
	         * client.
	         *
	         * **See also:** [[ICommClose]], [[close]]
	         */
	        get: function () {
	            return this._onClose;
	        },
	        /**
	         * Set the callback for a comm close event.
	         *
	         * #### Notes
	         * This is called when the comm is closed from either the server or
	         * client.
	         *
	         * **See also:** [[close]]
	         */
	        set: function (cb) {
	            this._onClose = cb;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Comm.prototype, "onMsg", {
	        /**
	         * Get the callback for a comm message received event.
	         */
	        get: function () {
	            return this._onMsg;
	        },
	        /**
	         * Set the callback for a comm message received event.
	         */
	        set: function (cb) {
	            this._onMsg = cb;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Comm.prototype, "isDisposed", {
	        /**
	         * Test whether the comm has been disposed.
	         *
	         * #### Notes
	         * This is a read-only property which is always safe to access.
	         */
	        get: function () {
	            return (this._kernel === null);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Open a comm with optional data and metadata.
	     *
	     * #### Notes
	     * This sends a `comm_open` message to the server.
	     *
	     * **See also:** [[ICommOpen]]
	     */
	    Comm.prototype.open = function (data, metadata) {
	        if (this.isDisposed || this._kernel.isDisposed) {
	            return;
	        }
	        var options = {
	            msgType: 'comm_open',
	            channel: 'shell',
	            username: this._kernel.username,
	            session: this._kernel.clientId
	        };
	        var content = {
	            comm_id: this._id,
	            target_name: this._target,
	            data: data || {}
	        };
	        var msg = createShellMessage(options, content, metadata);
	        return this._kernel.sendShellMessage(msg, false, true);
	    };
	    /**
	     * Send a `comm_msg` message to the kernel.
	     *
	     * #### Notes
	     * This is a no-op if the comm has been closed.
	     *
	     * **See also:** [[ICommMsg]]
	     */
	    Comm.prototype.send = function (data, metadata, buffers, disposeOnDone) {
	        if (buffers === void 0) { buffers = []; }
	        if (disposeOnDone === void 0) { disposeOnDone = true; }
	        if (this.isDisposed || this._kernel.isDisposed) {
	            return;
	        }
	        var options = {
	            msgType: 'comm_msg',
	            channel: 'shell',
	            username: this._kernel.username,
	            session: this._kernel.clientId
	        };
	        var content = {
	            comm_id: this._id,
	            data: data
	        };
	        var msg = createShellMessage(options, content, metadata, buffers);
	        return this._kernel.sendShellMessage(msg, false, true);
	    };
	    /**
	     * Close the comm.
	     *
	     * #### Notes
	     * This will send a `comm_close` message to the kernel, and call the
	     * `onClose` callback if set.
	     *
	     * This is a no-op if the comm is already closed.
	     *
	     * **See also:** [[ICommClose]], [[onClose]]
	     */
	    Comm.prototype.close = function (data, metadata) {
	        if (this.isDisposed || this._kernel.isDisposed) {
	            return;
	        }
	        var options = {
	            msgType: 'comm_msg',
	            channel: 'shell',
	            username: this._kernel.username,
	            session: this._kernel.clientId
	        };
	        var content = {
	            comm_id: this._id,
	            data: data || {}
	        };
	        var msg = createShellMessage(options, content, metadata);
	        var future = this._kernel.sendShellMessage(msg, false, true);
	        options.channel = 'iopub';
	        var ioMsg = createKernelMessage(options, content, metadata);
	        var onClose = this._onClose;
	        if (onClose) {
	            onClose(ioMsg);
	        }
	        this.dispose();
	        return future;
	    };
	    /**
	     * Dispose of the resources held by the comm.
	     */
	    Comm.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._onClose = null;
	        this._onMsg = null;
	        this._kernel = null;
	        _super.prototype.dispose.call(this);
	    };
	    return Comm;
	}(phosphor_disposable_1.DisposableDelegate));
	/**
	 * A private namespace for the Kernel.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A signal emitted when the kernel status changes.
	     */
	    Private.statusChangedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted for iopub kernel messages.
	     */
	    Private.iopubMessageSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted for unhandled kernel message.
	     */
	    Private.unhandledMessageSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted when the specs change.
	     */
	    Private.specsChangedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted when the running kernels change.
	     */
	    Private.runningChangedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A module private store for running kernels.
	     */
	    Private.runningKernels = Object.create(null);
	    /**
	     * Restart a kernel.
	     */
	    function restartKernel(kernel, baseUrl, ajaxSettings) {
	        if (kernel.status === 'dead') {
	            return Promise.reject(new Error('Kernel is dead'));
	        }
	        var url = utils.urlPathJoin(baseUrl, KERNEL_SERVICE_URL, utils.urlJoinEncode(kernel.id, 'restart'));
	        ajaxSettings = ajaxSettings || {};
	        ajaxSettings.method = 'POST';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	            validate.validateKernelModel(success.data);
	        }, onKernelError);
	    }
	    Private.restartKernel = restartKernel;
	    /**
	     * Interrupt a kernel.
	     */
	    function interruptKernel(kernel, baseUrl, ajaxSettings) {
	        if (kernel.status === 'dead') {
	            return Promise.reject(new Error('Kernel is dead'));
	        }
	        var url = utils.urlPathJoin(baseUrl, KERNEL_SERVICE_URL, utils.urlJoinEncode(kernel.id, 'interrupt'));
	        ajaxSettings = ajaxSettings || {};
	        ajaxSettings.method = 'POST';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	        }, onKernelError);
	    }
	    Private.interruptKernel = interruptKernel;
	    /**
	     * Delete a kernel.
	     */
	    function shutdownKernel(id, baseUrl, ajaxSettings) {
	        var url = utils.urlPathJoin(baseUrl, KERNEL_SERVICE_URL, utils.urlJoinEncode(id));
	        ajaxSettings = ajaxSettings || {};
	        ajaxSettings.method = 'DELETE';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	        }, onKernelError);
	    }
	    Private.shutdownKernel = shutdownKernel;
	    /**
	     * Get a full kernel model from the server by kernel id string.
	     */
	    function getKernelModel(id, options) {
	        options = options || {};
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        var url = utils.urlPathJoin(baseUrl, KERNEL_SERVICE_URL, id);
	        var ajaxSettings = options.ajaxSettings || {};
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	            var data = success.data;
	            validate.validateKernelModel(data);
	            return data;
	        }, Private.onKernelError);
	    }
	    Private.getKernelModel = getKernelModel;
	    /**
	     * Log the current kernel status.
	     */
	    function logKernelStatus(kernel) {
	        switch (kernel.status) {
	            case 'idle':
	            case 'busy':
	            case 'unknown':
	                return;
	            default:
	                console.log("Kernel: " + kernel.status + " (" + kernel.id + ")");
	                break;
	        }
	    }
	    Private.logKernelStatus = logKernelStatus;
	    /**
	     * Handle an error on a kernel Ajax call.
	     */
	    function onKernelError(error) {
	        var text = (error.statusText ||
	            error.error.message ||
	            error.xhr.responseText);
	        var msg = "API request failed (" + error.xhr.status + "): " + text;
	        throw Error(msg);
	    }
	    Private.onKernelError = onKernelError;
	    /**
	     * Send a kernel message to the kernel and resolve the reply message.
	     */
	    function handleShellMessage(kernel, msg) {
	        var future;
	        try {
	            future = kernel.sendShellMessage(msg, true);
	        }
	        catch (e) {
	            return Promise.reject(e);
	        }
	        return new Promise(function (resolve, reject) {
	            future.onReply = function (reply) {
	                resolve(reply);
	            };
	        });
	    }
	    Private.handleShellMessage = handleShellMessage;
	    /**
	     * Throw a typed error.
	     */
	    function typedThrow(msg) {
	        throw new Error(msg);
	    }
	    Private.typedThrow = typedThrow;
	})(Private || (Private = {}));


/***/ },
/* 135 */
/***/ function(module, exports) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	/**
	 * Test whether a JSON value is a primitive.
	 *
	 * @param value - The JSON value of interest.
	 *
	 * @returns `true` if the value is a primitive or `null`,
	 *   `false` otherwise.
	 */
	function isPrimitive(value) {
	    return (value === null ||
	        typeof value === 'boolean' ||
	        typeof value === 'number' ||
	        typeof value === 'string');
	}
	exports.isPrimitive = isPrimitive;
	/**
	 * Test whether a JSON value is an array.
	 *
	 * @param value - The JSON value of interest.
	 *
	 * @returns `true` if the value is a an array, `false` otherwise.
	 */
	function isArray(value) {
	    return Array.isArray(value);
	}
	exports.isArray = isArray;
	/**
	 * Test whether a JSON value is an object.
	 *
	 * @param value - The JSON value of interest.
	 *
	 * @returns `true` if the value is a an object, `false` otherwise.
	 */
	function isObject(value) {
	    return !isPrimitive(value) && !isArray(value);
	}
	exports.isObject = isObject;
	/**
	 * Compare two JSON values for deep equality.
	 *
	 * @param first - The first JSON value of interest.
	 *
	 * @param second - The second JSON value of interest.
	 *
	 * @returns `true` if the values are equivalent, `false` otherwise.
	 */
	function deepEqual(first, second) {
	    // Check referential and primitive equality first.
	    if (first === second) {
	        return true;
	    }
	    // If one is a primitive, the `===` check ruled out the other.
	    if (isPrimitive(first) || isPrimitive(second)) {
	        return false;
	    }
	    // Bail if either is `undefined`.
	    if (!first || !second) {
	        return false;
	    }
	    // Test whether they are arrays.
	    var a1 = isArray(first);
	    var a2 = isArray(second);
	    // Bail if the types are different.
	    if (a1 !== a2) {
	        return false;
	    }
	    // If they are both arrays, compare them.
	    if (a1 && a2) {
	        return Private.arrayEqual(first, second);
	    }
	    // At this point, they must both be objects.
	    return Private.objectEqual(first, second);
	}
	exports.deepEqual = deepEqual;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Compare two JSON arrays for deep equality.
	     */
	    function arrayEqual(first, second) {
	        // Test the arrays for equal length.
	        if (first.length !== second.length) {
	            return false;
	        }
	        // Compare the values for equality.
	        for (var i = 0, n = first.length; i < n; ++i) {
	            if (!deepEqual(first[i], second[i])) {
	                return false;
	            }
	        }
	        // At this point, the arrays are equal.
	        return true;
	    }
	    Private.arrayEqual = arrayEqual;
	    /**
	     * Compare two JSON objects for deep equality.
	     */
	    function objectEqual(first, second) {
	        // Get the keys for each object.
	        var k1 = Object.keys(first);
	        var k2 = Object.keys(second);
	        // Test the keys for equal length.
	        if (k1.length !== k2.length) {
	            return false;
	        }
	        // Sort the keys for equivalent order.
	        k1.sort();
	        k2.sort();
	        // Compare the keys for equality.
	        for (var i = 0, n = k1.length; i < n; ++i) {
	            if (k1[i] !== k2[i]) {
	                return false;
	            }
	        }
	        // Compare the values for equality.
	        for (var i = 0, n = k1.length; i < n; ++i) {
	            if (!deepEqual(first[k1[i]], second[k1[i]])) {
	                return false;
	            }
	        }
	        // At this point, the objects are equal.
	        return true;
	    }
	    Private.objectEqual = objectEqual;
	})(Private || (Private = {}));


/***/ },
/* 136 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(setImmediate) {// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	'use strict';
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var phosphor_disposable_1 = __webpack_require__(8);
	var ikernel_1 = __webpack_require__(133);
	/**
	 * Implementation of a kernel future.
	 */
	var KernelFutureHandler = (function (_super) {
	    __extends(KernelFutureHandler, _super);
	    /**
	     * Construct a new KernelFutureHandler.
	     */
	    function KernelFutureHandler(cb, msg, expectShell, disposeOnDone) {
	        _super.call(this, cb);
	        this._msg = null;
	        this._status = 0;
	        this._stdin = null;
	        this._iopub = null;
	        this._reply = null;
	        this._done = null;
	        this._hooks = new Private.HookList();
	        this._disposeOnDone = true;
	        this._msg = msg;
	        if (!expectShell) {
	            this._setFlag(Private.KernelFutureFlag.GotReply);
	        }
	        this._disposeOnDone = disposeOnDone;
	    }
	    Object.defineProperty(KernelFutureHandler.prototype, "msg", {
	        /**
	         * Get the original outgoing message.
	         */
	        get: function () {
	            return this._msg;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelFutureHandler.prototype, "isDone", {
	        /**
	         * Check for message done state.
	         */
	        get: function () {
	            return this._testFlag(Private.KernelFutureFlag.IsDone);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelFutureHandler.prototype, "onReply", {
	        /**
	         * Get the reply handler.
	         */
	        get: function () {
	            return this._reply;
	        },
	        /**
	         * Set the reply handler.
	         */
	        set: function (cb) {
	            this._reply = cb;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelFutureHandler.prototype, "onIOPub", {
	        /**
	         * Get the iopub handler.
	         */
	        get: function () {
	            return this._iopub;
	        },
	        /**
	         * Set the iopub handler.
	         */
	        set: function (cb) {
	            this._iopub = cb;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelFutureHandler.prototype, "onDone", {
	        /**
	         * Get the done handler.
	         */
	        get: function () {
	            return this._done;
	        },
	        /**
	         * Set the done handler.
	         */
	        set: function (cb) {
	            this._done = cb;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(KernelFutureHandler.prototype, "onStdin", {
	        /**
	         * Get the stdin handler.
	         */
	        get: function () {
	            return this._stdin;
	        },
	        /**
	         * Set the stdin handler.
	         */
	        set: function (cb) {
	            this._stdin = cb;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Register hook for IOPub messages.
	     *
	     * @param hook - The callback invoked for an IOPub message.
	     *
	     * #### Notes
	     * The IOPub hook system allows you to preempt the handlers for IOPub messages handled
	     * by the future. The most recently registered hook is run first.
	     * If the hook returns false, any later hooks and the future's onIOPub handler will not run.
	     * If a hook throws an error, the error is logged to the console and the next hook is run.
	     * If a hook is registered during the hook processing, it won't run until the next message.
	     * If a hook is removed during the hook processing, it will be deactivated immediately.
	     */
	    KernelFutureHandler.prototype.registerMessageHook = function (hook) {
	        this._hooks.add(hook);
	    };
	    /**
	     * Remove a hook for IOPub messages.
	     *
	     * @param hook - The hook to remove.
	     *
	     * #### Notes
	     * If a hook is removed during the hook processing, it will be deactivated immediately.
	     */
	    KernelFutureHandler.prototype.removeMessageHook = function (hook) {
	        if (this.isDisposed) {
	            return;
	        }
	        this._hooks.remove(hook);
	    };
	    /**
	     * Dispose and unregister the future.
	     */
	    KernelFutureHandler.prototype.dispose = function () {
	        this._stdin = null;
	        this._iopub = null;
	        this._reply = null;
	        this._done = null;
	        this._msg = null;
	        if (this._hooks) {
	            this._hooks.dispose();
	        }
	        this._hooks = null;
	        _super.prototype.dispose.call(this);
	    };
	    /**
	     * Handle an incoming kernel message.
	     */
	    KernelFutureHandler.prototype.handleMsg = function (msg) {
	        switch (msg.channel) {
	            case 'shell':
	                this._handleReply(msg);
	                break;
	            case 'stdin':
	                this._handleStdin(msg);
	                break;
	            case 'iopub':
	                this._handleIOPub(msg);
	                break;
	        }
	    };
	    KernelFutureHandler.prototype._handleReply = function (msg) {
	        var reply = this._reply;
	        if (reply) {
	            reply(msg);
	        }
	        this._setFlag(Private.KernelFutureFlag.GotReply);
	        if (this._testFlag(Private.KernelFutureFlag.GotIdle)) {
	            this._handleDone();
	        }
	    };
	    KernelFutureHandler.prototype._handleStdin = function (msg) {
	        var stdin = this._stdin;
	        if (stdin) {
	            stdin(msg);
	        }
	    };
	    KernelFutureHandler.prototype._handleIOPub = function (msg) {
	        var process = this._hooks.process(msg);
	        var iopub = this._iopub;
	        if (process && iopub) {
	            iopub(msg);
	        }
	        if (ikernel_1.KernelMessage.isStatusMsg(msg) &&
	            msg.content.execution_state === 'idle') {
	            this._setFlag(Private.KernelFutureFlag.GotIdle);
	            if (this._testFlag(Private.KernelFutureFlag.GotReply)) {
	                this._handleDone();
	            }
	        }
	    };
	    KernelFutureHandler.prototype._handleDone = function () {
	        if (this.isDone) {
	            return;
	        }
	        this._setFlag(Private.KernelFutureFlag.IsDone);
	        var done = this._done;
	        if (done)
	            done();
	        this._done = null;
	        if (this._disposeOnDone) {
	            this.dispose();
	        }
	    };
	    /**
	     * Test whether the given future flag is set.
	     */
	    KernelFutureHandler.prototype._testFlag = function (flag) {
	        return (this._status & flag) !== 0;
	    };
	    /**
	     * Set the given future flag.
	     */
	    KernelFutureHandler.prototype._setFlag = function (flag) {
	        this._status |= flag;
	    };
	    return KernelFutureHandler;
	}(phosphor_disposable_1.DisposableDelegate));
	exports.KernelFutureHandler = KernelFutureHandler;
	var Private;
	(function (Private) {
	    /**
	     * A polyfill for a function to run code outside of the current execution context.
	     */
	    var defer = typeof requestAnimationFrame === "function" ? requestAnimationFrame : setImmediate;
	    var HookList = (function () {
	        function HookList() {
	            this._hooks = [];
	        }
	        /**
	         * Register a hook.
	         *
	         * @param hook - The callback to register.
	         */
	        HookList.prototype.add = function (hook) {
	            this.remove(hook);
	            this._hooks.push(hook);
	        };
	        /**
	         * Remove a hook.
	         *
	         * @param hook - The callback to remove.
	         */
	        HookList.prototype.remove = function (hook) {
	            if (this.isDisposed) {
	                return;
	            }
	            var index = this._hooks.indexOf(hook);
	            if (index >= 0) {
	                this._hooks[index] = null;
	                this._scheduleCompact();
	            }
	        };
	        /**
	         * Process a message through the hooks.
	         *
	         * #### Notes
	         * The most recently registered hook is run first.
	         * If the hook returns false, any later hooks will not run.
	         * If a hook throws an error, the error is logged to the console and the next hook is run.
	         * If a hook is registered during the hook processing, it won't run until the next message.
	         * If a hook is removed during the hook processing, it will be deactivated immediately.
	         */
	        HookList.prototype.process = function (msg) {
	            var continueHandling;
	            // most recently-added hook is called first
	            for (var i = this._hooks.length - 1; i >= 0; i--) {
	                var hook = this._hooks[i];
	                if (hook === null) {
	                    continue;
	                }
	                try {
	                    continueHandling = hook(msg);
	                }
	                catch (err) {
	                    continueHandling = true;
	                    console.error(err);
	                }
	                if (continueHandling === false) {
	                    return false;
	                }
	            }
	            return true;
	        };
	        Object.defineProperty(HookList.prototype, "isDisposed", {
	            /**
	             * Test whether the HookList has been disposed.
	             *
	             * #### Notes
	             * This is a read-only property which is always safe to access.
	             */
	            get: function () {
	                return (this._hooks === null);
	            },
	            enumerable: true,
	            configurable: true
	        });
	        /**
	         * Dispose the hook list.
	         */
	        HookList.prototype.dispose = function () {
	            this._hooks = null;
	        };
	        /**
	         * Schedule a cleanup of the list, removing any hooks that have been nulled out.
	         */
	        HookList.prototype._scheduleCompact = function () {
	            var _this = this;
	            if (!this._cleanupScheduled) {
	                this._cleanupScheduled = true;
	                defer(function () {
	                    _this._cleanupScheduled = false;
	                    _this._compact();
	                });
	            }
	        };
	        /**
	         * Compact the list, removing any nulls.
	         */
	        HookList.prototype._compact = function () {
	            if (this.isDisposed) {
	                return;
	            }
	            var numNulls = 0;
	            for (var i = 0, len = this._hooks.length; i < len; i++) {
	                var hook = this._hooks[i];
	                if (this._hooks[i] === null) {
	                    numNulls++;
	                }
	                else {
	                    this._hooks[i - numNulls] = hook;
	                }
	            }
	            this._hooks.length -= numNulls;
	        };
	        return HookList;
	    }());
	    Private.HookList = HookList;
	    /**
	     * Bit flags for the kernel future state.
	     */
	    (function (KernelFutureFlag) {
	        KernelFutureFlag[KernelFutureFlag["GotReply"] = 1] = "GotReply";
	        KernelFutureFlag[KernelFutureFlag["GotIdle"] = 2] = "GotIdle";
	        KernelFutureFlag[KernelFutureFlag["IsDone"] = 4] = "IsDone";
	        KernelFutureFlag[KernelFutureFlag["DisposeOnDone"] = 8] = "DisposeOnDone";
	    })(Private.KernelFutureFlag || (Private.KernelFutureFlag = {}));
	    var KernelFutureFlag = Private.KernelFutureFlag;
	})(Private || (Private = {}));
	
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(14).setImmediate))

/***/ },
/* 137 */
/***/ function(module, exports) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	'use strict';
	/**
	 * Deserialize and return the unpacked message.
	 *
	 * #### Notes
	 * Handles JSON blob strings and binary messages.
	 */
	function deserialize(data) {
	    var value;
	    if (typeof data === 'string') {
	        value = JSON.parse(data);
	    }
	    else {
	        value = deserializeBinary(data);
	    }
	    return value;
	}
	exports.deserialize = deserialize;
	/**
	 * Serialize a kernel message for transport.
	 *
	 * #### Notes
	 * If there is binary content, an `ArrayBuffer` is returned,
	 * otherwise the message is converted to a JSON string.
	 */
	function serialize(msg) {
	    var value;
	    if (msg.buffers && msg.buffers.length) {
	        value = serializeBinary(msg);
	    }
	    else {
	        value = JSON.stringify(msg);
	    }
	    return value;
	}
	exports.serialize = serialize;
	/**
	 * Deserialize a binary message to a Kernel Message.
	 */
	function deserializeBinary(buf) {
	    var data = new DataView(buf);
	    // read the header: 1 + nbufs 32b integers
	    var nbufs = data.getUint32(0);
	    var offsets = [];
	    if (nbufs < 2) {
	        throw new Error('Invalid incoming Kernel Message');
	    }
	    for (var i = 1; i <= nbufs; i++) {
	        offsets.push(data.getUint32(i * 4));
	    }
	    var jsonBytes = new Uint8Array(buf.slice(offsets[0], offsets[1]));
	    var msg = JSON.parse((new TextDecoder('utf8')).decode(jsonBytes));
	    // the remaining chunks are stored as DataViews in msg.buffers
	    msg.buffers = [];
	    for (var i = 1; i < nbufs; i++) {
	        var start = offsets[i];
	        var stop = offsets[i + 1] || buf.byteLength;
	        msg.buffers.push(new DataView(buf.slice(start, stop)));
	    }
	    return msg;
	}
	/**
	 * Implement the binary serialization protocol.
	 *
	 * Serialize Kernel message to ArrayBuffer.
	 */
	function serializeBinary(msg) {
	    var offsets = [];
	    var buffers = [];
	    var encoder = new TextEncoder('utf8');
	    var jsonUtf8 = encoder.encode(JSON.stringify(msg, replaceBuffers));
	    buffers.push(jsonUtf8.buffer);
	    for (var i = 0; i < msg.buffers.length; i++) {
	        // msg.buffers elements could be either views or ArrayBuffers
	        // buffers elements are ArrayBuffers
	        var b = msg.buffers[i];
	        buffers.push(b instanceof ArrayBuffer ? b : b.buffer);
	    }
	    var nbufs = buffers.length;
	    offsets.push(4 * (nbufs + 1));
	    for (var i = 0; i + 1 < buffers.length; i++) {
	        offsets.push(offsets[offsets.length - 1] + buffers[i].byteLength);
	    }
	    var msgBuf = new Uint8Array(offsets[offsets.length - 1] + buffers[buffers.length - 1].byteLength);
	    // use DataView.setUint32 for network byte-order
	    var view = new DataView(msgBuf.buffer);
	    // write nbufs to first 4 bytes
	    view.setUint32(0, nbufs);
	    // write offsets to next 4 * nbufs bytes
	    for (var i = 0; i < offsets.length; i++) {
	        view.setUint32(4 * (i + 1), offsets[i]);
	    }
	    // write all the buffers at their respective offsets
	    for (var i = 0; i < buffers.length; i++) {
	        msgBuf.set(new Uint8Array(buffers[i]), offsets[i]);
	    }
	    return msgBuf.buffer;
	}
	/**
	 * Filter `"buffers"` key for `JSON.stringify`.
	 */
	function replaceBuffers(key, value) {
	    if (key === 'buffers') {
	        return undefined;
	    }
	    return value;
	}


/***/ },
/* 138 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var jupyter_js_utils_1 = __webpack_require__(129);
	var phosphor_signaling_1 = __webpack_require__(22);
	var contents_1 = __webpack_require__(131);
	var kernel_1 = __webpack_require__(134);
	var session_1 = __webpack_require__(139);
	var terminals_1 = __webpack_require__(140);
	/**
	 * Create a new service manager.
	 *
	 * @param options - The service manager creation options.
	 *
	 * @returns A promise that resolves with a service manager.
	 */
	function createServiceManager(options) {
	    if (options === void 0) { options = {}; }
	    options.baseUrl = options.baseUrl || jupyter_js_utils_1.getBaseUrl();
	    options.ajaxSettings = options.ajaxSettings || {};
	    if (options.kernelspecs) {
	        return Promise.resolve(new ServiceManager(options));
	    }
	    return kernel_1.getKernelSpecs(options.baseUrl).then(function (specs) {
	        options.kernelspecs = specs;
	        return new ServiceManager(options);
	    });
	}
	exports.createServiceManager = createServiceManager;
	/**
	 * An implementation of a services manager.
	 */
	var ServiceManager = (function () {
	    /**
	     * Construct a new services provider.
	     */
	    function ServiceManager(options) {
	        this._kernelManager = null;
	        this._sessionManager = null;
	        this._contentsManager = null;
	        this._terminalManager = null;
	        this._kernelspecs = null;
	        this._isDisposed = false;
	        var subOptions = {
	            baseUrl: options.baseUrl,
	            ajaxSettings: options.ajaxSettings
	        };
	        this._kernelspecs = options.kernelspecs;
	        this._kernelManager = new kernel_1.KernelManager(subOptions);
	        this._sessionManager = new session_1.SessionManager(subOptions);
	        this._contentsManager = new contents_1.ContentsManager(subOptions);
	        this._terminalManager = new terminals_1.TerminalManager(subOptions);
	        this._kernelManager.specsChanged.connect(this._onSpecsChanged, this);
	        this._sessionManager.specsChanged.connect(this._onSpecsChanged, this);
	    }
	    Object.defineProperty(ServiceManager.prototype, "specsChanged", {
	        /**
	         * A signal emitted when the specs change on the service manager.
	         */
	        get: function () {
	            return Private.specsChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ServiceManager.prototype, "isDisposed", {
	        /**
	         * Test whether the terminal manager is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._isDisposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources used by the manager.
	     */
	    ServiceManager.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._isDisposed = true;
	        phosphor_signaling_1.clearSignalData(this);
	    };
	    Object.defineProperty(ServiceManager.prototype, "kernelspecs", {
	        /**
	         * Get kernel specs.
	         */
	        get: function () {
	            return this._kernelspecs;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ServiceManager.prototype, "kernels", {
	        /**
	         * Get kernel manager instance.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._kernelManager;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ServiceManager.prototype, "sessions", {
	        /**
	         * Get the session manager instance.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._sessionManager;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ServiceManager.prototype, "contents", {
	        /**
	         * Get the contents manager instance.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._contentsManager;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ServiceManager.prototype, "terminals", {
	        /**
	         * Get the terminal manager instance.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._terminalManager;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Handle a change in kernel specs.
	     */
	    ServiceManager.prototype._onSpecsChanged = function (sender, args) {
	        this._kernelspecs = args;
	        this.specsChanged.emit(args);
	    };
	    return ServiceManager;
	}());
	exports.ServiceManager = ServiceManager;
	/**
	 * A namespace for private data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A signal emitted when the specs change.
	     */
	    Private.specsChangedSignal = new phosphor_signaling_1.Signal();
	})(Private || (Private = {}));


/***/ },
/* 139 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	'use strict';
	var utils = __webpack_require__(129);
	var phosphor_signaling_1 = __webpack_require__(22);
	var json_1 = __webpack_require__(135);
	var kernel_1 = __webpack_require__(134);
	var validate = __webpack_require__(132);
	/**
	 * The url for the session service.
	 */
	var SESSION_SERVICE_URL = 'api/sessions';
	/**
	 * An implementation of a session manager.
	 */
	var SessionManager = (function () {
	    /**
	     * Construct a new session manager.
	     *
	     * @param options - The default options for each session.
	     */
	    function SessionManager(options) {
	        this._options = null;
	        this._isDisposed = false;
	        this._running = [];
	        this._specs = null;
	        this._options = utils.copy(options || {});
	    }
	    Object.defineProperty(SessionManager.prototype, "specsChanged", {
	        /**
	         * A signal emitted when the kernel specs change.
	         */
	        get: function () {
	            return Private.specsChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SessionManager.prototype, "runningChanged", {
	        /**
	         * A signal emitted when the running sessions change.
	         */
	        get: function () {
	            return Private.runningChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(SessionManager.prototype, "isDisposed", {
	        /**
	         * Test whether the terminal manager is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._isDisposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources used by the manager.
	     */
	    SessionManager.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._isDisposed = true;
	        phosphor_signaling_1.clearSignalData(this);
	        this._running = [];
	    };
	    /**
	     * Get the available kernel specs. See also [[getKernelSpecs]].
	     *
	     * @param options - Overrides for the default options.
	     */
	    SessionManager.prototype.getSpecs = function (options) {
	        var _this = this;
	        return kernel_1.getKernelSpecs(this._getOptions(options)).then(function (specs) {
	            if (!json_1.deepEqual(specs, _this._specs)) {
	                _this._specs = specs;
	                _this.specsChanged.emit(specs);
	            }
	            return specs;
	        });
	    };
	    /**
	     * List the running sessions.  See also [[listRunningSessions]].
	     *
	     * @param options - Overrides for the default options.
	     */
	    SessionManager.prototype.listRunning = function (options) {
	        var _this = this;
	        return listRunningSessions(this._getOptions(options)).then(function (running) {
	            if (!json_1.deepEqual(running, _this._running)) {
	                _this._running = running.slice();
	                _this.runningChanged.emit(running);
	            }
	            return running;
	        });
	    };
	    /**
	     * Start a new session.  See also [[startNewSession]].
	     *
	     * @param options - Overrides for the default options, must include a
	     *   `'path'`.
	     *
	     * #### Notes
	     * This will emit [[runningChanged]] if the running kernels list
	     * changes.
	     */
	    SessionManager.prototype.startNew = function (options) {
	        return startNewSession(this._getOptions(options));
	    };
	    /**
	     * Find a session by id.
	     */
	    SessionManager.prototype.findById = function (id, options) {
	        return findSessionById(id, this._getOptions(options));
	    };
	    /**
	     * Find a session by path.
	     */
	    SessionManager.prototype.findByPath = function (path, options) {
	        return findSessionByPath(path, this._getOptions(options));
	    };
	    /*
	     * Connect to a running session.  See also [[connectToSession]].
	     */
	    SessionManager.prototype.connectTo = function (id, options) {
	        return connectToSession(id, this._getOptions(options));
	    };
	    /**
	     * Shut down a session by id.
	     *
	     * #### Notes
	     * This will emit [[runningChanged]] if the running kernels list
	     * changes.
	     */
	    SessionManager.prototype.shutdown = function (id, options) {
	        return shutdownSession(id, this._getOptions(options));
	    };
	    /**
	     * Get optionally overidden options.
	     */
	    SessionManager.prototype._getOptions = function (options) {
	        if (options) {
	            options = utils.extend(utils.copy(this._options), options);
	        }
	        else {
	            options = this._options;
	        }
	        return options;
	    };
	    return SessionManager;
	}());
	exports.SessionManager = SessionManager;
	/**
	 * List the running sessions.
	 *
	 * #### Notes
	 * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/sessions), and validates the response.
	 *
	 * All client-side sessions are updated with current information.
	 *
	 * The promise is fulfilled on a valid response and rejected otherwise.
	 */
	function listRunningSessions(options) {
	    options = options || {};
	    var baseUrl = options.baseUrl || utils.getBaseUrl();
	    var url = utils.urlPathJoin(baseUrl, SESSION_SERVICE_URL);
	    var ajaxSettings = utils.copy(options.ajaxSettings) || {};
	    ajaxSettings.method = 'GET';
	    ajaxSettings.dataType = 'json';
	    ajaxSettings.cache = false;
	    return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	        if (success.xhr.status !== 200) {
	            throw Error('Invalid Status: ' + success.xhr.status);
	        }
	        if (!Array.isArray(success.data)) {
	            throw Error('Invalid Session list');
	        }
	        for (var i = 0; i < success.data.length; i++) {
	            validate.validateSessionModel(success.data[i]);
	        }
	        return Private.updateRunningSessions(success.data);
	    }, Private.onSessionError);
	}
	exports.listRunningSessions = listRunningSessions;
	/**
	 * Start a new session.
	 *
	 * #### Notes
	 * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/sessions), and validates the response.
	 *
	 * A path must be provided.  If a kernel id is given, it will
	 * connect to an existing kernel.  If no kernel id or name is given,
	 * the server will start the default kernel type.
	 *
	 * The promise is fulfilled on a valid response and rejected otherwise.
	 *
	 * Wrap the result in an Session object. The promise is fulfilled
	 * when the session is created on the server, otherwise the promise is
	 * rejected.
	 */
	function startNewSession(options) {
	    if (options.path === void 0) {
	        return Promise.reject(new Error('Must specify a path'));
	    }
	    return Private.startSession(options).then(function (model) {
	        return Private.createSession(model, options);
	    });
	}
	exports.startNewSession = startNewSession;
	/**
	 * Find a session by id.
	 *
	 * #### Notes
	 * If the session was already started via `startNewSession`, the existing
	 * Session object's information is used in the fulfillment value.
	 *
	 * Otherwise, if `options` are given, we attempt to find to the existing
	 * session.
	 * The promise is fulfilled when the session is found,
	 * otherwise the promise is rejected.
	 */
	function findSessionById(id, options) {
	    var sessions = Private.runningSessions;
	    for (var clientId in sessions) {
	        var session = sessions[clientId];
	        if (session.id === id) {
	            var model = {
	                id: id,
	                notebook: { path: session.path },
	                kernel: { name: session.kernel.name, id: session.kernel.id }
	            };
	            return Promise.resolve(model);
	        }
	    }
	    return Private.getSessionModel(id, options).catch(function () {
	        var msg = "No running session for id: " + id;
	        return Private.typedThrow(msg);
	    });
	}
	exports.findSessionById = findSessionById;
	/**
	 * Find a session by path.
	 *
	 * #### Notes
	 * If the session was already started via `startNewSession`, the existing
	 * Session object's info is used in the fulfillment value.
	 *
	 * Otherwise, if `options` are given, we attempt to find to the existing
	 * session using [listRunningSessions].
	 * The promise is fulfilled when the session is found,
	 * otherwise the promise is rejected.
	 *
	 * If the session was not already started and no `options` are given,
	 * the promise is rejected.
	 */
	function findSessionByPath(path, options) {
	    var sessions = Private.runningSessions;
	    for (var clientId in sessions) {
	        var session = sessions[clientId];
	        if (session.path === path) {
	            var model = {
	                id: session.id,
	                notebook: { path: session.path },
	                kernel: { name: session.kernel.name, id: session.kernel.id }
	            };
	            return Promise.resolve(model);
	        }
	    }
	    return listRunningSessions(options).then(function (models) {
	        for (var _i = 0, models_1 = models; _i < models_1.length; _i++) {
	            var model = models_1[_i];
	            if (model.notebook.path === path) {
	                return model;
	            }
	        }
	        var msg = "No running session for path: " + path;
	        return Private.typedThrow(msg);
	    });
	}
	exports.findSessionByPath = findSessionByPath;
	/**
	 * Connect to a running session.
	 *
	 * #### Notes
	 * If the session was already started via `startNewSession`, the existing
	 * Session object is used as the fulfillment value.
	 *
	 * Otherwise, if `options` are given, we attempt to connect to the existing
	 * session.
	 * The promise is fulfilled when the session is ready on the server,
	 * otherwise the promise is rejected.
	 *
	 * If the session was not already started and no `options` are given,
	 * the promise is rejected.
	 */
	function connectToSession(id, options) {
	    for (var clientId in Private.runningSessions) {
	        var session = Private.runningSessions[clientId];
	        if (session.id === id) {
	            return session.clone();
	        }
	    }
	    return Private.getSessionModel(id, options).then(function (model) {
	        return Private.createSession(model, options);
	    }).catch(function () {
	        var msg = "No running session with id: " + id;
	        return Private.typedThrow(msg);
	    });
	}
	exports.connectToSession = connectToSession;
	/**
	 * Shut down a session by id.
	 */
	function shutdownSession(id, options) {
	    if (options === void 0) { options = {}; }
	    var baseUrl = options.baseUrl || utils.getBaseUrl();
	    var ajaxSettings = options.ajaxSettings || {};
	    return Private.shutdownSession(id, baseUrl, ajaxSettings);
	}
	exports.shutdownSession = shutdownSession;
	/**
	 * Session object for accessing the session REST api. The session
	 * should be used to start kernels and then shut them down -- for
	 * all other operations, the kernel object should be used.
	 */
	var Session = (function () {
	    /**
	     * Construct a new session.
	     */
	    function Session(options, id, kernel) {
	        this._id = '';
	        this._path = '';
	        this._ajaxSettings = '';
	        this._kernel = null;
	        this._uuid = '';
	        this._baseUrl = '';
	        this._options = null;
	        this._updating = false;
	        this.ajaxSettings = options.ajaxSettings || {};
	        this._id = id;
	        this._path = options.path;
	        this._baseUrl = options.baseUrl || utils.getBaseUrl();
	        this._uuid = utils.uuid();
	        Private.runningSessions[this._uuid] = this;
	        this.setupKernel(kernel);
	        this._options = utils.copy(options);
	    }
	    Object.defineProperty(Session.prototype, "sessionDied", {
	        /**
	         * A signal emitted when the session dies.
	         */
	        get: function () {
	            return Private.sessionDiedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Session.prototype, "kernelChanged", {
	        /**
	         * A signal emitted when the kernel changes.
	         */
	        get: function () {
	            return Private.kernelChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Session.prototype, "statusChanged", {
	        /**
	         * A signal emitted when the kernel status changes.
	         */
	        get: function () {
	            return Private.statusChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Session.prototype, "iopubMessage", {
	        /**
	         * A signal emitted for a kernel messages.
	         */
	        get: function () {
	            return Private.iopubMessageSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Session.prototype, "unhandledMessage", {
	        /**
	         * A signal emitted for an unhandled kernel message.
	         */
	        get: function () {
	            return Private.unhandledMessageSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Session.prototype, "pathChanged", {
	        /**
	         * A signal emitted when the session path changes.
	         */
	        get: function () {
	            return Private.pathChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Session.prototype, "id", {
	        /**
	         * Get the session id.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._id;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Session.prototype, "kernel", {
	        /**
	         * Get the session kernel object.
	         *
	         * #### Notes
	         * This is a read-only property, and can be altered by [changeKernel].
	         * Use the [statusChanged] and [unhandledMessage] signals on the session
	         * instead of the ones on the kernel.
	         */
	        get: function () {
	            return this._kernel;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Session.prototype, "path", {
	        /**
	         * Get the session path.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._path;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Session.prototype, "model", {
	        /**
	         * Get the model associated with the session.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return {
	                id: this.id,
	                kernel: this.kernel.model,
	                notebook: {
	                    path: this.path
	                }
	            };
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Session.prototype, "status", {
	        /**
	         * The current status of the session.
	         *
	         * #### Notes
	         * This is a read-only property, and is a delegate to the kernel status.
	         */
	        get: function () {
	            return this._kernel ? this._kernel.status : 'dead';
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Session.prototype, "ajaxSettings", {
	        /**
	         * Get a copy of the default ajax settings for the session.
	         */
	        get: function () {
	            return JSON.parse(this._ajaxSettings);
	        },
	        /**
	         * Set the default ajax settings for the session.
	         */
	        set: function (value) {
	            this._ajaxSettings = JSON.stringify(value);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(Session.prototype, "isDisposed", {
	        /**
	         * Test whether the session has been disposed.
	         *
	         * #### Notes
	         * This is a read-only property which is always safe to access.
	         */
	        get: function () {
	            return this._options === null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Clone the current session with a new clientId.
	     */
	    Session.prototype.clone = function () {
	        var _this = this;
	        var options = this._getKernelOptions();
	        return kernel_1.connectToKernel(this.kernel.id, options).then(function (kernel) {
	            options = utils.copy(_this._options);
	            options.ajaxSettings = _this.ajaxSettings;
	            return new Session(options, _this._id, kernel);
	        });
	    };
	    /**
	     * Update the session based on a session model from the server.
	     */
	    Session.prototype.update = function (model) {
	        var _this = this;
	        // Avoid a race condition if we are waiting for a REST call return.
	        if (this._updating) {
	            return Promise.resolve(void 0);
	        }
	        if (this._path !== model.notebook.path) {
	            this.pathChanged.emit(model.notebook.path);
	        }
	        this._path = model.notebook.path;
	        if (model.kernel.id !== this._kernel.id) {
	            var options = this._getKernelOptions();
	            options.name = model.kernel.name;
	            return kernel_1.connectToKernel(model.kernel.id, options).then(function (kernel) {
	                _this.setupKernel(kernel);
	                _this.kernelChanged.emit(kernel);
	            });
	        }
	        return Promise.resolve(void 0);
	    };
	    /**
	     * Dispose of the resources held by the session.
	     */
	    Session.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        if (this._kernel) {
	            this._kernel.dispose();
	        }
	        this._options = null;
	        delete Private.runningSessions[this._uuid];
	        this._kernel = null;
	        phosphor_signaling_1.clearSignalData(this);
	    };
	    /**
	     * Change the session path.
	     *
	     * @param path - The new session path.
	     *
	     * #### Notes
	     * This uses the Jupyter REST API, and the response is validated.
	     * The promise is fulfilled on a valid response and rejected otherwise.
	     */
	    Session.prototype.rename = function (path) {
	        if (this.isDisposed) {
	            return Promise.reject(new Error('Session is disposed'));
	        }
	        var data = JSON.stringify({
	            notebook: { path: path }
	        });
	        return this._patch(data).then(function () { return void 0; });
	    };
	    /**
	     * Change the kernel.
	     *
	     * @params options - The name or id of the new kernel.
	     *
	     * #### Notes
	     * This shuts down the existing kernel and creates a new kernel,
	     * keeping the existing session ID and session path.
	     */
	    Session.prototype.changeKernel = function (options) {
	        var _this = this;
	        if (this.isDisposed) {
	            return Promise.reject(new Error('Session is disposed'));
	        }
	        this._kernel.dispose();
	        var data = JSON.stringify({ kernel: options });
	        return this._patch(data).then(function () {
	            return _this.kernel;
	        });
	    };
	    /**
	     * Kill the kernel and shutdown the session.
	     *
	     * @returns - The promise fulfilled on a valid response from the server.
	     *
	     * #### Notes
	     * Uses the [Jupyter Notebook API](http://petstore.swagger.io/?url=https://raw.githubusercontent.com/jupyter/notebook/master/notebook/services/api/api.yaml#!/sessions), and validates the response.
	     * Emits a [sessionDied] signal on success.
	     */
	    Session.prototype.shutdown = function () {
	        var _this = this;
	        if (this.isDisposed) {
	            return Promise.reject(new Error('Session is disposed'));
	        }
	        return Private.shutdownSession(this.id, this._baseUrl, this.ajaxSettings)
	            .then(function () {
	            _this._kernel.dispose();
	            _this._kernel = null;
	            _this.sessionDied.emit(void 0);
	        });
	    };
	    /**
	     * Handle connections to a kernel.
	     */
	    Session.prototype.setupKernel = function (kernel) {
	        this._kernel = kernel;
	        kernel.statusChanged.connect(this.onKernelStatus, this);
	        kernel.unhandledMessage.connect(this.onUnhandledMessage, this);
	        kernel.iopubMessage.connect(this.onIOPubMessage, this);
	    };
	    /**
	     * Handle to changes in the Kernel status.
	     */
	    Session.prototype.onKernelStatus = function (sender, state) {
	        this.statusChanged.emit(state);
	    };
	    /**
	     * Handle iopub kernel messages.
	     */
	    Session.prototype.onIOPubMessage = function (sender, msg) {
	        this.iopubMessage.emit(msg);
	    };
	    /**
	     * Handle unhandled kernel messages.
	     */
	    Session.prototype.onUnhandledMessage = function (sender, msg) {
	        this.unhandledMessage.emit(msg);
	    };
	    /**
	     * Get the options used to create a new kernel.
	     */
	    Session.prototype._getKernelOptions = function () {
	        return {
	            baseUrl: this._options.baseUrl,
	            wsUrl: this._options.wsUrl,
	            username: this.kernel.username,
	            ajaxSettings: this.ajaxSettings
	        };
	    };
	    /**
	     * Send a PATCH to the server, updating the session path or the kernel.
	     */
	    Session.prototype._patch = function (data) {
	        var _this = this;
	        var url = Private.getSessionUrl(this._baseUrl, this._id);
	        var ajaxSettings = this.ajaxSettings;
	        ajaxSettings.method = 'PATCH';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.data = data;
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.cache = false;
	        this._updating = true;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	            var data = success.data;
	            validate.validateSessionModel(data);
	            _this._updating = false;
	            return Private.updateByModel(data);
	        }, function (error) {
	            _this._updating = false;
	            return Private.onSessionError(error);
	        });
	    };
	    return Session;
	}());
	/**
	 * A namespace for session private data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A signal emitted when the session is shut down.
	     */
	    Private.sessionDiedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted when the kernel changes.
	     */
	    Private.kernelChangedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted when the session kernel status changes.
	     */
	    Private.statusChangedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted for iopub kernel messages.
	     */
	    Private.iopubMessageSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted for an unhandled kernel message.
	     */
	    Private.unhandledMessageSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted when the session path changes.
	     */
	    Private.pathChangedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted when the specs change.
	     */
	    Private.specsChangedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted when the running kernels change.
	     */
	    Private.runningChangedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * The running sessions.
	     */
	    Private.runningSessions = Object.create(null);
	    /**
	     * Create a new session, or return an existing session if a session if
	     * the session path already exists
	     */
	    function startSession(options) {
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        var url = utils.urlPathJoin(baseUrl, SESSION_SERVICE_URL);
	        var model = {
	            kernel: { name: options.kernelName, id: options.kernelId },
	            notebook: { path: options.path }
	        };
	        var ajaxSettings = utils.copy(options.ajaxSettings) || {};
	        ajaxSettings.method = 'POST';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.data = JSON.stringify(model);
	        ajaxSettings.contentType = 'application/json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 201) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	            validate.validateSessionModel(success.data);
	            var data = success.data;
	            return updateByModel(data);
	        }, onSessionError);
	    }
	    Private.startSession = startSession;
	    /**
	     * Create a Promise for a kernel object given a session model and options.
	     */
	    function createKernel(model, options) {
	        var kernelOptions = {
	            name: model.kernel.name,
	            baseUrl: options.baseUrl || utils.getBaseUrl(),
	            wsUrl: options.wsUrl,
	            username: options.username,
	            clientId: options.clientId,
	            ajaxSettings: options.ajaxSettings
	        };
	        return kernel_1.connectToKernel(model.kernel.id, kernelOptions);
	    }
	    Private.createKernel = createKernel;
	    /**
	     * Create a Session object.
	     *
	     * @returns - A promise that resolves with a started session.
	     */
	    function createSession(model, options) {
	        return createKernel(model, options).then(function (kernel) {
	            return new Session(options, model.id, kernel);
	        }).catch(function (error) {
	            return typedThrow('Session failed to start: ' + error.message);
	        });
	    }
	    Private.createSession = createSession;
	    /**
	     * Get a full session model from the server by session id string.
	     */
	    function getSessionModel(id, options) {
	        options = options || {};
	        var baseUrl = options.baseUrl || utils.getBaseUrl();
	        var url = getSessionUrl(baseUrl, id);
	        var ajaxSettings = options.ajaxSettings || {};
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	            var data = success.data;
	            validate.validateSessionModel(data);
	            return updateByModel(data);
	        }, Private.onSessionError);
	    }
	    Private.getSessionModel = getSessionModel;
	    /**
	     * Update the running sessions based on new data from the server.
	     */
	    function updateRunningSessions(sessions) {
	        var promises = [];
	        for (var uuid in Private.runningSessions) {
	            var session = Private.runningSessions[uuid];
	            var updated = false;
	            for (var _i = 0, sessions_1 = sessions; _i < sessions_1.length; _i++) {
	                var sId = sessions_1[_i];
	                if (session.id === sId.id) {
	                    promises.push(session.update(sId));
	                    updated = true;
	                    break;
	                }
	            }
	            // If session is no longer running on disk, emit dead signal.
	            if (!updated && session.status !== 'dead') {
	                session.sessionDied.emit(void 0);
	            }
	        }
	        return Promise.all(promises).then(function () { return sessions; });
	    }
	    Private.updateRunningSessions = updateRunningSessions;
	    /**
	     * Update the running sessions given an updated session Id.
	     */
	    function updateByModel(model) {
	        var promises = [];
	        for (var uuid in Private.runningSessions) {
	            var session = Private.runningSessions[uuid];
	            if (session.id === model.id) {
	                promises.push(session.update(model));
	            }
	        }
	        return Promise.all(promises).then(function () { return model; });
	    }
	    Private.updateByModel = updateByModel;
	    /**
	     * Shut down a session by id.
	     */
	    function shutdownSession(id, baseUrl, ajaxSettings) {
	        if (ajaxSettings === void 0) { ajaxSettings = {}; }
	        var url = getSessionUrl(baseUrl, id);
	        ajaxSettings.method = 'DELETE';
	        ajaxSettings.dataType = 'json';
	        ajaxSettings.cache = false;
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                throw Error('Invalid Status: ' + success.xhr.status);
	            }
	        }, function (rejected) {
	            if (rejected.xhr.status === 410) {
	                throw Error('The kernel was deleted but the session was not');
	            }
	            onSessionError(rejected);
	        });
	    }
	    Private.shutdownSession = shutdownSession;
	    /**
	     * Get a session url.
	     */
	    function getSessionUrl(baseUrl, id) {
	        return utils.urlPathJoin(baseUrl, SESSION_SERVICE_URL, id);
	    }
	    Private.getSessionUrl = getSessionUrl;
	    /**
	     * Handle an error on a session Ajax call.
	     */
	    function onSessionError(error) {
	        var text = (error.statusText ||
	            error.error.message ||
	            error.xhr.responseText);
	        var msg = "API request failed (" + error.xhr.status + "):  " + text;
	        throw Error(msg);
	    }
	    Private.onSessionError = onSessionError;
	    /**
	     * Throw a typed error.
	     */
	    function typedThrow(msg) {
	        throw new Error(msg);
	    }
	    Private.typedThrow = typedThrow;
	})(Private || (Private = {}));


/***/ },
/* 140 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var utils = __webpack_require__(129);
	var phosphor_signaling_1 = __webpack_require__(22);
	var json_1 = __webpack_require__(135);
	/**
	 * The url for the terminal service.
	 */
	var TERMINAL_SERVICE_URL = 'api/terminals';
	/**
	 * Create a terminal session or connect to an existing session.
	 *
	 * #### Notes
	 * If the session is already running on the client, the existing
	 * instance will be returned.
	 */
	function createTerminalSession(options) {
	    if (options === void 0) { options = {}; }
	    if (options.name && options.name in Private.running) {
	        return Private.running[options.name];
	    }
	    return new TerminalSession(options).connect();
	}
	exports.createTerminalSession = createTerminalSession;
	/**
	 * A terminal session manager.
	 */
	var TerminalManager = (function () {
	    /**
	     * Construct a new terminal manager.
	     */
	    function TerminalManager(options) {
	        if (options === void 0) { options = {}; }
	        this._baseUrl = '';
	        this._wsUrl = '';
	        this._ajaxSettings = null;
	        this._running = [];
	        this._isDisposed = false;
	        this._baseUrl = options.baseUrl || utils.getBaseUrl();
	        this._wsUrl = options.wsUrl || utils.getWsUrl(this._baseUrl);
	        this._ajaxSettings = utils.copy(options.ajaxSettings) || {};
	    }
	    Object.defineProperty(TerminalManager.prototype, "runningChanged", {
	        /**
	         * A signal emitted when the running terminals change.
	         */
	        get: function () {
	            return Private.runningChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TerminalManager.prototype, "isDisposed", {
	        /**
	         * Test whether the terminal manager is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._isDisposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources used by the manager.
	     */
	    TerminalManager.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._isDisposed = true;
	        phosphor_signaling_1.clearSignalData(this);
	        this._running = [];
	    };
	    /**
	     * Create a new terminal session or connect to an existing session.
	     */
	    TerminalManager.prototype.create = function (options) {
	        if (options === void 0) { options = {}; }
	        options.baseUrl = options.baseUrl || this._baseUrl;
	        options.wsUrl = options.wsUrl || this._wsUrl;
	        options.ajaxSettings = (options.ajaxSettings || utils.copy(this._ajaxSettings));
	        return createTerminalSession(options);
	    };
	    /**
	     * Shut down a terminal session by name.
	     */
	    TerminalManager.prototype.shutdown = function (name) {
	        var url = utils.urlPathJoin(this._baseUrl, TERMINAL_SERVICE_URL, name);
	        var ajaxSettings = utils.copy(this._ajaxSettings) || {};
	        ajaxSettings.method = 'DELETE';
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                throw new Error('Invalid Response: ' + success.xhr.status);
	            }
	        });
	    };
	    /**
	     * Get the list of models for the terminals running on the server.
	     */
	    TerminalManager.prototype.listRunning = function () {
	        var _this = this;
	        var url = utils.urlPathJoin(this._baseUrl, TERMINAL_SERVICE_URL);
	        var ajaxSettings = utils.copy(this._ajaxSettings) || {};
	        ajaxSettings.method = 'GET';
	        ajaxSettings.dataType = 'json';
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                throw new Error('Invalid Response: ' + success.xhr.status);
	            }
	            var data = success.data;
	            if (!Array.isArray(data)) {
	                throw new Error('Invalid terminal data');
	            }
	            if (!json_1.deepEqual(data, _this._running)) {
	                _this._running = data.slice();
	                _this.runningChanged.emit(data);
	            }
	            return data;
	        });
	    };
	    return TerminalManager;
	}());
	exports.TerminalManager = TerminalManager;
	/**
	 * An implementation of a terminal interface.
	 */
	var TerminalSession = (function () {
	    /**
	     * Construct a new terminal session.
	     */
	    function TerminalSession(options) {
	        if (options === void 0) { options = {}; }
	        this._ajaxSettings = null;
	        this._ws = null;
	        this._isDisposed = false;
	        this._promise = null;
	        this._baseUrl = options.baseUrl || utils.getBaseUrl();
	        this._ajaxSettings = options.ajaxSettings || {};
	        this._name = options.name;
	        this._wsUrl = options.wsUrl || utils.getWsUrl(this._baseUrl);
	        this._promise = new utils.PromiseDelegate();
	    }
	    Object.defineProperty(TerminalSession.prototype, "messageReceived", {
	        /**
	         * A signal emitted when a message is received from the server.
	         */
	        get: function () {
	            return Private.messageReceivedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TerminalSession.prototype, "name", {
	        /**
	         * Get the name of the terminal session.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._name;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TerminalSession.prototype, "url", {
	        /**
	         * Get the websocket url used by the terminal session.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._url;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(TerminalSession.prototype, "isDisposed", {
	        /**
	         * Test whether the session is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._isDisposed;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources held by the session.
	     */
	    TerminalSession.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._isDisposed = true;
	        if (this._ws) {
	            this._ws.close();
	            this._ws = null;
	        }
	        delete Private.running[this._name];
	        this._promise = null;
	        phosphor_signaling_1.clearSignalData(this);
	    };
	    /**
	     * Send a message to the terminal session.
	     */
	    TerminalSession.prototype.send = function (message) {
	        var msg = [message.type];
	        msg.push.apply(msg, message.content);
	        this._ws.send(JSON.stringify(msg));
	    };
	    /**
	     * Shut down the terminal session.
	     */
	    TerminalSession.prototype.shutdown = function () {
	        var _this = this;
	        var url = utils.urlPathJoin(this._baseUrl, TERMINAL_SERVICE_URL, this._name);
	        var ajaxSettings = utils.copy(this._ajaxSettings);
	        ajaxSettings.method = 'DELETE';
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 204) {
	                throw new Error('Invalid Response: ' + success.xhr.status);
	            }
	            _this.dispose();
	        });
	    };
	    /**
	     * Connect to the terminal session.
	     */
	    TerminalSession.prototype.connect = function () {
	        var _this = this;
	        if (this._name) {
	            return this._initializeSocket();
	        }
	        return this._getName().then(function (name) {
	            _this._name = name;
	            return _this._initializeSocket();
	        });
	    };
	    /**
	     * Get a name for the terminal from the server.
	     */
	    TerminalSession.prototype._getName = function () {
	        var url = utils.urlPathJoin(this._baseUrl, TERMINAL_SERVICE_URL);
	        var ajaxSettings = utils.copy(this._ajaxSettings);
	        ajaxSettings.method = 'POST';
	        ajaxSettings.dataType = 'json';
	        return utils.ajaxRequest(url, ajaxSettings).then(function (success) {
	            if (success.xhr.status !== 200) {
	                throw new Error('Invalid Response: ' + success.xhr.status);
	            }
	            return success.data.name;
	        });
	    };
	    /**
	     * Connect to the websocket.
	     */
	    TerminalSession.prototype._initializeSocket = function () {
	        var _this = this;
	        var name = this._name;
	        Private.running[name] = this._promise.promise;
	        this._url = this._wsUrl + "terminals/websocket/" + name;
	        this._ws = new WebSocket(this._url);
	        this._ws.onmessage = function (event) {
	            var data = JSON.parse(event.data);
	            _this.messageReceived.emit({
	                type: data[0],
	                content: data.slice(1)
	            });
	        };
	        this._ws.onopen = function (event) {
	            _this._promise.resolve(_this);
	        };
	        return this._promise.promise;
	    };
	    return TerminalSession;
	}());
	/**
	 * A namespace for private data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A mapping of running terminals by name.
	     */
	    Private.running = Object.create(null);
	    /**
	     * A signal emitted when the terminal is fully connected.
	     */
	    Private.connectedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted when the running terminals change.
	     */
	    Private.runningChangedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted when a message is received.
	     */
	    Private.messageReceivedSignal = new phosphor_signaling_1.Signal();
	})(Private || (Private = {}));


/***/ },
/* 141 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var dialog_1 = __webpack_require__(142);
	var phosphor_signaling_1 = __webpack_require__(22);
	var phosphor_widget_1 = __webpack_require__(20);
	var phosphor_panel_1 = __webpack_require__(18);
	var cells_1 = __webpack_require__(143);
	var mimetype_1 = __webpack_require__(346);
	var tooltip_1 = __webpack_require__(347);
	var history_1 = __webpack_require__(348);
	var completion_1 = __webpack_require__(349);
	/**
	 * The class name added to console widgets.
	 */
	var CONSOLE_CLASS = 'jp-Console';
	/**
	 * The class name added to console panels.
	 */
	var CONSOLE_PANEL = 'jp-Console-panel';
	/**
	 * The class name added to the console banner.
	 */
	var BANNER_CLASS = 'jp-Console-banner';
	/**
	 * The class name of the active prompt
	 */
	var PROMPT_CLASS = 'jp-Console-prompt';
	/**
	 * A panel which contains a toolbar and a console.
	 */
	var ConsolePanel = (function (_super) {
	    __extends(ConsolePanel, _super);
	    /**
	     * Construct a console panel.
	     */
	    function ConsolePanel(options) {
	        _super.call(this);
	        this._console = null;
	        this.addClass(CONSOLE_PANEL);
	        this._console = new ConsoleWidget({
	            session: options.session,
	            rendermime: options.rendermime
	        });
	        this.addChild(this._console);
	    }
	    Object.defineProperty(ConsolePanel.prototype, "content", {
	        /**
	         * The console widget used by the panel.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._console;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources held by the widget.
	     */
	    ConsolePanel.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._console.dispose();
	        this._console = null;
	        _super.prototype.dispose.call(this);
	    };
	    /**
	     * Handle the DOM events for the widget.
	     *
	     * @param event - The DOM event sent to the widget.
	     *
	     * #### Notes
	     * This method implements the DOM `EventListener` interface and is
	     * called in response to events on the dock panel's node. It should
	     * not be called directly by user code.
	     */
	    ConsolePanel.prototype.handleEvent = function (event) {
	        switch (event.type) {
	            case 'click':
	                var prompt_1 = this.content.prompt;
	                if (prompt_1) {
	                    prompt_1.focus();
	                }
	                break;
	            default:
	                break;
	        }
	    };
	    /**
	     * Handle `after_attach` messages for the widget.
	     */
	    ConsolePanel.prototype.onAfterAttach = function (msg) {
	        this.content.node.addEventListener('click', this);
	    };
	    /**
	     * Handle `before_detach` messages for the widget.
	     */
	    ConsolePanel.prototype.onBeforeDetach = function (msg) {
	        this.content.node.removeEventListener('click', this);
	    };
	    /**
	     * Handle `'close-request'` messages.
	     */
	    ConsolePanel.prototype.onCloseRequest = function (msg) {
	        var _this = this;
	        var session = this.content.session;
	        if (!session.kernel) {
	            this.dispose();
	        }
	        session.kernel.getKernelSpec().then(function (spec) {
	            var name = spec.display_name;
	            return dialog_1.showDialog({
	                title: 'Shut down kernel?',
	                body: "Shut down " + name + "?"
	            });
	        }).then(function (value) {
	            if (value && value.text === 'OK') {
	                return session.shutdown();
	            }
	        }).then(function () {
	            _super.prototype.onCloseRequest.call(_this, msg);
	            _this.dispose();
	        });
	    };
	    return ConsolePanel;
	}(phosphor_panel_1.Panel));
	exports.ConsolePanel = ConsolePanel;
	/**
	 * A widget containing a Jupyter console.
	 */
	var ConsoleWidget = (function (_super) {
	    __extends(ConsoleWidget, _super);
	    /**
	     * Construct a console widget.
	     */
	    function ConsoleWidget(options) {
	        var _this = this;
	        _super.call(this);
	        this._completion = null;
	        this._completionHandler = null;
	        this._mimetype = 'text/x-ipython';
	        this._rendermime = null;
	        this._renderer = null;
	        this._tooltip = null;
	        this._history = null;
	        this._session = null;
	        this._pendingInspect = 0;
	        this.addClass(CONSOLE_CLASS);
	        var layout = new phosphor_panel_1.PanelLayout();
	        this.layout = layout;
	        this._renderer = options.renderer || ConsoleWidget.defaultRenderer;
	        this._rendermime = options.rendermime;
	        this._session = options.session;
	        this._history = new history_1.ConsoleHistory(this._session.kernel);
	        // Instantiate tab completion widget.
	        this._completion = options.completion || new completion_1.CompletionWidget({
	            model: new completion_1.CompletionModel()
	        });
	        this._completion.anchor = this.node;
	        // Because a completion widget may be passed in, check if it is attached.
	        if (!this._completion.isAttached) {
	            this._completion.attach(document.body);
	        }
	        this._completionHandler = new completion_1.CellCompletionHandler(this._completion);
	        this._completionHandler.kernel = this._session.kernel;
	        // Instantiate tooltip widget.
	        this._tooltip = options.tooltip || new tooltip_1.ConsoleTooltip();
	        this._tooltip.reference = this;
	        // Because a tooltip widget may be passed in, check if it is attached.
	        if (!this._tooltip.isAttached) {
	            this._tooltip.attach(document.body);
	        }
	        // Create the banner.
	        var banner = this._renderer.createBanner();
	        banner.addClass(BANNER_CLASS);
	        banner.readOnly = true;
	        banner.model.source = '...';
	        layout.addChild(banner);
	        // Set the banner text and the mimetype.
	        this.initialize();
	        // Create the prompt.
	        this.newPrompt();
	        // Handle changes to the kernel.
	        this._session.kernelChanged.connect(function (s, kernel) {
	            _this.clear();
	            _this.newPrompt();
	            _this.initialize();
	            _this._history.dispose();
	            _this._history = new history_1.ConsoleHistory(kernel);
	            _this._completionHandler.kernel = kernel;
	        });
	    }
	    Object.defineProperty(ConsoleWidget.prototype, "prompt", {
	        /*
	         * The last cell in a console is always a `CodeCellWidget` prompt.
	         */
	        get: function () {
	            var layout = this.layout;
	            var last = layout.childCount() - 1;
	            return last > 0 ? layout.childAt(last) : null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ConsoleWidget.prototype, "session", {
	        /**
	         * Get the session used by the console.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._session;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources held by the widget.
	     */
	    ConsoleWidget.prototype.dispose = function () {
	        // Do nothing if already disposed.
	        if (this.isDisposed) {
	            return;
	        }
	        this._tooltip.dispose();
	        this._tooltip = null;
	        this._history.dispose();
	        this._history = null;
	        this._completionHandler.dispose();
	        this._completionHandler = null;
	        this._completion.dispose();
	        this._completion = null;
	        this._session.dispose();
	        this._session = null;
	        _super.prototype.dispose.call(this);
	    };
	    /**
	     * Execute the current prompt.
	     */
	    ConsoleWidget.prototype.execute = function () {
	        var _this = this;
	        // Dismiss any outstanding tooltips or completion widgets.
	        this.dismissOverlays();
	        if (this._session.status === 'dead') {
	            return;
	        }
	        var prompt = this.prompt;
	        prompt.trusted = true;
	        this._history.push(prompt.model.source);
	        return prompt.execute(this._session.kernel).then(function () { return _this.newPrompt(); }, function () { return _this.newPrompt(); });
	    };
	    /**
	     * Clear the code cells.
	     */
	    ConsoleWidget.prototype.clear = function () {
	        while (this.prompt) {
	            this.prompt.dispose();
	        }
	        this.newPrompt();
	    };
	    /**
	     * Dismiss the tooltip and completion widget for a console.
	     */
	    ConsoleWidget.prototype.dismissOverlays = function () {
	        this._tooltip.hide();
	        this._completion.reset();
	    };
	    /**
	     * Serialize the output.
	     */
	    ConsoleWidget.prototype.serialize = function () {
	        var output = [];
	        var layout = this.layout;
	        for (var i = 1; i < layout.childCount(); i++) {
	            var widget = layout.childAt(i);
	            output.push(widget.model.toJSON());
	        }
	        return output;
	    };
	    /**
	     * Handle `after_attach` messages for the widget.
	     */
	    ConsoleWidget.prototype.onAfterAttach = function (msg) {
	        var prompt = this.prompt;
	        if (prompt) {
	            prompt.focus();
	        }
	    };
	    /**
	     * Handle `update_request` messages.
	     */
	    ConsoleWidget.prototype.onUpdateRequest = function (msg) {
	        var prompt = this.prompt;
	        Private.scrollIfNeeded(this.parent.node, prompt.node);
	    };
	    /**
	     * Make a new prompt.
	     */
	    ConsoleWidget.prototype.newPrompt = function () {
	        // Make the previous editor read-only and clear its signals.
	        var prompt = this.prompt;
	        if (prompt) {
	            prompt.readOnly = true;
	            prompt.removeClass(PROMPT_CLASS);
	            phosphor_signaling_1.clearSignalData(prompt.editor);
	        }
	        // Create the new prompt and add to layout.
	        var layout = this.layout;
	        prompt = this._renderer.createPrompt(this._rendermime);
	        prompt.mimetype = this._mimetype;
	        prompt.addClass(PROMPT_CLASS);
	        layout.addChild(prompt);
	        // Hook up completion, tooltip, and history handling.
	        var editor = prompt.editor;
	        editor.textChanged.connect(this.onTextChange, this);
	        editor.edgeRequested.connect(this.onEdgeRequest, this);
	        // Associate the new prompt with the completion handler.
	        this._completionHandler.activeCell = prompt;
	        // Jump to the bottom of the node.
	        this.node.scrollTop = this.node.scrollHeight;
	        prompt.focus();
	    };
	    /**
	     * Initialize the banner and mimetype.
	     */
	    ConsoleWidget.prototype.initialize = function () {
	        var _this = this;
	        var layout = this.layout;
	        var banner = layout.childAt(0);
	        this._session.kernel.kernelInfo().then(function (msg) {
	            var info = msg.content;
	            banner.model.source = info.banner;
	            _this._mimetype = mimetype_1.mimetypeForLanguage(info.language_info);
	            _this.prompt.mimetype = _this._mimetype;
	        });
	    };
	    /**
	     * Handle a text changed signal from an editor.
	     */
	    ConsoleWidget.prototype.onTextChange = function (editor, change) {
	        this._tooltip.hide();
	        if (change.newValue) {
	            this.updateTooltip(change);
	        }
	    };
	    /**
	     * Update the tooltip based on a text change.
	     */
	    ConsoleWidget.prototype.updateTooltip = function (change) {
	        var _this = this;
	        var contents = {
	            code: change.newValue,
	            cursor_pos: change.position,
	            detail_level: 0
	        };
	        var pendingInspect = ++this._pendingInspect;
	        this._session.kernel.inspect(contents).then(function (msg) {
	            var value = msg.content;
	            // If widget has been disposed, bail.
	            if (_this.isDisposed) {
	                return;
	            }
	            // If a newer text change has created a pending request, bail.
	            if (pendingInspect !== _this._pendingInspect) {
	                return;
	            }
	            // Tooltip request failures or negative results fail silently.
	            if (value.status !== 'ok' || !value.found) {
	                return;
	            }
	            _this.showTooltip(change, value.data);
	        });
	    };
	    /**
	     * Show the tooltip.
	     */
	    ConsoleWidget.prototype.showTooltip = function (change, bundle) {
	        // Add content and measure.
	        this._tooltip.content = this._rendermime.render(bundle);
	        this._tooltip.show();
	        var tooltip = this._tooltip.node;
	        var _a = tooltip.getBoundingClientRect(), width = _a.width, height = _a.height;
	        var maxWidth;
	        var maxHeight;
	        var _b = change.coords, top = _b.top, bottom = _b.bottom, left = _b.left;
	        var border = parseInt(window.getComputedStyle(tooltip).borderWidth, 10);
	        var heightAbove = top + border;
	        var heightBelow = window.innerHeight - bottom - border;
	        var widthLeft = left;
	        var widthRight = window.innerWidth - left;
	        // Prefer displaying below.
	        if (heightBelow >= height || heightBelow >= heightAbove) {
	            // Offset the height of the tooltip by the height of cursor characters.
	            top += change.chHeight;
	            maxHeight = heightBelow;
	        }
	        else {
	            maxHeight = heightAbove;
	            top -= Math.min(height, maxHeight);
	        }
	        // Prefer displaying on the right.
	        if (widthRight >= width || widthRight >= widthLeft) {
	            left += border;
	            maxWidth = widthRight;
	        }
	        else {
	            maxWidth = widthLeft;
	            left -= Math.min(width, maxWidth);
	        }
	        tooltip.style.top = Math.floor(top) + "px";
	        tooltip.style.left = Math.floor(left) + "px";
	        tooltip.style.maxHeight = Math.floor(maxHeight) + "px";
	        tooltip.style.maxWidth = Math.floor(maxWidth) + "px";
	    };
	    /**
	     * Handle an edge requested signal.
	     */
	    ConsoleWidget.prototype.onEdgeRequest = function (editor, location) {
	        var prompt = this.prompt;
	        if (location === 'top') {
	            this._history.back().then(function (value) {
	                if (!value) {
	                    return;
	                }
	                prompt.model.source = value;
	                prompt.editor.setCursorPosition(0);
	            });
	        }
	        else {
	            this._history.forward().then(function (value) {
	                // If at the bottom end of history, then clear the prompt.
	                var text = value || '';
	                prompt.model.source = text;
	                prompt.editor.setCursorPosition(text.length);
	            });
	        }
	    };
	    return ConsoleWidget;
	}(phosphor_widget_1.Widget));
	exports.ConsoleWidget = ConsoleWidget;
	/**
	 * A namespace for ConsoleWidget statics.
	 */
	var ConsoleWidget;
	(function (ConsoleWidget) {
	    /**
	     * The default implementation of an `IRenderer`.
	     */
	    var Renderer = (function () {
	        function Renderer() {
	        }
	        /**
	         * Create a new banner widget.
	         */
	        Renderer.prototype.createBanner = function () {
	            var widget = new cells_1.RawCellWidget();
	            widget.model = new cells_1.RawCellModel();
	            return widget;
	        };
	        /**
	         * Create a new prompt widget.
	         */
	        Renderer.prototype.createPrompt = function (rendermime) {
	            var widget = new cells_1.CodeCellWidget({ rendermime: rendermime });
	            widget.model = new cells_1.CodeCellModel();
	            return widget;
	        };
	        return Renderer;
	    }());
	    ConsoleWidget.Renderer = Renderer;
	    /**
	     * The default `IRenderer` instance.
	     */
	    ConsoleWidget.defaultRenderer = new Renderer();
	})(ConsoleWidget = exports.ConsoleWidget || (exports.ConsoleWidget = {}));
	/**
	 * A namespace for console widget private data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Scroll an element into view if needed.
	     *
	     * @param area - The scroll area element.
	     *
	     * @param elem - The element of interest.
	     */
	    function scrollIfNeeded(area, elem) {
	        var ar = area.getBoundingClientRect();
	        var er = elem.getBoundingClientRect();
	        if (er.top < ar.top - 10) {
	            area.scrollTop -= ar.top - er.top + 10;
	        }
	        else if (er.bottom > ar.bottom + 10) {
	            area.scrollTop += er.bottom - ar.bottom + 10;
	        }
	    }
	    Private.scrollIfNeeded = scrollIfNeeded;
	})(Private || (Private = {}));


/***/ },
/* 142 */
/***/ function(module, exports) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	/**
	 * The class name added to dialog instances.
	 */
	var DIALOG_CLASS = 'jp-Dialog';
	/**
	 * The class name added to dialog content node.
	 */
	var CONTENT_CLASS = 'jp-Dialog-content';
	/**
	 * The class name added to dialog header node.
	 */
	var HEADER_CLASS = 'jp-Dialog-header';
	/**
	 * The class name added to dialog title node.
	 */
	var TITLE_CLASS = 'jp-Dialog-title';
	/**
	 * The class name added to dialog body node.
	 */
	var BODY_CLASS = 'jp-Dialog-body';
	/**
	 * The class name added to a dialog body content node.
	 */
	var BODY_CONTENT_CLASS = 'jp-Dialog-bodyContent';
	/**
	 * The class name added to a dialog content node.
	 */
	var FOOTER_CLASS = 'jp-Dialog-footer';
	/**
	 * The class name added to a dialog button node.
	 */
	var BUTTON_CLASS = 'jp-Dialog-button';
	/**
	 * The class name added to a dialog button icon node.
	 */
	var BUTTON_ICON_CLASS = 'jp-Dialog-buttonIcon';
	/**
	 * The class name added to a dialog button text node.
	 */
	var BUTTON_TEXT_CLASS = 'jp-Dialog-buttonText';
	/*
	 * The class name added to dialog Confirm buttons.
	 */
	var OK_BUTTON_CLASS = 'jp-Dialog-okButton';
	/**
	 * The class name added to dialog Cancel buttons.
	 */
	var CANCEL_BUTTON_CLASS = 'jp-Dialog-cancelButton';
	/**
	 * The class name added to dialog input field wrappers.
	 */
	var INPUT_WRAPPER_CLASS = 'jp-Dialog-inputWrapper';
	/**
	 * The class name added to dialog input fields.
	 */
	var INPUT_CLASS = 'jp-Dialog-input';
	/**
	 * The class name added to dialog select wrappers.
	 */
	var SELECT_WRAPPER_CLASS = 'jp-Dialog-selectWrapper';
	/**
	 * The class name added to dialog select nodes.
	 */
	var SELECT_CLASS = 'jp-Dialog-select';
	/**
	 * A default confirmation button.
	 */
	exports.okButton = {
	    text: 'OK',
	    className: OK_BUTTON_CLASS
	};
	/**
	 * A default cancel button.
	 */
	exports.cancelButton = {
	    text: 'CANCEL',
	    className: CANCEL_BUTTON_CLASS
	};
	/**
	 * Create a dialog and show it.
	 *
	 * @param options - The dialog setup options.
	 *
	 * @returns The button item that was selected.
	 */
	function showDialog(options) {
	    options = options || {};
	    var host = options.host || document.body;
	    options.host = host;
	    options.body = options.body || '';
	    exports.okButton.text = options.okText ? options.okText : 'OK';
	    var buttons = options.buttons || [exports.cancelButton, exports.okButton];
	    var buttonNodes = buttons.map(createButton);
	    var dialog = createDialog(options, buttonNodes);
	    host.appendChild(dialog);
	    // Focus the ok button if given.
	    var index = buttons.indexOf(exports.okButton);
	    if (index !== -1) {
	        buttonNodes[index].focus();
	    }
	    return new Promise(function (resolve, reject) {
	        buttonNodes.map(function (node) {
	            node.addEventListener('click', function (evt) {
	                if (node.contains(evt.target)) {
	                    host.removeChild(dialog);
	                    var button = buttons[buttonNodes.indexOf(node)];
	                    resolve(button);
	                }
	            });
	        });
	        dialog.addEventListener('keydown', function (evt) {
	            // Check for escape key
	            if (evt.keyCode === 27) {
	                host.removeChild(dialog);
	                resolve(exports.cancelButton);
	            }
	        }, true);
	        dialog.addEventListener('contextmenu', function (evt) {
	            evt.preventDefault();
	            evt.stopPropagation();
	        }, true);
	    });
	}
	exports.showDialog = showDialog;
	/**
	 * Create the dialog node.
	 */
	function createDialog(options, buttonNodes) {
	    // Create the dialog nodes (except for the buttons).
	    var node = document.createElement('div');
	    var content = document.createElement('div');
	    var header = document.createElement('div');
	    var body = document.createElement('div');
	    var footer = document.createElement('div');
	    var title = document.createElement('span');
	    node.className = DIALOG_CLASS;
	    content.className = CONTENT_CLASS;
	    header.className = HEADER_CLASS;
	    body.className = BODY_CLASS;
	    footer.className = FOOTER_CLASS;
	    title.className = TITLE_CLASS;
	    node.appendChild(content);
	    content.appendChild(header);
	    content.appendChild(body);
	    content.appendChild(footer);
	    header.appendChild(title);
	    // Populate the nodes.
	    title.textContent = options.title || '';
	    var child;
	    if (typeof options.body === 'string') {
	        child = document.createElement('span');
	        child.innerHTML = options.body;
	    }
	    else if (options.body) {
	        child = options.body;
	        switch (child.tagName) {
	            case 'INPUT':
	                child = wrapInput(child);
	                break;
	            case 'SELECT':
	                child = wrapSelect(child);
	                break;
	            default:
	                child = styleElements(child);
	                break;
	        }
	    }
	    child.classList.add(BODY_CONTENT_CLASS);
	    body.appendChild(child);
	    buttonNodes.map(function (buttonNode) { footer.appendChild(buttonNode); });
	    return node;
	}
	/**
	 * Style the child elements of a parent element.
	 */
	function styleElements(element) {
	    for (var i = 0; i < element.children.length; i++) {
	        var child = element.children[i];
	        var next = child.nextSibling;
	        switch (child.tagName) {
	            case 'INPUT':
	                child = wrapInput(child);
	                element.insertBefore(child, next);
	                break;
	            case 'SELECT':
	                child = wrapSelect(child);
	                element.insertBefore(child, next);
	                break;
	        }
	    }
	    return element;
	}
	/**
	 * Create a node for a button item.
	 */
	function createButton(item) {
	    var button = document.createElement('button');
	    button.className = BUTTON_CLASS;
	    button.tabIndex = -1;
	    if (item.className) {
	        button.classList.add(item.className);
	    }
	    var icon = document.createElement('span');
	    icon.className = BUTTON_ICON_CLASS;
	    if (item.icon) {
	        icon.classList.add(item.icon);
	    }
	    var text = document.createElement('span');
	    text.className = BUTTON_TEXT_CLASS;
	    text.textContent = item.text;
	    button.appendChild(icon);
	    button.appendChild(text);
	    return button;
	}
	/**
	 * Wrap and style an input node.
	 */
	function wrapInput(input) {
	    var wrapper = document.createElement('div');
	    wrapper.className = INPUT_WRAPPER_CLASS;
	    wrapper.appendChild(input);
	    input.classList.add(INPUT_CLASS);
	    return wrapper;
	}
	/**
	 * Wrap and style a select node.
	 */
	function wrapSelect(select) {
	    var wrapper = document.createElement('div');
	    wrapper.className = SELECT_WRAPPER_CLASS;
	    wrapper.appendChild(select);
	    select.classList.add(SELECT_CLASS);
	    return wrapper;
	}


/***/ },
/* 143 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(144));
	__export(__webpack_require__(207));


/***/ },
/* 144 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var utils = __webpack_require__(129);
	var phosphor_signaling_1 = __webpack_require__(22);
	var json_1 = __webpack_require__(145);
	var metadata_1 = __webpack_require__(146);
	var output_area_1 = __webpack_require__(147);
	/**
	 * An implementation of the cell model.
	 */
	var CellModel = (function () {
	    /**
	     * Construct a cell model from optional cell content.
	     */
	    function CellModel(cell) {
	        this._metadata = Object.create(null);
	        this._cursors = Object.create(null);
	        this._source = '';
	        if (!cell) {
	            return;
	        }
	        if (Array.isArray(cell.source)) {
	            this.source = cell.source.join('\n');
	        }
	        else {
	            this.source = cell.source;
	        }
	        var metadata = utils.copy(cell.metadata);
	        if (this.type !== 'raw') {
	            delete metadata['format'];
	        }
	        if (this.type !== 'code') {
	            delete metadata['collapsed'];
	            delete metadata['scrolled'];
	        }
	        this._metadata = metadata;
	    }
	    Object.defineProperty(CellModel.prototype, "contentChanged", {
	        /**
	         * A signal emitted when the state of the model changes.
	         */
	        get: function () {
	            return Private.contentChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CellModel.prototype, "stateChanged", {
	        /**
	         * A signal emitted when a model state changes.
	         */
	        get: function () {
	            return Private.stateChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CellModel.prototype, "metadataChanged", {
	        /**
	         * A signal emitted when a metadata field changes.
	         */
	        get: function () {
	            return Private.metadataChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CellModel.prototype, "source", {
	        /**
	         * The input content of the cell.
	         */
	        get: function () {
	            return this._source;
	        },
	        set: function (newValue) {
	            if (this._source === newValue) {
	                return;
	            }
	            var oldValue = this._source;
	            this._source = newValue;
	            this.contentChanged.emit(void 0);
	            this.stateChanged.emit({ name: 'source', oldValue: oldValue, newValue: newValue });
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CellModel.prototype, "isDisposed", {
	        /**
	         * Get whether the model is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._metadata === null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources held by the model.
	     */
	    CellModel.prototype.dispose = function () {
	        // Do nothing if already disposed.
	        if (this.isDisposed) {
	            return;
	        }
	        phosphor_signaling_1.clearSignalData(this);
	        for (var key in this._cursors) {
	            this._cursors[key].dispose();
	        }
	        this._cursors = null;
	        this._metadata = null;
	    };
	    /**
	     * Serialize the model to JSON.
	     */
	    CellModel.prototype.toJSON = function () {
	        return {
	            cell_type: this.type,
	            source: this.source,
	            metadata: utils.copy(this._metadata)
	        };
	    };
	    /**
	     * Get a metadata cursor for the cell.
	     *
	     * #### Notes
	     * Metadata associated with the nbformat spec are set directly
	     * on the model.  This method is used to interact with a namespaced
	     * set of metadata on the cell.
	     */
	    CellModel.prototype.getMetadata = function (name) {
	        var _this = this;
	        if (this.isDisposed) {
	            return null;
	        }
	        if (name in this._cursors) {
	            return this._cursors[name];
	        }
	        var cursor = new metadata_1.MetadataCursor(name, function () {
	            return _this._metadata[name];
	        }, function (value) {
	            _this.setCursorData(name, value);
	        });
	        this._cursors[name] = cursor;
	        return cursor;
	    };
	    /**
	     * List the metadata namespace keys for the notebook.
	     *
	     * #### Notes
	     * Metadata associated with the nbformat are not included.
	     */
	    CellModel.prototype.listMetadata = function () {
	        return Object.keys(this._metadata);
	    };
	    /**
	     * Set the cursor data for a given field.
	     */
	    CellModel.prototype.setCursorData = function (name, newValue) {
	        var oldValue = this._metadata[name];
	        if (json_1.deepEqual(oldValue, newValue)) {
	            return;
	        }
	        this._metadata[name] = newValue;
	        this.contentChanged.emit(void 0);
	        this.metadataChanged.emit({ name: name, oldValue: oldValue, newValue: newValue });
	    };
	    return CellModel;
	}());
	exports.CellModel = CellModel;
	/**
	 * An implementation of a raw cell model.
	 */
	var RawCellModel = (function (_super) {
	    __extends(RawCellModel, _super);
	    function RawCellModel() {
	        _super.apply(this, arguments);
	    }
	    Object.defineProperty(RawCellModel.prototype, "type", {
	        /**
	         * The type of the cell.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return 'raw';
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return RawCellModel;
	}(CellModel));
	exports.RawCellModel = RawCellModel;
	/**
	 * An implementation of a markdown cell model.
	 */
	var MarkdownCellModel = (function (_super) {
	    __extends(MarkdownCellModel, _super);
	    function MarkdownCellModel() {
	        _super.apply(this, arguments);
	    }
	    Object.defineProperty(MarkdownCellModel.prototype, "type", {
	        /**
	         * The type of the cell.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return 'markdown';
	        },
	        enumerable: true,
	        configurable: true
	    });
	    return MarkdownCellModel;
	}(CellModel));
	exports.MarkdownCellModel = MarkdownCellModel;
	/**
	 * An implementation of a code cell Model.
	 */
	var CodeCellModel = (function (_super) {
	    __extends(CodeCellModel, _super);
	    /**
	     * Construct a new code cell with optional original cell content.
	     */
	    function CodeCellModel(cell) {
	        var _this = this;
	        _super.call(this, cell);
	        this._outputs = null;
	        this._executionCount = null;
	        this._outputs = new output_area_1.OutputAreaModel();
	        if (cell && cell.cell_type === 'code') {
	            this.executionCount = cell.execution_count;
	            for (var _i = 0, _a = cell.outputs; _i < _a.length; _i++) {
	                var output = _a[_i];
	                this._outputs.add(output);
	            }
	        }
	        this._outputs.changed.connect(function () {
	            _this.contentChanged.emit(void 0);
	        });
	    }
	    Object.defineProperty(CodeCellModel.prototype, "type", {
	        /**
	         * The type of the cell.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return 'code';
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CodeCellModel.prototype, "executionCount", {
	        /**
	         * The execution count of the cell.
	         */
	        get: function () {
	            return this._executionCount;
	        },
	        set: function (newValue) {
	            if (newValue === this._executionCount) {
	                return;
	            }
	            var oldValue = this.executionCount;
	            this._executionCount = newValue;
	            this.contentChanged.emit(void 0);
	            this.stateChanged.emit({ name: 'executionCount', oldValue: oldValue, newValue: newValue });
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(CodeCellModel.prototype, "outputs", {
	        /**
	         * The cell outputs.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._outputs;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources held by the model.
	     */
	    CodeCellModel.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._outputs.clear(false);
	        this._outputs = null;
	        _super.prototype.dispose.call(this);
	    };
	    /**
	     * Serialize the model to JSON.
	     */
	    CodeCellModel.prototype.toJSON = function () {
	        var cell = _super.prototype.toJSON.call(this);
	        cell.execution_count = this.executionCount;
	        var outputs = this.outputs;
	        cell.outputs = [];
	        for (var i = 0; i < outputs.length; i++) {
	            cell.outputs.push(outputs.get(i));
	        }
	        return cell;
	    };
	    return CodeCellModel;
	}(CellModel));
	exports.CodeCellModel = CodeCellModel;
	/**
	 * A namespace for cell private data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A signal emitted when the state of the model changes.
	     */
	    Private.contentChangedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted when a model state changes.
	     */
	    Private.stateChangedSignal = new phosphor_signaling_1.Signal();
	    /**
	     * A signal emitted when a metadata field changes.
	     */
	    Private.metadataChangedSignal = new phosphor_signaling_1.Signal();
	})(Private || (Private = {}));


/***/ },
/* 145 */
/***/ function(module, exports) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	/**
	 * Test whether a JSON value is a primitive.
	 *
	 * @param value - The JSON value of interest.
	 *
	 * @returns `true` if the value is a primitive or `null`,
	 *   `false` otherwise.
	 */
	function isPrimitive(value) {
	    return (value === null ||
	        typeof value === 'boolean' ||
	        typeof value === 'number' ||
	        typeof value === 'string');
	}
	exports.isPrimitive = isPrimitive;
	/**
	 * Test whether a JSON value is an array.
	 *
	 * @param value - The JSON value of interest.
	 *
	 * @returns `true` if the value is a an array, `false` otherwise.
	 */
	function isArray(value) {
	    return Array.isArray(value);
	}
	exports.isArray = isArray;
	/**
	 * Test whether a JSON value is an object.
	 *
	 * @param value - The JSON value of interest.
	 *
	 * @returns `true` if the value is a an object, `false` otherwise.
	 */
	function isObject(value) {
	    return !isPrimitive(value) && !isArray(value);
	}
	exports.isObject = isObject;
	/**
	 * Compare two JSON values for deep equality.
	 *
	 * @param first - The first JSON value of interest.
	 *
	 * @param second - The second JSON value of interest.
	 *
	 * @returns `true` if the values are equivalent, `false` otherwise.
	 */
	function deepEqual(first, second) {
	    // Check referential and primitive equality first.
	    if (first === second) {
	        return true;
	    }
	    // If one is a primitive, the `===` check ruled out the other.
	    if (isPrimitive(first) || isPrimitive(second)) {
	        return false;
	    }
	    // Bail if either is `undefined`.
	    if (!first || !second) {
	        return false;
	    }
	    // Test whether they are arrays.
	    var a1 = isArray(first);
	    var a2 = isArray(second);
	    // Bail if the types are different.
	    if (a1 !== a2) {
	        return false;
	    }
	    // If they are both arrays, compare them.
	    if (a1 && a2) {
	        return Private.arrayEqual(first, second);
	    }
	    // At this point, they must both be objects.
	    return Private.objectEqual(first, second);
	}
	exports.deepEqual = deepEqual;
	/**
	 * The namespace for the private module data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * Compare two JSON arrays for deep equality.
	     */
	    function arrayEqual(first, second) {
	        // Test the arrays for equal length.
	        if (first.length !== second.length) {
	            return false;
	        }
	        // Compare the values for equality.
	        for (var i = 0, n = first.length; i < n; ++i) {
	            if (!deepEqual(first[i], second[i])) {
	                return false;
	            }
	        }
	        // At this point, the arrays are equal.
	        return true;
	    }
	    Private.arrayEqual = arrayEqual;
	    /**
	     * Compare two JSON objects for deep equality.
	     */
	    function objectEqual(first, second) {
	        // Get the keys for each object.
	        var k1 = Object.keys(first);
	        var k2 = Object.keys(second);
	        // Test the keys for equal length.
	        if (k1.length !== k2.length) {
	            return false;
	        }
	        // Sort the keys for equivalent order.
	        k1.sort();
	        k2.sort();
	        // Compare the keys for equality.
	        for (var i = 0, n = k1.length; i < n; ++i) {
	            if (k1[i] !== k2[i]) {
	                return false;
	            }
	        }
	        // Compare the values for equality.
	        for (var i = 0, n = k1.length; i < n; ++i) {
	            if (!deepEqual(first[k1[i]], second[k1[i]])) {
	                return false;
	            }
	        }
	        // At this point, the objects are equal.
	        return true;
	    }
	    Private.objectEqual = objectEqual;
	})(Private || (Private = {}));


/***/ },
/* 146 */
/***/ function(module, exports) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	/**
	 * An implementation of a metadata cursor.
	 */
	var MetadataCursor = (function () {
	    /**
	     * Construct a new metadata cursor.
	     *
	     * @param name - The metadata namespace key.
	     *
	     * @param read - The read callback.
	     *
	     * @param write - The write callback.
	     */
	    function MetadataCursor(name, read, write) {
	        this._name = '';
	        this._read = null;
	        this._write = null;
	        this._name = name;
	        this._read = read;
	        this._write = write;
	    }
	    Object.defineProperty(MetadataCursor.prototype, "name", {
	        /**
	         * Get the namespace key of the metadata.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._name;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources used by the cursor.
	     *
	     * #### Notes
	     * This is not meant to be called by user code.
	     */
	    MetadataCursor.prototype.dispose = function () {
	        this._read = null;
	        this._write = null;
	    };
	    /**
	     * Get the value of the namespace data.
	     */
	    MetadataCursor.prototype.getValue = function () {
	        var read = this._read;
	        return read();
	    };
	    /**
	     * Set the value of the namespace data.
	     */
	    MetadataCursor.prototype.setValue = function (value) {
	        var write = this._write;
	        write(value);
	    };
	    return MetadataCursor;
	}());
	exports.MetadataCursor = MetadataCursor;


/***/ },
/* 147 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	function __export(m) {
	    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
	}
	__export(__webpack_require__(148));
	__export(__webpack_require__(151));


/***/ },
/* 148 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var phosphor_observablelist_1 = __webpack_require__(149);
	var phosphor_signaling_1 = __webpack_require__(22);
	var nbformat_1 = __webpack_require__(150);
	/**
	 * An model that maintains a list of output data.
	 */
	var OutputAreaModel = (function () {
	    /**
	     * Construct a new observable outputs instance.
	     */
	    function OutputAreaModel() {
	        this._clearNext = false;
	        this._list = null;
	        this._list = new phosphor_observablelist_1.ObservableList();
	        this._list.changed.connect(this._onListChanged, this);
	    }
	    Object.defineProperty(OutputAreaModel.prototype, "changed", {
	        /**
	         * A signal emitted when the model changes.
	         */
	        get: function () {
	            return Private.changedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(OutputAreaModel.prototype, "length", {
	        /**
	         * Get the length of the items in the model.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._list ? this._list.length : 0;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(OutputAreaModel.prototype, "isDisposed", {
	        /**
	         * Test whether the model is disposed.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._list === null;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources used by the model.
	     */
	    OutputAreaModel.prototype.dispose = function () {
	        if (this.isDisposed) {
	            return;
	        }
	        this._list.clear();
	        this._list = null;
	        phosphor_signaling_1.clearSignalData(this);
	    };
	    /**
	     * Get an item at the specified index.
	     */
	    OutputAreaModel.prototype.get = function (index) {
	        return this._list.get(index);
	    };
	    /**
	     * Add an output, which may be combined with previous output.
	     *
	     * #### Notes
	     * The output bundle is copied.
	     * Contiguous stream outputs of the same `name` are combined.
	     */
	    OutputAreaModel.prototype.add = function (output) {
	        // If we received a delayed clear message, then clear now.
	        if (this._clearNext) {
	            this.clear();
	            this._clearNext = false;
	        }
	        // Make a copy of the output bundle.
	        output = JSON.parse(JSON.stringify(output));
	        // Join multiline text outputs.
	        if (nbformat_1.nbformat.isStream(output)) {
	            if (Array.isArray(output.text)) {
	                output.text = output.text.join('\n');
	            }
	        }
	        // Consolidate outputs if they are stream outputs of the same kind.
	        var index = this.length - 1;
	        var lastOutput = this.get(index);
	        if (nbformat_1.nbformat.isStream(output)
	            && lastOutput && nbformat_1.nbformat.isStream(lastOutput)
	            && output.name === lastOutput.name) {
	            // In order to get a list change event, we add the previous
	            // text to the current item and replace the previous item.
	            // This also replaces the metadata of the last item.
	            var text = output.text;
	            output.text = lastOutput.text + text;
	            this._list.set(index, output);
	            return index;
	        }
	        else {
	            switch (output.output_type) {
	                case 'stream':
	                case 'execute_result':
	                case 'display_data':
	                case 'error':
	                    return this._list.add(output);
	                default:
	                    break;
	            }
	        }
	        return -1;
	    };
	    /**
	     * Clear all of the output.
	     *
	     * @param wait Delay clearing the output until the next message is added.
	     */
	    OutputAreaModel.prototype.clear = function (wait) {
	        if (wait === void 0) { wait = false; }
	        if (wait) {
	            this._clearNext = true;
	            return [];
	        }
	        return this._list.clear();
	    };
	    /**
	     * Execute code on a kernel and send outputs to the model.
	     */
	    OutputAreaModel.prototype.execute = function (code, kernel) {
	        var _this = this;
	        // Override the default for `stop_on_error`.
	        var content = {
	            code: code,
	            stop_on_error: true
	        };
	        this.clear();
	        return new Promise(function (resolve, reject) {
	            var future = kernel.execute(content);
	            future.onIOPub = (function (msg) {
	                var msgType = msg.header.msg_type;
	                switch (msgType) {
	                    case 'execute_result':
	                    case 'display_data':
	                    case 'stream':
	                    case 'error':
	                        var model = msg.content;
	                        model.output_type = msgType;
	                        _this.add(model);
	                        break;
	                    default:
	                        break;
	                }
	            });
	            future.onReply = function (msg) {
	                resolve(msg);
	            };
	        });
	    };
	    /**
	     * Handle a change to the list.
	     */
	    OutputAreaModel.prototype._onListChanged = function (sender, args) {
	        this.changed.emit(args);
	    };
	    return OutputAreaModel;
	}());
	exports.OutputAreaModel = OutputAreaModel;
	/**
	 * A namespace for private data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A signal emitted when the model changes.
	     */
	    Private.changedSignal = new phosphor_signaling_1.Signal();
	})(Private || (Private = {}));


/***/ },
/* 149 */
/***/ function(module, exports, __webpack_require__) {

	/*-----------------------------------------------------------------------------
	| Copyright (c) 2014-2015, PhosphorJS Contributors
	|
	| Distributed under the terms of the BSD 3-Clause License.
	|
	| The full license is in the file LICENSE, distributed with this software.
	|----------------------------------------------------------------------------*/
	'use strict';
	var arrays = __webpack_require__(3);
	var phosphor_signaling_1 = __webpack_require__(22);
	/**
	 * An enum of the change types which occur on an observable list.
	 */
	(function (ListChangeType) {
	    /**
	     * An item was added to the list.
	     */
	    ListChangeType[ListChangeType["Add"] = 0] = "Add";
	    /**
	     * An item was moved in the list.
	     */
	    ListChangeType[ListChangeType["Move"] = 1] = "Move";
	    /**
	     * An item was removed from the list.
	     */
	    ListChangeType[ListChangeType["Remove"] = 2] = "Remove";
	    /**
	     * Items were replaced in the list.
	     */
	    ListChangeType[ListChangeType["Replace"] = 3] = "Replace";
	    /**
	     * An item was set in the list.
	     */
	    ListChangeType[ListChangeType["Set"] = 4] = "Set";
	})(exports.ListChangeType || (exports.ListChangeType = {}));
	var ListChangeType = exports.ListChangeType;
	/**
	 * A concrete implementation of [[IObservableList]].
	 */
	var ObservableList = (function () {
	    /**
	     * Construct a new observable list.
	     *
	     * @param items - The initial items for the list.
	     */
	    function ObservableList(items) {
	        this.internal = items ? items.slice() : [];
	    }
	    Object.defineProperty(ObservableList.prototype, "changed", {
	        /**
	         * A signal emitted when the list has changed.
	         *
	         * #### Notes
	         * This is a pure delegate to the [[changedSignal]].
	         */
	        get: function () {
	            return ObservableList.changedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(ObservableList.prototype, "length", {
	        /**
	         * The number of items in the list.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this.internal.length;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Get the item at a specific index in the list.
	     *
	     * @param index - The index of the item of interest. If this is
	     *   negative, it is offset from the end of the list.
	     *
	     * @returns The item at the specified index, or `undefined` if the
	     *   index is out of range.
	     */
	    ObservableList.prototype.get = function (index) {
	        return this.internal[this._norm(index)];
	    };
	    /**
	     * Test whether the list contains a specific item.
	     *
	     * @param item - The item of interest.
	     *
	     * @returns `true` if the list contains the item, `false` otherwise.
	     */
	    ObservableList.prototype.contains = function (item) {
	        return this.internal.indexOf(item) !== -1;
	    };
	    /**
	     * Get the index of the first occurence of an item in the list.
	     *
	     * @param item - The item of interest.
	     *
	     * @returns The index of the specified item or `-1` if the item is
	     *   not contained in the list.
	     */
	    ObservableList.prototype.indexOf = function (item) {
	        return this.internal.indexOf(item);
	    };
	    /**
	     * Get a shallow copy of a portion of the list.
	     *
	     * @param start - The start index of the slice, inclusive. If this is
	     *   negative, it is offset from the end of the list. If this is not
	     *   provided, it defaults to `0`. In all cases, it is clamped to the
	     *   bounds of the list.
	     *
	     * @param end - The end index of the slice, exclusive. If this is
	     *   negative, it is offset from the end of the list. If this is not
	     *   provided, it defaults to `length`. In all cases, it is clamped
	     *   to the bounds of the list.
	     *
	     * @returns A new array containing the specified range of items.
	     */
	    ObservableList.prototype.slice = function (start, end) {
	        return this.internal.slice(start, end);
	    };
	    /**
	     * Set the item at a specific index.
	     *
	     * @param index - The index of interest. If this is negative, it is
	     *   offset from the end of the list.
	     *
	     * @param item - The item to set at the index.
	     *
	     * @returns The item which occupied the index, or `undefined` if the
	     *   index is out of range.
	     */
	    ObservableList.prototype.set = function (index, item) {
	        var i = this._norm(index);
	        if (!this._check(i))
	            return void 0;
	        return this.setItem(i, item);
	    };
	    /**
	     * Replace the contents of the list with the specified items.
	     *
	     * @param items - The items to assign to the list.
	     *
	     * @returns An array of the previous list items.
	     *
	     * #### Notes
	     * This is equivalent to `list.replace(0, list.length, items)`.
	     */
	    ObservableList.prototype.assign = function (items) {
	        return this.replaceItems(0, this.internal.length, items);
	    };
	    /**
	     * Add an item to the end of the list.
	     *
	     * @param item - The item to add to the list.
	     *
	     * @returns The index at which the item was added.
	     */
	    ObservableList.prototype.add = function (item) {
	        return this.addItem(this.internal.length, item);
	    };
	    /**
	     * Insert an item into the list at a specific index.
	     *
	     * @param index - The index at which to insert the item. If this is
	     *   negative, it is offset from the end of the list. In all cases,
	     *   it is clamped to the bounds of the list.
	     *
	     * @param item - The item to insert into the list.
	     *
	     * @returns The index at which the item was inserted.
	     */
	    ObservableList.prototype.insert = function (index, item) {
	        return this.addItem(this._clamp(index), item);
	    };
	    /**
	     * Move an item from one index to another.
	     *
	     * @param fromIndex - The index of the item of interest. If this is
	     *   negative, it is offset from the end of the list.
	     *
	     * @param toIndex - The desired index for the item. If this is
	     *   negative, it is offset from the end of the list.
	     *
	     * @returns `true` if the item was moved, `false` otherwise.
	     */
	    ObservableList.prototype.move = function (fromIndex, toIndex) {
	        var i = this._norm(fromIndex);
	        if (!this._check(i))
	            return false;
	        var j = this._norm(toIndex);
	        if (!this._check(j))
	            return false;
	        return this.moveItem(i, j);
	    };
	    /**
	     * Remove the first occurrence of a specific item from the list.
	     *
	     * @param item - The item to remove from the list.
	     *
	     * @return The index occupied by the item, or `-1` if the item is
	     *   not contained in the list.
	     */
	    ObservableList.prototype.remove = function (item) {
	        var i = this.internal.indexOf(item);
	        if (i !== -1)
	            this.removeItem(i);
	        return i;
	    };
	    /**
	     * Remove the item at a specific index.
	     *
	     * @param index - The index of the item of interest. If this is
	     *   negative, it is offset from the end of the list.
	     *
	     * @returns The item at the specified index, or `undefined` if the
	     *   index is out of range.
	     */
	    ObservableList.prototype.removeAt = function (index) {
	        var i = this._norm(index);
	        if (!this._check(i))
	            return void 0;
	        return this.removeItem(i);
	    };
	    /**
	     * Replace items at a specific location in the list.
	     *
	     * @param index - The index at which to modify the list. If this is
	     *   negative, it is offset from the end of the list. In all cases,
	     *   it is clamped to the bounds of the list.
	     *
	     * @param count - The number of items to remove at the given index.
	     *   This is clamped to the length of the list.
	     *
	     * @param items - The items to insert at the specified index.
	     *
	     * @returns An array of the items removed from the list.
	     */
	    ObservableList.prototype.replace = function (index, count, items) {
	        return this.replaceItems(this._norm(index), this._limit(count), items);
	    };
	    /**
	     * Remove all items from the list.
	     *
	     * @returns An array of the items removed from the list.
	     *
	     * #### Notes
	     * This is equivalent to `list.replace(0, list.length, [])`.
	     */
	    ObservableList.prototype.clear = function () {
	        return this.replaceItems(0, this.internal.length, []);
	    };
	    /**
	     * Add an item to the list at the specified index.
	     *
	     * @param index - The index at which to add the item. This must be
	     *   an integer in the range `[0, internal.length]`.
	     *
	     * @param item - The item to add at the specified index.
	     *
	     * @returns The index at which the item was added.
	     *
	     * #### Notes
	     * This may be reimplemented by subclasses to customize the behavior.
	     */
	    ObservableList.prototype.addItem = function (index, item) {
	        var i = arrays.insert(this.internal, index, item);
	        this.changed.emit({
	            type: ListChangeType.Add,
	            newIndex: i,
	            newValue: item,
	            oldIndex: -1,
	            oldValue: void 0,
	        });
	        return i;
	    };
	    /**
	     * Move an item in the list from one index to another.
	     *
	     * @param fromIndex - The initial index of the item. This must be
	     *   an integer in the range `[0, internal.length)`.
	     *
	     * @param toIndex - The desired index for the item. This must be
	     *   an integer in the range `[0, internal.length)`.
	     *
	     * @returns `true` if the item was moved, `false` otherwise.
	     *
	     * #### Notes
	     * This may be reimplemented by subclasses to customize the behavior.
	     */
	    ObservableList.prototype.moveItem = function (fromIndex, toIndex) {
	        if (!arrays.move(this.internal, fromIndex, toIndex)) {
	            return false;
	        }
	        var item = this.internal[toIndex];
	        this.changed.emit({
	            type: ListChangeType.Move,
	            newIndex: toIndex,
	            newValue: item,
	            oldIndex: fromIndex,
	            oldValue: item,
	        });
	        return true;
	    };
	    /**
	     * Remove the item from the list at the specified index.
	     *
	     * @param index - The index of the item to remove. This must be
	     *   an integer in the range `[0, internal.length)`.
	     *
	     * @returns The item removed from the list.
	     *
	     * #### Notes
	     * This may be reimplemented by subclasses to customize the behavior.
	     */
	    ObservableList.prototype.removeItem = function (index) {
	        var item = arrays.removeAt(this.internal, index);
	        this.changed.emit({
	            type: ListChangeType.Remove,
	            newIndex: -1,
	            newValue: void 0,
	            oldIndex: index,
	            oldValue: item,
	        });
	        return item;
	    };
	    /**
	     * Replace items at a specific location in the list.
	     *
	     * @param index - The index at which to modify the list. This must
	     *   be an integer in the range `[0, internal.length]`.
	     *
	     * @param count - The number of items to remove from the list. This
	     *   must be an integer in the range `[0, internal.length]`.
	     *
	     * @param items - The items to insert at the specified index.
	     *
	     * @returns An array of the items removed from the list.
	     *
	     * #### Notes
	     * This may be reimplemented by subclasses to customize the behavior.
	     */
	    ObservableList.prototype.replaceItems = function (index, count, items) {
	        var old = (_a = this.internal).splice.apply(_a, [index, count].concat(items));
	        this.changed.emit({
	            type: ListChangeType.Replace,
	            newIndex: index,
	            newValue: items,
	            oldIndex: index,
	            oldValue: old,
	        });
	        return old;
	        var _a;
	    };
	    /**
	     * Set the item at a specific index in the list.
	     *
	     * @param index - The index of interest. This must be an integer in
	     *   the range `[0, internal.length)`.
	     *
	     * @param item - The item to set at the index.
	     *
	     * @returns The item which previously occupied the specified index.
	     *
	     * #### Notes
	     * This may be reimplemented by subclasses to customize the behavior.
	     */
	    ObservableList.prototype.setItem = function (index, item) {
	        var old = this.internal[index];
	        this.internal[index] = item;
	        this.changed.emit({
	            type: ListChangeType.Set,
	            newIndex: index,
	            newValue: item,
	            oldIndex: index,
	            oldValue: old,
	        });
	        return old;
	    };
	    /**
	     * Normalize an index and offset negative values from the list end.
	     */
	    ObservableList.prototype._norm = function (i) {
	        return i < 0 ? Math.floor(i) + this.internal.length : Math.floor(i);
	    };
	    /**
	     * Check whether a normalized index is in range.
	     */
	    ObservableList.prototype._check = function (i) {
	        return i >= 0 && i < this.internal.length;
	    };
	    /**
	     * Normalize and clamp an index to the list bounds.
	     */
	    ObservableList.prototype._clamp = function (i) {
	        return Math.max(0, Math.min(this._norm(i), this.internal.length));
	    };
	    /**
	     * Normalize and limit a count to the length of the list.
	     */
	    ObservableList.prototype._limit = function (c) {
	        return Math.max(0, Math.min(Math.floor(c), this.internal.length));
	    };
	    /**
	     * A signal emitted when the list has changed.
	     *
	     * **See also:** [[changed]]
	     */
	    ObservableList.changedSignal = new phosphor_signaling_1.Signal();
	    return ObservableList;
	})();
	exports.ObservableList = ObservableList;
	//# sourceMappingURL=index.js.map

/***/ },
/* 150 */
/***/ function(module, exports) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	/**
	 * A namespace for nbformat interfaces.
	 */
	var nbformat;
	(function (nbformat) {
	    /**
	     * The major version of the notebook format.
	     */
	    nbformat.MAJOR_VERSION = 4;
	    /**
	     * The minor version of the notebook format.
	     */
	    nbformat.MINOR_VERSION = 0;
	    /**
	     * Check if cell is of markdown type.
	     */
	    function isMarkdownCell(d) {
	        return d.cell_type === 'markdown';
	    }
	    nbformat.isMarkdownCell = isMarkdownCell;
	    /**
	     * Check if cell is of code type.
	     */
	    function isCodeCell(d) {
	        return d.cell_type === 'code';
	    }
	    nbformat.isCodeCell = isCodeCell;
	    /**
	     * Check if cell is of raw type.
	     */
	    function isRawCell(d) {
	        return d.cell_type === 'raw';
	    }
	    nbformat.isRawCell = isRawCell;
	    /**
	     * Check if output is an `execute_result`.
	     */
	    function isExecuteResult(d) {
	        return d.output_type === 'execute_result';
	    }
	    nbformat.isExecuteResult = isExecuteResult;
	    /**
	     * Check if output is a `display_data`.
	     */
	    function isDisplayData(d) {
	        return d.output_type === 'display_data';
	    }
	    nbformat.isDisplayData = isDisplayData;
	    /**
	     * Check if output is `stream`.
	     */
	    function isStream(d) {
	        return d.output_type === 'stream';
	    }
	    nbformat.isStream = isStream;
	    /**
	     * Check if output is `error`.
	     */
	    function isError(d) {
	        return d.output_type === 'error';
	    }
	    nbformat.isError = isError;
	})(nbformat = exports.nbformat || (exports.nbformat = {}));


/***/ },
/* 151 */
/***/ function(module, exports, __webpack_require__) {

	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	"use strict";
	var __extends = (this && this.__extends) || function (d, b) {
	    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	    function __() { this.constructor = d; }
	    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
	};
	var phosphor_observablelist_1 = __webpack_require__(149);
	var phosphor_panel_1 = __webpack_require__(18);
	var phosphor_signaling_1 = __webpack_require__(22);
	var phosphor_widget_1 = __webpack_require__(20);
	var sanitizer_1 = __webpack_require__(152);
	/**
	 * The class name added to an output area widget.
	 */
	var OUTPUT_AREA_CLASS = 'jp-OutputArea';
	/**
	 * The class name added to an output widget.
	 */
	var OUTPUT_CLASS = 'jp-Output';
	/**
	 * The class name added to an execute result.
	 */
	var EXECUTE_CLASS = 'jp-Output-executeResult';
	/**
	 * The class name added to display data.
	 */
	var DISPLAY_CLASS = 'jp-Output-displayData';
	/**
	 * The class name added to stdout data.
	 */
	var STDOUT_CLASS = 'jp-Output-stdout';
	/**
	 * The class name added to stderr data.
	 */
	var STDERR_CLASS = 'jp-Output-stderr';
	/**
	 * The class name added to error data.
	 */
	var ERROR_CLASS = 'jp-Output-error';
	/**
	 * The class name added to fixed height output areas.
	 */
	var FIXED_HEIGHT_CLASS = 'jp-mod-fixedHeight';
	/**
	 * The class name added to collaped output areas.
	 */
	var COLLAPSED_CLASS = 'jp-mod-collapsed';
	/**
	 * The class name added to output area prompts.
	 */
	var PROMPT_CLASS = 'jp-Output-prompt';
	/**
	 * The class name added to output area results.
	 */
	var RESULT_CLASS = 'jp-Output-result';
	/**
	 * A list of outputs considered safe.
	 */
	var safeOutputs = ['text/plain', 'image/png', 'image/jpeg',
	    'application/vnd.jupyter.console-text'];
	/**
	 * A list of outputs that are sanitizable.
	 */
	var sanitizable = ['text/svg', 'text/html', 'text/latex'];
	/**
	 * An output area widget.
	 *
	 * #### Notes
	 * The widget model must be set separately and can be changed
	 * at any time.  Consumers of the widget must account for a
	 * `null` model, and may want to listen to the `modelChanged`
	 * signal.
	 */
	var OutputAreaWidget = (function (_super) {
	    __extends(OutputAreaWidget, _super);
	    /**
	     * Construct an output area widget.
	     */
	    function OutputAreaWidget(options) {
	        _super.call(this);
	        this._trusted = false;
	        this._fixedHeight = false;
	        this._collapsed = false;
	        this._model = null;
	        this._rendermime = null;
	        this._renderer = null;
	        this.addClass(OUTPUT_AREA_CLASS);
	        this._rendermime = options.rendermime;
	        this._renderer = options.renderer || OutputAreaWidget.defaultRenderer;
	        this.layout = new phosphor_panel_1.PanelLayout();
	    }
	    Object.defineProperty(OutputAreaWidget.prototype, "modelChanged", {
	        /**
	         * A signal emitted when the widget's model changes.
	         */
	        get: function () {
	            return Private.modelChangedSignal.bind(this);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(OutputAreaWidget.prototype, "model", {
	        /**
	         * The model for the widget.
	         */
	        get: function () {
	            return this._model;
	        },
	        set: function (newValue) {
	            if (!newValue && !this._model || newValue === this._model) {
	                return;
	            }
	            var oldValue = this._model;
	            this._model = newValue;
	            // Trigger private, protected, and public updates.
	            this._onModelChanged(oldValue, newValue);
	            this.onModelChanged(oldValue, newValue);
	            this.modelChanged.emit(void 0);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(OutputAreaWidget.prototype, "rendermime", {
	        /**
	         * Get the rendermime instance used by the widget.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._rendermime;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(OutputAreaWidget.prototype, "renderer", {
	        /**
	         * Get the renderer used by the widget.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            return this._renderer;
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(OutputAreaWidget.prototype, "trusted", {
	        /**
	         * The trusted state of the widget.
	         */
	        get: function () {
	            return this._trusted;
	        },
	        set: function (value) {
	            if (this._trusted === value) {
	                return;
	            }
	            this._trusted = value;
	            // Trigger a update of the child widgets.
	            var layout = this.layout;
	            for (var i = 0; i < layout.childCount(); i++) {
	                this._updateChild(i);
	            }
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(OutputAreaWidget.prototype, "collapsed", {
	        /**
	         * The collapsed state of the widget.
	         */
	        get: function () {
	            return this._collapsed;
	        },
	        set: function (value) {
	            if (this._collapsed === value) {
	                return;
	            }
	            this._collapsed = value;
	            this.update();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(OutputAreaWidget.prototype, "fixedHeight", {
	        /**
	         * The fixed height state of the widget.
	         */
	        get: function () {
	            return this._fixedHeight;
	        },
	        set: function (value) {
	            if (this._fixedHeight === value) {
	                return;
	            }
	            this._fixedHeight = value;
	            this.update();
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources held by the widget.
	     */
	    OutputAreaWidget.prototype.dispose = function () {
	        // Do nothing if already disposed.
	        if (this.isDisposed) {
	            return;
	        }
	        this._model = null;
	        this._rendermime = null;
	        this._renderer = null;
	        _super.prototype.dispose.call(this);
	    };
	    /**
	     * Get the child widget at the specified index.
	     */
	    OutputAreaWidget.prototype.childAt = function (index) {
	        var layout = this.layout;
	        return layout.childAt(index);
	    };
	    /**
	     * Get the number of child widgets.
	     */
	    OutputAreaWidget.prototype.childCount = function () {
	        var layout = this.layout;
	        return layout.childCount();
	    };
	    /**
	     * Handle `update_request` messages.
	     */
	    OutputAreaWidget.prototype.onUpdateRequest = function (msg) {
	        if (this.collapsed) {
	            this.addClass(COLLAPSED_CLASS);
	        }
	        else {
	            this.removeClass(COLLAPSED_CLASS);
	        }
	        if (this.fixedHeight) {
	            this.addClass(FIXED_HEIGHT_CLASS);
	        }
	        else {
	            this.removeClass(FIXED_HEIGHT_CLASS);
	        }
	    };
	    /**
	     * Handle a new model.
	     *
	     * #### Notes
	     * This method is called after the model change has been handled
	     * internally and before the `modelChanged` signal is emitted.
	     * The default implementation is a no-op.
	     */
	    OutputAreaWidget.prototype.onModelChanged = function (oldValue, newValue) { };
	    /**
	     * Handle a change to the model.
	     */
	    OutputAreaWidget.prototype._onModelChanged = function (oldValue, newValue) {
	        var layout = this.layout;
	        if (oldValue) {
	            oldValue.changed.disconnect(this._onModelStateChanged, this);
	        }
	        newValue.changed.connect(this._onModelStateChanged, this);
	        var start = newValue ? newValue.length : 0;
	        // Clear unnecessary child widgets.
	        for (var i = start; i < layout.childCount(); i++) {
	            this._removeChild(i);
	        }
	        if (!newValue) {
	            return;
	        }
	        // Reuse existing child widgets.
	        for (var i = 0; i < layout.childCount(); i++) {
	            this._updateChild(i);
	        }
	        // Add new widgets as necessary.
	        for (var i = layout.childCount(); i < newValue.length; i++) {
	            this._addChild();
	        }
	    };
	    /**
	     * Add a child to the layout.
	     */
	    OutputAreaWidget.prototype._addChild = function () {
	        var widget = this._renderer.createOutput({ rendermime: this.rendermime });
	        var layout = this.layout;
	        layout.addChild(widget);
	        this._updateChild(layout.childCount() - 1);
	    };
	    /**
	     * Remove a child from the layout.
	     */
	    OutputAreaWidget.prototype._removeChild = function (index) {
	        var layout = this.layout;
	        layout.childAt(index).dispose();
	    };
	    /**
	     * Update a child in the layout.
	     */
	    OutputAreaWidget.prototype._updateChild = function (index) {
	        var layout = this.layout;
	        var widget = layout.childAt(index);
	        var output = this._model.get(index);
	        widget.render(output, this._trusted);
	    };
	    /**
	     * Follow changes on the model state.
	     */
	    OutputAreaWidget.prototype._onModelStateChanged = function (sender, args) {
	        switch (args.type) {
	            case phosphor_observablelist_1.ListChangeType.Add:
	                // Children are always added at the end.
	                this._addChild();
	                break;
	            case phosphor_observablelist_1.ListChangeType.Replace:
	                // Only "clear" is supported by the model.
	                var oldValues = args.oldValue;
	                for (var i = args.oldIndex; i < oldValues.length; i++) {
	                    this._removeChild(args.oldIndex);
	                }
	                break;
	            case phosphor_observablelist_1.ListChangeType.Set:
	                this._updateChild(args.newIndex);
	                break;
	            default:
	                break;
	        }
	        this.update();
	    };
	    return OutputAreaWidget;
	}(phosphor_widget_1.Widget));
	exports.OutputAreaWidget = OutputAreaWidget;
	/**
	 * A namespace for OutputAreaWidget statics.
	 */
	var OutputAreaWidget;
	(function (OutputAreaWidget) {
	    /**
	     * The default implementation of `IRenderer`.
	     */
	    var Renderer = (function () {
	        function Renderer() {
	        }
	        /**
	         * Create an output widget.
	         *
	         *
	         * @returns A new widget for an output.
	         */
	        Renderer.prototype.createOutput = function (options) {
	            return new OutputWidget(options);
	        };
	        return Renderer;
	    }());
	    OutputAreaWidget.Renderer = Renderer;
	    /**
	     * The default `Renderer` instance.
	     */
	    OutputAreaWidget.defaultRenderer = new Renderer();
	})(OutputAreaWidget = exports.OutputAreaWidget || (exports.OutputAreaWidget = {}));
	/**
	 * An output widget.
	 */
	var OutputWidget = (function (_super) {
	    __extends(OutputWidget, _super);
	    /**
	     * Construct a new output widget.
	     */
	    function OutputWidget(options) {
	        _super.call(this);
	        this._rendermime = null;
	        this._placeholder = null;
	        var layout = new phosphor_panel_1.PanelLayout();
	        this.layout = layout;
	        var prompt = new phosphor_widget_1.Widget();
	        this._placeholder = new phosphor_widget_1.Widget();
	        this.addClass(OUTPUT_CLASS);
	        prompt.addClass(PROMPT_CLASS);
	        this._placeholder.addClass(RESULT_CLASS);
	        layout.addChild(prompt);
	        layout.addChild(this._placeholder);
	        this._rendermime = options.rendermime;
	    }
	    Object.defineProperty(OutputWidget.prototype, "prompt", {
	        /**
	         * The prompt widget used by the output widget.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            var layout = this.layout;
	            return layout.childAt(0);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    Object.defineProperty(OutputWidget.prototype, "output", {
	        /**
	         * The rendered output used by the output widget.
	         *
	         * #### Notes
	         * This is a read-only property.
	         */
	        get: function () {
	            var layout = this.layout;
	            return layout.childAt(1);
	        },
	        enumerable: true,
	        configurable: true
	    });
	    /**
	     * Dispose of the resources held by the widget.
	     */
	    OutputWidget.prototype.dispose = function () {
	        this._rendermime = null;
	        this._placeholder = null;
	        _super.prototype.dispose.call(this);
	    };
	    /**
	     * Clear the widget contents.
	     */
	    OutputWidget.prototype.clear = function () {
	        this.setOutput(this._placeholder);
	        this.prompt.node.textContent = '';
	    };
	    /**
	     * Render an output.
	     *
	     * @param output - The kernel output message payload.
	     *
	     * @param trusted - Whether the output is trusted.
	     */
	    OutputWidget.prototype.render = function (output, trusted) {
	        // Extract the data from the output and sanitize if necessary.
	        var rendermime = this._rendermime;
	        var bundle = this.getBundle(output);
	        var data = this.convertBundle(bundle);
	        if (!trusted) {
	            this.sanitize(data);
	        }
	        // Clear the content.
	        this.clear();
	        // Bail if no data to display.
	        var msg = 'Did not find renderer for output mimebundle.';
	        if (!data) {
	            console.log(msg);
	            return;
	        }
	        // Create the output result area.
	        var child = rendermime.render(data);
	        if (!child) {
	            console.log(msg);
	            console.log(data);
	            return;
	        }
	        this.setOutput(child);
	        // Add classes and output prompt as necessary.
	        switch (output.output_type) {
	            case 'execute_result':
	                child.addClass(EXECUTE_CLASS);
	                var count = output.execution_count;
	                this.prompt.node.textContent = "Out[" + (count === null ? ' ' : count) + "]:";
	                break;
	            case 'display_data':
	                child.addClass(DISPLAY_CLASS);
	                break;
	            case 'stream':
	                if (output.name === 'stdout') {
	                    child.addClass(STDOUT_CLASS);
	                }
	                else {
	                    child.addClass(STDERR_CLASS);
	                }
	                break;
	            case 'error':
	                child.addClass(ERROR_CLASS);
	                break;
	            default:
	                console.error("Unrecognized output type: " + output.output_type);
	                data = {};
	        }
	    };
	    /**
	     * Set the widget output.
	     */
	    OutputWidget.prototype.setOutput = function (value) {
	        var layout = this.layout;
	        var old = this.output;
	        value = value || null;
	        if (old === value) {
	            return;
	        }
	        if (old) {
	            if (old !== this._placeholder) {
	                old.dispose();
	            }
	            else {
	                old.parent = null;
	            }
	        }
	        if (value) {
	            layout.addChild(value);
	            value.addClass(RESULT_CLASS);
	        }
	        else {
	            layout.addChild(this._placeholder);
	        }
	    };
	    /**
	     * Get the mime bundle for an output.
	     *
	     * @params output - A kernel output message payload.
	     *
	     * @returns - A mime bundle for the payload.
	     */
	    OutputWidget.prototype.getBundle = function (output) {
	        var bundle;
	        switch (output.output_type) {
	            case 'execute_result':
	                bundle = output.data;
	                break;
	            case 'display_data':
	                bundle = output.data;
	                break;
	            case 'stream':
	                bundle = {
	                    'application/vnd.jupyter.console-text': output.text
	                };
	                break;
	            case 'error':
	                var out = output;
	                var traceback = out.traceback.join('\n');
	                bundle = {
	                    'application/vnd.jupyter.console-text': traceback ||
	                        out.ename + ": " + out.evalue
	                };
	                break;
	            default:
	                console.error("Unrecognized output type: " + output.output_type);
	                bundle = {};
	        }
	        return bundle;
	    };
	    /**
	     * Convert a mime bundle to a mime map.
	     */
	    OutputWidget.prototype.convertBundle = function (bundle) {
	        var map = Object.create(null);
	        for (var mimeType in bundle) {
	            var value = bundle[mimeType];
	            if (Array.isArray(value)) {
	                map[mimeType] = value.join('\n');
	            }
	            else {
	                map[mimeType] = value;
	            }
	        }
	        return map;
	    };
	    /**
	     * Sanitize a mime map.
	     *
	     * @params map - The map to sanitize.
	     */
	    OutputWidget.prototype.sanitize = function (map) {
	        var keys = Object.keys(map);
	        for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
	            var key = keys_1[_i];
	            if (safeOutputs.indexOf(key) !== -1) {
	                continue;
	            }
	            else if (sanitizable.indexOf(key) !== -1) {
	                var out = map[key];
	                if (typeof out === 'string') {
	                    map[key] = sanitizer_1.defaultSanitizer.sanitize(out);
	                }
	                else {
	                    var message = 'Ignoring unsanitized ' + key +
	                        ' output; could not sanitize because output is not a string.';
	                    console.log(message);
	                    delete map[key];
	                }
	            }
	            else {
	                // Don't display if we don't know how to sanitize it.
	                console.log('Ignoring untrusted ' + key + ' output.');
	                delete map[key];
	            }
	        }
	    };
	    return OutputWidget;
	}(phosphor_widget_1.Widget));
	exports.OutputWidget = OutputWidget;
	/**
	 * A namespace for private data.
	 */
	var Private;
	(function (Private) {
	    /**
	     * A signal emitted when the widget's model changes.
	     */
	    Private.modelChangedSignal = new phosphor_signaling_1.Signal();
	})(Private || (Private = {}));


/***/ },
/* 152 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	// Copyright (c) Jupyter Development Team.
	// Distributed under the terms of the Modified BSD License.
	var sanitize = __webpack_require__(153);
	/**
	 * A class to sanitize HTML strings.
	 */
	var Sanitizer = (function () {
	    function Sanitizer() {
	        this._options = {
	            allowedTags: sanitize.defaults.allowedTags.concat('h1', 'h2', 'img'),
	            allowedAttributes: {
	                // Allow the "rel" attribute for <a> tags.
	                'a': sanitize.defaults.allowedAttributes['a'].concat('rel'),
	                // Allow the "src" attribute for <img> tags.
	                'img': ['src', 'height', 'width', 'alt']
	            },
	            transformTags: {
	                // Set the "rel" attribute for <a> tags to "nofollow".
	                'a': sanitize.simpleTransform('a', { 'rel': 'nofollow' })
	            }
	        };
	    }
	    /**
	     * Sanitize an HTML string.
	     */
	    Sanitizer.prototype.sanitize = function (dirty) {
	        return sanitize(dirty, this._options);
	    };
	    return Sanitizer;
	}());
	/**
	 * The default instance of an `ISanitizer` meant for use by user code.
	 */
	exports.defaultSanitizer = new Sanitizer();


/***/ },
/* 153 */
/***/ function(module, exports, __webpack_require__) {

	var htmlparser = __webpack_require__(154);
	var extend = __webpack_require__(205);
	var quoteRegexp = __webpack_require__(206);
	
	function each(obj, cb) {
	  if (obj) Object.keys(obj).forEach(function (key) {
	    cb(obj[key], key);
	  });
	}
	
	// Avoid false positives with .__proto__, .hasOwnProperty, etc.
	function has(obj, key) {
	  return ({}).hasOwnProperty.call(obj, key);
	}
	
	module.exports = sanitizeHtml;
	
	// Ignore the _recursing flag; it's there for recursive
	// invocation as a guard against this exploit:
	// https://github.com/fb55/htmlparser2/issues/105
	
	function sanitizeHtml(html, options, _recursing) {
	  var result = '';
	
	  function Frame(tag, attribs) {
	    var that = this;
	    this.tag = tag;
	    this.attribs = attribs || {};
	    this.tagPosition = result.length;
	    this.text = ''; // Node inner text
	
	    this.updateParentNodeText = function() {
	      if (stack.length) {
	          var parentFrame = stack[stack.length - 1];
	          parentFrame.text += that.text;
	      }
	    };
	  }
	
	  if (!options) {
	    options = sanitizeHtml.defaults;
	    options.parser = htmlParserDefaults;
	  } else {
	    options = extend(sanitizeHtml.defaults, options);
	    if (options.parser) {
	      options.parser = extend(htmlParserDefaults, options.parser);
	    } else {
	      options.parser = htmlParserDefaults;
	    }
	  }
	
	  // Tags that contain something other than HTML, or where discarding
	  // the text when the tag is disallowed makes sense for other reasons.
	  // If we are not allowing these tags, we should drop their content too.
	  // For other tags you would drop the tag but keep its content.
	  var nonTextTagsArray = options.nonTextTags || [ 'script', 'style', 'textarea' ];
	  var allowedAttributesMap;
	  var allowedAttributesGlobMap;
	  if(options.allowedAttributes) {
	    allowedAttributesMap = {};
	    allowedAttributesGlobMap = {};
	    each(options.allowedAttributes, function(attributes, tag) {
	      allowedAttributesMap[tag] = [];
	      var globRegex = [];
	      attributes.forEach(function(name) {
	        if(name.indexOf('*') >= 0) {
	          globRegex.push(quoteRegexp(name).replace(/\\\*/g, '.*'));
	        } else {
	          allowedAttributesMap[tag].push(name);
	        }
	      });
	      allowedAttributesGlobMap[tag] = new RegExp('^(' + globRegex.join('|') + ')$');
	    });
	  }
	  var allowedClassesMap = {};
	  each(options.allowedClasses, function(classes, tag) {
	    // Implicitly allows the class attribute
	    if(allowedAttributesMap) {
	      if (!has(allowedAttributesMap, tag)) {
	        allowedAttributesMap[tag] = [];
	      }
	      allowedAttributesMap[tag].push('class');
	    }
	
	    allowedClassesMap[tag] = classes;
	  });
	
	  var transformTagsMap = {};
	  var transformTagsAll;
	  each(options.transformTags, function(transform, tag) {
	    var transFun;
	    if (typeof transform === 'function') {
	      transFun = transform;
	    } else if (typeof transform === "string") {
	      transFun = sanitizeHtml.simpleTransform(transform);
	    }
	    if (tag === '*') {
	      transformTagsAll = transFun;
	    } else {
	      transformTagsMap[tag] = transFun;
	    }
	  });
	
	  var depth = 0;
	  var stack = [];
	  var skipMap = {};
	  var transformMap = {};
	  var skipText = false;
	  var skipTextDepth = 0;
	
	  var parser = new htmlparser.Parser({
	    onopentag: function(name, attribs) {
	      if (skipText) {
	        skipTextDepth++;
	        return;
	      }
	      var frame = new Frame(name, attribs);
	      stack.push(frame);
	
	      var skip = false;
	      var transformedTag;
	      if (has(transformTagsMap, name)) {
	        transformedTag = transformTagsMap[name](name, attribs);
	
	        frame.attribs = attribs = transformedTag.attribs;
	
	        if (transformedTag.text !== undefined) {
	          frame.innerText = transformedTag.text;
	        }
	
	        if (name !== transformedTag.tagName) {
	          frame.name = name = transformedTag.tagName;
	          transformMap[depth] = transformedTag.tagName;
	        }
	      }
	      if (transformTagsAll) {
	        transformedTag = transformTagsAll(name, attribs);
	
	        frame.attribs = attribs = transformedTag.attribs;
	        if (name !== transformedTag.tagName) {
	          frame.name = name = transformedTag.tagName;
	          transformMap[depth] = transformedTag.tagName;
	        }
	      }
	
	      if (options.allowedTags && options.allowedTags.indexOf(name) === -1) {
	        skip = true;
	        if (nonTextTagsArray.indexOf(name) !== -1) {
	          skipText = true;
	          skipTextDepth = 1;
	        }
	        skipMap[depth] = true;
	      }
	      depth++;
	      if (skip) {
	        // We want the contents but not this tag
	        return;
	      }
	      result += '<' + name;
	      if (!allowedAttributesMap || has(allowedAttributesMap, name) || allowedAttributesMap['*']) {
	        each(attribs, function(value, a) {
	          if (!allowedAttributesMap ||
	              (has(allowedAttributesMap, name) && allowedAttributesMap[name].indexOf(a) !== -1 ) ||
	              (allowedAttributesMap['*'] && allowedAttributesMap['*'].indexOf(a) !== -1 ) ||
	              (has(allowedAttributesGlobMap, name) && allowedAttributesGlobMap[name].test(a)) ||
	              (allowedAttributesGlobMap['*'] && allowedAttributesGlobMap['*'].test(a))) {
	            if ((a === 'href') || (a === 'src')) {
	              if (naughtyHref(name, value)) {
	                delete frame.attribs[a];
	                return;
	              }
	            }
	            if (a === 'class') {
	              value = filterClasses(value, allowedClassesMap[name]);
	              if (!value.length) {
	                delete frame.attribs[a];
	                return;
	              }
	            }
	            result += ' ' + a;
	            if (value.length) {
	              result += '="' + escapeHtml(value) + '"';
	            }
	          } else {
	            delete frame.attribs[a];
	          }
	        });
	      }
	      if (options.selfClosing.indexOf(name) !== -1) {
	        result += " />";
	      } else {
	        result += ">";
	      }
	    },
	    ontext: function(text) {
	      if (skipText) {
	        return;
	      }
	      var lastFrame = stack[stack.length-1];
	      var tag;
	
	      if (lastFrame) {
	        tag = lastFrame.tag;
	        // If inner text was set by transform function then let's use it
	        text = lastFrame.innerText !== undefined ? lastFrame.innerText : text;
	      }
	
	      if ((tag === 'script') || (tag === 'style')) {
	        // htmlparser2 gives us these as-is. Escaping them ruins the content. Allowing
	        // script tags is, by definition, game over for XSS protection, so if that's
	        // your concern, don't allow them. The same is essentially true for style tags
	        // which have their own collection of XSS vectors.
	        result += text;
	      } else {
	        var escaped = escapeHtml(text);
	        if (options.textFilter) {
	          result += options.textFilter(escaped);
	        } else {
	          result += escaped;
	        }
	      }
	      if (stack.length) {
	           var frame = stack[stack.length - 1];
	           frame.text += text;
	      }
	    },
	    onclosetag: function(name) {
	
	      if (skipText) {
	        skipTextDepth--;
	        if (!skipTextDepth) {
	          skipText = false;
	        } else {
	          return;
	        }
	      }
	
	      var frame = stack.pop();
	      if (!frame) {
	        // Do not crash on bad markup
	        return;
	      }
	      skipText = false;
	      depth--;
	      if (skipMap[depth]) {
	        delete skipMap[depth];
	        frame.updateParentNodeText();
	        return;
	      }
	
	      if (transformMap[depth]) {
	        name = transformMap[depth];
	        delete transformMap[depth];
	      }
	
	      if (options.exclusiveFilter && options.exclusiveFilter(frame)) {
	         result = result.substr(0, frame.tagPosition);
	         return;
	      }
	
	      frame.updateParentNodeText();
	
	      if (options.selfClosing.indexOf(name) !== -1) {
	         // Already output />
	         return;
	      }
	
	      result += "</" + name + ">";
	    }
	  }, options.parser);
	  parser.write(html);
	  parser.end();
	
	  return result;
	
	  function escapeHtml(s) {
	    if (typeof(s) !== 'string') {
	      s = s + '';
	    }
	    return s.replace(/\&/g, '&amp;').replace(/</g, '&lt;').replace(/\>/g, '&gt;').replace(/\"/g, '&quot;');
	  }
	
	  function naughtyHref(name, href) {
	    // Browsers ignore character codes of 32 (space) and below in a surprising
	    // number of situations. Start reading here:
	    // https://www.owasp.org/index.php/XSS_Filter_Evasion_Cheat_Sheet#Embedded_tab
	    href = href.replace(/[\x00-\x20]+/g, '');
	    // Clobber any comments in URLs, which the browser might
	    // interpret inside an XML data island, allowing
	    // a javascript: URL to be snuck through
	    href = href.replace(/<\!\-\-.*?\-\-\>/g, '');
	    // Case insensitive so we don't get faked out by JAVASCRIPT #1
	    var matches = href.match(/^([a-zA-Z]+)\:/);
	    if (!matches) {
	      // No scheme = no way to inject js (right?)
	      return false;
	    }
	    var scheme = matches[1].toLowerCase();
	
	    if (has(options.allowedSchemesByTag, name)) {
	      return options.allowedSchemesByTag[name].indexOf(scheme) === -1;
	    }
	
	    return !options.allowedSchemes || options.allowedSchemes.indexOf(scheme) === -1;
	  }
	
	  function filterClasses(classes, allowed) {
	    if (!allowed) {
	      // The class attribute is allowed without filtering on this tag
	      return classes;
	    }
	    classes = classes.split(/\s+/);
	    return classes.filter(function(clss) {
	      return allowed.indexOf(clss) !== -1;
	    }).join(' ');
	  }
	}
	
	// Defaults are accessible to you so that you can use them as a starting point
	// programmatically if you wish
	
	var htmlParserDefaults = {
	  decodeEntities: true
	};
	sanitizeHtml.defaults = {
	  allowedTags: [ 'h3', 'h4', 'h5', 'h6', 'blockquote', 'p', 'a', 'ul', 'ol',
	    'nl', 'li', 'b', 'i', 'strong', 'em', 'strike', 'code', 'hr', 'br', 'div',
	    'table', 'thead', 'caption', 'tbody', 'tr', 'th', 'td', 'pre' ],
	  allowedAttributes: {
	    a: [ 'href', 'name', 'target' ],
	    // We don't currently allow img itself by default, but this
	    // would make sense if we did
	    img: [ 'src' ]
	  },
	  // Lots of these won't come up by default because we don't allow them
	  selfClosing: [ 'img', 'br', 'hr', 'area', 'base', 'basefont', 'input', 'link', 'meta' ],
	  // URL schemes we permit
	  allowedSchemes: [ 'http', 'https', 'ftp', 'mailto' ],
	  allowedSchemesByTag: {}
	};
	
	sanitizeHtml.simpleTransform = function(newTagName, newAttribs, merge) {
	  merge = (merge === undefined) ? true : merge;
	  newAttribs = newAttribs || {};
	
	  return function(tagName, attribs) {
	    var attrib;
	    if (merge) {
	      for (attrib in newAttribs) {
	        attribs[attrib] = newAttribs[attrib];
	      }
	    } else {
	      attribs = newAttribs;
	    }
	
	    return {
	      tagName: newTagName,
	      attribs: attribs
	    };
	  };
	};


/***/ },
/* 154 */
/***/ function(module, exports, __webpack_require__) {

	var Parser = __webpack_require__(155),
	    DomHandler = __webpack_require__(164);
	
	function defineProp(name, value){
		delete module.exports[name];
		module.exports[name] = value;
		return value;
	}
	
	module.exports = {
		Parser: Parser,
		Tokenizer: __webpack_require__(156),
		ElementType: __webpack_require__(165),
		DomHandler: DomHandler,
		get FeedHandler(){
			return defineProp("FeedHandler", __webpack_require__(168));
		},
		get Stream(){
			return defineProp("Stream", __webpack_require__(169));
		},
		get WritableStream(){
			return defineProp("WritableStream", __webpack_require__(170));
		},
		get ProxyHandler(){
			return defineProp("ProxyHandler", __webpack_require__(191));
		},
		get DomUtils(){
			return defineProp("DomUtils", __webpack_require__(192));
		},
		get CollectingHandler(){
			return defineProp("CollectingHandler", __webpack_require__(204));
		},
		// For legacy support
		DefaultHandler: DomHandler,
		get RssHandler(){
			return defineProp("RssHandler", this.FeedHandler);
		},
		//helper methods
		parseDOM: function(data, options){
			var handler = new DomHandler(options);
			new Parser(handler, options).end(data);
			return handler.dom;
		},
		parseFeed: function(feed, options){
			var handler = new module.exports.FeedHandler(options);
			new Parser(handler, options).end(feed);
			return handler.dom;
		},
		createDomStream: function(cb, options, elementCb){
			var handler = new DomHandler(cb, options, elementCb);
			return new Parser(handler, options);
		},
		// List of all events that the parser emits
		EVENTS: { /* Format: eventname: number of arguments */
			attribute: 2,
			cdatastart: 0,
			cdataend: 0,
			text: 1,
			processinginstruction: 2,
			comment: 1,
			commentend: 0,
			closetag: 1,
			opentag: 2,
			opentagname: 1,
			error: 1,
			end: 0
		}
	};


/***/ },
/* 155 */
/***/ function(module, exports, __webpack_require__) {

	var Tokenizer = __webpack_require__(156);
	
	/*
		Options:
	
		xmlMode: Disables the special behavior for script/style tags (false by default)
		lowerCaseAttributeNames: call .toLowerCase for each attribute name (true if xmlMode is `false`)
		lowerCaseTags: call .toLowerCase for each tag name (true if xmlMode is `false`)
	*/
	
	/*
		Callbacks:
	
		oncdataend,
		oncdatastart,
		onclosetag,
		oncomment,
		oncommentend,
		onerror,
		onopentag,
		onprocessinginstruction,
		onreset,
		ontext
	*/
	
	var formTags = {
		input: true,
		option: true,
		optgroup: true,
		select: true,
		button: true,
		datalist: true,
		textarea: true
	};
	
	var openImpliesClose = {
		tr      : { tr:true, th:true, td:true },
		th      : { th:true },
		td      : { thead:true, th:true, td:true },
		body    : { head:true, link:true, script:true },
		li      : { li:true },
		p       : { p:true },
		h1      : { p:true },
		h2      : { p:true },
		h3      : { p:true },
		h4      : { p:true },
		h5      : { p:true },
		h6      : { p:true },
		select  : formTags,
		input   : formTags,
		output  : formTags,
		button  : formTags,
		datalist: formTags,
		textarea: formTags,
		option 