"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var widgets_1 = require("@phosphor/widgets");
var RenderedData = /** @class */ (function (_super) {
    __extends(RenderedData, _super);
    function RenderedData(options, view) {
        var _this = _super.call(this) || this;
        _this._load_mimetype = options.mimeType;
        _this.view = view;
        return _this;
    }
    RenderedData.prototype.renderModel = function (model) {
        var data = model.data[this._load_mimetype];
        var value = JSON.parse(JSON.stringify(data));
        this.view.renderResult(value);
        return Promise.resolve();
    };
    return RenderedData;
}(widgets_1.Widget));
exports.RenderedData = RenderedData;
function register_renderer(panel, dojoView) {
    var rendererFactory = {
        safe: true,
        mimeTypes: ['application/unittest.status+json'],
        createRenderer: function (options) { return new RenderedData(options, dojoView); }
    };
    panel.notebook.rendermime.addFactory(rendererFactory, 0);
}
exports.register_renderer = register_renderer;
